import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::GuardDuty::Detector`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html
 */
export interface CfnDetectorProps {
    /**
     * `AWS::GuardDuty::Detector.Enable`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html#cfn-guardduty-detector-enable
     */
    readonly enable: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::Detector.DataSources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html#cfn-guardduty-detector-datasources
     */
    readonly dataSources?: CfnDetector.CFNDataSourceConfigurationsProperty | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::Detector.FindingPublishingFrequency`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html#cfn-guardduty-detector-findingpublishingfrequency
     */
    readonly findingPublishingFrequency?: string;
}
/**
 * A CloudFormation `AWS::GuardDuty::Detector`
 *
 * @cloudformationResource AWS::GuardDuty::Detector
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html
 */
export declare class CfnDetector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GuardDuty::Detector";
    /**
     * `AWS::GuardDuty::Detector.Enable`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html#cfn-guardduty-detector-enable
     */
    enable: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::Detector.DataSources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html#cfn-guardduty-detector-datasources
     */
    dataSources: CfnDetector.CFNDataSourceConfigurationsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GuardDuty::Detector.FindingPublishingFrequency`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html#cfn-guardduty-detector-findingpublishingfrequency
     */
    findingPublishingFrequency: string | undefined;
    /**
     * Create a new `AWS::GuardDuty::Detector`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDetectorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDetector {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfndatasourceconfigurations.html
     */
    interface CFNDataSourceConfigurationsProperty {
        /**
         * `CfnDetector.CFNDataSourceConfigurationsProperty.S3Logs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfndatasourceconfigurations.html#cfn-guardduty-detector-cfndatasourceconfigurations-s3logs
         */
        readonly s3Logs?: CfnDetector.CFNS3LogsConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDetector {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfns3logsconfiguration.html
     */
    interface CFNS3LogsConfigurationProperty {
        /**
         * `CfnDetector.CFNS3LogsConfigurationProperty.Enable`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfns3logsconfiguration.html#cfn-guardduty-detector-cfns3logsconfiguration-enable
         */
        readonly enable?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::GuardDuty::Filter`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html
 */
export interface CfnFilterProps {
    /**
     * `AWS::GuardDuty::Filter.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-action
     */
    readonly action: string;
    /**
     * `AWS::GuardDuty::Filter.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-description
     */
    readonly description: string;
    /**
     * `AWS::GuardDuty::Filter.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-detectorid
     */
    readonly detectorId: string;
    /**
     * `AWS::GuardDuty::Filter.FindingCriteria`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-findingcriteria
     */
    readonly findingCriteria: CfnFilter.FindingCriteriaProperty | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::Filter.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-name
     */
    readonly name: string;
    /**
     * `AWS::GuardDuty::Filter.Rank`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-rank
     */
    readonly rank: number;
}
/**
 * A CloudFormation `AWS::GuardDuty::Filter`
 *
 * @cloudformationResource AWS::GuardDuty::Filter
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html
 */
export declare class CfnFilter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GuardDuty::Filter";
    /**
     * `AWS::GuardDuty::Filter.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-action
     */
    action: string;
    /**
     * `AWS::GuardDuty::Filter.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-description
     */
    description: string;
    /**
     * `AWS::GuardDuty::Filter.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-detectorid
     */
    detectorId: string;
    /**
     * `AWS::GuardDuty::Filter.FindingCriteria`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-findingcriteria
     */
    findingCriteria: CfnFilter.FindingCriteriaProperty | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::Filter.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-name
     */
    name: string;
    /**
     * `AWS::GuardDuty::Filter.Rank`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html#cfn-guardduty-filter-rank
     */
    rank: number;
    /**
     * Create a new `AWS::GuardDuty::Filter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFilterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFilter {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html
     */
    interface ConditionProperty {
        /**
         * `CfnFilter.ConditionProperty.Eq`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html#cfn-guardduty-filter-condition-eq
         */
        readonly eq?: string[];
        /**
         * `CfnFilter.ConditionProperty.Gte`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html#cfn-guardduty-filter-condition-gte
         */
        readonly gte?: number;
        /**
         * `CfnFilter.ConditionProperty.Lt`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html#cfn-guardduty-filter-condition-lt
         */
        readonly lt?: number;
        /**
         * `CfnFilter.ConditionProperty.Lte`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html#cfn-guardduty-filter-condition-lte
         */
        readonly lte?: number;
        /**
         * `CfnFilter.ConditionProperty.Neq`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html#cfn-guardduty-filter-condition-neq
         */
        readonly neq?: string[];
    }
}
export declare namespace CfnFilter {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-findingcriteria.html
     */
    interface FindingCriteriaProperty {
        /**
         * `CfnFilter.FindingCriteriaProperty.Criterion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-findingcriteria.html#cfn-guardduty-filter-findingcriteria-criterion
         */
        readonly criterion?: any | cdk.IResolvable;
        /**
         * `CfnFilter.FindingCriteriaProperty.ItemType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-findingcriteria.html#cfn-guardduty-filter-findingcriteria-itemtype
         */
        readonly itemType?: CfnFilter.ConditionProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::GuardDuty::IPSet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html
 */
export interface CfnIPSetProps {
    /**
     * `AWS::GuardDuty::IPSet.Activate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-activate
     */
    readonly activate: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::IPSet.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-detectorid
     */
    readonly detectorId: string;
    /**
     * `AWS::GuardDuty::IPSet.Format`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-format
     */
    readonly format: string;
    /**
     * `AWS::GuardDuty::IPSet.Location`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-location
     */
    readonly location: string;
    /**
     * `AWS::GuardDuty::IPSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-name
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::GuardDuty::IPSet`
 *
 * @cloudformationResource AWS::GuardDuty::IPSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html
 */
export declare class CfnIPSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GuardDuty::IPSet";
    /**
     * `AWS::GuardDuty::IPSet.Activate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-activate
     */
    activate: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::IPSet.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-detectorid
     */
    detectorId: string;
    /**
     * `AWS::GuardDuty::IPSet.Format`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-format
     */
    format: string;
    /**
     * `AWS::GuardDuty::IPSet.Location`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-location
     */
    location: string;
    /**
     * `AWS::GuardDuty::IPSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html#cfn-guardduty-ipset-name
     */
    name: string | undefined;
    /**
     * Create a new `AWS::GuardDuty::IPSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIPSetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::GuardDuty::Master`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html
 */
export interface CfnMasterProps {
    /**
     * `AWS::GuardDuty::Master.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html#cfn-guardduty-master-detectorid
     */
    readonly detectorId: string;
    /**
     * `AWS::GuardDuty::Master.MasterId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html#cfn-guardduty-master-masterid
     */
    readonly masterId: string;
    /**
     * `AWS::GuardDuty::Master.InvitationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html#cfn-guardduty-master-invitationid
     */
    readonly invitationId?: string;
}
/**
 * A CloudFormation `AWS::GuardDuty::Master`
 *
 * @cloudformationResource AWS::GuardDuty::Master
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html
 */
export declare class CfnMaster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GuardDuty::Master";
    /**
     * `AWS::GuardDuty::Master.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html#cfn-guardduty-master-detectorid
     */
    detectorId: string;
    /**
     * `AWS::GuardDuty::Master.MasterId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html#cfn-guardduty-master-masterid
     */
    masterId: string;
    /**
     * `AWS::GuardDuty::Master.InvitationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html#cfn-guardduty-master-invitationid
     */
    invitationId: string | undefined;
    /**
     * Create a new `AWS::GuardDuty::Master`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMasterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::GuardDuty::Member`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html
 */
export interface CfnMemberProps {
    /**
     * `AWS::GuardDuty::Member.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-detectorid
     */
    readonly detectorId: string;
    /**
     * `AWS::GuardDuty::Member.Email`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-email
     */
    readonly email: string;
    /**
     * `AWS::GuardDuty::Member.MemberId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-memberid
     */
    readonly memberId: string;
    /**
     * `AWS::GuardDuty::Member.DisableEmailNotification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-disableemailnotification
     */
    readonly disableEmailNotification?: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::Member.Message`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-message
     */
    readonly message?: string;
    /**
     * `AWS::GuardDuty::Member.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-status
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::GuardDuty::Member`
 *
 * @cloudformationResource AWS::GuardDuty::Member
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html
 */
export declare class CfnMember extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GuardDuty::Member";
    /**
     * `AWS::GuardDuty::Member.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-detectorid
     */
    detectorId: string;
    /**
     * `AWS::GuardDuty::Member.Email`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-email
     */
    email: string;
    /**
     * `AWS::GuardDuty::Member.MemberId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-memberid
     */
    memberId: string;
    /**
     * `AWS::GuardDuty::Member.DisableEmailNotification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-disableemailnotification
     */
    disableEmailNotification: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::GuardDuty::Member.Message`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-message
     */
    message: string | undefined;
    /**
     * `AWS::GuardDuty::Member.Status`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html#cfn-guardduty-member-status
     */
    status: string | undefined;
    /**
     * Create a new `AWS::GuardDuty::Member`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMemberProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::GuardDuty::ThreatIntelSet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html
 */
export interface CfnThreatIntelSetProps {
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Activate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-activate
     */
    readonly activate: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-detectorid
     */
    readonly detectorId: string;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Format`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-format
     */
    readonly format: string;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Location`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-location
     */
    readonly location: string;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-name
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::GuardDuty::ThreatIntelSet`
 *
 * @cloudformationResource AWS::GuardDuty::ThreatIntelSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html
 */
export declare class CfnThreatIntelSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GuardDuty::ThreatIntelSet";
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Activate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-activate
     */
    activate: boolean | cdk.IResolvable;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.DetectorId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-detectorid
     */
    detectorId: string;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Format`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-format
     */
    format: string;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Location`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-location
     */
    location: string;
    /**
     * `AWS::GuardDuty::ThreatIntelSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html#cfn-guardduty-threatintelset-name
     */
    name: string | undefined;
    /**
     * Create a new `AWS::GuardDuty::ThreatIntelSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThreatIntelSetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
