"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
/**
 * A certificate source for an ELBv2 listener
 */
class ListenerCertificate {
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
//# sourceMappingURL=data:application/json;base64,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