import { Construct } from "../../../core";
import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
/**
 * Specifies the firelens log driver configuration options.
 */
export interface FireLensLogDriverProps extends BaseLogDriverProps {
    /**
     * The configuration options to send to the log driver.
     * @default - the log driver options
     */
    readonly options?: {
        [key: string]: string;
    };
}
/**
 * FireLens enables you to use task definition parameters to route logs to an AWS service
 *  or AWS Partner Network (APN) destination for log storage and analytics
 */
export declare class FireLensLogDriver extends LogDriver {
    /**
     * The configuration options to send to the log driver.
     * @default - the log driver options
     */
    private options?;
    /**
     * Constructs a new instance of the FireLensLogDriver class.
     * @param props the awsfirelens log driver configuration options.
     */
    constructor(props: FireLensLogDriverProps);
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope: Construct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
