"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            },
        });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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