"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = exports.LogQueryVisualizationType = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const widget_1 = require("./widget");
/**
 * Types of view
 */
var LogQueryVisualizationType;
(function (LogQueryVisualizationType) {
    /**
     * Table view
     */
    LogQueryVisualizationType["TABLE"] = "table";
    /**
     * Line view
     */
    LogQueryVisualizationType["LINE"] = "line";
    /**
     * Stacked area view
     */
    LogQueryVisualizationType["STACKEDAREA"] = "stackedarea";
    /**
     * Bar view
     */
    LogQueryVisualizationType["BAR"] = "bar";
    /**
     * Pie view
     */
    LogQueryVisualizationType["PIE"] = "pie";
})(LogQueryVisualizationType = exports.LogQueryVisualizationType || (exports.LogQueryVisualizationType = {}));
/**
 * Display query results from Logs Insights
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        const properties = {
            view: this.props.view ? this.props.view : LogQueryVisualizationType.TABLE,
            title: this.props.title,
            region: this.props.region || cdk.Aws.REGION,
            query: `${sources} | ${query}`,
        };
        // adding stacked property in case of LINE or STACKEDAREA
        if (this.props.view === LogQueryVisualizationType.LINE || this.props.view === LogQueryVisualizationType.STACKEDAREA) {
            // assign the right native view value. both types share the same value
            properties.view = 'timeSeries',
                properties.stacked = this.props.view === LogQueryVisualizationType.STACKEDAREA ? true : false;
        }
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: properties,
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
//# sourceMappingURL=data:application/json;base64,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