"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
const utils_1 = require("./utils");
/**
 * An Amplify Console branch
 */
class Branch extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new amplify_generated_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: props.autoBuild === undefined ? true : props.autoBuild,
            enablePullRequestPreview: props.pullRequestPreview === undefined ? true : props.pullRequestPreview,
            environmentVariables: core_1.Lazy.anyValue({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
    }
    /**
     * Import an existing branch
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
//# sourceMappingURL=data:application/json;base64,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