import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

from .. import (
    CfnResource as _CfnResource_7760e8e4,
    CfnTag as _CfnTag_b4661f1a,
    Construct as _Construct_f50a3f53,
    IInspectable as _IInspectable_051e6ed8,
    IResolvable as _IResolvable_9ceae33e,
    TagManager as _TagManager_2508893f,
    TreeInspector as _TreeInspector_154f5999,
)


@jsii.implements(_IInspectable_051e6ed8)
class CfnWorkspace(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_workspaces.CfnWorkspace",
):
    """A CloudFormation ``AWS::WorkSpaces::Workspace``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
    cloudformationResource:
    :cloudformationResource:: AWS::WorkSpaces::Workspace
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        bundle_id: builtins.str,
        directory_id: builtins.str,
        user_name: builtins.str,
        root_volume_encryption_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        user_volume_encryption_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        volume_encryption_key: typing.Optional[builtins.str] = None,
        workspace_properties: typing.Optional[typing.Union["WorkspacePropertiesProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Create a new ``AWS::WorkSpaces::Workspace``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param bundle_id: ``AWS::WorkSpaces::Workspace.BundleId``.
        :param directory_id: ``AWS::WorkSpaces::Workspace.DirectoryId``.
        :param user_name: ``AWS::WorkSpaces::Workspace.UserName``.
        :param root_volume_encryption_enabled: ``AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled``.
        :param tags: ``AWS::WorkSpaces::Workspace.Tags``.
        :param user_volume_encryption_enabled: ``AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled``.
        :param volume_encryption_key: ``AWS::WorkSpaces::Workspace.VolumeEncryptionKey``.
        :param workspace_properties: ``AWS::WorkSpaces::Workspace.WorkspaceProperties``.
        """
        props = CfnWorkspaceProps(
            bundle_id=bundle_id,
            directory_id=directory_id,
            user_name=user_name,
            root_volume_encryption_enabled=root_volume_encryption_enabled,
            tags=tags,
            user_volume_encryption_enabled=user_volume_encryption_enabled,
            volume_encryption_key=volume_encryption_key,
            workspace_properties=workspace_properties,
        )

        jsii.create(CfnWorkspace, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::WorkSpaces::Workspace.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bundleId")
    def bundle_id(self) -> builtins.str:
        """``AWS::WorkSpaces::Workspace.BundleId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-bundleid
        """
        return jsii.get(self, "bundleId")

    @bundle_id.setter # type: ignore
    def bundle_id(self, value: builtins.str) -> None:
        jsii.set(self, "bundleId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="directoryId")
    def directory_id(self) -> builtins.str:
        """``AWS::WorkSpaces::Workspace.DirectoryId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-directoryid
        """
        return jsii.get(self, "directoryId")

    @directory_id.setter # type: ignore
    def directory_id(self, value: builtins.str) -> None:
        jsii.set(self, "directoryId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userName")
    def user_name(self) -> builtins.str:
        """``AWS::WorkSpaces::Workspace.UserName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-username
        """
        return jsii.get(self, "userName")

    @user_name.setter # type: ignore
    def user_name(self, value: builtins.str) -> None:
        jsii.set(self, "userName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="rootVolumeEncryptionEnabled")
    def root_volume_encryption_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-rootvolumeencryptionenabled
        """
        return jsii.get(self, "rootVolumeEncryptionEnabled")

    @root_volume_encryption_enabled.setter # type: ignore
    def root_volume_encryption_enabled(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "rootVolumeEncryptionEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userVolumeEncryptionEnabled")
    def user_volume_encryption_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-uservolumeencryptionenabled
        """
        return jsii.get(self, "userVolumeEncryptionEnabled")

    @user_volume_encryption_enabled.setter # type: ignore
    def user_volume_encryption_enabled(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "userVolumeEncryptionEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="volumeEncryptionKey")
    def volume_encryption_key(self) -> typing.Optional[builtins.str]:
        """``AWS::WorkSpaces::Workspace.VolumeEncryptionKey``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-volumeencryptionkey
        """
        return jsii.get(self, "volumeEncryptionKey")

    @volume_encryption_key.setter # type: ignore
    def volume_encryption_key(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "volumeEncryptionKey", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="workspaceProperties")
    def workspace_properties(
        self,
    ) -> typing.Optional[typing.Union["WorkspacePropertiesProperty", _IResolvable_9ceae33e]]:
        """``AWS::WorkSpaces::Workspace.WorkspaceProperties``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-workspaceproperties
        """
        return jsii.get(self, "workspaceProperties")

    @workspace_properties.setter # type: ignore
    def workspace_properties(
        self,
        value: typing.Optional[typing.Union["WorkspacePropertiesProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "workspaceProperties", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_workspaces.CfnWorkspace.WorkspacePropertiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "compute_type_name": "computeTypeName",
            "root_volume_size_gib": "rootVolumeSizeGib",
            "running_mode": "runningMode",
            "running_mode_auto_stop_timeout_in_minutes": "runningModeAutoStopTimeoutInMinutes",
            "user_volume_size_gib": "userVolumeSizeGib",
        },
    )
    class WorkspacePropertiesProperty:
        def __init__(
            self,
            *,
            compute_type_name: typing.Optional[builtins.str] = None,
            root_volume_size_gib: typing.Optional[jsii.Number] = None,
            running_mode: typing.Optional[builtins.str] = None,
            running_mode_auto_stop_timeout_in_minutes: typing.Optional[jsii.Number] = None,
            user_volume_size_gib: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param compute_type_name: ``CfnWorkspace.WorkspacePropertiesProperty.ComputeTypeName``.
            :param root_volume_size_gib: ``CfnWorkspace.WorkspacePropertiesProperty.RootVolumeSizeGib``.
            :param running_mode: ``CfnWorkspace.WorkspacePropertiesProperty.RunningMode``.
            :param running_mode_auto_stop_timeout_in_minutes: ``CfnWorkspace.WorkspacePropertiesProperty.RunningModeAutoStopTimeoutInMinutes``.
            :param user_volume_size_gib: ``CfnWorkspace.WorkspacePropertiesProperty.UserVolumeSizeGib``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if compute_type_name is not None:
                self._values["compute_type_name"] = compute_type_name
            if root_volume_size_gib is not None:
                self._values["root_volume_size_gib"] = root_volume_size_gib
            if running_mode is not None:
                self._values["running_mode"] = running_mode
            if running_mode_auto_stop_timeout_in_minutes is not None:
                self._values["running_mode_auto_stop_timeout_in_minutes"] = running_mode_auto_stop_timeout_in_minutes
            if user_volume_size_gib is not None:
                self._values["user_volume_size_gib"] = user_volume_size_gib

        @builtins.property
        def compute_type_name(self) -> typing.Optional[builtins.str]:
            """``CfnWorkspace.WorkspacePropertiesProperty.ComputeTypeName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-computetypename
            """
            result = self._values.get("compute_type_name")
            return result

        @builtins.property
        def root_volume_size_gib(self) -> typing.Optional[jsii.Number]:
            """``CfnWorkspace.WorkspacePropertiesProperty.RootVolumeSizeGib``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-rootvolumesizegib
            """
            result = self._values.get("root_volume_size_gib")
            return result

        @builtins.property
        def running_mode(self) -> typing.Optional[builtins.str]:
            """``CfnWorkspace.WorkspacePropertiesProperty.RunningMode``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-runningmode
            """
            result = self._values.get("running_mode")
            return result

        @builtins.property
        def running_mode_auto_stop_timeout_in_minutes(
            self,
        ) -> typing.Optional[jsii.Number]:
            """``CfnWorkspace.WorkspacePropertiesProperty.RunningModeAutoStopTimeoutInMinutes``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-runningmodeautostoptimeoutinminutes
            """
            result = self._values.get("running_mode_auto_stop_timeout_in_minutes")
            return result

        @builtins.property
        def user_volume_size_gib(self) -> typing.Optional[jsii.Number]:
            """``CfnWorkspace.WorkspacePropertiesProperty.UserVolumeSizeGib``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-uservolumesizegib
            """
            result = self._values.get("user_volume_size_gib")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "WorkspacePropertiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_workspaces.CfnWorkspaceProps",
    jsii_struct_bases=[],
    name_mapping={
        "bundle_id": "bundleId",
        "directory_id": "directoryId",
        "user_name": "userName",
        "root_volume_encryption_enabled": "rootVolumeEncryptionEnabled",
        "tags": "tags",
        "user_volume_encryption_enabled": "userVolumeEncryptionEnabled",
        "volume_encryption_key": "volumeEncryptionKey",
        "workspace_properties": "workspaceProperties",
    },
)
class CfnWorkspaceProps:
    def __init__(
        self,
        *,
        bundle_id: builtins.str,
        directory_id: builtins.str,
        user_name: builtins.str,
        root_volume_encryption_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        user_volume_encryption_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        volume_encryption_key: typing.Optional[builtins.str] = None,
        workspace_properties: typing.Optional[typing.Union["CfnWorkspace.WorkspacePropertiesProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Properties for defining a ``AWS::WorkSpaces::Workspace``.

        :param bundle_id: ``AWS::WorkSpaces::Workspace.BundleId``.
        :param directory_id: ``AWS::WorkSpaces::Workspace.DirectoryId``.
        :param user_name: ``AWS::WorkSpaces::Workspace.UserName``.
        :param root_volume_encryption_enabled: ``AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled``.
        :param tags: ``AWS::WorkSpaces::Workspace.Tags``.
        :param user_volume_encryption_enabled: ``AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled``.
        :param volume_encryption_key: ``AWS::WorkSpaces::Workspace.VolumeEncryptionKey``.
        :param workspace_properties: ``AWS::WorkSpaces::Workspace.WorkspaceProperties``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "bundle_id": bundle_id,
            "directory_id": directory_id,
            "user_name": user_name,
        }
        if root_volume_encryption_enabled is not None:
            self._values["root_volume_encryption_enabled"] = root_volume_encryption_enabled
        if tags is not None:
            self._values["tags"] = tags
        if user_volume_encryption_enabled is not None:
            self._values["user_volume_encryption_enabled"] = user_volume_encryption_enabled
        if volume_encryption_key is not None:
            self._values["volume_encryption_key"] = volume_encryption_key
        if workspace_properties is not None:
            self._values["workspace_properties"] = workspace_properties

    @builtins.property
    def bundle_id(self) -> builtins.str:
        """``AWS::WorkSpaces::Workspace.BundleId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-bundleid
        """
        result = self._values.get("bundle_id")
        assert result is not None, "Required property 'bundle_id' is missing"
        return result

    @builtins.property
    def directory_id(self) -> builtins.str:
        """``AWS::WorkSpaces::Workspace.DirectoryId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-directoryid
        """
        result = self._values.get("directory_id")
        assert result is not None, "Required property 'directory_id' is missing"
        return result

    @builtins.property
    def user_name(self) -> builtins.str:
        """``AWS::WorkSpaces::Workspace.UserName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-username
        """
        result = self._values.get("user_name")
        assert result is not None, "Required property 'user_name' is missing"
        return result

    @builtins.property
    def root_volume_encryption_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-rootvolumeencryptionenabled
        """
        result = self._values.get("root_volume_encryption_enabled")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::WorkSpaces::Workspace.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def user_volume_encryption_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-uservolumeencryptionenabled
        """
        result = self._values.get("user_volume_encryption_enabled")
        return result

    @builtins.property
    def volume_encryption_key(self) -> typing.Optional[builtins.str]:
        """``AWS::WorkSpaces::Workspace.VolumeEncryptionKey``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-volumeencryptionkey
        """
        result = self._values.get("volume_encryption_key")
        return result

    @builtins.property
    def workspace_properties(
        self,
    ) -> typing.Optional[typing.Union["CfnWorkspace.WorkspacePropertiesProperty", _IResolvable_9ceae33e]]:
        """``AWS::WorkSpaces::Workspace.WorkspaceProperties``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-workspaceproperties
        """
        result = self._values.get("workspace_properties")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnWorkspaceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "CfnWorkspace",
    "CfnWorkspaceProps",
]

publication.publish()
