import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

from .. import (
    CfnResource as _CfnResource_7760e8e4,
    Construct as _Construct_f50a3f53,
    IDependable as _IDependable_4fc803f7,
    IInspectable as _IInspectable_051e6ed8,
    IResolvable as _IResolvable_9ceae33e,
    IResource as _IResource_72f7ee7e,
    RemovalPolicy as _RemovalPolicy_5986e9f3,
    Resource as _Resource_884d0774,
    Size as _Size_b4ccfc18,
    TagManager as _TagManager_2508893f,
    TreeInspector as _TreeInspector_154f5999,
)
from ..aws_ec2 import (
    Connections as _Connections_231f38b5,
    IConnectable as _IConnectable_a587039f,
    ISecurityGroup as _ISecurityGroup_d72ab8e8,
    IVpc as _IVpc_3795853f,
    SubnetSelection as _SubnetSelection_36a13cd6,
)
from ..aws_kms import IKey as _IKey_3336c79d


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.AccessPointOptions",
    jsii_struct_bases=[],
    name_mapping={
        "create_acl": "createAcl",
        "path": "path",
        "posix_user": "posixUser",
    },
)
class AccessPointOptions:
    def __init__(
        self,
        *,
        create_acl: typing.Optional["Acl"] = None,
        path: typing.Optional[builtins.str] = None,
        posix_user: typing.Optional["PosixUser"] = None,
    ) -> None:
        """Options to create an AccessPoint.

        :param create_acl: Specifies the POSIX IDs and permissions to apply when creating the access point's root directory. If the root directory specified by ``path`` does not exist, EFS creates the root directory and applies the permissions specified here. If the specified ``path`` does not exist, you must specify ``createAcl``. Default: - None. The directory specified by ``path`` must exist.
        :param path: Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. Default: '/'
        :param posix_user: The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point. Specify this to enforce a user identity using an access point. Default: - user identity not enforced

        stability
        :stability: experimental
        """
        if isinstance(create_acl, dict):
            create_acl = Acl(**create_acl)
        if isinstance(posix_user, dict):
            posix_user = PosixUser(**posix_user)
        self._values: typing.Dict[str, typing.Any] = {}
        if create_acl is not None:
            self._values["create_acl"] = create_acl
        if path is not None:
            self._values["path"] = path
        if posix_user is not None:
            self._values["posix_user"] = posix_user

    @builtins.property
    def create_acl(self) -> typing.Optional["Acl"]:
        """Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.

        If the
        root directory specified by ``path`` does not exist, EFS creates the root directory and applies the
        permissions specified here. If the specified ``path`` does not exist, you must specify ``createAcl``.

        default
        :default: - None. The directory specified by ``path`` must exist.

        stability
        :stability: experimental
        """
        result = self._values.get("create_acl")
        return result

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        """Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.

        default
        :default: '/'

        stability
        :stability: experimental
        """
        result = self._values.get("path")
        return result

    @builtins.property
    def posix_user(self) -> typing.Optional["PosixUser"]:
        """The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.

        Specify this to enforce a user identity using an access point.

        default
        :default: - user identity not enforced

        see
        :see: - `Enforcing a User Identity Using an Access Point <https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html>`_
        stability
        :stability: experimental
        """
        result = self._values.get("posix_user")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AccessPointOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.AccessPointProps",
    jsii_struct_bases=[AccessPointOptions],
    name_mapping={
        "create_acl": "createAcl",
        "path": "path",
        "posix_user": "posixUser",
        "file_system": "fileSystem",
    },
)
class AccessPointProps(AccessPointOptions):
    def __init__(
        self,
        *,
        create_acl: typing.Optional["Acl"] = None,
        path: typing.Optional[builtins.str] = None,
        posix_user: typing.Optional["PosixUser"] = None,
        file_system: "IFileSystem",
    ) -> None:
        """Properties for the AccessPoint.

        :param create_acl: Specifies the POSIX IDs and permissions to apply when creating the access point's root directory. If the root directory specified by ``path`` does not exist, EFS creates the root directory and applies the permissions specified here. If the specified ``path`` does not exist, you must specify ``createAcl``. Default: - None. The directory specified by ``path`` must exist.
        :param path: Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. Default: '/'
        :param posix_user: The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point. Specify this to enforce a user identity using an access point. Default: - user identity not enforced
        :param file_system: The efs filesystem.

        stability
        :stability: experimental
        """
        if isinstance(create_acl, dict):
            create_acl = Acl(**create_acl)
        if isinstance(posix_user, dict):
            posix_user = PosixUser(**posix_user)
        self._values: typing.Dict[str, typing.Any] = {
            "file_system": file_system,
        }
        if create_acl is not None:
            self._values["create_acl"] = create_acl
        if path is not None:
            self._values["path"] = path
        if posix_user is not None:
            self._values["posix_user"] = posix_user

    @builtins.property
    def create_acl(self) -> typing.Optional["Acl"]:
        """Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.

        If the
        root directory specified by ``path`` does not exist, EFS creates the root directory and applies the
        permissions specified here. If the specified ``path`` does not exist, you must specify ``createAcl``.

        default
        :default: - None. The directory specified by ``path`` must exist.

        stability
        :stability: experimental
        """
        result = self._values.get("create_acl")
        return result

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        """Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.

        default
        :default: '/'

        stability
        :stability: experimental
        """
        result = self._values.get("path")
        return result

    @builtins.property
    def posix_user(self) -> typing.Optional["PosixUser"]:
        """The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.

        Specify this to enforce a user identity using an access point.

        default
        :default: - user identity not enforced

        see
        :see: - `Enforcing a User Identity Using an Access Point <https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html>`_
        stability
        :stability: experimental
        """
        result = self._values.get("posix_user")
        return result

    @builtins.property
    def file_system(self) -> "IFileSystem":
        """The efs filesystem.

        stability
        :stability: experimental
        """
        result = self._values.get("file_system")
        assert result is not None, "Required property 'file_system' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AccessPointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.Acl",
    jsii_struct_bases=[],
    name_mapping={
        "owner_gid": "ownerGid",
        "owner_uid": "ownerUid",
        "permissions": "permissions",
    },
)
class Acl:
    def __init__(
        self,
        *,
        owner_gid: builtins.str,
        owner_uid: builtins.str,
        permissions: builtins.str,
    ) -> None:
        """Permissions as POSIX ACL.

        :param owner_gid: Specifies the POSIX group ID to apply to the RootDirectory. Accepts values from 0 to 2^32 (4294967295).
        :param owner_uid: Specifies the POSIX user ID to apply to the RootDirectory. Accepts values from 0 to 2^32 (4294967295).
        :param permissions: Specifies the POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "owner_gid": owner_gid,
            "owner_uid": owner_uid,
            "permissions": permissions,
        }

    @builtins.property
    def owner_gid(self) -> builtins.str:
        """Specifies the POSIX group ID to apply to the RootDirectory.

        Accepts values from 0 to 2^32 (4294967295).

        stability
        :stability: experimental
        """
        result = self._values.get("owner_gid")
        assert result is not None, "Required property 'owner_gid' is missing"
        return result

    @builtins.property
    def owner_uid(self) -> builtins.str:
        """Specifies the POSIX user ID to apply to the RootDirectory.

        Accepts values from 0 to 2^32 (4294967295).

        stability
        :stability: experimental
        """
        result = self._values.get("owner_uid")
        assert result is not None, "Required property 'owner_uid' is missing"
        return result

    @builtins.property
    def permissions(self) -> builtins.str:
        """Specifies the POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.

        stability
        :stability: experimental
        """
        result = self._values.get("permissions")
        assert result is not None, "Required property 'permissions' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Acl(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnAccessPoint(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_efs.CfnAccessPoint",
):
    """A CloudFormation ``AWS::EFS::AccessPoint``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
    cloudformationResource:
    :cloudformationResource:: AWS::EFS::AccessPoint
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        file_system_id: builtins.str,
        access_point_tags: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["AccessPointTagProperty", _IResolvable_9ceae33e]]]] = None,
        client_token: typing.Optional[builtins.str] = None,
        posix_user: typing.Optional[typing.Union["PosixUserProperty", _IResolvable_9ceae33e]] = None,
        root_directory: typing.Optional[typing.Union["RootDirectoryProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Create a new ``AWS::EFS::AccessPoint``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param file_system_id: ``AWS::EFS::AccessPoint.FileSystemId``.
        :param access_point_tags: ``AWS::EFS::AccessPoint.AccessPointTags``.
        :param client_token: ``AWS::EFS::AccessPoint.ClientToken``.
        :param posix_user: ``AWS::EFS::AccessPoint.PosixUser``.
        :param root_directory: ``AWS::EFS::AccessPoint.RootDirectory``.
        """
        props = CfnAccessPointProps(
            file_system_id=file_system_id,
            access_point_tags=access_point_tags,
            client_token=client_token,
            posix_user=posix_user,
            root_directory=root_directory,
        )

        jsii.create(CfnAccessPoint, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAccessPointId")
    def attr_access_point_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AccessPointId
        """
        return jsii.get(self, "attrAccessPointId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Arn
        """
        return jsii.get(self, "attrArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """``AWS::EFS::AccessPoint.FileSystemId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid
        """
        return jsii.get(self, "fileSystemId")

    @file_system_id.setter # type: ignore
    def file_system_id(self, value: builtins.str) -> None:
        jsii.set(self, "fileSystemId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointTags")
    def access_point_tags(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["AccessPointTagProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EFS::AccessPoint.AccessPointTags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags
        """
        return jsii.get(self, "accessPointTags")

    @access_point_tags.setter # type: ignore
    def access_point_tags(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["AccessPointTagProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "accessPointTags", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientToken")
    def client_token(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::AccessPoint.ClientToken``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken
        """
        return jsii.get(self, "clientToken")

    @client_token.setter # type: ignore
    def client_token(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "clientToken", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="posixUser")
    def posix_user(
        self,
    ) -> typing.Optional[typing.Union["PosixUserProperty", _IResolvable_9ceae33e]]:
        """``AWS::EFS::AccessPoint.PosixUser``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser
        """
        return jsii.get(self, "posixUser")

    @posix_user.setter # type: ignore
    def posix_user(
        self,
        value: typing.Optional[typing.Union["PosixUserProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "posixUser", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="rootDirectory")
    def root_directory(
        self,
    ) -> typing.Optional[typing.Union["RootDirectoryProperty", _IResolvable_9ceae33e]]:
        """``AWS::EFS::AccessPoint.RootDirectory``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory
        """
        return jsii.get(self, "rootDirectory")

    @root_directory.setter # type: ignore
    def root_directory(
        self,
        value: typing.Optional[typing.Union["RootDirectoryProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "rootDirectory", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnAccessPoint.AccessPointTagProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "value": "value"},
    )
    class AccessPointTagProperty:
        def __init__(
            self,
            *,
            key: typing.Optional[builtins.str] = None,
            value: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param key: ``CfnAccessPoint.AccessPointTagProperty.Key``.
            :param value: ``CfnAccessPoint.AccessPointTagProperty.Value``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if key is not None:
                self._values["key"] = key
            if value is not None:
                self._values["value"] = value

        @builtins.property
        def key(self) -> typing.Optional[builtins.str]:
            """``CfnAccessPoint.AccessPointTagProperty.Key``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html#cfn-efs-accesspoint-accesspointtag-key
            """
            result = self._values.get("key")
            return result

        @builtins.property
        def value(self) -> typing.Optional[builtins.str]:
            """``CfnAccessPoint.AccessPointTagProperty.Value``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html#cfn-efs-accesspoint-accesspointtag-value
            """
            result = self._values.get("value")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AccessPointTagProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnAccessPoint.CreationInfoProperty",
        jsii_struct_bases=[],
        name_mapping={
            "owner_gid": "ownerGid",
            "owner_uid": "ownerUid",
            "permissions": "permissions",
        },
    )
    class CreationInfoProperty:
        def __init__(
            self,
            *,
            owner_gid: builtins.str,
            owner_uid: builtins.str,
            permissions: builtins.str,
        ) -> None:
            """
            :param owner_gid: ``CfnAccessPoint.CreationInfoProperty.OwnerGid``.
            :param owner_uid: ``CfnAccessPoint.CreationInfoProperty.OwnerUid``.
            :param permissions: ``CfnAccessPoint.CreationInfoProperty.Permissions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "owner_gid": owner_gid,
                "owner_uid": owner_uid,
                "permissions": permissions,
            }

        @builtins.property
        def owner_gid(self) -> builtins.str:
            """``CfnAccessPoint.CreationInfoProperty.OwnerGid``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-ownergid
            """
            result = self._values.get("owner_gid")
            assert result is not None, "Required property 'owner_gid' is missing"
            return result

        @builtins.property
        def owner_uid(self) -> builtins.str:
            """``CfnAccessPoint.CreationInfoProperty.OwnerUid``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-owneruid
            """
            result = self._values.get("owner_uid")
            assert result is not None, "Required property 'owner_uid' is missing"
            return result

        @builtins.property
        def permissions(self) -> builtins.str:
            """``CfnAccessPoint.CreationInfoProperty.Permissions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-permissions
            """
            result = self._values.get("permissions")
            assert result is not None, "Required property 'permissions' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CreationInfoProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnAccessPoint.PosixUserProperty",
        jsii_struct_bases=[],
        name_mapping={"gid": "gid", "uid": "uid", "secondary_gids": "secondaryGids"},
    )
    class PosixUserProperty:
        def __init__(
            self,
            *,
            gid: builtins.str,
            uid: builtins.str,
            secondary_gids: typing.Optional[typing.List[builtins.str]] = None,
        ) -> None:
            """
            :param gid: ``CfnAccessPoint.PosixUserProperty.Gid``.
            :param uid: ``CfnAccessPoint.PosixUserProperty.Uid``.
            :param secondary_gids: ``CfnAccessPoint.PosixUserProperty.SecondaryGids``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "gid": gid,
                "uid": uid,
            }
            if secondary_gids is not None:
                self._values["secondary_gids"] = secondary_gids

        @builtins.property
        def gid(self) -> builtins.str:
            """``CfnAccessPoint.PosixUserProperty.Gid``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-gid
            """
            result = self._values.get("gid")
            assert result is not None, "Required property 'gid' is missing"
            return result

        @builtins.property
        def uid(self) -> builtins.str:
            """``CfnAccessPoint.PosixUserProperty.Uid``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-uid
            """
            result = self._values.get("uid")
            assert result is not None, "Required property 'uid' is missing"
            return result

        @builtins.property
        def secondary_gids(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnAccessPoint.PosixUserProperty.SecondaryGids``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-secondarygids
            """
            result = self._values.get("secondary_gids")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PosixUserProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnAccessPoint.RootDirectoryProperty",
        jsii_struct_bases=[],
        name_mapping={"creation_info": "creationInfo", "path": "path"},
    )
    class RootDirectoryProperty:
        def __init__(
            self,
            *,
            creation_info: typing.Optional[typing.Union["CfnAccessPoint.CreationInfoProperty", _IResolvable_9ceae33e]] = None,
            path: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param creation_info: ``CfnAccessPoint.RootDirectoryProperty.CreationInfo``.
            :param path: ``CfnAccessPoint.RootDirectoryProperty.Path``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if creation_info is not None:
                self._values["creation_info"] = creation_info
            if path is not None:
                self._values["path"] = path

        @builtins.property
        def creation_info(
            self,
        ) -> typing.Optional[typing.Union["CfnAccessPoint.CreationInfoProperty", _IResolvable_9ceae33e]]:
            """``CfnAccessPoint.RootDirectoryProperty.CreationInfo``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html#cfn-efs-accesspoint-rootdirectory-creationinfo
            """
            result = self._values.get("creation_info")
            return result

        @builtins.property
        def path(self) -> typing.Optional[builtins.str]:
            """``CfnAccessPoint.RootDirectoryProperty.Path``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html#cfn-efs-accesspoint-rootdirectory-path
            """
            result = self._values.get("path")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RootDirectoryProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.CfnAccessPointProps",
    jsii_struct_bases=[],
    name_mapping={
        "file_system_id": "fileSystemId",
        "access_point_tags": "accessPointTags",
        "client_token": "clientToken",
        "posix_user": "posixUser",
        "root_directory": "rootDirectory",
    },
)
class CfnAccessPointProps:
    def __init__(
        self,
        *,
        file_system_id: builtins.str,
        access_point_tags: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnAccessPoint.AccessPointTagProperty", _IResolvable_9ceae33e]]]] = None,
        client_token: typing.Optional[builtins.str] = None,
        posix_user: typing.Optional[typing.Union["CfnAccessPoint.PosixUserProperty", _IResolvable_9ceae33e]] = None,
        root_directory: typing.Optional[typing.Union["CfnAccessPoint.RootDirectoryProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EFS::AccessPoint``.

        :param file_system_id: ``AWS::EFS::AccessPoint.FileSystemId``.
        :param access_point_tags: ``AWS::EFS::AccessPoint.AccessPointTags``.
        :param client_token: ``AWS::EFS::AccessPoint.ClientToken``.
        :param posix_user: ``AWS::EFS::AccessPoint.PosixUser``.
        :param root_directory: ``AWS::EFS::AccessPoint.RootDirectory``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "file_system_id": file_system_id,
        }
        if access_point_tags is not None:
            self._values["access_point_tags"] = access_point_tags
        if client_token is not None:
            self._values["client_token"] = client_token
        if posix_user is not None:
            self._values["posix_user"] = posix_user
        if root_directory is not None:
            self._values["root_directory"] = root_directory

    @builtins.property
    def file_system_id(self) -> builtins.str:
        """``AWS::EFS::AccessPoint.FileSystemId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid
        """
        result = self._values.get("file_system_id")
        assert result is not None, "Required property 'file_system_id' is missing"
        return result

    @builtins.property
    def access_point_tags(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnAccessPoint.AccessPointTagProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EFS::AccessPoint.AccessPointTags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags
        """
        result = self._values.get("access_point_tags")
        return result

    @builtins.property
    def client_token(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::AccessPoint.ClientToken``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken
        """
        result = self._values.get("client_token")
        return result

    @builtins.property
    def posix_user(
        self,
    ) -> typing.Optional[typing.Union["CfnAccessPoint.PosixUserProperty", _IResolvable_9ceae33e]]:
        """``AWS::EFS::AccessPoint.PosixUser``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser
        """
        result = self._values.get("posix_user")
        return result

    @builtins.property
    def root_directory(
        self,
    ) -> typing.Optional[typing.Union["CfnAccessPoint.RootDirectoryProperty", _IResolvable_9ceae33e]]:
        """``AWS::EFS::AccessPoint.RootDirectory``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory
        """
        result = self._values.get("root_directory")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAccessPointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnFileSystem(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_efs.CfnFileSystem",
):
    """A CloudFormation ``AWS::EFS::FileSystem``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
    cloudformationResource:
    :cloudformationResource:: AWS::EFS::FileSystem
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        backup_policy: typing.Optional[typing.Union["BackupPolicyProperty", _IResolvable_9ceae33e]] = None,
        encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        file_system_policy: typing.Any = None,
        file_system_tags: typing.Optional[typing.List["ElasticFileSystemTagProperty"]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        lifecycle_policies: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["LifecyclePolicyProperty", _IResolvable_9ceae33e]]]] = None,
        performance_mode: typing.Optional[builtins.str] = None,
        provisioned_throughput_in_mibps: typing.Optional[jsii.Number] = None,
        throughput_mode: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EFS::FileSystem``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param backup_policy: ``AWS::EFS::FileSystem.BackupPolicy``.
        :param encrypted: ``AWS::EFS::FileSystem.Encrypted``.
        :param file_system_policy: ``AWS::EFS::FileSystem.FileSystemPolicy``.
        :param file_system_tags: ``AWS::EFS::FileSystem.FileSystemTags``.
        :param kms_key_id: ``AWS::EFS::FileSystem.KmsKeyId``.
        :param lifecycle_policies: ``AWS::EFS::FileSystem.LifecyclePolicies``.
        :param performance_mode: ``AWS::EFS::FileSystem.PerformanceMode``.
        :param provisioned_throughput_in_mibps: ``AWS::EFS::FileSystem.ProvisionedThroughputInMibps``.
        :param throughput_mode: ``AWS::EFS::FileSystem.ThroughputMode``.
        """
        props = CfnFileSystemProps(
            backup_policy=backup_policy,
            encrypted=encrypted,
            file_system_policy=file_system_policy,
            file_system_tags=file_system_tags,
            kms_key_id=kms_key_id,
            lifecycle_policies=lifecycle_policies,
            performance_mode=performance_mode,
            provisioned_throughput_in_mibps=provisioned_throughput_in_mibps,
            throughput_mode=throughput_mode,
        )

        jsii.create(CfnFileSystem, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Arn
        """
        return jsii.get(self, "attrArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrFileSystemId")
    def attr_file_system_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: FileSystemId
        """
        return jsii.get(self, "attrFileSystemId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EFS::FileSystem.FileSystemTags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystemPolicy")
    def file_system_policy(self) -> typing.Any:
        """``AWS::EFS::FileSystem.FileSystemPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
        """
        return jsii.get(self, "fileSystemPolicy")

    @file_system_policy.setter # type: ignore
    def file_system_policy(self, value: typing.Any) -> None:
        jsii.set(self, "fileSystemPolicy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="backupPolicy")
    def backup_policy(
        self,
    ) -> typing.Optional[typing.Union["BackupPolicyProperty", _IResolvable_9ceae33e]]:
        """``AWS::EFS::FileSystem.BackupPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy
        """
        return jsii.get(self, "backupPolicy")

    @backup_policy.setter # type: ignore
    def backup_policy(
        self,
        value: typing.Optional[typing.Union["BackupPolicyProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "backupPolicy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="encrypted")
    def encrypted(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EFS::FileSystem.Encrypted``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
        """
        return jsii.get(self, "encrypted")

    @encrypted.setter # type: ignore
    def encrypted(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "encrypted", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::FileSystem.KmsKeyId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
        """
        return jsii.get(self, "kmsKeyId")

    @kms_key_id.setter # type: ignore
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "kmsKeyId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="lifecyclePolicies")
    def lifecycle_policies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["LifecyclePolicyProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EFS::FileSystem.LifecyclePolicies``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
        """
        return jsii.get(self, "lifecyclePolicies")

    @lifecycle_policies.setter # type: ignore
    def lifecycle_policies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["LifecyclePolicyProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "lifecyclePolicies", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="performanceMode")
    def performance_mode(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::FileSystem.PerformanceMode``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
        """
        return jsii.get(self, "performanceMode")

    @performance_mode.setter # type: ignore
    def performance_mode(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "performanceMode", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> typing.Optional[jsii.Number]:
        """``AWS::EFS::FileSystem.ProvisionedThroughputInMibps``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
        """
        return jsii.get(self, "provisionedThroughputInMibps")

    @provisioned_throughput_in_mibps.setter # type: ignore
    def provisioned_throughput_in_mibps(
        self,
        value: typing.Optional[jsii.Number],
    ) -> None:
        jsii.set(self, "provisionedThroughputInMibps", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="throughputMode")
    def throughput_mode(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::FileSystem.ThroughputMode``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
        """
        return jsii.get(self, "throughputMode")

    @throughput_mode.setter # type: ignore
    def throughput_mode(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "throughputMode", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnFileSystem.BackupPolicyProperty",
        jsii_struct_bases=[],
        name_mapping={"status": "status"},
    )
    class BackupPolicyProperty:
        def __init__(self, *, status: builtins.str) -> None:
            """
            :param status: ``CfnFileSystem.BackupPolicyProperty.Status``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "status": status,
            }

        @builtins.property
        def status(self) -> builtins.str:
            """``CfnFileSystem.BackupPolicyProperty.Status``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-backuppolicy.html#cfn-efs-filesystem-backuppolicy-status
            """
            result = self._values.get("status")
            assert result is not None, "Required property 'status' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BackupPolicyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnFileSystem.ElasticFileSystemTagProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "value": "value"},
    )
    class ElasticFileSystemTagProperty:
        def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
            """
            :param key: ``CfnFileSystem.ElasticFileSystemTagProperty.Key``.
            :param value: ``CfnFileSystem.ElasticFileSystemTagProperty.Value``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "key": key,
                "value": value,
            }

        @builtins.property
        def key(self) -> builtins.str:
            """``CfnFileSystem.ElasticFileSystemTagProperty.Key``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-key
            """
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return result

        @builtins.property
        def value(self) -> builtins.str:
            """``CfnFileSystem.ElasticFileSystemTagProperty.Value``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-value
            """
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ElasticFileSystemTagProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_efs.CfnFileSystem.LifecyclePolicyProperty",
        jsii_struct_bases=[],
        name_mapping={"transition_to_ia": "transitionToIa"},
    )
    class LifecyclePolicyProperty:
        def __init__(self, *, transition_to_ia: builtins.str) -> None:
            """
            :param transition_to_ia: ``CfnFileSystem.LifecyclePolicyProperty.TransitionToIA``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "transition_to_ia": transition_to_ia,
            }

        @builtins.property
        def transition_to_ia(self) -> builtins.str:
            """``CfnFileSystem.LifecyclePolicyProperty.TransitionToIA``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoia
            """
            result = self._values.get("transition_to_ia")
            assert result is not None, "Required property 'transition_to_ia' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LifecyclePolicyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.CfnFileSystemProps",
    jsii_struct_bases=[],
    name_mapping={
        "backup_policy": "backupPolicy",
        "encrypted": "encrypted",
        "file_system_policy": "fileSystemPolicy",
        "file_system_tags": "fileSystemTags",
        "kms_key_id": "kmsKeyId",
        "lifecycle_policies": "lifecyclePolicies",
        "performance_mode": "performanceMode",
        "provisioned_throughput_in_mibps": "provisionedThroughputInMibps",
        "throughput_mode": "throughputMode",
    },
)
class CfnFileSystemProps:
    def __init__(
        self,
        *,
        backup_policy: typing.Optional[typing.Union["CfnFileSystem.BackupPolicyProperty", _IResolvable_9ceae33e]] = None,
        encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        file_system_policy: typing.Any = None,
        file_system_tags: typing.Optional[typing.List["CfnFileSystem.ElasticFileSystemTagProperty"]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        lifecycle_policies: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnFileSystem.LifecyclePolicyProperty", _IResolvable_9ceae33e]]]] = None,
        performance_mode: typing.Optional[builtins.str] = None,
        provisioned_throughput_in_mibps: typing.Optional[jsii.Number] = None,
        throughput_mode: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EFS::FileSystem``.

        :param backup_policy: ``AWS::EFS::FileSystem.BackupPolicy``.
        :param encrypted: ``AWS::EFS::FileSystem.Encrypted``.
        :param file_system_policy: ``AWS::EFS::FileSystem.FileSystemPolicy``.
        :param file_system_tags: ``AWS::EFS::FileSystem.FileSystemTags``.
        :param kms_key_id: ``AWS::EFS::FileSystem.KmsKeyId``.
        :param lifecycle_policies: ``AWS::EFS::FileSystem.LifecyclePolicies``.
        :param performance_mode: ``AWS::EFS::FileSystem.PerformanceMode``.
        :param provisioned_throughput_in_mibps: ``AWS::EFS::FileSystem.ProvisionedThroughputInMibps``.
        :param throughput_mode: ``AWS::EFS::FileSystem.ThroughputMode``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if backup_policy is not None:
            self._values["backup_policy"] = backup_policy
        if encrypted is not None:
            self._values["encrypted"] = encrypted
        if file_system_policy is not None:
            self._values["file_system_policy"] = file_system_policy
        if file_system_tags is not None:
            self._values["file_system_tags"] = file_system_tags
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if lifecycle_policies is not None:
            self._values["lifecycle_policies"] = lifecycle_policies
        if performance_mode is not None:
            self._values["performance_mode"] = performance_mode
        if provisioned_throughput_in_mibps is not None:
            self._values["provisioned_throughput_in_mibps"] = provisioned_throughput_in_mibps
        if throughput_mode is not None:
            self._values["throughput_mode"] = throughput_mode

    @builtins.property
    def backup_policy(
        self,
    ) -> typing.Optional[typing.Union["CfnFileSystem.BackupPolicyProperty", _IResolvable_9ceae33e]]:
        """``AWS::EFS::FileSystem.BackupPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy
        """
        result = self._values.get("backup_policy")
        return result

    @builtins.property
    def encrypted(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EFS::FileSystem.Encrypted``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
        """
        result = self._values.get("encrypted")
        return result

    @builtins.property
    def file_system_policy(self) -> typing.Any:
        """``AWS::EFS::FileSystem.FileSystemPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
        """
        result = self._values.get("file_system_policy")
        return result

    @builtins.property
    def file_system_tags(
        self,
    ) -> typing.Optional[typing.List["CfnFileSystem.ElasticFileSystemTagProperty"]]:
        """``AWS::EFS::FileSystem.FileSystemTags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
        """
        result = self._values.get("file_system_tags")
        return result

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::FileSystem.KmsKeyId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
        """
        result = self._values.get("kms_key_id")
        return result

    @builtins.property
    def lifecycle_policies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnFileSystem.LifecyclePolicyProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EFS::FileSystem.LifecyclePolicies``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
        """
        result = self._values.get("lifecycle_policies")
        return result

    @builtins.property
    def performance_mode(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::FileSystem.PerformanceMode``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
        """
        result = self._values.get("performance_mode")
        return result

    @builtins.property
    def provisioned_throughput_in_mibps(self) -> typing.Optional[jsii.Number]:
        """``AWS::EFS::FileSystem.ProvisionedThroughputInMibps``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
        """
        result = self._values.get("provisioned_throughput_in_mibps")
        return result

    @builtins.property
    def throughput_mode(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::FileSystem.ThroughputMode``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
        """
        result = self._values.get("throughput_mode")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnFileSystemProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnMountTarget(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_efs.CfnMountTarget",
):
    """A CloudFormation ``AWS::EFS::MountTarget``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
    cloudformationResource:
    :cloudformationResource:: AWS::EFS::MountTarget
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        file_system_id: builtins.str,
        security_groups: typing.List[builtins.str],
        subnet_id: builtins.str,
        ip_address: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EFS::MountTarget``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param file_system_id: ``AWS::EFS::MountTarget.FileSystemId``.
        :param security_groups: ``AWS::EFS::MountTarget.SecurityGroups``.
        :param subnet_id: ``AWS::EFS::MountTarget.SubnetId``.
        :param ip_address: ``AWS::EFS::MountTarget.IpAddress``.
        """
        props = CfnMountTargetProps(
            file_system_id=file_system_id,
            security_groups=security_groups,
            subnet_id=subnet_id,
            ip_address=ip_address,
        )

        jsii.create(CfnMountTarget, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrIpAddress")
    def attr_ip_address(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: IpAddress
        """
        return jsii.get(self, "attrIpAddress")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """``AWS::EFS::MountTarget.FileSystemId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
        """
        return jsii.get(self, "fileSystemId")

    @file_system_id.setter # type: ignore
    def file_system_id(self, value: builtins.str) -> None:
        jsii.set(self, "fileSystemId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroups")
    def security_groups(self) -> typing.List[builtins.str]:
        """``AWS::EFS::MountTarget.SecurityGroups``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
        """
        return jsii.get(self, "securityGroups")

    @security_groups.setter # type: ignore
    def security_groups(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "securityGroups", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EFS::MountTarget.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipAddress")
    def ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::MountTarget.IpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
        """
        return jsii.get(self, "ipAddress")

    @ip_address.setter # type: ignore
    def ip_address(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "ipAddress", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.CfnMountTargetProps",
    jsii_struct_bases=[],
    name_mapping={
        "file_system_id": "fileSystemId",
        "security_groups": "securityGroups",
        "subnet_id": "subnetId",
        "ip_address": "ipAddress",
    },
)
class CfnMountTargetProps:
    def __init__(
        self,
        *,
        file_system_id: builtins.str,
        security_groups: typing.List[builtins.str],
        subnet_id: builtins.str,
        ip_address: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EFS::MountTarget``.

        :param file_system_id: ``AWS::EFS::MountTarget.FileSystemId``.
        :param security_groups: ``AWS::EFS::MountTarget.SecurityGroups``.
        :param subnet_id: ``AWS::EFS::MountTarget.SubnetId``.
        :param ip_address: ``AWS::EFS::MountTarget.IpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "file_system_id": file_system_id,
            "security_groups": security_groups,
            "subnet_id": subnet_id,
        }
        if ip_address is not None:
            self._values["ip_address"] = ip_address

    @builtins.property
    def file_system_id(self) -> builtins.str:
        """``AWS::EFS::MountTarget.FileSystemId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
        """
        result = self._values.get("file_system_id")
        assert result is not None, "Required property 'file_system_id' is missing"
        return result

    @builtins.property
    def security_groups(self) -> typing.List[builtins.str]:
        """``AWS::EFS::MountTarget.SecurityGroups``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
        """
        result = self._values.get("security_groups")
        assert result is not None, "Required property 'security_groups' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EFS::MountTarget.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    @builtins.property
    def ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EFS::MountTarget.IpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
        """
        result = self._values.get("ip_address")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnMountTargetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.FileSystemAttributes",
    jsii_struct_bases=[],
    name_mapping={"file_system_id": "fileSystemId", "security_group": "securityGroup"},
)
class FileSystemAttributes:
    def __init__(
        self,
        *,
        file_system_id: builtins.str,
        security_group: _ISecurityGroup_d72ab8e8,
    ) -> None:
        """Properties that describe an existing EFS file system.

        :param file_system_id: The File System's ID.
        :param security_group: The security group of the file system.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "file_system_id": file_system_id,
            "security_group": security_group,
        }

    @builtins.property
    def file_system_id(self) -> builtins.str:
        """The File System's ID.

        stability
        :stability: experimental
        """
        result = self._values.get("file_system_id")
        assert result is not None, "Required property 'file_system_id' is missing"
        return result

    @builtins.property
    def security_group(self) -> _ISecurityGroup_d72ab8e8:
        """The security group of the file system.

        stability
        :stability: experimental
        """
        result = self._values.get("security_group")
        assert result is not None, "Required property 'security_group' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FileSystemAttributes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.FileSystemProps",
    jsii_struct_bases=[],
    name_mapping={
        "vpc": "vpc",
        "encrypted": "encrypted",
        "file_system_name": "fileSystemName",
        "kms_key": "kmsKey",
        "lifecycle_policy": "lifecyclePolicy",
        "performance_mode": "performanceMode",
        "provisioned_throughput_per_second": "provisionedThroughputPerSecond",
        "removal_policy": "removalPolicy",
        "security_group": "securityGroup",
        "throughput_mode": "throughputMode",
        "vpc_subnets": "vpcSubnets",
    },
)
class FileSystemProps:
    def __init__(
        self,
        *,
        vpc: _IVpc_3795853f,
        encrypted: typing.Optional[builtins.bool] = None,
        file_system_name: typing.Optional[builtins.str] = None,
        kms_key: typing.Optional[_IKey_3336c79d] = None,
        lifecycle_policy: typing.Optional["LifecyclePolicy"] = None,
        performance_mode: typing.Optional["PerformanceMode"] = None,
        provisioned_throughput_per_second: typing.Optional[_Size_b4ccfc18] = None,
        removal_policy: typing.Optional[_RemovalPolicy_5986e9f3] = None,
        security_group: typing.Optional[_ISecurityGroup_d72ab8e8] = None,
        throughput_mode: typing.Optional["ThroughputMode"] = None,
        vpc_subnets: typing.Optional[_SubnetSelection_36a13cd6] = None,
    ) -> None:
        """Properties of EFS FileSystem.

        :param vpc: VPC to launch the file system in.
        :param encrypted: Defines if the data at rest in the file system is encrypted or not. Default: - false
        :param file_system_name: The filesystem's name. Default: - CDK generated name
        :param kms_key: The KMS key used for encryption. This is required to encrypt the data at rest if @encrypted is set to true. Default: - if
        :param lifecycle_policy: A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class. Default: - none
        :param performance_mode: Enum to mention the performance mode of the file system. Default: - GENERAL_PURPOSE
        :param provisioned_throughput_per_second: Provisioned throughput for the file system. This is a required property if the throughput mode is set to PROVISIONED. Must be at least 1MiB/s. Default: - none, errors out
        :param removal_policy: The removal policy to apply to the file system. Default: RemovalPolicy.RETAIN
        :param security_group: Security Group to assign to this file system. Default: - creates new security group which allow all out bound traffic
        :param throughput_mode: Enum to mention the throughput mode of the file system. Default: - BURSTING
        :param vpc_subnets: Which subnets to place the mount target in the VPC. Default: - the Vpc default strategy if not specified

        stability
        :stability: experimental
        """
        if isinstance(vpc_subnets, dict):
            vpc_subnets = _SubnetSelection_36a13cd6(**vpc_subnets)
        self._values: typing.Dict[str, typing.Any] = {
            "vpc": vpc,
        }
        if encrypted is not None:
            self._values["encrypted"] = encrypted
        if file_system_name is not None:
            self._values["file_system_name"] = file_system_name
        if kms_key is not None:
            self._values["kms_key"] = kms_key
        if lifecycle_policy is not None:
            self._values["lifecycle_policy"] = lifecycle_policy
        if performance_mode is not None:
            self._values["performance_mode"] = performance_mode
        if provisioned_throughput_per_second is not None:
            self._values["provisioned_throughput_per_second"] = provisioned_throughput_per_second
        if removal_policy is not None:
            self._values["removal_policy"] = removal_policy
        if security_group is not None:
            self._values["security_group"] = security_group
        if throughput_mode is not None:
            self._values["throughput_mode"] = throughput_mode
        if vpc_subnets is not None:
            self._values["vpc_subnets"] = vpc_subnets

    @builtins.property
    def vpc(self) -> _IVpc_3795853f:
        """VPC to launch the file system in.

        stability
        :stability: experimental
        """
        result = self._values.get("vpc")
        assert result is not None, "Required property 'vpc' is missing"
        return result

    @builtins.property
    def encrypted(self) -> typing.Optional[builtins.bool]:
        """Defines if the data at rest in the file system is encrypted or not.

        default
        :default: - false

        stability
        :stability: experimental
        """
        result = self._values.get("encrypted")
        return result

    @builtins.property
    def file_system_name(self) -> typing.Optional[builtins.str]:
        """The filesystem's name.

        default
        :default: - CDK generated name

        stability
        :stability: experimental
        """
        result = self._values.get("file_system_name")
        return result

    @builtins.property
    def kms_key(self) -> typing.Optional[_IKey_3336c79d]:
        """The KMS key used for encryption.

        This is required to encrypt the data at rest if @encrypted is set to true.

        default
        :default: - if

        stability
        :stability: experimental
        encrypted:
        :encrypted:: is true, the default key for EFS (/aws/elasticfilesystem) is used
        """
        result = self._values.get("kms_key")
        return result

    @builtins.property
    def lifecycle_policy(self) -> typing.Optional["LifecyclePolicy"]:
        """A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.

        default
        :default: - none

        stability
        :stability: experimental
        """
        result = self._values.get("lifecycle_policy")
        return result

    @builtins.property
    def performance_mode(self) -> typing.Optional["PerformanceMode"]:
        """Enum to mention the performance mode of the file system.

        default
        :default: - GENERAL_PURPOSE

        stability
        :stability: experimental
        """
        result = self._values.get("performance_mode")
        return result

    @builtins.property
    def provisioned_throughput_per_second(self) -> typing.Optional[_Size_b4ccfc18]:
        """Provisioned throughput for the file system.

        This is a required property if the throughput mode is set to PROVISIONED.
        Must be at least 1MiB/s.

        default
        :default: - none, errors out

        stability
        :stability: experimental
        """
        result = self._values.get("provisioned_throughput_per_second")
        return result

    @builtins.property
    def removal_policy(self) -> typing.Optional[_RemovalPolicy_5986e9f3]:
        """The removal policy to apply to the file system.

        default
        :default: RemovalPolicy.RETAIN

        stability
        :stability: experimental
        """
        result = self._values.get("removal_policy")
        return result

    @builtins.property
    def security_group(self) -> typing.Optional[_ISecurityGroup_d72ab8e8]:
        """Security Group to assign to this file system.

        default
        :default: - creates new security group which allow all out bound traffic

        stability
        :stability: experimental
        """
        result = self._values.get("security_group")
        return result

    @builtins.property
    def throughput_mode(self) -> typing.Optional["ThroughputMode"]:
        """Enum to mention the throughput mode of the file system.

        default
        :default: - BURSTING

        stability
        :stability: experimental
        """
        result = self._values.get("throughput_mode")
        return result

    @builtins.property
    def vpc_subnets(self) -> typing.Optional[_SubnetSelection_36a13cd6]:
        """Which subnets to place the mount target in the VPC.

        default
        :default: - the Vpc default strategy if not specified

        stability
        :stability: experimental
        """
        result = self._values.get("vpc_subnets")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FileSystemProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="monocdk-experiment.aws_efs.IAccessPoint")
class IAccessPoint(_IResource_72f7ee7e, typing_extensions.Protocol):
    """Represents an EFS AccessPoint.

    stability
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IAccessPointProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointArn")
    def access_point_arn(self) -> builtins.str:
        """The ARN of the AccessPoint.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointId")
    def access_point_id(self) -> builtins.str:
        """The ID of the AccessPoint.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...


class _IAccessPointProxy(
    jsii.proxy_for(_IResource_72f7ee7e) # type: ignore
):
    """Represents an EFS AccessPoint.

    stability
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk-experiment.aws_efs.IAccessPoint"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointArn")
    def access_point_arn(self) -> builtins.str:
        """The ARN of the AccessPoint.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "accessPointArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointId")
    def access_point_id(self) -> builtins.str:
        """The ID of the AccessPoint.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "accessPointId")


@jsii.interface(jsii_type="monocdk-experiment.aws_efs.IFileSystem")
class IFileSystem(
    _IConnectable_a587039f,
    _IResource_72f7ee7e,
    typing_extensions.Protocol,
):
    """Interface to implement AWS File Systems.

    stability
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _IFileSystemProxy

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """The ID of the file system, assigned by Amazon EFS.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        ...

    @builtins.property # type: ignore
    @jsii.member(jsii_name="mountTargetsAvailable")
    def mount_targets_available(self) -> _IDependable_4fc803f7:
        """Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.

        stability
        :stability: experimental
        """
        ...


class _IFileSystemProxy(
    jsii.proxy_for(_IConnectable_a587039f), # type: ignore
    jsii.proxy_for(_IResource_72f7ee7e), # type: ignore
):
    """Interface to implement AWS File Systems.

    stability
    :stability: experimental
    """

    __jsii_type__: typing.ClassVar[str] = "monocdk-experiment.aws_efs.IFileSystem"

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """The ID of the file system, assigned by Amazon EFS.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "fileSystemId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="mountTargetsAvailable")
    def mount_targets_available(self) -> _IDependable_4fc803f7:
        """Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.

        stability
        :stability: experimental
        """
        return jsii.get(self, "mountTargetsAvailable")


@jsii.enum(jsii_type="monocdk-experiment.aws_efs.LifecyclePolicy")
class LifecyclePolicy(enum.Enum):
    """EFS Lifecycle Policy, if a file is not accessed for given days, it will move to EFS Infrequent Access.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-elasticfilesystem-filesystem-lifecyclepolicies
    stability
    :stability: experimental
    """

    AFTER_7_DAYS = "AFTER_7_DAYS"
    """After 7 days of not being accessed.

    stability
    :stability: experimental
    """
    AFTER_14_DAYS = "AFTER_14_DAYS"
    """After 14 days of not being accessed.

    stability
    :stability: experimental
    """
    AFTER_30_DAYS = "AFTER_30_DAYS"
    """After 30 days of not being accessed.

    stability
    :stability: experimental
    """
    AFTER_60_DAYS = "AFTER_60_DAYS"
    """After 60 days of not being accessed.

    stability
    :stability: experimental
    """
    AFTER_90_DAYS = "AFTER_90_DAYS"
    """After 90 days of not being accessed.

    stability
    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk-experiment.aws_efs.PerformanceMode")
class PerformanceMode(enum.Enum):
    """EFS Performance mode.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
    stability
    :stability: experimental
    """

    GENERAL_PURPOSE = "GENERAL_PURPOSE"
    """This is the general purpose performance mode for most file systems.

    stability
    :stability: experimental
    """
    MAX_IO = "MAX_IO"
    """This performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies.

    stability
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_efs.PosixUser",
    jsii_struct_bases=[],
    name_mapping={"gid": "gid", "uid": "uid", "secondary_gids": "secondaryGids"},
)
class PosixUser:
    def __init__(
        self,
        *,
        gid: builtins.str,
        uid: builtins.str,
        secondary_gids: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """Represents the PosixUser.

        :param gid: The POSIX group ID used for all file system operations using this access point.
        :param uid: The POSIX user ID used for all file system operations using this access point.
        :param secondary_gids: Secondary POSIX group IDs used for all file system operations using this access point. Default: - None

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "gid": gid,
            "uid": uid,
        }
        if secondary_gids is not None:
            self._values["secondary_gids"] = secondary_gids

    @builtins.property
    def gid(self) -> builtins.str:
        """The POSIX group ID used for all file system operations using this access point.

        stability
        :stability: experimental
        """
        result = self._values.get("gid")
        assert result is not None, "Required property 'gid' is missing"
        return result

    @builtins.property
    def uid(self) -> builtins.str:
        """The POSIX user ID used for all file system operations using this access point.

        stability
        :stability: experimental
        """
        result = self._values.get("uid")
        assert result is not None, "Required property 'uid' is missing"
        return result

    @builtins.property
    def secondary_gids(self) -> typing.Optional[typing.List[builtins.str]]:
        """Secondary POSIX group IDs used for all file system operations using this access point.

        default
        :default: - None

        stability
        :stability: experimental
        """
        result = self._values.get("secondary_gids")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PosixUser(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk-experiment.aws_efs.ThroughputMode")
class ThroughputMode(enum.Enum):
    """EFS Throughput mode.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-elasticfilesystem-filesystem-throughputmode
    stability
    :stability: experimental
    """

    BURSTING = "BURSTING"
    """This mode on Amazon EFS scales as the size of the file system in the standard storage class grows.

    stability
    :stability: experimental
    """
    PROVISIONED = "PROVISIONED"
    """This mode can instantly provision the throughput of the file system (in MiB/s) independent of the amount of data stored.

    stability
    :stability: experimental
    """


@jsii.implements(IAccessPoint)
class AccessPoint(
    _Resource_884d0774,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_efs.AccessPoint",
):
    """Represents the AccessPoint.

    stability
    :stability: experimental
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        file_system: "IFileSystem",
        create_acl: typing.Optional["Acl"] = None,
        path: typing.Optional[builtins.str] = None,
        posix_user: typing.Optional["PosixUser"] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param file_system: The efs filesystem.
        :param create_acl: Specifies the POSIX IDs and permissions to apply when creating the access point's root directory. If the root directory specified by ``path`` does not exist, EFS creates the root directory and applies the permissions specified here. If the specified ``path`` does not exist, you must specify ``createAcl``. Default: - None. The directory specified by ``path`` must exist.
        :param path: Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. Default: '/'
        :param posix_user: The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point. Specify this to enforce a user identity using an access point. Default: - user identity not enforced

        stability
        :stability: experimental
        """
        props = AccessPointProps(
            file_system=file_system,
            create_acl=create_acl,
            path=path,
            posix_user=posix_user,
        )

        jsii.create(AccessPoint, self, [scope, id, props])

    @jsii.member(jsii_name="fromAccessPointId")
    @builtins.classmethod
    def from_access_point_id(
        cls,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        access_point_id: builtins.str,
    ) -> "IAccessPoint":
        """Import an existing Access Point.

        :param scope: -
        :param id: -
        :param access_point_id: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "fromAccessPointId", [scope, id, access_point_id])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointArn")
    def access_point_arn(self) -> builtins.str:
        """The ARN of the Access Point.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "accessPointArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessPointId")
    def access_point_id(self) -> builtins.str:
        """The ID of the Access Point.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "accessPointId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystem")
    def file_system(self) -> "IFileSystem":
        """The filesystem of the access point.

        stability
        :stability: experimental
        """
        return jsii.get(self, "fileSystem")


@jsii.implements(IFileSystem)
class FileSystem(
    _Resource_884d0774,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_efs.FileSystem",
):
    """The Elastic File System implementation of IFileSystem.

    It creates a new, empty file system in Amazon Elastic File System (Amazon EFS).
    It also creates mount target (AWS::EFS::MountTarget) implicitly to mount the
    EFS file system on an Amazon Elastic Compute Cloud (Amazon EC2) instance or another resource.

    see
    :see: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
    stability
    :stability: experimental
    resource:
    :resource:: AWS::EFS::FileSystem
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        vpc: _IVpc_3795853f,
        encrypted: typing.Optional[builtins.bool] = None,
        file_system_name: typing.Optional[builtins.str] = None,
        kms_key: typing.Optional[_IKey_3336c79d] = None,
        lifecycle_policy: typing.Optional["LifecyclePolicy"] = None,
        performance_mode: typing.Optional["PerformanceMode"] = None,
        provisioned_throughput_per_second: typing.Optional[_Size_b4ccfc18] = None,
        removal_policy: typing.Optional[_RemovalPolicy_5986e9f3] = None,
        security_group: typing.Optional[_ISecurityGroup_d72ab8e8] = None,
        throughput_mode: typing.Optional["ThroughputMode"] = None,
        vpc_subnets: typing.Optional[_SubnetSelection_36a13cd6] = None,
    ) -> None:
        """Constructor for creating a new EFS FileSystem.

        :param scope: -
        :param id: -
        :param vpc: VPC to launch the file system in.
        :param encrypted: Defines if the data at rest in the file system is encrypted or not. Default: - false
        :param file_system_name: The filesystem's name. Default: - CDK generated name
        :param kms_key: The KMS key used for encryption. This is required to encrypt the data at rest if @encrypted is set to true. Default: - if
        :param lifecycle_policy: A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class. Default: - none
        :param performance_mode: Enum to mention the performance mode of the file system. Default: - GENERAL_PURPOSE
        :param provisioned_throughput_per_second: Provisioned throughput for the file system. This is a required property if the throughput mode is set to PROVISIONED. Must be at least 1MiB/s. Default: - none, errors out
        :param removal_policy: The removal policy to apply to the file system. Default: RemovalPolicy.RETAIN
        :param security_group: Security Group to assign to this file system. Default: - creates new security group which allow all out bound traffic
        :param throughput_mode: Enum to mention the throughput mode of the file system. Default: - BURSTING
        :param vpc_subnets: Which subnets to place the mount target in the VPC. Default: - the Vpc default strategy if not specified

        stability
        :stability: experimental
        """
        props = FileSystemProps(
            vpc=vpc,
            encrypted=encrypted,
            file_system_name=file_system_name,
            kms_key=kms_key,
            lifecycle_policy=lifecycle_policy,
            performance_mode=performance_mode,
            provisioned_throughput_per_second=provisioned_throughput_per_second,
            removal_policy=removal_policy,
            security_group=security_group,
            throughput_mode=throughput_mode,
            vpc_subnets=vpc_subnets,
        )

        jsii.create(FileSystem, self, [scope, id, props])

    @jsii.member(jsii_name="fromFileSystemAttributes")
    @builtins.classmethod
    def from_file_system_attributes(
        cls,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        file_system_id: builtins.str,
        security_group: _ISecurityGroup_d72ab8e8,
    ) -> "IFileSystem":
        """Import an existing File System from the given properties.

        :param scope: -
        :param id: -
        :param file_system_id: The File System's ID.
        :param security_group: The security group of the file system.

        stability
        :stability: experimental
        """
        attrs = FileSystemAttributes(
            file_system_id=file_system_id, security_group=security_group
        )

        return jsii.sinvoke(cls, "fromFileSystemAttributes", [scope, id, attrs])

    @jsii.member(jsii_name="addAccessPoint")
    def add_access_point(
        self,
        id: builtins.str,
        *,
        create_acl: typing.Optional["Acl"] = None,
        path: typing.Optional[builtins.str] = None,
        posix_user: typing.Optional["PosixUser"] = None,
    ) -> "AccessPoint":
        """create access point from this filesystem.

        :param id: -
        :param create_acl: Specifies the POSIX IDs and permissions to apply when creating the access point's root directory. If the root directory specified by ``path`` does not exist, EFS creates the root directory and applies the permissions specified here. If the specified ``path`` does not exist, you must specify ``createAcl``. Default: - None. The directory specified by ``path`` must exist.
        :param path: Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. Default: '/'
        :param posix_user: The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point. Specify this to enforce a user identity using an access point. Default: - user identity not enforced

        stability
        :stability: experimental
        """
        access_point_options = AccessPointOptions(
            create_acl=create_acl, path=path, posix_user=posix_user
        )

        return jsii.invoke(self, "addAccessPoint", [id, access_point_options])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connections")
    def connections(self) -> _Connections_231f38b5:
        """The security groups/rules used to allow network connections to the file system.

        stability
        :stability: experimental
        """
        return jsii.get(self, "connections")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """The ID of the file system, assigned by Amazon EFS.

        stability
        :stability: experimental
        attribute:
        :attribute:: true
        """
        return jsii.get(self, "fileSystemId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="mountTargetsAvailable")
    def mount_targets_available(self) -> _IDependable_4fc803f7:
        """Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.

        stability
        :stability: experimental
        """
        return jsii.get(self, "mountTargetsAvailable")


__all__ = [
    "AccessPoint",
    "AccessPointOptions",
    "AccessPointProps",
    "Acl",
    "CfnAccessPoint",
    "CfnAccessPointProps",
    "CfnFileSystem",
    "CfnFileSystemProps",
    "CfnMountTarget",
    "CfnMountTargetProps",
    "FileSystem",
    "FileSystemAttributes",
    "FileSystemProps",
    "IAccessPoint",
    "IFileSystem",
    "LifecyclePolicy",
    "PerformanceMode",
    "PosixUser",
    "ThroughputMode",
]

publication.publish()
