import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

from .. import (
    AssetHashType as _AssetHashType_16f7047a,
    BundlingOptions as _BundlingOptions_0cab5223,
    CfnResource as _CfnResource_7760e8e4,
    CfnTag as _CfnTag_b4661f1a,
    Construct as _Construct_f50a3f53,
    Duration as _Duration_5170c158,
    IConstruct as _IConstruct_db0cc7e3,
    IDependable as _IDependable_4fc803f7,
    IInspectable as _IInspectable_051e6ed8,
    IResolvable as _IResolvable_9ceae33e,
    IResource as _IResource_72f7ee7e,
    Resource as _Resource_884d0774,
    ResourceProps as _ResourceProps_92be6f66,
    Size as _Size_b4ccfc18,
    Stack as _Stack_05f4505a,
    TagManager as _TagManager_2508893f,
    TreeInspector as _TreeInspector_154f5999,
)
from ..assets import FollowMode as _FollowMode_f74e7125
from ..aws_cloudwatch import (
    Metric as _Metric_53e89548,
    MetricOptions as _MetricOptions_ad2c4d5d,
    Unit as _Unit_e1b74f3c,
)
from ..aws_iam import (
    ArnPrincipal as _ArnPrincipal_943f1cc1,
    Grant as _Grant_96af6d2d,
    IGrantable as _IGrantable_0fcfc53a,
    IPrincipal as _IPrincipal_97126874,
    IRole as _IRole_e69bbae4,
    PolicyDocument as _PolicyDocument_1d1bca11,
    PolicyStatement as _PolicyStatement_f75dc775,
)
from ..aws_kms import IKey as _IKey_3336c79d
from ..aws_logs import ILogGroup as _ILogGroup_6b54c8e1
from ..aws_s3 import IBucket as _IBucket_25bad983
from ..aws_s3_assets import (
    Asset as _Asset_0139ea2c, AssetOptions as _AssetOptions_ed6c2956
)


class AclCidr(
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="monocdk-experiment.aws_ec2.AclCidr",
):
    """Either an IPv4 or an IPv6 CIDR.

    stability
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _AclCidrProxy

    def __init__(self) -> None:
        """
        stability
        :stability: experimental
        """
        jsii.create(AclCidr, self, [])

    @jsii.member(jsii_name="anyIpv4")
    @builtins.classmethod
    def any_ipv4(cls) -> "AclCidr":
        """The CIDR containing all IPv4 addresses (i.e., 0.0.0.0/0).

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "anyIpv4", [])

    @jsii.member(jsii_name="anyIpv6")
    @builtins.classmethod
    def any_ipv6(cls) -> "AclCidr":
        """The CIDR containing all IPv6 addresses (i.e., ::/0).

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "anyIpv6", [])

    @jsii.member(jsii_name="ipv4")
    @builtins.classmethod
    def ipv4(cls, ipv4_cidr: builtins.str) -> "AclCidr":
        """An IP network range in CIDR notation (for example, 172.16.0.0/24).

        :param ipv4_cidr: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "ipv4", [ipv4_cidr])

    @jsii.member(jsii_name="ipv6")
    @builtins.classmethod
    def ipv6(cls, ipv6_cidr: builtins.str) -> "AclCidr":
        """An IPv6 network range in CIDR notation (for example, 2001:db8::/48).

        :param ipv6_cidr: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "ipv6", [ipv6_cidr])

    @jsii.member(jsii_name="toCidrConfig")
    @abc.abstractmethod
    def to_cidr_config(self) -> "AclCidrConfig":
        """
        stability
        :stability: experimental
        """
        ...


class _AclCidrProxy(AclCidr):
    @jsii.member(jsii_name="toCidrConfig")
    def to_cidr_config(self) -> "AclCidrConfig":
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toCidrConfig", [])


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.AclCidrConfig",
    jsii_struct_bases=[],
    name_mapping={"cidr_block": "cidrBlock", "ipv6_cidr_block": "ipv6CidrBlock"},
)
class AclCidrConfig:
    def __init__(
        self,
        *,
        cidr_block: typing.Optional[builtins.str] = None,
        ipv6_cidr_block: typing.Optional[builtins.str] = None,
    ) -> None:
        """Acl Configuration for CIDR.

        :param cidr_block: Ipv4 CIDR.
        :param ipv6_cidr_block: Ipv6 CIDR.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cidr_block is not None:
            self._values["cidr_block"] = cidr_block
        if ipv6_cidr_block is not None:
            self._values["ipv6_cidr_block"] = ipv6_cidr_block

    @builtins.property
    def cidr_block(self) -> typing.Optional[builtins.str]:
        """Ipv4 CIDR.

        stability
        :stability: experimental
        """
        result = self._values.get("cidr_block")
        return result

    @builtins.property
    def ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """Ipv6 CIDR.

        stability
        :stability: experimental
        """
        result = self._values.get("ipv6_cidr_block")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AclCidrConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.AclIcmp",
    jsii_struct_bases=[],
    name_mapping={"code": "code", "type": "type"},
)
class AclIcmp:
    def __init__(
        self,
        *,
        code: typing.Optional[jsii.Number] = None,
        type: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Properties to create Icmp.

        :param code: The Internet Control Message Protocol (ICMP) code. You can use -1 to specify all ICMP codes for the given ICMP type. Requirement is conditional: Required if you specify 1 (ICMP) for the protocol parameter.
        :param type: The Internet Control Message Protocol (ICMP) type. You can use -1 to specify all ICMP types. Conditional requirement: Required if you specify 1 (ICMP) for the CreateNetworkAclEntry protocol parameter.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if code is not None:
            self._values["code"] = code
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def code(self) -> typing.Optional[jsii.Number]:
        """The Internet Control Message Protocol (ICMP) code.

        You can use -1 to specify all ICMP
        codes for the given ICMP type. Requirement is conditional: Required if you
        specify 1 (ICMP) for the protocol parameter.

        stability
        :stability: experimental
        """
        result = self._values.get("code")
        return result

    @builtins.property
    def type(self) -> typing.Optional[jsii.Number]:
        """The Internet Control Message Protocol (ICMP) type.

        You can use -1 to specify all ICMP types.
        Conditional requirement: Required if you specify 1 (ICMP) for the CreateNetworkAclEntry protocol parameter.

        stability
        :stability: experimental
        """
        result = self._values.get("type")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AclIcmp(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.AclPortRange",
    jsii_struct_bases=[],
    name_mapping={"from_": "from", "to": "to"},
)
class AclPortRange:
    def __init__(
        self,
        *,
        from_: typing.Optional[jsii.Number] = None,
        to: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Properties to create PortRange.

        :param from_: The first port in the range. Required if you specify 6 (TCP) or 17 (UDP) for the protocol parameter.
        :param to: The last port in the range. Required if you specify 6 (TCP) or 17 (UDP) for the protocol parameter.

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if from_ is not None:
            self._values["from_"] = from_
        if to is not None:
            self._values["to"] = to

    @builtins.property
    def from_(self) -> typing.Optional[jsii.Number]:
        """The first port in the range.

        Required if you specify 6 (TCP) or 17 (UDP) for the protocol parameter.

        stability
        :stability: experimental
        """
        result = self._values.get("from_")
        return result

    @builtins.property
    def to(self) -> typing.Optional[jsii.Number]:
        """The last port in the range.

        Required if you specify 6 (TCP) or 17 (UDP) for the protocol parameter.

        stability
        :stability: experimental
        """
        result = self._values.get("to")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AclPortRange(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AclTraffic(
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="monocdk-experiment.aws_ec2.AclTraffic",
):
    """The traffic that is configured using a Network ACL entry.

    stability
    :stability: experimental
    """

    @builtins.staticmethod
    def __jsii_proxy_class__():
        return _AclTrafficProxy

    def __init__(self) -> None:
        """
        stability
        :stability: experimental
        """
        jsii.create(AclTraffic, self, [])

    @jsii.member(jsii_name="allTraffic")
    @builtins.classmethod
    def all_traffic(cls) -> "AclTraffic":
        """Apply the ACL entry to all traffic.

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "allTraffic", [])

    @jsii.member(jsii_name="icmp")
    @builtins.classmethod
    def icmp(
        cls,
        *,
        code: typing.Optional[jsii.Number] = None,
        type: typing.Optional[jsii.Number] = None,
    ) -> "AclTraffic":
        """Apply the ACL entry to ICMP traffic of given type and code.

        :param code: The Internet Control Message Protocol (ICMP) code. You can use -1 to specify all ICMP codes for the given ICMP type. Requirement is conditional: Required if you specify 1 (ICMP) for the protocol parameter.
        :param type: The Internet Control Message Protocol (ICMP) type. You can use -1 to specify all ICMP types. Conditional requirement: Required if you specify 1 (ICMP) for the CreateNetworkAclEntry protocol parameter.

        stability
        :stability: experimental
        """
        props = AclIcmp(code=code, type=type)

        return jsii.sinvoke(cls, "icmp", [props])

    @jsii.member(jsii_name="icmpv6")
    @builtins.classmethod
    def icmpv6(
        cls,
        *,
        code: typing.Optional[jsii.Number] = None,
        type: typing.Optional[jsii.Number] = None,
    ) -> "AclTraffic":
        """Apply the ACL entry to ICMPv6 traffic of given type and code.

        Requires an IPv6 CIDR block.

        :param code: The Internet Control Message Protocol (ICMP) code. You can use -1 to specify all ICMP codes for the given ICMP type. Requirement is conditional: Required if you specify 1 (ICMP) for the protocol parameter.
        :param type: The Internet Control Message Protocol (ICMP) type. You can use -1 to specify all ICMP types. Conditional requirement: Required if you specify 1 (ICMP) for the CreateNetworkAclEntry protocol parameter.

        stability
        :stability: experimental
        """
        props = AclIcmp(code=code, type=type)

        return jsii.sinvoke(cls, "icmpv6", [props])

    @jsii.member(jsii_name="tcpPort")
    @builtins.classmethod
    def tcp_port(cls, port: jsii.Number) -> "AclTraffic":
        """Apply the ACL entry to TCP traffic on a given port.

        :param port: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "tcpPort", [port])

    @jsii.member(jsii_name="tcpPortRange")
    @builtins.classmethod
    def tcp_port_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "AclTraffic":
        """Apply the ACL entry to TCP traffic on a given port range.

        :param start_port: -
        :param end_port: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "tcpPortRange", [start_port, end_port])

    @jsii.member(jsii_name="udpPort")
    @builtins.classmethod
    def udp_port(cls, port: jsii.Number) -> "AclTraffic":
        """Apply the ACL entry to UDP traffic on a given port.

        :param port: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "udpPort", [port])

    @jsii.member(jsii_name="udpPortRange")
    @builtins.classmethod
    def udp_port_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "AclTraffic":
        """Apply the ACL entry to UDP traffic on a given port range.

        :param start_port: -
        :param end_port: -

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "udpPortRange", [start_port, end_port])

    @jsii.member(jsii_name="toTrafficConfig")
    @abc.abstractmethod
    def to_traffic_config(self) -> "AclTrafficConfig":
        """
        stability
        :stability: experimental
        """
        ...


class _AclTrafficProxy(AclTraffic):
    @jsii.member(jsii_name="toTrafficConfig")
    def to_traffic_config(self) -> "AclTrafficConfig":
        """
        stability
        :stability: experimental
        """
        return jsii.invoke(self, "toTrafficConfig", [])


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.AclTrafficConfig",
    jsii_struct_bases=[],
    name_mapping={"protocol": "protocol", "icmp": "icmp", "port_range": "portRange"},
)
class AclTrafficConfig:
    def __init__(
        self,
        *,
        protocol: jsii.Number,
        icmp: typing.Optional["AclIcmp"] = None,
        port_range: typing.Optional["AclPortRange"] = None,
    ) -> None:
        """Acl Configuration for traffic.

        :param protocol: The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code. Default: 17
        :param icmp: The Internet Control Message Protocol (ICMP) code and type. Default: - Required if specifying 1 (ICMP) for the protocol parameter.
        :param port_range: The range of port numbers for the UDP/TCP protocol. Default: - Required if specifying 6 (TCP) or 17 (UDP) for the protocol parameter

        stability
        :stability: experimental
        """
        if isinstance(icmp, dict):
            icmp = AclIcmp(**icmp)
        if isinstance(port_range, dict):
            port_range = AclPortRange(**port_range)
        self._values: typing.Dict[str, typing.Any] = {
            "protocol": protocol,
        }
        if icmp is not None:
            self._values["icmp"] = icmp
        if port_range is not None:
            self._values["port_range"] = port_range

    @builtins.property
    def protocol(self) -> jsii.Number:
        """The protocol number.

        A value of "-1" means all protocols.

        If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP),
        or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
        ICMP types or codes that you specify.

        If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
        block, traffic for all ICMP types and codes allowed, regardless of any that
        you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
        block, you must specify an ICMP type and code.

        default
        :default: 17

        stability
        :stability: experimental
        """
        result = self._values.get("protocol")
        assert result is not None, "Required property 'protocol' is missing"
        return result

    @builtins.property
    def icmp(self) -> typing.Optional["AclIcmp"]:
        """The Internet Control Message Protocol (ICMP) code and type.

        default
        :default: - Required if specifying 1 (ICMP) for the protocol parameter.

        stability
        :stability: experimental
        """
        result = self._values.get("icmp")
        return result

    @builtins.property
    def port_range(self) -> typing.Optional["AclPortRange"]:
        """The range of port numbers for the UDP/TCP protocol.

        default
        :default: - Required if specifying 6 (TCP) or 17 (UDP) for the protocol parameter

        stability
        :stability: experimental
        """
        result = self._values.get("port_range")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AclTrafficConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk-experiment.aws_ec2.Action")
class Action(enum.Enum):
    """What action to apply to traffic matching the ACL.

    stability
    :stability: experimental
    """

    ALLOW = "ALLOW"
    """Allow the traffic.

    stability
    :stability: experimental
    """
    DENY = "DENY"
    """Deny the traffic.

    stability
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.AddRouteOptions",
    jsii_struct_bases=[],
    name_mapping={
        "router_id": "routerId",
        "router_type": "routerType",
        "destination_cidr_block": "destinationCidrBlock",
        "destination_ipv6_cidr_block": "destinationIpv6CidrBlock",
        "enables_internet_connectivity": "enablesInternetConnectivity",
    },
)
class AddRouteOptions:
    def __init__(
        self,
        *,
        router_id: builtins.str,
        router_type: "RouterType",
        destination_cidr_block: typing.Optional[builtins.str] = None,
        destination_ipv6_cidr_block: typing.Optional[builtins.str] = None,
        enables_internet_connectivity: typing.Optional[builtins.bool] = None,
    ) -> None:
        """Options for adding a new route to a subnet.

        :param router_id: The ID of the router. Can be an instance ID, gateway ID, etc, depending on the router type.
        :param router_type: What type of router to route this traffic to.
        :param destination_cidr_block: IPv4 range this route applies to. Default: '0.0.0.0/0'
        :param destination_ipv6_cidr_block: IPv6 range this route applies to. Default: - Uses IPv6
        :param enables_internet_connectivity: Whether this route will enable internet connectivity. If true, this route will be added before any AWS resources that depend on internet connectivity in the VPC will be created. Default: false

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "router_id": router_id,
            "router_type": router_type,
        }
        if destination_cidr_block is not None:
            self._values["destination_cidr_block"] = destination_cidr_block
        if destination_ipv6_cidr_block is not None:
            self._values["destination_ipv6_cidr_block"] = destination_ipv6_cidr_block
        if enables_internet_connectivity is not None:
            self._values["enables_internet_connectivity"] = enables_internet_connectivity

    @builtins.property
    def router_id(self) -> builtins.str:
        """The ID of the router.

        Can be an instance ID, gateway ID, etc, depending on the router type.

        stability
        :stability: experimental
        """
        result = self._values.get("router_id")
        assert result is not None, "Required property 'router_id' is missing"
        return result

    @builtins.property
    def router_type(self) -> "RouterType":
        """What type of router to route this traffic to.

        stability
        :stability: experimental
        """
        result = self._values.get("router_type")
        assert result is not None, "Required property 'router_type' is missing"
        return result

    @builtins.property
    def destination_cidr_block(self) -> typing.Optional[builtins.str]:
        """IPv4 range this route applies to.

        default
        :default: '0.0.0.0/0'

        stability
        :stability: experimental
        """
        result = self._values.get("destination_cidr_block")
        return result

    @builtins.property
    def destination_ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """IPv6 range this route applies to.

        default
        :default: - Uses IPv6

        stability
        :stability: experimental
        """
        result = self._values.get("destination_ipv6_cidr_block")
        return result

    @builtins.property
    def enables_internet_connectivity(self) -> typing.Optional[builtins.bool]:
        """Whether this route will enable internet connectivity.

        If true, this route will be added before any AWS resources that depend
        on internet connectivity in the VPC will be created.

        default
        :default: false

        stability
        :stability: experimental
        """
        result = self._values.get("enables_internet_connectivity")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddRouteOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk-experiment.aws_ec2.AmazonLinuxCpuType")
class AmazonLinuxCpuType(enum.Enum):
    """CPU type.

    stability
    :stability: experimental
    """

    ARM_64 = "ARM_64"
    """arm64 CPU type.

    stability
    :stability: experimental
    """
    X86_64 = "X86_64"
    """x86_64 CPU type.

    stability
    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk-experiment.aws_ec2.AmazonLinuxEdition")
class AmazonLinuxEdition(enum.Enum):
    """Amazon Linux edition.

    stability
    :stability: experimental
    """

    STANDARD = "STANDARD"
    """Standard edition.

    stability
    :stability: experimental
    """
    MINIMAL = "MINIMAL"
    """Minimal edition.

    stability
    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk-experiment.aws_ec2.AmazonLinuxGeneration")
class AmazonLinuxGeneration(enum.Enum):
    """What generation of Amazon Linux to use.

    stability
    :stability: experimental
    """

    AMAZON_LINUX = "AMAZON_LINUX"
    """Amazon Linux.

    stability
    :stability: experimental
    """
    AMAZON_LINUX_2 = "AMAZON_LINUX_2"
    """Amazon Linux 2.

    stability
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.AmazonLinuxImageProps",
    jsii_struct_bases=[],
    name_mapping={
        "cpu_type": "cpuType",
        "edition": "edition",
        "generation": "generation",
        "storage": "storage",
        "user_data": "userData",
        "virtualization": "virtualization",
    },
)
class AmazonLinuxImageProps:
    def __init__(
        self,
        *,
        cpu_type: typing.Optional["AmazonLinuxCpuType"] = None,
        edition: typing.Optional["AmazonLinuxEdition"] = None,
        generation: typing.Optional["AmazonLinuxGeneration"] = None,
        storage: typing.Optional["AmazonLinuxStorage"] = None,
        user_data: typing.Optional["UserData"] = None,
        virtualization: typing.Optional["AmazonLinuxVirt"] = None,
    ) -> None:
        """Amazon Linux image properties.

        :param cpu_type: CPU Type. Default: X86_64
        :param edition: What edition of Amazon Linux to use. Default: Standard
        :param generation: What generation of Amazon Linux to use. Default: AmazonLinux
        :param storage: What storage backed image to use. Default: GeneralPurpose
        :param user_data: Initial user data. Default: - Empty UserData for Linux machines
        :param virtualization: Virtualization type. Default: HVM

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if cpu_type is not None:
            self._values["cpu_type"] = cpu_type
        if edition is not None:
            self._values["edition"] = edition
        if generation is not None:
            self._values["generation"] = generation
        if storage is not None:
            self._values["storage"] = storage
        if user_data is not None:
            self._values["user_data"] = user_data
        if virtualization is not None:
            self._values["virtualization"] = virtualization

    @builtins.property
    def cpu_type(self) -> typing.Optional["AmazonLinuxCpuType"]:
        """CPU Type.

        default
        :default: X86_64

        stability
        :stability: experimental
        """
        result = self._values.get("cpu_type")
        return result

    @builtins.property
    def edition(self) -> typing.Optional["AmazonLinuxEdition"]:
        """What edition of Amazon Linux to use.

        default
        :default: Standard

        stability
        :stability: experimental
        """
        result = self._values.get("edition")
        return result

    @builtins.property
    def generation(self) -> typing.Optional["AmazonLinuxGeneration"]:
        """What generation of Amazon Linux to use.

        default
        :default: AmazonLinux

        stability
        :stability: experimental
        """
        result = self._values.get("generation")
        return result

    @builtins.property
    def storage(self) -> typing.Optional["AmazonLinuxStorage"]:
        """What storage backed image to use.

        default
        :default: GeneralPurpose

        stability
        :stability: experimental
        """
        result = self._values.get("storage")
        return result

    @builtins.property
    def user_data(self) -> typing.Optional["UserData"]:
        """Initial user data.

        default
        :default: - Empty UserData for Linux machines

        stability
        :stability: experimental
        """
        result = self._values.get("user_data")
        return result

    @builtins.property
    def virtualization(self) -> typing.Optional["AmazonLinuxVirt"]:
        """Virtualization type.

        default
        :default: HVM

        stability
        :stability: experimental
        """
        result = self._values.get("virtualization")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmazonLinuxImageProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="monocdk-experiment.aws_ec2.AmazonLinuxStorage")
class AmazonLinuxStorage(enum.Enum):
    """
    stability
    :stability: experimental
    """

    EBS = "EBS"
    """EBS-backed storage.

    stability
    :stability: experimental
    """
    GENERAL_PURPOSE = "GENERAL_PURPOSE"
    """General Purpose-based storage (recommended).

    stability
    :stability: experimental
    """


@jsii.enum(jsii_type="monocdk-experiment.aws_ec2.AmazonLinuxVirt")
class AmazonLinuxVirt(enum.Enum):
    """Virtualization type for Amazon Linux.

    stability
    :stability: experimental
    """

    HVM = "HVM"
    """HVM virtualization (recommended).

    stability
    :stability: experimental
    """
    PV = "PV"
    """PV virtualization.

    stability
    :stability: experimental
    """


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.ApplyCloudFormationInitOptions",
    jsii_struct_bases=[],
    name_mapping={
        "config_sets": "configSets",
        "embed_fingerprint": "embedFingerprint",
        "ignore_failures": "ignoreFailures",
        "print_log": "printLog",
        "timeout": "timeout",
    },
)
class ApplyCloudFormationInitOptions:
    def __init__(
        self,
        *,
        config_sets: typing.Optional[typing.List[builtins.str]] = None,
        embed_fingerprint: typing.Optional[builtins.bool] = None,
        ignore_failures: typing.Optional[builtins.bool] = None,
        print_log: typing.Optional[builtins.bool] = None,
        timeout: typing.Optional[_Duration_5170c158] = None,
    ) -> None:
        """Options for applying CloudFormation init to an instance or instance group.

        :param config_sets: ConfigSet to activate. Default: ['default']
        :param embed_fingerprint: Force instance replacement by embedding a config fingerprint. If ``true`` (the default), a hash of the config will be embedded into the UserData, so that if the config changes, the UserData changes. - If the EC2 instance is instance-store backed or ``userDataCausesReplacement`` is set, this will cause the instance to be replaced and the new configuration to be applied. - If the instance is EBS-backed and ``userDataCausesReplacement`` is not set, the change of UserData will make the instance restart but not be replaced, and the configuration will not be applied automatically. If ``false``, no hash will be embedded, and if the CloudFormation Init config changes nothing will happen to the running instance. If a config update introduces errors, you will not notice until after the CloudFormation deployment successfully finishes and the next instance fails to launch. Default: true
        :param ignore_failures: Don't fail the instance creation when cfn-init fails. You can use this to prevent CloudFormation from rolling back when instances fail to start up, to help in debugging. Default: false
        :param print_log: Print the results of running cfn-init to the Instance System Log. By default, the output of running cfn-init is written to a log file on the instance. Set this to ``true`` to print it to the System Log (visible from the EC2 Console), ``false`` to not print it. (Be aware that the system log is refreshed at certain points in time of the instance life cycle, and successful execution may not always show up). Default: true
        :param timeout: Timeout waiting for the configuration to be applied. Default: Duration.minutes(5)

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if config_sets is not None:
            self._values["config_sets"] = config_sets
        if embed_fingerprint is not None:
            self._values["embed_fingerprint"] = embed_fingerprint
        if ignore_failures is not None:
            self._values["ignore_failures"] = ignore_failures
        if print_log is not None:
            self._values["print_log"] = print_log
        if timeout is not None:
            self._values["timeout"] = timeout

    @builtins.property
    def config_sets(self) -> typing.Optional[typing.List[builtins.str]]:
        """ConfigSet to activate.

        default
        :default: ['default']

        stability
        :stability: experimental
        """
        result = self._values.get("config_sets")
        return result

    @builtins.property
    def embed_fingerprint(self) -> typing.Optional[builtins.bool]:
        """Force instance replacement by embedding a config fingerprint.

        If ``true`` (the default), a hash of the config will be embedded into the
        UserData, so that if the config changes, the UserData changes.

        - If the EC2 instance is instance-store backed or
          ``userDataCausesReplacement`` is set, this will cause the instance to be
          replaced and the new configuration to be applied.
        - If the instance is EBS-backed and ``userDataCausesReplacement`` is not
          set, the change of UserData will make the instance restart but not be
          replaced, and the configuration will not be applied automatically.

        If ``false``, no hash will be embedded, and if the CloudFormation Init
        config changes nothing will happen to the running instance. If a
        config update introduces errors, you will not notice until after the
        CloudFormation deployment successfully finishes and the next instance
        fails to launch.

        default
        :default: true

        stability
        :stability: experimental
        """
        result = self._values.get("embed_fingerprint")
        return result

    @builtins.property
    def ignore_failures(self) -> typing.Optional[builtins.bool]:
        """Don't fail the instance creation when cfn-init fails.

        You can use this to prevent CloudFormation from rolling back when
        instances fail to start up, to help in debugging.

        default
        :default: false

        stability
        :stability: experimental
        """
        result = self._values.get("ignore_failures")
        return result

    @builtins.property
    def print_log(self) -> typing.Optional[builtins.bool]:
        """Print the results of running cfn-init to the Instance System Log.

        By default, the output of running cfn-init is written to a log file
        on the instance. Set this to ``true`` to print it to the System Log
        (visible from the EC2 Console), ``false`` to not print it.

        (Be aware that the system log is refreshed at certain points in
        time of the instance life cycle, and successful execution may
        not always show up).

        default
        :default: true

        stability
        :stability: experimental
        """
        result = self._values.get("print_log")
        return result

    @builtins.property
    def timeout(self) -> typing.Optional[_Duration_5170c158]:
        """Timeout waiting for the configuration to be applied.

        default
        :default: Duration.minutes(5)

        stability
        :stability: experimental
        """
        result = self._values.get("timeout")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApplyCloudFormationInitOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.BastionHostLinuxProps",
    jsii_struct_bases=[],
    name_mapping={
        "vpc": "vpc",
        "availability_zone": "availabilityZone",
        "block_devices": "blockDevices",
        "instance_name": "instanceName",
        "instance_type": "instanceType",
        "machine_image": "machineImage",
        "security_group": "securityGroup",
        "subnet_selection": "subnetSelection",
    },
)
class BastionHostLinuxProps:
    def __init__(
        self,
        *,
        vpc: "IVpc",
        availability_zone: typing.Optional[builtins.str] = None,
        block_devices: typing.Optional[typing.List["BlockDevice"]] = None,
        instance_name: typing.Optional[builtins.str] = None,
        instance_type: typing.Optional["InstanceType"] = None,
        machine_image: typing.Optional["IMachineImage"] = None,
        security_group: typing.Optional["ISecurityGroup"] = None,
        subnet_selection: typing.Optional["SubnetSelection"] = None,
    ) -> None:
        """Properties of the bastion host.

        :param vpc: VPC to launch the instance in.
        :param availability_zone: In which AZ to place the instance within the VPC. Default: - Random zone.
        :param block_devices: Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. Each instance that is launched has an associated root device volume, either an Amazon EBS volume or an instance store volume. You can use block device mappings to specify additional EBS volumes or instance store volumes to attach to an instance when it is launched. Default: - Uses the block device mapping of the AMI
        :param instance_name: The name of the instance. Default: 'BastionHost'
        :param instance_type: Type of instance to launch. Default: 't3.nano'
        :param machine_image: The machine image to use. Default: - An Amazon Linux 2 image which is kept up-to-date automatically (the instance may be replaced on every deployment).
        :param security_group: Security Group to assign to this instance. Default: - create new security group with no inbound and all outbound traffic allowed
        :param subnet_selection: Select the subnets to run the bastion host in. Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM. You have to allow port 22 manually by using the connections field Default: - private subnets of the supplied VPC

        stability
        :stability: experimental
        """
        if isinstance(subnet_selection, dict):
            subnet_selection = SubnetSelection(**subnet_selection)
        self._values: typing.Dict[str, typing.Any] = {
            "vpc": vpc,
        }
        if availability_zone is not None:
            self._values["availability_zone"] = availability_zone
        if block_devices is not None:
            self._values["block_devices"] = block_devices
        if instance_name is not None:
            self._values["instance_name"] = instance_name
        if instance_type is not None:
            self._values["instance_type"] = instance_type
        if machine_image is not None:
            self._values["machine_image"] = machine_image
        if security_group is not None:
            self._values["security_group"] = security_group
        if subnet_selection is not None:
            self._values["subnet_selection"] = subnet_selection

    @builtins.property
    def vpc(self) -> "IVpc":
        """VPC to launch the instance in.

        stability
        :stability: experimental
        """
        result = self._values.get("vpc")
        assert result is not None, "Required property 'vpc' is missing"
        return result

    @builtins.property
    def availability_zone(self) -> typing.Optional[builtins.str]:
        """In which AZ to place the instance within the VPC.

        default
        :default: - Random zone.

        stability
        :stability: experimental
        """
        result = self._values.get("availability_zone")
        return result

    @builtins.property
    def block_devices(self) -> typing.Optional[typing.List["BlockDevice"]]:
        """Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.

        Each instance that is launched has an associated root device volume,
        either an Amazon EBS volume or an instance store volume.
        You can use block device mappings to specify additional EBS volumes or
        instance store volumes to attach to an instance when it is launched.

        default
        :default: - Uses the block device mapping of the AMI

        see
        :see: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
        stability
        :stability: experimental
        """
        result = self._values.get("block_devices")
        return result

    @builtins.property
    def instance_name(self) -> typing.Optional[builtins.str]:
        """The name of the instance.

        default
        :default: 'BastionHost'

        stability
        :stability: experimental
        """
        result = self._values.get("instance_name")
        return result

    @builtins.property
    def instance_type(self) -> typing.Optional["InstanceType"]:
        """Type of instance to launch.

        default
        :default: 't3.nano'

        stability
        :stability: experimental
        """
        result = self._values.get("instance_type")
        return result

    @builtins.property
    def machine_image(self) -> typing.Optional["IMachineImage"]:
        """The machine image to use.

        default
        :default:

        - An Amazon Linux 2 image which is kept up-to-date automatically (the instance
          may be replaced on every deployment).

        stability
        :stability: experimental
        """
        result = self._values.get("machine_image")
        return result

    @builtins.property
    def security_group(self) -> typing.Optional["ISecurityGroup"]:
        """Security Group to assign to this instance.

        default
        :default: - create new security group with no inbound and all outbound traffic allowed

        stability
        :stability: experimental
        """
        result = self._values.get("security_group")
        return result

    @builtins.property
    def subnet_selection(self) -> typing.Optional["SubnetSelection"]:
        """Select the subnets to run the bastion host in.

        Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM.
        You have to allow port 22 manually by using the connections field

        default
        :default: - private subnets of the supplied VPC

        stability
        :stability: experimental
        """
        result = self._values.get("subnet_selection")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BastionHostLinuxProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.BlockDevice",
    jsii_struct_bases=[],
    name_mapping={
        "device_name": "deviceName",
        "volume": "volume",
        "mapping_enabled": "mappingEnabled",
    },
)
class BlockDevice:
    def __init__(
        self,
        *,
        device_name: builtins.str,
        volume: "BlockDeviceVolume",
        mapping_enabled: typing.Optional[builtins.bool] = None,
    ) -> None:
        """Block device.

        :param device_name: The device name exposed to the EC2 instance.
        :param volume: Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume.
        :param mapping_enabled: If false, the device mapping will be suppressed. If set to false for the root device, the instance might fail the Amazon EC2 health check. Amazon EC2 Auto Scaling launches a replacement instance if the instance fails the health check. Default: true - device mapping is left untouched

        stability
        :stability: experimental
        """
        self._values: typing.Dict[str, typing.Any] = {
            "device_name": device_name,
            "volume": volume,
        }
        if mapping_enabled is not None:
            self._values["mapping_enabled"] = mapping_enabled

    @builtins.property
    def device_name(self) -> builtins.str:
        """The device name exposed to the EC2 instance.

        see
        :see: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html
        stability
        :stability: experimental

        Example::

            # Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
            "/dev/sdh" , "xvdh"
        """
        result = self._values.get("device_name")
        assert result is not None, "Required property 'device_name' is missing"
        return result

    @builtins.property
    def volume(self) -> "BlockDeviceVolume":
        """Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume.

        stability
        :stability: experimental

        Example::

            # Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
            BlockDeviceVolume.ebs(15) , BlockDeviceVolume.ephemeral(0)
        """
        result = self._values.get("volume")
        assert result is not None, "Required property 'volume' is missing"
        return result

    @builtins.property
    def mapping_enabled(self) -> typing.Optional[builtins.bool]:
        """If false, the device mapping will be suppressed.

        If set to false for the root device, the instance might fail the Amazon EC2 health check.
        Amazon EC2 Auto Scaling launches a replacement instance if the instance fails the health check.

        default
        :default: true - device mapping is left untouched

        stability
        :stability: experimental
        """
        result = self._values.get("mapping_enabled")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class BlockDeviceVolume(
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.BlockDeviceVolume",
):
    """Describes a block device mapping for an EC2 instance or Auto Scaling group.

    stability
    :stability: experimental
    """

    def __init__(
        self,
        ebs_device: typing.Optional["EbsDeviceProps"] = None,
        virtual_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """
        :param ebs_device: EBS device info.
        :param virtual_name: Virtual device name.

        stability
        :stability: experimental
        """
        jsii.create(BlockDeviceVolume, self, [ebs_device, virtual_name])

    @jsii.member(jsii_name="ebs")
    @builtins.classmethod
    def ebs(
        cls,
        volume_size: jsii.Number,
        *,
        encrypted: typing.Optional[builtins.bool] = None,
        delete_on_termination: typing.Optional[builtins.bool] = None,
        iops: typing.Optional[jsii.Number] = None,
        volume_type: typing.Optional["EbsDeviceVolumeType"] = None,
    ) -> "BlockDeviceVolume":
        """Creates a new Elastic Block Storage device.

        :param volume_size: The volume size, in Gibibytes (GiB).
        :param encrypted: Specifies whether the EBS volume is encrypted. Encrypted EBS volumes can only be attached to instances that support Amazon EBS encryption Default: false
        :param delete_on_termination: Indicates whether to delete the volume when the instance is terminated. Default: - true for Amazon EC2 Auto Scaling, false otherwise (e.g. EBS)
        :param iops: The number of I/O operations per second (IOPS) to provision for the volume. Must only be set for {@link volumeType}: {@link EbsDeviceVolumeType.IO1} The maximum ratio of IOPS to volume size (in GiB) is 50:1, so for 5,000 provisioned IOPS, you need at least 100 GiB storage on the volume. Default: - none, required for {@link EbsDeviceVolumeType.IO1}
        :param volume_type: The EBS volume type. Default: {@link EbsDeviceVolumeType.GP2}

        stability
        :stability: experimental
        """
        options = EbsDeviceOptions(
            encrypted=encrypted,
            delete_on_termination=delete_on_termination,
            iops=iops,
            volume_type=volume_type,
        )

        return jsii.sinvoke(cls, "ebs", [volume_size, options])

    @jsii.member(jsii_name="ebsFromSnapshot")
    @builtins.classmethod
    def ebs_from_snapshot(
        cls,
        snapshot_id: builtins.str,
        *,
        volume_size: typing.Optional[jsii.Number] = None,
        delete_on_termination: typing.Optional[builtins.bool] = None,
        iops: typing.Optional[jsii.Number] = None,
        volume_type: typing.Optional["EbsDeviceVolumeType"] = None,
    ) -> "BlockDeviceVolume":
        """Creates a new Elastic Block Storage device from an existing snapshot.

        :param snapshot_id: The snapshot ID of the volume to use.
        :param volume_size: The volume size, in Gibibytes (GiB). If you specify volumeSize, it must be equal or greater than the size of the snapshot. Default: - The snapshot size
        :param delete_on_termination: Indicates whether to delete the volume when the instance is terminated. Default: - true for Amazon EC2 Auto Scaling, false otherwise (e.g. EBS)
        :param iops: The number of I/O operations per second (IOPS) to provision for the volume. Must only be set for {@link volumeType}: {@link EbsDeviceVolumeType.IO1} The maximum ratio of IOPS to volume size (in GiB) is 50:1, so for 5,000 provisioned IOPS, you need at least 100 GiB storage on the volume. Default: - none, required for {@link EbsDeviceVolumeType.IO1}
        :param volume_type: The EBS volume type. Default: {@link EbsDeviceVolumeType.GP2}

        stability
        :stability: experimental
        """
        options = EbsDeviceSnapshotOptions(
            volume_size=volume_size,
            delete_on_termination=delete_on_termination,
            iops=iops,
            volume_type=volume_type,
        )

        return jsii.sinvoke(cls, "ebsFromSnapshot", [snapshot_id, options])

    @jsii.member(jsii_name="ephemeral")
    @builtins.classmethod
    def ephemeral(cls, volume_index: jsii.Number) -> "BlockDeviceVolume":
        """Creates a virtual, ephemeral device.

        The name will be in the form ephemeral{volumeIndex}.

        :param volume_index: the volume index. Must be equal or greater than 0

        stability
        :stability: experimental
        """
        return jsii.sinvoke(cls, "ephemeral", [volume_index])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ebsDevice")
    def ebs_device(self) -> typing.Optional["EbsDeviceProps"]:
        """EBS device info.

        stability
        :stability: experimental
        """
        return jsii.get(self, "ebsDevice")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualName")
    def virtual_name(self) -> typing.Optional[builtins.str]:
        """Virtual device name.

        stability
        :stability: experimental
        """
        return jsii.get(self, "virtualName")


@jsii.implements(_IInspectable_051e6ed8)
class CfnCapacityReservation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnCapacityReservation",
):
    """A CloudFormation ``AWS::EC2::CapacityReservation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::CapacityReservation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        availability_zone: builtins.str,
        instance_count: jsii.Number,
        instance_platform: builtins.str,
        instance_type: builtins.str,
        ebs_optimized: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        end_date: typing.Optional[builtins.str] = None,
        end_date_type: typing.Optional[builtins.str] = None,
        ephemeral_storage: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        instance_match_criteria: typing.Optional[builtins.str] = None,
        tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        tenancy: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::CapacityReservation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param availability_zone: ``AWS::EC2::CapacityReservation.AvailabilityZone``.
        :param instance_count: ``AWS::EC2::CapacityReservation.InstanceCount``.
        :param instance_platform: ``AWS::EC2::CapacityReservation.InstancePlatform``.
        :param instance_type: ``AWS::EC2::CapacityReservation.InstanceType``.
        :param ebs_optimized: ``AWS::EC2::CapacityReservation.EbsOptimized``.
        :param end_date: ``AWS::EC2::CapacityReservation.EndDate``.
        :param end_date_type: ``AWS::EC2::CapacityReservation.EndDateType``.
        :param ephemeral_storage: ``AWS::EC2::CapacityReservation.EphemeralStorage``.
        :param instance_match_criteria: ``AWS::EC2::CapacityReservation.InstanceMatchCriteria``.
        :param tag_specifications: ``AWS::EC2::CapacityReservation.TagSpecifications``.
        :param tenancy: ``AWS::EC2::CapacityReservation.Tenancy``.
        """
        props = CfnCapacityReservationProps(
            availability_zone=availability_zone,
            instance_count=instance_count,
            instance_platform=instance_platform,
            instance_type=instance_type,
            ebs_optimized=ebs_optimized,
            end_date=end_date,
            end_date_type=end_date_type,
            ephemeral_storage=ephemeral_storage,
            instance_match_criteria=instance_match_criteria,
            tag_specifications=tag_specifications,
            tenancy=tenancy,
        )

        jsii.create(CfnCapacityReservation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAvailabilityZone")
    def attr_availability_zone(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AvailabilityZone
        """
        return jsii.get(self, "attrAvailabilityZone")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAvailableInstanceCount")
    def attr_available_instance_count(self) -> jsii.Number:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AvailableInstanceCount
        """
        return jsii.get(self, "attrAvailableInstanceCount")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrInstanceType")
    def attr_instance_type(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: InstanceType
        """
        return jsii.get(self, "attrInstanceType")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrTenancy")
    def attr_tenancy(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Tenancy
        """
        return jsii.get(self, "attrTenancy")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrTotalInstanceCount")
    def attr_total_instance_count(self) -> jsii.Number:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: TotalInstanceCount
        """
        return jsii.get(self, "attrTotalInstanceCount")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        """``AWS::EC2::CapacityReservation.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
        """
        return jsii.get(self, "availabilityZone")

    @availability_zone.setter # type: ignore
    def availability_zone(self, value: builtins.str) -> None:
        jsii.set(self, "availabilityZone", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceCount")
    def instance_count(self) -> jsii.Number:
        """``AWS::EC2::CapacityReservation.InstanceCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
        """
        return jsii.get(self, "instanceCount")

    @instance_count.setter # type: ignore
    def instance_count(self, value: jsii.Number) -> None:
        jsii.set(self, "instanceCount", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instancePlatform")
    def instance_platform(self) -> builtins.str:
        """``AWS::EC2::CapacityReservation.InstancePlatform``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
        """
        return jsii.get(self, "instancePlatform")

    @instance_platform.setter # type: ignore
    def instance_platform(self, value: builtins.str) -> None:
        jsii.set(self, "instancePlatform", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceType")
    def instance_type(self) -> builtins.str:
        """``AWS::EC2::CapacityReservation.InstanceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
        """
        return jsii.get(self, "instanceType")

    @instance_type.setter # type: ignore
    def instance_type(self, value: builtins.str) -> None:
        jsii.set(self, "instanceType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ebsOptimized")
    def ebs_optimized(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::CapacityReservation.EbsOptimized``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
        """
        return jsii.get(self, "ebsOptimized")

    @ebs_optimized.setter # type: ignore
    def ebs_optimized(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "ebsOptimized", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="endDate")
    def end_date(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.EndDate``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
        """
        return jsii.get(self, "endDate")

    @end_date.setter # type: ignore
    def end_date(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "endDate", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="endDateType")
    def end_date_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.EndDateType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
        """
        return jsii.get(self, "endDateType")

    @end_date_type.setter # type: ignore
    def end_date_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "endDateType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ephemeralStorage")
    def ephemeral_storage(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::CapacityReservation.EphemeralStorage``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
        """
        return jsii.get(self, "ephemeralStorage")

    @ephemeral_storage.setter # type: ignore
    def ephemeral_storage(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "ephemeralStorage", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceMatchCriteria")
    def instance_match_criteria(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.InstanceMatchCriteria``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
        """
        return jsii.get(self, "instanceMatchCriteria")

    @instance_match_criteria.setter # type: ignore
    def instance_match_criteria(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "instanceMatchCriteria", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagSpecifications")
    def tag_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::CapacityReservation.TagSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
        """
        return jsii.get(self, "tagSpecifications")

    @tag_specifications.setter # type: ignore
    def tag_specifications(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "tagSpecifications", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tenancy")
    def tenancy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.Tenancy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
        """
        return jsii.get(self, "tenancy")

    @tenancy.setter # type: ignore
    def tenancy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "tenancy", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnCapacityReservation.TagSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"resource_type": "resourceType", "tags": "tags"},
    )
    class TagSpecificationProperty:
        def __init__(
            self,
            *,
            resource_type: typing.Optional[builtins.str] = None,
            tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        ) -> None:
            """
            :param resource_type: ``CfnCapacityReservation.TagSpecificationProperty.ResourceType``.
            :param tags: ``CfnCapacityReservation.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if resource_type is not None:
                self._values["resource_type"] = resource_type
            if tags is not None:
                self._values["tags"] = tags

        @builtins.property
        def resource_type(self) -> typing.Optional[builtins.str]:
            """``CfnCapacityReservation.TagSpecificationProperty.ResourceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-resourcetype
            """
            result = self._values.get("resource_type")
            return result

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
            """``CfnCapacityReservation.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-tags
            """
            result = self._values.get("tags")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TagSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnCapacityReservationProps",
    jsii_struct_bases=[],
    name_mapping={
        "availability_zone": "availabilityZone",
        "instance_count": "instanceCount",
        "instance_platform": "instancePlatform",
        "instance_type": "instanceType",
        "ebs_optimized": "ebsOptimized",
        "end_date": "endDate",
        "end_date_type": "endDateType",
        "ephemeral_storage": "ephemeralStorage",
        "instance_match_criteria": "instanceMatchCriteria",
        "tag_specifications": "tagSpecifications",
        "tenancy": "tenancy",
    },
)
class CfnCapacityReservationProps:
    def __init__(
        self,
        *,
        availability_zone: builtins.str,
        instance_count: jsii.Number,
        instance_platform: builtins.str,
        instance_type: builtins.str,
        ebs_optimized: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        end_date: typing.Optional[builtins.str] = None,
        end_date_type: typing.Optional[builtins.str] = None,
        ephemeral_storage: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        instance_match_criteria: typing.Optional[builtins.str] = None,
        tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnCapacityReservation.TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        tenancy: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::CapacityReservation``.

        :param availability_zone: ``AWS::EC2::CapacityReservation.AvailabilityZone``.
        :param instance_count: ``AWS::EC2::CapacityReservation.InstanceCount``.
        :param instance_platform: ``AWS::EC2::CapacityReservation.InstancePlatform``.
        :param instance_type: ``AWS::EC2::CapacityReservation.InstanceType``.
        :param ebs_optimized: ``AWS::EC2::CapacityReservation.EbsOptimized``.
        :param end_date: ``AWS::EC2::CapacityReservation.EndDate``.
        :param end_date_type: ``AWS::EC2::CapacityReservation.EndDateType``.
        :param ephemeral_storage: ``AWS::EC2::CapacityReservation.EphemeralStorage``.
        :param instance_match_criteria: ``AWS::EC2::CapacityReservation.InstanceMatchCriteria``.
        :param tag_specifications: ``AWS::EC2::CapacityReservation.TagSpecifications``.
        :param tenancy: ``AWS::EC2::CapacityReservation.Tenancy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "availability_zone": availability_zone,
            "instance_count": instance_count,
            "instance_platform": instance_platform,
            "instance_type": instance_type,
        }
        if ebs_optimized is not None:
            self._values["ebs_optimized"] = ebs_optimized
        if end_date is not None:
            self._values["end_date"] = end_date
        if end_date_type is not None:
            self._values["end_date_type"] = end_date_type
        if ephemeral_storage is not None:
            self._values["ephemeral_storage"] = ephemeral_storage
        if instance_match_criteria is not None:
            self._values["instance_match_criteria"] = instance_match_criteria
        if tag_specifications is not None:
            self._values["tag_specifications"] = tag_specifications
        if tenancy is not None:
            self._values["tenancy"] = tenancy

    @builtins.property
    def availability_zone(self) -> builtins.str:
        """``AWS::EC2::CapacityReservation.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
        """
        result = self._values.get("availability_zone")
        assert result is not None, "Required property 'availability_zone' is missing"
        return result

    @builtins.property
    def instance_count(self) -> jsii.Number:
        """``AWS::EC2::CapacityReservation.InstanceCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
        """
        result = self._values.get("instance_count")
        assert result is not None, "Required property 'instance_count' is missing"
        return result

    @builtins.property
    def instance_platform(self) -> builtins.str:
        """``AWS::EC2::CapacityReservation.InstancePlatform``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
        """
        result = self._values.get("instance_platform")
        assert result is not None, "Required property 'instance_platform' is missing"
        return result

    @builtins.property
    def instance_type(self) -> builtins.str:
        """``AWS::EC2::CapacityReservation.InstanceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
        """
        result = self._values.get("instance_type")
        assert result is not None, "Required property 'instance_type' is missing"
        return result

    @builtins.property
    def ebs_optimized(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::CapacityReservation.EbsOptimized``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
        """
        result = self._values.get("ebs_optimized")
        return result

    @builtins.property
    def end_date(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.EndDate``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
        """
        result = self._values.get("end_date")
        return result

    @builtins.property
    def end_date_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.EndDateType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
        """
        result = self._values.get("end_date_type")
        return result

    @builtins.property
    def ephemeral_storage(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::CapacityReservation.EphemeralStorage``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
        """
        result = self._values.get("ephemeral_storage")
        return result

    @builtins.property
    def instance_match_criteria(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.InstanceMatchCriteria``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
        """
        result = self._values.get("instance_match_criteria")
        return result

    @builtins.property
    def tag_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnCapacityReservation.TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::CapacityReservation.TagSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
        """
        result = self._values.get("tag_specifications")
        return result

    @builtins.property
    def tenancy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::CapacityReservation.Tenancy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
        """
        result = self._values.get("tenancy")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnCapacityReservationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnCarrierGateway(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnCarrierGateway",
):
    """A CloudFormation ``AWS::EC2::CarrierGateway``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::CarrierGateway
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        vpc_id: builtins.str,
        tags: typing.Optional["TagsProperty"] = None,
    ) -> None:
        """Create a new ``AWS::EC2::CarrierGateway``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param vpc_id: ``AWS::EC2::CarrierGateway.VpcId``.
        :param tags: ``AWS::EC2::CarrierGateway.Tags``.
        """
        props = CfnCarrierGatewayProps(vpc_id=vpc_id, tags=tags)

        jsii.create(CfnCarrierGateway, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrCarrierGatewayId")
    def attr_carrier_gateway_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: CarrierGatewayId
        """
        return jsii.get(self, "attrCarrierGatewayId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrOwnerId")
    def attr_owner_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: OwnerId
        """
        return jsii.get(self, "attrOwnerId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrState")
    def attr_state(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: State
        """
        return jsii.get(self, "attrState")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::CarrierGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::CarrierGateway.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnCarrierGateway.TagsProperty",
        jsii_struct_bases=[],
        name_mapping={"tags": "tags"},
    )
    class TagsProperty:
        def __init__(
            self,
            *,
            tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        ) -> None:
            """
            :param tags: ``CfnCarrierGateway.TagsProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-carriergateway-tags.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if tags is not None:
                self._values["tags"] = tags

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
            """``CfnCarrierGateway.TagsProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-carriergateway-tags.html#cfn-ec2-carriergateway-tags-tags
            """
            result = self._values.get("tags")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TagsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnCarrierGatewayProps",
    jsii_struct_bases=[],
    name_mapping={"vpc_id": "vpcId", "tags": "tags"},
)
class CfnCarrierGatewayProps:
    def __init__(
        self,
        *,
        vpc_id: builtins.str,
        tags: typing.Optional["CfnCarrierGateway.TagsProperty"] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::CarrierGateway``.

        :param vpc_id: ``AWS::EC2::CarrierGateway.VpcId``.
        :param tags: ``AWS::EC2::CarrierGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html
        """
        if isinstance(tags, dict):
            tags = CfnCarrierGateway.TagsProperty(**tags)
        self._values: typing.Dict[str, typing.Any] = {
            "vpc_id": vpc_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::CarrierGateway.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional["CfnCarrierGateway.TagsProperty"]:
        """``AWS::EC2::CarrierGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-carriergateway.html#cfn-ec2-carriergateway-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnCarrierGatewayProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnClientVpnAuthorizationRule(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnAuthorizationRule",
):
    """A CloudFormation ``AWS::EC2::ClientVpnAuthorizationRule``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::ClientVpnAuthorizationRule
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        client_vpn_endpoint_id: builtins.str,
        target_network_cidr: builtins.str,
        access_group_id: typing.Optional[builtins.str] = None,
        authorize_all_groups: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::ClientVpnAuthorizationRule``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param client_vpn_endpoint_id: ``AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId``.
        :param target_network_cidr: ``AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr``.
        :param access_group_id: ``AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId``.
        :param authorize_all_groups: ``AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups``.
        :param description: ``AWS::EC2::ClientVpnAuthorizationRule.Description``.
        """
        props = CfnClientVpnAuthorizationRuleProps(
            client_vpn_endpoint_id=client_vpn_endpoint_id,
            target_network_cidr=target_network_cidr,
            access_group_id=access_group_id,
            authorize_all_groups=authorize_all_groups,
            description=description,
        )

        jsii.create(CfnClientVpnAuthorizationRule, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientVpnEndpointId")
    def client_vpn_endpoint_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
        """
        return jsii.get(self, "clientVpnEndpointId")

    @client_vpn_endpoint_id.setter # type: ignore
    def client_vpn_endpoint_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientVpnEndpointId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="targetNetworkCidr")
    def target_network_cidr(self) -> builtins.str:
        """``AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
        """
        return jsii.get(self, "targetNetworkCidr")

    @target_network_cidr.setter # type: ignore
    def target_network_cidr(self, value: builtins.str) -> None:
        jsii.set(self, "targetNetworkCidr", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="accessGroupId")
    def access_group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
        """
        return jsii.get(self, "accessGroupId")

    @access_group_id.setter # type: ignore
    def access_group_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "accessGroupId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authorizeAllGroups")
    def authorize_all_groups(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
        """
        return jsii.get(self, "authorizeAllGroups")

    @authorize_all_groups.setter # type: ignore
    def authorize_all_groups(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "authorizeAllGroups", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnAuthorizationRule.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnAuthorizationRuleProps",
    jsii_struct_bases=[],
    name_mapping={
        "client_vpn_endpoint_id": "clientVpnEndpointId",
        "target_network_cidr": "targetNetworkCidr",
        "access_group_id": "accessGroupId",
        "authorize_all_groups": "authorizeAllGroups",
        "description": "description",
    },
)
class CfnClientVpnAuthorizationRuleProps:
    def __init__(
        self,
        *,
        client_vpn_endpoint_id: builtins.str,
        target_network_cidr: builtins.str,
        access_group_id: typing.Optional[builtins.str] = None,
        authorize_all_groups: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::ClientVpnAuthorizationRule``.

        :param client_vpn_endpoint_id: ``AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId``.
        :param target_network_cidr: ``AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr``.
        :param access_group_id: ``AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId``.
        :param authorize_all_groups: ``AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups``.
        :param description: ``AWS::EC2::ClientVpnAuthorizationRule.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_vpn_endpoint_id": client_vpn_endpoint_id,
            "target_network_cidr": target_network_cidr,
        }
        if access_group_id is not None:
            self._values["access_group_id"] = access_group_id
        if authorize_all_groups is not None:
            self._values["authorize_all_groups"] = authorize_all_groups
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def client_vpn_endpoint_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
        """
        result = self._values.get("client_vpn_endpoint_id")
        assert result is not None, "Required property 'client_vpn_endpoint_id' is missing"
        return result

    @builtins.property
    def target_network_cidr(self) -> builtins.str:
        """``AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
        """
        result = self._values.get("target_network_cidr")
        assert result is not None, "Required property 'target_network_cidr' is missing"
        return result

    @builtins.property
    def access_group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
        """
        result = self._values.get("access_group_id")
        return result

    @builtins.property
    def authorize_all_groups(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
        """
        result = self._values.get("authorize_all_groups")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnAuthorizationRule.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
        """
        result = self._values.get("description")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnClientVpnAuthorizationRuleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnClientVpnEndpoint(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint",
):
    """A CloudFormation ``AWS::EC2::ClientVpnEndpoint``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::ClientVpnEndpoint
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        authentication_options: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ClientAuthenticationRequestProperty", _IResolvable_9ceae33e]]],
        client_cidr_block: builtins.str,
        connection_log_options: typing.Union["ConnectionLogOptionsProperty", _IResolvable_9ceae33e],
        server_certificate_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        dns_servers: typing.Optional[typing.List[builtins.str]] = None,
        security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
        split_tunnel: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        transport_protocol: typing.Optional[builtins.str] = None,
        vpc_id: typing.Optional[builtins.str] = None,
        vpn_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Create a new ``AWS::EC2::ClientVpnEndpoint``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param authentication_options: ``AWS::EC2::ClientVpnEndpoint.AuthenticationOptions``.
        :param client_cidr_block: ``AWS::EC2::ClientVpnEndpoint.ClientCidrBlock``.
        :param connection_log_options: ``AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions``.
        :param server_certificate_arn: ``AWS::EC2::ClientVpnEndpoint.ServerCertificateArn``.
        :param description: ``AWS::EC2::ClientVpnEndpoint.Description``.
        :param dns_servers: ``AWS::EC2::ClientVpnEndpoint.DnsServers``.
        :param security_group_ids: ``AWS::EC2::ClientVpnEndpoint.SecurityGroupIds``.
        :param split_tunnel: ``AWS::EC2::ClientVpnEndpoint.SplitTunnel``.
        :param tag_specifications: ``AWS::EC2::ClientVpnEndpoint.TagSpecifications``.
        :param transport_protocol: ``AWS::EC2::ClientVpnEndpoint.TransportProtocol``.
        :param vpc_id: ``AWS::EC2::ClientVpnEndpoint.VpcId``.
        :param vpn_port: ``AWS::EC2::ClientVpnEndpoint.VpnPort``.
        """
        props = CfnClientVpnEndpointProps(
            authentication_options=authentication_options,
            client_cidr_block=client_cidr_block,
            connection_log_options=connection_log_options,
            server_certificate_arn=server_certificate_arn,
            description=description,
            dns_servers=dns_servers,
            security_group_ids=security_group_ids,
            split_tunnel=split_tunnel,
            tag_specifications=tag_specifications,
            transport_protocol=transport_protocol,
            vpc_id=vpc_id,
            vpn_port=vpn_port,
        )

        jsii.create(CfnClientVpnEndpoint, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="authenticationOptions")
    def authentication_options(
        self,
    ) -> typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ClientAuthenticationRequestProperty", _IResolvable_9ceae33e]]]:
        """``AWS::EC2::ClientVpnEndpoint.AuthenticationOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
        """
        return jsii.get(self, "authenticationOptions")

    @authentication_options.setter # type: ignore
    def authentication_options(
        self,
        value: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ClientAuthenticationRequestProperty", _IResolvable_9ceae33e]]],
    ) -> None:
        jsii.set(self, "authenticationOptions", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientCidrBlock")
    def client_cidr_block(self) -> builtins.str:
        """``AWS::EC2::ClientVpnEndpoint.ClientCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
        """
        return jsii.get(self, "clientCidrBlock")

    @client_cidr_block.setter # type: ignore
    def client_cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "clientCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionLogOptions")
    def connection_log_options(
        self,
    ) -> typing.Union["ConnectionLogOptionsProperty", _IResolvable_9ceae33e]:
        """``AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
        """
        return jsii.get(self, "connectionLogOptions")

    @connection_log_options.setter # type: ignore
    def connection_log_options(
        self,
        value: typing.Union["ConnectionLogOptionsProperty", _IResolvable_9ceae33e],
    ) -> None:
        jsii.set(self, "connectionLogOptions", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serverCertificateArn")
    def server_certificate_arn(self) -> builtins.str:
        """``AWS::EC2::ClientVpnEndpoint.ServerCertificateArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
        """
        return jsii.get(self, "serverCertificateArn")

    @server_certificate_arn.setter # type: ignore
    def server_certificate_arn(self, value: builtins.str) -> None:
        jsii.set(self, "serverCertificateArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnEndpoint.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="dnsServers")
    def dns_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::ClientVpnEndpoint.DnsServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
        """
        return jsii.get(self, "dnsServers")

    @dns_servers.setter # type: ignore
    def dns_servers(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        jsii.set(self, "dnsServers", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroupIds")
    def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::ClientVpnEndpoint.SecurityGroupIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
        """
        return jsii.get(self, "securityGroupIds")

    @security_group_ids.setter # type: ignore
    def security_group_ids(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "securityGroupIds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="splitTunnel")
    def split_tunnel(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::ClientVpnEndpoint.SplitTunnel``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
        """
        return jsii.get(self, "splitTunnel")

    @split_tunnel.setter # type: ignore
    def split_tunnel(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "splitTunnel", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagSpecifications")
    def tag_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::ClientVpnEndpoint.TagSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
        """
        return jsii.get(self, "tagSpecifications")

    @tag_specifications.setter # type: ignore
    def tag_specifications(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "tagSpecifications", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transportProtocol")
    def transport_protocol(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnEndpoint.TransportProtocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
        """
        return jsii.get(self, "transportProtocol")

    @transport_protocol.setter # type: ignore
    def transport_protocol(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "transportProtocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnEndpoint.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "vpcId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpnPort")
    def vpn_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::ClientVpnEndpoint.VpnPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
        """
        return jsii.get(self, "vpnPort")

    @vpn_port.setter # type: ignore
    def vpn_port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "vpnPort", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "client_root_certificate_chain_arn": "clientRootCertificateChainArn",
        },
    )
    class CertificateAuthenticationRequestProperty:
        def __init__(self, *, client_root_certificate_chain_arn: builtins.str) -> None:
            """
            :param client_root_certificate_chain_arn: ``CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "client_root_certificate_chain_arn": client_root_certificate_chain_arn,
            }

        @builtins.property
        def client_root_certificate_chain_arn(self) -> builtins.str:
            """``CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html#cfn-ec2-clientvpnendpoint-certificateauthenticationrequest-clientrootcertificatechainarn
            """
            result = self._values.get("client_root_certificate_chain_arn")
            assert result is not None, "Required property 'client_root_certificate_chain_arn' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CertificateAuthenticationRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "type": "type",
            "active_directory": "activeDirectory",
            "federated_authentication": "federatedAuthentication",
            "mutual_authentication": "mutualAuthentication",
        },
    )
    class ClientAuthenticationRequestProperty:
        def __init__(
            self,
            *,
            type: builtins.str,
            active_directory: typing.Optional[typing.Union["CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty", _IResolvable_9ceae33e]] = None,
            federated_authentication: typing.Optional[typing.Union["CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty", _IResolvable_9ceae33e]] = None,
            mutual_authentication: typing.Optional[typing.Union["CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty", _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param type: ``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type``.
            :param active_directory: ``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory``.
            :param federated_authentication: ``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.FederatedAuthentication``.
            :param mutual_authentication: ``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "type": type,
            }
            if active_directory is not None:
                self._values["active_directory"] = active_directory
            if federated_authentication is not None:
                self._values["federated_authentication"] = federated_authentication
            if mutual_authentication is not None:
                self._values["mutual_authentication"] = mutual_authentication

        @builtins.property
        def type(self) -> builtins.str:
            """``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-type
            """
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return result

        @builtins.property
        def active_directory(
            self,
        ) -> typing.Optional[typing.Union["CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty", _IResolvable_9ceae33e]]:
            """``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-activedirectory
            """
            result = self._values.get("active_directory")
            return result

        @builtins.property
        def federated_authentication(
            self,
        ) -> typing.Optional[typing.Union["CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty", _IResolvable_9ceae33e]]:
            """``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.FederatedAuthentication``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-federatedauthentication
            """
            result = self._values.get("federated_authentication")
            return result

        @builtins.property
        def mutual_authentication(
            self,
        ) -> typing.Optional[typing.Union["CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty", _IResolvable_9ceae33e]]:
            """``CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-mutualauthentication
            """
            result = self._values.get("mutual_authentication")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClientAuthenticationRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enabled": "enabled",
            "cloudwatch_log_group": "cloudwatchLogGroup",
            "cloudwatch_log_stream": "cloudwatchLogStream",
        },
    )
    class ConnectionLogOptionsProperty:
        def __init__(
            self,
            *,
            enabled: typing.Union[builtins.bool, _IResolvable_9ceae33e],
            cloudwatch_log_group: typing.Optional[builtins.str] = None,
            cloudwatch_log_stream: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param enabled: ``CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled``.
            :param cloudwatch_log_group: ``CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup``.
            :param cloudwatch_log_stream: ``CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "enabled": enabled,
            }
            if cloudwatch_log_group is not None:
                self._values["cloudwatch_log_group"] = cloudwatch_log_group
            if cloudwatch_log_stream is not None:
                self._values["cloudwatch_log_stream"] = cloudwatch_log_stream

        @builtins.property
        def enabled(self) -> typing.Union[builtins.bool, _IResolvable_9ceae33e]:
            """``CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-enabled
            """
            result = self._values.get("enabled")
            assert result is not None, "Required property 'enabled' is missing"
            return result

        @builtins.property
        def cloudwatch_log_group(self) -> typing.Optional[builtins.str]:
            """``CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchloggroup
            """
            result = self._values.get("cloudwatch_log_group")
            return result

        @builtins.property
        def cloudwatch_log_stream(self) -> typing.Optional[builtins.str]:
            """``CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchlogstream
            """
            result = self._values.get("cloudwatch_log_stream")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConnectionLogOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty",
        jsii_struct_bases=[],
        name_mapping={"directory_id": "directoryId"},
    )
    class DirectoryServiceAuthenticationRequestProperty:
        def __init__(self, *, directory_id: builtins.str) -> None:
            """
            :param directory_id: ``CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "directory_id": directory_id,
            }

        @builtins.property
        def directory_id(self) -> builtins.str:
            """``CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html#cfn-ec2-clientvpnendpoint-directoryserviceauthenticationrequest-directoryid
            """
            result = self._values.get("directory_id")
            assert result is not None, "Required property 'directory_id' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DirectoryServiceAuthenticationRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty",
        jsii_struct_bases=[],
        name_mapping={"saml_provider_arn": "samlProviderArn"},
    )
    class FederatedAuthenticationRequestProperty:
        def __init__(self, *, saml_provider_arn: builtins.str) -> None:
            """
            :param saml_provider_arn: ``CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty.SAMLProviderArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "saml_provider_arn": saml_provider_arn,
            }

        @builtins.property
        def saml_provider_arn(self) -> builtins.str:
            """``CfnClientVpnEndpoint.FederatedAuthenticationRequestProperty.SAMLProviderArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-federatedauthenticationrequest.html#cfn-ec2-clientvpnendpoint-federatedauthenticationrequest-samlproviderarn
            """
            result = self._values.get("saml_provider_arn")
            assert result is not None, "Required property 'saml_provider_arn' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FederatedAuthenticationRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpoint.TagSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"resource_type": "resourceType", "tags": "tags"},
    )
    class TagSpecificationProperty:
        def __init__(
            self,
            *,
            resource_type: builtins.str,
            tags: typing.List[_CfnTag_b4661f1a],
        ) -> None:
            """
            :param resource_type: ``CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType``.
            :param tags: ``CfnClientVpnEndpoint.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "resource_type": resource_type,
                "tags": tags,
            }

        @builtins.property
        def resource_type(self) -> builtins.str:
            """``CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-resourcetype
            """
            result = self._values.get("resource_type")
            assert result is not None, "Required property 'resource_type' is missing"
            return result

        @builtins.property
        def tags(self) -> typing.List[_CfnTag_b4661f1a]:
            """``CfnClientVpnEndpoint.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-tags
            """
            result = self._values.get("tags")
            assert result is not None, "Required property 'tags' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TagSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnEndpointProps",
    jsii_struct_bases=[],
    name_mapping={
        "authentication_options": "authenticationOptions",
        "client_cidr_block": "clientCidrBlock",
        "connection_log_options": "connectionLogOptions",
        "server_certificate_arn": "serverCertificateArn",
        "description": "description",
        "dns_servers": "dnsServers",
        "security_group_ids": "securityGroupIds",
        "split_tunnel": "splitTunnel",
        "tag_specifications": "tagSpecifications",
        "transport_protocol": "transportProtocol",
        "vpc_id": "vpcId",
        "vpn_port": "vpnPort",
    },
)
class CfnClientVpnEndpointProps:
    def __init__(
        self,
        *,
        authentication_options: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnClientVpnEndpoint.ClientAuthenticationRequestProperty", _IResolvable_9ceae33e]]],
        client_cidr_block: builtins.str,
        connection_log_options: typing.Union["CfnClientVpnEndpoint.ConnectionLogOptionsProperty", _IResolvable_9ceae33e],
        server_certificate_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        dns_servers: typing.Optional[typing.List[builtins.str]] = None,
        security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
        split_tunnel: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnClientVpnEndpoint.TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        transport_protocol: typing.Optional[builtins.str] = None,
        vpc_id: typing.Optional[builtins.str] = None,
        vpn_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::ClientVpnEndpoint``.

        :param authentication_options: ``AWS::EC2::ClientVpnEndpoint.AuthenticationOptions``.
        :param client_cidr_block: ``AWS::EC2::ClientVpnEndpoint.ClientCidrBlock``.
        :param connection_log_options: ``AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions``.
        :param server_certificate_arn: ``AWS::EC2::ClientVpnEndpoint.ServerCertificateArn``.
        :param description: ``AWS::EC2::ClientVpnEndpoint.Description``.
        :param dns_servers: ``AWS::EC2::ClientVpnEndpoint.DnsServers``.
        :param security_group_ids: ``AWS::EC2::ClientVpnEndpoint.SecurityGroupIds``.
        :param split_tunnel: ``AWS::EC2::ClientVpnEndpoint.SplitTunnel``.
        :param tag_specifications: ``AWS::EC2::ClientVpnEndpoint.TagSpecifications``.
        :param transport_protocol: ``AWS::EC2::ClientVpnEndpoint.TransportProtocol``.
        :param vpc_id: ``AWS::EC2::ClientVpnEndpoint.VpcId``.
        :param vpn_port: ``AWS::EC2::ClientVpnEndpoint.VpnPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "authentication_options": authentication_options,
            "client_cidr_block": client_cidr_block,
            "connection_log_options": connection_log_options,
            "server_certificate_arn": server_certificate_arn,
        }
        if description is not None:
            self._values["description"] = description
        if dns_servers is not None:
            self._values["dns_servers"] = dns_servers
        if security_group_ids is not None:
            self._values["security_group_ids"] = security_group_ids
        if split_tunnel is not None:
            self._values["split_tunnel"] = split_tunnel
        if tag_specifications is not None:
            self._values["tag_specifications"] = tag_specifications
        if transport_protocol is not None:
            self._values["transport_protocol"] = transport_protocol
        if vpc_id is not None:
            self._values["vpc_id"] = vpc_id
        if vpn_port is not None:
            self._values["vpn_port"] = vpn_port

    @builtins.property
    def authentication_options(
        self,
    ) -> typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnClientVpnEndpoint.ClientAuthenticationRequestProperty", _IResolvable_9ceae33e]]]:
        """``AWS::EC2::ClientVpnEndpoint.AuthenticationOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
        """
        result = self._values.get("authentication_options")
        assert result is not None, "Required property 'authentication_options' is missing"
        return result

    @builtins.property
    def client_cidr_block(self) -> builtins.str:
        """``AWS::EC2::ClientVpnEndpoint.ClientCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
        """
        result = self._values.get("client_cidr_block")
        assert result is not None, "Required property 'client_cidr_block' is missing"
        return result

    @builtins.property
    def connection_log_options(
        self,
    ) -> typing.Union["CfnClientVpnEndpoint.ConnectionLogOptionsProperty", _IResolvable_9ceae33e]:
        """``AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
        """
        result = self._values.get("connection_log_options")
        assert result is not None, "Required property 'connection_log_options' is missing"
        return result

    @builtins.property
    def server_certificate_arn(self) -> builtins.str:
        """``AWS::EC2::ClientVpnEndpoint.ServerCertificateArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
        """
        result = self._values.get("server_certificate_arn")
        assert result is not None, "Required property 'server_certificate_arn' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnEndpoint.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def dns_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::ClientVpnEndpoint.DnsServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
        """
        result = self._values.get("dns_servers")
        return result

    @builtins.property
    def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::ClientVpnEndpoint.SecurityGroupIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
        """
        result = self._values.get("security_group_ids")
        return result

    @builtins.property
    def split_tunnel(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::ClientVpnEndpoint.SplitTunnel``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
        """
        result = self._values.get("split_tunnel")
        return result

    @builtins.property
    def tag_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnClientVpnEndpoint.TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::ClientVpnEndpoint.TagSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
        """
        result = self._values.get("tag_specifications")
        return result

    @builtins.property
    def transport_protocol(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnEndpoint.TransportProtocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
        """
        result = self._values.get("transport_protocol")
        return result

    @builtins.property
    def vpc_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnEndpoint.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
        """
        result = self._values.get("vpc_id")
        return result

    @builtins.property
    def vpn_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::ClientVpnEndpoint.VpnPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
        """
        result = self._values.get("vpn_port")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnClientVpnEndpointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnClientVpnRoute(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnRoute",
):
    """A CloudFormation ``AWS::EC2::ClientVpnRoute``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::ClientVpnRoute
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        client_vpn_endpoint_id: builtins.str,
        destination_cidr_block: builtins.str,
        target_vpc_subnet_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::ClientVpnRoute``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param client_vpn_endpoint_id: ``AWS::EC2::ClientVpnRoute.ClientVpnEndpointId``.
        :param destination_cidr_block: ``AWS::EC2::ClientVpnRoute.DestinationCidrBlock``.
        :param target_vpc_subnet_id: ``AWS::EC2::ClientVpnRoute.TargetVpcSubnetId``.
        :param description: ``AWS::EC2::ClientVpnRoute.Description``.
        """
        props = CfnClientVpnRouteProps(
            client_vpn_endpoint_id=client_vpn_endpoint_id,
            destination_cidr_block=destination_cidr_block,
            target_vpc_subnet_id=target_vpc_subnet_id,
            description=description,
        )

        jsii.create(CfnClientVpnRoute, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientVpnEndpointId")
    def client_vpn_endpoint_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnRoute.ClientVpnEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
        """
        return jsii.get(self, "clientVpnEndpointId")

    @client_vpn_endpoint_id.setter # type: ignore
    def client_vpn_endpoint_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientVpnEndpointId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationCidrBlock")
    def destination_cidr_block(self) -> builtins.str:
        """``AWS::EC2::ClientVpnRoute.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
        """
        return jsii.get(self, "destinationCidrBlock")

    @destination_cidr_block.setter # type: ignore
    def destination_cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "destinationCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="targetVpcSubnetId")
    def target_vpc_subnet_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnRoute.TargetVpcSubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
        """
        return jsii.get(self, "targetVpcSubnetId")

    @target_vpc_subnet_id.setter # type: ignore
    def target_vpc_subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "targetVpcSubnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnRoute.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnRouteProps",
    jsii_struct_bases=[],
    name_mapping={
        "client_vpn_endpoint_id": "clientVpnEndpointId",
        "destination_cidr_block": "destinationCidrBlock",
        "target_vpc_subnet_id": "targetVpcSubnetId",
        "description": "description",
    },
)
class CfnClientVpnRouteProps:
    def __init__(
        self,
        *,
        client_vpn_endpoint_id: builtins.str,
        destination_cidr_block: builtins.str,
        target_vpc_subnet_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::ClientVpnRoute``.

        :param client_vpn_endpoint_id: ``AWS::EC2::ClientVpnRoute.ClientVpnEndpointId``.
        :param destination_cidr_block: ``AWS::EC2::ClientVpnRoute.DestinationCidrBlock``.
        :param target_vpc_subnet_id: ``AWS::EC2::ClientVpnRoute.TargetVpcSubnetId``.
        :param description: ``AWS::EC2::ClientVpnRoute.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_vpn_endpoint_id": client_vpn_endpoint_id,
            "destination_cidr_block": destination_cidr_block,
            "target_vpc_subnet_id": target_vpc_subnet_id,
        }
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def client_vpn_endpoint_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnRoute.ClientVpnEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
        """
        result = self._values.get("client_vpn_endpoint_id")
        assert result is not None, "Required property 'client_vpn_endpoint_id' is missing"
        return result

    @builtins.property
    def destination_cidr_block(self) -> builtins.str:
        """``AWS::EC2::ClientVpnRoute.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
        """
        result = self._values.get("destination_cidr_block")
        assert result is not None, "Required property 'destination_cidr_block' is missing"
        return result

    @builtins.property
    def target_vpc_subnet_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnRoute.TargetVpcSubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
        """
        result = self._values.get("target_vpc_subnet_id")
        assert result is not None, "Required property 'target_vpc_subnet_id' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::ClientVpnRoute.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
        """
        result = self._values.get("description")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnClientVpnRouteProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnClientVpnTargetNetworkAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnTargetNetworkAssociation",
):
    """A CloudFormation ``AWS::EC2::ClientVpnTargetNetworkAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::ClientVpnTargetNetworkAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        client_vpn_endpoint_id: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::ClientVpnTargetNetworkAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param client_vpn_endpoint_id: ``AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId``.
        :param subnet_id: ``AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId``.
        """
        props = CfnClientVpnTargetNetworkAssociationProps(
            client_vpn_endpoint_id=client_vpn_endpoint_id, subnet_id=subnet_id
        )

        jsii.create(CfnClientVpnTargetNetworkAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="clientVpnEndpointId")
    def client_vpn_endpoint_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
        """
        return jsii.get(self, "clientVpnEndpointId")

    @client_vpn_endpoint_id.setter # type: ignore
    def client_vpn_endpoint_id(self, value: builtins.str) -> None:
        jsii.set(self, "clientVpnEndpointId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnClientVpnTargetNetworkAssociationProps",
    jsii_struct_bases=[],
    name_mapping={
        "client_vpn_endpoint_id": "clientVpnEndpointId",
        "subnet_id": "subnetId",
    },
)
class CfnClientVpnTargetNetworkAssociationProps:
    def __init__(
        self,
        *,
        client_vpn_endpoint_id: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::ClientVpnTargetNetworkAssociation``.

        :param client_vpn_endpoint_id: ``AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId``.
        :param subnet_id: ``AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "client_vpn_endpoint_id": client_vpn_endpoint_id,
            "subnet_id": subnet_id,
        }

    @builtins.property
    def client_vpn_endpoint_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
        """
        result = self._values.get("client_vpn_endpoint_id")
        assert result is not None, "Required property 'client_vpn_endpoint_id' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnClientVpnTargetNetworkAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnCustomerGateway(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnCustomerGateway",
):
    """A CloudFormation ``AWS::EC2::CustomerGateway``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::CustomerGateway
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        bgp_asn: jsii.Number,
        ip_address: builtins.str,
        type: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::CustomerGateway``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param bgp_asn: ``AWS::EC2::CustomerGateway.BgpAsn``.
        :param ip_address: ``AWS::EC2::CustomerGateway.IpAddress``.
        :param type: ``AWS::EC2::CustomerGateway.Type``.
        :param tags: ``AWS::EC2::CustomerGateway.Tags``.
        """
        props = CfnCustomerGatewayProps(
            bgp_asn=bgp_asn, ip_address=ip_address, type=type, tags=tags
        )

        jsii.create(CfnCustomerGateway, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::CustomerGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="bgpAsn")
    def bgp_asn(self) -> jsii.Number:
        """``AWS::EC2::CustomerGateway.BgpAsn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
        """
        return jsii.get(self, "bgpAsn")

    @bgp_asn.setter # type: ignore
    def bgp_asn(self, value: jsii.Number) -> None:
        jsii.set(self, "bgpAsn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipAddress")
    def ip_address(self) -> builtins.str:
        """``AWS::EC2::CustomerGateway.IpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
        """
        return jsii.get(self, "ipAddress")

    @ip_address.setter # type: ignore
    def ip_address(self, value: builtins.str) -> None:
        jsii.set(self, "ipAddress", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        """``AWS::EC2::CustomerGateway.Type``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
        """
        return jsii.get(self, "type")

    @type.setter # type: ignore
    def type(self, value: builtins.str) -> None:
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnCustomerGatewayProps",
    jsii_struct_bases=[],
    name_mapping={
        "bgp_asn": "bgpAsn",
        "ip_address": "ipAddress",
        "type": "type",
        "tags": "tags",
    },
)
class CfnCustomerGatewayProps:
    def __init__(
        self,
        *,
        bgp_asn: jsii.Number,
        ip_address: builtins.str,
        type: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::CustomerGateway``.

        :param bgp_asn: ``AWS::EC2::CustomerGateway.BgpAsn``.
        :param ip_address: ``AWS::EC2::CustomerGateway.IpAddress``.
        :param type: ``AWS::EC2::CustomerGateway.Type``.
        :param tags: ``AWS::EC2::CustomerGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "bgp_asn": bgp_asn,
            "ip_address": ip_address,
            "type": type,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def bgp_asn(self) -> jsii.Number:
        """``AWS::EC2::CustomerGateway.BgpAsn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
        """
        result = self._values.get("bgp_asn")
        assert result is not None, "Required property 'bgp_asn' is missing"
        return result

    @builtins.property
    def ip_address(self) -> builtins.str:
        """``AWS::EC2::CustomerGateway.IpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
        """
        result = self._values.get("ip_address")
        assert result is not None, "Required property 'ip_address' is missing"
        return result

    @builtins.property
    def type(self) -> builtins.str:
        """``AWS::EC2::CustomerGateway.Type``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
        """
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::CustomerGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnCustomerGatewayProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnDHCPOptions(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnDHCPOptions",
):
    """A CloudFormation ``AWS::EC2::DHCPOptions``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::DHCPOptions
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        domain_name: typing.Optional[builtins.str] = None,
        domain_name_servers: typing.Optional[typing.List[builtins.str]] = None,
        netbios_name_servers: typing.Optional[typing.List[builtins.str]] = None,
        netbios_node_type: typing.Optional[jsii.Number] = None,
        ntp_servers: typing.Optional[typing.List[builtins.str]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::DHCPOptions``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param domain_name: ``AWS::EC2::DHCPOptions.DomainName``.
        :param domain_name_servers: ``AWS::EC2::DHCPOptions.DomainNameServers``.
        :param netbios_name_servers: ``AWS::EC2::DHCPOptions.NetbiosNameServers``.
        :param netbios_node_type: ``AWS::EC2::DHCPOptions.NetbiosNodeType``.
        :param ntp_servers: ``AWS::EC2::DHCPOptions.NtpServers``.
        :param tags: ``AWS::EC2::DHCPOptions.Tags``.
        """
        props = CfnDHCPOptionsProps(
            domain_name=domain_name,
            domain_name_servers=domain_name_servers,
            netbios_name_servers=netbios_name_servers,
            netbios_node_type=netbios_node_type,
            ntp_servers=ntp_servers,
            tags=tags,
        )

        jsii.create(CfnDHCPOptions, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::DHCPOptions.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::DHCPOptions.DomainName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
        """
        return jsii.get(self, "domainName")

    @domain_name.setter # type: ignore
    def domain_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domainNameServers")
    def domain_name_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::DHCPOptions.DomainNameServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
        """
        return jsii.get(self, "domainNameServers")

    @domain_name_servers.setter # type: ignore
    def domain_name_servers(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "domainNameServers", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="netbiosNameServers")
    def netbios_name_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::DHCPOptions.NetbiosNameServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
        """
        return jsii.get(self, "netbiosNameServers")

    @netbios_name_servers.setter # type: ignore
    def netbios_name_servers(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "netbiosNameServers", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="netbiosNodeType")
    def netbios_node_type(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::DHCPOptions.NetbiosNodeType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
        """
        return jsii.get(self, "netbiosNodeType")

    @netbios_node_type.setter # type: ignore
    def netbios_node_type(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "netbiosNodeType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ntpServers")
    def ntp_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::DHCPOptions.NtpServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
        """
        return jsii.get(self, "ntpServers")

    @ntp_servers.setter # type: ignore
    def ntp_servers(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        jsii.set(self, "ntpServers", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnDHCPOptionsProps",
    jsii_struct_bases=[],
    name_mapping={
        "domain_name": "domainName",
        "domain_name_servers": "domainNameServers",
        "netbios_name_servers": "netbiosNameServers",
        "netbios_node_type": "netbiosNodeType",
        "ntp_servers": "ntpServers",
        "tags": "tags",
    },
)
class CfnDHCPOptionsProps:
    def __init__(
        self,
        *,
        domain_name: typing.Optional[builtins.str] = None,
        domain_name_servers: typing.Optional[typing.List[builtins.str]] = None,
        netbios_name_servers: typing.Optional[typing.List[builtins.str]] = None,
        netbios_node_type: typing.Optional[jsii.Number] = None,
        ntp_servers: typing.Optional[typing.List[builtins.str]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::DHCPOptions``.

        :param domain_name: ``AWS::EC2::DHCPOptions.DomainName``.
        :param domain_name_servers: ``AWS::EC2::DHCPOptions.DomainNameServers``.
        :param netbios_name_servers: ``AWS::EC2::DHCPOptions.NetbiosNameServers``.
        :param netbios_node_type: ``AWS::EC2::DHCPOptions.NetbiosNodeType``.
        :param ntp_servers: ``AWS::EC2::DHCPOptions.NtpServers``.
        :param tags: ``AWS::EC2::DHCPOptions.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if domain_name_servers is not None:
            self._values["domain_name_servers"] = domain_name_servers
        if netbios_name_servers is not None:
            self._values["netbios_name_servers"] = netbios_name_servers
        if netbios_node_type is not None:
            self._values["netbios_node_type"] = netbios_node_type
        if ntp_servers is not None:
            self._values["ntp_servers"] = ntp_servers
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def domain_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::DHCPOptions.DomainName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
        """
        result = self._values.get("domain_name")
        return result

    @builtins.property
    def domain_name_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::DHCPOptions.DomainNameServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
        """
        result = self._values.get("domain_name_servers")
        return result

    @builtins.property
    def netbios_name_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::DHCPOptions.NetbiosNameServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
        """
        result = self._values.get("netbios_name_servers")
        return result

    @builtins.property
    def netbios_node_type(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::DHCPOptions.NetbiosNodeType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
        """
        result = self._values.get("netbios_node_type")
        return result

    @builtins.property
    def ntp_servers(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::DHCPOptions.NtpServers``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
        """
        result = self._values.get("ntp_servers")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::DHCPOptions.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDHCPOptionsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnEC2Fleet(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet",
):
    """A CloudFormation ``AWS::EC2::EC2Fleet``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::EC2Fleet
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        launch_template_configs: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["FleetLaunchTemplateConfigRequestProperty", _IResolvable_9ceae33e]]],
        target_capacity_specification: typing.Union["TargetCapacitySpecificationRequestProperty", _IResolvable_9ceae33e],
        excess_capacity_termination_policy: typing.Optional[builtins.str] = None,
        on_demand_options: typing.Optional[typing.Union["OnDemandOptionsRequestProperty", _IResolvable_9ceae33e]] = None,
        replace_unhealthy_instances: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        spot_options: typing.Optional[typing.Union["SpotOptionsRequestProperty", _IResolvable_9ceae33e]] = None,
        tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        terminate_instances_with_expiration: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        type: typing.Optional[builtins.str] = None,
        valid_from: typing.Optional[builtins.str] = None,
        valid_until: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::EC2Fleet``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param launch_template_configs: ``AWS::EC2::EC2Fleet.LaunchTemplateConfigs``.
        :param target_capacity_specification: ``AWS::EC2::EC2Fleet.TargetCapacitySpecification``.
        :param excess_capacity_termination_policy: ``AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy``.
        :param on_demand_options: ``AWS::EC2::EC2Fleet.OnDemandOptions``.
        :param replace_unhealthy_instances: ``AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances``.
        :param spot_options: ``AWS::EC2::EC2Fleet.SpotOptions``.
        :param tag_specifications: ``AWS::EC2::EC2Fleet.TagSpecifications``.
        :param terminate_instances_with_expiration: ``AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration``.
        :param type: ``AWS::EC2::EC2Fleet.Type``.
        :param valid_from: ``AWS::EC2::EC2Fleet.ValidFrom``.
        :param valid_until: ``AWS::EC2::EC2Fleet.ValidUntil``.
        """
        props = CfnEC2FleetProps(
            launch_template_configs=launch_template_configs,
            target_capacity_specification=target_capacity_specification,
            excess_capacity_termination_policy=excess_capacity_termination_policy,
            on_demand_options=on_demand_options,
            replace_unhealthy_instances=replace_unhealthy_instances,
            spot_options=spot_options,
            tag_specifications=tag_specifications,
            terminate_instances_with_expiration=terminate_instances_with_expiration,
            type=type,
            valid_from=valid_from,
            valid_until=valid_until,
        )

        jsii.create(CfnEC2Fleet, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="launchTemplateConfigs")
    def launch_template_configs(
        self,
    ) -> typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["FleetLaunchTemplateConfigRequestProperty", _IResolvable_9ceae33e]]]:
        """``AWS::EC2::EC2Fleet.LaunchTemplateConfigs``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
        """
        return jsii.get(self, "launchTemplateConfigs")

    @launch_template_configs.setter # type: ignore
    def launch_template_configs(
        self,
        value: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["FleetLaunchTemplateConfigRequestProperty", _IResolvable_9ceae33e]]],
    ) -> None:
        jsii.set(self, "launchTemplateConfigs", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="targetCapacitySpecification")
    def target_capacity_specification(
        self,
    ) -> typing.Union["TargetCapacitySpecificationRequestProperty", _IResolvable_9ceae33e]:
        """``AWS::EC2::EC2Fleet.TargetCapacitySpecification``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
        """
        return jsii.get(self, "targetCapacitySpecification")

    @target_capacity_specification.setter # type: ignore
    def target_capacity_specification(
        self,
        value: typing.Union["TargetCapacitySpecificationRequestProperty", _IResolvable_9ceae33e],
    ) -> None:
        jsii.set(self, "targetCapacitySpecification", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
        """
        return jsii.get(self, "excessCapacityTerminationPolicy")

    @excess_capacity_termination_policy.setter # type: ignore
    def excess_capacity_termination_policy(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "excessCapacityTerminationPolicy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="onDemandOptions")
    def on_demand_options(
        self,
    ) -> typing.Optional[typing.Union["OnDemandOptionsRequestProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.OnDemandOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
        """
        return jsii.get(self, "onDemandOptions")

    @on_demand_options.setter # type: ignore
    def on_demand_options(
        self,
        value: typing.Optional[typing.Union["OnDemandOptionsRequestProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "onDemandOptions", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="replaceUnhealthyInstances")
    def replace_unhealthy_instances(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
        """
        return jsii.get(self, "replaceUnhealthyInstances")

    @replace_unhealthy_instances.setter # type: ignore
    def replace_unhealthy_instances(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "replaceUnhealthyInstances", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="spotOptions")
    def spot_options(
        self,
    ) -> typing.Optional[typing.Union["SpotOptionsRequestProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.SpotOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
        """
        return jsii.get(self, "spotOptions")

    @spot_options.setter # type: ignore
    def spot_options(
        self,
        value: typing.Optional[typing.Union["SpotOptionsRequestProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "spotOptions", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tagSpecifications")
    def tag_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::EC2Fleet.TagSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
        """
        return jsii.get(self, "tagSpecifications")

    @tag_specifications.setter # type: ignore
    def tag_specifications(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["TagSpecificationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "tagSpecifications", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="terminateInstancesWithExpiration")
    def terminate_instances_with_expiration(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
        """
        return jsii.get(self, "terminateInstancesWithExpiration")

    @terminate_instances_with_expiration.setter # type: ignore
    def terminate_instances_with_expiration(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "terminateInstancesWithExpiration", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="type")
    def type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.Type``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
        """
        return jsii.get(self, "type")

    @type.setter # type: ignore
    def type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "type", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="validFrom")
    def valid_from(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.ValidFrom``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
        """
        return jsii.get(self, "validFrom")

    @valid_from.setter # type: ignore
    def valid_from(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "validFrom", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="validUntil")
    def valid_until(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.ValidUntil``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
        """
        return jsii.get(self, "validUntil")

    @valid_until.setter # type: ignore
    def valid_until(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "validUntil", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty",
        jsii_struct_bases=[],
        name_mapping={"usage_strategy": "usageStrategy"},
    )
    class CapacityReservationOptionsRequestProperty:
        def __init__(
            self,
            *,
            usage_strategy: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param usage_strategy: ``CfnEC2Fleet.CapacityReservationOptionsRequestProperty.UsageStrategy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if usage_strategy is not None:
                self._values["usage_strategy"] = usage_strategy

        @builtins.property
        def usage_strategy(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.CapacityReservationOptionsRequestProperty.UsageStrategy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html#cfn-ec2-ec2fleet-capacityreservationoptionsrequest-usagestrategy
            """
            result = self._values.get("usage_strategy")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CapacityReservationOptionsRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "launch_template_specification": "launchTemplateSpecification",
            "overrides": "overrides",
        },
    )
    class FleetLaunchTemplateConfigRequestProperty:
        def __init__(
            self,
            *,
            launch_template_specification: typing.Optional[typing.Union["CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty", _IResolvable_9ceae33e]] = None,
            overrides: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty", _IResolvable_9ceae33e]]]] = None,
        ) -> None:
            """
            :param launch_template_specification: ``CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification``.
            :param overrides: ``CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if launch_template_specification is not None:
                self._values["launch_template_specification"] = launch_template_specification
            if overrides is not None:
                self._values["overrides"] = overrides

        @builtins.property
        def launch_template_specification(
            self,
        ) -> typing.Optional[typing.Union["CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty", _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
            """
            result = self._values.get("launch_template_specification")
            return result

        @builtins.property
        def overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty", _IResolvable_9ceae33e]]]]:
            """``CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
            """
            result = self._values.get("overrides")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FleetLaunchTemplateConfigRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "availability_zone": "availabilityZone",
            "instance_type": "instanceType",
            "max_price": "maxPrice",
            "placement": "placement",
            "priority": "priority",
            "subnet_id": "subnetId",
            "weighted_capacity": "weightedCapacity",
        },
    )
    class FleetLaunchTemplateOverridesRequestProperty:
        def __init__(
            self,
            *,
            availability_zone: typing.Optional[builtins.str] = None,
            instance_type: typing.Optional[builtins.str] = None,
            max_price: typing.Optional[builtins.str] = None,
            placement: typing.Optional[typing.Union["CfnEC2Fleet.PlacementProperty", _IResolvable_9ceae33e]] = None,
            priority: typing.Optional[jsii.Number] = None,
            subnet_id: typing.Optional[builtins.str] = None,
            weighted_capacity: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param availability_zone: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone``.
            :param instance_type: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType``.
            :param max_price: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice``.
            :param placement: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement``.
            :param priority: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority``.
            :param subnet_id: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId``.
            :param weighted_capacity: ``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if availability_zone is not None:
                self._values["availability_zone"] = availability_zone
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if max_price is not None:
                self._values["max_price"] = max_price
            if placement is not None:
                self._values["placement"] = placement
            if priority is not None:
                self._values["priority"] = priority
            if subnet_id is not None:
                self._values["subnet_id"] = subnet_id
            if weighted_capacity is not None:
                self._values["weighted_capacity"] = weighted_capacity

        @builtins.property
        def availability_zone(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
            """
            result = self._values.get("availability_zone")
            return result

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
            """
            result = self._values.get("instance_type")
            return result

        @builtins.property
        def max_price(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
            """
            result = self._values.get("max_price")
            return result

        @builtins.property
        def placement(
            self,
        ) -> typing.Optional[typing.Union["CfnEC2Fleet.PlacementProperty", _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-placement
            """
            result = self._values.get("placement")
            return result

        @builtins.property
        def priority(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
            """
            result = self._values.get("priority")
            return result

        @builtins.property
        def subnet_id(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
            """
            result = self._values.get("subnet_id")
            return result

        @builtins.property
        def weighted_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
            """
            result = self._values.get("weighted_capacity")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FleetLaunchTemplateOverridesRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "launch_template_id": "launchTemplateId",
            "launch_template_name": "launchTemplateName",
            "version": "version",
        },
    )
    class FleetLaunchTemplateSpecificationRequestProperty:
        def __init__(
            self,
            *,
            launch_template_id: typing.Optional[builtins.str] = None,
            launch_template_name: typing.Optional[builtins.str] = None,
            version: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param launch_template_id: ``CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId``.
            :param launch_template_name: ``CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName``.
            :param version: ``CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if launch_template_id is not None:
                self._values["launch_template_id"] = launch_template_id
            if launch_template_name is not None:
                self._values["launch_template_name"] = launch_template_name
            if version is not None:
                self._values["version"] = version

        @builtins.property
        def launch_template_id(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
            """
            result = self._values.get("launch_template_id")
            return result

        @builtins.property
        def launch_template_name(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
            """
            result = self._values.get("launch_template_name")
            return result

        @builtins.property
        def version(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
            """
            result = self._values.get("version")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FleetLaunchTemplateSpecificationRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allocation_strategy": "allocationStrategy",
            "capacity_reservation_options": "capacityReservationOptions",
            "max_total_price": "maxTotalPrice",
            "min_target_capacity": "minTargetCapacity",
            "single_availability_zone": "singleAvailabilityZone",
            "single_instance_type": "singleInstanceType",
        },
    )
    class OnDemandOptionsRequestProperty:
        def __init__(
            self,
            *,
            allocation_strategy: typing.Optional[builtins.str] = None,
            capacity_reservation_options: typing.Optional[typing.Union["CfnEC2Fleet.CapacityReservationOptionsRequestProperty", _IResolvable_9ceae33e]] = None,
            max_total_price: typing.Optional[builtins.str] = None,
            min_target_capacity: typing.Optional[jsii.Number] = None,
            single_availability_zone: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            single_instance_type: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param allocation_strategy: ``CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy``.
            :param capacity_reservation_options: ``CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions``.
            :param max_total_price: ``CfnEC2Fleet.OnDemandOptionsRequestProperty.MaxTotalPrice``.
            :param min_target_capacity: ``CfnEC2Fleet.OnDemandOptionsRequestProperty.MinTargetCapacity``.
            :param single_availability_zone: ``CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone``.
            :param single_instance_type: ``CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if allocation_strategy is not None:
                self._values["allocation_strategy"] = allocation_strategy
            if capacity_reservation_options is not None:
                self._values["capacity_reservation_options"] = capacity_reservation_options
            if max_total_price is not None:
                self._values["max_total_price"] = max_total_price
            if min_target_capacity is not None:
                self._values["min_target_capacity"] = min_target_capacity
            if single_availability_zone is not None:
                self._values["single_availability_zone"] = single_availability_zone
            if single_instance_type is not None:
                self._values["single_instance_type"] = single_instance_type

        @builtins.property
        def allocation_strategy(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
            """
            result = self._values.get("allocation_strategy")
            return result

        @builtins.property
        def capacity_reservation_options(
            self,
        ) -> typing.Optional[typing.Union["CfnEC2Fleet.CapacityReservationOptionsRequestProperty", _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-capacityreservationoptions
            """
            result = self._values.get("capacity_reservation_options")
            return result

        @builtins.property
        def max_total_price(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.OnDemandOptionsRequestProperty.MaxTotalPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-maxtotalprice
            """
            result = self._values.get("max_total_price")
            return result

        @builtins.property
        def min_target_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.OnDemandOptionsRequestProperty.MinTargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-mintargetcapacity
            """
            result = self._values.get("min_target_capacity")
            return result

        @builtins.property
        def single_availability_zone(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleavailabilityzone
            """
            result = self._values.get("single_availability_zone")
            return result

        @builtins.property
        def single_instance_type(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleinstancetype
            """
            result = self._values.get("single_instance_type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnDemandOptionsRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.PlacementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "affinity": "affinity",
            "availability_zone": "availabilityZone",
            "group_name": "groupName",
            "host_id": "hostId",
            "host_resource_group_arn": "hostResourceGroupArn",
            "partition_number": "partitionNumber",
            "spread_domain": "spreadDomain",
            "tenancy": "tenancy",
        },
    )
    class PlacementProperty:
        def __init__(
            self,
            *,
            affinity: typing.Optional[builtins.str] = None,
            availability_zone: typing.Optional[builtins.str] = None,
            group_name: typing.Optional[builtins.str] = None,
            host_id: typing.Optional[builtins.str] = None,
            host_resource_group_arn: typing.Optional[builtins.str] = None,
            partition_number: typing.Optional[jsii.Number] = None,
            spread_domain: typing.Optional[builtins.str] = None,
            tenancy: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param affinity: ``CfnEC2Fleet.PlacementProperty.Affinity``.
            :param availability_zone: ``CfnEC2Fleet.PlacementProperty.AvailabilityZone``.
            :param group_name: ``CfnEC2Fleet.PlacementProperty.GroupName``.
            :param host_id: ``CfnEC2Fleet.PlacementProperty.HostId``.
            :param host_resource_group_arn: ``CfnEC2Fleet.PlacementProperty.HostResourceGroupArn``.
            :param partition_number: ``CfnEC2Fleet.PlacementProperty.PartitionNumber``.
            :param spread_domain: ``CfnEC2Fleet.PlacementProperty.SpreadDomain``.
            :param tenancy: ``CfnEC2Fleet.PlacementProperty.Tenancy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if affinity is not None:
                self._values["affinity"] = affinity
            if availability_zone is not None:
                self._values["availability_zone"] = availability_zone
            if group_name is not None:
                self._values["group_name"] = group_name
            if host_id is not None:
                self._values["host_id"] = host_id
            if host_resource_group_arn is not None:
                self._values["host_resource_group_arn"] = host_resource_group_arn
            if partition_number is not None:
                self._values["partition_number"] = partition_number
            if spread_domain is not None:
                self._values["spread_domain"] = spread_domain
            if tenancy is not None:
                self._values["tenancy"] = tenancy

        @builtins.property
        def affinity(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.Affinity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-affinity
            """
            result = self._values.get("affinity")
            return result

        @builtins.property
        def availability_zone(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.AvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-availabilityzone
            """
            result = self._values.get("availability_zone")
            return result

        @builtins.property
        def group_name(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.GroupName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-groupname
            """
            result = self._values.get("group_name")
            return result

        @builtins.property
        def host_id(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.HostId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostid
            """
            result = self._values.get("host_id")
            return result

        @builtins.property
        def host_resource_group_arn(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.HostResourceGroupArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostresourcegrouparn
            """
            result = self._values.get("host_resource_group_arn")
            return result

        @builtins.property
        def partition_number(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.PlacementProperty.PartitionNumber``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-partitionnumber
            """
            result = self._values.get("partition_number")
            return result

        @builtins.property
        def spread_domain(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.SpreadDomain``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-spreaddomain
            """
            result = self._values.get("spread_domain")
            return result

        @builtins.property
        def tenancy(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.PlacementProperty.Tenancy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-tenancy
            """
            result = self._values.get("tenancy")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PlacementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.SpotOptionsRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allocation_strategy": "allocationStrategy",
            "instance_interruption_behavior": "instanceInterruptionBehavior",
            "instance_pools_to_use_count": "instancePoolsToUseCount",
            "max_total_price": "maxTotalPrice",
            "min_target_capacity": "minTargetCapacity",
            "single_availability_zone": "singleAvailabilityZone",
            "single_instance_type": "singleInstanceType",
        },
    )
    class SpotOptionsRequestProperty:
        def __init__(
            self,
            *,
            allocation_strategy: typing.Optional[builtins.str] = None,
            instance_interruption_behavior: typing.Optional[builtins.str] = None,
            instance_pools_to_use_count: typing.Optional[jsii.Number] = None,
            max_total_price: typing.Optional[builtins.str] = None,
            min_target_capacity: typing.Optional[jsii.Number] = None,
            single_availability_zone: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            single_instance_type: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param allocation_strategy: ``CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy``.
            :param instance_interruption_behavior: ``CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior``.
            :param instance_pools_to_use_count: ``CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount``.
            :param max_total_price: ``CfnEC2Fleet.SpotOptionsRequestProperty.MaxTotalPrice``.
            :param min_target_capacity: ``CfnEC2Fleet.SpotOptionsRequestProperty.MinTargetCapacity``.
            :param single_availability_zone: ``CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone``.
            :param single_instance_type: ``CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if allocation_strategy is not None:
                self._values["allocation_strategy"] = allocation_strategy
            if instance_interruption_behavior is not None:
                self._values["instance_interruption_behavior"] = instance_interruption_behavior
            if instance_pools_to_use_count is not None:
                self._values["instance_pools_to_use_count"] = instance_pools_to_use_count
            if max_total_price is not None:
                self._values["max_total_price"] = max_total_price
            if min_target_capacity is not None:
                self._values["min_target_capacity"] = min_target_capacity
            if single_availability_zone is not None:
                self._values["single_availability_zone"] = single_availability_zone
            if single_instance_type is not None:
                self._values["single_instance_type"] = single_instance_type

        @builtins.property
        def allocation_strategy(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
            """
            result = self._values.get("allocation_strategy")
            return result

        @builtins.property
        def instance_interruption_behavior(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
            """
            result = self._values.get("instance_interruption_behavior")
            return result

        @builtins.property
        def instance_pools_to_use_count(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
            """
            result = self._values.get("instance_pools_to_use_count")
            return result

        @builtins.property
        def max_total_price(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.MaxTotalPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maxtotalprice
            """
            result = self._values.get("max_total_price")
            return result

        @builtins.property
        def min_target_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.MinTargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-mintargetcapacity
            """
            result = self._values.get("min_target_capacity")
            return result

        @builtins.property
        def single_availability_zone(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleavailabilityzone
            """
            result = self._values.get("single_availability_zone")
            return result

        @builtins.property
        def single_instance_type(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleinstancetype
            """
            result = self._values.get("single_instance_type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotOptionsRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.TagSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"resource_type": "resourceType", "tags": "tags"},
    )
    class TagSpecificationProperty:
        def __init__(
            self,
            *,
            resource_type: typing.Optional[builtins.str] = None,
            tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        ) -> None:
            """
            :param resource_type: ``CfnEC2Fleet.TagSpecificationProperty.ResourceType``.
            :param tags: ``CfnEC2Fleet.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if resource_type is not None:
                self._values["resource_type"] = resource_type
            if tags is not None:
                self._values["tags"] = tags

        @builtins.property
        def resource_type(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.TagSpecificationProperty.ResourceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
            """
            result = self._values.get("resource_type")
            return result

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
            """``CfnEC2Fleet.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
            """
            result = self._values.get("tags")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TagSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty",
        jsii_struct_bases=[],
        name_mapping={
            "total_target_capacity": "totalTargetCapacity",
            "default_target_capacity_type": "defaultTargetCapacityType",
            "on_demand_target_capacity": "onDemandTargetCapacity",
            "spot_target_capacity": "spotTargetCapacity",
        },
    )
    class TargetCapacitySpecificationRequestProperty:
        def __init__(
            self,
            *,
            total_target_capacity: jsii.Number,
            default_target_capacity_type: typing.Optional[builtins.str] = None,
            on_demand_target_capacity: typing.Optional[jsii.Number] = None,
            spot_target_capacity: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param total_target_capacity: ``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity``.
            :param default_target_capacity_type: ``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType``.
            :param on_demand_target_capacity: ``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity``.
            :param spot_target_capacity: ``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "total_target_capacity": total_target_capacity,
            }
            if default_target_capacity_type is not None:
                self._values["default_target_capacity_type"] = default_target_capacity_type
            if on_demand_target_capacity is not None:
                self._values["on_demand_target_capacity"] = on_demand_target_capacity
            if spot_target_capacity is not None:
                self._values["spot_target_capacity"] = spot_target_capacity

        @builtins.property
        def total_target_capacity(self) -> jsii.Number:
            """``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
            """
            result = self._values.get("total_target_capacity")
            assert result is not None, "Required property 'total_target_capacity' is missing"
            return result

        @builtins.property
        def default_target_capacity_type(self) -> typing.Optional[builtins.str]:
            """``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
            """
            result = self._values.get("default_target_capacity_type")
            return result

        @builtins.property
        def on_demand_target_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
            """
            result = self._values.get("on_demand_target_capacity")
            return result

        @builtins.property
        def spot_target_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
            """
            result = self._values.get("spot_target_capacity")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TargetCapacitySpecificationRequestProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnEC2FleetProps",
    jsii_struct_bases=[],
    name_mapping={
        "launch_template_configs": "launchTemplateConfigs",
        "target_capacity_specification": "targetCapacitySpecification",
        "excess_capacity_termination_policy": "excessCapacityTerminationPolicy",
        "on_demand_options": "onDemandOptions",
        "replace_unhealthy_instances": "replaceUnhealthyInstances",
        "spot_options": "spotOptions",
        "tag_specifications": "tagSpecifications",
        "terminate_instances_with_expiration": "terminateInstancesWithExpiration",
        "type": "type",
        "valid_from": "validFrom",
        "valid_until": "validUntil",
    },
)
class CfnEC2FleetProps:
    def __init__(
        self,
        *,
        launch_template_configs: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty", _IResolvable_9ceae33e]]],
        target_capacity_specification: typing.Union["CfnEC2Fleet.TargetCapacitySpecificationRequestProperty", _IResolvable_9ceae33e],
        excess_capacity_termination_policy: typing.Optional[builtins.str] = None,
        on_demand_options: typing.Optional[typing.Union["CfnEC2Fleet.OnDemandOptionsRequestProperty", _IResolvable_9ceae33e]] = None,
        replace_unhealthy_instances: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        spot_options: typing.Optional[typing.Union["CfnEC2Fleet.SpotOptionsRequestProperty", _IResolvable_9ceae33e]] = None,
        tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnEC2Fleet.TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        terminate_instances_with_expiration: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        type: typing.Optional[builtins.str] = None,
        valid_from: typing.Optional[builtins.str] = None,
        valid_until: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::EC2Fleet``.

        :param launch_template_configs: ``AWS::EC2::EC2Fleet.LaunchTemplateConfigs``.
        :param target_capacity_specification: ``AWS::EC2::EC2Fleet.TargetCapacitySpecification``.
        :param excess_capacity_termination_policy: ``AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy``.
        :param on_demand_options: ``AWS::EC2::EC2Fleet.OnDemandOptions``.
        :param replace_unhealthy_instances: ``AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances``.
        :param spot_options: ``AWS::EC2::EC2Fleet.SpotOptions``.
        :param tag_specifications: ``AWS::EC2::EC2Fleet.TagSpecifications``.
        :param terminate_instances_with_expiration: ``AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration``.
        :param type: ``AWS::EC2::EC2Fleet.Type``.
        :param valid_from: ``AWS::EC2::EC2Fleet.ValidFrom``.
        :param valid_until: ``AWS::EC2::EC2Fleet.ValidUntil``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "launch_template_configs": launch_template_configs,
            "target_capacity_specification": target_capacity_specification,
        }
        if excess_capacity_termination_policy is not None:
            self._values["excess_capacity_termination_policy"] = excess_capacity_termination_policy
        if on_demand_options is not None:
            self._values["on_demand_options"] = on_demand_options
        if replace_unhealthy_instances is not None:
            self._values["replace_unhealthy_instances"] = replace_unhealthy_instances
        if spot_options is not None:
            self._values["spot_options"] = spot_options
        if tag_specifications is not None:
            self._values["tag_specifications"] = tag_specifications
        if terminate_instances_with_expiration is not None:
            self._values["terminate_instances_with_expiration"] = terminate_instances_with_expiration
        if type is not None:
            self._values["type"] = type
        if valid_from is not None:
            self._values["valid_from"] = valid_from
        if valid_until is not None:
            self._values["valid_until"] = valid_until

    @builtins.property
    def launch_template_configs(
        self,
    ) -> typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty", _IResolvable_9ceae33e]]]:
        """``AWS::EC2::EC2Fleet.LaunchTemplateConfigs``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
        """
        result = self._values.get("launch_template_configs")
        assert result is not None, "Required property 'launch_template_configs' is missing"
        return result

    @builtins.property
    def target_capacity_specification(
        self,
    ) -> typing.Union["CfnEC2Fleet.TargetCapacitySpecificationRequestProperty", _IResolvable_9ceae33e]:
        """``AWS::EC2::EC2Fleet.TargetCapacitySpecification``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
        """
        result = self._values.get("target_capacity_specification")
        assert result is not None, "Required property 'target_capacity_specification' is missing"
        return result

    @builtins.property
    def excess_capacity_termination_policy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
        """
        result = self._values.get("excess_capacity_termination_policy")
        return result

    @builtins.property
    def on_demand_options(
        self,
    ) -> typing.Optional[typing.Union["CfnEC2Fleet.OnDemandOptionsRequestProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.OnDemandOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
        """
        result = self._values.get("on_demand_options")
        return result

    @builtins.property
    def replace_unhealthy_instances(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
        """
        result = self._values.get("replace_unhealthy_instances")
        return result

    @builtins.property
    def spot_options(
        self,
    ) -> typing.Optional[typing.Union["CfnEC2Fleet.SpotOptionsRequestProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.SpotOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
        """
        result = self._values.get("spot_options")
        return result

    @builtins.property
    def tag_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnEC2Fleet.TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::EC2Fleet.TagSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
        """
        result = self._values.get("tag_specifications")
        return result

    @builtins.property
    def terminate_instances_with_expiration(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
        """
        result = self._values.get("terminate_instances_with_expiration")
        return result

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.Type``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
        """
        result = self._values.get("type")
        return result

    @builtins.property
    def valid_from(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.ValidFrom``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
        """
        result = self._values.get("valid_from")
        return result

    @builtins.property
    def valid_until(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EC2Fleet.ValidUntil``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
        """
        result = self._values.get("valid_until")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEC2FleetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnEIP(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnEIP",
):
    """A CloudFormation ``AWS::EC2::EIP``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::EIP
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        domain: typing.Optional[builtins.str] = None,
        instance_id: typing.Optional[builtins.str] = None,
        public_ipv4_pool: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::EIP``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param domain: ``AWS::EC2::EIP.Domain``.
        :param instance_id: ``AWS::EC2::EIP.InstanceId``.
        :param public_ipv4_pool: ``AWS::EC2::EIP.PublicIpv4Pool``.
        :param tags: ``AWS::EC2::EIP.Tags``.
        """
        props = CfnEIPProps(
            domain=domain,
            instance_id=instance_id,
            public_ipv4_pool=public_ipv4_pool,
            tags=tags,
        )

        jsii.create(CfnEIP, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAllocationId")
    def attr_allocation_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AllocationId
        """
        return jsii.get(self, "attrAllocationId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::EIP.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="domain")
    def domain(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIP.Domain``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
        """
        return jsii.get(self, "domain")

    @domain.setter # type: ignore
    def domain(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "domain", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceId")
    def instance_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIP.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
        """
        return jsii.get(self, "instanceId")

    @instance_id.setter # type: ignore
    def instance_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "instanceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="publicIpv4Pool")
    def public_ipv4_pool(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIP.PublicIpv4Pool``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
        """
        return jsii.get(self, "publicIpv4Pool")

    @public_ipv4_pool.setter # type: ignore
    def public_ipv4_pool(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "publicIpv4Pool", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnEIPAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnEIPAssociation",
):
    """A CloudFormation ``AWS::EC2::EIPAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::EIPAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        allocation_id: typing.Optional[builtins.str] = None,
        eip: typing.Optional[builtins.str] = None,
        instance_id: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::EIPAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param allocation_id: ``AWS::EC2::EIPAssociation.AllocationId``.
        :param eip: ``AWS::EC2::EIPAssociation.EIP``.
        :param instance_id: ``AWS::EC2::EIPAssociation.InstanceId``.
        :param network_interface_id: ``AWS::EC2::EIPAssociation.NetworkInterfaceId``.
        :param private_ip_address: ``AWS::EC2::EIPAssociation.PrivateIpAddress``.
        """
        props = CfnEIPAssociationProps(
            allocation_id=allocation_id,
            eip=eip,
            instance_id=instance_id,
            network_interface_id=network_interface_id,
            private_ip_address=private_ip_address,
        )

        jsii.create(CfnEIPAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allocationId")
    def allocation_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.AllocationId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
        """
        return jsii.get(self, "allocationId")

    @allocation_id.setter # type: ignore
    def allocation_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "allocationId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="eip")
    def eip(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.EIP``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
        """
        return jsii.get(self, "eip")

    @eip.setter # type: ignore
    def eip(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "eip", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceId")
    def instance_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
        """
        return jsii.get(self, "instanceId")

    @instance_id.setter # type: ignore
    def instance_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "instanceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaceId")
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
        """
        return jsii.get(self, "networkInterfaceId")

    @network_interface_id.setter # type: ignore
    def network_interface_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "networkInterfaceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="privateIpAddress")
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
        """
        return jsii.get(self, "privateIpAddress")

    @private_ip_address.setter # type: ignore
    def private_ip_address(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "privateIpAddress", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnEIPAssociationProps",
    jsii_struct_bases=[],
    name_mapping={
        "allocation_id": "allocationId",
        "eip": "eip",
        "instance_id": "instanceId",
        "network_interface_id": "networkInterfaceId",
        "private_ip_address": "privateIpAddress",
    },
)
class CfnEIPAssociationProps:
    def __init__(
        self,
        *,
        allocation_id: typing.Optional[builtins.str] = None,
        eip: typing.Optional[builtins.str] = None,
        instance_id: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::EIPAssociation``.

        :param allocation_id: ``AWS::EC2::EIPAssociation.AllocationId``.
        :param eip: ``AWS::EC2::EIPAssociation.EIP``.
        :param instance_id: ``AWS::EC2::EIPAssociation.InstanceId``.
        :param network_interface_id: ``AWS::EC2::EIPAssociation.NetworkInterfaceId``.
        :param private_ip_address: ``AWS::EC2::EIPAssociation.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if allocation_id is not None:
            self._values["allocation_id"] = allocation_id
        if eip is not None:
            self._values["eip"] = eip
        if instance_id is not None:
            self._values["instance_id"] = instance_id
        if network_interface_id is not None:
            self._values["network_interface_id"] = network_interface_id
        if private_ip_address is not None:
            self._values["private_ip_address"] = private_ip_address

    @builtins.property
    def allocation_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.AllocationId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
        """
        result = self._values.get("allocation_id")
        return result

    @builtins.property
    def eip(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.EIP``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
        """
        result = self._values.get("eip")
        return result

    @builtins.property
    def instance_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
        """
        result = self._values.get("instance_id")
        return result

    @builtins.property
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
        """
        result = self._values.get("network_interface_id")
        return result

    @builtins.property
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIPAssociation.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
        """
        result = self._values.get("private_ip_address")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEIPAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnEIPProps",
    jsii_struct_bases=[],
    name_mapping={
        "domain": "domain",
        "instance_id": "instanceId",
        "public_ipv4_pool": "publicIpv4Pool",
        "tags": "tags",
    },
)
class CfnEIPProps:
    def __init__(
        self,
        *,
        domain: typing.Optional[builtins.str] = None,
        instance_id: typing.Optional[builtins.str] = None,
        public_ipv4_pool: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::EIP``.

        :param domain: ``AWS::EC2::EIP.Domain``.
        :param instance_id: ``AWS::EC2::EIP.InstanceId``.
        :param public_ipv4_pool: ``AWS::EC2::EIP.PublicIpv4Pool``.
        :param tags: ``AWS::EC2::EIP.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if domain is not None:
            self._values["domain"] = domain
        if instance_id is not None:
            self._values["instance_id"] = instance_id
        if public_ipv4_pool is not None:
            self._values["public_ipv4_pool"] = public_ipv4_pool
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def domain(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIP.Domain``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
        """
        result = self._values.get("domain")
        return result

    @builtins.property
    def instance_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIP.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
        """
        result = self._values.get("instance_id")
        return result

    @builtins.property
    def public_ipv4_pool(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::EIP.PublicIpv4Pool``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
        """
        result = self._values.get("public_ipv4_pool")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::EIP.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEIPProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnEgressOnlyInternetGateway(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnEgressOnlyInternetGateway",
):
    """A CloudFormation ``AWS::EC2::EgressOnlyInternetGateway``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::EgressOnlyInternetGateway
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        vpc_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::EgressOnlyInternetGateway``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param vpc_id: ``AWS::EC2::EgressOnlyInternetGateway.VpcId``.
        """
        props = CfnEgressOnlyInternetGatewayProps(vpc_id=vpc_id)

        jsii.create(CfnEgressOnlyInternetGateway, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::EgressOnlyInternetGateway.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnEgressOnlyInternetGatewayProps",
    jsii_struct_bases=[],
    name_mapping={"vpc_id": "vpcId"},
)
class CfnEgressOnlyInternetGatewayProps:
    def __init__(self, *, vpc_id: builtins.str) -> None:
        """Properties for defining a ``AWS::EC2::EgressOnlyInternetGateway``.

        :param vpc_id: ``AWS::EC2::EgressOnlyInternetGateway.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "vpc_id": vpc_id,
        }

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::EgressOnlyInternetGateway.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEgressOnlyInternetGatewayProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnFlowLog(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnFlowLog",
):
    """A CloudFormation ``AWS::EC2::FlowLog``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::FlowLog
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        resource_id: builtins.str,
        resource_type: builtins.str,
        traffic_type: builtins.str,
        deliver_logs_permission_arn: typing.Optional[builtins.str] = None,
        log_destination: typing.Optional[builtins.str] = None,
        log_destination_type: typing.Optional[builtins.str] = None,
        log_format: typing.Optional[builtins.str] = None,
        log_group_name: typing.Optional[builtins.str] = None,
        max_aggregation_interval: typing.Optional[jsii.Number] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::FlowLog``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param resource_id: ``AWS::EC2::FlowLog.ResourceId``.
        :param resource_type: ``AWS::EC2::FlowLog.ResourceType``.
        :param traffic_type: ``AWS::EC2::FlowLog.TrafficType``.
        :param deliver_logs_permission_arn: ``AWS::EC2::FlowLog.DeliverLogsPermissionArn``.
        :param log_destination: ``AWS::EC2::FlowLog.LogDestination``.
        :param log_destination_type: ``AWS::EC2::FlowLog.LogDestinationType``.
        :param log_format: ``AWS::EC2::FlowLog.LogFormat``.
        :param log_group_name: ``AWS::EC2::FlowLog.LogGroupName``.
        :param max_aggregation_interval: ``AWS::EC2::FlowLog.MaxAggregationInterval``.
        :param tags: ``AWS::EC2::FlowLog.Tags``.
        """
        props = CfnFlowLogProps(
            resource_id=resource_id,
            resource_type=resource_type,
            traffic_type=traffic_type,
            deliver_logs_permission_arn=deliver_logs_permission_arn,
            log_destination=log_destination,
            log_destination_type=log_destination_type,
            log_format=log_format,
            log_group_name=log_group_name,
            max_aggregation_interval=max_aggregation_interval,
            tags=tags,
        )

        jsii.create(CfnFlowLog, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Id
        """
        return jsii.get(self, "attrId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::FlowLog.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> builtins.str:
        """``AWS::EC2::FlowLog.ResourceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
        """
        return jsii.get(self, "resourceId")

    @resource_id.setter # type: ignore
    def resource_id(self, value: builtins.str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        """``AWS::EC2::FlowLog.ResourceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
        """
        return jsii.get(self, "resourceType")

    @resource_type.setter # type: ignore
    def resource_type(self, value: builtins.str) -> None:
        jsii.set(self, "resourceType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="trafficType")
    def traffic_type(self) -> builtins.str:
        """``AWS::EC2::FlowLog.TrafficType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
        """
        return jsii.get(self, "trafficType")

    @traffic_type.setter # type: ignore
    def traffic_type(self, value: builtins.str) -> None:
        jsii.set(self, "trafficType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deliverLogsPermissionArn")
    def deliver_logs_permission_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.DeliverLogsPermissionArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
        """
        return jsii.get(self, "deliverLogsPermissionArn")

    @deliver_logs_permission_arn.setter # type: ignore
    def deliver_logs_permission_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "deliverLogsPermissionArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logDestination")
    def log_destination(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogDestination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
        """
        return jsii.get(self, "logDestination")

    @log_destination.setter # type: ignore
    def log_destination(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "logDestination", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logDestinationType")
    def log_destination_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogDestinationType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
        """
        return jsii.get(self, "logDestinationType")

    @log_destination_type.setter # type: ignore
    def log_destination_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "logDestinationType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logFormat")
    def log_format(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogFormat``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
        """
        return jsii.get(self, "logFormat")

    @log_format.setter # type: ignore
    def log_format(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "logFormat", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="logGroupName")
    def log_group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogGroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
        """
        return jsii.get(self, "logGroupName")

    @log_group_name.setter # type: ignore
    def log_group_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "logGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="maxAggregationInterval")
    def max_aggregation_interval(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::FlowLog.MaxAggregationInterval``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
        """
        return jsii.get(self, "maxAggregationInterval")

    @max_aggregation_interval.setter # type: ignore
    def max_aggregation_interval(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "maxAggregationInterval", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnFlowLogProps",
    jsii_struct_bases=[],
    name_mapping={
        "resource_id": "resourceId",
        "resource_type": "resourceType",
        "traffic_type": "trafficType",
        "deliver_logs_permission_arn": "deliverLogsPermissionArn",
        "log_destination": "logDestination",
        "log_destination_type": "logDestinationType",
        "log_format": "logFormat",
        "log_group_name": "logGroupName",
        "max_aggregation_interval": "maxAggregationInterval",
        "tags": "tags",
    },
)
class CfnFlowLogProps:
    def __init__(
        self,
        *,
        resource_id: builtins.str,
        resource_type: builtins.str,
        traffic_type: builtins.str,
        deliver_logs_permission_arn: typing.Optional[builtins.str] = None,
        log_destination: typing.Optional[builtins.str] = None,
        log_destination_type: typing.Optional[builtins.str] = None,
        log_format: typing.Optional[builtins.str] = None,
        log_group_name: typing.Optional[builtins.str] = None,
        max_aggregation_interval: typing.Optional[jsii.Number] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::FlowLog``.

        :param resource_id: ``AWS::EC2::FlowLog.ResourceId``.
        :param resource_type: ``AWS::EC2::FlowLog.ResourceType``.
        :param traffic_type: ``AWS::EC2::FlowLog.TrafficType``.
        :param deliver_logs_permission_arn: ``AWS::EC2::FlowLog.DeliverLogsPermissionArn``.
        :param log_destination: ``AWS::EC2::FlowLog.LogDestination``.
        :param log_destination_type: ``AWS::EC2::FlowLog.LogDestinationType``.
        :param log_format: ``AWS::EC2::FlowLog.LogFormat``.
        :param log_group_name: ``AWS::EC2::FlowLog.LogGroupName``.
        :param max_aggregation_interval: ``AWS::EC2::FlowLog.MaxAggregationInterval``.
        :param tags: ``AWS::EC2::FlowLog.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "resource_id": resource_id,
            "resource_type": resource_type,
            "traffic_type": traffic_type,
        }
        if deliver_logs_permission_arn is not None:
            self._values["deliver_logs_permission_arn"] = deliver_logs_permission_arn
        if log_destination is not None:
            self._values["log_destination"] = log_destination
        if log_destination_type is not None:
            self._values["log_destination_type"] = log_destination_type
        if log_format is not None:
            self._values["log_format"] = log_format
        if log_group_name is not None:
            self._values["log_group_name"] = log_group_name
        if max_aggregation_interval is not None:
            self._values["max_aggregation_interval"] = max_aggregation_interval
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def resource_id(self) -> builtins.str:
        """``AWS::EC2::FlowLog.ResourceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
        """
        result = self._values.get("resource_id")
        assert result is not None, "Required property 'resource_id' is missing"
        return result

    @builtins.property
    def resource_type(self) -> builtins.str:
        """``AWS::EC2::FlowLog.ResourceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
        """
        result = self._values.get("resource_type")
        assert result is not None, "Required property 'resource_type' is missing"
        return result

    @builtins.property
    def traffic_type(self) -> builtins.str:
        """``AWS::EC2::FlowLog.TrafficType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
        """
        result = self._values.get("traffic_type")
        assert result is not None, "Required property 'traffic_type' is missing"
        return result

    @builtins.property
    def deliver_logs_permission_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.DeliverLogsPermissionArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
        """
        result = self._values.get("deliver_logs_permission_arn")
        return result

    @builtins.property
    def log_destination(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogDestination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
        """
        result = self._values.get("log_destination")
        return result

    @builtins.property
    def log_destination_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogDestinationType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
        """
        result = self._values.get("log_destination_type")
        return result

    @builtins.property
    def log_format(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogFormat``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logformat
        """
        result = self._values.get("log_format")
        return result

    @builtins.property
    def log_group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::FlowLog.LogGroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
        """
        result = self._values.get("log_group_name")
        return result

    @builtins.property
    def max_aggregation_interval(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::FlowLog.MaxAggregationInterval``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval
        """
        result = self._values.get("max_aggregation_interval")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::FlowLog.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnFlowLogProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnGatewayRouteTableAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnGatewayRouteTableAssociation",
):
    """A CloudFormation ``AWS::EC2::GatewayRouteTableAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::GatewayRouteTableAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        gateway_id: builtins.str,
        route_table_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::GatewayRouteTableAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param gateway_id: ``AWS::EC2::GatewayRouteTableAssociation.GatewayId``.
        :param route_table_id: ``AWS::EC2::GatewayRouteTableAssociation.RouteTableId``.
        """
        props = CfnGatewayRouteTableAssociationProps(
            gateway_id=gateway_id, route_table_id=route_table_id
        )

        jsii.create(CfnGatewayRouteTableAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAssociationId")
    def attr_association_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AssociationId
        """
        return jsii.get(self, "attrAssociationId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="gatewayId")
    def gateway_id(self) -> builtins.str:
        """``AWS::EC2::GatewayRouteTableAssociation.GatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-gatewayid
        """
        return jsii.get(self, "gatewayId")

    @gateway_id.setter # type: ignore
    def gateway_id(self, value: builtins.str) -> None:
        jsii.set(self, "gatewayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeTableId")
    def route_table_id(self) -> builtins.str:
        """``AWS::EC2::GatewayRouteTableAssociation.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-routetableid
        """
        return jsii.get(self, "routeTableId")

    @route_table_id.setter # type: ignore
    def route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "routeTableId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnGatewayRouteTableAssociationProps",
    jsii_struct_bases=[],
    name_mapping={"gateway_id": "gatewayId", "route_table_id": "routeTableId"},
)
class CfnGatewayRouteTableAssociationProps:
    def __init__(
        self,
        *,
        gateway_id: builtins.str,
        route_table_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::GatewayRouteTableAssociation``.

        :param gateway_id: ``AWS::EC2::GatewayRouteTableAssociation.GatewayId``.
        :param route_table_id: ``AWS::EC2::GatewayRouteTableAssociation.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "gateway_id": gateway_id,
            "route_table_id": route_table_id,
        }

    @builtins.property
    def gateway_id(self) -> builtins.str:
        """``AWS::EC2::GatewayRouteTableAssociation.GatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-gatewayid
        """
        result = self._values.get("gateway_id")
        assert result is not None, "Required property 'gateway_id' is missing"
        return result

    @builtins.property
    def route_table_id(self) -> builtins.str:
        """``AWS::EC2::GatewayRouteTableAssociation.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-gatewayroutetableassociation.html#cfn-ec2-gatewayroutetableassociation-routetableid
        """
        result = self._values.get("route_table_id")
        assert result is not None, "Required property 'route_table_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnGatewayRouteTableAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnHost(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnHost",
):
    """A CloudFormation ``AWS::EC2::Host``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::Host
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        availability_zone: builtins.str,
        instance_type: builtins.str,
        auto_placement: typing.Optional[builtins.str] = None,
        host_recovery: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::Host``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param availability_zone: ``AWS::EC2::Host.AvailabilityZone``.
        :param instance_type: ``AWS::EC2::Host.InstanceType``.
        :param auto_placement: ``AWS::EC2::Host.AutoPlacement``.
        :param host_recovery: ``AWS::EC2::Host.HostRecovery``.
        """
        props = CfnHostProps(
            availability_zone=availability_zone,
            instance_type=instance_type,
            auto_placement=auto_placement,
            host_recovery=host_recovery,
        )

        jsii.create(CfnHost, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        """``AWS::EC2::Host.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
        """
        return jsii.get(self, "availabilityZone")

    @availability_zone.setter # type: ignore
    def availability_zone(self, value: builtins.str) -> None:
        jsii.set(self, "availabilityZone", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceType")
    def instance_type(self) -> builtins.str:
        """``AWS::EC2::Host.InstanceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
        """
        return jsii.get(self, "instanceType")

    @instance_type.setter # type: ignore
    def instance_type(self, value: builtins.str) -> None:
        jsii.set(self, "instanceType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="autoPlacement")
    def auto_placement(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Host.AutoPlacement``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
        """
        return jsii.get(self, "autoPlacement")

    @auto_placement.setter # type: ignore
    def auto_placement(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "autoPlacement", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostRecovery")
    def host_recovery(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Host.HostRecovery``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
        """
        return jsii.get(self, "hostRecovery")

    @host_recovery.setter # type: ignore
    def host_recovery(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "hostRecovery", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnHostProps",
    jsii_struct_bases=[],
    name_mapping={
        "availability_zone": "availabilityZone",
        "instance_type": "instanceType",
        "auto_placement": "autoPlacement",
        "host_recovery": "hostRecovery",
    },
)
class CfnHostProps:
    def __init__(
        self,
        *,
        availability_zone: builtins.str,
        instance_type: builtins.str,
        auto_placement: typing.Optional[builtins.str] = None,
        host_recovery: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::Host``.

        :param availability_zone: ``AWS::EC2::Host.AvailabilityZone``.
        :param instance_type: ``AWS::EC2::Host.InstanceType``.
        :param auto_placement: ``AWS::EC2::Host.AutoPlacement``.
        :param host_recovery: ``AWS::EC2::Host.HostRecovery``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "availability_zone": availability_zone,
            "instance_type": instance_type,
        }
        if auto_placement is not None:
            self._values["auto_placement"] = auto_placement
        if host_recovery is not None:
            self._values["host_recovery"] = host_recovery

    @builtins.property
    def availability_zone(self) -> builtins.str:
        """``AWS::EC2::Host.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
        """
        result = self._values.get("availability_zone")
        assert result is not None, "Required property 'availability_zone' is missing"
        return result

    @builtins.property
    def instance_type(self) -> builtins.str:
        """``AWS::EC2::Host.InstanceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
        """
        result = self._values.get("instance_type")
        assert result is not None, "Required property 'instance_type' is missing"
        return result

    @builtins.property
    def auto_placement(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Host.AutoPlacement``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
        """
        result = self._values.get("auto_placement")
        return result

    @builtins.property
    def host_recovery(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Host.HostRecovery``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
        """
        result = self._values.get("host_recovery")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnHostProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnInstance(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnInstance",
):
    """A CloudFormation ``AWS::EC2::Instance``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::Instance
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        additional_info: typing.Optional[builtins.str] = None,
        affinity: typing.Optional[builtins.str] = None,
        availability_zone: typing.Optional[builtins.str] = None,
        block_device_mappings: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]] = None,
        cpu_options: typing.Optional[typing.Union["CpuOptionsProperty", _IResolvable_9ceae33e]] = None,
        credit_specification: typing.Optional[typing.Union["CreditSpecificationProperty", _IResolvable_9ceae33e]] = None,
        disable_api_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ebs_optimized: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        elastic_gpu_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        elastic_inference_accelerators: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]] = None,
        hibernation_options: typing.Optional[typing.Union["HibernationOptionsProperty", _IResolvable_9ceae33e]] = None,
        host_id: typing.Optional[builtins.str] = None,
        host_resource_group_arn: typing.Optional[builtins.str] = None,
        iam_instance_profile: typing.Optional[builtins.str] = None,
        image_id: typing.Optional[builtins.str] = None,
        instance_initiated_shutdown_behavior: typing.Optional[builtins.str] = None,
        instance_type: typing.Optional[builtins.str] = None,
        ipv6_address_count: typing.Optional[jsii.Number] = None,
        ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]] = None,
        kernel_id: typing.Optional[builtins.str] = None,
        key_name: typing.Optional[builtins.str] = None,
        launch_template: typing.Optional[typing.Union["LaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]] = None,
        license_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["LicenseSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        monitoring: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        network_interfaces: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["NetworkInterfaceProperty", _IResolvable_9ceae33e]]]] = None,
        placement_group_name: typing.Optional[builtins.str] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
        ramdisk_id: typing.Optional[builtins.str] = None,
        security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
        security_groups: typing.Optional[typing.List[builtins.str]] = None,
        source_dest_check: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ssm_associations: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["SsmAssociationProperty", _IResolvable_9ceae33e]]]] = None,
        subnet_id: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        tenancy: typing.Optional[builtins.str] = None,
        user_data: typing.Optional[builtins.str] = None,
        volumes: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["VolumeProperty", _IResolvable_9ceae33e]]]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::Instance``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param additional_info: ``AWS::EC2::Instance.AdditionalInfo``.
        :param affinity: ``AWS::EC2::Instance.Affinity``.
        :param availability_zone: ``AWS::EC2::Instance.AvailabilityZone``.
        :param block_device_mappings: ``AWS::EC2::Instance.BlockDeviceMappings``.
        :param cpu_options: ``AWS::EC2::Instance.CpuOptions``.
        :param credit_specification: ``AWS::EC2::Instance.CreditSpecification``.
        :param disable_api_termination: ``AWS::EC2::Instance.DisableApiTermination``.
        :param ebs_optimized: ``AWS::EC2::Instance.EbsOptimized``.
        :param elastic_gpu_specifications: ``AWS::EC2::Instance.ElasticGpuSpecifications``.
        :param elastic_inference_accelerators: ``AWS::EC2::Instance.ElasticInferenceAccelerators``.
        :param hibernation_options: ``AWS::EC2::Instance.HibernationOptions``.
        :param host_id: ``AWS::EC2::Instance.HostId``.
        :param host_resource_group_arn: ``AWS::EC2::Instance.HostResourceGroupArn``.
        :param iam_instance_profile: ``AWS::EC2::Instance.IamInstanceProfile``.
        :param image_id: ``AWS::EC2::Instance.ImageId``.
        :param instance_initiated_shutdown_behavior: ``AWS::EC2::Instance.InstanceInitiatedShutdownBehavior``.
        :param instance_type: ``AWS::EC2::Instance.InstanceType``.
        :param ipv6_address_count: ``AWS::EC2::Instance.Ipv6AddressCount``.
        :param ipv6_addresses: ``AWS::EC2::Instance.Ipv6Addresses``.
        :param kernel_id: ``AWS::EC2::Instance.KernelId``.
        :param key_name: ``AWS::EC2::Instance.KeyName``.
        :param launch_template: ``AWS::EC2::Instance.LaunchTemplate``.
        :param license_specifications: ``AWS::EC2::Instance.LicenseSpecifications``.
        :param monitoring: ``AWS::EC2::Instance.Monitoring``.
        :param network_interfaces: ``AWS::EC2::Instance.NetworkInterfaces``.
        :param placement_group_name: ``AWS::EC2::Instance.PlacementGroupName``.
        :param private_ip_address: ``AWS::EC2::Instance.PrivateIpAddress``.
        :param ramdisk_id: ``AWS::EC2::Instance.RamdiskId``.
        :param security_group_ids: ``AWS::EC2::Instance.SecurityGroupIds``.
        :param security_groups: ``AWS::EC2::Instance.SecurityGroups``.
        :param source_dest_check: ``AWS::EC2::Instance.SourceDestCheck``.
        :param ssm_associations: ``AWS::EC2::Instance.SsmAssociations``.
        :param subnet_id: ``AWS::EC2::Instance.SubnetId``.
        :param tags: ``AWS::EC2::Instance.Tags``.
        :param tenancy: ``AWS::EC2::Instance.Tenancy``.
        :param user_data: ``AWS::EC2::Instance.UserData``.
        :param volumes: ``AWS::EC2::Instance.Volumes``.
        """
        props = CfnInstanceProps(
            additional_info=additional_info,
            affinity=affinity,
            availability_zone=availability_zone,
            block_device_mappings=block_device_mappings,
            cpu_options=cpu_options,
            credit_specification=credit_specification,
            disable_api_termination=disable_api_termination,
            ebs_optimized=ebs_optimized,
            elastic_gpu_specifications=elastic_gpu_specifications,
            elastic_inference_accelerators=elastic_inference_accelerators,
            hibernation_options=hibernation_options,
            host_id=host_id,
            host_resource_group_arn=host_resource_group_arn,
            iam_instance_profile=iam_instance_profile,
            image_id=image_id,
            instance_initiated_shutdown_behavior=instance_initiated_shutdown_behavior,
            instance_type=instance_type,
            ipv6_address_count=ipv6_address_count,
            ipv6_addresses=ipv6_addresses,
            kernel_id=kernel_id,
            key_name=key_name,
            launch_template=launch_template,
            license_specifications=license_specifications,
            monitoring=monitoring,
            network_interfaces=network_interfaces,
            placement_group_name=placement_group_name,
            private_ip_address=private_ip_address,
            ramdisk_id=ramdisk_id,
            security_group_ids=security_group_ids,
            security_groups=security_groups,
            source_dest_check=source_dest_check,
            ssm_associations=ssm_associations,
            subnet_id=subnet_id,
            tags=tags,
            tenancy=tenancy,
            user_data=user_data,
            volumes=volumes,
        )

        jsii.create(CfnInstance, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAvailabilityZone")
    def attr_availability_zone(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AvailabilityZone
        """
        return jsii.get(self, "attrAvailabilityZone")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrPrivateDnsName")
    def attr_private_dns_name(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: PrivateDnsName
        """
        return jsii.get(self, "attrPrivateDnsName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrPrivateIp")
    def attr_private_ip(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: PrivateIp
        """
        return jsii.get(self, "attrPrivateIp")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrPublicDnsName")
    def attr_public_dns_name(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: PublicDnsName
        """
        return jsii.get(self, "attrPublicDnsName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrPublicIp")
    def attr_public_ip(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: PublicIp
        """
        return jsii.get(self, "attrPublicIp")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::Instance.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="additionalInfo")
    def additional_info(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.AdditionalInfo``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
        """
        return jsii.get(self, "additionalInfo")

    @additional_info.setter # type: ignore
    def additional_info(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "additionalInfo", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="affinity")
    def affinity(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.Affinity``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
        """
        return jsii.get(self, "affinity")

    @affinity.setter # type: ignore
    def affinity(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "affinity", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="availabilityZone")
    def availability_zone(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
        """
        return jsii.get(self, "availabilityZone")

    @availability_zone.setter # type: ignore
    def availability_zone(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "availabilityZone", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="blockDeviceMappings")
    def block_device_mappings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.BlockDeviceMappings``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
        """
        return jsii.get(self, "blockDeviceMappings")

    @block_device_mappings.setter # type: ignore
    def block_device_mappings(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "blockDeviceMappings", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cpuOptions")
    def cpu_options(
        self,
    ) -> typing.Optional[typing.Union["CpuOptionsProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.CpuOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
        """
        return jsii.get(self, "cpuOptions")

    @cpu_options.setter # type: ignore
    def cpu_options(
        self,
        value: typing.Optional[typing.Union["CpuOptionsProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "cpuOptions", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="creditSpecification")
    def credit_specification(
        self,
    ) -> typing.Optional[typing.Union["CreditSpecificationProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.CreditSpecification``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
        """
        return jsii.get(self, "creditSpecification")

    @credit_specification.setter # type: ignore
    def credit_specification(
        self,
        value: typing.Optional[typing.Union["CreditSpecificationProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "creditSpecification", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="disableApiTermination")
    def disable_api_termination(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.DisableApiTermination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
        """
        return jsii.get(self, "disableApiTermination")

    @disable_api_termination.setter # type: ignore
    def disable_api_termination(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "disableApiTermination", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ebsOptimized")
    def ebs_optimized(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.EbsOptimized``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
        """
        return jsii.get(self, "ebsOptimized")

    @ebs_optimized.setter # type: ignore
    def ebs_optimized(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "ebsOptimized", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="elasticGpuSpecifications")
    def elastic_gpu_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.ElasticGpuSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
        """
        return jsii.get(self, "elasticGpuSpecifications")

    @elastic_gpu_specifications.setter # type: ignore
    def elastic_gpu_specifications(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "elasticGpuSpecifications", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="elasticInferenceAccelerators")
    def elastic_inference_accelerators(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.ElasticInferenceAccelerators``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
        """
        return jsii.get(self, "elasticInferenceAccelerators")

    @elastic_inference_accelerators.setter # type: ignore
    def elastic_inference_accelerators(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["ElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "elasticInferenceAccelerators", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hibernationOptions")
    def hibernation_options(
        self,
    ) -> typing.Optional[typing.Union["HibernationOptionsProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.HibernationOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hibernationoptions
        """
        return jsii.get(self, "hibernationOptions")

    @hibernation_options.setter # type: ignore
    def hibernation_options(
        self,
        value: typing.Optional[typing.Union["HibernationOptionsProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "hibernationOptions", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostId")
    def host_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.HostId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
        """
        return jsii.get(self, "hostId")

    @host_id.setter # type: ignore
    def host_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "hostId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.HostResourceGroupArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostresourcegrouparn
        """
        return jsii.get(self, "hostResourceGroupArn")

    @host_resource_group_arn.setter # type: ignore
    def host_resource_group_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "hostResourceGroupArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="iamInstanceProfile")
    def iam_instance_profile(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.IamInstanceProfile``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
        """
        return jsii.get(self, "iamInstanceProfile")

    @iam_instance_profile.setter # type: ignore
    def iam_instance_profile(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "iamInstanceProfile", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="imageId")
    def image_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.ImageId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
        """
        return jsii.get(self, "imageId")

    @image_id.setter # type: ignore
    def image_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "imageId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.InstanceInitiatedShutdownBehavior``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
        """
        return jsii.get(self, "instanceInitiatedShutdownBehavior")

    @instance_initiated_shutdown_behavior.setter # type: ignore
    def instance_initiated_shutdown_behavior(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "instanceInitiatedShutdownBehavior", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceType")
    def instance_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.InstanceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
        """
        return jsii.get(self, "instanceType")

    @instance_type.setter # type: ignore
    def instance_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "instanceType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6AddressCount")
    def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::Instance.Ipv6AddressCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
        """
        return jsii.get(self, "ipv6AddressCount")

    @ipv6_address_count.setter # type: ignore
    def ipv6_address_count(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "ipv6AddressCount", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6Addresses")
    def ipv6_addresses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.Ipv6Addresses``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
        """
        return jsii.get(self, "ipv6Addresses")

    @ipv6_addresses.setter # type: ignore
    def ipv6_addresses(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "ipv6Addresses", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="kernelId")
    def kernel_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.KernelId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
        """
        return jsii.get(self, "kernelId")

    @kernel_id.setter # type: ignore
    def kernel_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "kernelId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="keyName")
    def key_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.KeyName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
        """
        return jsii.get(self, "keyName")

    @key_name.setter # type: ignore
    def key_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "keyName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="launchTemplate")
    def launch_template(
        self,
    ) -> typing.Optional[typing.Union["LaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.LaunchTemplate``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
        """
        return jsii.get(self, "launchTemplate")

    @launch_template.setter # type: ignore
    def launch_template(
        self,
        value: typing.Optional[typing.Union["LaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "launchTemplate", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="licenseSpecifications")
    def license_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["LicenseSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.LicenseSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
        """
        return jsii.get(self, "licenseSpecifications")

    @license_specifications.setter # type: ignore
    def license_specifications(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["LicenseSpecificationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "licenseSpecifications", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="monitoring")
    def monitoring(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.Monitoring``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
        """
        return jsii.get(self, "monitoring")

    @monitoring.setter # type: ignore
    def monitoring(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "monitoring", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaces")
    def network_interfaces(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["NetworkInterfaceProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.NetworkInterfaces``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
        """
        return jsii.get(self, "networkInterfaces")

    @network_interfaces.setter # type: ignore
    def network_interfaces(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["NetworkInterfaceProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "networkInterfaces", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="placementGroupName")
    def placement_group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.PlacementGroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
        """
        return jsii.get(self, "placementGroupName")

    @placement_group_name.setter # type: ignore
    def placement_group_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "placementGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="privateIpAddress")
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
        """
        return jsii.get(self, "privateIpAddress")

    @private_ip_address.setter # type: ignore
    def private_ip_address(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "privateIpAddress", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ramdiskId")
    def ramdisk_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.RamdiskId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
        """
        return jsii.get(self, "ramdiskId")

    @ramdisk_id.setter # type: ignore
    def ramdisk_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "ramdiskId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroupIds")
    def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::Instance.SecurityGroupIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
        """
        return jsii.get(self, "securityGroupIds")

    @security_group_ids.setter # type: ignore
    def security_group_ids(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "securityGroupIds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroups")
    def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::Instance.SecurityGroups``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
        """
        return jsii.get(self, "securityGroups")

    @security_groups.setter # type: ignore
    def security_groups(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "securityGroups", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceDestCheck")
    def source_dest_check(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.SourceDestCheck``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
        """
        return jsii.get(self, "sourceDestCheck")

    @source_dest_check.setter # type: ignore
    def source_dest_check(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "sourceDestCheck", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ssmAssociations")
    def ssm_associations(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["SsmAssociationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.SsmAssociations``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
        """
        return jsii.get(self, "ssmAssociations")

    @ssm_associations.setter # type: ignore
    def ssm_associations(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["SsmAssociationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "ssmAssociations", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "subnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tenancy")
    def tenancy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.Tenancy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
        """
        return jsii.get(self, "tenancy")

    @tenancy.setter # type: ignore
    def tenancy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "tenancy", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="userData")
    def user_data(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.UserData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
        """
        return jsii.get(self, "userData")

    @user_data.setter # type: ignore
    def user_data(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "userData", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="volumes")
    def volumes(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["VolumeProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.Volumes``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
        """
        return jsii.get(self, "volumes")

    @volumes.setter # type: ignore
    def volumes(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["VolumeProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "volumes", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.AssociationParameterProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "value": "value"},
    )
    class AssociationParameterProperty:
        def __init__(
            self,
            *,
            key: builtins.str,
            value: typing.List[builtins.str],
        ) -> None:
            """
            :param key: ``CfnInstance.AssociationParameterProperty.Key``.
            :param value: ``CfnInstance.AssociationParameterProperty.Value``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "key": key,
                "value": value,
            }

        @builtins.property
        def key(self) -> builtins.str:
            """``CfnInstance.AssociationParameterProperty.Key``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
            """
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return result

        @builtins.property
        def value(self) -> typing.List[builtins.str]:
            """``CfnInstance.AssociationParameterProperty.Value``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
            """
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AssociationParameterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.BlockDeviceMappingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_name": "deviceName",
            "ebs": "ebs",
            "no_device": "noDevice",
            "virtual_name": "virtualName",
        },
    )
    class BlockDeviceMappingProperty:
        def __init__(
            self,
            *,
            device_name: builtins.str,
            ebs: typing.Optional[typing.Union["CfnInstance.EbsProperty", _IResolvable_9ceae33e]] = None,
            no_device: typing.Optional[typing.Union["CfnInstance.NoDeviceProperty", _IResolvable_9ceae33e]] = None,
            virtual_name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param device_name: ``CfnInstance.BlockDeviceMappingProperty.DeviceName``.
            :param ebs: ``CfnInstance.BlockDeviceMappingProperty.Ebs``.
            :param no_device: ``CfnInstance.BlockDeviceMappingProperty.NoDevice``.
            :param virtual_name: ``CfnInstance.BlockDeviceMappingProperty.VirtualName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "device_name": device_name,
            }
            if ebs is not None:
                self._values["ebs"] = ebs
            if no_device is not None:
                self._values["no_device"] = no_device
            if virtual_name is not None:
                self._values["virtual_name"] = virtual_name

        @builtins.property
        def device_name(self) -> builtins.str:
            """``CfnInstance.BlockDeviceMappingProperty.DeviceName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
            """
            result = self._values.get("device_name")
            assert result is not None, "Required property 'device_name' is missing"
            return result

        @builtins.property
        def ebs(
            self,
        ) -> typing.Optional[typing.Union["CfnInstance.EbsProperty", _IResolvable_9ceae33e]]:
            """``CfnInstance.BlockDeviceMappingProperty.Ebs``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
            """
            result = self._values.get("ebs")
            return result

        @builtins.property
        def no_device(
            self,
        ) -> typing.Optional[typing.Union["CfnInstance.NoDeviceProperty", _IResolvable_9ceae33e]]:
            """``CfnInstance.BlockDeviceMappingProperty.NoDevice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
            """
            result = self._values.get("no_device")
            return result

        @builtins.property
        def virtual_name(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.BlockDeviceMappingProperty.VirtualName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
            """
            result = self._values.get("virtual_name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockDeviceMappingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.CpuOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"core_count": "coreCount", "threads_per_core": "threadsPerCore"},
    )
    class CpuOptionsProperty:
        def __init__(
            self,
            *,
            core_count: typing.Optional[jsii.Number] = None,
            threads_per_core: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param core_count: ``CfnInstance.CpuOptionsProperty.CoreCount``.
            :param threads_per_core: ``CfnInstance.CpuOptionsProperty.ThreadsPerCore``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if core_count is not None:
                self._values["core_count"] = core_count
            if threads_per_core is not None:
                self._values["threads_per_core"] = threads_per_core

        @builtins.property
        def core_count(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.CpuOptionsProperty.CoreCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-corecount
            """
            result = self._values.get("core_count")
            return result

        @builtins.property
        def threads_per_core(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.CpuOptionsProperty.ThreadsPerCore``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-threadspercore
            """
            result = self._values.get("threads_per_core")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CpuOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.CreditSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"cpu_credits": "cpuCredits"},
    )
    class CreditSpecificationProperty:
        def __init__(
            self,
            *,
            cpu_credits: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param cpu_credits: ``CfnInstance.CreditSpecificationProperty.CPUCredits``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if cpu_credits is not None:
                self._values["cpu_credits"] = cpu_credits

        @builtins.property
        def cpu_credits(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.CreditSpecificationProperty.CPUCredits``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
            """
            result = self._values.get("cpu_credits")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CreditSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.EbsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "delete_on_termination": "deleteOnTermination",
            "encrypted": "encrypted",
            "iops": "iops",
            "kms_key_id": "kmsKeyId",
            "snapshot_id": "snapshotId",
            "volume_size": "volumeSize",
            "volume_type": "volumeType",
        },
    )
    class EbsProperty:
        def __init__(
            self,
            *,
            delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            iops: typing.Optional[jsii.Number] = None,
            kms_key_id: typing.Optional[builtins.str] = None,
            snapshot_id: typing.Optional[builtins.str] = None,
            volume_size: typing.Optional[jsii.Number] = None,
            volume_type: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param delete_on_termination: ``CfnInstance.EbsProperty.DeleteOnTermination``.
            :param encrypted: ``CfnInstance.EbsProperty.Encrypted``.
            :param iops: ``CfnInstance.EbsProperty.Iops``.
            :param kms_key_id: ``CfnInstance.EbsProperty.KmsKeyId``.
            :param snapshot_id: ``CfnInstance.EbsProperty.SnapshotId``.
            :param volume_size: ``CfnInstance.EbsProperty.VolumeSize``.
            :param volume_type: ``CfnInstance.EbsProperty.VolumeType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if delete_on_termination is not None:
                self._values["delete_on_termination"] = delete_on_termination
            if encrypted is not None:
                self._values["encrypted"] = encrypted
            if iops is not None:
                self._values["iops"] = iops
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id
            if snapshot_id is not None:
                self._values["snapshot_id"] = snapshot_id
            if volume_size is not None:
                self._values["volume_size"] = volume_size
            if volume_type is not None:
                self._values["volume_type"] = volume_type

        @builtins.property
        def delete_on_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnInstance.EbsProperty.DeleteOnTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
            """
            result = self._values.get("delete_on_termination")
            return result

        @builtins.property
        def encrypted(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnInstance.EbsProperty.Encrypted``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
            """
            result = self._values.get("encrypted")
            return result

        @builtins.property
        def iops(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.EbsProperty.Iops``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
            """
            result = self._values.get("iops")
            return result

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.EbsProperty.KmsKeyId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-instance-ebs-kmskeyid
            """
            result = self._values.get("kms_key_id")
            return result

        @builtins.property
        def snapshot_id(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.EbsProperty.SnapshotId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
            """
            result = self._values.get("snapshot_id")
            return result

        @builtins.property
        def volume_size(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.EbsProperty.VolumeSize``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
            """
            result = self._values.get("volume_size")
            return result

        @builtins.property
        def volume_type(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.EbsProperty.VolumeType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
            """
            result = self._values.get("volume_type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EbsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.ElasticGpuSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type"},
    )
    class ElasticGpuSpecificationProperty:
        def __init__(self, *, type: builtins.str) -> None:
            """
            :param type: ``CfnInstance.ElasticGpuSpecificationProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "type": type,
            }

        @builtins.property
        def type(self) -> builtins.str:
            """``CfnInstance.ElasticGpuSpecificationProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
            """
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ElasticGpuSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.ElasticInferenceAcceleratorProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type", "count": "count"},
    )
    class ElasticInferenceAcceleratorProperty:
        def __init__(
            self,
            *,
            type: builtins.str,
            count: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param type: ``CfnInstance.ElasticInferenceAcceleratorProperty.Type``.
            :param count: ``CfnInstance.ElasticInferenceAcceleratorProperty.Count``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "type": type,
            }
            if count is not None:
                self._values["count"] = count

        @builtins.property
        def type(self) -> builtins.str:
            """``CfnInstance.ElasticInferenceAcceleratorProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
            """
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return result

        @builtins.property
        def count(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.ElasticInferenceAcceleratorProperty.Count``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-count
            """
            result = self._values.get("count")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ElasticInferenceAcceleratorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.HibernationOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"configured": "configured"},
    )
    class HibernationOptionsProperty:
        def __init__(
            self,
            *,
            configured: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param configured: ``CfnInstance.HibernationOptionsProperty.Configured``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if configured is not None:
                self._values["configured"] = configured

        @builtins.property
        def configured(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnInstance.HibernationOptionsProperty.Configured``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html#cfn-ec2-instance-hibernationoptions-configured
            """
            result = self._values.get("configured")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HibernationOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.InstanceIpv6AddressProperty",
        jsii_struct_bases=[],
        name_mapping={"ipv6_address": "ipv6Address"},
    )
    class InstanceIpv6AddressProperty:
        def __init__(self, *, ipv6_address: builtins.str) -> None:
            """
            :param ipv6_address: ``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "ipv6_address": ipv6_address,
            }

        @builtins.property
        def ipv6_address(self) -> builtins.str:
            """``CfnInstance.InstanceIpv6AddressProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
            """
            result = self._values.get("ipv6_address")
            assert result is not None, "Required property 'ipv6_address' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InstanceIpv6AddressProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.LaunchTemplateSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "version": "version",
            "launch_template_id": "launchTemplateId",
            "launch_template_name": "launchTemplateName",
        },
    )
    class LaunchTemplateSpecificationProperty:
        def __init__(
            self,
            *,
            version: builtins.str,
            launch_template_id: typing.Optional[builtins.str] = None,
            launch_template_name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param version: ``CfnInstance.LaunchTemplateSpecificationProperty.Version``.
            :param launch_template_id: ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``.
            :param launch_template_name: ``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "version": version,
            }
            if launch_template_id is not None:
                self._values["launch_template_id"] = launch_template_id
            if launch_template_name is not None:
                self._values["launch_template_name"] = launch_template_name

        @builtins.property
        def version(self) -> builtins.str:
            """``CfnInstance.LaunchTemplateSpecificationProperty.Version``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
            """
            result = self._values.get("version")
            assert result is not None, "Required property 'version' is missing"
            return result

        @builtins.property
        def launch_template_id(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
            """
            result = self._values.get("launch_template_id")
            return result

        @builtins.property
        def launch_template_name(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
            """
            result = self._values.get("launch_template_name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LaunchTemplateSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.LicenseSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"license_configuration_arn": "licenseConfigurationArn"},
    )
    class LicenseSpecificationProperty:
        def __init__(self, *, license_configuration_arn: builtins.str) -> None:
            """
            :param license_configuration_arn: ``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "license_configuration_arn": license_configuration_arn,
            }

        @builtins.property
        def license_configuration_arn(self) -> builtins.str:
            """``CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
            """
            result = self._values.get("license_configuration_arn")
            assert result is not None, "Required property 'license_configuration_arn' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LicenseSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.NetworkInterfaceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_index": "deviceIndex",
            "associate_public_ip_address": "associatePublicIpAddress",
            "delete_on_termination": "deleteOnTermination",
            "description": "description",
            "group_set": "groupSet",
            "ipv6_address_count": "ipv6AddressCount",
            "ipv6_addresses": "ipv6Addresses",
            "network_interface_id": "networkInterfaceId",
            "private_ip_address": "privateIpAddress",
            "private_ip_addresses": "privateIpAddresses",
            "secondary_private_ip_address_count": "secondaryPrivateIpAddressCount",
            "subnet_id": "subnetId",
        },
    )
    class NetworkInterfaceProperty:
        def __init__(
            self,
            *,
            device_index: builtins.str,
            associate_public_ip_address: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            description: typing.Optional[builtins.str] = None,
            group_set: typing.Optional[typing.List[builtins.str]] = None,
            ipv6_address_count: typing.Optional[jsii.Number] = None,
            ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]] = None,
            network_interface_id: typing.Optional[builtins.str] = None,
            private_ip_address: typing.Optional[builtins.str] = None,
            private_ip_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            secondary_private_ip_address_count: typing.Optional[jsii.Number] = None,
            subnet_id: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param device_index: ``CfnInstance.NetworkInterfaceProperty.DeviceIndex``.
            :param associate_public_ip_address: ``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``.
            :param delete_on_termination: ``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``.
            :param description: ``CfnInstance.NetworkInterfaceProperty.Description``.
            :param group_set: ``CfnInstance.NetworkInterfaceProperty.GroupSet``.
            :param ipv6_address_count: ``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``.
            :param ipv6_addresses: ``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``.
            :param network_interface_id: ``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``.
            :param private_ip_address: ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``.
            :param private_ip_addresses: ``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``.
            :param secondary_private_ip_address_count: ``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``.
            :param subnet_id: ``CfnInstance.NetworkInterfaceProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "device_index": device_index,
            }
            if associate_public_ip_address is not None:
                self._values["associate_public_ip_address"] = associate_public_ip_address
            if delete_on_termination is not None:
                self._values["delete_on_termination"] = delete_on_termination
            if description is not None:
                self._values["description"] = description
            if group_set is not None:
                self._values["group_set"] = group_set
            if ipv6_address_count is not None:
                self._values["ipv6_address_count"] = ipv6_address_count
            if ipv6_addresses is not None:
                self._values["ipv6_addresses"] = ipv6_addresses
            if network_interface_id is not None:
                self._values["network_interface_id"] = network_interface_id
            if private_ip_address is not None:
                self._values["private_ip_address"] = private_ip_address
            if private_ip_addresses is not None:
                self._values["private_ip_addresses"] = private_ip_addresses
            if secondary_private_ip_address_count is not None:
                self._values["secondary_private_ip_address_count"] = secondary_private_ip_address_count
            if subnet_id is not None:
                self._values["subnet_id"] = subnet_id

        @builtins.property
        def device_index(self) -> builtins.str:
            """``CfnInstance.NetworkInterfaceProperty.DeviceIndex``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
            """
            result = self._values.get("device_index")
            assert result is not None, "Required property 'device_index' is missing"
            return result

        @builtins.property
        def associate_public_ip_address(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
            """
            result = self._values.get("associate_public_ip_address")
            return result

        @builtins.property
        def delete_on_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnInstance.NetworkInterfaceProperty.DeleteOnTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
            """
            result = self._values.get("delete_on_termination")
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.NetworkInterfaceProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
            """
            result = self._values.get("description")
            return result

        @builtins.property
        def group_set(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnInstance.NetworkInterfaceProperty.GroupSet``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
            """
            result = self._values.get("group_set")
            return result

        @builtins.property
        def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
            """
            result = self._values.get("ipv6_address_count")
            return result

        @builtins.property
        def ipv6_addresses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]]:
            """``CfnInstance.NetworkInterfaceProperty.Ipv6Addresses``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
            """
            result = self._values.get("ipv6_addresses")
            return result

        @builtins.property
        def network_interface_id(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
            """
            result = self._values.get("network_interface_id")
            return result

        @builtins.property
        def private_ip_address(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.NetworkInterfaceProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
            """
            result = self._values.get("private_ip_address")
            return result

        @builtins.property
        def private_ip_addresses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
            """
            result = self._values.get("private_ip_addresses")
            return result

        @builtins.property
        def secondary_private_ip_address_count(self) -> typing.Optional[jsii.Number]:
            """``CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
            """
            result = self._values.get("secondary_private_ip_address_count")
            return result

        @builtins.property
        def subnet_id(self) -> typing.Optional[builtins.str]:
            """``CfnInstance.NetworkInterfaceProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
            """
            result = self._values.get("subnet_id")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkInterfaceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.NoDeviceProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class NoDeviceProperty:
        def __init__(self) -> None:
            """
            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
            """
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NoDeviceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.PrivateIpAddressSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"primary": "primary", "private_ip_address": "privateIpAddress"},
    )
    class PrivateIpAddressSpecificationProperty:
        def __init__(
            self,
            *,
            primary: typing.Union[builtins.bool, _IResolvable_9ceae33e],
            private_ip_address: builtins.str,
        ) -> None:
            """
            :param primary: ``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``.
            :param private_ip_address: ``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "primary": primary,
                "private_ip_address": private_ip_address,
            }

        @builtins.property
        def primary(self) -> typing.Union[builtins.bool, _IResolvable_9ceae33e]:
            """``CfnInstance.PrivateIpAddressSpecificationProperty.Primary``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
            """
            result = self._values.get("primary")
            assert result is not None, "Required property 'primary' is missing"
            return result

        @builtins.property
        def private_ip_address(self) -> builtins.str:
            """``CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
            """
            result = self._values.get("private_ip_address")
            assert result is not None, "Required property 'private_ip_address' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PrivateIpAddressSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.SsmAssociationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "document_name": "documentName",
            "association_parameters": "associationParameters",
        },
    )
    class SsmAssociationProperty:
        def __init__(
            self,
            *,
            document_name: builtins.str,
            association_parameters: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.AssociationParameterProperty", _IResolvable_9ceae33e]]]] = None,
        ) -> None:
            """
            :param document_name: ``CfnInstance.SsmAssociationProperty.DocumentName``.
            :param association_parameters: ``CfnInstance.SsmAssociationProperty.AssociationParameters``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "document_name": document_name,
            }
            if association_parameters is not None:
                self._values["association_parameters"] = association_parameters

        @builtins.property
        def document_name(self) -> builtins.str:
            """``CfnInstance.SsmAssociationProperty.DocumentName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
            """
            result = self._values.get("document_name")
            assert result is not None, "Required property 'document_name' is missing"
            return result

        @builtins.property
        def association_parameters(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.AssociationParameterProperty", _IResolvable_9ceae33e]]]]:
            """``CfnInstance.SsmAssociationProperty.AssociationParameters``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
            """
            result = self._values.get("association_parameters")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SsmAssociationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnInstance.VolumeProperty",
        jsii_struct_bases=[],
        name_mapping={"device": "device", "volume_id": "volumeId"},
    )
    class VolumeProperty:
        def __init__(self, *, device: builtins.str, volume_id: builtins.str) -> None:
            """
            :param device: ``CfnInstance.VolumeProperty.Device``.
            :param volume_id: ``CfnInstance.VolumeProperty.VolumeId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "device": device,
                "volume_id": volume_id,
            }

        @builtins.property
        def device(self) -> builtins.str:
            """``CfnInstance.VolumeProperty.Device``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
            """
            result = self._values.get("device")
            assert result is not None, "Required property 'device' is missing"
            return result

        @builtins.property
        def volume_id(self) -> builtins.str:
            """``CfnInstance.VolumeProperty.VolumeId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
            """
            result = self._values.get("volume_id")
            assert result is not None, "Required property 'volume_id' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VolumeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnInstanceProps",
    jsii_struct_bases=[],
    name_mapping={
        "additional_info": "additionalInfo",
        "affinity": "affinity",
        "availability_zone": "availabilityZone",
        "block_device_mappings": "blockDeviceMappings",
        "cpu_options": "cpuOptions",
        "credit_specification": "creditSpecification",
        "disable_api_termination": "disableApiTermination",
        "ebs_optimized": "ebsOptimized",
        "elastic_gpu_specifications": "elasticGpuSpecifications",
        "elastic_inference_accelerators": "elasticInferenceAccelerators",
        "hibernation_options": "hibernationOptions",
        "host_id": "hostId",
        "host_resource_group_arn": "hostResourceGroupArn",
        "iam_instance_profile": "iamInstanceProfile",
        "image_id": "imageId",
        "instance_initiated_shutdown_behavior": "instanceInitiatedShutdownBehavior",
        "instance_type": "instanceType",
        "ipv6_address_count": "ipv6AddressCount",
        "ipv6_addresses": "ipv6Addresses",
        "kernel_id": "kernelId",
        "key_name": "keyName",
        "launch_template": "launchTemplate",
        "license_specifications": "licenseSpecifications",
        "monitoring": "monitoring",
        "network_interfaces": "networkInterfaces",
        "placement_group_name": "placementGroupName",
        "private_ip_address": "privateIpAddress",
        "ramdisk_id": "ramdiskId",
        "security_group_ids": "securityGroupIds",
        "security_groups": "securityGroups",
        "source_dest_check": "sourceDestCheck",
        "ssm_associations": "ssmAssociations",
        "subnet_id": "subnetId",
        "tags": "tags",
        "tenancy": "tenancy",
        "user_data": "userData",
        "volumes": "volumes",
    },
)
class CfnInstanceProps:
    def __init__(
        self,
        *,
        additional_info: typing.Optional[builtins.str] = None,
        affinity: typing.Optional[builtins.str] = None,
        availability_zone: typing.Optional[builtins.str] = None,
        block_device_mappings: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]] = None,
        cpu_options: typing.Optional[typing.Union["CfnInstance.CpuOptionsProperty", _IResolvable_9ceae33e]] = None,
        credit_specification: typing.Optional[typing.Union["CfnInstance.CreditSpecificationProperty", _IResolvable_9ceae33e]] = None,
        disable_api_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ebs_optimized: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        elastic_gpu_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        elastic_inference_accelerators: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.ElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]] = None,
        hibernation_options: typing.Optional[typing.Union["CfnInstance.HibernationOptionsProperty", _IResolvable_9ceae33e]] = None,
        host_id: typing.Optional[builtins.str] = None,
        host_resource_group_arn: typing.Optional[builtins.str] = None,
        iam_instance_profile: typing.Optional[builtins.str] = None,
        image_id: typing.Optional[builtins.str] = None,
        instance_initiated_shutdown_behavior: typing.Optional[builtins.str] = None,
        instance_type: typing.Optional[builtins.str] = None,
        ipv6_address_count: typing.Optional[jsii.Number] = None,
        ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]] = None,
        kernel_id: typing.Optional[builtins.str] = None,
        key_name: typing.Optional[builtins.str] = None,
        launch_template: typing.Optional[typing.Union["CfnInstance.LaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]] = None,
        license_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.LicenseSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        monitoring: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        network_interfaces: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.NetworkInterfaceProperty", _IResolvable_9ceae33e]]]] = None,
        placement_group_name: typing.Optional[builtins.str] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
        ramdisk_id: typing.Optional[builtins.str] = None,
        security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
        security_groups: typing.Optional[typing.List[builtins.str]] = None,
        source_dest_check: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ssm_associations: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.SsmAssociationProperty", _IResolvable_9ceae33e]]]] = None,
        subnet_id: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        tenancy: typing.Optional[builtins.str] = None,
        user_data: typing.Optional[builtins.str] = None,
        volumes: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.VolumeProperty", _IResolvable_9ceae33e]]]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::Instance``.

        :param additional_info: ``AWS::EC2::Instance.AdditionalInfo``.
        :param affinity: ``AWS::EC2::Instance.Affinity``.
        :param availability_zone: ``AWS::EC2::Instance.AvailabilityZone``.
        :param block_device_mappings: ``AWS::EC2::Instance.BlockDeviceMappings``.
        :param cpu_options: ``AWS::EC2::Instance.CpuOptions``.
        :param credit_specification: ``AWS::EC2::Instance.CreditSpecification``.
        :param disable_api_termination: ``AWS::EC2::Instance.DisableApiTermination``.
        :param ebs_optimized: ``AWS::EC2::Instance.EbsOptimized``.
        :param elastic_gpu_specifications: ``AWS::EC2::Instance.ElasticGpuSpecifications``.
        :param elastic_inference_accelerators: ``AWS::EC2::Instance.ElasticInferenceAccelerators``.
        :param hibernation_options: ``AWS::EC2::Instance.HibernationOptions``.
        :param host_id: ``AWS::EC2::Instance.HostId``.
        :param host_resource_group_arn: ``AWS::EC2::Instance.HostResourceGroupArn``.
        :param iam_instance_profile: ``AWS::EC2::Instance.IamInstanceProfile``.
        :param image_id: ``AWS::EC2::Instance.ImageId``.
        :param instance_initiated_shutdown_behavior: ``AWS::EC2::Instance.InstanceInitiatedShutdownBehavior``.
        :param instance_type: ``AWS::EC2::Instance.InstanceType``.
        :param ipv6_address_count: ``AWS::EC2::Instance.Ipv6AddressCount``.
        :param ipv6_addresses: ``AWS::EC2::Instance.Ipv6Addresses``.
        :param kernel_id: ``AWS::EC2::Instance.KernelId``.
        :param key_name: ``AWS::EC2::Instance.KeyName``.
        :param launch_template: ``AWS::EC2::Instance.LaunchTemplate``.
        :param license_specifications: ``AWS::EC2::Instance.LicenseSpecifications``.
        :param monitoring: ``AWS::EC2::Instance.Monitoring``.
        :param network_interfaces: ``AWS::EC2::Instance.NetworkInterfaces``.
        :param placement_group_name: ``AWS::EC2::Instance.PlacementGroupName``.
        :param private_ip_address: ``AWS::EC2::Instance.PrivateIpAddress``.
        :param ramdisk_id: ``AWS::EC2::Instance.RamdiskId``.
        :param security_group_ids: ``AWS::EC2::Instance.SecurityGroupIds``.
        :param security_groups: ``AWS::EC2::Instance.SecurityGroups``.
        :param source_dest_check: ``AWS::EC2::Instance.SourceDestCheck``.
        :param ssm_associations: ``AWS::EC2::Instance.SsmAssociations``.
        :param subnet_id: ``AWS::EC2::Instance.SubnetId``.
        :param tags: ``AWS::EC2::Instance.Tags``.
        :param tenancy: ``AWS::EC2::Instance.Tenancy``.
        :param user_data: ``AWS::EC2::Instance.UserData``.
        :param volumes: ``AWS::EC2::Instance.Volumes``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if additional_info is not None:
            self._values["additional_info"] = additional_info
        if affinity is not None:
            self._values["affinity"] = affinity
        if availability_zone is not None:
            self._values["availability_zone"] = availability_zone
        if block_device_mappings is not None:
            self._values["block_device_mappings"] = block_device_mappings
        if cpu_options is not None:
            self._values["cpu_options"] = cpu_options
        if credit_specification is not None:
            self._values["credit_specification"] = credit_specification
        if disable_api_termination is not None:
            self._values["disable_api_termination"] = disable_api_termination
        if ebs_optimized is not None:
            self._values["ebs_optimized"] = ebs_optimized
        if elastic_gpu_specifications is not None:
            self._values["elastic_gpu_specifications"] = elastic_gpu_specifications
        if elastic_inference_accelerators is not None:
            self._values["elastic_inference_accelerators"] = elastic_inference_accelerators
        if hibernation_options is not None:
            self._values["hibernation_options"] = hibernation_options
        if host_id is not None:
            self._values["host_id"] = host_id
        if host_resource_group_arn is not None:
            self._values["host_resource_group_arn"] = host_resource_group_arn
        if iam_instance_profile is not None:
            self._values["iam_instance_profile"] = iam_instance_profile
        if image_id is not None:
            self._values["image_id"] = image_id
        if instance_initiated_shutdown_behavior is not None:
            self._values["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
        if instance_type is not None:
            self._values["instance_type"] = instance_type
        if ipv6_address_count is not None:
            self._values["ipv6_address_count"] = ipv6_address_count
        if ipv6_addresses is not None:
            self._values["ipv6_addresses"] = ipv6_addresses
        if kernel_id is not None:
            self._values["kernel_id"] = kernel_id
        if key_name is not None:
            self._values["key_name"] = key_name
        if launch_template is not None:
            self._values["launch_template"] = launch_template
        if license_specifications is not None:
            self._values["license_specifications"] = license_specifications
        if monitoring is not None:
            self._values["monitoring"] = monitoring
        if network_interfaces is not None:
            self._values["network_interfaces"] = network_interfaces
        if placement_group_name is not None:
            self._values["placement_group_name"] = placement_group_name
        if private_ip_address is not None:
            self._values["private_ip_address"] = private_ip_address
        if ramdisk_id is not None:
            self._values["ramdisk_id"] = ramdisk_id
        if security_group_ids is not None:
            self._values["security_group_ids"] = security_group_ids
        if security_groups is not None:
            self._values["security_groups"] = security_groups
        if source_dest_check is not None:
            self._values["source_dest_check"] = source_dest_check
        if ssm_associations is not None:
            self._values["ssm_associations"] = ssm_associations
        if subnet_id is not None:
            self._values["subnet_id"] = subnet_id
        if tags is not None:
            self._values["tags"] = tags
        if tenancy is not None:
            self._values["tenancy"] = tenancy
        if user_data is not None:
            self._values["user_data"] = user_data
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def additional_info(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.AdditionalInfo``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
        """
        result = self._values.get("additional_info")
        return result

    @builtins.property
    def affinity(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.Affinity``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
        """
        result = self._values.get("affinity")
        return result

    @builtins.property
    def availability_zone(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
        """
        result = self._values.get("availability_zone")
        return result

    @builtins.property
    def block_device_mappings(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.BlockDeviceMappings``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
        """
        result = self._values.get("block_device_mappings")
        return result

    @builtins.property
    def cpu_options(
        self,
    ) -> typing.Optional[typing.Union["CfnInstance.CpuOptionsProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.CpuOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
        """
        result = self._values.get("cpu_options")
        return result

    @builtins.property
    def credit_specification(
        self,
    ) -> typing.Optional[typing.Union["CfnInstance.CreditSpecificationProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.CreditSpecification``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
        """
        result = self._values.get("credit_specification")
        return result

    @builtins.property
    def disable_api_termination(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.DisableApiTermination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
        """
        result = self._values.get("disable_api_termination")
        return result

    @builtins.property
    def ebs_optimized(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.EbsOptimized``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
        """
        result = self._values.get("ebs_optimized")
        return result

    @builtins.property
    def elastic_gpu_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.ElasticGpuSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
        """
        result = self._values.get("elastic_gpu_specifications")
        return result

    @builtins.property
    def elastic_inference_accelerators(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.ElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.ElasticInferenceAccelerators``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
        """
        result = self._values.get("elastic_inference_accelerators")
        return result

    @builtins.property
    def hibernation_options(
        self,
    ) -> typing.Optional[typing.Union["CfnInstance.HibernationOptionsProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.HibernationOptions``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hibernationoptions
        """
        result = self._values.get("hibernation_options")
        return result

    @builtins.property
    def host_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.HostId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
        """
        result = self._values.get("host_id")
        return result

    @builtins.property
    def host_resource_group_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.HostResourceGroupArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostresourcegrouparn
        """
        result = self._values.get("host_resource_group_arn")
        return result

    @builtins.property
    def iam_instance_profile(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.IamInstanceProfile``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
        """
        result = self._values.get("iam_instance_profile")
        return result

    @builtins.property
    def image_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.ImageId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
        """
        result = self._values.get("image_id")
        return result

    @builtins.property
    def instance_initiated_shutdown_behavior(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.InstanceInitiatedShutdownBehavior``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
        """
        result = self._values.get("instance_initiated_shutdown_behavior")
        return result

    @builtins.property
    def instance_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.InstanceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
        """
        result = self._values.get("instance_type")
        return result

    @builtins.property
    def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::Instance.Ipv6AddressCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
        """
        result = self._values.get("ipv6_address_count")
        return result

    @builtins.property
    def ipv6_addresses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.Ipv6Addresses``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
        """
        result = self._values.get("ipv6_addresses")
        return result

    @builtins.property
    def kernel_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.KernelId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
        """
        result = self._values.get("kernel_id")
        return result

    @builtins.property
    def key_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.KeyName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
        """
        result = self._values.get("key_name")
        return result

    @builtins.property
    def launch_template(
        self,
    ) -> typing.Optional[typing.Union["CfnInstance.LaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.LaunchTemplate``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
        """
        result = self._values.get("launch_template")
        return result

    @builtins.property
    def license_specifications(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.LicenseSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.LicenseSpecifications``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
        """
        result = self._values.get("license_specifications")
        return result

    @builtins.property
    def monitoring(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.Monitoring``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
        """
        result = self._values.get("monitoring")
        return result

    @builtins.property
    def network_interfaces(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.NetworkInterfaceProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.NetworkInterfaces``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
        """
        result = self._values.get("network_interfaces")
        return result

    @builtins.property
    def placement_group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.PlacementGroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
        """
        result = self._values.get("placement_group_name")
        return result

    @builtins.property
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
        """
        result = self._values.get("private_ip_address")
        return result

    @builtins.property
    def ramdisk_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.RamdiskId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
        """
        result = self._values.get("ramdisk_id")
        return result

    @builtins.property
    def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::Instance.SecurityGroupIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
        """
        result = self._values.get("security_group_ids")
        return result

    @builtins.property
    def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::Instance.SecurityGroups``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
        """
        result = self._values.get("security_groups")
        return result

    @builtins.property
    def source_dest_check(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Instance.SourceDestCheck``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
        """
        result = self._values.get("source_dest_check")
        return result

    @builtins.property
    def ssm_associations(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.SsmAssociationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.SsmAssociations``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
        """
        result = self._values.get("ssm_associations")
        return result

    @builtins.property
    def subnet_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
        """
        result = self._values.get("subnet_id")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::Instance.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def tenancy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.Tenancy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
        """
        result = self._values.get("tenancy")
        return result

    @builtins.property
    def user_data(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Instance.UserData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
        """
        result = self._values.get("user_data")
        return result

    @builtins.property
    def volumes(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnInstance.VolumeProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::Instance.Volumes``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
        """
        result = self._values.get("volumes")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnInstanceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnInternetGateway(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnInternetGateway",
):
    """A CloudFormation ``AWS::EC2::InternetGateway``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::InternetGateway
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::InternetGateway``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param tags: ``AWS::EC2::InternetGateway.Tags``.
        """
        props = CfnInternetGatewayProps(tags=tags)

        jsii.create(CfnInternetGateway, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::InternetGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
        """
        return jsii.get(self, "tags")


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnInternetGatewayProps",
    jsii_struct_bases=[],
    name_mapping={"tags": "tags"},
)
class CfnInternetGatewayProps:
    def __init__(
        self,
        *,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::InternetGateway``.

        :param tags: ``AWS::EC2::InternetGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::InternetGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnInternetGatewayProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnLaunchTemplate(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate",
):
    """A CloudFormation ``AWS::EC2::LaunchTemplate``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::LaunchTemplate
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        launch_template_data: typing.Optional[typing.Union["LaunchTemplateDataProperty", _IResolvable_9ceae33e]] = None,
        launch_template_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::LaunchTemplate``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param launch_template_data: ``AWS::EC2::LaunchTemplate.LaunchTemplateData``.
        :param launch_template_name: ``AWS::EC2::LaunchTemplate.LaunchTemplateName``.
        """
        props = CfnLaunchTemplateProps(
            launch_template_data=launch_template_data,
            launch_template_name=launch_template_name,
        )

        jsii.create(CfnLaunchTemplate, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrDefaultVersionNumber")
    def attr_default_version_number(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: DefaultVersionNumber
        """
        return jsii.get(self, "attrDefaultVersionNumber")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrLatestVersionNumber")
    def attr_latest_version_number(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: LatestVersionNumber
        """
        return jsii.get(self, "attrLatestVersionNumber")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="launchTemplateData")
    def launch_template_data(
        self,
    ) -> typing.Optional[typing.Union["LaunchTemplateDataProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::LaunchTemplate.LaunchTemplateData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
        """
        return jsii.get(self, "launchTemplateData")

    @launch_template_data.setter # type: ignore
    def launch_template_data(
        self,
        value: typing.Optional[typing.Union["LaunchTemplateDataProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "launchTemplateData", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="launchTemplateName")
    def launch_template_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::LaunchTemplate.LaunchTemplateName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
        """
        return jsii.get(self, "launchTemplateName")

    @launch_template_name.setter # type: ignore
    def launch_template_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "launchTemplateName", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.BlockDeviceMappingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_name": "deviceName",
            "ebs": "ebs",
            "no_device": "noDevice",
            "virtual_name": "virtualName",
        },
    )
    class BlockDeviceMappingProperty:
        def __init__(
            self,
            *,
            device_name: typing.Optional[builtins.str] = None,
            ebs: typing.Optional[typing.Union["CfnLaunchTemplate.EbsProperty", _IResolvable_9ceae33e]] = None,
            no_device: typing.Optional[builtins.str] = None,
            virtual_name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param device_name: ``CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName``.
            :param ebs: ``CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs``.
            :param no_device: ``CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice``.
            :param virtual_name: ``CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if device_name is not None:
                self._values["device_name"] = device_name
            if ebs is not None:
                self._values["ebs"] = ebs
            if no_device is not None:
                self._values["no_device"] = no_device
            if virtual_name is not None:
                self._values["virtual_name"] = virtual_name

        @builtins.property
        def device_name(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
            """
            result = self._values.get("device_name")
            return result

        @builtins.property
        def ebs(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.EbsProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
            """
            result = self._values.get("ebs")
            return result

        @builtins.property
        def no_device(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
            """
            result = self._values.get("no_device")
            return result

        @builtins.property
        def virtual_name(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
            """
            result = self._values.get("virtual_name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockDeviceMappingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "capacity_reservation_preference": "capacityReservationPreference",
            "capacity_reservation_target": "capacityReservationTarget",
        },
    )
    class CapacityReservationSpecificationProperty:
        def __init__(
            self,
            *,
            capacity_reservation_preference: typing.Optional[builtins.str] = None,
            capacity_reservation_target: typing.Optional[typing.Union["CfnLaunchTemplate.CapacityReservationTargetProperty", _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param capacity_reservation_preference: ``CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference``.
            :param capacity_reservation_target: ``CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if capacity_reservation_preference is not None:
                self._values["capacity_reservation_preference"] = capacity_reservation_preference
            if capacity_reservation_target is not None:
                self._values["capacity_reservation_target"] = capacity_reservation_target

        @builtins.property
        def capacity_reservation_preference(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
            """
            result = self._values.get("capacity_reservation_preference")
            return result

        @builtins.property
        def capacity_reservation_target(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.CapacityReservationTargetProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
            """
            result = self._values.get("capacity_reservation_target")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CapacityReservationSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.CapacityReservationTargetProperty",
        jsii_struct_bases=[],
        name_mapping={"capacity_reservation_id": "capacityReservationId"},
    )
    class CapacityReservationTargetProperty:
        def __init__(
            self,
            *,
            capacity_reservation_id: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param capacity_reservation_id: ``CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if capacity_reservation_id is not None:
                self._values["capacity_reservation_id"] = capacity_reservation_id

        @builtins.property
        def capacity_reservation_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
            """
            result = self._values.get("capacity_reservation_id")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CapacityReservationTargetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.CpuOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"core_count": "coreCount", "threads_per_core": "threadsPerCore"},
    )
    class CpuOptionsProperty:
        def __init__(
            self,
            *,
            core_count: typing.Optional[jsii.Number] = None,
            threads_per_core: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param core_count: ``CfnLaunchTemplate.CpuOptionsProperty.CoreCount``.
            :param threads_per_core: ``CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if core_count is not None:
                self._values["core_count"] = core_count
            if threads_per_core is not None:
                self._values["threads_per_core"] = threads_per_core

        @builtins.property
        def core_count(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.CpuOptionsProperty.CoreCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
            """
            result = self._values.get("core_count")
            return result

        @builtins.property
        def threads_per_core(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
            """
            result = self._values.get("threads_per_core")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CpuOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.CreditSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"cpu_credits": "cpuCredits"},
    )
    class CreditSpecificationProperty:
        def __init__(
            self,
            *,
            cpu_credits: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param cpu_credits: ``CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if cpu_credits is not None:
                self._values["cpu_credits"] = cpu_credits

        @builtins.property
        def cpu_credits(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
            """
            result = self._values.get("cpu_credits")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CreditSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.EbsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "delete_on_termination": "deleteOnTermination",
            "encrypted": "encrypted",
            "iops": "iops",
            "kms_key_id": "kmsKeyId",
            "snapshot_id": "snapshotId",
            "volume_size": "volumeSize",
            "volume_type": "volumeType",
        },
    )
    class EbsProperty:
        def __init__(
            self,
            *,
            delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            iops: typing.Optional[jsii.Number] = None,
            kms_key_id: typing.Optional[builtins.str] = None,
            snapshot_id: typing.Optional[builtins.str] = None,
            volume_size: typing.Optional[jsii.Number] = None,
            volume_type: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param delete_on_termination: ``CfnLaunchTemplate.EbsProperty.DeleteOnTermination``.
            :param encrypted: ``CfnLaunchTemplate.EbsProperty.Encrypted``.
            :param iops: ``CfnLaunchTemplate.EbsProperty.Iops``.
            :param kms_key_id: ``CfnLaunchTemplate.EbsProperty.KmsKeyId``.
            :param snapshot_id: ``CfnLaunchTemplate.EbsProperty.SnapshotId``.
            :param volume_size: ``CfnLaunchTemplate.EbsProperty.VolumeSize``.
            :param volume_type: ``CfnLaunchTemplate.EbsProperty.VolumeType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if delete_on_termination is not None:
                self._values["delete_on_termination"] = delete_on_termination
            if encrypted is not None:
                self._values["encrypted"] = encrypted
            if iops is not None:
                self._values["iops"] = iops
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id
            if snapshot_id is not None:
                self._values["snapshot_id"] = snapshot_id
            if volume_size is not None:
                self._values["volume_size"] = volume_size
            if volume_type is not None:
                self._values["volume_type"] = volume_type

        @builtins.property
        def delete_on_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.EbsProperty.DeleteOnTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
            """
            result = self._values.get("delete_on_termination")
            return result

        @builtins.property
        def encrypted(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.EbsProperty.Encrypted``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
            """
            result = self._values.get("encrypted")
            return result

        @builtins.property
        def iops(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.EbsProperty.Iops``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
            """
            result = self._values.get("iops")
            return result

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.EbsProperty.KmsKeyId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
            """
            result = self._values.get("kms_key_id")
            return result

        @builtins.property
        def snapshot_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.EbsProperty.SnapshotId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
            """
            result = self._values.get("snapshot_id")
            return result

        @builtins.property
        def volume_size(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.EbsProperty.VolumeSize``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
            """
            result = self._values.get("volume_size")
            return result

        @builtins.property
        def volume_type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.EbsProperty.VolumeType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
            """
            result = self._values.get("volume_type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EbsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type"},
    )
    class ElasticGpuSpecificationProperty:
        def __init__(self, *, type: typing.Optional[builtins.str] = None) -> None:
            """
            :param type: ``CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
            """
            result = self._values.get("type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ElasticGpuSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.HibernationOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"configured": "configured"},
    )
    class HibernationOptionsProperty:
        def __init__(
            self,
            *,
            configured: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param configured: ``CfnLaunchTemplate.HibernationOptionsProperty.Configured``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if configured is not None:
                self._values["configured"] = configured

        @builtins.property
        def configured(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.HibernationOptionsProperty.Configured``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
            """
            result = self._values.get("configured")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HibernationOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.IamInstanceProfileProperty",
        jsii_struct_bases=[],
        name_mapping={"arn": "arn", "name": "name"},
    )
    class IamInstanceProfileProperty:
        def __init__(
            self,
            *,
            arn: typing.Optional[builtins.str] = None,
            name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param arn: ``CfnLaunchTemplate.IamInstanceProfileProperty.Arn``.
            :param name: ``CfnLaunchTemplate.IamInstanceProfileProperty.Name``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if arn is not None:
                self._values["arn"] = arn
            if name is not None:
                self._values["name"] = name

        @builtins.property
        def arn(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.IamInstanceProfileProperty.Arn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
            """
            result = self._values.get("arn")
            return result

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.IamInstanceProfileProperty.Name``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
            """
            result = self._values.get("name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IamInstanceProfileProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={"market_type": "marketType", "spot_options": "spotOptions"},
    )
    class InstanceMarketOptionsProperty:
        def __init__(
            self,
            *,
            market_type: typing.Optional[builtins.str] = None,
            spot_options: typing.Optional[typing.Union["CfnLaunchTemplate.SpotOptionsProperty", _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param market_type: ``CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType``.
            :param spot_options: ``CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if market_type is not None:
                self._values["market_type"] = market_type
            if spot_options is not None:
                self._values["spot_options"] = spot_options

        @builtins.property
        def market_type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
            """
            result = self._values.get("market_type")
            return result

        @builtins.property
        def spot_options(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.SpotOptionsProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
            """
            result = self._values.get("spot_options")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InstanceMarketOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.Ipv6AddProperty",
        jsii_struct_bases=[],
        name_mapping={"ipv6_address": "ipv6Address"},
    )
    class Ipv6AddProperty:
        def __init__(
            self,
            *,
            ipv6_address: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param ipv6_address: ``CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if ipv6_address is not None:
                self._values["ipv6_address"] = ipv6_address

        @builtins.property
        def ipv6_address(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
            """
            result = self._values.get("ipv6_address")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Ipv6AddProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.LaunchTemplateDataProperty",
        jsii_struct_bases=[],
        name_mapping={
            "block_device_mappings": "blockDeviceMappings",
            "capacity_reservation_specification": "capacityReservationSpecification",
            "cpu_options": "cpuOptions",
            "credit_specification": "creditSpecification",
            "disable_api_termination": "disableApiTermination",
            "ebs_optimized": "ebsOptimized",
            "elastic_gpu_specifications": "elasticGpuSpecifications",
            "elastic_inference_accelerators": "elasticInferenceAccelerators",
            "hibernation_options": "hibernationOptions",
            "iam_instance_profile": "iamInstanceProfile",
            "image_id": "imageId",
            "instance_initiated_shutdown_behavior": "instanceInitiatedShutdownBehavior",
            "instance_market_options": "instanceMarketOptions",
            "instance_type": "instanceType",
            "kernel_id": "kernelId",
            "key_name": "keyName",
            "license_specifications": "licenseSpecifications",
            "metadata_options": "metadataOptions",
            "monitoring": "monitoring",
            "network_interfaces": "networkInterfaces",
            "placement": "placement",
            "ram_disk_id": "ramDiskId",
            "security_group_ids": "securityGroupIds",
            "security_groups": "securityGroups",
            "tag_specifications": "tagSpecifications",
            "user_data": "userData",
        },
    )
    class LaunchTemplateDataProperty:
        def __init__(
            self,
            *,
            block_device_mappings: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]] = None,
            capacity_reservation_specification: typing.Optional[typing.Union["CfnLaunchTemplate.CapacityReservationSpecificationProperty", _IResolvable_9ceae33e]] = None,
            cpu_options: typing.Optional[typing.Union["CfnLaunchTemplate.CpuOptionsProperty", _IResolvable_9ceae33e]] = None,
            credit_specification: typing.Optional[typing.Union["CfnLaunchTemplate.CreditSpecificationProperty", _IResolvable_9ceae33e]] = None,
            disable_api_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            ebs_optimized: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            elastic_gpu_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            elastic_inference_accelerators: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]] = None,
            hibernation_options: typing.Optional[typing.Union["CfnLaunchTemplate.HibernationOptionsProperty", _IResolvable_9ceae33e]] = None,
            iam_instance_profile: typing.Optional[typing.Union["CfnLaunchTemplate.IamInstanceProfileProperty", _IResolvable_9ceae33e]] = None,
            image_id: typing.Optional[builtins.str] = None,
            instance_initiated_shutdown_behavior: typing.Optional[builtins.str] = None,
            instance_market_options: typing.Optional[typing.Union["CfnLaunchTemplate.InstanceMarketOptionsProperty", _IResolvable_9ceae33e]] = None,
            instance_type: typing.Optional[builtins.str] = None,
            kernel_id: typing.Optional[builtins.str] = None,
            key_name: typing.Optional[builtins.str] = None,
            license_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.LicenseSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            metadata_options: typing.Optional[typing.Union["CfnLaunchTemplate.MetadataOptionsProperty", _IResolvable_9ceae33e]] = None,
            monitoring: typing.Optional[typing.Union["CfnLaunchTemplate.MonitoringProperty", _IResolvable_9ceae33e]] = None,
            network_interfaces: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.NetworkInterfaceProperty", _IResolvable_9ceae33e]]]] = None,
            placement: typing.Optional[typing.Union["CfnLaunchTemplate.PlacementProperty", _IResolvable_9ceae33e]] = None,
            ram_disk_id: typing.Optional[builtins.str] = None,
            security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
            security_groups: typing.Optional[typing.List[builtins.str]] = None,
            tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.TagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            user_data: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param block_device_mappings: ``CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings``.
            :param capacity_reservation_specification: ``CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification``.
            :param cpu_options: ``CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions``.
            :param credit_specification: ``CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification``.
            :param disable_api_termination: ``CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination``.
            :param ebs_optimized: ``CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized``.
            :param elastic_gpu_specifications: ``CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications``.
            :param elastic_inference_accelerators: ``CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators``.
            :param hibernation_options: ``CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions``.
            :param iam_instance_profile: ``CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile``.
            :param image_id: ``CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId``.
            :param instance_initiated_shutdown_behavior: ``CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``.
            :param instance_market_options: ``CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions``.
            :param instance_type: ``CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType``.
            :param kernel_id: ``CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId``.
            :param key_name: ``CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName``.
            :param license_specifications: ``CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications``.
            :param metadata_options: ``CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions``.
            :param monitoring: ``CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring``.
            :param network_interfaces: ``CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces``.
            :param placement: ``CfnLaunchTemplate.LaunchTemplateDataProperty.Placement``.
            :param ram_disk_id: ``CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId``.
            :param security_group_ids: ``CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds``.
            :param security_groups: ``CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups``.
            :param tag_specifications: ``CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications``.
            :param user_data: ``CfnLaunchTemplate.LaunchTemplateDataProperty.UserData``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if block_device_mappings is not None:
                self._values["block_device_mappings"] = block_device_mappings
            if capacity_reservation_specification is not None:
                self._values["capacity_reservation_specification"] = capacity_reservation_specification
            if cpu_options is not None:
                self._values["cpu_options"] = cpu_options
            if credit_specification is not None:
                self._values["credit_specification"] = credit_specification
            if disable_api_termination is not None:
                self._values["disable_api_termination"] = disable_api_termination
            if ebs_optimized is not None:
                self._values["ebs_optimized"] = ebs_optimized
            if elastic_gpu_specifications is not None:
                self._values["elastic_gpu_specifications"] = elastic_gpu_specifications
            if elastic_inference_accelerators is not None:
                self._values["elastic_inference_accelerators"] = elastic_inference_accelerators
            if hibernation_options is not None:
                self._values["hibernation_options"] = hibernation_options
            if iam_instance_profile is not None:
                self._values["iam_instance_profile"] = iam_instance_profile
            if image_id is not None:
                self._values["image_id"] = image_id
            if instance_initiated_shutdown_behavior is not None:
                self._values["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
            if instance_market_options is not None:
                self._values["instance_market_options"] = instance_market_options
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if kernel_id is not None:
                self._values["kernel_id"] = kernel_id
            if key_name is not None:
                self._values["key_name"] = key_name
            if license_specifications is not None:
                self._values["license_specifications"] = license_specifications
            if metadata_options is not None:
                self._values["metadata_options"] = metadata_options
            if monitoring is not None:
                self._values["monitoring"] = monitoring
            if network_interfaces is not None:
                self._values["network_interfaces"] = network_interfaces
            if placement is not None:
                self._values["placement"] = placement
            if ram_disk_id is not None:
                self._values["ram_disk_id"] = ram_disk_id
            if security_group_ids is not None:
                self._values["security_group_ids"] = security_group_ids
            if security_groups is not None:
                self._values["security_groups"] = security_groups
            if tag_specifications is not None:
                self._values["tag_specifications"] = tag_specifications
            if user_data is not None:
                self._values["user_data"] = user_data

        @builtins.property
        def block_device_mappings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
            """
            result = self._values.get("block_device_mappings")
            return result

        @builtins.property
        def capacity_reservation_specification(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.CapacityReservationSpecificationProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
            """
            result = self._values.get("capacity_reservation_specification")
            return result

        @builtins.property
        def cpu_options(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.CpuOptionsProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
            """
            result = self._values.get("cpu_options")
            return result

        @builtins.property
        def credit_specification(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.CreditSpecificationProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
            """
            result = self._values.get("credit_specification")
            return result

        @builtins.property
        def disable_api_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
            """
            result = self._values.get("disable_api_termination")
            return result

        @builtins.property
        def ebs_optimized(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
            """
            result = self._values.get("ebs_optimized")
            return result

        @builtins.property
        def elastic_gpu_specifications(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.ElasticGpuSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
            """
            result = self._values.get("elastic_gpu_specifications")
            return result

        @builtins.property
        def elastic_inference_accelerators(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
            """
            result = self._values.get("elastic_inference_accelerators")
            return result

        @builtins.property
        def hibernation_options(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.HibernationOptionsProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
            """
            result = self._values.get("hibernation_options")
            return result

        @builtins.property
        def iam_instance_profile(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.IamInstanceProfileProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
            """
            result = self._values.get("iam_instance_profile")
            return result

        @builtins.property
        def image_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
            """
            result = self._values.get("image_id")
            return result

        @builtins.property
        def instance_initiated_shutdown_behavior(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
            """
            result = self._values.get("instance_initiated_shutdown_behavior")
            return result

        @builtins.property
        def instance_market_options(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.InstanceMarketOptionsProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
            """
            result = self._values.get("instance_market_options")
            return result

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
            """
            result = self._values.get("instance_type")
            return result

        @builtins.property
        def kernel_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
            """
            result = self._values.get("kernel_id")
            return result

        @builtins.property
        def key_name(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
            """
            result = self._values.get("key_name")
            return result

        @builtins.property
        def license_specifications(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.LicenseSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
            """
            result = self._values.get("license_specifications")
            return result

        @builtins.property
        def metadata_options(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.MetadataOptionsProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.MetadataOptions``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions
            """
            result = self._values.get("metadata_options")
            return result

        @builtins.property
        def monitoring(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.MonitoringProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
            """
            result = self._values.get("monitoring")
            return result

        @builtins.property
        def network_interfaces(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.NetworkInterfaceProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
            """
            result = self._values.get("network_interfaces")
            return result

        @builtins.property
        def placement(
            self,
        ) -> typing.Optional[typing.Union["CfnLaunchTemplate.PlacementProperty", _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.Placement``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
            """
            result = self._values.get("placement")
            return result

        @builtins.property
        def ram_disk_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
            """
            result = self._values.get("ram_disk_id")
            return result

        @builtins.property
        def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
            """
            result = self._values.get("security_group_ids")
            return result

        @builtins.property
        def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
            """
            result = self._values.get("security_groups")
            return result

        @builtins.property
        def tag_specifications(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.TagSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
            """
            result = self._values.get("tag_specifications")
            return result

        @builtins.property
        def user_data(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateDataProperty.UserData``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
            """
            result = self._values.get("user_data")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LaunchTemplateDataProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty",
        jsii_struct_bases=[],
        name_mapping={"count": "count", "type": "type"},
    )
    class LaunchTemplateElasticInferenceAcceleratorProperty:
        def __init__(
            self,
            *,
            count: typing.Optional[jsii.Number] = None,
            type: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param count: ``CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Count``.
            :param type: ``CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if count is not None:
                self._values["count"] = count
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def count(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Count``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-count
            """
            result = self._values.get("count")
            return result

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
            """
            result = self._values.get("type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LaunchTemplateElasticInferenceAcceleratorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.LicenseSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"license_configuration_arn": "licenseConfigurationArn"},
    )
    class LicenseSpecificationProperty:
        def __init__(
            self,
            *,
            license_configuration_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param license_configuration_arn: ``CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if license_configuration_arn is not None:
                self._values["license_configuration_arn"] = license_configuration_arn

        @builtins.property
        def license_configuration_arn(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
            """
            result = self._values.get("license_configuration_arn")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LicenseSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.MetadataOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "http_endpoint": "httpEndpoint",
            "http_put_response_hop_limit": "httpPutResponseHopLimit",
            "http_tokens": "httpTokens",
        },
    )
    class MetadataOptionsProperty:
        def __init__(
            self,
            *,
            http_endpoint: typing.Optional[builtins.str] = None,
            http_put_response_hop_limit: typing.Optional[jsii.Number] = None,
            http_tokens: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param http_endpoint: ``CfnLaunchTemplate.MetadataOptionsProperty.HttpEndpoint``.
            :param http_put_response_hop_limit: ``CfnLaunchTemplate.MetadataOptionsProperty.HttpPutResponseHopLimit``.
            :param http_tokens: ``CfnLaunchTemplate.MetadataOptionsProperty.HttpTokens``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if http_endpoint is not None:
                self._values["http_endpoint"] = http_endpoint
            if http_put_response_hop_limit is not None:
                self._values["http_put_response_hop_limit"] = http_put_response_hop_limit
            if http_tokens is not None:
                self._values["http_tokens"] = http_tokens

        @builtins.property
        def http_endpoint(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.MetadataOptionsProperty.HttpEndpoint``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpendpoint
            """
            result = self._values.get("http_endpoint")
            return result

        @builtins.property
        def http_put_response_hop_limit(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.MetadataOptionsProperty.HttpPutResponseHopLimit``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httpputresponsehoplimit
            """
            result = self._values.get("http_put_response_hop_limit")
            return result

        @builtins.property
        def http_tokens(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.MetadataOptionsProperty.HttpTokens``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens
            """
            result = self._values.get("http_tokens")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MetadataOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.MonitoringProperty",
        jsii_struct_bases=[],
        name_mapping={"enabled": "enabled"},
    )
    class MonitoringProperty:
        def __init__(
            self,
            *,
            enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param enabled: ``CfnLaunchTemplate.MonitoringProperty.Enabled``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if enabled is not None:
                self._values["enabled"] = enabled

        @builtins.property
        def enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.MonitoringProperty.Enabled``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
            """
            result = self._values.get("enabled")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.NetworkInterfaceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "associate_public_ip_address": "associatePublicIpAddress",
            "delete_on_termination": "deleteOnTermination",
            "description": "description",
            "device_index": "deviceIndex",
            "groups": "groups",
            "interface_type": "interfaceType",
            "ipv6_address_count": "ipv6AddressCount",
            "ipv6_addresses": "ipv6Addresses",
            "network_interface_id": "networkInterfaceId",
            "private_ip_address": "privateIpAddress",
            "private_ip_addresses": "privateIpAddresses",
            "secondary_private_ip_address_count": "secondaryPrivateIpAddressCount",
            "subnet_id": "subnetId",
        },
    )
    class NetworkInterfaceProperty:
        def __init__(
            self,
            *,
            associate_public_ip_address: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            description: typing.Optional[builtins.str] = None,
            device_index: typing.Optional[jsii.Number] = None,
            groups: typing.Optional[typing.List[builtins.str]] = None,
            interface_type: typing.Optional[builtins.str] = None,
            ipv6_address_count: typing.Optional[jsii.Number] = None,
            ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.Ipv6AddProperty", _IResolvable_9ceae33e]]]] = None,
            network_interface_id: typing.Optional[builtins.str] = None,
            private_ip_address: typing.Optional[builtins.str] = None,
            private_ip_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.PrivateIpAddProperty", _IResolvable_9ceae33e]]]] = None,
            secondary_private_ip_address_count: typing.Optional[jsii.Number] = None,
            subnet_id: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param associate_public_ip_address: ``CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress``.
            :param delete_on_termination: ``CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination``.
            :param description: ``CfnLaunchTemplate.NetworkInterfaceProperty.Description``.
            :param device_index: ``CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex``.
            :param groups: ``CfnLaunchTemplate.NetworkInterfaceProperty.Groups``.
            :param interface_type: ``CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType``.
            :param ipv6_address_count: ``CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount``.
            :param ipv6_addresses: ``CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses``.
            :param network_interface_id: ``CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId``.
            :param private_ip_address: ``CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress``.
            :param private_ip_addresses: ``CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses``.
            :param secondary_private_ip_address_count: ``CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``.
            :param subnet_id: ``CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if associate_public_ip_address is not None:
                self._values["associate_public_ip_address"] = associate_public_ip_address
            if delete_on_termination is not None:
                self._values["delete_on_termination"] = delete_on_termination
            if description is not None:
                self._values["description"] = description
            if device_index is not None:
                self._values["device_index"] = device_index
            if groups is not None:
                self._values["groups"] = groups
            if interface_type is not None:
                self._values["interface_type"] = interface_type
            if ipv6_address_count is not None:
                self._values["ipv6_address_count"] = ipv6_address_count
            if ipv6_addresses is not None:
                self._values["ipv6_addresses"] = ipv6_addresses
            if network_interface_id is not None:
                self._values["network_interface_id"] = network_interface_id
            if private_ip_address is not None:
                self._values["private_ip_address"] = private_ip_address
            if private_ip_addresses is not None:
                self._values["private_ip_addresses"] = private_ip_addresses
            if secondary_private_ip_address_count is not None:
                self._values["secondary_private_ip_address_count"] = secondary_private_ip_address_count
            if subnet_id is not None:
                self._values["subnet_id"] = subnet_id

        @builtins.property
        def associate_public_ip_address(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
            """
            result = self._values.get("associate_public_ip_address")
            return result

        @builtins.property
        def delete_on_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
            """
            result = self._values.get("delete_on_termination")
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
            """
            result = self._values.get("description")
            return result

        @builtins.property
        def device_index(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
            """
            result = self._values.get("device_index")
            return result

        @builtins.property
        def groups(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.Groups``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
            """
            result = self._values.get("groups")
            return result

        @builtins.property
        def interface_type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
            """
            result = self._values.get("interface_type")
            return result

        @builtins.property
        def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
            """
            result = self._values.get("ipv6_address_count")
            return result

        @builtins.property
        def ipv6_addresses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.Ipv6AddProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
            """
            result = self._values.get("ipv6_addresses")
            return result

        @builtins.property
        def network_interface_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
            """
            result = self._values.get("network_interface_id")
            return result

        @builtins.property
        def private_ip_address(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
            """
            result = self._values.get("private_ip_address")
            return result

        @builtins.property
        def private_ip_addresses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnLaunchTemplate.PrivateIpAddProperty", _IResolvable_9ceae33e]]]]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
            """
            result = self._values.get("private_ip_addresses")
            return result

        @builtins.property
        def secondary_private_ip_address_count(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
            """
            result = self._values.get("secondary_private_ip_address_count")
            return result

        @builtins.property
        def subnet_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
            """
            result = self._values.get("subnet_id")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkInterfaceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.PlacementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "affinity": "affinity",
            "availability_zone": "availabilityZone",
            "group_name": "groupName",
            "host_id": "hostId",
            "host_resource_group_arn": "hostResourceGroupArn",
            "partition_number": "partitionNumber",
            "spread_domain": "spreadDomain",
            "tenancy": "tenancy",
        },
    )
    class PlacementProperty:
        def __init__(
            self,
            *,
            affinity: typing.Optional[builtins.str] = None,
            availability_zone: typing.Optional[builtins.str] = None,
            group_name: typing.Optional[builtins.str] = None,
            host_id: typing.Optional[builtins.str] = None,
            host_resource_group_arn: typing.Optional[builtins.str] = None,
            partition_number: typing.Optional[jsii.Number] = None,
            spread_domain: typing.Optional[builtins.str] = None,
            tenancy: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param affinity: ``CfnLaunchTemplate.PlacementProperty.Affinity``.
            :param availability_zone: ``CfnLaunchTemplate.PlacementProperty.AvailabilityZone``.
            :param group_name: ``CfnLaunchTemplate.PlacementProperty.GroupName``.
            :param host_id: ``CfnLaunchTemplate.PlacementProperty.HostId``.
            :param host_resource_group_arn: ``CfnLaunchTemplate.PlacementProperty.HostResourceGroupArn``.
            :param partition_number: ``CfnLaunchTemplate.PlacementProperty.PartitionNumber``.
            :param spread_domain: ``CfnLaunchTemplate.PlacementProperty.SpreadDomain``.
            :param tenancy: ``CfnLaunchTemplate.PlacementProperty.Tenancy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if affinity is not None:
                self._values["affinity"] = affinity
            if availability_zone is not None:
                self._values["availability_zone"] = availability_zone
            if group_name is not None:
                self._values["group_name"] = group_name
            if host_id is not None:
                self._values["host_id"] = host_id
            if host_resource_group_arn is not None:
                self._values["host_resource_group_arn"] = host_resource_group_arn
            if partition_number is not None:
                self._values["partition_number"] = partition_number
            if spread_domain is not None:
                self._values["spread_domain"] = spread_domain
            if tenancy is not None:
                self._values["tenancy"] = tenancy

        @builtins.property
        def affinity(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.Affinity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
            """
            result = self._values.get("affinity")
            return result

        @builtins.property
        def availability_zone(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.AvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
            """
            result = self._values.get("availability_zone")
            return result

        @builtins.property
        def group_name(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.GroupName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
            """
            result = self._values.get("group_name")
            return result

        @builtins.property
        def host_id(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.HostId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
            """
            result = self._values.get("host_id")
            return result

        @builtins.property
        def host_resource_group_arn(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.HostResourceGroupArn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostresourcegrouparn
            """
            result = self._values.get("host_resource_group_arn")
            return result

        @builtins.property
        def partition_number(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.PlacementProperty.PartitionNumber``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-partitionnumber
            """
            result = self._values.get("partition_number")
            return result

        @builtins.property
        def spread_domain(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.SpreadDomain``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-spreaddomain
            """
            result = self._values.get("spread_domain")
            return result

        @builtins.property
        def tenancy(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PlacementProperty.Tenancy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
            """
            result = self._values.get("tenancy")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PlacementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.PrivateIpAddProperty",
        jsii_struct_bases=[],
        name_mapping={"primary": "primary", "private_ip_address": "privateIpAddress"},
    )
    class PrivateIpAddProperty:
        def __init__(
            self,
            *,
            primary: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            private_ip_address: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param primary: ``CfnLaunchTemplate.PrivateIpAddProperty.Primary``.
            :param private_ip_address: ``CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if primary is not None:
                self._values["primary"] = primary
            if private_ip_address is not None:
                self._values["private_ip_address"] = private_ip_address

        @builtins.property
        def primary(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnLaunchTemplate.PrivateIpAddProperty.Primary``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
            """
            result = self._values.get("primary")
            return result

        @builtins.property
        def private_ip_address(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
            """
            result = self._values.get("private_ip_address")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PrivateIpAddProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.SpotOptionsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "block_duration_minutes": "blockDurationMinutes",
            "instance_interruption_behavior": "instanceInterruptionBehavior",
            "max_price": "maxPrice",
            "spot_instance_type": "spotInstanceType",
            "valid_until": "validUntil",
        },
    )
    class SpotOptionsProperty:
        def __init__(
            self,
            *,
            block_duration_minutes: typing.Optional[jsii.Number] = None,
            instance_interruption_behavior: typing.Optional[builtins.str] = None,
            max_price: typing.Optional[builtins.str] = None,
            spot_instance_type: typing.Optional[builtins.str] = None,
            valid_until: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param block_duration_minutes: ``CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes``.
            :param instance_interruption_behavior: ``CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior``.
            :param max_price: ``CfnLaunchTemplate.SpotOptionsProperty.MaxPrice``.
            :param spot_instance_type: ``CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType``.
            :param valid_until: ``CfnLaunchTemplate.SpotOptionsProperty.ValidUntil``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if block_duration_minutes is not None:
                self._values["block_duration_minutes"] = block_duration_minutes
            if instance_interruption_behavior is not None:
                self._values["instance_interruption_behavior"] = instance_interruption_behavior
            if max_price is not None:
                self._values["max_price"] = max_price
            if spot_instance_type is not None:
                self._values["spot_instance_type"] = spot_instance_type
            if valid_until is not None:
                self._values["valid_until"] = valid_until

        @builtins.property
        def block_duration_minutes(self) -> typing.Optional[jsii.Number]:
            """``CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-blockdurationminutes
            """
            result = self._values.get("block_duration_minutes")
            return result

        @builtins.property
        def instance_interruption_behavior(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
            """
            result = self._values.get("instance_interruption_behavior")
            return result

        @builtins.property
        def max_price(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.SpotOptionsProperty.MaxPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
            """
            result = self._values.get("max_price")
            return result

        @builtins.property
        def spot_instance_type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
            """
            result = self._values.get("spot_instance_type")
            return result

        @builtins.property
        def valid_until(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.SpotOptionsProperty.ValidUntil``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-validuntil
            """
            result = self._values.get("valid_until")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotOptionsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplate.TagSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"resource_type": "resourceType", "tags": "tags"},
    )
    class TagSpecificationProperty:
        def __init__(
            self,
            *,
            resource_type: typing.Optional[builtins.str] = None,
            tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        ) -> None:
            """
            :param resource_type: ``CfnLaunchTemplate.TagSpecificationProperty.ResourceType``.
            :param tags: ``CfnLaunchTemplate.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if resource_type is not None:
                self._values["resource_type"] = resource_type
            if tags is not None:
                self._values["tags"] = tags

        @builtins.property
        def resource_type(self) -> typing.Optional[builtins.str]:
            """``CfnLaunchTemplate.TagSpecificationProperty.ResourceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
            """
            result = self._values.get("resource_type")
            return result

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
            """``CfnLaunchTemplate.TagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
            """
            result = self._values.get("tags")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TagSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnLaunchTemplateProps",
    jsii_struct_bases=[],
    name_mapping={
        "launch_template_data": "launchTemplateData",
        "launch_template_name": "launchTemplateName",
    },
)
class CfnLaunchTemplateProps:
    def __init__(
        self,
        *,
        launch_template_data: typing.Optional[typing.Union["CfnLaunchTemplate.LaunchTemplateDataProperty", _IResolvable_9ceae33e]] = None,
        launch_template_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::LaunchTemplate``.

        :param launch_template_data: ``AWS::EC2::LaunchTemplate.LaunchTemplateData``.
        :param launch_template_name: ``AWS::EC2::LaunchTemplate.LaunchTemplateName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if launch_template_data is not None:
            self._values["launch_template_data"] = launch_template_data
        if launch_template_name is not None:
            self._values["launch_template_name"] = launch_template_name

    @builtins.property
    def launch_template_data(
        self,
    ) -> typing.Optional[typing.Union["CfnLaunchTemplate.LaunchTemplateDataProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::LaunchTemplate.LaunchTemplateData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
        """
        result = self._values.get("launch_template_data")
        return result

    @builtins.property
    def launch_template_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::LaunchTemplate.LaunchTemplateName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
        """
        result = self._values.get("launch_template_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnLaunchTemplateProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnLocalGatewayRoute(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnLocalGatewayRoute",
):
    """A CloudFormation ``AWS::EC2::LocalGatewayRoute``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::LocalGatewayRoute
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        destination_cidr_block: builtins.str,
        local_gateway_route_table_id: builtins.str,
        local_gateway_virtual_interface_group_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::LocalGatewayRoute``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param destination_cidr_block: ``AWS::EC2::LocalGatewayRoute.DestinationCidrBlock``.
        :param local_gateway_route_table_id: ``AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId``.
        :param local_gateway_virtual_interface_group_id: ``AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId``.
        """
        props = CfnLocalGatewayRouteProps(
            destination_cidr_block=destination_cidr_block,
            local_gateway_route_table_id=local_gateway_route_table_id,
            local_gateway_virtual_interface_group_id=local_gateway_virtual_interface_group_id,
        )

        jsii.create(CfnLocalGatewayRoute, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrState")
    def attr_state(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: State
        """
        return jsii.get(self, "attrState")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrType")
    def attr_type(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Type
        """
        return jsii.get(self, "attrType")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationCidrBlock")
    def destination_cidr_block(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRoute.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
        """
        return jsii.get(self, "destinationCidrBlock")

    @destination_cidr_block.setter # type: ignore
    def destination_cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "destinationCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="localGatewayRouteTableId")
    def local_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
        """
        return jsii.get(self, "localGatewayRouteTableId")

    @local_gateway_route_table_id.setter # type: ignore
    def local_gateway_route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "localGatewayRouteTableId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="localGatewayVirtualInterfaceGroupId")
    def local_gateway_virtual_interface_group_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
        """
        return jsii.get(self, "localGatewayVirtualInterfaceGroupId")

    @local_gateway_virtual_interface_group_id.setter # type: ignore
    def local_gateway_virtual_interface_group_id(self, value: builtins.str) -> None:
        jsii.set(self, "localGatewayVirtualInterfaceGroupId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnLocalGatewayRouteProps",
    jsii_struct_bases=[],
    name_mapping={
        "destination_cidr_block": "destinationCidrBlock",
        "local_gateway_route_table_id": "localGatewayRouteTableId",
        "local_gateway_virtual_interface_group_id": "localGatewayVirtualInterfaceGroupId",
    },
)
class CfnLocalGatewayRouteProps:
    def __init__(
        self,
        *,
        destination_cidr_block: builtins.str,
        local_gateway_route_table_id: builtins.str,
        local_gateway_virtual_interface_group_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::LocalGatewayRoute``.

        :param destination_cidr_block: ``AWS::EC2::LocalGatewayRoute.DestinationCidrBlock``.
        :param local_gateway_route_table_id: ``AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId``.
        :param local_gateway_virtual_interface_group_id: ``AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "destination_cidr_block": destination_cidr_block,
            "local_gateway_route_table_id": local_gateway_route_table_id,
            "local_gateway_virtual_interface_group_id": local_gateway_virtual_interface_group_id,
        }

    @builtins.property
    def destination_cidr_block(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRoute.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
        """
        result = self._values.get("destination_cidr_block")
        assert result is not None, "Required property 'destination_cidr_block' is missing"
        return result

    @builtins.property
    def local_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
        """
        result = self._values.get("local_gateway_route_table_id")
        assert result is not None, "Required property 'local_gateway_route_table_id' is missing"
        return result

    @builtins.property
    def local_gateway_virtual_interface_group_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
        """
        result = self._values.get("local_gateway_virtual_interface_group_id")
        assert result is not None, "Required property 'local_gateway_virtual_interface_group_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnLocalGatewayRouteProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnLocalGatewayRouteTableVPCAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnLocalGatewayRouteTableVPCAssociation",
):
    """A CloudFormation ``AWS::EC2::LocalGatewayRouteTableVPCAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::LocalGatewayRouteTableVPCAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        local_gateway_route_table_id: builtins.str,
        vpc_id: builtins.str,
        tags: typing.Optional["TagsProperty"] = None,
    ) -> None:
        """Create a new ``AWS::EC2::LocalGatewayRouteTableVPCAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param local_gateway_route_table_id: ``AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId``.
        :param vpc_id: ``AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId``.
        :param tags: ``AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags``.
        """
        props = CfnLocalGatewayRouteTableVPCAssociationProps(
            local_gateway_route_table_id=local_gateway_route_table_id,
            vpc_id=vpc_id,
            tags=tags,
        )

        jsii.create(CfnLocalGatewayRouteTableVPCAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrLocalGatewayId")
    def attr_local_gateway_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: LocalGatewayId
        """
        return jsii.get(self, "attrLocalGatewayId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrLocalGatewayRouteTableVpcAssociationId")
    def attr_local_gateway_route_table_vpc_association_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: LocalGatewayRouteTableVpcAssociationId
        """
        return jsii.get(self, "attrLocalGatewayRouteTableVpcAssociationId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrState")
    def attr_state(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: State
        """
        return jsii.get(self, "attrState")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="localGatewayRouteTableId")
    def local_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-localgatewayroutetableid
        """
        return jsii.get(self, "localGatewayRouteTableId")

    @local_gateway_route_table_id.setter # type: ignore
    def local_gateway_route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "localGatewayRouteTableId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnLocalGatewayRouteTableVPCAssociation.TagsProperty",
        jsii_struct_bases=[],
        name_mapping={"tags": "tags"},
    )
    class TagsProperty:
        def __init__(
            self,
            *,
            tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        ) -> None:
            """
            :param tags: ``CfnLocalGatewayRouteTableVPCAssociation.TagsProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-localgatewayroutetablevpcassociation-tags.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if tags is not None:
                self._values["tags"] = tags

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
            """``CfnLocalGatewayRouteTableVPCAssociation.TagsProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-localgatewayroutetablevpcassociation-tags.html#cfn-ec2-localgatewayroutetablevpcassociation-tags-tags
            """
            result = self._values.get("tags")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TagsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnLocalGatewayRouteTableVPCAssociationProps",
    jsii_struct_bases=[],
    name_mapping={
        "local_gateway_route_table_id": "localGatewayRouteTableId",
        "vpc_id": "vpcId",
        "tags": "tags",
    },
)
class CfnLocalGatewayRouteTableVPCAssociationProps:
    def __init__(
        self,
        *,
        local_gateway_route_table_id: builtins.str,
        vpc_id: builtins.str,
        tags: typing.Optional["CfnLocalGatewayRouteTableVPCAssociation.TagsProperty"] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::LocalGatewayRouteTableVPCAssociation``.

        :param local_gateway_route_table_id: ``AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId``.
        :param vpc_id: ``AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId``.
        :param tags: ``AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html
        """
        if isinstance(tags, dict):
            tags = CfnLocalGatewayRouteTableVPCAssociation.TagsProperty(**tags)
        self._values: typing.Dict[str, typing.Any] = {
            "local_gateway_route_table_id": local_gateway_route_table_id,
            "vpc_id": vpc_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def local_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRouteTableVPCAssociation.LocalGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-localgatewayroutetableid
        """
        result = self._values.get("local_gateway_route_table_id")
        assert result is not None, "Required property 'local_gateway_route_table_id' is missing"
        return result

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::LocalGatewayRouteTableVPCAssociation.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def tags(
        self,
    ) -> typing.Optional["CfnLocalGatewayRouteTableVPCAssociation.TagsProperty"]:
        """``AWS::EC2::LocalGatewayRouteTableVPCAssociation.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroutetablevpcassociation.html#cfn-ec2-localgatewayroutetablevpcassociation-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnLocalGatewayRouteTableVPCAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnNatGateway(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnNatGateway",
):
    """A CloudFormation ``AWS::EC2::NatGateway``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::NatGateway
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        allocation_id: builtins.str,
        subnet_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::NatGateway``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param allocation_id: ``AWS::EC2::NatGateway.AllocationId``.
        :param subnet_id: ``AWS::EC2::NatGateway.SubnetId``.
        :param tags: ``AWS::EC2::NatGateway.Tags``.
        """
        props = CfnNatGatewayProps(
            allocation_id=allocation_id, subnet_id=subnet_id, tags=tags
        )

        jsii.create(CfnNatGateway, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::NatGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allocationId")
    def allocation_id(self) -> builtins.str:
        """``AWS::EC2::NatGateway.AllocationId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
        """
        return jsii.get(self, "allocationId")

    @allocation_id.setter # type: ignore
    def allocation_id(self, value: builtins.str) -> None:
        jsii.set(self, "allocationId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::NatGateway.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnNatGatewayProps",
    jsii_struct_bases=[],
    name_mapping={
        "allocation_id": "allocationId",
        "subnet_id": "subnetId",
        "tags": "tags",
    },
)
class CfnNatGatewayProps:
    def __init__(
        self,
        *,
        allocation_id: builtins.str,
        subnet_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::NatGateway``.

        :param allocation_id: ``AWS::EC2::NatGateway.AllocationId``.
        :param subnet_id: ``AWS::EC2::NatGateway.SubnetId``.
        :param tags: ``AWS::EC2::NatGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "allocation_id": allocation_id,
            "subnet_id": subnet_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def allocation_id(self) -> builtins.str:
        """``AWS::EC2::NatGateway.AllocationId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
        """
        result = self._values.get("allocation_id")
        assert result is not None, "Required property 'allocation_id' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::NatGateway.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::NatGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnNatGatewayProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnNetworkAcl(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkAcl",
):
    """A CloudFormation ``AWS::EC2::NetworkAcl``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::NetworkAcl
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        vpc_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::NetworkAcl``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param vpc_id: ``AWS::EC2::NetworkAcl.VpcId``.
        :param tags: ``AWS::EC2::NetworkAcl.Tags``.
        """
        props = CfnNetworkAclProps(vpc_id=vpc_id, tags=tags)

        jsii.create(CfnNetworkAcl, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::NetworkAcl.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::NetworkAcl.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnNetworkAclEntry(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkAclEntry",
):
    """A CloudFormation ``AWS::EC2::NetworkAclEntry``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::NetworkAclEntry
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        network_acl_id: builtins.str,
        protocol: jsii.Number,
        rule_action: builtins.str,
        rule_number: jsii.Number,
        cidr_block: typing.Optional[builtins.str] = None,
        egress: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        icmp: typing.Optional[typing.Union["IcmpProperty", _IResolvable_9ceae33e]] = None,
        ipv6_cidr_block: typing.Optional[builtins.str] = None,
        port_range: typing.Optional[typing.Union["PortRangeProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::NetworkAclEntry``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param network_acl_id: ``AWS::EC2::NetworkAclEntry.NetworkAclId``.
        :param protocol: ``AWS::EC2::NetworkAclEntry.Protocol``.
        :param rule_action: ``AWS::EC2::NetworkAclEntry.RuleAction``.
        :param rule_number: ``AWS::EC2::NetworkAclEntry.RuleNumber``.
        :param cidr_block: ``AWS::EC2::NetworkAclEntry.CidrBlock``.
        :param egress: ``AWS::EC2::NetworkAclEntry.Egress``.
        :param icmp: ``AWS::EC2::NetworkAclEntry.Icmp``.
        :param ipv6_cidr_block: ``AWS::EC2::NetworkAclEntry.Ipv6CidrBlock``.
        :param port_range: ``AWS::EC2::NetworkAclEntry.PortRange``.
        """
        props = CfnNetworkAclEntryProps(
            network_acl_id=network_acl_id,
            protocol=protocol,
            rule_action=rule_action,
            rule_number=rule_number,
            cidr_block=cidr_block,
            egress=egress,
            icmp=icmp,
            ipv6_cidr_block=ipv6_cidr_block,
            port_range=port_range,
        )

        jsii.create(CfnNetworkAclEntry, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkAclId")
    def network_acl_id(self) -> builtins.str:
        """``AWS::EC2::NetworkAclEntry.NetworkAclId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
        """
        return jsii.get(self, "networkAclId")

    @network_acl_id.setter # type: ignore
    def network_acl_id(self, value: builtins.str) -> None:
        jsii.set(self, "networkAclId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocol")
    def protocol(self) -> jsii.Number:
        """``AWS::EC2::NetworkAclEntry.Protocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
        """
        return jsii.get(self, "protocol")

    @protocol.setter # type: ignore
    def protocol(self, value: jsii.Number) -> None:
        jsii.set(self, "protocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ruleAction")
    def rule_action(self) -> builtins.str:
        """``AWS::EC2::NetworkAclEntry.RuleAction``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
        """
        return jsii.get(self, "ruleAction")

    @rule_action.setter # type: ignore
    def rule_action(self, value: builtins.str) -> None:
        jsii.set(self, "ruleAction", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ruleNumber")
    def rule_number(self) -> jsii.Number:
        """``AWS::EC2::NetworkAclEntry.RuleNumber``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
        """
        return jsii.get(self, "ruleNumber")

    @rule_number.setter # type: ignore
    def rule_number(self, value: jsii.Number) -> None:
        jsii.set(self, "ruleNumber", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrBlock")
    def cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkAclEntry.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
        """
        return jsii.get(self, "cidrBlock")

    @cidr_block.setter # type: ignore
    def cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="egress")
    def egress(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkAclEntry.Egress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
        """
        return jsii.get(self, "egress")

    @egress.setter # type: ignore
    def egress(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "egress", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="icmp")
    def icmp(
        self,
    ) -> typing.Optional[typing.Union["IcmpProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkAclEntry.Icmp``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
        """
        return jsii.get(self, "icmp")

    @icmp.setter # type: ignore
    def icmp(
        self,
        value: typing.Optional[typing.Union["IcmpProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "icmp", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkAclEntry.Ipv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
        """
        return jsii.get(self, "ipv6CidrBlock")

    @ipv6_cidr_block.setter # type: ignore
    def ipv6_cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "ipv6CidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="portRange")
    def port_range(
        self,
    ) -> typing.Optional[typing.Union["PortRangeProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkAclEntry.PortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
        """
        return jsii.get(self, "portRange")

    @port_range.setter # type: ignore
    def port_range(
        self,
        value: typing.Optional[typing.Union["PortRangeProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "portRange", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnNetworkAclEntry.IcmpProperty",
        jsii_struct_bases=[],
        name_mapping={"code": "code", "type": "type"},
    )
    class IcmpProperty:
        def __init__(
            self,
            *,
            code: typing.Optional[jsii.Number] = None,
            type: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param code: ``CfnNetworkAclEntry.IcmpProperty.Code``.
            :param type: ``CfnNetworkAclEntry.IcmpProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if code is not None:
                self._values["code"] = code
            if type is not None:
                self._values["type"] = type

        @builtins.property
        def code(self) -> typing.Optional[jsii.Number]:
            """``CfnNetworkAclEntry.IcmpProperty.Code``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
            """
            result = self._values.get("code")
            return result

        @builtins.property
        def type(self) -> typing.Optional[jsii.Number]:
            """``CfnNetworkAclEntry.IcmpProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
            """
            result = self._values.get("type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IcmpProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnNetworkAclEntry.PortRangeProperty",
        jsii_struct_bases=[],
        name_mapping={"from_": "from", "to": "to"},
    )
    class PortRangeProperty:
        def __init__(
            self,
            *,
            from_: typing.Optional[jsii.Number] = None,
            to: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param from_: ``CfnNetworkAclEntry.PortRangeProperty.From``.
            :param to: ``CfnNetworkAclEntry.PortRangeProperty.To``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if from_ is not None:
                self._values["from_"] = from_
            if to is not None:
                self._values["to"] = to

        @builtins.property
        def from_(self) -> typing.Optional[jsii.Number]:
            """``CfnNetworkAclEntry.PortRangeProperty.From``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
            """
            result = self._values.get("from_")
            return result

        @builtins.property
        def to(self) -> typing.Optional[jsii.Number]:
            """``CfnNetworkAclEntry.PortRangeProperty.To``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
            """
            result = self._values.get("to")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PortRangeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkAclEntryProps",
    jsii_struct_bases=[],
    name_mapping={
        "network_acl_id": "networkAclId",
        "protocol": "protocol",
        "rule_action": "ruleAction",
        "rule_number": "ruleNumber",
        "cidr_block": "cidrBlock",
        "egress": "egress",
        "icmp": "icmp",
        "ipv6_cidr_block": "ipv6CidrBlock",
        "port_range": "portRange",
    },
)
class CfnNetworkAclEntryProps:
    def __init__(
        self,
        *,
        network_acl_id: builtins.str,
        protocol: jsii.Number,
        rule_action: builtins.str,
        rule_number: jsii.Number,
        cidr_block: typing.Optional[builtins.str] = None,
        egress: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        icmp: typing.Optional[typing.Union["CfnNetworkAclEntry.IcmpProperty", _IResolvable_9ceae33e]] = None,
        ipv6_cidr_block: typing.Optional[builtins.str] = None,
        port_range: typing.Optional[typing.Union["CfnNetworkAclEntry.PortRangeProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::NetworkAclEntry``.

        :param network_acl_id: ``AWS::EC2::NetworkAclEntry.NetworkAclId``.
        :param protocol: ``AWS::EC2::NetworkAclEntry.Protocol``.
        :param rule_action: ``AWS::EC2::NetworkAclEntry.RuleAction``.
        :param rule_number: ``AWS::EC2::NetworkAclEntry.RuleNumber``.
        :param cidr_block: ``AWS::EC2::NetworkAclEntry.CidrBlock``.
        :param egress: ``AWS::EC2::NetworkAclEntry.Egress``.
        :param icmp: ``AWS::EC2::NetworkAclEntry.Icmp``.
        :param ipv6_cidr_block: ``AWS::EC2::NetworkAclEntry.Ipv6CidrBlock``.
        :param port_range: ``AWS::EC2::NetworkAclEntry.PortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "network_acl_id": network_acl_id,
            "protocol": protocol,
            "rule_action": rule_action,
            "rule_number": rule_number,
        }
        if cidr_block is not None:
            self._values["cidr_block"] = cidr_block
        if egress is not None:
            self._values["egress"] = egress
        if icmp is not None:
            self._values["icmp"] = icmp
        if ipv6_cidr_block is not None:
            self._values["ipv6_cidr_block"] = ipv6_cidr_block
        if port_range is not None:
            self._values["port_range"] = port_range

    @builtins.property
    def network_acl_id(self) -> builtins.str:
        """``AWS::EC2::NetworkAclEntry.NetworkAclId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
        """
        result = self._values.get("network_acl_id")
        assert result is not None, "Required property 'network_acl_id' is missing"
        return result

    @builtins.property
    def protocol(self) -> jsii.Number:
        """``AWS::EC2::NetworkAclEntry.Protocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
        """
        result = self._values.get("protocol")
        assert result is not None, "Required property 'protocol' is missing"
        return result

    @builtins.property
    def rule_action(self) -> builtins.str:
        """``AWS::EC2::NetworkAclEntry.RuleAction``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
        """
        result = self._values.get("rule_action")
        assert result is not None, "Required property 'rule_action' is missing"
        return result

    @builtins.property
    def rule_number(self) -> jsii.Number:
        """``AWS::EC2::NetworkAclEntry.RuleNumber``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
        """
        result = self._values.get("rule_number")
        assert result is not None, "Required property 'rule_number' is missing"
        return result

    @builtins.property
    def cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkAclEntry.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
        """
        result = self._values.get("cidr_block")
        return result

    @builtins.property
    def egress(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkAclEntry.Egress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
        """
        result = self._values.get("egress")
        return result

    @builtins.property
    def icmp(
        self,
    ) -> typing.Optional[typing.Union["CfnNetworkAclEntry.IcmpProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkAclEntry.Icmp``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
        """
        result = self._values.get("icmp")
        return result

    @builtins.property
    def ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkAclEntry.Ipv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
        """
        result = self._values.get("ipv6_cidr_block")
        return result

    @builtins.property
    def port_range(
        self,
    ) -> typing.Optional[typing.Union["CfnNetworkAclEntry.PortRangeProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkAclEntry.PortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
        """
        result = self._values.get("port_range")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnNetworkAclEntryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkAclProps",
    jsii_struct_bases=[],
    name_mapping={"vpc_id": "vpcId", "tags": "tags"},
)
class CfnNetworkAclProps:
    def __init__(
        self,
        *,
        vpc_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::NetworkAcl``.

        :param vpc_id: ``AWS::EC2::NetworkAcl.VpcId``.
        :param tags: ``AWS::EC2::NetworkAcl.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "vpc_id": vpc_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::NetworkAcl.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::NetworkAcl.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnNetworkAclProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnNetworkInterface(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterface",
):
    """A CloudFormation ``AWS::EC2::NetworkInterface``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::NetworkInterface
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        subnet_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        group_set: typing.Optional[typing.List[builtins.str]] = None,
        interface_type: typing.Optional[builtins.str] = None,
        ipv6_address_count: typing.Optional[jsii.Number] = None,
        ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
        private_ip_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        secondary_private_ip_address_count: typing.Optional[jsii.Number] = None,
        source_dest_check: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::NetworkInterface``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param subnet_id: ``AWS::EC2::NetworkInterface.SubnetId``.
        :param description: ``AWS::EC2::NetworkInterface.Description``.
        :param group_set: ``AWS::EC2::NetworkInterface.GroupSet``.
        :param interface_type: ``AWS::EC2::NetworkInterface.InterfaceType``.
        :param ipv6_address_count: ``AWS::EC2::NetworkInterface.Ipv6AddressCount``.
        :param ipv6_addresses: ``AWS::EC2::NetworkInterface.Ipv6Addresses``.
        :param private_ip_address: ``AWS::EC2::NetworkInterface.PrivateIpAddress``.
        :param private_ip_addresses: ``AWS::EC2::NetworkInterface.PrivateIpAddresses``.
        :param secondary_private_ip_address_count: ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``.
        :param source_dest_check: ``AWS::EC2::NetworkInterface.SourceDestCheck``.
        :param tags: ``AWS::EC2::NetworkInterface.Tags``.
        """
        props = CfnNetworkInterfaceProps(
            subnet_id=subnet_id,
            description=description,
            group_set=group_set,
            interface_type=interface_type,
            ipv6_address_count=ipv6_address_count,
            ipv6_addresses=ipv6_addresses,
            private_ip_address=private_ip_address,
            private_ip_addresses=private_ip_addresses,
            secondary_private_ip_address_count=secondary_private_ip_address_count,
            source_dest_check=source_dest_check,
            tags=tags,
        )

        jsii.create(CfnNetworkInterface, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrPrimaryPrivateIpAddress")
    def attr_primary_private_ip_address(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: PrimaryPrivateIpAddress
        """
        return jsii.get(self, "attrPrimaryPrivateIpAddress")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrSecondaryPrivateIpAddresses")
    def attr_secondary_private_ip_addresses(self) -> typing.List[builtins.str]:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: SecondaryPrivateIpAddresses
        """
        return jsii.get(self, "attrSecondaryPrivateIpAddresses")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::NetworkInterface.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterface.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkInterface.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupSet")
    def group_set(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::NetworkInterface.GroupSet``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
        """
        return jsii.get(self, "groupSet")

    @group_set.setter # type: ignore
    def group_set(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        jsii.set(self, "groupSet", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="interfaceType")
    def interface_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkInterface.InterfaceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
        """
        return jsii.get(self, "interfaceType")

    @interface_type.setter # type: ignore
    def interface_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "interfaceType", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6AddressCount")
    def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::NetworkInterface.Ipv6AddressCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
        """
        return jsii.get(self, "ipv6AddressCount")

    @ipv6_address_count.setter # type: ignore
    def ipv6_address_count(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "ipv6AddressCount", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6Addresses")
    def ipv6_addresses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::NetworkInterface.Ipv6Addresses``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
        """
        return jsii.get(self, "ipv6Addresses")

    @ipv6_addresses.setter # type: ignore
    def ipv6_addresses(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "ipv6Addresses", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="privateIpAddress")
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkInterface.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
        """
        return jsii.get(self, "privateIpAddress")

    @private_ip_address.setter # type: ignore
    def private_ip_address(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "privateIpAddress", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="privateIpAddresses")
    def private_ip_addresses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::NetworkInterface.PrivateIpAddresses``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
        """
        return jsii.get(self, "privateIpAddresses")

    @private_ip_addresses.setter # type: ignore
    def private_ip_addresses(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "privateIpAddresses", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="secondaryPrivateIpAddressCount")
    def secondary_private_ip_address_count(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
        """
        return jsii.get(self, "secondaryPrivateIpAddressCount")

    @secondary_private_ip_address_count.setter # type: ignore
    def secondary_private_ip_address_count(
        self,
        value: typing.Optional[jsii.Number],
    ) -> None:
        jsii.set(self, "secondaryPrivateIpAddressCount", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceDestCheck")
    def source_dest_check(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkInterface.SourceDestCheck``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
        """
        return jsii.get(self, "sourceDestCheck")

    @source_dest_check.setter # type: ignore
    def source_dest_check(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "sourceDestCheck", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterface.InstanceIpv6AddressProperty",
        jsii_struct_bases=[],
        name_mapping={"ipv6_address": "ipv6Address"},
    )
    class InstanceIpv6AddressProperty:
        def __init__(self, *, ipv6_address: builtins.str) -> None:
            """
            :param ipv6_address: ``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "ipv6_address": ipv6_address,
            }

        @builtins.property
        def ipv6_address(self) -> builtins.str:
            """``CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
            """
            result = self._values.get("ipv6_address")
            assert result is not None, "Required property 'ipv6_address' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InstanceIpv6AddressProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterface.PrivateIpAddressSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"primary": "primary", "private_ip_address": "privateIpAddress"},
    )
    class PrivateIpAddressSpecificationProperty:
        def __init__(
            self,
            *,
            primary: typing.Union[builtins.bool, _IResolvable_9ceae33e],
            private_ip_address: builtins.str,
        ) -> None:
            """
            :param primary: ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``.
            :param private_ip_address: ``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "primary": primary,
                "private_ip_address": private_ip_address,
            }

        @builtins.property
        def primary(self) -> typing.Union[builtins.bool, _IResolvable_9ceae33e]:
            """``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
            """
            result = self._values.get("primary")
            assert result is not None, "Required property 'primary' is missing"
            return result

        @builtins.property
        def private_ip_address(self) -> builtins.str:
            """``CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
            """
            result = self._values.get("private_ip_address")
            assert result is not None, "Required property 'private_ip_address' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PrivateIpAddressSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_051e6ed8)
class CfnNetworkInterfaceAttachment(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterfaceAttachment",
):
    """A CloudFormation ``AWS::EC2::NetworkInterfaceAttachment``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::NetworkInterfaceAttachment
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        device_index: builtins.str,
        instance_id: builtins.str,
        network_interface_id: builtins.str,
        delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::NetworkInterfaceAttachment``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param device_index: ``AWS::EC2::NetworkInterfaceAttachment.DeviceIndex``.
        :param instance_id: ``AWS::EC2::NetworkInterfaceAttachment.InstanceId``.
        :param network_interface_id: ``AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId``.
        :param delete_on_termination: ``AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination``.
        """
        props = CfnNetworkInterfaceAttachmentProps(
            device_index=device_index,
            instance_id=instance_id,
            network_interface_id=network_interface_id,
            delete_on_termination=delete_on_termination,
        )

        jsii.create(CfnNetworkInterfaceAttachment, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deviceIndex")
    def device_index(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfaceAttachment.DeviceIndex``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
        """
        return jsii.get(self, "deviceIndex")

    @device_index.setter # type: ignore
    def device_index(self, value: builtins.str) -> None:
        jsii.set(self, "deviceIndex", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceId")
    def instance_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfaceAttachment.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
        """
        return jsii.get(self, "instanceId")

    @instance_id.setter # type: ignore
    def instance_id(self, value: builtins.str) -> None:
        jsii.set(self, "instanceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaceId")
    def network_interface_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
        """
        return jsii.get(self, "networkInterfaceId")

    @network_interface_id.setter # type: ignore
    def network_interface_id(self, value: builtins.str) -> None:
        jsii.set(self, "networkInterfaceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="deleteOnTermination")
    def delete_on_termination(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
        """
        return jsii.get(self, "deleteOnTermination")

    @delete_on_termination.setter # type: ignore
    def delete_on_termination(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "deleteOnTermination", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterfaceAttachmentProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_index": "deviceIndex",
        "instance_id": "instanceId",
        "network_interface_id": "networkInterfaceId",
        "delete_on_termination": "deleteOnTermination",
    },
)
class CfnNetworkInterfaceAttachmentProps:
    def __init__(
        self,
        *,
        device_index: builtins.str,
        instance_id: builtins.str,
        network_interface_id: builtins.str,
        delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::NetworkInterfaceAttachment``.

        :param device_index: ``AWS::EC2::NetworkInterfaceAttachment.DeviceIndex``.
        :param instance_id: ``AWS::EC2::NetworkInterfaceAttachment.InstanceId``.
        :param network_interface_id: ``AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId``.
        :param delete_on_termination: ``AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "device_index": device_index,
            "instance_id": instance_id,
            "network_interface_id": network_interface_id,
        }
        if delete_on_termination is not None:
            self._values["delete_on_termination"] = delete_on_termination

    @builtins.property
    def device_index(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfaceAttachment.DeviceIndex``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
        """
        result = self._values.get("device_index")
        assert result is not None, "Required property 'device_index' is missing"
        return result

    @builtins.property
    def instance_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfaceAttachment.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
        """
        result = self._values.get("instance_id")
        assert result is not None, "Required property 'instance_id' is missing"
        return result

    @builtins.property
    def network_interface_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
        """
        result = self._values.get("network_interface_id")
        assert result is not None, "Required property 'network_interface_id' is missing"
        return result

    @builtins.property
    def delete_on_termination(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
        """
        result = self._values.get("delete_on_termination")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnNetworkInterfaceAttachmentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnNetworkInterfacePermission(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterfacePermission",
):
    """A CloudFormation ``AWS::EC2::NetworkInterfacePermission``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::NetworkInterfacePermission
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        aws_account_id: builtins.str,
        network_interface_id: builtins.str,
        permission: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::NetworkInterfacePermission``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param aws_account_id: ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``.
        :param network_interface_id: ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``.
        :param permission: ``AWS::EC2::NetworkInterfacePermission.Permission``.
        """
        props = CfnNetworkInterfacePermissionProps(
            aws_account_id=aws_account_id,
            network_interface_id=network_interface_id,
            permission=permission,
        )

        jsii.create(CfnNetworkInterfacePermission, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="awsAccountId")
    def aws_account_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfacePermission.AwsAccountId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
        """
        return jsii.get(self, "awsAccountId")

    @aws_account_id.setter # type: ignore
    def aws_account_id(self, value: builtins.str) -> None:
        jsii.set(self, "awsAccountId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaceId")
    def network_interface_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
        """
        return jsii.get(self, "networkInterfaceId")

    @network_interface_id.setter # type: ignore
    def network_interface_id(self, value: builtins.str) -> None:
        jsii.set(self, "networkInterfaceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="permission")
    def permission(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfacePermission.Permission``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
        """
        return jsii.get(self, "permission")

    @permission.setter # type: ignore
    def permission(self, value: builtins.str) -> None:
        jsii.set(self, "permission", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterfacePermissionProps",
    jsii_struct_bases=[],
    name_mapping={
        "aws_account_id": "awsAccountId",
        "network_interface_id": "networkInterfaceId",
        "permission": "permission",
    },
)
class CfnNetworkInterfacePermissionProps:
    def __init__(
        self,
        *,
        aws_account_id: builtins.str,
        network_interface_id: builtins.str,
        permission: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::NetworkInterfacePermission``.

        :param aws_account_id: ``AWS::EC2::NetworkInterfacePermission.AwsAccountId``.
        :param network_interface_id: ``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``.
        :param permission: ``AWS::EC2::NetworkInterfacePermission.Permission``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "aws_account_id": aws_account_id,
            "network_interface_id": network_interface_id,
            "permission": permission,
        }

    @builtins.property
    def aws_account_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfacePermission.AwsAccountId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
        """
        result = self._values.get("aws_account_id")
        assert result is not None, "Required property 'aws_account_id' is missing"
        return result

    @builtins.property
    def network_interface_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
        """
        result = self._values.get("network_interface_id")
        assert result is not None, "Required property 'network_interface_id' is missing"
        return result

    @builtins.property
    def permission(self) -> builtins.str:
        """``AWS::EC2::NetworkInterfacePermission.Permission``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
        """
        result = self._values.get("permission")
        assert result is not None, "Required property 'permission' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnNetworkInterfacePermissionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnNetworkInterfaceProps",
    jsii_struct_bases=[],
    name_mapping={
        "subnet_id": "subnetId",
        "description": "description",
        "group_set": "groupSet",
        "interface_type": "interfaceType",
        "ipv6_address_count": "ipv6AddressCount",
        "ipv6_addresses": "ipv6Addresses",
        "private_ip_address": "privateIpAddress",
        "private_ip_addresses": "privateIpAddresses",
        "secondary_private_ip_address_count": "secondaryPrivateIpAddressCount",
        "source_dest_check": "sourceDestCheck",
        "tags": "tags",
    },
)
class CfnNetworkInterfaceProps:
    def __init__(
        self,
        *,
        subnet_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        group_set: typing.Optional[typing.List[builtins.str]] = None,
        interface_type: typing.Optional[builtins.str] = None,
        ipv6_address_count: typing.Optional[jsii.Number] = None,
        ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnNetworkInterface.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]] = None,
        private_ip_address: typing.Optional[builtins.str] = None,
        private_ip_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnNetworkInterface.PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
        secondary_private_ip_address_count: typing.Optional[jsii.Number] = None,
        source_dest_check: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::NetworkInterface``.

        :param subnet_id: ``AWS::EC2::NetworkInterface.SubnetId``.
        :param description: ``AWS::EC2::NetworkInterface.Description``.
        :param group_set: ``AWS::EC2::NetworkInterface.GroupSet``.
        :param interface_type: ``AWS::EC2::NetworkInterface.InterfaceType``.
        :param ipv6_address_count: ``AWS::EC2::NetworkInterface.Ipv6AddressCount``.
        :param ipv6_addresses: ``AWS::EC2::NetworkInterface.Ipv6Addresses``.
        :param private_ip_address: ``AWS::EC2::NetworkInterface.PrivateIpAddress``.
        :param private_ip_addresses: ``AWS::EC2::NetworkInterface.PrivateIpAddresses``.
        :param secondary_private_ip_address_count: ``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``.
        :param source_dest_check: ``AWS::EC2::NetworkInterface.SourceDestCheck``.
        :param tags: ``AWS::EC2::NetworkInterface.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "subnet_id": subnet_id,
        }
        if description is not None:
            self._values["description"] = description
        if group_set is not None:
            self._values["group_set"] = group_set
        if interface_type is not None:
            self._values["interface_type"] = interface_type
        if ipv6_address_count is not None:
            self._values["ipv6_address_count"] = ipv6_address_count
        if ipv6_addresses is not None:
            self._values["ipv6_addresses"] = ipv6_addresses
        if private_ip_address is not None:
            self._values["private_ip_address"] = private_ip_address
        if private_ip_addresses is not None:
            self._values["private_ip_addresses"] = private_ip_addresses
        if secondary_private_ip_address_count is not None:
            self._values["secondary_private_ip_address_count"] = secondary_private_ip_address_count
        if source_dest_check is not None:
            self._values["source_dest_check"] = source_dest_check
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::NetworkInterface.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkInterface.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def group_set(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::NetworkInterface.GroupSet``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
        """
        result = self._values.get("group_set")
        return result

    @builtins.property
    def interface_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkInterface.InterfaceType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
        """
        result = self._values.get("interface_type")
        return result

    @builtins.property
    def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::NetworkInterface.Ipv6AddressCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
        """
        result = self._values.get("ipv6_address_count")
        return result

    @builtins.property
    def ipv6_addresses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnNetworkInterface.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::NetworkInterface.Ipv6Addresses``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
        """
        result = self._values.get("ipv6_addresses")
        return result

    @builtins.property
    def private_ip_address(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::NetworkInterface.PrivateIpAddress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
        """
        result = self._values.get("private_ip_address")
        return result

    @builtins.property
    def private_ip_addresses(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnNetworkInterface.PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::NetworkInterface.PrivateIpAddresses``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
        """
        result = self._values.get("private_ip_addresses")
        return result

    @builtins.property
    def secondary_private_ip_address_count(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
        """
        result = self._values.get("secondary_private_ip_address_count")
        return result

    @builtins.property
    def source_dest_check(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::NetworkInterface.SourceDestCheck``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
        """
        result = self._values.get("source_dest_check")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::NetworkInterface.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnNetworkInterfaceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnPlacementGroup(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnPlacementGroup",
):
    """A CloudFormation ``AWS::EC2::PlacementGroup``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::PlacementGroup
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        strategy: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::PlacementGroup``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param strategy: ``AWS::EC2::PlacementGroup.Strategy``.
        """
        props = CfnPlacementGroupProps(strategy=strategy)

        jsii.create(CfnPlacementGroup, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::PlacementGroup.Strategy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
        """
        return jsii.get(self, "strategy")

    @strategy.setter # type: ignore
    def strategy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "strategy", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnPlacementGroupProps",
    jsii_struct_bases=[],
    name_mapping={"strategy": "strategy"},
)
class CfnPlacementGroupProps:
    def __init__(self, *, strategy: typing.Optional[builtins.str] = None) -> None:
        """Properties for defining a ``AWS::EC2::PlacementGroup``.

        :param strategy: ``AWS::EC2::PlacementGroup.Strategy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def strategy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::PlacementGroup.Strategy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
        """
        result = self._values.get("strategy")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnPlacementGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnPrefixList(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnPrefixList",
):
    """A CloudFormation ``AWS::EC2::PrefixList``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::PrefixList
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        address_family: builtins.str,
        max_entries: jsii.Number,
        prefix_list_name: builtins.str,
        entries: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["EntryProperty", _IResolvable_9ceae33e]]]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::PrefixList``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param address_family: ``AWS::EC2::PrefixList.AddressFamily``.
        :param max_entries: ``AWS::EC2::PrefixList.MaxEntries``.
        :param prefix_list_name: ``AWS::EC2::PrefixList.PrefixListName``.
        :param entries: ``AWS::EC2::PrefixList.Entries``.
        :param tags: ``AWS::EC2::PrefixList.Tags``.
        """
        props = CfnPrefixListProps(
            address_family=address_family,
            max_entries=max_entries,
            prefix_list_name=prefix_list_name,
            entries=entries,
            tags=tags,
        )

        jsii.create(CfnPrefixList, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Arn
        """
        return jsii.get(self, "attrArn")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrOwnerId")
    def attr_owner_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: OwnerId
        """
        return jsii.get(self, "attrOwnerId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrPrefixListId")
    def attr_prefix_list_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: PrefixListId
        """
        return jsii.get(self, "attrPrefixListId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrVersion")
    def attr_version(self) -> jsii.Number:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Version
        """
        return jsii.get(self, "attrVersion")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::PrefixList.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="addressFamily")
    def address_family(self) -> builtins.str:
        """``AWS::EC2::PrefixList.AddressFamily``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
        """
        return jsii.get(self, "addressFamily")

    @address_family.setter # type: ignore
    def address_family(self, value: builtins.str) -> None:
        jsii.set(self, "addressFamily", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="maxEntries")
    def max_entries(self) -> jsii.Number:
        """``AWS::EC2::PrefixList.MaxEntries``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
        """
        return jsii.get(self, "maxEntries")

    @max_entries.setter # type: ignore
    def max_entries(self, value: jsii.Number) -> None:
        jsii.set(self, "maxEntries", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="prefixListName")
    def prefix_list_name(self) -> builtins.str:
        """``AWS::EC2::PrefixList.PrefixListName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
        """
        return jsii.get(self, "prefixListName")

    @prefix_list_name.setter # type: ignore
    def prefix_list_name(self, value: builtins.str) -> None:
        jsii.set(self, "prefixListName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="entries")
    def entries(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["EntryProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::PrefixList.Entries``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
        """
        return jsii.get(self, "entries")

    @entries.setter # type: ignore
    def entries(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["EntryProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "entries", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnPrefixList.EntryProperty",
        jsii_struct_bases=[],
        name_mapping={"cidr": "cidr", "description": "description"},
    )
    class EntryProperty:
        def __init__(
            self,
            *,
            cidr: builtins.str,
            description: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param cidr: ``CfnPrefixList.EntryProperty.Cidr``.
            :param description: ``CfnPrefixList.EntryProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "cidr": cidr,
            }
            if description is not None:
                self._values["description"] = description

        @builtins.property
        def cidr(self) -> builtins.str:
            """``CfnPrefixList.EntryProperty.Cidr``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-cidr
            """
            result = self._values.get("cidr")
            assert result is not None, "Required property 'cidr' is missing"
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnPrefixList.EntryProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-description
            """
            result = self._values.get("description")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EntryProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnPrefixListProps",
    jsii_struct_bases=[],
    name_mapping={
        "address_family": "addressFamily",
        "max_entries": "maxEntries",
        "prefix_list_name": "prefixListName",
        "entries": "entries",
        "tags": "tags",
    },
)
class CfnPrefixListProps:
    def __init__(
        self,
        *,
        address_family: builtins.str,
        max_entries: jsii.Number,
        prefix_list_name: builtins.str,
        entries: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnPrefixList.EntryProperty", _IResolvable_9ceae33e]]]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::PrefixList``.

        :param address_family: ``AWS::EC2::PrefixList.AddressFamily``.
        :param max_entries: ``AWS::EC2::PrefixList.MaxEntries``.
        :param prefix_list_name: ``AWS::EC2::PrefixList.PrefixListName``.
        :param entries: ``AWS::EC2::PrefixList.Entries``.
        :param tags: ``AWS::EC2::PrefixList.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "address_family": address_family,
            "max_entries": max_entries,
            "prefix_list_name": prefix_list_name,
        }
        if entries is not None:
            self._values["entries"] = entries
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def address_family(self) -> builtins.str:
        """``AWS::EC2::PrefixList.AddressFamily``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
        """
        result = self._values.get("address_family")
        assert result is not None, "Required property 'address_family' is missing"
        return result

    @builtins.property
    def max_entries(self) -> jsii.Number:
        """``AWS::EC2::PrefixList.MaxEntries``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
        """
        result = self._values.get("max_entries")
        assert result is not None, "Required property 'max_entries' is missing"
        return result

    @builtins.property
    def prefix_list_name(self) -> builtins.str:
        """``AWS::EC2::PrefixList.PrefixListName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
        """
        result = self._values.get("prefix_list_name")
        assert result is not None, "Required property 'prefix_list_name' is missing"
        return result

    @builtins.property
    def entries(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnPrefixList.EntryProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::PrefixList.Entries``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
        """
        result = self._values.get("entries")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::PrefixList.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnPrefixListProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnRoute(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnRoute",
):
    """A CloudFormation ``AWS::EC2::Route``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::Route
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        route_table_id: builtins.str,
        destination_cidr_block: typing.Optional[builtins.str] = None,
        destination_ipv6_cidr_block: typing.Optional[builtins.str] = None,
        egress_only_internet_gateway_id: typing.Optional[builtins.str] = None,
        gateway_id: typing.Optional[builtins.str] = None,
        instance_id: typing.Optional[builtins.str] = None,
        nat_gateway_id: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        transit_gateway_id: typing.Optional[builtins.str] = None,
        vpc_peering_connection_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::Route``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param route_table_id: ``AWS::EC2::Route.RouteTableId``.
        :param destination_cidr_block: ``AWS::EC2::Route.DestinationCidrBlock``.
        :param destination_ipv6_cidr_block: ``AWS::EC2::Route.DestinationIpv6CidrBlock``.
        :param egress_only_internet_gateway_id: ``AWS::EC2::Route.EgressOnlyInternetGatewayId``.
        :param gateway_id: ``AWS::EC2::Route.GatewayId``.
        :param instance_id: ``AWS::EC2::Route.InstanceId``.
        :param nat_gateway_id: ``AWS::EC2::Route.NatGatewayId``.
        :param network_interface_id: ``AWS::EC2::Route.NetworkInterfaceId``.
        :param transit_gateway_id: ``AWS::EC2::Route.TransitGatewayId``.
        :param vpc_peering_connection_id: ``AWS::EC2::Route.VpcPeeringConnectionId``.
        """
        props = CfnRouteProps(
            route_table_id=route_table_id,
            destination_cidr_block=destination_cidr_block,
            destination_ipv6_cidr_block=destination_ipv6_cidr_block,
            egress_only_internet_gateway_id=egress_only_internet_gateway_id,
            gateway_id=gateway_id,
            instance_id=instance_id,
            nat_gateway_id=nat_gateway_id,
            network_interface_id=network_interface_id,
            transit_gateway_id=transit_gateway_id,
            vpc_peering_connection_id=vpc_peering_connection_id,
        )

        jsii.create(CfnRoute, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeTableId")
    def route_table_id(self) -> builtins.str:
        """``AWS::EC2::Route.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
        """
        return jsii.get(self, "routeTableId")

    @route_table_id.setter # type: ignore
    def route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "routeTableId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationCidrBlock")
    def destination_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
        """
        return jsii.get(self, "destinationCidrBlock")

    @destination_cidr_block.setter # type: ignore
    def destination_cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "destinationCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationIpv6CidrBlock")
    def destination_ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.DestinationIpv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
        """
        return jsii.get(self, "destinationIpv6CidrBlock")

    @destination_ipv6_cidr_block.setter # type: ignore
    def destination_ipv6_cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "destinationIpv6CidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="egressOnlyInternetGatewayId")
    def egress_only_internet_gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.EgressOnlyInternetGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
        """
        return jsii.get(self, "egressOnlyInternetGatewayId")

    @egress_only_internet_gateway_id.setter # type: ignore
    def egress_only_internet_gateway_id(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "egressOnlyInternetGatewayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="gatewayId")
    def gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.GatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
        """
        return jsii.get(self, "gatewayId")

    @gateway_id.setter # type: ignore
    def gateway_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "gatewayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceId")
    def instance_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
        """
        return jsii.get(self, "instanceId")

    @instance_id.setter # type: ignore
    def instance_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "instanceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="natGatewayId")
    def nat_gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.NatGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
        """
        return jsii.get(self, "natGatewayId")

    @nat_gateway_id.setter # type: ignore
    def nat_gateway_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "natGatewayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaceId")
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
        """
        return jsii.get(self, "networkInterfaceId")

    @network_interface_id.setter # type: ignore
    def network_interface_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "networkInterfaceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayId")
    def transit_gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.TransitGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
        """
        return jsii.get(self, "transitGatewayId")

    @transit_gateway_id.setter # type: ignore
    def transit_gateway_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "transitGatewayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.VpcPeeringConnectionId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
        """
        return jsii.get(self, "vpcPeeringConnectionId")

    @vpc_peering_connection_id.setter # type: ignore
    def vpc_peering_connection_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "vpcPeeringConnectionId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnRouteProps",
    jsii_struct_bases=[],
    name_mapping={
        "route_table_id": "routeTableId",
        "destination_cidr_block": "destinationCidrBlock",
        "destination_ipv6_cidr_block": "destinationIpv6CidrBlock",
        "egress_only_internet_gateway_id": "egressOnlyInternetGatewayId",
        "gateway_id": "gatewayId",
        "instance_id": "instanceId",
        "nat_gateway_id": "natGatewayId",
        "network_interface_id": "networkInterfaceId",
        "transit_gateway_id": "transitGatewayId",
        "vpc_peering_connection_id": "vpcPeeringConnectionId",
    },
)
class CfnRouteProps:
    def __init__(
        self,
        *,
        route_table_id: builtins.str,
        destination_cidr_block: typing.Optional[builtins.str] = None,
        destination_ipv6_cidr_block: typing.Optional[builtins.str] = None,
        egress_only_internet_gateway_id: typing.Optional[builtins.str] = None,
        gateway_id: typing.Optional[builtins.str] = None,
        instance_id: typing.Optional[builtins.str] = None,
        nat_gateway_id: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        transit_gateway_id: typing.Optional[builtins.str] = None,
        vpc_peering_connection_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::Route``.

        :param route_table_id: ``AWS::EC2::Route.RouteTableId``.
        :param destination_cidr_block: ``AWS::EC2::Route.DestinationCidrBlock``.
        :param destination_ipv6_cidr_block: ``AWS::EC2::Route.DestinationIpv6CidrBlock``.
        :param egress_only_internet_gateway_id: ``AWS::EC2::Route.EgressOnlyInternetGatewayId``.
        :param gateway_id: ``AWS::EC2::Route.GatewayId``.
        :param instance_id: ``AWS::EC2::Route.InstanceId``.
        :param nat_gateway_id: ``AWS::EC2::Route.NatGatewayId``.
        :param network_interface_id: ``AWS::EC2::Route.NetworkInterfaceId``.
        :param transit_gateway_id: ``AWS::EC2::Route.TransitGatewayId``.
        :param vpc_peering_connection_id: ``AWS::EC2::Route.VpcPeeringConnectionId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "route_table_id": route_table_id,
        }
        if destination_cidr_block is not None:
            self._values["destination_cidr_block"] = destination_cidr_block
        if destination_ipv6_cidr_block is not None:
            self._values["destination_ipv6_cidr_block"] = destination_ipv6_cidr_block
        if egress_only_internet_gateway_id is not None:
            self._values["egress_only_internet_gateway_id"] = egress_only_internet_gateway_id
        if gateway_id is not None:
            self._values["gateway_id"] = gateway_id
        if instance_id is not None:
            self._values["instance_id"] = instance_id
        if nat_gateway_id is not None:
            self._values["nat_gateway_id"] = nat_gateway_id
        if network_interface_id is not None:
            self._values["network_interface_id"] = network_interface_id
        if transit_gateway_id is not None:
            self._values["transit_gateway_id"] = transit_gateway_id
        if vpc_peering_connection_id is not None:
            self._values["vpc_peering_connection_id"] = vpc_peering_connection_id

    @builtins.property
    def route_table_id(self) -> builtins.str:
        """``AWS::EC2::Route.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
        """
        result = self._values.get("route_table_id")
        assert result is not None, "Required property 'route_table_id' is missing"
        return result

    @builtins.property
    def destination_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
        """
        result = self._values.get("destination_cidr_block")
        return result

    @builtins.property
    def destination_ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.DestinationIpv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
        """
        result = self._values.get("destination_ipv6_cidr_block")
        return result

    @builtins.property
    def egress_only_internet_gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.EgressOnlyInternetGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
        """
        result = self._values.get("egress_only_internet_gateway_id")
        return result

    @builtins.property
    def gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.GatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
        """
        result = self._values.get("gateway_id")
        return result

    @builtins.property
    def instance_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.InstanceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
        """
        result = self._values.get("instance_id")
        return result

    @builtins.property
    def nat_gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.NatGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
        """
        result = self._values.get("nat_gateway_id")
        return result

    @builtins.property
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
        """
        result = self._values.get("network_interface_id")
        return result

    @builtins.property
    def transit_gateway_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.TransitGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
        """
        result = self._values.get("transit_gateway_id")
        return result

    @builtins.property
    def vpc_peering_connection_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Route.VpcPeeringConnectionId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
        """
        result = self._values.get("vpc_peering_connection_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRouteProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnRouteTable(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnRouteTable",
):
    """A CloudFormation ``AWS::EC2::RouteTable``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::RouteTable
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        vpc_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::RouteTable``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param vpc_id: ``AWS::EC2::RouteTable.VpcId``.
        :param tags: ``AWS::EC2::RouteTable.Tags``.
        """
        props = CfnRouteTableProps(vpc_id=vpc_id, tags=tags)

        jsii.create(CfnRouteTable, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::RouteTable.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::RouteTable.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnRouteTableProps",
    jsii_struct_bases=[],
    name_mapping={"vpc_id": "vpcId", "tags": "tags"},
)
class CfnRouteTableProps:
    def __init__(
        self,
        *,
        vpc_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::RouteTable``.

        :param vpc_id: ``AWS::EC2::RouteTable.VpcId``.
        :param tags: ``AWS::EC2::RouteTable.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "vpc_id": vpc_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::RouteTable.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::RouteTable.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRouteTableProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSecurityGroup(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroup",
):
    """A CloudFormation ``AWS::EC2::SecurityGroup``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SecurityGroup
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        group_description: builtins.str,
        group_name: typing.Optional[builtins.str] = None,
        security_group_egress: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["EgressProperty", _IResolvable_9ceae33e]]]] = None,
        security_group_ingress: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["IngressProperty", _IResolvable_9ceae33e]]]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        vpc_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::SecurityGroup``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param group_description: ``AWS::EC2::SecurityGroup.GroupDescription``.
        :param group_name: ``AWS::EC2::SecurityGroup.GroupName``.
        :param security_group_egress: ``AWS::EC2::SecurityGroup.SecurityGroupEgress``.
        :param security_group_ingress: ``AWS::EC2::SecurityGroup.SecurityGroupIngress``.
        :param tags: ``AWS::EC2::SecurityGroup.Tags``.
        :param vpc_id: ``AWS::EC2::SecurityGroup.VpcId``.
        """
        props = CfnSecurityGroupProps(
            group_description=group_description,
            group_name=group_name,
            security_group_egress=security_group_egress,
            security_group_ingress=security_group_ingress,
            tags=tags,
            vpc_id=vpc_id,
        )

        jsii.create(CfnSecurityGroup, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrGroupId")
    def attr_group_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: GroupId
        """
        return jsii.get(self, "attrGroupId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrVpcId")
    def attr_vpc_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: VpcId
        """
        return jsii.get(self, "attrVpcId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::SecurityGroup.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupDescription")
    def group_description(self) -> builtins.str:
        """``AWS::EC2::SecurityGroup.GroupDescription``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
        """
        return jsii.get(self, "groupDescription")

    @group_description.setter # type: ignore
    def group_description(self, value: builtins.str) -> None:
        jsii.set(self, "groupDescription", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupName")
    def group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroup.GroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
        """
        return jsii.get(self, "groupName")

    @group_name.setter # type: ignore
    def group_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "groupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroupEgress")
    def security_group_egress(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["EgressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::SecurityGroup.SecurityGroupEgress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
        """
        return jsii.get(self, "securityGroupEgress")

    @security_group_egress.setter # type: ignore
    def security_group_egress(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["EgressProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "securityGroupEgress", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroupIngress")
    def security_group_ingress(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["IngressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::SecurityGroup.SecurityGroupIngress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
        """
        return jsii.get(self, "securityGroupIngress")

    @security_group_ingress.setter # type: ignore
    def security_group_ingress(
        self,
        value: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["IngressProperty", _IResolvable_9ceae33e]]]],
    ) -> None:
        jsii.set(self, "securityGroupIngress", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroup.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "vpcId", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroup.EgressProperty",
        jsii_struct_bases=[],
        name_mapping={
            "ip_protocol": "ipProtocol",
            "cidr_ip": "cidrIp",
            "cidr_ipv6": "cidrIpv6",
            "description": "description",
            "destination_prefix_list_id": "destinationPrefixListId",
            "destination_security_group_id": "destinationSecurityGroupId",
            "from_port": "fromPort",
            "to_port": "toPort",
        },
    )
    class EgressProperty:
        def __init__(
            self,
            *,
            ip_protocol: builtins.str,
            cidr_ip: typing.Optional[builtins.str] = None,
            cidr_ipv6: typing.Optional[builtins.str] = None,
            description: typing.Optional[builtins.str] = None,
            destination_prefix_list_id: typing.Optional[builtins.str] = None,
            destination_security_group_id: typing.Optional[builtins.str] = None,
            from_port: typing.Optional[jsii.Number] = None,
            to_port: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param ip_protocol: ``CfnSecurityGroup.EgressProperty.IpProtocol``.
            :param cidr_ip: ``CfnSecurityGroup.EgressProperty.CidrIp``.
            :param cidr_ipv6: ``CfnSecurityGroup.EgressProperty.CidrIpv6``.
            :param description: ``CfnSecurityGroup.EgressProperty.Description``.
            :param destination_prefix_list_id: ``CfnSecurityGroup.EgressProperty.DestinationPrefixListId``.
            :param destination_security_group_id: ``CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId``.
            :param from_port: ``CfnSecurityGroup.EgressProperty.FromPort``.
            :param to_port: ``CfnSecurityGroup.EgressProperty.ToPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "ip_protocol": ip_protocol,
            }
            if cidr_ip is not None:
                self._values["cidr_ip"] = cidr_ip
            if cidr_ipv6 is not None:
                self._values["cidr_ipv6"] = cidr_ipv6
            if description is not None:
                self._values["description"] = description
            if destination_prefix_list_id is not None:
                self._values["destination_prefix_list_id"] = destination_prefix_list_id
            if destination_security_group_id is not None:
                self._values["destination_security_group_id"] = destination_security_group_id
            if from_port is not None:
                self._values["from_port"] = from_port
            if to_port is not None:
                self._values["to_port"] = to_port

        @builtins.property
        def ip_protocol(self) -> builtins.str:
            """``CfnSecurityGroup.EgressProperty.IpProtocol``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
            """
            result = self._values.get("ip_protocol")
            assert result is not None, "Required property 'ip_protocol' is missing"
            return result

        @builtins.property
        def cidr_ip(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.EgressProperty.CidrIp``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
            """
            result = self._values.get("cidr_ip")
            return result

        @builtins.property
        def cidr_ipv6(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.EgressProperty.CidrIpv6``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
            """
            result = self._values.get("cidr_ipv6")
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.EgressProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
            """
            result = self._values.get("description")
            return result

        @builtins.property
        def destination_prefix_list_id(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.EgressProperty.DestinationPrefixListId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
            """
            result = self._values.get("destination_prefix_list_id")
            return result

        @builtins.property
        def destination_security_group_id(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
            """
            result = self._values.get("destination_security_group_id")
            return result

        @builtins.property
        def from_port(self) -> typing.Optional[jsii.Number]:
            """``CfnSecurityGroup.EgressProperty.FromPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
            """
            result = self._values.get("from_port")
            return result

        @builtins.property
        def to_port(self) -> typing.Optional[jsii.Number]:
            """``CfnSecurityGroup.EgressProperty.ToPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
            """
            result = self._values.get("to_port")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EgressProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroup.IngressProperty",
        jsii_struct_bases=[],
        name_mapping={
            "ip_protocol": "ipProtocol",
            "cidr_ip": "cidrIp",
            "cidr_ipv6": "cidrIpv6",
            "description": "description",
            "from_port": "fromPort",
            "source_prefix_list_id": "sourcePrefixListId",
            "source_security_group_id": "sourceSecurityGroupId",
            "source_security_group_name": "sourceSecurityGroupName",
            "source_security_group_owner_id": "sourceSecurityGroupOwnerId",
            "to_port": "toPort",
        },
    )
    class IngressProperty:
        def __init__(
            self,
            *,
            ip_protocol: builtins.str,
            cidr_ip: typing.Optional[builtins.str] = None,
            cidr_ipv6: typing.Optional[builtins.str] = None,
            description: typing.Optional[builtins.str] = None,
            from_port: typing.Optional[jsii.Number] = None,
            source_prefix_list_id: typing.Optional[builtins.str] = None,
            source_security_group_id: typing.Optional[builtins.str] = None,
            source_security_group_name: typing.Optional[builtins.str] = None,
            source_security_group_owner_id: typing.Optional[builtins.str] = None,
            to_port: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param ip_protocol: ``CfnSecurityGroup.IngressProperty.IpProtocol``.
            :param cidr_ip: ``CfnSecurityGroup.IngressProperty.CidrIp``.
            :param cidr_ipv6: ``CfnSecurityGroup.IngressProperty.CidrIpv6``.
            :param description: ``CfnSecurityGroup.IngressProperty.Description``.
            :param from_port: ``CfnSecurityGroup.IngressProperty.FromPort``.
            :param source_prefix_list_id: ``CfnSecurityGroup.IngressProperty.SourcePrefixListId``.
            :param source_security_group_id: ``CfnSecurityGroup.IngressProperty.SourceSecurityGroupId``.
            :param source_security_group_name: ``CfnSecurityGroup.IngressProperty.SourceSecurityGroupName``.
            :param source_security_group_owner_id: ``CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId``.
            :param to_port: ``CfnSecurityGroup.IngressProperty.ToPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "ip_protocol": ip_protocol,
            }
            if cidr_ip is not None:
                self._values["cidr_ip"] = cidr_ip
            if cidr_ipv6 is not None:
                self._values["cidr_ipv6"] = cidr_ipv6
            if description is not None:
                self._values["description"] = description
            if from_port is not None:
                self._values["from_port"] = from_port
            if source_prefix_list_id is not None:
                self._values["source_prefix_list_id"] = source_prefix_list_id
            if source_security_group_id is not None:
                self._values["source_security_group_id"] = source_security_group_id
            if source_security_group_name is not None:
                self._values["source_security_group_name"] = source_security_group_name
            if source_security_group_owner_id is not None:
                self._values["source_security_group_owner_id"] = source_security_group_owner_id
            if to_port is not None:
                self._values["to_port"] = to_port

        @builtins.property
        def ip_protocol(self) -> builtins.str:
            """``CfnSecurityGroup.IngressProperty.IpProtocol``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
            """
            result = self._values.get("ip_protocol")
            assert result is not None, "Required property 'ip_protocol' is missing"
            return result

        @builtins.property
        def cidr_ip(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.CidrIp``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
            """
            result = self._values.get("cidr_ip")
            return result

        @builtins.property
        def cidr_ipv6(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.CidrIpv6``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
            """
            result = self._values.get("cidr_ipv6")
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
            """
            result = self._values.get("description")
            return result

        @builtins.property
        def from_port(self) -> typing.Optional[jsii.Number]:
            """``CfnSecurityGroup.IngressProperty.FromPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
            """
            result = self._values.get("from_port")
            return result

        @builtins.property
        def source_prefix_list_id(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.SourcePrefixListId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
            """
            result = self._values.get("source_prefix_list_id")
            return result

        @builtins.property
        def source_security_group_id(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.SourceSecurityGroupId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
            """
            result = self._values.get("source_security_group_id")
            return result

        @builtins.property
        def source_security_group_name(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.SourceSecurityGroupName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
            """
            result = self._values.get("source_security_group_name")
            return result

        @builtins.property
        def source_security_group_owner_id(self) -> typing.Optional[builtins.str]:
            """``CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
            """
            result = self._values.get("source_security_group_owner_id")
            return result

        @builtins.property
        def to_port(self) -> typing.Optional[jsii.Number]:
            """``CfnSecurityGroup.IngressProperty.ToPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
            """
            result = self._values.get("to_port")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IngressProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSecurityGroupEgress(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroupEgress",
):
    """A CloudFormation ``AWS::EC2::SecurityGroupEgress``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SecurityGroupEgress
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        group_id: builtins.str,
        ip_protocol: builtins.str,
        cidr_ip: typing.Optional[builtins.str] = None,
        cidr_ipv6: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        destination_prefix_list_id: typing.Optional[builtins.str] = None,
        destination_security_group_id: typing.Optional[builtins.str] = None,
        from_port: typing.Optional[jsii.Number] = None,
        to_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Create a new ``AWS::EC2::SecurityGroupEgress``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param group_id: ``AWS::EC2::SecurityGroupEgress.GroupId``.
        :param ip_protocol: ``AWS::EC2::SecurityGroupEgress.IpProtocol``.
        :param cidr_ip: ``AWS::EC2::SecurityGroupEgress.CidrIp``.
        :param cidr_ipv6: ``AWS::EC2::SecurityGroupEgress.CidrIpv6``.
        :param description: ``AWS::EC2::SecurityGroupEgress.Description``.
        :param destination_prefix_list_id: ``AWS::EC2::SecurityGroupEgress.DestinationPrefixListId``.
        :param destination_security_group_id: ``AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId``.
        :param from_port: ``AWS::EC2::SecurityGroupEgress.FromPort``.
        :param to_port: ``AWS::EC2::SecurityGroupEgress.ToPort``.
        """
        props = CfnSecurityGroupEgressProps(
            group_id=group_id,
            ip_protocol=ip_protocol,
            cidr_ip=cidr_ip,
            cidr_ipv6=cidr_ipv6,
            description=description,
            destination_prefix_list_id=destination_prefix_list_id,
            destination_security_group_id=destination_security_group_id,
            from_port=from_port,
            to_port=to_port,
        )

        jsii.create(CfnSecurityGroupEgress, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupId")
    def group_id(self) -> builtins.str:
        """``AWS::EC2::SecurityGroupEgress.GroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
        """
        return jsii.get(self, "groupId")

    @group_id.setter # type: ignore
    def group_id(self, value: builtins.str) -> None:
        jsii.set(self, "groupId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """``AWS::EC2::SecurityGroupEgress.IpProtocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
        """
        return jsii.get(self, "ipProtocol")

    @ip_protocol.setter # type: ignore
    def ip_protocol(self, value: builtins.str) -> None:
        jsii.set(self, "ipProtocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrIp")
    def cidr_ip(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.CidrIp``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
        """
        return jsii.get(self, "cidrIp")

    @cidr_ip.setter # type: ignore
    def cidr_ip(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cidrIp", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrIpv6")
    def cidr_ipv6(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.CidrIpv6``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
        """
        return jsii.get(self, "cidrIpv6")

    @cidr_ipv6.setter # type: ignore
    def cidr_ipv6(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cidrIpv6", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationPrefixListId")
    def destination_prefix_list_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.DestinationPrefixListId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
        """
        return jsii.get(self, "destinationPrefixListId")

    @destination_prefix_list_id.setter # type: ignore
    def destination_prefix_list_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "destinationPrefixListId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationSecurityGroupId")
    def destination_security_group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
        """
        return jsii.get(self, "destinationSecurityGroupId")

    @destination_security_group_id.setter # type: ignore
    def destination_security_group_id(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "destinationSecurityGroupId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fromPort")
    def from_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupEgress.FromPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
        """
        return jsii.get(self, "fromPort")

    @from_port.setter # type: ignore
    def from_port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "fromPort", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="toPort")
    def to_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupEgress.ToPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
        """
        return jsii.get(self, "toPort")

    @to_port.setter # type: ignore
    def to_port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "toPort", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroupEgressProps",
    jsii_struct_bases=[],
    name_mapping={
        "group_id": "groupId",
        "ip_protocol": "ipProtocol",
        "cidr_ip": "cidrIp",
        "cidr_ipv6": "cidrIpv6",
        "description": "description",
        "destination_prefix_list_id": "destinationPrefixListId",
        "destination_security_group_id": "destinationSecurityGroupId",
        "from_port": "fromPort",
        "to_port": "toPort",
    },
)
class CfnSecurityGroupEgressProps:
    def __init__(
        self,
        *,
        group_id: builtins.str,
        ip_protocol: builtins.str,
        cidr_ip: typing.Optional[builtins.str] = None,
        cidr_ipv6: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        destination_prefix_list_id: typing.Optional[builtins.str] = None,
        destination_security_group_id: typing.Optional[builtins.str] = None,
        from_port: typing.Optional[jsii.Number] = None,
        to_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::SecurityGroupEgress``.

        :param group_id: ``AWS::EC2::SecurityGroupEgress.GroupId``.
        :param ip_protocol: ``AWS::EC2::SecurityGroupEgress.IpProtocol``.
        :param cidr_ip: ``AWS::EC2::SecurityGroupEgress.CidrIp``.
        :param cidr_ipv6: ``AWS::EC2::SecurityGroupEgress.CidrIpv6``.
        :param description: ``AWS::EC2::SecurityGroupEgress.Description``.
        :param destination_prefix_list_id: ``AWS::EC2::SecurityGroupEgress.DestinationPrefixListId``.
        :param destination_security_group_id: ``AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId``.
        :param from_port: ``AWS::EC2::SecurityGroupEgress.FromPort``.
        :param to_port: ``AWS::EC2::SecurityGroupEgress.ToPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "group_id": group_id,
            "ip_protocol": ip_protocol,
        }
        if cidr_ip is not None:
            self._values["cidr_ip"] = cidr_ip
        if cidr_ipv6 is not None:
            self._values["cidr_ipv6"] = cidr_ipv6
        if description is not None:
            self._values["description"] = description
        if destination_prefix_list_id is not None:
            self._values["destination_prefix_list_id"] = destination_prefix_list_id
        if destination_security_group_id is not None:
            self._values["destination_security_group_id"] = destination_security_group_id
        if from_port is not None:
            self._values["from_port"] = from_port
        if to_port is not None:
            self._values["to_port"] = to_port

    @builtins.property
    def group_id(self) -> builtins.str:
        """``AWS::EC2::SecurityGroupEgress.GroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
        """
        result = self._values.get("group_id")
        assert result is not None, "Required property 'group_id' is missing"
        return result

    @builtins.property
    def ip_protocol(self) -> builtins.str:
        """``AWS::EC2::SecurityGroupEgress.IpProtocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
        """
        result = self._values.get("ip_protocol")
        assert result is not None, "Required property 'ip_protocol' is missing"
        return result

    @builtins.property
    def cidr_ip(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.CidrIp``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
        """
        result = self._values.get("cidr_ip")
        return result

    @builtins.property
    def cidr_ipv6(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.CidrIpv6``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
        """
        result = self._values.get("cidr_ipv6")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def destination_prefix_list_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.DestinationPrefixListId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
        """
        result = self._values.get("destination_prefix_list_id")
        return result

    @builtins.property
    def destination_security_group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
        """
        result = self._values.get("destination_security_group_id")
        return result

    @builtins.property
    def from_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupEgress.FromPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
        """
        result = self._values.get("from_port")
        return result

    @builtins.property
    def to_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupEgress.ToPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
        """
        result = self._values.get("to_port")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSecurityGroupEgressProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSecurityGroupIngress(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroupIngress",
):
    """A CloudFormation ``AWS::EC2::SecurityGroupIngress``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SecurityGroupIngress
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        ip_protocol: builtins.str,
        cidr_ip: typing.Optional[builtins.str] = None,
        cidr_ipv6: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        from_port: typing.Optional[jsii.Number] = None,
        group_id: typing.Optional[builtins.str] = None,
        group_name: typing.Optional[builtins.str] = None,
        source_prefix_list_id: typing.Optional[builtins.str] = None,
        source_security_group_id: typing.Optional[builtins.str] = None,
        source_security_group_name: typing.Optional[builtins.str] = None,
        source_security_group_owner_id: typing.Optional[builtins.str] = None,
        to_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Create a new ``AWS::EC2::SecurityGroupIngress``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param ip_protocol: ``AWS::EC2::SecurityGroupIngress.IpProtocol``.
        :param cidr_ip: ``AWS::EC2::SecurityGroupIngress.CidrIp``.
        :param cidr_ipv6: ``AWS::EC2::SecurityGroupIngress.CidrIpv6``.
        :param description: ``AWS::EC2::SecurityGroupIngress.Description``.
        :param from_port: ``AWS::EC2::SecurityGroupIngress.FromPort``.
        :param group_id: ``AWS::EC2::SecurityGroupIngress.GroupId``.
        :param group_name: ``AWS::EC2::SecurityGroupIngress.GroupName``.
        :param source_prefix_list_id: ``AWS::EC2::SecurityGroupIngress.SourcePrefixListId``.
        :param source_security_group_id: ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``.
        :param source_security_group_name: ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``.
        :param source_security_group_owner_id: ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``.
        :param to_port: ``AWS::EC2::SecurityGroupIngress.ToPort``.
        """
        props = CfnSecurityGroupIngressProps(
            ip_protocol=ip_protocol,
            cidr_ip=cidr_ip,
            cidr_ipv6=cidr_ipv6,
            description=description,
            from_port=from_port,
            group_id=group_id,
            group_name=group_name,
            source_prefix_list_id=source_prefix_list_id,
            source_security_group_id=source_security_group_id,
            source_security_group_name=source_security_group_name,
            source_security_group_owner_id=source_security_group_owner_id,
            to_port=to_port,
        )

        jsii.create(CfnSecurityGroupIngress, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipProtocol")
    def ip_protocol(self) -> builtins.str:
        """``AWS::EC2::SecurityGroupIngress.IpProtocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
        """
        return jsii.get(self, "ipProtocol")

    @ip_protocol.setter # type: ignore
    def ip_protocol(self, value: builtins.str) -> None:
        jsii.set(self, "ipProtocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrIp")
    def cidr_ip(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.CidrIp``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
        """
        return jsii.get(self, "cidrIp")

    @cidr_ip.setter # type: ignore
    def cidr_ip(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cidrIp", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrIpv6")
    def cidr_ipv6(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.CidrIpv6``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
        """
        return jsii.get(self, "cidrIpv6")

    @cidr_ipv6.setter # type: ignore
    def cidr_ipv6(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cidrIpv6", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fromPort")
    def from_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupIngress.FromPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
        """
        return jsii.get(self, "fromPort")

    @from_port.setter # type: ignore
    def from_port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "fromPort", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupId")
    def group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.GroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
        """
        return jsii.get(self, "groupId")

    @group_id.setter # type: ignore
    def group_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "groupId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="groupName")
    def group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.GroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
        """
        return jsii.get(self, "groupName")

    @group_name.setter # type: ignore
    def group_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "groupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourcePrefixListId")
    def source_prefix_list_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourcePrefixListId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
        """
        return jsii.get(self, "sourcePrefixListId")

    @source_prefix_list_id.setter # type: ignore
    def source_prefix_list_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "sourcePrefixListId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceSecurityGroupId")
    def source_security_group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
        """
        return jsii.get(self, "sourceSecurityGroupId")

    @source_security_group_id.setter # type: ignore
    def source_security_group_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "sourceSecurityGroupId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceSecurityGroupName")
    def source_security_group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
        """
        return jsii.get(self, "sourceSecurityGroupName")

    @source_security_group_name.setter # type: ignore
    def source_security_group_name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "sourceSecurityGroupName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceSecurityGroupOwnerId")
    def source_security_group_owner_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
        """
        return jsii.get(self, "sourceSecurityGroupOwnerId")

    @source_security_group_owner_id.setter # type: ignore
    def source_security_group_owner_id(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "sourceSecurityGroupOwnerId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="toPort")
    def to_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupIngress.ToPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
        """
        return jsii.get(self, "toPort")

    @to_port.setter # type: ignore
    def to_port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "toPort", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroupIngressProps",
    jsii_struct_bases=[],
    name_mapping={
        "ip_protocol": "ipProtocol",
        "cidr_ip": "cidrIp",
        "cidr_ipv6": "cidrIpv6",
        "description": "description",
        "from_port": "fromPort",
        "group_id": "groupId",
        "group_name": "groupName",
        "source_prefix_list_id": "sourcePrefixListId",
        "source_security_group_id": "sourceSecurityGroupId",
        "source_security_group_name": "sourceSecurityGroupName",
        "source_security_group_owner_id": "sourceSecurityGroupOwnerId",
        "to_port": "toPort",
    },
)
class CfnSecurityGroupIngressProps:
    def __init__(
        self,
        *,
        ip_protocol: builtins.str,
        cidr_ip: typing.Optional[builtins.str] = None,
        cidr_ipv6: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        from_port: typing.Optional[jsii.Number] = None,
        group_id: typing.Optional[builtins.str] = None,
        group_name: typing.Optional[builtins.str] = None,
        source_prefix_list_id: typing.Optional[builtins.str] = None,
        source_security_group_id: typing.Optional[builtins.str] = None,
        source_security_group_name: typing.Optional[builtins.str] = None,
        source_security_group_owner_id: typing.Optional[builtins.str] = None,
        to_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::SecurityGroupIngress``.

        :param ip_protocol: ``AWS::EC2::SecurityGroupIngress.IpProtocol``.
        :param cidr_ip: ``AWS::EC2::SecurityGroupIngress.CidrIp``.
        :param cidr_ipv6: ``AWS::EC2::SecurityGroupIngress.CidrIpv6``.
        :param description: ``AWS::EC2::SecurityGroupIngress.Description``.
        :param from_port: ``AWS::EC2::SecurityGroupIngress.FromPort``.
        :param group_id: ``AWS::EC2::SecurityGroupIngress.GroupId``.
        :param group_name: ``AWS::EC2::SecurityGroupIngress.GroupName``.
        :param source_prefix_list_id: ``AWS::EC2::SecurityGroupIngress.SourcePrefixListId``.
        :param source_security_group_id: ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``.
        :param source_security_group_name: ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``.
        :param source_security_group_owner_id: ``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``.
        :param to_port: ``AWS::EC2::SecurityGroupIngress.ToPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "ip_protocol": ip_protocol,
        }
        if cidr_ip is not None:
            self._values["cidr_ip"] = cidr_ip
        if cidr_ipv6 is not None:
            self._values["cidr_ipv6"] = cidr_ipv6
        if description is not None:
            self._values["description"] = description
        if from_port is not None:
            self._values["from_port"] = from_port
        if group_id is not None:
            self._values["group_id"] = group_id
        if group_name is not None:
            self._values["group_name"] = group_name
        if source_prefix_list_id is not None:
            self._values["source_prefix_list_id"] = source_prefix_list_id
        if source_security_group_id is not None:
            self._values["source_security_group_id"] = source_security_group_id
        if source_security_group_name is not None:
            self._values["source_security_group_name"] = source_security_group_name
        if source_security_group_owner_id is not None:
            self._values["source_security_group_owner_id"] = source_security_group_owner_id
        if to_port is not None:
            self._values["to_port"] = to_port

    @builtins.property
    def ip_protocol(self) -> builtins.str:
        """``AWS::EC2::SecurityGroupIngress.IpProtocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
        """
        result = self._values.get("ip_protocol")
        assert result is not None, "Required property 'ip_protocol' is missing"
        return result

    @builtins.property
    def cidr_ip(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.CidrIp``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
        """
        result = self._values.get("cidr_ip")
        return result

    @builtins.property
    def cidr_ipv6(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.CidrIpv6``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
        """
        result = self._values.get("cidr_ipv6")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def from_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupIngress.FromPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
        """
        result = self._values.get("from_port")
        return result

    @builtins.property
    def group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.GroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
        """
        result = self._values.get("group_id")
        return result

    @builtins.property
    def group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.GroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
        """
        result = self._values.get("group_name")
        return result

    @builtins.property
    def source_prefix_list_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourcePrefixListId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
        """
        result = self._values.get("source_prefix_list_id")
        return result

    @builtins.property
    def source_security_group_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
        """
        result = self._values.get("source_security_group_id")
        return result

    @builtins.property
    def source_security_group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
        """
        result = self._values.get("source_security_group_name")
        return result

    @builtins.property
    def source_security_group_owner_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
        """
        result = self._values.get("source_security_group_owner_id")
        return result

    @builtins.property
    def to_port(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::SecurityGroupIngress.ToPort``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
        """
        result = self._values.get("to_port")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSecurityGroupIngressProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSecurityGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "group_description": "groupDescription",
        "group_name": "groupName",
        "security_group_egress": "securityGroupEgress",
        "security_group_ingress": "securityGroupIngress",
        "tags": "tags",
        "vpc_id": "vpcId",
    },
)
class CfnSecurityGroupProps:
    def __init__(
        self,
        *,
        group_description: builtins.str,
        group_name: typing.Optional[builtins.str] = None,
        security_group_egress: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSecurityGroup.EgressProperty", _IResolvable_9ceae33e]]]] = None,
        security_group_ingress: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSecurityGroup.IngressProperty", _IResolvable_9ceae33e]]]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        vpc_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::SecurityGroup``.

        :param group_description: ``AWS::EC2::SecurityGroup.GroupDescription``.
        :param group_name: ``AWS::EC2::SecurityGroup.GroupName``.
        :param security_group_egress: ``AWS::EC2::SecurityGroup.SecurityGroupEgress``.
        :param security_group_ingress: ``AWS::EC2::SecurityGroup.SecurityGroupIngress``.
        :param tags: ``AWS::EC2::SecurityGroup.Tags``.
        :param vpc_id: ``AWS::EC2::SecurityGroup.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "group_description": group_description,
        }
        if group_name is not None:
            self._values["group_name"] = group_name
        if security_group_egress is not None:
            self._values["security_group_egress"] = security_group_egress
        if security_group_ingress is not None:
            self._values["security_group_ingress"] = security_group_ingress
        if tags is not None:
            self._values["tags"] = tags
        if vpc_id is not None:
            self._values["vpc_id"] = vpc_id

    @builtins.property
    def group_description(self) -> builtins.str:
        """``AWS::EC2::SecurityGroup.GroupDescription``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
        """
        result = self._values.get("group_description")
        assert result is not None, "Required property 'group_description' is missing"
        return result

    @builtins.property
    def group_name(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroup.GroupName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
        """
        result = self._values.get("group_name")
        return result

    @builtins.property
    def security_group_egress(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSecurityGroup.EgressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::SecurityGroup.SecurityGroupEgress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
        """
        result = self._values.get("security_group_egress")
        return result

    @builtins.property
    def security_group_ingress(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSecurityGroup.IngressProperty", _IResolvable_9ceae33e]]]]:
        """``AWS::EC2::SecurityGroup.SecurityGroupIngress``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
        """
        result = self._values.get("security_group_ingress")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::SecurityGroup.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def vpc_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::SecurityGroup.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
        """
        result = self._values.get("vpc_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSecurityGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSpotFleet(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet",
):
    """A CloudFormation ``AWS::EC2::SpotFleet``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SpotFleet
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        spot_fleet_request_config_data: typing.Union["SpotFleetRequestConfigDataProperty", _IResolvable_9ceae33e],
    ) -> None:
        """Create a new ``AWS::EC2::SpotFleet``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param spot_fleet_request_config_data: ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``.
        """
        props = CfnSpotFleetProps(
            spot_fleet_request_config_data=spot_fleet_request_config_data
        )

        jsii.create(CfnSpotFleet, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="spotFleetRequestConfigData")
    def spot_fleet_request_config_data(
        self,
    ) -> typing.Union["SpotFleetRequestConfigDataProperty", _IResolvable_9ceae33e]:
        """``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
        """
        return jsii.get(self, "spotFleetRequestConfigData")

    @spot_fleet_request_config_data.setter # type: ignore
    def spot_fleet_request_config_data(
        self,
        value: typing.Union["SpotFleetRequestConfigDataProperty", _IResolvable_9ceae33e],
    ) -> None:
        jsii.set(self, "spotFleetRequestConfigData", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.BlockDeviceMappingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_name": "deviceName",
            "ebs": "ebs",
            "no_device": "noDevice",
            "virtual_name": "virtualName",
        },
    )
    class BlockDeviceMappingProperty:
        def __init__(
            self,
            *,
            device_name: builtins.str,
            ebs: typing.Optional[typing.Union["CfnSpotFleet.EbsBlockDeviceProperty", _IResolvable_9ceae33e]] = None,
            no_device: typing.Optional[builtins.str] = None,
            virtual_name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param device_name: ``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``.
            :param ebs: ``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``.
            :param no_device: ``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``.
            :param virtual_name: ``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "device_name": device_name,
            }
            if ebs is not None:
                self._values["ebs"] = ebs
            if no_device is not None:
                self._values["no_device"] = no_device
            if virtual_name is not None:
                self._values["virtual_name"] = virtual_name

        @builtins.property
        def device_name(self) -> builtins.str:
            """``CfnSpotFleet.BlockDeviceMappingProperty.DeviceName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
            """
            result = self._values.get("device_name")
            assert result is not None, "Required property 'device_name' is missing"
            return result

        @builtins.property
        def ebs(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.EbsBlockDeviceProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.BlockDeviceMappingProperty.Ebs``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
            """
            result = self._values.get("ebs")
            return result

        @builtins.property
        def no_device(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.BlockDeviceMappingProperty.NoDevice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
            """
            result = self._values.get("no_device")
            return result

        @builtins.property
        def virtual_name(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.BlockDeviceMappingProperty.VirtualName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
            """
            result = self._values.get("virtual_name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockDeviceMappingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.ClassicLoadBalancerProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class ClassicLoadBalancerProperty:
        def __init__(self, *, name: builtins.str) -> None:
            """
            :param name: ``CfnSpotFleet.ClassicLoadBalancerProperty.Name``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            """``CfnSpotFleet.ClassicLoadBalancerProperty.Name``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
            """
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClassicLoadBalancerProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"classic_load_balancers": "classicLoadBalancers"},
    )
    class ClassicLoadBalancersConfigProperty:
        def __init__(
            self,
            *,
            classic_load_balancers: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.ClassicLoadBalancerProperty", _IResolvable_9ceae33e]]],
        ) -> None:
            """
            :param classic_load_balancers: ``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "classic_load_balancers": classic_load_balancers,
            }

        @builtins.property
        def classic_load_balancers(
            self,
        ) -> typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.ClassicLoadBalancerProperty", _IResolvable_9ceae33e]]]:
            """``CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
            """
            result = self._values.get("classic_load_balancers")
            assert result is not None, "Required property 'classic_load_balancers' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClassicLoadBalancersConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.EbsBlockDeviceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "delete_on_termination": "deleteOnTermination",
            "encrypted": "encrypted",
            "iops": "iops",
            "snapshot_id": "snapshotId",
            "volume_size": "volumeSize",
            "volume_type": "volumeType",
        },
    )
    class EbsBlockDeviceProperty:
        def __init__(
            self,
            *,
            delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            encrypted: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            iops: typing.Optional[jsii.Number] = None,
            snapshot_id: typing.Optional[builtins.str] = None,
            volume_size: typing.Optional[jsii.Number] = None,
            volume_type: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param delete_on_termination: ``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``.
            :param encrypted: ``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``.
            :param iops: ``CfnSpotFleet.EbsBlockDeviceProperty.Iops``.
            :param snapshot_id: ``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``.
            :param volume_size: ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``.
            :param volume_type: ``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if delete_on_termination is not None:
                self._values["delete_on_termination"] = delete_on_termination
            if encrypted is not None:
                self._values["encrypted"] = encrypted
            if iops is not None:
                self._values["iops"] = iops
            if snapshot_id is not None:
                self._values["snapshot_id"] = snapshot_id
            if volume_size is not None:
                self._values["volume_size"] = volume_size
            if volume_type is not None:
                self._values["volume_type"] = volume_type

        @builtins.property
        def delete_on_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
            """
            result = self._values.get("delete_on_termination")
            return result

        @builtins.property
        def encrypted(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.EbsBlockDeviceProperty.Encrypted``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
            """
            result = self._values.get("encrypted")
            return result

        @builtins.property
        def iops(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.EbsBlockDeviceProperty.Iops``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
            """
            result = self._values.get("iops")
            return result

        @builtins.property
        def snapshot_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
            """
            result = self._values.get("snapshot_id")
            return result

        @builtins.property
        def volume_size(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
            """
            result = self._values.get("volume_size")
            return result

        @builtins.property
        def volume_type(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.EbsBlockDeviceProperty.VolumeType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
            """
            result = self._values.get("volume_type")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EbsBlockDeviceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "version": "version",
            "launch_template_id": "launchTemplateId",
            "launch_template_name": "launchTemplateName",
        },
    )
    class FleetLaunchTemplateSpecificationProperty:
        def __init__(
            self,
            *,
            version: builtins.str,
            launch_template_id: typing.Optional[builtins.str] = None,
            launch_template_name: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param version: ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``.
            :param launch_template_id: ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``.
            :param launch_template_name: ``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "version": version,
            }
            if launch_template_id is not None:
                self._values["launch_template_id"] = launch_template_id
            if launch_template_name is not None:
                self._values["launch_template_name"] = launch_template_name

        @builtins.property
        def version(self) -> builtins.str:
            """``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
            """
            result = self._values.get("version")
            assert result is not None, "Required property 'version' is missing"
            return result

        @builtins.property
        def launch_template_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
            """
            result = self._values.get("launch_template_id")
            return result

        @builtins.property
        def launch_template_name(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
            """
            result = self._values.get("launch_template_name")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FleetLaunchTemplateSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.GroupIdentifierProperty",
        jsii_struct_bases=[],
        name_mapping={"group_id": "groupId"},
    )
    class GroupIdentifierProperty:
        def __init__(self, *, group_id: builtins.str) -> None:
            """
            :param group_id: ``CfnSpotFleet.GroupIdentifierProperty.GroupId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "group_id": group_id,
            }

        @builtins.property
        def group_id(self) -> builtins.str:
            """``CfnSpotFleet.GroupIdentifierProperty.GroupId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
            """
            result = self._values.get("group_id")
            assert result is not None, "Required property 'group_id' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GroupIdentifierProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"arn": "arn"},
    )
    class IamInstanceProfileSpecificationProperty:
        def __init__(self, *, arn: typing.Optional[builtins.str] = None) -> None:
            """
            :param arn: ``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if arn is not None:
                self._values["arn"] = arn

        @builtins.property
        def arn(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
            """
            result = self._values.get("arn")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IamInstanceProfileSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.InstanceIpv6AddressProperty",
        jsii_struct_bases=[],
        name_mapping={"ipv6_address": "ipv6Address"},
    )
    class InstanceIpv6AddressProperty:
        def __init__(self, *, ipv6_address: builtins.str) -> None:
            """
            :param ipv6_address: ``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "ipv6_address": ipv6_address,
            }

        @builtins.property
        def ipv6_address(self) -> builtins.str:
            """``CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
            """
            result = self._values.get("ipv6_address")
            assert result is not None, "Required property 'ipv6_address' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InstanceIpv6AddressProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "associate_public_ip_address": "associatePublicIpAddress",
            "delete_on_termination": "deleteOnTermination",
            "description": "description",
            "device_index": "deviceIndex",
            "groups": "groups",
            "ipv6_address_count": "ipv6AddressCount",
            "ipv6_addresses": "ipv6Addresses",
            "network_interface_id": "networkInterfaceId",
            "private_ip_addresses": "privateIpAddresses",
            "secondary_private_ip_address_count": "secondaryPrivateIpAddressCount",
            "subnet_id": "subnetId",
        },
    )
    class InstanceNetworkInterfaceSpecificationProperty:
        def __init__(
            self,
            *,
            associate_public_ip_address: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            delete_on_termination: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            description: typing.Optional[builtins.str] = None,
            device_index: typing.Optional[jsii.Number] = None,
            groups: typing.Optional[typing.List[builtins.str]] = None,
            ipv6_address_count: typing.Optional[jsii.Number] = None,
            ipv6_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]] = None,
            network_interface_id: typing.Optional[builtins.str] = None,
            private_ip_addresses: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            secondary_private_ip_address_count: typing.Optional[jsii.Number] = None,
            subnet_id: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param associate_public_ip_address: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``.
            :param delete_on_termination: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``.
            :param description: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``.
            :param device_index: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``.
            :param groups: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``.
            :param ipv6_address_count: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``.
            :param ipv6_addresses: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``.
            :param network_interface_id: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``.
            :param private_ip_addresses: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``.
            :param secondary_private_ip_address_count: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``.
            :param subnet_id: ``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if associate_public_ip_address is not None:
                self._values["associate_public_ip_address"] = associate_public_ip_address
            if delete_on_termination is not None:
                self._values["delete_on_termination"] = delete_on_termination
            if description is not None:
                self._values["description"] = description
            if device_index is not None:
                self._values["device_index"] = device_index
            if groups is not None:
                self._values["groups"] = groups
            if ipv6_address_count is not None:
                self._values["ipv6_address_count"] = ipv6_address_count
            if ipv6_addresses is not None:
                self._values["ipv6_addresses"] = ipv6_addresses
            if network_interface_id is not None:
                self._values["network_interface_id"] = network_interface_id
            if private_ip_addresses is not None:
                self._values["private_ip_addresses"] = private_ip_addresses
            if secondary_private_ip_address_count is not None:
                self._values["secondary_private_ip_address_count"] = secondary_private_ip_address_count
            if subnet_id is not None:
                self._values["subnet_id"] = subnet_id

        @builtins.property
        def associate_public_ip_address(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
            """
            result = self._values.get("associate_public_ip_address")
            return result

        @builtins.property
        def delete_on_termination(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
            """
            result = self._values.get("delete_on_termination")
            return result

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
            """
            result = self._values.get("description")
            return result

        @builtins.property
        def device_index(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
            """
            result = self._values.get("device_index")
            return result

        @builtins.property
        def groups(self) -> typing.Optional[typing.List[builtins.str]]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
            """
            result = self._values.get("groups")
            return result

        @builtins.property
        def ipv6_address_count(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
            """
            result = self._values.get("ipv6_address_count")
            return result

        @builtins.property
        def ipv6_addresses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.InstanceIpv6AddressProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
            """
            result = self._values.get("ipv6_addresses")
            return result

        @builtins.property
        def network_interface_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
            """
            result = self._values.get("network_interface_id")
            return result

        @builtins.property
        def private_ip_addresses(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.PrivateIpAddressSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
            """
            result = self._values.get("private_ip_addresses")
            return result

        @builtins.property
        def secondary_private_ip_address_count(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
            """
            result = self._values.get("secondary_private_ip_address_count")
            return result

        @builtins.property
        def subnet_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
            """
            result = self._values.get("subnet_id")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InstanceNetworkInterfaceSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.LaunchTemplateConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "launch_template_specification": "launchTemplateSpecification",
            "overrides": "overrides",
        },
    )
    class LaunchTemplateConfigProperty:
        def __init__(
            self,
            *,
            launch_template_specification: typing.Optional[typing.Union["CfnSpotFleet.FleetLaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]] = None,
            overrides: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.LaunchTemplateOverridesProperty", _IResolvable_9ceae33e]]]] = None,
        ) -> None:
            """
            :param launch_template_specification: ``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``.
            :param overrides: ``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if launch_template_specification is not None:
                self._values["launch_template_specification"] = launch_template_specification
            if overrides is not None:
                self._values["overrides"] = overrides

        @builtins.property
        def launch_template_specification(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.FleetLaunchTemplateSpecificationProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
            """
            result = self._values.get("launch_template_specification")
            return result

        @builtins.property
        def overrides(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.LaunchTemplateOverridesProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.LaunchTemplateConfigProperty.Overrides``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
            """
            result = self._values.get("overrides")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LaunchTemplateConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.LaunchTemplateOverridesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "availability_zone": "availabilityZone",
            "instance_type": "instanceType",
            "spot_price": "spotPrice",
            "subnet_id": "subnetId",
            "weighted_capacity": "weightedCapacity",
        },
    )
    class LaunchTemplateOverridesProperty:
        def __init__(
            self,
            *,
            availability_zone: typing.Optional[builtins.str] = None,
            instance_type: typing.Optional[builtins.str] = None,
            spot_price: typing.Optional[builtins.str] = None,
            subnet_id: typing.Optional[builtins.str] = None,
            weighted_capacity: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param availability_zone: ``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``.
            :param instance_type: ``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``.
            :param spot_price: ``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``.
            :param subnet_id: ``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``.
            :param weighted_capacity: ``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if availability_zone is not None:
                self._values["availability_zone"] = availability_zone
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if spot_price is not None:
                self._values["spot_price"] = spot_price
            if subnet_id is not None:
                self._values["subnet_id"] = subnet_id
            if weighted_capacity is not None:
                self._values["weighted_capacity"] = weighted_capacity

        @builtins.property
        def availability_zone(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
            """
            result = self._values.get("availability_zone")
            return result

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
            """
            result = self._values.get("instance_type")
            return result

        @builtins.property
        def spot_price(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
            """
            result = self._values.get("spot_price")
            return result

        @builtins.property
        def subnet_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
            """
            result = self._values.get("subnet_id")
            return result

        @builtins.property
        def weighted_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
            """
            result = self._values.get("weighted_capacity")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LaunchTemplateOverridesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.LoadBalancersConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "classic_load_balancers_config": "classicLoadBalancersConfig",
            "target_groups_config": "targetGroupsConfig",
        },
    )
    class LoadBalancersConfigProperty:
        def __init__(
            self,
            *,
            classic_load_balancers_config: typing.Optional[typing.Union["CfnSpotFleet.ClassicLoadBalancersConfigProperty", _IResolvable_9ceae33e]] = None,
            target_groups_config: typing.Optional[typing.Union["CfnSpotFleet.TargetGroupsConfigProperty", _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param classic_load_balancers_config: ``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``.
            :param target_groups_config: ``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if classic_load_balancers_config is not None:
                self._values["classic_load_balancers_config"] = classic_load_balancers_config
            if target_groups_config is not None:
                self._values["target_groups_config"] = target_groups_config

        @builtins.property
        def classic_load_balancers_config(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.ClassicLoadBalancersConfigProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
            """
            result = self._values.get("classic_load_balancers_config")
            return result

        @builtins.property
        def target_groups_config(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.TargetGroupsConfigProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
            """
            result = self._values.get("target_groups_config")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LoadBalancersConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"private_ip_address": "privateIpAddress", "primary": "primary"},
    )
    class PrivateIpAddressSpecificationProperty:
        def __init__(
            self,
            *,
            private_ip_address: builtins.str,
            primary: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param private_ip_address: ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``.
            :param primary: ``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "private_ip_address": private_ip_address,
            }
            if primary is not None:
                self._values["primary"] = primary

        @builtins.property
        def private_ip_address(self) -> builtins.str:
            """``CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
            """
            result = self._values.get("private_ip_address")
            assert result is not None, "Required property 'private_ip_address' is missing"
            return result

        @builtins.property
        def primary(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
            """
            result = self._values.get("primary")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "PrivateIpAddressSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "image_id": "imageId",
            "instance_type": "instanceType",
            "block_device_mappings": "blockDeviceMappings",
            "ebs_optimized": "ebsOptimized",
            "iam_instance_profile": "iamInstanceProfile",
            "kernel_id": "kernelId",
            "key_name": "keyName",
            "monitoring": "monitoring",
            "network_interfaces": "networkInterfaces",
            "placement": "placement",
            "ramdisk_id": "ramdiskId",
            "security_groups": "securityGroups",
            "spot_price": "spotPrice",
            "subnet_id": "subnetId",
            "tag_specifications": "tagSpecifications",
            "user_data": "userData",
            "weighted_capacity": "weightedCapacity",
        },
    )
    class SpotFleetLaunchSpecificationProperty:
        def __init__(
            self,
            *,
            image_id: builtins.str,
            instance_type: builtins.str,
            block_device_mappings: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]] = None,
            ebs_optimized: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            iam_instance_profile: typing.Optional[typing.Union["CfnSpotFleet.IamInstanceProfileSpecificationProperty", _IResolvable_9ceae33e]] = None,
            kernel_id: typing.Optional[builtins.str] = None,
            key_name: typing.Optional[builtins.str] = None,
            monitoring: typing.Optional[typing.Union["CfnSpotFleet.SpotFleetMonitoringProperty", _IResolvable_9ceae33e]] = None,
            network_interfaces: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            placement: typing.Optional[typing.Union["CfnSpotFleet.SpotPlacementProperty", _IResolvable_9ceae33e]] = None,
            ramdisk_id: typing.Optional[builtins.str] = None,
            security_groups: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.GroupIdentifierProperty", _IResolvable_9ceae33e]]]] = None,
            spot_price: typing.Optional[builtins.str] = None,
            subnet_id: typing.Optional[builtins.str] = None,
            tag_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.SpotFleetTagSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            user_data: typing.Optional[builtins.str] = None,
            weighted_capacity: typing.Optional[jsii.Number] = None,
        ) -> None:
            """
            :param image_id: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``.
            :param instance_type: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``.
            :param block_device_mappings: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``.
            :param ebs_optimized: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``.
            :param iam_instance_profile: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``.
            :param kernel_id: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``.
            :param key_name: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``.
            :param monitoring: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``.
            :param network_interfaces: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``.
            :param placement: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``.
            :param ramdisk_id: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``.
            :param security_groups: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``.
            :param spot_price: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``.
            :param subnet_id: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``.
            :param tag_specifications: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``.
            :param user_data: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``.
            :param weighted_capacity: ``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "image_id": image_id,
                "instance_type": instance_type,
            }
            if block_device_mappings is not None:
                self._values["block_device_mappings"] = block_device_mappings
            if ebs_optimized is not None:
                self._values["ebs_optimized"] = ebs_optimized
            if iam_instance_profile is not None:
                self._values["iam_instance_profile"] = iam_instance_profile
            if kernel_id is not None:
                self._values["kernel_id"] = kernel_id
            if key_name is not None:
                self._values["key_name"] = key_name
            if monitoring is not None:
                self._values["monitoring"] = monitoring
            if network_interfaces is not None:
                self._values["network_interfaces"] = network_interfaces
            if placement is not None:
                self._values["placement"] = placement
            if ramdisk_id is not None:
                self._values["ramdisk_id"] = ramdisk_id
            if security_groups is not None:
                self._values["security_groups"] = security_groups
            if spot_price is not None:
                self._values["spot_price"] = spot_price
            if subnet_id is not None:
                self._values["subnet_id"] = subnet_id
            if tag_specifications is not None:
                self._values["tag_specifications"] = tag_specifications
            if user_data is not None:
                self._values["user_data"] = user_data
            if weighted_capacity is not None:
                self._values["weighted_capacity"] = weighted_capacity

        @builtins.property
        def image_id(self) -> builtins.str:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
            """
            result = self._values.get("image_id")
            assert result is not None, "Required property 'image_id' is missing"
            return result

        @builtins.property
        def instance_type(self) -> builtins.str:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
            """
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return result

        @builtins.property
        def block_device_mappings(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.BlockDeviceMappingProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
            """
            result = self._values.get("block_device_mappings")
            return result

        @builtins.property
        def ebs_optimized(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
            """
            result = self._values.get("ebs_optimized")
            return result

        @builtins.property
        def iam_instance_profile(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.IamInstanceProfileSpecificationProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
            """
            result = self._values.get("iam_instance_profile")
            return result

        @builtins.property
        def kernel_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
            """
            result = self._values.get("kernel_id")
            return result

        @builtins.property
        def key_name(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
            """
            result = self._values.get("key_name")
            return result

        @builtins.property
        def monitoring(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.SpotFleetMonitoringProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
            """
            result = self._values.get("monitoring")
            return result

        @builtins.property
        def network_interfaces(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
            """
            result = self._values.get("network_interfaces")
            return result

        @builtins.property
        def placement(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.SpotPlacementProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
            """
            result = self._values.get("placement")
            return result

        @builtins.property
        def ramdisk_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
            """
            result = self._values.get("ramdisk_id")
            return result

        @builtins.property
        def security_groups(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.GroupIdentifierProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
            """
            result = self._values.get("security_groups")
            return result

        @builtins.property
        def spot_price(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
            """
            result = self._values.get("spot_price")
            return result

        @builtins.property
        def subnet_id(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
            """
            result = self._values.get("subnet_id")
            return result

        @builtins.property
        def tag_specifications(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.SpotFleetTagSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
            """
            result = self._values.get("tag_specifications")
            return result

        @builtins.property
        def user_data(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
            """
            result = self._values.get("user_data")
            return result

        @builtins.property
        def weighted_capacity(self) -> typing.Optional[jsii.Number]:
            """``CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
            """
            result = self._values.get("weighted_capacity")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotFleetLaunchSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.SpotFleetMonitoringProperty",
        jsii_struct_bases=[],
        name_mapping={"enabled": "enabled"},
    )
    class SpotFleetMonitoringProperty:
        def __init__(
            self,
            *,
            enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        ) -> None:
            """
            :param enabled: ``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if enabled is not None:
                self._values["enabled"] = enabled

        @builtins.property
        def enabled(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetMonitoringProperty.Enabled``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
            """
            result = self._values.get("enabled")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotFleetMonitoringProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty",
        jsii_struct_bases=[],
        name_mapping={
            "iam_fleet_role": "iamFleetRole",
            "target_capacity": "targetCapacity",
            "allocation_strategy": "allocationStrategy",
            "excess_capacity_termination_policy": "excessCapacityTerminationPolicy",
            "instance_interruption_behavior": "instanceInterruptionBehavior",
            "launch_specifications": "launchSpecifications",
            "launch_template_configs": "launchTemplateConfigs",
            "load_balancers_config": "loadBalancersConfig",
            "replace_unhealthy_instances": "replaceUnhealthyInstances",
            "spot_price": "spotPrice",
            "terminate_instances_with_expiration": "terminateInstancesWithExpiration",
            "type": "type",
            "valid_from": "validFrom",
            "valid_until": "validUntil",
        },
    )
    class SpotFleetRequestConfigDataProperty:
        def __init__(
            self,
            *,
            iam_fleet_role: builtins.str,
            target_capacity: jsii.Number,
            allocation_strategy: typing.Optional[builtins.str] = None,
            excess_capacity_termination_policy: typing.Optional[builtins.str] = None,
            instance_interruption_behavior: typing.Optional[builtins.str] = None,
            launch_specifications: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.SpotFleetLaunchSpecificationProperty", _IResolvable_9ceae33e]]]] = None,
            launch_template_configs: typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.LaunchTemplateConfigProperty", _IResolvable_9ceae33e]]]] = None,
            load_balancers_config: typing.Optional[typing.Union["CfnSpotFleet.LoadBalancersConfigProperty", _IResolvable_9ceae33e]] = None,
            replace_unhealthy_instances: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            spot_price: typing.Optional[builtins.str] = None,
            terminate_instances_with_expiration: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
            type: typing.Optional[builtins.str] = None,
            valid_from: typing.Optional[builtins.str] = None,
            valid_until: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param iam_fleet_role: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``.
            :param target_capacity: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``.
            :param allocation_strategy: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``.
            :param excess_capacity_termination_policy: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``.
            :param instance_interruption_behavior: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``.
            :param launch_specifications: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``.
            :param launch_template_configs: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``.
            :param load_balancers_config: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``.
            :param replace_unhealthy_instances: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``.
            :param spot_price: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``.
            :param terminate_instances_with_expiration: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``.
            :param type: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``.
            :param valid_from: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``.
            :param valid_until: ``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "iam_fleet_role": iam_fleet_role,
                "target_capacity": target_capacity,
            }
            if allocation_strategy is not None:
                self._values["allocation_strategy"] = allocation_strategy
            if excess_capacity_termination_policy is not None:
                self._values["excess_capacity_termination_policy"] = excess_capacity_termination_policy
            if instance_interruption_behavior is not None:
                self._values["instance_interruption_behavior"] = instance_interruption_behavior
            if launch_specifications is not None:
                self._values["launch_specifications"] = launch_specifications
            if launch_template_configs is not None:
                self._values["launch_template_configs"] = launch_template_configs
            if load_balancers_config is not None:
                self._values["load_balancers_config"] = load_balancers_config
            if replace_unhealthy_instances is not None:
                self._values["replace_unhealthy_instances"] = replace_unhealthy_instances
            if spot_price is not None:
                self._values["spot_price"] = spot_price
            if terminate_instances_with_expiration is not None:
                self._values["terminate_instances_with_expiration"] = terminate_instances_with_expiration
            if type is not None:
                self._values["type"] = type
            if valid_from is not None:
                self._values["valid_from"] = valid_from
            if valid_until is not None:
                self._values["valid_until"] = valid_until

        @builtins.property
        def iam_fleet_role(self) -> builtins.str:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
            """
            result = self._values.get("iam_fleet_role")
            assert result is not None, "Required property 'iam_fleet_role' is missing"
            return result

        @builtins.property
        def target_capacity(self) -> jsii.Number:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
            """
            result = self._values.get("target_capacity")
            assert result is not None, "Required property 'target_capacity' is missing"
            return result

        @builtins.property
        def allocation_strategy(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
            """
            result = self._values.get("allocation_strategy")
            return result

        @builtins.property
        def excess_capacity_termination_policy(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
            """
            result = self._values.get("excess_capacity_termination_policy")
            return result

        @builtins.property
        def instance_interruption_behavior(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
            """
            result = self._values.get("instance_interruption_behavior")
            return result

        @builtins.property
        def launch_specifications(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.SpotFleetLaunchSpecificationProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
            """
            result = self._values.get("launch_specifications")
            return result

        @builtins.property
        def launch_template_configs(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.LaunchTemplateConfigProperty", _IResolvable_9ceae33e]]]]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
            """
            result = self._values.get("launch_template_configs")
            return result

        @builtins.property
        def load_balancers_config(
            self,
        ) -> typing.Optional[typing.Union["CfnSpotFleet.LoadBalancersConfigProperty", _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
            """
            result = self._values.get("load_balancers_config")
            return result

        @builtins.property
        def replace_unhealthy_instances(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
            """
            result = self._values.get("replace_unhealthy_instances")
            return result

        @builtins.property
        def spot_price(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
            """
            result = self._values.get("spot_price")
            return result

        @builtins.property
        def terminate_instances_with_expiration(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
            """
            result = self._values.get("terminate_instances_with_expiration")
            return result

        @builtins.property
        def type(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
            """
            result = self._values.get("type")
            return result

        @builtins.property
        def valid_from(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
            """
            result = self._values.get("valid_from")
            return result

        @builtins.property
        def valid_until(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
            """
            result = self._values.get("valid_until")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotFleetRequestConfigDataProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"resource_type": "resourceType", "tags": "tags"},
    )
    class SpotFleetTagSpecificationProperty:
        def __init__(
            self,
            *,
            resource_type: typing.Optional[builtins.str] = None,
            tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        ) -> None:
            """
            :param resource_type: ``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``.
            :param tags: ``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if resource_type is not None:
                self._values["resource_type"] = resource_type
            if tags is not None:
                self._values["tags"] = tags

        @builtins.property
        def resource_type(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
            """
            result = self._values.get("resource_type")
            return result

        @builtins.property
        def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
            """``CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
            """
            result = self._values.get("tags")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotFleetTagSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.SpotPlacementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "availability_zone": "availabilityZone",
            "group_name": "groupName",
            "tenancy": "tenancy",
        },
    )
    class SpotPlacementProperty:
        def __init__(
            self,
            *,
            availability_zone: typing.Optional[builtins.str] = None,
            group_name: typing.Optional[builtins.str] = None,
            tenancy: typing.Optional[builtins.str] = None,
        ) -> None:
            """
            :param availability_zone: ``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``.
            :param group_name: ``CfnSpotFleet.SpotPlacementProperty.GroupName``.
            :param tenancy: ``CfnSpotFleet.SpotPlacementProperty.Tenancy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
            """
            self._values: typing.Dict[str, typing.Any] = {}
            if availability_zone is not None:
                self._values["availability_zone"] = availability_zone
            if group_name is not None:
                self._values["group_name"] = group_name
            if tenancy is not None:
                self._values["tenancy"] = tenancy

        @builtins.property
        def availability_zone(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotPlacementProperty.AvailabilityZone``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
            """
            result = self._values.get("availability_zone")
            return result

        @builtins.property
        def group_name(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotPlacementProperty.GroupName``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
            """
            result = self._values.get("group_name")
            return result

        @builtins.property
        def tenancy(self) -> typing.Optional[builtins.str]:
            """``CfnSpotFleet.SpotPlacementProperty.Tenancy``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
            """
            result = self._values.get("tenancy")
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SpotPlacementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.TargetGroupProperty",
        jsii_struct_bases=[],
        name_mapping={"arn": "arn"},
    )
    class TargetGroupProperty:
        def __init__(self, *, arn: builtins.str) -> None:
            """
            :param arn: ``CfnSpotFleet.TargetGroupProperty.Arn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "arn": arn,
            }

        @builtins.property
        def arn(self) -> builtins.str:
            """``CfnSpotFleet.TargetGroupProperty.Arn``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
            """
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TargetGroupProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleet.TargetGroupsConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"target_groups": "targetGroups"},
    )
    class TargetGroupsConfigProperty:
        def __init__(
            self,
            *,
            target_groups: typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.TargetGroupProperty", _IResolvable_9ceae33e]]],
        ) -> None:
            """
            :param target_groups: ``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "target_groups": target_groups,
            }

        @builtins.property
        def target_groups(
            self,
        ) -> typing.Union[_IResolvable_9ceae33e, typing.List[typing.Union["CfnSpotFleet.TargetGroupProperty", _IResolvable_9ceae33e]]]:
            """``CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
            """
            result = self._values.get("target_groups")
            assert result is not None, "Required property 'target_groups' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TargetGroupsConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSpotFleetProps",
    jsii_struct_bases=[],
    name_mapping={"spot_fleet_request_config_data": "spotFleetRequestConfigData"},
)
class CfnSpotFleetProps:
    def __init__(
        self,
        *,
        spot_fleet_request_config_data: typing.Union["CfnSpotFleet.SpotFleetRequestConfigDataProperty", _IResolvable_9ceae33e],
    ) -> None:
        """Properties for defining a ``AWS::EC2::SpotFleet``.

        :param spot_fleet_request_config_data: ``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "spot_fleet_request_config_data": spot_fleet_request_config_data,
        }

    @builtins.property
    def spot_fleet_request_config_data(
        self,
    ) -> typing.Union["CfnSpotFleet.SpotFleetRequestConfigDataProperty", _IResolvable_9ceae33e]:
        """``AWS::EC2::SpotFleet.SpotFleetRequestConfigData``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
        """
        result = self._values.get("spot_fleet_request_config_data")
        assert result is not None, "Required property 'spot_fleet_request_config_data' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSpotFleetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSubnet(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnet",
):
    """A CloudFormation ``AWS::EC2::Subnet``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::Subnet
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        cidr_block: builtins.str,
        vpc_id: builtins.str,
        assign_ipv6_address_on_creation: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        availability_zone: typing.Optional[builtins.str] = None,
        ipv6_cidr_block: typing.Optional[builtins.str] = None,
        map_public_ip_on_launch: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::Subnet``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param cidr_block: ``AWS::EC2::Subnet.CidrBlock``.
        :param vpc_id: ``AWS::EC2::Subnet.VpcId``.
        :param assign_ipv6_address_on_creation: ``AWS::EC2::Subnet.AssignIpv6AddressOnCreation``.
        :param availability_zone: ``AWS::EC2::Subnet.AvailabilityZone``.
        :param ipv6_cidr_block: ``AWS::EC2::Subnet.Ipv6CidrBlock``.
        :param map_public_ip_on_launch: ``AWS::EC2::Subnet.MapPublicIpOnLaunch``.
        :param tags: ``AWS::EC2::Subnet.Tags``.
        """
        props = CfnSubnetProps(
            cidr_block=cidr_block,
            vpc_id=vpc_id,
            assign_ipv6_address_on_creation=assign_ipv6_address_on_creation,
            availability_zone=availability_zone,
            ipv6_cidr_block=ipv6_cidr_block,
            map_public_ip_on_launch=map_public_ip_on_launch,
            tags=tags,
        )

        jsii.create(CfnSubnet, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAvailabilityZone")
    def attr_availability_zone(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AvailabilityZone
        """
        return jsii.get(self, "attrAvailabilityZone")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrIpv6CidrBlocks")
    def attr_ipv6_cidr_blocks(self) -> typing.List[builtins.str]:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Ipv6CidrBlocks
        """
        return jsii.get(self, "attrIpv6CidrBlocks")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrNetworkAclAssociationId")
    def attr_network_acl_association_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: NetworkAclAssociationId
        """
        return jsii.get(self, "attrNetworkAclAssociationId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrVpcId")
    def attr_vpc_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: VpcId
        """
        return jsii.get(self, "attrVpcId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::Subnet.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrBlock")
    def cidr_block(self) -> builtins.str:
        """``AWS::EC2::Subnet.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
        """
        return jsii.get(self, "cidrBlock")

    @cidr_block.setter # type: ignore
    def cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "cidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::Subnet.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="assignIpv6AddressOnCreation")
    def assign_ipv6_address_on_creation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Subnet.AssignIpv6AddressOnCreation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
        """
        return jsii.get(self, "assignIpv6AddressOnCreation")

    @assign_ipv6_address_on_creation.setter # type: ignore
    def assign_ipv6_address_on_creation(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "assignIpv6AddressOnCreation", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="availabilityZone")
    def availability_zone(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Subnet.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
        """
        return jsii.get(self, "availabilityZone")

    @availability_zone.setter # type: ignore
    def availability_zone(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "availabilityZone", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Subnet.Ipv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
        """
        return jsii.get(self, "ipv6CidrBlock")

    @ipv6_cidr_block.setter # type: ignore
    def ipv6_cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "ipv6CidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="mapPublicIpOnLaunch")
    def map_public_ip_on_launch(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Subnet.MapPublicIpOnLaunch``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
        """
        return jsii.get(self, "mapPublicIpOnLaunch")

    @map_public_ip_on_launch.setter # type: ignore
    def map_public_ip_on_launch(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "mapPublicIpOnLaunch", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnSubnetCidrBlock(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetCidrBlock",
):
    """A CloudFormation ``AWS::EC2::SubnetCidrBlock``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SubnetCidrBlock
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        ipv6_cidr_block: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::SubnetCidrBlock``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param ipv6_cidr_block: ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``.
        :param subnet_id: ``AWS::EC2::SubnetCidrBlock.SubnetId``.
        """
        props = CfnSubnetCidrBlockProps(
            ipv6_cidr_block=ipv6_cidr_block, subnet_id=subnet_id
        )

        jsii.create(CfnSubnetCidrBlock, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> builtins.str:
        """``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
        """
        return jsii.get(self, "ipv6CidrBlock")

    @ipv6_cidr_block.setter # type: ignore
    def ipv6_cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "ipv6CidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::SubnetCidrBlock.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetCidrBlockProps",
    jsii_struct_bases=[],
    name_mapping={"ipv6_cidr_block": "ipv6CidrBlock", "subnet_id": "subnetId"},
)
class CfnSubnetCidrBlockProps:
    def __init__(
        self,
        *,
        ipv6_cidr_block: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::SubnetCidrBlock``.

        :param ipv6_cidr_block: ``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``.
        :param subnet_id: ``AWS::EC2::SubnetCidrBlock.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "ipv6_cidr_block": ipv6_cidr_block,
            "subnet_id": subnet_id,
        }

    @builtins.property
    def ipv6_cidr_block(self) -> builtins.str:
        """``AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
        """
        result = self._values.get("ipv6_cidr_block")
        assert result is not None, "Required property 'ipv6_cidr_block' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::SubnetCidrBlock.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSubnetCidrBlockProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSubnetNetworkAclAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetNetworkAclAssociation",
):
    """A CloudFormation ``AWS::EC2::SubnetNetworkAclAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SubnetNetworkAclAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        network_acl_id: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::SubnetNetworkAclAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param network_acl_id: ``AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId``.
        :param subnet_id: ``AWS::EC2::SubnetNetworkAclAssociation.SubnetId``.
        """
        props = CfnSubnetNetworkAclAssociationProps(
            network_acl_id=network_acl_id, subnet_id=subnet_id
        )

        jsii.create(CfnSubnetNetworkAclAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrAssociationId")
    def attr_association_id(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: AssociationId
        """
        return jsii.get(self, "attrAssociationId")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkAclId")
    def network_acl_id(self) -> builtins.str:
        """``AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
        """
        return jsii.get(self, "networkAclId")

    @network_acl_id.setter # type: ignore
    def network_acl_id(self, value: builtins.str) -> None:
        jsii.set(self, "networkAclId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::SubnetNetworkAclAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetNetworkAclAssociationProps",
    jsii_struct_bases=[],
    name_mapping={"network_acl_id": "networkAclId", "subnet_id": "subnetId"},
)
class CfnSubnetNetworkAclAssociationProps:
    def __init__(
        self,
        *,
        network_acl_id: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::SubnetNetworkAclAssociation``.

        :param network_acl_id: ``AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId``.
        :param subnet_id: ``AWS::EC2::SubnetNetworkAclAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "network_acl_id": network_acl_id,
            "subnet_id": subnet_id,
        }

    @builtins.property
    def network_acl_id(self) -> builtins.str:
        """``AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
        """
        result = self._values.get("network_acl_id")
        assert result is not None, "Required property 'network_acl_id' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::SubnetNetworkAclAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSubnetNetworkAclAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetProps",
    jsii_struct_bases=[],
    name_mapping={
        "cidr_block": "cidrBlock",
        "vpc_id": "vpcId",
        "assign_ipv6_address_on_creation": "assignIpv6AddressOnCreation",
        "availability_zone": "availabilityZone",
        "ipv6_cidr_block": "ipv6CidrBlock",
        "map_public_ip_on_launch": "mapPublicIpOnLaunch",
        "tags": "tags",
    },
)
class CfnSubnetProps:
    def __init__(
        self,
        *,
        cidr_block: builtins.str,
        vpc_id: builtins.str,
        assign_ipv6_address_on_creation: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        availability_zone: typing.Optional[builtins.str] = None,
        ipv6_cidr_block: typing.Optional[builtins.str] = None,
        map_public_ip_on_launch: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::Subnet``.

        :param cidr_block: ``AWS::EC2::Subnet.CidrBlock``.
        :param vpc_id: ``AWS::EC2::Subnet.VpcId``.
        :param assign_ipv6_address_on_creation: ``AWS::EC2::Subnet.AssignIpv6AddressOnCreation``.
        :param availability_zone: ``AWS::EC2::Subnet.AvailabilityZone``.
        :param ipv6_cidr_block: ``AWS::EC2::Subnet.Ipv6CidrBlock``.
        :param map_public_ip_on_launch: ``AWS::EC2::Subnet.MapPublicIpOnLaunch``.
        :param tags: ``AWS::EC2::Subnet.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "cidr_block": cidr_block,
            "vpc_id": vpc_id,
        }
        if assign_ipv6_address_on_creation is not None:
            self._values["assign_ipv6_address_on_creation"] = assign_ipv6_address_on_creation
        if availability_zone is not None:
            self._values["availability_zone"] = availability_zone
        if ipv6_cidr_block is not None:
            self._values["ipv6_cidr_block"] = ipv6_cidr_block
        if map_public_ip_on_launch is not None:
            self._values["map_public_ip_on_launch"] = map_public_ip_on_launch
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def cidr_block(self) -> builtins.str:
        """``AWS::EC2::Subnet.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
        """
        result = self._values.get("cidr_block")
        assert result is not None, "Required property 'cidr_block' is missing"
        return result

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::Subnet.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def assign_ipv6_address_on_creation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Subnet.AssignIpv6AddressOnCreation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
        """
        result = self._values.get("assign_ipv6_address_on_creation")
        return result

    @builtins.property
    def availability_zone(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Subnet.AvailabilityZone``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
        """
        result = self._values.get("availability_zone")
        return result

    @builtins.property
    def ipv6_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::Subnet.Ipv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
        """
        result = self._values.get("ipv6_cidr_block")
        return result

    @builtins.property
    def map_public_ip_on_launch(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::Subnet.MapPublicIpOnLaunch``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
        """
        result = self._values.get("map_public_ip_on_launch")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::Subnet.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSubnetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnSubnetRouteTableAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetRouteTableAssociation",
):
    """A CloudFormation ``AWS::EC2::SubnetRouteTableAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::SubnetRouteTableAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        route_table_id: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::SubnetRouteTableAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param route_table_id: ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``.
        :param subnet_id: ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``.
        """
        props = CfnSubnetRouteTableAssociationProps(
            route_table_id=route_table_id, subnet_id=subnet_id
        )

        jsii.create(CfnSubnetRouteTableAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeTableId")
    def route_table_id(self) -> builtins.str:
        """``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
        """
        return jsii.get(self, "routeTableId")

    @route_table_id.setter # type: ignore
    def route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "routeTableId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetId")
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::SubnetRouteTableAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
        """
        return jsii.get(self, "subnetId")

    @subnet_id.setter # type: ignore
    def subnet_id(self, value: builtins.str) -> None:
        jsii.set(self, "subnetId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnSubnetRouteTableAssociationProps",
    jsii_struct_bases=[],
    name_mapping={"route_table_id": "routeTableId", "subnet_id": "subnetId"},
)
class CfnSubnetRouteTableAssociationProps:
    def __init__(
        self,
        *,
        route_table_id: builtins.str,
        subnet_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::SubnetRouteTableAssociation``.

        :param route_table_id: ``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``.
        :param subnet_id: ``AWS::EC2::SubnetRouteTableAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "route_table_id": route_table_id,
            "subnet_id": subnet_id,
        }

    @builtins.property
    def route_table_id(self) -> builtins.str:
        """``AWS::EC2::SubnetRouteTableAssociation.RouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
        """
        result = self._values.get("route_table_id")
        assert result is not None, "Required property 'route_table_id' is missing"
        return result

    @builtins.property
    def subnet_id(self) -> builtins.str:
        """``AWS::EC2::SubnetRouteTableAssociation.SubnetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
        """
        result = self._values.get("subnet_id")
        assert result is not None, "Required property 'subnet_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnSubnetRouteTableAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTrafficMirrorFilter(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorFilter",
):
    """A CloudFormation ``AWS::EC2::TrafficMirrorFilter``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TrafficMirrorFilter
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        description: typing.Optional[builtins.str] = None,
        network_services: typing.Optional[typing.List[builtins.str]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TrafficMirrorFilter``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param description: ``AWS::EC2::TrafficMirrorFilter.Description``.
        :param network_services: ``AWS::EC2::TrafficMirrorFilter.NetworkServices``.
        :param tags: ``AWS::EC2::TrafficMirrorFilter.Tags``.
        """
        props = CfnTrafficMirrorFilterProps(
            description=description, network_services=network_services, tags=tags
        )

        jsii.create(CfnTrafficMirrorFilter, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::TrafficMirrorFilter.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorFilter.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkServices")
    def network_services(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::TrafficMirrorFilter.NetworkServices``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-networkservices
        """
        return jsii.get(self, "networkServices")

    @network_services.setter # type: ignore
    def network_services(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "networkServices", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorFilterProps",
    jsii_struct_bases=[],
    name_mapping={
        "description": "description",
        "network_services": "networkServices",
        "tags": "tags",
    },
)
class CfnTrafficMirrorFilterProps:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        network_services: typing.Optional[typing.List[builtins.str]] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TrafficMirrorFilter``.

        :param description: ``AWS::EC2::TrafficMirrorFilter.Description``.
        :param network_services: ``AWS::EC2::TrafficMirrorFilter.NetworkServices``.
        :param tags: ``AWS::EC2::TrafficMirrorFilter.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if network_services is not None:
            self._values["network_services"] = network_services
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorFilter.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def network_services(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::TrafficMirrorFilter.NetworkServices``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-networkservices
        """
        result = self._values.get("network_services")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::TrafficMirrorFilter.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilter.html#cfn-ec2-trafficmirrorfilter-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTrafficMirrorFilterProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTrafficMirrorFilterRule(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorFilterRule",
):
    """A CloudFormation ``AWS::EC2::TrafficMirrorFilterRule``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TrafficMirrorFilterRule
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        destination_cidr_block: builtins.str,
        rule_action: builtins.str,
        rule_number: jsii.Number,
        source_cidr_block: builtins.str,
        traffic_direction: builtins.str,
        traffic_mirror_filter_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        destination_port_range: typing.Optional[typing.Union["TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]] = None,
        protocol: typing.Optional[jsii.Number] = None,
        source_port_range: typing.Optional[typing.Union["TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TrafficMirrorFilterRule``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param destination_cidr_block: ``AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock``.
        :param rule_action: ``AWS::EC2::TrafficMirrorFilterRule.RuleAction``.
        :param rule_number: ``AWS::EC2::TrafficMirrorFilterRule.RuleNumber``.
        :param source_cidr_block: ``AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock``.
        :param traffic_direction: ``AWS::EC2::TrafficMirrorFilterRule.TrafficDirection``.
        :param traffic_mirror_filter_id: ``AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId``.
        :param description: ``AWS::EC2::TrafficMirrorFilterRule.Description``.
        :param destination_port_range: ``AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange``.
        :param protocol: ``AWS::EC2::TrafficMirrorFilterRule.Protocol``.
        :param source_port_range: ``AWS::EC2::TrafficMirrorFilterRule.SourcePortRange``.
        """
        props = CfnTrafficMirrorFilterRuleProps(
            destination_cidr_block=destination_cidr_block,
            rule_action=rule_action,
            rule_number=rule_number,
            source_cidr_block=source_cidr_block,
            traffic_direction=traffic_direction,
            traffic_mirror_filter_id=traffic_mirror_filter_id,
            description=description,
            destination_port_range=destination_port_range,
            protocol=protocol,
            source_port_range=source_port_range,
        )

        jsii.create(CfnTrafficMirrorFilterRule, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationCidrBlock")
    def destination_cidr_block(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
        """
        return jsii.get(self, "destinationCidrBlock")

    @destination_cidr_block.setter # type: ignore
    def destination_cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "destinationCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ruleAction")
    def rule_action(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.RuleAction``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
        """
        return jsii.get(self, "ruleAction")

    @rule_action.setter # type: ignore
    def rule_action(self, value: builtins.str) -> None:
        jsii.set(self, "ruleAction", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="ruleNumber")
    def rule_number(self) -> jsii.Number:
        """``AWS::EC2::TrafficMirrorFilterRule.RuleNumber``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
        """
        return jsii.get(self, "ruleNumber")

    @rule_number.setter # type: ignore
    def rule_number(self, value: jsii.Number) -> None:
        jsii.set(self, "ruleNumber", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourceCidrBlock")
    def source_cidr_block(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
        """
        return jsii.get(self, "sourceCidrBlock")

    @source_cidr_block.setter # type: ignore
    def source_cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "sourceCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="trafficDirection")
    def traffic_direction(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.TrafficDirection``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
        """
        return jsii.get(self, "trafficDirection")

    @traffic_direction.setter # type: ignore
    def traffic_direction(self, value: builtins.str) -> None:
        jsii.set(self, "trafficDirection", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
        """
        return jsii.get(self, "trafficMirrorFilterId")

    @traffic_mirror_filter_id.setter # type: ignore
    def traffic_mirror_filter_id(self, value: builtins.str) -> None:
        jsii.set(self, "trafficMirrorFilterId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorFilterRule.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationPortRange")
    def destination_port_range(
        self,
    ) -> typing.Optional[typing.Union["TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
        """
        return jsii.get(self, "destinationPortRange")

    @destination_port_range.setter # type: ignore
    def destination_port_range(
        self,
        value: typing.Optional[typing.Union["TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "destinationPortRange", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="protocol")
    def protocol(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TrafficMirrorFilterRule.Protocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
        """
        return jsii.get(self, "protocol")

    @protocol.setter # type: ignore
    def protocol(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "protocol", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sourcePortRange")
    def source_port_range(
        self,
    ) -> typing.Optional[typing.Union["TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::TrafficMirrorFilterRule.SourcePortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
        """
        return jsii.get(self, "sourcePortRange")

    @source_port_range.setter # type: ignore
    def source_port_range(
        self,
        value: typing.Optional[typing.Union["TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "sourcePortRange", value)

    @jsii.data_type(
        jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty",
        jsii_struct_bases=[],
        name_mapping={"from_port": "fromPort", "to_port": "toPort"},
    )
    class TrafficMirrorPortRangeProperty:
        def __init__(self, *, from_port: jsii.Number, to_port: jsii.Number) -> None:
            """
            :param from_port: ``CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.FromPort``.
            :param to_port: ``CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.ToPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html
            """
            self._values: typing.Dict[str, typing.Any] = {
                "from_port": from_port,
                "to_port": to_port,
            }

        @builtins.property
        def from_port(self) -> jsii.Number:
            """``CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.FromPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorportrange-fromport
            """
            result = self._values.get("from_port")
            assert result is not None, "Required property 'from_port' is missing"
            return result

        @builtins.property
        def to_port(self) -> jsii.Number:
            """``CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.ToPort``.

            see
            :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-trafficmirrorfilterrule-trafficmirrorportrange.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorportrange-toport
            """
            result = self._values.get("to_port")
            assert result is not None, "Required property 'to_port' is missing"
            return result

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TrafficMirrorPortRangeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorFilterRuleProps",
    jsii_struct_bases=[],
    name_mapping={
        "destination_cidr_block": "destinationCidrBlock",
        "rule_action": "ruleAction",
        "rule_number": "ruleNumber",
        "source_cidr_block": "sourceCidrBlock",
        "traffic_direction": "trafficDirection",
        "traffic_mirror_filter_id": "trafficMirrorFilterId",
        "description": "description",
        "destination_port_range": "destinationPortRange",
        "protocol": "protocol",
        "source_port_range": "sourcePortRange",
    },
)
class CfnTrafficMirrorFilterRuleProps:
    def __init__(
        self,
        *,
        destination_cidr_block: builtins.str,
        rule_action: builtins.str,
        rule_number: jsii.Number,
        source_cidr_block: builtins.str,
        traffic_direction: builtins.str,
        traffic_mirror_filter_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        destination_port_range: typing.Optional[typing.Union["CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]] = None,
        protocol: typing.Optional[jsii.Number] = None,
        source_port_range: typing.Optional[typing.Union["CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TrafficMirrorFilterRule``.

        :param destination_cidr_block: ``AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock``.
        :param rule_action: ``AWS::EC2::TrafficMirrorFilterRule.RuleAction``.
        :param rule_number: ``AWS::EC2::TrafficMirrorFilterRule.RuleNumber``.
        :param source_cidr_block: ``AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock``.
        :param traffic_direction: ``AWS::EC2::TrafficMirrorFilterRule.TrafficDirection``.
        :param traffic_mirror_filter_id: ``AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId``.
        :param description: ``AWS::EC2::TrafficMirrorFilterRule.Description``.
        :param destination_port_range: ``AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange``.
        :param protocol: ``AWS::EC2::TrafficMirrorFilterRule.Protocol``.
        :param source_port_range: ``AWS::EC2::TrafficMirrorFilterRule.SourcePortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "destination_cidr_block": destination_cidr_block,
            "rule_action": rule_action,
            "rule_number": rule_number,
            "source_cidr_block": source_cidr_block,
            "traffic_direction": traffic_direction,
            "traffic_mirror_filter_id": traffic_mirror_filter_id,
        }
        if description is not None:
            self._values["description"] = description
        if destination_port_range is not None:
            self._values["destination_port_range"] = destination_port_range
        if protocol is not None:
            self._values["protocol"] = protocol
        if source_port_range is not None:
            self._values["source_port_range"] = source_port_range

    @builtins.property
    def destination_cidr_block(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationcidrblock
        """
        result = self._values.get("destination_cidr_block")
        assert result is not None, "Required property 'destination_cidr_block' is missing"
        return result

    @builtins.property
    def rule_action(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.RuleAction``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-ruleaction
        """
        result = self._values.get("rule_action")
        assert result is not None, "Required property 'rule_action' is missing"
        return result

    @builtins.property
    def rule_number(self) -> jsii.Number:
        """``AWS::EC2::TrafficMirrorFilterRule.RuleNumber``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-rulenumber
        """
        result = self._values.get("rule_number")
        assert result is not None, "Required property 'rule_number' is missing"
        return result

    @builtins.property
    def source_cidr_block(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.SourceCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourcecidrblock
        """
        result = self._values.get("source_cidr_block")
        assert result is not None, "Required property 'source_cidr_block' is missing"
        return result

    @builtins.property
    def traffic_direction(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.TrafficDirection``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficdirection
        """
        result = self._values.get("traffic_direction")
        assert result is not None, "Required property 'traffic_direction' is missing"
        return result

    @builtins.property
    def traffic_mirror_filter_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorFilterRule.TrafficMirrorFilterId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-trafficmirrorfilterid
        """
        result = self._values.get("traffic_mirror_filter_id")
        assert result is not None, "Required property 'traffic_mirror_filter_id' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorFilterRule.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def destination_port_range(
        self,
    ) -> typing.Optional[typing.Union["CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::TrafficMirrorFilterRule.DestinationPortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-destinationportrange
        """
        result = self._values.get("destination_port_range")
        return result

    @builtins.property
    def protocol(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TrafficMirrorFilterRule.Protocol``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-protocol
        """
        result = self._values.get("protocol")
        return result

    @builtins.property
    def source_port_range(
        self,
    ) -> typing.Optional[typing.Union["CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty", _IResolvable_9ceae33e]]:
        """``AWS::EC2::TrafficMirrorFilterRule.SourcePortRange``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorfilterrule.html#cfn-ec2-trafficmirrorfilterrule-sourceportrange
        """
        result = self._values.get("source_port_range")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTrafficMirrorFilterRuleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTrafficMirrorSession(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorSession",
):
    """A CloudFormation ``AWS::EC2::TrafficMirrorSession``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TrafficMirrorSession
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        network_interface_id: builtins.str,
        session_number: jsii.Number,
        traffic_mirror_filter_id: builtins.str,
        traffic_mirror_target_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        packet_length: typing.Optional[jsii.Number] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        virtual_network_id: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TrafficMirrorSession``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param network_interface_id: ``AWS::EC2::TrafficMirrorSession.NetworkInterfaceId``.
        :param session_number: ``AWS::EC2::TrafficMirrorSession.SessionNumber``.
        :param traffic_mirror_filter_id: ``AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId``.
        :param traffic_mirror_target_id: ``AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId``.
        :param description: ``AWS::EC2::TrafficMirrorSession.Description``.
        :param packet_length: ``AWS::EC2::TrafficMirrorSession.PacketLength``.
        :param tags: ``AWS::EC2::TrafficMirrorSession.Tags``.
        :param virtual_network_id: ``AWS::EC2::TrafficMirrorSession.VirtualNetworkId``.
        """
        props = CfnTrafficMirrorSessionProps(
            network_interface_id=network_interface_id,
            session_number=session_number,
            traffic_mirror_filter_id=traffic_mirror_filter_id,
            traffic_mirror_target_id=traffic_mirror_target_id,
            description=description,
            packet_length=packet_length,
            tags=tags,
            virtual_network_id=virtual_network_id,
        )

        jsii.create(CfnTrafficMirrorSession, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::TrafficMirrorSession.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaceId")
    def network_interface_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorSession.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
        """
        return jsii.get(self, "networkInterfaceId")

    @network_interface_id.setter # type: ignore
    def network_interface_id(self, value: builtins.str) -> None:
        jsii.set(self, "networkInterfaceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="sessionNumber")
    def session_number(self) -> jsii.Number:
        """``AWS::EC2::TrafficMirrorSession.SessionNumber``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
        """
        return jsii.get(self, "sessionNumber")

    @session_number.setter # type: ignore
    def session_number(self, value: jsii.Number) -> None:
        jsii.set(self, "sessionNumber", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
        """
        return jsii.get(self, "trafficMirrorFilterId")

    @traffic_mirror_filter_id.setter # type: ignore
    def traffic_mirror_filter_id(self, value: builtins.str) -> None:
        jsii.set(self, "trafficMirrorFilterId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
        """
        return jsii.get(self, "trafficMirrorTargetId")

    @traffic_mirror_target_id.setter # type: ignore
    def traffic_mirror_target_id(self, value: builtins.str) -> None:
        jsii.set(self, "trafficMirrorTargetId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorSession.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="packetLength")
    def packet_length(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TrafficMirrorSession.PacketLength``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
        """
        return jsii.get(self, "packetLength")

    @packet_length.setter # type: ignore
    def packet_length(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "packetLength", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="virtualNetworkId")
    def virtual_network_id(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TrafficMirrorSession.VirtualNetworkId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
        """
        return jsii.get(self, "virtualNetworkId")

    @virtual_network_id.setter # type: ignore
    def virtual_network_id(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "virtualNetworkId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorSessionProps",
    jsii_struct_bases=[],
    name_mapping={
        "network_interface_id": "networkInterfaceId",
        "session_number": "sessionNumber",
        "traffic_mirror_filter_id": "trafficMirrorFilterId",
        "traffic_mirror_target_id": "trafficMirrorTargetId",
        "description": "description",
        "packet_length": "packetLength",
        "tags": "tags",
        "virtual_network_id": "virtualNetworkId",
    },
)
class CfnTrafficMirrorSessionProps:
    def __init__(
        self,
        *,
        network_interface_id: builtins.str,
        session_number: jsii.Number,
        traffic_mirror_filter_id: builtins.str,
        traffic_mirror_target_id: builtins.str,
        description: typing.Optional[builtins.str] = None,
        packet_length: typing.Optional[jsii.Number] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        virtual_network_id: typing.Optional[jsii.Number] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TrafficMirrorSession``.

        :param network_interface_id: ``AWS::EC2::TrafficMirrorSession.NetworkInterfaceId``.
        :param session_number: ``AWS::EC2::TrafficMirrorSession.SessionNumber``.
        :param traffic_mirror_filter_id: ``AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId``.
        :param traffic_mirror_target_id: ``AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId``.
        :param description: ``AWS::EC2::TrafficMirrorSession.Description``.
        :param packet_length: ``AWS::EC2::TrafficMirrorSession.PacketLength``.
        :param tags: ``AWS::EC2::TrafficMirrorSession.Tags``.
        :param virtual_network_id: ``AWS::EC2::TrafficMirrorSession.VirtualNetworkId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "network_interface_id": network_interface_id,
            "session_number": session_number,
            "traffic_mirror_filter_id": traffic_mirror_filter_id,
            "traffic_mirror_target_id": traffic_mirror_target_id,
        }
        if description is not None:
            self._values["description"] = description
        if packet_length is not None:
            self._values["packet_length"] = packet_length
        if tags is not None:
            self._values["tags"] = tags
        if virtual_network_id is not None:
            self._values["virtual_network_id"] = virtual_network_id

    @builtins.property
    def network_interface_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorSession.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
        """
        result = self._values.get("network_interface_id")
        assert result is not None, "Required property 'network_interface_id' is missing"
        return result

    @builtins.property
    def session_number(self) -> jsii.Number:
        """``AWS::EC2::TrafficMirrorSession.SessionNumber``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
        """
        result = self._values.get("session_number")
        assert result is not None, "Required property 'session_number' is missing"
        return result

    @builtins.property
    def traffic_mirror_filter_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
        """
        result = self._values.get("traffic_mirror_filter_id")
        assert result is not None, "Required property 'traffic_mirror_filter_id' is missing"
        return result

    @builtins.property
    def traffic_mirror_target_id(self) -> builtins.str:
        """``AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
        """
        result = self._values.get("traffic_mirror_target_id")
        assert result is not None, "Required property 'traffic_mirror_target_id' is missing"
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorSession.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def packet_length(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TrafficMirrorSession.PacketLength``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
        """
        result = self._values.get("packet_length")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::TrafficMirrorSession.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def virtual_network_id(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TrafficMirrorSession.VirtualNetworkId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
        """
        result = self._values.get("virtual_network_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTrafficMirrorSessionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTrafficMirrorTarget(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorTarget",
):
    """A CloudFormation ``AWS::EC2::TrafficMirrorTarget``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TrafficMirrorTarget
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        description: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        network_load_balancer_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TrafficMirrorTarget``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param description: ``AWS::EC2::TrafficMirrorTarget.Description``.
        :param network_interface_id: ``AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId``.
        :param network_load_balancer_arn: ``AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn``.
        :param tags: ``AWS::EC2::TrafficMirrorTarget.Tags``.
        """
        props = CfnTrafficMirrorTargetProps(
            description=description,
            network_interface_id=network_interface_id,
            network_load_balancer_arn=network_load_balancer_arn,
            tags=tags,
        )

        jsii.create(CfnTrafficMirrorTarget, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::TrafficMirrorTarget.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorTarget.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkInterfaceId")
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkinterfaceid
        """
        return jsii.get(self, "networkInterfaceId")

    @network_interface_id.setter # type: ignore
    def network_interface_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "networkInterfaceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkLoadBalancerArn")
    def network_load_balancer_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkloadbalancerarn
        """
        return jsii.get(self, "networkLoadBalancerArn")

    @network_load_balancer_arn.setter # type: ignore
    def network_load_balancer_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "networkLoadBalancerArn", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTrafficMirrorTargetProps",
    jsii_struct_bases=[],
    name_mapping={
        "description": "description",
        "network_interface_id": "networkInterfaceId",
        "network_load_balancer_arn": "networkLoadBalancerArn",
        "tags": "tags",
    },
)
class CfnTrafficMirrorTargetProps:
    def __init__(
        self,
        *,
        description: typing.Optional[builtins.str] = None,
        network_interface_id: typing.Optional[builtins.str] = None,
        network_load_balancer_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TrafficMirrorTarget``.

        :param description: ``AWS::EC2::TrafficMirrorTarget.Description``.
        :param network_interface_id: ``AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId``.
        :param network_load_balancer_arn: ``AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn``.
        :param tags: ``AWS::EC2::TrafficMirrorTarget.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if description is not None:
            self._values["description"] = description
        if network_interface_id is not None:
            self._values["network_interface_id"] = network_interface_id
        if network_load_balancer_arn is not None:
            self._values["network_load_balancer_arn"] = network_load_balancer_arn
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorTarget.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def network_interface_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorTarget.NetworkInterfaceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkinterfaceid
        """
        result = self._values.get("network_interface_id")
        return result

    @builtins.property
    def network_load_balancer_arn(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TrafficMirrorTarget.NetworkLoadBalancerArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-networkloadbalancerarn
        """
        result = self._values.get("network_load_balancer_arn")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::TrafficMirrorTarget.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrortarget.html#cfn-ec2-trafficmirrortarget-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTrafficMirrorTargetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTransitGateway(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGateway",
):
    """A CloudFormation ``AWS::EC2::TransitGateway``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TransitGateway
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        amazon_side_asn: typing.Optional[jsii.Number] = None,
        auto_accept_shared_attachments: typing.Optional[builtins.str] = None,
        default_route_table_association: typing.Optional[builtins.str] = None,
        default_route_table_propagation: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        dns_support: typing.Optional[builtins.str] = None,
        multicast_support: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        vpn_ecmp_support: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TransitGateway``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param amazon_side_asn: ``AWS::EC2::TransitGateway.AmazonSideAsn``.
        :param auto_accept_shared_attachments: ``AWS::EC2::TransitGateway.AutoAcceptSharedAttachments``.
        :param default_route_table_association: ``AWS::EC2::TransitGateway.DefaultRouteTableAssociation``.
        :param default_route_table_propagation: ``AWS::EC2::TransitGateway.DefaultRouteTablePropagation``.
        :param description: ``AWS::EC2::TransitGateway.Description``.
        :param dns_support: ``AWS::EC2::TransitGateway.DnsSupport``.
        :param multicast_support: ``AWS::EC2::TransitGateway.MulticastSupport``.
        :param tags: ``AWS::EC2::TransitGateway.Tags``.
        :param vpn_ecmp_support: ``AWS::EC2::TransitGateway.VpnEcmpSupport``.
        """
        props = CfnTransitGatewayProps(
            amazon_side_asn=amazon_side_asn,
            auto_accept_shared_attachments=auto_accept_shared_attachments,
            default_route_table_association=default_route_table_association,
            default_route_table_propagation=default_route_table_propagation,
            description=description,
            dns_support=dns_support,
            multicast_support=multicast_support,
            tags=tags,
            vpn_ecmp_support=vpn_ecmp_support,
        )

        jsii.create(CfnTransitGateway, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::TransitGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="amazonSideAsn")
    def amazon_side_asn(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TransitGateway.AmazonSideAsn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
        """
        return jsii.get(self, "amazonSideAsn")

    @amazon_side_asn.setter # type: ignore
    def amazon_side_asn(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "amazonSideAsn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="autoAcceptSharedAttachments")
    def auto_accept_shared_attachments(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.AutoAcceptSharedAttachments``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
        """
        return jsii.get(self, "autoAcceptSharedAttachments")

    @auto_accept_shared_attachments.setter # type: ignore
    def auto_accept_shared_attachments(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "autoAcceptSharedAttachments", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultRouteTableAssociation")
    def default_route_table_association(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.DefaultRouteTableAssociation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
        """
        return jsii.get(self, "defaultRouteTableAssociation")

    @default_route_table_association.setter # type: ignore
    def default_route_table_association(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "defaultRouteTableAssociation", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="defaultRouteTablePropagation")
    def default_route_table_propagation(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.DefaultRouteTablePropagation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
        """
        return jsii.get(self, "defaultRouteTablePropagation")

    @default_route_table_propagation.setter # type: ignore
    def default_route_table_propagation(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "defaultRouteTablePropagation", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
        """
        return jsii.get(self, "description")

    @description.setter # type: ignore
    def description(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="dnsSupport")
    def dns_support(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.DnsSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
        """
        return jsii.get(self, "dnsSupport")

    @dns_support.setter # type: ignore
    def dns_support(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "dnsSupport", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="multicastSupport")
    def multicast_support(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.MulticastSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-multicastsupport
        """
        return jsii.get(self, "multicastSupport")

    @multicast_support.setter # type: ignore
    def multicast_support(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "multicastSupport", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpnEcmpSupport")
    def vpn_ecmp_support(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.VpnEcmpSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
        """
        return jsii.get(self, "vpnEcmpSupport")

    @vpn_ecmp_support.setter # type: ignore
    def vpn_ecmp_support(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "vpnEcmpSupport", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnTransitGatewayAttachment(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayAttachment",
):
    """A CloudFormation ``AWS::EC2::TransitGatewayAttachment``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TransitGatewayAttachment
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        subnet_ids: typing.List[builtins.str],
        transit_gateway_id: builtins.str,
        vpc_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TransitGatewayAttachment``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param subnet_ids: ``AWS::EC2::TransitGatewayAttachment.SubnetIds``.
        :param transit_gateway_id: ``AWS::EC2::TransitGatewayAttachment.TransitGatewayId``.
        :param vpc_id: ``AWS::EC2::TransitGatewayAttachment.VpcId``.
        :param tags: ``AWS::EC2::TransitGatewayAttachment.Tags``.
        """
        props = CfnTransitGatewayAttachmentProps(
            subnet_ids=subnet_ids,
            transit_gateway_id=transit_gateway_id,
            vpc_id=vpc_id,
            tags=tags,
        )

        jsii.create(CfnTransitGatewayAttachment, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::TransitGatewayAttachment.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.List[builtins.str]:
        """``AWS::EC2::TransitGatewayAttachment.SubnetIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
        """
        return jsii.get(self, "subnetIds")

    @subnet_ids.setter # type: ignore
    def subnet_ids(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "subnetIds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayId")
    def transit_gateway_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayAttachment.TransitGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
        """
        return jsii.get(self, "transitGatewayId")

    @transit_gateway_id.setter # type: ignore
    def transit_gateway_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayAttachment.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayAttachmentProps",
    jsii_struct_bases=[],
    name_mapping={
        "subnet_ids": "subnetIds",
        "transit_gateway_id": "transitGatewayId",
        "vpc_id": "vpcId",
        "tags": "tags",
    },
)
class CfnTransitGatewayAttachmentProps:
    def __init__(
        self,
        *,
        subnet_ids: typing.List[builtins.str],
        transit_gateway_id: builtins.str,
        vpc_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TransitGatewayAttachment``.

        :param subnet_ids: ``AWS::EC2::TransitGatewayAttachment.SubnetIds``.
        :param transit_gateway_id: ``AWS::EC2::TransitGatewayAttachment.TransitGatewayId``.
        :param vpc_id: ``AWS::EC2::TransitGatewayAttachment.VpcId``.
        :param tags: ``AWS::EC2::TransitGatewayAttachment.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "subnet_ids": subnet_ids,
            "transit_gateway_id": transit_gateway_id,
            "vpc_id": vpc_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def subnet_ids(self) -> typing.List[builtins.str]:
        """``AWS::EC2::TransitGatewayAttachment.SubnetIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
        """
        result = self._values.get("subnet_ids")
        assert result is not None, "Required property 'subnet_ids' is missing"
        return result

    @builtins.property
    def transit_gateway_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayAttachment.TransitGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
        """
        result = self._values.get("transit_gateway_id")
        assert result is not None, "Required property 'transit_gateway_id' is missing"
        return result

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayAttachment.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::TransitGatewayAttachment.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTransitGatewayAttachmentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayProps",
    jsii_struct_bases=[],
    name_mapping={
        "amazon_side_asn": "amazonSideAsn",
        "auto_accept_shared_attachments": "autoAcceptSharedAttachments",
        "default_route_table_association": "defaultRouteTableAssociation",
        "default_route_table_propagation": "defaultRouteTablePropagation",
        "description": "description",
        "dns_support": "dnsSupport",
        "multicast_support": "multicastSupport",
        "tags": "tags",
        "vpn_ecmp_support": "vpnEcmpSupport",
    },
)
class CfnTransitGatewayProps:
    def __init__(
        self,
        *,
        amazon_side_asn: typing.Optional[jsii.Number] = None,
        auto_accept_shared_attachments: typing.Optional[builtins.str] = None,
        default_route_table_association: typing.Optional[builtins.str] = None,
        default_route_table_propagation: typing.Optional[builtins.str] = None,
        description: typing.Optional[builtins.str] = None,
        dns_support: typing.Optional[builtins.str] = None,
        multicast_support: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
        vpn_ecmp_support: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TransitGateway``.

        :param amazon_side_asn: ``AWS::EC2::TransitGateway.AmazonSideAsn``.
        :param auto_accept_shared_attachments: ``AWS::EC2::TransitGateway.AutoAcceptSharedAttachments``.
        :param default_route_table_association: ``AWS::EC2::TransitGateway.DefaultRouteTableAssociation``.
        :param default_route_table_propagation: ``AWS::EC2::TransitGateway.DefaultRouteTablePropagation``.
        :param description: ``AWS::EC2::TransitGateway.Description``.
        :param dns_support: ``AWS::EC2::TransitGateway.DnsSupport``.
        :param multicast_support: ``AWS::EC2::TransitGateway.MulticastSupport``.
        :param tags: ``AWS::EC2::TransitGateway.Tags``.
        :param vpn_ecmp_support: ``AWS::EC2::TransitGateway.VpnEcmpSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
        """
        self._values: typing.Dict[str, typing.Any] = {}
        if amazon_side_asn is not None:
            self._values["amazon_side_asn"] = amazon_side_asn
        if auto_accept_shared_attachments is not None:
            self._values["auto_accept_shared_attachments"] = auto_accept_shared_attachments
        if default_route_table_association is not None:
            self._values["default_route_table_association"] = default_route_table_association
        if default_route_table_propagation is not None:
            self._values["default_route_table_propagation"] = default_route_table_propagation
        if description is not None:
            self._values["description"] = description
        if dns_support is not None:
            self._values["dns_support"] = dns_support
        if multicast_support is not None:
            self._values["multicast_support"] = multicast_support
        if tags is not None:
            self._values["tags"] = tags
        if vpn_ecmp_support is not None:
            self._values["vpn_ecmp_support"] = vpn_ecmp_support

    @builtins.property
    def amazon_side_asn(self) -> typing.Optional[jsii.Number]:
        """``AWS::EC2::TransitGateway.AmazonSideAsn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
        """
        result = self._values.get("amazon_side_asn")
        return result

    @builtins.property
    def auto_accept_shared_attachments(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.AutoAcceptSharedAttachments``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
        """
        result = self._values.get("auto_accept_shared_attachments")
        return result

    @builtins.property
    def default_route_table_association(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.DefaultRouteTableAssociation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
        """
        result = self._values.get("default_route_table_association")
        return result

    @builtins.property
    def default_route_table_propagation(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.DefaultRouteTablePropagation``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
        """
        result = self._values.get("default_route_table_propagation")
        return result

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.Description``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
        """
        result = self._values.get("description")
        return result

    @builtins.property
    def dns_support(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.DnsSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
        """
        result = self._values.get("dns_support")
        return result

    @builtins.property
    def multicast_support(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.MulticastSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-multicastsupport
        """
        result = self._values.get("multicast_support")
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::TransitGateway.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
        """
        result = self._values.get("tags")
        return result

    @builtins.property
    def vpn_ecmp_support(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGateway.VpnEcmpSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
        """
        result = self._values.get("vpn_ecmp_support")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTransitGatewayProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTransitGatewayRoute(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRoute",
):
    """A CloudFormation ``AWS::EC2::TransitGatewayRoute``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TransitGatewayRoute
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        transit_gateway_route_table_id: builtins.str,
        blackhole: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        destination_cidr_block: typing.Optional[builtins.str] = None,
        transit_gateway_attachment_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TransitGatewayRoute``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param transit_gateway_route_table_id: ``AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId``.
        :param blackhole: ``AWS::EC2::TransitGatewayRoute.Blackhole``.
        :param destination_cidr_block: ``AWS::EC2::TransitGatewayRoute.DestinationCidrBlock``.
        :param transit_gateway_attachment_id: ``AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId``.
        """
        props = CfnTransitGatewayRouteProps(
            transit_gateway_route_table_id=transit_gateway_route_table_id,
            blackhole=blackhole,
            destination_cidr_block=destination_cidr_block,
            transit_gateway_attachment_id=transit_gateway_attachment_id,
        )

        jsii.create(CfnTransitGatewayRoute, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
        """
        return jsii.get(self, "transitGatewayRouteTableId")

    @transit_gateway_route_table_id.setter # type: ignore
    def transit_gateway_route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayRouteTableId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="blackhole")
    def blackhole(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::TransitGatewayRoute.Blackhole``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
        """
        return jsii.get(self, "blackhole")

    @blackhole.setter # type: ignore
    def blackhole(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "blackhole", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="destinationCidrBlock")
    def destination_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGatewayRoute.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
        """
        return jsii.get(self, "destinationCidrBlock")

    @destination_cidr_block.setter # type: ignore
    def destination_cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "destinationCidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
        """
        return jsii.get(self, "transitGatewayAttachmentId")

    @transit_gateway_attachment_id.setter # type: ignore
    def transit_gateway_attachment_id(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        jsii.set(self, "transitGatewayAttachmentId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteProps",
    jsii_struct_bases=[],
    name_mapping={
        "transit_gateway_route_table_id": "transitGatewayRouteTableId",
        "blackhole": "blackhole",
        "destination_cidr_block": "destinationCidrBlock",
        "transit_gateway_attachment_id": "transitGatewayAttachmentId",
    },
)
class CfnTransitGatewayRouteProps:
    def __init__(
        self,
        *,
        transit_gateway_route_table_id: builtins.str,
        blackhole: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        destination_cidr_block: typing.Optional[builtins.str] = None,
        transit_gateway_attachment_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TransitGatewayRoute``.

        :param transit_gateway_route_table_id: ``AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId``.
        :param blackhole: ``AWS::EC2::TransitGatewayRoute.Blackhole``.
        :param destination_cidr_block: ``AWS::EC2::TransitGatewayRoute.DestinationCidrBlock``.
        :param transit_gateway_attachment_id: ``AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "transit_gateway_route_table_id": transit_gateway_route_table_id,
        }
        if blackhole is not None:
            self._values["blackhole"] = blackhole
        if destination_cidr_block is not None:
            self._values["destination_cidr_block"] = destination_cidr_block
        if transit_gateway_attachment_id is not None:
            self._values["transit_gateway_attachment_id"] = transit_gateway_attachment_id

    @builtins.property
    def transit_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
        """
        result = self._values.get("transit_gateway_route_table_id")
        assert result is not None, "Required property 'transit_gateway_route_table_id' is missing"
        return result

    @builtins.property
    def blackhole(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::TransitGatewayRoute.Blackhole``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
        """
        result = self._values.get("blackhole")
        return result

    @builtins.property
    def destination_cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGatewayRoute.DestinationCidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
        """
        result = self._values.get("destination_cidr_block")
        return result

    @builtins.property
    def transit_gateway_attachment_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
        """
        result = self._values.get("transit_gateway_attachment_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTransitGatewayRouteProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTransitGatewayRouteTable(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteTable",
):
    """A CloudFormation ``AWS::EC2::TransitGatewayRouteTable``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TransitGatewayRouteTable
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        transit_gateway_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::TransitGatewayRouteTable``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param transit_gateway_id: ``AWS::EC2::TransitGatewayRouteTable.TransitGatewayId``.
        :param tags: ``AWS::EC2::TransitGatewayRouteTable.Tags``.
        """
        props = CfnTransitGatewayRouteTableProps(
            transit_gateway_id=transit_gateway_id, tags=tags
        )

        jsii.create(CfnTransitGatewayRouteTable, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::TransitGatewayRouteTable.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayId")
    def transit_gateway_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTable.TransitGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
        """
        return jsii.get(self, "transitGatewayId")

    @transit_gateway_id.setter # type: ignore
    def transit_gateway_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayId", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnTransitGatewayRouteTableAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteTableAssociation",
):
    """A CloudFormation ``AWS::EC2::TransitGatewayRouteTableAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TransitGatewayRouteTableAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        transit_gateway_attachment_id: builtins.str,
        transit_gateway_route_table_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::TransitGatewayRouteTableAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param transit_gateway_attachment_id: ``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId``.
        :param transit_gateway_route_table_id: ``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId``.
        """
        props = CfnTransitGatewayRouteTableAssociationProps(
            transit_gateway_attachment_id=transit_gateway_attachment_id,
            transit_gateway_route_table_id=transit_gateway_route_table_id,
        )

        jsii.create(CfnTransitGatewayRouteTableAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
        """
        return jsii.get(self, "transitGatewayAttachmentId")

    @transit_gateway_attachment_id.setter # type: ignore
    def transit_gateway_attachment_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayAttachmentId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
        """
        return jsii.get(self, "transitGatewayRouteTableId")

    @transit_gateway_route_table_id.setter # type: ignore
    def transit_gateway_route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayRouteTableId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteTableAssociationProps",
    jsii_struct_bases=[],
    name_mapping={
        "transit_gateway_attachment_id": "transitGatewayAttachmentId",
        "transit_gateway_route_table_id": "transitGatewayRouteTableId",
    },
)
class CfnTransitGatewayRouteTableAssociationProps:
    def __init__(
        self,
        *,
        transit_gateway_attachment_id: builtins.str,
        transit_gateway_route_table_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TransitGatewayRouteTableAssociation``.

        :param transit_gateway_attachment_id: ``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId``.
        :param transit_gateway_route_table_id: ``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "transit_gateway_attachment_id": transit_gateway_attachment_id,
            "transit_gateway_route_table_id": transit_gateway_route_table_id,
        }

    @builtins.property
    def transit_gateway_attachment_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
        """
        result = self._values.get("transit_gateway_attachment_id")
        assert result is not None, "Required property 'transit_gateway_attachment_id' is missing"
        return result

    @builtins.property
    def transit_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
        """
        result = self._values.get("transit_gateway_route_table_id")
        assert result is not None, "Required property 'transit_gateway_route_table_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTransitGatewayRouteTableAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnTransitGatewayRouteTablePropagation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteTablePropagation",
):
    """A CloudFormation ``AWS::EC2::TransitGatewayRouteTablePropagation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::TransitGatewayRouteTablePropagation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        transit_gateway_attachment_id: builtins.str,
        transit_gateway_route_table_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::TransitGatewayRouteTablePropagation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param transit_gateway_attachment_id: ``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId``.
        :param transit_gateway_route_table_id: ``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId``.
        """
        props = CfnTransitGatewayRouteTablePropagationProps(
            transit_gateway_attachment_id=transit_gateway_attachment_id,
            transit_gateway_route_table_id=transit_gateway_route_table_id,
        )

        jsii.create(CfnTransitGatewayRouteTablePropagation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayAttachmentId")
    def transit_gateway_attachment_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
        """
        return jsii.get(self, "transitGatewayAttachmentId")

    @transit_gateway_attachment_id.setter # type: ignore
    def transit_gateway_attachment_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayAttachmentId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
        """
        return jsii.get(self, "transitGatewayRouteTableId")

    @transit_gateway_route_table_id.setter # type: ignore
    def transit_gateway_route_table_id(self, value: builtins.str) -> None:
        jsii.set(self, "transitGatewayRouteTableId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteTablePropagationProps",
    jsii_struct_bases=[],
    name_mapping={
        "transit_gateway_attachment_id": "transitGatewayAttachmentId",
        "transit_gateway_route_table_id": "transitGatewayRouteTableId",
    },
)
class CfnTransitGatewayRouteTablePropagationProps:
    def __init__(
        self,
        *,
        transit_gateway_attachment_id: builtins.str,
        transit_gateway_route_table_id: builtins.str,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TransitGatewayRouteTablePropagation``.

        :param transit_gateway_attachment_id: ``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId``.
        :param transit_gateway_route_table_id: ``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "transit_gateway_attachment_id": transit_gateway_attachment_id,
            "transit_gateway_route_table_id": transit_gateway_route_table_id,
        }

    @builtins.property
    def transit_gateway_attachment_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
        """
        result = self._values.get("transit_gateway_attachment_id")
        assert result is not None, "Required property 'transit_gateway_attachment_id' is missing"
        return result

    @builtins.property
    def transit_gateway_route_table_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
        """
        result = self._values.get("transit_gateway_route_table_id")
        assert result is not None, "Required property 'transit_gateway_route_table_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTransitGatewayRouteTablePropagationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnTransitGatewayRouteTableProps",
    jsii_struct_bases=[],
    name_mapping={"transit_gateway_id": "transitGatewayId", "tags": "tags"},
)
class CfnTransitGatewayRouteTableProps:
    def __init__(
        self,
        *,
        transit_gateway_id: builtins.str,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::TransitGatewayRouteTable``.

        :param transit_gateway_id: ``AWS::EC2::TransitGatewayRouteTable.TransitGatewayId``.
        :param tags: ``AWS::EC2::TransitGatewayRouteTable.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "transit_gateway_id": transit_gateway_id,
        }
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def transit_gateway_id(self) -> builtins.str:
        """``AWS::EC2::TransitGatewayRouteTable.TransitGatewayId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
        """
        result = self._values.get("transit_gateway_id")
        assert result is not None, "Required property 'transit_gateway_id' is missing"
        return result

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_b4661f1a]]:
        """``AWS::EC2::TransitGatewayRouteTable.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
        """
        result = self._values.get("tags")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnTransitGatewayRouteTableProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPC(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPC",
):
    """A CloudFormation ``AWS::EC2::VPC``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPC
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        cidr_block: builtins.str,
        enable_dns_hostnames: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        enable_dns_support: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        instance_tenancy: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.List[_CfnTag_b4661f1a]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::VPC``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param cidr_block: ``AWS::EC2::VPC.CidrBlock``.
        :param enable_dns_hostnames: ``AWS::EC2::VPC.EnableDnsHostnames``.
        :param enable_dns_support: ``AWS::EC2::VPC.EnableDnsSupport``.
        :param instance_tenancy: ``AWS::EC2::VPC.InstanceTenancy``.
        :param tags: ``AWS::EC2::VPC.Tags``.
        """
        props = CfnVPCProps(
            cidr_block=cidr_block,
            enable_dns_hostnames=enable_dns_hostnames,
            enable_dns_support=enable_dns_support,
            instance_tenancy=instance_tenancy,
            tags=tags,
        )

        jsii.create(CfnVPC, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrCidrBlock")
    def attr_cidr_block(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: CidrBlock
        """
        return jsii.get(self, "attrCidrBlock")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrCidrBlockAssociations")
    def attr_cidr_block_associations(self) -> typing.List[builtins.str]:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: CidrBlockAssociations
        """
        return jsii.get(self, "attrCidrBlockAssociations")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrDefaultNetworkAcl")
    def attr_default_network_acl(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: DefaultNetworkAcl
        """
        return jsii.get(self, "attrDefaultNetworkAcl")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrDefaultSecurityGroup")
    def attr_default_security_group(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: DefaultSecurityGroup
        """
        return jsii.get(self, "attrDefaultSecurityGroup")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrIpv6CidrBlocks")
    def attr_ipv6_cidr_blocks(self) -> typing.List[builtins.str]:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: Ipv6CidrBlocks
        """
        return jsii.get(self, "attrIpv6CidrBlocks")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_2508893f:
        """``AWS::EC2::VPC.Tags``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
        """
        return jsii.get(self, "tags")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrBlock")
    def cidr_block(self) -> builtins.str:
        """``AWS::EC2::VPC.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
        """
        return jsii.get(self, "cidrBlock")

    @cidr_block.setter # type: ignore
    def cidr_block(self, value: builtins.str) -> None:
        jsii.set(self, "cidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enableDnsHostnames")
    def enable_dns_hostnames(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPC.EnableDnsHostnames``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
        """
        return jsii.get(self, "enableDnsHostnames")

    @enable_dns_hostnames.setter # type: ignore
    def enable_dns_hostnames(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "enableDnsHostnames", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="enableDnsSupport")
    def enable_dns_support(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPC.EnableDnsSupport``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
        """
        return jsii.get(self, "enableDnsSupport")

    @enable_dns_support.setter # type: ignore
    def enable_dns_support(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "enableDnsSupport", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="instanceTenancy")
    def instance_tenancy(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPC.InstanceTenancy``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
        """
        return jsii.get(self, "instanceTenancy")

    @instance_tenancy.setter # type: ignore
    def instance_tenancy(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "instanceTenancy", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPCCidrBlock(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCCidrBlock",
):
    """A CloudFormation ``AWS::EC2::VPCCidrBlock``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPCCidrBlock
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        vpc_id: builtins.str,
        amazon_provided_ipv6_cidr_block: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        cidr_block: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::VPCCidrBlock``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param vpc_id: ``AWS::EC2::VPCCidrBlock.VpcId``.
        :param amazon_provided_ipv6_cidr_block: ``AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock``.
        :param cidr_block: ``AWS::EC2::VPCCidrBlock.CidrBlock``.
        """
        props = CfnVPCCidrBlockProps(
            vpc_id=vpc_id,
            amazon_provided_ipv6_cidr_block=amazon_provided_ipv6_cidr_block,
            cidr_block=cidr_block,
        )

        jsii.create(CfnVPCCidrBlock, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::VPCCidrBlock.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="amazonProvidedIpv6CidrBlock")
    def amazon_provided_ipv6_cidr_block(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
        """
        return jsii.get(self, "amazonProvidedIpv6CidrBlock")

    @amazon_provided_ipv6_cidr_block.setter # type: ignore
    def amazon_provided_ipv6_cidr_block(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "amazonProvidedIpv6CidrBlock", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cidrBlock")
    def cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCCidrBlock.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
        """
        return jsii.get(self, "cidrBlock")

    @cidr_block.setter # type: ignore
    def cidr_block(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "cidrBlock", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCCidrBlockProps",
    jsii_struct_bases=[],
    name_mapping={
        "vpc_id": "vpcId",
        "amazon_provided_ipv6_cidr_block": "amazonProvidedIpv6CidrBlock",
        "cidr_block": "cidrBlock",
    },
)
class CfnVPCCidrBlockProps:
    def __init__(
        self,
        *,
        vpc_id: builtins.str,
        amazon_provided_ipv6_cidr_block: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        cidr_block: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::VPCCidrBlock``.

        :param vpc_id: ``AWS::EC2::VPCCidrBlock.VpcId``.
        :param amazon_provided_ipv6_cidr_block: ``AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock``.
        :param cidr_block: ``AWS::EC2::VPCCidrBlock.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "vpc_id": vpc_id,
        }
        if amazon_provided_ipv6_cidr_block is not None:
            self._values["amazon_provided_ipv6_cidr_block"] = amazon_provided_ipv6_cidr_block
        if cidr_block is not None:
            self._values["cidr_block"] = cidr_block

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::VPCCidrBlock.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def amazon_provided_ipv6_cidr_block(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
        """
        result = self._values.get("amazon_provided_ipv6_cidr_block")
        return result

    @builtins.property
    def cidr_block(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCCidrBlock.CidrBlock``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
        """
        result = self._values.get("cidr_block")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVPCCidrBlockProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPCDHCPOptionsAssociation(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCDHCPOptionsAssociation",
):
    """A CloudFormation ``AWS::EC2::VPCDHCPOptionsAssociation``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPCDHCPOptionsAssociation
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        dhcp_options_id: builtins.str,
        vpc_id: builtins.str,
    ) -> None:
        """Create a new ``AWS::EC2::VPCDHCPOptionsAssociation``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param dhcp_options_id: ``AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId``.
        :param vpc_id: ``AWS::EC2::VPCDHCPOptionsAssociation.VpcId``.
        """
        props = CfnVPCDHCPOptionsAssociationProps(
            dhcp_options_id=dhcp_options_id, vpc_id=vpc_id
        )

        jsii.create(CfnVPCDHCPOptionsAssociation, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="dhcpOptionsId")
    def dhcp_options_id(self) -> builtins.str:
        """``AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
        """
        return jsii.get(self, "dhcpOptionsId")

    @dhcp_options_id.setter # type: ignore
    def dhcp_options_id(self, value: builtins.str) -> None:
        jsii.set(self, "dhcpOptionsId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::VPCDHCPOptionsAssociation.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCDHCPOptionsAssociationProps",
    jsii_struct_bases=[],
    name_mapping={"dhcp_options_id": "dhcpOptionsId", "vpc_id": "vpcId"},
)
class CfnVPCDHCPOptionsAssociationProps:
    def __init__(self, *, dhcp_options_id: builtins.str, vpc_id: builtins.str) -> None:
        """Properties for defining a ``AWS::EC2::VPCDHCPOptionsAssociation``.

        :param dhcp_options_id: ``AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId``.
        :param vpc_id: ``AWS::EC2::VPCDHCPOptionsAssociation.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "dhcp_options_id": dhcp_options_id,
            "vpc_id": vpc_id,
        }

    @builtins.property
    def dhcp_options_id(self) -> builtins.str:
        """``AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
        """
        result = self._values.get("dhcp_options_id")
        assert result is not None, "Required property 'dhcp_options_id' is missing"
        return result

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::VPCDHCPOptionsAssociation.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVPCDHCPOptionsAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPCEndpoint(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpoint",
):
    """A CloudFormation ``AWS::EC2::VPCEndpoint``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPCEndpoint
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        service_name: builtins.str,
        vpc_id: builtins.str,
        policy_document: typing.Any = None,
        private_dns_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        route_table_ids: typing.Optional[typing.List[builtins.str]] = None,
        security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
        subnet_ids: typing.Optional[typing.List[builtins.str]] = None,
        vpc_endpoint_type: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::VPCEndpoint``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param service_name: ``AWS::EC2::VPCEndpoint.ServiceName``.
        :param vpc_id: ``AWS::EC2::VPCEndpoint.VpcId``.
        :param policy_document: ``AWS::EC2::VPCEndpoint.PolicyDocument``.
        :param private_dns_enabled: ``AWS::EC2::VPCEndpoint.PrivateDnsEnabled``.
        :param route_table_ids: ``AWS::EC2::VPCEndpoint.RouteTableIds``.
        :param security_group_ids: ``AWS::EC2::VPCEndpoint.SecurityGroupIds``.
        :param subnet_ids: ``AWS::EC2::VPCEndpoint.SubnetIds``.
        :param vpc_endpoint_type: ``AWS::EC2::VPCEndpoint.VpcEndpointType``.
        """
        props = CfnVPCEndpointProps(
            service_name=service_name,
            vpc_id=vpc_id,
            policy_document=policy_document,
            private_dns_enabled=private_dns_enabled,
            route_table_ids=route_table_ids,
            security_group_ids=security_group_ids,
            subnet_ids=subnet_ids,
            vpc_endpoint_type=vpc_endpoint_type,
        )

        jsii.create(CfnVPCEndpoint, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrCreationTimestamp")
    def attr_creation_timestamp(self) -> builtins.str:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: CreationTimestamp
        """
        return jsii.get(self, "attrCreationTimestamp")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrDnsEntries")
    def attr_dns_entries(self) -> typing.List[builtins.str]:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: DnsEntries
        """
        return jsii.get(self, "attrDnsEntries")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="attrNetworkInterfaceIds")
    def attr_network_interface_ids(self) -> typing.List[builtins.str]:
        """
        cloudformationAttribute:
        :cloudformationAttribute:: NetworkInterfaceIds
        """
        return jsii.get(self, "attrNetworkInterfaceIds")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="policyDocument")
    def policy_document(self) -> typing.Any:
        """``AWS::EC2::VPCEndpoint.PolicyDocument``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
        """
        return jsii.get(self, "policyDocument")

    @policy_document.setter # type: ignore
    def policy_document(self, value: typing.Any) -> None:
        jsii.set(self, "policyDocument", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceName")
    def service_name(self) -> builtins.str:
        """``AWS::EC2::VPCEndpoint.ServiceName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
        """
        return jsii.get(self, "serviceName")

    @service_name.setter # type: ignore
    def service_name(self, value: builtins.str) -> None:
        jsii.set(self, "serviceName", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::VPCEndpoint.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
        """
        return jsii.get(self, "vpcId")

    @vpc_id.setter # type: ignore
    def vpc_id(self, value: builtins.str) -> None:
        jsii.set(self, "vpcId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="privateDnsEnabled")
    def private_dns_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPCEndpoint.PrivateDnsEnabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
        """
        return jsii.get(self, "privateDnsEnabled")

    @private_dns_enabled.setter # type: ignore
    def private_dns_enabled(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "privateDnsEnabled", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="routeTableIds")
    def route_table_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpoint.RouteTableIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
        """
        return jsii.get(self, "routeTableIds")

    @route_table_ids.setter # type: ignore
    def route_table_ids(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "routeTableIds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="securityGroupIds")
    def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpoint.SecurityGroupIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
        """
        return jsii.get(self, "securityGroupIds")

    @security_group_ids.setter # type: ignore
    def security_group_ids(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "securityGroupIds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpoint.SubnetIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
        """
        return jsii.get(self, "subnetIds")

    @subnet_ids.setter # type: ignore
    def subnet_ids(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        jsii.set(self, "subnetIds", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcEndpointType")
    def vpc_endpoint_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCEndpoint.VpcEndpointType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
        """
        return jsii.get(self, "vpcEndpointType")

    @vpc_endpoint_type.setter # type: ignore
    def vpc_endpoint_type(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "vpcEndpointType", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPCEndpointConnectionNotification(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointConnectionNotification",
):
    """A CloudFormation ``AWS::EC2::VPCEndpointConnectionNotification``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPCEndpointConnectionNotification
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        connection_events: typing.List[builtins.str],
        connection_notification_arn: builtins.str,
        service_id: typing.Optional[builtins.str] = None,
        vpc_endpoint_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Create a new ``AWS::EC2::VPCEndpointConnectionNotification``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param connection_events: ``AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents``.
        :param connection_notification_arn: ``AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn``.
        :param service_id: ``AWS::EC2::VPCEndpointConnectionNotification.ServiceId``.
        :param vpc_endpoint_id: ``AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId``.
        """
        props = CfnVPCEndpointConnectionNotificationProps(
            connection_events=connection_events,
            connection_notification_arn=connection_notification_arn,
            service_id=service_id,
            vpc_endpoint_id=vpc_endpoint_id,
        )

        jsii.create(CfnVPCEndpointConnectionNotification, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionEvents")
    def connection_events(self) -> typing.List[builtins.str]:
        """``AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
        """
        return jsii.get(self, "connectionEvents")

    @connection_events.setter # type: ignore
    def connection_events(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "connectionEvents", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="connectionNotificationArn")
    def connection_notification_arn(self) -> builtins.str:
        """``AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
        """
        return jsii.get(self, "connectionNotificationArn")

    @connection_notification_arn.setter # type: ignore
    def connection_notification_arn(self, value: builtins.str) -> None:
        jsii.set(self, "connectionNotificationArn", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceId")
    def service_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCEndpointConnectionNotification.ServiceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
        """
        return jsii.get(self, "serviceId")

    @service_id.setter # type: ignore
    def service_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "serviceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="vpcEndpointId")
    def vpc_endpoint_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
        """
        return jsii.get(self, "vpcEndpointId")

    @vpc_endpoint_id.setter # type: ignore
    def vpc_endpoint_id(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "vpcEndpointId", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointConnectionNotificationProps",
    jsii_struct_bases=[],
    name_mapping={
        "connection_events": "connectionEvents",
        "connection_notification_arn": "connectionNotificationArn",
        "service_id": "serviceId",
        "vpc_endpoint_id": "vpcEndpointId",
    },
)
class CfnVPCEndpointConnectionNotificationProps:
    def __init__(
        self,
        *,
        connection_events: typing.List[builtins.str],
        connection_notification_arn: builtins.str,
        service_id: typing.Optional[builtins.str] = None,
        vpc_endpoint_id: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::VPCEndpointConnectionNotification``.

        :param connection_events: ``AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents``.
        :param connection_notification_arn: ``AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn``.
        :param service_id: ``AWS::EC2::VPCEndpointConnectionNotification.ServiceId``.
        :param vpc_endpoint_id: ``AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "connection_events": connection_events,
            "connection_notification_arn": connection_notification_arn,
        }
        if service_id is not None:
            self._values["service_id"] = service_id
        if vpc_endpoint_id is not None:
            self._values["vpc_endpoint_id"] = vpc_endpoint_id

    @builtins.property
    def connection_events(self) -> typing.List[builtins.str]:
        """``AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
        """
        result = self._values.get("connection_events")
        assert result is not None, "Required property 'connection_events' is missing"
        return result

    @builtins.property
    def connection_notification_arn(self) -> builtins.str:
        """``AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
        """
        result = self._values.get("connection_notification_arn")
        assert result is not None, "Required property 'connection_notification_arn' is missing"
        return result

    @builtins.property
    def service_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCEndpointConnectionNotification.ServiceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
        """
        result = self._values.get("service_id")
        return result

    @builtins.property
    def vpc_endpoint_id(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
        """
        result = self._values.get("vpc_endpoint_id")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVPCEndpointConnectionNotificationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointProps",
    jsii_struct_bases=[],
    name_mapping={
        "service_name": "serviceName",
        "vpc_id": "vpcId",
        "policy_document": "policyDocument",
        "private_dns_enabled": "privateDnsEnabled",
        "route_table_ids": "routeTableIds",
        "security_group_ids": "securityGroupIds",
        "subnet_ids": "subnetIds",
        "vpc_endpoint_type": "vpcEndpointType",
    },
)
class CfnVPCEndpointProps:
    def __init__(
        self,
        *,
        service_name: builtins.str,
        vpc_id: builtins.str,
        policy_document: typing.Any = None,
        private_dns_enabled: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
        route_table_ids: typing.Optional[typing.List[builtins.str]] = None,
        security_group_ids: typing.Optional[typing.List[builtins.str]] = None,
        subnet_ids: typing.Optional[typing.List[builtins.str]] = None,
        vpc_endpoint_type: typing.Optional[builtins.str] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::VPCEndpoint``.

        :param service_name: ``AWS::EC2::VPCEndpoint.ServiceName``.
        :param vpc_id: ``AWS::EC2::VPCEndpoint.VpcId``.
        :param policy_document: ``AWS::EC2::VPCEndpoint.PolicyDocument``.
        :param private_dns_enabled: ``AWS::EC2::VPCEndpoint.PrivateDnsEnabled``.
        :param route_table_ids: ``AWS::EC2::VPCEndpoint.RouteTableIds``.
        :param security_group_ids: ``AWS::EC2::VPCEndpoint.SecurityGroupIds``.
        :param subnet_ids: ``AWS::EC2::VPCEndpoint.SubnetIds``.
        :param vpc_endpoint_type: ``AWS::EC2::VPCEndpoint.VpcEndpointType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "service_name": service_name,
            "vpc_id": vpc_id,
        }
        if policy_document is not None:
            self._values["policy_document"] = policy_document
        if private_dns_enabled is not None:
            self._values["private_dns_enabled"] = private_dns_enabled
        if route_table_ids is not None:
            self._values["route_table_ids"] = route_table_ids
        if security_group_ids is not None:
            self._values["security_group_ids"] = security_group_ids
        if subnet_ids is not None:
            self._values["subnet_ids"] = subnet_ids
        if vpc_endpoint_type is not None:
            self._values["vpc_endpoint_type"] = vpc_endpoint_type

    @builtins.property
    def service_name(self) -> builtins.str:
        """``AWS::EC2::VPCEndpoint.ServiceName``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
        """
        result = self._values.get("service_name")
        assert result is not None, "Required property 'service_name' is missing"
        return result

    @builtins.property
    def vpc_id(self) -> builtins.str:
        """``AWS::EC2::VPCEndpoint.VpcId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
        """
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return result

    @builtins.property
    def policy_document(self) -> typing.Any:
        """``AWS::EC2::VPCEndpoint.PolicyDocument``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
        """
        result = self._values.get("policy_document")
        return result

    @builtins.property
    def private_dns_enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPCEndpoint.PrivateDnsEnabled``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
        """
        result = self._values.get("private_dns_enabled")
        return result

    @builtins.property
    def route_table_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpoint.RouteTableIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
        """
        result = self._values.get("route_table_ids")
        return result

    @builtins.property
    def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpoint.SecurityGroupIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
        """
        result = self._values.get("security_group_ids")
        return result

    @builtins.property
    def subnet_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpoint.SubnetIds``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
        """
        result = self._values.get("subnet_ids")
        return result

    @builtins.property
    def vpc_endpoint_type(self) -> typing.Optional[builtins.str]:
        """``AWS::EC2::VPCEndpoint.VpcEndpointType``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
        """
        result = self._values.get("vpc_endpoint_type")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVPCEndpointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPCEndpointService(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointService",
):
    """A CloudFormation ``AWS::EC2::VPCEndpointService``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPCEndpointService
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        network_load_balancer_arns: typing.List[builtins.str],
        acceptance_required: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::VPCEndpointService``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param network_load_balancer_arns: ``AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns``.
        :param acceptance_required: ``AWS::EC2::VPCEndpointService.AcceptanceRequired``.
        """
        props = CfnVPCEndpointServiceProps(
            network_load_balancer_arns=network_load_balancer_arns,
            acceptance_required=acceptance_required,
        )

        jsii.create(CfnVPCEndpointService, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="networkLoadBalancerArns")
    def network_load_balancer_arns(self) -> typing.List[builtins.str]:
        """``AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
        """
        return jsii.get(self, "networkLoadBalancerArns")

    @network_load_balancer_arns.setter # type: ignore
    def network_load_balancer_arns(self, value: typing.List[builtins.str]) -> None:
        jsii.set(self, "networkLoadBalancerArns", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="acceptanceRequired")
    def acceptance_required(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPCEndpointService.AcceptanceRequired``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
        """
        return jsii.get(self, "acceptanceRequired")

    @acceptance_required.setter # type: ignore
    def acceptance_required(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]],
    ) -> None:
        jsii.set(self, "acceptanceRequired", value)


@jsii.implements(_IInspectable_051e6ed8)
class CfnVPCEndpointServicePermissions(
    _CfnResource_7760e8e4,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointServicePermissions",
):
    """A CloudFormation ``AWS::EC2::VPCEndpointServicePermissions``.

    see
    :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
    cloudformationResource:
    :cloudformationResource:: AWS::EC2::VPCEndpointServicePermissions
    """

    def __init__(
        self,
        scope: _Construct_f50a3f53,
        id: builtins.str,
        *,
        service_id: builtins.str,
        allowed_principals: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """Create a new ``AWS::EC2::VPCEndpointServicePermissions``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param service_id: ``AWS::EC2::VPCEndpointServicePermissions.ServiceId``.
        :param allowed_principals: ``AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals``.
        """
        props = CfnVPCEndpointServicePermissionsProps(
            service_id=service_id, allowed_principals=allowed_principals
        )

        jsii.create(CfnVPCEndpointServicePermissions, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_154f5999) -> None:
        """Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.

        stability
        :stability: experimental
        """
        return jsii.invoke(self, "inspect", [inspector])

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        """
        :param props: -
        """
        return jsii.invoke(self, "renderProperties", [props])

    @jsii.python.classproperty # type: ignore
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        """The CloudFormation resource type name for this resource class."""
        return jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return jsii.get(self, "cfnProperties")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="serviceId")
    def service_id(self) -> builtins.str:
        """``AWS::EC2::VPCEndpointServicePermissions.ServiceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
        """
        return jsii.get(self, "serviceId")

    @service_id.setter # type: ignore
    def service_id(self, value: builtins.str) -> None:
        jsii.set(self, "serviceId", value)

    @builtins.property # type: ignore
    @jsii.member(jsii_name="allowedPrincipals")
    def allowed_principals(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
        """
        return jsii.get(self, "allowedPrincipals")

    @allowed_principals.setter # type: ignore
    def allowed_principals(
        self,
        value: typing.Optional[typing.List[builtins.str]],
    ) -> None:
        jsii.set(self, "allowedPrincipals", value)


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointServicePermissionsProps",
    jsii_struct_bases=[],
    name_mapping={
        "service_id": "serviceId",
        "allowed_principals": "allowedPrincipals",
    },
)
class CfnVPCEndpointServicePermissionsProps:
    def __init__(
        self,
        *,
        service_id: builtins.str,
        allowed_principals: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::VPCEndpointServicePermissions``.

        :param service_id: ``AWS::EC2::VPCEndpointServicePermissions.ServiceId``.
        :param allowed_principals: ``AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "service_id": service_id,
        }
        if allowed_principals is not None:
            self._values["allowed_principals"] = allowed_principals

    @builtins.property
    def service_id(self) -> builtins.str:
        """``AWS::EC2::VPCEndpointServicePermissions.ServiceId``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
        """
        result = self._values.get("service_id")
        assert result is not None, "Required property 'service_id' is missing"
        return result

    @builtins.property
    def allowed_principals(self) -> typing.Optional[typing.List[builtins.str]]:
        """``AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
        """
        result = self._values.get("allowed_principals")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVPCEndpointServicePermissionsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk-experiment.aws_ec2.CfnVPCEndpointServiceProps",
    jsii_struct_bases=[],
    name_mapping={
        "network_load_balancer_arns": "networkLoadBalancerArns",
        "acceptance_required": "acceptanceRequired",
    },
)
class CfnVPCEndpointServiceProps:
    def __init__(
        self,
        *,
        network_load_balancer_arns: typing.List[builtins.str],
        acceptance_required: typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]] = None,
    ) -> None:
        """Properties for defining a ``AWS::EC2::VPCEndpointService``.

        :param network_load_balancer_arns: ``AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns``.
        :param acceptance_required: ``AWS::EC2::VPCEndpointService.AcceptanceRequired``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
        """
        self._values: typing.Dict[str, typing.Any] = {
            "network_load_balancer_arns": network_load_balancer_arns,
        }
        if acceptance_required is not None:
            self._values["acceptance_required"] = acceptance_required

    @builtins.property
    def network_load_balancer_arns(self) -> typing.List[builtins.str]:
        """``AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
        """
        result = self._values.get("network_load_balancer_arns")
        assert result is not None, "Required property 'network_load_balancer_arns' is missing"
        return result

    @builtins.property
    def acceptance_required(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_9ceae33e]]:
        """``AWS::EC2::VPCEndpointService.AcceptanceRequired``.

        see
        :see: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
        """
        result = self._values.get("acceptance_required")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnVPCEndpointServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for 