"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceSlack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack gitlab_service_slack}
*/
class ServiceSlack extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_slack gitlab_service_slack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceSlackConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_service_slack',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.18.0',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._branchesToBeNotified = config.branchesToBeNotified;
        this._confidentialIssueChannel = config.confidentialIssueChannel;
        this._confidentialIssuesEvents = config.confidentialIssuesEvents;
        this._confidentialNoteEvents = config.confidentialNoteEvents;
        this._id = config.id;
        this._issueChannel = config.issueChannel;
        this._issuesEvents = config.issuesEvents;
        this._mergeRequestChannel = config.mergeRequestChannel;
        this._mergeRequestsEvents = config.mergeRequestsEvents;
        this._noteChannel = config.noteChannel;
        this._noteEvents = config.noteEvents;
        this._notifyOnlyBrokenPipelines = config.notifyOnlyBrokenPipelines;
        this._notifyOnlyDefaultBranch = config.notifyOnlyDefaultBranch;
        this._pipelineChannel = config.pipelineChannel;
        this._pipelineEvents = config.pipelineEvents;
        this._project = config.project;
        this._pushChannel = config.pushChannel;
        this._pushEvents = config.pushEvents;
        this._tagPushChannel = config.tagPushChannel;
        this._tagPushEvents = config.tagPushEvents;
        this._username = config.username;
        this._webhook = config.webhook;
        this._wikiPageChannel = config.wikiPageChannel;
        this._wikiPageEvents = config.wikiPageEvents;
    }
    get branchesToBeNotified() {
        return this.getStringAttribute('branches_to_be_notified');
    }
    set branchesToBeNotified(value) {
        this._branchesToBeNotified = value;
    }
    resetBranchesToBeNotified() {
        this._branchesToBeNotified = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchesToBeNotifiedInput() {
        return this._branchesToBeNotified;
    }
    get confidentialIssueChannel() {
        return this.getStringAttribute('confidential_issue_channel');
    }
    set confidentialIssueChannel(value) {
        this._confidentialIssueChannel = value;
    }
    resetConfidentialIssueChannel() {
        this._confidentialIssueChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialIssueChannelInput() {
        return this._confidentialIssueChannel;
    }
    get confidentialIssuesEvents() {
        return this.getBooleanAttribute('confidential_issues_events');
    }
    set confidentialIssuesEvents(value) {
        this._confidentialIssuesEvents = value;
    }
    resetConfidentialIssuesEvents() {
        this._confidentialIssuesEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialIssuesEventsInput() {
        return this._confidentialIssuesEvents;
    }
    get confidentialNoteEvents() {
        return this.getBooleanAttribute('confidential_note_events');
    }
    set confidentialNoteEvents(value) {
        this._confidentialNoteEvents = value;
    }
    resetConfidentialNoteEvents() {
        this._confidentialNoteEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialNoteEventsInput() {
        return this._confidentialNoteEvents;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get issueChannel() {
        return this.getStringAttribute('issue_channel');
    }
    set issueChannel(value) {
        this._issueChannel = value;
    }
    resetIssueChannel() {
        this._issueChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issueChannelInput() {
        return this._issueChannel;
    }
    get issuesEvents() {
        return this.getBooleanAttribute('issues_events');
    }
    set issuesEvents(value) {
        this._issuesEvents = value;
    }
    resetIssuesEvents() {
        this._issuesEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEventsInput() {
        return this._issuesEvents;
    }
    // job_events - computed: true, optional: false, required: false
    get jobEvents() {
        return this.getBooleanAttribute('job_events');
    }
    get mergeRequestChannel() {
        return this.getStringAttribute('merge_request_channel');
    }
    set mergeRequestChannel(value) {
        this._mergeRequestChannel = value;
    }
    resetMergeRequestChannel() {
        this._mergeRequestChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestChannelInput() {
        return this._mergeRequestChannel;
    }
    get mergeRequestsEvents() {
        return this.getBooleanAttribute('merge_requests_events');
    }
    set mergeRequestsEvents(value) {
        this._mergeRequestsEvents = value;
    }
    resetMergeRequestsEvents() {
        this._mergeRequestsEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEventsInput() {
        return this._mergeRequestsEvents;
    }
    get noteChannel() {
        return this.getStringAttribute('note_channel');
    }
    set noteChannel(value) {
        this._noteChannel = value;
    }
    resetNoteChannel() {
        this._noteChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noteChannelInput() {
        return this._noteChannel;
    }
    get noteEvents() {
        return this.getBooleanAttribute('note_events');
    }
    set noteEvents(value) {
        this._noteEvents = value;
    }
    resetNoteEvents() {
        this._noteEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get noteEventsInput() {
        return this._noteEvents;
    }
    get notifyOnlyBrokenPipelines() {
        return this.getBooleanAttribute('notify_only_broken_pipelines');
    }
    set notifyOnlyBrokenPipelines(value) {
        this._notifyOnlyBrokenPipelines = value;
    }
    resetNotifyOnlyBrokenPipelines() {
        this._notifyOnlyBrokenPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyOnlyBrokenPipelinesInput() {
        return this._notifyOnlyBrokenPipelines;
    }
    get notifyOnlyDefaultBranch() {
        return this.getBooleanAttribute('notify_only_default_branch');
    }
    set notifyOnlyDefaultBranch(value) {
        this._notifyOnlyDefaultBranch = value;
    }
    resetNotifyOnlyDefaultBranch() {
        this._notifyOnlyDefaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyOnlyDefaultBranchInput() {
        return this._notifyOnlyDefaultBranch;
    }
    get pipelineChannel() {
        return this.getStringAttribute('pipeline_channel');
    }
    set pipelineChannel(value) {
        this._pipelineChannel = value;
    }
    resetPipelineChannel() {
        this._pipelineChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineChannelInput() {
        return this._pipelineChannel;
    }
    get pipelineEvents() {
        return this.getBooleanAttribute('pipeline_events');
    }
    set pipelineEvents(value) {
        this._pipelineEvents = value;
    }
    resetPipelineEvents() {
        this._pipelineEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelineEventsInput() {
        return this._pipelineEvents;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pushChannel() {
        return this.getStringAttribute('push_channel');
    }
    set pushChannel(value) {
        this._pushChannel = value;
    }
    resetPushChannel() {
        this._pushChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushChannelInput() {
        return this._pushChannel;
    }
    get pushEvents() {
        return this.getBooleanAttribute('push_events');
    }
    set pushEvents(value) {
        this._pushEvents = value;
    }
    resetPushEvents() {
        this._pushEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushEventsInput() {
        return this._pushEvents;
    }
    get tagPushChannel() {
        return this.getStringAttribute('tag_push_channel');
    }
    set tagPushChannel(value) {
        this._tagPushChannel = value;
    }
    resetTagPushChannel() {
        this._tagPushChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagPushChannelInput() {
        return this._tagPushChannel;
    }
    get tagPushEvents() {
        return this.getBooleanAttribute('tag_push_events');
    }
    set tagPushEvents(value) {
        this._tagPushEvents = value;
    }
    resetTagPushEvents() {
        this._tagPushEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagPushEventsInput() {
        return this._tagPushEvents;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get webhook() {
        return this.getStringAttribute('webhook');
    }
    set webhook(value) {
        this._webhook = value;
    }
    // Temporarily expose input value. Use with caution.
    get webhookInput() {
        return this._webhook;
    }
    get wikiPageChannel() {
        return this.getStringAttribute('wiki_page_channel');
    }
    set wikiPageChannel(value) {
        this._wikiPageChannel = value;
    }
    resetWikiPageChannel() {
        this._wikiPageChannel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageChannelInput() {
        return this._wikiPageChannel;
    }
    get wikiPageEvents() {
        return this.getBooleanAttribute('wiki_page_events');
    }
    set wikiPageEvents(value) {
        this._wikiPageEvents = value;
    }
    resetWikiPageEvents() {
        this._wikiPageEvents = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiPageEventsInput() {
        return this._wikiPageEvents;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            branches_to_be_notified: cdktf.stringToTerraform(this._branchesToBeNotified),
            confidential_issue_channel: cdktf.stringToTerraform(this._confidentialIssueChannel),
            confidential_issues_events: cdktf.booleanToTerraform(this._confidentialIssuesEvents),
            confidential_note_events: cdktf.booleanToTerraform(this._confidentialNoteEvents),
            id: cdktf.stringToTerraform(this._id),
            issue_channel: cdktf.stringToTerraform(this._issueChannel),
            issues_events: cdktf.booleanToTerraform(this._issuesEvents),
            merge_request_channel: cdktf.stringToTerraform(this._mergeRequestChannel),
            merge_requests_events: cdktf.booleanToTerraform(this._mergeRequestsEvents),
            note_channel: cdktf.stringToTerraform(this._noteChannel),
            note_events: cdktf.booleanToTerraform(this._noteEvents),
            notify_only_broken_pipelines: cdktf.booleanToTerraform(this._notifyOnlyBrokenPipelines),
            notify_only_default_branch: cdktf.booleanToTerraform(this._notifyOnlyDefaultBranch),
            pipeline_channel: cdktf.stringToTerraform(this._pipelineChannel),
            pipeline_events: cdktf.booleanToTerraform(this._pipelineEvents),
            project: cdktf.stringToTerraform(this._project),
            push_channel: cdktf.stringToTerraform(this._pushChannel),
            push_events: cdktf.booleanToTerraform(this._pushEvents),
            tag_push_channel: cdktf.stringToTerraform(this._tagPushChannel),
            tag_push_events: cdktf.booleanToTerraform(this._tagPushEvents),
            username: cdktf.stringToTerraform(this._username),
            webhook: cdktf.stringToTerraform(this._webhook),
            wiki_page_channel: cdktf.stringToTerraform(this._wikiPageChannel),
            wiki_page_events: cdktf.booleanToTerraform(this._wikiPageEvents),
        };
    }
}
exports.ServiceSlack = ServiceSlack;
_a = JSII_RTTI_SYMBOL_1;
ServiceSlack[_a] = { fqn: "@cdktf/provider-gitlab.serviceSlack.ServiceSlack", version: "3.0.5" };
// =================
// STATIC PROPERTIES
// =================
ServiceSlack.tfResourceType = "gitlab_service_slack";
//# sourceMappingURL=data:application/json;base64,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