import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupHookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Invoke the hook for confidential issues events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#confidential_issues_events GroupHook#confidential_issues_events}
    */
    readonly confidentialIssuesEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for confidential notes events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#confidential_note_events GroupHook#confidential_note_events}
    */
    readonly confidentialNoteEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for deployment events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#deployment_events GroupHook#deployment_events}
    */
    readonly deploymentEvents?: boolean | cdktf.IResolvable;
    /**
    * Enable ssl verification when invoking the hook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#enable_ssl_verification GroupHook#enable_ssl_verification}
    */
    readonly enableSslVerification?: boolean | cdktf.IResolvable;
    /**
    * The ID or full path of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#group GroupHook#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#id GroupHook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Invoke the hook for issues events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#issues_events GroupHook#issues_events}
    */
    readonly issuesEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for job events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#job_events GroupHook#job_events}
    */
    readonly jobEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for merge requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#merge_requests_events GroupHook#merge_requests_events}
    */
    readonly mergeRequestsEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for notes events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#note_events GroupHook#note_events}
    */
    readonly noteEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for pipeline events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#pipeline_events GroupHook#pipeline_events}
    */
    readonly pipelineEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#push_events GroupHook#push_events}
    */
    readonly pushEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for push events on matching branches only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#push_events_branch_filter GroupHook#push_events_branch_filter}
    */
    readonly pushEventsBranchFilter?: string;
    /**
    * Invoke the hook for releases events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#releases_events GroupHook#releases_events}
    */
    readonly releasesEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for subgroup events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#subgroup_events GroupHook#subgroup_events}
    */
    readonly subgroupEvents?: boolean | cdktf.IResolvable;
    /**
    * Invoke the hook for tag push events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#tag_push_events GroupHook#tag_push_events}
    */
    readonly tagPushEvents?: boolean | cdktf.IResolvable;
    /**
    * A token to present when invoking the hook. The token is not available for imported resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#token GroupHook#token}
    */
    readonly token?: string;
    /**
    * The url of the hook to invoke.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#url GroupHook#url}
    */
    readonly url: string;
    /**
    * Invoke the hook for wiki page events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook#wiki_page_events GroupHook#wiki_page_events}
    */
    readonly wikiPageEvents?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook gitlab_group_hook}
*/
export declare class GroupHook extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group_hook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_hook gitlab_group_hook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupHookConfig
    */
    constructor(scope: Construct, id: string, config: GroupHookConfig);
    private _confidentialIssuesEvents?;
    get confidentialIssuesEvents(): boolean | cdktf.IResolvable;
    set confidentialIssuesEvents(value: boolean | cdktf.IResolvable);
    resetConfidentialIssuesEvents(): void;
    get confidentialIssuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _confidentialNoteEvents?;
    get confidentialNoteEvents(): boolean | cdktf.IResolvable;
    set confidentialNoteEvents(value: boolean | cdktf.IResolvable);
    resetConfidentialNoteEvents(): void;
    get confidentialNoteEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _deploymentEvents?;
    get deploymentEvents(): boolean | cdktf.IResolvable;
    set deploymentEvents(value: boolean | cdktf.IResolvable);
    resetDeploymentEvents(): void;
    get deploymentEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSslVerification?;
    get enableSslVerification(): boolean | cdktf.IResolvable;
    set enableSslVerification(value: boolean | cdktf.IResolvable);
    resetEnableSslVerification(): void;
    get enableSslVerificationInput(): boolean | cdktf.IResolvable | undefined;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get groupId(): number;
    get hookId(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuesEvents?;
    get issuesEvents(): boolean | cdktf.IResolvable;
    set issuesEvents(value: boolean | cdktf.IResolvable);
    resetIssuesEvents(): void;
    get issuesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _jobEvents?;
    get jobEvents(): boolean | cdktf.IResolvable;
    set jobEvents(value: boolean | cdktf.IResolvable);
    resetJobEvents(): void;
    get jobEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _mergeRequestsEvents?;
    get mergeRequestsEvents(): boolean | cdktf.IResolvable;
    set mergeRequestsEvents(value: boolean | cdktf.IResolvable);
    resetMergeRequestsEvents(): void;
    get mergeRequestsEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _noteEvents?;
    get noteEvents(): boolean | cdktf.IResolvable;
    set noteEvents(value: boolean | cdktf.IResolvable);
    resetNoteEvents(): void;
    get noteEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _pipelineEvents?;
    get pipelineEvents(): boolean | cdktf.IResolvable;
    set pipelineEvents(value: boolean | cdktf.IResolvable);
    resetPipelineEvents(): void;
    get pipelineEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _pushEvents?;
    get pushEvents(): boolean | cdktf.IResolvable;
    set pushEvents(value: boolean | cdktf.IResolvable);
    resetPushEvents(): void;
    get pushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _pushEventsBranchFilter?;
    get pushEventsBranchFilter(): string;
    set pushEventsBranchFilter(value: string);
    resetPushEventsBranchFilter(): void;
    get pushEventsBranchFilterInput(): string | undefined;
    private _releasesEvents?;
    get releasesEvents(): boolean | cdktf.IResolvable;
    set releasesEvents(value: boolean | cdktf.IResolvable);
    resetReleasesEvents(): void;
    get releasesEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _subgroupEvents?;
    get subgroupEvents(): boolean | cdktf.IResolvable;
    set subgroupEvents(value: boolean | cdktf.IResolvable);
    resetSubgroupEvents(): void;
    get subgroupEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagPushEvents?;
    get tagPushEvents(): boolean | cdktf.IResolvable;
    set tagPushEvents(value: boolean | cdktf.IResolvable);
    resetTagPushEvents(): void;
    get tagPushEventsInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _wikiPageEvents?;
    get wikiPageEvents(): boolean | cdktf.IResolvable;
    set wikiPageEvents(value: boolean | cdktf.IResolvable);
    resetWikiPageEvents(): void;
    get wikiPageEventsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
