"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnIntegration = exports.toJson_RespondersProperty = exports.toJson_CfnIntegrationProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnIntegrationProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnIntegrationProps(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'OpsgenieApiEndpoint': obj.opsgenieApiEndpoint,
        'OpsgenieApiKey': obj.opsgenieApiKey,
        'Enabled': obj.enabled,
        'Name': obj.name,
        'IntegrationType': obj.integrationType,
        'OwnerTeamId': obj.ownerTeamId,
        'OwnerTeamName': obj.ownerTeamName,
        'AllowReadAccess': obj.allowReadAccess,
        'AllowWriteAccess': obj.allowWriteAccess,
        'AllowDeleteAccess': obj.allowDeleteAccess,
        'AllowConfigurationAccess': obj.allowConfigurationAccess,
        'Responders': (_b = obj.responders) === null || _b === void 0 ? void 0 : _b.map(y => toJson_RespondersProperty(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnIntegrationProps = toJson_CfnIntegrationProps;
/**
 * Converts an object of type 'RespondersProperty' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RespondersProperty(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'type': obj.type,
        'name': obj.name,
        'username': obj.username,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RespondersProperty = toJson_RespondersProperty;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Atlassian::Opsgenie::Integration`
 *
 * @cloudformationResource Atlassian::Opsgenie::Integration
 * @stability external
 * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
 */
class CfnIntegration extends cdk.CfnResource {
    /**
     * Create a new `Atlassian::Opsgenie::Integration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIntegration.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnIntegrationProps(props) });
        this.props = props;
        this.attrIntegrationId = cdk.Token.asString(this.getAtt('IntegrationId'));
        this.attrIntegrationApiKey = cdk.Token.asString(this.getAtt('IntegrationApiKey'));
    }
}
exports.CfnIntegration = CfnIntegration;
_a = JSII_RTTI_SYMBOL_1;
CfnIntegration[_a] = { fqn: "@cdk-cloudformation/atlassian-opsgenie-integration.CfnIntegration", version: "1.0.1-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnIntegration.CFN_RESOURCE_TYPE_NAME = "Atlassian::Opsgenie::Integration";
//# sourceMappingURL=data:application/json;base64,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