import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Opsgenie Integration Resource definition
 *
 * @schema CfnIntegrationProps
 */
export interface CfnIntegrationProps {
    /**
     * @schema CfnIntegrationProps#OpsgenieApiEndpoint
     */
    readonly opsgenieApiEndpoint: string;
    /**
     * @schema CfnIntegrationProps#OpsgenieApiKey
     */
    readonly opsgenieApiKey: string;
    /**
     * Integration status, default is true
     *
     * @schema CfnIntegrationProps#Enabled
     */
    readonly enabled: boolean;
    /**
     * Integration name
     *
     * @schema CfnIntegrationProps#Name
     */
    readonly name: string;
    /**
     * Integration types, only api integration types supported
     *
     * @schema CfnIntegrationProps#IntegrationType
     */
    readonly integrationType: string;
    /**
     * Id of the integration owner team.
     *
     * @schema CfnIntegrationProps#OwnerTeamId
     */
    readonly ownerTeamId?: string;
    /**
     * Name of the integration owner team.
     *
     * @schema CfnIntegrationProps#OwnerTeamName
     */
    readonly ownerTeamName?: string;
    /**
     * This parameter is for configuring the read access of integration
     *
     * @schema CfnIntegrationProps#AllowReadAccess
     */
    readonly allowReadAccess?: boolean;
    /**
     * This parameter is for configuring the write access of integration.
     *
     * @schema CfnIntegrationProps#AllowWriteAccess
     */
    readonly allowWriteAccess?: boolean;
    /**
     * This parameter is for configuring the delete access of integration.
     *
     * @schema CfnIntegrationProps#AllowDeleteAccess
     */
    readonly allowDeleteAccess?: boolean;
    /**
     * This parameter is for allowing or restricting the configuration access.
     *
     * @schema CfnIntegrationProps#AllowConfigurationAccess
     */
    readonly allowConfigurationAccess?: boolean;
    /**
     * @schema CfnIntegrationProps#Responders
     */
    readonly responders?: RespondersProperty[];
}
/**
 * Converts an object of type 'CfnIntegrationProps' to JSON representation.
 */
export declare function toJson_CfnIntegrationProps(obj: CfnIntegrationProps | undefined): Record<string, any> | undefined;
/**
 * @schema respondersProperty
 */
export interface RespondersProperty {
    /**
     * Responder type
     *
     * @schema respondersProperty#type
     */
    readonly type?: string;
    /**
     * Responder name if available
     *
     * @schema respondersProperty#name
     */
    readonly name?: string;
    /**
     * Responder username, if responder type is user
     *
     * @schema respondersProperty#username
     */
    readonly username?: string;
}
/**
 * Converts an object of type 'RespondersProperty' to JSON representation.
 */
export declare function toJson_RespondersProperty(obj: RespondersProperty | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Atlassian::Opsgenie::Integration`
 *
 * @cloudformationResource Atlassian::Opsgenie::Integration
 * @stability external
 * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
 */
export declare class CfnIntegration extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Atlassian::Opsgenie::Integration";
    /**
     * Resource props.
     */
    readonly props: CfnIntegrationProps;
    /**
     * Attribute `Atlassian::Opsgenie::Integration.IntegrationId`
     * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
     */
    readonly attrIntegrationId: string;
    /**
     * Attribute `Atlassian::Opsgenie::Integration.IntegrationApiKey`
     * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
     */
    readonly attrIntegrationApiKey: string;
    /**
     * Create a new `Atlassian::Opsgenie::Integration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnIntegrationProps);
}
