from setuptools import setup, find_packages
import versioneer

setup(
    name='scgenome',
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    description='Code for analyzing single cell whole genomes',
    author='Shah Lab',
    url='https://github.com/shahcompbio/scgenome',
    packages=find_packages(),
    install_requires=[
        'adjustText',
        'anndata',
        'bamread',
        'bokeh',
        'brewer2mpl',
        'Click',
        'csverve',
        'hdbscan',
        'hmmlearn',
        'ipython',
        'jupyter',
        'lda',
        'matplotlib',
        'numba',
        'numexpr',
        'numpy',
        'oauthlib',
        'pandas',
        'pyBigWig',
        'pyfaidx',
        'pyranges',
        'pysam',
        'PyYAML',
        'scikit-learn',
        'scipy',
        'seaborn',
        'statsmodels',
        'umap-learn',
        'wgs_analysis',
        'nose',
        'biopython',
        'pypeliner'
    ],
    package_data={
        'scgenome': [
            'data/mm10.fa.fai',
            'data/GRCh37-lite.fa.fai',
            'dtypes/*.yaml',
        ],
    },
)
