# # ⚠ Warning
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
# LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
# NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#
# [🥭 Entropy Markets](https://entropy.markets/) support is available at:
#   [Docs](https://docs.entropy.markets/)
#   [Discord](https://discord.gg/67jySBhxrg)
#   [Twitter](https://twitter.com/entropymarkets)
#   [Github](https://github.com/blockworks-foundation)
#   [Email](mailto:hello@blockworks.foundation)

import typing


def indent_collection_as_str(
    collection: typing.Sequence[typing.Any], levels: int = 0
) -> str:
    spaces: int = levels * 4
    spacing: str = " " * spaces
    if len(collection) == 0:
        return f"{spacing}None"
    return f"{spacing}" + f"\n{spacing}".join(f"{item}" for item in collection)


def indent_item_by(item: typing.Any, levels: int = 1) -> str:
    spaces: int = levels * 4
    spacing: str = " " * spaces
    return f"{item}".replace("\n", f"\n{spacing}")
