#!/usr/bin/env python

"""
camcops_server/alembic/versions/0045_das28_esr_crp_floating_point.py

===============================================================================

    Copyright (C) 2012-2020 Rudolf Cardinal (rudolf@pobox.com).

    This file is part of CamCOPS.

    CamCOPS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CamCOPS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CamCOPS. If not, see <http://www.gnu.org/licenses/>.

===============================================================================

DATABASE REVISION SCRIPT

das28_esr_crp_floating_point

Revision ID: 0045
Revises: 0044
Creation date: 2020-02-24 12:41:55.045317

"""

# =============================================================================
# Imports
# =============================================================================

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


# =============================================================================
# Revision identifiers, used by Alembic.
# =============================================================================

revision = '0045'
down_revision = '0044'
branch_labels = None
depends_on = None


# =============================================================================
# The upgrade/downgrade steps
# =============================================================================

# noinspection PyPep8,PyTypeChecker
def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('das28', schema=None) as batch_op:
        batch_op.alter_column('crp',
                              existing_type=mysql.INTEGER(display_width=11),
                              type_=sa.Float(),
                              existing_comment='CRP (0-300 mg/L)',
                              existing_nullable=True)
        batch_op.alter_column('esr',
                              existing_type=mysql.INTEGER(display_width=11),
                              type_=sa.Float(),
                              existing_comment='ESR (1-300 mm/h)',
                              existing_nullable=True)

    # ### end Alembic commands ###


# noinspection PyPep8,PyTypeChecker
def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('das28', schema=None) as batch_op:
        batch_op.alter_column('esr',
                              existing_type=sa.Float(),
                              type_=mysql.INTEGER(display_width=11),
                              existing_comment='ESR (1-300 mm/h)',
                              existing_nullable=True)
        batch_op.alter_column('crp',
                              existing_type=sa.Float(),
                              type_=mysql.INTEGER(display_width=11),
                              existing_comment='CRP (0-300 mg/L)',
                              existing_nullable=True)

    # ### end Alembic commands ###
