# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_schedule import CoreV1Schedule
from dasl_api.models.workspace_v1_export_config import WorkspaceV1ExportConfig
from dasl_api.models.workspace_v1_workspace_config_spec_default_config import WorkspaceV1WorkspaceConfigSpecDefaultConfig
from dasl_api.models.workspace_v1_workspace_config_spec_detection_rule_metadata import WorkspaceV1WorkspaceConfigSpecDetectionRuleMetadata
from dasl_api.models.workspace_v1_workspace_config_spec_managed_retention_inner import WorkspaceV1WorkspaceConfigSpecManagedRetentionInner
from dasl_api.models.workspace_v1_workspace_config_spec_observables import WorkspaceV1WorkspaceConfigSpecObservables
from dasl_api.models.workspace_v1_workspace_config_spec_system_tables_config import WorkspaceV1WorkspaceConfigSpecSystemTablesConfig
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceV1WorkspaceConfigSpec(BaseModel):
    """
    WorkspaceV1WorkspaceConfigSpec
    """ # noqa: E501
    system_tables_config: WorkspaceV1WorkspaceConfigSpecSystemTablesConfig = Field(alias="systemTablesConfig")
    default_sql_warehouse: Optional[StrictStr] = Field(default=None, alias="defaultSQLWarehouse")
    detection_rule_metadata: Optional[WorkspaceV1WorkspaceConfigSpecDetectionRuleMetadata] = Field(default=None, alias="detectionRuleMetadata")
    notable_export: Optional[WorkspaceV1ExportConfig] = Field(default=None, alias="notableExport")
    operational_alert_export: Optional[WorkspaceV1ExportConfig] = Field(default=None, alias="operationalAlertExport")
    export_schedule: Optional[CoreV1Schedule] = Field(default=None, description="Schedule for notable and operational alert export job. Note that delivery of such exports to your configured destination happens in a job configured to run on this schedule, and so can be significantly delayed depending on how this field is configured. If this value is not provided, the export job will run every 2 hours.", alias="exportSchedule")
    observables: Optional[WorkspaceV1WorkspaceConfigSpecObservables] = None
    dasl_storage_path: StrictStr = Field(description="The path to a directory where DASL can store internal files and state. ", alias="daslStoragePath")
    dasl_custom_presets_path: Optional[StrictStr] = Field(default=None, description="A path to a user catalog volume where the user can store custom preset to be made available via the DASL UI. ", alias="daslCustomPresetsPath")
    default_config: Optional[WorkspaceV1WorkspaceConfigSpecDefaultConfig] = Field(default=None, alias="defaultConfig")
    managed_retention: Optional[List[WorkspaceV1WorkspaceConfigSpecManagedRetentionInner]] = Field(default=None, alias="managedRetention")
    __properties: ClassVar[List[str]] = ["systemTablesConfig", "defaultSQLWarehouse", "detectionRuleMetadata", "notableExport", "operationalAlertExport", "exportSchedule", "observables", "daslStoragePath", "daslCustomPresetsPath", "defaultConfig", "managedRetention"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of system_tables_config
        if self.system_tables_config:
            _dict['systemTablesConfig'] = self.system_tables_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detection_rule_metadata
        if self.detection_rule_metadata:
            _dict['detectionRuleMetadata'] = self.detection_rule_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notable_export
        if self.notable_export:
            _dict['notableExport'] = self.notable_export.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operational_alert_export
        if self.operational_alert_export:
            _dict['operationalAlertExport'] = self.operational_alert_export.to_dict()
        # override the default output from pydantic by calling `to_dict()` of export_schedule
        if self.export_schedule:
            _dict['exportSchedule'] = self.export_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of observables
        if self.observables:
            _dict['observables'] = self.observables.to_dict()
        # override the default output from pydantic by calling `to_dict()` of default_config
        if self.default_config:
            _dict['defaultConfig'] = self.default_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in managed_retention (list)
        _items = []
        if self.managed_retention:
            for _item_managed_retention in self.managed_retention:
                if _item_managed_retention:
                    _items.append(_item_managed_retention.to_dict())
            _dict['managedRetention'] = _items
        # set to None if default_sql_warehouse (nullable) is None
        # and model_fields_set contains the field
        if self.default_sql_warehouse is None and "default_sql_warehouse" in self.model_fields_set:
            _dict['defaultSQLWarehouse'] = None

        # set to None if detection_rule_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.detection_rule_metadata is None and "detection_rule_metadata" in self.model_fields_set:
            _dict['detectionRuleMetadata'] = None

        # set to None if notable_export (nullable) is None
        # and model_fields_set contains the field
        if self.notable_export is None and "notable_export" in self.model_fields_set:
            _dict['notableExport'] = None

        # set to None if operational_alert_export (nullable) is None
        # and model_fields_set contains the field
        if self.operational_alert_export is None and "operational_alert_export" in self.model_fields_set:
            _dict['operationalAlertExport'] = None

        # set to None if export_schedule (nullable) is None
        # and model_fields_set contains the field
        if self.export_schedule is None and "export_schedule" in self.model_fields_set:
            _dict['exportSchedule'] = None

        # set to None if observables (nullable) is None
        # and model_fields_set contains the field
        if self.observables is None and "observables" in self.model_fields_set:
            _dict['observables'] = None

        # set to None if dasl_custom_presets_path (nullable) is None
        # and model_fields_set contains the field
        if self.dasl_custom_presets_path is None and "dasl_custom_presets_path" in self.model_fields_set:
            _dict['daslCustomPresetsPath'] = None

        # set to None if default_config (nullable) is None
        # and model_fields_set contains the field
        if self.default_config is None and "default_config" in self.model_fields_set:
            _dict['defaultConfig'] = None

        # set to None if managed_retention (nullable) is None
        # and model_fields_set contains the field
        if self.managed_retention is None and "managed_retention" in self.model_fields_set:
            _dict['managedRetention'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceV1WorkspaceConfigSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "systemTablesConfig": WorkspaceV1WorkspaceConfigSpecSystemTablesConfig.from_dict(obj["systemTablesConfig"]) if obj.get("systemTablesConfig") is not None else None,
            "defaultSQLWarehouse": obj.get("defaultSQLWarehouse"),
            "detectionRuleMetadata": WorkspaceV1WorkspaceConfigSpecDetectionRuleMetadata.from_dict(obj["detectionRuleMetadata"]) if obj.get("detectionRuleMetadata") is not None else None,
            "notableExport": WorkspaceV1ExportConfig.from_dict(obj["notableExport"]) if obj.get("notableExport") is not None else None,
            "operationalAlertExport": WorkspaceV1ExportConfig.from_dict(obj["operationalAlertExport"]) if obj.get("operationalAlertExport") is not None else None,
            "exportSchedule": CoreV1Schedule.from_dict(obj["exportSchedule"]) if obj.get("exportSchedule") is not None else None,
            "observables": WorkspaceV1WorkspaceConfigSpecObservables.from_dict(obj["observables"]) if obj.get("observables") is not None else None,
            "daslStoragePath": obj.get("daslStoragePath"),
            "daslCustomPresetsPath": obj.get("daslCustomPresetsPath"),
            "defaultConfig": WorkspaceV1WorkspaceConfigSpecDefaultConfig.from_dict(obj["defaultConfig"]) if obj.get("defaultConfig") is not None else None,
            "managedRetention": [WorkspaceV1WorkspaceConfigSpecManagedRetentionInner.from_dict(_item) for _item in obj["managedRetention"]] if obj.get("managedRetention") is not None else None
        })
        return _obj


