# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1VerifyAuthResponse(BaseModel):
    """
    DbuiV1VerifyAuthResponse
    """ # noqa: E501
    expiry: StrictInt = Field(description="The expiry time of this token.")
    is_databricks_authed: StrictBool = Field(description="Indicates whether this token is authenticated against Databricks too.", alias="isDatabricksAuthed")
    is_admin: StrictBool = Field(description="Indicates whether this token has admin privledges in the DASL workspace.", alias="isAdmin")
    dasl_workspace_id: StrictStr = Field(description="The DASL workspace ID this token authed against.", alias="daslWorkspaceId")
    __properties: ClassVar[List[str]] = ["expiry", "isDatabricksAuthed", "isAdmin", "daslWorkspaceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1VerifyAuthResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1VerifyAuthResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "expiry": obj.get("expiry"),
            "isDatabricksAuthed": obj.get("isDatabricksAuthed"),
            "isAdmin": obj.get("isAdmin"),
            "daslWorkspaceId": obj.get("daslWorkspaceId")
        })
        return _obj


