# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from dasl_api.models.dbui_v1_table_column_details import DbuiV1TableColumnDetails
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1TransformResponseStagesInner(BaseModel):
    """
    DbuiV1TransformResponseStagesInner
    """ # noqa: E501
    transform_type: StrictStr = Field(alias="transformType")
    columns: List[DbuiV1TableColumnDetails] = Field(description="A list of metadata about the columns returned.")
    data: List[Dict[str, StrictStr]] = Field(description="The data represented as a list of map[String, String].")
    __properties: ClassVar[List[str]] = ["transformType", "columns", "data"]

    @field_validator('transform_type')
    def transform_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SilverPreTransform', 'SilverTransform', 'Gold', 'Input']):
            raise ValueError("must be one of enum values ('SilverPreTransform', 'SilverTransform', 'Gold', 'Input')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1TransformResponseStagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item_columns in self.columns:
                if _item_columns:
                    _items.append(_item_columns.to_dict())
            _dict['columns'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1TransformResponseStagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transformType": obj.get("transformType"),
            "columns": [DbuiV1TableColumnDetails.from_dict(_item) for _item in obj["columns"]] if obj.get("columns") is not None else None,
            "data": obj.get("data")
        })
        return _obj


