# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_autoloader_spec import CoreV1DataSourceAutoloaderSpec
from typing import Optional, Set
from typing_extensions import Self

class DbuiV1AutoloaderPreviewRequest(BaseModel):
    """
    DbuiV1AutoloaderPreviewRequest
    """ # noqa: E501
    warehouse: StrictStr = Field(description="The SQL warehouse ID to use.")
    autoloader: CoreV1DataSourceAutoloaderSpec
    page_size: Optional[StrictInt] = Field(default=None, description="Number of records to return per page.", alias="pageSize")
    page: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["warehouse", "autoloader", "pageSize", "page"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbuiV1AutoloaderPreviewRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of autoloader
        if self.autoloader:
            _dict['autoloader'] = self.autoloader.to_dict()
        # set to None if page_size (nullable) is None
        # and model_fields_set contains the field
        if self.page_size is None and "page_size" in self.model_fields_set:
            _dict['pageSize'] = None

        # set to None if page (nullable) is None
        # and model_fields_set contains the field
        if self.page is None and "page" in self.model_fields_set:
            _dict['page'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbuiV1AutoloaderPreviewRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "warehouse": obj.get("warehouse"),
            "autoloader": CoreV1DataSourceAutoloaderSpec.from_dict(obj["autoloader"]) if obj.get("autoloader") is not None else None,
            "pageSize": obj.get("pageSize"),
            "page": obj.get("page")
        })
        return _obj


