# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from dasl_api.models.core_v1_rule_spec_metadata_mitre_inner import CoreV1RuleSpecMetadataMitreInner
from dasl_api.models.core_v1_rule_spec_metadata_response import CoreV1RuleSpecMetadataResponse
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleSpecMetadata(BaseModel):
    """
    CoreV1RuleSpecMetadata
    """ # noqa: E501
    version: Optional[Union[StrictFloat, StrictInt]] = None
    category: Optional[StrictStr] = Field(default=None, description="The category of this detection. The available values are configured in workspace config.")
    severity: Optional[StrictStr] = None
    fidelity: Optional[StrictStr] = Field(default=None, description="Fidelity is used to capture the maturity of a rule. Newly created, untested rules should be marked as Investigative fidelity. Older, more well-tested rules should be marked as High fidelity. This helps an analyst determine how likely a notable is a false positive. ")
    mitre: Optional[List[CoreV1RuleSpecMetadataMitreInner]] = Field(default=None, description="A list of MITRE tactics to apply when processing a detection. ")
    objective: Optional[StrictStr] = Field(default=None, description="A longer form description of what this rule is attempting to detect (objectMeta.comment is a summary).")
    response: Optional[CoreV1RuleSpecMetadataResponse] = None
    __properties: ClassVar[List[str]] = ["version", "category", "severity", "fidelity", "mitre", "objective", "response"]

    @field_validator('fidelity')
    def fidelity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Investigative', 'Medium', 'High']):
            raise ValueError("must be one of enum values ('Investigative', 'Medium', 'High')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in mitre (list)
        _items = []
        if self.mitre:
            for _item_mitre in self.mitre:
                if _item_mitre:
                    _items.append(_item_mitre.to_dict())
            _dict['mitre'] = _items
        # override the default output from pydantic by calling `to_dict()` of response
        if self.response:
            _dict['response'] = self.response.to_dict()
        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if severity (nullable) is None
        # and model_fields_set contains the field
        if self.severity is None and "severity" in self.model_fields_set:
            _dict['severity'] = None

        # set to None if fidelity (nullable) is None
        # and model_fields_set contains the field
        if self.fidelity is None and "fidelity" in self.model_fields_set:
            _dict['fidelity'] = None

        # set to None if mitre (nullable) is None
        # and model_fields_set contains the field
        if self.mitre is None and "mitre" in self.model_fields_set:
            _dict['mitre'] = None

        # set to None if objective (nullable) is None
        # and model_fields_set contains the field
        if self.objective is None and "objective" in self.model_fields_set:
            _dict['objective'] = None

        # set to None if response (nullable) is None
        # and model_fields_set contains the field
        if self.response is None and "response" in self.model_fields_set:
            _dict['response'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleSpecMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "category": obj.get("category"),
            "severity": obj.get("severity"),
            "fidelity": obj.get("fidelity"),
            "mitre": [CoreV1RuleSpecMetadataMitreInner.from_dict(_item) for _item in obj["mitre"]] if obj.get("mitre") is not None else None,
            "objective": obj.get("objective"),
            "response": CoreV1RuleSpecMetadataResponse.from_dict(obj["response"]) if obj.get("response") is not None else None
        })
        return _obj


