# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from dasl_api.models.core_v1_rule_observable_risk import CoreV1RuleObservableRisk
from typing import Optional, Set
from typing_extensions import Self

class CoreV1RuleObservable(BaseModel):
    """
    CoreV1RuleObservable
    """ # noqa: E501
    kind: StrictStr = Field(description="A user defined name for the type of observable, eg; IP address, email.")
    value: StrictStr = Field(description="A SQL expression indicating the observable value, eg; '{ip_addr}'.")
    relationship: StrictStr = Field(description="The relationship between the observable and the event, eg; 'tenant', 'user'.")
    risk: CoreV1RuleObservableRisk
    __properties: ClassVar[List[str]] = ["kind", "value", "relationship", "risk"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1RuleObservable from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of risk
        if self.risk:
            _dict['risk'] = self.risk.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1RuleObservable from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "kind": obj.get("kind"),
            "value": obj.get("value"),
            "relationship": obj.get("relationship"),
            "risk": CoreV1RuleObservableRisk.from_dict(obj["risk"]) if obj.get("risk") is not None else None
        })
        return _obj


