# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1MigrationStatus(BaseModel):
    """
    CoreV1MigrationStatus
    """ # noqa: E501
    current_version: StrictInt = Field(description="The greatest migration version successfully applied.", alias="currentVersion")
    last_update: datetime = Field(description="The last time a migration was attempted.", alias="lastUpdate")
    last_error: Optional[StrictStr] = Field(default=None, description="If the last update was not successful, then this field should be populated with an error message describing why. If this field is empty or unspecified, then the last applied migration was a success.", alias="lastError")
    __properties: ClassVar[List[str]] = ["currentVersion", "lastUpdate", "lastError"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1MigrationStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if last_error (nullable) is None
        # and model_fields_set contains the field
        if self.last_error is None and "last_error" in self.model_fields_set:
            _dict['lastError'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1MigrationStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currentVersion": obj.get("currentVersion"),
            "lastUpdate": obj.get("lastUpdate"),
            "lastError": obj.get("lastError")
        })
        return _obj


