# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceSpecBronzeClustering(BaseModel):
    """
    Optional configuration of liquid clustering applied to the bronze table(s).
    """ # noqa: E501
    column_names: Optional[List[StrictStr]] = Field(default=None, description="List of column names that should be included into liquid clustering.", alias="columnNames")
    time_column: Optional[StrictStr] = Field(default=None, description="Name of the column that holds 'time' information and should be used to cluster by.", alias="timeColumn")
    __properties: ClassVar[List[str]] = ["columnNames", "timeColumn"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecBronzeClustering from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if column_names (nullable) is None
        # and model_fields_set contains the field
        if self.column_names is None and "column_names" in self.model_fields_set:
            _dict['columnNames'] = None

        # set to None if time_column (nullable) is None
        # and model_fields_set contains the field
        if self.time_column is None and "time_column" in self.model_fields_set:
            _dict['timeColumn'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceSpecBronzeClustering from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "columnNames": obj.get("columnNames"),
            "timeColumn": obj.get("timeColumn")
        })
        return _obj


