# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CoreV1DataSourceFieldUtilsUnreferencedColumns(BaseModel):
    """
    CoreV1DataSourceFieldUtilsUnreferencedColumns
    """ # noqa: E501
    preserve: Optional[StrictBool] = Field(default=None, description="Indicates whether columns not referenced in the FieldSpecs should be preserved in the output. This only applies to the value in the FieldSpec \"from\" attribute. ")
    embed_column: Optional[StrictStr] = Field(default=None, description="Specifies a name for a new column to contain all unreferenced fields as a single structured object. Only applies if preserve is true. ", alias="embedColumn")
    embed_column_type: Optional[StrictStr] = Field(default=None, description="Specifies the type of structured object that that unreferenced fields will be contained in. Supported values are: json | struct | variant.  Only applies if embedColumn is set. ", alias="embedColumnType")
    omit_columns: Optional[List[StrictStr]] = Field(default=None, description="Lists columns to exclude from the output (either preserved as columns or embedded). Useful for retaining  all columns except the specified ones. ", alias="omitColumns")
    duplicate_prefix: Optional[StrictStr] = Field(default=None, description="Adds a specified prefix to resolve ambiguous duplicate field names. This applies only to \"preserved\" columns that may be duplicative with something in the field specs. ", alias="duplicatePrefix")
    __properties: ClassVar[List[str]] = ["preserve", "embedColumn", "embedColumnType", "omitColumns", "duplicatePrefix"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldUtilsUnreferencedColumns from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if preserve (nullable) is None
        # and model_fields_set contains the field
        if self.preserve is None and "preserve" in self.model_fields_set:
            _dict['preserve'] = None

        # set to None if embed_column (nullable) is None
        # and model_fields_set contains the field
        if self.embed_column is None and "embed_column" in self.model_fields_set:
            _dict['embedColumn'] = None

        # set to None if omit_columns (nullable) is None
        # and model_fields_set contains the field
        if self.omit_columns is None and "omit_columns" in self.model_fields_set:
            _dict['omitColumns'] = None

        # set to None if duplicate_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.duplicate_prefix is None and "duplicate_prefix" in self.model_fields_set:
            _dict['duplicatePrefix'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CoreV1DataSourceFieldUtilsUnreferencedColumns from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "preserve": obj.get("preserve"),
            "embedColumn": obj.get("embedColumn"),
            "embedColumnType": obj.get("embedColumnType"),
            "omitColumns": obj.get("omitColumns"),
            "duplicatePrefix": obj.get("duplicatePrefix")
        })
        return _obj


