# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.core_v1_data_source_field_spec import CoreV1DataSourceFieldSpec
from dasl_api.models.core_v1_data_source_field_utils import CoreV1DataSourceFieldUtils
from typing import Optional, Set
from typing_extensions import Self

class ContentV1DatasourcePresetSilverTransformInner(BaseModel):
    """
    ContentV1DatasourcePresetSilverTransformInner
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of this silver transform definition. This is used to identify the silver table for writes  as well as the data transformation variable (dataframe) for later use in the related notebook. ")
    filter: Optional[StrictStr] = Field(default=None, description="A SQL filter to apply to the data at the beginning of a data transformation stage. ")
    post_filter: Optional[StrictStr] = Field(default=None, description="A SQL filter to apply at the end of a data transformation stage. ", alias="postFilter")
    fields: Optional[List[Optional[CoreV1DataSourceFieldSpec]]] = Field(default=None, description="A list of FieldSpecs that define the column schema for this data transformation. Each FieldSpec will  include a name, type, and other properties that define the column schema. ")
    utils: Optional[CoreV1DataSourceFieldUtils] = Field(default=None, description="A list of utilities for handling fields, including managing unreferenced fields and extracting fields  from hierarchical or JSON objects. ")
    __properties: ClassVar[List[str]] = ["name", "filter", "postFilter", "fields", "utils"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetSilverTransformInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of utils
        if self.utils:
            _dict['utils'] = self.utils.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if filter (nullable) is None
        # and model_fields_set contains the field
        if self.filter is None and "filter" in self.model_fields_set:
            _dict['filter'] = None

        # set to None if post_filter (nullable) is None
        # and model_fields_set contains the field
        if self.post_filter is None and "post_filter" in self.model_fields_set:
            _dict['postFilter'] = None

        # set to None if fields (nullable) is None
        # and model_fields_set contains the field
        if self.fields is None and "fields" in self.model_fields_set:
            _dict['fields'] = None

        # set to None if utils (nullable) is None
        # and model_fields_set contains the field
        if self.utils is None and "utils" in self.model_fields_set:
            _dict['utils'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetSilverTransformInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "filter": obj.get("filter"),
            "postFilter": obj.get("postFilter"),
            "fields": [CoreV1DataSourceFieldSpec.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None,
            "utils": CoreV1DataSourceFieldUtils.from_dict(obj["utils"]) if obj.get("utils") is not None else None
        })
        return _obj


