# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.20
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class CommonV1JobMeta(BaseModel):
    """
    Metadata related to reconciliation job for a reconciled resource. 
    """ # noqa: E501
    last_updated: datetime = Field(alias="lastUpdated")
    last_started: datetime = Field(alias="lastStarted")
    last_completed: datetime = Field(alias="lastCompleted")
    last_deadline: datetime = Field(alias="lastDeadline")
    deleted_at: datetime = Field(alias="deletedAt")
    job_status: StrictStr = Field(alias="jobStatus")
    __properties: ClassVar[List[str]] = ["lastUpdated", "lastStarted", "lastCompleted", "lastDeadline", "deletedAt", "jobStatus"]

    @field_validator('job_status')
    def job_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['idle', 'running']):
            raise ValueError("must be one of enum values ('idle', 'running')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CommonV1JobMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CommonV1JobMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lastUpdated": obj.get("lastUpdated"),
            "lastStarted": obj.get("lastStarted"),
            "lastCompleted": obj.get("lastCompleted"),
            "lastDeadline": obj.get("lastDeadline"),
            "deletedAt": obj.get("deletedAt"),
            "jobStatus": obj.get("jobStatus")
        })
        return _obj


