"""empty message

Revision ID: 976c33d240d0
Revises: 
Create Date: 2023-02-23 14:12:53.160163

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '976c33d240d0'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('clients',
    sa.Column('created_utc', sa.DateTime(), nullable=True),
    sa.Column('client_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('client_name', sa.String(length=255), nullable=False),
    sa.PrimaryKeyConstraint('client_uuid')
    )
    op.create_table('status',
    sa.Column('created_utc', sa.DateTime(), nullable=True),
    sa.Column('status_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('status', sa.String(length=255), nullable=True),
    sa.Column('message', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('status_uuid')
    )
    op.create_table('sites',
    sa.Column('created_utc', sa.DateTime(), nullable=True),
    sa.Column('site_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('client_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('client_site_id', sa.Integer(), nullable=True),
    sa.Column('client_site_name', sa.String(length=255), nullable=True),
    sa.Column('region', sa.String(length=255), nullable=True),
    sa.Column('dno', sa.String(length=255), nullable=True),
    sa.Column('gsp', sa.String(length=255), nullable=True),
    sa.Column('orientation', sa.Float(), nullable=True),
    sa.Column('tilt', sa.Float(), nullable=True),
    sa.Column('latitude', sa.Float(), nullable=True),
    sa.Column('longitude', sa.Float(), nullable=True),
    sa.Column('capacity_kw', sa.Float(), nullable=True),
    sa.Column('ml_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.ForeignKeyConstraint(['client_uuid'], ['clients.client_uuid'], ),
    sa.PrimaryKeyConstraint('site_uuid'),
    sa.UniqueConstraint('client_site_id', 'client_uuid', name='idx_client'),
    sa.UniqueConstraint('ml_id')
    )
    op.create_index(op.f('ix_sites_client_site_id'), 'sites', ['client_site_id'], unique=False)
    op.create_index(op.f('ix_sites_client_site_name'), 'sites', ['client_site_name'], unique=False)
    op.create_table('forecasts',
    sa.Column('created_utc', sa.DateTime(), nullable=True),
    sa.Column('forecast_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('site_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('forecast_version', sa.String(length=32), nullable=False),
    sa.ForeignKeyConstraint(['site_uuid'], ['sites.site_uuid'], ),
    sa.PrimaryKeyConstraint('forecast_uuid')
    )
    op.create_index(op.f('ix_forecasts_site_uuid'), 'forecasts', ['site_uuid'], unique=False)
    op.create_table('generation',
    sa.Column('created_utc', sa.DateTime(), nullable=True),
    sa.Column('generation_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('site_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('generation_power_kw', sa.Float(), nullable=False),
    sa.Column('start_utc', sa.DateTime(), nullable=False),
    sa.Column('end_utc', sa.DateTime(), nullable=False),
    sa.ForeignKeyConstraint(['site_uuid'], ['sites.site_uuid'], ),
    sa.PrimaryKeyConstraint('generation_uuid')
    )
    op.create_index(op.f('ix_generation_site_uuid'), 'generation', ['site_uuid'], unique=False)
    op.create_index(op.f('ix_generation_start_utc'), 'generation', ['start_utc'], unique=False)
    op.create_table('forecast_values',
    sa.Column('created_utc', sa.DateTime(), nullable=True),
    sa.Column('forecast_value_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('start_utc', sa.DateTime(), nullable=False),
    sa.Column('end_utc', sa.DateTime(), nullable=False),
    sa.Column('forecast_power_kw', sa.Float(), nullable=False),
    sa.Column('forecast_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('site_uuid', postgresql.UUID(as_uuid=True), nullable=False),
    sa.ForeignKeyConstraint(['forecast_uuid'], ['forecasts.forecast_uuid'], ),
    sa.ForeignKeyConstraint(['site_uuid'], ['sites.site_uuid'], ),
    sa.PrimaryKeyConstraint('forecast_value_uuid')
    )
    op.create_index(op.f('ix_forecast_values_forecast_uuid'), 'forecast_values', ['forecast_uuid'], unique=False)
    op.create_index(op.f('ix_forecast_values_site_uuid'), 'forecast_values', ['site_uuid'], unique=False)
    op.create_index(op.f('ix_forecast_values_start_utc'), 'forecast_values', ['start_utc'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_forecast_values_start_utc'), table_name='forecast_values')
    op.drop_index(op.f('ix_forecast_values_site_uuid'), table_name='forecast_values')
    op.drop_index(op.f('ix_forecast_values_forecast_uuid'), table_name='forecast_values')
    op.drop_table('forecast_values')
    op.drop_index(op.f('ix_generation_start_utc'), table_name='generation')
    op.drop_index(op.f('ix_generation_site_uuid'), table_name='generation')
    op.drop_table('generation')
    op.drop_index(op.f('ix_forecasts_site_uuid'), table_name='forecasts')
    op.drop_table('forecasts')
    op.drop_index(op.f('ix_sites_client_site_name'), table_name='sites')
    op.drop_index(op.f('ix_sites_client_site_id'), table_name='sites')
    op.drop_table('sites')
    op.drop_table('status')
    op.drop_table('clients')
    # ### end Alembic commands ###
