import numpy as np
from calc11 import almacalc

nant = 1
ntimes = 60

refx = 1000.0
refy = 1299.0
refz = 700.0
antx = np.array([-3101.52])
anty = np.array([-11245.77])
antz = np.array([8916.26])
temp = np.array([30.0])
pressure = np.array([1000.0])
humidity =  np.array([0.7])

mjd = np.array([58701.45833333334, 58701.45902777778,
                58701.45972222222, 58701.46041666667,
                58701.46111111111, 58701.46180555555,
                58701.46250000000, 58701.46319444444,
                58701.46388888889, 58701.46458333333,
                58701.46527777778, 58701.46597222222,
                58701.46666666667, 58701.46736111111,
                58701.46805555555, 58701.46875000000,
                58701.46944444445, 58701.47013888889,
                58701.47083333333, 58701.47152777778,
                58701.47222222222, 58701.47291666667,
                58701.47361111111, 58701.47430555556,
                58701.47500000000, 58701.47569444445,
                58701.47638888889, 58701.47708333333,
                58701.47777777778, 58701.47847222222,
                58701.47916666666, 58701.47986111111,
                58701.48055555556, 58701.48125000000,
                58701.48194444444, 58701.48263888889,
                58701.48333333333, 58701.48402777778,
                58701.48472222222, 58701.48541666667,
                58701.48611111111, 58701.48680555556,
                58701.48750000000, 58701.48819444444,
                58701.48888888889, 58701.48958333334,
                58701.49027777778, 58701.49097222222,
                58701.49166666667, 58701.49236111111,
                58701.49305555555, 58701.49375000000,
                58701.49444444444, 58701.49513888889,
                58701.49583333333, 58701.49652777778,
                58701.49722222222, 58701.49791666667,
                58701.49861111111, 58701.49930555555])
ra  = np.array([2.0] * ntimes)
dec = np.array([1.0] * ntimes)
ssobj = np.zeros(ntimes, dtype=bool)
dx = np.zeros(ntimes)
dy = np.zeros(ntimes)
dut = np.zeros(ntimes)
leapsec = 37.0
axisoff = np.zeros(nant)
sourcename = ['P'] * ntimes
jpx_de421 = '../calc11/data/DE421_little_Endian'

geodelay, drydelay, wetdelay = almacalc(refx, refy, refz, antx, anty,
                                        antz, temp, pressure,
                                        humidity, mjd, ra, dec, ssobj,
                                        dx, dy, dut, leapsec, axisoff,
                                        sourcename, jpx_de421)

print('geodelay:')
print(geodelay)
print('drydelay:')
print(drydelay)
print('wetdelay:')
print(wetdelay)
