# IBM Watson Studio Pipelines Python Client

This package provides various utilities for working with IBM Watson
Studio Pipelines. Its primary usage is to enable users to store
artifact results of a notebook run.


## Usage

### Construction

`WSPipelines` client is constructed from IAM APIKEY, which can be provided
in a few ways:

* explicitly:

  ```python
  from ibm_watson_studio_pipelines import WSPipelines
  
  client = WSPipelines(apikey)
  # or
  client = WSPipelines.from_apikey(apikey)
  ```

* implicitly:

  ```bash
  APIKEY=...
  export APIKEY
  ```

  ```python
  from ibm_watson_studio_pipelines import WSPipelines

  client = WSPipelines()
  # or
  client = WSPipelines.new_instance()
  # or
  client = WSPipelines.from_apikey()
  ```

All of the above may also define `service_name` and `url`.


### Usage in Python notebooks

Notebooks run in IBM Watson Studio Pipelines get inputs and expose
outputs as a node:

```
{
  "id": ...,
  "type": "execution_node",
  "op": "run_container",
  "app_data": {
    "pipeline_data": {
      "name": ...,
      "config": {
        "link": {
          "component_id_ref": "run-notebook"
        }
      },
      "inputs": [
        ...,
        {
          "name": "model_name",
          "group": "env_variables",
          "type": "String",
          "value_from": ...
        }
      ],
      "outputs": [
        {
          "name": "trained_model",
          "group": "output_variables",
          "type": {
            "CPDPath": {
              "path_type": "resource",
              "resource_type": "asset",
              "asset_type": "wml_model"
            }
          }
        }
      ]
    }
  },
  ...
}
```

Inside of the notebook, inputs are available as environmental
variables:

```python
model_name = os.environ['model_name']
```

Outputs are exposed using sdk method, `store_results`:

```python
client = WSPipelines.from_apikey(...)
client.store_results({
  "trained_model": ... // cpd path to the trained model
})
```


### Other features

Client also provides a method to get WML instance credentials:

```python
client.get_wml_credentials() # the scope passed in notebook
# or
client.get_wml_credentials("cpd://projects/123456789")
```


## Contribution

See a separate [document on contribution](CONTRIBUTING.md).
