"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tm = require("../lib/index");
const cdk = require("aws-cdk-lib");
const assertions_1 = require("aws-cdk-lib/assertions");
//#import { StringAttribute } from "aws-cdk-lib/aws-cognito";
describe("ProcessorStack", () => {
    test("synthesizes the way we expect", () => {
        const app = new cdk.App();
        // Since the ProcessorStack consumes resources from a separate stack
        // (cross-stack references), we create a stack for our SNS topics to live
        // in here. These topics can then be passed to the ProcessorStack later,
        // creating a cross-stack reference.
        const userpoolStack = new cdk.Stack(app, "UpStack");
        const userpoolclient = new tm.TmUserPoolClient(userpoolStack, "UserPool", { signInCaseSensitive: true }, {});
        cdk.Tags.of(userpoolclient).add('key', 'value');
        // Prepare the stack for assertions.
        const template = assertions_1.Template.fromStack(userpoolStack);
        console.log(template);
        console.log(JSON.stringify(template));
        template.resourceCountIs("AWS::Cognito::UserPool", 1);
        template.resourceCountIs("AWS::Cognito::UserPoolClient", 2);
    });
});
//# sourceMappingURL=data:application/json;base64,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