# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['IpReverseArgs', 'IpReverse']

@pulumi.input_type
class IpReverseArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 ip_reverse: pulumi.Input[str],
                 reverse: pulumi.Input[str]):
        """
        The set of arguments for constructing a IpReverse resource.
        :param pulumi.Input[str] ip: The IP block to which the IP belongs
        :param pulumi.Input[str] ip_reverse: The IP to set the reverse of
        :param pulumi.Input[str] reverse: The value of the reverse
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "ip_reverse", ip_reverse)
        pulumi.set(__self__, "reverse", reverse)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        The IP block to which the IP belongs
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipReverse")
    def ip_reverse(self) -> pulumi.Input[str]:
        """
        The IP to set the reverse of
        """
        return pulumi.get(self, "ip_reverse")

    @ip_reverse.setter
    def ip_reverse(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_reverse", value)

    @property
    @pulumi.getter
    def reverse(self) -> pulumi.Input[str]:
        """
        The value of the reverse
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: pulumi.Input[str]):
        pulumi.set(self, "reverse", value)


@pulumi.input_type
class _IpReverseState:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_reverse: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IpReverse resources.
        :param pulumi.Input[str] ip: The IP block to which the IP belongs
        :param pulumi.Input[str] ip_reverse: The IP to set the reverse of
        :param pulumi.Input[str] reverse: The value of the reverse
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_reverse is not None:
            pulumi.set(__self__, "ip_reverse", ip_reverse)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP block to which the IP belongs
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipReverse")
    def ip_reverse(self) -> Optional[pulumi.Input[str]]:
        """
        The IP to set the reverse of
        """
        return pulumi.get(self, "ip_reverse")

    @ip_reverse.setter
    def ip_reverse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_reverse", value)

    @property
    @pulumi.getter
    def reverse(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the reverse
        """
        return pulumi.get(self, "reverse")

    @reverse.setter
    def reverse(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reverse", value)


class IpReverse(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_reverse: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a OVH IP reverse.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        # Set the reverse of an IP
        test = ovh.IpReverse("test",
            ip="192.0.2.0/24",
            ip_reverse="192.0.2.1",
            reverse="example.com")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip: The IP block to which the IP belongs
        :param pulumi.Input[str] ip_reverse: The IP to set the reverse of
        :param pulumi.Input[str] reverse: The value of the reverse
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpReverseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OVH IP reverse.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh

        # Set the reverse of an IP
        test = ovh.IpReverse("test",
            ip="192.0.2.0/24",
            ip_reverse="192.0.2.1",
            reverse="example.com")
        ```

        :param str resource_name: The name of the resource.
        :param IpReverseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpReverseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_reverse: Optional[pulumi.Input[str]] = None,
                 reverse: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpReverseArgs.__new__(IpReverseArgs)

            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            if ip_reverse is None and not opts.urn:
                raise TypeError("Missing required property 'ip_reverse'")
            __props__.__dict__["ip_reverse"] = ip_reverse
            if reverse is None and not opts.urn:
                raise TypeError("Missing required property 'reverse'")
            __props__.__dict__["reverse"] = reverse
        super(IpReverse, __self__).__init__(
            'ovh:index/ipReverse:IpReverse',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip: Optional[pulumi.Input[str]] = None,
            ip_reverse: Optional[pulumi.Input[str]] = None,
            reverse: Optional[pulumi.Input[str]] = None) -> 'IpReverse':
        """
        Get an existing IpReverse resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip: The IP block to which the IP belongs
        :param pulumi.Input[str] ip_reverse: The IP to set the reverse of
        :param pulumi.Input[str] reverse: The value of the reverse
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpReverseState.__new__(_IpReverseState)

        __props__.__dict__["ip"] = ip
        __props__.__dict__["ip_reverse"] = ip_reverse
        __props__.__dict__["reverse"] = reverse
        return IpReverse(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        The IP block to which the IP belongs
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipReverse")
    def ip_reverse(self) -> pulumi.Output[str]:
        """
        The IP to set the reverse of
        """
        return pulumi.get(self, "ip_reverse")

    @property
    @pulumi.getter
    def reverse(self) -> pulumi.Output[str]:
        """
        The value of the reverse
        """
        return pulumi.get(self, "reverse")

