/***************************************************************************
  **************************************************************************
    
  Spherical Harmonic Transform Kit 2.7
    
  Copyright 1997-2003  Sean Moore, Dennis Healy,
                       Dan Rockmore, Peter Kostelec
  Copyright 2004  Peter Kostelec, Dan Rockmore

  This file is part of SpharmonicKit.

  SpharmonicKit is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  SpharmonicKit is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
  See the accompanying LICENSE file for details.

  ************************************************************************
  ************************************************************************/

/****

  OUR permutations: permutation arrays used in FCTs. See Sean's
  thesis for details. The interface function (defined at the
  bottom of this file) is

  const int *get_perm(int n)

  ****/

static const int OUR4[4] = {0, 3, 2, 1};

static const int OUR8[8] = {0, 7, 4, 3, 2, 5, 6, 1};

static const int OUR16[16] =
{0, 15, 8, 7, 4, 11, 12, 3, 2, 13, 10, 5, 6, 9, 14, 1};

static const int OUR32[32] = 
{0, 31, 16, 15, 8, 23, 24, 7, 4, 27, 20, 11, 12, 19, 28, 3, 2, 29, 18, 13, 
  10, 21, 26, 5, 6, 25, 22, 9, 14, 17, 30, 1};

static const int OUR64[64] = 
{0, 63, 32, 31, 16, 47, 48, 15, 8, 55, 40, 23, 24, 39, 56, 7, 4, 59, 36, 27, 
  20, 43, 52, 11, 12, 51, 44, 19, 28, 35, 60, 3, 2, 61, 34, 29, 18, 45, 50, 
  13, 10, 53, 42, 21, 26, 37, 58, 5, 6, 57, 38, 25, 22, 41, 54, 9, 14, 49, 
  46, 17, 30, 33, 62, 1};

static const int OUR128[128] = 
{0, 127, 64, 63, 32, 95, 96, 31, 16, 111, 80, 47, 48, 79, 112, 15, 8, 119, 
  72, 55, 40, 87, 104, 23, 24, 103, 88, 39, 56, 71, 120, 7, 4, 123, 68, 59, 
  36, 91, 100, 27, 20, 107, 84, 43, 52, 75, 116, 11, 12, 115, 76, 51, 44, 83, 
  108, 19, 28, 99, 92, 35, 60, 67, 124, 3, 2, 125, 66, 61, 34, 93, 98, 29, 
  18, 109, 82, 45, 50, 77, 114, 13, 10, 117, 74, 53, 42, 85, 106, 21, 26, 
  101, 90, 37, 58, 69, 122, 5, 6, 121, 70, 57, 38, 89, 102, 25, 22, 105, 86, 
  41, 54, 73, 118, 9, 14, 113, 78, 49, 46, 81, 110, 17, 30, 97, 94, 33, 62, 
  65, 126, 1};

static const int OUR256[256] = 
{0, 255, 128, 127, 64, 191, 192, 63, 32, 223, 160, 95, 96, 159, 224, 31, 16, 
  239, 144, 111, 80, 175, 208, 47, 48, 207, 176, 79, 112, 143, 240, 15, 8, 
  247, 136, 119, 72, 183, 200, 55, 40, 215, 168, 87, 104, 151, 232, 23, 24, 
  231, 152, 103, 88, 167, 216, 39, 56, 199, 184, 71, 120, 135, 248, 7, 4, 
  251, 132, 123, 68, 187, 196, 59, 36, 219, 164, 91, 100, 155, 228, 27, 20, 
  235, 148, 107, 84, 171, 212, 43, 52, 203, 180, 75, 116, 139, 244, 11, 12, 
  243, 140, 115, 76, 179, 204, 51, 44, 211, 172, 83, 108, 147, 236, 19, 28, 
  227, 156, 99, 92, 163, 220, 35, 60, 195, 188, 67, 124, 131, 252, 3, 2, 253, 
  130, 125, 66, 189, 194, 61, 34, 221, 162, 93, 98, 157, 226, 29, 18, 237, 
  146, 109, 82, 173, 210, 45, 50, 205, 178, 77, 114, 141, 242, 13, 10, 245, 
  138, 117, 74, 181, 202, 53, 42, 213, 170, 85, 106, 149, 234, 21, 26, 229, 
  154, 101, 90, 165, 218, 37, 58, 197, 186, 69, 122, 133, 250, 5, 6, 249, 
  134, 121, 70, 185, 198, 57, 38, 217, 166, 89, 102, 153, 230, 25, 22, 233, 
  150, 105, 86, 169, 214, 41, 54, 201, 182, 73, 118, 137, 246, 9, 14, 241, 
  142, 113, 78, 177, 206, 49, 46, 209, 174, 81, 110, 145, 238, 17, 30, 225, 
  158, 97, 94, 161, 222, 33, 62, 193, 190, 65, 126, 129, 254, 1};

static const int OUR512[512] = 
{0, 511, 256, 255, 128, 383, 384, 127, 64, 447, 320, 191, 192, 319, 448, 63, 
  32, 479, 288, 223, 160, 351, 416, 95, 96, 415, 352, 159, 224, 287, 480, 31, 
  16, 495, 272, 239, 144, 367, 400, 111, 80, 431, 336, 175, 208, 303, 464, 
  47, 48, 463, 304, 207, 176, 335, 432, 79, 112, 399, 368, 143, 240, 271, 
  496, 15, 8, 503, 264, 247, 136, 375, 392, 119, 72, 439, 328, 183, 200, 311, 
  456, 55, 40, 471, 296, 215, 168, 343, 424, 87, 104, 407, 360, 151, 232, 
  279, 488, 23, 24, 487, 280, 231, 152, 359, 408, 103, 88, 423, 344, 167, 
  216, 295, 472, 39, 56, 455, 312, 199, 184, 327, 440, 71, 120, 391, 376, 
  135, 248, 263, 504, 7, 4, 507, 260, 251, 132, 379, 388, 123, 68, 443, 324, 
  187, 196, 315, 452, 59, 36, 475, 292, 219, 164, 347, 420, 91, 100, 411, 
  356, 155, 228, 283, 484, 27, 20, 491, 276, 235, 148, 363, 404, 107, 84, 
  427, 340, 171, 212, 299, 468, 43, 52, 459, 308, 203, 180, 331, 436, 75, 
  116, 395, 372, 139, 244, 267, 500, 11, 12, 499, 268, 243, 140, 371, 396, 
  115, 76, 435, 332, 179, 204, 307, 460, 51, 44, 467, 300, 211, 172, 339, 
  428, 83, 108, 403, 364, 147, 236, 275, 492, 19, 28, 483, 284, 227, 156, 
  355, 412, 99, 92, 419, 348, 163, 220, 291, 476, 35, 60, 451, 316, 195, 188, 
  323, 444, 67, 124, 387, 380, 131, 252, 259, 508, 3, 2, 509, 258, 253, 130, 
  381, 386, 125, 66, 445, 322, 189, 194, 317, 450, 61, 34, 477, 290, 221, 
  162, 349, 418, 93, 98, 413, 354, 157, 226, 285, 482, 29, 18, 493, 274, 237, 
  146, 365, 402, 109, 82, 429, 338, 173, 210, 301, 466, 45, 50, 461, 306, 
  205, 178, 333, 434, 77, 114, 397, 370, 141, 242, 269, 498, 13, 10, 501, 
  266, 245, 138, 373, 394, 117, 74, 437, 330, 181, 202, 309, 458, 53, 42, 
  469, 298, 213, 170, 341, 426, 85, 106, 405, 362, 149, 234, 277, 490, 21, 
  26, 485, 282, 229, 154, 357, 410, 101, 90, 421, 346, 165, 218, 293, 474, 
  37, 58, 453, 314, 197, 186, 325, 442, 69, 122, 389, 378, 133, 250, 261, 
  506, 5, 6, 505, 262, 249, 134, 377, 390, 121, 70, 441, 326, 185, 198, 313, 
  454, 57, 38, 473, 294, 217, 166, 345, 422, 89, 102, 409, 358, 153, 230, 
  281, 486, 25, 22, 489, 278, 233, 150, 361, 406, 105, 86, 425, 342, 169, 
  214, 297, 470, 41, 54, 457, 310, 201, 182, 329, 438, 73, 118, 393, 374, 
  137, 246, 265, 502, 9, 14, 497, 270, 241, 142, 369, 398, 113, 78, 433, 334, 
  177, 206, 305, 462, 49, 46, 465, 302, 209, 174, 337, 430, 81, 110, 401, 
  366, 145, 238, 273, 494, 17, 30, 481, 286, 225, 158, 353, 414, 97, 94, 417, 
  350, 161, 222, 289, 478, 33, 62, 449, 318, 193, 190, 321, 446, 65, 126, 
  385, 382, 129, 254, 257, 510, 1};



static const int OUR1024[1024] = 
{0, 1023, 512, 511, 256, 767, 768, 255, 128, 895, 640, 383, 384, 639, 896, 
  127, 64, 959, 576, 447, 320, 703, 832, 191, 192, 831, 704, 319, 448, 575, 
  960, 63, 32, 991, 544, 479, 288, 735, 800, 223, 160, 863, 672, 351, 416, 
  607, 928, 95, 96, 927, 608, 415, 352, 671, 864, 159, 224, 799, 736, 287, 
  480, 543, 992, 31, 16, 1007, 528, 495, 272, 751, 784, 239, 144, 879, 656, 
  367, 400, 623, 912, 111, 80, 943, 592, 431, 336, 687, 848, 175, 208, 815, 
  720, 303, 464, 559, 976, 47, 48, 975, 560, 463, 304, 719, 816, 207, 176, 
  847, 688, 335, 432, 591, 944, 79, 112, 911, 624, 399, 368, 655, 880, 143, 
  240, 783, 752, 271, 496, 527, 1008, 15, 8, 1015, 520, 503, 264, 759, 776, 
  247, 136, 887, 648, 375, 392, 631, 904, 119, 72, 951, 584, 439, 328, 695, 
  840, 183, 200, 823, 712, 311, 456, 567, 968, 55, 40, 983, 552, 471, 296, 
  727, 808, 215, 168, 855, 680, 343, 424, 599, 936, 87, 104, 919, 616, 407, 
  360, 663, 872, 151, 232, 791, 744, 279, 488, 535, 1000, 23, 24, 999, 536, 
  487, 280, 743, 792, 231, 152, 871, 664, 359, 408, 615, 920, 103, 88, 935, 
  600, 423, 344, 679, 856, 167, 216, 807, 728, 295, 472, 551, 984, 39, 56, 
  967, 568, 455, 312, 711, 824, 199, 184, 839, 696, 327, 440, 583, 952, 71, 
  120, 903, 632, 391, 376, 647, 888, 135, 248, 775, 760, 263, 504, 519, 1016, 
  7, 4, 1019, 516, 507, 260, 763, 772, 251, 132, 891, 644, 379, 388, 635, 
  900, 123, 68, 955, 580, 443, 324, 699, 836, 187, 196, 827, 708, 315, 452, 
  571, 964, 59, 36, 987, 548, 475, 292, 731, 804, 219, 164, 859, 676, 347, 
  420, 603, 932, 91, 100, 923, 612, 411, 356, 667, 868, 155, 228, 795, 740, 
  283, 484, 539, 996, 27, 20, 1003, 532, 491, 276, 747, 788, 235, 148, 875, 
  660, 363, 404, 619, 916, 107, 84, 939, 596, 427, 340, 683, 852, 171, 212, 
  811, 724, 299, 468, 555, 980, 43, 52, 971, 564, 459, 308, 715, 820, 203, 
  180, 843, 692, 331, 436, 587, 948, 75, 116, 907, 628, 395, 372, 651, 884, 
  139, 244, 779, 756, 267, 500, 523, 1012, 11, 12, 1011, 524, 499, 268, 755, 
  780, 243, 140, 883, 652, 371, 396, 627, 908, 115, 76, 947, 588, 435, 332, 
  691, 844, 179, 204, 819, 716, 307, 460, 563, 972, 51, 44, 979, 556, 467, 
  300, 723, 812, 211, 172, 851, 684, 339, 428, 595, 940, 83, 108, 915, 620, 
  403, 364, 659, 876, 147, 236, 787, 748, 275, 492, 531, 1004, 19, 28, 995, 
  540, 483, 284, 739, 796, 227, 156, 867, 668, 355, 412, 611, 924, 99, 92, 
  931, 604, 419, 348, 675, 860, 163, 220, 803, 732, 291, 476, 547, 988, 35, 
  60, 963, 572, 451, 316, 707, 828, 195, 188, 835, 700, 323, 444, 579, 956, 
  67, 124, 899, 636, 387, 380, 643, 892, 131, 252, 771, 764, 259, 508, 515, 
  1020, 3, 2, 1021, 514, 509, 258, 765, 770, 253, 130, 893, 642, 381, 386, 
  637, 898, 125, 66, 957, 578, 445, 322, 701, 834, 189, 194, 829, 706, 317, 
  450, 573, 962, 61, 34, 989, 546, 477, 290, 733, 802, 221, 162, 861, 674, 
  349, 418, 605, 930, 93, 98, 925, 610, 413, 354, 669, 866, 157, 226, 797, 
  738, 285, 482, 541, 994, 29, 18, 1005, 530, 493, 274, 749, 786, 237, 146, 
  877, 658, 365, 402, 621, 914, 109, 82, 941, 594, 429, 338, 685, 850, 173, 
  210, 813, 722, 301, 466, 557, 978, 45, 50, 973, 562, 461, 306, 717, 818, 
  205, 178, 845, 690, 333, 434, 589, 946, 77, 114, 909, 626, 397, 370, 653, 
  882, 141, 242, 781, 754, 269, 498, 525, 1010, 13, 10, 1013, 522, 501, 266, 
  757, 778, 245, 138, 885, 650, 373, 394, 629, 906, 117, 74, 949, 586, 437, 
  330, 693, 842, 181, 202, 821, 714, 309, 458, 565, 970, 53, 42, 981, 554, 
  469, 298, 725, 810, 213, 170, 853, 682, 341, 426, 597, 938, 85, 106, 917, 
  618, 405, 362, 661, 874, 149, 234, 789, 746, 277, 490, 533, 1002, 21, 26, 
  997, 538, 485, 282, 741, 794, 229, 154, 869, 666, 357, 410, 613, 922, 101, 
  90, 933, 602, 421, 346, 677, 858, 165, 218, 805, 730, 293, 474, 549, 986, 
  37, 58, 965, 570, 453, 314, 709, 826, 197, 186, 837, 698, 325, 442, 581, 
  954, 69, 122, 901, 634, 389, 378, 645, 890, 133, 250, 773, 762, 261, 506, 
  517, 1018, 5, 6, 1017, 518, 505, 262, 761, 774, 249, 134, 889, 646, 377, 
  390, 633, 902, 121, 70, 953, 582, 441, 326, 697, 838, 185, 198, 825, 710, 
  313, 454, 569, 966, 57, 38, 985, 550, 473, 294, 729, 806, 217, 166, 857, 
  678, 345, 422, 601, 934, 89, 102, 921, 614, 409, 358, 665, 870, 153, 230, 
  793, 742, 281, 486, 537, 998, 25, 22, 1001, 534, 489, 278, 745, 790, 233, 
  150, 873, 662, 361, 406, 617, 918, 105, 86, 937, 598, 425, 342, 681, 854, 
  169, 214, 809, 726, 297, 470, 553, 982, 41, 54, 969, 566, 457, 310, 713, 
  822, 201, 182, 841, 694, 329, 438, 585, 950, 73, 118, 905, 630, 393, 374, 
  649, 886, 137, 246, 777, 758, 265, 502, 521, 1014, 9, 14, 1009, 526, 497, 
  270, 753, 782, 241, 142, 881, 654, 369, 398, 625, 910, 113, 78, 945, 590, 
  433, 334, 689, 846, 177, 206, 817, 718, 305, 462, 561, 974, 49, 46, 977, 
  558, 465, 302, 721, 814, 209, 174, 849, 686, 337, 430, 593, 942, 81, 110, 
  913, 622, 401, 366, 657, 878, 145, 238, 785, 750, 273, 494, 529, 1006, 17, 
  30, 993, 542, 481, 286, 737, 798, 225, 158, 865, 670, 353, 414, 609, 926, 
  97, 94, 929, 606, 417, 350, 673, 862, 161, 222, 801, 734, 289, 478, 545, 
  990, 33, 62, 961, 574, 449, 318, 705, 830, 193, 190, 833, 702, 321, 446, 
  577, 958, 65, 126, 897, 638, 385, 382, 641, 894, 129, 254, 769, 766, 257, 
  510, 513, 1022, 1};


static const int OUR2048[2048] = 
{0, 2047, 1024, 1023, 512, 1535, 1536, 511, 256, 1791, 1280, 767, 768, 1279, 
  1792, 255, 128, 1919, 1152, 895, 640, 1407, 1664, 383, 384, 1663, 1408, 
  639, 896, 1151, 1920, 127, 64, 1983, 1088, 959, 576, 1471, 1600, 447, 320, 
  1727, 1344, 703, 832, 1215, 1856, 191, 192, 1855, 1216, 831, 704, 1343, 
  1728, 319, 448, 1599, 1472, 575, 960, 1087, 1984, 63, 32, 2015, 1056, 991, 
  544, 1503, 1568, 479, 288, 1759, 1312, 735, 800, 1247, 1824, 223, 160, 
  1887, 1184, 863, 672, 1375, 1696, 351, 416, 1631, 1440, 607, 928, 1119, 
  1952, 95, 96, 1951, 1120, 927, 608, 1439, 1632, 415, 352, 1695, 1376, 671, 
  864, 1183, 1888, 159, 224, 1823, 1248, 799, 736, 1311, 1760, 287, 480, 
  1567, 1504, 543, 992, 1055, 2016, 31, 16, 2031, 1040, 1007, 528, 1519, 
  1552, 495, 272, 1775, 1296, 751, 784, 1263, 1808, 239, 144, 1903, 1168, 
  879, 656, 1391, 1680, 367, 400, 1647, 1424, 623, 912, 1135, 1936, 111, 80, 
  1967, 1104, 943, 592, 1455, 1616, 431, 336, 1711, 1360, 687, 848, 1199, 
  1872, 175, 208, 1839, 1232, 815, 720, 1327, 1744, 303, 464, 1583, 1488, 
  559, 976, 1071, 2000, 47, 48, 1999, 1072, 975, 560, 1487, 1584, 463, 304, 
  1743, 1328, 719, 816, 1231, 1840, 207, 176, 1871, 1200, 847, 688, 1359, 
  1712, 335, 432, 1615, 1456, 591, 944, 1103, 1968, 79, 112, 1935, 1136, 911, 
  624, 1423, 1648, 399, 368, 1679, 1392, 655, 880, 1167, 1904, 143, 240, 
  1807, 1264, 783, 752, 1295, 1776, 271, 496, 1551, 1520, 527, 1008, 1039, 
  2032, 15, 8, 2039, 1032, 1015, 520, 1527, 1544, 503, 264, 1783, 1288, 759, 
  776, 1271, 1800, 247, 136, 1911, 1160, 887, 648, 1399, 1672, 375, 392, 
  1655, 1416, 631, 904, 1143, 1928, 119, 72, 1975, 1096, 951, 584, 1463, 
  1608, 439, 328, 1719, 1352, 695, 840, 1207, 1864, 183, 200, 1847, 1224, 
  823, 712, 1335, 1736, 311, 456, 1591, 1480, 567, 968, 1079, 1992, 55, 40, 
  2007, 1064, 983, 552, 1495, 1576, 471, 296, 1751, 1320, 727, 808, 1239, 
  1832, 215, 168, 1879, 1192, 855, 680, 1367, 1704, 343, 424, 1623, 1448, 
  599, 936, 1111, 1960, 87, 104, 1943, 1128, 919, 616, 1431, 1640, 407, 360, 
  1687, 1384, 663, 872, 1175, 1896, 151, 232, 1815, 1256, 791, 744, 1303, 
  1768, 279, 488, 1559, 1512, 535, 1000, 1047, 2024, 23, 24, 2023, 1048, 999, 
  536, 1511, 1560, 487, 280, 1767, 1304, 743, 792, 1255, 1816, 231, 152, 
  1895, 1176, 871, 664, 1383, 1688, 359, 408, 1639, 1432, 615, 920, 1127, 
  1944, 103, 88, 1959, 1112, 935, 600, 1447, 1624, 423, 344, 1703, 1368, 679, 
  856, 1191, 1880, 167, 216, 1831, 1240, 807, 728, 1319, 1752, 295, 472, 
  1575, 1496, 551, 984, 1063, 2008, 39, 56, 1991, 1080, 967, 568, 1479, 1592, 
  455, 312, 1735, 1336, 711, 824, 1223, 1848, 199, 184, 1863, 1208, 839, 696, 
  1351, 1720, 327, 440, 1607, 1464, 583, 952, 1095, 1976, 71, 120, 1927, 
  1144, 903, 632, 1415, 1656, 391, 376, 1671, 1400, 647, 888, 1159, 1912, 
  135, 248, 1799, 1272, 775, 760, 1287, 1784, 263, 504, 1543, 1528, 519, 
  1016, 1031, 2040, 7, 4, 2043, 1028, 1019, 516, 1531, 1540, 507, 260, 1787, 
  1284, 763, 772, 1275, 1796, 251, 132, 1915, 1156, 891, 644, 1403, 1668, 
  379, 388, 1659, 1412, 635, 900, 1147, 1924, 123, 68, 1979, 1092, 955, 580, 
  1467, 1604, 443, 324, 1723, 1348, 699, 836, 1211, 1860, 187, 196, 1851, 
  1220, 827, 708, 1339, 1732, 315, 452, 1595, 1476, 571, 964, 1083, 1988, 59, 
  36, 2011, 1060, 987, 548, 1499, 1572, 475, 292, 1755, 1316, 731, 804, 1243, 
  1828, 219, 164, 1883, 1188, 859, 676, 1371, 1700, 347, 420, 1627, 1444, 
  603, 932, 1115, 1956, 91, 100, 1947, 1124, 923, 612, 1435, 1636, 411, 356, 
  1691, 1380, 667, 868, 1179, 1892, 155, 228, 1819, 1252, 795, 740, 1307, 
  1764, 283, 484, 1563, 1508, 539, 996, 1051, 2020, 27, 20, 2027, 1044, 1003, 
  532, 1515, 1556, 491, 276, 1771, 1300, 747, 788, 1259, 1812, 235, 148, 
  1899, 1172, 875, 660, 1387, 1684, 363, 404, 1643, 1428, 619, 916, 1131, 
  1940, 107, 84, 1963, 1108, 939, 596, 1451, 1620, 427, 340, 1707, 1364, 683, 
  852, 1195, 1876, 171, 212, 1835, 1236, 811, 724, 1323, 1748, 299, 468, 
  1579, 1492, 555, 980, 1067, 2004, 43, 52, 1995, 1076, 971, 564, 1483, 1588, 
  459, 308, 1739, 1332, 715, 820, 1227, 1844, 203, 180, 1867, 1204, 843, 692, 
  1355, 1716, 331, 436, 1611, 1460, 587, 948, 1099, 1972, 75, 116, 1931, 
  1140, 907, 628, 1419, 1652, 395, 372, 1675, 1396, 651, 884, 1163, 1908, 
  139, 244, 1803, 1268, 779, 756, 1291, 1780, 267, 500, 1547, 1524, 523, 
  1012, 1035, 2036, 11, 12, 2035, 1036, 1011, 524, 1523, 1548, 499, 268, 
  1779, 1292, 755, 780, 1267, 1804, 243, 140, 1907, 1164, 883, 652, 1395, 
  1676, 371, 396, 1651, 1420, 627, 908, 1139, 1932, 115, 76, 1971, 1100, 947, 
  588, 1459, 1612, 435, 332, 1715, 1356, 691, 844, 1203, 1868, 179, 204, 
  1843, 1228, 819, 716, 1331, 1740, 307, 460, 1587, 1484, 563, 972, 1075, 
  1996, 51, 44, 2003, 1068, 979, 556, 1491, 1580, 467, 300, 1747, 1324, 723, 
  812, 1235, 1836, 211, 172, 1875, 1196, 851, 684, 1363, 1708, 339, 428, 
  1619, 1452, 595, 940, 1107, 1964, 83, 108, 1939, 1132, 915, 620, 1427, 
  1644, 403, 364, 1683, 1388, 659, 876, 1171, 1900, 147, 236, 1811, 1260, 
  787, 748, 1299, 1772, 275, 492, 1555, 1516, 531, 1004, 1043, 2028, 19, 28, 
  2019, 1052, 995, 540, 1507, 1564, 483, 284, 1763, 1308, 739, 796, 1251, 
  1820, 227, 156, 1891, 1180, 867, 668, 1379, 1692, 355, 412, 1635, 1436, 
  611, 924, 1123, 1948, 99, 92, 1955, 1116, 931, 604, 1443, 1628, 419, 348, 
  1699, 1372, 675, 860, 1187, 1884, 163, 220, 1827, 1244, 803, 732, 1315, 
  1756, 291, 476, 1571, 1500, 547, 988, 1059, 2012, 35, 60, 1987, 1084, 963, 
  572, 1475, 1596, 451, 316, 1731, 1340, 707, 828, 1219, 1852, 195, 188, 
  1859, 1212, 835, 700, 1347, 1724, 323, 444, 1603, 1468, 579, 956, 1091, 
  1980, 67, 124, 1923, 1148, 899, 636, 1411, 1660, 387, 380, 1667, 1404, 643, 
  892, 1155, 1916, 131, 252, 1795, 1276, 771, 764, 1283, 1788, 259, 508, 
  1539, 1532, 515, 1020, 1027, 2044, 3, 2, 2045, 1026, 1021, 514, 1533, 1538, 
  509, 258, 1789, 1282, 765, 770, 1277, 1794, 253, 130, 1917, 1154, 893, 642, 
  1405, 1666, 381, 386, 1661, 1410, 637, 898, 1149, 1922, 125, 66, 1981, 
  1090, 957, 578, 1469, 1602, 445, 322, 1725, 1346, 701, 834, 1213, 1858, 
  189, 194, 1853, 1218, 829, 706, 1341, 1730, 317, 450, 1597, 1474, 573, 962, 
  1085, 1986, 61, 34, 2013, 1058, 989, 546, 1501, 1570, 477, 290, 1757, 1314, 
  733, 802, 1245, 1826, 221, 162, 1885, 1186, 861, 674, 1373, 1698, 349, 418, 
  1629, 1442, 605, 930, 1117, 1954, 93, 98, 1949, 1122, 925, 610, 1437, 1634, 
  413, 354, 1693, 1378, 669, 866, 1181, 1890, 157, 226, 1821, 1250, 797, 738, 
  1309, 1762, 285, 482, 1565, 1506, 541, 994, 1053, 2018, 29, 18, 2029, 1042, 
  1005, 530, 1517, 1554, 493, 274, 1773, 1298, 749, 786, 1261, 1810, 237, 
  146, 1901, 1170, 877, 658, 1389, 1682, 365, 402, 1645, 1426, 621, 914, 
  1133, 1938, 109, 82, 1965, 1106, 941, 594, 1453, 1618, 429, 338, 1709, 
  1362, 685, 850, 1197, 1874, 173, 210, 1837, 1234, 813, 722, 1325, 1746, 
  301, 466, 1581, 1490, 557, 978, 1069, 2002, 45, 50, 1997, 1074, 973, 562, 
  1485, 1586, 461, 306, 1741, 1330, 717, 818, 1229, 1842, 205, 178, 1869, 
  1202, 845, 690, 1357, 1714, 333, 434, 1613, 1458, 589, 946, 1101, 1970, 77, 
  114, 1933, 1138, 909, 626, 1421, 1650, 397, 370, 1677, 1394, 653, 882, 
  1165, 1906, 141, 242, 1805, 1266, 781, 754, 1293, 1778, 269, 498, 1549, 
  1522, 525, 1010, 1037, 2034, 13, 10, 2037, 1034, 1013, 522, 1525, 1546, 
  501, 266, 1781, 1290, 757, 778, 1269, 1802, 245, 138, 1909, 1162, 885, 650, 
  1397, 1674, 373, 394, 1653, 1418, 629, 906, 1141, 1930, 117, 74, 1973, 
  1098, 949, 586, 1461, 1610, 437, 330, 1717, 1354, 693, 842, 1205, 1866, 
  181, 202, 1845, 1226, 821, 714, 1333, 1738, 309, 458, 1589, 1482, 565, 970, 
  1077, 1994, 53, 42, 2005, 1066, 981, 554, 1493, 1578, 469, 298, 1749, 1322, 
  725, 810, 1237, 1834, 213, 170, 1877, 1194, 853, 682, 1365, 1706, 341, 426, 
  1621, 1450, 597, 938, 1109, 1962, 85, 106, 1941, 1130, 917, 618, 1429, 
  1642, 405, 362, 1685, 1386, 661, 874, 1173, 1898, 149, 234, 1813, 1258, 
  789, 746, 1301, 1770, 277, 490, 1557, 1514, 533, 1002, 1045, 2026, 21, 26, 
  2021, 1050, 997, 538, 1509, 1562, 485, 282, 1765, 1306, 741, 794, 1253, 
  1818, 229, 154, 1893, 1178, 869, 666, 1381, 1690, 357, 410, 1637, 1434, 
  613, 922, 1125, 1946, 101, 90, 1957, 1114, 933, 602, 1445, 1626, 421, 346, 
  1701, 1370, 677, 858, 1189, 1882, 165, 218, 1829, 1242, 805, 730, 1317, 
  1754, 293, 474, 1573, 1498, 549, 986, 1061, 2010, 37, 58, 1989, 1082, 965, 
  570, 1477, 1594, 453, 314, 1733, 1338, 709, 826, 1221, 1850, 197, 186, 
  1861, 1210, 837, 698, 1349, 1722, 325, 442, 1605, 1466, 581, 954, 1093, 
  1978, 69, 122, 1925, 1146, 901, 634, 1413, 1658, 389, 378, 1669, 1402, 645, 
  890, 1157, 1914, 133, 250, 1797, 1274, 773, 762, 1285, 1786, 261, 506, 
  1541, 1530, 517, 1018, 1029, 2042, 5, 6, 2041, 1030, 1017, 518, 1529, 1542, 
  505, 262, 1785, 1286, 761, 774, 1273, 1798, 249, 134, 1913, 1158, 889, 646, 
  1401, 1670, 377, 390, 1657, 1414, 633, 902, 1145, 1926, 121, 70, 1977, 
  1094, 953, 582, 1465, 1606, 441, 326, 1721, 1350, 697, 838, 1209, 1862, 
  185, 198, 1849, 1222, 825, 710, 1337, 1734, 313, 454, 1593, 1478, 569, 966, 
  1081, 1990, 57, 38, 2009, 1062, 985, 550, 1497, 1574, 473, 294, 1753, 1318, 
  729, 806, 1241, 1830, 217, 166, 1881, 1190, 857, 678, 1369, 1702, 345, 422, 
  1625, 1446, 601, 934, 1113, 1958, 89, 102, 1945, 1126, 921, 614, 1433, 
  1638, 409, 358, 1689, 1382, 665, 870, 1177, 1894, 153, 230, 1817, 1254, 
  793, 742, 1305, 1766, 281, 486, 1561, 1510, 537, 998, 1049, 2022, 25, 22, 
  2025, 1046, 1001, 534, 1513, 1558, 489, 278, 1769, 1302, 745, 790, 1257, 
  1814, 233, 150, 1897, 1174, 873, 662, 1385, 1686, 361, 406, 1641, 1430, 
  617, 918, 1129, 1942, 105, 86, 1961, 1110, 937, 598, 1449, 1622, 425, 342, 
  1705, 1366, 681, 854, 1193, 1878, 169, 214, 1833, 1238, 809, 726, 1321, 
  1750, 297, 470, 1577, 1494, 553, 982, 1065, 2006, 41, 54, 1993, 1078, 969, 
  566, 1481, 1590, 457, 310, 1737, 1334, 713, 822, 1225, 1846, 201, 182, 
  1865, 1206, 841, 694, 1353, 1718, 329, 438, 1609, 1462, 585, 950, 1097, 
  1974, 73, 118, 1929, 1142, 905, 630, 1417, 1654, 393, 374, 1673, 1398, 649, 
  886, 1161, 1910, 137, 246, 1801, 1270, 777, 758, 1289, 1782, 265, 502, 
  1545, 1526, 521, 1014, 1033, 2038, 9, 14, 2033, 1038, 1009, 526, 1521, 
  1550, 497, 270, 1777, 1294, 753, 782, 1265, 1806, 241, 142, 1905, 1166, 
  881, 654, 1393, 1678, 369, 398, 1649, 1422, 625, 910, 1137, 1934, 113, 78, 
  1969, 1102, 945, 590, 1457, 1614, 433, 334, 1713, 1358, 689, 846, 1201, 
  1870, 177, 206, 1841, 1230, 817, 718, 1329, 1742, 305, 462, 1585, 1486, 
  561, 974, 1073, 1998, 49, 46, 2001, 1070, 977, 558, 1489, 1582, 465, 302, 
  1745, 1326, 721, 814, 1233, 1838, 209, 174, 1873, 1198, 849, 686, 1361, 
  1710, 337, 430, 1617, 1454, 593, 942, 1105, 1966, 81, 110, 1937, 1134, 913, 
  622, 1425, 1646, 401, 366, 1681, 1390, 657, 878, 1169, 1902, 145, 238, 
  1809, 1262, 785, 750, 1297, 1774, 273, 494, 1553, 1518, 529, 1006, 1041, 
  2030, 17, 30, 2017, 1054, 993, 542, 1505, 1566, 481, 286, 1761, 1310, 737, 
  798, 1249, 1822, 225, 158, 1889, 1182, 865, 670, 1377, 1694, 353, 414, 
  1633, 1438, 609, 926, 1121, 1950, 97, 94, 1953, 1118, 929, 606, 1441, 1630, 
  417, 350, 1697, 1374, 673, 862, 1185, 1886, 161, 222, 1825, 1246, 801, 734, 
  1313, 1758, 289, 478, 1569, 1502, 545, 990, 1057, 2014, 33, 62, 1985, 1086, 
  961, 574, 1473, 1598, 449, 318, 1729, 1342, 705, 830, 1217, 1854, 193, 190, 
  1857, 1214, 833, 702, 1345, 1726, 321, 446, 1601, 1470, 577, 958, 1089, 
  1982, 65, 126, 1921, 1150, 897, 638, 1409, 1662, 385, 382, 1665, 1406, 641, 
  894, 1153, 1918, 129, 254, 1793, 1278, 769, 766, 1281, 1790, 257, 510, 
  1537, 1534, 513, 1022, 1025, 2046, 1};

static const int OUR4096[4096] = 
{0, 4095, 2048, 2047, 1024, 3071, 3072, 1023, 512, 3583, 2560, 1535, 1536, 
  2559, 3584, 511, 256, 3839, 2304, 1791, 1280, 2815, 3328, 767, 768, 3327, 
  2816, 1279, 1792, 2303, 3840, 255, 128, 3967, 2176, 1919, 1152, 2943, 3200, 
  895, 640, 3455, 2688, 1407, 1664, 2431, 3712, 383, 384, 3711, 2432, 1663, 
  1408, 2687, 3456, 639, 896, 3199, 2944, 1151, 1920, 2175, 3968, 127, 64, 
  4031, 2112, 1983, 1088, 3007, 3136, 959, 576, 3519, 2624, 1471, 1600, 2495, 
  3648, 447, 320, 3775, 2368, 1727, 1344, 2751, 3392, 703, 832, 3263, 2880, 
  1215, 1856, 2239, 3904, 191, 192, 3903, 2240, 1855, 1216, 2879, 3264, 831, 
  704, 3391, 2752, 1343, 1728, 2367, 3776, 319, 448, 3647, 2496, 1599, 1472, 
  2623, 3520, 575, 960, 3135, 3008, 1087, 1984, 2111, 4032, 63, 32, 4063, 
  2080, 2015, 1056, 3039, 3104, 991, 544, 3551, 2592, 1503, 1568, 2527, 3616, 
  479, 288, 3807, 2336, 1759, 1312, 2783, 3360, 735, 800, 3295, 2848, 1247, 
  1824, 2271, 3872, 223, 160, 3935, 2208, 1887, 1184, 2911, 3232, 863, 672, 
  3423, 2720, 1375, 1696, 2399, 3744, 351, 416, 3679, 2464, 1631, 1440, 2655, 
  3488, 607, 928, 3167, 2976, 1119, 1952, 2143, 4000, 95, 96, 3999, 2144, 
  1951, 1120, 2975, 3168, 927, 608, 3487, 2656, 1439, 1632, 2463, 3680, 415, 
  352, 3743, 2400, 1695, 1376, 2719, 3424, 671, 864, 3231, 2912, 1183, 1888, 
  2207, 3936, 159, 224, 3871, 2272, 1823, 1248, 2847, 3296, 799, 736, 3359, 
  2784, 1311, 1760, 2335, 3808, 287, 480, 3615, 2528, 1567, 1504, 2591, 3552, 
  543, 992, 3103, 3040, 1055, 2016, 2079, 4064, 31, 16, 4079, 2064, 2031, 
  1040, 3055, 3088, 1007, 528, 3567, 2576, 1519, 1552, 2543, 3600, 495, 272, 
  3823, 2320, 1775, 1296, 2799, 3344, 751, 784, 3311, 2832, 1263, 1808, 2287, 
  3856, 239, 144, 3951, 2192, 1903, 1168, 2927, 3216, 879, 656, 3439, 2704, 
  1391, 1680, 2415, 3728, 367, 400, 3695, 2448, 1647, 1424, 2671, 3472, 623, 
  912, 3183, 2960, 1135, 1936, 2159, 3984, 111, 80, 4015, 2128, 1967, 1104, 
  2991, 3152, 943, 592, 3503, 2640, 1455, 1616, 2479, 3664, 431, 336, 3759, 
  2384, 1711, 1360, 2735, 3408, 687, 848, 3247, 2896, 1199, 1872, 2223, 3920, 
  175, 208, 3887, 2256, 1839, 1232, 2863, 3280, 815, 720, 3375, 2768, 1327, 
  1744, 2351, 3792, 303, 464, 3631, 2512, 1583, 1488, 2607, 3536, 559, 976, 
  3119, 3024, 1071, 2000, 2095, 4048, 47, 48, 4047, 2096, 1999, 1072, 3023, 
  3120, 975, 560, 3535, 2608, 1487, 1584, 2511, 3632, 463, 304, 3791, 2352, 
  1743, 1328, 2767, 3376, 719, 816, 3279, 2864, 1231, 1840, 2255, 3888, 207, 
  176, 3919, 2224, 1871, 1200, 2895, 3248, 847, 688, 3407, 2736, 1359, 1712, 
  2383, 3760, 335, 432, 3663, 2480, 1615, 1456, 2639, 3504, 591, 944, 3151, 
  2992, 1103, 1968, 2127, 4016, 79, 112, 3983, 2160, 1935, 1136, 2959, 3184, 
  911, 624, 3471, 2672, 1423, 1648, 2447, 3696, 399, 368, 3727, 2416, 1679, 
  1392, 2703, 3440, 655, 880, 3215, 2928, 1167, 1904, 2191, 3952, 143, 240, 
  3855, 2288, 1807, 1264, 2831, 3312, 783, 752, 3343, 2800, 1295, 1776, 2319, 
  3824, 271, 496, 3599, 2544, 1551, 1520, 2575, 3568, 527, 1008, 3087, 3056, 
  1039, 2032, 2063, 4080, 15, 8, 4087, 2056, 2039, 1032, 3063, 3080, 1015, 
  520, 3575, 2568, 1527, 1544, 2551, 3592, 503, 264, 3831, 2312, 1783, 1288, 
  2807, 3336, 759, 776, 3319, 2824, 1271, 1800, 2295, 3848, 247, 136, 3959, 
  2184, 1911, 1160, 2935, 3208, 887, 648, 3447, 2696, 1399, 1672, 2423, 3720, 
  375, 392, 3703, 2440, 1655, 1416, 2679, 3464, 631, 904, 3191, 2952, 1143, 
  1928, 2167, 3976, 119, 72, 4023, 2120, 1975, 1096, 2999, 3144, 951, 584, 
  3511, 2632, 1463, 1608, 2487, 3656, 439, 328, 3767, 2376, 1719, 1352, 2743, 
  3400, 695, 840, 3255, 2888, 1207, 1864, 2231, 3912, 183, 200, 3895, 2248, 
  1847, 1224, 2871, 3272, 823, 712, 3383, 2760, 1335, 1736, 2359, 3784, 311, 
  456, 3639, 2504, 1591, 1480, 2615, 3528, 567, 968, 3127, 3016, 1079, 1992, 
  2103, 4040, 55, 40, 4055, 2088, 2007, 1064, 3031, 3112, 983, 552, 3543, 
  2600, 1495, 1576, 2519, 3624, 471, 296, 3799, 2344, 1751, 1320, 2775, 3368, 
  727, 808, 3287, 2856, 1239, 1832, 2263, 3880, 215, 168, 3927, 2216, 1879, 
  1192, 2903, 3240, 855, 680, 3415, 2728, 1367, 1704, 2391, 3752, 343, 424, 
  3671, 2472, 1623, 1448, 2647, 3496, 599, 936, 3159, 2984, 1111, 1960, 2135, 
  4008, 87, 104, 3991, 2152, 1943, 1128, 2967, 3176, 919, 616, 3479, 2664, 
  1431, 1640, 2455, 3688, 407, 360, 3735, 2408, 1687, 1384, 2711, 3432, 663, 
  872, 3223, 2920, 1175, 1896, 2199, 3944, 151, 232, 3863, 2280, 1815, 1256, 
  2839, 3304, 791, 744, 3351, 2792, 1303, 1768, 2327, 3816, 279, 488, 3607, 
  2536, 1559, 1512, 2583, 3560, 535, 1000, 3095, 3048, 1047, 2024, 2071, 
  4072, 23, 24, 4071, 2072, 2023, 1048, 3047, 3096, 999, 536, 3559, 2584, 
  1511, 1560, 2535, 3608, 487, 280, 3815, 2328, 1767, 1304, 2791, 3352, 743, 
  792, 3303, 2840, 1255, 1816, 2279, 3864, 231, 152, 3943, 2200, 1895, 1176, 
  2919, 3224, 871, 664, 3431, 2712, 1383, 1688, 2407, 3736, 359, 408, 3687, 
  2456, 1639, 1432, 2663, 3480, 615, 920, 3175, 2968, 1127, 1944, 2151, 3992, 
  103, 88, 4007, 2136, 1959, 1112, 2983, 3160, 935, 600, 3495, 2648, 1447, 
  1624, 2471, 3672, 423, 344, 3751, 2392, 1703, 1368, 2727, 3416, 679, 856, 
  3239, 2904, 1191, 1880, 2215, 3928, 167, 216, 3879, 2264, 1831, 1240, 2855, 
  3288, 807, 728, 3367, 2776, 1319, 1752, 2343, 3800, 295, 472, 3623, 2520, 
  1575, 1496, 2599, 3544, 551, 984, 3111, 3032, 1063, 2008, 2087, 4056, 39, 
  56, 4039, 2104, 1991, 1080, 3015, 3128, 967, 568, 3527, 2616, 1479, 1592, 
  2503, 3640, 455, 312, 3783, 2360, 1735, 1336, 2759, 3384, 711, 824, 3271, 
  2872, 1223, 1848, 2247, 3896, 199, 184, 3911, 2232, 1863, 1208, 2887, 3256, 
  839, 696, 3399, 2744, 1351, 1720, 2375, 3768, 327, 440, 3655, 2488, 1607, 
  1464, 2631, 3512, 583, 952, 3143, 3000, 1095, 1976, 2119, 4024, 71, 120, 
  3975, 2168, 1927, 1144, 2951, 3192, 903, 632, 3463, 2680, 1415, 1656, 2439, 
  3704, 391, 376, 3719, 2424, 1671, 1400, 2695, 3448, 647, 888, 3207, 2936, 
  1159, 1912, 2183, 3960, 135, 248, 3847, 2296, 1799, 1272, 2823, 3320, 775, 
  760, 3335, 2808, 1287, 1784, 2311, 3832, 263, 504, 3591, 2552, 1543, 1528, 
  2567, 3576, 519, 1016, 3079, 3064, 1031, 2040, 2055, 4088, 7, 4, 4091, 
  2052, 2043, 1028, 3067, 3076, 1019, 516, 3579, 2564, 1531, 1540, 2555, 
  3588, 507, 260, 3835, 2308, 1787, 1284, 2811, 3332, 763, 772, 3323, 2820, 
  1275, 1796, 2299, 3844, 251, 132, 3963, 2180, 1915, 1156, 2939, 3204, 891, 
  644, 3451, 2692, 1403, 1668, 2427, 3716, 379, 388, 3707, 2436, 1659, 1412, 
  2683, 3460, 635, 900, 3195, 2948, 1147, 1924, 2171, 3972, 123, 68, 4027, 
  2116, 1979, 1092, 3003, 3140, 955, 580, 3515, 2628, 1467, 1604, 2491, 3652, 
  443, 324, 3771, 2372, 1723, 1348, 2747, 3396, 699, 836, 3259, 2884, 1211, 
  1860, 2235, 3908, 187, 196, 3899, 2244, 1851, 1220, 2875, 3268, 827, 708, 
  3387, 2756, 1339, 1732, 2363, 3780, 315, 452, 3643, 2500, 1595, 1476, 2619, 
  3524, 571, 964, 3131, 3012, 1083, 1988, 2107, 4036, 59, 36, 4059, 2084, 
  2011, 1060, 3035, 3108, 987, 548, 3547, 2596, 1499, 1572, 2523, 3620, 475, 
  292, 3803, 2340, 1755, 1316, 2779, 3364, 731, 804, 3291, 2852, 1243, 1828, 
  2267, 3876, 219, 164, 3931, 2212, 1883, 1188, 2907, 3236, 859, 676, 3419, 
  2724, 1371, 1700, 2395, 3748, 347, 420, 3675, 2468, 1627, 1444, 2651, 3492, 
  603, 932, 3163, 2980, 1115, 1956, 2139, 4004, 91, 100, 3995, 2148, 1947, 
  1124, 2971, 3172, 923, 612, 3483, 2660, 1435, 1636, 2459, 3684, 411, 356, 
  3739, 2404, 1691, 1380, 2715, 3428, 667, 868, 3227, 2916, 1179, 1892, 2203, 
  3940, 155, 228, 3867, 2276, 1819, 1252, 2843, 3300, 795, 740, 3355, 2788, 
  1307, 1764, 2331, 3812, 283, 484, 3611, 2532, 1563, 1508, 2587, 3556, 539, 
  996, 3099, 3044, 1051, 2020, 2075, 4068, 27, 20, 4075, 2068, 2027, 1044, 
  3051, 3092, 1003, 532, 3563, 2580, 1515, 1556, 2539, 3604, 491, 276, 3819, 
  2324, 1771, 1300, 2795, 3348, 747, 788, 3307, 2836, 1259, 1812, 2283, 3860, 
  235, 148, 3947, 2196, 1899, 1172, 2923, 3220, 875, 660, 3435, 2708, 1387, 
  1684, 2411, 3732, 363, 404, 3691, 2452, 1643, 1428, 2667, 3476, 619, 916, 
  3179, 2964, 1131, 1940, 2155, 3988, 107, 84, 4011, 2132, 1963, 1108, 2987, 
  3156, 939, 596, 3499, 2644, 1451, 1620, 2475, 3668, 427, 340, 3755, 2388, 
  1707, 1364, 2731, 3412, 683, 852, 3243, 2900, 1195, 1876, 2219, 3924, 171, 
  212, 3883, 2260, 1835, 1236, 2859, 3284, 811, 724, 3371, 2772, 1323, 1748, 
  2347, 3796, 299, 468, 3627, 2516, 1579, 1492, 2603, 3540, 555, 980, 3115, 
  3028, 1067, 2004, 2091, 4052, 43, 52, 4043, 2100, 1995, 1076, 3019, 3124, 
  971, 564, 3531, 2612, 1483, 1588, 2507, 3636, 459, 308, 3787, 2356, 1739, 
  1332, 2763, 3380, 715, 820, 3275, 2868, 1227, 1844, 2251, 3892, 203, 180, 
  3915, 2228, 1867, 1204, 2891, 3252, 843, 692, 3403, 2740, 1355, 1716, 2379, 
  3764, 331, 436, 3659, 2484, 1611, 1460, 2635, 3508, 587, 948, 3147, 2996, 
  1099, 1972, 2123, 4020, 75, 116, 3979, 2164, 1931, 1140, 2955, 3188, 907, 
  628, 3467, 2676, 1419, 1652, 2443, 3700, 395, 372, 3723, 2420, 1675, 1396, 
  2699, 3444, 651, 884, 3211, 2932, 1163, 1908, 2187, 3956, 139, 244, 3851, 
  2292, 1803, 1268, 2827, 3316, 779, 756, 3339, 2804, 1291, 1780, 2315, 3828, 
  267, 500, 3595, 2548, 1547, 1524, 2571, 3572, 523, 1012, 3083, 3060, 1035, 
  2036, 2059, 4084, 11, 12, 4083, 2060, 2035, 1036, 3059, 3084, 1011, 524, 
  3571, 2572, 1523, 1548, 2547, 3596, 499, 268, 3827, 2316, 1779, 1292, 2803, 
  3340, 755, 780, 3315, 2828, 1267, 1804, 2291, 3852, 243, 140, 3955, 2188, 
  1907, 1164, 2931, 3212, 883, 652, 3443, 2700, 1395, 1676, 2419, 3724, 371, 
  396, 3699, 2444, 1651, 1420, 2675, 3468, 627, 908, 3187, 2956, 1139, 1932, 
  2163, 3980, 115, 76, 4019, 2124, 1971, 1100, 2995, 3148, 947, 588, 3507, 
  2636, 1459, 1612, 2483, 3660, 435, 332, 3763, 2380, 1715, 1356, 2739, 3404, 
  691, 844, 3251, 2892, 1203, 1868, 2227, 3916, 179, 204, 3891, 2252, 1843, 
  1228, 2867, 3276, 819, 716, 3379, 2764, 1331, 1740, 2355, 3788, 307, 460, 
  3635, 2508, 1587, 1484, 2611, 3532, 563, 972, 3123, 3020, 1075, 1996, 2099, 
  4044, 51, 44, 4051, 2092, 2003, 1068, 3027, 3116, 979, 556, 3539, 2604, 
  1491, 1580, 2515, 3628, 467, 300, 3795, 2348, 1747, 1324, 2771, 3372, 723, 
  812, 3283, 2860, 1235, 1836, 2259, 3884, 211, 172, 3923, 2220, 1875, 1196, 
  2899, 3244, 851, 684, 3411, 2732, 1363, 1708, 2387, 3756, 339, 428, 3667, 
  2476, 1619, 1452, 2643, 3500, 595, 940, 3155, 2988, 1107, 1964, 2131, 4012, 
  83, 108, 3987, 2156, 1939, 1132, 2963, 3180, 915, 620, 3475, 2668, 1427, 
  1644, 2451, 3692, 403, 364, 3731, 2412, 1683, 1388, 2707, 3436, 659, 876, 
  3219, 2924, 1171, 1900, 2195, 3948, 147, 236, 3859, 2284, 1811, 1260, 2835, 
  3308, 787, 748, 3347, 2796, 1299, 1772, 2323, 3820, 275, 492, 3603, 2540, 
  1555, 1516, 2579, 3564, 531, 1004, 3091, 3052, 1043, 2028, 2067, 4076, 19, 
  28, 4067, 2076, 2019, 1052, 3043, 3100, 995, 540, 3555, 2588, 1507, 1564, 
  2531, 3612, 483, 284, 3811, 2332, 1763, 1308, 2787, 3356, 739, 796, 3299, 
  2844, 1251, 1820, 2275, 3868, 227, 156, 3939, 2204, 1891, 1180, 2915, 3228, 
  867, 668, 3427, 2716, 1379, 1692, 2403, 3740, 355, 412, 3683, 2460, 1635, 
  1436, 2659, 3484, 611, 924, 3171, 2972, 1123, 1948, 2147, 3996, 99, 92, 
  4003, 2140, 1955, 1116, 2979, 3164, 931, 604, 3491, 2652, 1443, 1628, 2467, 
  3676, 419, 348, 3747, 2396, 1699, 1372, 2723, 3420, 675, 860, 3235, 2908, 
  1187, 1884, 2211, 3932, 163, 220, 3875, 2268, 1827, 1244, 2851, 3292, 803, 
  732, 3363, 2780, 1315, 1756, 2339, 3804, 291, 476, 3619, 2524, 1571, 1500, 
  2595, 3548, 547, 988, 3107, 3036, 1059, 2012, 2083, 4060, 35, 60, 4035, 
  2108, 1987, 1084, 3011, 3132, 963, 572, 3523, 2620, 1475, 1596, 2499, 3644, 
  451, 316, 3779, 2364, 1731, 1340, 2755, 3388, 707, 828, 3267, 2876, 1219, 
  1852, 2243, 3900, 195, 188, 3907, 2236, 1859, 1212, 2883, 3260, 835, 700, 
  3395, 2748, 1347, 1724, 2371, 3772, 323, 444, 3651, 2492, 1603, 1468, 2627, 
  3516, 579, 956, 3139, 3004, 1091, 1980, 2115, 4028, 67, 124, 3971, 2172, 
  1923, 1148, 2947, 3196, 899, 636, 3459, 2684, 1411, 1660, 2435, 3708, 387, 
  380, 3715, 2428, 1667, 1404, 2691, 3452, 643, 892, 3203, 2940, 1155, 1916, 
  2179, 3964, 131, 252, 3843, 2300, 1795, 1276, 2819, 3324, 771, 764, 3331, 
  2812, 1283, 1788, 2307, 3836, 259, 508, 3587, 2556, 1539, 1532, 2563, 3580, 
  515, 1020, 3075, 3068, 1027, 2044, 2051, 4092, 3, 2, 4093, 2050, 2045, 
  1026, 3069, 3074, 1021, 514, 3581, 2562, 1533, 1538, 2557, 3586, 509, 258, 
  3837, 2306, 1789, 1282, 2813, 3330, 765, 770, 3325, 2818, 1277, 1794, 2301, 
  3842, 253, 130, 3965, 2178, 1917, 1154, 2941, 3202, 893, 642, 3453, 2690, 
  1405, 1666, 2429, 3714, 381, 386, 3709, 2434, 1661, 1410, 2685, 3458, 637, 
  898, 3197, 2946, 1149, 1922, 2173, 3970, 125, 66, 4029, 2114, 1981, 1090, 
  3005, 3138, 957, 578, 3517, 2626, 1469, 1602, 2493, 3650, 445, 322, 3773, 
  2370, 1725, 1346, 2749, 3394, 701, 834, 3261, 2882, 1213, 1858, 2237, 3906, 
  189, 194, 3901, 2242, 1853, 1218, 2877, 3266, 829, 706, 3389, 2754, 1341, 
  1730, 2365, 3778, 317, 450, 3645, 2498, 1597, 1474, 2621, 3522, 573, 962, 
  3133, 3010, 1085, 1986, 2109, 4034, 61, 34, 4061, 2082, 2013, 1058, 3037, 
  3106, 989, 546, 3549, 2594, 1501, 1570, 2525, 3618, 477, 290, 3805, 2338, 
  1757, 1314, 2781, 3362, 733, 802, 3293, 2850, 1245, 1826, 2269, 3874, 221, 
  162, 3933, 2210, 1885, 1186, 2909, 3234, 861, 674, 3421, 2722, 1373, 1698, 
  2397, 3746, 349, 418, 3677, 2466, 1629, 1442, 2653, 3490, 605, 930, 3165, 
  2978, 1117, 1954, 2141, 4002, 93, 98, 3997, 2146, 1949, 1122, 2973, 3170, 
  925, 610, 3485, 2658, 1437, 1634, 2461, 3682, 413, 354, 3741, 2402, 1693, 
  1378, 2717, 3426, 669, 866, 3229, 2914, 1181, 1890, 2205, 3938, 157, 226, 
  3869, 2274, 1821, 1250, 2845, 3298, 797, 738, 3357, 2786, 1309, 1762, 2333, 
  3810, 285, 482, 3613, 2530, 1565, 1506, 2589, 3554, 541, 994, 3101, 3042, 
  1053, 2018, 2077, 4066, 29, 18, 4077, 2066, 2029, 1042, 3053, 3090, 1005, 
  530, 3565, 2578, 1517, 1554, 2541, 3602, 493, 274, 3821, 2322, 1773, 1298, 
  2797, 3346, 749, 786, 3309, 2834, 1261, 1810, 2285, 3858, 237, 146, 3949, 
  2194, 1901, 1170, 2925, 3218, 877, 658, 3437, 2706, 1389, 1682, 2413, 3730, 
  365, 402, 3693, 2450, 1645, 1426, 2669, 3474, 621, 914, 3181, 2962, 1133, 
  1938, 2157, 3986, 109, 82, 4013, 2130, 1965, 1106, 2989, 3154, 941, 594, 
  3501, 2642, 1453, 1618, 2477, 3666, 429, 338, 3757, 2386, 1709, 1362, 2733, 
  3410, 685, 850, 3245, 2898, 1197, 1874, 2221, 3922, 173, 210, 3885, 2258, 
  1837, 1234, 2861, 3282, 813, 722, 3373, 2770, 1325, 1746, 2349, 3794, 301, 
  466, 3629, 2514, 1581, 1490, 2605, 3538, 557, 978, 3117, 3026, 1069, 2002, 
  2093, 4050, 45, 50, 4045, 2098, 1997, 1074, 3021, 3122, 973, 562, 3533, 
  2610, 1485, 1586, 2509, 3634, 461, 306, 3789, 2354, 1741, 1330, 2765, 3378, 
  717, 818, 3277, 2866, 1229, 1842, 2253, 3890, 205, 178, 3917, 2226, 1869, 
  1202, 2893, 3250, 845, 690, 3405, 2738, 1357, 1714, 2381, 3762, 333, 434, 
  3661, 2482, 1613, 1458, 2637, 3506, 589, 946, 3149, 2994, 1101, 1970, 2125, 
  4018, 77, 114, 3981, 2162, 1933, 1138, 2957, 3186, 909, 626, 3469, 2674, 
  1421, 1650, 2445, 3698, 397, 370, 3725, 2418, 1677, 1394, 2701, 3442, 653, 
  882, 3213, 2930, 1165, 1906, 2189, 3954, 141, 242, 3853, 2290, 1805, 1266, 
  2829, 3314, 781, 754, 3341, 2802, 1293, 1778, 2317, 3826, 269, 498, 3597, 
  2546, 1549, 1522, 2573, 3570, 525, 1010, 3085, 3058, 1037, 2034, 2061, 
  4082, 13, 10, 4085, 2058, 2037, 1034, 3061, 3082, 1013, 522, 3573, 2570, 
  1525, 1546, 2549, 3594, 501, 266, 3829, 2314, 1781, 1290, 2805, 3338, 757, 
  778, 3317, 2826, 1269, 1802, 2293, 3850, 245, 138, 3957, 2186, 1909, 1162, 
  2933, 3210, 885, 650, 3445, 2698, 1397, 1674, 2421, 3722, 373, 394, 3701, 
  2442, 1653, 1418, 2677, 3466, 629, 906, 3189, 2954, 1141, 1930, 2165, 3978, 
  117, 74, 4021, 2122, 1973, 1098, 2997, 3146, 949, 586, 3509, 2634, 1461, 
  1610, 2485, 3658, 437, 330, 3765, 2378, 1717, 1354, 2741, 3402, 693, 842, 
  3253, 2890, 1205, 1866, 2229, 3914, 181, 202, 3893, 2250, 1845, 1226, 2869, 
  3274, 821, 714, 3381, 2762, 1333, 1738, 2357, 3786, 309, 458, 3637, 2506, 
  1589, 1482, 2613, 3530, 565, 970, 3125, 3018, 1077, 1994, 2101, 4042, 53, 
  42, 4053, 2090, 2005, 1066, 3029, 3114, 981, 554, 3541, 2602, 1493, 1578, 
  2517, 3626, 469, 298, 3797, 2346, 1749, 1322, 2773, 3370, 725, 810, 3285, 
  2858, 1237, 1834, 2261, 3882, 213, 170, 3925, 2218, 1877, 1194, 2901, 3242, 
  853, 682, 3413, 2730, 1365, 1706, 2389, 3754, 341, 426, 3669, 2474, 1621, 
  1450, 2645, 3498, 597, 938, 3157, 2986, 1109, 1962, 2133, 4010, 85, 106, 
  3989, 2154, 1941, 1130, 2965, 3178, 917, 618, 3477, 2666, 1429, 1642, 2453, 
  3690, 405, 362, 3733, 2410, 1685, 1386, 2709, 3434, 661, 874, 3221, 2922, 
  1173, 1898, 2197, 3946, 149, 234, 3861, 2282, 1813, 1258, 2837, 3306, 789, 
  746, 3349, 2794, 1301, 1770, 2325, 3818, 277, 490, 3605, 2538, 1557, 1514, 
  2581, 3562, 533, 1002, 3093, 3050, 1045, 2026, 2069, 4074, 21, 26, 4069, 
  2074, 2021, 1050, 3045, 3098, 997, 538, 3557, 2586, 1509, 1562, 2533, 3610, 
  485, 282, 3813, 2330, 1765, 1306, 2789, 3354, 741, 794, 3301, 2842, 1253, 
  1818, 2277, 3866, 229, 154, 3941, 2202, 1893, 1178, 2917, 3226, 869, 666, 
  3429, 2714, 1381, 1690, 2405, 3738, 357, 410, 3685, 2458, 1637, 1434, 2661, 
  3482, 613, 922, 3173, 2970, 1125, 1946, 2149, 3994, 101, 90, 4005, 2138, 
  1957, 1114, 2981, 3162, 933, 602, 3493, 2650, 1445, 1626, 2469, 3674, 421, 
  346, 3749, 2394, 1701, 1370, 2725, 3418, 677, 858, 3237, 2906, 1189, 1882, 
  2213, 3930, 165, 218, 3877, 2266, 1829, 1242, 2853, 3290, 805, 730, 3365, 
  2778, 1317, 1754, 2341, 3802, 293, 474, 3621, 2522, 1573, 1498, 2597, 3546, 
  549, 986, 3109, 3034, 1061, 2010, 2085, 4058, 37, 58, 4037, 2106, 1989, 
  1082, 3013, 3130, 965, 570, 3525, 2618, 1477, 1594, 2501, 3642, 453, 314, 
  3781, 2362, 1733, 1338, 2757, 3386, 709, 826, 3269, 2874, 1221, 1850, 2245, 
  3898, 197, 186, 3909, 2234, 1861, 1210, 2885, 3258, 837, 698, 3397, 2746, 
  1349, 1722, 2373, 3770, 325, 442, 3653, 2490, 1605, 1466, 2629, 3514, 581, 
  954, 3141, 3002, 1093, 1978, 2117, 4026, 69, 122, 3973, 2170, 1925, 1146, 
  2949, 3194, 901, 634, 3461, 2682, 1413, 1658, 2437, 3706, 389, 378, 3717, 
  2426, 1669, 1402, 2693, 3450, 645, 890, 3205, 2938, 1157, 1914, 2181, 3962, 
  133, 250, 3845, 2298, 1797, 1274, 2821, 3322, 773, 762, 3333, 2810, 1285, 
  1786, 2309, 3834, 261, 506, 3589, 2554, 1541, 1530, 2565, 3578, 517, 1018, 
  3077, 3066, 1029, 2042, 2053, 4090, 5, 6, 4089, 2054, 2041, 1030, 3065, 
  3078, 1017, 518, 3577, 2566, 1529, 1542, 2553, 3590, 505, 262, 3833, 2310, 
  1785, 1286, 2809, 3334, 761, 774, 3321, 2822, 1273, 1798, 2297, 3846, 249, 
  134, 3961, 2182, 1913, 1158, 2937, 3206, 889, 646, 3449, 2694, 1401, 1670, 
  2425, 3718, 377, 390, 3705, 2438, 1657, 1414, 2681, 3462, 633, 902, 3193, 
  2950, 1145, 1926, 2169, 3974, 121, 70, 4025, 2118, 1977, 1094, 3001, 3142, 
  953, 582, 3513, 2630, 1465, 1606, 2489, 3654, 441, 326, 3769, 2374, 1721, 
  1350, 2745, 3398, 697, 838, 3257, 2886, 1209, 1862, 2233, 3910, 185, 198, 
  3897, 2246, 1849, 1222, 2873, 3270, 825, 710, 3385, 2758, 1337, 1734, 2361, 
  3782, 313, 454, 3641, 2502, 1593, 1478, 2617, 3526, 569, 966, 3129, 3014, 
  1081, 1990, 2105, 4038, 57, 38, 4057, 2086, 2009, 1062, 3033, 3110, 985, 
  550, 3545, 2598, 1497, 1574, 2521, 3622, 473, 294, 3801, 2342, 1753, 1318, 
  2777, 3366, 729, 806, 3289, 2854, 1241, 1830, 2265, 3878, 217, 166, 3929, 
  2214, 1881, 1190, 2905, 3238, 857, 678, 3417, 2726, 1369, 1702, 2393, 3750, 
  345, 422, 3673, 2470, 1625, 1446, 2649, 3494, 601, 934, 3161, 2982, 1113, 
  1958, 2137, 4006, 89, 102, 3993, 2150, 1945, 1126, 2969, 3174, 921, 614, 
  3481, 2662, 1433, 1638, 2457, 3686, 409, 358, 3737, 2406, 1689, 1382, 2713, 
  3430, 665, 870, 3225, 2918, 1177, 1894, 2201, 3942, 153, 230, 3865, 2278, 
  1817, 1254, 2841, 3302, 793, 742, 3353, 2790, 1305, 1766, 2329, 3814, 281, 
  486, 3609, 2534, 1561, 1510, 2585, 3558, 537, 998, 3097, 3046, 1049, 2022, 
  2073, 4070, 25, 22, 4073, 2070, 2025, 1046, 3049, 3094, 1001, 534, 3561, 
  2582, 1513, 1558, 2537, 3606, 489, 278, 3817, 2326, 1769, 1302, 2793, 3350, 
  745, 790, 3305, 2838, 1257, 1814, 2281, 3862, 233, 150, 3945, 2198, 1897, 
  1174, 2921, 3222, 873, 662, 3433, 2710, 1385, 1686, 2409, 3734, 361, 406, 
  3689, 2454, 1641, 1430, 2665, 3478, 617, 918, 3177, 2966, 1129, 1942, 2153, 
  3990, 105, 86, 4009, 2134, 1961, 1110, 2985, 3158, 937, 598, 3497, 2646, 
  1449, 1622, 2473, 3670, 425, 342, 3753, 2390, 1705, 1366, 2729, 3414, 681, 
  854, 3241, 2902, 1193, 1878, 2217, 3926, 169, 214, 3881, 2262, 1833, 1238, 
  2857, 3286, 809, 726, 3369, 2774, 1321, 1750, 2345, 3798, 297, 470, 3625, 
  2518, 1577, 1494, 2601, 3542, 553, 982, 3113, 3030, 1065, 2006, 2089, 4054, 
  41, 54, 4041, 2102, 1993, 1078, 3017, 3126, 969, 566, 3529, 2614, 1481, 
  1590, 2505, 3638, 457, 310, 3785, 2358, 1737, 1334, 2761, 3382, 713, 822, 
  3273, 2870, 1225, 1846, 2249, 3894, 201, 182, 3913, 2230, 1865, 1206, 2889, 
  3254, 841, 694, 3401, 2742, 1353, 1718, 2377, 3766, 329, 438, 3657, 2486, 
  1609, 1462, 2633, 3510, 585, 950, 3145, 2998, 1097, 1974, 2121, 4022, 73, 
  118, 3977, 2166, 1929, 1142, 2953, 3190, 905, 630, 3465, 2678, 1417, 1654, 
  2441, 3702, 393, 374, 3721, 2422, 1673, 1398, 2697, 3446, 649, 886, 3209, 
  2934, 1161, 1910, 2185, 3958, 137, 246, 3849, 2294, 1801, 1270, 2825, 3318, 
  777, 758, 3337, 2806, 1289, 1782, 2313, 3830, 265, 502, 3593, 2550, 1545, 
  1526, 2569, 3574, 521, 1014, 3081, 3062, 1033, 2038, 2057, 4086, 9, 14, 
  4081, 2062, 2033, 1038, 3057, 3086, 1009, 526, 3569, 2574, 1521, 1550, 
  2545, 3598, 497, 270, 3825, 2318, 1777, 1294, 2801, 3342, 753, 782, 3313, 
  2830, 1265, 1806, 2289, 3854, 241, 142, 3953, 2190, 1905, 1166, 2929, 3214, 
  881, 654, 3441, 2702, 1393, 1678, 2417, 3726, 369, 398, 3697, 2446, 1649, 
  1422, 2673, 3470, 625, 910, 3185, 2958, 1137, 1934, 2161, 3982, 113, 78, 
  4017, 2126, 1969, 1102, 2993, 3150, 945, 590, 3505, 2638, 1457, 1614, 2481, 
  3662, 433, 334, 3761, 2382, 1713, 1358, 2737, 3406, 689, 846, 3249, 2894, 
  1201, 1870, 2225, 3918, 177, 206, 3889, 2254, 1841, 1230, 2865, 3278, 817, 
  718, 3377, 2766, 1329, 1742, 2353, 3790, 305, 462, 3633, 2510, 1585, 1486, 
  2609, 3534, 561, 974, 3121, 3022, 1073, 1998, 2097, 4046, 49, 46, 4049, 
  2094, 2001, 1070, 3025, 3118, 977, 558, 3537, 2606, 1489, 1582, 2513, 3630, 
  465, 302, 3793, 2350, 1745, 1326, 2769, 3374, 721, 814, 3281, 2862, 1233, 
  1838, 2257, 3886, 209, 174, 3921, 2222, 1873, 1198, 2897, 3246, 849, 686, 
  3409, 2734, 1361, 1710, 2385, 3758, 337, 430, 3665, 2478, 1617, 1454, 2641, 
  3502, 593, 942, 3153, 2990, 1105, 1966, 2129, 4014, 81, 110, 3985, 2158, 
  1937, 1134, 2961, 3182, 913, 622, 3473, 2670, 1425, 1646, 2449, 3694, 401, 
  366, 3729, 2414, 1681, 1390, 2705, 3438, 657, 878, 3217, 2926, 1169, 1902, 
  2193, 3950, 145, 238, 3857, 2286, 1809, 1262, 2833, 3310, 785, 750, 3345, 
  2798, 1297, 1774, 2321, 3822, 273, 494, 3601, 2542, 1553, 1518, 2577, 3566, 
  529, 1006, 3089, 3054, 1041, 2030, 2065, 4078, 17, 30, 4065, 2078, 2017, 
  1054, 3041, 3102, 993, 542, 3553, 2590, 1505, 1566, 2529, 3614, 481, 286, 
  3809, 2334, 1761, 1310, 2785, 3358, 737, 798, 3297, 2846, 1249, 1822, 2273, 
  3870, 225, 158, 3937, 2206, 1889, 1182, 2913, 3230, 865, 670, 3425, 2718, 
  1377, 1694, 2401, 3742, 353, 414, 3681, 2462, 1633, 1438, 2657, 3486, 609, 
  926, 3169, 2974, 1121, 1950, 2145, 3998, 97, 94, 4001, 2142, 1953, 1118, 
  2977, 3166, 929, 606, 3489, 2654, 1441, 1630, 2465, 3678, 417, 350, 3745, 
  2398, 1697, 1374, 2721, 3422, 673, 862, 3233, 2910, 1185, 1886, 2209, 3934, 
  161, 222, 3873, 2270, 1825, 1246, 2849, 3294, 801, 734, 3361, 2782, 1313, 
  1758, 2337, 3806, 289, 478, 3617, 2526, 1569, 1502, 2593, 3550, 545, 990, 
  3105, 3038, 1057, 2014, 2081, 4062, 33, 62, 4033, 2110, 1985, 1086, 3009, 
  3134, 961, 574, 3521, 2622, 1473, 1598, 2497, 3646, 449, 318, 3777, 2366, 
  1729, 1342, 2753, 3390, 705, 830, 3265, 2878, 1217, 1854, 2241, 3902, 193, 
  190, 3905, 2238, 1857, 1214, 2881, 3262, 833, 702, 3393, 2750, 1345, 1726, 
  2369, 3774, 321, 446, 3649, 2494, 1601, 1470, 2625, 3518, 577, 958, 3137, 
  3006, 1089, 1982, 2113, 4030, 65, 126, 3969, 2174, 1921, 1150, 2945, 3198, 
  897, 638, 3457, 2686, 1409, 1662, 2433, 3710, 385, 382, 3713, 2430, 1665, 
  1406, 2689, 3454, 641, 894, 3201, 2942, 1153, 1918, 2177, 3966, 129, 254, 
  3841, 2302, 1793, 1278, 2817, 3326, 769, 766, 3329, 2814, 1281, 1790, 2305, 
  3838, 257, 510, 3585, 2558, 1537, 1534, 2561, 3582, 513, 1022, 3073, 3070, 
  1025, 2046, 2049, 4094, 1};



/************************************************************************/
/************************************************************************/

/*** "interface" code to the above arrays ***/

/* returns a pointer to an array containing the OUR permutation
   for the specified problem size n. */

const int *get_perm(int n)
{
  switch(n)
    {
    case 4: return OUR4;
    case 8: return OUR8;
    case 16: return OUR16;
    case 32: return OUR32;
    case 64: return OUR64;
    case 128: return OUR128;
    case 256: return OUR256;
    case 512: return OUR512;
    case 1024: return OUR1024;
    case 2048: return OUR2048;
    case 4096: return OUR4096;
    default: return 0;
    }
}
