# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.model_route_spec import ModelRouteSpec  # noqa: F401,E501
from odahuflow.sdk.models.model_route_status import ModelRouteStatus  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelRoute(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, created_at: str=None, default: bool=None, id: str=None, spec: ModelRouteSpec=None, status: ModelRouteStatus=None, updated_at: str=None):  # noqa: E501
        """ModelRoute - a model defined in Swagger

        :param created_at: The created_at of this ModelRoute.  # noqa: E501
        :type created_at: str
        :param default: The default of this ModelRoute.  # noqa: E501
        :type default: bool
        :param id: The id of this ModelRoute.  # noqa: E501
        :type id: str
        :param spec: The spec of this ModelRoute.  # noqa: E501
        :type spec: ModelRouteSpec
        :param status: The status of this ModelRoute.  # noqa: E501
        :type status: ModelRouteStatus
        :param updated_at: The updated_at of this ModelRoute.  # noqa: E501
        :type updated_at: str
        """
        self.swagger_types = {
            'created_at': str,
            'default': bool,
            'id': str,
            'spec': ModelRouteSpec,
            'status': ModelRouteStatus,
            'updated_at': str
        }

        self.attribute_map = {
            'created_at': 'createdAt',
            'default': 'default',
            'id': 'id',
            'spec': 'spec',
            'status': 'status',
            'updated_at': 'updatedAt'
        }

        self._created_at = created_at
        self._default = default
        self._id = id
        self._spec = spec
        self._status = status
        self._updated_at = updated_at

    @classmethod
    def from_dict(cls, dikt) -> 'ModelRoute':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelRoute of this ModelRoute.  # noqa: E501
        :rtype: ModelRoute
        """
        return util.deserialize_model(dikt, cls)

    @property
    def created_at(self) -> str:
        """Gets the created_at of this ModelRoute.

        CreatedAt  # noqa: E501

        :return: The created_at of this ModelRoute.
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at: str):
        """Sets the created_at of this ModelRoute.

        CreatedAt  # noqa: E501

        :param created_at: The created_at of this ModelRoute.
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def default(self) -> bool:
        """Gets the default of this ModelRoute.

        Default routes cannot be deleted by  They are managed by system One ModelDeployment has exactly one default Route that gives 100% traffic to the model  # noqa: E501

        :return: The default of this ModelRoute.
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default: bool):
        """Sets the default of this ModelRoute.

        Default routes cannot be deleted by  They are managed by system One ModelDeployment has exactly one default Route that gives 100% traffic to the model  # noqa: E501

        :param default: The default of this ModelRoute.
        :type default: bool
        """

        self._default = default

    @property
    def id(self) -> str:
        """Gets the id of this ModelRoute.

        Model route id  # noqa: E501

        :return: The id of this ModelRoute.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this ModelRoute.

        Model route id  # noqa: E501

        :param id: The id of this ModelRoute.
        :type id: str
        """

        self._id = id

    @property
    def spec(self) -> ModelRouteSpec:
        """Gets the spec of this ModelRoute.

        Model route specification  # noqa: E501

        :return: The spec of this ModelRoute.
        :rtype: ModelRouteSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec: ModelRouteSpec):
        """Sets the spec of this ModelRoute.

        Model route specification  # noqa: E501

        :param spec: The spec of this ModelRoute.
        :type spec: ModelRouteSpec
        """

        self._spec = spec

    @property
    def status(self) -> ModelRouteStatus:
        """Gets the status of this ModelRoute.

        Model route status  # noqa: E501

        :return: The status of this ModelRoute.
        :rtype: ModelRouteStatus
        """
        return self._status

    @status.setter
    def status(self, status: ModelRouteStatus):
        """Sets the status of this ModelRoute.

        Model route status  # noqa: E501

        :param status: The status of this ModelRoute.
        :type status: ModelRouteStatus
        """

        self._status = status

    @property
    def updated_at(self) -> str:
        """Gets the updated_at of this ModelRoute.

        UpdatedAt  # noqa: E501

        :return: The updated_at of this ModelRoute.
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at: str):
        """Sets the updated_at of this ModelRoute.

        UpdatedAt  # noqa: E501

        :param updated_at: The updated_at of this ModelRoute.
        :type updated_at: str
        """

        self._updated_at = updated_at
