# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.vault import Vault  # noqa: F401,E501
from odahuflow.sdk.models import util


class ConnectionConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, enabled: bool=None, namespace: str=None, repository_type: str=None, vault: Vault=None):  # noqa: E501
        """ConnectionConfig - a model defined in Swagger

        :param enabled: The enabled of this ConnectionConfig.  # noqa: E501
        :type enabled: bool
        :param namespace: The namespace of this ConnectionConfig.  # noqa: E501
        :type namespace: str
        :param repository_type: The repository_type of this ConnectionConfig.  # noqa: E501
        :type repository_type: str
        :param vault: The vault of this ConnectionConfig.  # noqa: E501
        :type vault: Vault
        """
        self.swagger_types = {
            'enabled': bool,
            'namespace': str,
            'repository_type': str,
            'vault': Vault
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'namespace': 'namespace',
            'repository_type': 'repositoryType',
            'vault': 'vault'
        }

        self._enabled = enabled
        self._namespace = namespace
        self._repository_type = repository_type
        self._vault = vault

    @classmethod
    def from_dict(cls, dikt) -> 'ConnectionConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ConnectionConfig of this ConnectionConfig.  # noqa: E501
        :rtype: ConnectionConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def enabled(self) -> bool:
        """Gets the enabled of this ConnectionConfig.

        Connection API server and operator are enabled  # noqa: E501

        :return: The enabled of this ConnectionConfig.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool):
        """Sets the enabled of this ConnectionConfig.

        Connection API server and operator are enabled  # noqa: E501

        :param enabled: The enabled of this ConnectionConfig.
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def namespace(self) -> str:
        """Gets the namespace of this ConnectionConfig.

        Enable connection API/operator  # noqa: E501

        :return: The namespace of this ConnectionConfig.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str):
        """Sets the namespace of this ConnectionConfig.

        Enable connection API/operator  # noqa: E501

        :param namespace: The namespace of this ConnectionConfig.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def repository_type(self) -> str:
        """Gets the repository_type of this ConnectionConfig.

        Storage backend for connections. Available options:   * kubernetes   * vault  # noqa: E501

        :return: The repository_type of this ConnectionConfig.
        :rtype: str
        """
        return self._repository_type

    @repository_type.setter
    def repository_type(self, repository_type: str):
        """Sets the repository_type of this ConnectionConfig.

        Storage backend for connections. Available options:   * kubernetes   * vault  # noqa: E501

        :param repository_type: The repository_type of this ConnectionConfig.
        :type repository_type: str
        """

        self._repository_type = repository_type

    @property
    def vault(self) -> Vault:
        """Gets the vault of this ConnectionConfig.

        Connection Vault configuration  # noqa: E501

        :return: The vault of this ConnectionConfig.
        :rtype: Vault
        """
        return self._vault

    @vault.setter
    def vault(self, vault: Vault):
        """Sets the vault of this ConnectionConfig.

        Connection Vault configuration  # noqa: E501

        :param vault: The vault of this ConnectionConfig.
        :type vault: Vault
        """

        self._vault = vault
