# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

# pyre-unsafe

# This file contains dummy data for the model unit tests

import numpy as np
import pandas as pd
from pandas import Timestamp

AIR_FCST_LINEAR_95 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 472.9444444444443,
            1: 475.60162835249025,
            2: 478.2588122605362,
            3: 480.9159961685822,
            4: 483.57318007662815,
            5: 486.23036398467417,
            6: 488.88754789272014,
            7: 491.5447318007661,
            8: 494.20191570881207,
            9: 496.85909961685803,
            10: 499.516283524904,
            11: 502.17346743295,
            12: 504.830651340996,
            13: 507.48783524904195,
            14: 510.1450191570879,
            15: 512.8022030651339,
            16: 515.4593869731799,
            17: 518.1165708812258,
            18: 520.7737547892718,
            19: 523.4309386973177,
            20: 526.0881226053638,
            21: 528.7453065134097,
            22: 531.4024904214557,
            23: 534.0596743295017,
            24: 536.7168582375476,
            25: 539.3740421455936,
            26: 542.0312260536396,
            27: 544.6884099616856,
            28: 547.3455938697316,
            29: 550.0027777777775,
        },
        "fcst_lower": {
            0: 380.6292037661305,
            1: 383.26004701147235,
            2: 385.8905370924373,
            3: 388.52067431512216,
            4: 391.1504589893095,
            5: 393.7798914284503,
            6: 396.4089719496461,
            7: 399.0377008736321,
            8: 401.66607852475926,
            9: 404.2941052309762,
            10: 406.9217813238114,
            11: 409.54910713835505,
            12: 412.1760830132403,
            13: 414.80270929062544,
            14: 417.42898631617453,
            15: 420.0549144390392,
            16: 422.68049401183924,
            17: 425.3057253906438,
            18: 427.93060893495215,
            19: 430.555145007674,
            20: 433.1793339751107,
            21: 435.8031762069345,
            22: 438.42667207616984,
            23: 441.0498219591729,
            24: 443.6726262356114,
            25: 446.2950852884452,
            26: 448.91719950390507,
            27: 451.53896927147304,
            28: 454.1603949838614,
            29: 456.78147703699216,
        },
        "fcst_upper": {
            0: 565.2596851227581,
            1: 567.9432096935082,
            2: 570.6270874286351,
            3: 573.3113180220422,
            4: 575.9959011639468,
            5: 578.680836540898,
            6: 581.3661238357942,
            7: 584.0517627279,
            8: 586.7377528928648,
            9: 589.4240940027398,
            10: 592.1107857259966,
            11: 594.797827727545,
            12: 597.4852196687516,
            13: 600.1729612074585,
            14: 602.8610519980012,
            15: 605.5494916912286,
            16: 608.2382799345206,
            17: 610.9274163718079,
            18: 613.6169006435915,
            19: 616.3067323869615,
            20: 618.9969112356168,
            21: 621.6874368198849,
            22: 624.3783087667415,
            23: 627.0695266998305,
            24: 629.7610902394838,
            25: 632.4529990027421,
            26: 635.145252603374,
            27: 637.8378506518982,
            28: 640.5307927556019,
            29: 643.2240785185628,
        },
    }
)

AIR_FCST_LINEAR_99 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 472.9444444444443,
            1: 475.60162835249025,
            2: 478.2588122605362,
            3: 480.9159961685822,
            4: 483.57318007662815,
            5: 486.23036398467417,
            6: 488.88754789272014,
            7: 491.5447318007661,
            8: 494.20191570881207,
            9: 496.85909961685803,
            10: 499.516283524904,
            11: 502.17346743295,
            12: 504.830651340996,
            13: 507.48783524904195,
            14: 510.1450191570879,
            15: 512.8022030651339,
            16: 515.4593869731799,
            17: 518.1165708812258,
            18: 520.7737547892718,
            19: 523.4309386973177,
            20: 526.0881226053638,
            21: 528.7453065134097,
            22: 531.4024904214557,
            23: 534.0596743295017,
            24: 536.7168582375476,
            25: 539.3740421455936,
            26: 542.0312260536396,
            27: 544.6884099616856,
            28: 547.3455938697316,
            29: 550.0027777777775,
        },
        "fcst_lower": {
            0: 351.01805478037915,
            1: 353.64044896268456,
            2: 356.2623766991775,
            3: 358.883838394139,
            4: 361.50483445671773,
            5: 364.12536530090745,
            6: 366.74543134552374,
            7: 369.3650330141812,
            8: 371.98417073526997,
            9: 374.6028449419319,
            10: 377.2210560720369,
            11: 379.83880456815905,
            12: 382.45609087755207,
            13: 385.07291545212513,
            14: 387.68927874841813,
            15: 390.3051812275768,
            16: 392.92062335532785,
            17: 395.5356056019535,
            18: 398.15012844226646,
            19: 400.764192355584,
            20: 403.37779782570226,
            21: 405.99094534087044,
            22: 408.60363539376465,
            23: 411.2158684814615,
            24: 413.82764510541136,
            25: 416.4389657714128,
            26: 419.04983098958445,
            27: 421.66024127433906,
            28: 424.2701971443558,
            29: 426.8796991225531,
        },
        "fcst_upper": {
            0: 594.8708341085095,
            1: 597.562807742296,
            2: 600.255247821895,
            3: 602.9481539430253,
            4: 605.6415256965386,
            5: 608.3353626684409,
            6: 611.0296644399166,
            7: 613.724430587351,
            8: 616.4196606823541,
            9: 619.1153542917842,
            10: 621.8115109777711,
            11: 624.508130297741,
            12: 627.2052118044398,
            13: 629.9027550459588,
            14: 632.6007595657577,
            15: 635.299224902691,
            16: 637.998150591032,
            17: 640.6975361604982,
            18: 643.3973811362772,
            19: 646.0976850390515,
            20: 648.7984473850253,
            21: 651.4996676859489,
            22: 654.2013454491467,
            23: 656.903480177542,
            24: 659.6060713696838,
            25: 662.3091185197744,
            26: 665.0126211176946,
            27: 667.716578649032,
            28: 670.4209905951075,
            29: 673.1258564330019,
        },
    }
)

PEYTON_FCST_LINEAR_95 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.479624727157459,
            1: 8.479984673362159,
            2: 8.480344619566859,
            3: 8.48070456577156,
            4: 8.48106451197626,
            5: 8.48142445818096,
            6: 8.481784404385662,
            7: 8.482144350590362,
            8: 8.482504296795062,
            9: 8.482864242999762,
            10: 8.483224189204464,
            11: 8.483584135409163,
            12: 8.483944081613863,
            13: 8.484304027818565,
            14: 8.484663974023265,
            15: 8.485023920227965,
            16: 8.485383866432667,
            17: 8.485743812637367,
            18: 8.486103758842066,
            19: 8.486463705046766,
            20: 8.486823651251468,
            21: 8.487183597456168,
            22: 8.487543543660868,
            23: 8.48790348986557,
            24: 8.48826343607027,
            25: 8.48862338227497,
            26: 8.48898332847967,
            27: 8.489343274684371,
            28: 8.489703220889071,
            29: 8.490063167093771,
        },
        "fcst_lower": {
            0: 7.055970485245664,
            1: 7.056266316358524,
            2: 7.056561800026597,
            3: 7.056856936297079,
            4: 7.057151725217398,
            5: 7.05744616683524,
            6: 7.057740261198534,
            7: 7.058034008355445,
            8: 7.058327408354395,
            9: 7.058620461244044,
            10: 7.0589131670733005,
            11: 7.059205525891312,
            12: 7.059497537747475,
            13: 7.059789202691431,
            14: 7.0600805207730595,
            15: 7.060371492042489,
            16: 7.060662116550093,
            17: 7.060952394346479,
            18: 7.06124232548251,
            19: 7.0615319100092835,
            20: 7.061821147978145,
            21: 7.062110039440677,
            22: 7.062398584448709,
            23: 7.062686783054313,
            24: 7.0629746353098,
            25: 7.063262141267724,
            26: 7.063549300980883,
            27: 7.063836114502315,
            28: 7.0641225818852975,
            29: 7.064408703183352,
        },
        "fcst_upper": {
            0: 9.903278969069254,
            1: 9.903703030365794,
            2: 9.90412743910712,
            3: 9.904552195246042,
            4: 9.904977298735123,
            5: 9.90540274952668,
            6: 9.90582854757279,
            7: 9.906254692825279,
            8: 9.90668118523573,
            9: 9.90710802475548,
            10: 9.907535211335626,
            11: 9.907962744927016,
            12: 9.908390625480251,
            13: 9.9088188529457,
            14: 9.90924742727347,
            15: 9.909676348413441,
            16: 9.91010561631524,
            17: 9.910535230928254,
            18: 9.910965192201623,
            19: 9.91139550008425,
            20: 9.91182615452479,
            21: 9.912257155471659,
            22: 9.912688502873028,
            23: 9.913120196676825,
            24: 9.91355223683074,
            25: 9.913984623282214,
            26: 9.914417355978456,
            27: 9.914850434866427,
            28: 9.915283859892844,
            29: 9.91571763100419,
        },
    }
)

PEYTON_FCST_LINEAR_99 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.479624727157459,
            1: 8.479984673362159,
            2: 8.480344619566859,
            3: 8.48070456577156,
            4: 8.48106451197626,
            5: 8.48142445818096,
            6: 8.481784404385662,
            7: 8.482144350590362,
            8: 8.482504296795062,
            9: 8.482864242999762,
            10: 8.483224189204464,
            11: 8.483584135409163,
            12: 8.483944081613863,
            13: 8.484304027818565,
            14: 8.484663974023265,
            15: 8.485023920227965,
            16: 8.485383866432667,
            17: 8.485743812637367,
            18: 8.486103758842066,
            19: 8.486463705046766,
            20: 8.486823651251468,
            21: 8.487183597456168,
            22: 8.487543543660868,
            23: 8.48790348986557,
            24: 8.48826343607027,
            25: 8.48862338227497,
            26: 8.48898332847967,
            27: 8.489343274684371,
            28: 8.489703220889071,
            29: 8.490063167093771,
        },
        "fcst_lower": {
            0: 6.605000045325637,
            1: 6.605275566724015,
            2: 6.605550630617649,
            3: 6.605825237068679,
            4: 6.606099386139563,
            5: 6.60637307789309,
            6: 6.606646312392368,
            7: 6.606919089700827,
            8: 6.607191409882221,
            9: 6.607463273000626,
            10: 6.607734679120443,
            11: 6.608005628306389,
            12: 6.608276120623508,
            13: 6.608546156137163,
            14: 6.608815734913038,
            15: 6.609084857017139,
            16: 6.609353522515795,
            17: 6.609621731475649,
            18: 6.609889483963668,
            19: 6.610156780047143,
            20: 6.61042361979368,
            21: 6.610690003271204,
            22: 6.610955930547961,
            23: 6.611221401692519,
            24: 6.611486416773756,
            25: 6.611750975860878,
            26: 6.612015079023405,
            27: 6.612278726331177,
            28: 6.612541917854348,
            29: 6.612804653663393,
        },
        "fcst_upper": {
            0: 10.354249408989281,
            1: 10.354693780000304,
            2: 10.355138608516068,
            3: 10.355583894474442,
            4: 10.356029637812957,
            5: 10.35647583846883,
            6: 10.356922496378955,
            7: 10.357369611479896,
            8: 10.357817183707903,
            9: 10.358265212998898,
            10: 10.358713699288483,
            11: 10.359162642511938,
            12: 10.359612042604219,
            13: 10.360061899499968,
            14: 10.360512213133493,
            15: 10.36096298343879,
            16: 10.361414210349539,
            17: 10.361865893799084,
            18: 10.362318033720465,
            19: 10.36277063004639,
            20: 10.363223682709256,
            21: 10.363677191641132,
            22: 10.364131156773775,
            23: 10.364585578038621,
            24: 10.365040455366783,
            25: 10.365495788689062,
            26: 10.365951577935935,
            27: 10.366407823037564,
            28: 10.366864523923793,
            29: 10.36732168052415,
        },
    }
)

PEYTON_FCST_LINEAR_INVALID_ZERO = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2012-05-02 00:00:00"),
            1: pd.Timestamp("2012-05-03 00:00:00"),
            2: pd.Timestamp("2012-05-04 00:00:00"),
            3: pd.Timestamp("2012-05-05 00:00:00"),
            4: pd.Timestamp("2012-05-06 00:00:00"),
            5: pd.Timestamp("2012-05-07 00:00:00"),
            6: pd.Timestamp("2012-05-08 00:00:00"),
            7: pd.Timestamp("2012-05-09 00:00:00"),
            8: pd.Timestamp("2012-05-10 00:00:00"),
            9: pd.Timestamp("2012-05-11 00:00:00"),
            10: pd.Timestamp("2012-05-12 00:00:00"),
            11: pd.Timestamp("2012-05-13 00:00:00"),
            12: pd.Timestamp("2012-05-14 00:00:00"),
            13: pd.Timestamp("2012-05-15 00:00:00"),
            14: pd.Timestamp("2012-05-16 00:00:00"),
            15: pd.Timestamp("2012-05-17 00:00:00"),
            16: pd.Timestamp("2012-05-18 00:00:00"),
            17: pd.Timestamp("2012-05-19 00:00:00"),
            18: pd.Timestamp("2012-05-20 00:00:00"),
            19: pd.Timestamp("2012-05-21 00:00:00"),
            20: pd.Timestamp("2012-05-22 00:00:00"),
            21: pd.Timestamp("2012-05-23 00:00:00"),
            22: pd.Timestamp("2012-05-24 00:00:00"),
            23: pd.Timestamp("2012-05-25 00:00:00"),
            24: pd.Timestamp("2012-05-26 00:00:00"),
            25: pd.Timestamp("2012-05-27 00:00:00"),
            26: pd.Timestamp("2012-05-28 00:00:00"),
            27: pd.Timestamp("2012-05-29 00:00:00"),
            28: pd.Timestamp("2012-05-30 00:00:00"),
            29: pd.Timestamp("2012-05-31 00:00:00"),
            30: pd.Timestamp("2012-06-01 00:00:00"),
            31: pd.Timestamp("2012-06-02 00:00:00"),
            32: pd.Timestamp("2012-06-03 00:00:00"),
            33: pd.Timestamp("2012-06-04 00:00:00"),
            34: pd.Timestamp("2012-06-05 00:00:00"),
            35: pd.Timestamp("2012-06-06 00:00:00"),
            36: pd.Timestamp("2012-06-07 00:00:00"),
            37: pd.Timestamp("2012-06-08 00:00:00"),
            38: pd.Timestamp("2012-06-09 00:00:00"),
            39: pd.Timestamp("2012-06-10 00:00:00"),
            40: pd.Timestamp("2012-06-11 00:00:00"),
            41: pd.Timestamp("2012-06-12 00:00:00"),
            42: pd.Timestamp("2012-06-13 00:00:00"),
            43: pd.Timestamp("2012-06-14 00:00:00"),
            44: pd.Timestamp("2012-06-15 00:00:00"),
            45: pd.Timestamp("2012-06-16 00:00:00"),
            46: pd.Timestamp("2012-06-17 00:00:00"),
            47: pd.Timestamp("2012-06-18 00:00:00"),
            48: pd.Timestamp("2012-06-19 00:00:00"),
            49: pd.Timestamp("2012-06-20 00:00:00"),
            50: pd.Timestamp("2012-06-21 00:00:00"),
            51: pd.Timestamp("2012-06-22 00:00:00"),
            52: pd.Timestamp("2012-06-23 00:00:00"),
            53: pd.Timestamp("2012-06-24 00:00:00"),
            54: pd.Timestamp("2012-06-25 00:00:00"),
            55: pd.Timestamp("2012-06-26 00:00:00"),
            56: pd.Timestamp("2012-06-27 00:00:00"),
            57: pd.Timestamp("2012-06-28 00:00:00"),
            58: pd.Timestamp("2012-06-29 00:00:00"),
            59: pd.Timestamp("2012-06-30 00:00:00"),
            60: pd.Timestamp("2012-07-01 00:00:00"),
            61: pd.Timestamp("2012-07-02 00:00:00"),
            62: pd.Timestamp("2012-07-03 00:00:00"),
            63: pd.Timestamp("2012-07-04 00:00:00"),
            64: pd.Timestamp("2012-07-05 00:00:00"),
            65: pd.Timestamp("2012-07-06 00:00:00"),
            66: pd.Timestamp("2012-07-07 00:00:00"),
            67: pd.Timestamp("2012-07-08 00:00:00"),
            68: pd.Timestamp("2012-07-09 00:00:00"),
            69: pd.Timestamp("2012-07-10 00:00:00"),
            70: pd.Timestamp("2012-07-11 00:00:00"),
            71: pd.Timestamp("2012-07-12 00:00:00"),
            72: pd.Timestamp("2012-07-13 00:00:00"),
            73: pd.Timestamp("2012-07-14 00:00:00"),
            74: pd.Timestamp("2012-07-15 00:00:00"),
            75: pd.Timestamp("2012-07-16 00:00:00"),
            76: pd.Timestamp("2012-07-17 00:00:00"),
            77: pd.Timestamp("2012-07-18 00:00:00"),
            78: pd.Timestamp("2012-07-19 00:00:00"),
            79: pd.Timestamp("2012-07-20 00:00:00"),
            80: pd.Timestamp("2012-07-21 00:00:00"),
            81: pd.Timestamp("2012-07-22 00:00:00"),
            82: pd.Timestamp("2012-07-23 00:00:00"),
            83: pd.Timestamp("2012-07-24 00:00:00"),
            84: pd.Timestamp("2012-07-25 00:00:00"),
            85: pd.Timestamp("2012-07-26 00:00:00"),
            86: pd.Timestamp("2012-07-27 00:00:00"),
            87: pd.Timestamp("2012-07-28 00:00:00"),
            88: pd.Timestamp("2012-07-29 00:00:00"),
            89: pd.Timestamp("2012-07-30 00:00:00"),
            90: pd.Timestamp("2012-07-31 00:00:00"),
            91: pd.Timestamp("2012-08-01 00:00:00"),
            92: pd.Timestamp("2012-08-02 00:00:00"),
            93: pd.Timestamp("2012-08-03 00:00:00"),
            94: pd.Timestamp("2012-08-04 00:00:00"),
            95: pd.Timestamp("2012-08-05 00:00:00"),
            96: pd.Timestamp("2012-08-06 00:00:00"),
            97: pd.Timestamp("2012-08-07 00:00:00"),
            98: pd.Timestamp("2012-08-08 00:00:00"),
            99: pd.Timestamp("2012-08-09 00:00:00"),
            100: pd.Timestamp("2012-08-10 00:00:00"),
            101: pd.Timestamp("2012-08-11 00:00:00"),
            102: pd.Timestamp("2012-08-12 00:00:00"),
            103: pd.Timestamp("2012-08-13 00:00:00"),
            104: pd.Timestamp("2012-08-14 00:00:00"),
            105: pd.Timestamp("2012-08-15 00:00:00"),
            106: pd.Timestamp("2012-08-16 00:00:00"),
            107: pd.Timestamp("2012-08-17 00:00:00"),
            108: pd.Timestamp("2012-08-18 00:00:00"),
            109: pd.Timestamp("2012-08-19 00:00:00"),
            110: pd.Timestamp("2012-08-20 00:00:00"),
            111: pd.Timestamp("2012-08-21 00:00:00"),
            112: pd.Timestamp("2012-08-22 00:00:00"),
            113: pd.Timestamp("2012-08-23 00:00:00"),
            114: pd.Timestamp("2012-08-24 00:00:00"),
            115: pd.Timestamp("2012-08-25 00:00:00"),
            116: pd.Timestamp("2012-08-26 00:00:00"),
            117: pd.Timestamp("2012-08-27 00:00:00"),
            118: pd.Timestamp("2012-08-28 00:00:00"),
            119: pd.Timestamp("2012-08-29 00:00:00"),
            120: pd.Timestamp("2012-08-30 00:00:00"),
            121: pd.Timestamp("2012-08-31 00:00:00"),
            122: pd.Timestamp("2012-09-01 00:00:00"),
            123: pd.Timestamp("2012-09-02 00:00:00"),
            124: pd.Timestamp("2012-09-03 00:00:00"),
            125: pd.Timestamp("2012-09-04 00:00:00"),
            126: pd.Timestamp("2012-09-05 00:00:00"),
            127: pd.Timestamp("2012-09-06 00:00:00"),
            128: pd.Timestamp("2012-09-07 00:00:00"),
            129: pd.Timestamp("2012-09-08 00:00:00"),
            130: pd.Timestamp("2012-09-09 00:00:00"),
            131: pd.Timestamp("2012-09-10 00:00:00"),
            132: pd.Timestamp("2012-09-11 00:00:00"),
            133: pd.Timestamp("2012-09-12 00:00:00"),
            134: pd.Timestamp("2012-09-13 00:00:00"),
            135: pd.Timestamp("2012-09-14 00:00:00"),
            136: pd.Timestamp("2012-09-15 00:00:00"),
            137: pd.Timestamp("2012-09-16 00:00:00"),
            138: pd.Timestamp("2012-09-17 00:00:00"),
            139: pd.Timestamp("2012-09-18 00:00:00"),
            140: pd.Timestamp("2012-09-19 00:00:00"),
            141: pd.Timestamp("2012-09-20 00:00:00"),
            142: pd.Timestamp("2012-09-21 00:00:00"),
            143: pd.Timestamp("2012-09-22 00:00:00"),
            144: pd.Timestamp("2012-09-23 00:00:00"),
            145: pd.Timestamp("2012-09-24 00:00:00"),
            146: pd.Timestamp("2012-09-25 00:00:00"),
            147: pd.Timestamp("2012-09-26 00:00:00"),
            148: pd.Timestamp("2012-09-27 00:00:00"),
            149: pd.Timestamp("2012-09-28 00:00:00"),
            150: pd.Timestamp("2012-09-29 00:00:00"),
            151: pd.Timestamp("2012-09-30 00:00:00"),
            152: pd.Timestamp("2012-10-01 00:00:00"),
            153: pd.Timestamp("2012-10-02 00:00:00"),
            154: pd.Timestamp("2012-10-03 00:00:00"),
            155: pd.Timestamp("2012-10-04 00:00:00"),
            156: pd.Timestamp("2012-10-05 00:00:00"),
            157: pd.Timestamp("2012-10-06 00:00:00"),
            158: pd.Timestamp("2012-10-07 00:00:00"),
            159: pd.Timestamp("2012-10-08 00:00:00"),
            160: pd.Timestamp("2012-10-09 00:00:00"),
            161: pd.Timestamp("2012-10-10 00:00:00"),
            162: pd.Timestamp("2012-10-11 00:00:00"),
            163: pd.Timestamp("2012-10-12 00:00:00"),
            164: pd.Timestamp("2012-10-13 00:00:00"),
            165: pd.Timestamp("2012-10-14 00:00:00"),
            166: pd.Timestamp("2012-10-15 00:00:00"),
            167: pd.Timestamp("2012-10-16 00:00:00"),
            168: pd.Timestamp("2012-10-17 00:00:00"),
            169: pd.Timestamp("2012-10-18 00:00:00"),
            170: pd.Timestamp("2012-10-19 00:00:00"),
            171: pd.Timestamp("2012-10-20 00:00:00"),
            172: pd.Timestamp("2012-10-21 00:00:00"),
            173: pd.Timestamp("2012-10-22 00:00:00"),
            174: pd.Timestamp("2012-10-23 00:00:00"),
            175: pd.Timestamp("2012-10-24 00:00:00"),
            176: pd.Timestamp("2012-10-25 00:00:00"),
            177: pd.Timestamp("2012-10-26 00:00:00"),
            178: pd.Timestamp("2012-10-27 00:00:00"),
            179: pd.Timestamp("2012-10-28 00:00:00"),
            180: pd.Timestamp("2012-10-29 00:00:00"),
            181: pd.Timestamp("2012-10-30 00:00:00"),
            182: pd.Timestamp("2012-10-31 00:00:00"),
            183: pd.Timestamp("2012-11-01 00:00:00"),
            184: pd.Timestamp("2012-11-02 00:00:00"),
            185: pd.Timestamp("2012-11-03 00:00:00"),
            186: pd.Timestamp("2012-11-04 00:00:00"),
            187: pd.Timestamp("2012-11-05 00:00:00"),
            188: pd.Timestamp("2012-11-06 00:00:00"),
            189: pd.Timestamp("2012-11-07 00:00:00"),
            190: pd.Timestamp("2012-11-08 00:00:00"),
            191: pd.Timestamp("2012-11-09 00:00:00"),
            192: pd.Timestamp("2012-11-10 00:00:00"),
            193: pd.Timestamp("2012-11-11 00:00:00"),
            194: pd.Timestamp("2012-11-12 00:00:00"),
            195: pd.Timestamp("2012-11-13 00:00:00"),
            196: pd.Timestamp("2012-11-14 00:00:00"),
            197: pd.Timestamp("2012-11-15 00:00:00"),
            198: pd.Timestamp("2012-11-16 00:00:00"),
            199: pd.Timestamp("2012-11-17 00:00:00"),
            200: pd.Timestamp("2012-11-18 00:00:00"),
            201: pd.Timestamp("2012-11-19 00:00:00"),
            202: pd.Timestamp("2012-11-20 00:00:00"),
            203: pd.Timestamp("2012-11-21 00:00:00"),
            204: pd.Timestamp("2012-11-22 00:00:00"),
            205: pd.Timestamp("2012-11-23 00:00:00"),
            206: pd.Timestamp("2012-11-24 00:00:00"),
            207: pd.Timestamp("2012-11-25 00:00:00"),
            208: pd.Timestamp("2012-11-26 00:00:00"),
            209: pd.Timestamp("2012-11-27 00:00:00"),
            210: pd.Timestamp("2012-11-28 00:00:00"),
            211: pd.Timestamp("2012-11-29 00:00:00"),
            212: pd.Timestamp("2012-11-30 00:00:00"),
            213: pd.Timestamp("2012-12-01 00:00:00"),
            214: pd.Timestamp("2012-12-02 00:00:00"),
            215: pd.Timestamp("2012-12-03 00:00:00"),
            216: pd.Timestamp("2012-12-04 00:00:00"),
            217: pd.Timestamp("2012-12-05 00:00:00"),
            218: pd.Timestamp("2012-12-06 00:00:00"),
            219: pd.Timestamp("2012-12-07 00:00:00"),
            220: pd.Timestamp("2012-12-08 00:00:00"),
            221: pd.Timestamp("2012-12-09 00:00:00"),
            222: pd.Timestamp("2012-12-10 00:00:00"),
            223: pd.Timestamp("2012-12-11 00:00:00"),
            224: pd.Timestamp("2012-12-12 00:00:00"),
            225: pd.Timestamp("2012-12-13 00:00:00"),
            226: pd.Timestamp("2012-12-14 00:00:00"),
            227: pd.Timestamp("2012-12-15 00:00:00"),
            228: pd.Timestamp("2012-12-16 00:00:00"),
            229: pd.Timestamp("2012-12-17 00:00:00"),
            230: pd.Timestamp("2012-12-18 00:00:00"),
            231: pd.Timestamp("2012-12-19 00:00:00"),
            232: pd.Timestamp("2012-12-20 00:00:00"),
            233: pd.Timestamp("2012-12-21 00:00:00"),
            234: pd.Timestamp("2012-12-22 00:00:00"),
            235: pd.Timestamp("2012-12-23 00:00:00"),
            236: pd.Timestamp("2012-12-24 00:00:00"),
            237: pd.Timestamp("2012-12-25 00:00:00"),
            238: pd.Timestamp("2012-12-26 00:00:00"),
            239: pd.Timestamp("2012-12-27 00:00:00"),
            240: pd.Timestamp("2012-12-28 00:00:00"),
            241: pd.Timestamp("2012-12-29 00:00:00"),
            242: pd.Timestamp("2012-12-30 00:00:00"),
            243: pd.Timestamp("2012-12-31 00:00:00"),
            244: pd.Timestamp("2013-01-01 00:00:00"),
            245: pd.Timestamp("2013-01-02 00:00:00"),
            246: pd.Timestamp("2013-01-03 00:00:00"),
            247: pd.Timestamp("2013-01-04 00:00:00"),
            248: pd.Timestamp("2013-01-05 00:00:00"),
            249: pd.Timestamp("2013-01-06 00:00:00"),
            250: pd.Timestamp("2013-01-07 00:00:00"),
            251: pd.Timestamp("2013-01-08 00:00:00"),
            252: pd.Timestamp("2013-01-09 00:00:00"),
            253: pd.Timestamp("2013-01-10 00:00:00"),
            254: pd.Timestamp("2013-01-11 00:00:00"),
            255: pd.Timestamp("2013-01-12 00:00:00"),
            256: pd.Timestamp("2013-01-13 00:00:00"),
            257: pd.Timestamp("2013-01-14 00:00:00"),
            258: pd.Timestamp("2013-01-15 00:00:00"),
            259: pd.Timestamp("2013-01-16 00:00:00"),
            260: pd.Timestamp("2013-01-17 00:00:00"),
            261: pd.Timestamp("2013-01-18 00:00:00"),
            262: pd.Timestamp("2013-01-19 00:00:00"),
            263: pd.Timestamp("2013-01-20 00:00:00"),
            264: pd.Timestamp("2013-01-21 00:00:00"),
            265: pd.Timestamp("2013-01-22 00:00:00"),
            266: pd.Timestamp("2013-01-23 00:00:00"),
            267: pd.Timestamp("2013-01-24 00:00:00"),
            268: pd.Timestamp("2013-01-25 00:00:00"),
            269: pd.Timestamp("2013-01-26 00:00:00"),
            270: pd.Timestamp("2013-01-27 00:00:00"),
            271: pd.Timestamp("2013-01-28 00:00:00"),
            272: pd.Timestamp("2013-01-29 00:00:00"),
            273: pd.Timestamp("2013-01-30 00:00:00"),
            274: pd.Timestamp("2013-01-31 00:00:00"),
            275: pd.Timestamp("2013-02-01 00:00:00"),
            276: pd.Timestamp("2013-02-02 00:00:00"),
            277: pd.Timestamp("2013-02-03 00:00:00"),
            278: pd.Timestamp("2013-02-04 00:00:00"),
            279: pd.Timestamp("2013-02-05 00:00:00"),
            280: pd.Timestamp("2013-02-06 00:00:00"),
            281: pd.Timestamp("2013-02-07 00:00:00"),
            282: pd.Timestamp("2013-02-08 00:00:00"),
            283: pd.Timestamp("2013-02-09 00:00:00"),
            284: pd.Timestamp("2013-02-10 00:00:00"),
            285: pd.Timestamp("2013-02-11 00:00:00"),
            286: pd.Timestamp("2013-02-12 00:00:00"),
            287: pd.Timestamp("2013-02-13 00:00:00"),
            288: pd.Timestamp("2013-02-14 00:00:00"),
            289: pd.Timestamp("2013-02-15 00:00:00"),
            290: pd.Timestamp("2013-02-16 00:00:00"),
            291: pd.Timestamp("2013-02-17 00:00:00"),
            292: pd.Timestamp("2013-02-18 00:00:00"),
            293: pd.Timestamp("2013-02-19 00:00:00"),
            294: pd.Timestamp("2013-02-20 00:00:00"),
            295: pd.Timestamp("2013-02-21 00:00:00"),
            296: pd.Timestamp("2013-02-22 00:00:00"),
            297: pd.Timestamp("2013-02-23 00:00:00"),
            298: pd.Timestamp("2013-02-24 00:00:00"),
            299: pd.Timestamp("2013-02-25 00:00:00"),
            300: pd.Timestamp("2013-02-26 00:00:00"),
            301: pd.Timestamp("2013-02-27 00:00:00"),
            302: pd.Timestamp("2013-02-28 00:00:00"),
            303: pd.Timestamp("2013-03-01 00:00:00"),
            304: pd.Timestamp("2013-03-02 00:00:00"),
            305: pd.Timestamp("2013-03-03 00:00:00"),
            306: pd.Timestamp("2013-03-04 00:00:00"),
            307: pd.Timestamp("2013-03-05 00:00:00"),
            308: pd.Timestamp("2013-03-06 00:00:00"),
            309: pd.Timestamp("2013-03-07 00:00:00"),
            310: pd.Timestamp("2013-03-08 00:00:00"),
            311: pd.Timestamp("2013-03-09 00:00:00"),
            312: pd.Timestamp("2013-03-10 00:00:00"),
            313: pd.Timestamp("2013-03-11 00:00:00"),
            314: pd.Timestamp("2013-03-12 00:00:00"),
            315: pd.Timestamp("2013-03-13 00:00:00"),
            316: pd.Timestamp("2013-03-14 00:00:00"),
            317: pd.Timestamp("2013-03-15 00:00:00"),
            318: pd.Timestamp("2013-03-16 00:00:00"),
            319: pd.Timestamp("2013-03-17 00:00:00"),
            320: pd.Timestamp("2013-03-18 00:00:00"),
            321: pd.Timestamp("2013-03-19 00:00:00"),
            322: pd.Timestamp("2013-03-20 00:00:00"),
            323: pd.Timestamp("2013-03-21 00:00:00"),
            324: pd.Timestamp("2013-03-22 00:00:00"),
            325: pd.Timestamp("2013-03-23 00:00:00"),
            326: pd.Timestamp("2013-03-24 00:00:00"),
            327: pd.Timestamp("2013-03-25 00:00:00"),
            328: pd.Timestamp("2013-03-26 00:00:00"),
            329: pd.Timestamp("2013-03-27 00:00:00"),
            330: pd.Timestamp("2013-03-28 00:00:00"),
            331: pd.Timestamp("2013-03-29 00:00:00"),
            332: pd.Timestamp("2013-03-30 00:00:00"),
            333: pd.Timestamp("2013-03-31 00:00:00"),
            334: pd.Timestamp("2013-04-01 00:00:00"),
            335: pd.Timestamp("2013-04-02 00:00:00"),
            336: pd.Timestamp("2013-04-03 00:00:00"),
            337: pd.Timestamp("2013-04-04 00:00:00"),
            338: pd.Timestamp("2013-04-05 00:00:00"),
            339: pd.Timestamp("2013-04-06 00:00:00"),
            340: pd.Timestamp("2013-04-07 00:00:00"),
            341: pd.Timestamp("2013-04-08 00:00:00"),
            342: pd.Timestamp("2013-04-09 00:00:00"),
            343: pd.Timestamp("2013-04-10 00:00:00"),
            344: pd.Timestamp("2013-04-11 00:00:00"),
            345: pd.Timestamp("2013-04-12 00:00:00"),
            346: pd.Timestamp("2013-04-13 00:00:00"),
            347: pd.Timestamp("2013-04-14 00:00:00"),
            348: pd.Timestamp("2013-04-15 00:00:00"),
            349: pd.Timestamp("2013-04-16 00:00:00"),
            350: pd.Timestamp("2013-04-17 00:00:00"),
            351: pd.Timestamp("2013-04-18 00:00:00"),
            352: pd.Timestamp("2013-04-19 00:00:00"),
            353: pd.Timestamp("2013-04-20 00:00:00"),
            354: pd.Timestamp("2013-04-21 00:00:00"),
            355: pd.Timestamp("2013-04-22 00:00:00"),
            356: pd.Timestamp("2013-04-23 00:00:00"),
            357: pd.Timestamp("2013-04-24 00:00:00"),
            358: pd.Timestamp("2013-04-25 00:00:00"),
            359: pd.Timestamp("2013-04-26 00:00:00"),
            360: pd.Timestamp("2013-04-27 00:00:00"),
            361: pd.Timestamp("2013-04-28 00:00:00"),
            362: pd.Timestamp("2013-04-29 00:00:00"),
            363: pd.Timestamp("2013-04-30 00:00:00"),
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
            379: pd.Timestamp("2013-05-16 00:00:00"),
            380: pd.Timestamp("2013-05-17 00:00:00"),
            381: pd.Timestamp("2013-05-18 00:00:00"),
            382: pd.Timestamp("2013-05-19 00:00:00"),
            383: pd.Timestamp("2013-05-20 00:00:00"),
            384: pd.Timestamp("2013-05-21 00:00:00"),
            385: pd.Timestamp("2013-05-22 00:00:00"),
            386: pd.Timestamp("2013-05-23 00:00:00"),
            387: pd.Timestamp("2013-05-24 00:00:00"),
            388: pd.Timestamp("2013-05-25 00:00:00"),
            389: pd.Timestamp("2013-05-26 00:00:00"),
            390: pd.Timestamp("2013-05-27 00:00:00"),
            391: pd.Timestamp("2013-05-28 00:00:00"),
            392: pd.Timestamp("2013-05-29 00:00:00"),
            393: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.348604308646497,
            1: 8.348964254851197,
            2: 8.349324201055898,
            3: 8.349684147260598,
            4: 8.350044093465298,
            5: 8.350404039669998,
            6: 8.3507639858747,
            7: 8.3511239320794,
            8: 8.3514838782841,
            9: 8.351843824488801,
            10: 8.352203770693501,
            11: 8.352563716898201,
            12: 8.352923663102903,
            13: 8.353283609307603,
            14: 8.353643555512303,
            15: 8.354003501717003,
            16: 8.354363447921704,
            17: 8.354723394126404,
            18: 8.355083340331104,
            19: 8.355443286535806,
            20: 8.355803232740506,
            21: 8.356163178945206,
            22: 8.356523125149906,
            23: 8.356883071354607,
            24: 8.357243017559307,
            25: 8.357602963764007,
            26: 8.357962909968709,
            27: 8.358322856173409,
            28: 8.358682802378109,
            29: 8.35904274858281,
            30: 8.35940269478751,
            31: 8.35976264099221,
            32: 8.36012258719691,
            33: 8.360482533401612,
            34: 8.360842479606312,
            35: 8.361202425811012,
            36: 8.361562372015714,
            37: 8.361922318220413,
            38: 8.362282264425113,
            39: 8.362642210629813,
            40: 8.363002156834515,
            41: 8.363362103039215,
            42: 8.363722049243915,
            43: 8.364081995448617,
            44: 8.364441941653316,
            45: 8.364801887858016,
            46: 8.365161834062716,
            47: 8.365521780267418,
            48: 8.365881726472118,
            49: 8.366241672676818,
            50: 8.36660161888152,
            51: 8.36696156508622,
            52: 8.36732151129092,
            53: 8.367681457495621,
            54: 8.368041403700321,
            55: 8.368401349905021,
            56: 8.36876129610972,
            57: 8.369121242314423,
            58: 8.369481188519122,
            59: 8.369841134723822,
            60: 8.370201080928524,
            61: 8.370561027133224,
            62: 8.370920973337924,
            63: 8.371280919542624,
            64: 8.371640865747326,
            65: 8.372000811952026,
            66: 8.372360758156725,
            67: 8.372720704361427,
            68: 8.373080650566127,
            69: 8.373440596770827,
            70: 8.373800542975529,
            71: 8.374160489180229,
            72: 8.374520435384929,
            73: 8.374880381589628,
            74: 8.37524032779433,
            75: 8.37560027399903,
            76: 8.37596022020373,
            77: 8.376320166408432,
            78: 8.376680112613132,
            79: 8.377040058817832,
            80: 8.377400005022531,
            81: 8.377759951227233,
            82: 8.378119897431933,
            83: 8.378479843636633,
            84: 8.378839789841335,
            85: 8.379199736046035,
            86: 8.379559682250735,
            87: 8.379919628455436,
            88: 8.380279574660136,
            89: 8.380639520864836,
            90: 8.380999467069536,
            91: 8.381359413274238,
            92: 8.381719359478938,
            93: 8.382079305683638,
            94: 8.38243925188834,
            95: 8.38279919809304,
            96: 8.38315914429774,
            97: 8.383519090502439,
            98: 8.38387903670714,
            99: 8.38423898291184,
            100: 8.38459892911654,
            101: 8.384958875321242,
            102: 8.385318821525942,
            103: 8.385678767730642,
            104: 8.386038713935344,
            105: 8.386398660140044,
            106: 8.386758606344744,
            107: 8.387118552549444,
            108: 8.387478498754145,
            109: 8.387838444958845,
            110: 8.388198391163545,
            111: 8.388558337368247,
            112: 8.388918283572947,
            113: 8.389278229777647,
            114: 8.389638175982347,
            115: 8.389998122187048,
            116: 8.390358068391748,
            117: 8.390718014596448,
            118: 8.39107796080115,
            119: 8.39143790700585,
            120: 8.39179785321055,
            121: 8.392157799415251,
            122: 8.392517745619951,
            123: 8.392877691824651,
            124: 8.393237638029351,
            125: 8.393597584234053,
            126: 8.393957530438753,
            127: 8.394317476643453,
            128: 8.394677422848154,
            129: 8.395037369052854,
            130: 8.395397315257554,
            131: 8.395757261462254,
            132: 8.396117207666956,
            133: 8.396477153871656,
            134: 8.396837100076356,
            135: 8.397197046281057,
            136: 8.397556992485757,
            137: 8.397916938690457,
            138: 8.398276884895157,
            139: 8.398636831099859,
            140: 8.398996777304559,
            141: 8.399356723509259,
            142: 8.39971666971396,
            143: 8.40007661591866,
            144: 8.40043656212336,
            145: 8.400796508328062,
            146: 8.401156454532762,
            147: 8.401516400737462,
            148: 8.401876346942162,
            149: 8.402236293146863,
            150: 8.402596239351563,
            151: 8.402956185556263,
            152: 8.403316131760965,
            153: 8.403676077965665,
            154: 8.404036024170365,
            155: 8.404395970375065,
            156: 8.404755916579767,
            157: 8.405115862784466,
            158: 8.405475808989166,
            159: 8.405835755193868,
            160: 8.406195701398568,
            161: 8.406555647603268,
            162: 8.40691559380797,
            163: 8.40727554001267,
            164: 8.40763548621737,
            165: 8.40799543242207,
            166: 8.408355378626771,
            167: 8.408715324831471,
            168: 8.409075271036171,
            169: 8.409435217240873,
            170: 8.409795163445573,
            171: 8.410155109650272,
            172: 8.410515055854972,
            173: 8.410875002059674,
            174: 8.411234948264374,
            175: 8.411594894469074,
            176: 8.411954840673776,
            177: 8.412314786878476,
            178: 8.412674733083175,
            179: 8.413034679287877,
            180: 8.413394625492577,
            181: 8.413754571697277,
            182: 8.414114517901977,
            183: 8.414474464106679,
            184: 8.414834410311379,
            185: 8.415194356516078,
            186: 8.41555430272078,
            187: 8.41591424892548,
            188: 8.41627419513018,
            189: 8.41663414133488,
            190: 8.416994087539582,
            191: 8.417354033744282,
            192: 8.417713979948982,
            193: 8.418073926153683,
            194: 8.418433872358383,
            195: 8.418793818563083,
            196: 8.419153764767785,
            197: 8.419513710972485,
            198: 8.419873657177185,
            199: 8.420233603381885,
            200: 8.420593549586586,
            201: 8.420953495791286,
            202: 8.421313441995986,
            203: 8.421673388200688,
            204: 8.422033334405388,
            205: 8.422393280610088,
            206: 8.422753226814788,
            207: 8.42311317301949,
            208: 8.42347311922419,
            209: 8.423833065428889,
            210: 8.42419301163359,
            211: 8.42455295783829,
            212: 8.42491290404299,
            213: 8.42527285024769,
            214: 8.425632796452392,
            215: 8.425992742657092,
            216: 8.426352688861792,
            217: 8.426712635066494,
            218: 8.427072581271194,
            219: 8.427432527475894,
            220: 8.427792473680595,
            221: 8.428152419885295,
            222: 8.428512366089995,
            223: 8.428872312294695,
            224: 8.429232258499397,
            225: 8.429592204704097,
            226: 8.429952150908797,
            227: 8.430312097113498,
            228: 8.430672043318198,
            229: 8.431031989522898,
            230: 8.431391935727598,
            231: 8.4317518819323,
            232: 8.432111828137,
            233: 8.4324717743417,
            234: 8.432831720546401,
            235: 8.433191666751101,
            236: 8.433551612955801,
            237: 8.433911559160503,
            238: 8.434271505365203,
            239: 8.434631451569903,
            240: 8.434991397774603,
            241: 8.435351343979304,
            242: 8.435711290184004,
            243: 8.436071236388704,
            244: 8.436431182593406,
            245: 8.436791128798106,
            246: 8.437151075002806,
            247: 8.437511021207506,
            248: 8.437870967412207,
            249: 8.438230913616907,
            250: 8.438590859821607,
            251: 8.438950806026309,
            252: 8.439310752231009,
            253: 8.439670698435709,
            254: 8.44003064464041,
            255: 8.44039059084511,
            256: 8.44075053704981,
            257: 8.44111048325451,
            258: 8.441470429459212,
            259: 8.441830375663912,
            260: 8.442190321868612,
            261: 8.442550268073314,
            262: 8.442910214278013,
            263: 8.443270160482713,
            264: 8.443630106687413,
            265: 8.443990052892115,
            266: 8.444349999096815,
            267: 8.444709945301515,
            268: 8.445069891506217,
            269: 8.445429837710916,
            270: 8.445789783915616,
            271: 8.446149730120318,
            272: 8.446509676325018,
            273: 8.446869622529718,
            274: 8.447229568734418,
            275: 8.44758951493912,
            276: 8.44794946114382,
            277: 8.44830940734852,
            278: 8.448669353553221,
            279: 8.449029299757921,
            280: 8.449389245962621,
            281: 8.449749192167321,
            282: 8.450109138372023,
            283: 8.450469084576723,
            284: 8.450829030781422,
            285: 8.451188976986124,
            286: 8.451548923190824,
            287: 8.451908869395524,
            288: 8.452268815600226,
            289: 8.452628761804926,
            290: 8.452988708009626,
            291: 8.453348654214325,
            292: 8.453708600419027,
            293: 8.454068546623727,
            294: 8.454428492828427,
            295: 8.454788439033129,
            296: 8.455148385237829,
            297: 8.455508331442529,
            298: 8.455868277647228,
            299: 8.45622822385193,
            300: 8.45658817005663,
            301: 8.45694811626133,
            302: 8.457308062466032,
            303: 8.457668008670732,
            304: 8.458027954875432,
            305: 8.458387901080131,
            306: 8.458747847284833,
            307: 8.459107793489533,
            308: 8.459467739694233,
            309: 8.459827685898935,
            310: 8.460187632103635,
            311: 8.460547578308335,
            312: 8.460907524513036,
            313: 8.461267470717736,
            314: 8.461627416922436,
            315: 8.461987363127136,
            316: 8.462347309331838,
            317: 8.462707255536538,
            318: 8.463067201741238,
            319: 8.46342714794594,
            320: 8.46378709415064,
            321: 8.46414704035534,
            322: 8.464506986560039,
            323: 8.46486693276474,
            324: 8.46522687896944,
            325: 8.46558682517414,
            326: 8.465946771378842,
            327: 8.466306717583542,
            328: 8.466666663788242,
            329: 8.467026609992944,
            330: 8.467386556197644,
            331: 8.467746502402344,
            332: 8.468106448607044,
            333: 8.468466394811745,
            334: 8.468826341016445,
            335: 8.469186287221145,
            336: 8.469546233425847,
            337: 8.469906179630547,
            338: 8.470266125835247,
            339: 8.470626072039947,
            340: 8.470986018244648,
            341: 8.471345964449348,
            342: 8.471705910654048,
            343: 8.47206585685875,
            344: 8.47242580306345,
            345: 8.47278574926815,
            346: 8.473145695472851,
            347: 8.473505641677551,
            348: 8.473865587882251,
            349: 8.474225534086951,
            350: 8.474585480291653,
            351: 8.474945426496353,
            352: 8.475305372701053,
            353: 8.475665318905754,
            354: 8.476025265110454,
            355: 8.476385211315154,
            356: 8.476745157519854,
            357: 8.477105103724556,
            358: 8.477465049929256,
            359: 8.477824996133956,
            360: 8.478184942338657,
            361: 8.478544888543357,
            362: 8.478904834748057,
            363: 8.479264780952759,
            364: 8.479624727157459,
            365: 8.479984673362159,
            366: 8.480344619566859,
            367: 8.48070456577156,
            368: 8.48106451197626,
            369: 8.48142445818096,
            370: 8.481784404385662,
            371: 8.482144350590362,
            372: 8.482504296795062,
            373: 8.482864242999762,
            374: 8.483224189204464,
            375: 8.483584135409163,
            376: 8.483944081613863,
            377: 8.484304027818565,
            378: 8.484663974023265,
            379: 8.485023920227965,
            380: 8.485383866432667,
            381: 8.485743812637367,
            382: 8.486103758842066,
            383: 8.486463705046766,
            384: 8.486823651251468,
            385: 8.487183597456168,
            386: 8.487543543660868,
            387: 8.48790348986557,
            388: 8.48826343607027,
            389: 8.48862338227497,
            390: 8.48898332847967,
            391: 8.489343274684371,
            392: 8.489703220889071,
            393: 8.490063167093771,
        },
        "fcst_lower": {
            0: -np.inf,
            1: -np.inf,
            2: -np.inf,
            3: -np.inf,
            4: -np.inf,
            5: -np.inf,
            6: -np.inf,
            7: -np.inf,
            8: -np.inf,
            9: -np.inf,
            10: -np.inf,
            11: -np.inf,
            12: -np.inf,
            13: -np.inf,
            14: -np.inf,
            15: -np.inf,
            16: -np.inf,
            17: -np.inf,
            18: -np.inf,
            19: -np.inf,
            20: -np.inf,
            21: -np.inf,
            22: -np.inf,
            23: -np.inf,
            24: -np.inf,
            25: -np.inf,
            26: -np.inf,
            27: -np.inf,
            28: -np.inf,
            29: -np.inf,
            30: -np.inf,
            31: -np.inf,
            32: -np.inf,
            33: -np.inf,
            34: -np.inf,
            35: -np.inf,
            36: -np.inf,
            37: -np.inf,
            38: -np.inf,
            39: -np.inf,
            40: -np.inf,
            41: -np.inf,
            42: -np.inf,
            43: -np.inf,
            44: -np.inf,
            45: -np.inf,
            46: -np.inf,
            47: -np.inf,
            48: -np.inf,
            49: -np.inf,
            50: -np.inf,
            51: -np.inf,
            52: -np.inf,
            53: -np.inf,
            54: -np.inf,
            55: -np.inf,
            56: -np.inf,
            57: -np.inf,
            58: -np.inf,
            59: -np.inf,
            60: -np.inf,
            61: -np.inf,
            62: -np.inf,
            63: -np.inf,
            64: -np.inf,
            65: -np.inf,
            66: -np.inf,
            67: -np.inf,
            68: -np.inf,
            69: -np.inf,
            70: -np.inf,
            71: -np.inf,
            72: -np.inf,
            73: -np.inf,
            74: -np.inf,
            75: -np.inf,
            76: -np.inf,
            77: -np.inf,
            78: -np.inf,
            79: -np.inf,
            80: -np.inf,
            81: -np.inf,
            82: -np.inf,
            83: -np.inf,
            84: -np.inf,
            85: -np.inf,
            86: -np.inf,
            87: -np.inf,
            88: -np.inf,
            89: -np.inf,
            90: -np.inf,
            91: -np.inf,
            92: -np.inf,
            93: -np.inf,
            94: -np.inf,
            95: -np.inf,
            96: -np.inf,
            97: -np.inf,
            98: -np.inf,
            99: -np.inf,
            100: -np.inf,
            101: -np.inf,
            102: -np.inf,
            103: -np.inf,
            104: -np.inf,
            105: -np.inf,
            106: -np.inf,
            107: -np.inf,
            108: -np.inf,
            109: -np.inf,
            110: -np.inf,
            111: -np.inf,
            112: -np.inf,
            113: -np.inf,
            114: -np.inf,
            115: -np.inf,
            116: -np.inf,
            117: -np.inf,
            118: -np.inf,
            119: -np.inf,
            120: -np.inf,
            121: -np.inf,
            122: -np.inf,
            123: -np.inf,
            124: -np.inf,
            125: -np.inf,
            126: -np.inf,
            127: -np.inf,
            128: -np.inf,
            129: -np.inf,
            130: -np.inf,
            131: -np.inf,
            132: -np.inf,
            133: -np.inf,
            134: -np.inf,
            135: -np.inf,
            136: -np.inf,
            137: -np.inf,
            138: -np.inf,
            139: -np.inf,
            140: -np.inf,
            141: -np.inf,
            142: -np.inf,
            143: -np.inf,
            144: -np.inf,
            145: -np.inf,
            146: -np.inf,
            147: -np.inf,
            148: -np.inf,
            149: -np.inf,
            150: -np.inf,
            151: -np.inf,
            152: -np.inf,
            153: -np.inf,
            154: -np.inf,
            155: -np.inf,
            156: -np.inf,
            157: -np.inf,
            158: -np.inf,
            159: -np.inf,
            160: -np.inf,
            161: -np.inf,
            162: -np.inf,
            163: -np.inf,
            164: -np.inf,
            165: -np.inf,
            166: -np.inf,
            167: -np.inf,
            168: -np.inf,
            169: -np.inf,
            170: -np.inf,
            171: -np.inf,
            172: -np.inf,
            173: -np.inf,
            174: -np.inf,
            175: -np.inf,
            176: -np.inf,
            177: -np.inf,
            178: -np.inf,
            179: -np.inf,
            180: -np.inf,
            181: -np.inf,
            182: -np.inf,
            183: -np.inf,
            184: -np.inf,
            185: -np.inf,
            186: -np.inf,
            187: -np.inf,
            188: -np.inf,
            189: -np.inf,
            190: -np.inf,
            191: -np.inf,
            192: -np.inf,
            193: -np.inf,
            194: -np.inf,
            195: -np.inf,
            196: -np.inf,
            197: -np.inf,
            198: -np.inf,
            199: -np.inf,
            200: -np.inf,
            201: -np.inf,
            202: -np.inf,
            203: -np.inf,
            204: -np.inf,
            205: -np.inf,
            206: -np.inf,
            207: -np.inf,
            208: -np.inf,
            209: -np.inf,
            210: -np.inf,
            211: -np.inf,
            212: -np.inf,
            213: -np.inf,
            214: -np.inf,
            215: -np.inf,
            216: -np.inf,
            217: -np.inf,
            218: -np.inf,
            219: -np.inf,
            220: -np.inf,
            221: -np.inf,
            222: -np.inf,
            223: -np.inf,
            224: -np.inf,
            225: -np.inf,
            226: -np.inf,
            227: -np.inf,
            228: -np.inf,
            229: -np.inf,
            230: -np.inf,
            231: -np.inf,
            232: -np.inf,
            233: -np.inf,
            234: -np.inf,
            235: -np.inf,
            236: -np.inf,
            237: -np.inf,
            238: -np.inf,
            239: -np.inf,
            240: -np.inf,
            241: -np.inf,
            242: -np.inf,
            243: -np.inf,
            244: -np.inf,
            245: -np.inf,
            246: -np.inf,
            247: -np.inf,
            248: -np.inf,
            249: -np.inf,
            250: -np.inf,
            251: -np.inf,
            252: -np.inf,
            253: -np.inf,
            254: -np.inf,
            255: -np.inf,
            256: -np.inf,
            257: -np.inf,
            258: -np.inf,
            259: -np.inf,
            260: -np.inf,
            261: -np.inf,
            262: -np.inf,
            263: -np.inf,
            264: -np.inf,
            265: -np.inf,
            266: -np.inf,
            267: -np.inf,
            268: -np.inf,
            269: -np.inf,
            270: -np.inf,
            271: -np.inf,
            272: -np.inf,
            273: -np.inf,
            274: -np.inf,
            275: -np.inf,
            276: -np.inf,
            277: -np.inf,
            278: -np.inf,
            279: -np.inf,
            280: -np.inf,
            281: -np.inf,
            282: -np.inf,
            283: -np.inf,
            284: -np.inf,
            285: -np.inf,
            286: -np.inf,
            287: -np.inf,
            288: -np.inf,
            289: -np.inf,
            290: -np.inf,
            291: -np.inf,
            292: -np.inf,
            293: -np.inf,
            294: -np.inf,
            295: -np.inf,
            296: -np.inf,
            297: -np.inf,
            298: -np.inf,
            299: -np.inf,
            300: -np.inf,
            301: -np.inf,
            302: -np.inf,
            303: -np.inf,
            304: -np.inf,
            305: -np.inf,
            306: -np.inf,
            307: -np.inf,
            308: -np.inf,
            309: -np.inf,
            310: -np.inf,
            311: -np.inf,
            312: -np.inf,
            313: -np.inf,
            314: -np.inf,
            315: -np.inf,
            316: -np.inf,
            317: -np.inf,
            318: -np.inf,
            319: -np.inf,
            320: -np.inf,
            321: -np.inf,
            322: -np.inf,
            323: -np.inf,
            324: -np.inf,
            325: -np.inf,
            326: -np.inf,
            327: -np.inf,
            328: -np.inf,
            329: -np.inf,
            330: -np.inf,
            331: -np.inf,
            332: -np.inf,
            333: -np.inf,
            334: -np.inf,
            335: -np.inf,
            336: -np.inf,
            337: -np.inf,
            338: -np.inf,
            339: -np.inf,
            340: -np.inf,
            341: -np.inf,
            342: -np.inf,
            343: -np.inf,
            344: -np.inf,
            345: -np.inf,
            346: -np.inf,
            347: -np.inf,
            348: -np.inf,
            349: -np.inf,
            350: -np.inf,
            351: -np.inf,
            352: -np.inf,
            353: -np.inf,
            354: -np.inf,
            355: -np.inf,
            356: -np.inf,
            357: -np.inf,
            358: -np.inf,
            359: -np.inf,
            360: -np.inf,
            361: -np.inf,
            362: -np.inf,
            363: -np.inf,
            364: -np.inf,
            365: -np.inf,
            366: -np.inf,
            367: -np.inf,
            368: -np.inf,
            369: -np.inf,
            370: -np.inf,
            371: -np.inf,
            372: -np.inf,
            373: -np.inf,
            374: -np.inf,
            375: -np.inf,
            376: -np.inf,
            377: -np.inf,
            378: -np.inf,
            379: -np.inf,
            380: -np.inf,
            381: -np.inf,
            382: -np.inf,
            383: -np.inf,
            384: -np.inf,
            385: -np.inf,
            386: -np.inf,
            387: -np.inf,
            388: -np.inf,
            389: -np.inf,
            390: -np.inf,
            391: -np.inf,
            392: -np.inf,
            393: -np.inf,
        },
        "fcst_upper": {
            0: np.inf,
            1: np.inf,
            2: np.inf,
            3: np.inf,
            4: np.inf,
            5: np.inf,
            6: np.inf,
            7: np.inf,
            8: np.inf,
            9: np.inf,
            10: np.inf,
            11: np.inf,
            12: np.inf,
            13: np.inf,
            14: np.inf,
            15: np.inf,
            16: np.inf,
            17: np.inf,
            18: np.inf,
            19: np.inf,
            20: np.inf,
            21: np.inf,
            22: np.inf,
            23: np.inf,
            24: np.inf,
            25: np.inf,
            26: np.inf,
            27: np.inf,
            28: np.inf,
            29: np.inf,
            30: np.inf,
            31: np.inf,
            32: np.inf,
            33: np.inf,
            34: np.inf,
            35: np.inf,
            36: np.inf,
            37: np.inf,
            38: np.inf,
            39: np.inf,
            40: np.inf,
            41: np.inf,
            42: np.inf,
            43: np.inf,
            44: np.inf,
            45: np.inf,
            46: np.inf,
            47: np.inf,
            48: np.inf,
            49: np.inf,
            50: np.inf,
            51: np.inf,
            52: np.inf,
            53: np.inf,
            54: np.inf,
            55: np.inf,
            56: np.inf,
            57: np.inf,
            58: np.inf,
            59: np.inf,
            60: np.inf,
            61: np.inf,
            62: np.inf,
            63: np.inf,
            64: np.inf,
            65: np.inf,
            66: np.inf,
            67: np.inf,
            68: np.inf,
            69: np.inf,
            70: np.inf,
            71: np.inf,
            72: np.inf,
            73: np.inf,
            74: np.inf,
            75: np.inf,
            76: np.inf,
            77: np.inf,
            78: np.inf,
            79: np.inf,
            80: np.inf,
            81: np.inf,
            82: np.inf,
            83: np.inf,
            84: np.inf,
            85: np.inf,
            86: np.inf,
            87: np.inf,
            88: np.inf,
            89: np.inf,
            90: np.inf,
            91: np.inf,
            92: np.inf,
            93: np.inf,
            94: np.inf,
            95: np.inf,
            96: np.inf,
            97: np.inf,
            98: np.inf,
            99: np.inf,
            100: np.inf,
            101: np.inf,
            102: np.inf,
            103: np.inf,
            104: np.inf,
            105: np.inf,
            106: np.inf,
            107: np.inf,
            108: np.inf,
            109: np.inf,
            110: np.inf,
            111: np.inf,
            112: np.inf,
            113: np.inf,
            114: np.inf,
            115: np.inf,
            116: np.inf,
            117: np.inf,
            118: np.inf,
            119: np.inf,
            120: np.inf,
            121: np.inf,
            122: np.inf,
            123: np.inf,
            124: np.inf,
            125: np.inf,
            126: np.inf,
            127: np.inf,
            128: np.inf,
            129: np.inf,
            130: np.inf,
            131: np.inf,
            132: np.inf,
            133: np.inf,
            134: np.inf,
            135: np.inf,
            136: np.inf,
            137: np.inf,
            138: np.inf,
            139: np.inf,
            140: np.inf,
            141: np.inf,
            142: np.inf,
            143: np.inf,
            144: np.inf,
            145: np.inf,
            146: np.inf,
            147: np.inf,
            148: np.inf,
            149: np.inf,
            150: np.inf,
            151: np.inf,
            152: np.inf,
            153: np.inf,
            154: np.inf,
            155: np.inf,
            156: np.inf,
            157: np.inf,
            158: np.inf,
            159: np.inf,
            160: np.inf,
            161: np.inf,
            162: np.inf,
            163: np.inf,
            164: np.inf,
            165: np.inf,
            166: np.inf,
            167: np.inf,
            168: np.inf,
            169: np.inf,
            170: np.inf,
            171: np.inf,
            172: np.inf,
            173: np.inf,
            174: np.inf,
            175: np.inf,
            176: np.inf,
            177: np.inf,
            178: np.inf,
            179: np.inf,
            180: np.inf,
            181: np.inf,
            182: np.inf,
            183: np.inf,
            184: np.inf,
            185: np.inf,
            186: np.inf,
            187: np.inf,
            188: np.inf,
            189: np.inf,
            190: np.inf,
            191: np.inf,
            192: np.inf,
            193: np.inf,
            194: np.inf,
            195: np.inf,
            196: np.inf,
            197: np.inf,
            198: np.inf,
            199: np.inf,
            200: np.inf,
            201: np.inf,
            202: np.inf,
            203: np.inf,
            204: np.inf,
            205: np.inf,
            206: np.inf,
            207: np.inf,
            208: np.inf,
            209: np.inf,
            210: np.inf,
            211: np.inf,
            212: np.inf,
            213: np.inf,
            214: np.inf,
            215: np.inf,
            216: np.inf,
            217: np.inf,
            218: np.inf,
            219: np.inf,
            220: np.inf,
            221: np.inf,
            222: np.inf,
            223: np.inf,
            224: np.inf,
            225: np.inf,
            226: np.inf,
            227: np.inf,
            228: np.inf,
            229: np.inf,
            230: np.inf,
            231: np.inf,
            232: np.inf,
            233: np.inf,
            234: np.inf,
            235: np.inf,
            236: np.inf,
            237: np.inf,
            238: np.inf,
            239: np.inf,
            240: np.inf,
            241: np.inf,
            242: np.inf,
            243: np.inf,
            244: np.inf,
            245: np.inf,
            246: np.inf,
            247: np.inf,
            248: np.inf,
            249: np.inf,
            250: np.inf,
            251: np.inf,
            252: np.inf,
            253: np.inf,
            254: np.inf,
            255: np.inf,
            256: np.inf,
            257: np.inf,
            258: np.inf,
            259: np.inf,
            260: np.inf,
            261: np.inf,
            262: np.inf,
            263: np.inf,
            264: np.inf,
            265: np.inf,
            266: np.inf,
            267: np.inf,
            268: np.inf,
            269: np.inf,
            270: np.inf,
            271: np.inf,
            272: np.inf,
            273: np.inf,
            274: np.inf,
            275: np.inf,
            276: np.inf,
            277: np.inf,
            278: np.inf,
            279: np.inf,
            280: np.inf,
            281: np.inf,
            282: np.inf,
            283: np.inf,
            284: np.inf,
            285: np.inf,
            286: np.inf,
            287: np.inf,
            288: np.inf,
            289: np.inf,
            290: np.inf,
            291: np.inf,
            292: np.inf,
            293: np.inf,
            294: np.inf,
            295: np.inf,
            296: np.inf,
            297: np.inf,
            298: np.inf,
            299: np.inf,
            300: np.inf,
            301: np.inf,
            302: np.inf,
            303: np.inf,
            304: np.inf,
            305: np.inf,
            306: np.inf,
            307: np.inf,
            308: np.inf,
            309: np.inf,
            310: np.inf,
            311: np.inf,
            312: np.inf,
            313: np.inf,
            314: np.inf,
            315: np.inf,
            316: np.inf,
            317: np.inf,
            318: np.inf,
            319: np.inf,
            320: np.inf,
            321: np.inf,
            322: np.inf,
            323: np.inf,
            324: np.inf,
            325: np.inf,
            326: np.inf,
            327: np.inf,
            328: np.inf,
            329: np.inf,
            330: np.inf,
            331: np.inf,
            332: np.inf,
            333: np.inf,
            334: np.inf,
            335: np.inf,
            336: np.inf,
            337: np.inf,
            338: np.inf,
            339: np.inf,
            340: np.inf,
            341: np.inf,
            342: np.inf,
            343: np.inf,
            344: np.inf,
            345: np.inf,
            346: np.inf,
            347: np.inf,
            348: np.inf,
            349: np.inf,
            350: np.inf,
            351: np.inf,
            352: np.inf,
            353: np.inf,
            354: np.inf,
            355: np.inf,
            356: np.inf,
            357: np.inf,
            358: np.inf,
            359: np.inf,
            360: np.inf,
            361: np.inf,
            362: np.inf,
            363: np.inf,
            364: np.inf,
            365: np.inf,
            366: np.inf,
            367: np.inf,
            368: np.inf,
            369: np.inf,
            370: np.inf,
            371: np.inf,
            372: np.inf,
            373: np.inf,
            374: np.inf,
            375: np.inf,
            376: np.inf,
            377: np.inf,
            378: np.inf,
            379: np.inf,
            380: np.inf,
            381: np.inf,
            382: np.inf,
            383: np.inf,
            384: np.inf,
            385: np.inf,
            386: np.inf,
            387: np.inf,
            388: np.inf,
            389: np.inf,
            390: np.inf,
            391: np.inf,
            392: np.inf,
            393: np.inf,
        },
    }
)

PEYTON_FCST_LINEAR_INVALID_NEG_ONE = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2012-05-02 00:00:00"),
            1: pd.Timestamp("2012-05-03 00:00:00"),
            2: pd.Timestamp("2012-05-04 00:00:00"),
            3: pd.Timestamp("2012-05-05 00:00:00"),
            4: pd.Timestamp("2012-05-06 00:00:00"),
            5: pd.Timestamp("2012-05-07 00:00:00"),
            6: pd.Timestamp("2012-05-08 00:00:00"),
            7: pd.Timestamp("2012-05-09 00:00:00"),
            8: pd.Timestamp("2012-05-10 00:00:00"),
            9: pd.Timestamp("2012-05-11 00:00:00"),
            10: pd.Timestamp("2012-05-12 00:00:00"),
            11: pd.Timestamp("2012-05-13 00:00:00"),
            12: pd.Timestamp("2012-05-14 00:00:00"),
            13: pd.Timestamp("2012-05-15 00:00:00"),
            14: pd.Timestamp("2012-05-16 00:00:00"),
            15: pd.Timestamp("2012-05-17 00:00:00"),
            16: pd.Timestamp("2012-05-18 00:00:00"),
            17: pd.Timestamp("2012-05-19 00:00:00"),
            18: pd.Timestamp("2012-05-20 00:00:00"),
            19: pd.Timestamp("2012-05-21 00:00:00"),
            20: pd.Timestamp("2012-05-22 00:00:00"),
            21: pd.Timestamp("2012-05-23 00:00:00"),
            22: pd.Timestamp("2012-05-24 00:00:00"),
            23: pd.Timestamp("2012-05-25 00:00:00"),
            24: pd.Timestamp("2012-05-26 00:00:00"),
            25: pd.Timestamp("2012-05-27 00:00:00"),
            26: pd.Timestamp("2012-05-28 00:00:00"),
            27: pd.Timestamp("2012-05-29 00:00:00"),
            28: pd.Timestamp("2012-05-30 00:00:00"),
            29: pd.Timestamp("2012-05-31 00:00:00"),
            30: pd.Timestamp("2012-06-01 00:00:00"),
            31: pd.Timestamp("2012-06-02 00:00:00"),
            32: pd.Timestamp("2012-06-03 00:00:00"),
            33: pd.Timestamp("2012-06-04 00:00:00"),
            34: pd.Timestamp("2012-06-05 00:00:00"),
            35: pd.Timestamp("2012-06-06 00:00:00"),
            36: pd.Timestamp("2012-06-07 00:00:00"),
            37: pd.Timestamp("2012-06-08 00:00:00"),
            38: pd.Timestamp("2012-06-09 00:00:00"),
            39: pd.Timestamp("2012-06-10 00:00:00"),
            40: pd.Timestamp("2012-06-11 00:00:00"),
            41: pd.Timestamp("2012-06-12 00:00:00"),
            42: pd.Timestamp("2012-06-13 00:00:00"),
            43: pd.Timestamp("2012-06-14 00:00:00"),
            44: pd.Timestamp("2012-06-15 00:00:00"),
            45: pd.Timestamp("2012-06-16 00:00:00"),
            46: pd.Timestamp("2012-06-17 00:00:00"),
            47: pd.Timestamp("2012-06-18 00:00:00"),
            48: pd.Timestamp("2012-06-19 00:00:00"),
            49: pd.Timestamp("2012-06-20 00:00:00"),
            50: pd.Timestamp("2012-06-21 00:00:00"),
            51: pd.Timestamp("2012-06-22 00:00:00"),
            52: pd.Timestamp("2012-06-23 00:00:00"),
            53: pd.Timestamp("2012-06-24 00:00:00"),
            54: pd.Timestamp("2012-06-25 00:00:00"),
            55: pd.Timestamp("2012-06-26 00:00:00"),
            56: pd.Timestamp("2012-06-27 00:00:00"),
            57: pd.Timestamp("2012-06-28 00:00:00"),
            58: pd.Timestamp("2012-06-29 00:00:00"),
            59: pd.Timestamp("2012-06-30 00:00:00"),
            60: pd.Timestamp("2012-07-01 00:00:00"),
            61: pd.Timestamp("2012-07-02 00:00:00"),
            62: pd.Timestamp("2012-07-03 00:00:00"),
            63: pd.Timestamp("2012-07-04 00:00:00"),
            64: pd.Timestamp("2012-07-05 00:00:00"),
            65: pd.Timestamp("2012-07-06 00:00:00"),
            66: pd.Timestamp("2012-07-07 00:00:00"),
            67: pd.Timestamp("2012-07-08 00:00:00"),
            68: pd.Timestamp("2012-07-09 00:00:00"),
            69: pd.Timestamp("2012-07-10 00:00:00"),
            70: pd.Timestamp("2012-07-11 00:00:00"),
            71: pd.Timestamp("2012-07-12 00:00:00"),
            72: pd.Timestamp("2012-07-13 00:00:00"),
            73: pd.Timestamp("2012-07-14 00:00:00"),
            74: pd.Timestamp("2012-07-15 00:00:00"),
            75: pd.Timestamp("2012-07-16 00:00:00"),
            76: pd.Timestamp("2012-07-17 00:00:00"),
            77: pd.Timestamp("2012-07-18 00:00:00"),
            78: pd.Timestamp("2012-07-19 00:00:00"),
            79: pd.Timestamp("2012-07-20 00:00:00"),
            80: pd.Timestamp("2012-07-21 00:00:00"),
            81: pd.Timestamp("2012-07-22 00:00:00"),
            82: pd.Timestamp("2012-07-23 00:00:00"),
            83: pd.Timestamp("2012-07-24 00:00:00"),
            84: pd.Timestamp("2012-07-25 00:00:00"),
            85: pd.Timestamp("2012-07-26 00:00:00"),
            86: pd.Timestamp("2012-07-27 00:00:00"),
            87: pd.Timestamp("2012-07-28 00:00:00"),
            88: pd.Timestamp("2012-07-29 00:00:00"),
            89: pd.Timestamp("2012-07-30 00:00:00"),
            90: pd.Timestamp("2012-07-31 00:00:00"),
            91: pd.Timestamp("2012-08-01 00:00:00"),
            92: pd.Timestamp("2012-08-02 00:00:00"),
            93: pd.Timestamp("2012-08-03 00:00:00"),
            94: pd.Timestamp("2012-08-04 00:00:00"),
            95: pd.Timestamp("2012-08-05 00:00:00"),
            96: pd.Timestamp("2012-08-06 00:00:00"),
            97: pd.Timestamp("2012-08-07 00:00:00"),
            98: pd.Timestamp("2012-08-08 00:00:00"),
            99: pd.Timestamp("2012-08-09 00:00:00"),
            100: pd.Timestamp("2012-08-10 00:00:00"),
            101: pd.Timestamp("2012-08-11 00:00:00"),
            102: pd.Timestamp("2012-08-12 00:00:00"),
            103: pd.Timestamp("2012-08-13 00:00:00"),
            104: pd.Timestamp("2012-08-14 00:00:00"),
            105: pd.Timestamp("2012-08-15 00:00:00"),
            106: pd.Timestamp("2012-08-16 00:00:00"),
            107: pd.Timestamp("2012-08-17 00:00:00"),
            108: pd.Timestamp("2012-08-18 00:00:00"),
            109: pd.Timestamp("2012-08-19 00:00:00"),
            110: pd.Timestamp("2012-08-20 00:00:00"),
            111: pd.Timestamp("2012-08-21 00:00:00"),
            112: pd.Timestamp("2012-08-22 00:00:00"),
            113: pd.Timestamp("2012-08-23 00:00:00"),
            114: pd.Timestamp("2012-08-24 00:00:00"),
            115: pd.Timestamp("2012-08-25 00:00:00"),
            116: pd.Timestamp("2012-08-26 00:00:00"),
            117: pd.Timestamp("2012-08-27 00:00:00"),
            118: pd.Timestamp("2012-08-28 00:00:00"),
            119: pd.Timestamp("2012-08-29 00:00:00"),
            120: pd.Timestamp("2012-08-30 00:00:00"),
            121: pd.Timestamp("2012-08-31 00:00:00"),
            122: pd.Timestamp("2012-09-01 00:00:00"),
            123: pd.Timestamp("2012-09-02 00:00:00"),
            124: pd.Timestamp("2012-09-03 00:00:00"),
            125: pd.Timestamp("2012-09-04 00:00:00"),
            126: pd.Timestamp("2012-09-05 00:00:00"),
            127: pd.Timestamp("2012-09-06 00:00:00"),
            128: pd.Timestamp("2012-09-07 00:00:00"),
            129: pd.Timestamp("2012-09-08 00:00:00"),
            130: pd.Timestamp("2012-09-09 00:00:00"),
            131: pd.Timestamp("2012-09-10 00:00:00"),
            132: pd.Timestamp("2012-09-11 00:00:00"),
            133: pd.Timestamp("2012-09-12 00:00:00"),
            134: pd.Timestamp("2012-09-13 00:00:00"),
            135: pd.Timestamp("2012-09-14 00:00:00"),
            136: pd.Timestamp("2012-09-15 00:00:00"),
            137: pd.Timestamp("2012-09-16 00:00:00"),
            138: pd.Timestamp("2012-09-17 00:00:00"),
            139: pd.Timestamp("2012-09-18 00:00:00"),
            140: pd.Timestamp("2012-09-19 00:00:00"),
            141: pd.Timestamp("2012-09-20 00:00:00"),
            142: pd.Timestamp("2012-09-21 00:00:00"),
            143: pd.Timestamp("2012-09-22 00:00:00"),
            144: pd.Timestamp("2012-09-23 00:00:00"),
            145: pd.Timestamp("2012-09-24 00:00:00"),
            146: pd.Timestamp("2012-09-25 00:00:00"),
            147: pd.Timestamp("2012-09-26 00:00:00"),
            148: pd.Timestamp("2012-09-27 00:00:00"),
            149: pd.Timestamp("2012-09-28 00:00:00"),
            150: pd.Timestamp("2012-09-29 00:00:00"),
            151: pd.Timestamp("2012-09-30 00:00:00"),
            152: pd.Timestamp("2012-10-01 00:00:00"),
            153: pd.Timestamp("2012-10-02 00:00:00"),
            154: pd.Timestamp("2012-10-03 00:00:00"),
            155: pd.Timestamp("2012-10-04 00:00:00"),
            156: pd.Timestamp("2012-10-05 00:00:00"),
            157: pd.Timestamp("2012-10-06 00:00:00"),
            158: pd.Timestamp("2012-10-07 00:00:00"),
            159: pd.Timestamp("2012-10-08 00:00:00"),
            160: pd.Timestamp("2012-10-09 00:00:00"),
            161: pd.Timestamp("2012-10-10 00:00:00"),
            162: pd.Timestamp("2012-10-11 00:00:00"),
            163: pd.Timestamp("2012-10-12 00:00:00"),
            164: pd.Timestamp("2012-10-13 00:00:00"),
            165: pd.Timestamp("2012-10-14 00:00:00"),
            166: pd.Timestamp("2012-10-15 00:00:00"),
            167: pd.Timestamp("2012-10-16 00:00:00"),
            168: pd.Timestamp("2012-10-17 00:00:00"),
            169: pd.Timestamp("2012-10-18 00:00:00"),
            170: pd.Timestamp("2012-10-19 00:00:00"),
            171: pd.Timestamp("2012-10-20 00:00:00"),
            172: pd.Timestamp("2012-10-21 00:00:00"),
            173: pd.Timestamp("2012-10-22 00:00:00"),
            174: pd.Timestamp("2012-10-23 00:00:00"),
            175: pd.Timestamp("2012-10-24 00:00:00"),
            176: pd.Timestamp("2012-10-25 00:00:00"),
            177: pd.Timestamp("2012-10-26 00:00:00"),
            178: pd.Timestamp("2012-10-27 00:00:00"),
            179: pd.Timestamp("2012-10-28 00:00:00"),
            180: pd.Timestamp("2012-10-29 00:00:00"),
            181: pd.Timestamp("2012-10-30 00:00:00"),
            182: pd.Timestamp("2012-10-31 00:00:00"),
            183: pd.Timestamp("2012-11-01 00:00:00"),
            184: pd.Timestamp("2012-11-02 00:00:00"),
            185: pd.Timestamp("2012-11-03 00:00:00"),
            186: pd.Timestamp("2012-11-04 00:00:00"),
            187: pd.Timestamp("2012-11-05 00:00:00"),
            188: pd.Timestamp("2012-11-06 00:00:00"),
            189: pd.Timestamp("2012-11-07 00:00:00"),
            190: pd.Timestamp("2012-11-08 00:00:00"),
            191: pd.Timestamp("2012-11-09 00:00:00"),
            192: pd.Timestamp("2012-11-10 00:00:00"),
            193: pd.Timestamp("2012-11-11 00:00:00"),
            194: pd.Timestamp("2012-11-12 00:00:00"),
            195: pd.Timestamp("2012-11-13 00:00:00"),
            196: pd.Timestamp("2012-11-14 00:00:00"),
            197: pd.Timestamp("2012-11-15 00:00:00"),
            198: pd.Timestamp("2012-11-16 00:00:00"),
            199: pd.Timestamp("2012-11-17 00:00:00"),
            200: pd.Timestamp("2012-11-18 00:00:00"),
            201: pd.Timestamp("2012-11-19 00:00:00"),
            202: pd.Timestamp("2012-11-20 00:00:00"),
            203: pd.Timestamp("2012-11-21 00:00:00"),
            204: pd.Timestamp("2012-11-22 00:00:00"),
            205: pd.Timestamp("2012-11-23 00:00:00"),
            206: pd.Timestamp("2012-11-24 00:00:00"),
            207: pd.Timestamp("2012-11-25 00:00:00"),
            208: pd.Timestamp("2012-11-26 00:00:00"),
            209: pd.Timestamp("2012-11-27 00:00:00"),
            210: pd.Timestamp("2012-11-28 00:00:00"),
            211: pd.Timestamp("2012-11-29 00:00:00"),
            212: pd.Timestamp("2012-11-30 00:00:00"),
            213: pd.Timestamp("2012-12-01 00:00:00"),
            214: pd.Timestamp("2012-12-02 00:00:00"),
            215: pd.Timestamp("2012-12-03 00:00:00"),
            216: pd.Timestamp("2012-12-04 00:00:00"),
            217: pd.Timestamp("2012-12-05 00:00:00"),
            218: pd.Timestamp("2012-12-06 00:00:00"),
            219: pd.Timestamp("2012-12-07 00:00:00"),
            220: pd.Timestamp("2012-12-08 00:00:00"),
            221: pd.Timestamp("2012-12-09 00:00:00"),
            222: pd.Timestamp("2012-12-10 00:00:00"),
            223: pd.Timestamp("2012-12-11 00:00:00"),
            224: pd.Timestamp("2012-12-12 00:00:00"),
            225: pd.Timestamp("2012-12-13 00:00:00"),
            226: pd.Timestamp("2012-12-14 00:00:00"),
            227: pd.Timestamp("2012-12-15 00:00:00"),
            228: pd.Timestamp("2012-12-16 00:00:00"),
            229: pd.Timestamp("2012-12-17 00:00:00"),
            230: pd.Timestamp("2012-12-18 00:00:00"),
            231: pd.Timestamp("2012-12-19 00:00:00"),
            232: pd.Timestamp("2012-12-20 00:00:00"),
            233: pd.Timestamp("2012-12-21 00:00:00"),
            234: pd.Timestamp("2012-12-22 00:00:00"),
            235: pd.Timestamp("2012-12-23 00:00:00"),
            236: pd.Timestamp("2012-12-24 00:00:00"),
            237: pd.Timestamp("2012-12-25 00:00:00"),
            238: pd.Timestamp("2012-12-26 00:00:00"),
            239: pd.Timestamp("2012-12-27 00:00:00"),
            240: pd.Timestamp("2012-12-28 00:00:00"),
            241: pd.Timestamp("2012-12-29 00:00:00"),
            242: pd.Timestamp("2012-12-30 00:00:00"),
            243: pd.Timestamp("2012-12-31 00:00:00"),
            244: pd.Timestamp("2013-01-01 00:00:00"),
            245: pd.Timestamp("2013-01-02 00:00:00"),
            246: pd.Timestamp("2013-01-03 00:00:00"),
            247: pd.Timestamp("2013-01-04 00:00:00"),
            248: pd.Timestamp("2013-01-05 00:00:00"),
            249: pd.Timestamp("2013-01-06 00:00:00"),
            250: pd.Timestamp("2013-01-07 00:00:00"),
            251: pd.Timestamp("2013-01-08 00:00:00"),
            252: pd.Timestamp("2013-01-09 00:00:00"),
            253: pd.Timestamp("2013-01-10 00:00:00"),
            254: pd.Timestamp("2013-01-11 00:00:00"),
            255: pd.Timestamp("2013-01-12 00:00:00"),
            256: pd.Timestamp("2013-01-13 00:00:00"),
            257: pd.Timestamp("2013-01-14 00:00:00"),
            258: pd.Timestamp("2013-01-15 00:00:00"),
            259: pd.Timestamp("2013-01-16 00:00:00"),
            260: pd.Timestamp("2013-01-17 00:00:00"),
            261: pd.Timestamp("2013-01-18 00:00:00"),
            262: pd.Timestamp("2013-01-19 00:00:00"),
            263: pd.Timestamp("2013-01-20 00:00:00"),
            264: pd.Timestamp("2013-01-21 00:00:00"),
            265: pd.Timestamp("2013-01-22 00:00:00"),
            266: pd.Timestamp("2013-01-23 00:00:00"),
            267: pd.Timestamp("2013-01-24 00:00:00"),
            268: pd.Timestamp("2013-01-25 00:00:00"),
            269: pd.Timestamp("2013-01-26 00:00:00"),
            270: pd.Timestamp("2013-01-27 00:00:00"),
            271: pd.Timestamp("2013-01-28 00:00:00"),
            272: pd.Timestamp("2013-01-29 00:00:00"),
            273: pd.Timestamp("2013-01-30 00:00:00"),
            274: pd.Timestamp("2013-01-31 00:00:00"),
            275: pd.Timestamp("2013-02-01 00:00:00"),
            276: pd.Timestamp("2013-02-02 00:00:00"),
            277: pd.Timestamp("2013-02-03 00:00:00"),
            278: pd.Timestamp("2013-02-04 00:00:00"),
            279: pd.Timestamp("2013-02-05 00:00:00"),
            280: pd.Timestamp("2013-02-06 00:00:00"),
            281: pd.Timestamp("2013-02-07 00:00:00"),
            282: pd.Timestamp("2013-02-08 00:00:00"),
            283: pd.Timestamp("2013-02-09 00:00:00"),
            284: pd.Timestamp("2013-02-10 00:00:00"),
            285: pd.Timestamp("2013-02-11 00:00:00"),
            286: pd.Timestamp("2013-02-12 00:00:00"),
            287: pd.Timestamp("2013-02-13 00:00:00"),
            288: pd.Timestamp("2013-02-14 00:00:00"),
            289: pd.Timestamp("2013-02-15 00:00:00"),
            290: pd.Timestamp("2013-02-16 00:00:00"),
            291: pd.Timestamp("2013-02-17 00:00:00"),
            292: pd.Timestamp("2013-02-18 00:00:00"),
            293: pd.Timestamp("2013-02-19 00:00:00"),
            294: pd.Timestamp("2013-02-20 00:00:00"),
            295: pd.Timestamp("2013-02-21 00:00:00"),
            296: pd.Timestamp("2013-02-22 00:00:00"),
            297: pd.Timestamp("2013-02-23 00:00:00"),
            298: pd.Timestamp("2013-02-24 00:00:00"),
            299: pd.Timestamp("2013-02-25 00:00:00"),
            300: pd.Timestamp("2013-02-26 00:00:00"),
            301: pd.Timestamp("2013-02-27 00:00:00"),
            302: pd.Timestamp("2013-02-28 00:00:00"),
            303: pd.Timestamp("2013-03-01 00:00:00"),
            304: pd.Timestamp("2013-03-02 00:00:00"),
            305: pd.Timestamp("2013-03-03 00:00:00"),
            306: pd.Timestamp("2013-03-04 00:00:00"),
            307: pd.Timestamp("2013-03-05 00:00:00"),
            308: pd.Timestamp("2013-03-06 00:00:00"),
            309: pd.Timestamp("2013-03-07 00:00:00"),
            310: pd.Timestamp("2013-03-08 00:00:00"),
            311: pd.Timestamp("2013-03-09 00:00:00"),
            312: pd.Timestamp("2013-03-10 00:00:00"),
            313: pd.Timestamp("2013-03-11 00:00:00"),
            314: pd.Timestamp("2013-03-12 00:00:00"),
            315: pd.Timestamp("2013-03-13 00:00:00"),
            316: pd.Timestamp("2013-03-14 00:00:00"),
            317: pd.Timestamp("2013-03-15 00:00:00"),
            318: pd.Timestamp("2013-03-16 00:00:00"),
            319: pd.Timestamp("2013-03-17 00:00:00"),
            320: pd.Timestamp("2013-03-18 00:00:00"),
            321: pd.Timestamp("2013-03-19 00:00:00"),
            322: pd.Timestamp("2013-03-20 00:00:00"),
            323: pd.Timestamp("2013-03-21 00:00:00"),
            324: pd.Timestamp("2013-03-22 00:00:00"),
            325: pd.Timestamp("2013-03-23 00:00:00"),
            326: pd.Timestamp("2013-03-24 00:00:00"),
            327: pd.Timestamp("2013-03-25 00:00:00"),
            328: pd.Timestamp("2013-03-26 00:00:00"),
            329: pd.Timestamp("2013-03-27 00:00:00"),
            330: pd.Timestamp("2013-03-28 00:00:00"),
            331: pd.Timestamp("2013-03-29 00:00:00"),
            332: pd.Timestamp("2013-03-30 00:00:00"),
            333: pd.Timestamp("2013-03-31 00:00:00"),
            334: pd.Timestamp("2013-04-01 00:00:00"),
            335: pd.Timestamp("2013-04-02 00:00:00"),
            336: pd.Timestamp("2013-04-03 00:00:00"),
            337: pd.Timestamp("2013-04-04 00:00:00"),
            338: pd.Timestamp("2013-04-05 00:00:00"),
            339: pd.Timestamp("2013-04-06 00:00:00"),
            340: pd.Timestamp("2013-04-07 00:00:00"),
            341: pd.Timestamp("2013-04-08 00:00:00"),
            342: pd.Timestamp("2013-04-09 00:00:00"),
            343: pd.Timestamp("2013-04-10 00:00:00"),
            344: pd.Timestamp("2013-04-11 00:00:00"),
            345: pd.Timestamp("2013-04-12 00:00:00"),
            346: pd.Timestamp("2013-04-13 00:00:00"),
            347: pd.Timestamp("2013-04-14 00:00:00"),
            348: pd.Timestamp("2013-04-15 00:00:00"),
            349: pd.Timestamp("2013-04-16 00:00:00"),
            350: pd.Timestamp("2013-04-17 00:00:00"),
            351: pd.Timestamp("2013-04-18 00:00:00"),
            352: pd.Timestamp("2013-04-19 00:00:00"),
            353: pd.Timestamp("2013-04-20 00:00:00"),
            354: pd.Timestamp("2013-04-21 00:00:00"),
            355: pd.Timestamp("2013-04-22 00:00:00"),
            356: pd.Timestamp("2013-04-23 00:00:00"),
            357: pd.Timestamp("2013-04-24 00:00:00"),
            358: pd.Timestamp("2013-04-25 00:00:00"),
            359: pd.Timestamp("2013-04-26 00:00:00"),
            360: pd.Timestamp("2013-04-27 00:00:00"),
            361: pd.Timestamp("2013-04-28 00:00:00"),
            362: pd.Timestamp("2013-04-29 00:00:00"),
            363: pd.Timestamp("2013-04-30 00:00:00"),
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
            379: pd.Timestamp("2013-05-16 00:00:00"),
            380: pd.Timestamp("2013-05-17 00:00:00"),
            381: pd.Timestamp("2013-05-18 00:00:00"),
            382: pd.Timestamp("2013-05-19 00:00:00"),
            383: pd.Timestamp("2013-05-20 00:00:00"),
            384: pd.Timestamp("2013-05-21 00:00:00"),
            385: pd.Timestamp("2013-05-22 00:00:00"),
            386: pd.Timestamp("2013-05-23 00:00:00"),
            387: pd.Timestamp("2013-05-24 00:00:00"),
            388: pd.Timestamp("2013-05-25 00:00:00"),
            389: pd.Timestamp("2013-05-26 00:00:00"),
            390: pd.Timestamp("2013-05-27 00:00:00"),
            391: pd.Timestamp("2013-05-28 00:00:00"),
            392: pd.Timestamp("2013-05-29 00:00:00"),
            393: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.348604308646497,
            1: 8.348964254851197,
            2: 8.349324201055898,
            3: 8.349684147260598,
            4: 8.350044093465298,
            5: 8.350404039669998,
            6: 8.3507639858747,
            7: 8.3511239320794,
            8: 8.3514838782841,
            9: 8.351843824488801,
            10: 8.352203770693501,
            11: 8.352563716898201,
            12: 8.352923663102903,
            13: 8.353283609307603,
            14: 8.353643555512303,
            15: 8.354003501717003,
            16: 8.354363447921704,
            17: 8.354723394126404,
            18: 8.355083340331104,
            19: 8.355443286535806,
            20: 8.355803232740506,
            21: 8.356163178945206,
            22: 8.356523125149906,
            23: 8.356883071354607,
            24: 8.357243017559307,
            25: 8.357602963764007,
            26: 8.357962909968709,
            27: 8.358322856173409,
            28: 8.358682802378109,
            29: 8.35904274858281,
            30: 8.35940269478751,
            31: 8.35976264099221,
            32: 8.36012258719691,
            33: 8.360482533401612,
            34: 8.360842479606312,
            35: 8.361202425811012,
            36: 8.361562372015714,
            37: 8.361922318220413,
            38: 8.362282264425113,
            39: 8.362642210629813,
            40: 8.363002156834515,
            41: 8.363362103039215,
            42: 8.363722049243915,
            43: 8.364081995448617,
            44: 8.364441941653316,
            45: 8.364801887858016,
            46: 8.365161834062716,
            47: 8.365521780267418,
            48: 8.365881726472118,
            49: 8.366241672676818,
            50: 8.36660161888152,
            51: 8.36696156508622,
            52: 8.36732151129092,
            53: 8.367681457495621,
            54: 8.368041403700321,
            55: 8.368401349905021,
            56: 8.36876129610972,
            57: 8.369121242314423,
            58: 8.369481188519122,
            59: 8.369841134723822,
            60: 8.370201080928524,
            61: 8.370561027133224,
            62: 8.370920973337924,
            63: 8.371280919542624,
            64: 8.371640865747326,
            65: 8.372000811952026,
            66: 8.372360758156725,
            67: 8.372720704361427,
            68: 8.373080650566127,
            69: 8.373440596770827,
            70: 8.373800542975529,
            71: 8.374160489180229,
            72: 8.374520435384929,
            73: 8.374880381589628,
            74: 8.37524032779433,
            75: 8.37560027399903,
            76: 8.37596022020373,
            77: 8.376320166408432,
            78: 8.376680112613132,
            79: 8.377040058817832,
            80: 8.377400005022531,
            81: 8.377759951227233,
            82: 8.378119897431933,
            83: 8.378479843636633,
            84: 8.378839789841335,
            85: 8.379199736046035,
            86: 8.379559682250735,
            87: 8.379919628455436,
            88: 8.380279574660136,
            89: 8.380639520864836,
            90: 8.380999467069536,
            91: 8.381359413274238,
            92: 8.381719359478938,
            93: 8.382079305683638,
            94: 8.38243925188834,
            95: 8.38279919809304,
            96: 8.38315914429774,
            97: 8.383519090502439,
            98: 8.38387903670714,
            99: 8.38423898291184,
            100: 8.38459892911654,
            101: 8.384958875321242,
            102: 8.385318821525942,
            103: 8.385678767730642,
            104: 8.386038713935344,
            105: 8.386398660140044,
            106: 8.386758606344744,
            107: 8.387118552549444,
            108: 8.387478498754145,
            109: 8.387838444958845,
            110: 8.388198391163545,
            111: 8.388558337368247,
            112: 8.388918283572947,
            113: 8.389278229777647,
            114: 8.389638175982347,
            115: 8.389998122187048,
            116: 8.390358068391748,
            117: 8.390718014596448,
            118: 8.39107796080115,
            119: 8.39143790700585,
            120: 8.39179785321055,
            121: 8.392157799415251,
            122: 8.392517745619951,
            123: 8.392877691824651,
            124: 8.393237638029351,
            125: 8.393597584234053,
            126: 8.393957530438753,
            127: 8.394317476643453,
            128: 8.394677422848154,
            129: 8.395037369052854,
            130: 8.395397315257554,
            131: 8.395757261462254,
            132: 8.396117207666956,
            133: 8.396477153871656,
            134: 8.396837100076356,
            135: 8.397197046281057,
            136: 8.397556992485757,
            137: 8.397916938690457,
            138: 8.398276884895157,
            139: 8.398636831099859,
            140: 8.398996777304559,
            141: 8.399356723509259,
            142: 8.39971666971396,
            143: 8.40007661591866,
            144: 8.40043656212336,
            145: 8.400796508328062,
            146: 8.401156454532762,
            147: 8.401516400737462,
            148: 8.401876346942162,
            149: 8.402236293146863,
            150: 8.402596239351563,
            151: 8.402956185556263,
            152: 8.403316131760965,
            153: 8.403676077965665,
            154: 8.404036024170365,
            155: 8.404395970375065,
            156: 8.404755916579767,
            157: 8.405115862784466,
            158: 8.405475808989166,
            159: 8.405835755193868,
            160: 8.406195701398568,
            161: 8.406555647603268,
            162: 8.40691559380797,
            163: 8.40727554001267,
            164: 8.40763548621737,
            165: 8.40799543242207,
            166: 8.408355378626771,
            167: 8.408715324831471,
            168: 8.409075271036171,
            169: 8.409435217240873,
            170: 8.409795163445573,
            171: 8.410155109650272,
            172: 8.410515055854972,
            173: 8.410875002059674,
            174: 8.411234948264374,
            175: 8.411594894469074,
            176: 8.411954840673776,
            177: 8.412314786878476,
            178: 8.412674733083175,
            179: 8.413034679287877,
            180: 8.413394625492577,
            181: 8.413754571697277,
            182: 8.414114517901977,
            183: 8.414474464106679,
            184: 8.414834410311379,
            185: 8.415194356516078,
            186: 8.41555430272078,
            187: 8.41591424892548,
            188: 8.41627419513018,
            189: 8.41663414133488,
            190: 8.416994087539582,
            191: 8.417354033744282,
            192: 8.417713979948982,
            193: 8.418073926153683,
            194: 8.418433872358383,
            195: 8.418793818563083,
            196: 8.419153764767785,
            197: 8.419513710972485,
            198: 8.419873657177185,
            199: 8.420233603381885,
            200: 8.420593549586586,
            201: 8.420953495791286,
            202: 8.421313441995986,
            203: 8.421673388200688,
            204: 8.422033334405388,
            205: 8.422393280610088,
            206: 8.422753226814788,
            207: 8.42311317301949,
            208: 8.42347311922419,
            209: 8.423833065428889,
            210: 8.42419301163359,
            211: 8.42455295783829,
            212: 8.42491290404299,
            213: 8.42527285024769,
            214: 8.425632796452392,
            215: 8.425992742657092,
            216: 8.426352688861792,
            217: 8.426712635066494,
            218: 8.427072581271194,
            219: 8.427432527475894,
            220: 8.427792473680595,
            221: 8.428152419885295,
            222: 8.428512366089995,
            223: 8.428872312294695,
            224: 8.429232258499397,
            225: 8.429592204704097,
            226: 8.429952150908797,
            227: 8.430312097113498,
            228: 8.430672043318198,
            229: 8.431031989522898,
            230: 8.431391935727598,
            231: 8.4317518819323,
            232: 8.432111828137,
            233: 8.4324717743417,
            234: 8.432831720546401,
            235: 8.433191666751101,
            236: 8.433551612955801,
            237: 8.433911559160503,
            238: 8.434271505365203,
            239: 8.434631451569903,
            240: 8.434991397774603,
            241: 8.435351343979304,
            242: 8.435711290184004,
            243: 8.436071236388704,
            244: 8.436431182593406,
            245: 8.436791128798106,
            246: 8.437151075002806,
            247: 8.437511021207506,
            248: 8.437870967412207,
            249: 8.438230913616907,
            250: 8.438590859821607,
            251: 8.438950806026309,
            252: 8.439310752231009,
            253: 8.439670698435709,
            254: 8.44003064464041,
            255: 8.44039059084511,
            256: 8.44075053704981,
            257: 8.44111048325451,
            258: 8.441470429459212,
            259: 8.441830375663912,
            260: 8.442190321868612,
            261: 8.442550268073314,
            262: 8.442910214278013,
            263: 8.443270160482713,
            264: 8.443630106687413,
            265: 8.443990052892115,
            266: 8.444349999096815,
            267: 8.444709945301515,
            268: 8.445069891506217,
            269: 8.445429837710916,
            270: 8.445789783915616,
            271: 8.446149730120318,
            272: 8.446509676325018,
            273: 8.446869622529718,
            274: 8.447229568734418,
            275: 8.44758951493912,
            276: 8.44794946114382,
            277: 8.44830940734852,
            278: 8.448669353553221,
            279: 8.449029299757921,
            280: 8.449389245962621,
            281: 8.449749192167321,
            282: 8.450109138372023,
            283: 8.450469084576723,
            284: 8.450829030781422,
            285: 8.451188976986124,
            286: 8.451548923190824,
            287: 8.451908869395524,
            288: 8.452268815600226,
            289: 8.452628761804926,
            290: 8.452988708009626,
            291: 8.453348654214325,
            292: 8.453708600419027,
            293: 8.454068546623727,
            294: 8.454428492828427,
            295: 8.454788439033129,
            296: 8.455148385237829,
            297: 8.455508331442529,
            298: 8.455868277647228,
            299: 8.45622822385193,
            300: 8.45658817005663,
            301: 8.45694811626133,
            302: 8.457308062466032,
            303: 8.457668008670732,
            304: 8.458027954875432,
            305: 8.458387901080131,
            306: 8.458747847284833,
            307: 8.459107793489533,
            308: 8.459467739694233,
            309: 8.459827685898935,
            310: 8.460187632103635,
            311: 8.460547578308335,
            312: 8.460907524513036,
            313: 8.461267470717736,
            314: 8.461627416922436,
            315: 8.461987363127136,
            316: 8.462347309331838,
            317: 8.462707255536538,
            318: 8.463067201741238,
            319: 8.46342714794594,
            320: 8.46378709415064,
            321: 8.46414704035534,
            322: 8.464506986560039,
            323: 8.46486693276474,
            324: 8.46522687896944,
            325: 8.46558682517414,
            326: 8.465946771378842,
            327: 8.466306717583542,
            328: 8.466666663788242,
            329: 8.467026609992944,
            330: 8.467386556197644,
            331: 8.467746502402344,
            332: 8.468106448607044,
            333: 8.468466394811745,
            334: 8.468826341016445,
            335: 8.469186287221145,
            336: 8.469546233425847,
            337: 8.469906179630547,
            338: 8.470266125835247,
            339: 8.470626072039947,
            340: 8.470986018244648,
            341: 8.471345964449348,
            342: 8.471705910654048,
            343: 8.47206585685875,
            344: 8.47242580306345,
            345: 8.47278574926815,
            346: 8.473145695472851,
            347: 8.473505641677551,
            348: 8.473865587882251,
            349: 8.474225534086951,
            350: 8.474585480291653,
            351: 8.474945426496353,
            352: 8.475305372701053,
            353: 8.475665318905754,
            354: 8.476025265110454,
            355: 8.476385211315154,
            356: 8.476745157519854,
            357: 8.477105103724556,
            358: 8.477465049929256,
            359: 8.477824996133956,
            360: 8.478184942338657,
            361: 8.478544888543357,
            362: 8.478904834748057,
            363: 8.479264780952759,
            364: 8.479624727157459,
            365: 8.479984673362159,
            366: 8.480344619566859,
            367: 8.48070456577156,
            368: 8.48106451197626,
            369: 8.48142445818096,
            370: 8.481784404385662,
            371: 8.482144350590362,
            372: 8.482504296795062,
            373: 8.482864242999762,
            374: 8.483224189204464,
            375: 8.483584135409163,
            376: 8.483944081613863,
            377: 8.484304027818565,
            378: 8.484663974023265,
            379: 8.485023920227965,
            380: 8.485383866432667,
            381: 8.485743812637367,
            382: 8.486103758842066,
            383: 8.486463705046766,
            384: 8.486823651251468,
            385: 8.487183597456168,
            386: 8.487543543660868,
            387: 8.48790348986557,
            388: 8.48826343607027,
            389: 8.48862338227497,
            390: 8.48898332847967,
            391: 8.489343274684371,
            392: 8.489703220889071,
            393: 8.490063167093771,
        },
        "fcst_lower": {
            0: np.nan,
            1: np.nan,
            2: np.nan,
            3: np.nan,
            4: np.nan,
            5: np.nan,
            6: np.nan,
            7: np.nan,
            8: np.nan,
            9: np.nan,
            10: np.nan,
            11: np.nan,
            12: np.nan,
            13: np.nan,
            14: np.nan,
            15: np.nan,
            16: np.nan,
            17: np.nan,
            18: np.nan,
            19: np.nan,
            20: np.nan,
            21: np.nan,
            22: np.nan,
            23: np.nan,
            24: np.nan,
            25: np.nan,
            26: np.nan,
            27: np.nan,
            28: np.nan,
            29: np.nan,
            30: np.nan,
            31: np.nan,
            32: np.nan,
            33: np.nan,
            34: np.nan,
            35: np.nan,
            36: np.nan,
            37: np.nan,
            38: np.nan,
            39: np.nan,
            40: np.nan,
            41: np.nan,
            42: np.nan,
            43: np.nan,
            44: np.nan,
            45: np.nan,
            46: np.nan,
            47: np.nan,
            48: np.nan,
            49: np.nan,
            50: np.nan,
            51: np.nan,
            52: np.nan,
            53: np.nan,
            54: np.nan,
            55: np.nan,
            56: np.nan,
            57: np.nan,
            58: np.nan,
            59: np.nan,
            60: np.nan,
            61: np.nan,
            62: np.nan,
            63: np.nan,
            64: np.nan,
            65: np.nan,
            66: np.nan,
            67: np.nan,
            68: np.nan,
            69: np.nan,
            70: np.nan,
            71: np.nan,
            72: np.nan,
            73: np.nan,
            74: np.nan,
            75: np.nan,
            76: np.nan,
            77: np.nan,
            78: np.nan,
            79: np.nan,
            80: np.nan,
            81: np.nan,
            82: np.nan,
            83: np.nan,
            84: np.nan,
            85: np.nan,
            86: np.nan,
            87: np.nan,
            88: np.nan,
            89: np.nan,
            90: np.nan,
            91: np.nan,
            92: np.nan,
            93: np.nan,
            94: np.nan,
            95: np.nan,
            96: np.nan,
            97: np.nan,
            98: np.nan,
            99: np.nan,
            100: np.nan,
            101: np.nan,
            102: np.nan,
            103: np.nan,
            104: np.nan,
            105: np.nan,
            106: np.nan,
            107: np.nan,
            108: np.nan,
            109: np.nan,
            110: np.nan,
            111: np.nan,
            112: np.nan,
            113: np.nan,
            114: np.nan,
            115: np.nan,
            116: np.nan,
            117: np.nan,
            118: np.nan,
            119: np.nan,
            120: np.nan,
            121: np.nan,
            122: np.nan,
            123: np.nan,
            124: np.nan,
            125: np.nan,
            126: np.nan,
            127: np.nan,
            128: np.nan,
            129: np.nan,
            130: np.nan,
            131: np.nan,
            132: np.nan,
            133: np.nan,
            134: np.nan,
            135: np.nan,
            136: np.nan,
            137: np.nan,
            138: np.nan,
            139: np.nan,
            140: np.nan,
            141: np.nan,
            142: np.nan,
            143: np.nan,
            144: np.nan,
            145: np.nan,
            146: np.nan,
            147: np.nan,
            148: np.nan,
            149: np.nan,
            150: np.nan,
            151: np.nan,
            152: np.nan,
            153: np.nan,
            154: np.nan,
            155: np.nan,
            156: np.nan,
            157: np.nan,
            158: np.nan,
            159: np.nan,
            160: np.nan,
            161: np.nan,
            162: np.nan,
            163: np.nan,
            164: np.nan,
            165: np.nan,
            166: np.nan,
            167: np.nan,
            168: np.nan,
            169: np.nan,
            170: np.nan,
            171: np.nan,
            172: np.nan,
            173: np.nan,
            174: np.nan,
            175: np.nan,
            176: np.nan,
            177: np.nan,
            178: np.nan,
            179: np.nan,
            180: np.nan,
            181: np.nan,
            182: np.nan,
            183: np.nan,
            184: np.nan,
            185: np.nan,
            186: np.nan,
            187: np.nan,
            188: np.nan,
            189: np.nan,
            190: np.nan,
            191: np.nan,
            192: np.nan,
            193: np.nan,
            194: np.nan,
            195: np.nan,
            196: np.nan,
            197: np.nan,
            198: np.nan,
            199: np.nan,
            200: np.nan,
            201: np.nan,
            202: np.nan,
            203: np.nan,
            204: np.nan,
            205: np.nan,
            206: np.nan,
            207: np.nan,
            208: np.nan,
            209: np.nan,
            210: np.nan,
            211: np.nan,
            212: np.nan,
            213: np.nan,
            214: np.nan,
            215: np.nan,
            216: np.nan,
            217: np.nan,
            218: np.nan,
            219: np.nan,
            220: np.nan,
            221: np.nan,
            222: np.nan,
            223: np.nan,
            224: np.nan,
            225: np.nan,
            226: np.nan,
            227: np.nan,
            228: np.nan,
            229: np.nan,
            230: np.nan,
            231: np.nan,
            232: np.nan,
            233: np.nan,
            234: np.nan,
            235: np.nan,
            236: np.nan,
            237: np.nan,
            238: np.nan,
            239: np.nan,
            240: np.nan,
            241: np.nan,
            242: np.nan,
            243: np.nan,
            244: np.nan,
            245: np.nan,
            246: np.nan,
            247: np.nan,
            248: np.nan,
            249: np.nan,
            250: np.nan,
            251: np.nan,
            252: np.nan,
            253: np.nan,
            254: np.nan,
            255: np.nan,
            256: np.nan,
            257: np.nan,
            258: np.nan,
            259: np.nan,
            260: np.nan,
            261: np.nan,
            262: np.nan,
            263: np.nan,
            264: np.nan,
            265: np.nan,
            266: np.nan,
            267: np.nan,
            268: np.nan,
            269: np.nan,
            270: np.nan,
            271: np.nan,
            272: np.nan,
            273: np.nan,
            274: np.nan,
            275: np.nan,
            276: np.nan,
            277: np.nan,
            278: np.nan,
            279: np.nan,
            280: np.nan,
            281: np.nan,
            282: np.nan,
            283: np.nan,
            284: np.nan,
            285: np.nan,
            286: np.nan,
            287: np.nan,
            288: np.nan,
            289: np.nan,
            290: np.nan,
            291: np.nan,
            292: np.nan,
            293: np.nan,
            294: np.nan,
            295: np.nan,
            296: np.nan,
            297: np.nan,
            298: np.nan,
            299: np.nan,
            300: np.nan,
            301: np.nan,
            302: np.nan,
            303: np.nan,
            304: np.nan,
            305: np.nan,
            306: np.nan,
            307: np.nan,
            308: np.nan,
            309: np.nan,
            310: np.nan,
            311: np.nan,
            312: np.nan,
            313: np.nan,
            314: np.nan,
            315: np.nan,
            316: np.nan,
            317: np.nan,
            318: np.nan,
            319: np.nan,
            320: np.nan,
            321: np.nan,
            322: np.nan,
            323: np.nan,
            324: np.nan,
            325: np.nan,
            326: np.nan,
            327: np.nan,
            328: np.nan,
            329: np.nan,
            330: np.nan,
            331: np.nan,
            332: np.nan,
            333: np.nan,
            334: np.nan,
            335: np.nan,
            336: np.nan,
            337: np.nan,
            338: np.nan,
            339: np.nan,
            340: np.nan,
            341: np.nan,
            342: np.nan,
            343: np.nan,
            344: np.nan,
            345: np.nan,
            346: np.nan,
            347: np.nan,
            348: np.nan,
            349: np.nan,
            350: np.nan,
            351: np.nan,
            352: np.nan,
            353: np.nan,
            354: np.nan,
            355: np.nan,
            356: np.nan,
            357: np.nan,
            358: np.nan,
            359: np.nan,
            360: np.nan,
            361: np.nan,
            362: np.nan,
            363: np.nan,
            364: np.nan,
            365: np.nan,
            366: np.nan,
            367: np.nan,
            368: np.nan,
            369: np.nan,
            370: np.nan,
            371: np.nan,
            372: np.nan,
            373: np.nan,
            374: np.nan,
            375: np.nan,
            376: np.nan,
            377: np.nan,
            378: np.nan,
            379: np.nan,
            380: np.nan,
            381: np.nan,
            382: np.nan,
            383: np.nan,
            384: np.nan,
            385: np.nan,
            386: np.nan,
            387: np.nan,
            388: np.nan,
            389: np.nan,
            390: np.nan,
            391: np.nan,
            392: np.nan,
            393: np.nan,
        },
        "fcst_upper": {
            0: np.nan,
            1: np.nan,
            2: np.nan,
            3: np.nan,
            4: np.nan,
            5: np.nan,
            6: np.nan,
            7: np.nan,
            8: np.nan,
            9: np.nan,
            10: np.nan,
            11: np.nan,
            12: np.nan,
            13: np.nan,
            14: np.nan,
            15: np.nan,
            16: np.nan,
            17: np.nan,
            18: np.nan,
            19: np.nan,
            20: np.nan,
            21: np.nan,
            22: np.nan,
            23: np.nan,
            24: np.nan,
            25: np.nan,
            26: np.nan,
            27: np.nan,
            28: np.nan,
            29: np.nan,
            30: np.nan,
            31: np.nan,
            32: np.nan,
            33: np.nan,
            34: np.nan,
            35: np.nan,
            36: np.nan,
            37: np.nan,
            38: np.nan,
            39: np.nan,
            40: np.nan,
            41: np.nan,
            42: np.nan,
            43: np.nan,
            44: np.nan,
            45: np.nan,
            46: np.nan,
            47: np.nan,
            48: np.nan,
            49: np.nan,
            50: np.nan,
            51: np.nan,
            52: np.nan,
            53: np.nan,
            54: np.nan,
            55: np.nan,
            56: np.nan,
            57: np.nan,
            58: np.nan,
            59: np.nan,
            60: np.nan,
            61: np.nan,
            62: np.nan,
            63: np.nan,
            64: np.nan,
            65: np.nan,
            66: np.nan,
            67: np.nan,
            68: np.nan,
            69: np.nan,
            70: np.nan,
            71: np.nan,
            72: np.nan,
            73: np.nan,
            74: np.nan,
            75: np.nan,
            76: np.nan,
            77: np.nan,
            78: np.nan,
            79: np.nan,
            80: np.nan,
            81: np.nan,
            82: np.nan,
            83: np.nan,
            84: np.nan,
            85: np.nan,
            86: np.nan,
            87: np.nan,
            88: np.nan,
            89: np.nan,
            90: np.nan,
            91: np.nan,
            92: np.nan,
            93: np.nan,
            94: np.nan,
            95: np.nan,
            96: np.nan,
            97: np.nan,
            98: np.nan,
            99: np.nan,
            100: np.nan,
            101: np.nan,
            102: np.nan,
            103: np.nan,
            104: np.nan,
            105: np.nan,
            106: np.nan,
            107: np.nan,
            108: np.nan,
            109: np.nan,
            110: np.nan,
            111: np.nan,
            112: np.nan,
            113: np.nan,
            114: np.nan,
            115: np.nan,
            116: np.nan,
            117: np.nan,
            118: np.nan,
            119: np.nan,
            120: np.nan,
            121: np.nan,
            122: np.nan,
            123: np.nan,
            124: np.nan,
            125: np.nan,
            126: np.nan,
            127: np.nan,
            128: np.nan,
            129: np.nan,
            130: np.nan,
            131: np.nan,
            132: np.nan,
            133: np.nan,
            134: np.nan,
            135: np.nan,
            136: np.nan,
            137: np.nan,
            138: np.nan,
            139: np.nan,
            140: np.nan,
            141: np.nan,
            142: np.nan,
            143: np.nan,
            144: np.nan,
            145: np.nan,
            146: np.nan,
            147: np.nan,
            148: np.nan,
            149: np.nan,
            150: np.nan,
            151: np.nan,
            152: np.nan,
            153: np.nan,
            154: np.nan,
            155: np.nan,
            156: np.nan,
            157: np.nan,
            158: np.nan,
            159: np.nan,
            160: np.nan,
            161: np.nan,
            162: np.nan,
            163: np.nan,
            164: np.nan,
            165: np.nan,
            166: np.nan,
            167: np.nan,
            168: np.nan,
            169: np.nan,
            170: np.nan,
            171: np.nan,
            172: np.nan,
            173: np.nan,
            174: np.nan,
            175: np.nan,
            176: np.nan,
            177: np.nan,
            178: np.nan,
            179: np.nan,
            180: np.nan,
            181: np.nan,
            182: np.nan,
            183: np.nan,
            184: np.nan,
            185: np.nan,
            186: np.nan,
            187: np.nan,
            188: np.nan,
            189: np.nan,
            190: np.nan,
            191: np.nan,
            192: np.nan,
            193: np.nan,
            194: np.nan,
            195: np.nan,
            196: np.nan,
            197: np.nan,
            198: np.nan,
            199: np.nan,
            200: np.nan,
            201: np.nan,
            202: np.nan,
            203: np.nan,
            204: np.nan,
            205: np.nan,
            206: np.nan,
            207: np.nan,
            208: np.nan,
            209: np.nan,
            210: np.nan,
            211: np.nan,
            212: np.nan,
            213: np.nan,
            214: np.nan,
            215: np.nan,
            216: np.nan,
            217: np.nan,
            218: np.nan,
            219: np.nan,
            220: np.nan,
            221: np.nan,
            222: np.nan,
            223: np.nan,
            224: np.nan,
            225: np.nan,
            226: np.nan,
            227: np.nan,
            228: np.nan,
            229: np.nan,
            230: np.nan,
            231: np.nan,
            232: np.nan,
            233: np.nan,
            234: np.nan,
            235: np.nan,
            236: np.nan,
            237: np.nan,
            238: np.nan,
            239: np.nan,
            240: np.nan,
            241: np.nan,
            242: np.nan,
            243: np.nan,
            244: np.nan,
            245: np.nan,
            246: np.nan,
            247: np.nan,
            248: np.nan,
            249: np.nan,
            250: np.nan,
            251: np.nan,
            252: np.nan,
            253: np.nan,
            254: np.nan,
            255: np.nan,
            256: np.nan,
            257: np.nan,
            258: np.nan,
            259: np.nan,
            260: np.nan,
            261: np.nan,
            262: np.nan,
            263: np.nan,
            264: np.nan,
            265: np.nan,
            266: np.nan,
            267: np.nan,
            268: np.nan,
            269: np.nan,
            270: np.nan,
            271: np.nan,
            272: np.nan,
            273: np.nan,
            274: np.nan,
            275: np.nan,
            276: np.nan,
            277: np.nan,
            278: np.nan,
            279: np.nan,
            280: np.nan,
            281: np.nan,
            282: np.nan,
            283: np.nan,
            284: np.nan,
            285: np.nan,
            286: np.nan,
            287: np.nan,
            288: np.nan,
            289: np.nan,
            290: np.nan,
            291: np.nan,
            292: np.nan,
            293: np.nan,
            294: np.nan,
            295: np.nan,
            296: np.nan,
            297: np.nan,
            298: np.nan,
            299: np.nan,
            300: np.nan,
            301: np.nan,
            302: np.nan,
            303: np.nan,
            304: np.nan,
            305: np.nan,
            306: np.nan,
            307: np.nan,
            308: np.nan,
            309: np.nan,
            310: np.nan,
            311: np.nan,
            312: np.nan,
            313: np.nan,
            314: np.nan,
            315: np.nan,
            316: np.nan,
            317: np.nan,
            318: np.nan,
            319: np.nan,
            320: np.nan,
            321: np.nan,
            322: np.nan,
            323: np.nan,
            324: np.nan,
            325: np.nan,
            326: np.nan,
            327: np.nan,
            328: np.nan,
            329: np.nan,
            330: np.nan,
            331: np.nan,
            332: np.nan,
            333: np.nan,
            334: np.nan,
            335: np.nan,
            336: np.nan,
            337: np.nan,
            338: np.nan,
            339: np.nan,
            340: np.nan,
            341: np.nan,
            342: np.nan,
            343: np.nan,
            344: np.nan,
            345: np.nan,
            346: np.nan,
            347: np.nan,
            348: np.nan,
            349: np.nan,
            350: np.nan,
            351: np.nan,
            352: np.nan,
            353: np.nan,
            354: np.nan,
            355: np.nan,
            356: np.nan,
            357: np.nan,
            358: np.nan,
            359: np.nan,
            360: np.nan,
            361: np.nan,
            362: np.nan,
            363: np.nan,
            364: np.nan,
            365: np.nan,
            366: np.nan,
            367: np.nan,
            368: np.nan,
            369: np.nan,
            370: np.nan,
            371: np.nan,
            372: np.nan,
            373: np.nan,
            374: np.nan,
            375: np.nan,
            376: np.nan,
            377: np.nan,
            378: np.nan,
            379: np.nan,
            380: np.nan,
            381: np.nan,
            382: np.nan,
            383: np.nan,
            384: np.nan,
            385: np.nan,
            386: np.nan,
            387: np.nan,
            388: np.nan,
            389: np.nan,
            390: np.nan,
            391: np.nan,
            392: np.nan,
            393: np.nan,
        },
    }
)

PEYTON_FCST_LINEAR_NAN = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: np.nan,
            1: np.nan,
            2: np.nan,
            3: np.nan,
            4: np.nan,
            5: np.nan,
            6: np.nan,
            7: np.nan,
            8: np.nan,
            9: np.nan,
            10: np.nan,
            11: np.nan,
            12: np.nan,
            13: np.nan,
            14: np.nan,
            15: np.nan,
            16: np.nan,
            17: np.nan,
            18: np.nan,
            19: np.nan,
            20: np.nan,
            21: np.nan,
            22: np.nan,
            23: np.nan,
            24: np.nan,
            25: np.nan,
            26: np.nan,
            27: np.nan,
            28: np.nan,
            29: np.nan,
        },
        "fcst_lower": {
            0: np.nan,
            1: np.nan,
            2: np.nan,
            3: np.nan,
            4: np.nan,
            5: np.nan,
            6: np.nan,
            7: np.nan,
            8: np.nan,
            9: np.nan,
            10: np.nan,
            11: np.nan,
            12: np.nan,
            13: np.nan,
            14: np.nan,
            15: np.nan,
            16: np.nan,
            17: np.nan,
            18: np.nan,
            19: np.nan,
            20: np.nan,
            21: np.nan,
            22: np.nan,
            23: np.nan,
            24: np.nan,
            25: np.nan,
            26: np.nan,
            27: np.nan,
            28: np.nan,
            29: np.nan,
        },
        "fcst_upper": {
            0: np.nan,
            1: np.nan,
            2: np.nan,
            3: np.nan,
            4: np.nan,
            5: np.nan,
            6: np.nan,
            7: np.nan,
            8: np.nan,
            9: np.nan,
            10: np.nan,
            11: np.nan,
            12: np.nan,
            13: np.nan,
            14: np.nan,
            15: np.nan,
            16: np.nan,
            17: np.nan,
            18: np.nan,
            19: np.nan,
            20: np.nan,
            21: np.nan,
            22: np.nan,
            23: np.nan,
            24: np.nan,
            25: np.nan,
            26: np.nan,
            27: np.nan,
            28: np.nan,
            29: np.nan,
        },
    }
)

PEYTON_INPUT_NAN = pd.DataFrame(
    {
        "time": {
            0: "2012-05-02",
            1: "2012-05-03",
            2: "2012-05-04",
            3: "2012-05-05",
            4: "2012-05-06",
            5: "2012-05-07",
            6: "2012-05-08",
            7: "2012-05-09",
            8: "2012-05-10",
            9: "2012-05-11",
            10: "2012-05-12",
            11: "2012-05-13",
            12: "2012-05-14",
            13: "2012-05-15",
            14: "2012-05-16",
            15: "2012-05-17",
            16: "2012-05-18",
            17: "2012-05-19",
            18: "2012-05-20",
            19: "2012-05-21",
            20: "2012-05-22",
            21: "2012-05-23",
            22: "2012-05-24",
            23: "2012-05-25",
            24: "2012-05-26",
            25: "2012-05-27",
            26: "2012-05-28",
            27: "2012-05-29",
            28: "2012-05-30",
            29: "2012-05-31",
            30: "2012-06-01",
            31: "2012-06-02",
            32: "2012-06-03",
            33: "2012-06-04",
            34: "2012-06-05",
            35: "2012-06-06",
            36: "2012-06-07",
            37: "2012-06-08",
            38: "2012-06-09",
            39: "2012-06-10",
            40: "2012-06-11",
            41: "2012-06-12",
            42: "2012-06-13",
            43: "2012-06-14",
            44: "2012-06-15",
            45: "2012-06-16",
            46: "2012-06-17",
            47: "2012-06-18",
            48: "2012-06-19",
            49: "2012-06-20",
            50: "2012-06-21",
            51: "2012-06-22",
            52: "2012-06-23",
            53: "2012-06-24",
            54: "2012-06-25",
            55: "2012-06-26",
            56: "2012-06-27",
            57: "2012-06-28",
            58: "2012-06-29",
            59: "2012-06-30",
            60: "2012-07-01",
            61: "2012-07-02",
            62: "2012-07-03",
            63: "2012-07-04",
            64: "2012-07-05",
            65: "2012-07-06",
            66: "2012-07-07",
            67: "2012-07-08",
            68: "2012-07-09",
            69: "2012-07-10",
            70: "2012-07-11",
            71: "2012-07-12",
            72: "2012-07-13",
            73: "2012-07-14",
            74: "2012-07-15",
            75: "2012-07-16",
            76: "2012-07-17",
            77: "2012-07-18",
            78: "2012-07-19",
            79: "2012-07-20",
            80: "2012-07-21",
            81: "2012-07-22",
            82: "2012-07-23",
            83: "2012-07-24",
            84: "2012-07-25",
            85: "2012-07-26",
            86: "2012-07-27",
            87: "2012-07-28",
            88: "2012-07-29",
            89: "2012-07-30",
            90: "2012-07-31",
            91: "2012-08-01",
            92: "2012-08-02",
            93: "2012-08-03",
            94: "2012-08-04",
            95: "2012-08-05",
            96: "2012-08-06",
            97: "2012-08-07",
            98: "2012-08-08",
            99: "2012-08-09",
            100: "2012-08-10",
            101: "2012-08-11",
            102: "2012-08-12",
            103: "2012-08-13",
            104: "2012-08-14",
            105: "2012-08-15",
            106: "2012-08-16",
            107: "2012-08-17",
            108: "2012-08-18",
            109: "2012-08-19",
            110: "2012-08-20",
            111: "2012-08-21",
            112: "2012-08-22",
            113: "2012-08-23",
            114: "2012-08-24",
            115: "2012-08-25",
            116: "2012-08-26",
            117: "2012-08-27",
            118: "2012-08-28",
            119: "2012-08-29",
            120: "2012-08-30",
            121: "2012-08-31",
            122: "2012-09-01",
            123: "2012-09-02",
            124: "2012-09-03",
            125: "2012-09-04",
            126: "2012-09-05",
            127: "2012-09-06",
            128: "2012-09-07",
            129: "2012-09-08",
            130: "2012-09-09",
            131: "2012-09-10",
            132: "2012-09-11",
            133: "2012-09-12",
            134: "2012-09-13",
            135: "2012-09-14",
            136: "2012-09-15",
            137: "2012-09-16",
            138: "2012-09-17",
            139: "2012-09-18",
            140: "2012-09-19",
            141: "2012-09-20",
            142: "2012-09-21",
            143: "2012-09-22",
            144: "2012-09-23",
            145: "2012-09-24",
            146: "2012-09-25",
            147: "2012-09-26",
            148: "2012-09-27",
            149: "2012-09-28",
            150: "2012-09-29",
            151: "2012-09-30",
            152: "2012-10-01",
            153: "2012-10-02",
            154: "2012-10-03",
            155: "2012-10-04",
            156: "2012-10-05",
            157: "2012-10-06",
            158: "2012-10-07",
            159: "2012-10-08",
            160: "2012-10-09",
            161: "2012-10-10",
            162: "2012-10-11",
            163: "2012-10-12",
            164: "2012-10-13",
            165: "2012-10-14",
            166: "2012-10-15",
            167: "2012-10-16",
            168: "2012-10-17",
            169: "2012-10-18",
            170: "2012-10-19",
            171: "2012-10-20",
            172: "2012-10-21",
            173: "2012-10-22",
            174: "2012-10-23",
            175: "2012-10-24",
            176: "2012-10-25",
            177: "2012-10-26",
            178: "2012-10-27",
            179: "2012-10-28",
            180: "2012-10-29",
            181: "2012-10-30",
            182: "2012-10-31",
            183: "2012-11-01",
            184: "2012-11-02",
            185: "2012-11-03",
            186: "2012-11-04",
            187: "2012-11-05",
            188: "2012-11-06",
            189: "2012-11-07",
            190: "2012-11-08",
            191: "2012-11-09",
            192: "2012-11-10",
            193: "2012-11-11",
            194: "2012-11-12",
            195: "2012-11-13",
            196: "2012-11-14",
            197: "2012-11-15",
            198: "2012-11-16",
            199: "2012-11-17",
            200: "2012-11-18",
            201: "2012-11-19",
            202: "2012-11-20",
            203: "2012-11-21",
            204: "2012-11-22",
            205: "2012-11-23",
            206: "2012-11-24",
            207: "2012-11-25",
            208: "2012-11-26",
            209: "2012-11-27",
            210: "2012-11-28",
            211: "2012-11-29",
            212: "2012-11-30",
            213: "2012-12-01",
            214: "2012-12-02",
            215: "2012-12-03",
            216: "2012-12-04",
            217: "2012-12-05",
            218: "2012-12-06",
            219: "2012-12-07",
            220: "2012-12-08",
            221: "2012-12-09",
            222: "2012-12-10",
            223: "2012-12-11",
            224: "2012-12-12",
            225: "2012-12-13",
            226: "2012-12-14",
            227: "2012-12-15",
            228: "2012-12-16",
            229: "2012-12-17",
            230: "2012-12-18",
            231: "2012-12-19",
            232: "2012-12-20",
            233: "2012-12-21",
            234: "2012-12-22",
            235: "2012-12-23",
            236: "2012-12-24",
            237: "2012-12-25",
            238: "2012-12-26",
            239: "2012-12-27",
            240: "2012-12-28",
            241: "2012-12-29",
            242: "2012-12-30",
            243: "2012-12-31",
            244: "2013-01-01",
            245: "2013-01-02",
            246: "2013-01-03",
            247: "2013-01-04",
            248: "2013-01-05",
            249: "2013-01-06",
            250: "2013-01-07",
            251: "2013-01-08",
            252: "2013-01-09",
            253: "2013-01-10",
            254: "2013-01-11",
            255: "2013-01-12",
            256: "2013-01-13",
            257: "2013-01-14",
            258: "2013-01-15",
            259: "2013-01-16",
            260: "2013-01-17",
            261: "2013-01-18",
            262: "2013-01-19",
            263: "2013-01-20",
            264: "2013-01-21",
            265: "2013-01-22",
            266: "2013-01-23",
            267: "2013-01-24",
            268: "2013-01-25",
            269: "2013-01-26",
            270: "2013-01-27",
            271: "2013-01-28",
            272: "2013-01-29",
            273: "2013-01-30",
            274: "2013-01-31",
            275: "2013-02-01",
            276: "2013-02-02",
            277: "2013-02-03",
            278: "2013-02-04",
            279: "2013-02-05",
            280: "2013-02-06",
            281: "2013-02-07",
            282: "2013-02-08",
            283: "2013-02-09",
            284: "2013-02-10",
            285: "2013-02-11",
            286: "2013-02-12",
            287: "2013-02-13",
            288: "2013-02-14",
            289: "2013-02-15",
            290: "2013-02-16",
            291: "2013-02-17",
            292: "2013-02-18",
            293: "2013-02-19",
            294: "2013-02-20",
            295: "2013-02-21",
            296: "2013-02-22",
            297: "2013-02-23",
            298: "2013-02-24",
            299: "2013-02-25",
            300: "2013-02-26",
            301: "2013-02-27",
            302: "2013-02-28",
            303: "2013-03-01",
            304: "2013-03-02",
            305: "2013-03-03",
            306: "2013-03-04",
            307: "2013-03-05",
            308: "2013-03-06",
            309: "2013-03-07",
            310: "2013-03-08",
            311: "2013-03-09",
            312: "2013-03-10",
            313: "2013-03-11",
            314: "2013-03-12",
            315: "2013-03-13",
            316: "2013-03-14",
            317: "2013-03-15",
            318: "2013-03-16",
            319: "2013-03-17",
            320: "2013-03-18",
            321: "2013-03-19",
            322: "2013-03-20",
            323: "2013-03-21",
            324: "2013-03-22",
            325: "2013-03-23",
            326: "2013-03-24",
            327: "2013-03-25",
            328: "2013-03-26",
            329: "2013-03-27",
            330: "2013-03-28",
            331: "2013-03-29",
            332: "2013-03-30",
            333: "2013-03-31",
            334: "2013-04-01",
            335: "2013-04-02",
            336: "2013-04-03",
            337: "2013-04-04",
            338: "2013-04-05",
            339: "2013-04-06",
            340: "2013-04-07",
            341: "2013-04-08",
            342: "2013-04-09",
            343: "2013-04-10",
            344: "2013-04-11",
            345: "2013-04-12",
            346: "2013-04-13",
            347: "2013-04-14",
            348: "2013-04-15",
            349: "2013-04-16",
            350: "2013-04-17",
            351: "2013-04-18",
            352: "2013-04-19",
            353: "2013-04-20",
            354: "2013-04-21",
            355: "2013-04-22",
            356: "2013-04-23",
            357: "2013-04-24",
            358: "2013-04-25",
            359: "2013-04-26",
            360: "2013-04-27",
            361: "2013-04-28",
            362: "2013-04-29",
            363: "2013-04-30",
        },
        "y": {
            0: np.nan,
            1: np.nan,
            2: np.nan,
            3: np.nan,
            4: np.nan,
            5: np.nan,
            6: np.nan,
            7: np.nan,
            8: np.nan,
            9: np.nan,
            10: np.nan,
            11: np.nan,
            12: np.nan,
            13: np.nan,
            14: np.nan,
            15: np.nan,
            16: np.nan,
            17: np.nan,
            18: np.nan,
            19: np.nan,
            20: np.nan,
            21: np.nan,
            22: np.nan,
            23: np.nan,
            24: np.nan,
            25: np.nan,
            26: np.nan,
            27: np.nan,
            28: np.nan,
            29: np.nan,
            30: np.nan,
            31: np.nan,
            32: np.nan,
            33: np.nan,
            34: np.nan,
            35: np.nan,
            36: np.nan,
            37: np.nan,
            38: np.nan,
            39: np.nan,
            40: np.nan,
            41: np.nan,
            42: np.nan,
            43: np.nan,
            44: np.nan,
            45: np.nan,
            46: np.nan,
            47: np.nan,
            48: np.nan,
            49: np.nan,
            50: np.nan,
            51: np.nan,
            52: np.nan,
            53: np.nan,
            54: np.nan,
            55: np.nan,
            56: np.nan,
            57: np.nan,
            58: np.nan,
            59: np.nan,
            60: np.nan,
            61: np.nan,
            62: np.nan,
            63: np.nan,
            64: np.nan,
            65: np.nan,
            66: np.nan,
            67: np.nan,
            68: np.nan,
            69: np.nan,
            70: np.nan,
            71: np.nan,
            72: np.nan,
            73: np.nan,
            74: np.nan,
            75: np.nan,
            76: np.nan,
            77: np.nan,
            78: np.nan,
            79: np.nan,
            80: np.nan,
            81: np.nan,
            82: np.nan,
            83: np.nan,
            84: np.nan,
            85: np.nan,
            86: np.nan,
            87: np.nan,
            88: np.nan,
            89: np.nan,
            90: np.nan,
            91: np.nan,
            92: np.nan,
            93: np.nan,
            94: np.nan,
            95: np.nan,
            96: np.nan,
            97: np.nan,
            98: np.nan,
            99: np.nan,
            100: np.nan,
            101: np.nan,
            102: np.nan,
            103: np.nan,
            104: np.nan,
            105: np.nan,
            106: np.nan,
            107: np.nan,
            108: np.nan,
            109: np.nan,
            110: np.nan,
            111: np.nan,
            112: np.nan,
            113: np.nan,
            114: np.nan,
            115: np.nan,
            116: np.nan,
            117: np.nan,
            118: np.nan,
            119: np.nan,
            120: np.nan,
            121: np.nan,
            122: np.nan,
            123: np.nan,
            124: np.nan,
            125: np.nan,
            126: np.nan,
            127: np.nan,
            128: np.nan,
            129: np.nan,
            130: np.nan,
            131: np.nan,
            132: np.nan,
            133: np.nan,
            134: np.nan,
            135: np.nan,
            136: np.nan,
            137: np.nan,
            138: np.nan,
            139: np.nan,
            140: np.nan,
            141: np.nan,
            142: np.nan,
            143: np.nan,
            144: np.nan,
            145: np.nan,
            146: np.nan,
            147: np.nan,
            148: np.nan,
            149: np.nan,
            150: np.nan,
            151: np.nan,
            152: np.nan,
            153: np.nan,
            154: np.nan,
            155: np.nan,
            156: np.nan,
            157: np.nan,
            158: np.nan,
            159: np.nan,
            160: np.nan,
            161: np.nan,
            162: np.nan,
            163: np.nan,
            164: np.nan,
            165: np.nan,
            166: np.nan,
            167: np.nan,
            168: np.nan,
            169: np.nan,
            170: np.nan,
            171: np.nan,
            172: np.nan,
            173: np.nan,
            174: np.nan,
            175: np.nan,
            176: np.nan,
            177: np.nan,
            178: np.nan,
            179: np.nan,
            180: np.nan,
            181: np.nan,
            182: np.nan,
            183: np.nan,
            184: np.nan,
            185: np.nan,
            186: np.nan,
            187: np.nan,
            188: np.nan,
            189: np.nan,
            190: np.nan,
            191: np.nan,
            192: np.nan,
            193: np.nan,
            194: np.nan,
            195: np.nan,
            196: np.nan,
            197: np.nan,
            198: np.nan,
            199: np.nan,
            200: np.nan,
            201: np.nan,
            202: np.nan,
            203: np.nan,
            204: np.nan,
            205: np.nan,
            206: np.nan,
            207: np.nan,
            208: np.nan,
            209: np.nan,
            210: np.nan,
            211: np.nan,
            212: np.nan,
            213: np.nan,
            214: np.nan,
            215: np.nan,
            216: np.nan,
            217: np.nan,
            218: np.nan,
            219: np.nan,
            220: np.nan,
            221: np.nan,
            222: np.nan,
            223: np.nan,
            224: np.nan,
            225: np.nan,
            226: np.nan,
            227: np.nan,
            228: np.nan,
            229: np.nan,
            230: np.nan,
            231: np.nan,
            232: np.nan,
            233: np.nan,
            234: np.nan,
            235: np.nan,
            236: np.nan,
            237: np.nan,
            238: np.nan,
            239: np.nan,
            240: np.nan,
            241: np.nan,
            242: np.nan,
            243: np.nan,
            244: np.nan,
            245: np.nan,
            246: np.nan,
            247: np.nan,
            248: np.nan,
            249: np.nan,
            250: np.nan,
            251: np.nan,
            252: np.nan,
            253: np.nan,
            254: np.nan,
            255: np.nan,
            256: np.nan,
            257: np.nan,
            258: np.nan,
            259: np.nan,
            260: np.nan,
            261: np.nan,
            262: np.nan,
            263: np.nan,
            264: np.nan,
            265: np.nan,
            266: np.nan,
            267: np.nan,
            268: np.nan,
            269: np.nan,
            270: np.nan,
            271: np.nan,
            272: np.nan,
            273: np.nan,
            274: np.nan,
            275: np.nan,
            276: np.nan,
            277: np.nan,
            278: np.nan,
            279: np.nan,
            280: np.nan,
            281: np.nan,
            282: np.nan,
            283: np.nan,
            284: np.nan,
            285: np.nan,
            286: np.nan,
            287: np.nan,
            288: np.nan,
            289: np.nan,
            290: np.nan,
            291: np.nan,
            292: np.nan,
            293: np.nan,
            294: np.nan,
            295: np.nan,
            296: np.nan,
            297: np.nan,
            298: np.nan,
            299: np.nan,
            300: np.nan,
            301: np.nan,
            302: np.nan,
            303: np.nan,
            304: np.nan,
            305: np.nan,
            306: np.nan,
            307: np.nan,
            308: np.nan,
            309: np.nan,
            310: np.nan,
            311: np.nan,
            312: np.nan,
            313: np.nan,
            314: np.nan,
            315: np.nan,
            316: np.nan,
            317: np.nan,
            318: np.nan,
            319: np.nan,
            320: np.nan,
            321: np.nan,
            322: np.nan,
            323: np.nan,
            324: np.nan,
            325: np.nan,
            326: np.nan,
            327: np.nan,
            328: np.nan,
            329: np.nan,
            330: np.nan,
            331: np.nan,
            332: np.nan,
            333: np.nan,
            334: np.nan,
            335: np.nan,
            336: np.nan,
            337: np.nan,
            338: np.nan,
            339: np.nan,
            340: np.nan,
            341: np.nan,
            342: np.nan,
            343: np.nan,
            344: np.nan,
            345: np.nan,
            346: np.nan,
            347: np.nan,
            348: np.nan,
            349: np.nan,
            350: np.nan,
            351: np.nan,
            352: np.nan,
            353: np.nan,
            354: np.nan,
            355: np.nan,
            356: np.nan,
            357: np.nan,
            358: np.nan,
            359: np.nan,
            360: np.nan,
            361: np.nan,
            362: np.nan,
            363: np.nan,
        },
    }
)

METALEARNING_TEST_T1 = pd.DataFrame(
    {
        "time": {i: t for i, t in enumerate(pd.date_range("2021-05-06", periods=60))},
        "value": {
            0: 0.7112185692244729,
            1: 0.28612756331913936,
            2: 1.7908691322641883,
            3: 0.43736075519156936,
            4: -0.23525058548224762,
            5: -1.7582001930868774,
            6: -1.3365811786052153,
            7: 2.70136827387631,
            8: -0.8503288703120376,
            9: -0.47291541289255906,
            10: -0.9736036599402202,
            11: -0.053613618660455685,
            12: -0.4399764354493508,
            13: 0.6510891719510783,
            14: 0.9102880748521228,
            15: -1.2169517244324117,
            16: 0.8823261711758554,
            17: -0.5167547199636685,
            18: -0.4241112420820669,
            19: -0.15161410456893973,
            20: 1.6557873470589026,
            21: 1.2492635567473669,
            22: 0.07067834347638169,
            23: 0.3623930917415304,
            24: -0.32136739683067467,
            25: 0.9965947640417286,
            26: 0.8934515245219763,
            27: 1.3250787764049077,
            28: 1.2944296521273506,
            29: -1.3910010840943103,
            30: 0.6328473646452667,
            31: -0.6151063175871002,
            32: 0.8221900526926592,
            33: 0.8837000910837177,
            34: 0.6241905424412373,
            35: -0.8085562684125828,
            36: -0.3968679453028329,
            37: 0.6234364586120968,
            38: -0.37072070379376093,
            39: -1.7565683865929325,
            40: 1.9080129722528856,
            41: -1.5900532052259917,
            42: -1.5547053773517148,
            43: 0.6241855745492039,
            44: -1.4985540880236143,
            45: -0.6693668595230223,
            46: -1.9413572006241901,
            47: 1.1699716086421006,
            48: -0.2929609945390526,
            49: 0.8411729895364164,
            50: -0.7087415808122113,
            51: 1.2840790235360602,
            52: -0.7147023141176251,
            53: 1.7370410717756741,
            54: -0.5205749206419553,
            55: -0.15020971601450228,
            56: -1.5088757646035433,
            57: -1.043191636587259,
            58: 0.09474263159788751,
            59: -0.12799293830733294,
        },
    }
)

METALEARNING_TEST_T1_FEATURES = {
    "length": 60,
    "mean": 0.017541978414630434,
    "var": 1.1330423233556002,
    "entropy": 0.8859834841922064,
    "lumpiness": 0.02715210543626642,
    "stability": 0.040424748165751194,
    "flat_spots": 1,
    "hurst": -0.009818911425943738,
    "std1st_der": 0.7210367489651559,
    "crossing_points": 32,
    "binarize_mean": 0.4666666666666667,
    "unitroot_kpss": 0.07430358370741166,
    "heterogeneity": 6.697453093870143,
    "histogram_mode": -0.5485395582740402,
    "linearity": 0.02245331522304122,
    "trend_strength": 0.22455457938231527,
    "seasonality_strength": 0.4810375570834332,
    "spikiness": 0.00012961684067190377,
    "peak": 0,
    "trough": 5,
    "level_shift_idx": 21,
    "level_shift_size": 0.1419658380986679,
    "y_acf1": -0.1334061337054278,
    "y_acf5": 0.03813891322368813,
    "diff1y_acf1": -0.5958571156764788,
    "diff1y_acf5": 0.4160058545847156,
    "diff2y_acf1": -0.7374357720433103,
    "diff2y_acf5": 0.7048949611179683,
    "y_pacf5": 0.03335133884678569,
    "diff1y_pacf5": 0.7499500138901602,
    "diff2y_pacf5": 1.8304505333773173,
    "seas_acf1": 0.16081850213286256,
    "seas_pacf1": 0.22189491849213927,
    "firstmin_ac": 1,
    "firstzero_ac": 3,
    "holt_alpha": 0.21052631578947367,
    "holt_beta": 0.21052631578947367,
    "hw_alpha": np.nan,
    "hw_beta": np.nan,
    "hw_gamma": np.nan,
}

METALEARNING_TEST_T2 = pd.DataFrame(
    {
        "time": {i: t for i, t in enumerate(pd.date_range("2021-05-06", periods=60))},
        "value": {
            0: 0.03311787628295211,
            1: 0.5273022473907714,
            2: 0.3773553931583247,
            3: 0.09563694333627344,
            4: 1.524706793895165,
            5: 0.6171562805357564,
            6: 0.35859880554321116,
            7: 0.6050713159814466,
            8: 0.8843087863778628,
            9: 1.6375480266541607,
            10: 0.7061190560580963,
            11: 0.6961083764757605,
            12: 0.05859116425445711,
            13: 1.4199818522703387,
            14: 0.14449318312962062,
            15: 3.139712107794079,
            16: 1.8761537803231672,
            17: 0.14085831327945778,
            18: 1.7274097408558717,
            19: 0.042350555351393815,
            20: 1.950774376187714,
            21: 1.062863664255698,
            22: 0.8975406475971797,
            23: 0.7556289030342478,
            24: 1.193215581899301,
            25: 0.7265814392991706,
            26: 0.7091637521237201,
            27: 0.6387444272009849,
            28: 0.6724117330778265,
            29: 1.2893706824976368,
            30: 0.39742659040034645,
            31: 1.595405033245209,
            32: 0.7458532366189279,
            33: 0.7032615006875266,
            34: 0.5933185716755207,
            35: 0.16107480444349953,
            36: 0.5592223806594153,
            37: 0.7745859398941953,
            38: 1.3068416600591384,
            39: 1.2436098268331073,
            40: 0.25952021498932615,
            41: 1.347500758310904,
            42: 1.8494084696277076,
            43: 0.3054109812345139,
            44: 0.6470355749547894,
            45: 0.21825776026063276,
            46: 0.36770844840170835,
            47: 0.7560966411821854,
            48: 0.16415990275685444,
            49: 0.552571928952884,
            50: 2.04178068255798,
            51: 1.790573925858621,
            52: 0.24618139328935654,
            53: 0.400888337382867,
            54: 2.175527336804398,
            55: 1.406341482682491,
            56: 1.0197034851735676,
            57: 1.9823165173659234,
            58: 0.13775080596032568,
            59: 1.081401230949507,
        },
    }
)

METALEARNING_TEST_T2_FEATURES = {
    "length": 60,
    "mean": 0.8889935204889182,
    "var": 0.4339723115044476,
    "entropy": 0.9062662461791416,
    "lumpiness": 0.023362172264992747,
    "stability": 0.030229530493845646,
    "flat_spots": 1,
    "hurst": -0.021772668163519544,
    "std1st_der": 0.48397243746464197,
    "crossing_points": 27,
    "binarize_mean": 0.38333333333333336,
    "unitroot_kpss": 0.08053956294618499,
    "heterogeneity": 3.732058275703587,
    "histogram_mode": 0.03311787628295211,
    "linearity": 0.012797310585104091,
    "trend_strength": 0.24190571668002014,
    "seasonality_strength": 0.37385052827383813,
    "spikiness": 2.8368797395354512e-05,
    "peak": 4,
    "trough": 3,
    "level_shift_idx": 15,
    "level_shift_size": 0.14893186516752932,
    "y_acf1": -0.09313831054944781,
    "y_acf5": 0.041934017014729597,
    "diff1y_acf1": -0.5279995758182909,
    "diff1y_acf5": 0.3441814241353133,
    "diff2y_acf1": -0.6592266744380927,
    "diff2y_acf5": 0.5333616344338944,
    "y_pacf5": 0.042648851746986086,
    "diff1y_pacf5": 0.6799034767926148,
    "diff2y_pacf5": 1.2927400320509825,
    "seas_acf1": 0.00474904222956029,
    "seas_pacf1": 0.015773034095832947,
    "firstmin_ac": 1,
    "firstzero_ac": 4,
    "holt_alpha": 0.20073207666635207,
    "holt_beta": 0.20073038111605043,
    "hw_alpha": 0.10526241886359299,
    "hw_beta": 0.10526943965945956,
    "hw_gamma": 0.26315604715898244,
}

METALEARNING_TEST_FEATURES = [
    [
        1.08565103,
        -0.92567252,
        -0.31020792,
        1.29803874,
        -0.80276567,
        -0.26583506,
        -2.83965074,
        -0.53971508,
        -0.52822807,
        0.23892437,
        -0.13409521,
        -0.44432967,
        -0.16805101,
        -0.90482502,
        -0.02182439,
        -0.11112191,
        -0.48058064,
        0.90641584,
        0.73888397,
        0.49253603,
        -1.0450474,
        1.15928987,
        -0.60442358,
        2.40575244,
        -1.9539288,
        0.4424955,
        -1.34667628,
        -1.30152228,
        -0.69201056,
        0.63910397,
        0.21705932,
        1.36665286,
        -0.59686006,
        0.94514967,
        -0.11579573,
        0.43509245,
        0.92586754,
        -0.10588535,
        0.23006655,
        0.9286056,
    ],
    [
        -0.05468981,
        0.14851362,
        -0.77330589,
        0.09830413,
        -0.4989081,
        -0.83200877,
        0.95829231,
        0.6187273,
        0.36315383,
        0.36637462,
        0.39614439,
        -0.2464249,
        -1.6899136,
        1.41230063,
        -1.22986175,
        0.07146394,
        -0.22278461,
        -0.24202289,
        -1.41214979,
        -0.34357369,
        -0.74921607,
        -0.31704973,
        0.23464001,
        -1.1360718,
        0.39051003,
        0.52022306,
        -0.80449176,
        0.53360451,
        0.39917439,
        -1.29757766,
        -0.96291282,
        -0.89634859,
        0.47413525,
        1.66061776,
        0.41800094,
        -0.50182222,
        1.00137551,
        -0.78192466,
        0.27105568,
        -0.53869405,
    ],
]

METALEARNING_TEST_MULTI = pd.DataFrame(
    {
        "time": {i: t for i, t in enumerate(pd.date_range("2021-05-06", periods=30))},
        "y": {
            0: 1,
            1: 2,
            2: 3,
            3: 4,
            4: 5,
            5: 6,
            6: 7,
            7: 8,
            8: 9,
            9: 10,
            10: 11,
            11: 12,
            12: 13,
            13: 14,
            14: 15,
            15: 16,
            16: 17,
            17: 18,
            18: 19,
            19: 20,
            20: 21,
            21: 22,
            22: 23,
            23: 24,
            24: 25,
            25: 26,
            26: 27,
            27: 28,
            28: 29,
            29: 30,
        },
        "z": {
            0: 1.2622887024442238,
            1: -1.375388419424237,
            2: 1.6105001100909309,
            3: 0.8360217153674283,
            4: -1.1787646903164346,
            5: -0.4873760750756692,
            6: -1.385672390891951,
            7: 0.6208331955845247,
            8: 0.7488032806815271,
            9: 0.3002392127702183,
            10: -0.22645033854916954,
            11: -0.9209664873600163,
            12: 0.07008998004246421,
            13: -0.6716084779303537,
            14: 0.47582398344006577,
            15: -0.17841450908106507,
            16: 0.0905434173978501,
            17: -0.10524527869658624,
            18: -0.23408569091546855,
            19: -1.0165202742858588,
            20: 0.8245635894080147,
            21: 0.7619909485066353,
            22: 0.2854745931462472,
            23: -0.8794144092785487,
            24: 1.294518927777081,
            25: -0.1593423664921398,
            26: -0.25588735974394616,
            27: -1.1383373628596727,
            28: -0.7418581263160675,
            29: -0.28032496781238847,
        },
    }
)

PEYTON_FCST_15_ARIMA_PARAM_1_MODEL_1 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
        },
        "fcst": {
            0: 7.940480857230361,
            1: 7.890521247867683,
            2: 7.868743227314358,
            3: 7.859001067790166,
            4: 7.854399212870253,
            5: 7.851992691658566,
            6: 7.850523758870425,
            7: 7.849455253611216,
            8: 7.848557763908408,
            9: 7.847733311942562,
            10: 7.846940053109861,
            11: 7.84616011631582,
            12: 7.845385869130233,
            13: 7.844614051876368,
            14: 7.843843272403614,
        },
        "fcst_lower": {
            0: 7.05954539696271,
            1: 6.895622219348986,
            2: 6.834214576608463,
            3: 6.803917944580299,
            4: 6.784960481789183,
            5: 6.770545536610528,
            6: 6.758058474764527,
            7: 6.746435277314804,
            8: 6.7352309284064615,
            9: 6.7242563949242085,
            10: 6.71343022358396,
            11: 6.702716519862747,
            12: 6.692098772048167,
            13: 6.681568754691981,
            14: 6.671121814034725,
        },
        "fcst_upper": {
            0: 8.821416317498013,
            1: 8.88542027638638,
            2: 8.903271878020252,
            3: 8.914084191000033,
            4: 8.923837943951323,
            5: 8.933439846706605,
            6: 8.942989042976322,
            7: 8.952475229907629,
            8: 8.961884599410356,
            9: 8.971210228960917,
            10: 8.980449882635762,
            11: 8.989603712768893,
            12: 8.998672966212299,
            13: 9.007659349060756,
            14: 9.016564730772503,
        },
    }
)

PEYTON_FCST_30_ARIMA_PARAM_1_MODEL_1 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.940480857230361,
            1: 7.890521247867683,
            2: 7.868743227314358,
            3: 7.859001067790166,
            4: 7.854399212870253,
            5: 7.851992691658566,
            6: 7.850523758870425,
            7: 7.849455253611216,
            8: 7.848557763908408,
            9: 7.847733311942562,
            10: 7.846940053109861,
            11: 7.84616011631582,
            12: 7.845385869130233,
            13: 7.844614051876368,
            14: 7.843843272403614,
            15: 7.843072936148924,
            16: 7.842302789184875,
            17: 7.841532723063531,
            18: 7.840762691468684,
            19: 7.839992674619497,
            20: 7.839222664067922,
            21: 7.838452656205947,
            22: 7.837682649492652,
            23: 7.836912643269938,
            24: 7.836142637256742,
            25: 7.835372631333029,
            26: 7.834602625447531,
            27: 7.833832619578356,
            28: 7.833062613716151,
            29: 7.832292607856923,
        },
        "fcst_lower": {
            0: 7.05954539696271,
            1: 6.895622219348986,
            2: 6.834214576608463,
            3: 6.803917944580299,
            4: 6.784960481789183,
            5: 6.770545536610528,
            6: 6.758058474764527,
            7: 6.746435277314804,
            8: 6.7352309284064615,
            9: 6.7242563949242085,
            10: 6.71343022358396,
            11: 6.702716519862747,
            12: 6.692098772048167,
            13: 6.681568754691981,
            14: 6.671121814034725,
            15: 6.660754861687368,
            16: 6.65046551906174,
            17: 6.6402517511320145,
            18: 6.630111708424872,
            19: 6.620043657716803,
            20: 6.610045950601637,
            21: 6.600117008296207,
            22: 6.590255313472834,
            23: 6.580459405190895,
            24: 6.570727875248046,
            25: 6.561059365228859,
            26: 6.5514525639365075,
            27: 6.541906205067343,
            28: 6.532419065062822,
            29: 6.522989961105574,
        },
        "fcst_upper": {
            0: 8.821416317498013,
            1: 8.88542027638638,
            2: 8.903271878020252,
            3: 8.914084191000033,
            4: 8.923837943951323,
            5: 8.933439846706605,
            6: 8.942989042976322,
            7: 8.952475229907629,
            8: 8.961884599410356,
            9: 8.971210228960917,
            10: 8.980449882635762,
            11: 8.989603712768893,
            12: 8.998672966212299,
            13: 9.007659349060756,
            14: 9.016564730772503,
            15: 9.02539101061048,
            16: 9.03414005930801,
            17: 9.042813694995047,
            18: 9.051413674512496,
            19: 9.05994169152219,
            20: 9.068399377534208,
            21: 9.076788304115686,
            22: 9.085109985512469,
            23: 9.09336588134898,
            24: 9.101557399265438,
            25: 9.109685897437199,
            26: 9.117752686958555,
            27: 9.125759034089368,
            28: 9.13370616236948,
            29: 9.141595254608273,
        },
    }
)

PEYTON_FCST_15_ARIMA_PARAM_2_MODEL_1 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
        },
        "fcst": {
            0: 7.881135373636217,
            1: 7.834420797133395,
            2: 7.8666993351876275,
            3: 7.852679933930919,
            4: 7.857141058696803,
            5: 7.85422540066944,
            6: 7.854254297592095,
            7: 7.853107830660793,
            8: 7.852430528072707,
            9: 7.851565951407573,
            10: 7.850776128036123,
            11: 7.849956465751542,
            12: 7.849148714122571,
            13: 7.848336208174419,
            14: 7.847525599985015,
        },
        "fcst_lower": {
            0: 7.016738678610501,
            1: 6.820382617649829,
            2: 6.827476584820522,
            3: 6.8060466501466355,
            4: 6.7975082882872675,
            5: 6.784161505481881,
            6: 6.772936132884821,
            7: 6.761020962803888,
            8: 6.749534723245571,
            9: 6.738023710887118,
            10: 6.7266655269502795,
            11: 6.715384943627649,
            12: 6.704208284786378,
            13: 6.693121344934464,
            14: 6.682126323863031,
        },
        "fcst_upper": {
            0: 8.745532068661932,
            1: 8.84845897661696,
            2: 8.905922085554733,
            3: 8.899313217715202,
            4: 8.91677382910634,
            5: 8.924289295857,
            6: 8.935572462299369,
            7: 8.945194698517698,
            8: 8.955326332899844,
            9: 8.965108191928028,
            10: 8.974886729121966,
            11: 8.984527987875435,
            12: 8.994089143458766,
            13: 9.003551071414375,
            14: 9.012924876106998,
        },
    }
)

PEYTON_FCST_30_ARIMA_PARAM_2_MODEL_1 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.881135373636217,
            1: 7.834420797133395,
            2: 7.8666993351876275,
            3: 7.852679933930919,
            4: 7.857141058696803,
            5: 7.85422540066944,
            6: 7.854254297592095,
            7: 7.853107830660793,
            8: 7.852430528072707,
            9: 7.851565951407573,
            10: 7.850776128036123,
            11: 7.849956465751542,
            12: 7.849148714122571,
            13: 7.848336208174419,
            14: 7.847525599985015,
            15: 7.846714234276368,
            16: 7.845903170943038,
            17: 7.8450919869120055,
            18: 7.844280851059295,
            19: 7.843469695975475,
            20: 7.842658548568045,
            21: 7.841847398096467,
            22: 7.841036248847991,
            23: 7.840225099111295,
            24: 7.8394139495694795,
            25: 7.838602799949874,
            26: 7.83779165036132,
            27: 7.836980500760371,
            28: 7.8361693511643695,
            29: 7.835358201566393,
        },
        "fcst_lower": {
            0: 7.016738678610501,
            1: 6.820382617649829,
            2: 6.827476584820522,
            3: 6.8060466501466355,
            4: 6.7975082882872675,
            5: 6.784161505481881,
            6: 6.772936132884821,
            7: 6.761020962803888,
            8: 6.749534723245571,
            9: 6.738023710887118,
            10: 6.7266655269502795,
            11: 6.715384943627649,
            12: 6.704208284786378,
            13: 6.693121344934464,
            14: 6.682126323863031,
            15: 6.671218999579241,
            16: 6.660397866112156,
            17: 6.649660463925119,
            18: 6.639004842214219,
            19: 6.628428965925433,
            20: 6.617930946560942,
            21: 6.607508943515154,
            22: 6.59716119779362,
            23: 6.586886013117941,
            24: 6.576681758463545,
            25: 6.566546862351812,
            26: 6.556479810751995,
            27: 6.546479143822264,
            28: 6.536543453377417,
            29: 6.526671380307525,
        },
        "fcst_upper": {
            0: 8.745532068661932,
            1: 8.84845897661696,
            2: 8.905922085554733,
            3: 8.899313217715202,
            4: 8.91677382910634,
            5: 8.924289295857,
            6: 8.935572462299369,
            7: 8.945194698517698,
            8: 8.955326332899844,
            9: 8.965108191928028,
            10: 8.974886729121966,
            11: 8.984527987875435,
            12: 8.994089143458766,
            13: 9.003551071414375,
            14: 9.012924876106998,
            15: 9.022209468973495,
            16: 9.03140847577392,
            17: 9.040523509898893,
            18: 9.04955685990437,
            19: 9.058510426025517,
            20: 9.067386150575148,
            21: 9.07618585267778,
            22: 9.084911299902362,
            23: 9.093564185104649,
            24: 9.102146140675414,
            25: 9.110658737547936,
            26: 9.119103489970644,
            27: 9.127481857698477,
            28: 9.135795248951322,
            29: 9.14404502282526,
        },
    }
)

PEYTON_FCST_15_ARIMA_PARAM_1_MODEL_2 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
        },
        "fcst": {
            0: 7.944025543438113,
            1: 7.896058661864416,
            2: 7.875588940590136,
            3: 7.866853549101262,
            4: 7.863125747269404,
            5: 7.861534919140486,
            6: 7.860856038059918,
            7: 7.860566327617177,
            8: 7.86044269456415,
            9: 7.8603899345336306,
            10: 7.860367419350577,
            11: 7.860357811064475,
            12: 7.860353710757513,
            13: 7.86035196096395,
            14: 7.860351214244852,
        },
        "fcst_lower": {
            0: 7.061827523068538,
            1: 6.90033565641836,
            2: 6.840623978834781,
            3: 6.811641639531865,
            4: 6.793819879993599,
            5: 6.7804584768342115,
            6: 6.768986367083855,
            7: 6.758358954743929,
            8: 6.748139882498416,
            9: 6.738144012554313,
            10: 6.728291682425065,
            11: 6.718547857384789,
            12: 6.708896471907462,
            13: 6.699329561180043,
            14: 6.689842647110949,
        },
        "fcst_upper": {
            0: 8.82622356380769,
            1: 8.891781667310472,
            2: 8.910553902345491,
            3: 8.922065458670659,
            4: 8.932431614545209,
            5: 8.942611361446762,
            6: 8.952725709035981,
            7: 8.962773700490425,
            8: 8.972745506629884,
            9: 8.982635856512948,
            10: 8.992443156276087,
            11: 9.00216776474416,
            12: 9.011810949607565,
            13: 9.021374360747856,
            14: 9.030859781378755,
        },
    }
)

PEYTON_FCST_30_ARIMA_PARAM_1_MODEL_2 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.944025543438113,
            1: 7.896058661864416,
            2: 7.875588940590136,
            3: 7.866853549101262,
            4: 7.863125747269404,
            5: 7.861534919140486,
            6: 7.860856038059918,
            7: 7.860566327617177,
            8: 7.86044269456415,
            9: 7.8603899345336306,
            10: 7.860367419350577,
            11: 7.860357811064475,
            12: 7.860353710757513,
            13: 7.86035196096395,
            14: 7.860351214244852,
            15: 7.860350895584741,
            16: 7.860350759597505,
            17: 7.860350701565364,
            18: 7.860350676800325,
            19: 7.860350666231919,
            20: 7.860350661721884,
            21: 7.86035065979724,
            22: 7.8603506589759045,
            23: 7.860350658625402,
            24: 7.860350658475825,
            25: 7.860350658411995,
            26: 7.860350658384755,
            27: 7.860350658373131,
            28: 7.86035065836817,
            29: 7.860350658366054,
        },
        "fcst_lower": {
            0: 7.061827523068538,
            1: 6.90033565641836,
            2: 6.840623978834781,
            3: 6.811641639531865,
            4: 6.793819879993599,
            5: 6.7804584768342115,
            6: 6.768986367083855,
            7: 6.758358954743929,
            8: 6.748139882498416,
            9: 6.738144012554313,
            10: 6.728291682425065,
            11: 6.718547857384789,
            12: 6.708896471907462,
            13: 6.699329561180043,
            14: 6.689842647110949,
            15: 6.680432776462899,
            16: 6.6710976850257735,
            17: 6.66183544024345,
            18: 6.652644287276451,
            19: 6.643522581653869,
            20: 6.634468758853449,
            21: 6.62548131969489,
            22: 6.616558822562795,
            23: 6.607699878632374,
            24: 6.598903148463457,
            25: 6.590167339261074,
            26: 6.581491202497958,
            27: 6.572873531763655,
            28: 6.564313160777465,
            29: 6.555808961533698,
        },
        "fcst_upper": {
            0: 8.82622356380769,
            1: 8.891781667310472,
            2: 8.910553902345491,
            3: 8.922065458670659,
            4: 8.932431614545209,
            5: 8.942611361446762,
            6: 8.952725709035981,
            7: 8.962773700490425,
            8: 8.972745506629884,
            9: 8.982635856512948,
            10: 8.992443156276087,
            11: 9.00216776474416,
            12: 9.011810949607565,
            13: 9.021374360747856,
            14: 9.030859781378755,
            15: 9.040269014706583,
            16: 9.049603834169236,
            17: 9.05886596288728,
            18: 9.068057066324197,
            19: 9.077178750809969,
            20: 9.086232564590318,
            21: 9.09521999989959,
            22: 9.104142495389015,
            23: 9.11300143861843,
            24: 9.121798168488194,
            25: 9.130533977562916,
            26: 9.139210114271552,
            27: 9.147827784982606,
            28: 9.156388155958876,
            29: 9.16489235519841,
        },
    }
)

PEYTON_FCST_15_ARIMA_PARAM_2_MODEL_2 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
        },
        "fcst": {
            0: 8.730436154070746,
            1: 1.7764696188918219,
            2: 1.7588528682367137,
            3: 1.7412361175816515,
            4: 1.7236193669266353,
            5: 1.706002616271665,
            6: 1.6883858656167408,
            7: 1.6707691149618622,
            8: 1.6531523643070296,
            9: 1.635535613652243,
            10: 1.6179188629975023,
            11: 1.6003021123428076,
            12: 1.5826853616881589,
            13: 1.565068611033556,
            14: 1.5474518603789993,
        },
        "fcst_lower": {
            0: 1.1291162054717665,
            1: -8.973407616092297,
            2: -8.991024366747405,
            3: -9.008641117402467,
            4: -9.026257868057483,
            5: -9.043874618712454,
            6: -9.061491369367378,
            7: -9.079108120022257,
            8: -9.09672487067709,
            9: -9.114341621331876,
            10: -9.131958371986617,
            11: -9.149575122641311,
            12: -9.16719187329596,
            13: -9.184808623950563,
            14: -9.20242537460512,
        },
        "fcst_upper": {
            0: 16.331756102669726,
            1: 12.52634685387594,
            2: 12.508730103220833,
            3: 12.49111335256577,
            4: 12.473496601910755,
            5: 12.455879851255784,
            6: 12.43826310060086,
            7: 12.420646349945981,
            8: 12.403029599291148,
            9: 12.385412848636362,
            10: 12.367796097981621,
            11: 12.350179347326927,
            12: 12.332562596672277,
            13: 12.314945846017675,
            14: 12.297329095363118,
        },
    }
)

PEYTON_FCST_30_ARIMA_PARAM_2_MODEL_2 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.730436154070746,
            1: 1.7764696188918219,
            2: 1.7588528682367137,
            3: 1.7412361175816515,
            4: 1.7236193669266353,
            5: 1.706002616271665,
            6: 1.6883858656167408,
            7: 1.6707691149618622,
            8: 1.6531523643070296,
            9: 1.635535613652243,
            10: 1.6179188629975023,
            11: 1.6003021123428076,
            12: 1.5826853616881589,
            13: 1.565068611033556,
            14: 1.5474518603789993,
            15: 1.5298351097244884,
            16: 1.5122183590700233,
            17: 1.4946016084156042,
            18: 1.476984857761231,
            19: 1.4593681071069038,
            20: 1.4417513564526225,
            21: 1.4241346057983872,
            22: 1.406517855144198,
            23: 1.3889011044900545,
            24: 1.3712843538359571,
            25: 1.3536676031819055,
            26: 1.3360508525278998,
            27: 1.31843410187394,
            28: 1.3008173512200263,
            29: 1.2832006005661585,
        },
        "fcst_lower": {
            0: 1.1291162054717665,
            1: -8.973407616092297,
            2: -8.991024366747405,
            3: -9.008641117402467,
            4: -9.026257868057483,
            5: -9.043874618712454,
            6: -9.061491369367378,
            7: -9.079108120022257,
            8: -9.09672487067709,
            9: -9.114341621331876,
            10: -9.131958371986617,
            11: -9.149575122641311,
            12: -9.16719187329596,
            13: -9.184808623950563,
            14: -9.20242537460512,
            15: -9.220042125259631,
            16: -9.237658875914097,
            17: -9.255275626568515,
            18: -9.272892377222888,
            19: -9.290509127877215,
            20: -9.308125878531497,
            21: -9.325742629185731,
            22: -9.34335937983992,
            23: -9.360976130494064,
            24: -9.378592881148162,
            25: -9.396209631802213,
            26: -9.41382638245622,
            27: -9.431443133110179,
            28: -9.449059883764093,
            29: -9.466676634417961,
        },
        "fcst_upper": {
            0: 16.331756102669726,
            1: 12.52634685387594,
            2: 12.508730103220833,
            3: 12.49111335256577,
            4: 12.473496601910755,
            5: 12.455879851255784,
            6: 12.43826310060086,
            7: 12.420646349945981,
            8: 12.403029599291148,
            9: 12.385412848636362,
            10: 12.367796097981621,
            11: 12.350179347326927,
            12: 12.332562596672277,
            13: 12.314945846017675,
            14: 12.297329095363118,
            15: 12.279712344708607,
            16: 12.262095594054141,
            17: 12.244478843399722,
            18: 12.22686209274535,
            19: 12.209245342091023,
            20: 12.191628591436741,
            21: 12.174011840782507,
            22: 12.156395090128317,
            23: 12.138778339474174,
            24: 12.121161588820076,
            25: 12.103544838166025,
            26: 12.085928087512018,
            27: 12.06831133685806,
            28: 12.050694586204145,
            29: 12.033077835550277,
        },
    }
)

PEYTON_FCST_15_ARIMA_PARAM_1_MODEL_1_INCL_HIST = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("2012-05-03 00:00:00"),
            "fcst": -0.0007700058570090651,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-04 00:00:00"),
            "fcst": 0.003945764176497557,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-05 00:00:00"),
            "fcst": 0.056389253940629255,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-06 00:00:00"),
            "fcst": 0.03581633435595588,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-07 00:00:00"),
            "fcst": -0.4128869117836815,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-08 00:00:00"),
            "fcst": -0.21494697202566299,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-09 00:00:00"),
            "fcst": 0.023753499987732296,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-10 00:00:00"),
            "fcst": 0.09355937802330405,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-11 00:00:00"),
            "fcst": 0.18319088827293034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-12 00:00:00"),
            "fcst": 0.20044808320056756,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-13 00:00:00"),
            "fcst": 0.2503354760854294,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-14 00:00:00"),
            "fcst": 0.17127042819947244,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-15 00:00:00"),
            "fcst": 0.14608737892963222,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-16 00:00:00"),
            "fcst": 0.1046934406435516,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-17 00:00:00"),
            "fcst": 0.022584545049575466,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-18 00:00:00"),
            "fcst": 0.05981881271357159,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-19 00:00:00"),
            "fcst": 0.14025155875910666,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-20 00:00:00"),
            "fcst": 0.2620310138400047,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-21 00:00:00"),
            "fcst": 0.20643571244428782,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-22 00:00:00"),
            "fcst": -0.03163734777951549,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-23 00:00:00"),
            "fcst": -0.17638166890869264,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-24 00:00:00"),
            "fcst": -0.026283311915276913,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-25 00:00:00"),
            "fcst": 0.08888312964866367,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-26 00:00:00"),
            "fcst": 0.09318350600838077,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-27 00:00:00"),
            "fcst": 0.21884338795240824,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-28 00:00:00"),
            "fcst": 0.11943606160735805,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-29 00:00:00"),
            "fcst": 0.09954952209841111,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-30 00:00:00"),
            "fcst": 0.0115899772154675,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-31 00:00:00"),
            "fcst": 0.012880997922767479,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-01 00:00:00"),
            "fcst": -0.0728620311757119,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-02 00:00:00"),
            "fcst": 0.01827210829676365,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-03 00:00:00"),
            "fcst": 0.08966940872011074,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-04 00:00:00"),
            "fcst": 0.06304407979604659,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-05 00:00:00"),
            "fcst": -0.013443609595630263,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-06 00:00:00"),
            "fcst": -0.05624628223233899,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-07 00:00:00"),
            "fcst": 0.0829341015327528,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-08 00:00:00"),
            "fcst": 0.03996293101592904,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-09 00:00:00"),
            "fcst": -0.03873226464407914,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-10 00:00:00"),
            "fcst": -0.06431422815004223,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-11 00:00:00"),
            "fcst": 0.028090033076010767,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-12 00:00:00"),
            "fcst": 0.08447685368419985,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-13 00:00:00"),
            "fcst": -0.02645959470756161,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-14 00:00:00"),
            "fcst": -0.04747711263299492,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-15 00:00:00"),
            "fcst": 0.03990163053922584,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-16 00:00:00"),
            "fcst": 0.04021077078495444,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-17 00:00:00"),
            "fcst": 0.11798186890164153,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-18 00:00:00"),
            "fcst": -0.07080972833656002,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-19 00:00:00"),
            "fcst": -0.011919670865285226,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-20 00:00:00"),
            "fcst": -0.2962532999717047,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-21 00:00:00"),
            "fcst": -0.16324802300440683,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-22 00:00:00"),
            "fcst": 0.0036335041454830658,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-23 00:00:00"),
            "fcst": -0.02623718629423044,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-24 00:00:00"),
            "fcst": 0.14562991055130833,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-25 00:00:00"),
            "fcst": 0.15360465873927256,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-26 00:00:00"),
            "fcst": 0.07657127134706403,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-27 00:00:00"),
            "fcst": 0.01072068277829874,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-28 00:00:00"),
            "fcst": 0.08562704277501096,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-29 00:00:00"),
            "fcst": 0.0853670485997517,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-30 00:00:00"),
            "fcst": 0.10168388082429597,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-01 00:00:00"),
            "fcst": 0.18331939970107475,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-02 00:00:00"),
            "fcst": 0.10888859514445062,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-03 00:00:00"),
            "fcst": 0.073361421870783,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-04 00:00:00"),
            "fcst": 0.00505975073752761,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-05 00:00:00"),
            "fcst": -0.011786813571759813,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-06 00:00:00"),
            "fcst": 0.04499906817304014,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-07 00:00:00"),
            "fcst": -0.02204728075254085,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-08 00:00:00"),
            "fcst": 0.01887920114434169,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-09 00:00:00"),
            "fcst": 0.02807098731061397,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-10 00:00:00"),
            "fcst": -0.05101427096084735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-11 00:00:00"),
            "fcst": -0.06567448275215854,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-12 00:00:00"),
            "fcst": -0.1661172146522294,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-13 00:00:00"),
            "fcst": -0.45662523636038066,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-14 00:00:00"),
            "fcst": -0.29484802919147635,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-15 00:00:00"),
            "fcst": -0.2576509951513812,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-16 00:00:00"),
            "fcst": -0.06331978173133601,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-17 00:00:00"),
            "fcst": -0.024190222244225165,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-18 00:00:00"),
            "fcst": -0.04005079178503399,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-19 00:00:00"),
            "fcst": -0.03513273312234734,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-20 00:00:00"),
            "fcst": -0.005376936062810568,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-21 00:00:00"),
            "fcst": -0.029961636549809822,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-22 00:00:00"),
            "fcst": 0.0695630775721521,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-23 00:00:00"),
            "fcst": 0.050399959617684564,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-24 00:00:00"),
            "fcst": -0.07115299609536034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-25 00:00:00"),
            "fcst": -0.02788826856667878,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-26 00:00:00"),
            "fcst": -0.09519448076762971,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-27 00:00:00"),
            "fcst": -0.29420534138598886,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-28 00:00:00"),
            "fcst": -0.4405363351823598,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-29 00:00:00"),
            "fcst": -0.09301263627108312,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-30 00:00:00"),
            "fcst": -0.08352088660138757,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-31 00:00:00"),
            "fcst": -0.018480056965353625,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-01 00:00:00"),
            "fcst": 0.10125417988561353,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-02 00:00:00"),
            "fcst": 0.11459132599568725,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-03 00:00:00"),
            "fcst": 0.004241493000187911,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-04 00:00:00"),
            "fcst": -0.00045454647922826136,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-05 00:00:00"),
            "fcst": -0.02016539216723052,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-06 00:00:00"),
            "fcst": -0.014948356274609428,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-07 00:00:00"),
            "fcst": -0.028782012411350644,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-08 00:00:00"),
            "fcst": 0.011485072885252356,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-09 00:00:00"),
            "fcst": 0.06683900574044777,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-10 00:00:00"),
            "fcst": -0.08106271288693767,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-11 00:00:00"),
            "fcst": -0.4375079242179869,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-12 00:00:00"),
            "fcst": -0.2312314576119786,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-13 00:00:00"),
            "fcst": -0.2747471288930195,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-14 00:00:00"),
            "fcst": -0.04576123818907407,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-15 00:00:00"),
            "fcst": -0.13192614949543646,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-16 00:00:00"),
            "fcst": -0.034070783752468276,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-17 00:00:00"),
            "fcst": 0.09132631973734068,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-18 00:00:00"),
            "fcst": -0.04358007918926741,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-19 00:00:00"),
            "fcst": -0.013374996227422553,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-20 00:00:00"),
            "fcst": -0.29410697261045793,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-21 00:00:00"),
            "fcst": -0.30386947286298016,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-22 00:00:00"),
            "fcst": 0.024655775764804988,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-23 00:00:00"),
            "fcst": 0.10488713556552678,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-24 00:00:00"),
            "fcst": 0.0075180732192244165,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-25 00:00:00"),
            "fcst": 0.0417710197874166,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-26 00:00:00"),
            "fcst": -0.16721226006178036,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-27 00:00:00"),
            "fcst": -0.48462348289444823,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-28 00:00:00"),
            "fcst": -0.2965404536031402,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-29 00:00:00"),
            "fcst": -0.003618946625966485,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-30 00:00:00"),
            "fcst": 0.05552916768599228,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-31 00:00:00"),
            "fcst": 0.0966709988230193,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-01 00:00:00"),
            "fcst": -0.008016920874532568,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-02 00:00:00"),
            "fcst": 0.03651778280738183,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-03 00:00:00"),
            "fcst": -0.20225460610116375,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-04 00:00:00"),
            "fcst": 0.010189685355543737,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-05 00:00:00"),
            "fcst": 0.051994776316516056,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-06 00:00:00"),
            "fcst": -0.08409966126151391,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-07 00:00:00"),
            "fcst": -0.6797432836365787,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-08 00:00:00"),
            "fcst": 0.014740299904501791,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-09 00:00:00"),
            "fcst": -0.029807795575780505,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-10 00:00:00"),
            "fcst": -0.5300712183424823,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-11 00:00:00"),
            "fcst": -1.3225227968332607,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-12 00:00:00"),
            "fcst": -0.24988179782478648,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-13 00:00:00"),
            "fcst": 0.1759503207731844,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-14 00:00:00"),
            "fcst": 0.20665564064411474,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-15 00:00:00"),
            "fcst": 0.03405961703029581,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-16 00:00:00"),
            "fcst": 0.15132655672394024,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-17 00:00:00"),
            "fcst": -0.3680485068109315,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-18 00:00:00"),
            "fcst": -0.24004930870575114,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-19 00:00:00"),
            "fcst": -0.682397194567312,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-20 00:00:00"),
            "fcst": 0.2565737245049693,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-21 00:00:00"),
            "fcst": 0.3236003122646166,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-22 00:00:00"),
            "fcst": -0.10975674384291934,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-23 00:00:00"),
            "fcst": 0.35054006608394706,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-24 00:00:00"),
            "fcst": -0.20280478364900545,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-25 00:00:00"),
            "fcst": -0.2102306146514188,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-26 00:00:00"),
            "fcst": 0.25117921481141614,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-27 00:00:00"),
            "fcst": 0.4667175156220593,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-28 00:00:00"),
            "fcst": 0.3871928767637057,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-29 00:00:00"),
            "fcst": 0.22082749877785862,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-30 00:00:00"),
            "fcst": 0.2878227855580986,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-01 00:00:00"),
            "fcst": -0.18531590545535792,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-02 00:00:00"),
            "fcst": -0.44818532387901944,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-03 00:00:00"),
            "fcst": 0.0781777868793121,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-04 00:00:00"),
            "fcst": 0.22944140782120054,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-05 00:00:00"),
            "fcst": 0.14181455189445258,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-06 00:00:00"),
            "fcst": -0.0664425042348854,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-07 00:00:00"),
            "fcst": 0.17349444734918595,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-08 00:00:00"),
            "fcst": -0.44641936322963316,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-09 00:00:00"),
            "fcst": -0.4431240616508445,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-10 00:00:00"),
            "fcst": 0.0681196313318011,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-11 00:00:00"),
            "fcst": 0.33864995796823016,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-12 00:00:00"),
            "fcst": 0.3504202436325591,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-13 00:00:00"),
            "fcst": 0.23727328493488054,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-14 00:00:00"),
            "fcst": 0.28969564906912915,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-15 00:00:00"),
            "fcst": -0.1163019776841474,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-16 00:00:00"),
            "fcst": -0.13790149069240654,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-17 00:00:00"),
            "fcst": -0.9459415448437483,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-18 00:00:00"),
            "fcst": 0.12174937772701971,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-19 00:00:00"),
            "fcst": 0.25131941566998117,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-20 00:00:00"),
            "fcst": 0.22188979337641102,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-21 00:00:00"),
            "fcst": 0.3132158810605632,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-22 00:00:00"),
            "fcst": -0.33213451276126243,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-23 00:00:00"),
            "fcst": -0.08805474932336255,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-24 00:00:00"),
            "fcst": 0.1233687238094402,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-25 00:00:00"),
            "fcst": 0.2629854858251821,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-26 00:00:00"),
            "fcst": 0.2408965878382258,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-27 00:00:00"),
            "fcst": 0.14370735299319456,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-28 00:00:00"),
            "fcst": 0.11091323243559104,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-29 00:00:00"),
            "fcst": -0.2265767071052478,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-30 00:00:00"),
            "fcst": -0.7866871314985183,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-31 00:00:00"),
            "fcst": 0.03450286342175132,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-01 00:00:00"),
            "fcst": 0.12339161984763047,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-02 00:00:00"),
            "fcst": 0.19814560542524334,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-03 00:00:00"),
            "fcst": 0.1449564761572295,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-04 00:00:00"),
            "fcst": 0.18248604615513786,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-05 00:00:00"),
            "fcst": -0.43422997299025146,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-06 00:00:00"),
            "fcst": -0.37740550612125046,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-07 00:00:00"),
            "fcst": 0.06620917162923201,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-08 00:00:00"),
            "fcst": 0.2693624286596078,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-09 00:00:00"),
            "fcst": 0.1901187903990711,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-10 00:00:00"),
            "fcst": 0.005358972227035297,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-11 00:00:00"),
            "fcst": 0.27344770582268496,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-12 00:00:00"),
            "fcst": -0.22125496788252316,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-13 00:00:00"),
            "fcst": -0.12727696612459283,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-14 00:00:00"),
            "fcst": 0.07711973860947507,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-15 00:00:00"),
            "fcst": 0.24731679113806196,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-16 00:00:00"),
            "fcst": 0.20617208842600365,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-17 00:00:00"),
            "fcst": 0.22819428651128137,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-18 00:00:00"),
            "fcst": 0.2754958161515757,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-19 00:00:00"),
            "fcst": -0.2506389344574349,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-20 00:00:00"),
            "fcst": -0.467200765441649,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-21 00:00:00"),
            "fcst": 0.06761280483955656,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-22 00:00:00"),
            "fcst": 0.23193076748874078,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-23 00:00:00"),
            "fcst": 0.03885382053483735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-24 00:00:00"),
            "fcst": -0.09721686118172701,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-25 00:00:00"),
            "fcst": 0.1654674229898253,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-26 00:00:00"),
            "fcst": -0.36032471147981027,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-27 00:00:00"),
            "fcst": -0.5261721545516235,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-28 00:00:00"),
            "fcst": 0.019254171195356884,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-29 00:00:00"),
            "fcst": 0.12854640295937486,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-30 00:00:00"),
            "fcst": 0.17861528108870836,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-01 00:00:00"),
            "fcst": 0.03359351112022693,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-02 00:00:00"),
            "fcst": 0.07522231284268344,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-03 00:00:00"),
            "fcst": -0.26262548926875096,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-04 00:00:00"),
            "fcst": -0.39350653024977844,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-05 00:00:00"),
            "fcst": -0.3393503050852452,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-06 00:00:00"),
            "fcst": 0.12766766047010267,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-07 00:00:00"),
            "fcst": 0.09097283050041605,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-08 00:00:00"),
            "fcst": -0.47981491425801237,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-09 00:00:00"),
            "fcst": 0.1476682708451985,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-10 00:00:00"),
            "fcst": -0.11184525776218601,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-11 00:00:00"),
            "fcst": -0.10782045188115491,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-12 00:00:00"),
            "fcst": -0.17424610786934036,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-13 00:00:00"),
            "fcst": 0.1437353570333326,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-14 00:00:00"),
            "fcst": 0.17200308558046096,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-15 00:00:00"),
            "fcst": 0.2799760031121332,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-16 00:00:00"),
            "fcst": 0.3226753147603072,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-17 00:00:00"),
            "fcst": -0.1950165891987167,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-18 00:00:00"),
            "fcst": -0.19286372659488737,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-19 00:00:00"),
            "fcst": 0.08994298163712011,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-20 00:00:00"),
            "fcst": 0.21018363219995329,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-21 00:00:00"),
            "fcst": 0.23958185908913499,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-22 00:00:00"),
            "fcst": 0.2709043381717522,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-23 00:00:00"),
            "fcst": 0.28399778442766843,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-24 00:00:00"),
            "fcst": -0.2402588508791048,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-25 00:00:00"),
            "fcst": -0.40523140964447657,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-26 00:00:00"),
            "fcst": 0.1161293098831932,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-27 00:00:00"),
            "fcst": 0.11844489779334463,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-28 00:00:00"),
            "fcst": -0.06347527468712175,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-29 00:00:00"),
            "fcst": 0.07609637479815401,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-30 00:00:00"),
            "fcst": 0.13998722124293128,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-31 00:00:00"),
            "fcst": -0.3290923983842169,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-01 00:00:00"),
            "fcst": -0.6074844406325873,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-02 00:00:00"),
            "fcst": -0.05854282021062879,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-03 00:00:00"),
            "fcst": -0.04061160273152583,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-04 00:00:00"),
            "fcst": -0.02286822726492621,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-05 00:00:00"),
            "fcst": -0.15467537094339134,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-06 00:00:00"),
            "fcst": -0.09406618749216267,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-07 00:00:00"),
            "fcst": -0.509677685073989,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-08 00:00:00"),
            "fcst": -0.15547647971956585,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-09 00:00:00"),
            "fcst": 0.0393350353994628,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-10 00:00:00"),
            "fcst": 0.058191429964034175,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-11 00:00:00"),
            "fcst": 0.09511320041848087,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-12 00:00:00"),
            "fcst": 0.003404702175357599,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-13 00:00:00"),
            "fcst": -0.6608575737008224,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-14 00:00:00"),
            "fcst": -1.0555192997492326,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-15 00:00:00"),
            "fcst": -0.32825023448483215,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-16 00:00:00"),
            "fcst": 0.13731089262913287,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-17 00:00:00"),
            "fcst": 0.32947271900323194,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-18 00:00:00"),
            "fcst": 0.35085617234508537,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-19 00:00:00"),
            "fcst": 0.3529775402961782,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-20 00:00:00"),
            "fcst": 0.4133286576452372,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-21 00:00:00"),
            "fcst": 0.13052828733826394,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-22 00:00:00"),
            "fcst": -0.3851065551528735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-23 00:00:00"),
            "fcst": 0.134589889481306,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-24 00:00:00"),
            "fcst": 0.18975632847301777,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-25 00:00:00"),
            "fcst": 0.301761047823618,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-26 00:00:00"),
            "fcst": 0.2951062264258376,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-27 00:00:00"),
            "fcst": 0.30273529239367936,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-28 00:00:00"),
            "fcst": 0.23661359254271508,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-29 00:00:00"),
            "fcst": -0.5328392882589585,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-30 00:00:00"),
            "fcst": 0.20946587624123636,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-31 00:00:00"),
            "fcst": 0.2543507321873164,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-01 00:00:00"),
            "fcst": 0.24172115295065605,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-02 00:00:00"),
            "fcst": 0.17373595459259406,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-03 00:00:00"),
            "fcst": 0.16964055640592213,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-04 00:00:00"),
            "fcst": -0.349320251163763,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-05 00:00:00"),
            "fcst": -0.5151548388618591,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-06 00:00:00"),
            "fcst": 0.08401844276598974,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-07 00:00:00"),
            "fcst": 0.2380093343070403,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-08 00:00:00"),
            "fcst": 0.2829582983631439,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-09 00:00:00"),
            "fcst": 0.34161290777682074,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-10 00:00:00"),
            "fcst": 0.35908221203549073,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-11 00:00:00"),
            "fcst": 0.3491998010157814,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-12 00:00:00"),
            "fcst": 0.29201236429210975,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-13 00:00:00"),
            "fcst": 0.28670145112115764,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-14 00:00:00"),
            "fcst": 0.28738145316032904,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-15 00:00:00"),
            "fcst": 0.32182404357492855,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-16 00:00:00"),
            "fcst": 0.2657331928021771,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-17 00:00:00"),
            "fcst": 0.27539758570602557,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-18 00:00:00"),
            "fcst": 0.24555094742973435,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-19 00:00:00"),
            "fcst": 0.15247451699757622,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-20 00:00:00"),
            "fcst": 0.11839543778088207,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-21 00:00:00"),
            "fcst": 0.1516970968169062,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-22 00:00:00"),
            "fcst": 0.16477343580307838,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-23 00:00:00"),
            "fcst": 0.13852347060075532,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-24 00:00:00"),
            "fcst": 0.18082063339946575,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-25 00:00:00"),
            "fcst": 0.19628456887496087,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-26 00:00:00"),
            "fcst": 0.10019887553438628,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-27 00:00:00"),
            "fcst": -0.07520717053836065,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-28 00:00:00"),
            "fcst": 0.03298355039674053,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-01 00:00:00"),
            "fcst": 0.055433128301513895,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-02 00:00:00"),
            "fcst": 0.07429767219394756,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-03 00:00:00"),
            "fcst": 0.12722529339106078,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-04 00:00:00"),
            "fcst": 0.09775001275984066,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-05 00:00:00"),
            "fcst": 0.06088058445207728,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-06 00:00:00"),
            "fcst": 0.05298595317047888,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-07 00:00:00"),
            "fcst": 0.0436319001666092,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-08 00:00:00"),
            "fcst": 0.0036462114725477335,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-09 00:00:00"),
            "fcst": 0.08007940466841124,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-10 00:00:00"),
            "fcst": 0.15334923005918044,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-11 00:00:00"),
            "fcst": 0.17188681314212778,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-12 00:00:00"),
            "fcst": 0.0391287607636743,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-13 00:00:00"),
            "fcst": 0.013229061653719343,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-14 00:00:00"),
            "fcst": -0.11943900495684034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-15 00:00:00"),
            "fcst": -0.251549296029257,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-16 00:00:00"),
            "fcst": -0.07707680814449921,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-17 00:00:00"),
            "fcst": 0.03050894015373598,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-18 00:00:00"),
            "fcst": 0.0027868934109876523,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-19 00:00:00"),
            "fcst": 0.030265271794574004,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-20 00:00:00"),
            "fcst": 0.005565862885094863,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-21 00:00:00"),
            "fcst": -0.15509033691841095,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-22 00:00:00"),
            "fcst": -0.29014076383492926,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-23 00:00:00"),
            "fcst": -0.014458080712184851,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-24 00:00:00"),
            "fcst": 0.07587250378642696,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-25 00:00:00"),
            "fcst": -0.21799719879296947,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-26 00:00:00"),
            "fcst": -0.03702319905105739,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-27 00:00:00"),
            "fcst": 0.07537751142657184,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-28 00:00:00"),
            "fcst": 0.10904266652649494,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-29 00:00:00"),
            "fcst": 0.1005320948493634,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-30 00:00:00"),
            "fcst": 0.09066200227821583,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-31 00:00:00"),
            "fcst": 0.08356274096954996,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-01 00:00:00"),
            "fcst": 0.21137564308564738,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-02 00:00:00"),
            "fcst": 0.06544169132038052,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-03 00:00:00"),
            "fcst": 0.12859701218060596,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-04 00:00:00"),
            "fcst": 0.07555411988986832,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-05 00:00:00"),
            "fcst": 0.1352649420476866,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-06 00:00:00"),
            "fcst": 0.16360959089774735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-07 00:00:00"),
            "fcst": 0.1504991416635415,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-08 00:00:00"),
            "fcst": 0.08522631678613442,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-09 00:00:00"),
            "fcst": 0.03271626929061449,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-10 00:00:00"),
            "fcst": 0.012032987561415326,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-11 00:00:00"),
            "fcst": 0.06226741257140378,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-12 00:00:00"),
            "fcst": -0.18634053078122764,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-13 00:00:00"),
            "fcst": 0.00991478058534373,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-14 00:00:00"),
            "fcst": 0.16666254287310428,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-15 00:00:00"),
            "fcst": 0.15082718804260112,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-16 00:00:00"),
            "fcst": 0.07854208836446688,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-17 00:00:00"),
            "fcst": 0.02887891023785722,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-18 00:00:00"),
            "fcst": 0.028061008419253963,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-19 00:00:00"),
            "fcst": -0.008738806323105697,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-20 00:00:00"),
            "fcst": -0.10980505360053733,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-21 00:00:00"),
            "fcst": 0.15770171409854744,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-22 00:00:00"),
            "fcst": 0.035181913531413034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-23 00:00:00"),
            "fcst": -0.038126964262058166,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-24 00:00:00"),
            "fcst": -0.05833577687965125,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-25 00:00:00"),
            "fcst": -0.18615676011966428,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-26 00:00:00"),
            "fcst": -0.15335795649936085,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-27 00:00:00"),
            "fcst": -0.22953567971841624,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-28 00:00:00"),
            "fcst": -0.11566596410555033,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-29 00:00:00"),
            "fcst": -0.017777493672709754,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-30 00:00:00"),
            "fcst": -0.25853291624371877,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-05-01 00:00:00"),
            "fcst": -0.11594591029261868,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-05-01 00:00:00"),
            "fcst": 7.940480857230361,
            "fcst_lower": 7.05954539696271,
            "fcst_upper": 8.821416317498013,
        },
        {
            "time": pd.Timestamp("2013-05-02 00:00:00"),
            "fcst": 7.890521247867683,
            "fcst_lower": 6.895622219348986,
            "fcst_upper": 8.88542027638638,
        },
        {
            "time": pd.Timestamp("2013-05-03 00:00:00"),
            "fcst": 7.868743227314358,
            "fcst_lower": 6.834214576608463,
            "fcst_upper": 8.903271878020252,
        },
        {
            "time": pd.Timestamp("2013-05-04 00:00:00"),
            "fcst": 7.859001067790166,
            "fcst_lower": 6.803917944580299,
            "fcst_upper": 8.914084191000033,
        },
        {
            "time": pd.Timestamp("2013-05-05 00:00:00"),
            "fcst": 7.854399212870253,
            "fcst_lower": 6.784960481789183,
            "fcst_upper": 8.923837943951323,
        },
        {
            "time": pd.Timestamp("2013-05-06 00:00:00"),
            "fcst": 7.851992691658566,
            "fcst_lower": 6.770545536610528,
            "fcst_upper": 8.933439846706605,
        },
        {
            "time": pd.Timestamp("2013-05-07 00:00:00"),
            "fcst": 7.850523758870425,
            "fcst_lower": 6.758058474764527,
            "fcst_upper": 8.942989042976322,
        },
        {
            "time": pd.Timestamp("2013-05-08 00:00:00"),
            "fcst": 7.849455253611216,
            "fcst_lower": 6.746435277314804,
            "fcst_upper": 8.952475229907629,
        },
        {
            "time": pd.Timestamp("2013-05-09 00:00:00"),
            "fcst": 7.848557763908408,
            "fcst_lower": 6.7352309284064615,
            "fcst_upper": 8.961884599410356,
        },
        {
            "time": pd.Timestamp("2013-05-10 00:00:00"),
            "fcst": 7.847733311942562,
            "fcst_lower": 6.7242563949242085,
            "fcst_upper": 8.971210228960917,
        },
        {
            "time": pd.Timestamp("2013-05-11 00:00:00"),
            "fcst": 7.846940053109861,
            "fcst_lower": 6.71343022358396,
            "fcst_upper": 8.980449882635762,
        },
        {
            "time": pd.Timestamp("2013-05-12 00:00:00"),
            "fcst": 7.84616011631582,
            "fcst_lower": 6.702716519862747,
            "fcst_upper": 8.989603712768893,
        },
        {
            "time": pd.Timestamp("2013-05-13 00:00:00"),
            "fcst": 7.845385869130233,
            "fcst_lower": 6.692098772048167,
            "fcst_upper": 8.998672966212299,
        },
        {
            "time": pd.Timestamp("2013-05-14 00:00:00"),
            "fcst": 7.844614051876368,
            "fcst_lower": 6.681568754691981,
            "fcst_upper": 9.007659349060756,
        },
        {
            "time": pd.Timestamp("2013-05-15 00:00:00"),
            "fcst": 7.843843272403614,
            "fcst_lower": 6.671121814034725,
            "fcst_upper": 9.016564730772503,
        },
    ]
)

PEYTON_FCST_30_ARIMA_PARAM_1_MODEL_1_INCL_HIST = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("2012-05-03 00:00:00"),
            "fcst": -0.0007700058570090651,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-04 00:00:00"),
            "fcst": 0.003945764176497557,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-05 00:00:00"),
            "fcst": 0.056389253940629255,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-06 00:00:00"),
            "fcst": 0.03581633435595588,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-07 00:00:00"),
            "fcst": -0.4128869117836815,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-08 00:00:00"),
            "fcst": -0.21494697202566299,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-09 00:00:00"),
            "fcst": 0.023753499987732296,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-10 00:00:00"),
            "fcst": 0.09355937802330405,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-11 00:00:00"),
            "fcst": 0.18319088827293034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-12 00:00:00"),
            "fcst": 0.20044808320056756,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-13 00:00:00"),
            "fcst": 0.2503354760854294,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-14 00:00:00"),
            "fcst": 0.17127042819947244,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-15 00:00:00"),
            "fcst": 0.14608737892963222,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-16 00:00:00"),
            "fcst": 0.1046934406435516,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-17 00:00:00"),
            "fcst": 0.022584545049575466,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-18 00:00:00"),
            "fcst": 0.05981881271357159,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-19 00:00:00"),
            "fcst": 0.14025155875910666,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-20 00:00:00"),
            "fcst": 0.2620310138400047,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-21 00:00:00"),
            "fcst": 0.20643571244428782,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-22 00:00:00"),
            "fcst": -0.03163734777951549,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-23 00:00:00"),
            "fcst": -0.17638166890869264,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-24 00:00:00"),
            "fcst": -0.026283311915276913,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-25 00:00:00"),
            "fcst": 0.08888312964866367,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-26 00:00:00"),
            "fcst": 0.09318350600838077,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-27 00:00:00"),
            "fcst": 0.21884338795240824,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-28 00:00:00"),
            "fcst": 0.11943606160735805,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-29 00:00:00"),
            "fcst": 0.09954952209841111,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-30 00:00:00"),
            "fcst": 0.0115899772154675,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-05-31 00:00:00"),
            "fcst": 0.012880997922767479,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-01 00:00:00"),
            "fcst": -0.0728620311757119,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-02 00:00:00"),
            "fcst": 0.01827210829676365,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-03 00:00:00"),
            "fcst": 0.08966940872011074,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-04 00:00:00"),
            "fcst": 0.06304407979604659,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-05 00:00:00"),
            "fcst": -0.013443609595630263,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-06 00:00:00"),
            "fcst": -0.05624628223233899,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-07 00:00:00"),
            "fcst": 0.0829341015327528,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-08 00:00:00"),
            "fcst": 0.03996293101592904,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-09 00:00:00"),
            "fcst": -0.03873226464407914,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-10 00:00:00"),
            "fcst": -0.06431422815004223,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-11 00:00:00"),
            "fcst": 0.028090033076010767,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-12 00:00:00"),
            "fcst": 0.08447685368419985,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-13 00:00:00"),
            "fcst": -0.02645959470756161,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-14 00:00:00"),
            "fcst": -0.04747711263299492,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-15 00:00:00"),
            "fcst": 0.03990163053922584,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-16 00:00:00"),
            "fcst": 0.04021077078495444,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-17 00:00:00"),
            "fcst": 0.11798186890164153,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-18 00:00:00"),
            "fcst": -0.07080972833656002,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-19 00:00:00"),
            "fcst": -0.011919670865285226,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-20 00:00:00"),
            "fcst": -0.2962532999717047,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-21 00:00:00"),
            "fcst": -0.16324802300440683,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-22 00:00:00"),
            "fcst": 0.0036335041454830658,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-23 00:00:00"),
            "fcst": -0.02623718629423044,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-24 00:00:00"),
            "fcst": 0.14562991055130833,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-25 00:00:00"),
            "fcst": 0.15360465873927256,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-26 00:00:00"),
            "fcst": 0.07657127134706403,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-27 00:00:00"),
            "fcst": 0.01072068277829874,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-28 00:00:00"),
            "fcst": 0.08562704277501096,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-29 00:00:00"),
            "fcst": 0.0853670485997517,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-06-30 00:00:00"),
            "fcst": 0.10168388082429597,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-01 00:00:00"),
            "fcst": 0.18331939970107475,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-02 00:00:00"),
            "fcst": 0.10888859514445062,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-03 00:00:00"),
            "fcst": 0.073361421870783,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-04 00:00:00"),
            "fcst": 0.00505975073752761,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-05 00:00:00"),
            "fcst": -0.011786813571759813,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-06 00:00:00"),
            "fcst": 0.04499906817304014,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-07 00:00:00"),
            "fcst": -0.02204728075254085,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-08 00:00:00"),
            "fcst": 0.01887920114434169,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-09 00:00:00"),
            "fcst": 0.02807098731061397,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-10 00:00:00"),
            "fcst": -0.05101427096084735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-11 00:00:00"),
            "fcst": -0.06567448275215854,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-12 00:00:00"),
            "fcst": -0.1661172146522294,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-13 00:00:00"),
            "fcst": -0.45662523636038066,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-14 00:00:00"),
            "fcst": -0.29484802919147635,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-15 00:00:00"),
            "fcst": -0.2576509951513812,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-16 00:00:00"),
            "fcst": -0.06331978173133601,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-17 00:00:00"),
            "fcst": -0.024190222244225165,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-18 00:00:00"),
            "fcst": -0.04005079178503399,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-19 00:00:00"),
            "fcst": -0.03513273312234734,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-20 00:00:00"),
            "fcst": -0.005376936062810568,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-21 00:00:00"),
            "fcst": -0.029961636549809822,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-22 00:00:00"),
            "fcst": 0.0695630775721521,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-23 00:00:00"),
            "fcst": 0.050399959617684564,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-24 00:00:00"),
            "fcst": -0.07115299609536034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-25 00:00:00"),
            "fcst": -0.02788826856667878,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-26 00:00:00"),
            "fcst": -0.09519448076762971,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-27 00:00:00"),
            "fcst": -0.29420534138598886,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-28 00:00:00"),
            "fcst": -0.4405363351823598,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-29 00:00:00"),
            "fcst": -0.09301263627108312,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-30 00:00:00"),
            "fcst": -0.08352088660138757,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-07-31 00:00:00"),
            "fcst": -0.018480056965353625,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-01 00:00:00"),
            "fcst": 0.10125417988561353,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-02 00:00:00"),
            "fcst": 0.11459132599568725,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-03 00:00:00"),
            "fcst": 0.004241493000187911,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-04 00:00:00"),
            "fcst": -0.00045454647922826136,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-05 00:00:00"),
            "fcst": -0.02016539216723052,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-06 00:00:00"),
            "fcst": -0.014948356274609428,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-07 00:00:00"),
            "fcst": -0.028782012411350644,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-08 00:00:00"),
            "fcst": 0.011485072885252356,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-09 00:00:00"),
            "fcst": 0.06683900574044777,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-10 00:00:00"),
            "fcst": -0.08106271288693767,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-11 00:00:00"),
            "fcst": -0.4375079242179869,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-12 00:00:00"),
            "fcst": -0.2312314576119786,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-13 00:00:00"),
            "fcst": -0.2747471288930195,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-14 00:00:00"),
            "fcst": -0.04576123818907407,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-15 00:00:00"),
            "fcst": -0.13192614949543646,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-16 00:00:00"),
            "fcst": -0.034070783752468276,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-17 00:00:00"),
            "fcst": 0.09132631973734068,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-18 00:00:00"),
            "fcst": -0.04358007918926741,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-19 00:00:00"),
            "fcst": -0.013374996227422553,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-20 00:00:00"),
            "fcst": -0.29410697261045793,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-21 00:00:00"),
            "fcst": -0.30386947286298016,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-22 00:00:00"),
            "fcst": 0.024655775764804988,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-23 00:00:00"),
            "fcst": 0.10488713556552678,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-24 00:00:00"),
            "fcst": 0.0075180732192244165,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-25 00:00:00"),
            "fcst": 0.0417710197874166,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-26 00:00:00"),
            "fcst": -0.16721226006178036,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-27 00:00:00"),
            "fcst": -0.48462348289444823,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-28 00:00:00"),
            "fcst": -0.2965404536031402,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-29 00:00:00"),
            "fcst": -0.003618946625966485,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-30 00:00:00"),
            "fcst": 0.05552916768599228,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-08-31 00:00:00"),
            "fcst": 0.0966709988230193,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-01 00:00:00"),
            "fcst": -0.008016920874532568,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-02 00:00:00"),
            "fcst": 0.03651778280738183,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-03 00:00:00"),
            "fcst": -0.20225460610116375,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-04 00:00:00"),
            "fcst": 0.010189685355543737,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-05 00:00:00"),
            "fcst": 0.051994776316516056,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-06 00:00:00"),
            "fcst": -0.08409966126151391,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-07 00:00:00"),
            "fcst": -0.6797432836365787,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-08 00:00:00"),
            "fcst": 0.014740299904501791,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-09 00:00:00"),
            "fcst": -0.029807795575780505,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-10 00:00:00"),
            "fcst": -0.5300712183424823,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-11 00:00:00"),
            "fcst": -1.3225227968332607,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-12 00:00:00"),
            "fcst": -0.24988179782478648,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-13 00:00:00"),
            "fcst": 0.1759503207731844,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-14 00:00:00"),
            "fcst": 0.20665564064411474,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-15 00:00:00"),
            "fcst": 0.03405961703029581,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-16 00:00:00"),
            "fcst": 0.15132655672394024,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-17 00:00:00"),
            "fcst": -0.3680485068109315,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-18 00:00:00"),
            "fcst": -0.24004930870575114,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-19 00:00:00"),
            "fcst": -0.682397194567312,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-20 00:00:00"),
            "fcst": 0.2565737245049693,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-21 00:00:00"),
            "fcst": 0.3236003122646166,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-22 00:00:00"),
            "fcst": -0.10975674384291934,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-23 00:00:00"),
            "fcst": 0.35054006608394706,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-24 00:00:00"),
            "fcst": -0.20280478364900545,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-25 00:00:00"),
            "fcst": -0.2102306146514188,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-26 00:00:00"),
            "fcst": 0.25117921481141614,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-27 00:00:00"),
            "fcst": 0.4667175156220593,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-28 00:00:00"),
            "fcst": 0.3871928767637057,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-29 00:00:00"),
            "fcst": 0.22082749877785862,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-09-30 00:00:00"),
            "fcst": 0.2878227855580986,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-01 00:00:00"),
            "fcst": -0.18531590545535792,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-02 00:00:00"),
            "fcst": -0.44818532387901944,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-03 00:00:00"),
            "fcst": 0.0781777868793121,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-04 00:00:00"),
            "fcst": 0.22944140782120054,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-05 00:00:00"),
            "fcst": 0.14181455189445258,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-06 00:00:00"),
            "fcst": -0.0664425042348854,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-07 00:00:00"),
            "fcst": 0.17349444734918595,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-08 00:00:00"),
            "fcst": -0.44641936322963316,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-09 00:00:00"),
            "fcst": -0.4431240616508445,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-10 00:00:00"),
            "fcst": 0.0681196313318011,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-11 00:00:00"),
            "fcst": 0.33864995796823016,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-12 00:00:00"),
            "fcst": 0.3504202436325591,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-13 00:00:00"),
            "fcst": 0.23727328493488054,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-14 00:00:00"),
            "fcst": 0.28969564906912915,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-15 00:00:00"),
            "fcst": -0.1163019776841474,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-16 00:00:00"),
            "fcst": -0.13790149069240654,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-17 00:00:00"),
            "fcst": -0.9459415448437483,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-18 00:00:00"),
            "fcst": 0.12174937772701971,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-19 00:00:00"),
            "fcst": 0.25131941566998117,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-20 00:00:00"),
            "fcst": 0.22188979337641102,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-21 00:00:00"),
            "fcst": 0.3132158810605632,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-22 00:00:00"),
            "fcst": -0.33213451276126243,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-23 00:00:00"),
            "fcst": -0.08805474932336255,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-24 00:00:00"),
            "fcst": 0.1233687238094402,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-25 00:00:00"),
            "fcst": 0.2629854858251821,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-26 00:00:00"),
            "fcst": 0.2408965878382258,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-27 00:00:00"),
            "fcst": 0.14370735299319456,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-28 00:00:00"),
            "fcst": 0.11091323243559104,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-29 00:00:00"),
            "fcst": -0.2265767071052478,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-30 00:00:00"),
            "fcst": -0.7866871314985183,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-10-31 00:00:00"),
            "fcst": 0.03450286342175132,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-01 00:00:00"),
            "fcst": 0.12339161984763047,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-02 00:00:00"),
            "fcst": 0.19814560542524334,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-03 00:00:00"),
            "fcst": 0.1449564761572295,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-04 00:00:00"),
            "fcst": 0.18248604615513786,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-05 00:00:00"),
            "fcst": -0.43422997299025146,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-06 00:00:00"),
            "fcst": -0.37740550612125046,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-07 00:00:00"),
            "fcst": 0.06620917162923201,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-08 00:00:00"),
            "fcst": 0.2693624286596078,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-09 00:00:00"),
            "fcst": 0.1901187903990711,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-10 00:00:00"),
            "fcst": 0.005358972227035297,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-11 00:00:00"),
            "fcst": 0.27344770582268496,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-12 00:00:00"),
            "fcst": -0.22125496788252316,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-13 00:00:00"),
            "fcst": -0.12727696612459283,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-14 00:00:00"),
            "fcst": 0.07711973860947507,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-15 00:00:00"),
            "fcst": 0.24731679113806196,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-16 00:00:00"),
            "fcst": 0.20617208842600365,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-17 00:00:00"),
            "fcst": 0.22819428651128137,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-18 00:00:00"),
            "fcst": 0.2754958161515757,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-19 00:00:00"),
            "fcst": -0.2506389344574349,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-20 00:00:00"),
            "fcst": -0.467200765441649,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-21 00:00:00"),
            "fcst": 0.06761280483955656,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-22 00:00:00"),
            "fcst": 0.23193076748874078,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-23 00:00:00"),
            "fcst": 0.03885382053483735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-24 00:00:00"),
            "fcst": -0.09721686118172701,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-25 00:00:00"),
            "fcst": 0.1654674229898253,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-26 00:00:00"),
            "fcst": -0.36032471147981027,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-27 00:00:00"),
            "fcst": -0.5261721545516235,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-28 00:00:00"),
            "fcst": 0.019254171195356884,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-29 00:00:00"),
            "fcst": 0.12854640295937486,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-11-30 00:00:00"),
            "fcst": 0.17861528108870836,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-01 00:00:00"),
            "fcst": 0.03359351112022693,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-02 00:00:00"),
            "fcst": 0.07522231284268344,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-03 00:00:00"),
            "fcst": -0.26262548926875096,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-04 00:00:00"),
            "fcst": -0.39350653024977844,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-05 00:00:00"),
            "fcst": -0.3393503050852452,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-06 00:00:00"),
            "fcst": 0.12766766047010267,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-07 00:00:00"),
            "fcst": 0.09097283050041605,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-08 00:00:00"),
            "fcst": -0.47981491425801237,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-09 00:00:00"),
            "fcst": 0.1476682708451985,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-10 00:00:00"),
            "fcst": -0.11184525776218601,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-11 00:00:00"),
            "fcst": -0.10782045188115491,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-12 00:00:00"),
            "fcst": -0.17424610786934036,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-13 00:00:00"),
            "fcst": 0.1437353570333326,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-14 00:00:00"),
            "fcst": 0.17200308558046096,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-15 00:00:00"),
            "fcst": 0.2799760031121332,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-16 00:00:00"),
            "fcst": 0.3226753147603072,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-17 00:00:00"),
            "fcst": -0.1950165891987167,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-18 00:00:00"),
            "fcst": -0.19286372659488737,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-19 00:00:00"),
            "fcst": 0.08994298163712011,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-20 00:00:00"),
            "fcst": 0.21018363219995329,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-21 00:00:00"),
            "fcst": 0.23958185908913499,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-22 00:00:00"),
            "fcst": 0.2709043381717522,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-23 00:00:00"),
            "fcst": 0.28399778442766843,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-24 00:00:00"),
            "fcst": -0.2402588508791048,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-25 00:00:00"),
            "fcst": -0.40523140964447657,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-26 00:00:00"),
            "fcst": 0.1161293098831932,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-27 00:00:00"),
            "fcst": 0.11844489779334463,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-28 00:00:00"),
            "fcst": -0.06347527468712175,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-29 00:00:00"),
            "fcst": 0.07609637479815401,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-30 00:00:00"),
            "fcst": 0.13998722124293128,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2012-12-31 00:00:00"),
            "fcst": -0.3290923983842169,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-01 00:00:00"),
            "fcst": -0.6074844406325873,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-02 00:00:00"),
            "fcst": -0.05854282021062879,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-03 00:00:00"),
            "fcst": -0.04061160273152583,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-04 00:00:00"),
            "fcst": -0.02286822726492621,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-05 00:00:00"),
            "fcst": -0.15467537094339134,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-06 00:00:00"),
            "fcst": -0.09406618749216267,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-07 00:00:00"),
            "fcst": -0.509677685073989,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-08 00:00:00"),
            "fcst": -0.15547647971956585,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-09 00:00:00"),
            "fcst": 0.0393350353994628,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-10 00:00:00"),
            "fcst": 0.058191429964034175,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-11 00:00:00"),
            "fcst": 0.09511320041848087,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-12 00:00:00"),
            "fcst": 0.003404702175357599,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-13 00:00:00"),
            "fcst": -0.6608575737008224,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-14 00:00:00"),
            "fcst": -1.0555192997492326,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-15 00:00:00"),
            "fcst": -0.32825023448483215,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-16 00:00:00"),
            "fcst": 0.13731089262913287,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-17 00:00:00"),
            "fcst": 0.32947271900323194,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-18 00:00:00"),
            "fcst": 0.35085617234508537,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-19 00:00:00"),
            "fcst": 0.3529775402961782,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-20 00:00:00"),
            "fcst": 0.4133286576452372,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-21 00:00:00"),
            "fcst": 0.13052828733826394,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-22 00:00:00"),
            "fcst": -0.3851065551528735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-23 00:00:00"),
            "fcst": 0.134589889481306,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-24 00:00:00"),
            "fcst": 0.18975632847301777,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-25 00:00:00"),
            "fcst": 0.301761047823618,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-26 00:00:00"),
            "fcst": 0.2951062264258376,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-27 00:00:00"),
            "fcst": 0.30273529239367936,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-28 00:00:00"),
            "fcst": 0.23661359254271508,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-29 00:00:00"),
            "fcst": -0.5328392882589585,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-30 00:00:00"),
            "fcst": 0.20946587624123636,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-01-31 00:00:00"),
            "fcst": 0.2543507321873164,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-01 00:00:00"),
            "fcst": 0.24172115295065605,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-02 00:00:00"),
            "fcst": 0.17373595459259406,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-03 00:00:00"),
            "fcst": 0.16964055640592213,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-04 00:00:00"),
            "fcst": -0.349320251163763,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-05 00:00:00"),
            "fcst": -0.5151548388618591,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-06 00:00:00"),
            "fcst": 0.08401844276598974,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-07 00:00:00"),
            "fcst": 0.2380093343070403,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-08 00:00:00"),
            "fcst": 0.2829582983631439,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-09 00:00:00"),
            "fcst": 0.34161290777682074,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-10 00:00:00"),
            "fcst": 0.35908221203549073,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-11 00:00:00"),
            "fcst": 0.3491998010157814,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-12 00:00:00"),
            "fcst": 0.29201236429210975,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-13 00:00:00"),
            "fcst": 0.28670145112115764,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-14 00:00:00"),
            "fcst": 0.28738145316032904,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-15 00:00:00"),
            "fcst": 0.32182404357492855,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-16 00:00:00"),
            "fcst": 0.2657331928021771,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-17 00:00:00"),
            "fcst": 0.27539758570602557,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-18 00:00:00"),
            "fcst": 0.24555094742973435,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-19 00:00:00"),
            "fcst": 0.15247451699757622,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-20 00:00:00"),
            "fcst": 0.11839543778088207,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-21 00:00:00"),
            "fcst": 0.1516970968169062,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-22 00:00:00"),
            "fcst": 0.16477343580307838,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-23 00:00:00"),
            "fcst": 0.13852347060075532,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-24 00:00:00"),
            "fcst": 0.18082063339946575,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-25 00:00:00"),
            "fcst": 0.19628456887496087,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-26 00:00:00"),
            "fcst": 0.10019887553438628,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-27 00:00:00"),
            "fcst": -0.07520717053836065,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-02-28 00:00:00"),
            "fcst": 0.03298355039674053,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-01 00:00:00"),
            "fcst": 0.055433128301513895,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-02 00:00:00"),
            "fcst": 0.07429767219394756,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-03 00:00:00"),
            "fcst": 0.12722529339106078,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-04 00:00:00"),
            "fcst": 0.09775001275984066,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-05 00:00:00"),
            "fcst": 0.06088058445207728,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-06 00:00:00"),
            "fcst": 0.05298595317047888,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-07 00:00:00"),
            "fcst": 0.0436319001666092,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-08 00:00:00"),
            "fcst": 0.0036462114725477335,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-09 00:00:00"),
            "fcst": 0.08007940466841124,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-10 00:00:00"),
            "fcst": 0.15334923005918044,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-11 00:00:00"),
            "fcst": 0.17188681314212778,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-12 00:00:00"),
            "fcst": 0.0391287607636743,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-13 00:00:00"),
            "fcst": 0.013229061653719343,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-14 00:00:00"),
            "fcst": -0.11943900495684034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-15 00:00:00"),
            "fcst": -0.251549296029257,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-16 00:00:00"),
            "fcst": -0.07707680814449921,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-17 00:00:00"),
            "fcst": 0.03050894015373598,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-18 00:00:00"),
            "fcst": 0.0027868934109876523,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-19 00:00:00"),
            "fcst": 0.030265271794574004,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-20 00:00:00"),
            "fcst": 0.005565862885094863,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-21 00:00:00"),
            "fcst": -0.15509033691841095,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-22 00:00:00"),
            "fcst": -0.29014076383492926,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-23 00:00:00"),
            "fcst": -0.014458080712184851,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-24 00:00:00"),
            "fcst": 0.07587250378642696,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-25 00:00:00"),
            "fcst": -0.21799719879296947,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-26 00:00:00"),
            "fcst": -0.03702319905105739,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-27 00:00:00"),
            "fcst": 0.07537751142657184,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-28 00:00:00"),
            "fcst": 0.10904266652649494,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-29 00:00:00"),
            "fcst": 0.1005320948493634,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-30 00:00:00"),
            "fcst": 0.09066200227821583,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-03-31 00:00:00"),
            "fcst": 0.08356274096954996,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-01 00:00:00"),
            "fcst": 0.21137564308564738,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-02 00:00:00"),
            "fcst": 0.06544169132038052,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-03 00:00:00"),
            "fcst": 0.12859701218060596,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-04 00:00:00"),
            "fcst": 0.07555411988986832,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-05 00:00:00"),
            "fcst": 0.1352649420476866,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-06 00:00:00"),
            "fcst": 0.16360959089774735,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-07 00:00:00"),
            "fcst": 0.1504991416635415,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-08 00:00:00"),
            "fcst": 0.08522631678613442,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-09 00:00:00"),
            "fcst": 0.03271626929061449,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-10 00:00:00"),
            "fcst": 0.012032987561415326,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-11 00:00:00"),
            "fcst": 0.06226741257140378,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-12 00:00:00"),
            "fcst": -0.18634053078122764,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-13 00:00:00"),
            "fcst": 0.00991478058534373,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-14 00:00:00"),
            "fcst": 0.16666254287310428,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-15 00:00:00"),
            "fcst": 0.15082718804260112,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-16 00:00:00"),
            "fcst": 0.07854208836446688,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-17 00:00:00"),
            "fcst": 0.02887891023785722,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-18 00:00:00"),
            "fcst": 0.028061008419253963,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-19 00:00:00"),
            "fcst": -0.008738806323105697,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-20 00:00:00"),
            "fcst": -0.10980505360053733,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-21 00:00:00"),
            "fcst": 0.15770171409854744,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-22 00:00:00"),
            "fcst": 0.035181913531413034,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-23 00:00:00"),
            "fcst": -0.038126964262058166,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-24 00:00:00"),
            "fcst": -0.05833577687965125,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-25 00:00:00"),
            "fcst": -0.18615676011966428,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-26 00:00:00"),
            "fcst": -0.15335795649936085,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-27 00:00:00"),
            "fcst": -0.22953567971841624,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-28 00:00:00"),
            "fcst": -0.11566596410555033,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-29 00:00:00"),
            "fcst": -0.017777493672709754,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-04-30 00:00:00"),
            "fcst": -0.25853291624371877,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-05-01 00:00:00"),
            "fcst": -0.11594591029261868,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("2013-05-01 00:00:00"),
            "fcst": 7.940480857230361,
            "fcst_lower": 7.05954539696271,
            "fcst_upper": 8.821416317498013,
        },
        {
            "time": pd.Timestamp("2013-05-02 00:00:00"),
            "fcst": 7.890521247867683,
            "fcst_lower": 6.895622219348986,
            "fcst_upper": 8.88542027638638,
        },
        {
            "time": pd.Timestamp("2013-05-03 00:00:00"),
            "fcst": 7.868743227314358,
            "fcst_lower": 6.834214576608463,
            "fcst_upper": 8.903271878020252,
        },
        {
            "time": pd.Timestamp("2013-05-04 00:00:00"),
            "fcst": 7.859001067790166,
            "fcst_lower": 6.803917944580299,
            "fcst_upper": 8.914084191000033,
        },
        {
            "time": pd.Timestamp("2013-05-05 00:00:00"),
            "fcst": 7.854399212870253,
            "fcst_lower": 6.784960481789183,
            "fcst_upper": 8.923837943951323,
        },
        {
            "time": pd.Timestamp("2013-05-06 00:00:00"),
            "fcst": 7.851992691658566,
            "fcst_lower": 6.770545536610528,
            "fcst_upper": 8.933439846706605,
        },
        {
            "time": pd.Timestamp("2013-05-07 00:00:00"),
            "fcst": 7.850523758870425,
            "fcst_lower": 6.758058474764527,
            "fcst_upper": 8.942989042976322,
        },
        {
            "time": pd.Timestamp("2013-05-08 00:00:00"),
            "fcst": 7.849455253611216,
            "fcst_lower": 6.746435277314804,
            "fcst_upper": 8.952475229907629,
        },
        {
            "time": pd.Timestamp("2013-05-09 00:00:00"),
            "fcst": 7.848557763908408,
            "fcst_lower": 6.7352309284064615,
            "fcst_upper": 8.961884599410356,
        },
        {
            "time": pd.Timestamp("2013-05-10 00:00:00"),
            "fcst": 7.847733311942562,
            "fcst_lower": 6.7242563949242085,
            "fcst_upper": 8.971210228960917,
        },
        {
            "time": pd.Timestamp("2013-05-11 00:00:00"),
            "fcst": 7.846940053109861,
            "fcst_lower": 6.71343022358396,
            "fcst_upper": 8.980449882635762,
        },
        {
            "time": pd.Timestamp("2013-05-12 00:00:00"),
            "fcst": 7.84616011631582,
            "fcst_lower": 6.702716519862747,
            "fcst_upper": 8.989603712768893,
        },
        {
            "time": pd.Timestamp("2013-05-13 00:00:00"),
            "fcst": 7.845385869130233,
            "fcst_lower": 6.692098772048167,
            "fcst_upper": 8.998672966212299,
        },
        {
            "time": pd.Timestamp("2013-05-14 00:00:00"),
            "fcst": 7.844614051876368,
            "fcst_lower": 6.681568754691981,
            "fcst_upper": 9.007659349060756,
        },
        {
            "time": pd.Timestamp("2013-05-15 00:00:00"),
            "fcst": 7.843843272403614,
            "fcst_lower": 6.671121814034725,
            "fcst_upper": 9.016564730772503,
        },
        {
            "time": pd.Timestamp("2013-05-16 00:00:00"),
            "fcst": 7.843072936148924,
            "fcst_lower": 6.660754861687368,
            "fcst_upper": 9.02539101061048,
        },
        {
            "time": pd.Timestamp("2013-05-17 00:00:00"),
            "fcst": 7.842302789184875,
            "fcst_lower": 6.65046551906174,
            "fcst_upper": 9.03414005930801,
        },
        {
            "time": pd.Timestamp("2013-05-18 00:00:00"),
            "fcst": 7.841532723063531,
            "fcst_lower": 6.6402517511320145,
            "fcst_upper": 9.042813694995047,
        },
        {
            "time": pd.Timestamp("2013-05-19 00:00:00"),
            "fcst": 7.840762691468684,
            "fcst_lower": 6.630111708424872,
            "fcst_upper": 9.051413674512496,
        },
        {
            "time": pd.Timestamp("2013-05-20 00:00:00"),
            "fcst": 7.839992674619497,
            "fcst_lower": 6.620043657716803,
            "fcst_upper": 9.05994169152219,
        },
        {
            "time": pd.Timestamp("2013-05-21 00:00:00"),
            "fcst": 7.839222664067922,
            "fcst_lower": 6.610045950601637,
            "fcst_upper": 9.068399377534208,
        },
        {
            "time": pd.Timestamp("2013-05-22 00:00:00"),
            "fcst": 7.838452656205947,
            "fcst_lower": 6.600117008296207,
            "fcst_upper": 9.076788304115686,
        },
        {
            "time": pd.Timestamp("2013-05-23 00:00:00"),
            "fcst": 7.837682649492652,
            "fcst_lower": 6.590255313472834,
            "fcst_upper": 9.085109985512469,
        },
        {
            "time": pd.Timestamp("2013-05-24 00:00:00"),
            "fcst": 7.836912643269938,
            "fcst_lower": 6.580459405190895,
            "fcst_upper": 9.09336588134898,
        },
        {
            "time": pd.Timestamp("2013-05-25 00:00:00"),
            "fcst": 7.836142637256742,
            "fcst_lower": 6.570727875248046,
            "fcst_upper": 9.101557399265438,
        },
        {
            "time": pd.Timestamp("2013-05-26 00:00:00"),
            "fcst": 7.835372631333029,
            "fcst_lower": 6.561059365228859,
            "fcst_upper": 9.109685897437199,
        },
        {
            "time": pd.Timestamp("2013-05-27 00:00:00"),
            "fcst": 7.834602625447531,
            "fcst_lower": 6.5514525639365075,
            "fcst_upper": 9.117752686958555,
        },
        {
            "time": pd.Timestamp("2013-05-28 00:00:00"),
            "fcst": 7.833832619578356,
            "fcst_lower": 6.541906205067343,
            "fcst_upper": 9.125759034089368,
        },
        {
            "time": pd.Timestamp("2013-05-29 00:00:00"),
            "fcst": 7.833062613716151,
            "fcst_lower": 6.532419065062822,
            "fcst_upper": 9.13370616236948,
        },
        {
            "time": pd.Timestamp("2013-05-30 00:00:00"),
            "fcst": 7.832292607856923,
            "fcst_lower": 6.522989961105574,
            "fcst_upper": 9.141595254608273,
        },
    ]
)

AIR_FCST_15_SARIMA_PARAM_1_MODEL_1 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 475.734999664335,
            "fcst_lower": 414.94683614194525,
            "fcst_upper": 536.5231631867248,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 454.9960131326432,
            "fcst_lower": 350.9406985933037,
            "fcst_upper": 559.0513276719827,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 464.83036926989587,
            "fcst_lower": 337.5891858591327,
            "fcst_upper": 592.071552680659,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 460.16695138848075,
            "fcst_lower": 310.6316031682349,
            "fcst_upper": 609.7022996087267,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 462.3783281205398,
            "fcst_lower": 294.62476708969064,
            "fcst_upper": 630.1318891513889,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 461.3297008742918,
            "fcst_lower": 276.654109966928,
            "fcst_upper": 646.0052917816556,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 461.82695631052394,
            "fcst_lower": 261.87302294007793,
            "fcst_upper": 661.78088968097,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 461.591159491638,
            "fcst_lower": 247.3497039224739,
            "fcst_upper": 675.832615060802,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 461.7029735327635,
            "fcst_lower": 234.11208345911712,
            "fcst_upper": 689.2938636064099,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 461.64995169874607,
            "fcst_lower": 221.43104743037904,
            "fcst_upper": 701.8688559671131,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 461.67509447021087,
            "fcst_lower": 209.4683909799995,
            "fcst_upper": 713.8817979604222,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 461.66317185439334,
            "fcst_lower": 198.00921052859343,
            "fcst_upper": 725.3171331801932,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 461.6688255178382,
            "fcst_lower": 187.04615729497976,
            "fcst_upper": 736.2914937406965,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 461.66614457006324,
            "fcst_lower": 176.49553139848467,
            "fcst_upper": 746.8367577416418,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 461.6674158662842,
            "fcst_lower": 166.32570802200962,
            "fcst_upper": 757.0091237105588,
        },
    ]
)

AIR_FCST_30_SARIMA_PARAM_1_MODEL_1 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 475.734999664335,
            "fcst_lower": 414.94683614194525,
            "fcst_upper": 536.5231631867248,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 454.9960131326432,
            "fcst_lower": 350.9406985933037,
            "fcst_upper": 559.0513276719827,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 464.83036926989587,
            "fcst_lower": 337.5891858591327,
            "fcst_upper": 592.071552680659,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 460.16695138848075,
            "fcst_lower": 310.6316031682349,
            "fcst_upper": 609.7022996087267,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 462.3783281205398,
            "fcst_lower": 294.62476708969064,
            "fcst_upper": 630.1318891513889,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 461.3297008742918,
            "fcst_lower": 276.654109966928,
            "fcst_upper": 646.0052917816556,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 461.82695631052394,
            "fcst_lower": 261.87302294007793,
            "fcst_upper": 661.78088968097,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 461.591159491638,
            "fcst_lower": 247.3497039224739,
            "fcst_upper": 675.832615060802,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 461.7029735327635,
            "fcst_lower": 234.11208345911712,
            "fcst_upper": 689.2938636064099,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 461.64995169874607,
            "fcst_lower": 221.43104743037904,
            "fcst_upper": 701.8688559671131,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 461.67509447021087,
            "fcst_lower": 209.4683909799995,
            "fcst_upper": 713.8817979604222,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 461.66317185439334,
            "fcst_lower": 198.00921052859343,
            "fcst_upper": 725.3171331801932,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 461.6688255178382,
            "fcst_lower": 187.04615729497976,
            "fcst_upper": 736.2914937406965,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 461.66614457006324,
            "fcst_lower": 176.49553139848467,
            "fcst_upper": 746.8367577416418,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 461.6674158662842,
            "fcst_lower": 166.32570802200962,
            "fcst_upper": 757.0091237105588,
        },
        {
            "time": pd.Timestamp("1962-04-01 00:00:00"),
            "fcst": 461.66681302198543,
            "fcst_lower": 156.49263999202753,
            "fcst_upper": 766.8409860519433,
        },
        {
            "time": pd.Timestamp("1962-05-01 00:00:00"),
            "fcst": 461.66709888868,
            "fcst_lower": 146.96759579695265,
            "fcst_upper": 776.3666019804074,
        },
        {
            "time": pd.Timestamp("1962-06-01 00:00:00"),
            "fcst": 461.6669633316759,
            "fcst_lower": 137.72205693628518,
            "fcst_upper": 785.6118697270666,
        },
        {
            "time": pd.Timestamp("1962-07-01 00:00:00"),
            "fcst": 461.66702761234137,
            "fcst_lower": 128.7333762035309,
            "fcst_upper": 794.6006790211518,
        },
        {
            "time": pd.Timestamp("1962-08-01 00:00:00"),
            "fcst": 461.6669971306707,
            "fcst_lower": 119.98097832591253,
            "fcst_upper": 803.3530159354289,
        },
        {
            "time": pd.Timestamp("1962-09-01 00:00:00"),
            "fcst": 461.6670115849742,
            "fcst_lower": 111.44729181160483,
            "fcst_upper": 811.8867313583436,
        },
        {
            "time": pd.Timestamp("1962-10-01 00:00:00"),
            "fcst": 461.66700473079317,
            "fcst_lower": 103.11663171244152,
            "fcst_upper": 820.2173777491448,
        },
        {
            "time": pd.Timestamp("1962-11-01 00:00:00"),
            "fcst": 461.66700798102227,
            "fcst_lower": 94.9751928349915,
            "fcst_upper": 828.358823127053,
        },
        {
            "time": pd.Timestamp("1962-12-01 00:00:00"),
            "fcst": 461.6670064397748,
            "fcst_lower": 87.01062404537282,
            "fcst_upper": 836.3233888341767,
        },
        {
            "time": pd.Timestamp("1963-01-01 00:00:00"),
            "fcst": 461.66700717062906,
            "fcst_lower": 79.21188259460115,
            "fcst_upper": 844.122131746657,
        },
        {
            "time": pd.Timestamp("1963-02-01 00:00:00"),
            "fcst": 461.6670068240605,
            "fcst_lower": 71.56901936341609,
            "fcst_upper": 851.7649942847049,
        },
        {
            "time": pd.Timestamp("1963-03-01 00:00:00"),
            "fcst": 461.6670069884021,
            "fcst_lower": 64.07304664895531,
            "fcst_upper": 859.2609673278489,
        },
        {
            "time": pd.Timestamp("1963-04-01 00:00:00"),
            "fcst": 461.66700691047186,
            "fcst_lower": 56.715806406470165,
            "fcst_upper": 866.6182074144735,
        },
        {
            "time": pd.Timestamp("1963-05-01 00:00:00"),
            "fcst": 461.6670069474261,
            "fcst_lower": 49.48986993667626,
            "fcst_upper": 873.8441439581759,
        },
        {
            "time": pd.Timestamp("1963-06-01 00:00:00"),
            "fcst": 461.6670069299025,
            "fcst_lower": 42.388448257749985,
            "fcst_upper": 880.945565602055,
        },
    ]
)

AIR_FCST_15_SARIMA_PARAM_2_MODEL_1 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 449.45646723526534,
            "fcst_lower": 428.8051912510871,
            "fcst_upper": 470.1077432194436,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 419.4161652450919,
            "fcst_lower": 395.57372723856895,
            "fcst_upper": 443.2586032516149,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 467.96439603968764,
            "fcst_lower": 440.41536929301304,
            "fcst_upper": 495.51342278636224,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 489.5373489111334,
            "fcst_lower": 458.2564055096148,
            "fcst_upper": 520.8182923126519,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 505.5361446094845,
            "fcst_lower": 471.5949596047826,
            "fcst_upper": 539.4773296141864,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 578.1914387473729,
            "fcst_lower": 541.2893697134359,
            "fcst_upper": 615.0935077813099,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 670.4043449527954,
            "fcst_lower": 631.0355334792789,
            "fcst_upper": 709.773156426312,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 663.0898849729405,
            "fcst_lower": 621.2895232734636,
            "fcst_upper": 704.8902466724173,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 547.4938044426624,
            "fcst_lower": 503.4205663546901,
            "fcst_upper": 591.5670425306347,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 486.3639955812308,
            "fcst_lower": 440.13923220066494,
            "fcst_upper": 532.5887589617968,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 412.8461658627194,
            "fcst_lower": 364.54878660265763,
            "fcst_upper": 461.1435451227811,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 459.8220185004234,
            "fcst_lower": 409.550641470057,
            "fcst_upper": 510.0933955307898,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 477.5535520899389,
            "fcst_lower": 419.98487039591237,
            "fcst_upper": 535.1222337839654,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 443.810928145418,
            "fcst_lower": 382.15096882917675,
            "fcst_upper": 505.4708874616593,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 496.9279986362585,
            "fcst_lower": 430.9861627523478,
            "fcst_upper": 562.8698345201692,
        },
    ]
)

AIR_FCST_30_SARIMA_PARAM_2_MODEL_1 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 449.45646723526534,
            "fcst_lower": 428.8051912510871,
            "fcst_upper": 470.1077432194436,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 419.4161652450919,
            "fcst_lower": 395.57372723856895,
            "fcst_upper": 443.2586032516149,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 467.96439603968764,
            "fcst_lower": 440.41536929301304,
            "fcst_upper": 495.51342278636224,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 489.5373489111334,
            "fcst_lower": 458.2564055096148,
            "fcst_upper": 520.8182923126519,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 505.5361446094845,
            "fcst_lower": 471.5949596047826,
            "fcst_upper": 539.4773296141864,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 578.1914387473729,
            "fcst_lower": 541.2893697134359,
            "fcst_upper": 615.0935077813099,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 670.4043449527954,
            "fcst_lower": 631.0355334792789,
            "fcst_upper": 709.773156426312,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 663.0898849729405,
            "fcst_lower": 621.2895232734636,
            "fcst_upper": 704.8902466724173,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 547.4938044426624,
            "fcst_lower": 503.4205663546901,
            "fcst_upper": 591.5670425306347,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 486.3639955812308,
            "fcst_lower": 440.13923220066494,
            "fcst_upper": 532.5887589617968,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 412.8461658627194,
            "fcst_lower": 364.54878660265763,
            "fcst_upper": 461.1435451227811,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 459.8220185004234,
            "fcst_lower": 409.550641470057,
            "fcst_upper": 510.0933955307898,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 477.5535520899389,
            "fcst_lower": 419.98487039591237,
            "fcst_upper": 535.1222337839654,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 443.810928145418,
            "fcst_lower": 382.15096882917675,
            "fcst_upper": 505.4708874616593,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 496.9279986362585,
            "fcst_lower": 430.9861627523478,
            "fcst_upper": 562.8698345201692,
        },
        {
            "time": pd.Timestamp("1962-04-01 00:00:00"),
            "fcst": 520.403839900848,
            "fcst_lower": 450.2070928538659,
            "fcst_upper": 590.60058694783,
        },
        {
            "time": pd.Timestamp("1962-05-01 00:00:00"),
            "fcst": 537.4342519864693,
            "fcst_lower": 463.58280669416007,
            "fcst_upper": 611.2856972787787,
        },
        {
            "time": pd.Timestamp("1962-06-01 00:00:00"),
            "fcst": 617.914355864871,
            "fcst_lower": 540.3104378414018,
            "fcst_upper": 695.5182738883402,
        },
        {
            "time": pd.Timestamp("1962-07-01 00:00:00"),
            "fcst": 720.3515864522939,
            "fcst_lower": 639.3206536889036,
            "fcst_upper": 801.3825192156842,
        },
        {
            "time": pd.Timestamp("1962-08-01 00:00:00"),
            "fcst": 711.254748925014,
            "fcst_lower": 626.872931320103,
            "fcst_upper": 795.6365665299251,
        },
        {
            "time": pd.Timestamp("1962-09-01 00:00:00"),
            "fcst": 580.924029262118,
            "fcst_lower": 493.33371987320817,
            "fcst_upper": 668.5143386510279,
        },
        {
            "time": pd.Timestamp("1962-10-01 00:00:00"),
            "fcst": 511.563934970003,
            "fcst_lower": 420.88428949185214,
            "fcst_upper": 602.2435804481538,
        },
        {
            "time": pd.Timestamp("1962-11-01 00:00:00"),
            "fcst": 428.33070727185594,
            "fcst_lower": 334.65357514032905,
            "fcst_upper": 522.0078394033828,
        },
        {
            "time": pd.Timestamp("1962-12-01 00:00:00"),
            "fcst": 480.03619512275634,
            "fcst_lower": 383.46248741000784,
            "fcst_upper": 576.6099028355048,
        },
        {
            "time": pd.Timestamp("1963-01-01 00:00:00"),
            "fcst": 498.98075596714943,
            "fcst_lower": 394.73275010117237,
            "fcst_upper": 603.2287618331264,
        },
        {
            "time": pd.Timestamp("1963-02-01 00:00:00"),
            "fcst": 460.27256842992364,
            "fcst_lower": 351.05176802520236,
            "fcst_upper": 569.4933688346449,
        },
        {
            "time": pd.Timestamp("1963-03-01 00:00:00"),
            "fcst": 518.833847610495,
            "fcst_lower": 404.43654763263567,
            "fcst_upper": 633.2311475883544,
        },
        {
            "time": pd.Timestamp("1963-04-01 00:00:00"),
            "fcst": 544.1925791044939,
            "fcst_lower": 424.6196188978465,
            "fcst_upper": 663.7655393111413,
        },
        {
            "time": pd.Timestamp("1963-05-01 00:00:00"),
            "fcst": 562.3256287957417,
            "fcst_lower": 438.1373152385748,
            "fcst_upper": 686.5139423529087,
        },
        {
            "time": pd.Timestamp("1963-06-01 00:00:00"),
            "fcst": 651.5118577810393,
            "fcst_lower": 522.6088426209153,
            "fcst_upper": 780.4148729411634,
        },
    ]
)

AIR_FCST_15_SARIMA_PARAM_1_MODEL_2 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 792.0535887542746,
            "fcst_lower": -3338.966274757853,
            "fcst_upper": 4923.0734522664025,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 1152.0732316134322,
            "fcst_lower": -11883.898354356968,
            "fcst_upper": 14188.044817583834,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 1512.0589317778959,
            "fcst_lower": -22863.1074551212,
            "fcst_upper": 25887.225318676996,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 1872.0106924477868,
            "fcst_lower": -35879.791633738336,
            "fcst_upper": 39623.81301863391,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 2231.9285168229244,
            "fcst_lower": -50669.34240608488,
            "fcst_upper": 55133.19943973073,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 2591.812408102827,
            "fcst_lower": -67047.30346095053,
            "fcst_upper": 72230.92827715617,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 2951.6623694867103,
            "fcst_lower": -84876.3873239775,
            "fcst_upper": 90779.71206295093,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 3311.4784041734893,
            "fcst_lower": -104049.44315289322,
            "fcst_upper": 110672.39996124021,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 3671.260515361777,
            "fcst_lower": -124479.88114782744,
            "fcst_upper": 131822.402178551,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 4031.0087062498847,
            "fcst_lower": -146095.857910656,
            "fcst_upper": 154157.87532315575,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 4390.722980035823,
            "fcst_lower": -168836.52367518313,
            "fcst_upper": 177617.96963525476,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 4750.4033399172995,
            "fcst_lower": -192649.4805148904,
            "fcst_upper": 202150.287194725,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 5110.049789091721,
            "fcst_lower": -217488.99250936016,
            "fcst_upper": 227709.0920875436,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 5469.662330756194,
            "fcst_lower": -243314.6845571667,
            "fcst_upper": 254254.0092186791,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 5829.240968107521,
            "fcst_lower": -270090.57091421064,
            "fcst_upper": 281749.0528504257,
        },
    ]
)

AIR_FCST_30_SARIMA_PARAM_1_MODEL_2 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 792.0535887542746,
            "fcst_lower": -3338.966274757853,
            "fcst_upper": 4923.0734522664025,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 1152.0732316134322,
            "fcst_lower": -11883.898354356968,
            "fcst_upper": 14188.044817583834,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 1512.0589317778959,
            "fcst_lower": -22863.1074551212,
            "fcst_upper": 25887.225318676996,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 1872.0106924477868,
            "fcst_lower": -35879.791633738336,
            "fcst_upper": 39623.81301863391,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 2231.9285168229244,
            "fcst_lower": -50669.34240608488,
            "fcst_upper": 55133.19943973073,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 2591.812408102827,
            "fcst_lower": -67047.30346095053,
            "fcst_upper": 72230.92827715617,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 2951.6623694867103,
            "fcst_lower": -84876.3873239775,
            "fcst_upper": 90779.71206295093,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 3311.4784041734893,
            "fcst_lower": -104049.44315289322,
            "fcst_upper": 110672.39996124021,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 3671.260515361777,
            "fcst_lower": -124479.88114782744,
            "fcst_upper": 131822.402178551,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 4031.0087062498847,
            "fcst_lower": -146095.857910656,
            "fcst_upper": 154157.87532315575,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 4390.722980035823,
            "fcst_lower": -168836.52367518313,
            "fcst_upper": 177617.96963525476,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 4750.4033399172995,
            "fcst_lower": -192649.4805148904,
            "fcst_upper": 202150.287194725,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 5110.049789091721,
            "fcst_lower": -217488.99250936016,
            "fcst_upper": 227709.0920875436,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 5469.662330756194,
            "fcst_lower": -243314.6845571667,
            "fcst_upper": 254254.0092186791,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 5829.240968107521,
            "fcst_lower": -270090.57091421064,
            "fcst_upper": 281749.0528504257,
        },
        {
            "time": pd.Timestamp("1962-04-01 00:00:00"),
            "fcst": 6188.785704342207,
            "fcst_lower": -297784.3133783731,
            "fcst_upper": 310161.88478705747,
        },
        {
            "time": pd.Timestamp("1962-05-01 00:00:00"),
            "fcst": 6548.2965426564515,
            "fcst_lower": -326366.6437887754,
            "fcst_upper": 339463.23687408824,
        },
        {
            "time": pd.Timestamp("1962-06-01 00:00:00"),
            "fcst": 6907.773486246155,
            "fcst_lower": -355810.906857057,
            "fcst_upper": 369626.45382954937,
        },
        {
            "time": pd.Timestamp("1962-07-01 00:00:00"),
            "fcst": 7267.216538306916,
            "fcst_lower": -386092.6929207302,
            "fcst_upper": 400627.12599734403,
        },
        {
            "time": pd.Timestamp("1962-08-01 00:00:00"),
            "fcst": 7626.625702034032,
            "fcst_lower": -417189.53909736965,
            "fcst_upper": 432442.79050143773,
        },
        {
            "time": pd.Timestamp("1962-09-01 00:00:00"),
            "fcst": 7986.000980622499,
            "fcst_lower": -449080.6832931032,
            "fcst_upper": 465052.68525434815,
        },
        {
            "time": pd.Timestamp("1962-10-01 00:00:00"),
            "fcst": 8345.342377267012,
            "fcst_lower": -481746.8596283498,
            "fcst_upper": 498437.5443828838,
        },
        {
            "time": pd.Timestamp("1962-11-01 00:00:00"),
            "fcst": 8704.649895161965,
            "fcst_lower": -515170.1267288102,
            "fcst_upper": 532579.4265191341,
        },
        {
            "time": pd.Timestamp("1962-12-01 00:00:00"),
            "fcst": 9063.92353750145,
            "fcst_lower": -549333.7223926808,
            "fcst_upper": 567461.5694676838,
        },
        {
            "time": pd.Timestamp("1963-01-01 00:00:00"),
            "fcst": 9423.163307479259,
            "fcst_lower": -584221.9396447878,
            "fcst_upper": 603068.2662597463,
        },
        {
            "time": pd.Timestamp("1963-02-01 00:00:00"),
            "fcst": 9782.369208288881,
            "fcst_lower": -619820.0202950516,
            "fcst_upper": 639384.7587116293,
        },
        {
            "time": pd.Timestamp("1963-03-01 00:00:00"),
            "fcst": 10141.541243123507,
            "fcst_lower": -656114.062946607,
            "fcst_upper": 676397.145432854,
        },
        {
            "time": pd.Timestamp("1963-04-01 00:00:00"),
            "fcst": 10500.679415176024,
            "fcst_lower": -693090.9430259921,
            "fcst_upper": 714092.3018563442,
        },
        {
            "time": pd.Timestamp("1963-05-01 00:00:00"),
            "fcst": 10859.783727639018,
            "fcst_lower": -730738.2428882846,
            "fcst_upper": 752457.8103435626,
        },
        {
            "time": pd.Timestamp("1963-06-01 00:00:00"),
            "fcst": 11218.854183704778,
            "fcst_lower": -769044.1904220572,
            "fcst_upper": 791481.8987894668,
        },
    ]
)

AIR_FCST_15_SARIMA_PARAM_2_MODEL_2 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": -3781.8669719150857,
            "fcst_lower": -200181.97843355636,
            "fcst_upper": 192618.24448972617,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 457362.75075375783,
            "fcst_lower": -20739325.635134727,
            "fcst_upper": 21654051.13664224,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": -50142237.42101226,
            "fcst_lower": -2376266233.751603,
            "fcst_upper": 2275981758.9095783,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 5501568363.932395,
            "fcst_lower": -249716603522.0544,
            "fcst_upper": 260719740249.91922,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": -603623464481.4572,
            "fcst_lower": -28605764152574.383,
            "fcst_upper": 27398517223611.47,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 66228625935946.9,
            "fcst_lower": -3006122613812477.0,
            "fcst_upper": 3138579865684371.0,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": -7266501633095522.0,
            "fcst_lower": -3.443600919917305e17,
            "fcst_upper": 3.298270887255394e17,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 7.972692357411579e17,
            "fcst_lower": -3.61881142030236e19,
            "fcst_upper": 3.778265267450592e19,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": -8.747513815509372e19,
            "fcst_lower": -4.145453774465402e21,
            "fcst_upper": 3.970503498155214e21,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 9.59763584523536e21,
            "fcst_lower": -4.356374565532236e23,
            "fcst_upper": 4.548327282436943e23,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": -1.0530376488737538e24,
            "fcst_lower": -4.9903538173762575e25,
            "fcst_upper": 4.779746287601506e25,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 1.1553764987823104e26,
            "fcst_lower": -5.244263143623692e27,
            "fcst_upper": 5.475338443380155e27,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": -1.2676610901482663e28,
            "fcst_lower": -6.007456017481067e29,
            "fcst_upper": 5.7539237994514136e29,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 1.3908579940560712e30,
            "fcst_lower": -6.313115528946667e31,
            "fcst_upper": 6.591287127757882e31,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": -1.5260277172374359e32,
            "fcst_lower": -7.231857524071115e33,
            "fcst_upper": 6.926651980623627e33,
        },
    ]
)

AIR_FCST_30_SARIMA_PARAM_2_MODEL_2 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": -3781.8669719150857,
            "fcst_lower": -200181.97843355636,
            "fcst_upper": 192618.24448972617,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 457362.75075375783,
            "fcst_lower": -20739325.635134727,
            "fcst_upper": 21654051.13664224,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": -50142237.42101226,
            "fcst_lower": -2376266233.751603,
            "fcst_upper": 2275981758.9095783,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 5501568363.932395,
            "fcst_lower": -249716603522.0544,
            "fcst_upper": 260719740249.91922,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": -603623464481.4572,
            "fcst_lower": -28605764152574.383,
            "fcst_upper": 27398517223611.47,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 66228625935946.9,
            "fcst_lower": -3006122613812477.0,
            "fcst_upper": 3138579865684371.0,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": -7266501633095522.0,
            "fcst_lower": -3.443600919917305e17,
            "fcst_upper": 3.298270887255394e17,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 7.972692357411579e17,
            "fcst_lower": -3.61881142030236e19,
            "fcst_upper": 3.778265267450592e19,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": -8.747513815509372e19,
            "fcst_lower": -4.145453774465402e21,
            "fcst_upper": 3.970503498155214e21,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 9.59763584523536e21,
            "fcst_lower": -4.356374565532236e23,
            "fcst_upper": 4.548327282436943e23,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": -1.0530376488737538e24,
            "fcst_lower": -4.9903538173762575e25,
            "fcst_upper": 4.779746287601506e25,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 1.1553764987823104e26,
            "fcst_lower": -5.244263143623692e27,
            "fcst_upper": 5.475338443380155e27,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": -1.2676610901482663e28,
            "fcst_lower": -6.007456017481067e29,
            "fcst_upper": 5.7539237994514136e29,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 1.3908579940560712e30,
            "fcst_lower": -6.313115528946667e31,
            "fcst_upper": 6.591287127757882e31,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": -1.5260277172374359e32,
            "fcst_lower": -7.231857524071115e33,
            "fcst_upper": 6.926651980623627e33,
        },
        {
            "time": pd.Timestamp("1962-04-01 00:00:00"),
            "fcst": 1.6743338311524398e34,
            "fcst_lower": -7.59981461462061e35,
            "fcst_upper": 7.934681380851099e35,
        },
        {
            "time": pd.Timestamp("1962-05-01 00:00:00"),
            "fcst": -1.8370529882750648e36,
            "fcst_lower": -8.705808764355019e37,
            "fcst_upper": 8.338398166700007e37,
        },
        {
            "time": pd.Timestamp("1962-06-01 00:00:00"),
            "fcst": 2.0155859118055944e38,
            "fcst_lower": -9.148760530640518e39,
            "fcst_upper": 9.551877713001636e39,
        },
        {
            "time": pd.Timestamp("1962-07-01 00:00:00"),
            "fcst": -2.2114694534118106e40,
            "fcst_lower": -1.0480171379102986e42,
            "fcst_upper": 1.0037877488420623e42,
        },
        {
            "time": pd.Timestamp("1962-08-01 00:00:00"),
            "fcst": 2.4263898227947306e42,
            "fcst_lower": -1.1013402759322984e44,
            "fcst_upper": 1.1498680723881932e44,
        },
        {
            "time": pd.Timestamp("1962-09-01 00:00:00"),
            "fcst": -2.6621971029619837e44,
            "fcst_lower": -1.2616173305468483e46,
            "fcst_upper": 1.2083733884876087e46,
        },
        {
            "time": pd.Timestamp("1962-10-01 00:00:00"),
            "fcst": 2.9209211761595633e46,
            "fcst_lower": -1.3258084516785478e48,
            "fcst_upper": 1.3842268752017392e48,
        },
        {
            "time": pd.Timestamp("1962-11-01 00:00:00"),
            "fcst": -3.2047891975559714e48,
            "fcst_lower": -1.5187521569636682e50,
            "fcst_upper": 1.4546563730125486e50,
        },
        {
            "time": pd.Timestamp("1962-12-01 00:00:00"),
            "fcst": 3.5162447670961676e50,
            "fcst_lower": -1.5960263044537214e52,
            "fcst_upper": 1.6663511997956447e52,
        },
        {
            "time": pd.Timestamp("1963-01-01 00:00:00"),
            "fcst": -3.8579689645609656e52,
            "fcst_lower": -1.828294569544312e54,
            "fcst_upper": 1.751135190253093e54,
        },
        {
            "time": pd.Timestamp("1963-02-01 00:00:00"),
            "fcst": 4.232903428906417e54,
            "fcst_lower": -1.921318242679158e56,
            "fcst_upper": 2.0059763112572865e56,
        },
        {
            "time": pd.Timestamp("1963-03-01 00:00:00"),
            "fcst": -4.644275680555325e56,
            "fcst_lower": -2.2009259494373087e58,
            "fcst_upper": 2.108040435826202e58,
        },
        {
            "time": pd.Timestamp("1963-04-01 00:00:00"),
            "fcst": 5.095626904620905e58,
            "fcst_lower": -2.3129091164416752e60,
            "fcst_upper": 2.4148216545340934e60,
        },
        {
            "time": pd.Timestamp("1963-05-01 00:00:00"),
            "fcst": -5.590842434226837e60,
            "fcst_lower": -2.6495046890140163e62,
            "fcst_upper": 2.5376878403294794e62,
        },
        {
            "time": pd.Timestamp("1963-06-01 00:00:00"),
            "fcst": 6.13418519633099e62,
            "fcst_lower": -2.78431155343604e64,
            "fcst_upper": 2.90699525736266e64,
        },
    ]
)

AIR_FCST_15_SARIMA_PARAM_1_MODEL_1_INCL_HIST = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1949-01-01 00:00:00"),
            "fcst": np.nan,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("1949-02-01 00:00:00"),
            "fcst": np.nan,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("1949-03-01 00:00:00"),
            "fcst": np.nan,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("1949-04-01 00:00:00"),
            "fcst": 135.0085515088317,
            "fcst_lower": 71.80596294755452,
            "fcst_upper": 198.21114007010885,
        },
        {
            "time": pd.Timestamp("1949-05-01 00:00:00"),
            "fcst": 125.62306006134283,
            "fcst_lower": 63.15956900973017,
            "fcst_upper": 188.08655111295548,
        },
        {
            "time": pd.Timestamp("1949-06-01 00:00:00"),
            "fcst": 121.01284262480458,
            "fcst_lower": 59.03692143976053,
            "fcst_upper": 182.98876380984862,
        },
        {
            "time": pd.Timestamp("1949-07-01 00:00:00"),
            "fcst": 139.98060524169694,
            "fcst_lower": 78.33811846537051,
            "fcst_upper": 201.62309201802336,
        },
        {
            "time": pd.Timestamp("1949-08-01 00:00:00"),
            "fcst": 148.56955010352056,
            "fcst_lower": 87.1607308157933,
            "fcst_upper": 209.9783693912478,
        },
        {
            "time": pd.Timestamp("1949-09-01 00:00:00"),
            "fcst": 147.5180865351954,
            "fcst_lower": 86.27583411392447,
            "fcst_upper": 208.76033895646634,
        },
        {
            "time": pd.Timestamp("1949-10-01 00:00:00"),
            "fcst": 131.89147407336858,
            "fcst_lower": 70.76940341948509,
            "fcst_upper": 193.01354472725208,
        },
        {
            "time": pd.Timestamp("1949-11-01 00:00:00"),
            "fcst": 116.05089123243054,
            "fcst_lower": 55.01629378221911,
            "fcst_upper": 177.085488682642,
        },
        {
            "time": pd.Timestamp("1949-12-01 00:00:00"),
            "fcst": 100.79090654677762,
            "fcst_lower": 39.82038033164898,
            "fcst_upper": 161.76143276190626,
        },
        {
            "time": pd.Timestamp("1950-01-01 00:00:00"),
            "fcst": 126.13248036324374,
            "fcst_lower": 65.20910226614157,
            "fcst_upper": 187.05585846034592,
        },
        {
            "time": pd.Timestamp("1950-02-01 00:00:00"),
            "fcst": 106.85235461638639,
            "fcst_lower": 45.96378987448384,
            "fcst_upper": 167.74091935828895,
        },
        {
            "time": pd.Timestamp("1950-03-01 00:00:00"),
            "fcst": 137.26328054657446,
            "fcst_lower": 76.40048612084445,
            "fcst_upper": 198.12607497230448,
        },
        {
            "time": pd.Timestamp("1950-04-01 00:00:00"),
            "fcst": 137.10578739491186,
            "fcst_lower": 76.26210478110622,
            "fcst_upper": 197.9494700087175,
        },
        {
            "time": pd.Timestamp("1950-05-01 00:00:00"),
            "fcst": 136.0301562760974,
            "fcst_lower": 75.20066695643767,
            "fcst_upper": 196.85964559575712,
        },
        {
            "time": pd.Timestamp("1950-06-01 00:00:00"),
            "fcst": 120.23040140472432,
            "fcst_lower": 59.41146346957495,
            "fcst_upper": 181.04933933987368,
        },
        {
            "time": pd.Timestamp("1950-07-01 00:00:00"),
            "fcst": 162.43659552335512,
            "fcst_lower": 101.62550752905884,
            "fcst_upper": 223.2476835176514,
        },
        {
            "time": pd.Timestamp("1950-08-01 00:00:00"),
            "fcst": 166.56792220834384,
            "fcst_lower": 105.76267766375248,
            "fcst_upper": 227.37316675293522,
        },
        {
            "time": pd.Timestamp("1950-09-01 00:00:00"),
            "fcst": 172.9619223189896,
            "fcst_lower": 112.16102943817532,
            "fcst_upper": 233.76281519980387,
        },
        {
            "time": pd.Timestamp("1950-10-01 00:00:00"),
            "fcst": 150.77620057807434,
            "fcst_lower": 89.97854943367574,
            "fcst_upper": 211.57385172247294,
        },
        {
            "time": pd.Timestamp("1950-11-01 00:00:00"),
            "fcst": 129.51001770308469,
            "fcst_lower": 68.71478202858111,
            "fcst_upper": 190.30525337758826,
        },
        {
            "time": pd.Timestamp("1950-12-01 00:00:00"),
            "fcst": 109.62000466116207,
            "fcst_lower": 48.826569105723955,
            "fcst_upper": 170.41344021660018,
        },
        {
            "time": pd.Timestamp("1951-01-01 00:00:00"),
            "fcst": 153.89935886484943,
            "fcst_lower": 93.1072650149965,
            "fcst_upper": 214.69145271470236,
        },
        {
            "time": pd.Timestamp("1951-02-01 00:00:00"),
            "fcst": 134.9454456980926,
            "fcst_lower": 74.15435197547745,
            "fcst_upper": 195.73653942070777,
        },
        {
            "time": pd.Timestamp("1951-03-01 00:00:00"),
            "fcst": 160.62731874968088,
            "fcst_lower": 99.83697059052213,
            "fcst_upper": 221.41766690883964,
        },
        {
            "time": pd.Timestamp("1951-04-01 00:00:00"),
            "fcst": 179.72266723733324,
            "fcst_lower": 118.9328749022144,
            "fcst_upper": 240.5124595724521,
        },
        {
            "time": pd.Timestamp("1951-05-01 00:00:00"),
            "fcst": 155.67375787300605,
            "fcst_lower": 94.88437992615539,
            "fcst_upper": 216.46313581985672,
        },
        {
            "time": pd.Timestamp("1951-06-01 00:00:00"),
            "fcst": 181.82932035221148,
            "fcst_lower": 121.04025135703824,
            "fcst_upper": 242.61838934738472,
        },
        {
            "time": pd.Timestamp("1951-07-01 00:00:00"),
            "fcst": 171.84831446216,
            "fcst_lower": 111.05947581440104,
            "fcst_upper": 232.63715310991898,
        },
        {
            "time": pd.Timestamp("1951-08-01 00:00:00"),
            "fcst": 212.4867364260599,
            "fcst_lower": 151.69806952299996,
            "fcst_upper": 273.27540332911985,
        },
        {
            "time": pd.Timestamp("1951-09-01 00:00:00"),
            "fcst": 187.3544433748014,
            "fcst_lower": 126.5659045244358,
            "fcst_upper": 248.14298222516703,
        },
        {
            "time": pd.Timestamp("1951-10-01 00:00:00"),
            "fcst": 188.21643415300693,
            "fcst_lower": 127.4279907794978,
            "fcst_upper": 249.00487752651605,
        },
        {
            "time": pd.Timestamp("1951-11-01 00:00:00"),
            "fcst": 149.7947340852945,
            "fcst_lower": 89.00636190039214,
            "fcst_upper": 210.58310627019685,
        },
        {
            "time": pd.Timestamp("1951-12-01 00:00:00"),
            "fcst": 150.31042796244319,
            "fcst_lower": 89.52210885683084,
            "fcst_upper": 211.09874706805553,
        },
        {
            "time": pd.Timestamp("1952-01-01 00:00:00"),
            "fcst": 170.06388969156714,
            "fcst_lower": 109.27561016281888,
            "fcst_upper": 230.8521692203154,
        },
        {
            "time": pd.Timestamp("1952-02-01 00:00:00"),
            "fcst": 169.43734205976682,
            "fcst_lower": 108.64909204031761,
            "fcst_upper": 230.22559207921603,
        },
        {
            "time": pd.Timestamp("1952-03-01 00:00:00"),
            "fcst": 184.8530229780305,
            "fcst_lower": 124.06479496134995,
            "fcst_upper": 245.64125099471107,
        },
        {
            "time": pd.Timestamp("1952-04-01 00:00:00"),
            "fcst": 193.87031577249965,
            "fcst_lower": 133.0821041615831,
            "fcst_upper": 254.6585273834162,
        },
        {
            "time": pd.Timestamp("1952-05-01 00:00:00"),
            "fcst": 175.57690391180074,
            "fcst_lower": 114.78870453340889,
            "fcst_upper": 236.3651032901926,
        },
        {
            "time": pd.Timestamp("1952-06-01 00:00:00"),
            "fcst": 188.4614166915688,
            "fcst_lower": 127.67322643404401,
            "fcst_upper": 249.24960694909356,
        },
        {
            "time": pd.Timestamp("1952-07-01 00:00:00"),
            "fcst": 226.90956070992576,
            "fcst_lower": 166.12137725314514,
            "fcst_upper": 287.6977441667064,
        },
        {
            "time": pd.Timestamp("1952-08-01 00:00:00"),
            "fcst": 226.97822295549526,
            "fcst_lower": 166.1900445695202,
            "fcst_upper": 287.76640134147027,
        },
        {
            "time": pd.Timestamp("1952-09-01 00:00:00"),
            "fcst": 249.28088657412243,
            "fcst_lower": 188.49271196906875,
            "fcst_upper": 310.0690611791761,
        },
        {
            "time": pd.Timestamp("1952-10-01 00:00:00"),
            "fcst": 189.8660953003974,
            "fcst_lower": 129.0779235144954,
            "fcst_upper": 250.6542670862994,
        },
        {
            "time": pd.Timestamp("1952-11-01 00:00:00"),
            "fcst": 200.51466059348994,
            "fcst_lower": 139.72649090962,
            "fcst_upper": 261.3028302773599,
        },
        {
            "time": pd.Timestamp("1952-12-01 00:00:00"),
            "fcst": 156.38743049987673,
            "fcst_lower": 95.59926238333622,
            "fcst_upper": 217.17559861641723,
        },
        {
            "time": pd.Timestamp("1953-01-01 00:00:00"),
            "fcst": 216.04599225409171,
            "fcst_lower": 155.25782530619267,
            "fcst_upper": 276.83415920199076,
        },
        {
            "time": pd.Timestamp("1953-02-01 00:00:00"),
            "fcst": 177.7419649757186,
            "fcst_lower": 116.953798899189,
            "fcst_upper": 238.53013105224818,
        },
        {
            "time": pd.Timestamp("1953-03-01 00:00:00"),
            "fcst": 211.7657477407197,
            "fcst_lower": 150.97758231390586,
            "fcst_upper": 272.55391316753355,
        },
        {
            "time": pd.Timestamp("1953-04-01 00:00:00"),
            "fcst": 237.95832780274853,
            "fcst_lower": 177.17016286037972,
            "fcst_upper": 298.74649274511734,
        },
        {
            "time": pd.Timestamp("1953-05-01 00:00:00"),
            "fcst": 232.91969102352166,
            "fcst_lower": 172.1315264423677,
            "fcst_upper": 293.7078556046756,
        },
        {
            "time": pd.Timestamp("1953-06-01 00:00:00"),
            "fcst": 228.4605400761027,
            "fcst_lower": 167.67237576427993,
            "fcst_upper": 289.24870438792544,
        },
        {
            "time": pd.Timestamp("1953-07-01 00:00:00"),
            "fcst": 248.91602032670454,
            "fcst_lower": 188.1278562157022,
            "fcst_upper": 309.7041844377069,
        },
        {
            "time": pd.Timestamp("1953-08-01 00:00:00"),
            "fcst": 267.066835347853,
            "fcst_lower": 206.27867138658758,
            "fcst_upper": 327.8549993091184,
        },
        {
            "time": pd.Timestamp("1953-09-01 00:00:00"),
            "fcst": 272.46619776983084,
            "fcst_lower": 211.67803392021324,
            "fcst_upper": 333.25436161944845,
        },
        {
            "time": pd.Timestamp("1953-10-01 00:00:00"),
            "fcst": 222.97194293233372,
            "fcst_lower": 162.18377916596359,
            "fcst_upper": 283.76010669870385,
        },
        {
            "time": pd.Timestamp("1953-11-01 00:00:00"),
            "fcst": 212.9913800856689,
            "fcst_lower": 152.2032163813703,
            "fcst_upper": 273.77954378996753,
        },
        {
            "time": pd.Timestamp("1953-12-01 00:00:00"),
            "fcst": 166.2121528915526,
            "fcst_lower": 105.42398923353613,
            "fcst_upper": 227.00031654956905,
        },
        {
            "time": pd.Timestamp("1954-01-01 00:00:00"),
            "fcst": 221.08105573624715,
            "fcst_lower": 160.29289211273988,
            "fcst_upper": 281.8692193597544,
        },
        {
            "time": pd.Timestamp("1954-02-01 00:00:00"),
            "fcst": 187.82797877201423,
            "fcst_lower": 127.03981517423793,
            "fcst_upper": 248.61614236979054,
        },
        {
            "time": pd.Timestamp("1954-03-01 00:00:00"),
            "fcst": 195.73568473628217,
            "fcst_lower": 134.94752115769154,
            "fcst_upper": 256.5238483148728,
        },
        {
            "time": pd.Timestamp("1954-04-01 00:00:00"),
            "fcst": 246.6173596818791,
            "fcst_lower": 185.8291961175938,
            "fcst_upper": 307.4055232461644,
        },
        {
            "time": pd.Timestamp("1954-05-01 00:00:00"),
            "fcst": 213.8540513995003,
            "fcst_lower": 153.0658878458814,
            "fcst_upper": 274.64221495311915,
        },
        {
            "time": pd.Timestamp("1954-06-01 00:00:00"),
            "fcst": 248.0765798423727,
            "fcst_lower": 187.288416296707,
            "fcst_upper": 308.8647433880384,
        },
        {
            "time": pd.Timestamp("1954-07-01 00:00:00"),
            "fcst": 263.52392042845304,
            "fcst_lower": 202.73575688871742,
            "fcst_upper": 324.31208396818863,
        },
        {
            "time": pd.Timestamp("1954-08-01 00:00:00"),
            "fcst": 317.204490044766,
            "fcst_lower": 256.416326509452,
            "fcst_upper": 377.99265358007995,
        },
        {
            "time": pd.Timestamp("1954-09-01 00:00:00"),
            "fcst": 276.36727700385717,
            "fcst_lower": 215.57911347184006,
            "fcst_upper": 337.1554405358743,
        },
        {
            "time": pd.Timestamp("1954-10-01 00:00:00"),
            "fcst": 260.1261005070125,
            "fcst_lower": 199.33793697745364,
            "fcst_upper": 320.91426403657135,
        },
        {
            "time": pd.Timestamp("1954-11-01 00:00:00"),
            "fcst": 216.34861852382815,
            "fcst_lower": 155.56045499610224,
            "fcst_upper": 277.13678205155406,
        },
        {
            "time": pd.Timestamp("1954-12-01 00:00:00"),
            "fcst": 203.8026254705358,
            "fcst_lower": 143.01446194417656,
            "fcst_upper": 264.590788996895,
        },
        {
            "time": pd.Timestamp("1955-01-01 00:00:00"),
            "fcst": 238.42873369055582,
            "fcst_lower": 177.6405701652156,
            "fcst_upper": 299.21689721589604,
        },
        {
            "time": pd.Timestamp("1955-02-01 00:00:00"),
            "fcst": 238.91922058333466,
            "fcst_lower": 178.13105705875427,
            "fcst_upper": 299.70738410791506,
        },
        {
            "time": pd.Timestamp("1955-03-01 00:00:00"),
            "fcst": 232.15654290166714,
            "fcst_lower": 171.3683793776533,
            "fcst_upper": 292.944706425681,
        },
        {
            "time": pd.Timestamp("1955-04-01 00:00:00"),
            "fcst": 280.96451957808154,
            "fcst_lower": 220.1763560544901,
            "fcst_upper": 341.752683101673,
        },
        {
            "time": pd.Timestamp("1955-05-01 00:00:00"),
            "fcst": 257.7202862742384,
            "fcst_lower": 196.93212275096192,
            "fcst_upper": 318.50844979751486,
        },
        {
            "time": pd.Timestamp("1955-06-01 00:00:00"),
            "fcst": 280.1292930749069,
            "fcst_lower": 219.34112955186532,
            "fcst_upper": 340.9174565979485,
        },
        {
            "time": pd.Timestamp("1955-07-01 00:00:00"),
            "fcst": 323.77188751363974,
            "fcst_lower": 262.9837239907733,
            "fcst_upper": 384.5600510365062,
        },
        {
            "time": pd.Timestamp("1955-08-01 00:00:00"),
            "fcst": 375.5012021316152,
            "fcst_lower": 314.71303860887923,
            "fcst_upper": 436.2893656543511,
        },
        {
            "time": pd.Timestamp("1955-09-01 00:00:00"),
            "fcst": 330.45065371688304,
            "fcst_lower": 269.66249019424447,
            "fcst_upper": 391.2388172395216,
        },
        {
            "time": pd.Timestamp("1955-10-01 00:00:00"),
            "fcst": 312.6648050820013,
            "fcst_lower": 251.8766415594353,
            "fcst_upper": 373.4529686045673,
        },
        {
            "time": pd.Timestamp("1955-11-01 00:00:00"),
            "fcst": 258.6325461215688,
            "fcst_lower": 197.84438259905693,
            "fcst_upper": 319.42070964408066,
        },
        {
            "time": pd.Timestamp("1955-12-01 00:00:00"),
            "fcst": 235.86564530137574,
            "fcst_lower": 175.07748177890426,
            "fcst_upper": 296.6538088238472,
        },
        {
            "time": pd.Timestamp("1956-01-01 00:00:00"),
            "fcst": 294.94080808729143,
            "fcst_lower": 234.15264456485005,
            "fcst_upper": 355.7289716097328,
        },
        {
            "time": pd.Timestamp("1956-02-01 00:00:00"),
            "fcst": 271.70747129501024,
            "fcst_lower": 210.91930777259125,
            "fcst_upper": 332.4956348174292,
        },
        {
            "time": pd.Timestamp("1956-03-01 00:00:00"),
            "fcst": 284.8894558755466,
            "fcst_lower": 224.1012923531444,
            "fcst_upper": 345.67761939794883,
        },
        {
            "time": pd.Timestamp("1956-04-01 00:00:00"),
            "fcst": 325.7594794539503,
            "fcst_lower": 264.9713159315605,
            "fcst_upper": 386.54764297634006,
        },
        {
            "time": pd.Timestamp("1956-05-01 00:00:00"),
            "fcst": 303.8790205944456,
            "fcst_lower": 243.09085707205583,
            "fcst_upper": 364.66718411683536,
        },
        {
            "time": pd.Timestamp("1956-06-01 00:00:00"),
            "fcst": 327.8224332648391,
            "fcst_lower": 267.03426974244934,
            "fcst_upper": 388.61059678722887,
        },
        {
            "time": pd.Timestamp("1956-07-01 00:00:00"),
            "fcst": 387.3191590210848,
            "fcst_lower": 326.530995498695,
            "fcst_upper": 448.10732254347454,
        },
        {
            "time": pd.Timestamp("1956-08-01 00:00:00"),
            "fcst": 416.6816499516949,
            "fcst_lower": 355.89348642930514,
            "fcst_upper": 477.4698134740847,
        },
        {
            "time": pd.Timestamp("1956-09-01 00:00:00"),
            "fcst": 398.70650883375663,
            "fcst_lower": 337.91834531136686,
            "fcst_upper": 459.4946723561464,
        },
        {
            "time": pd.Timestamp("1956-10-01 00:00:00"),
            "fcst": 340.96941141178087,
            "fcst_lower": 280.1812478893911,
            "fcst_upper": 401.75757493417063,
        },
        {
            "time": pd.Timestamp("1956-11-01 00:00:00"),
            "fcst": 299.0396677611477,
            "fcst_lower": 238.25150423875795,
            "fcst_upper": 359.8278312835375,
        },
        {
            "time": pd.Timestamp("1956-12-01 00:00:00"),
            "fcst": 263.38472516050194,
            "fcst_lower": 202.59656163811218,
            "fcst_upper": 324.1728886828917,
        },
        {
            "time": pd.Timestamp("1957-01-01 00:00:00"),
            "fcst": 326.2012603176815,
            "fcst_lower": 265.4130967952917,
            "fcst_upper": 386.98942384007125,
        },
        {
            "time": pd.Timestamp("1957-02-01 00:00:00"),
            "fcst": 301.059982020002,
            "fcst_lower": 240.27181849761223,
            "fcst_upper": 361.84814554239176,
        },
        {
            "time": pd.Timestamp("1957-03-01 00:00:00"),
            "fcst": 307.58695762114746,
            "fcst_lower": 246.7987940987577,
            "fcst_upper": 368.3751211435372,
        },
        {
            "time": pd.Timestamp("1957-04-01 00:00:00"),
            "fcst": 371.7236809447925,
            "fcst_lower": 310.9355174224027,
            "fcst_upper": 432.51184446718224,
        },
        {
            "time": pd.Timestamp("1957-05-01 00:00:00"),
            "fcst": 331.30825739954514,
            "fcst_lower": 270.5200938771554,
            "fcst_upper": 392.0964209219349,
        },
        {
            "time": pd.Timestamp("1957-06-01 00:00:00"),
            "fcst": 372.1383605155684,
            "fcst_lower": 311.35019699317866,
            "fcst_upper": 432.9265240379582,
        },
        {
            "time": pd.Timestamp("1957-07-01 00:00:00"),
            "fcst": 433.28418069535934,
            "fcst_lower": 372.4960171729696,
            "fcst_upper": 494.0723442177491,
        },
        {
            "time": pd.Timestamp("1957-08-01 00:00:00"),
            "fcst": 471.99604626997774,
            "fcst_lower": 411.207882747588,
            "fcst_upper": 532.7842097923675,
        },
        {
            "time": pd.Timestamp("1957-09-01 00:00:00"),
            "fcst": 461.7375384808529,
            "fcst_lower": 400.9493749584631,
            "fcst_upper": 522.5257020032426,
        },
        {
            "time": pd.Timestamp("1957-10-01 00:00:00"),
            "fcst": 384.0182219526643,
            "fcst_lower": 323.23005843027454,
            "fcst_upper": 444.80638547505407,
        },
        {
            "time": pd.Timestamp("1957-11-01 00:00:00"),
            "fcst": 342.0640995662381,
            "fcst_lower": 281.27593604384833,
            "fcst_upper": 402.85226308862786,
        },
        {
            "time": pd.Timestamp("1957-12-01 00:00:00"),
            "fcst": 292.9115359604155,
            "fcst_lower": 232.12337243802574,
            "fcst_upper": 353.6996994828053,
        },
        {
            "time": pd.Timestamp("1958-01-01 00:00:00"),
            "fcst": 358.5066437814099,
            "fcst_lower": 297.7184802590201,
            "fcst_upper": 419.29480730379964,
        },
        {
            "time": pd.Timestamp("1958-02-01 00:00:00"),
            "fcst": 322.1227918937741,
            "fcst_lower": 261.3346283713843,
            "fcst_upper": 382.91095541616386,
        },
        {
            "time": pd.Timestamp("1958-03-01 00:00:00"),
            "fcst": 324.8723080815947,
            "fcst_lower": 264.08414455920496,
            "fcst_upper": 385.6604716039845,
        },
        {
            "time": pd.Timestamp("1958-04-01 00:00:00"),
            "fcst": 373.1949826857821,
            "fcst_lower": 312.40681916339236,
            "fcst_upper": 433.9831462081719,
        },
        {
            "time": pd.Timestamp("1958-05-01 00:00:00"),
            "fcst": 332.8829728970037,
            "fcst_lower": 272.09480937461393,
            "fcst_upper": 393.67113641939346,
        },
        {
            "time": pd.Timestamp("1958-06-01 00:00:00"),
            "fcst": 381.89299859284955,
            "fcst_lower": 321.1048350704598,
            "fcst_upper": 442.6811621152393,
        },
        {
            "time": pd.Timestamp("1958-07-01 00:00:00"),
            "fcst": 446.7155564920999,
            "fcst_lower": 385.9273929697101,
            "fcst_upper": 507.50372001448966,
        },
        {
            "time": pd.Timestamp("1958-08-01 00:00:00"),
            "fcst": 502.6844537687679,
            "fcst_lower": 441.89629024637816,
            "fcst_upper": 563.4726172911577,
        },
        {
            "time": pd.Timestamp("1958-09-01 00:00:00"),
            "fcst": 500.3607141468311,
            "fcst_lower": 439.57255062444136,
            "fcst_upper": 561.1488776692208,
        },
        {
            "time": pd.Timestamp("1958-10-01 00:00:00"),
            "fcst": 368.68671492844595,
            "fcst_lower": 307.8985514060562,
            "fcst_upper": 429.4748784508357,
        },
        {
            "time": pd.Timestamp("1958-11-01 00:00:00"),
            "fcst": 371.974401051855,
            "fcst_lower": 311.18623752946525,
            "fcst_upper": 432.7625645742448,
        },
        {
            "time": pd.Timestamp("1958-12-01 00:00:00"),
            "fcst": 279.72095413080376,
            "fcst_lower": 218.932790608414,
            "fcst_upper": 340.5091176531935,
        },
        {
            "time": pd.Timestamp("1959-01-01 00:00:00"),
            "fcst": 373.656947563427,
            "fcst_lower": 312.86878404103726,
            "fcst_upper": 434.4451110858168,
        },
        {
            "time": pd.Timestamp("1959-02-01 00:00:00"),
            "fcst": 337.3007528305821,
            "fcst_lower": 276.51258930819233,
            "fcst_upper": 398.08891635297186,
        },
        {
            "time": pd.Timestamp("1959-03-01 00:00:00"),
            "fcst": 354.59332155002505,
            "fcst_lower": 293.8051580276353,
            "fcst_upper": 415.3814850724148,
        },
        {
            "time": pd.Timestamp("1959-04-01 00:00:00"),
            "fcst": 420.0409061007712,
            "fcst_lower": 359.25274257838146,
            "fcst_upper": 480.829069623161,
        },
        {
            "time": pd.Timestamp("1959-05-01 00:00:00"),
            "fcst": 379.98272771878794,
            "fcst_lower": 319.1945641963982,
            "fcst_upper": 440.7708912411777,
        },
        {
            "time": pd.Timestamp("1959-06-01 00:00:00"),
            "fcst": 443.1740564357343,
            "fcst_lower": 382.38589291334455,
            "fcst_upper": 503.9622199581241,
        },
        {
            "time": pd.Timestamp("1959-07-01 00:00:00"),
            "fcst": 472.2328796575603,
            "fcst_lower": 411.44471613517055,
            "fcst_upper": 533.0210431799501,
        },
        {
            "time": pd.Timestamp("1959-08-01 00:00:00"),
            "fcst": 577.3857032885581,
            "fcst_lower": 516.5975397661684,
            "fcst_upper": 638.1738668109479,
        },
        {
            "time": pd.Timestamp("1959-09-01 00:00:00"),
            "fcst": 537.9078476419501,
            "fcst_lower": 477.1196841195603,
            "fcst_upper": 598.6960111643398,
        },
        {
            "time": pd.Timestamp("1959-10-01 00:00:00"),
            "fcst": 443.840206931614,
            "fcst_lower": 383.0520434092242,
            "fcst_upper": 504.62837045400374,
        },
        {
            "time": pd.Timestamp("1959-11-01 00:00:00"),
            "fcst": 401.74361834799936,
            "fcst_lower": 340.9554548256096,
            "fcst_upper": 462.5317818703891,
        },
        {
            "time": pd.Timestamp("1959-12-01 00:00:00"),
            "fcst": 349.02037060055704,
            "fcst_lower": 288.2322070781673,
            "fcst_upper": 409.8085341229468,
        },
        {
            "time": pd.Timestamp("1960-01-01 00:00:00"),
            "fcst": 432.9477609983596,
            "fcst_lower": 372.15959747596986,
            "fcst_upper": 493.7359245207494,
        },
        {
            "time": pd.Timestamp("1960-02-01 00:00:00"),
            "fcst": 397.5388056768658,
            "fcst_lower": 336.75064215447605,
            "fcst_upper": 458.3269691992556,
        },
        {
            "time": pd.Timestamp("1960-03-01 00:00:00"),
            "fcst": 397.6828749250387,
            "fcst_lower": 336.8947114026489,
            "fcst_upper": 458.47103844742844,
        },
        {
            "time": pd.Timestamp("1960-04-01 00:00:00"),
            "fcst": 424.1297588023324,
            "fcst_lower": 363.3415952799426,
            "fcst_upper": 484.91792232472216,
        },
        {
            "time": pd.Timestamp("1960-05-01 00:00:00"),
            "fcst": 472.9210680197455,
            "fcst_lower": 412.13290449735575,
            "fcst_upper": 533.7092315421353,
        },
        {
            "time": pd.Timestamp("1960-06-01 00:00:00"),
            "fcst": 465.9884988075222,
            "fcst_lower": 405.20033528513244,
            "fcst_upper": 526.7766623299119,
        },
        {
            "time": pd.Timestamp("1960-07-01 00:00:00"),
            "fcst": 564.7168052202932,
            "fcst_lower": 503.9286416979034,
            "fcst_upper": 625.5049687426829,
        },
        {
            "time": pd.Timestamp("1960-08-01 00:00:00"),
            "fcst": 630.2087363420145,
            "fcst_lower": 569.4205728196248,
            "fcst_upper": 690.9968998644042,
        },
        {
            "time": pd.Timestamp("1960-09-01 00:00:00"),
            "fcst": 592.6829862745113,
            "fcst_lower": 531.8948227521216,
            "fcst_upper": 653.471149796901,
        },
        {
            "time": pd.Timestamp("1960-10-01 00:00:00"),
            "fcst": 481.3478022088564,
            "fcst_lower": 420.55963868646666,
            "fcst_upper": 542.1359657312462,
        },
        {
            "time": pd.Timestamp("1960-11-01 00:00:00"),
            "fcst": 465.71698278583256,
            "fcst_lower": 404.9288192634428,
            "fcst_upper": 526.5051463082223,
        },
        {
            "time": pd.Timestamp("1960-12-01 00:00:00"),
            "fcst": 358.28660749941486,
            "fcst_lower": 297.4984439770251,
            "fcst_upper": 419.0747710218046,
        },
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 475.734999664335,
            "fcst_lower": 414.94683614194525,
            "fcst_upper": 536.5231631867248,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 454.9960131326432,
            "fcst_lower": 350.9406985933037,
            "fcst_upper": 559.0513276719827,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 464.83036926989587,
            "fcst_lower": 337.5891858591327,
            "fcst_upper": 592.071552680659,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 460.16695138848075,
            "fcst_lower": 310.6316031682349,
            "fcst_upper": 609.7022996087267,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 462.3783281205398,
            "fcst_lower": 294.62476708969064,
            "fcst_upper": 630.1318891513889,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 461.3297008742918,
            "fcst_lower": 276.654109966928,
            "fcst_upper": 646.0052917816556,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 461.82695631052394,
            "fcst_lower": 261.87302294007793,
            "fcst_upper": 661.78088968097,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 461.591159491638,
            "fcst_lower": 247.3497039224739,
            "fcst_upper": 675.832615060802,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 461.7029735327635,
            "fcst_lower": 234.11208345911712,
            "fcst_upper": 689.2938636064099,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 461.64995169874607,
            "fcst_lower": 221.43104743037904,
            "fcst_upper": 701.8688559671131,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 461.67509447021087,
            "fcst_lower": 209.4683909799995,
            "fcst_upper": 713.8817979604222,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 461.66317185439334,
            "fcst_lower": 198.00921052859343,
            "fcst_upper": 725.3171331801932,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 461.6688255178382,
            "fcst_lower": 187.04615729497976,
            "fcst_upper": 736.2914937406965,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 461.66614457006324,
            "fcst_lower": 176.49553139848467,
            "fcst_upper": 746.8367577416418,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 461.6674158662842,
            "fcst_lower": 166.32570802200962,
            "fcst_upper": 757.0091237105588,
        },
    ]
)

AIR_FCST_30_SARIMA_PARAM_1_MODEL_1_INCL_HIST = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1949-01-01 00:00:00"),
            "fcst": np.nan,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("1949-02-01 00:00:00"),
            "fcst": np.nan,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("1949-03-01 00:00:00"),
            "fcst": np.nan,
            "fcst_lower": np.nan,
            "fcst_upper": np.nan,
        },
        {
            "time": pd.Timestamp("1949-04-01 00:00:00"),
            "fcst": 135.0085515088317,
            "fcst_lower": 71.80596294755452,
            "fcst_upper": 198.21114007010885,
        },
        {
            "time": pd.Timestamp("1949-05-01 00:00:00"),
            "fcst": 125.62306006134283,
            "fcst_lower": 63.15956900973017,
            "fcst_upper": 188.08655111295548,
        },
        {
            "time": pd.Timestamp("1949-06-01 00:00:00"),
            "fcst": 121.01284262480458,
            "fcst_lower": 59.03692143976053,
            "fcst_upper": 182.98876380984862,
        },
        {
            "time": pd.Timestamp("1949-07-01 00:00:00"),
            "fcst": 139.98060524169694,
            "fcst_lower": 78.33811846537051,
            "fcst_upper": 201.62309201802336,
        },
        {
            "time": pd.Timestamp("1949-08-01 00:00:00"),
            "fcst": 148.56955010352056,
            "fcst_lower": 87.1607308157933,
            "fcst_upper": 209.9783693912478,
        },
        {
            "time": pd.Timestamp("1949-09-01 00:00:00"),
            "fcst": 147.5180865351954,
            "fcst_lower": 86.27583411392447,
            "fcst_upper": 208.76033895646634,
        },
        {
            "time": pd.Timestamp("1949-10-01 00:00:00"),
            "fcst": 131.89147407336858,
            "fcst_lower": 70.76940341948509,
            "fcst_upper": 193.01354472725208,
        },
        {
            "time": pd.Timestamp("1949-11-01 00:00:00"),
            "fcst": 116.05089123243054,
            "fcst_lower": 55.01629378221911,
            "fcst_upper": 177.085488682642,
        },
        {
            "time": pd.Timestamp("1949-12-01 00:00:00"),
            "fcst": 100.79090654677762,
            "fcst_lower": 39.82038033164898,
            "fcst_upper": 161.76143276190626,
        },
        {
            "time": pd.Timestamp("1950-01-01 00:00:00"),
            "fcst": 126.13248036324374,
            "fcst_lower": 65.20910226614157,
            "fcst_upper": 187.05585846034592,
        },
        {
            "time": pd.Timestamp("1950-02-01 00:00:00"),
            "fcst": 106.85235461638639,
            "fcst_lower": 45.96378987448384,
            "fcst_upper": 167.74091935828895,
        },
        {
            "time": pd.Timestamp("1950-03-01 00:00:00"),
            "fcst": 137.26328054657446,
            "fcst_lower": 76.40048612084445,
            "fcst_upper": 198.12607497230448,
        },
        {
            "time": pd.Timestamp("1950-04-01 00:00:00"),
            "fcst": 137.10578739491186,
            "fcst_lower": 76.26210478110622,
            "fcst_upper": 197.9494700087175,
        },
        {
            "time": pd.Timestamp("1950-05-01 00:00:00"),
            "fcst": 136.0301562760974,
            "fcst_lower": 75.20066695643767,
            "fcst_upper": 196.85964559575712,
        },
        {
            "time": pd.Timestamp("1950-06-01 00:00:00"),
            "fcst": 120.23040140472432,
            "fcst_lower": 59.41146346957495,
            "fcst_upper": 181.04933933987368,
        },
        {
            "time": pd.Timestamp("1950-07-01 00:00:00"),
            "fcst": 162.43659552335512,
            "fcst_lower": 101.62550752905884,
            "fcst_upper": 223.2476835176514,
        },
        {
            "time": pd.Timestamp("1950-08-01 00:00:00"),
            "fcst": 166.56792220834384,
            "fcst_lower": 105.76267766375248,
            "fcst_upper": 227.37316675293522,
        },
        {
            "time": pd.Timestamp("1950-09-01 00:00:00"),
            "fcst": 172.9619223189896,
            "fcst_lower": 112.16102943817532,
            "fcst_upper": 233.76281519980387,
        },
        {
            "time": pd.Timestamp("1950-10-01 00:00:00"),
            "fcst": 150.77620057807434,
            "fcst_lower": 89.97854943367574,
            "fcst_upper": 211.57385172247294,
        },
        {
            "time": pd.Timestamp("1950-11-01 00:00:00"),
            "fcst": 129.51001770308469,
            "fcst_lower": 68.71478202858111,
            "fcst_upper": 190.30525337758826,
        },
        {
            "time": pd.Timestamp("1950-12-01 00:00:00"),
            "fcst": 109.62000466116207,
            "fcst_lower": 48.826569105723955,
            "fcst_upper": 170.41344021660018,
        },
        {
            "time": pd.Timestamp("1951-01-01 00:00:00"),
            "fcst": 153.89935886484943,
            "fcst_lower": 93.1072650149965,
            "fcst_upper": 214.69145271470236,
        },
        {
            "time": pd.Timestamp("1951-02-01 00:00:00"),
            "fcst": 134.9454456980926,
            "fcst_lower": 74.15435197547745,
            "fcst_upper": 195.73653942070777,
        },
        {
            "time": pd.Timestamp("1951-03-01 00:00:00"),
            "fcst": 160.62731874968088,
            "fcst_lower": 99.83697059052213,
            "fcst_upper": 221.41766690883964,
        },
        {
            "time": pd.Timestamp("1951-04-01 00:00:00"),
            "fcst": 179.72266723733324,
            "fcst_lower": 118.9328749022144,
            "fcst_upper": 240.5124595724521,
        },
        {
            "time": pd.Timestamp("1951-05-01 00:00:00"),
            "fcst": 155.67375787300605,
            "fcst_lower": 94.88437992615539,
            "fcst_upper": 216.46313581985672,
        },
        {
            "time": pd.Timestamp("1951-06-01 00:00:00"),
            "fcst": 181.82932035221148,
            "fcst_lower": 121.04025135703824,
            "fcst_upper": 242.61838934738472,
        },
        {
            "time": pd.Timestamp("1951-07-01 00:00:00"),
            "fcst": 171.84831446216,
            "fcst_lower": 111.05947581440104,
            "fcst_upper": 232.63715310991898,
        },
        {
            "time": pd.Timestamp("1951-08-01 00:00:00"),
            "fcst": 212.4867364260599,
            "fcst_lower": 151.69806952299996,
            "fcst_upper": 273.27540332911985,
        },
        {
            "time": pd.Timestamp("1951-09-01 00:00:00"),
            "fcst": 187.3544433748014,
            "fcst_lower": 126.5659045244358,
            "fcst_upper": 248.14298222516703,
        },
        {
            "time": pd.Timestamp("1951-10-01 00:00:00"),
            "fcst": 188.21643415300693,
            "fcst_lower": 127.4279907794978,
            "fcst_upper": 249.00487752651605,
        },
        {
            "time": pd.Timestamp("1951-11-01 00:00:00"),
            "fcst": 149.7947340852945,
            "fcst_lower": 89.00636190039214,
            "fcst_upper": 210.58310627019685,
        },
        {
            "time": pd.Timestamp("1951-12-01 00:00:00"),
            "fcst": 150.31042796244319,
            "fcst_lower": 89.52210885683084,
            "fcst_upper": 211.09874706805553,
        },
        {
            "time": pd.Timestamp("1952-01-01 00:00:00"),
            "fcst": 170.06388969156714,
            "fcst_lower": 109.27561016281888,
            "fcst_upper": 230.8521692203154,
        },
        {
            "time": pd.Timestamp("1952-02-01 00:00:00"),
            "fcst": 169.43734205976682,
            "fcst_lower": 108.64909204031761,
            "fcst_upper": 230.22559207921603,
        },
        {
            "time": pd.Timestamp("1952-03-01 00:00:00"),
            "fcst": 184.8530229780305,
            "fcst_lower": 124.06479496134995,
            "fcst_upper": 245.64125099471107,
        },
        {
            "time": pd.Timestamp("1952-04-01 00:00:00"),
            "fcst": 193.87031577249965,
            "fcst_lower": 133.0821041615831,
            "fcst_upper": 254.6585273834162,
        },
        {
            "time": pd.Timestamp("1952-05-01 00:00:00"),
            "fcst": 175.57690391180074,
            "fcst_lower": 114.78870453340889,
            "fcst_upper": 236.3651032901926,
        },
        {
            "time": pd.Timestamp("1952-06-01 00:00:00"),
            "fcst": 188.4614166915688,
            "fcst_lower": 127.67322643404401,
            "fcst_upper": 249.24960694909356,
        },
        {
            "time": pd.Timestamp("1952-07-01 00:00:00"),
            "fcst": 226.90956070992576,
            "fcst_lower": 166.12137725314514,
            "fcst_upper": 287.6977441667064,
        },
        {
            "time": pd.Timestamp("1952-08-01 00:00:00"),
            "fcst": 226.97822295549526,
            "fcst_lower": 166.1900445695202,
            "fcst_upper": 287.76640134147027,
        },
        {
            "time": pd.Timestamp("1952-09-01 00:00:00"),
            "fcst": 249.28088657412243,
            "fcst_lower": 188.49271196906875,
            "fcst_upper": 310.0690611791761,
        },
        {
            "time": pd.Timestamp("1952-10-01 00:00:00"),
            "fcst": 189.8660953003974,
            "fcst_lower": 129.0779235144954,
            "fcst_upper": 250.6542670862994,
        },
        {
            "time": pd.Timestamp("1952-11-01 00:00:00"),
            "fcst": 200.51466059348994,
            "fcst_lower": 139.72649090962,
            "fcst_upper": 261.3028302773599,
        },
        {
            "time": pd.Timestamp("1952-12-01 00:00:00"),
            "fcst": 156.38743049987673,
            "fcst_lower": 95.59926238333622,
            "fcst_upper": 217.17559861641723,
        },
        {
            "time": pd.Timestamp("1953-01-01 00:00:00"),
            "fcst": 216.04599225409171,
            "fcst_lower": 155.25782530619267,
            "fcst_upper": 276.83415920199076,
        },
        {
            "time": pd.Timestamp("1953-02-01 00:00:00"),
            "fcst": 177.7419649757186,
            "fcst_lower": 116.953798899189,
            "fcst_upper": 238.53013105224818,
        },
        {
            "time": pd.Timestamp("1953-03-01 00:00:00"),
            "fcst": 211.7657477407197,
            "fcst_lower": 150.97758231390586,
            "fcst_upper": 272.55391316753355,
        },
        {
            "time": pd.Timestamp("1953-04-01 00:00:00"),
            "fcst": 237.95832780274853,
            "fcst_lower": 177.17016286037972,
            "fcst_upper": 298.74649274511734,
        },
        {
            "time": pd.Timestamp("1953-05-01 00:00:00"),
            "fcst": 232.91969102352166,
            "fcst_lower": 172.1315264423677,
            "fcst_upper": 293.7078556046756,
        },
        {
            "time": pd.Timestamp("1953-06-01 00:00:00"),
            "fcst": 228.4605400761027,
            "fcst_lower": 167.67237576427993,
            "fcst_upper": 289.24870438792544,
        },
        {
            "time": pd.Timestamp("1953-07-01 00:00:00"),
            "fcst": 248.91602032670454,
            "fcst_lower": 188.1278562157022,
            "fcst_upper": 309.7041844377069,
        },
        {
            "time": pd.Timestamp("1953-08-01 00:00:00"),
            "fcst": 267.066835347853,
            "fcst_lower": 206.27867138658758,
            "fcst_upper": 327.8549993091184,
        },
        {
            "time": pd.Timestamp("1953-09-01 00:00:00"),
            "fcst": 272.46619776983084,
            "fcst_lower": 211.67803392021324,
            "fcst_upper": 333.25436161944845,
        },
        {
            "time": pd.Timestamp("1953-10-01 00:00:00"),
            "fcst": 222.97194293233372,
            "fcst_lower": 162.18377916596359,
            "fcst_upper": 283.76010669870385,
        },
        {
            "time": pd.Timestamp("1953-11-01 00:00:00"),
            "fcst": 212.9913800856689,
            "fcst_lower": 152.2032163813703,
            "fcst_upper": 273.77954378996753,
        },
        {
            "time": pd.Timestamp("1953-12-01 00:00:00"),
            "fcst": 166.2121528915526,
            "fcst_lower": 105.42398923353613,
            "fcst_upper": 227.00031654956905,
        },
        {
            "time": pd.Timestamp("1954-01-01 00:00:00"),
            "fcst": 221.08105573624715,
            "fcst_lower": 160.29289211273988,
            "fcst_upper": 281.8692193597544,
        },
        {
            "time": pd.Timestamp("1954-02-01 00:00:00"),
            "fcst": 187.82797877201423,
            "fcst_lower": 127.03981517423793,
            "fcst_upper": 248.61614236979054,
        },
        {
            "time": pd.Timestamp("1954-03-01 00:00:00"),
            "fcst": 195.73568473628217,
            "fcst_lower": 134.94752115769154,
            "fcst_upper": 256.5238483148728,
        },
        {
            "time": pd.Timestamp("1954-04-01 00:00:00"),
            "fcst": 246.6173596818791,
            "fcst_lower": 185.8291961175938,
            "fcst_upper": 307.4055232461644,
        },
        {
            "time": pd.Timestamp("1954-05-01 00:00:00"),
            "fcst": 213.8540513995003,
            "fcst_lower": 153.0658878458814,
            "fcst_upper": 274.64221495311915,
        },
        {
            "time": pd.Timestamp("1954-06-01 00:00:00"),
            "fcst": 248.0765798423727,
            "fcst_lower": 187.288416296707,
            "fcst_upper": 308.8647433880384,
        },
        {
            "time": pd.Timestamp("1954-07-01 00:00:00"),
            "fcst": 263.52392042845304,
            "fcst_lower": 202.73575688871742,
            "fcst_upper": 324.31208396818863,
        },
        {
            "time": pd.Timestamp("1954-08-01 00:00:00"),
            "fcst": 317.204490044766,
            "fcst_lower": 256.416326509452,
            "fcst_upper": 377.99265358007995,
        },
        {
            "time": pd.Timestamp("1954-09-01 00:00:00"),
            "fcst": 276.36727700385717,
            "fcst_lower": 215.57911347184006,
            "fcst_upper": 337.1554405358743,
        },
        {
            "time": pd.Timestamp("1954-10-01 00:00:00"),
            "fcst": 260.1261005070125,
            "fcst_lower": 199.33793697745364,
            "fcst_upper": 320.91426403657135,
        },
        {
            "time": pd.Timestamp("1954-11-01 00:00:00"),
            "fcst": 216.34861852382815,
            "fcst_lower": 155.56045499610224,
            "fcst_upper": 277.13678205155406,
        },
        {
            "time": pd.Timestamp("1954-12-01 00:00:00"),
            "fcst": 203.8026254705358,
            "fcst_lower": 143.01446194417656,
            "fcst_upper": 264.590788996895,
        },
        {
            "time": pd.Timestamp("1955-01-01 00:00:00"),
            "fcst": 238.42873369055582,
            "fcst_lower": 177.6405701652156,
            "fcst_upper": 299.21689721589604,
        },
        {
            "time": pd.Timestamp("1955-02-01 00:00:00"),
            "fcst": 238.91922058333466,
            "fcst_lower": 178.13105705875427,
            "fcst_upper": 299.70738410791506,
        },
        {
            "time": pd.Timestamp("1955-03-01 00:00:00"),
            "fcst": 232.15654290166714,
            "fcst_lower": 171.3683793776533,
            "fcst_upper": 292.944706425681,
        },
        {
            "time": pd.Timestamp("1955-04-01 00:00:00"),
            "fcst": 280.96451957808154,
            "fcst_lower": 220.1763560544901,
            "fcst_upper": 341.752683101673,
        },
        {
            "time": pd.Timestamp("1955-05-01 00:00:00"),
            "fcst": 257.7202862742384,
            "fcst_lower": 196.93212275096192,
            "fcst_upper": 318.50844979751486,
        },
        {
            "time": pd.Timestamp("1955-06-01 00:00:00"),
            "fcst": 280.1292930749069,
            "fcst_lower": 219.34112955186532,
            "fcst_upper": 340.9174565979485,
        },
        {
            "time": pd.Timestamp("1955-07-01 00:00:00"),
            "fcst": 323.77188751363974,
            "fcst_lower": 262.9837239907733,
            "fcst_upper": 384.5600510365062,
        },
        {
            "time": pd.Timestamp("1955-08-01 00:00:00"),
            "fcst": 375.5012021316152,
            "fcst_lower": 314.71303860887923,
            "fcst_upper": 436.2893656543511,
        },
        {
            "time": pd.Timestamp("1955-09-01 00:00:00"),
            "fcst": 330.45065371688304,
            "fcst_lower": 269.66249019424447,
            "fcst_upper": 391.2388172395216,
        },
        {
            "time": pd.Timestamp("1955-10-01 00:00:00"),
            "fcst": 312.6648050820013,
            "fcst_lower": 251.8766415594353,
            "fcst_upper": 373.4529686045673,
        },
        {
            "time": pd.Timestamp("1955-11-01 00:00:00"),
            "fcst": 258.6325461215688,
            "fcst_lower": 197.84438259905693,
            "fcst_upper": 319.42070964408066,
        },
        {
            "time": pd.Timestamp("1955-12-01 00:00:00"),
            "fcst": 235.86564530137574,
            "fcst_lower": 175.07748177890426,
            "fcst_upper": 296.6538088238472,
        },
        {
            "time": pd.Timestamp("1956-01-01 00:00:00"),
            "fcst": 294.94080808729143,
            "fcst_lower": 234.15264456485005,
            "fcst_upper": 355.7289716097328,
        },
        {
            "time": pd.Timestamp("1956-02-01 00:00:00"),
            "fcst": 271.70747129501024,
            "fcst_lower": 210.91930777259125,
            "fcst_upper": 332.4956348174292,
        },
        {
            "time": pd.Timestamp("1956-03-01 00:00:00"),
            "fcst": 284.8894558755466,
            "fcst_lower": 224.1012923531444,
            "fcst_upper": 345.67761939794883,
        },
        {
            "time": pd.Timestamp("1956-04-01 00:00:00"),
            "fcst": 325.7594794539503,
            "fcst_lower": 264.9713159315605,
            "fcst_upper": 386.54764297634006,
        },
        {
            "time": pd.Timestamp("1956-05-01 00:00:00"),
            "fcst": 303.8790205944456,
            "fcst_lower": 243.09085707205583,
            "fcst_upper": 364.66718411683536,
        },
        {
            "time": pd.Timestamp("1956-06-01 00:00:00"),
            "fcst": 327.8224332648391,
            "fcst_lower": 267.03426974244934,
            "fcst_upper": 388.61059678722887,
        },
        {
            "time": pd.Timestamp("1956-07-01 00:00:00"),
            "fcst": 387.3191590210848,
            "fcst_lower": 326.530995498695,
            "fcst_upper": 448.10732254347454,
        },
        {
            "time": pd.Timestamp("1956-08-01 00:00:00"),
            "fcst": 416.6816499516949,
            "fcst_lower": 355.89348642930514,
            "fcst_upper": 477.4698134740847,
        },
        {
            "time": pd.Timestamp("1956-09-01 00:00:00"),
            "fcst": 398.70650883375663,
            "fcst_lower": 337.91834531136686,
            "fcst_upper": 459.4946723561464,
        },
        {
            "time": pd.Timestamp("1956-10-01 00:00:00"),
            "fcst": 340.96941141178087,
            "fcst_lower": 280.1812478893911,
            "fcst_upper": 401.75757493417063,
        },
        {
            "time": pd.Timestamp("1956-11-01 00:00:00"),
            "fcst": 299.0396677611477,
            "fcst_lower": 238.25150423875795,
            "fcst_upper": 359.8278312835375,
        },
        {
            "time": pd.Timestamp("1956-12-01 00:00:00"),
            "fcst": 263.38472516050194,
            "fcst_lower": 202.59656163811218,
            "fcst_upper": 324.1728886828917,
        },
        {
            "time": pd.Timestamp("1957-01-01 00:00:00"),
            "fcst": 326.2012603176815,
            "fcst_lower": 265.4130967952917,
            "fcst_upper": 386.98942384007125,
        },
        {
            "time": pd.Timestamp("1957-02-01 00:00:00"),
            "fcst": 301.059982020002,
            "fcst_lower": 240.27181849761223,
            "fcst_upper": 361.84814554239176,
        },
        {
            "time": pd.Timestamp("1957-03-01 00:00:00"),
            "fcst": 307.58695762114746,
            "fcst_lower": 246.7987940987577,
            "fcst_upper": 368.3751211435372,
        },
        {
            "time": pd.Timestamp("1957-04-01 00:00:00"),
            "fcst": 371.7236809447925,
            "fcst_lower": 310.9355174224027,
            "fcst_upper": 432.51184446718224,
        },
        {
            "time": pd.Timestamp("1957-05-01 00:00:00"),
            "fcst": 331.30825739954514,
            "fcst_lower": 270.5200938771554,
            "fcst_upper": 392.0964209219349,
        },
        {
            "time": pd.Timestamp("1957-06-01 00:00:00"),
            "fcst": 372.1383605155684,
            "fcst_lower": 311.35019699317866,
            "fcst_upper": 432.9265240379582,
        },
        {
            "time": pd.Timestamp("1957-07-01 00:00:00"),
            "fcst": 433.28418069535934,
            "fcst_lower": 372.4960171729696,
            "fcst_upper": 494.0723442177491,
        },
        {
            "time": pd.Timestamp("1957-08-01 00:00:00"),
            "fcst": 471.99604626997774,
            "fcst_lower": 411.207882747588,
            "fcst_upper": 532.7842097923675,
        },
        {
            "time": pd.Timestamp("1957-09-01 00:00:00"),
            "fcst": 461.7375384808529,
            "fcst_lower": 400.9493749584631,
            "fcst_upper": 522.5257020032426,
        },
        {
            "time": pd.Timestamp("1957-10-01 00:00:00"),
            "fcst": 384.0182219526643,
            "fcst_lower": 323.23005843027454,
            "fcst_upper": 444.80638547505407,
        },
        {
            "time": pd.Timestamp("1957-11-01 00:00:00"),
            "fcst": 342.0640995662381,
            "fcst_lower": 281.27593604384833,
            "fcst_upper": 402.85226308862786,
        },
        {
            "time": pd.Timestamp("1957-12-01 00:00:00"),
            "fcst": 292.9115359604155,
            "fcst_lower": 232.12337243802574,
            "fcst_upper": 353.6996994828053,
        },
        {
            "time": pd.Timestamp("1958-01-01 00:00:00"),
            "fcst": 358.5066437814099,
            "fcst_lower": 297.7184802590201,
            "fcst_upper": 419.29480730379964,
        },
        {
            "time": pd.Timestamp("1958-02-01 00:00:00"),
            "fcst": 322.1227918937741,
            "fcst_lower": 261.3346283713843,
            "fcst_upper": 382.91095541616386,
        },
        {
            "time": pd.Timestamp("1958-03-01 00:00:00"),
            "fcst": 324.8723080815947,
            "fcst_lower": 264.08414455920496,
            "fcst_upper": 385.6604716039845,
        },
        {
            "time": pd.Timestamp("1958-04-01 00:00:00"),
            "fcst": 373.1949826857821,
            "fcst_lower": 312.40681916339236,
            "fcst_upper": 433.9831462081719,
        },
        {
            "time": pd.Timestamp("1958-05-01 00:00:00"),
            "fcst": 332.8829728970037,
            "fcst_lower": 272.09480937461393,
            "fcst_upper": 393.67113641939346,
        },
        {
            "time": pd.Timestamp("1958-06-01 00:00:00"),
            "fcst": 381.89299859284955,
            "fcst_lower": 321.1048350704598,
            "fcst_upper": 442.6811621152393,
        },
        {
            "time": pd.Timestamp("1958-07-01 00:00:00"),
            "fcst": 446.7155564920999,
            "fcst_lower": 385.9273929697101,
            "fcst_upper": 507.50372001448966,
        },
        {
            "time": pd.Timestamp("1958-08-01 00:00:00"),
            "fcst": 502.6844537687679,
            "fcst_lower": 441.89629024637816,
            "fcst_upper": 563.4726172911577,
        },
        {
            "time": pd.Timestamp("1958-09-01 00:00:00"),
            "fcst": 500.3607141468311,
            "fcst_lower": 439.57255062444136,
            "fcst_upper": 561.1488776692208,
        },
        {
            "time": pd.Timestamp("1958-10-01 00:00:00"),
            "fcst": 368.68671492844595,
            "fcst_lower": 307.8985514060562,
            "fcst_upper": 429.4748784508357,
        },
        {
            "time": pd.Timestamp("1958-11-01 00:00:00"),
            "fcst": 371.974401051855,
            "fcst_lower": 311.18623752946525,
            "fcst_upper": 432.7625645742448,
        },
        {
            "time": pd.Timestamp("1958-12-01 00:00:00"),
            "fcst": 279.72095413080376,
            "fcst_lower": 218.932790608414,
            "fcst_upper": 340.5091176531935,
        },
        {
            "time": pd.Timestamp("1959-01-01 00:00:00"),
            "fcst": 373.656947563427,
            "fcst_lower": 312.86878404103726,
            "fcst_upper": 434.4451110858168,
        },
        {
            "time": pd.Timestamp("1959-02-01 00:00:00"),
            "fcst": 337.3007528305821,
            "fcst_lower": 276.51258930819233,
            "fcst_upper": 398.08891635297186,
        },
        {
            "time": pd.Timestamp("1959-03-01 00:00:00"),
            "fcst": 354.59332155002505,
            "fcst_lower": 293.8051580276353,
            "fcst_upper": 415.3814850724148,
        },
        {
            "time": pd.Timestamp("1959-04-01 00:00:00"),
            "fcst": 420.0409061007712,
            "fcst_lower": 359.25274257838146,
            "fcst_upper": 480.829069623161,
        },
        {
            "time": pd.Timestamp("1959-05-01 00:00:00"),
            "fcst": 379.98272771878794,
            "fcst_lower": 319.1945641963982,
            "fcst_upper": 440.7708912411777,
        },
        {
            "time": pd.Timestamp("1959-06-01 00:00:00"),
            "fcst": 443.1740564357343,
            "fcst_lower": 382.38589291334455,
            "fcst_upper": 503.9622199581241,
        },
        {
            "time": pd.Timestamp("1959-07-01 00:00:00"),
            "fcst": 472.2328796575603,
            "fcst_lower": 411.44471613517055,
            "fcst_upper": 533.0210431799501,
        },
        {
            "time": pd.Timestamp("1959-08-01 00:00:00"),
            "fcst": 577.3857032885581,
            "fcst_lower": 516.5975397661684,
            "fcst_upper": 638.1738668109479,
        },
        {
            "time": pd.Timestamp("1959-09-01 00:00:00"),
            "fcst": 537.9078476419501,
            "fcst_lower": 477.1196841195603,
            "fcst_upper": 598.6960111643398,
        },
        {
            "time": pd.Timestamp("1959-10-01 00:00:00"),
            "fcst": 443.840206931614,
            "fcst_lower": 383.0520434092242,
            "fcst_upper": 504.62837045400374,
        },
        {
            "time": pd.Timestamp("1959-11-01 00:00:00"),
            "fcst": 401.74361834799936,
            "fcst_lower": 340.9554548256096,
            "fcst_upper": 462.5317818703891,
        },
        {
            "time": pd.Timestamp("1959-12-01 00:00:00"),
            "fcst": 349.02037060055704,
            "fcst_lower": 288.2322070781673,
            "fcst_upper": 409.8085341229468,
        },
        {
            "time": pd.Timestamp("1960-01-01 00:00:00"),
            "fcst": 432.9477609983596,
            "fcst_lower": 372.15959747596986,
            "fcst_upper": 493.7359245207494,
        },
        {
            "time": pd.Timestamp("1960-02-01 00:00:00"),
            "fcst": 397.5388056768658,
            "fcst_lower": 336.75064215447605,
            "fcst_upper": 458.3269691992556,
        },
        {
            "time": pd.Timestamp("1960-03-01 00:00:00"),
            "fcst": 397.6828749250387,
            "fcst_lower": 336.8947114026489,
            "fcst_upper": 458.47103844742844,
        },
        {
            "time": pd.Timestamp("1960-04-01 00:00:00"),
            "fcst": 424.1297588023324,
            "fcst_lower": 363.3415952799426,
            "fcst_upper": 484.91792232472216,
        },
        {
            "time": pd.Timestamp("1960-05-01 00:00:00"),
            "fcst": 472.9210680197455,
            "fcst_lower": 412.13290449735575,
            "fcst_upper": 533.7092315421353,
        },
        {
            "time": pd.Timestamp("1960-06-01 00:00:00"),
            "fcst": 465.9884988075222,
            "fcst_lower": 405.20033528513244,
            "fcst_upper": 526.7766623299119,
        },
        {
            "time": pd.Timestamp("1960-07-01 00:00:00"),
            "fcst": 564.7168052202932,
            "fcst_lower": 503.9286416979034,
            "fcst_upper": 625.5049687426829,
        },
        {
            "time": pd.Timestamp("1960-08-01 00:00:00"),
            "fcst": 630.2087363420145,
            "fcst_lower": 569.4205728196248,
            "fcst_upper": 690.9968998644042,
        },
        {
            "time": pd.Timestamp("1960-09-01 00:00:00"),
            "fcst": 592.6829862745113,
            "fcst_lower": 531.8948227521216,
            "fcst_upper": 653.471149796901,
        },
        {
            "time": pd.Timestamp("1960-10-01 00:00:00"),
            "fcst": 481.3478022088564,
            "fcst_lower": 420.55963868646666,
            "fcst_upper": 542.1359657312462,
        },
        {
            "time": pd.Timestamp("1960-11-01 00:00:00"),
            "fcst": 465.71698278583256,
            "fcst_lower": 404.9288192634428,
            "fcst_upper": 526.5051463082223,
        },
        {
            "time": pd.Timestamp("1960-12-01 00:00:00"),
            "fcst": 358.28660749941486,
            "fcst_lower": 297.4984439770251,
            "fcst_upper": 419.0747710218046,
        },
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 475.734999664335,
            "fcst_lower": 414.94683614194525,
            "fcst_upper": 536.5231631867248,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 454.9960131326432,
            "fcst_lower": 350.9406985933037,
            "fcst_upper": 559.0513276719827,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 464.83036926989587,
            "fcst_lower": 337.5891858591327,
            "fcst_upper": 592.071552680659,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 460.16695138848075,
            "fcst_lower": 310.6316031682349,
            "fcst_upper": 609.7022996087267,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 462.3783281205398,
            "fcst_lower": 294.62476708969064,
            "fcst_upper": 630.1318891513889,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 461.3297008742918,
            "fcst_lower": 276.654109966928,
            "fcst_upper": 646.0052917816556,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 461.82695631052394,
            "fcst_lower": 261.87302294007793,
            "fcst_upper": 661.78088968097,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 461.591159491638,
            "fcst_lower": 247.3497039224739,
            "fcst_upper": 675.832615060802,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 461.7029735327635,
            "fcst_lower": 234.11208345911712,
            "fcst_upper": 689.2938636064099,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 461.64995169874607,
            "fcst_lower": 221.43104743037904,
            "fcst_upper": 701.8688559671131,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 461.67509447021087,
            "fcst_lower": 209.4683909799995,
            "fcst_upper": 713.8817979604222,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 461.66317185439334,
            "fcst_lower": 198.00921052859343,
            "fcst_upper": 725.3171331801932,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 461.6688255178382,
            "fcst_lower": 187.04615729497976,
            "fcst_upper": 736.2914937406965,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 461.66614457006324,
            "fcst_lower": 176.49553139848467,
            "fcst_upper": 746.8367577416418,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 461.6674158662842,
            "fcst_lower": 166.32570802200962,
            "fcst_upper": 757.0091237105588,
        },
        {
            "time": pd.Timestamp("1962-04-01 00:00:00"),
            "fcst": 461.66681302198543,
            "fcst_lower": 156.49263999202753,
            "fcst_upper": 766.8409860519433,
        },
        {
            "time": pd.Timestamp("1962-05-01 00:00:00"),
            "fcst": 461.66709888868,
            "fcst_lower": 146.96759579695265,
            "fcst_upper": 776.3666019804074,
        },
        {
            "time": pd.Timestamp("1962-06-01 00:00:00"),
            "fcst": 461.6669633316759,
            "fcst_lower": 137.72205693628518,
            "fcst_upper": 785.6118697270666,
        },
        {
            "time": pd.Timestamp("1962-07-01 00:00:00"),
            "fcst": 461.66702761234137,
            "fcst_lower": 128.7333762035309,
            "fcst_upper": 794.6006790211518,
        },
        {
            "time": pd.Timestamp("1962-08-01 00:00:00"),
            "fcst": 461.6669971306707,
            "fcst_lower": 119.98097832591253,
            "fcst_upper": 803.3530159354289,
        },
        {
            "time": pd.Timestamp("1962-09-01 00:00:00"),
            "fcst": 461.6670115849742,
            "fcst_lower": 111.44729181160483,
            "fcst_upper": 811.8867313583436,
        },
        {
            "time": pd.Timestamp("1962-10-01 00:00:00"),
            "fcst": 461.66700473079317,
            "fcst_lower": 103.11663171244152,
            "fcst_upper": 820.2173777491448,
        },
        {
            "time": pd.Timestamp("1962-11-01 00:00:00"),
            "fcst": 461.66700798102227,
            "fcst_lower": 94.9751928349915,
            "fcst_upper": 828.358823127053,
        },
        {
            "time": pd.Timestamp("1962-12-01 00:00:00"),
            "fcst": 461.6670064397748,
            "fcst_lower": 87.01062404537282,
            "fcst_upper": 836.3233888341767,
        },
        {
            "time": pd.Timestamp("1963-01-01 00:00:00"),
            "fcst": 461.66700717062906,
            "fcst_lower": 79.21188259460115,
            "fcst_upper": 844.122131746657,
        },
        {
            "time": pd.Timestamp("1963-02-01 00:00:00"),
            "fcst": 461.6670068240605,
            "fcst_lower": 71.56901936341609,
            "fcst_upper": 851.7649942847049,
        },
        {
            "time": pd.Timestamp("1963-03-01 00:00:00"),
            "fcst": 461.6670069884021,
            "fcst_lower": 64.07304664895531,
            "fcst_upper": 859.2609673278489,
        },
        {
            "time": pd.Timestamp("1963-04-01 00:00:00"),
            "fcst": 461.66700691047186,
            "fcst_lower": 56.715806406470165,
            "fcst_upper": 866.6182074144735,
        },
        {
            "time": pd.Timestamp("1963-05-01 00:00:00"),
            "fcst": 461.6670069474261,
            "fcst_lower": 49.48986993667626,
            "fcst_upper": 873.8441439581759,
        },
        {
            "time": pd.Timestamp("1963-06-01 00:00:00"),
            "fcst": 461.6670069299025,
            "fcst_lower": 42.388448257749985,
            "fcst_upper": 880.945565602055,
        },
    ]
)

EXOG_FCST_15_SARIMA_PARAM_EXOG_MODEL_1 = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("2020-01-18 00:00:00"),
            "fcst": 1.0082317127144957,
            "fcst_lower": 0.9923439863354956,
            "fcst_upper": 1.0241194390934958,
        },
        {
            "time": pd.Timestamp("2020-01-19 00:00:00"),
            "fcst": 0.9991862948033454,
            "fcst_lower": 0.9832141399147633,
            "fcst_upper": 1.0151584496919277,
        },
        {
            "time": pd.Timestamp("2020-01-20 00:00:00"),
            "fcst": 1.0046506773970796,
            "fcst_lower": 0.9881041550167277,
            "fcst_upper": 1.0211971997774316,
        },
        {
            "time": pd.Timestamp("2020-01-21 00:00:00"),
            "fcst": 1.0027999940466874,
            "fcst_lower": 0.9851582626466864,
            "fcst_upper": 1.0204417254466884,
        },
        {
            "time": pd.Timestamp("2020-01-22 00:00:00"),
            "fcst": 1.003219426593839,
            "fcst_lower": 0.9849304220755777,
            "fcst_upper": 1.0215084311121003,
        },
        {
            "time": pd.Timestamp("2020-01-23 00:00:00"),
            "fcst": 1.0013563760320352,
            "fcst_lower": 0.9823976131938543,
            "fcst_upper": 1.020315138870216,
        },
        {
            "time": pd.Timestamp("2020-01-24 00:00:00"),
            "fcst": 1.0029118249312734,
            "fcst_lower": 0.9832559890968382,
            "fcst_upper": 1.0225676607657086,
        },
        {
            "time": pd.Timestamp("2020-01-25 00:00:00"),
            "fcst": 0.9990584720988192,
            "fcst_lower": 0.9787586813527127,
            "fcst_upper": 1.0193582628449256,
        },
        {
            "time": pd.Timestamp("2020-01-26 00:00:00"),
            "fcst": 1.0017823097118022,
            "fcst_lower": 0.980856283700758,
            "fcst_upper": 1.0227083357228464,
        },
        {
            "time": pd.Timestamp("2020-01-27 00:00:00"),
            "fcst": 1.0001623305902951,
            "fcst_lower": 0.9786235255394861,
            "fcst_upper": 1.0217011356411043,
        },
        {
            "time": pd.Timestamp("2020-01-28 00:00:00"),
            "fcst": 1.000457094995268,
            "fcst_lower": 0.9783247990068599,
            "fcst_upper": 1.022589390983676,
        },
        {
            "time": pd.Timestamp("2020-01-29 00:00:00"),
            "fcst": 1.0000817043750918,
            "fcst_lower": 0.977371398201776,
            "fcst_upper": 1.0227920105484076,
        },
        {
            "time": pd.Timestamp("2020-01-30 00:00:00"),
            "fcst": 0.9997321013059957,
            "fcst_lower": 0.9756282277596985,
            "fcst_upper": 1.0238359748522927,
        },
        {
            "time": pd.Timestamp("2020-01-31 00:00:00"),
            "fcst": 1.003367319788623,
            "fcst_lower": 0.9786659022295303,
            "fcst_upper": 1.0280687373477158,
        },
        {
            "time": pd.Timestamp("2020-02-01 00:00:00"),
            "fcst": 1.0022894278227508,
            "fcst_lower": 0.976892260431941,
            "fcst_upper": 1.0276865952135605,
        },
    ]
)

NONSEASONAL_INPUT = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1960-12-31 00:00:00"),
            1: pd.Timestamp("1961-01-31 00:00:00"),
            2: pd.Timestamp("1961-02-28 00:00:00"),
            3: pd.Timestamp("1961-03-31 00:00:00"),
            4: pd.Timestamp("1961-04-30 00:00:00"),
            5: pd.Timestamp("1961-05-31 00:00:00"),
            6: pd.Timestamp("1961-06-30 00:00:00"),
            7: pd.Timestamp("1961-07-31 00:00:00"),
            8: pd.Timestamp("1961-08-31 00:00:00"),
            9: pd.Timestamp("1961-09-30 00:00:00"),
            10: pd.Timestamp("1961-10-31 00:00:00"),
            11: pd.Timestamp("1961-11-30 00:00:00"),
            12: pd.Timestamp("1961-12-31 00:00:00"),
            13: pd.Timestamp("1962-01-31 00:00:00"),
            14: pd.Timestamp("1962-02-28 00:00:00"),
            15: pd.Timestamp("1962-03-31 00:00:00"),
            16: pd.Timestamp("1962-04-30 00:00:00"),
            17: pd.Timestamp("1962-05-31 00:00:00"),
            18: pd.Timestamp("1962-06-30 00:00:00"),
            19: pd.Timestamp("1962-07-31 00:00:00"),
            20: pd.Timestamp("1962-08-31 00:00:00"),
            21: pd.Timestamp("1962-09-30 00:00:00"),
            22: pd.Timestamp("1962-10-31 00:00:00"),
            23: pd.Timestamp("1962-11-30 00:00:00"),
            24: pd.Timestamp("1962-12-31 00:00:00"),
        },
        "y": {
            0: 0.41506547032298174,
            1: -0.5406062106254615,
            2: 0.11083671449243261,
            3: -0.11398908479210373,
            4: 0.48307065281000106,
            5: -0.3161130468562421,
            6: 0.5990983108480854,
            7: -0.08663517357344115,
            8: -0.09999762532731679,
            9: 1.0592252850641404,
            10: -0.1660776147823171,
            11: 0.9322497147884551,
            12: 0.03697191608164456,
            13: 0.7241544636986402,
            14: -0.7964571920055838,
            15: 1.0753387472642086,
            16: 1.3483162806264335,
            17: 0.3499265428611668,
            18: -0.07003020867307755,
            19: -1.9919572119735123,
            20: 1.1230705955752662,
            21: 2.112168748216511,
            22: 0.5453426700281295,
            23: 1.3077219291558078,
            24: 1.2449380568881798,
        },
    }
)

NONSEASONAL_FUTURE_DF = pd.DataFrame(
    {
        "ds": {
            0: pd.Timestamp("1963-01-31 00:00:00"),
            1: pd.Timestamp("1963-02-28 00:00:00"),
            2: pd.Timestamp("1963-03-31 00:00:00"),
            3: pd.Timestamp("1963-04-30 00:00:00"),
            4: pd.Timestamp("1963-05-31 00:00:00"),
            5: pd.Timestamp("1963-06-30 00:00:00"),
            6: pd.Timestamp("1963-07-31 00:00:00"),
            7: pd.Timestamp("1963-08-31 00:00:00"),
            8: pd.Timestamp("1963-09-30 00:00:00"),
            9: pd.Timestamp("1963-10-31 00:00:00"),
            10: pd.Timestamp("1963-11-30 00:00:00"),
            11: pd.Timestamp("1963-12-31 00:00:00"),
        }
    }
)

AIR_FCST_30_PROPHET_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 465.59528569048166,
            1: 459.9558291481247,
            2: 492.95627065480187,
            3: 491.39646681061055,
            4: 495.8164027430265,
            5: 536.723733599239,
            6: 576.3580878717815,
            7: 576.774767410605,
            8: 528.2798791132368,
            9: 493.04059333031705,
            10: 459.2124905191395,
            11: 488.56065439007415,
            12: 501.4478393337234,
            13: 495.30135257307614,
            14: 530.862962759873,
            15: 527.178674463527,
            16: 533.1498179102681,
            17: 572.763461207553,
            18: 613.2630760453825,
            19: 613.1841652926352,
            20: 565.1767551336386,
            21: 529.5362230989792,
            22: 496.63581791637984,
            23: 526.1280789406818,
            24: 537.2652818391174,
            25: 530.6716820769692,
            26: 568.7687595327632,
            27: 562.9589993161109,
            28: 570.4916281454283,
            29: 608.7966975832746,
        },
        "fcst_lower": {
            0: 435.7227955169751,
            1: 433.03706366553985,
            2: 463.2380158942223,
            3: 461.385597691946,
            4: 467.16226356625845,
            5: 505.0131481472155,
            6: 548.5305115754014,
            7: 549.5843511864674,
            8: 502.1042013702371,
            9: 465.4473773938255,
            10: 429.7216267443718,
            11: 459.3869910121299,
            12: 472.99261225208966,
            13: 467.2334155857151,
            14: 501.96626673567454,
            15: 500.1362058155516,
            16: 504.1302881271059,
            17: 544.6241869461372,
            18: 584.0450100717637,
            19: 584.1066024817961,
            20: 537.8220302644348,
            21: 498.7658984347239,
            22: 467.7583442404464,
            23: 496.21227014845556,
            24: 510.56633711316607,
            25: 499.48092003575675,
            26: 542.4142362169579,
            27: 533.22136091424,
            28: 542.7665402452914,
            29: 581.0751908444602,
        },
        "fcst_upper": {
            0: 493.42362207487463,
            1: 487.48619890349266,
            2: 520.8302015885779,
            3: 519.7151950182429,
            4: 523.3038803967601,
            5: 565.3458444494522,
            6: 605.3689473814483,
            7: 607.5326881691888,
            8: 557.5077000916897,
            9: 522.0729932348357,
            10: 486.5037455495359,
            11: 516.9593158035708,
            12: 529.8880747286842,
            13: 523.1933917687096,
            14: 558.6142240080726,
            15: 556.5583959018988,
            16: 559.6401054062931,
            17: 601.5975821122233,
            18: 641.4213271589108,
            19: 642.9538881677378,
            20: 593.1390965161879,
            21: 559.2586524345785,
            22: 525.82443333545,
            23: 554.3688117496768,
            24: 564.2766083727195,
            25: 559.1708161195501,
            26: 598.218095935576,
            27: 591.131489011433,
            28: 601.7309712860445,
            29: 637.9083803171933,
        },
    }
)

AIR_FCST_30_PROPHET_CAP_AND_FLOOR_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 475.1575442103092,
            1: 469.24179608421866,
            2: 503.11659609624536,
            3: 502.31359340950956,
            4: 506.85396492553156,
            5: 548.6845145501933,
            6: 588.6703496295718,
            7: 589.3272437420154,
            8: 541.0900404153592,
            9: 507.00020458085845,
            10: 473.2248193157536,
            11: 503.0391202867464,
            12: 516.0508016418704,
            13: 510.23415966933925,
            14: 546.491165453043,
            15: 542.9398772109357,
            16: 549.8053457737586,
            17: 589.4433541284543,
            18: 630.409646625312,
            19: 630.9017169479421,
            20: 583.9416416493654,
            21: 547.92435041299,
            22: 515.6912215970992,
            23: 545.1485026034558,
            24: 556.4324168509892,
            25: 550.7215796751234,
            26: 589.2719067529652,
            27: 582.9292377569677,
            28: 592.0798841970798,
            29: 629.4582350097522,
        },
        "fcst_lower": {
            0: 445.3418598594581,
            1: 442.37954981156753,
            2: 473.4261904547741,
            3: 472.3495518433545,
            4: 478.24327458785837,
            5: 517.0701518389475,
            6: 560.8025261752462,
            7: 562.294897734461,
            8: 514.9341473365542,
            9: 479.45553157412814,
            10: 443.9014610568383,
            11: 473.9696193939736,
            12: 487.52992050249156,
            13: 481.98817396338916,
            14: 516.8915086392954,
            15: 515.3912239207851,
            16: 520.840187606289,
            17: 560.923719628996,
            18: 601.2325344593912,
            19: 601.8209664312715,
            20: 556.6303990916655,
            21: 517.44076619717,
            22: 486.8662571363469,
            23: 515.3865991708863,
            24: 529.6661865746032,
            25: 519.649083216983,
            26: 563.0662280239728,
            27: 552.6646271671854,
            28: 564.7986165777385,
            29: 601.7352512977587,
        },
        "fcst_upper": {
            0: 502.93296195510214,
            1: 496.7902750763139,
            2: 531.0465021126715,
            3: 530.5185358828127,
            4: 534.2851110611824,
            5: 577.5091588015033,
            6: 617.6355544964309,
            7: 620.0970379564785,
            8: 570.3684024348204,
            9: 536.0907703966614,
            10: 500.19801938833615,
            11: 531.3327035010188,
            12: 544.6015513834924,
            13: 537.7868775369062,
            14: 573.8837866856328,
            15: 572.0145294514786,
            16: 575.841124061249,
            17: 617.9573369540493,
            18: 658.7007736374042,
            19: 660.742916185678,
            20: 611.7835417415275,
            21: 577.5572482204245,
            22: 544.3169813165081,
            23: 573.2953511012179,
            24: 583.6627573206079,
            25: 578.8415342181587,
            26: 618.0269834406183,
            27: 610.4770092899499,
            28: 623.1408929198517,
            29: 657.7775827360285,
        },
    }
)

PEYTON_FCST_30_PROPHET_CAP_AND_FLOOR_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 9.86101525181464,
            1: 9.89003240961042,
            2: 9.930278231638619,
            3: 9.784139043582456,
            4: 10.181742594673318,
            5: 10.3023632182167,
            6: 10.050429250465271,
            7: 9.861015251814367,
            8: 9.890032409610013,
            9: 9.930278231638434,
            10: 9.784139043582357,
            11: 10.181742594672786,
            12: 10.302363218216716,
            13: 10.050429250464921,
            14: 9.861015251814095,
            15: 9.890032409610109,
            16: 9.930278231638638,
            17: 9.784139043582408,
            18: 10.181742594673226,
            19: 10.302363218216732,
            20: 10.050429250464944,
            21: 9.861015251814528,
            22: 9.890032409610107,
            23: 9.93027823163856,
            24: 9.78413904358252,
            25: 10.18174259467248,
            26: 10.302363218216582,
            27: 10.050429250464951,
            28: 9.861015251814257,
            29: 9.890032409610107,
        },
        "fcst_lower": {
            0: 7.523186110258121,
            1: 7.575393432516099,
            2: 7.6355617294543,
            3: 7.6252084389987855,
            4: 7.9639238986736665,
            5: 7.876072621875117,
            6: 7.953465126288597,
            7: 7.652371536106707,
            8: 7.619598524085517,
            9: 7.727352392038587,
            10: 7.590527949007888,
            11: 8.023666367393657,
            12: 8.020968141056638,
            13: 7.747017837209666,
            14: 7.629569241285518,
            15: 7.83573566653282,
            16: 7.870761785182868,
            17: 7.392173418278055,
            18: 8.072712388162977,
            19: 8.164211695364877,
            20: 7.753943792351764,
            21: 7.6251760230290575,
            22: 7.639626386920325,
            23: 7.6301289075174115,
            24: 7.641139952361675,
            25: 8.028837974985159,
            26: 8.01673544100944,
            27: 7.683822540708778,
            28: 7.561195117618204,
            29: 7.99594817226005,
        },
        "fcst_upper": {
            0: 12.089732898097001,
            1: 11.984250766806364,
            2: 12.19042330428994,
            3: 12.153367218555255,
            4: 12.487552941138016,
            5: 12.479388409934085,
            6: 12.237686150431063,
            7: 12.06206958905758,
            8: 11.96067710177131,
            9: 12.055337761921143,
            10: 12.037647958894585,
            11: 12.282405332374646,
            12: 12.29542065922854,
            13: 12.206035177309621,
            14: 12.103815485014408,
            15: 12.035622751632467,
            16: 12.198735175562952,
            17: 11.922095489765741,
            18: 12.383072433918803,
            19: 12.435352494215513,
            20: 12.147049325915042,
            21: 11.962957076996277,
            22: 12.081392901358322,
            23: 12.175395109201133,
            24: 11.998325143455052,
            25: 12.441980195057987,
            26: 12.502881352584524,
            27: 12.281079278077286,
            28: 12.01665981197022,
            29: 12.021690364457857,
        },
    }
)

AIR_FCST_30_PROPHET_INCL_HIST_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1949-01-01 00:00:00"),
            1: pd.Timestamp("1949-02-01 00:00:00"),
            2: pd.Timestamp("1949-03-01 00:00:00"),
            3: pd.Timestamp("1949-04-01 00:00:00"),
            4: pd.Timestamp("1949-05-01 00:00:00"),
            5: pd.Timestamp("1949-06-01 00:00:00"),
            6: pd.Timestamp("1949-07-01 00:00:00"),
            7: pd.Timestamp("1949-08-01 00:00:00"),
            8: pd.Timestamp("1949-09-01 00:00:00"),
            9: pd.Timestamp("1949-10-01 00:00:00"),
            10: pd.Timestamp("1949-11-01 00:00:00"),
            11: pd.Timestamp("1949-12-01 00:00:00"),
            12: pd.Timestamp("1950-01-01 00:00:00"),
            13: pd.Timestamp("1950-02-01 00:00:00"),
            14: pd.Timestamp("1950-03-01 00:00:00"),
            15: pd.Timestamp("1950-04-01 00:00:00"),
            16: pd.Timestamp("1950-05-01 00:00:00"),
            17: pd.Timestamp("1950-06-01 00:00:00"),
            18: pd.Timestamp("1950-07-01 00:00:00"),
            19: pd.Timestamp("1950-08-01 00:00:00"),
            20: pd.Timestamp("1950-09-01 00:00:00"),
            21: pd.Timestamp("1950-10-01 00:00:00"),
            22: pd.Timestamp("1950-11-01 00:00:00"),
            23: pd.Timestamp("1950-12-01 00:00:00"),
            24: pd.Timestamp("1951-01-01 00:00:00"),
            25: pd.Timestamp("1951-02-01 00:00:00"),
            26: pd.Timestamp("1951-03-01 00:00:00"),
            27: pd.Timestamp("1951-04-01 00:00:00"),
            28: pd.Timestamp("1951-05-01 00:00:00"),
            29: pd.Timestamp("1951-06-01 00:00:00"),
            30: pd.Timestamp("1951-07-01 00:00:00"),
            31: pd.Timestamp("1951-08-01 00:00:00"),
            32: pd.Timestamp("1951-09-01 00:00:00"),
            33: pd.Timestamp("1951-10-01 00:00:00"),
            34: pd.Timestamp("1951-11-01 00:00:00"),
            35: pd.Timestamp("1951-12-01 00:00:00"),
            36: pd.Timestamp("1952-01-01 00:00:00"),
            37: pd.Timestamp("1952-02-01 00:00:00"),
            38: pd.Timestamp("1952-03-01 00:00:00"),
            39: pd.Timestamp("1952-04-01 00:00:00"),
            40: pd.Timestamp("1952-05-01 00:00:00"),
            41: pd.Timestamp("1952-06-01 00:00:00"),
            42: pd.Timestamp("1952-07-01 00:00:00"),
            43: pd.Timestamp("1952-08-01 00:00:00"),
            44: pd.Timestamp("1952-09-01 00:00:00"),
            45: pd.Timestamp("1952-10-01 00:00:00"),
            46: pd.Timestamp("1952-11-01 00:00:00"),
            47: pd.Timestamp("1952-12-01 00:00:00"),
            48: pd.Timestamp("1953-01-01 00:00:00"),
            49: pd.Timestamp("1953-02-01 00:00:00"),
            50: pd.Timestamp("1953-03-01 00:00:00"),
            51: pd.Timestamp("1953-04-01 00:00:00"),
            52: pd.Timestamp("1953-05-01 00:00:00"),
            53: pd.Timestamp("1953-06-01 00:00:00"),
            54: pd.Timestamp("1953-07-01 00:00:00"),
            55: pd.Timestamp("1953-08-01 00:00:00"),
            56: pd.Timestamp("1953-09-01 00:00:00"),
            57: pd.Timestamp("1953-10-01 00:00:00"),
            58: pd.Timestamp("1953-11-01 00:00:00"),
            59: pd.Timestamp("1953-12-01 00:00:00"),
            60: pd.Timestamp("1954-01-01 00:00:00"),
            61: pd.Timestamp("1954-02-01 00:00:00"),
            62: pd.Timestamp("1954-03-01 00:00:00"),
            63: pd.Timestamp("1954-04-01 00:00:00"),
            64: pd.Timestamp("1954-05-01 00:00:00"),
            65: pd.Timestamp("1954-06-01 00:00:00"),
            66: pd.Timestamp("1954-07-01 00:00:00"),
            67: pd.Timestamp("1954-08-01 00:00:00"),
            68: pd.Timestamp("1954-09-01 00:00:00"),
            69: pd.Timestamp("1954-10-01 00:00:00"),
            70: pd.Timestamp("1954-11-01 00:00:00"),
            71: pd.Timestamp("1954-12-01 00:00:00"),
            72: pd.Timestamp("1955-01-01 00:00:00"),
            73: pd.Timestamp("1955-02-01 00:00:00"),
            74: pd.Timestamp("1955-03-01 00:00:00"),
            75: pd.Timestamp("1955-04-01 00:00:00"),
            76: pd.Timestamp("1955-05-01 00:00:00"),
            77: pd.Timestamp("1955-06-01 00:00:00"),
            78: pd.Timestamp("1955-07-01 00:00:00"),
            79: pd.Timestamp("1955-08-01 00:00:00"),
            80: pd.Timestamp("1955-09-01 00:00:00"),
            81: pd.Timestamp("1955-10-01 00:00:00"),
            82: pd.Timestamp("1955-11-01 00:00:00"),
            83: pd.Timestamp("1955-12-01 00:00:00"),
            84: pd.Timestamp("1956-01-01 00:00:00"),
            85: pd.Timestamp("1956-02-01 00:00:00"),
            86: pd.Timestamp("1956-03-01 00:00:00"),
            87: pd.Timestamp("1956-04-01 00:00:00"),
            88: pd.Timestamp("1956-05-01 00:00:00"),
            89: pd.Timestamp("1956-06-01 00:00:00"),
            90: pd.Timestamp("1956-07-01 00:00:00"),
            91: pd.Timestamp("1956-08-01 00:00:00"),
            92: pd.Timestamp("1956-09-01 00:00:00"),
            93: pd.Timestamp("1956-10-01 00:00:00"),
            94: pd.Timestamp("1956-11-01 00:00:00"),
            95: pd.Timestamp("1956-12-01 00:00:00"),
            96: pd.Timestamp("1957-01-01 00:00:00"),
            97: pd.Timestamp("1957-02-01 00:00:00"),
            98: pd.Timestamp("1957-03-01 00:00:00"),
            99: pd.Timestamp("1957-04-01 00:00:00"),
            100: pd.Timestamp("1957-05-01 00:00:00"),
            101: pd.Timestamp("1957-06-01 00:00:00"),
            102: pd.Timestamp("1957-07-01 00:00:00"),
            103: pd.Timestamp("1957-08-01 00:00:00"),
            104: pd.Timestamp("1957-09-01 00:00:00"),
            105: pd.Timestamp("1957-10-01 00:00:00"),
            106: pd.Timestamp("1957-11-01 00:00:00"),
            107: pd.Timestamp("1957-12-01 00:00:00"),
            108: pd.Timestamp("1958-01-01 00:00:00"),
            109: pd.Timestamp("1958-02-01 00:00:00"),
            110: pd.Timestamp("1958-03-01 00:00:00"),
            111: pd.Timestamp("1958-04-01 00:00:00"),
            112: pd.Timestamp("1958-05-01 00:00:00"),
            113: pd.Timestamp("1958-06-01 00:00:00"),
            114: pd.Timestamp("1958-07-01 00:00:00"),
            115: pd.Timestamp("1958-08-01 00:00:00"),
            116: pd.Timestamp("1958-09-01 00:00:00"),
            117: pd.Timestamp("1958-10-01 00:00:00"),
            118: pd.Timestamp("1958-11-01 00:00:00"),
            119: pd.Timestamp("1958-12-01 00:00:00"),
            120: pd.Timestamp("1959-01-01 00:00:00"),
            121: pd.Timestamp("1959-02-01 00:00:00"),
            122: pd.Timestamp("1959-03-01 00:00:00"),
            123: pd.Timestamp("1959-04-01 00:00:00"),
            124: pd.Timestamp("1959-05-01 00:00:00"),
            125: pd.Timestamp("1959-06-01 00:00:00"),
            126: pd.Timestamp("1959-07-01 00:00:00"),
            127: pd.Timestamp("1959-08-01 00:00:00"),
            128: pd.Timestamp("1959-09-01 00:00:00"),
            129: pd.Timestamp("1959-10-01 00:00:00"),
            130: pd.Timestamp("1959-11-01 00:00:00"),
            131: pd.Timestamp("1959-12-01 00:00:00"),
            132: pd.Timestamp("1960-01-01 00:00:00"),
            133: pd.Timestamp("1960-02-01 00:00:00"),
            134: pd.Timestamp("1960-03-01 00:00:00"),
            135: pd.Timestamp("1960-04-01 00:00:00"),
            136: pd.Timestamp("1960-05-01 00:00:00"),
            137: pd.Timestamp("1960-06-01 00:00:00"),
            138: pd.Timestamp("1960-07-01 00:00:00"),
            139: pd.Timestamp("1960-08-01 00:00:00"),
            140: pd.Timestamp("1960-09-01 00:00:00"),
            141: pd.Timestamp("1960-10-01 00:00:00"),
            142: pd.Timestamp("1960-11-01 00:00:00"),
            143: pd.Timestamp("1960-12-01 00:00:00"),
            144: pd.Timestamp("1961-01-01 00:00:00"),
            145: pd.Timestamp("1961-02-01 00:00:00"),
            146: pd.Timestamp("1961-03-01 00:00:00"),
            147: pd.Timestamp("1961-04-01 00:00:00"),
            148: pd.Timestamp("1961-05-01 00:00:00"),
            149: pd.Timestamp("1961-06-01 00:00:00"),
            150: pd.Timestamp("1961-07-01 00:00:00"),
            151: pd.Timestamp("1961-08-01 00:00:00"),
            152: pd.Timestamp("1961-09-01 00:00:00"),
            153: pd.Timestamp("1961-10-01 00:00:00"),
            154: pd.Timestamp("1961-11-01 00:00:00"),
            155: pd.Timestamp("1961-12-01 00:00:00"),
            156: pd.Timestamp("1962-01-01 00:00:00"),
            157: pd.Timestamp("1962-02-01 00:00:00"),
            158: pd.Timestamp("1962-03-01 00:00:00"),
            159: pd.Timestamp("1962-04-01 00:00:00"),
            160: pd.Timestamp("1962-05-01 00:00:00"),
            161: pd.Timestamp("1962-06-01 00:00:00"),
            162: pd.Timestamp("1962-07-01 00:00:00"),
            163: pd.Timestamp("1962-08-01 00:00:00"),
            164: pd.Timestamp("1962-09-01 00:00:00"),
            165: pd.Timestamp("1962-10-01 00:00:00"),
            166: pd.Timestamp("1962-11-01 00:00:00"),
            167: pd.Timestamp("1962-12-01 00:00:00"),
            168: pd.Timestamp("1963-01-01 00:00:00"),
            169: pd.Timestamp("1963-02-01 00:00:00"),
            170: pd.Timestamp("1963-03-01 00:00:00"),
            171: pd.Timestamp("1963-04-01 00:00:00"),
            172: pd.Timestamp("1963-05-01 00:00:00"),
            173: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 84.82713996622525,
            1: 78.24556990885091,
            2: 110.39507017615126,
            3: 107.89315281694103,
            4: 111.40136599288164,
            5: 151.36658333407547,
            6: 190.08921485228058,
            7: 189.56378087828537,
            8: 140.12677906809756,
            9: 103.97577053084026,
            10: 69.20555419659107,
            11: 97.64199530326354,
            12: 109.58706672384726,
            13: 102.49846644013039,
            14: 137.20913538027463,
            15: 132.5827335492101,
            16: 137.64215422040246,
            17: 176.31368398296644,
            18: 215.90157604524956,
            19: 214.88055174751753,
            20: 165.93102804353725,
            21: 129.37877322340452,
            22: 95.53625449581821,
            23: 124.11679273464871,
            24: 134.311882087584,
            25: 126.7761687799386,
            26: 164.0223049688268,
            27: 157.27043120667446,
            28: 163.8913372675921,
            29: 201.25429317809787,
            30: 241.7018989572827,
            31: 240.18370293200667,
            32: 191.7408539458812,
            33: 154.8000112054635,
            34: 121.89410719468887,
            35: 150.5615090229799,
            36: 159.0026457389163,
            37: 151.080063697262,
            38: 185.96938277248597,
            39: 185.58930116153655,
            40: 187.5578075240549,
            41: 228.8011362549425,
            42: 266.6531983389425,
            43: 266.6209301528497,
            44: 216.71573404290558,
            45: 180.97873028498896,
            46: 145.2911803543033,
            47: 173.52648225449315,
            48: 187.21527988380893,
            49: 180.63371150687743,
            50: 212.78321329201103,
            51: 210.2813905574789,
            52: 213.78969530571166,
            53: 253.75500727159042,
            54: 292.47773035993964,
            55: 291.95239100842906,
            56: 242.63914194729588,
            57: 206.60789413492213,
            58: 171.96143055997842,
            59: 200.5176324014636,
            60: 212.77349209801784,
            61: 205.99568009027914,
            62: 240.9870610216413,
            63: 236.67144747820177,
            64: 242.0316310084053,
            65: 281.2558273795679,
            66: 321.3785580953476,
            67: 320.91020041647926,
            68: 272.513343331368,
            69: 236.71606305729313,
            70: 203.65368469397202,
            71: 232.9891974788594,
            72: 243.96442719656739,
            73: 237.2088542536957,
            74: 275.2844261521004,
            75: 269.4508562111982,
            76: 276.9604433718847,
            77: 315.2417030854795,
            78: 356.57798996443285,
            79: 356.0019068518603,
            80: 308.50117077844465,
            81: 272.4720501835022,
            82: 240.50825905638914,
            83: 270.08738303958995,
            84: 279.4706326489337,
            85: 272.49016268770674,
            86: 308.2608124188191,
            87: 308.82284288829464,
            88: 311.7030706164595,
            89: 353.88851142518917,
            90: 392.6522948019699,
            91: 393.56213861841616,
            92: 344.59905457621164,
            93: 309.7737721741758,
            94: 275.02833431123145,
            95: 304.1753568168637,
            96: 318.80626573846854,
            97: 313.1668086470938,
            98: 346.1672496578828,
            99: 344.60744526467255,
            100: 349.02738066578,
            101: 389.93471096853324,
            102: 429.5690647054662,
            103: 429.9857436908262,
            104: 381.49085483999505,
            105: 346.2515685214679,
            106: 312.42346546149275,
            107: 341.7716290916592,
            108: 354.658813786516,
            109: 348.51232677707503,
            110: 384.0739367976919,
            111: 380.3896483173692,
            112: 386.36079158606304,
            113: 425.97443469937105,
            114: 466.4740493591522,
            115: 466.39513860640415,
            116: 418.3877284474073,
            117: 382.74719641274834,
            118: 349.84679123014877,
            119: 379.3390522544518,
            120: 390.4762551528871,
            121: 383.88265539073996,
            122: 421.97973284653256,
            123: 416.16997262988133,
            124: 423.702601459198,
            125: 462.00767089704607,
            126: 503.3669994446303,
            127: 502.79091694669523,
            128: 455.2901814879176,
            129: 419.26106148778285,
            130: 387.2972709753104,
            131: 416.8763955438906,
            132: 426.25964575812486,
            133: 419.2791764017902,
            134: 455.04982669876756,
            135: 455.6118577731363,
            136: 458.49208608918974,
            137: 500.67752750540217,
            138: 539.441311470067,
            139: 540.3511558939996,
            140: 491.3880723940807,
            141: 456.56279051683265,
            142: 421.8173531961696,
            143: 450.9643762265932,
            144: 465.59528569048166,
            145: 459.9558291481247,
            146: 492.95627065480187,
            147: 491.39646681061055,
            148: 495.8164027430265,
            149: 536.723733599239,
            150: 576.3580878717815,
            151: 576.774767410605,
            152: 528.2798791132368,
            153: 493.04059333031705,
            154: 459.2124905191395,
            155: 488.56065439007415,
            156: 501.4478393337234,
            157: 495.30135257307614,
            158: 530.862962759873,
            159: 527.178674463527,
            160: 533.1498179102681,
            161: 572.763461207553,
            162: 613.2630760453825,
            163: 613.1841652926352,
            164: 565.1767551336386,
            165: 529.5362230989792,
            166: 496.63581791637984,
            167: 526.1280789406818,
            168: 537.2652818391174,
            169: 530.6716820769692,
            170: 568.7687595327632,
            171: 562.9589993161109,
            172: 570.4916281454283,
            173: 608.7966975832746,
        },
        "fcst_lower": {
            0: 57.07534737227605,
            1: 50.67812972727987,
            2: 81.83667348404623,
            3: 80.5032172770161,
            4: 85.7715547128157,
            5: 122.84308742593484,
            6: 160.83529318426346,
            7: 162.5300244576596,
            8: 112.15920665557877,
            9: 77.14864462381344,
            10: 41.23375295131777,
            11: 69.21638952894217,
            12: 78.84325092372005,
            13: 75.25141720342873,
            14: 109.97590851326228,
            15: 103.13528012827027,
            16: 108.72340372518194,
            17: 147.2866255742716,
            18: 186.5124833254854,
            19: 188.1708499083023,
            20: 136.82425453997425,
            21: 99.85540885300391,
            22: 65.56834479488684,
            23: 96.10566220996122,
            24: 105.90554198231416,
            25: 97.6245842764528,
            26: 136.5401479198438,
            27: 127.51800818605868,
            28: 134.4583917167556,
            29: 174.09850223458787,
            30: 213.62165203762683,
            31: 210.59425693233644,
            32: 164.52063994760962,
            33: 126.10566276573148,
            34: 94.04922913443495,
            35: 119.69116164189211,
            36: 132.5451122232673,
            37: 121.93182322538472,
            38: 159.35053728010354,
            39: 156.68607213069345,
            40: 159.84493441590254,
            41: 199.38750450672907,
            42: 238.07320989450577,
            43: 238.2436015998504,
            44: 189.5296460525659,
            45: 153.9331697277263,
            46: 116.98408199834255,
            47: 145.47556870068826,
            48: 158.6933598543773,
            49: 150.74193718780538,
            50: 184.94076359311634,
            51: 183.495860198857,
            52: 186.44122443883208,
            53: 226.49439645246196,
            54: 262.96564826687467,
            55: 261.9068217833312,
            56: 213.40154612960686,
            57: 177.48664424590527,
            58: 142.781784374279,
            59: 169.56178719604532,
            60: 183.2117738519203,
            61: 176.86201110497993,
            62: 210.81942887246052,
            63: 206.67417108340345,
            64: 215.144964672804,
            65: 252.03245550694058,
            66: 291.3631390333255,
            67: 291.35754257685613,
            68: 246.12212348282225,
            69: 207.8305704911925,
            70: 176.68789785570388,
            71: 204.24527555657596,
            72: 216.05398340487173,
            73: 209.41170786777803,
            74: 246.96465826952135,
            75: 240.59878911463227,
            76: 246.74855769246832,
            77: 287.00823734182745,
            78: 327.5795381947413,
            79: 328.616783832251,
            80: 279.67038730691667,
            81: 242.25490818294526,
            82: 212.28100783170862,
            83: 242.15346989014807,
            84: 251.846502176027,
            85: 243.22252491484022,
            86: 278.19294862514073,
            87: 278.73439476689555,
            88: 283.5451610134779,
            89: 325.451397323253,
            90: 363.0289279044889,
            91: 366.8673094493671,
            92: 317.2636414711618,
            93: 281.69762522476935,
            94: 247.7657798405009,
            95: 276.62862018745193,
            96: 287.88646885252354,
            97: 283.3695695356206,
            98: 318.0895507160994,
            99: 315.2438465790889,
            100: 319.8986820626794,
            101: 362.93920784380276,
            102: 400.75785047338894,
            103: 401.22403145738485,
            104: 352.95935145010503,
            105: 318.5118345707204,
            106: 284.9880341838398,
            107: 312.69789126814703,
            108: 326.2278676031517,
            109: 319.04540899349144,
            110: 355.67188192967586,
            111: 353.78255179958154,
            112: 357.51960426604353,
            113: 397.7452590018106,
            114: 437.6676452098293,
            115: 437.67399205350586,
            116: 389.05993353428477,
            117: 354.0127728514775,
            118: 322.10572744220724,
            119: 351.5171668339378,
            120: 361.66944567390493,
            121: 356.13392133655606,
            122: 394.1542301246463,
            123: 388.87614052033007,
            124: 394.5255295086753,
            125: 431.2352836689995,
            126: 473.93485265479256,
            127: 473.8645632632011,
            128: 425.60412147855726,
            129: 391.11425265526805,
            130: 358.6679164627638,
            131: 387.4241106979646,
            132: 398.6675604333335,
            133: 391.67833256897575,
            134: 427.7583326092743,
            135: 426.12274689825296,
            136: 431.37408411421524,
            137: 471.0807198025017,
            138: 511.92997884829083,
            139: 511.56012910967695,
            140: 463.0963132871096,
            141: 428.1229231280904,
            142: 393.5597601309849,
            143: 421.5313200210364,
            144: 436.2023060093481,
            145: 433.7023809526974,
            146: 465.36968260107886,
            147: 462.34023215151126,
            148: 466.00776637685084,
            149: 506.51193431975986,
            150: 547.6664202076362,
            151: 547.9638469105741,
            152: 500.2663441240114,
            153: 464.90602976671704,
            154: 431.1213705820963,
            155: 460.05049683740015,
            156: 473.66664007925476,
            157: 466.4945548693236,
            158: 500.0304064165404,
            159: 496.97377501037863,
            160: 505.166214305167,
            161: 543.3502399208718,
            162: 584.6136366711781,
            163: 584.5205809013729,
            164: 536.3530007631742,
            165: 501.7513158619169,
            166: 468.98106917641394,
            167: 498.46399656060396,
            168: 508.3366455692578,
            169: 500.76989327249726,
            170: 539.8700305432857,
            171: 535.6003348723025,
            172: 541.2038595935002,
            173: 579.091762857722,
        },
        "fcst_upper": {
            0: 114.65871545212238,
            1: 105.11408726065488,
            2: 137.7927580724369,
            3: 135.85264038632235,
            4: 140.23665160117415,
            5: 179.43857582313132,
            6: 218.79659249264927,
            7: 217.34793178555714,
            8: 169.53164962634727,
            9: 132.59816962376414,
            10: 97.94776689140647,
            11: 127.06034763526566,
            12: 139.21803088945842,
            13: 130.5606671164681,
            14: 164.36795331693173,
            15: 159.96704641828876,
            16: 163.79048274267345,
            17: 203.07574967903864,
            18: 247.1028606172059,
            19: 243.27042436458447,
            20: 193.29696292653898,
            21: 157.61742866801754,
            22: 125.49424964769159,
            23: 155.28508816535003,
            24: 166.24399920153883,
            25: 156.49061019440762,
            26: 195.02436515912197,
            27: 186.3115944347047,
            28: 192.26002945535078,
            29: 228.41048568389704,
            30: 269.0290757095965,
            31: 269.7018453156122,
            32: 220.96720226076235,
            33: 182.08783262169416,
            34: 151.3508867182161,
            35: 178.72731978494153,
            36: 188.55533041810105,
            37: 179.86040257914067,
            38: 214.61693797466802,
            39: 215.33540234634262,
            40: 216.21644582920217,
            41: 256.31910876826254,
            42: 296.40027867037713,
            43: 295.7692222464063,
            44: 244.5241425654401,
            45: 206.96531819120594,
            46: 172.99793637593638,
            47: 201.47747663721626,
            48: 215.8446272654088,
            49: 212.00280492143403,
            50: 243.06171505214402,
            51: 237.55482157908006,
            52: 241.58954810946554,
            53: 282.2834534894482,
            54: 320.26362070129323,
            55: 320.9414518795717,
            56: 272.1601878011095,
            57: 235.4101103575964,
            58: 199.06774559092634,
            59: 228.69007133283313,
            60: 241.4675641607511,
            61: 233.43891113624449,
            62: 271.4310755083969,
            63: 264.56732152015985,
            64: 270.7548050384948,
            65: 309.51072736983673,
            66: 349.62877834691466,
            67: 348.0761204657771,
            68: 302.2867059877698,
            69: 266.6077215334174,
            70: 233.04180814238254,
            71: 261.6483922606546,
            72: 272.821254466058,
            73: 268.91901793564375,
            74: 304.63084915464515,
            75: 295.686143880803,
            76: 306.06980242984986,
            77: 344.1916271757355,
            78: 383.8303751036721,
            79: 385.77499681587466,
            80: 337.0100945662258,
            81: 299.78346070097865,
            82: 268.2669390440743,
            83: 298.9257900190012,
            84: 309.29523545744814,
            85: 301.933070409225,
            86: 334.6279655645174,
            87: 337.5051381803765,
            88: 342.0906443776275,
            89: 382.81788696569674,
            90: 420.24208508253724,
            91: 424.48401988865686,
            92: 373.8344703937116,
            93: 339.3239278206528,
            94: 301.86296205190075,
            95: 334.451686600765,
            96: 347.16891628867546,
            97: 343.4760226001075,
            98: 374.4851678820127,
            99: 374.3178025007481,
            100: 375.8709731660652,
            101: 420.19465124360096,
            102: 457.3144235272313,
            103: 461.3799999132151,
            104: 410.5431339590472,
            105: 376.50903460856813,
            106: 339.7569051864903,
            107: 370.566486902681,
            108: 383.32215125695876,
            109: 377.55809244653057,
            110: 412.019898433594,
            111: 408.9963571533412,
            112: 413.4403314149778,
            113: 453.33737015620886,
            114: 495.520179819216,
            115: 493.1075488764819,
            116: 446.3207079367976,
            117: 409.4492519058148,
            118: 378.8168219455785,
            119: 406.4545958494943,
            120: 419.25690622781684,
            121: 411.0493440219911,
            122: 450.79665671688207,
            123: 445.7178062282029,
            124: 452.26262445895065,
            125: 488.9904212920897,
            126: 530.5942815133291,
            127: 531.4464027290087,
            128: 484.1376148612365,
            129: 447.9337614795482,
            130: 415.09595417401056,
            131: 447.9121813568368,
            132: 454.4279808230676,
            133: 449.37849702198906,
            134: 483.82838917360186,
            135: 486.2170801925128,
            136: 487.1483065023905,
            137: 531.8293576257481,
            138: 569.503655999338,
            139: 568.9396426960316,
            140: 520.5345024953517,
            141: 486.86523616513784,
            142: 450.39967364017775,
            143: 479.7887539760417,
            144: 494.18527601881095,
            145: 488.31380734227696,
            146: 522.5327881805024,
            147: 519.5721524980352,
            148: 524.0536173041271,
            149: 562.2439245383196,
            150: 602.4443380919059,
            151: 604.2091203982012,
            152: 558.4389031413405,
            153: 521.2538614386007,
            154: 487.9742897163234,
            155: 516.360927166625,
            156: 529.1501414728922,
            157: 523.7509476590066,
            158: 559.7749823930538,
            159: 555.6436041013609,
            160: 563.9994080865021,
            161: 600.8503834754525,
            162: 640.5115128130894,
            163: 640.9003613719606,
            164: 592.3164892669371,
            165: 558.7823359789031,
            166: 524.6708544377315,
            167: 556.1475319704066,
            168: 567.5876439955351,
            169: 559.8703627325478,
            170: 597.6263244716924,
            171: 595.1188868121062,
            172: 599.6952680326292,
            173: 639.6781624428361,
        },
    }
)

PEYTON_FCST_15_PROPHET_INCL_HIST_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2012-05-02 00:00:00"),
            1: pd.Timestamp("2012-05-03 00:00:00"),
            2: pd.Timestamp("2012-05-04 00:00:00"),
            3: pd.Timestamp("2012-05-05 00:00:00"),
            4: pd.Timestamp("2012-05-06 00:00:00"),
            5: pd.Timestamp("2012-05-07 00:00:00"),
            6: pd.Timestamp("2012-05-08 00:00:00"),
            7: pd.Timestamp("2012-05-09 00:00:00"),
            8: pd.Timestamp("2012-05-10 00:00:00"),
            9: pd.Timestamp("2012-05-11 00:00:00"),
            10: pd.Timestamp("2012-05-12 00:00:00"),
            11: pd.Timestamp("2012-05-13 00:00:00"),
            12: pd.Timestamp("2012-05-14 00:00:00"),
            13: pd.Timestamp("2012-05-15 00:00:00"),
            14: pd.Timestamp("2012-05-16 00:00:00"),
            15: pd.Timestamp("2012-05-17 00:00:00"),
            16: pd.Timestamp("2012-05-18 00:00:00"),
            17: pd.Timestamp("2012-05-19 00:00:00"),
            18: pd.Timestamp("2012-05-20 00:00:00"),
            19: pd.Timestamp("2012-05-21 00:00:00"),
            20: pd.Timestamp("2012-05-22 00:00:00"),
            21: pd.Timestamp("2012-05-23 00:00:00"),
            22: pd.Timestamp("2012-05-24 00:00:00"),
            23: pd.Timestamp("2012-05-25 00:00:00"),
            24: pd.Timestamp("2012-05-26 00:00:00"),
            25: pd.Timestamp("2012-05-27 00:00:00"),
            26: pd.Timestamp("2012-05-28 00:00:00"),
            27: pd.Timestamp("2012-05-29 00:00:00"),
            28: pd.Timestamp("2012-05-30 00:00:00"),
            29: pd.Timestamp("2012-05-31 00:00:00"),
            30: pd.Timestamp("2012-06-01 00:00:00"),
            31: pd.Timestamp("2012-06-02 00:00:00"),
            32: pd.Timestamp("2012-06-03 00:00:00"),
            33: pd.Timestamp("2012-06-04 00:00:00"),
            34: pd.Timestamp("2012-06-05 00:00:00"),
            35: pd.Timestamp("2012-06-06 00:00:00"),
            36: pd.Timestamp("2012-06-07 00:00:00"),
            37: pd.Timestamp("2012-06-08 00:00:00"),
            38: pd.Timestamp("2012-06-09 00:00:00"),
            39: pd.Timestamp("2012-06-10 00:00:00"),
            40: pd.Timestamp("2012-06-11 00:00:00"),
            41: pd.Timestamp("2012-06-12 00:00:00"),
            42: pd.Timestamp("2012-06-13 00:00:00"),
            43: pd.Timestamp("2012-06-14 00:00:00"),
            44: pd.Timestamp("2012-06-15 00:00:00"),
            45: pd.Timestamp("2012-06-16 00:00:00"),
            46: pd.Timestamp("2012-06-17 00:00:00"),
            47: pd.Timestamp("2012-06-18 00:00:00"),
            48: pd.Timestamp("2012-06-19 00:00:00"),
            49: pd.Timestamp("2012-06-20 00:00:00"),
            50: pd.Timestamp("2012-06-21 00:00:00"),
            51: pd.Timestamp("2012-06-22 00:00:00"),
            52: pd.Timestamp("2012-06-23 00:00:00"),
            53: pd.Timestamp("2012-06-24 00:00:00"),
            54: pd.Timestamp("2012-06-25 00:00:00"),
            55: pd.Timestamp("2012-06-26 00:00:00"),
            56: pd.Timestamp("2012-06-27 00:00:00"),
            57: pd.Timestamp("2012-06-28 00:00:00"),
            58: pd.Timestamp("2012-06-29 00:00:00"),
            59: pd.Timestamp("2012-06-30 00:00:00"),
            60: pd.Timestamp("2012-07-01 00:00:00"),
            61: pd.Timestamp("2012-07-02 00:00:00"),
            62: pd.Timestamp("2012-07-03 00:00:00"),
            63: pd.Timestamp("2012-07-04 00:00:00"),
            64: pd.Timestamp("2012-07-05 00:00:00"),
            65: pd.Timestamp("2012-07-06 00:00:00"),
            66: pd.Timestamp("2012-07-07 00:00:00"),
            67: pd.Timestamp("2012-07-08 00:00:00"),
            68: pd.Timestamp("2012-07-09 00:00:00"),
            69: pd.Timestamp("2012-07-10 00:00:00"),
            70: pd.Timestamp("2012-07-11 00:00:00"),
            71: pd.Timestamp("2012-07-12 00:00:00"),
            72: pd.Timestamp("2012-07-13 00:00:00"),
            73: pd.Timestamp("2012-07-14 00:00:00"),
            74: pd.Timestamp("2012-07-15 00:00:00"),
            75: pd.Timestamp("2012-07-16 00:00:00"),
            76: pd.Timestamp("2012-07-17 00:00:00"),
            77: pd.Timestamp("2012-07-18 00:00:00"),
            78: pd.Timestamp("2012-07-19 00:00:00"),
            79: pd.Timestamp("2012-07-20 00:00:00"),
            80: pd.Timestamp("2012-07-21 00:00:00"),
            81: pd.Timestamp("2012-07-22 00:00:00"),
            82: pd.Timestamp("2012-07-23 00:00:00"),
            83: pd.Timestamp("2012-07-24 00:00:00"),
            84: pd.Timestamp("2012-07-25 00:00:00"),
            85: pd.Timestamp("2012-07-26 00:00:00"),
            86: pd.Timestamp("2012-07-27 00:00:00"),
            87: pd.Timestamp("2012-07-28 00:00:00"),
            88: pd.Timestamp("2012-07-29 00:00:00"),
            89: pd.Timestamp("2012-07-30 00:00:00"),
            90: pd.Timestamp("2012-07-31 00:00:00"),
            91: pd.Timestamp("2012-08-01 00:00:00"),
            92: pd.Timestamp("2012-08-02 00:00:00"),
            93: pd.Timestamp("2012-08-03 00:00:00"),
            94: pd.Timestamp("2012-08-04 00:00:00"),
            95: pd.Timestamp("2012-08-05 00:00:00"),
            96: pd.Timestamp("2012-08-06 00:00:00"),
            97: pd.Timestamp("2012-08-07 00:00:00"),
            98: pd.Timestamp("2012-08-08 00:00:00"),
            99: pd.Timestamp("2012-08-09 00:00:00"),
            100: pd.Timestamp("2012-08-10 00:00:00"),
            101: pd.Timestamp("2012-08-11 00:00:00"),
            102: pd.Timestamp("2012-08-12 00:00:00"),
            103: pd.Timestamp("2012-08-13 00:00:00"),
            104: pd.Timestamp("2012-08-14 00:00:00"),
            105: pd.Timestamp("2012-08-15 00:00:00"),
            106: pd.Timestamp("2012-08-16 00:00:00"),
            107: pd.Timestamp("2012-08-17 00:00:00"),
            108: pd.Timestamp("2012-08-18 00:00:00"),
            109: pd.Timestamp("2012-08-19 00:00:00"),
            110: pd.Timestamp("2012-08-20 00:00:00"),
            111: pd.Timestamp("2012-08-21 00:00:00"),
            112: pd.Timestamp("2012-08-22 00:00:00"),
            113: pd.Timestamp("2012-08-23 00:00:00"),
            114: pd.Timestamp("2012-08-24 00:00:00"),
            115: pd.Timestamp("2012-08-25 00:00:00"),
            116: pd.Timestamp("2012-08-26 00:00:00"),
            117: pd.Timestamp("2012-08-27 00:00:00"),
            118: pd.Timestamp("2012-08-28 00:00:00"),
            119: pd.Timestamp("2012-08-29 00:00:00"),
            120: pd.Timestamp("2012-08-30 00:00:00"),
            121: pd.Timestamp("2012-08-31 00:00:00"),
            122: pd.Timestamp("2012-09-01 00:00:00"),
            123: pd.Timestamp("2012-09-02 00:00:00"),
            124: pd.Timestamp("2012-09-03 00:00:00"),
            125: pd.Timestamp("2012-09-04 00:00:00"),
            126: pd.Timestamp("2012-09-05 00:00:00"),
            127: pd.Timestamp("2012-09-06 00:00:00"),
            128: pd.Timestamp("2012-09-07 00:00:00"),
            129: pd.Timestamp("2012-09-08 00:00:00"),
            130: pd.Timestamp("2012-09-09 00:00:00"),
            131: pd.Timestamp("2012-09-10 00:00:00"),
            132: pd.Timestamp("2012-09-11 00:00:00"),
            133: pd.Timestamp("2012-09-12 00:00:00"),
            134: pd.Timestamp("2012-09-13 00:00:00"),
            135: pd.Timestamp("2012-09-14 00:00:00"),
            136: pd.Timestamp("2012-09-15 00:00:00"),
            137: pd.Timestamp("2012-09-16 00:00:00"),
            138: pd.Timestamp("2012-09-17 00:00:00"),
            139: pd.Timestamp("2012-09-18 00:00:00"),
            140: pd.Timestamp("2012-09-19 00:00:00"),
            141: pd.Timestamp("2012-09-20 00:00:00"),
            142: pd.Timestamp("2012-09-21 00:00:00"),
            143: pd.Timestamp("2012-09-22 00:00:00"),
            144: pd.Timestamp("2012-09-23 00:00:00"),
            145: pd.Timestamp("2012-09-24 00:00:00"),
            146: pd.Timestamp("2012-09-25 00:00:00"),
            147: pd.Timestamp("2012-09-26 00:00:00"),
            148: pd.Timestamp("2012-09-27 00:00:00"),
            149: pd.Timestamp("2012-09-28 00:00:00"),
            150: pd.Timestamp("2012-09-29 00:00:00"),
            151: pd.Timestamp("2012-09-30 00:00:00"),
            152: pd.Timestamp("2012-10-01 00:00:00"),
            153: pd.Timestamp("2012-10-02 00:00:00"),
            154: pd.Timestamp("2012-10-03 00:00:00"),
            155: pd.Timestamp("2012-10-04 00:00:00"),
            156: pd.Timestamp("2012-10-05 00:00:00"),
            157: pd.Timestamp("2012-10-06 00:00:00"),
            158: pd.Timestamp("2012-10-07 00:00:00"),
            159: pd.Timestamp("2012-10-08 00:00:00"),
            160: pd.Timestamp("2012-10-09 00:00:00"),
            161: pd.Timestamp("2012-10-10 00:00:00"),
            162: pd.Timestamp("2012-10-11 00:00:00"),
            163: pd.Timestamp("2012-10-12 00:00:00"),
            164: pd.Timestamp("2012-10-13 00:00:00"),
            165: pd.Timestamp("2012-10-14 00:00:00"),
            166: pd.Timestamp("2012-10-15 00:00:00"),
            167: pd.Timestamp("2012-10-16 00:00:00"),
            168: pd.Timestamp("2012-10-17 00:00:00"),
            169: pd.Timestamp("2012-10-18 00:00:00"),
            170: pd.Timestamp("2012-10-19 00:00:00"),
            171: pd.Timestamp("2012-10-20 00:00:00"),
            172: pd.Timestamp("2012-10-21 00:00:00"),
            173: pd.Timestamp("2012-10-22 00:00:00"),
            174: pd.Timestamp("2012-10-23 00:00:00"),
            175: pd.Timestamp("2012-10-24 00:00:00"),
            176: pd.Timestamp("2012-10-25 00:00:00"),
            177: pd.Timestamp("2012-10-26 00:00:00"),
            178: pd.Timestamp("2012-10-27 00:00:00"),
            179: pd.Timestamp("2012-10-28 00:00:00"),
            180: pd.Timestamp("2012-10-29 00:00:00"),
            181: pd.Timestamp("2012-10-30 00:00:00"),
            182: pd.Timestamp("2012-10-31 00:00:00"),
            183: pd.Timestamp("2012-11-01 00:00:00"),
            184: pd.Timestamp("2012-11-02 00:00:00"),
            185: pd.Timestamp("2012-11-03 00:00:00"),
            186: pd.Timestamp("2012-11-04 00:00:00"),
            187: pd.Timestamp("2012-11-05 00:00:00"),
            188: pd.Timestamp("2012-11-06 00:00:00"),
            189: pd.Timestamp("2012-11-07 00:00:00"),
            190: pd.Timestamp("2012-11-08 00:00:00"),
            191: pd.Timestamp("2012-11-09 00:00:00"),
            192: pd.Timestamp("2012-11-10 00:00:00"),
            193: pd.Timestamp("2012-11-11 00:00:00"),
            194: pd.Timestamp("2012-11-12 00:00:00"),
            195: pd.Timestamp("2012-11-13 00:00:00"),
            196: pd.Timestamp("2012-11-14 00:00:00"),
            197: pd.Timestamp("2012-11-15 00:00:00"),
            198: pd.Timestamp("2012-11-16 00:00:00"),
            199: pd.Timestamp("2012-11-17 00:00:00"),
            200: pd.Timestamp("2012-11-18 00:00:00"),
            201: pd.Timestamp("2012-11-19 00:00:00"),
            202: pd.Timestamp("2012-11-20 00:00:00"),
            203: pd.Timestamp("2012-11-21 00:00:00"),
            204: pd.Timestamp("2012-11-22 00:00:00"),
            205: pd.Timestamp("2012-11-23 00:00:00"),
            206: pd.Timestamp("2012-11-24 00:00:00"),
            207: pd.Timestamp("2012-11-25 00:00:00"),
            208: pd.Timestamp("2012-11-26 00:00:00"),
            209: pd.Timestamp("2012-11-27 00:00:00"),
            210: pd.Timestamp("2012-11-28 00:00:00"),
            211: pd.Timestamp("2012-11-29 00:00:00"),
            212: pd.Timestamp("2012-11-30 00:00:00"),
            213: pd.Timestamp("2012-12-01 00:00:00"),
            214: pd.Timestamp("2012-12-02 00:00:00"),
            215: pd.Timestamp("2012-12-03 00:00:00"),
            216: pd.Timestamp("2012-12-04 00:00:00"),
            217: pd.Timestamp("2012-12-05 00:00:00"),
            218: pd.Timestamp("2012-12-06 00:00:00"),
            219: pd.Timestamp("2012-12-07 00:00:00"),
            220: pd.Timestamp("2012-12-08 00:00:00"),
            221: pd.Timestamp("2012-12-09 00:00:00"),
            222: pd.Timestamp("2012-12-10 00:00:00"),
            223: pd.Timestamp("2012-12-11 00:00:00"),
            224: pd.Timestamp("2012-12-12 00:00:00"),
            225: pd.Timestamp("2012-12-13 00:00:00"),
            226: pd.Timestamp("2012-12-14 00:00:00"),
            227: pd.Timestamp("2012-12-15 00:00:00"),
            228: pd.Timestamp("2012-12-16 00:00:00"),
            229: pd.Timestamp("2012-12-17 00:00:00"),
            230: pd.Timestamp("2012-12-18 00:00:00"),
            231: pd.Timestamp("2012-12-19 00:00:00"),
            232: pd.Timestamp("2012-12-20 00:00:00"),
            233: pd.Timestamp("2012-12-21 00:00:00"),
            234: pd.Timestamp("2012-12-22 00:00:00"),
            235: pd.Timestamp("2012-12-23 00:00:00"),
            236: pd.Timestamp("2012-12-24 00:00:00"),
            237: pd.Timestamp("2012-12-25 00:00:00"),
            238: pd.Timestamp("2012-12-26 00:00:00"),
            239: pd.Timestamp("2012-12-27 00:00:00"),
            240: pd.Timestamp("2012-12-28 00:00:00"),
            241: pd.Timestamp("2012-12-29 00:00:00"),
            242: pd.Timestamp("2012-12-30 00:00:00"),
            243: pd.Timestamp("2012-12-31 00:00:00"),
            244: pd.Timestamp("2013-01-01 00:00:00"),
            245: pd.Timestamp("2013-01-02 00:00:00"),
            246: pd.Timestamp("2013-01-03 00:00:00"),
            247: pd.Timestamp("2013-01-04 00:00:00"),
            248: pd.Timestamp("2013-01-05 00:00:00"),
            249: pd.Timestamp("2013-01-06 00:00:00"),
            250: pd.Timestamp("2013-01-07 00:00:00"),
            251: pd.Timestamp("2013-01-08 00:00:00"),
            252: pd.Timestamp("2013-01-09 00:00:00"),
            253: pd.Timestamp("2013-01-10 00:00:00"),
            254: pd.Timestamp("2013-01-11 00:00:00"),
            255: pd.Timestamp("2013-01-12 00:00:00"),
            256: pd.Timestamp("2013-01-13 00:00:00"),
            257: pd.Timestamp("2013-01-14 00:00:00"),
            258: pd.Timestamp("2013-01-15 00:00:00"),
            259: pd.Timestamp("2013-01-16 00:00:00"),
            260: pd.Timestamp("2013-01-17 00:00:00"),
            261: pd.Timestamp("2013-01-18 00:00:00"),
            262: pd.Timestamp("2013-01-19 00:00:00"),
            263: pd.Timestamp("2013-01-20 00:00:00"),
            264: pd.Timestamp("2013-01-21 00:00:00"),
            265: pd.Timestamp("2013-01-22 00:00:00"),
            266: pd.Timestamp("2013-01-23 00:00:00"),
            267: pd.Timestamp("2013-01-24 00:00:00"),
            268: pd.Timestamp("2013-01-25 00:00:00"),
            269: pd.Timestamp("2013-01-26 00:00:00"),
            270: pd.Timestamp("2013-01-27 00:00:00"),
            271: pd.Timestamp("2013-01-28 00:00:00"),
            272: pd.Timestamp("2013-01-29 00:00:00"),
            273: pd.Timestamp("2013-01-30 00:00:00"),
            274: pd.Timestamp("2013-01-31 00:00:00"),
            275: pd.Timestamp("2013-02-01 00:00:00"),
            276: pd.Timestamp("2013-02-02 00:00:00"),
            277: pd.Timestamp("2013-02-03 00:00:00"),
            278: pd.Timestamp("2013-02-04 00:00:00"),
            279: pd.Timestamp("2013-02-05 00:00:00"),
            280: pd.Timestamp("2013-02-06 00:00:00"),
            281: pd.Timestamp("2013-02-07 00:00:00"),
            282: pd.Timestamp("2013-02-08 00:00:00"),
            283: pd.Timestamp("2013-02-09 00:00:00"),
            284: pd.Timestamp("2013-02-10 00:00:00"),
            285: pd.Timestamp("2013-02-11 00:00:00"),
            286: pd.Timestamp("2013-02-12 00:00:00"),
            287: pd.Timestamp("2013-02-13 00:00:00"),
            288: pd.Timestamp("2013-02-14 00:00:00"),
            289: pd.Timestamp("2013-02-15 00:00:00"),
            290: pd.Timestamp("2013-02-16 00:00:00"),
            291: pd.Timestamp("2013-02-17 00:00:00"),
            292: pd.Timestamp("2013-02-18 00:00:00"),
            293: pd.Timestamp("2013-02-19 00:00:00"),
            294: pd.Timestamp("2013-02-20 00:00:00"),
            295: pd.Timestamp("2013-02-21 00:00:00"),
            296: pd.Timestamp("2013-02-22 00:00:00"),
            297: pd.Timestamp("2013-02-23 00:00:00"),
            298: pd.Timestamp("2013-02-24 00:00:00"),
            299: pd.Timestamp("2013-02-25 00:00:00"),
            300: pd.Timestamp("2013-02-26 00:00:00"),
            301: pd.Timestamp("2013-02-27 00:00:00"),
            302: pd.Timestamp("2013-02-28 00:00:00"),
            303: pd.Timestamp("2013-03-01 00:00:00"),
            304: pd.Timestamp("2013-03-02 00:00:00"),
            305: pd.Timestamp("2013-03-03 00:00:00"),
            306: pd.Timestamp("2013-03-04 00:00:00"),
            307: pd.Timestamp("2013-03-05 00:00:00"),
            308: pd.Timestamp("2013-03-06 00:00:00"),
            309: pd.Timestamp("2013-03-07 00:00:00"),
            310: pd.Timestamp("2013-03-08 00:00:00"),
            311: pd.Timestamp("2013-03-09 00:00:00"),
            312: pd.Timestamp("2013-03-10 00:00:00"),
            313: pd.Timestamp("2013-03-11 00:00:00"),
            314: pd.Timestamp("2013-03-12 00:00:00"),
            315: pd.Timestamp("2013-03-13 00:00:00"),
            316: pd.Timestamp("2013-03-14 00:00:00"),
            317: pd.Timestamp("2013-03-15 00:00:00"),
            318: pd.Timestamp("2013-03-16 00:00:00"),
            319: pd.Timestamp("2013-03-17 00:00:00"),
            320: pd.Timestamp("2013-03-18 00:00:00"),
            321: pd.Timestamp("2013-03-19 00:00:00"),
            322: pd.Timestamp("2013-03-20 00:00:00"),
            323: pd.Timestamp("2013-03-21 00:00:00"),
            324: pd.Timestamp("2013-03-22 00:00:00"),
            325: pd.Timestamp("2013-03-23 00:00:00"),
            326: pd.Timestamp("2013-03-24 00:00:00"),
            327: pd.Timestamp("2013-03-25 00:00:00"),
            328: pd.Timestamp("2013-03-26 00:00:00"),
            329: pd.Timestamp("2013-03-27 00:00:00"),
            330: pd.Timestamp("2013-03-28 00:00:00"),
            331: pd.Timestamp("2013-03-29 00:00:00"),
            332: pd.Timestamp("2013-03-30 00:00:00"),
            333: pd.Timestamp("2013-03-31 00:00:00"),
            334: pd.Timestamp("2013-04-01 00:00:00"),
            335: pd.Timestamp("2013-04-02 00:00:00"),
            336: pd.Timestamp("2013-04-03 00:00:00"),
            337: pd.Timestamp("2013-04-04 00:00:00"),
            338: pd.Timestamp("2013-04-05 00:00:00"),
            339: pd.Timestamp("2013-04-06 00:00:00"),
            340: pd.Timestamp("2013-04-07 00:00:00"),
            341: pd.Timestamp("2013-04-08 00:00:00"),
            342: pd.Timestamp("2013-04-09 00:00:00"),
            343: pd.Timestamp("2013-04-10 00:00:00"),
            344: pd.Timestamp("2013-04-11 00:00:00"),
            345: pd.Timestamp("2013-04-12 00:00:00"),
            346: pd.Timestamp("2013-04-13 00:00:00"),
            347: pd.Timestamp("2013-04-14 00:00:00"),
            348: pd.Timestamp("2013-04-15 00:00:00"),
            349: pd.Timestamp("2013-04-16 00:00:00"),
            350: pd.Timestamp("2013-04-17 00:00:00"),
            351: pd.Timestamp("2013-04-18 00:00:00"),
            352: pd.Timestamp("2013-04-19 00:00:00"),
            353: pd.Timestamp("2013-04-20 00:00:00"),
            354: pd.Timestamp("2013-04-21 00:00:00"),
            355: pd.Timestamp("2013-04-22 00:00:00"),
            356: pd.Timestamp("2013-04-23 00:00:00"),
            357: pd.Timestamp("2013-04-24 00:00:00"),
            358: pd.Timestamp("2013-04-25 00:00:00"),
            359: pd.Timestamp("2013-04-26 00:00:00"),
            360: pd.Timestamp("2013-04-27 00:00:00"),
            361: pd.Timestamp("2013-04-28 00:00:00"),
            362: pd.Timestamp("2013-04-29 00:00:00"),
            363: pd.Timestamp("2013-04-30 00:00:00"),
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
        },
        "fcst": {
            0: 7.713245845523316,
            1: 7.747959176960694,
            2: 7.795686250899575,
            3: 7.627634103070908,
            4: 8.089104407057658,
            5: 8.22993796123083,
            6: 7.939545326740182,
            7: 7.711923468644015,
            8: 7.746636800081176,
            9: 7.794363874019675,
            10: 7.626311726191162,
            11: 8.087782030178348,
            12: 8.228615584351214,
            13: 7.938222950291884,
            14: 7.710601092625162,
            15: 7.745314424493283,
            16: 7.7930414988623395,
            17: 7.624989351464368,
            18: 8.086459655881525,
            19: 8.227293210485538,
            20: 7.936900576426574,
            21: 7.7092787187595135,
            22: 7.743992050627956,
            23: 7.791719124997247,
            24: 7.623666978406032,
            25: 8.08513728363043,
            26: 8.225970839040823,
            27: 7.935578205788725,
            28: 7.707956348928617,
            29: 7.742669681603631,
            30: 7.790396756779751,
            31: 7.622344610188881,
            32: 8.083814915413658,
            33: 8.224648470823565,
            34: 7.934255837571893,
            35: 7.7066339807114215,
            36: 7.741404394113255,
            37: 7.789188550016053,
            38: 7.62119348415149,
            39: 8.082720870101953,
            40: 8.223611506239518,
            41: 7.933275953713848,
            42: 7.705711177580473,
            43: 7.7404815909819265,
            44: 7.7882657468851235,
            45: 7.620270681020275,
            46: 8.081798066971427,
            47: 8.226344977947692,
            48: 7.939665700261163,
            49: 7.715757198967248,
            50: 7.7541838872085105,
            51: 7.805624317950884,
            52: 7.641285526925623,
            53: 8.106469187716291,
            54: 8.251016098692677,
            55: 7.964336821006632,
            56: 7.740428319712356,
            57: 7.778855007953403,
            58: 7.830295438695394,
            59: 7.672206948117644,
            60: 8.143640909355753,
            61: 8.294438120778999,
            62: 8.014009143540017,
            63: 7.796350942693127,
            64: 7.841027931381609,
            65: 7.898718662570998,
            66: 7.74063017199309,
            67: 8.212064133230825,
            68: 8.362861344654338,
            69: 8.082432367415299,
            70: 7.864774166568898,
            71: 7.912609580372766,
            72: 7.973458736678094,
            73: 7.818528671215924,
            74: 8.293121057569628,
            75: 8.447076694108679,
            76: 8.169806141984498,
            77: 7.955306366254266,
            78: 8.003141780058025,
            79: 8.063990936363133,
            80: 7.90906087090125,
            81: 8.383653257254272,
            82: 8.537608894269177,
            83: 8.260338342621449,
            84: 8.04583856736583,
            85: 8.093673981645214,
            86: 8.154523138425482,
            87: 7.999593073439084,
            88: 8.47418546026677,
            89: 8.628141097282311,
            90: 8.350870545633729,
            91: 8.136370770378655,
            92: 8.18420618465803,
            93: 8.245055341438698,
            94: 8.090125277446619,
            95: 8.564717665269356,
            96: 8.71867330327888,
            97: 8.44140275262527,
            98: 8.226902978364883,
            99: 8.274738393638865,
            100: 8.335587551413937,
            101: 8.180657487422067,
            102: 8.655249875245183,
            103: 8.809205513254591,
            104: 8.531934962601467,
            105: 8.317435188059587,
            106: 8.365270603052787,
            107: 8.426119760547069,
            108: 8.271189696274343,
            109: 8.745782083816145,
            110: 8.899737721545538,
            111: 8.622467170611046,
            112: 8.407967396070084,
            113: 8.455802811063197,
            114: 8.5166519685574,
            115: 8.361721904284513,
            116: 8.836314291827065,
            117: 8.990269925387821,
            118: 8.712999370285187,
            119: 8.498499591575733,
            120: 8.546335002400836,
            121: 8.607184155727172,
            122: 8.45225408728622,
            123: 8.926846470660708,
            124: 9.080802104221217,
            125: 8.80353154911986,
            126: 8.589031770409619,
            127: 8.636867181234507,
            128: 8.697716334560594,
            129: 8.538706015796373,
            130: 9.009218148847769,
            131: 9.159093532084917,
            132: 8.87774272666009,
            133: 8.659162697626217,
            134: 8.702917858128131,
            135: 8.75968676113103,
            136: 8.600676442366526,
            137: 9.071188575417484,
            138: 9.221063958654899,
            139: 8.939713153229588,
            140: 8.715059435736674,
            141: 8.752740907779351,
            142: 8.803436122322928,
            143: 8.638352115098758,
            144: 9.102790559690538,
            145: 9.246592254468279,
            146: 8.959167760583044,
            147: 8.734514043090618,
            148: 8.7721955151326,
            149: 8.822890729676143,
            150: 8.657806722452314,
            151: 9.122245167044476,
            152: 9.26409101111618,
            153: 8.974710666525846,
            154: 8.748101098327115,
            155: 8.783826719664177,
            156: 8.83256608350193,
            157: 8.665526225572586,
            158: 9.128008819458287,
            159: 9.269854663530868,
            160: 8.980474318940106,
            161: 8.753864750741865,
            162: 8.789590372078546,
            163: 8.8383297360033,
            164: 8.671289878160332,
            165: 9.133772472133263,
            166: 9.275618316291958,
            167: 8.986237971787371,
            168: 8.759628403675817,
            169: 8.795354025099348,
            170: 8.844093389024088,
            171: 8.677053531181272,
            172: 9.139536125154404,
            173: 9.28138196931285,
            174: 8.992001624809118,
            175: 8.765392055599147,
            176: 8.801117675924408,
            177: 8.849857038750708,
            178: 8.68281717981005,
            179: 9.145299772683499,
            180: 9.287145615745219,
            181: 8.997765270142766,
            182: 8.771155700933312,
            183: 8.806881321258594,
            184: 8.855620684085109,
            185: 8.68858082514429,
            186: 9.151063418018248,
            187: 9.292909259835735,
            188: 9.003528912990035,
            189: 8.77691934253702,
            190: 8.812644961618716,
            191: 8.8613843232016,
            192: 8.694344463017247,
            193: 9.156827054647906,
            194: 9.298672896465277,
            195: 9.009292549618781,
            196: 8.782682979166308,
            197: 8.818408598247867,
            198: 8.867147959771811,
            199: 8.700108099528492,
            200: 9.162590691100124,
            201: 9.304436532858306,
            202: 9.01505618595387,
            203: 8.788446615441618,
            204: 8.824172234464402,
            205: 8.872911595987832,
            206: 8.705871735744859,
            207: 9.168354327315987,
            208: 9.310200169074568,
            209: 9.020819822169274,
            210: 8.794210248978176,
            211: 8.829935865321621,
            212: 8.87867522416609,
            213: 8.711635361243157,
            214: 9.174117950135686,
            215: 9.315963789214658,
            216: 9.026583439630008,
            217: 8.799973866439398,
            218: 8.835699482782445,
            219: 8.884438841626714,
            220: 8.717398978703995,
            221: 9.179881565255846,
            222: 9.321727401993275,
            223: 9.032347050069273,
            224: 8.805737474535563,
            225: 8.841463088537873,
            226: 8.890202445041002,
            227: 8.723162579777378,
            228: 9.185645166328307,
            229: 9.327491003066418,
            230: 9.038110651141755,
            231: 8.81150107560896,
            232: 8.847226689611189,
            233: 8.895087266823303,
            234: 8.727168622268712,
            235: 9.188772429529344,
            236: 9.329739486976413,
            237: 9.039480355760453,
            238: 8.81199200093639,
            239: 8.846838835647826,
            240: 8.894699412860547,
            241: 8.726780768305602,
            242: 9.188384575566433,
            243: 9.329351633012886,
            244: 9.039092501797722,
            245: 8.805358135589444,
            246: 8.833958958916387,
            247: 8.87557352474458,
            248: 8.701408868805375,
            249: 9.156766664682127,
            250: 9.29148771074423,
            251: 8.994982568144183,
            252: 8.761248201935992,
            253: 8.789849025262956,
            254: 8.831463591091227,
            255: 8.65729893515206,
            256: 9.104984069386523,
            257: 9.232032453807214,
            258: 8.927854649565077,
            259: 8.686447621715118,
            260: 8.707375783400844,
            261: 8.741317687587198,
            262: 8.559480370006069,
            263: 9.00716550424091,
            264: 9.134213888661487,
            265: 8.830036084418982,
            266: 8.588629056569513,
            267: 8.60955721825436,
            268: 8.64349912239577,
            269: 8.46166180476963,
            270: 8.909346938959152,
            271: 9.036395323334308,
            272: 8.732217519047195,
            273: 8.490810491151738,
            274: 8.511738652791978,
            275: 8.545680556933009,
            276: 8.36384323930702,
            277: 8.811528373496095,
            278: 8.938576757871651,
            279: 8.634398954898193,
            280: 8.392991928317308,
            281: 8.413920091271251,
            282: 8.447861996726765,
            283: 8.266024680414633,
            284: 8.713709815917536,
            285: 8.84075820160757,
            286: 8.53658039863369,
            287: 8.295173372053293,
            288: 8.316101535007268,
            289: 8.350043440462715,
            290: 8.168206124150606,
            291: 8.615911414351947,
            292: 8.742979954739972,
            293: 8.438822306465184,
            294: 8.197435434582262,
            295: 8.218383752234661,
            296: 8.252345812387832,
            297: 8.070528650774305,
            298: 8.518233940974904,
            299: 8.645302481363375,
            300: 8.34114483308792,
            301: 8.09975796120554,
            302: 8.120706278857938,
            303: 8.154668339011321,
            304: 7.972851177397693,
            305: 8.420556467598745,
            306: 8.547625007987339,
            307: 8.243467359711516,
            308: 8.002080487829197,
            309: 8.023028805481623,
            310: 8.056990865634997,
            311: 7.875173704021083,
            312: 8.322878994222824,
            313: 8.44994753461056,
            314: 8.145789886334684,
            315: 7.904403014452878,
            316: 7.925351332105197,
            317: 7.959313392258617,
            318: 7.777496230644726,
            319: 8.225201520846426,
            320: 8.352270061233964,
            321: 8.048112412958703,
            322: 7.806725541076536,
            323: 7.82767385872877,
            324: 7.861635918881972,
            325: 7.679818757268115,
            326: 8.12752404746962,
            327: 8.254592587857557,
            328: 7.950434939582723,
            329: 7.709048067699788,
            330: 7.729996385352343,
            331: 7.763958445505648,
            332: 7.582141283891815,
            333: 8.029846574093462,
            334: 8.15691511448115,
            335: 7.8527574662063175,
            336: 7.611370594323874,
            337: 7.632318911976029,
            338: 7.666280972129269,
            339: 7.484463810515514,
            340: 7.932169100717302,
            341: 8.059237641104744,
            342: 7.755079992830766,
            343: 7.513693120947127,
            344: 7.534641438599602,
            345: 7.568603498752944,
            346: 7.386786337139156,
            347: 7.83449162734026,
            348: 7.961560167728145,
            349: 7.6574025194535045,
            350: 7.416015647570783,
            351: 7.436963965223175,
            352: 7.470926025376751,
            353: 7.289108863762603,
            354: 7.736814153964339,
            355: 7.863882694352286,
            356: 7.559725046077101,
            357: 7.318338174194438,
            358: 7.339286491846566,
            359: 7.373248552000239,
            360: 7.191431390386246,
            361: 7.639136680588178,
            362: 7.76620522097551,
            363: 7.4620475727011195,
            364: 7.220660700818121,
            365: 7.2416090184704345,
            366: 7.275571078623728,
            367: 7.093753917009888,
            368: 7.54145920721202,
            369: 7.668527747599284,
            370: 7.364370099324286,
            371: 7.122983227441376,
            372: 7.143931545093528,
            373: 7.177893605247083,
            374: 6.996076443633335,
            375: 7.443781733834978,
            376: 7.570850274222876,
            377: 7.266692625947454,
            378: 7.025305754064628,
        },
        "fcst_lower": {
            0: 7.143110105784194,
            1: 7.184677182751015,
            2: 7.219631229807209,
            3: 7.022014277823116,
            4: 7.508460681739394,
            5: 7.627889243031185,
            6: 7.385033434932504,
            7: 7.103619594210419,
            8: 7.105510478897571,
            9: 7.201581706169666,
            10: 7.039640188275415,
            11: 7.487571657453695,
            12: 7.65690459259978,
            13: 7.359690429961748,
            14: 7.1155266435189235,
            15: 7.194904832034949,
            16: 7.184792312418526,
            17: 7.024848033308231,
            18: 7.48412946759151,
            19: 7.63980720199675,
            20: 7.334492825472576,
            21: 7.127318461631461,
            22: 7.1485835099697725,
            23: 7.223236251058496,
            24: 7.061757460562333,
            25: 7.5028003395821745,
            26: 7.616563388890052,
            27: 7.351864273772432,
            28: 7.126164414883021,
            29: 7.187945737761888,
            30: 7.178972890255103,
            31: 7.014747048546357,
            32: 7.523267393064503,
            33: 7.6900991391951,
            34: 7.352661044330227,
            35: 7.124834529354169,
            36: 7.187302402783139,
            37: 7.197245698293674,
            38: 7.02450298062421,
            39: 7.518927043653337,
            40: 7.6364689483237,
            41: 7.326651567549191,
            42: 7.105940287937902,
            43: 7.153743653517389,
            44: 7.1867588086174585,
            45: 7.077282946174464,
            46: 7.4730491152179805,
            47: 7.677781986583476,
            48: 7.378167926232128,
            49: 7.132654643550039,
            50: 7.170620289771774,
            51: 7.241212547015398,
            52: 7.042212683661315,
            53: 7.5439243944776955,
            54: 7.617632555000496,
            55: 7.351091226923147,
            56: 7.16965509135786,
            57: 7.198205621564545,
            58: 7.275755008790348,
            59: 7.090461177868102,
            60: 7.553905009280552,
            61: 7.733913570470437,
            62: 7.4350872343969865,
            63: 7.164897015663784,
            64: 7.190117716055918,
            65: 7.297058839998728,
            66: 7.145980037552135,
            67: 7.600326525896823,
            68: 7.775906952525046,
            69: 7.500367851411129,
            70: 7.289070929020334,
            71: 7.358640403836616,
            72: 7.410068134667908,
            73: 7.257444004445504,
            74: 7.724441562898723,
            75: 7.871112330988092,
            76: 7.570564898455198,
            77: 7.36168121905725,
            78: 7.4125979124392245,
            79: 7.46896808792214,
            80: 7.326126941212127,
            81: 7.768739700856962,
            82: 7.928550563599149,
            83: 7.6419335230202,
            84: 7.4290637647420015,
            85: 7.507705187481339,
            86: 7.589561590761017,
            87: 7.426787912318253,
            88: 7.897149653861327,
            89: 8.034119384898487,
            90: 7.792185109312774,
            91: 7.5539560552613745,
            92: 7.604469998696066,
            93: 7.652537738014463,
            94: 7.473359490747942,
            95: 7.990413699488647,
            96: 8.160807764890633,
            97: 7.885063050763748,
            98: 7.606528264296799,
            99: 7.694072953357791,
            100: 7.762915294211896,
            101: 7.592611021864679,
            102: 8.091898490147873,
            103: 8.241265180785696,
            104: 7.963250822487266,
            105: 7.711321141220491,
            106: 7.810589838974734,
            107: 7.817687677212685,
            108: 7.628052567484352,
            109: 8.15670288488057,
            110: 8.293474995662146,
            111: 8.05324590443424,
            112: 7.817157420097288,
            113: 7.888321359474514,
            114: 7.930020810331952,
            115: 7.739249014145739,
            116: 8.273820427044278,
            117: 8.3745624326975,
            118: 8.11815486822871,
            119: 7.912787112981967,
            120: 7.959367492814154,
            121: 8.04250879910865,
            122: 7.875373660399229,
            123: 8.361445062163925,
            124: 8.47397800996373,
            125: 8.174277701707496,
            126: 8.008811139392852,
            127: 8.060782892134721,
            128: 8.094474242055485,
            129: 7.926191368692672,
            130: 8.404205038411813,
            131: 8.552449080198564,
            132: 8.30765311298215,
            133: 8.093076971170506,
            134: 8.091979908478912,
            135: 8.180979414026515,
            136: 7.9989414551165785,
            137: 8.478345560786227,
            138: 8.612277515885216,
            139: 8.363037274834337,
            140: 8.100896337733719,
            141: 8.141508130990161,
            142: 8.244435643281754,
            143: 8.060594519440388,
            144: 8.483715587355478,
            145: 8.63994876351375,
            146: 8.343970437628274,
            147: 8.101907203759152,
            148: 8.161165340440084,
            149: 8.251598595040397,
            150: 8.079745380250863,
            151: 8.521438840774522,
            152: 8.644744936107692,
            153: 8.351083151934427,
            154: 8.186256355945343,
            155: 8.169963142016128,
            156: 8.273248064508232,
            157: 8.115685372106071,
            158: 8.536905649423412,
            159: 8.68522366348051,
            160: 8.355578609871275,
            161: 8.120904582182604,
            162: 8.216330345492018,
            163: 8.27145074893642,
            164: 8.10459061779685,
            165: 8.518455998219165,
            166: 8.687441734223246,
            167: 8.378061631539888,
            168: 8.181528407663976,
            169: 8.223484247715195,
            170: 8.227626523403984,
            171: 8.080621054561533,
            172: 8.529257082664765,
            173: 8.708625473838671,
            174: 8.442608968361059,
            175: 8.158792684540254,
            176: 8.250029569512543,
            177: 8.273527784037455,
            178: 8.065096017961864,
            179: 8.553951671968905,
            180: 8.675227125832954,
            181: 8.43162009878538,
            182: 8.21104187209796,
            183: 8.203284649371925,
            184: 8.242152770632849,
            185: 8.110082987780729,
            186: 8.534142885402924,
            187: 8.666200173657428,
            188: 8.419341587647668,
            189: 8.224047222321905,
            190: 8.198000607437475,
            191: 8.258532954355156,
            192: 8.121721183977474,
            193: 8.579468468790079,
            194: 8.734344806579433,
            195: 8.407319174635063,
            196: 8.175932804231062,
            197: 8.216176582126588,
            198: 8.319355320435255,
            199: 8.137627510917497,
            200: 8.581652877835884,
            201: 8.716404030988265,
            202: 8.441249261671576,
            203: 8.21793540749503,
            204: 8.287464030856485,
            205: 8.28442531808688,
            206: 8.208986130233335,
            207: 8.532700855997799,
            208: 8.724554125513308,
            209: 8.419062882672973,
            210: 8.195713744903642,
            211: 8.24128145902436,
            212: 8.307822114192858,
            213: 8.117896915508647,
            214: 8.597755383638331,
            215: 8.778457239506432,
            216: 8.433907621874212,
            217: 8.192331788008785,
            218: 8.248622586537985,
            219: 8.278555156169299,
            220: 8.161838303372269,
            221: 8.639961298442845,
            222: 8.75914657125385,
            223: 8.437651457736205,
            224: 8.22944768851255,
            225: 8.273678976744028,
            226: 8.337854544206712,
            227: 8.137954012440789,
            228: 8.563918873175433,
            229: 8.731854190870015,
            230: 8.464337596746276,
            231: 8.24790239312571,
            232: 8.237798301659572,
            233: 8.302604898665331,
            234: 8.155665891526546,
            235: 8.56231218675803,
            236: 8.7554033247801,
            237: 8.475401913631547,
            238: 8.248120851374193,
            239: 8.24178257861246,
            240: 8.306568657309716,
            241: 8.133428414376727,
            242: 8.630351062235663,
            243: 8.732716377971514,
            244: 8.452064710302954,
            245: 8.214315649708498,
            246: 8.294075989966776,
            247: 8.283511695792049,
            248: 8.137768757180819,
            249: 8.593818584469302,
            250: 8.70599675117187,
            251: 8.41670106108169,
            252: 8.188229896927417,
            253: 8.185483787703244,
            254: 8.260104159565383,
            255: 8.035465506138141,
            256: 8.544515513265202,
            257: 8.65833437127276,
            258: 8.34922820303492,
            259: 8.097183894957299,
            260: 8.10017981809902,
            261: 8.160092672747584,
            262: 7.982359350888741,
            263: 8.390369625634923,
            264: 8.543718263936876,
            265: 8.170672013627359,
            266: 8.009077197924086,
            267: 8.01793054983131,
            268: 8.00203321349697,
            269: 7.855907237278501,
            270: 8.331270083314365,
            271: 8.457271445235923,
            272: 8.096914139428467,
            273: 7.882707685767894,
            274: 7.952496220240774,
            275: 7.944792280989661,
            276: 7.7799605539842345,
            277: 8.176101900903038,
            278: 8.300801759095618,
            279: 8.060857186914902,
            280: 7.777173319650946,
            281: 7.846791812915906,
            282: 7.8663807813457005,
            283: 7.683486305326963,
            284: 8.139740668115243,
            285: 8.23847997279419,
            286: 7.987243404483987,
            287: 7.6970390131679185,
            288: 7.719694752082939,
            289: 7.762235745591179,
            290: 7.612366386960841,
            291: 8.010529037386705,
            292: 8.164617568280127,
            293: 7.846263932692014,
            294: 7.607382696128226,
            295: 7.622940374083941,
            296: 7.713327176324958,
            297: 7.4567578562274415,
            298: 7.934806656669838,
            299: 8.03085612381996,
            300: 7.733643875828687,
            301: 7.534038284589502,
            302: 7.537776525042757,
            303: 7.550999855633216,
            304: 7.382986193153615,
            305: 7.818837586827109,
            306: 7.954024834002254,
            307: 7.682625424411178,
            308: 7.402131876162333,
            309: 7.443072035590144,
            310: 7.4743257725254155,
            311: 7.280974287929024,
            312: 7.717949925424003,
            313: 7.835946256922569,
            314: 7.602020353154877,
            315: 7.341923396956216,
            316: 7.331068451850486,
            317: 7.3546096385254405,
            318: 7.168442929035828,
            319: 7.6622417710671105,
            320: 7.755504151004193,
            321: 7.458623675545644,
            322: 7.235849650376727,
            323: 7.2902536941439635,
            324: 7.303063810894443,
            325: 7.094987011209143,
            326: 7.5211320616083945,
            327: 7.6342168669945645,
            328: 7.378561420240523,
            329: 7.12644330995532,
            330: 7.097368645983935,
            331: 7.148313965262157,
            332: 7.000028191197806,
            333: 7.445511538026047,
            334: 7.582335595969696,
            335: 7.3040747704259354,
            336: 7.052653609484357,
            337: 7.069860456692123,
            338: 7.062440093767832,
            339: 6.877300746280825,
            340: 7.376048194555718,
            341: 7.467619660459797,
            342: 7.183777324495398,
            343: 6.925345645419224,
            344: 6.928684776068321,
            345: 6.9465374630434775,
            346: 6.774161684842539,
            347: 7.300906825519334,
            348: 7.369479733909318,
            349: 7.070720998439379,
            350: 6.819735554405341,
            351: 6.871196114375047,
            352: 6.894016993309594,
            353: 6.721187180511849,
            354: 7.187787676857383,
            355: 7.281651448923958,
            356: 6.968407780693915,
            357: 6.7340329309733695,
            358: 6.759049271476629,
            359: 6.746533634980084,
            360: 6.618853458825777,
            361: 7.056619399387594,
            362: 7.1888396308704055,
            363: 6.873761084451768,
            364: 6.641720925457513,
            365: 6.666223534272653,
            366: 6.671861561200792,
            367: 6.49166252564396,
            368: 6.974135152128372,
            369: 7.089892633345363,
            370: 6.792286729334534,
            371: 6.522033855508401,
            372: 6.516380851155153,
            373: 6.605859072972971,
            374: 6.454791251870964,
            375: 6.86452629031848,
            376: 7.003492305682654,
            377: 6.67653065285822,
            378: 6.435170617705394,
        },
        "fcst_upper": {
            0: 8.292007309753227,
            1: 8.368903143698532,
            2: 8.386954266821222,
            3: 8.23647291349591,
            4: 8.66376645243186,
            5: 8.790532453559953,
            6: 8.535820274884449,
            7: 8.297256193333984,
            8: 8.316119126245782,
            9: 8.370909958407806,
            10: 8.232287186317052,
            11: 8.632169416543963,
            12: 8.836949774397729,
            13: 8.536534768345911,
            14: 8.29222285443426,
            15: 8.325928631158481,
            16: 8.364417170973164,
            17: 8.224185472086084,
            18: 8.691452229420179,
            19: 8.794366215253197,
            20: 8.553787508769659,
            21: 8.266361196461819,
            22: 8.352947802460598,
            23: 8.387963649445823,
            24: 8.242605357006067,
            25: 8.67228522732787,
            26: 8.872484519064836,
            27: 8.516066038917984,
            28: 8.290565180899275,
            29: 8.28252748502801,
            30: 8.418178225766528,
            31: 8.173808247578933,
            32: 8.656528573956045,
            33: 8.773588483294274,
            34: 8.478354546363153,
            35: 8.293358978278803,
            36: 8.337623145090127,
            37: 8.354987487392142,
            38: 8.243652590440611,
            39: 8.63836224815391,
            40: 8.815278680605777,
            41: 8.542098213674318,
            42: 8.35298998448145,
            43: 8.307370345969165,
            44: 8.346415451927015,
            45: 8.247544840422808,
            46: 8.655281081488274,
            47: 8.794921740843728,
            48: 8.518217603598385,
            49: 8.29342481558542,
            50: 8.312139498143768,
            51: 8.364911589692516,
            52: 8.219699901308157,
            53: 8.697675784285629,
            54: 8.827747758870997,
            55: 8.595712605834722,
            56: 8.345049900779202,
            57: 8.382383749547397,
            58: 8.41709802168986,
            59: 8.246621063217493,
            60: 8.73940776957732,
            61: 8.901173610109936,
            62: 8.61321604122556,
            63: 8.389205796614792,
            64: 8.4432543606576,
            65: 8.497070260094063,
            66: 8.3158998296513,
            67: 8.785006952849093,
            68: 8.934106652762534,
            69: 8.621814510882556,
            70: 8.429033608274977,
            71: 8.472905816034814,
            72: 8.561709259435174,
            73: 8.412863800642867,
            74: 8.832533320628622,
            75: 9.02983358638009,
            76: 8.74782459008626,
            77: 8.553279497941412,
            78: 8.639903719152095,
            79: 8.643735293094283,
            80: 8.52493985203344,
            81: 8.945273814781736,
            82: 9.1194267794894,
            83: 8.846866796133334,
            84: 8.633203869859575,
            85: 8.694378158713965,
            86: 8.743789092762064,
            87: 8.57023869642103,
            88: 9.034905255421075,
            89: 9.216479129889064,
            90: 8.879310490375008,
            91: 8.715127850724627,
            92: 8.754170003471238,
            93: 8.834846968168684,
            94: 8.67936606501323,
            95: 9.16954557485018,
            96: 9.350942885488614,
            97: 9.01918575331639,
            98: 8.825438730342611,
            99: 8.869301581835167,
            100: 8.906416761509108,
            101: 8.735684364768462,
            102: 9.210321998618758,
            103: 9.385115163806379,
            104: 9.140617848893118,
            105: 8.870658643038643,
            106: 8.966568934246077,
            107: 9.031680446477612,
            108: 8.86963671398931,
            109: 9.294603584616954,
            110: 9.454425584530089,
            111: 9.232869288086762,
            112: 8.975107808243758,
            113: 9.072101322502979,
            114: 9.136517087122941,
            115: 8.969054191723782,
            116: 9.440594205315822,
            117: 9.617866619550842,
            118: 9.295827234232151,
            119: 9.103024952226326,
            120: 9.15451760186333,
            121: 9.223263751186108,
            122: 9.047293182143521,
            123: 9.513665198860986,
            124: 9.669999559880944,
            125: 9.409322719538682,
            126: 9.196039602346898,
            127: 9.287352901232433,
            128: 9.288078591661046,
            129: 9.105435502006962,
            130: 9.595330575226452,
            131: 9.700844856090365,
            132: 9.433953783299343,
            133: 9.259424624610043,
            134: 9.298393097275115,
            135: 9.334887212308377,
            136: 9.15071487511058,
            137: 9.612540868335941,
            138: 9.823199669152121,
            139: 9.528732974680333,
            140: 9.31615375351715,
            141: 9.374173475937216,
            142: 9.340173077980944,
            143: 9.17531993947921,
            144: 9.672703010425447,
            145: 9.833474667223703,
            146: 9.535650358989757,
            147: 9.323200878469482,
            148: 9.368425536042839,
            149: 9.391197762774706,
            150: 9.275935847189112,
            151: 9.716459873358676,
            152: 9.78681221942096,
            153: 9.534347875433129,
            154: 9.371917226631092,
            155: 9.352313203773278,
            156: 9.453520832812664,
            157: 9.228295690849091,
            158: 9.734791556299673,
            159: 9.88239744337945,
            160: 9.573088423386423,
            161: 9.349998856335906,
            162: 9.387826390989025,
            163: 9.439111883879857,
            164: 9.258701164169722,
            165: 9.672912010474565,
            166: 9.915760582922104,
            167: 9.598666153412713,
            168: 9.349558106889956,
            169: 9.388503102737397,
            170: 9.457870613923783,
            171: 9.268604261189328,
            172: 9.700356857288233,
            173: 9.894302696784761,
            174: 9.592167915925616,
            175: 9.333707726715314,
            176: 9.386344640884982,
            177: 9.469449743029802,
            178: 9.252694926760057,
            179: 9.735866207515807,
            180: 9.864996425919847,
            181: 9.602121593848809,
            182: 9.387729575519105,
            183: 9.379661841180058,
            184: 9.470048278492191,
            185: 9.31810680460764,
            186: 9.758199156291557,
            187: 9.886565133708899,
            188: 9.617723152949742,
            189: 9.359945184315666,
            190: 9.39091159991353,
            191: 9.440794014347874,
            192: 9.332251610457849,
            193: 9.795793042090114,
            194: 9.900661404635802,
            195: 9.606353178678145,
            196: 9.395543986809189,
            197: 9.404392210054745,
            198: 9.46372425528925,
            199: 9.312075486692596,
            200: 9.825215823053059,
            201: 9.890000969298809,
            202: 9.605296378636533,
            203: 9.37918883669721,
            204: 9.421545563648777,
            205: 9.413092486826253,
            206: 9.333798647940004,
            207: 9.734059215347733,
            208: 9.949983984443037,
            209: 9.6121985484278,
            210: 9.341273432057832,
            211: 9.449079789617002,
            212: 9.468814315214619,
            213: 9.310378005912185,
            214: 9.72734136990846,
            215: 9.897737160428798,
            216: 9.608513298542139,
            217: 9.436646786862916,
            218: 9.44173151241943,
            219: 9.479536691572585,
            220: 9.287374791897545,
            221: 9.775834446272949,
            222: 9.901773803182014,
            223: 9.64666708639355,
            224: 9.39668004125765,
            225: 9.438297546932402,
            226: 9.461999195894983,
            227: 9.304962719627785,
            228: 9.778775398317151,
            229: 9.907512093078306,
            230: 9.631736870136079,
            231: 9.41146464893906,
            232: 9.426182864123142,
            233: 9.47524251684035,
            234: 9.30486676660316,
            235: 9.784483532153525,
            236: 9.92899615670756,
            237: 9.670444282519622,
            238: 9.403325200952592,
            239: 9.435804677403258,
            240: 9.477562701630385,
            241: 9.343509318839176,
            242: 9.80698437736861,
            243: 9.917462668702678,
            244: 9.626509881762962,
            245: 9.371100914501154,
            246: 9.462255202798664,
            247: 9.492437870025588,
            248: 9.294358276370483,
            249: 9.728373021927009,
            250: 9.886529816407021,
            251: 9.569285421042702,
            252: 9.366814961199257,
            253: 9.34689176256333,
            254: 9.454409109051737,
            255: 9.260045006438432,
            256: 9.698363068473885,
            257: 9.816988575733419,
            258: 9.52193111448629,
            259: 9.29712814035449,
            260: 9.294677926512662,
            261: 9.350444574227701,
            262: 9.147559253280656,
            263: 9.597882026373378,
            264: 9.780455616128192,
            265: 9.377735571885244,
            266: 9.14090410920211,
            267: 9.163054645988153,
            268: 9.216242383551727,
            269: 9.097732142954227,
            270: 9.54337384976299,
            271: 9.62948325895284,
            272: 9.349987092774906,
            273: 9.06905979757986,
            274: 9.119945160012493,
            275: 9.10212107072957,
            276: 8.98272922941889,
            277: 9.380541442366564,
            278: 9.491803952207366,
            279: 9.221440161106223,
            280: 9.002615588672679,
            281: 8.98685965833764,
            282: 9.048696495325624,
            283: 8.874048123506684,
            284: 9.275424899555876,
            285: 9.403354613974196,
            286: 9.140526059428048,
            287: 8.89573083524227,
            288: 8.934121093858948,
            289: 8.955317978344205,
            290: 8.778371568001672,
            291: 9.165320256898504,
            292: 9.331117567767832,
            293: 9.016255397443153,
            294: 8.751004870329506,
            295: 8.801334251802137,
            296: 8.838685426617532,
            297: 8.669216593246098,
            298: 9.117244111726396,
            299: 9.245260244443534,
            300: 8.935271836945544,
            301: 8.694491836732054,
            302: 8.685473130273508,
            303: 8.770485391321003,
            304: 8.59455680358996,
            305: 8.99006485268859,
            306: 9.101274808950711,
            307: 8.860063473729904,
            308: 8.571686187722252,
            309: 8.607871714590154,
            310: 8.611618812060545,
            311: 8.495787146658657,
            312: 8.918374945645358,
            313: 9.04083893612459,
            314: 8.752704586452236,
            315: 8.502716877846812,
            316: 8.517852889259968,
            317: 8.512475569298603,
            318: 8.353149665450154,
            319: 8.816785421479937,
            320: 8.914099917052345,
            321: 8.660974577628567,
            322: 8.365005275210802,
            323: 8.444574593247443,
            324: 8.433623110233599,
            325: 8.259152655954075,
            326: 8.734076537720492,
            327: 8.843043556507029,
            328: 8.539723913835093,
            329: 8.305681293276882,
            330: 8.31358201843329,
            331: 8.362990921308091,
            332: 8.23164815644191,
            333: 8.611426789986032,
            334: 8.760685567997598,
            335: 8.392237649201109,
            336: 8.206304649220911,
            337: 8.227128218247481,
            338: 8.25640946409948,
            339: 8.105298750909277,
            340: 8.519866063860858,
            341: 8.694963215873887,
            342: 8.342670091276547,
            343: 8.071936338379187,
            344: 8.165501419285457,
            345: 8.148997572914627,
            346: 7.986395996304026,
            347: 8.435877600536484,
            348: 8.509211987199985,
            349: 8.216105655079616,
            350: 7.9727794342797,
            351: 8.051192042949184,
            352: 8.043434869830364,
            353: 7.844105416634229,
            354: 8.405438418000418,
            355: 8.434901218174598,
            356: 8.118705841475258,
            357: 7.874071481309522,
            358: 7.920218450798264,
            359: 7.938016873037496,
            360: 7.798140187153802,
            361: 8.262490708495418,
            362: 8.339660689166566,
            363: 8.045953862334798,
            364: 7.816543856473682,
            365: 7.800372627825619,
            366: 7.844042143291405,
            367: 7.703344139291474,
            368: 8.139957244784707,
            369: 8.277227864281219,
            370: 7.963095586509671,
            371: 7.687903761184175,
            372: 7.745763727882769,
            373: 7.809232538790762,
            374: 7.611919715499811,
            375: 8.009429203331072,
            376: 8.169063559004465,
            377: 7.819845402188427,
            378: 7.604836996007125,
        },
    }
)

AIR_FCST_15_PROPHET_LOGISTIC_CAP_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
        },
        "fcst": {
            0: 474.8363017288656,
            1: 468.99171117849556,
            2: 502.0107150977976,
            3: 501.49961364980686,
            4: 505.7999464448948,
            5: 547.8463030880213,
            6: 587.6968798959065,
            7: 588.3403482152739,
            8: 539.7409068282652,
            9: 505.70514065476294,
            10: 471.8830792741277,
            11: 501.7918634254075,
            12: 514.935717783898,
            13: 509.0208355173735,
            14: 545.3488204468623,
        },
        "fcst_lower": {
            0: 445.08242175237444,
            1: 441.72751709909295,
            2: 470.55691169739845,
            3: 474.0525321394879,
            4: 478.2321425027879,
            5: 518.8270217221966,
            6: 559.1550095543314,
            7: 559.2980056250977,
            8: 511.6934102435192,
            9: 480.81906454294034,
            10: 442.61996850681754,
            11: 473.58061234926606,
            12: 484.36591417477575,
            13: 479.8175916881218,
            14: 517.8966869136175,
        },
        "fcst_upper": {
            0: 503.8120645009746,
            1: 498.3423255535767,
            2: 530.9445170423978,
            3: 532.0118942263415,
            4: 532.5239830355447,
            5: 576.0691450083493,
            6: 617.405134654996,
            7: 617.1023541799481,
            8: 567.7339721571983,
            9: 534.7247367000513,
            10: 499.73784308244615,
            11: 529.0246435279244,
            12: 543.5705482455107,
            13: 537.592677202221,
            14: 574.6001384569872,
        },
    }
)

PEYTON_FCST_30_PROPHET_DAILY_CAP_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.309701804674974,
            1: 7.332130661074342,
            2: 7.36764685017488,
            3: 7.187538991723003,
            4: 7.6364256219589155,
            5: 7.7649637273330665,
            6: 7.462621854852071,
            7: 7.224065560790778,
            8: 7.246552162060077,
            9: 7.282126330981348,
            10: 7.10207668658457,
            11: 7.5510217643915425,
            12: 7.6796185501343315,
            13: 7.377335590095167,
            14: 7.138838439826197,
            15: 7.16138441551181,
            16: 7.197018188744356,
            17: 7.017028377823432,
            18: 7.466033517539327,
            19: 7.594690592888185,
            20: 7.292468149417277,
            21: 7.054031741940442,
            22: 7.076638685900331,
            23: 7.112333652148555,
            24: 6.932405258240528,
            25: 7.381472038219104,
            26: 7.510190976335489,
            27: 7.208030617385161,
            28: 6.969656515430458,
            29: 6.992325985161949,
        },
        "fcst_lower": {
            0: 6.664679118887306,
            1: 6.6935062966607095,
            2: 6.734868361194695,
            3: 6.586846703023675,
            4: 7.024514620228759,
            5: 7.095533934909643,
            6: 6.884381951793827,
            7: 6.614058556523093,
            8: 6.614995860763193,
            9: 6.671628963387851,
            10: 6.4987763334536055,
            11: 6.955403477927713,
            12: 7.0490801036568795,
            13: 6.738989529460044,
            14: 6.517742315745279,
            15: 6.5916072379030695,
            16: 6.622692162098093,
            17: 6.346664742045041,
            18: 6.881641988019506,
            19: 7.004916292163072,
            20: 6.6606068489546555,
            21: 6.429378890162921,
            22: 6.455593468076069,
            23: 6.478560580057457,
            24: 6.355078775015013,
            25: 6.793512368343319,
            26: 6.889681715060315,
            27: 6.536936770051854,
            28: 6.32894734006989,
            29: 6.464396545834131,
        },
        "fcst_upper": {
            0: 7.924619899634765,
            1: 7.909939503205977,
            2: 7.990955047677133,
            3: 7.841224880695751,
            4: 8.272945285721484,
            5: 8.365619528575252,
            6: 8.0661006527869,
            7: 7.832055885696028,
            8: 7.815732760844865,
            9: 7.861941621187907,
            10: 7.719764315473959,
            11: 8.12714568338086,
            12: 8.229516419349281,
            13: 7.966065783938846,
            14: 7.7507129829672765,
            15: 7.752526155549491,
            16: 7.821471477029241,
            17: 7.608593337773231,
            18: 8.074147125043737,
            19: 8.18157577742058,
            20: 7.8745727933723755,
            21: 7.622286788415174,
            22: 7.681828983075624,
            23: 7.728809396951798,
            24: 7.548825990498768,
            25: 8.005467896603225,
            26: 8.128146048791287,
            27: 7.814187288136758,
            28: 7.5655046616171955,
            29: 7.588410903530529,
        },
    }
)

AIR_FCST_30_PROPHET_CUSTOM_SEASONALITY_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 452.96601621157333,
            1: 437.98832908311806,
            2: 566.4927510503155,
            3: 533.8909937431466,
            4: 567.9188293074376,
            5: 578.0143045952303,
            6: 647.6075715186254,
            7: 616.956642348948,
            8: 542.4720010345447,
            9: 532.8286114704305,
            10: 473.2093212270391,
            11: 527.8141700989343,
            12: 510.76906094986526,
            13: 483.2323136428713,
            14: 669.501284331564,
            15: 632.0560306519425,
            16: 671.3362288462214,
            17: 677.1212663968699,
            18: 750.7019844622027,
            19: 717.0699797805638,
            20: 632.5726183830741,
            21: 632.2576551688128,
            22: 562.6499432667736,
            23: 627.7175584666347,
            24: 599.7503585672704,
            25: 557.5602199713626,
            26: 745.6397414808766,
            27: 724.8009277979628,
            28: 747.9457991040732,
            29: 770.8109509671146,
        },
        "fcst_lower": {
            0: 424.8994717774092,
            1: 412.7019590055081,
            2: 538.544143057207,
            3: 505.6848176776265,
            4: 540.9866117246912,
            5: 548.2543036094157,
            6: 621.3748034389309,
            7: 591.5108120742709,
            8: 517.8498825443983,
            9: 506.89994251860844,
            10: 445.60613912114513,
            11: 500.4500001017916,
            12: 483.92117750254266,
            13: 456.64261439964093,
            14: 641.6349008157191,
            15: 606.1229381167503,
            16: 644.0711070774304,
            17: 650.2743200642118,
            18: 723.2366681762659,
            19: 689.6957582030766,
            20: 606.866335365676,
            21: 603.5654860518345,
            22: 535.5166190823288,
            23: 599.7006883692071,
            24: 574.555533493021,
            25: 528.3118986328117,
            26: 720.9669325631302,
            27: 696.311019044141,
            28: 722.2598973215389,
            29: 744.7121674124865,
        },
        "fcst_upper": {
            0: 479.11198647133193,
            1: 463.92056712896846,
            2: 592.7841465127738,
            3: 560.4412881535918,
            4: 593.7407294863663,
            5: 605.1479186815375,
            6: 674.873476971475,
            7: 645.9211692372113,
            8: 570.0325013586959,
            9: 560.2125174120044,
            10: 498.6001137647761,
            11: 554.4479495175004,
            12: 537.6414343726829,
            13: 509.16922751615664,
            14: 695.2856840314337,
            15: 659.424463561998,
            16: 695.8442702379866,
            17: 703.9579725859626,
            18: 777.3333892567645,
            19: 745.1617634118725,
            20: 658.7770256084456,
            21: 660.1527419546438,
            22: 589.5899932592852,
            23: 654.2140626474315,
            24: 625.3790538143977,
            25: 584.0289841837368,
            26: 772.7044239821412,
            27: 750.7329886534386,
            28: 777.1858875813338,
            29: 797.4644292161097,
        },
    }
)

PEYTON_FCST_30_PROPHET_CUSTOM_SEASONALITY_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.310204404948854,
            1: 7.305480197360137,
            2: 7.30965923862747,
            3: 7.094514957955274,
            4: 7.506039017835247,
            5: 7.594800909807456,
            6: 7.250966171095805,
            7: 6.965193791651218,
            8: 6.946210113397585,
            9: 6.941352852627586,
            10: 6.722546864139355,
            11: 7.135794857559768,
            12: 7.231537700553363,
            13: 6.899677113462629,
            14: 6.6304811880089405,
            15: 6.632169794832014,
            16: 6.65147318062203,
            17: 6.459624959467439,
            18: 6.901872222951885,
            19: 7.027856859645095,
            20: 6.726660301756082,
            21: 6.487731518608982,
            22: 6.518494699876626,
            23: 6.564929316021729,
            24: 6.397583172958472,
            25: 6.86110063995964,
            26: 7.004619653126363,
            27: 6.71682929447113,
            28: 6.48690743062501,
            29: 6.52213460943214,
        },
        "fcst_lower": {
            0: 6.726788786466419,
            1: 6.727851787147943,
            2: 6.737279515903056,
            3: 6.550498073046225,
            4: 6.952572537668496,
            5: 6.989309343413395,
            6: 6.728383343554542,
            7: 6.410635004556951,
            8: 6.379215999991831,
            9: 6.393439501498509,
            10: 6.176868616834364,
            11: 6.597108447865797,
            12: 6.660090046305426,
            13: 6.322017466338105,
            14: 6.066743091435035,
            15: 6.115686889613311,
            16: 6.136187500488641,
            17: 5.85146603255074,
            18: 6.375089849528449,
            19: 6.4910400994583,
            20: 6.153054105616886,
            21: 5.92286419233778,
            22: 5.954450199189329,
            23: 5.9868526231575,
            24: 5.867070586271821,
            25: 6.330352633577601,
            26: 6.440787940475338,
            27: 6.104088447438135,
            28: 5.89604671300344,
            29: 6.042822632291787,
        },
        "fcst_upper": {
            0: 7.866390766439251,
            1: 7.828101665448806,
            2: 7.873434351601799,
            3: 7.685766344319408,
            4: 8.081832080581423,
            5: 8.138087190271907,
            6: 7.798470261770245,
            7: 7.515399332903971,
            8: 7.461993576122207,
            9: 7.4691123124526095,
            10: 7.279958001655828,
            11: 7.660532609846931,
            12: 7.729517766876632,
            13: 7.432711662424305,
            14: 7.1861107442967205,
            15: 7.162436387583534,
            16: 7.216365260664922,
            17: 6.991879095326979,
            18: 7.44636612975707,
            19: 7.562234428757602,
            20: 7.253525743078088,
            21: 7.003887250880256,
            22: 7.063487442697169,
            23: 7.119021167343828,
            24: 6.955999042940917,
            25: 7.4251575313642775,
            26: 7.565136033469522,
            27: 7.270713445151623,
            28: 7.029987420401476,
            29: 7.062272300962427,
        },
    }
)

NONSEASONAL_FCST_15_PROPHET_ARG_FUTURE_SM_11 = pd.DataFrame(
    {
        "ds": {
            0: pd.Timestamp("1963-01-31 00:00:00"),
            1: pd.Timestamp("1963-02-28 00:00:00"),
            2: pd.Timestamp("1963-03-31 00:00:00"),
            3: pd.Timestamp("1963-04-30 00:00:00"),
            4: pd.Timestamp("1963-05-31 00:00:00"),
            5: pd.Timestamp("1963-06-30 00:00:00"),
            6: pd.Timestamp("1963-07-31 00:00:00"),
            7: pd.Timestamp("1963-08-31 00:00:00"),
            8: pd.Timestamp("1963-09-30 00:00:00"),
            9: pd.Timestamp("1963-10-31 00:00:00"),
            10: pd.Timestamp("1963-11-30 00:00:00"),
            11: pd.Timestamp("1963-12-31 00:00:00"),
        },
        "trend": {
            0: 1.4863506035356537,
            1: 1.5153722851288405,
            2: 1.5475034326070118,
            3: 1.5785980914568547,
            4: 1.610729238935026,
            5: 1.6418238977848691,
            6: 1.6739550452630403,
            7: 1.7060861927412116,
            8: 1.7371808515910547,
            9: 1.7693119990692259,
            10: 1.8004066579190692,
            11: 1.83253780539724,
        },
        "yhat_lower": {
            0: 1.1594374527914133,
            1: -2.248335089417451,
            2: 2.0604229200350743,
            3: 2.282279023693326,
            4: 1.2809544896936165,
            5: -0.3992332220272177,
            6: -3.552547372714546,
            7: 2.429955426700173,
            8: 2.9000236398478862,
            9: 0.6974054961124588,
            10: 0.9017089206384991,
            11: 0.9537477781206941,
        },
        "yhat_upper": {
            0: 1.6201165163554494,
            1: -1.7455747337323577,
            2: 2.531809100253131,
            3: 2.777959505427363,
            4: 1.7376132983833892,
            5: 0.07946819642707456,
            6: -3.0853192468466877,
            7: 2.8960848991428243,
            8: 3.3712332482620138,
            9: 1.1821260937994622,
            10: 1.3997416814227919,
            11: 1.4474825924984773,
        },
        "trend_lower": {
            0: 1.486350550058763,
            1: 1.5153720936439148,
            2: 1.5475030409711172,
            3: 1.5785974767875617,
            4: 1.6107283337535407,
            5: 1.6418227060078137,
            6: 1.6739535322032517,
            7: 1.706084373856565,
            8: 1.7371786410770564,
            9: 1.769309338677681,
            10: 1.8004035415083601,
            11: 1.832534164520744,
        },
        "trend_upper": {
            0: 1.486350659928231,
            1: 1.515372451724875,
            2: 1.5475037804692382,
            3: 1.5785986386258855,
            4: 1.6107300179980912,
            5: 1.6418249316742897,
            6: 1.6739563806098692,
            7: 1.7060878674683846,
            8: 1.737182890758364,
            9: 1.7693143896963959,
            10: 1.800409447090903,
            11: 1.8325410022110504,
        },
        "additive_terms": {
            0: -0.10603153621913787,
            1: -3.5100601864408625,
            2: 0.7525595383683356,
            3: 0.9495977533373023,
            4: -0.08872196007671039,
            5: -1.7897575752775112,
            6: -4.992084112210778,
            7: 0.9439920445988806,
            8: 1.410764220309051,
            9: -0.8269897561991282,
            10: -0.6332794813823102,
            11: -0.627787096526166,
        },
        "additive_terms_lower": {
            0: -0.10603153621913787,
            1: -3.5100601864408625,
            2: 0.7525595383683356,
            3: 0.9495977533373023,
            4: -0.08872196007671039,
            5: -1.7897575752775112,
            6: -4.992084112210778,
            7: 0.9439920445988806,
            8: 1.410764220309051,
            9: -0.8269897561991282,
            10: -0.6332794813823102,
            11: -0.627787096526166,
        },
        "additive_terms_upper": {
            0: -0.10603153621913787,
            1: -3.5100601864408625,
            2: 0.7525595383683356,
            3: 0.9495977533373023,
            4: -0.08872196007671039,
            5: -1.7897575752775112,
            6: -4.992084112210778,
            7: 0.9439920445988806,
            8: 1.410764220309051,
            9: -0.8269897561991282,
            10: -0.6332794813823102,
            11: -0.627787096526166,
        },
        "yearly": {
            0: -0.10603153621913787,
            1: -3.5100601864408625,
            2: 0.7525595383683356,
            3: 0.9495977533373023,
            4: -0.08872196007671039,
            5: -1.7897575752775112,
            6: -4.992084112210778,
            7: 0.9439920445988806,
            8: 1.410764220309051,
            9: -0.8269897561991282,
            10: -0.6332794813823102,
            11: -0.627787096526166,
        },
        "yearly_lower": {
            0: -0.10603153621913787,
            1: -3.5100601864408625,
            2: 0.7525595383683356,
            3: 0.9495977533373023,
            4: -0.08872196007671039,
            5: -1.7897575752775112,
            6: -4.992084112210778,
            7: 0.9439920445988806,
            8: 1.410764220309051,
            9: -0.8269897561991282,
            10: -0.6332794813823102,
            11: -0.627787096526166,
        },
        "yearly_upper": {
            0: -0.10603153621913787,
            1: -3.5100601864408625,
            2: 0.7525595383683356,
            3: 0.9495977533373023,
            4: -0.08872196007671039,
            5: -1.7897575752775112,
            6: -4.992084112210778,
            7: 0.9439920445988806,
            8: 1.410764220309051,
            9: -0.8269897561991282,
            10: -0.6332794813823102,
            11: -0.627787096526166,
        },
        "multiplicative_terms": {
            0: 0.0,
            1: 0.0,
            2: 0.0,
            3: 0.0,
            4: 0.0,
            5: 0.0,
            6: 0.0,
            7: 0.0,
            8: 0.0,
            9: 0.0,
            10: 0.0,
            11: 0.0,
        },
        "multiplicative_terms_lower": {
            0: 0.0,
            1: 0.0,
            2: 0.0,
            3: 0.0,
            4: 0.0,
            5: 0.0,
            6: 0.0,
            7: 0.0,
            8: 0.0,
            9: 0.0,
            10: 0.0,
            11: 0.0,
        },
        "multiplicative_terms_upper": {
            0: 0.0,
            1: 0.0,
            2: 0.0,
            3: 0.0,
            4: 0.0,
            5: 0.0,
            6: 0.0,
            7: 0.0,
            8: 0.0,
            9: 0.0,
            10: 0.0,
            11: 0.0,
        },
        "yhat": {
            0: 1.3803190673165158,
            1: -1.994687901312022,
            2: 2.3000629709753473,
            3: 2.528195844794157,
            4: 1.5220072788583157,
            5: -0.14793367749264208,
            6: -3.3181290669477375,
            7: 2.650078237340092,
            8: 3.1479450719001054,
            9: 0.9423222428700977,
            10: 1.167127176536759,
            11: 1.204750708871074,
        },
    }
)

AIR_FCST_30_PROPHET_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 466.54949529306384,
            1: 461.0149722219397,
            2: 493.42051383362895,
            3: 492.09716300129605,
            4: 496.43069102104533,
            5: 537.5706104154885,
            6: 577.1448049907949,
            7: 577.5779251624626,
            8: 529.0042295821432,
            9: 493.8507852015329,
            10: 459.98717217484693,
            11: 489.352454886114,
            12: 502.3800115074687,
            13: 496.27360400418974,
            14: 531.9184998721412,
            15: 528.0143396522675,
            16: 534.1153773178809,
            17: 573.5694202090814,
            18: 614.189938977541,
            19: 614.1506680384373,
            20: 566.2293188085794,
            21: 530.5315659720388,
            22: 497.68269580029374,
            23: 527.2074641183364,
            24: 538.1711703676725,
            25: 531.5641426276097,
            26: 570.4184320916362,
            27: 563.9262064953872,
            28: 571.8037322668091,
            29: 609.5581957151934,
        },
        "fcst_lower": {
            0: 436.66543323521887,
            1: 434.08218961824196,
            2: 463.69220344096215,
            3: 462.0751659406037,
            4: 467.76598827119955,
            5: 505.8520356783214,
            6: 549.3141576606173,
            7: 550.3899546190513,
            8: 502.81872758510326,
            9: 466.24020432761296,
            10: 430.4665703998807,
            11: 460.16737670536145,
            12: 473.8596106354481,
            13: 468.17109439503025,
            14: 502.9592032377311,
            15: 500.95868572567764,
            16: 505.11654752091164,
            17: 545.4451699085795,
            18: 584.9424565920709,
            19: 585.0593457336159,
            20: 538.8098189878858,
            21: 499.74638371229423,
            22: 468.8232517708133,
            23: 497.2896705579375,
            24: 511.45671004444404,
            25: 500.3644211985417,
            26: 544.0015236741305,
            27: 534.1427559429333,
            28: 544.0144882894072,
            29: 581.7969591787996,
        },
        "fcst_upper": {
            0: 494.38861170577394,
            1: 488.5518870859255,
            2: 521.3122112469476,
            3: 520.4399102319655,
            4: 523.931005158026,
            5: 566.178119883852,
            6: 606.1669026098009,
            7: 608.3477325943362,
            8: 558.2332904556636,
            9: 522.882506512789,
            10: 487.2921618559126,
            11: 517.7368606824481,
            12: 530.8435907663193,
            13: 524.1896920778432,
            14: 559.6675371699441,
            15: 557.474799838249,
            16: 560.5897837084689,
            17: 602.3868489857199,
            18: 642.2968195734655,
            19: 644.030142013098,
            20: 594.2218553261007,
            21: 560.2950574381408,
            22: 526.9077147025658,
            23: 555.4253978133032,
            24: 565.2390807788803,
            25: 560.0229214856699,
            26: 599.8227436725223,
            27: 592.1244528776316,
            28: 603.0971896013723,
            29: 638.7723104070045,
        },
    }
)

AIR_FCST_30_PROPHET_CAP_AND_FLOOR_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 475.1532782046899,
            1: 469.19332724731584,
            2: 503.09501509424797,
            3: 502.3043546207114,
            4: 506.8276560032621,
            5: 548.6664781115998,
            6: 588.6792337637517,
            7: 589.3572357297155,
            8: 541.0308636258886,
            9: 506.9540499402625,
            10: 473.20176525118853,
            11: 503.08513064927183,
            12: 516.0402922815176,
            13: 510.17911104897803,
            14: 546.4591808241485,
            15: 542.9239266057684,
            16: 549.7698203847091,
            17: 589.4202040295114,
            18: 630.4119972016963,
            19: 630.9237637324917,
            20: 583.8723702813984,
            21: 547.8718370084842,
            22: 515.6608558103559,
            23: 545.1869851982699,
            24: 556.4160884170091,
            25: 550.6603609242528,
            26: 589.2299878549468,
            27: 582.9070929557129,
            28: 592.0357124889904,
            29: 629.4305563722146,
        },
        "fcst_lower": {
            0: 445.3395443711149,
            1: 442.33283828047774,
            2: 473.4065517864172,
            3: 472.3422733141102,
            4: 478.2188373929017,
            5: 517.0541830910526,
            6: 560.8132337095608,
            7: 562.3266592520714,
            8: 514.8766805436387,
            9: 479.41117903767577,
            10: 443.8803251671445,
            11: 474.0175314026396,
            12: 487.5212766527527,
            13: 481.9349719051492,
            14: 516.8614551262343,
            15: 515.3770745638952,
            16: 520.8065583984169,
            17: 560.9024345724439,
            18: 601.2367939715982,
            19: 601.844916480008,
            20: 556.5629188883239,
            21: 517.3902520523155,
            22: 486.83777806666336,
            23: 515.4270272174365,
            24: 529.6516110502463,
            25: 519.5898993143903,
            26: 563.0260162280957,
            27: 552.6444610036451,
            28: 564.7562214012846,
            29: 601.7093827934974,
        },
        "fcst_upper": {
            0: 502.9268789047515,
            1: 496.74000386332597,
            2: 531.0230939594485,
            3: 530.50745194603,
            4: 534.257007624121,
            5: 577.4892366293137,
            6: 617.6425436630758,
            7: 620.125016753491,
            8: 570.3073098748073,
            9: 536.042712577469,
            10: 500.17320072264005,
            11: 531.3768629902295,
            12: 544.5891685624433,
            13: 537.7300273966486,
            14: 573.8500080233164,
            15: 571.99667589684,
            16: 575.8038948645637,
            17: 617.9323140966267,
            18: 658.7012733979813,
            19: 660.7630127843707,
            20: 611.7124422004916,
            21: 577.5027972451942,
            22: 544.2847324665361,
            23: 573.3319938049964,
            24: 583.644640726565,
            25: 578.7784734053895,
            26: 617.9831777957173,
            27: 610.4530629518694,
            28: 623.0946907933026,
            29: 657.7480443198558,
        },
    }
)

PEYTON_FCST_30_PROPHET_CAP_AND_FLOOR_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 9.86101525225098,
            1: 9.89003240995565,
            2: 9.930278231857494,
            3: 9.784139044260016,
            4: 10.181742594102822,
            5: 10.302363217267562,
            6: 10.050429250306896,
            7: 9.861015252250708,
            8: 9.890032409955243,
            9: 9.930278231857312,
            10: 9.784139044259918,
            11: 10.18174259410229,
            12: 10.30236321726758,
            13: 10.050429250306546,
            14: 9.861015252250434,
            15: 9.890032409955339,
            16: 9.930278231857514,
            17: 9.78413904425997,
            18: 10.181742594102731,
            19: 10.302363217267596,
            20: 10.05042925030657,
            21: 9.861015252250867,
            22: 9.890032409955339,
            23: 9.930278231857436,
            24: 9.784139044260082,
            25: 10.181742594101985,
            26: 10.302363217267446,
            27: 10.050429250306577,
            28: 9.861015252250596,
            29: 9.890032409955337,
        },
        "fcst_lower": {
            0: 7.523186110258983,
            1: 7.575393432430172,
            2: 7.635561729245729,
            3: 7.625208439274192,
            4: 7.963923897690048,
            5: 7.876072620474026,
            6: 7.953465125739613,
            7: 7.652371536131636,
            8: 7.619598524007825,
            9: 7.727352391847119,
            10: 7.5905279492768365,
            11: 8.023666366421168,
            12: 8.020968139682537,
            13: 7.747017836622224,
            14: 7.629569241306196,
            15: 7.8357356664953866,
            16: 7.870761785018109,
            17: 7.392173418510056,
            18: 8.072712387199624,
            19: 8.164211694017458,
            20: 7.753943791765615,
            21: 7.625176023048917,
            22: 7.6396263868463645,
            23: 7.630128907307829,
            24: 7.64113995264005,
            25: 8.028837974013635,
            26: 8.01673543963455,
            27: 7.683822540109567,
            28: 7.561195117626147,
            29: 7.995948172252461,
        },
        "fcst_upper": {
            0: 12.08973289894849,
            1: 11.98425076754169,
            2: 12.190423304929823,
            3: 12.153367219674141,
            4: 12.48755294099703,
            5: 12.479388409390472,
            6: 12.237686150680116,
            7: 12.06206958990392,
            8: 11.960677102502245,
            9: 12.055337762535864,
            10: 12.037647959991915,
            11: 12.28240533219545,
            12: 12.29542065865066,
            13: 12.20603517755278,
            14: 12.103815485868521,
            15: 12.035622752377364,
            16: 12.198735176204378,
            17: 11.922095490841548,
            18: 12.38307243375836,
            19: 12.435352493663697,
            20: 12.147049326147211,
            21: 11.962957077824154,
            22: 12.081392902111746,
            23: 12.175395109838217,
            24: 11.998325144545058,
            25: 12.441980194908517,
            26: 12.502881352045287,
            27: 12.281079278334424,
            28: 12.016659812808099,
            29: 12.02169036520016,
        },
    }
)

AIR_FCST_30_PROPHET_INCL_HIST_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1949-01-01 00:00:00"),
            1: pd.Timestamp("1949-02-01 00:00:00"),
            2: pd.Timestamp("1949-03-01 00:00:00"),
            3: pd.Timestamp("1949-04-01 00:00:00"),
            4: pd.Timestamp("1949-05-01 00:00:00"),
            5: pd.Timestamp("1949-06-01 00:00:00"),
            6: pd.Timestamp("1949-07-01 00:00:00"),
            7: pd.Timestamp("1949-08-01 00:00:00"),
            8: pd.Timestamp("1949-09-01 00:00:00"),
            9: pd.Timestamp("1949-10-01 00:00:00"),
            10: pd.Timestamp("1949-11-01 00:00:00"),
            11: pd.Timestamp("1949-12-01 00:00:00"),
            12: pd.Timestamp("1950-01-01 00:00:00"),
            13: pd.Timestamp("1950-02-01 00:00:00"),
            14: pd.Timestamp("1950-03-01 00:00:00"),
            15: pd.Timestamp("1950-04-01 00:00:00"),
            16: pd.Timestamp("1950-05-01 00:00:00"),
            17: pd.Timestamp("1950-06-01 00:00:00"),
            18: pd.Timestamp("1950-07-01 00:00:00"),
            19: pd.Timestamp("1950-08-01 00:00:00"),
            20: pd.Timestamp("1950-09-01 00:00:00"),
            21: pd.Timestamp("1950-10-01 00:00:00"),
            22: pd.Timestamp("1950-11-01 00:00:00"),
            23: pd.Timestamp("1950-12-01 00:00:00"),
            24: pd.Timestamp("1951-01-01 00:00:00"),
            25: pd.Timestamp("1951-02-01 00:00:00"),
            26: pd.Timestamp("1951-03-01 00:00:00"),
            27: pd.Timestamp("1951-04-01 00:00:00"),
            28: pd.Timestamp("1951-05-01 00:00:00"),
            29: pd.Timestamp("1951-06-01 00:00:00"),
            30: pd.Timestamp("1951-07-01 00:00:00"),
            31: pd.Timestamp("1951-08-01 00:00:00"),
            32: pd.Timestamp("1951-09-01 00:00:00"),
            33: pd.Timestamp("1951-10-01 00:00:00"),
            34: pd.Timestamp("1951-11-01 00:00:00"),
            35: pd.Timestamp("1951-12-01 00:00:00"),
            36: pd.Timestamp("1952-01-01 00:00:00"),
            37: pd.Timestamp("1952-02-01 00:00:00"),
            38: pd.Timestamp("1952-03-01 00:00:00"),
            39: pd.Timestamp("1952-04-01 00:00:00"),
            40: pd.Timestamp("1952-05-01 00:00:00"),
            41: pd.Timestamp("1952-06-01 00:00:00"),
            42: pd.Timestamp("1952-07-01 00:00:00"),
            43: pd.Timestamp("1952-08-01 00:00:00"),
            44: pd.Timestamp("1952-09-01 00:00:00"),
            45: pd.Timestamp("1952-10-01 00:00:00"),
            46: pd.Timestamp("1952-11-01 00:00:00"),
            47: pd.Timestamp("1952-12-01 00:00:00"),
            48: pd.Timestamp("1953-01-01 00:00:00"),
            49: pd.Timestamp("1953-02-01 00:00:00"),
            50: pd.Timestamp("1953-03-01 00:00:00"),
            51: pd.Timestamp("1953-04-01 00:00:00"),
            52: pd.Timestamp("1953-05-01 00:00:00"),
            53: pd.Timestamp("1953-06-01 00:00:00"),
            54: pd.Timestamp("1953-07-01 00:00:00"),
            55: pd.Timestamp("1953-08-01 00:00:00"),
            56: pd.Timestamp("1953-09-01 00:00:00"),
            57: pd.Timestamp("1953-10-01 00:00:00"),
            58: pd.Timestamp("1953-11-01 00:00:00"),
            59: pd.Timestamp("1953-12-01 00:00:00"),
            60: pd.Timestamp("1954-01-01 00:00:00"),
            61: pd.Timestamp("1954-02-01 00:00:00"),
            62: pd.Timestamp("1954-03-01 00:00:00"),
            63: pd.Timestamp("1954-04-01 00:00:00"),
            64: pd.Timestamp("1954-05-01 00:00:00"),
            65: pd.Timestamp("1954-06-01 00:00:00"),
            66: pd.Timestamp("1954-07-01 00:00:00"),
            67: pd.Timestamp("1954-08-01 00:00:00"),
            68: pd.Timestamp("1954-09-01 00:00:00"),
            69: pd.Timestamp("1954-10-01 00:00:00"),
            70: pd.Timestamp("1954-11-01 00:00:00"),
            71: pd.Timestamp("1954-12-01 00:00:00"),
            72: pd.Timestamp("1955-01-01 00:00:00"),
            73: pd.Timestamp("1955-02-01 00:00:00"),
            74: pd.Timestamp("1955-03-01 00:00:00"),
            75: pd.Timestamp("1955-04-01 00:00:00"),
            76: pd.Timestamp("1955-05-01 00:00:00"),
            77: pd.Timestamp("1955-06-01 00:00:00"),
            78: pd.Timestamp("1955-07-01 00:00:00"),
            79: pd.Timestamp("1955-08-01 00:00:00"),
            80: pd.Timestamp("1955-09-01 00:00:00"),
            81: pd.Timestamp("1955-10-01 00:00:00"),
            82: pd.Timestamp("1955-11-01 00:00:00"),
            83: pd.Timestamp("1955-12-01 00:00:00"),
            84: pd.Timestamp("1956-01-01 00:00:00"),
            85: pd.Timestamp("1956-02-01 00:00:00"),
            86: pd.Timestamp("1956-03-01 00:00:00"),
            87: pd.Timestamp("1956-04-01 00:00:00"),
            88: pd.Timestamp("1956-05-01 00:00:00"),
            89: pd.Timestamp("1956-06-01 00:00:00"),
            90: pd.Timestamp("1956-07-01 00:00:00"),
            91: pd.Timestamp("1956-08-01 00:00:00"),
            92: pd.Timestamp("1956-09-01 00:00:00"),
            93: pd.Timestamp("1956-10-01 00:00:00"),
            94: pd.Timestamp("1956-11-01 00:00:00"),
            95: pd.Timestamp("1956-12-01 00:00:00"),
            96: pd.Timestamp("1957-01-01 00:00:00"),
            97: pd.Timestamp("1957-02-01 00:00:00"),
            98: pd.Timestamp("1957-03-01 00:00:00"),
            99: pd.Timestamp("1957-04-01 00:00:00"),
            100: pd.Timestamp("1957-05-01 00:00:00"),
            101: pd.Timestamp("1957-06-01 00:00:00"),
            102: pd.Timestamp("1957-07-01 00:00:00"),
            103: pd.Timestamp("1957-08-01 00:00:00"),
            104: pd.Timestamp("1957-09-01 00:00:00"),
            105: pd.Timestamp("1957-10-01 00:00:00"),
            106: pd.Timestamp("1957-11-01 00:00:00"),
            107: pd.Timestamp("1957-12-01 00:00:00"),
            108: pd.Timestamp("1958-01-01 00:00:00"),
            109: pd.Timestamp("1958-02-01 00:00:00"),
            110: pd.Timestamp("1958-03-01 00:00:00"),
            111: pd.Timestamp("1958-04-01 00:00:00"),
            112: pd.Timestamp("1958-05-01 00:00:00"),
            113: pd.Timestamp("1958-06-01 00:00:00"),
            114: pd.Timestamp("1958-07-01 00:00:00"),
            115: pd.Timestamp("1958-08-01 00:00:00"),
            116: pd.Timestamp("1958-09-01 00:00:00"),
            117: pd.Timestamp("1958-10-01 00:00:00"),
            118: pd.Timestamp("1958-11-01 00:00:00"),
            119: pd.Timestamp("1958-12-01 00:00:00"),
            120: pd.Timestamp("1959-01-01 00:00:00"),
            121: pd.Timestamp("1959-02-01 00:00:00"),
            122: pd.Timestamp("1959-03-01 00:00:00"),
            123: pd.Timestamp("1959-04-01 00:00:00"),
            124: pd.Timestamp("1959-05-01 00:00:00"),
            125: pd.Timestamp("1959-06-01 00:00:00"),
            126: pd.Timestamp("1959-07-01 00:00:00"),
            127: pd.Timestamp("1959-08-01 00:00:00"),
            128: pd.Timestamp("1959-09-01 00:00:00"),
            129: pd.Timestamp("1959-10-01 00:00:00"),
            130: pd.Timestamp("1959-11-01 00:00:00"),
            131: pd.Timestamp("1959-12-01 00:00:00"),
            132: pd.Timestamp("1960-01-01 00:00:00"),
            133: pd.Timestamp("1960-02-01 00:00:00"),
            134: pd.Timestamp("1960-03-01 00:00:00"),
            135: pd.Timestamp("1960-04-01 00:00:00"),
            136: pd.Timestamp("1960-05-01 00:00:00"),
            137: pd.Timestamp("1960-06-01 00:00:00"),
            138: pd.Timestamp("1960-07-01 00:00:00"),
            139: pd.Timestamp("1960-08-01 00:00:00"),
            140: pd.Timestamp("1960-09-01 00:00:00"),
            141: pd.Timestamp("1960-10-01 00:00:00"),
            142: pd.Timestamp("1960-11-01 00:00:00"),
            143: pd.Timestamp("1960-12-01 00:00:00"),
            144: pd.Timestamp("1961-01-01 00:00:00"),
            145: pd.Timestamp("1961-02-01 00:00:00"),
            146: pd.Timestamp("1961-03-01 00:00:00"),
            147: pd.Timestamp("1961-04-01 00:00:00"),
            148: pd.Timestamp("1961-05-01 00:00:00"),
            149: pd.Timestamp("1961-06-01 00:00:00"),
            150: pd.Timestamp("1961-07-01 00:00:00"),
            151: pd.Timestamp("1961-08-01 00:00:00"),
            152: pd.Timestamp("1961-09-01 00:00:00"),
            153: pd.Timestamp("1961-10-01 00:00:00"),
            154: pd.Timestamp("1961-11-01 00:00:00"),
            155: pd.Timestamp("1961-12-01 00:00:00"),
            156: pd.Timestamp("1962-01-01 00:00:00"),
            157: pd.Timestamp("1962-02-01 00:00:00"),
            158: pd.Timestamp("1962-03-01 00:00:00"),
            159: pd.Timestamp("1962-04-01 00:00:00"),
            160: pd.Timestamp("1962-05-01 00:00:00"),
            161: pd.Timestamp("1962-06-01 00:00:00"),
            162: pd.Timestamp("1962-07-01 00:00:00"),
            163: pd.Timestamp("1962-08-01 00:00:00"),
            164: pd.Timestamp("1962-09-01 00:00:00"),
            165: pd.Timestamp("1962-10-01 00:00:00"),
            166: pd.Timestamp("1962-11-01 00:00:00"),
            167: pd.Timestamp("1962-12-01 00:00:00"),
            168: pd.Timestamp("1963-01-01 00:00:00"),
            169: pd.Timestamp("1963-02-01 00:00:00"),
            170: pd.Timestamp("1963-03-01 00:00:00"),
            171: pd.Timestamp("1963-04-01 00:00:00"),
            172: pd.Timestamp("1963-05-01 00:00:00"),
            173: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 86.11425834745359,
            1: 79.59157421323678,
            2: 111.10458325180285,
            3: 108.79307135637535,
            4: 112.17031447634932,
            5: 152.32207280769836,
            6: 190.93998248396457,
            7: 190.384941593286,
            8: 140.82308495061946,
            9: 104.71335567096912,
            10: 69.86158158244208,
            11: 98.27057939515473,
            12: 110.3099749546753,
            13: 103.21540638955767,
            14: 137.96776968551507,
            15: 133.07544840635495,
            16: 138.22020117586845,
            17: 176.68608300778038,
            18: 216.35031688014172,
            19: 215.32288491504698,
            20: 166.4133746591988,
            21: 129.75933695879095,
            22: 95.92230576105177,
            23: 124.49078921522904,
            24: 134.46633443376336,
            25: 126.87114566290276,
            26: 164.8329025829763,
            27: 157.35251595592564,
            28: 164.2737568935713,
            29: 201.04005934705967,
            30: 241.7517470055949,
            31: 240.25133181357876,
            32: 192.0109048099219,
            33: 154.8230353191886,
            34: 122.0096430396186,
            35: 150.67552999982493,
            36: 158.58484706997064,
            37: 150.56066466855836,
            38: 185.24184836399849,
            39: 185.50193841023335,
            40: 187.1219160283825,
            41: 228.94482654992382,
            42: 266.5179295785584,
            43: 266.4339996971423,
            44: 216.23683126382312,
            45: 180.68189834216568,
            46: 144.82578595159177,
            47: 173.0133348777495,
            48: 187.11155196382904,
            49: 180.58890391118075,
            50: 212.10194553956717,
            51: 209.79047031813906,
            52: 213.1677489291075,
            53: 253.31954393446358,
            54: 291.93748910097764,
            55: 291.3824848835582,
            56: 241.94025865542042,
            57: 205.9463007446584,
            58: 171.21415707015254,
            59: 199.7389262512733,
            60: 212.09849371406403,
            61: 205.3240970522248,
            62: 240.36564787373882,
            63: 235.7934984953025,
            64: 241.24809503973165,
            65: 280.3062133884173,
            66: 320.54357937380206,
            67: 320.10838389218543,
            68: 271.7911101198216,
            69: 235.95661185252243,
            70: 202.96643806900153,
            71: 232.35446095628674,
            72: 243.17686359384143,
            73: 236.4285322420013,
            74: 275.28282121864504,
            75: 268.7905950827965,
            76: 276.6681203320233,
            77: 314.4225832408065,
            78: 356.09055521092193,
            79: 355.5783005035952,
            80: 308.32603398463414,
            81: 272.09441556659294,
            82: 240.26914939547618,
            83: 269.89128746108764,
            84: 278.78873067348604,
            85: 271.7526744216841,
            86: 307.3582341925714,
            87: 308.60645038841386,
            88: 311.1826791067339,
            89: 353.9937157651269,
            90: 392.5230682953132,
            91: 393.4272628988327,
            92: 344.21821895696945,
            93: 309.6195355431771,
            94: 274.75154764406074,
            95: 303.8953460852541,
            96: 318.9816876702024,
            97: 313.44716409811014,
            98: 345.85270525731136,
            99: 344.52935392400923,
            100: 348.86288145895,
            101: 390.0028003998368,
            102: 429.57699453621296,
            103: 430.010114254319,
            104: 381.4364182204383,
            105: 346.28297340090086,
            106: 312.419359907483,
            107: 341.78464216707835,
            108: 354.81219832170694,
            109: 348.70579035170067,
            110: 384.3506861470722,
            111: 380.4465258468513,
            112: 386.54756343470376,
            113: 426.0016062455577,
            114: 466.6221249362544,
            115: 466.58285399715004,
            116: 418.66150476729183,
            117: 382.9637519307517,
            118: 350.11488175900627,
            119: 379.63965007705036,
            120: 390.6033563263862,
            121: 383.9963285863248,
            122: 422.85061805034945,
            123: 416.3583924541015,
            124: 424.23591822552265,
            125: 461.99038167390876,
            126: 503.6583541662195,
            127: 503.14609996909974,
            128: 455.8938339603467,
            129: 419.6622160360509,
            130: 387.8369503751452,
            131: 417.4590889017966,
            132: 426.3565325906009,
            133: 419.3204768152069,
            134: 454.926037031764,
            135: 456.17425370401554,
            136: 458.7504828957302,
            137: 501.5615200432955,
            138: 540.0908730468717,
            139: 540.9950681395676,
            140: 491.78602468036047,
            141: 457.1873417336489,
            142: 422.3193543171839,
            143: 451.46315322546207,
            144: 466.54949529306384,
            145: 461.0149722219397,
            146: 493.42051383362895,
            147: 492.09716300129605,
            148: 496.43069102104533,
            149: 537.5706104154885,
            150: 577.1448049907949,
            151: 577.5779251624626,
            152: 529.0042295821432,
            153: 493.8507852015329,
            154: 459.98717217484693,
            155: 489.352454886114,
            156: 502.3800115074687,
            157: 496.27360400418974,
            158: 531.9184998721412,
            159: 528.0143396522675,
            160: 534.1153773178809,
            161: 573.5694202090814,
            162: 614.189938977541,
            163: 614.1506680384373,
            164: 566.2293188085794,
            165: 530.5315659720388,
            166: 497.68269580029374,
            167: 527.2074641183364,
            168: 538.1711703676725,
            169: 531.5641426276097,
            170: 570.4184320916362,
            171: 563.9262064953872,
            172: 571.8037322668091,
            173: 609.5581957151934,
        },
        "fcst_lower": {
            0: 58.35171537641107,
            1: 52.01345506826378,
            2: 82.53512372357356,
            3: 81.39252561407814,
            4: 86.530574823723,
            5: 123.78752758315792,
            6: 161.67472855017309,
            7: 163.34071294551356,
            8: 112.84467857309455,
            9: 77.87583758048768,
            10: 41.87894473401458,
            11: 69.8339622247174,
            12: 79.55424973961497,
            13: 75.95780230120154,
            14: 110.72399332130186,
            15: 103.6165877500936,
            16: 109.29024825212592,
            17: 147.64778021468237,
            18: 186.94983953258824,
            19: 188.60283637963727,
            20: 137.29532589152177,
            21: 100.22453594699246,
            22: 65.94278721255161,
            23: 96.46880785217026,
            24: 106.04899039543446,
            25: 97.7082685365992,
            26: 137.34009960722608,
            27: 127.58856756209913,
            28: 134.82940972741326,
            29: 173.87374890316346,
            30: 213.66062247353835,
            31: 210.65042357407654,
            32: 164.7801463553219,
            33: 126.11757137889458,
            34: 94.15397854320017,
            35: 119.79322418851233,
            36: 132.11706454207172,
            37: 121.40113286926073,
            38: 158.61269137098546,
            39: 156.58751296351025,
            40: 159.39830761960968,
            41: 199.51980066809156,
            42: 237.92686993387179,
            43: 238.04567844946166,
            44: 189.0402120367499,
            45: 153.6258609851177,
            46: 116.50772210643913,
            47: 144.95155507458452,
            48: 158.5785832284551,
            49: 150.685550237556,
            50: 184.24871034519677,
            51: 182.99456388917778,
            52: 185.80868392227282,
            53: 226.04837301024975,
            54: 262.4139747369977,
            55: 261.3252767274595,
            56: 212.69133689619886,
            57: 176.81376998372394,
            58: 142.02320739121447,
            59: 168.77108949582905,
            60: 182.52532396919946,
            61: 176.17914238414875,
            62: 210.18632950931564,
            63: 205.78460187698437,
            64: 214.35101345614555,
            65: 251.0715210842717,
            66: 290.5165330602272,
            67: 290.5442780635789,
            68: 245.38966694734594,
            69: 207.0599297412218,
            70: 175.99020533336844,
            71: 203.59940432986627,
            72: 215.2556079673936,
            73: 208.62061791002193,
            74: 246.95208293900413,
            75: 239.92735138925363,
            76: 246.44453129461104,
            77: 286.17818053146596,
            78: 327.0808701383512,
            79: 328.1825691458681,
            80: 279.48408216089376,
            81: 241.86556817186778,
            82: 212.03096361246236,
            83: 241.94655338542876,
            84: 251.1538992767218,
            85: 242.47369906975405,
            86: 277.27872283151225,
            87: 278.5063467257605,
            88: 283.01386180669573,
            89: 325.5455858090254,
            90: 362.8882260178602,
            91: 366.7220927949039,
            92: 316.87221677022745,
            93: 281.53251256959993,
            94: 247.47843231532093,
            95: 276.3379385124987,
            96: 288.04991319848347,
            97: 283.6383822527503,
            98: 317.76412969015263,
            99: 315.154380486412,
            100: 319.7228990984791,
            101: 362.9968398663666,
            102: 400.7546195325761,
            103: 401.23726042520184,
            104: 352.8938624122426,
            105: 318.5324937442884,
            106: 284.97330080350304,
            107: 312.6996418766803,
            108: 326.3702386734806,
            109: 319.2274577927696,
            110: 355.937629005995,
            111: 353.8291223797033,
            112: 357.6952037322711,
            113: 397.7614952441694,
            114: 437.8045618786822,
            115: 437.85058156274516,
            116: 389.32234897167626,
            117: 354.21819734478044,
            118: 322.3630717500529,
            119: 351.80698712716753,
            120: 361.78538778213976,
            121: 356.2368453398524,
            122: 395.0143363978388,
            123: 389.05398737033573,
            124: 395.04754377895813,
            125: 431.20607396304496,
            126: 474.21480607048096,
            127: 474.2085409117912,
            128: 426.19627428521034,
            129: 391.504503806651,
            130: 359.19650553912106,
            131: 387.9953949489711,
            132: 398.7537587554718,
            133: 391.7089410792193,
            134: 427.6239708737491,
            135: 426.67371945671476,
            136: 431.6219760589072,
            137: 471.9532472488163,
            138: 512.5688831964129,
            139: 512.1928884038172,
            140: 463.48330602625356,
            141: 428.7364574241842,
            142: 394.05081493996653,
            143: 422.0186953617188,
            144: 437.14515620540465,
            145: 434.7513540720078,
            146: 465.82308686757347,
            147: 463.0296726556158,
            148: 466.60999267378304,
            149: 507.3471078114828,
            150: 548.440803723081,
            151: 548.7399769186591,
            152: 500.97864268460944,
            153: 465.69102217836263,
            154: 431.89153440118076,
            155: 460.8349884123933,
            156: 474.54286857842993,
            157: 467.4447948364811,
            158: 501.10626518749297,
            159: 497.7892372890249,
            160: 506.1669564595403,
            161: 544.114387426296,
            162: 585.5392609242225,
            163: 585.4325271170283,
            164: 537.3935726404692,
            165: 502.6859947709603,
            166: 470.0625908041732,
            167: 499.5631510720678,
            168: 509.23013566503994,
            169: 501.6260353670143,
            170: 541.5376107162467,
            171: 536.5413679249434,
            172: 542.50022135719,
            173: 579.8206258228705,
        },
        "fcst_upper": {
            0: 115.95738986832308,
            1: 106.47049978254572,
            2: 138.51288435353723,
            3: 136.76338975888896,
            4: 141.01677018087375,
            5: 180.4049397115869,
            6: 219.65848067209424,
            7: 218.1798554124835,
            8: 170.23934624861369,
            9: 133.34684239300822,
            10: 98.6149283192809,
            11: 127.7003276894163,
            12: 139.9524174432575,
            13: 131.2884776876153,
            14: 165.13710829514272,
            15: 160.47036929971844,
            16: 164.37865893181046,
            17: 203.458515684546,
            18: 247.56368807943244,
            19: 243.72375508606405,
            20: 193.78991044729545,
            21: 158.00893137945786,
            22: 125.89190591983605,
            23: 155.67115849406474,
            24: 166.41082128200478,
            25: 156.59709773742162,
            26: 195.84697222587118,
            27: 186.40492903222687,
            28: 192.65343843049112,
            29: 228.2067715088006,
            30: 269.08950964903585,
            31: 269.7809088157101,
            32: 221.24857470932346,
            33: 182.1214273812356,
            34: 151.47783341117517,
            35: 178.85225151956212,
            36: 188.14897974853582,
            37: 179.35215236162847,
            38: 213.90050094016755,
            39: 215.25956251932297,
            40: 215.79165600084434,
            41: 256.47345886406066,
            42: 296.2765332135744,
            43: 295.5935831381163,
            44: 244.0560120951002,
            45: 206.67855282762847,
            46: 172.54327490423304,
            47: 200.9751568035486,
            48: 215.75198966614408,
            49: 211.970148958182,
            50: 242.39217646316376,
            51: 237.07446641106378,
            52: 240.97837072732426,
            53: 281.8590413863521,
            54: 319.73414302807197,
            55: 320.38277541977163,
            56: 271.4727402524943,
            57: 234.75967425327985,
            58: 198.33097243570788,
            59: 227.92227850801186,
            60: 240.80368117029747,
            61: 232.77795894595988,
            62: 270.8214556396082,
            63: 263.7001787280421,
            64: 269.9823957367236,
            65: 308.5720586474864,
            66: 348.8047430813511,
            67: 347.2848273656415,
            68: 301.5760062609454,
            69: 265.85984963832465,
            70: 232.3659457697289,
            71: 261.0247576209622,
            72: 272.04486930428556,
            73: 268.15097967881366,
            74: 304.6406123197567,
            75: 295.03604567195487,
            76: 305.78875565568404,
            77: 343.3837218354856,
            78: 383.353497268816,
            79: 385.36292384669713,
            80: 336.84600144392607,
            81: 299.4164058677364,
            82: 268.03858242826533,
            83: 298.740865745875,
            84: 308.62488681592527,
            85: 301.20698761762924,
            86: 333.7356013393376,
            87: 337.2998565119582,
            88: 341.5820242832357,
            89: 382.9342978500436,
            90: 420.12354619717337,
            91: 424.36112256228756,
            92: 373.4649598715223,
            93: 339.181138209348,
            94: 301.5965704742146,
            95: 334.1834041912477,
            96: 347.3553252291854,
            97: 343.76811911175247,
            98: 374.1815931619899,
            99: 374.2512202380221,
            100: 375.71687252145205,
            101: 420.2744626480952,
            102: 457.3331012427828,
            103: 461.4165318566192,
            104: 410.4999514937903,
            105: 376.5521605027509,
            106: 339.7633879497327,
            107: 370.59065441357563,
            108: 383.486639279808,
            109: 377.76280765230234,
            110: 412.3074733764853,
            111: 409.0643162339103,
            112: 413.6375932261566,
            113: 453.3751414455849,
            114: 495.6795071687754,
            115: 493.30561201260326,
            116: 446.60530482122164,
            117: 409.676151158002,
            118: 379.09613476768214,
            119: 406.76569758162407,
            120: 419.39515633344337,
            121: 411.1735409394643,
            122: 451.6787049040352,
            123: 445.9176721726114,
            124: 452.8070046913921,
            125: 488.9835845375913,
            126: 530.8961834292471,
            127: 531.8126861975162,
            128: 484.7524421356495,
            129: 448.34602314229005,
            130: 415.64640211523135,
            131: 448.50689723183774,
            132: 454.5357793911735,
            133: 449.4314571884045,
            134: 483.71574762965236,
            135: 486.7913318505822,
            136: 487.41780403961235,
            137: 532.7254176335106,
            138: 570.164863005493,
            139: 569.5946294339088,
            140: 520.9437454077578,
            141: 487.5015258207042,
            142: 450.9127468648025,
            143: 480.29869684570025,
            144: 495.1505606961323,
            145: 489.38420873238925,
            146: 523.006817955284,
            147: 520.2828017474475,
            148: 524.6733395267563,
            149: 563.1031094020462,
            150: 603.2411617781074,
            151: 605.0241628084635,
            152: 559.19000138933,
            153: 522.0774074906897,
            154: 488.7629215857109,
            155: 517.1446039156065,
            156: 530.0668549750725,
            157: 524.7715350212144,
            158: 560.8344513847136,
            159: 556.4562568244145,
            160: 565.0130690950169,
            161: 601.7107280697649,
            162: 641.4486581013902,
            163: 641.8685436191367,
            164: 593.3748502436724,
            165: 559.7334836367007,
            166: 525.7904583862356,
            167: 557.2311428297331,
            168: 568.5787936637811,
            169: 560.7702073397403,
            170: 599.2956139837394,
            171: 596.051358567354,
            172: 600.8879880649158,
            173: 640.5116406281757,
        },
    }
)

PEYTON_FCST_15_PROPHET_INCL_HIST_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2012-05-02 00:00:00"),
            1: pd.Timestamp("2012-05-03 00:00:00"),
            2: pd.Timestamp("2012-05-04 00:00:00"),
            3: pd.Timestamp("2012-05-05 00:00:00"),
            4: pd.Timestamp("2012-05-06 00:00:00"),
            5: pd.Timestamp("2012-05-07 00:00:00"),
            6: pd.Timestamp("2012-05-08 00:00:00"),
            7: pd.Timestamp("2012-05-09 00:00:00"),
            8: pd.Timestamp("2012-05-10 00:00:00"),
            9: pd.Timestamp("2012-05-11 00:00:00"),
            10: pd.Timestamp("2012-05-12 00:00:00"),
            11: pd.Timestamp("2012-05-13 00:00:00"),
            12: pd.Timestamp("2012-05-14 00:00:00"),
            13: pd.Timestamp("2012-05-15 00:00:00"),
            14: pd.Timestamp("2012-05-16 00:00:00"),
            15: pd.Timestamp("2012-05-17 00:00:00"),
            16: pd.Timestamp("2012-05-18 00:00:00"),
            17: pd.Timestamp("2012-05-19 00:00:00"),
            18: pd.Timestamp("2012-05-20 00:00:00"),
            19: pd.Timestamp("2012-05-21 00:00:00"),
            20: pd.Timestamp("2012-05-22 00:00:00"),
            21: pd.Timestamp("2012-05-23 00:00:00"),
            22: pd.Timestamp("2012-05-24 00:00:00"),
            23: pd.Timestamp("2012-05-25 00:00:00"),
            24: pd.Timestamp("2012-05-26 00:00:00"),
            25: pd.Timestamp("2012-05-27 00:00:00"),
            26: pd.Timestamp("2012-05-28 00:00:00"),
            27: pd.Timestamp("2012-05-29 00:00:00"),
            28: pd.Timestamp("2012-05-30 00:00:00"),
            29: pd.Timestamp("2012-05-31 00:00:00"),
            30: pd.Timestamp("2012-06-01 00:00:00"),
            31: pd.Timestamp("2012-06-02 00:00:00"),
            32: pd.Timestamp("2012-06-03 00:00:00"),
            33: pd.Timestamp("2012-06-04 00:00:00"),
            34: pd.Timestamp("2012-06-05 00:00:00"),
            35: pd.Timestamp("2012-06-06 00:00:00"),
            36: pd.Timestamp("2012-06-07 00:00:00"),
            37: pd.Timestamp("2012-06-08 00:00:00"),
            38: pd.Timestamp("2012-06-09 00:00:00"),
            39: pd.Timestamp("2012-06-10 00:00:00"),
            40: pd.Timestamp("2012-06-11 00:00:00"),
            41: pd.Timestamp("2012-06-12 00:00:00"),
            42: pd.Timestamp("2012-06-13 00:00:00"),
            43: pd.Timestamp("2012-06-14 00:00:00"),
            44: pd.Timestamp("2012-06-15 00:00:00"),
            45: pd.Timestamp("2012-06-16 00:00:00"),
            46: pd.Timestamp("2012-06-17 00:00:00"),
            47: pd.Timestamp("2012-06-18 00:00:00"),
            48: pd.Timestamp("2012-06-19 00:00:00"),
            49: pd.Timestamp("2012-06-20 00:00:00"),
            50: pd.Timestamp("2012-06-21 00:00:00"),
            51: pd.Timestamp("2012-06-22 00:00:00"),
            52: pd.Timestamp("2012-06-23 00:00:00"),
            53: pd.Timestamp("2012-06-24 00:00:00"),
            54: pd.Timestamp("2012-06-25 00:00:00"),
            55: pd.Timestamp("2012-06-26 00:00:00"),
            56: pd.Timestamp("2012-06-27 00:00:00"),
            57: pd.Timestamp("2012-06-28 00:00:00"),
            58: pd.Timestamp("2012-06-29 00:00:00"),
            59: pd.Timestamp("2012-06-30 00:00:00"),
            60: pd.Timestamp("2012-07-01 00:00:00"),
            61: pd.Timestamp("2012-07-02 00:00:00"),
            62: pd.Timestamp("2012-07-03 00:00:00"),
            63: pd.Timestamp("2012-07-04 00:00:00"),
            64: pd.Timestamp("2012-07-05 00:00:00"),
            65: pd.Timestamp("2012-07-06 00:00:00"),
            66: pd.Timestamp("2012-07-07 00:00:00"),
            67: pd.Timestamp("2012-07-08 00:00:00"),
            68: pd.Timestamp("2012-07-09 00:00:00"),
            69: pd.Timestamp("2012-07-10 00:00:00"),
            70: pd.Timestamp("2012-07-11 00:00:00"),
            71: pd.Timestamp("2012-07-12 00:00:00"),
            72: pd.Timestamp("2012-07-13 00:00:00"),
            73: pd.Timestamp("2012-07-14 00:00:00"),
            74: pd.Timestamp("2012-07-15 00:00:00"),
            75: pd.Timestamp("2012-07-16 00:00:00"),
            76: pd.Timestamp("2012-07-17 00:00:00"),
            77: pd.Timestamp("2012-07-18 00:00:00"),
            78: pd.Timestamp("2012-07-19 00:00:00"),
            79: pd.Timestamp("2012-07-20 00:00:00"),
            80: pd.Timestamp("2012-07-21 00:00:00"),
            81: pd.Timestamp("2012-07-22 00:00:00"),
            82: pd.Timestamp("2012-07-23 00:00:00"),
            83: pd.Timestamp("2012-07-24 00:00:00"),
            84: pd.Timestamp("2012-07-25 00:00:00"),
            85: pd.Timestamp("2012-07-26 00:00:00"),
            86: pd.Timestamp("2012-07-27 00:00:00"),
            87: pd.Timestamp("2012-07-28 00:00:00"),
            88: pd.Timestamp("2012-07-29 00:00:00"),
            89: pd.Timestamp("2012-07-30 00:00:00"),
            90: pd.Timestamp("2012-07-31 00:00:00"),
            91: pd.Timestamp("2012-08-01 00:00:00"),
            92: pd.Timestamp("2012-08-02 00:00:00"),
            93: pd.Timestamp("2012-08-03 00:00:00"),
            94: pd.Timestamp("2012-08-04 00:00:00"),
            95: pd.Timestamp("2012-08-05 00:00:00"),
            96: pd.Timestamp("2012-08-06 00:00:00"),
            97: pd.Timestamp("2012-08-07 00:00:00"),
            98: pd.Timestamp("2012-08-08 00:00:00"),
            99: pd.Timestamp("2012-08-09 00:00:00"),
            100: pd.Timestamp("2012-08-10 00:00:00"),
            101: pd.Timestamp("2012-08-11 00:00:00"),
            102: pd.Timestamp("2012-08-12 00:00:00"),
            103: pd.Timestamp("2012-08-13 00:00:00"),
            104: pd.Timestamp("2012-08-14 00:00:00"),
            105: pd.Timestamp("2012-08-15 00:00:00"),
            106: pd.Timestamp("2012-08-16 00:00:00"),
            107: pd.Timestamp("2012-08-17 00:00:00"),
            108: pd.Timestamp("2012-08-18 00:00:00"),
            109: pd.Timestamp("2012-08-19 00:00:00"),
            110: pd.Timestamp("2012-08-20 00:00:00"),
            111: pd.Timestamp("2012-08-21 00:00:00"),
            112: pd.Timestamp("2012-08-22 00:00:00"),
            113: pd.Timestamp("2012-08-23 00:00:00"),
            114: pd.Timestamp("2012-08-24 00:00:00"),
            115: pd.Timestamp("2012-08-25 00:00:00"),
            116: pd.Timestamp("2012-08-26 00:00:00"),
            117: pd.Timestamp("2012-08-27 00:00:00"),
            118: pd.Timestamp("2012-08-28 00:00:00"),
            119: pd.Timestamp("2012-08-29 00:00:00"),
            120: pd.Timestamp("2012-08-30 00:00:00"),
            121: pd.Timestamp("2012-08-31 00:00:00"),
            122: pd.Timestamp("2012-09-01 00:00:00"),
            123: pd.Timestamp("2012-09-02 00:00:00"),
            124: pd.Timestamp("2012-09-03 00:00:00"),
            125: pd.Timestamp("2012-09-04 00:00:00"),
            126: pd.Timestamp("2012-09-05 00:00:00"),
            127: pd.Timestamp("2012-09-06 00:00:00"),
            128: pd.Timestamp("2012-09-07 00:00:00"),
            129: pd.Timestamp("2012-09-08 00:00:00"),
            130: pd.Timestamp("2012-09-09 00:00:00"),
            131: pd.Timestamp("2012-09-10 00:00:00"),
            132: pd.Timestamp("2012-09-11 00:00:00"),
            133: pd.Timestamp("2012-09-12 00:00:00"),
            134: pd.Timestamp("2012-09-13 00:00:00"),
            135: pd.Timestamp("2012-09-14 00:00:00"),
            136: pd.Timestamp("2012-09-15 00:00:00"),
            137: pd.Timestamp("2012-09-16 00:00:00"),
            138: pd.Timestamp("2012-09-17 00:00:00"),
            139: pd.Timestamp("2012-09-18 00:00:00"),
            140: pd.Timestamp("2012-09-19 00:00:00"),
            141: pd.Timestamp("2012-09-20 00:00:00"),
            142: pd.Timestamp("2012-09-21 00:00:00"),
            143: pd.Timestamp("2012-09-22 00:00:00"),
            144: pd.Timestamp("2012-09-23 00:00:00"),
            145: pd.Timestamp("2012-09-24 00:00:00"),
            146: pd.Timestamp("2012-09-25 00:00:00"),
            147: pd.Timestamp("2012-09-26 00:00:00"),
            148: pd.Timestamp("2012-09-27 00:00:00"),
            149: pd.Timestamp("2012-09-28 00:00:00"),
            150: pd.Timestamp("2012-09-29 00:00:00"),
            151: pd.Timestamp("2012-09-30 00:00:00"),
            152: pd.Timestamp("2012-10-01 00:00:00"),
            153: pd.Timestamp("2012-10-02 00:00:00"),
            154: pd.Timestamp("2012-10-03 00:00:00"),
            155: pd.Timestamp("2012-10-04 00:00:00"),
            156: pd.Timestamp("2012-10-05 00:00:00"),
            157: pd.Timestamp("2012-10-06 00:00:00"),
            158: pd.Timestamp("2012-10-07 00:00:00"),
            159: pd.Timestamp("2012-10-08 00:00:00"),
            160: pd.Timestamp("2012-10-09 00:00:00"),
            161: pd.Timestamp("2012-10-10 00:00:00"),
            162: pd.Timestamp("2012-10-11 00:00:00"),
            163: pd.Timestamp("2012-10-12 00:00:00"),
            164: pd.Timestamp("2012-10-13 00:00:00"),
            165: pd.Timestamp("2012-10-14 00:00:00"),
            166: pd.Timestamp("2012-10-15 00:00:00"),
            167: pd.Timestamp("2012-10-16 00:00:00"),
            168: pd.Timestamp("2012-10-17 00:00:00"),
            169: pd.Timestamp("2012-10-18 00:00:00"),
            170: pd.Timestamp("2012-10-19 00:00:00"),
            171: pd.Timestamp("2012-10-20 00:00:00"),
            172: pd.Timestamp("2012-10-21 00:00:00"),
            173: pd.Timestamp("2012-10-22 00:00:00"),
            174: pd.Timestamp("2012-10-23 00:00:00"),
            175: pd.Timestamp("2012-10-24 00:00:00"),
            176: pd.Timestamp("2012-10-25 00:00:00"),
            177: pd.Timestamp("2012-10-26 00:00:00"),
            178: pd.Timestamp("2012-10-27 00:00:00"),
            179: pd.Timestamp("2012-10-28 00:00:00"),
            180: pd.Timestamp("2012-10-29 00:00:00"),
            181: pd.Timestamp("2012-10-30 00:00:00"),
            182: pd.Timestamp("2012-10-31 00:00:00"),
            183: pd.Timestamp("2012-11-01 00:00:00"),
            184: pd.Timestamp("2012-11-02 00:00:00"),
            185: pd.Timestamp("2012-11-03 00:00:00"),
            186: pd.Timestamp("2012-11-04 00:00:00"),
            187: pd.Timestamp("2012-11-05 00:00:00"),
            188: pd.Timestamp("2012-11-06 00:00:00"),
            189: pd.Timestamp("2012-11-07 00:00:00"),
            190: pd.Timestamp("2012-11-08 00:00:00"),
            191: pd.Timestamp("2012-11-09 00:00:00"),
            192: pd.Timestamp("2012-11-10 00:00:00"),
            193: pd.Timestamp("2012-11-11 00:00:00"),
            194: pd.Timestamp("2012-11-12 00:00:00"),
            195: pd.Timestamp("2012-11-13 00:00:00"),
            196: pd.Timestamp("2012-11-14 00:00:00"),
            197: pd.Timestamp("2012-11-15 00:00:00"),
            198: pd.Timestamp("2012-11-16 00:00:00"),
            199: pd.Timestamp("2012-11-17 00:00:00"),
            200: pd.Timestamp("2012-11-18 00:00:00"),
            201: pd.Timestamp("2012-11-19 00:00:00"),
            202: pd.Timestamp("2012-11-20 00:00:00"),
            203: pd.Timestamp("2012-11-21 00:00:00"),
            204: pd.Timestamp("2012-11-22 00:00:00"),
            205: pd.Timestamp("2012-11-23 00:00:00"),
            206: pd.Timestamp("2012-11-24 00:00:00"),
            207: pd.Timestamp("2012-11-25 00:00:00"),
            208: pd.Timestamp("2012-11-26 00:00:00"),
            209: pd.Timestamp("2012-11-27 00:00:00"),
            210: pd.Timestamp("2012-11-28 00:00:00"),
            211: pd.Timestamp("2012-11-29 00:00:00"),
            212: pd.Timestamp("2012-11-30 00:00:00"),
            213: pd.Timestamp("2012-12-01 00:00:00"),
            214: pd.Timestamp("2012-12-02 00:00:00"),
            215: pd.Timestamp("2012-12-03 00:00:00"),
            216: pd.Timestamp("2012-12-04 00:00:00"),
            217: pd.Timestamp("2012-12-05 00:00:00"),
            218: pd.Timestamp("2012-12-06 00:00:00"),
            219: pd.Timestamp("2012-12-07 00:00:00"),
            220: pd.Timestamp("2012-12-08 00:00:00"),
            221: pd.Timestamp("2012-12-09 00:00:00"),
            222: pd.Timestamp("2012-12-10 00:00:00"),
            223: pd.Timestamp("2012-12-11 00:00:00"),
            224: pd.Timestamp("2012-12-12 00:00:00"),
            225: pd.Timestamp("2012-12-13 00:00:00"),
            226: pd.Timestamp("2012-12-14 00:00:00"),
            227: pd.Timestamp("2012-12-15 00:00:00"),
            228: pd.Timestamp("2012-12-16 00:00:00"),
            229: pd.Timestamp("2012-12-17 00:00:00"),
            230: pd.Timestamp("2012-12-18 00:00:00"),
            231: pd.Timestamp("2012-12-19 00:00:00"),
            232: pd.Timestamp("2012-12-20 00:00:00"),
            233: pd.Timestamp("2012-12-21 00:00:00"),
            234: pd.Timestamp("2012-12-22 00:00:00"),
            235: pd.Timestamp("2012-12-23 00:00:00"),
            236: pd.Timestamp("2012-12-24 00:00:00"),
            237: pd.Timestamp("2012-12-25 00:00:00"),
            238: pd.Timestamp("2012-12-26 00:00:00"),
            239: pd.Timestamp("2012-12-27 00:00:00"),
            240: pd.Timestamp("2012-12-28 00:00:00"),
            241: pd.Timestamp("2012-12-29 00:00:00"),
            242: pd.Timestamp("2012-12-30 00:00:00"),
            243: pd.Timestamp("2012-12-31 00:00:00"),
            244: pd.Timestamp("2013-01-01 00:00:00"),
            245: pd.Timestamp("2013-01-02 00:00:00"),
            246: pd.Timestamp("2013-01-03 00:00:00"),
            247: pd.Timestamp("2013-01-04 00:00:00"),
            248: pd.Timestamp("2013-01-05 00:00:00"),
            249: pd.Timestamp("2013-01-06 00:00:00"),
            250: pd.Timestamp("2013-01-07 00:00:00"),
            251: pd.Timestamp("2013-01-08 00:00:00"),
            252: pd.Timestamp("2013-01-09 00:00:00"),
            253: pd.Timestamp("2013-01-10 00:00:00"),
            254: pd.Timestamp("2013-01-11 00:00:00"),
            255: pd.Timestamp("2013-01-12 00:00:00"),
            256: pd.Timestamp("2013-01-13 00:00:00"),
            257: pd.Timestamp("2013-01-14 00:00:00"),
            258: pd.Timestamp("2013-01-15 00:00:00"),
            259: pd.Timestamp("2013-01-16 00:00:00"),
            260: pd.Timestamp("2013-01-17 00:00:00"),
            261: pd.Timestamp("2013-01-18 00:00:00"),
            262: pd.Timestamp("2013-01-19 00:00:00"),
            263: pd.Timestamp("2013-01-20 00:00:00"),
            264: pd.Timestamp("2013-01-21 00:00:00"),
            265: pd.Timestamp("2013-01-22 00:00:00"),
            266: pd.Timestamp("2013-01-23 00:00:00"),
            267: pd.Timestamp("2013-01-24 00:00:00"),
            268: pd.Timestamp("2013-01-25 00:00:00"),
            269: pd.Timestamp("2013-01-26 00:00:00"),
            270: pd.Timestamp("2013-01-27 00:00:00"),
            271: pd.Timestamp("2013-01-28 00:00:00"),
            272: pd.Timestamp("2013-01-29 00:00:00"),
            273: pd.Timestamp("2013-01-30 00:00:00"),
            274: pd.Timestamp("2013-01-31 00:00:00"),
            275: pd.Timestamp("2013-02-01 00:00:00"),
            276: pd.Timestamp("2013-02-02 00:00:00"),
            277: pd.Timestamp("2013-02-03 00:00:00"),
            278: pd.Timestamp("2013-02-04 00:00:00"),
            279: pd.Timestamp("2013-02-05 00:00:00"),
            280: pd.Timestamp("2013-02-06 00:00:00"),
            281: pd.Timestamp("2013-02-07 00:00:00"),
            282: pd.Timestamp("2013-02-08 00:00:00"),
            283: pd.Timestamp("2013-02-09 00:00:00"),
            284: pd.Timestamp("2013-02-10 00:00:00"),
            285: pd.Timestamp("2013-02-11 00:00:00"),
            286: pd.Timestamp("2013-02-12 00:00:00"),
            287: pd.Timestamp("2013-02-13 00:00:00"),
            288: pd.Timestamp("2013-02-14 00:00:00"),
            289: pd.Timestamp("2013-02-15 00:00:00"),
            290: pd.Timestamp("2013-02-16 00:00:00"),
            291: pd.Timestamp("2013-02-17 00:00:00"),
            292: pd.Timestamp("2013-02-18 00:00:00"),
            293: pd.Timestamp("2013-02-19 00:00:00"),
            294: pd.Timestamp("2013-02-20 00:00:00"),
            295: pd.Timestamp("2013-02-21 00:00:00"),
            296: pd.Timestamp("2013-02-22 00:00:00"),
            297: pd.Timestamp("2013-02-23 00:00:00"),
            298: pd.Timestamp("2013-02-24 00:00:00"),
            299: pd.Timestamp("2013-02-25 00:00:00"),
            300: pd.Timestamp("2013-02-26 00:00:00"),
            301: pd.Timestamp("2013-02-27 00:00:00"),
            302: pd.Timestamp("2013-02-28 00:00:00"),
            303: pd.Timestamp("2013-03-01 00:00:00"),
            304: pd.Timestamp("2013-03-02 00:00:00"),
            305: pd.Timestamp("2013-03-03 00:00:00"),
            306: pd.Timestamp("2013-03-04 00:00:00"),
            307: pd.Timestamp("2013-03-05 00:00:00"),
            308: pd.Timestamp("2013-03-06 00:00:00"),
            309: pd.Timestamp("2013-03-07 00:00:00"),
            310: pd.Timestamp("2013-03-08 00:00:00"),
            311: pd.Timestamp("2013-03-09 00:00:00"),
            312: pd.Timestamp("2013-03-10 00:00:00"),
            313: pd.Timestamp("2013-03-11 00:00:00"),
            314: pd.Timestamp("2013-03-12 00:00:00"),
            315: pd.Timestamp("2013-03-13 00:00:00"),
            316: pd.Timestamp("2013-03-14 00:00:00"),
            317: pd.Timestamp("2013-03-15 00:00:00"),
            318: pd.Timestamp("2013-03-16 00:00:00"),
            319: pd.Timestamp("2013-03-17 00:00:00"),
            320: pd.Timestamp("2013-03-18 00:00:00"),
            321: pd.Timestamp("2013-03-19 00:00:00"),
            322: pd.Timestamp("2013-03-20 00:00:00"),
            323: pd.Timestamp("2013-03-21 00:00:00"),
            324: pd.Timestamp("2013-03-22 00:00:00"),
            325: pd.Timestamp("2013-03-23 00:00:00"),
            326: pd.Timestamp("2013-03-24 00:00:00"),
            327: pd.Timestamp("2013-03-25 00:00:00"),
            328: pd.Timestamp("2013-03-26 00:00:00"),
            329: pd.Timestamp("2013-03-27 00:00:00"),
            330: pd.Timestamp("2013-03-28 00:00:00"),
            331: pd.Timestamp("2013-03-29 00:00:00"),
            332: pd.Timestamp("2013-03-30 00:00:00"),
            333: pd.Timestamp("2013-03-31 00:00:00"),
            334: pd.Timestamp("2013-04-01 00:00:00"),
            335: pd.Timestamp("2013-04-02 00:00:00"),
            336: pd.Timestamp("2013-04-03 00:00:00"),
            337: pd.Timestamp("2013-04-04 00:00:00"),
            338: pd.Timestamp("2013-04-05 00:00:00"),
            339: pd.Timestamp("2013-04-06 00:00:00"),
            340: pd.Timestamp("2013-04-07 00:00:00"),
            341: pd.Timestamp("2013-04-08 00:00:00"),
            342: pd.Timestamp("2013-04-09 00:00:00"),
            343: pd.Timestamp("2013-04-10 00:00:00"),
            344: pd.Timestamp("2013-04-11 00:00:00"),
            345: pd.Timestamp("2013-04-12 00:00:00"),
            346: pd.Timestamp("2013-04-13 00:00:00"),
            347: pd.Timestamp("2013-04-14 00:00:00"),
            348: pd.Timestamp("2013-04-15 00:00:00"),
            349: pd.Timestamp("2013-04-16 00:00:00"),
            350: pd.Timestamp("2013-04-17 00:00:00"),
            351: pd.Timestamp("2013-04-18 00:00:00"),
            352: pd.Timestamp("2013-04-19 00:00:00"),
            353: pd.Timestamp("2013-04-20 00:00:00"),
            354: pd.Timestamp("2013-04-21 00:00:00"),
            355: pd.Timestamp("2013-04-22 00:00:00"),
            356: pd.Timestamp("2013-04-23 00:00:00"),
            357: pd.Timestamp("2013-04-24 00:00:00"),
            358: pd.Timestamp("2013-04-25 00:00:00"),
            359: pd.Timestamp("2013-04-26 00:00:00"),
            360: pd.Timestamp("2013-04-27 00:00:00"),
            361: pd.Timestamp("2013-04-28 00:00:00"),
            362: pd.Timestamp("2013-04-29 00:00:00"),
            363: pd.Timestamp("2013-04-30 00:00:00"),
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
        },
        "fcst": {
            0: 7.710195925566869,
            1: 7.744907999726215,
            2: 7.7926437941918705,
            3: 7.624593397388267,
            4: 8.086088963498527,
            5: 8.226938714098187,
            6: 7.936541087327886,
            7: 7.709339119187576,
            8: 7.744051193346707,
            9: 7.791786987811981,
            10: 7.623736591008531,
            11: 8.08523215711923,
            12: 8.226081907718582,
            13: 7.935684280956517,
            14: 7.708482312822571,
            15: 7.743194386989579,
            16: 7.790930181462328,
            17: 7.622879784666338,
            18: 8.084375350783924,
            19: 8.22522510139134,
            20: 7.934827474629642,
            21: 7.707625506495359,
            22: 7.742337580662688,
            23: 7.7900733751356706,
            24: 7.622022979465374,
            25: 8.08351854670914,
            26: 8.22436829844187,
            27: 7.933970672805973,
            28: 7.706768705797579,
            29: 7.741480781090415,
            30: 7.7892165766891654,
            31: 7.621166181019212,
            32: 8.082661748263359,
            33: 8.2235114999956,
            34: 7.9331138743601315,
            35: 7.705911907351373,
            36: 7.740937906482861,
            37: 7.788987625920119,
            38: 7.6212511540883074,
            39: 8.083060645169969,
            40: 8.224224320741705,
            41: 7.934140618944066,
            42: 7.707252575774236,
            43: 7.7422785749053435,
            44: 7.790328294343002,
            45: 7.622591822510904,
            46: 8.084401313593254,
            47: 8.229126254571282,
            48: 7.942603818180381,
            49: 7.719277040417607,
            50: 7.757864304956119,
            51: 7.809475289800548,
            52: 7.6453000833756315,
            53: 8.110670839865094,
            54: 8.255395780843246,
            55: 7.968873344452828,
            56: 7.745546566689691,
            57: 7.784133831227987,
            58: 7.835744816072033,
            59: 7.677453468591156,
            60: 8.148708084024586,
            61: 8.299316883946126,
            62: 8.0186783064993,
            63: 7.801235387680077,
            64: 7.845706511162335,
            65: 7.903201354950308,
            66: 7.744910007469274,
            67: 8.21616462290233,
            68: 8.366773422824135,
            69: 8.086134845377256,
            70: 7.868691926558522,
            71: 7.916301168950475,
            72: 7.976934131648697,
            73: 7.821780903077708,
            74: 8.296173637421044,
            75: 8.4499205562527,
            76: 8.172420097714982,
            77: 7.9581152978067236,
            78: 8.005724540198571,
            79: 8.066357502896574,
            80: 7.91120427432587,
            81: 8.385597008668524,
            82: 8.539343934328583,
            83: 8.261843482619872,
            84: 8.047538689538785,
            85: 8.095147938758803,
            86: 8.155780908284516,
            87: 8.000627686541854,
            88: 8.475020427711723,
            89: 8.628767353372417,
            90: 8.351266901662852,
            91: 8.136962108582305,
            92: 8.184571357802321,
            93: 8.245204327328434,
            94: 8.090051106272263,
            95: 8.564443848129365,
            96: 8.71819077447622,
            97: 8.440690323453806,
            98: 8.226385531060124,
            99: 8.273994780966925,
            100: 8.33462775117962,
            101: 8.179474530123663,
            102: 8.65386727198114,
            103: 8.80761419832788,
            104: 8.53011374730595,
            105: 8.315808953942291,
            106: 8.363418202879824,
            107: 8.424051172123246,
            108: 8.268897950097948,
            109: 8.743290690985626,
            110: 8.897037616363868,
            111: 8.619537164372087,
            112: 8.405232371009348,
            113: 8.452841619946796,
            114: 8.513474589190134,
            115: 8.358321367164674,
            116: 8.832714108053105,
            117: 8.986461033172288,
            118: 8.708960580921946,
            119: 8.494655787300292,
            120: 8.542265035979309,
            121: 8.602898004964365,
            122: 8.447744782680422,
            123: 8.922137523310363,
            124: 9.0758844484293,
            125: 8.798383996180233,
            126: 8.584079202557795,
            127: 8.631688451236597,
            128: 8.692321420221402,
            129: 8.533245223373818,
            130: 9.003714989440295,
            131: 9.153538939995503,
            132: 8.872115513182596,
            133: 8.653887744996153,
            134: 8.697574019111611,
            135: 8.754284013532857,
            136: 8.595207816684988,
            137: 9.065677582751034,
            138: 9.215501533306504,
            139: 8.934078106493114,
            140: 8.71009075996415,
            141: 8.748017455736885,
            142: 8.798967871815329,
            143: 8.634132096624311,
            144: 9.098842284347697,
            145: 9.242906656560015,
            146: 8.955723651403218,
            147: 8.731736304874742,
            148: 8.769663000646784,
            149: 8.820613416725193,
            150: 8.65577764153452,
            151: 9.120487829258284,
            152: 9.262377787096094,
            153: 8.973020367565722,
            154: 8.74685860666247,
            155: 8.782610888061116,
            156: 8.831386889765264,
            157: 8.6643767002006,
            158: 9.126912473549432,
            159: 9.268802431388114,
            160: 8.979445011857317,
            161: 8.753283250954555,
            162: 8.789035532352822,
            163: 8.837811532228436,
            164: 8.670801340834615,
            165: 9.133337112355147,
            166: 9.275227068364412,
            167: 8.985869647004257,
            168: 8.75970788427265,
            169: 8.795460163842236,
            170: 8.844236163717838,
            171: 8.67722597232417,
            172: 9.1397617438449,
            173: 9.281651699853919,
            174: 8.992294278494619,
            175: 8.766132515060658,
            176: 8.80188479392804,
            177: 8.850660793101268,
            178: 8.683650601005823,
            179: 9.146186371822935,
            180: 9.288076327131295,
            181: 8.998718905069339,
            182: 8.772557141635895,
            183: 8.8083094205033,
            184: 8.85708541967674,
            185: 8.690075227581138,
            186: 9.15261099839876,
            187: 9.294500953778003,
            188: 9.005143531787926,
            189: 8.778981768426044,
            190: 8.81473404736498,
            191: 8.86351004660991,
            192: 8.696499854585895,
            193: 9.15903562547534,
            194: 9.300925580854468,
            195: 9.011568158863593,
            196: 8.785406395502251,
            197: 8.821158674441053,
            198: 8.869934674290462,
            199: 8.702924482870898,
            200: 9.165460254364737,
            201: 9.307350210348094,
            202: 9.017992788962697,
            203: 8.791831026204996,
            204: 8.82758330574844,
            205: 8.876359305597337,
            206: 8.709349114178117,
            207: 9.17188488567145,
            208: 9.313774841655206,
            209: 9.024417420268955,
            210: 8.798255654977599,
            211: 8.8340079319869,
            212: 8.882783929302025,
            213: 8.715773735348042,
            214: 9.178309504307968,
            215: 9.320199457757308,
            216: 9.030842033836889,
            217: 8.804680268546024,
            218: 8.840432545554926,
            219: 8.889208542869852,
            220: 8.72219834891608,
            221: 9.18473411513327,
            222: 9.32662406583901,
            223: 9.037266639177183,
            224: 8.811104871141154,
            225: 8.846857145407261,
            226: 8.89563313997899,
            227: 8.728622943282254,
            228: 9.191158709498522,
            229: 9.333048660204947,
            230: 9.043691233542454,
            231: 8.817529465507347,
            232: 8.853281739773367,
            233: 8.900706588571616,
            234: 8.732345246101445,
            235: 9.193529866544948,
            236: 9.334068671477857,
            237: 9.043360099041601,
            238: 8.815847185232753,
            239: 8.850248313725515,
            240: 8.897673162524367,
            241: 8.729311820053844,
            242: 9.190496440497544,
            243: 9.331035245429838,
            244: 9.040326672994377,
            245: 8.806681687617962,
            246: 8.834950744542875,
            247: 8.876243521773842,
            248: 8.701750107735705,
            249: 9.156802656611971,
            250: 9.291209389976562,
            251: 8.994368745972862,
            252: 8.76072376059653,
            253: 8.788992817521468,
            254: 8.830285594752516,
            255: 8.655792180714412,
            256: 9.103434795324508,
            257: 9.230431594423813,
            258: 8.926181016154144,
            259: 8.685126096512167,
            260: 8.705985219171984,
            261: 8.739868062137235,
            262: 8.557964713833293,
            263: 9.00560732844377,
            264: 9.132604127542956,
            265: 8.828353549272919,
            266: 8.587298629631432,
            267: 8.60815775229037,
            268: 8.642040595299003,
            269: 8.46013724703837,
            270: 8.907779861691848,
            271: 9.034776660833934,
            272: 8.730526082607613,
            273: 8.489471163008458,
            274: 8.510330285711113,
            275: 8.544213128719365,
            276: 8.362309780458883,
            277: 8.809952395111917,
            278: 8.9369491942544,
            279: 8.63269861720444,
            280: 8.391643698782564,
            281: 8.412502822661628,
            282: 8.44638566684707,
            283: 8.264482319763152,
            284: 8.712124935592719,
            285: 8.839121735912391,
            286: 8.534871158862007,
            287: 8.29381624044062,
            288: 8.314675364319715,
            289: 8.348558208505086,
            290: 8.16665486142119,
            291: 8.61436912276236,
            292: 8.741437568593186,
            293: 8.43725863705506,
            294: 8.196275364144311,
            295: 8.217206133534996,
            296: 8.251160623231256,
            297: 8.069328921659107,
            298: 8.517043182999535,
            299: 8.644111628830807,
            300: 8.339932697292017,
            301: 8.098949424381809,
            302: 8.11988019377249,
            303: 8.153834683468965,
            304: 7.972002981896716,
            305: 8.419717243237592,
            306: 8.546785689068988,
            307: 8.24260675752983,
            308: 8.001623484619682,
            309: 8.022554254010394,
            310: 8.056508743706857,
            311: 7.874677042134324,
            312: 8.322391303475891,
            313: 8.449459749306428,
            314: 8.145280817767217,
            315: 7.904297544857583,
            316: 7.925228314248184,
            317: 7.959182803944694,
            318: 7.777351102372182,
            319: 8.22506536371371,
            320: 8.35213380954405,
            321: 8.047954878005452,
            322: 7.806971605095457,
            323: 7.827902374485976,
            324: 7.861856864182268,
            325: 7.68002516260979,
            326: 8.127739423951125,
            327: 8.254807869781859,
            328: 7.950628938243689,
            329: 7.709645665332928,
            330: 7.730576434723766,
            331: 7.764530924420164,
            332: 7.582699222847708,
            333: 8.030413484189182,
            334: 8.157481930019673,
            335: 7.853302998481503,
            336: 7.61231972557123,
            337: 7.633250494961673,
            338: 7.6672049846579995,
            339: 7.485373283085627,
            340: 7.933087544427242,
            341: 8.060155990257483,
            342: 7.755977058720169,
            343: 7.514993785808704,
            344: 7.535924555199462,
            345: 7.569879044895894,
            346: 7.388047343323486,
            347: 7.835761604664416,
            348: 7.962830050495103,
            349: 7.658651118957125,
            350: 7.4176678460465775,
            351: 7.438598615437254,
            352: 7.47255310513392,
            353: 7.290721403561151,
            354: 7.738435664902715,
            355: 7.865504110733463,
            356: 7.561325179194938,
            357: 7.320341906284452,
            358: 7.341272675674861,
            359: 7.3752271653716255,
            360: 7.193395463799012,
            361: 7.6411097251407725,
            362: 7.768178170970906,
            363: 7.463999239433177,
            364: 7.223015966522352,
            365: 7.243946735912949,
            366: 7.277901225609331,
            367: 7.0960695240368725,
            368: 7.543783785378832,
            369: 7.670852231208895,
            370: 7.366673299670559,
            371: 7.125690026759824,
            372: 7.14662079615026,
            373: 7.180575285846905,
            374: 6.998743584274537,
            375: 7.446457845616006,
            376: 7.573526291446706,
            377: 7.269347359907946,
            378: 7.0283640869972945,
        },
        "fcst_lower": {
            0: 7.1393457895898065,
            1: 7.180920197215959,
            2: 7.215866959834292,
            3: 7.018214713337873,
            4: 7.504717675138625,
            5: 7.624135611794266,
            6: 7.381334376406461,
            7: 7.100273022761689,
            8: 7.102121522714937,
            9: 7.198262047107872,
            10: 7.036329937031151,
            11: 7.4842697037892725,
            12: 7.653654545893796,
            13: 7.356426842984418,
            14: 7.11266221856886,
            15: 7.19209511571483,
            16: 7.181918841551823,
            17: 7.021986472432229,
            18: 7.481290425699634,
            19: 7.63700295628621,
            20: 7.331664889693152,
            21: 7.124936036674003,
            22: 7.14618297623085,
            23: 7.220878176046664,
            24: 7.059409373072878,
            25: 7.500451917968195,
            26: 7.614197243487162,
            27: 7.349525330692049,
            28: 7.124247769972272,
            29: 7.186061752427718,
            30: 7.177026578733725,
            31: 7.012807282414339,
            32: 7.521411843984355,
            33: 7.688292362906976,
            34: 7.350790326361769,
            35: 7.123383444795006,
            36: 7.186141609655912,
            37: 7.1963030530305305,
            38: 7.023812980451571,
            39: 7.518560369080476,
            40: 7.636346056562846,
            41: 7.32675611523351,
            42: 7.1067301562111185,
            43: 7.154805438178655,
            44: 7.188067650836667,
            45: 7.078923708646581,
            46: 7.474889582153023,
            47: 7.679875898234149,
            48: 7.380402471529216,
            49: 7.135443840974969,
            50: 7.173569485795238,
            51: 7.244356294922232,
            52: 7.045476584862669,
            53: 7.547421162059628,
            54: 7.621218589622505,
            55: 7.3548593362622965,
            56: 7.174058143305953,
            57: 7.202756874704008,
            58: 7.280509531294196,
            59: 7.094978754406447,
            60: 7.558233228155128,
            61: 7.738089980492334,
            62: 7.439030991799091,
            63: 7.168990230986533,
            64: 7.193980686891873,
            65: 7.300787635571004,
            66: 7.149514759559147,
            67: 7.60366049101141,
            68: 7.779083560208865,
            69: 7.503340986040456,
            70: 7.292267316539494,
            71: 7.361637853338193,
            72: 7.412837585249283,
            73: 7.259993181320259,
            74: 7.726781571228534,
            75: 7.873234493463908,
            76: 7.572427987926723,
            77: 7.3637463214785965,
            78: 7.414440704379288,
            79: 7.470589073965205,
            80: 7.327539911904135,
            81: 7.769912948160123,
            82: 7.9295224363112204,
            83: 7.642663784255805,
            84: 7.429991050609599,
            85: 7.5084449090911285,
            86: 7.590111447791402,
            87: 7.427104784322447,
            88: 7.897261579089276,
            89: 8.034001314950066,
            90: 7.791881416658607,
            91: 7.553817611322984,
            92: 7.604108745971248,
            93: 7.65194428255682,
            94: 7.47251249456544,
            95: 7.9894202632053695,
            96: 8.159626214760026,
            97: 7.883653512180744,
            98: 7.605233469895632,
            99: 7.69260175043475,
            100: 7.7612379194113785,
            101: 7.5906912256813435,
            102: 8.089809991634505,
            103: 8.238962220528565,
            104: 7.960717029849273,
            105: 7.708935429026934,
            106: 7.808042408086284,
            107: 7.814856706147185,
            108: 7.62495495226088,
            109: 8.153473359120932,
            110: 8.290015226105158,
            111: 8.049602647818627,
            112: 7.81368209339476,
            113: 7.884649098018437,
            114: 7.926108365499948,
            115: 7.73506850085542,
            116: 8.269515422518246,
            117: 8.369982041546203,
            118: 8.113370721848169,
            119: 7.908209394373399,
            120: 7.954562039470102,
            121: 8.037515094122684,
            122: 7.8701415082713675,
            123: 8.356027650826844,
            124: 8.468299986386016,
            125: 8.16834167586577,
            126: 8.003131538648537,
            127: 8.054882312197956,
            128: 8.088323448280194,
            129: 7.9199630780603485,
            130: 8.39794378043259,
            131: 8.546134345420334,
            132: 8.301311561063974,
            133: 8.08709269708391,
            134: 8.085870546899212,
            135: 8.174851529723476,
            136: 7.992718838444535,
            137: 8.472091719022934,
            138: 8.60595226387273,
            139: 8.356679636880857,
            140: 8.095158098195736,
            141: 8.136018786957756,
            142: 8.23926694933341,
            143: 8.05565055432655,
            144: 8.478991593529452,
            145: 8.635503024120744,
            146: 8.339755468769818,
            147: 8.09833679124729,
            148: 8.157867187830496,
            149: 8.248605436855932,
            150: 8.076991972090653,
            151: 8.518928675636348,
            152: 8.642255653905089,
            153: 8.348611430026665,
            154: 8.18430985689739,
            155: 8.167978121955102,
            156: 8.271368029444263,
            157: 8.113846880563742,
            158: 8.535068634492298,
            159: 8.683438872127889,
            160: 8.353766290757232,
            161: 8.119529965367773,
            162: 8.2150571947084,
            163: 8.270222229727,
            164: 8.10339199023923,
            165: 8.517249629462892,
            166: 8.686313484371093,
            167: 8.37693124456843,
            168: 8.180883512584073,
            169: 8.222873817421835,
            170: 8.22699684764617,
            171: 8.08004614891,
            172: 8.528718004421426,
            173: 8.708177524260599,
            174: 8.442213217479782,
            175: 8.158773057800504,
            176: 8.250106158502547,
            177: 8.273609381500306,
            178: 8.065155417037355,
            179: 8.554097295181,
            180: 8.675391086011118,
            181: 8.431864337769275,
            182: 8.21174147430096,
            183: 8.20395642488252,
            184: 8.242848813544965,
            185: 8.110852516034354,
            186: 8.534917446874271,
            187: 8.667006583355535,
            188: 8.420224203172673,
            189: 8.225416883777456,
            190: 8.199319526390653,
            191: 8.259903287915183,
            192: 8.123159062350947,
            193: 8.580953592948712,
            194: 8.735890371880522,
            195: 8.408840494182783,
            196: 8.177895945404213,
            197: 8.218172044538004,
            198: 8.32145563525391,
            199: 8.13973909014325,
            200: 8.583794509558327,
            201: 8.718580887090019,
            202: 8.4434668683442,
            203: 8.220604951548165,
            204: 8.290202591552594,
            205: 8.287135637714124,
            206: 8.21184089692254,
            207: 8.535434922541064,
            208: 8.727394967005798,
            209: 8.421906462275361,
            210: 8.199009217823745,
            211: 8.244615925037733,
            212: 8.31121552420562,
            213: 8.121291318516144,
            214: 8.601224739182292,
            215: 8.782019397110869,
            216: 8.437423576486674,
            217: 8.196276797372263,
            218: 8.252620025323358,
            219: 8.282565667985514,
            220: 8.165941540315133,
            221: 8.644137312926127,
            222: 8.763338305376704,
            223: 8.441825876414917,
            224: 8.234092977685817,
            225: 8.27836158403193,
            226: 8.342593131572965,
            227: 8.14268109302762,
            228: 8.568653375682349,
            229: 8.736665498204186,
            230: 8.469199225250696,
            231: 8.253224577904138,
            232: 8.243089720782155,
            233: 8.307481823217053,
            234: 8.160126406242876,
            235: 8.566284651337314,
            236: 8.759012849795235,
            237: 8.478574850640307,
            238: 8.251269489141627,
            239: 8.244433904054487,
            240: 8.308805462470854,
            241: 8.135215978811553,
            242: 8.631763695361466,
            243: 8.733652389506931,
            244: 8.452563319042145,
            245: 8.21489860875372,
            246: 8.294391286934403,
            247: 8.283439822572262,
            248: 8.137403739079303,
            249: 8.59314918650227,
            250: 8.704984793640685,
            251: 8.415362635795146,
            252: 8.186987447414047,
            253: 8.18387029319308,
            254: 8.258210233668246,
            255: 8.033179576792925,
            256: 8.54226395622026,
            257: 8.656014651934948,
            258: 8.346829534289835,
            259: 8.095124005606639,
            260: 8.098028420119405,
            261: 8.157914755883741,
            262: 7.980120545725019,
            263: 8.388038587123624,
            264: 8.541368595067576,
            265: 8.168163276616063,
            266: 8.007020576084248,
            267: 8.015789758886745,
            268: 7.999770911439007,
            269: 7.853623651908789,
            270: 8.32897865936586,
            271: 8.454927124105543,
            272: 8.094426649851506,
            273: 7.88060638757754,
            274: 7.950387106544561,
            275: 7.942571922738771,
            276: 7.777695473585791,
            277: 8.1737297151425,
            278: 8.298375045332147,
            279: 8.0584381851333,
            280: 7.7750534519489705,
            281: 7.844663916502678,
            282: 7.864175839025585,
            283: 7.681214007583994,
            284: 8.137436588183554,
            285: 8.23608883541143,
            286: 7.984845829891965,
            287: 7.694932402254112,
            288: 7.7175212667958855,
            289: 7.760013973935053,
            290: 7.610118641289787,
            291: 8.008228184523942,
            292: 8.16235047767394,
            293: 7.8439577708481085,
            294: 7.605483272888552,
            295: 7.621016647958258,
            296: 7.711466581543118,
            297: 7.454789054914133,
            298: 7.932884847774542,
            299: 8.028895352589704,
            300: 7.7316705241184644,
            301: 7.532520884980062,
            302: 7.536220012457184,
            303: 7.549409786374915,
            304: 7.381398880112259,
            305: 7.817244391657324,
            306: 7.952441717244936,
            307: 7.681062071391872,
            308: 7.400923120341537,
            309: 7.441870781851894,
            310: 7.473113554724515,
            311: 7.2797330773359565,
            312: 7.716704241411871,
            313: 7.834689110618418,
            314: 7.600829925953431,
            315: 7.341113124461103,
            316: 7.330200780704204,
            317: 7.353721339272481,
            318: 7.1675346397175055,
            319: 7.661400209415222,
            320: 7.754620134718088,
            321: 7.457727494499956,
            322: 7.235380390727579,
            323: 7.289808807205965,
            324: 7.302584849515064,
            325: 7.094460605800514,
            326: 7.520587611748167,
            327: 7.633654800560917,
            328: 7.378038845176461,
            329: 7.126310887317622,
            330: 7.097155994871034,
            331: 7.14811502419729,
            332: 6.9998567259531015,
            333: 7.445346259763158,
            334: 7.5821824470895525,
            335: 7.303932787735179,
            336: 7.052902652517236,
            337: 7.070087263294801,
            338: 7.062607476564819,
            339: 6.877449426326153,
            340: 7.376269803011332,
            341: 7.467796695517994,
            342: 7.1839585319522605,
            343: 6.925909094221847,
            344: 6.929208611798917,
            345: 6.947033542816077,
            346: 6.774655054977477,
            347: 7.301508205966512,
            348: 7.370007723114802,
            349: 7.07123446937226,
            350: 6.820640597027494,
            351: 6.872121841439738,
            352: 6.8949211897015985,
            353: 6.722088098347975,
            354: 7.188721242062073,
            355: 7.282543313055812,
            356: 6.969266976521954,
            357: 6.735304512036055,
            358: 6.760308401625505,
            359: 6.747726956801102,
            360: 6.620100075865046,
            361: 7.057862533279938,
            362: 7.190089125420477,
            363: 6.87497561154366,
            364: 6.643331526035914,
            365: 6.667840277398658,
            366: 6.673437201529585,
            367: 6.4932523723542275,
            368: 6.975748857177791,
            369: 7.091492070759918,
            370: 6.793870701117878,
            371: 6.524047772556929,
            372: 6.518283763409354,
            373: 6.607825672698519,
            374: 6.45691457561523,
            375: 6.866431450573167,
            376: 7.005407319976342,
            377: 6.678547015391412,
            378: 6.437470135730437,
        },
        "fcst_upper": {
            0: 8.28968259431194,
            1: 8.366630026850187,
            2: 8.384652685692345,
            3: 8.234195100095516,
            4: 8.661471076699893,
            5: 8.788235647211875,
            6: 8.533563184878938,
            7: 8.295405282368268,
            8: 8.31424709700353,
            9: 8.36905550078155,
            10: 8.230471355557604,
            11: 8.630301676306372,
            12: 8.835178357743711,
            13: 8.534745800673043,
            14: 8.290832863180745,
            15: 8.324536119708707,
            16: 8.363021803481493,
            17: 8.22282671500673,
            18: 8.690125997161015,
            19: 8.793008664703233,
            20: 8.552487383779798,
            21: 8.26540602432838,
            22: 8.352056371308475,
            23: 8.387065010869279,
            24: 8.241736905392772,
            25: 8.671402203418157,
            26: 8.871692078427337,
            27: 8.51518587363954,
            28: 8.290107563144197,
            29: 8.282015041640541,
            30: 8.41778467364615,
            31: 8.173320817973847,
            32: 8.656093033249,
            33: 8.773139349857356,
            34: 8.47789435425174,
            35: 8.293372087966848,
            36: 8.337903736449876,
            37: 8.355495525397894,
            38: 8.244490219276353,
            39: 8.639398257613944,
            40: 8.816632870843634,
            41: 8.543725750448582,
            42: 8.355342441362327,
            43: 8.309877657566618,
            44: 8.349177376781707,
            45: 8.25065197421036,
            46: 8.658602918578191,
            47: 8.798415460263097,
            48: 8.521880663447023,
            49: 8.297668490928883,
            50: 8.316519050082777,
            51: 8.369463364342305,
            52: 8.224439227359909,
            53: 8.70261823505307,
            54: 8.832850102134726,
            55: 8.601040261030727,
            56: 8.350925755730895,
            57: 8.388418811437512,
            58: 8.42328267933133,
            59: 8.25258734085451,
            60: 8.745221457004371,
            61: 8.906812630038377,
            62: 8.618636027407486,
            63: 8.394833105533552,
            64: 8.448687547219619,
            65: 8.502302703980677,
            66: 8.320900494310058,
            67: 8.789825356109173,
            68: 8.938734517490879,
            69: 8.626192849954855,
            70: 8.433658401334588,
            71: 8.477299471673033,
            72: 8.565921748980163,
            73: 8.416860751263615,
            74: 8.83626179933108,
            75: 9.033407659423823,
            76: 8.751162819311636,
            77: 8.556837706772756,
            78: 8.643284360046373,
            79: 8.646828295735038,
            80: 8.527854969273701,
            81: 8.947921292669323,
            82: 9.121890853846075,
            83: 8.849106872904578,
            84: 8.63563997740084,
            85: 8.696604815183694,
            86: 8.745785229560026,
            87: 8.571988344659895,
            88: 9.036442820658582,
            89: 9.217842590205876,
            90: 8.880368996629398,
            91: 8.716444387950304,
            92: 8.755249357431678,
            93: 8.835734979679753,
            94: 8.680030229243126,
            95: 9.17002962422002,
            96: 9.35125260838921,
            97: 9.01919730261754,
            98: 8.825671265295906,
            99: 8.86930297368629,
            100: 8.906172226450739,
            101: 8.735196871875278,
            102: 9.20963491645449,
            103: 9.384245479991474,
            104: 9.139559330502491,
            105: 8.869725613587239,
            106: 8.965469977921208,
            107: 9.030370642753153,
            108: 8.86809483888442,
            109: 9.292799880679,
            110: 9.452420518959038,
            111: 9.230704132998087,
            112: 8.973083426190643,
            113: 9.069912370885584,
            114: 9.134116416314479,
            115: 8.966414659170198,
            116: 9.437751201397061,
            117: 9.614844123777425,
            118: 9.292518744698143,
            119: 9.099938635358333,
            120: 9.151209705473118,
            121: 9.21974956561438,
            122: 9.043529478385318,
            123: 9.509691552005874,
            124: 9.665820185197171,
            125: 9.404934240102014,
            126: 9.191847632509392,
            127: 9.282989248274623,
            128: 9.283423417959213,
            129: 9.100684837690153,
            130: 9.590561831298013,
            131: 9.695969093761644,
            132: 9.42902351803728,
            133: 9.25490181718423,
            134: 9.293795405607344,
            135: 9.330205207175098,
            136: 9.14593546317182,
            137: 9.607708205432925,
            138: 9.818391736911815,
            139: 9.523835986471306,
            140: 9.311938265958133,
            141: 9.370228696512308,
            142: 9.336377374088404,
            143: 9.171772756904875,
            144: 9.669468851533098,
            145: 9.830524449609223,
            146: 9.532928598841638,
            147: 9.32116078154007,
            148: 9.366640114668709,
            149: 9.389632554640455,
            150: 9.27468129958066,
            151: 9.715447103437876,
            152: 9.785753979887334,
            153: 9.533358817754316,
            154: 9.37145639425241,
            155: 9.35180970184412,
            156: 9.453119712973,
            157: 9.227851331564406,
            158: 9.7344555263546,
            159: 9.882112744697592,
            160: 9.572801678569528,
            161: 9.350164329475675,
            162: 9.388021157947325,
            163: 9.439346477160763,
            164: 9.258948669830964,
            165: 9.673152207815694,
            166: 9.916171451394483,
            167: 9.599065218495673,
            168: 9.35037678612187,
            169: 9.389352474082747,
            170: 9.458782468873055,
            171: 9.269517932159815,
            172: 9.70128520024818,
            173: 9.895340434365806,
            174: 9.593212594980915,
            175: 9.335160301817208,
            176: 9.387845064859398,
            177: 9.471029864596344,
            178: 9.254242420921495,
            179: 9.737492803133085,
            180: 9.866651200745743,
            181: 9.603832504374747,
            182: 9.389903600758519,
            183: 9.38180765064722,
            184: 9.47228290927077,
            185: 9.320390020935756,
            186: 9.760507494956649,
            187: 9.888900695283672,
            188: 9.620107374534847,
            189: 9.362738158105756,
            190: 9.393725270144033,
            191: 9.443645754518037,
            192: 9.335206317758738,
            193: 9.798802255406319,
            194: 9.903668397684397,
            195: 9.609376921810192,
            196: 9.39903533535447,
            197: 9.407876540318657,
            198: 9.467258496811484,
            199: 9.31565868251256,
            200: 9.828915674384946,
            201: 9.89364837562071,
            202: 9.608972569332543,
            203: 9.3833134642038,
            204: 9.425705160642167,
            205: 9.417217058399189,
            206: 9.33806283658793,
            207: 9.73829861795839,
            208: 9.954360324274012,
            209: 9.616537160829498,
            210: 9.34600432372789,
            211: 9.453927661164224,
            212: 9.473662481354525,
            213: 9.315266621517527,
            214: 9.732226128702518,
            215: 9.902701807491406,
            216: 9.613501067352498,
            217: 9.442150958180358,
            218: 9.447223950498294,
            219: 9.48505206728511,
            220: 9.292888357955079,
            221: 9.781433741997922,
            222: 9.907397281605324,
            223: 9.652356435915083,
            224: 9.402787905644999,
            225: 9.444439454290773,
            226: 9.46814636836491,
            227: 9.311152095194478,
            228: 9.785032150475695,
            229: 9.913796533078791,
            230: 9.638061283010881,
            231: 9.418244810196114,
            232: 9.43296336277798,
            233: 9.481588789556906,
            234: 9.310767262581088,
            235: 9.7899874120615,
            236: 9.934076226797432,
            237: 9.675114641480748,
            238: 9.4079213425053,
            239: 9.439952146370308,
            240: 9.481266795511743,
            241: 9.346813148937594,
            242: 9.809871365380761,
            243: 9.919883200912766,
            244: 9.628480103582474,
            245: 9.373133358263212,
            246: 9.46403426142289,
            247: 9.493880815559692,
            248: 9.295442497711017,
            249: 9.729125252820204,
            250: 9.886997100259576,
            251: 9.569391216620195,
            252: 9.367049312169215,
            253: 9.346733545156706,
            254: 9.454011681099558,
            255: 9.259293509908241,
            256: 9.697557315112423,
            257: 9.816120682946806,
            258: 9.521001875720362,
            259: 9.296571815146368,
            260: 9.294023268511618,
            261: 9.349758202027648,
            262: 9.146780476613129,
            263: 9.59706403511772,
            264: 9.779655614206858,
            265: 9.376739319717244,
            266: 9.140265698554904,
            267: 9.16234872798568,
            268: 9.215501519991125,
            269: 9.097004599381162,
            270: 9.542601226181468,
            271: 9.628607752442246,
            272: 9.349069739117063,
            273: 9.068445032203499,
            274: 9.119298892920042,
            275: 9.101350878247677,
            276: 8.981971252253857,
            277: 9.379678453481914,
            278: 9.490869597941524,
            279: 9.22047540267895,
            280: 9.002031234859384,
            281: 8.98616029924105,
            282: 9.047973028098639,
            283: 8.873267633459077,
            284: 9.274543864148288,
            285: 9.402423097526118,
            286: 9.139573580683466,
            287: 8.895126219149088,
            288: 8.933469319191577,
            289: 8.954591172534325,
            290: 8.77758485986378,
            291: 9.164466390157331,
            292: 9.330312134716339,
            293: 9.015415268058858,
            294: 8.750538438081152,
            295: 8.800887086597612,
            296: 8.838234937612807,
            297: 8.668767037087955,
            298: 9.116803930469247,
            299: 9.244821155989227,
            300: 8.934804159121368,
            301: 8.694428518307447,
            302: 8.685354714056793,
            303: 8.770423371995719,
            304: 8.594487622855995,
            305: 8.989939238472227,
            306: 9.10112922892185,
            307: 8.859975483951686,
            308: 8.57194291659573,
            309: 8.608129987856845,
            310: 8.611831654665876,
            311: 8.496068131001968,
            312: 8.918633428200243,
            313: 9.04109155449076,
            314: 8.752955999202275,
            315: 8.503361112476885,
            316: 8.518472292643901,
            317: 8.513038108867576,
            318: 8.353725847243826,
            319: 8.817390535738543,
            320: 8.914667654092455,
            321: 8.661584976334444,
            322: 8.365950879556674,
            323: 8.445576103106239,
            324: 8.434560771693173,
            325: 8.260084983087502,
            326: 8.735051941660279,
            327: 8.843996184170098,
            328: 8.540656308279596,
            329: 8.30702648924858,
            330: 8.314893317140145,
            331: 8.364314004889689,
            332: 8.233019945914315,
            333: 8.612722436572618,
            334: 8.762008925023538,
            335: 8.393459165432944,
            336: 8.207999249697815,
            337: 8.228805114149113,
            338: 8.258072924351236,
            339: 8.106986147252425,
            340: 8.521520908519301,
            341: 8.696678147186491,
            342: 8.344303424209958,
            343: 8.073936497811253,
            344: 8.16757502131792,
            345: 8.151000369279242,
            346: 7.988408330382547,
            347: 8.437901131526646,
            348: 8.511168093215657,
            349: 8.218054325444257,
            350: 7.975129273557365,
            351: 8.053596338350156,
            352: 8.045779319392928,
            353: 7.846413382840571,
            354: 8.407897734088568,
            355: 8.43723813694719,
            356: 8.12100639336968,
            357: 7.876771562981275,
            358: 7.922932558833107,
            359: 7.940703157119092,
            360: 7.800864483881345,
            361: 8.265244833309085,
            362: 8.342352195113726,
            363: 8.048637180194033,
            364: 7.819645780657607,
            365: 7.8034097468158015,
            366: 7.847084600629913,
            367: 7.706423580141056,
            368: 8.143038264153668,
            369: 8.280315066385887,
            370: 7.966141954884263,
            371: 7.691318421939667,
            372: 7.749180477392563,
            373: 7.81271204745412,
            374: 7.615244316606538,
            375: 8.012823097767386,
            376: 8.172499621657307,
            377: 7.82311437565047,
            378: 7.608592902846065,
        },
    }
)

AIR_FCST_15_PROPHET_LOGISTIC_CAP_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
        },
        "fcst": {
            0: 474.8362799512042,
            1: 468.9916881899657,
            2: 502.0106903871963,
            3: 501.49959017106704,
            4: 505.79992157649934,
            5: 547.8462762836779,
            6: 587.6968530468348,
            7: 588.3403217412557,
            8: 539.7408809101208,
            9: 505.7051154784511,
            10: 471.88305612695933,
            11: 501.7918421053647,
            12: 514.9356960790084,
            13: 509.0208125734815,
            14: 545.3487965572431,
        },
        "fcst_lower": {
            0: 445.0823998560953,
            1: 441.72749406446144,
            2: 470.5568868447796,
            3: 474.05250855995007,
            4: 478.23211749758195,
            5: 518.8269948517109,
            6: 559.1549826080967,
            7: 559.2979790265297,
            8: 511.69338424718364,
            9: 480.81903923309454,
            10: 442.6199454492793,
            11: 473.5805909279045,
            12: 484.3658924969916,
            13: 479.81756865254147,
            14: 517.8966627852753,
        },
        "fcst_upper": {
            0: 503.8120428388288,
            1: 498.34230267364455,
            2: 530.9444925914046,
            3: 532.0118708692428,
            4: 532.523958222772,
            5: 576.0691183255308,
            6: 617.4051079222874,
            7: 617.1023278205932,
            8: 567.7339463033223,
            9: 534.7247116394298,
            10: 499.7378203060462,
            11: 529.0246221670866,
            12: 543.5705260770047,
            13: 537.5926543535654,
            14: 574.6001147007677,
        },
    }
)

PEYTON_FCST_30_PROPHET_DAILY_CAP_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.331859311253365,
            1: 7.354249349679736,
            2: 7.389757711441401,
            3: 7.209493662824087,
            4: 7.658651320662986,
            5: 7.7872419710607055,
            6: 7.484632036296666,
            7: 7.248539363366209,
            8: 7.270983523103537,
            9: 7.306546222992052,
            10: 7.126336728682114,
            11: 7.575549156371828,
            12: 7.704194791527012,
            13: 7.40164005578452,
            14: 7.165602795499072,
            15: 7.188102580860686,
            16: 7.223721118706291,
            17: 7.043567674038666,
            18: 7.492836362407444,
            19: 7.621538468625771,
            20: 7.3190404136790495,
            21: 7.083060043267397,
            22: 7.105616926923051,
            23: 7.14129277082636,
            24: 6.961196839320299,
            25: 7.410523247291657,
            26: 7.539283278893468,
            27: 7.236843354444335,
            28: 7.000921318978118,
            29: 7.0235367413603775,
        },
        "fcst_lower": {
            0: 6.6842439270652205,
            1: 6.713058005213148,
            2: 6.754440320348967,
            3: 6.606527358631897,
            4: 7.044280714471815,
            5: 7.115121374747295,
            6: 6.9040178657359474,
            7: 6.636407608070906,
            8: 6.636050657550367,
            9: 6.692957917957333,
            10: 6.5206113819888545,
            11: 6.9775267723980035,
            12: 7.071121866716252,
            13: 6.760760489988774,
            14: 6.542062061397551,
            15: 6.616282717620708,
            16: 6.6470865621378294,
            17: 6.371323918061791,
            18: 6.906073772303484,
            19: 7.029498158978105,
            20: 6.685922550590015,
            21: 6.4580979731311094,
            22: 6.482813339162121,
            23: 6.504087835171158,
            24: 6.382263944707629,
            25: 6.819695194686108,
            26: 6.914474389209892,
            27: 6.563884948007971,
            28: 6.359884556154696,
            29: 6.494487552730167,
        },
        "fcst_upper": {
            0: 7.949249097823939,
            1: 7.93438072107086,
            2: 8.015571324958122,
            3: 7.865807072341612,
            4: 8.29772148729878,
            5: 8.39031213596704,
            6: 8.0905365450609,
            7: 7.85894033719714,
            8: 7.842451969526193,
            9: 7.8885555797463605,
            10: 7.746548997008269,
            11: 8.152878189668238,
            12: 8.256303000560008,
            13: 7.992823490079385,
            14: 7.779979178951879,
            15: 7.78162044235521,
            16: 7.850448062145312,
            17: 7.638227447522366,
            18: 8.103666926540505,
            19: 8.2112302359874,
            20: 7.903303177997009,
            21: 7.6553686926351245,
            22: 7.712960422945617,
            23: 7.757893199604111,
            24: 7.578836431938248,
            25: 8.035622771717362,
            26: 8.157204546960445,
            27: 7.844948363142048,
            28: 7.599181867880122,
            29: 7.621823993259122,
        },
    }
)

AIR_FCST_30_PROPHET_CUSTOM_SEASONALITY_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1961-01-01 00:00:00"),
            1: pd.Timestamp("1961-02-01 00:00:00"),
            2: pd.Timestamp("1961-03-01 00:00:00"),
            3: pd.Timestamp("1961-04-01 00:00:00"),
            4: pd.Timestamp("1961-05-01 00:00:00"),
            5: pd.Timestamp("1961-06-01 00:00:00"),
            6: pd.Timestamp("1961-07-01 00:00:00"),
            7: pd.Timestamp("1961-08-01 00:00:00"),
            8: pd.Timestamp("1961-09-01 00:00:00"),
            9: pd.Timestamp("1961-10-01 00:00:00"),
            10: pd.Timestamp("1961-11-01 00:00:00"),
            11: pd.Timestamp("1961-12-01 00:00:00"),
            12: pd.Timestamp("1962-01-01 00:00:00"),
            13: pd.Timestamp("1962-02-01 00:00:00"),
            14: pd.Timestamp("1962-03-01 00:00:00"),
            15: pd.Timestamp("1962-04-01 00:00:00"),
            16: pd.Timestamp("1962-05-01 00:00:00"),
            17: pd.Timestamp("1962-06-01 00:00:00"),
            18: pd.Timestamp("1962-07-01 00:00:00"),
            19: pd.Timestamp("1962-08-01 00:00:00"),
            20: pd.Timestamp("1962-09-01 00:00:00"),
            21: pd.Timestamp("1962-10-01 00:00:00"),
            22: pd.Timestamp("1962-11-01 00:00:00"),
            23: pd.Timestamp("1962-12-01 00:00:00"),
            24: pd.Timestamp("1963-01-01 00:00:00"),
            25: pd.Timestamp("1963-02-01 00:00:00"),
            26: pd.Timestamp("1963-03-01 00:00:00"),
            27: pd.Timestamp("1963-04-01 00:00:00"),
            28: pd.Timestamp("1963-05-01 00:00:00"),
            29: pd.Timestamp("1963-06-01 00:00:00"),
        },
        "fcst": {
            0: 452.88345517479746,
            1: 437.9750764863489,
            2: 564.0581722096811,
            3: 532.4626894414829,
            4: 565.4929535283603,
            5: 576.5925608005873,
            6: 645.167708008004,
            7: 615.5653243735584,
            8: 541.8783558909014,
            9: 531.4149061053702,
            10: 472.5774066716521,
            11: 526.3906583847821,
            12: 510.13331047183823,
            13: 483.1039140043139,
            14: 664.434422175725,
            15: 628.340440837633,
            16: 666.2631672975554,
            17: 673.4054958880696,
            18: 745.6452388016862,
            19: 713.3207318286643,
            20: 630.0995226187222,
            21: 628.5221175410493,
            22: 560.2062003332692,
            23: 623.9829608974794,
            24: 597.3003973985731,
            25: 556.1991961776957,
            26: 738.4514474984936,
            27: 718.6025531101388,
            28: 740.7349265395878,
            29: 764.6053723392605,
        },
        "fcst_lower": {
            0: 424.682921950405,
            1: 412.5679900824412,
            2: 535.9761313681635,
            3: 504.12183621258754,
            4: 538.4321389211508,
            5: 546.6907787357392,
            6: 618.8095221467094,
            7: 589.9973683308615,
            8: 517.1393430322438,
            9: 505.3623630365468,
            10: 444.84252772723704,
            11: 498.8958861672086,
            12: 483.1574351204671,
            13: 456.3880288790717,
            14: 636.4381386505919,
            15: 602.2841171281649,
            16: 638.8671049496324,
            17: 646.4307940648474,
            18: 718.048688328434,
            19: 685.8153320933951,
            20: 604.2678273379327,
            21: 599.6899383865052,
            22: 532.942733182364,
            23: 595.8332727537743,
            24: 571.9841531156071,
            25: 526.8099646425002,
            26: 713.66525562444,
            27: 689.9773942342617,
            28: 714.9313974529585,
            29: 738.3841244059056,
        },
        "fcst_upper": {
            0: 479.15424546477635,
            1: 464.0312190445665,
            2: 590.4750819576508,
            3: 559.1397365356636,
            4: 591.4381219255607,
            5: 603.8557390466535,
            6: 672.5638319850465,
            7: 644.6682785486421,
            8: 569.5706684196123,
            9: 558.9295999343411,
            10: 498.08943585149916,
            11: 553.1515454929595,
            12: 537.1373508202025,
            13: 509.16408199479247,
            14: 690.3431234462456,
            15: 655.8400715120379,
            16: 690.8885483160265,
            17: 700.3747360683956,
            18: 772.4038012876088,
            19: 741.545426591666,
            20: 656.433095984407,
            21: 656.5497802841992,
            22: 587.2811180341304,
            23: 650.6050821785003,
            24: 623.055539348631,
            25: 582.7958231656721,
            26: 765.648745406405,
            27: 744.6580380710474,
            28: 770.1133464429854,
            29: 791.3905219842743,
        },
    }
)

PEYTON_FCST_30_PROPHET_CUSTOM_SEASONALITY_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2013-05-01 00:00:00"),
            1: pd.Timestamp("2013-05-02 00:00:00"),
            2: pd.Timestamp("2013-05-03 00:00:00"),
            3: pd.Timestamp("2013-05-04 00:00:00"),
            4: pd.Timestamp("2013-05-05 00:00:00"),
            5: pd.Timestamp("2013-05-06 00:00:00"),
            6: pd.Timestamp("2013-05-07 00:00:00"),
            7: pd.Timestamp("2013-05-08 00:00:00"),
            8: pd.Timestamp("2013-05-09 00:00:00"),
            9: pd.Timestamp("2013-05-10 00:00:00"),
            10: pd.Timestamp("2013-05-11 00:00:00"),
            11: pd.Timestamp("2013-05-12 00:00:00"),
            12: pd.Timestamp("2013-05-13 00:00:00"),
            13: pd.Timestamp("2013-05-14 00:00:00"),
            14: pd.Timestamp("2013-05-15 00:00:00"),
            15: pd.Timestamp("2013-05-16 00:00:00"),
            16: pd.Timestamp("2013-05-17 00:00:00"),
            17: pd.Timestamp("2013-05-18 00:00:00"),
            18: pd.Timestamp("2013-05-19 00:00:00"),
            19: pd.Timestamp("2013-05-20 00:00:00"),
            20: pd.Timestamp("2013-05-21 00:00:00"),
            21: pd.Timestamp("2013-05-22 00:00:00"),
            22: pd.Timestamp("2013-05-23 00:00:00"),
            23: pd.Timestamp("2013-05-24 00:00:00"),
            24: pd.Timestamp("2013-05-25 00:00:00"),
            25: pd.Timestamp("2013-05-26 00:00:00"),
            26: pd.Timestamp("2013-05-27 00:00:00"),
            27: pd.Timestamp("2013-05-28 00:00:00"),
            28: pd.Timestamp("2013-05-29 00:00:00"),
            29: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 7.3037491155836,
            1: 7.298802654989095,
            2: 7.302759950741621,
            3: 7.087397229569874,
            4: 7.498713130599085,
            5: 7.587266579175969,
            6: 7.243228524765057,
            7: 6.957122764380708,
            8: 6.937961394872215,
            9: 6.932939334396985,
            10: 6.713982929830124,
            11: 7.127100370274706,
            12: 7.222720303593862,
            13: 6.890748090874125,
            14: 6.621314782411355,
            15: 6.622924120496868,
            16: 6.642161678096348,
            17: 6.450260735153485,
            18: 6.892472125750261,
            19: 7.0184239080258815,
            20: 6.717199704101642,
            21: 6.478110179851799,
            22: 6.508862347295869,
            23: 6.555290184879691,
            24: 6.387940589397616,
            25: 6.85146134706936,
            26: 6.994976487299352,
            27: 6.707177448764311,
            28: 6.477104192294041,
            29: 6.512320699071476,
        },
        "fcst_lower": {
            0: 6.717252779036359,
            1: 6.718124085984931,
            2: 6.727356960944083,
            3: 6.540505402788345,
            4: 6.9423240783761555,
            5: 6.978577722980976,
            6: 6.717895242425473,
            7: 6.399576409383779,
            8: 6.368149007248556,
            9: 6.382128615992393,
            10: 6.165423236124337,
            11: 6.585560928300749,
            12: 6.648173270105328,
            13: 6.310032220065989,
            14: 6.054488305589597,
            15: 6.103721169443442,
            16: 6.124426526327651,
            17: 5.83892418242846,
            18: 6.362965901550441,
            19: 6.478591082020587,
            20: 6.140482234300091,
            21: 5.910310146894073,
            22: 5.94163876550658,
            23: 5.9741522761438635,
            24: 5.854476398076014,
            25: 6.317910733216211,
            26: 6.426611998730378,
            27: 6.091164986077031,
            28: 5.883013233762382,
            29: 6.030362117789187,
        },
        "fcst_upper": {
            0: 7.862872411425703,
            1: 7.824183818476362,
            2: 7.869512070364395,
            3: 7.681770710662209,
            4: 8.077548105946294,
            5: 8.133421675293558,
            6: 7.793681230930931,
            7: 7.510239664570255,
            8: 7.4565809990786605,
            9: 7.463485876121115,
            10: 7.274334203168064,
            11: 7.654608992969765,
            12: 7.723338203519616,
            13: 7.426595502999383,
            14: 7.179817840416072,
            15: 7.155976160949455,
            16: 7.210038382027373,
            17: 6.985326382781782,
            18: 7.439788720419854,
            19: 7.5553759309243445,
            20: 7.246882224102252,
            21: 6.997163599111351,
            22: 7.056755226508162,
            23: 7.112151947124181,
            24: 6.949637505738485,
            25: 7.418501055847267,
            26: 7.558483941708863,
            27: 7.263961758272869,
            28: 7.023147231669527,
            29: 7.055461672474383,
        },
    }
)

NONSEASONAL_FCST_15_PROPHET_ARG_FUTURE_SM_12 = pd.DataFrame(
    {
        "ds": {
            0: pd.Timestamp("1963-01-31 00:00:00"),
            1: pd.Timestamp("1963-02-28 00:00:00"),
            2: pd.Timestamp("1963-03-31 00:00:00"),
            3: pd.Timestamp("1963-04-30 00:00:00"),
            4: pd.Timestamp("1963-05-31 00:00:00"),
            5: pd.Timestamp("1963-06-30 00:00:00"),
            6: pd.Timestamp("1963-07-31 00:00:00"),
            7: pd.Timestamp("1963-08-31 00:00:00"),
            8: pd.Timestamp("1963-09-30 00:00:00"),
            9: pd.Timestamp("1963-10-31 00:00:00"),
            10: pd.Timestamp("1963-11-30 00:00:00"),
            11: pd.Timestamp("1963-12-31 00:00:00"),
        },
        "trend": {
            0: 1.486350603534519,
            1: 1.5153722851275742,
            2: 1.5475034326055999,
            3: 1.578598091455302,
            4: 1.6107292389333274,
            5: 1.6418238977830293,
            6: 1.6739550452610548,
            7: 1.7060861927390802,
            8: 1.7371808515887825,
            9: 1.7693119990668078,
            10: 1.8004066579165097,
            11: 1.8325378053945354,
        },
        "yhat_lower": {
            0: 1.1594374527896225,
            1: -2.248335089418763,
            2: 2.0604229200339033,
            3: 2.282279023692054,
            4: 1.2809544896920573,
            5: -0.3992332220290529,
            6: -3.552547372716627,
            7: 2.4299554266978927,
            8: 2.90002363984548,
            9: 0.697405496110251,
            10: 0.9017089206367225,
            11: 0.953747778118578,
        },
        "yhat_upper": {
            0: 1.6201165163539932,
            1: -1.7455747337333132,
            2: 2.5318091002522354,
            3: 2.7779595054263746,
            4: 1.7376132983822454,
            5: 0.07946819642562761,
            6: -3.0853192468484716,
            7: 2.896084899140792,
            8: 3.3712332482598972,
            9: 1.1821260937977756,
            10: 1.3997416814214965,
            11: 1.44748259249655,
        },
        "trend_lower": {
            0: 1.4863505500576313,
            1: 1.5153720936426587,
            2: 1.5475030409697264,
            3: 1.5785974767860411,
            4: 1.6107283337518905,
            5: 1.6418227060060375,
            6: 1.6739535322013472,
            7: 1.706084373854531,
            8: 1.737178641074902,
            9: 1.7693093386754053,
            10: 1.8004035415059678,
            11: 1.832534164518234,
        },
        "trend_upper": {
            0: 1.4863506599270937,
            1: 1.5153724517235998,
            2: 1.5475037804678078,
            3: 1.5785986386243034,
            4: 1.6107300179963508,
            5: 1.6418249316723945,
            6: 1.673956380607812,
            7: 1.7060878674661635,
            8: 1.7371828907559823,
            9: 1.76931438969385,
            10: 1.8004094470881942,
            11: 1.8325410022081747,
        },
        "additive_terms": {
            0: -0.10603153621962905,
            1: -3.5100601864407293,
            2: 0.7525595383687024,
            3: 0.949597753337762,
            4: -0.08872196007635745,
            5: -1.789757575277333,
            6: -4.992084112210709,
            7: 0.943992044598797,
            8: 1.4107642203091333,
            9: -0.8269897561986163,
            10: -0.633279481381239,
            11: -0.6277870965254754,
        },
        "additive_terms_lower": {
            0: -0.10603153621962905,
            1: -3.5100601864407293,
            2: 0.7525595383687024,
            3: 0.949597753337762,
            4: -0.08872196007635745,
            5: -1.789757575277333,
            6: -4.992084112210709,
            7: 0.943992044598797,
            8: 1.4107642203091333,
            9: -0.8269897561986163,
            10: -0.633279481381239,
            11: -0.6277870965254754,
        },
        "additive_terms_upper": {
            0: -0.10603153621962905,
            1: -3.5100601864407293,
            2: 0.7525595383687024,
            3: 0.949597753337762,
            4: -0.08872196007635745,
            5: -1.789757575277333,
            6: -4.992084112210709,
            7: 0.943992044598797,
            8: 1.4107642203091333,
            9: -0.8269897561986163,
            10: -0.633279481381239,
            11: -0.6277870965254754,
        },
        "yearly": {
            0: -0.10603153621962905,
            1: -3.5100601864407293,
            2: 0.7525595383687024,
            3: 0.949597753337762,
            4: -0.08872196007635745,
            5: -1.789757575277333,
            6: -4.992084112210709,
            7: 0.943992044598797,
            8: 1.4107642203091333,
            9: -0.8269897561986163,
            10: -0.633279481381239,
            11: -0.6277870965254754,
        },
        "yearly_lower": {
            0: -0.10603153621962905,
            1: -3.5100601864407293,
            2: 0.7525595383687024,
            3: 0.949597753337762,
            4: -0.08872196007635745,
            5: -1.789757575277333,
            6: -4.992084112210709,
            7: 0.943992044598797,
            8: 1.4107642203091333,
            9: -0.8269897561986163,
            10: -0.633279481381239,
            11: -0.6277870965254754,
        },
        "yearly_upper": {
            0: -0.10603153621962905,
            1: -3.5100601864407293,
            2: 0.7525595383687024,
            3: 0.949597753337762,
            4: -0.08872196007635745,
            5: -1.789757575277333,
            6: -4.992084112210709,
            7: 0.943992044598797,
            8: 1.4107642203091333,
            9: -0.8269897561986163,
            10: -0.633279481381239,
            11: -0.6277870965254754,
        },
        "multiplicative_terms": {
            0: 0.0,
            1: 0.0,
            2: 0.0,
            3: 0.0,
            4: 0.0,
            5: 0.0,
            6: 0.0,
            7: 0.0,
            8: 0.0,
            9: 0.0,
            10: 0.0,
            11: 0.0,
        },
        "multiplicative_terms_lower": {
            0: 0.0,
            1: 0.0,
            2: 0.0,
            3: 0.0,
            4: 0.0,
            5: 0.0,
            6: 0.0,
            7: 0.0,
            8: 0.0,
            9: 0.0,
            10: 0.0,
            11: 0.0,
        },
        "multiplicative_terms_upper": {
            0: 0.0,
            1: 0.0,
            2: 0.0,
            3: 0.0,
            4: 0.0,
            5: 0.0,
            6: 0.0,
            7: 0.0,
            8: 0.0,
            9: 0.0,
            10: 0.0,
            11: 0.0,
        },
        "yhat": {
            0: 1.38031906731489,
            1: -1.994687901313155,
            2: 2.3000629709743023,
            3: 2.528195844793064,
            4: 1.52200727885697,
            5: -0.14793367749430364,
            6: -3.3181290669496546,
            7: 2.650078237337877,
            8: 3.147945071897916,
            9: 0.9423222428681916,
            10: 1.1671271765352706,
            11: 1.20475070886906,
        },
    }
)

AIR_FCST_15_THETA_SM_11 = pd.DataFrame(
    {
        "time": {
            144: pd.Timestamp("1961-01-01 00:00:00"),
            145: pd.Timestamp("1961-02-01 00:00:00"),
            146: pd.Timestamp("1961-03-01 00:00:00"),
            147: pd.Timestamp("1961-04-01 00:00:00"),
            148: pd.Timestamp("1961-05-01 00:00:00"),
            149: pd.Timestamp("1961-06-01 00:00:00"),
            150: pd.Timestamp("1961-07-01 00:00:00"),
            151: pd.Timestamp("1961-08-01 00:00:00"),
            152: pd.Timestamp("1961-09-01 00:00:00"),
            153: pd.Timestamp("1961-10-01 00:00:00"),
            154: pd.Timestamp("1961-11-01 00:00:00"),
            155: pd.Timestamp("1961-12-01 00:00:00"),
            156: pd.Timestamp("1962-01-01 00:00:00"),
            157: pd.Timestamp("1962-02-01 00:00:00"),
            158: pd.Timestamp("1962-03-01 00:00:00"),
        },
        "fcst": {
            144: 447.12997053137497,
            145: 416.8943415790874,
            146: 461.31785253090857,
            147: 480.8468434929286,
            148: 499.02818626377126,
            149: 561.930444765741,
            150: 651.3312292286936,
            151: 647.5086856403731,
            152: 529.1660189014996,
            153: 474.192343615874,
            154: 405.4960170447968,
            155: 445.52827993367737,
            156: 461.5181965591764,
            157: 430.273735190953,
            158: 476.08344090751103,
        },
        "fcst_lower": {
            144: 433.2370906368733,
            145: 398.5247559820268,
            146: 439.3662867951251,
            147: 455.8208409855942,
            148: 471.26615527283343,
            149: 531.6788344286617,
            150: 618.7798929852893,
            151: 612.809707925232,
            152: 492.4447904672473,
            153: 435.5545618347569,
            154: 365.03235749440626,
            155: 403.3176496676579,
            156: 417.6300789110101,
            157: 384.7699283837861,
            158: 429.0193782143196,
        },
        "fcst_upper": {
            144: 461.02285042587664,
            145: 435.26392717614794,
            146: 483.269418266692,
            147: 505.872846000263,
            148: 526.7902172547091,
            149: 592.1820551028202,
            150: 683.8825654720979,
            151: 682.2076633555141,
            152: 565.8872473357519,
            153: 512.8301253969911,
            154: 445.9596765951874,
            155: 487.7389101996968,
            156: 505.40631420734263,
            157: 475.7775419981199,
            158: 523.1475036007025,
        },
    }
)

AIR_FCST_15_THETA_INCL_HIST_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("1949-01-01 00:00:00"),
            1: pd.Timestamp("1949-02-01 00:00:00"),
            2: pd.Timestamp("1949-03-01 00:00:00"),
            3: pd.Timestamp("1949-04-01 00:00:00"),
            4: pd.Timestamp("1949-05-01 00:00:00"),
            5: pd.Timestamp("1949-06-01 00:00:00"),
            6: pd.Timestamp("1949-07-01 00:00:00"),
            7: pd.Timestamp("1949-08-01 00:00:00"),
            8: pd.Timestamp("1949-09-01 00:00:00"),
            9: pd.Timestamp("1949-10-01 00:00:00"),
            10: pd.Timestamp("1949-11-01 00:00:00"),
            11: pd.Timestamp("1949-12-01 00:00:00"),
            12: pd.Timestamp("1950-01-01 00:00:00"),
            13: pd.Timestamp("1950-02-01 00:00:00"),
            14: pd.Timestamp("1950-03-01 00:00:00"),
            15: pd.Timestamp("1950-04-01 00:00:00"),
            16: pd.Timestamp("1950-05-01 00:00:00"),
            17: pd.Timestamp("1950-06-01 00:00:00"),
            18: pd.Timestamp("1950-07-01 00:00:00"),
            19: pd.Timestamp("1950-08-01 00:00:00"),
            20: pd.Timestamp("1950-09-01 00:00:00"),
            21: pd.Timestamp("1950-10-01 00:00:00"),
            22: pd.Timestamp("1950-11-01 00:00:00"),
            23: pd.Timestamp("1950-12-01 00:00:00"),
            24: pd.Timestamp("1951-01-01 00:00:00"),
            25: pd.Timestamp("1951-02-01 00:00:00"),
            26: pd.Timestamp("1951-03-01 00:00:00"),
            27: pd.Timestamp("1951-04-01 00:00:00"),
            28: pd.Timestamp("1951-05-01 00:00:00"),
            29: pd.Timestamp("1951-06-01 00:00:00"),
            30: pd.Timestamp("1951-07-01 00:00:00"),
            31: pd.Timestamp("1951-08-01 00:00:00"),
            32: pd.Timestamp("1951-09-01 00:00:00"),
            33: pd.Timestamp("1951-10-01 00:00:00"),
            34: pd.Timestamp("1951-11-01 00:00:00"),
            35: pd.Timestamp("1951-12-01 00:00:00"),
            36: pd.Timestamp("1952-01-01 00:00:00"),
            37: pd.Timestamp("1952-02-01 00:00:00"),
            38: pd.Timestamp("1952-03-01 00:00:00"),
            39: pd.Timestamp("1952-04-01 00:00:00"),
            40: pd.Timestamp("1952-05-01 00:00:00"),
            41: pd.Timestamp("1952-06-01 00:00:00"),
            42: pd.Timestamp("1952-07-01 00:00:00"),
            43: pd.Timestamp("1952-08-01 00:00:00"),
            44: pd.Timestamp("1952-09-01 00:00:00"),
            45: pd.Timestamp("1952-10-01 00:00:00"),
            46: pd.Timestamp("1952-11-01 00:00:00"),
            47: pd.Timestamp("1952-12-01 00:00:00"),
            48: pd.Timestamp("1953-01-01 00:00:00"),
            49: pd.Timestamp("1953-02-01 00:00:00"),
            50: pd.Timestamp("1953-03-01 00:00:00"),
            51: pd.Timestamp("1953-04-01 00:00:00"),
            52: pd.Timestamp("1953-05-01 00:00:00"),
            53: pd.Timestamp("1953-06-01 00:00:00"),
            54: pd.Timestamp("1953-07-01 00:00:00"),
            55: pd.Timestamp("1953-08-01 00:00:00"),
            56: pd.Timestamp("1953-09-01 00:00:00"),
            57: pd.Timestamp("1953-10-01 00:00:00"),
            58: pd.Timestamp("1953-11-01 00:00:00"),
            59: pd.Timestamp("1953-12-01 00:00:00"),
            60: pd.Timestamp("1954-01-01 00:00:00"),
            61: pd.Timestamp("1954-02-01 00:00:00"),
            62: pd.Timestamp("1954-03-01 00:00:00"),
            63: pd.Timestamp("1954-04-01 00:00:00"),
            64: pd.Timestamp("1954-05-01 00:00:00"),
            65: pd.Timestamp("1954-06-01 00:00:00"),
            66: pd.Timestamp("1954-07-01 00:00:00"),
            67: pd.Timestamp("1954-08-01 00:00:00"),
            68: pd.Timestamp("1954-09-01 00:00:00"),
            69: pd.Timestamp("1954-10-01 00:00:00"),
            70: pd.Timestamp("1954-11-01 00:00:00"),
            71: pd.Timestamp("1954-12-01 00:00:00"),
            72: pd.Timestamp("1955-01-01 00:00:00"),
            73: pd.Timestamp("1955-02-01 00:00:00"),
            74: pd.Timestamp("1955-03-01 00:00:00"),
            75: pd.Timestamp("1955-04-01 00:00:00"),
            76: pd.Timestamp("1955-05-01 00:00:00"),
            77: pd.Timestamp("1955-06-01 00:00:00"),
            78: pd.Timestamp("1955-07-01 00:00:00"),
            79: pd.Timestamp("1955-08-01 00:00:00"),
            80: pd.Timestamp("1955-09-01 00:00:00"),
            81: pd.Timestamp("1955-10-01 00:00:00"),
            82: pd.Timestamp("1955-11-01 00:00:00"),
            83: pd.Timestamp("1955-12-01 00:00:00"),
            84: pd.Timestamp("1956-01-01 00:00:00"),
            85: pd.Timestamp("1956-02-01 00:00:00"),
            86: pd.Timestamp("1956-03-01 00:00:00"),
            87: pd.Timestamp("1956-04-01 00:00:00"),
            88: pd.Timestamp("1956-05-01 00:00:00"),
            89: pd.Timestamp("1956-06-01 00:00:00"),
            90: pd.Timestamp("1956-07-01 00:00:00"),
            91: pd.Timestamp("1956-08-01 00:00:00"),
            92: pd.Timestamp("1956-09-01 00:00:00"),
            93: pd.Timestamp("1956-10-01 00:00:00"),
            94: pd.Timestamp("1956-11-01 00:00:00"),
            95: pd.Timestamp("1956-12-01 00:00:00"),
            96: pd.Timestamp("1957-01-01 00:00:00"),
            97: pd.Timestamp("1957-02-01 00:00:00"),
            98: pd.Timestamp("1957-03-01 00:00:00"),
            99: pd.Timestamp("1957-04-01 00:00:00"),
            100: pd.Timestamp("1957-05-01 00:00:00"),
            101: pd.Timestamp("1957-06-01 00:00:00"),
            102: pd.Timestamp("1957-07-01 00:00:00"),
            103: pd.Timestamp("1957-08-01 00:00:00"),
            104: pd.Timestamp("1957-09-01 00:00:00"),
            105: pd.Timestamp("1957-10-01 00:00:00"),
            106: pd.Timestamp("1957-11-01 00:00:00"),
            107: pd.Timestamp("1957-12-01 00:00:00"),
            108: pd.Timestamp("1958-01-01 00:00:00"),
            109: pd.Timestamp("1958-02-01 00:00:00"),
            110: pd.Timestamp("1958-03-01 00:00:00"),
            111: pd.Timestamp("1958-04-01 00:00:00"),
            112: pd.Timestamp("1958-05-01 00:00:00"),
            113: pd.Timestamp("1958-06-01 00:00:00"),
            114: pd.Timestamp("1958-07-01 00:00:00"),
            115: pd.Timestamp("1958-08-01 00:00:00"),
            116: pd.Timestamp("1958-09-01 00:00:00"),
            117: pd.Timestamp("1958-10-01 00:00:00"),
            118: pd.Timestamp("1958-11-01 00:00:00"),
            119: pd.Timestamp("1958-12-01 00:00:00"),
            120: pd.Timestamp("1959-01-01 00:00:00"),
            121: pd.Timestamp("1959-02-01 00:00:00"),
            122: pd.Timestamp("1959-03-01 00:00:00"),
            123: pd.Timestamp("1959-04-01 00:00:00"),
            124: pd.Timestamp("1959-05-01 00:00:00"),
            125: pd.Timestamp("1959-06-01 00:00:00"),
            126: pd.Timestamp("1959-07-01 00:00:00"),
            127: pd.Timestamp("1959-08-01 00:00:00"),
            128: pd.Timestamp("1959-09-01 00:00:00"),
            129: pd.Timestamp("1959-10-01 00:00:00"),
            130: pd.Timestamp("1959-11-01 00:00:00"),
            131: pd.Timestamp("1959-12-01 00:00:00"),
            132: pd.Timestamp("1960-01-01 00:00:00"),
            133: pd.Timestamp("1960-02-01 00:00:00"),
            134: pd.Timestamp("1960-03-01 00:00:00"),
            135: pd.Timestamp("1960-04-01 00:00:00"),
            136: pd.Timestamp("1960-05-01 00:00:00"),
            137: pd.Timestamp("1960-06-01 00:00:00"),
            138: pd.Timestamp("1960-07-01 00:00:00"),
            139: pd.Timestamp("1960-08-01 00:00:00"),
            140: pd.Timestamp("1960-09-01 00:00:00"),
            141: pd.Timestamp("1960-10-01 00:00:00"),
            142: pd.Timestamp("1960-11-01 00:00:00"),
            143: pd.Timestamp("1960-12-01 00:00:00"),
            144: pd.Timestamp("1961-01-01 00:00:00"),
            145: pd.Timestamp("1961-02-01 00:00:00"),
            146: pd.Timestamp("1961-03-01 00:00:00"),
            147: pd.Timestamp("1961-04-01 00:00:00"),
            148: pd.Timestamp("1961-05-01 00:00:00"),
            149: pd.Timestamp("1961-06-01 00:00:00"),
            150: pd.Timestamp("1961-07-01 00:00:00"),
            151: pd.Timestamp("1961-08-01 00:00:00"),
            152: pd.Timestamp("1961-09-01 00:00:00"),
            153: pd.Timestamp("1961-10-01 00:00:00"),
            154: pd.Timestamp("1961-11-01 00:00:00"),
            155: pd.Timestamp("1961-12-01 00:00:00"),
            156: pd.Timestamp("1962-01-01 00:00:00"),
            157: pd.Timestamp("1962-02-01 00:00:00"),
            158: pd.Timestamp("1962-03-01 00:00:00"),
        },
        "fcst": {
            0: 111.7905799360185,
            1: 119.82472512125055,
            2: 131.14459763569317,
            3: 125.56839165628531,
            4: 119.86272981994105,
            5: 135.83754410276745,
            6: 149.55111916170793,
            7: 146.12359906035255,
            8: 136.27856835553996,
            9: 115.64427567629895,
            10: 102.25215634207217,
            11: 120.38471744168451,
            12: 117.35820040626832,
            13: 121.44248345318918,
            14: 140.0599508848024,
            15: 133.21249298615248,
            16: 128.58840829955054,
            17: 140.0348065110792,
            18: 162.27805574794718,
            19: 168.02484366344544,
            20: 154.03555563776092,
            21: 135.37939004533348,
            22: 115.53586109927777,
            23: 131.21208878884235,
            24: 138.72758314130448,
            25: 149.21937140707112,
            26: 169.00075796540986,
            27: 166.57241737737675,
            28: 159.05859598099732,
            29: 188.879914591256,
            30: 195.8045812609248,
            31: 198.9715149173661,
            32: 177.7624336703185,
            33: 159.0700433371404,
            34: 140.43926674756182,
            35: 165.40813871220757,
            36: 167.42689952684722,
            37: 172.68120091210173,
            38: 204.59250345246096,
            39: 183.0075063052462,
            40: 180.27613965475433,
            41: 200.42189495419697,
            42: 233.85450605995783,
            43: 232.524089620245,
            44: 211.86339315758138,
            45: 184.14462724282973,
            46: 165.9542633395202,
            47: 192.54116557192023,
            48: 196.25783252624996,
            49: 192.36244942841208,
            50: 226.828657700216,
            51: 224.41477542438489,
            52: 233.22798750966024,
            53: 254.0565182678204,
            54: 266.8152196684842,
            55: 264.07814373253336,
            56: 236.1362421912865,
            57: 209.25459449535404,
            58: 183.47994401913246,
            59: 201.82240017025208,
            60: 204.28588594510396,
            61: 195.8401409673102,
            62: 221.12524361013655,
            63: 226.88852560331415,
            64: 225.9544728418766,
            65: 260.73687669847055,
            66: 291.84692199486915,
            67: 294.55118676724476,
            68: 255.90070689766952,
            69: 226.47456225183024,
            70: 197.69540185551435,
            71: 227.50811360264754,
            72: 233.05463830418378,
            73: 228.25729667155636,
            74: 271.47136641390483,
            75: 261.4129617151037,
            76: 268.40009231006866,
            77: 306.99864737061506,
            78: 349.93431398344404,
            79: 350.048832841657,
            80: 303.5865637959524,
            81: 269.1129924197851,
            82: 236.9594208289742,
            83: 266.7433297777855,
            84: 282.068689883387,
            85: 268.8725429163281,
            86: 317.8642039675062,
            87: 309.201394113091,
            88: 314.908132497328,
            89: 369.19523059903406,
            90: 415.1461165352526,
            91: 402.3677847544506,
            92: 349.4869939218194,
            93: 305.3769087729116,
            94: 265.6678894162828,
            95: 302.3260379839074,
            96: 311.712248384884,
            97: 297.9299486067005,
            98: 345.0876423584656,
            99: 343.9674701251021,
            100: 353.933299360484,
            101: 414.9914085002251,
            102: 468.0116723310664,
            103: 462.0048489728523,
            104: 393.4166570765834,
            105: 347.9647719545135,
            106: 301.83137622262024,
            107: 336.5507955174962,
            108: 345.3549206140498,
            109: 320.8234223900151,
            110: 362.3406494213253,
            111: 357.5627964594115,
            112: 358.2424853667907,
            113: 418.23268478045287,
            114: 486.7977555338237,
            115: 488.06843993619253,
            116: 418.7248814627883,
            117: 354.3490302950448,
            118: 310.2744981728548,
            119: 341.32915090561175,
            120: 347.3038516002216,
            121: 335.1924314711943,
            122: 382.54589002115716,
            123: 407.6269097110198,
            124: 409.7820711563323,
            125: 477.1963934572989,
            126: 538.7376784778799,
            127: 543.7565580990243,
            128: 458.4631486624468,
            129: 408.34402250877673,
            130: 349.9485743891647,
            131: 395.49678803805085,
            132: 416.5802995582341,
            133: 387.70931695887504,
            134: 431.0200916138051,
            135: 437.26216103376447,
            136: 473.84558017158747,
            137: 530.3687089879487,
            138: 617.7571252407732,
            139: 616.1542255966216,
            140: 495.06058306948773,
            141: 452.4724502903674,
            142: 392.20374950190387,
            143: 427.71221850789254,
            144: 447.12997053137497,
            145: 416.8943415790874,
            146: 461.31785253090857,
            147: 480.8468434929286,
            148: 499.02818626377126,
            149: 561.930444765741,
            150: 651.3312292286936,
            151: 647.5086856403731,
            152: 529.1660189014996,
            153: 474.192343615874,
            154: 405.4960170447968,
            155: 445.52827993367737,
            156: 461.5181965591764,
            157: 430.273735190953,
            158: 476.08344090751103,
        },
        "fcst_lower": {
            0: 97.8977000415168,
            1: 105.93184522674885,
            2: 117.25171774119147,
            3: 111.67551176178361,
            4: 105.96984992543935,
            5: 121.94466420826575,
            6: 135.65823926720623,
            7: 132.23071916585084,
            8: 122.38568846103826,
            9: 101.75139578179724,
            10: 88.35927644757047,
            11: 106.49183754718281,
            12: 103.46532051176662,
            13: 107.54960355868748,
            14: 126.16707099030069,
            15: 119.31961309165078,
            16: 114.69552840504883,
            17: 126.1419266165775,
            18: 148.38517585344547,
            19: 154.13196376894373,
            20: 140.14267574325922,
            21: 121.48651015083178,
            22: 101.64298120477606,
            23: 117.31920889434065,
            24: 124.83470324680277,
            25: 135.32649151256942,
            26: 155.10787807090816,
            27: 152.67953748287505,
            28: 145.16571608649562,
            29: 174.9870346967543,
            30: 181.9117013664231,
            31: 185.0786350228644,
            32: 163.8695537758168,
            33: 145.1771634426387,
            34: 126.54638685306011,
            35: 151.51525881770587,
            36: 153.53401963234552,
            37: 158.78832101760003,
            38: 190.69962355795926,
            39: 169.1146264107445,
            40: 166.38325976025263,
            41: 186.52901505969527,
            42: 219.96162616545612,
            43: 218.6312097257433,
            44: 197.97051326307968,
            45: 170.25174734832802,
            46: 152.0613834450185,
            47: 178.64828567741853,
            48: 182.36495263174825,
            49: 178.46956953391037,
            50: 212.9357778057143,
            51: 210.52189552988318,
            52: 219.33510761515853,
            53: 240.1636383733187,
            54: 252.9223397739825,
            55: 250.18526383803166,
            56: 222.2433622967848,
            57: 195.36171460085234,
            58: 169.58706412463076,
            59: 187.92952027575038,
            60: 190.39300605060225,
            61: 181.9472610728085,
            62: 207.23236371563485,
            63: 212.99564570881245,
            64: 212.0615929473749,
            65: 246.84399680396885,
            66: 277.9540421003675,
            67: 280.6583068727431,
            68: 242.00782700316782,
            69: 212.58168235732853,
            70: 183.80252196101264,
            71: 213.61523370814584,
            72: 219.16175840968208,
            73: 214.36441677705466,
            74: 257.57848651940316,
            75: 247.52008182060197,
            76: 254.50721241556695,
            77: 293.1057674761134,
            78: 336.04143408894237,
            79: 336.1559529471553,
            80: 289.6936839014507,
            81: 255.22011252528338,
            82: 223.0665409344725,
            83: 252.8504498832838,
            84: 268.1758099888853,
            85: 254.97966302182638,
            86: 303.97132407300455,
            87: 295.3085142185893,
            88: 301.0152526028263,
            89: 355.3023507045324,
            90: 401.2532366407509,
            91: 388.47490485994894,
            92: 335.59411402731774,
            93: 291.4840288784099,
            94: 251.77500952178107,
            95: 288.4331580894057,
            96: 297.8193684903823,
            97: 284.03706871219885,
            98: 331.1947624639639,
            99: 330.07459023060045,
            100: 340.0404194659823,
            101: 401.0985286057234,
            102: 454.1187924365647,
            103: 448.1119690783506,
            104: 379.52377718208174,
            105: 334.0718920600118,
            106: 287.93849632811856,
            107: 322.65791562299455,
            108: 331.4620407195481,
            109: 306.9305424955134,
            110: 348.4477695268236,
            111: 343.66991656490984,
            112: 344.349605472289,
            113: 404.3398048859512,
            114: 472.90487563932203,
            115: 474.17556004169086,
            116: 404.8320015682866,
            117: 340.45615040054315,
            118: 296.38161827835313,
            119: 327.4362710111101,
            120: 333.41097170571993,
            121: 321.29955157669264,
            122: 368.6530101266555,
            123: 393.7340298165181,
            124: 395.8891912618306,
            125: 463.3035135627972,
            126: 524.8447985833782,
            127: 529.8636782045227,
            128: 444.57026876794515,
            129: 394.45114261427506,
            130: 336.05569449466304,
            131: 381.6039081435492,
            132: 402.68741966373244,
            133: 373.81643706437336,
            134: 417.12721171930343,
            135: 423.3692811392628,
            136: 459.9527002770858,
            137: 516.475829093447,
            138: 603.8642453462716,
            139: 602.2613457021199,
            140: 481.16770317498606,
            141: 438.57957039586574,
            142: 378.3108696074022,
            143: 413.81933861339087,
            144: 433.2370906368733,
            145: 398.5247559820268,
            146: 439.3662867951251,
            147: 455.8208409855942,
            148: 471.26615527283343,
            149: 531.6788344286617,
            150: 618.7798929852893,
            151: 612.809707925232,
            152: 492.4447904672473,
            153: 435.5545618347569,
            154: 365.03235749440626,
            155: 403.3176496676579,
            156: 417.6300789110101,
            157: 384.7699283837861,
            158: 429.0193782143196,
        },
        "fcst_upper": {
            0: 125.6834598305202,
            1: 133.71760501575224,
            2: 145.03747753019488,
            3: 139.46127155078702,
            4: 133.75560971444276,
            5: 149.73042399726916,
            6: 163.44399905620963,
            7: 160.01647895485425,
            8: 150.17144825004166,
            9: 129.53715557080065,
            10: 116.14503623657387,
            11: 134.2775973361862,
            12: 131.25108030077,
            13: 135.33536334769087,
            14: 153.9528307793041,
            15: 147.1053728806542,
            16: 142.48128819405224,
            17: 153.9276864055809,
            18: 176.17093564244888,
            19: 181.91772355794714,
            20: 167.92843553226263,
            21: 149.27226993983518,
            22: 129.42874099377946,
            23: 145.10496868334405,
            24: 152.62046303580618,
            25: 163.11225130157283,
            26: 182.89363785991156,
            27: 180.46529727187846,
            28: 172.95147587549903,
            29: 202.77279448575771,
            30: 209.6974611554265,
            31: 212.8643948118678,
            32: 191.6553135648202,
            33: 172.9629232316421,
            34: 154.33214664206352,
            35: 179.30101860670928,
            36: 181.31977942134893,
            37: 186.57408080660343,
            38: 218.48538334696266,
            39: 196.9003861997479,
            40: 194.16901954925603,
            41: 214.31477484869868,
            42: 247.74738595445953,
            43: 246.4169695147467,
            44: 225.7562730520831,
            45: 198.03750713733143,
            46: 179.8471432340219,
            47: 206.43404546642194,
            48: 210.15071242075166,
            49: 206.25532932291378,
            50: 240.72153759471772,
            51: 238.3076553188866,
            52: 247.12086740416194,
            53: 267.9493981623221,
            54: 280.70809956298586,
            55: 277.97102362703504,
            56: 250.0291220857882,
            57: 223.14747438985574,
            58: 197.37282391363416,
            59: 215.71528006475378,
            60: 218.17876583960566,
            61: 209.7330208618119,
            62: 235.01812350463825,
            63: 240.78140549781585,
            64: 239.8473527363783,
            65: 274.6297565929722,
            66: 305.7398018893708,
            67: 308.44406666174643,
            68: 269.7935867921712,
            69: 240.36744214633194,
            70: 211.58828175001605,
            71: 241.40099349714924,
            72: 246.9475181986855,
            73: 242.15017656605806,
            74: 285.3642463084065,
            75: 275.30584160960535,
            76: 282.29297220457033,
            77: 320.89152726511674,
            78: 363.8271938779457,
            79: 363.94171273615865,
            80: 317.47944369045405,
            81: 283.00587231428676,
            82: 250.8523007234759,
            83: 280.6362096722872,
            84: 295.96156977788866,
            85: 282.76542281082976,
            86: 331.7570838620079,
            87: 323.0942740075927,
            88: 328.80101239182966,
            89: 383.08811049353574,
            90: 429.03899642975426,
            91: 416.2606646489523,
            92: 363.3798738163211,
            93: 319.26978866741325,
            94: 279.56076931078445,
            95: 316.21891787840906,
            96: 325.60512827938567,
            97: 311.8228285012022,
            98: 358.98052225296726,
            99: 357.8603500196038,
            100: 367.8261792549857,
            101: 428.88428839472675,
            102: 481.90455222556807,
            103: 475.897728867354,
            104: 407.3095369710851,
            105: 361.85765184901516,
            106: 315.7242561171219,
            107: 350.4436754119979,
            108: 359.24780050855145,
            109: 334.71630228451676,
            110: 376.23352931582696,
            111: 371.4556763539132,
            112: 372.13536526129235,
            113: 432.12556467495455,
            114: 500.6906354283254,
            115: 501.9613198306942,
            116: 432.61776135728996,
            117: 368.2419101895465,
            118: 324.1673780673565,
            119: 355.22203080011343,
            120: 361.1967314947233,
            121: 349.085311365696,
            122: 396.43876991565884,
            123: 421.51978960552145,
            124: 423.67495105083395,
            125: 491.08927335180056,
            126: 552.6305583723815,
            127: 557.649437993526,
            128: 472.3560285569485,
            129: 422.2369024032784,
            130: 363.8414542836664,
            131: 409.3896679325525,
            132: 430.4731794527358,
            133: 401.6021968533767,
            134: 444.9129715083068,
            135: 451.15504092826615,
            136: 487.73846006608915,
            137: 544.2615888824504,
            138: 631.6500051352749,
            139: 630.0471054911233,
            140: 508.9534629639894,
            141: 466.3653301848691,
            142: 406.09662939640555,
            143: 441.6050984023942,
            144: 461.02285042587664,
            145: 435.26392717614794,
            146: 483.269418266692,
            147: 505.872846000263,
            148: 526.7902172547091,
            149: 592.1820551028202,
            150: 683.8825654720979,
            151: 682.2076633555141,
            152: 565.8872473357519,
            153: 512.8301253969911,
            154: 445.9596765951874,
            155: 487.7389101996968,
            156: 505.40631420734263,
            157: 475.7775419981199,
            158: 523.1475036007025,
        },
    }
)

PEYTON_FCST_30_THETA_SM_11 = pd.DataFrame(
    {
        "time": {
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
            379: pd.Timestamp("2013-05-16 00:00:00"),
            380: pd.Timestamp("2013-05-17 00:00:00"),
            381: pd.Timestamp("2013-05-18 00:00:00"),
            382: pd.Timestamp("2013-05-19 00:00:00"),
            383: pd.Timestamp("2013-05-20 00:00:00"),
            384: pd.Timestamp("2013-05-21 00:00:00"),
            385: pd.Timestamp("2013-05-22 00:00:00"),
            386: pd.Timestamp("2013-05-23 00:00:00"),
            387: pd.Timestamp("2013-05-24 00:00:00"),
            388: pd.Timestamp("2013-05-25 00:00:00"),
            389: pd.Timestamp("2013-05-26 00:00:00"),
            390: pd.Timestamp("2013-05-27 00:00:00"),
            391: pd.Timestamp("2013-05-28 00:00:00"),
            392: pd.Timestamp("2013-05-29 00:00:00"),
            393: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            364: 7.990746152944167,
            365: 7.990926126046517,
            366: 7.991106099148868,
            367: 7.991286072251218,
            368: 7.991466045353568,
            369: 7.991646018455919,
            370: 7.991825991558269,
            371: 7.992005964660619,
            372: 7.99218593776297,
            373: 7.99236591086532,
            374: 7.9925458839676695,
            375: 7.99272585707002,
            376: 7.99290583017237,
            377: 7.99308580327472,
            378: 7.99326577637707,
            379: 7.993445749479421,
            380: 7.993625722581771,
            381: 7.993805695684121,
            382: 7.993985668786472,
            383: 7.994165641888822,
            384: 7.994345614991172,
            385: 7.994525588093523,
            386: 7.994705561195873,
            387: 7.994885534298223,
            388: 7.995065507400573,
            389: 7.995245480502923,
            390: 7.995425453605273,
            391: 7.995605426707624,
            392: 7.995785399809974,
            393: 7.995965372912324,
        },
        "fcst_lower": {
            364: 7.0419752895941565,
            365: 7.0170579491646325,
            366: 6.992771335282274,
            367: 6.9690701579034275,
            368: 6.9459143008917215,
            369: 6.923268030500096,
            370: 6.9010993530507765,
            371: 6.879379488815659,
            372: 6.858082437392524,
            373: 6.837184615849763,
            374: 6.816664555280485,
            375: 6.796502644639974,
            376: 6.776680913161631,
            377: 6.757182844479369,
            378: 6.737993216985914,
            379: 6.719097966038125,
            380: 6.7004840644626515,
            381: 6.682139418476238,
            382: 6.664052776657809,
            383: 6.646213650025969,
            384: 6.628612241609547,
            385: 6.611239384168365,
            386: 6.5940864849403065,
            387: 6.577145476469456,
            388: 6.560408772716754,
            389: 6.543869229775718,
            390: 6.527520110616059,
            391: 6.511355053361671,
            392: 6.495368042679324,
            393: 6.479553383913212,
        },
        "fcst_upper": {
            364: 8.939517016294179,
            365: 8.964794302928402,
            366: 8.989440863015462,
            367: 9.013501986599008,
            368: 9.037017789815415,
            369: 9.06002400641174,
            370: 9.082552630065761,
            371: 9.10463244050558,
            372: 9.126289438133416,
            373: 9.147547205880876,
            374: 9.168427212654855,
            375: 9.188949069500067,
            376: 9.20913074718311,
            377: 9.22898876207007,
            378: 9.248538335768227,
            379: 9.267793532920718,
            380: 9.28676738070089,
            381: 9.305471972892004,
            382: 9.323918560915134,
            383: 9.342117633751673,
            384: 9.360078988372797,
            385: 9.377811792018681,
            386: 9.395324637451438,
            387: 9.41262559212699,
            388: 9.429722242084392,
            389: 9.44662173123013,
            390: 9.463330796594487,
            391: 9.479855800053578,
            392: 9.496202756940624,
            393: 9.512377361911437,
        },
    }
)

PEYTON_FCST_30_THETA_INCL_HIST_SM_11 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2012-05-02 00:00:00"),
            1: pd.Timestamp("2012-05-03 00:00:00"),
            2: pd.Timestamp("2012-05-04 00:00:00"),
            3: pd.Timestamp("2012-05-05 00:00:00"),
            4: pd.Timestamp("2012-05-06 00:00:00"),
            5: pd.Timestamp("2012-05-07 00:00:00"),
            6: pd.Timestamp("2012-05-08 00:00:00"),
            7: pd.Timestamp("2012-05-09 00:00:00"),
            8: pd.Timestamp("2012-05-10 00:00:00"),
            9: pd.Timestamp("2012-05-11 00:00:00"),
            10: pd.Timestamp("2012-05-12 00:00:00"),
            11: pd.Timestamp("2012-05-13 00:00:00"),
            12: pd.Timestamp("2012-05-14 00:00:00"),
            13: pd.Timestamp("2012-05-15 00:00:00"),
            14: pd.Timestamp("2012-05-16 00:00:00"),
            15: pd.Timestamp("2012-05-17 00:00:00"),
            16: pd.Timestamp("2012-05-18 00:00:00"),
            17: pd.Timestamp("2012-05-19 00:00:00"),
            18: pd.Timestamp("2012-05-20 00:00:00"),
            19: pd.Timestamp("2012-05-21 00:00:00"),
            20: pd.Timestamp("2012-05-22 00:00:00"),
            21: pd.Timestamp("2012-05-23 00:00:00"),
            22: pd.Timestamp("2012-05-24 00:00:00"),
            23: pd.Timestamp("2012-05-25 00:00:00"),
            24: pd.Timestamp("2012-05-26 00:00:00"),
            25: pd.Timestamp("2012-05-27 00:00:00"),
            26: pd.Timestamp("2012-05-28 00:00:00"),
            27: pd.Timestamp("2012-05-29 00:00:00"),
            28: pd.Timestamp("2012-05-30 00:00:00"),
            29: pd.Timestamp("2012-05-31 00:00:00"),
            30: pd.Timestamp("2012-06-01 00:00:00"),
            31: pd.Timestamp("2012-06-02 00:00:00"),
            32: pd.Timestamp("2012-06-03 00:00:00"),
            33: pd.Timestamp("2012-06-04 00:00:00"),
            34: pd.Timestamp("2012-06-05 00:00:00"),
            35: pd.Timestamp("2012-06-06 00:00:00"),
            36: pd.Timestamp("2012-06-07 00:00:00"),
            37: pd.Timestamp("2012-06-08 00:00:00"),
            38: pd.Timestamp("2012-06-09 00:00:00"),
            39: pd.Timestamp("2012-06-10 00:00:00"),
            40: pd.Timestamp("2012-06-11 00:00:00"),
            41: pd.Timestamp("2012-06-12 00:00:00"),
            42: pd.Timestamp("2012-06-13 00:00:00"),
            43: pd.Timestamp("2012-06-14 00:00:00"),
            44: pd.Timestamp("2012-06-15 00:00:00"),
            45: pd.Timestamp("2012-06-16 00:00:00"),
            46: pd.Timestamp("2012-06-17 00:00:00"),
            47: pd.Timestamp("2012-06-18 00:00:00"),
            48: pd.Timestamp("2012-06-19 00:00:00"),
            49: pd.Timestamp("2012-06-20 00:00:00"),
            50: pd.Timestamp("2012-06-21 00:00:00"),
            51: pd.Timestamp("2012-06-22 00:00:00"),
            52: pd.Timestamp("2012-06-23 00:00:00"),
            53: pd.Timestamp("2012-06-24 00:00:00"),
            54: pd.Timestamp("2012-06-25 00:00:00"),
            55: pd.Timestamp("2012-06-26 00:00:00"),
            56: pd.Timestamp("2012-06-27 00:00:00"),
            57: pd.Timestamp("2012-06-28 00:00:00"),
            58: pd.Timestamp("2012-06-29 00:00:00"),
            59: pd.Timestamp("2012-06-30 00:00:00"),
            60: pd.Timestamp("2012-07-01 00:00:00"),
            61: pd.Timestamp("2012-07-02 00:00:00"),
            62: pd.Timestamp("2012-07-03 00:00:00"),
            63: pd.Timestamp("2012-07-04 00:00:00"),
            64: pd.Timestamp("2012-07-05 00:00:00"),
            65: pd.Timestamp("2012-07-06 00:00:00"),
            66: pd.Timestamp("2012-07-07 00:00:00"),
            67: pd.Timestamp("2012-07-08 00:00:00"),
            68: pd.Timestamp("2012-07-09 00:00:00"),
            69: pd.Timestamp("2012-07-10 00:00:00"),
            70: pd.Timestamp("2012-07-11 00:00:00"),
            71: pd.Timestamp("2012-07-12 00:00:00"),
            72: pd.Timestamp("2012-07-13 00:00:00"),
            73: pd.Timestamp("2012-07-14 00:00:00"),
            74: pd.Timestamp("2012-07-15 00:00:00"),
            75: pd.Timestamp("2012-07-16 00:00:00"),
            76: pd.Timestamp("2012-07-17 00:00:00"),
            77: pd.Timestamp("2012-07-18 00:00:00"),
            78: pd.Timestamp("2012-07-19 00:00:00"),
            79: pd.Timestamp("2012-07-20 00:00:00"),
            80: pd.Timestamp("2012-07-21 00:00:00"),
            81: pd.Timestamp("2012-07-22 00:00:00"),
            82: pd.Timestamp("2012-07-23 00:00:00"),
            83: pd.Timestamp("2012-07-24 00:00:00"),
            84: pd.Timestamp("2012-07-25 00:00:00"),
            85: pd.Timestamp("2012-07-26 00:00:00"),
            86: pd.Timestamp("2012-07-27 00:00:00"),
            87: pd.Timestamp("2012-07-28 00:00:00"),
            88: pd.Timestamp("2012-07-29 00:00:00"),
            89: pd.Timestamp("2012-07-30 00:00:00"),
            90: pd.Timestamp("2012-07-31 00:00:00"),
            91: pd.Timestamp("2012-08-01 00:00:00"),
            92: pd.Timestamp("2012-08-02 00:00:00"),
            93: pd.Timestamp("2012-08-03 00:00:00"),
            94: pd.Timestamp("2012-08-04 00:00:00"),
            95: pd.Timestamp("2012-08-05 00:00:00"),
            96: pd.Timestamp("2012-08-06 00:00:00"),
            97: pd.Timestamp("2012-08-07 00:00:00"),
            98: pd.Timestamp("2012-08-08 00:00:00"),
            99: pd.Timestamp("2012-08-09 00:00:00"),
            100: pd.Timestamp("2012-08-10 00:00:00"),
            101: pd.Timestamp("2012-08-11 00:00:00"),
            102: pd.Timestamp("2012-08-12 00:00:00"),
            103: pd.Timestamp("2012-08-13 00:00:00"),
            104: pd.Timestamp("2012-08-14 00:00:00"),
            105: pd.Timestamp("2012-08-15 00:00:00"),
            106: pd.Timestamp("2012-08-16 00:00:00"),
            107: pd.Timestamp("2012-08-17 00:00:00"),
            108: pd.Timestamp("2012-08-18 00:00:00"),
            109: pd.Timestamp("2012-08-19 00:00:00"),
            110: pd.Timestamp("2012-08-20 00:00:00"),
            111: pd.Timestamp("2012-08-21 00:00:00"),
            112: pd.Timestamp("2012-08-22 00:00:00"),
            113: pd.Timestamp("2012-08-23 00:00:00"),
            114: pd.Timestamp("2012-08-24 00:00:00"),
            115: pd.Timestamp("2012-08-25 00:00:00"),
            116: pd.Timestamp("2012-08-26 00:00:00"),
            117: pd.Timestamp("2012-08-27 00:00:00"),
            118: pd.Timestamp("2012-08-28 00:00:00"),
            119: pd.Timestamp("2012-08-29 00:00:00"),
            120: pd.Timestamp("2012-08-30 00:00:00"),
            121: pd.Timestamp("2012-08-31 00:00:00"),
            122: pd.Timestamp("2012-09-01 00:00:00"),
            123: pd.Timestamp("2012-09-02 00:00:00"),
            124: pd.Timestamp("2012-09-03 00:00:00"),
            125: pd.Timestamp("2012-09-04 00:00:00"),
            126: pd.Timestamp("2012-09-05 00:00:00"),
            127: pd.Timestamp("2012-09-06 00:00:00"),
            128: pd.Timestamp("2012-09-07 00:00:00"),
            129: pd.Timestamp("2012-09-08 00:00:00"),
            130: pd.Timestamp("2012-09-09 00:00:00"),
            131: pd.Timestamp("2012-09-10 00:00:00"),
            132: pd.Timestamp("2012-09-11 00:00:00"),
            133: pd.Timestamp("2012-09-12 00:00:00"),
            134: pd.Timestamp("2012-09-13 00:00:00"),
            135: pd.Timestamp("2012-09-14 00:00:00"),
            136: pd.Timestamp("2012-09-15 00:00:00"),
            137: pd.Timestamp("2012-09-16 00:00:00"),
            138: pd.Timestamp("2012-09-17 00:00:00"),
            139: pd.Timestamp("2012-09-18 00:00:00"),
            140: pd.Timestamp("2012-09-19 00:00:00"),
            141: pd.Timestamp("2012-09-20 00:00:00"),
            142: pd.Timestamp("2012-09-21 00:00:00"),
            143: pd.Timestamp("2012-09-22 00:00:00"),
            144: pd.Timestamp("2012-09-23 00:00:00"),
            145: pd.Timestamp("2012-09-24 00:00:00"),
            146: pd.Timestamp("2012-09-25 00:00:00"),
            147: pd.Timestamp("2012-09-26 00:00:00"),
            148: pd.Timestamp("2012-09-27 00:00:00"),
            149: pd.Timestamp("2012-09-28 00:00:00"),
            150: pd.Timestamp("2012-09-29 00:00:00"),
            151: pd.Timestamp("2012-09-30 00:00:00"),
            152: pd.Timestamp("2012-10-01 00:00:00"),
            153: pd.Timestamp("2012-10-02 00:00:00"),
            154: pd.Timestamp("2012-10-03 00:00:00"),
            155: pd.Timestamp("2012-10-04 00:00:00"),
            156: pd.Timestamp("2012-10-05 00:00:00"),
            157: pd.Timestamp("2012-10-06 00:00:00"),
            158: pd.Timestamp("2012-10-07 00:00:00"),
            159: pd.Timestamp("2012-10-08 00:00:00"),
            160: pd.Timestamp("2012-10-09 00:00:00"),
            161: pd.Timestamp("2012-10-10 00:00:00"),
            162: pd.Timestamp("2012-10-11 00:00:00"),
            163: pd.Timestamp("2012-10-12 00:00:00"),
            164: pd.Timestamp("2012-10-13 00:00:00"),
            165: pd.Timestamp("2012-10-14 00:00:00"),
            166: pd.Timestamp("2012-10-15 00:00:00"),
            167: pd.Timestamp("2012-10-16 00:00:00"),
            168: pd.Timestamp("2012-10-17 00:00:00"),
            169: pd.Timestamp("2012-10-18 00:00:00"),
            170: pd.Timestamp("2012-10-19 00:00:00"),
            171: pd.Timestamp("2012-10-20 00:00:00"),
            172: pd.Timestamp("2012-10-21 00:00:00"),
            173: pd.Timestamp("2012-10-22 00:00:00"),
            174: pd.Timestamp("2012-10-23 00:00:00"),
            175: pd.Timestamp("2012-10-24 00:00:00"),
            176: pd.Timestamp("2012-10-25 00:00:00"),
            177: pd.Timestamp("2012-10-26 00:00:00"),
            178: pd.Timestamp("2012-10-27 00:00:00"),
            179: pd.Timestamp("2012-10-28 00:00:00"),
            180: pd.Timestamp("2012-10-29 00:00:00"),
            181: pd.Timestamp("2012-10-30 00:00:00"),
            182: pd.Timestamp("2012-10-31 00:00:00"),
            183: pd.Timestamp("2012-11-01 00:00:00"),
            184: pd.Timestamp("2012-11-02 00:00:00"),
            185: pd.Timestamp("2012-11-03 00:00:00"),
            186: pd.Timestamp("2012-11-04 00:00:00"),
            187: pd.Timestamp("2012-11-05 00:00:00"),
            188: pd.Timestamp("2012-11-06 00:00:00"),
            189: pd.Timestamp("2012-11-07 00:00:00"),
            190: pd.Timestamp("2012-11-08 00:00:00"),
            191: pd.Timestamp("2012-11-09 00:00:00"),
            192: pd.Timestamp("2012-11-10 00:00:00"),
            193: pd.Timestamp("2012-11-11 00:00:00"),
            194: pd.Timestamp("2012-11-12 00:00:00"),
            195: pd.Timestamp("2012-11-13 00:00:00"),
            196: pd.Timestamp("2012-11-14 00:00:00"),
            197: pd.Timestamp("2012-11-15 00:00:00"),
            198: pd.Timestamp("2012-11-16 00:00:00"),
            199: pd.Timestamp("2012-11-17 00:00:00"),
            200: pd.Timestamp("2012-11-18 00:00:00"),
            201: pd.Timestamp("2012-11-19 00:00:00"),
            202: pd.Timestamp("2012-11-20 00:00:00"),
            203: pd.Timestamp("2012-11-21 00:00:00"),
            204: pd.Timestamp("2012-11-22 00:00:00"),
            205: pd.Timestamp("2012-11-23 00:00:00"),
            206: pd.Timestamp("2012-11-24 00:00:00"),
            207: pd.Timestamp("2012-11-25 00:00:00"),
            208: pd.Timestamp("2012-11-26 00:00:00"),
            209: pd.Timestamp("2012-11-27 00:00:00"),
            210: pd.Timestamp("2012-11-28 00:00:00"),
            211: pd.Timestamp("2012-11-29 00:00:00"),
            212: pd.Timestamp("2012-11-30 00:00:00"),
            213: pd.Timestamp("2012-12-01 00:00:00"),
            214: pd.Timestamp("2012-12-02 00:00:00"),
            215: pd.Timestamp("2012-12-03 00:00:00"),
            216: pd.Timestamp("2012-12-04 00:00:00"),
            217: pd.Timestamp("2012-12-05 00:00:00"),
            218: pd.Timestamp("2012-12-06 00:00:00"),
            219: pd.Timestamp("2012-12-07 00:00:00"),
            220: pd.Timestamp("2012-12-08 00:00:00"),
            221: pd.Timestamp("2012-12-09 00:00:00"),
            222: pd.Timestamp("2012-12-10 00:00:00"),
            223: pd.Timestamp("2012-12-11 00:00:00"),
            224: pd.Timestamp("2012-12-12 00:00:00"),
            225: pd.Timestamp("2012-12-13 00:00:00"),
            226: pd.Timestamp("2012-12-14 00:00:00"),
            227: pd.Timestamp("2012-12-15 00:00:00"),
            228: pd.Timestamp("2012-12-16 00:00:00"),
            229: pd.Timestamp("2012-12-17 00:00:00"),
            230: pd.Timestamp("2012-12-18 00:00:00"),
            231: pd.Timestamp("2012-12-19 00:00:00"),
            232: pd.Timestamp("2012-12-20 00:00:00"),
            233: pd.Timestamp("2012-12-21 00:00:00"),
            234: pd.Timestamp("2012-12-22 00:00:00"),
            235: pd.Timestamp("2012-12-23 00:00:00"),
            236: pd.Timestamp("2012-12-24 00:00:00"),
            237: pd.Timestamp("2012-12-25 00:00:00"),
            238: pd.Timestamp("2012-12-26 00:00:00"),
            239: pd.Timestamp("2012-12-27 00:00:00"),
            240: pd.Timestamp("2012-12-28 00:00:00"),
            241: pd.Timestamp("2012-12-29 00:00:00"),
            242: pd.Timestamp("2012-12-30 00:00:00"),
            243: pd.Timestamp("2012-12-31 00:00:00"),
            244: pd.Timestamp("2013-01-01 00:00:00"),
            245: pd.Timestamp("2013-01-02 00:00:00"),
            246: pd.Timestamp("2013-01-03 00:00:00"),
            247: pd.Timestamp("2013-01-04 00:00:00"),
            248: pd.Timestamp("2013-01-05 00:00:00"),
            249: pd.Timestamp("2013-01-06 00:00:00"),
            250: pd.Timestamp("2013-01-07 00:00:00"),
            251: pd.Timestamp("2013-01-08 00:00:00"),
            252: pd.Timestamp("2013-01-09 00:00:00"),
            253: pd.Timestamp("2013-01-10 00:00:00"),
            254: pd.Timestamp("2013-01-11 00:00:00"),
            255: pd.Timestamp("2013-01-12 00:00:00"),
            256: pd.Timestamp("2013-01-13 00:00:00"),
            257: pd.Timestamp("2013-01-14 00:00:00"),
            258: pd.Timestamp("2013-01-15 00:00:00"),
            259: pd.Timestamp("2013-01-16 00:00:00"),
            260: pd.Timestamp("2013-01-17 00:00:00"),
            261: pd.Timestamp("2013-01-18 00:00:00"),
            262: pd.Timestamp("2013-01-19 00:00:00"),
            263: pd.Timestamp("2013-01-20 00:00:00"),
            264: pd.Timestamp("2013-01-21 00:00:00"),
            265: pd.Timestamp("2013-01-22 00:00:00"),
            266: pd.Timestamp("2013-01-23 00:00:00"),
            267: pd.Timestamp("2013-01-24 00:00:00"),
            268: pd.Timestamp("2013-01-25 00:00:00"),
            269: pd.Timestamp("2013-01-26 00:00:00"),
            270: pd.Timestamp("2013-01-27 00:00:00"),
            271: pd.Timestamp("2013-01-28 00:00:00"),
            272: pd.Timestamp("2013-01-29 00:00:00"),
            273: pd.Timestamp("2013-01-30 00:00:00"),
            274: pd.Timestamp("2013-01-31 00:00:00"),
            275: pd.Timestamp("2013-02-01 00:00:00"),
            276: pd.Timestamp("2013-02-02 00:00:00"),
            277: pd.Timestamp("2013-02-03 00:00:00"),
            278: pd.Timestamp("2013-02-04 00:00:00"),
            279: pd.Timestamp("2013-02-05 00:00:00"),
            280: pd.Timestamp("2013-02-06 00:00:00"),
            281: pd.Timestamp("2013-02-07 00:00:00"),
            282: pd.Timestamp("2013-02-08 00:00:00"),
            283: pd.Timestamp("2013-02-09 00:00:00"),
            284: pd.Timestamp("2013-02-10 00:00:00"),
            285: pd.Timestamp("2013-02-11 00:00:00"),
            286: pd.Timestamp("2013-02-12 00:00:00"),
            287: pd.Timestamp("2013-02-13 00:00:00"),
            288: pd.Timestamp("2013-02-14 00:00:00"),
            289: pd.Timestamp("2013-02-15 00:00:00"),
            290: pd.Timestamp("2013-02-16 00:00:00"),
            291: pd.Timestamp("2013-02-17 00:00:00"),
            292: pd.Timestamp("2013-02-18 00:00:00"),
            293: pd.Timestamp("2013-02-19 00:00:00"),
            294: pd.Timestamp("2013-02-20 00:00:00"),
            295: pd.Timestamp("2013-02-21 00:00:00"),
            296: pd.Timestamp("2013-02-22 00:00:00"),
            297: pd.Timestamp("2013-02-23 00:00:00"),
            298: pd.Timestamp("2013-02-24 00:00:00"),
            299: pd.Timestamp("2013-02-25 00:00:00"),
            300: pd.Timestamp("2013-02-26 00:00:00"),
            301: pd.Timestamp("2013-02-27 00:00:00"),
            302: pd.Timestamp("2013-02-28 00:00:00"),
            303: pd.Timestamp("2013-03-01 00:00:00"),
            304: pd.Timestamp("2013-03-02 00:00:00"),
            305: pd.Timestamp("2013-03-03 00:00:00"),
            306: pd.Timestamp("2013-03-04 00:00:00"),
            307: pd.Timestamp("2013-03-05 00:00:00"),
            308: pd.Timestamp("2013-03-06 00:00:00"),
            309: pd.Timestamp("2013-03-07 00:00:00"),
            310: pd.Timestamp("2013-03-08 00:00:00"),
            311: pd.Timestamp("2013-03-09 00:00:00"),
            312: pd.Timestamp("2013-03-10 00:00:00"),
            313: pd.Timestamp("2013-03-11 00:00:00"),
            314: pd.Timestamp("2013-03-12 00:00:00"),
            315: pd.Timestamp("2013-03-13 00:00:00"),
            316: pd.Timestamp("2013-03-14 00:00:00"),
            317: pd.Timestamp("2013-03-15 00:00:00"),
            318: pd.Timestamp("2013-03-16 00:00:00"),
            319: pd.Timestamp("2013-03-17 00:00:00"),
            320: pd.Timestamp("2013-03-18 00:00:00"),
            321: pd.Timestamp("2013-03-19 00:00:00"),
            322: pd.Timestamp("2013-03-20 00:00:00"),
            323: pd.Timestamp("2013-03-21 00:00:00"),
            324: pd.Timestamp("2013-03-22 00:00:00"),
            325: pd.Timestamp("2013-03-23 00:00:00"),
            326: pd.Timestamp("2013-03-24 00:00:00"),
            327: pd.Timestamp("2013-03-25 00:00:00"),
            328: pd.Timestamp("2013-03-26 00:00:00"),
            329: pd.Timestamp("2013-03-27 00:00:00"),
            330: pd.Timestamp("2013-03-28 00:00:00"),
            331: pd.Timestamp("2013-03-29 00:00:00"),
            332: pd.Timestamp("2013-03-30 00:00:00"),
            333: pd.Timestamp("2013-03-31 00:00:00"),
            334: pd.Timestamp("2013-04-01 00:00:00"),
            335: pd.Timestamp("2013-04-02 00:00:00"),
            336: pd.Timestamp("2013-04-03 00:00:00"),
            337: pd.Timestamp("2013-04-04 00:00:00"),
            338: pd.Timestamp("2013-04-05 00:00:00"),
            339: pd.Timestamp("2013-04-06 00:00:00"),
            340: pd.Timestamp("2013-04-07 00:00:00"),
            341: pd.Timestamp("2013-04-08 00:00:00"),
            342: pd.Timestamp("2013-04-09 00:00:00"),
            343: pd.Timestamp("2013-04-10 00:00:00"),
            344: pd.Timestamp("2013-04-11 00:00:00"),
            345: pd.Timestamp("2013-04-12 00:00:00"),
            346: pd.Timestamp("2013-04-13 00:00:00"),
            347: pd.Timestamp("2013-04-14 00:00:00"),
            348: pd.Timestamp("2013-04-15 00:00:00"),
            349: pd.Timestamp("2013-04-16 00:00:00"),
            350: pd.Timestamp("2013-04-17 00:00:00"),
            351: pd.Timestamp("2013-04-18 00:00:00"),
            352: pd.Timestamp("2013-04-19 00:00:00"),
            353: pd.Timestamp("2013-04-20 00:00:00"),
            354: pd.Timestamp("2013-04-21 00:00:00"),
            355: pd.Timestamp("2013-04-22 00:00:00"),
            356: pd.Timestamp("2013-04-23 00:00:00"),
            357: pd.Timestamp("2013-04-24 00:00:00"),
            358: pd.Timestamp("2013-04-25 00:00:00"),
            359: pd.Timestamp("2013-04-26 00:00:00"),
            360: pd.Timestamp("2013-04-27 00:00:00"),
            361: pd.Timestamp("2013-04-28 00:00:00"),
            362: pd.Timestamp("2013-04-29 00:00:00"),
            363: pd.Timestamp("2013-04-30 00:00:00"),
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
            379: pd.Timestamp("2013-05-16 00:00:00"),
            380: pd.Timestamp("2013-05-17 00:00:00"),
            381: pd.Timestamp("2013-05-18 00:00:00"),
            382: pd.Timestamp("2013-05-19 00:00:00"),
            383: pd.Timestamp("2013-05-20 00:00:00"),
            384: pd.Timestamp("2013-05-21 00:00:00"),
            385: pd.Timestamp("2013-05-22 00:00:00"),
            386: pd.Timestamp("2013-05-23 00:00:00"),
            387: pd.Timestamp("2013-05-24 00:00:00"),
            388: pd.Timestamp("2013-05-25 00:00:00"),
            389: pd.Timestamp("2013-05-26 00:00:00"),
            390: pd.Timestamp("2013-05-27 00:00:00"),
            391: pd.Timestamp("2013-05-28 00:00:00"),
            392: pd.Timestamp("2013-05-29 00:00:00"),
            393: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.242571417557185,
            1: 8.234239278782947,
            2: 8.22375750408101,
            3: 8.179067615331503,
            4: 8.150305651688152,
            5: 8.38295276953232,
            6: 8.487224117294007,
            7: 8.45538843113504,
            8: 8.392415227356707,
            9: 8.291483823840537,
            10: 8.193760528476679,
            11: 8.081596890911428,
            12: 8.020852971080988,
            13: 7.97722359892113,
            14: 7.956295757956348,
            15: 7.9751815045445404,
            16: 7.969956781157352,
            17: 7.923125982239018,
            18: 7.820106703279734,
            19: 7.755029248736911,
            20: 7.811283316861521,
            21: 7.926674757627894,
            22: 7.9503151207097,
            23: 7.913263262073231,
            24: 7.878182729206154,
            25: 7.7851760417752605,
            26: 7.751481086125767,
            27: 7.729343177935746,
            28: 7.750248450707828,
            29: 7.764914072691624,
            30: 7.817161047280631,
            31: 7.816147370260684,
            32: 7.779475363859275,
            33: 7.7597764758005265,
            34: 7.778696018788342,
            35: 7.81452301503347,
            36: 7.776690888285868,
            37: 7.764390239309742,
            38: 7.791168150164171,
            39: 7.825844283319341,
            40: 7.810312603863451,
            41: 7.769345578460492,
            42: 7.78768201101209,
            43: 7.813060689993387,
            44: 7.792032054946288,
            45: 7.773605253647215,
            46: 7.719417247937204,
            47: 7.763933652030582,
            48: 7.772606103862633,
            49: 7.918173263360487,
            50: 7.979126713804241,
            51: 7.952212962159344,
            52: 7.945697652149873,
            53: 7.8579793075348885,
            54: 7.7795312526393765,
            55: 7.749249531392487,
            56: 7.754203208703749,
            57: 7.720784405677069,
            58: 7.690935355327168,
            59: 7.655764521917211,
            60: 7.583898695466271,
            61: 7.555991469343105,
            62: 7.546454487264252,
            63: 7.568697179469606,
            64: 7.593542951263316,
            65: 7.585312640381407,
            66: 7.609298971932021,
            67: 7.608624862805518,
            68: 7.6025135597126905,
            69: 7.634800968499936,
            70: 7.668971853566081,
            71: 7.74708798344245,
            72: 7.956373467608982,
            73: 8.059912919765814,
            74: 8.135186747261535,
            75: 8.110400029773215,
            76: 8.075086952867641,
            77: 8.056615672525307,
            78: 8.041717614593388,
            79: 8.017228449851693,
            80: 8.01042981674295,
            81: 7.957922047778185,
            82: 7.923379938768765,
            83: 7.953448597786916,
            84: 7.958648633358569,
            85: 7.996554795577973,
            86: 8.126977204919186,
            87: 8.312307324749012,
            88: 8.306162164179945,
            89: 8.301030869464084,
            90: 8.269159001884539,
            91: 8.186988605161455,
            92: 8.112305325485881,
            93: 8.103009522857583,
            94: 8.097737171237036,
            95: 8.103096748986069,
            96: 8.10541904443794,
            97: 8.114441600089917,
            98: 8.102910382006385,
            99: 8.066314415497356,
            100: 8.106860599409371,
            101: 8.315351917321857,
            102: 8.395687074880163,
            103: 8.489427370845846,
            104: 8.462759845669668,
            105: 8.486217424591713,
            106: 8.462631761635636,
            107: 8.384812477108156,
            108: 8.386180811778562,
            109: 8.374375441948855,
            110: 8.502518404348445,
            111: 8.619546131728269,
            112: 8.563659015019374,
            113: 8.480227199241511,
            114: 8.45834552120787,
            115: 8.42426641192495,
            116: 8.497704310168864,
            117: 8.716556022645722,
            118: 8.815962604907352,
            119: 8.763533663530087,
            120: 8.694379647047954,
            121: 8.618329000616999,
            122: 8.606077245244334,
            123: 8.575128548030209,
            124: 8.66573774897471,
            125: 8.64127077697597,
            126: 8.601397713868867,
            127: 8.6343793574515,
            128: 8.953756911286805,
            129: 8.89295557845208,
            130: 8.867021234530952,
            131: 9.092060856919636,
            132: 9.676174931495058,
            133: 9.665173003192745,
            134: 9.460911628167318,
            135: 9.28038314712149,
            136: 9.21569302394338,
            137: 9.107001930822891,
            138: 9.269128533927326,
            139: 9.348666927839869,
            140: 9.636554809800177,
            141: 9.432549090581762,
            142: 9.230677836832788,
            143: 9.271076686097414,
            144: 9.082846196563587,
            145: 9.190910898220467,
            146: 9.287020789942918,
            147: 9.145846977862512,
            148: 8.920151750492547,
            149: 8.76301175947841,
            150: 8.704658253494454,
            151: 8.616435032823066,
            152: 8.765258276834835,
            153: 9.016327371774025,
            154: 8.973921804848587,
            155: 8.863688375122955,
            156: 8.810529503947098,
            157: 8.864185173798836,
            158: 8.79145390872496,
            159: 9.02914832246739,
            160: 9.231256869785462,
            161: 9.158352582604028,
            162: 8.967045538855267,
            163: 8.79794761875984,
            164: 8.706224763122679,
            165: 8.598675590485698,
            166: 8.699842169228054,
            167: 8.793436484228145,
            168: 9.265451221029625,
            169: 9.152775655421863,
            170: 8.997036537420586,
            171: 8.87950760754705,
            172: 8.733903328776158,
            173: 8.921334988530354,
            174: 8.96204588311403,
            175: 8.89429033298491,
            176: 8.768098412124004,
            177: 8.669143011802932,
            178: 8.62876476004886,
            179: 8.606653634884793,
            180: 8.748612379381061,
            181: 9.141209191861584,
            182: 9.080029211200436,
            183: 8.987842348337411,
            184: 8.87448034493511,
            185: 8.803627638269255,
            186: 8.72377143154655,
            187: 8.954003964039295,
            188: 9.123714286001752,
            189: 9.055735727167914,
            190: 8.901135951798132,
            191: 8.80789598550989,
            192: 8.816999644455276,
            193: 8.692893151743556,
            194: 8.825333415693205,
            195: 8.891642987264499,
            196: 8.848851829889632,
            197: 8.72914675739318,
            198: 8.645208144309274,
            199: 8.55993576623425,
            200: 8.46027137610438,
            201: 8.626713143235758,
            202: 8.871869197057492,
            203: 8.821707838800803,
            204: 8.699656590497348,
            205: 8.688680331875823,
            206: 8.744482856453757,
            207: 8.663783342307646,
            208: 8.849873913978168,
            209: 9.090643273864462,
            210: 9.034748955882502,
            211: 8.937408387539623,
            212: 8.831868688646425,
            213: 8.812705118421945,
            214: 8.775878520517578,
            215: 8.908403509257234,
            216: 9.086316610064896,
            217: 9.215180942972912,
            218: 9.10259661603682,
            219: 9.02766189044278,
            220: 9.243656573500314,
            221: 9.126531105329642,
            222: 9.155727131741674,
            223: 9.181315669012028,
            224: 9.238268747380685,
            225: 9.135178304509378,
            226: 9.03511947023774,
            227: 8.897205560040113,
            228: 8.756863211818654,
            229: 8.885683461684103,
            230: 8.992704977899802,
            231: 8.946117410051322,
            232: 8.84722635737958,
            233: 8.746678186644107,
            234: 8.642518399369177,
            235: 8.542973477110236,
            236: 8.708186865292893,
            237: 8.92676642464108,
            238: 8.859784719758759,
            239: 8.801435389988843,
            240: 8.83938243375718,
            241: 8.803343358412679,
            242: 8.740675877588838,
            243: 8.914203037291923,
            244: 9.198669682693414,
            245: 9.178516371909115,
            246: 9.1568657296331,
            247: 9.13330171525627,
            248: 9.18029382101872,
            249: 9.194026609354454,
            250: 9.411362113375832,
            251: 9.429852365939425,
            252: 9.356327360305448,
            253: 9.28854828453212,
            254: 9.21548373078328,
            255: 9.199276411847443,
            256: 9.510120808879446,
            257: 9.972572337947899,
            258: 10.023646046300438,
            259: 9.851462773936763,
            260: 9.618752994352198,
            261: 9.413591154450193,
            262: 9.237966338061174,
            263: 9.056565142457082,
            264: 9.035057959799117,
            265: 9.26335139093478,
            266: 9.20368674352436,
            267: 9.124328171766027,
            268: 8.99951151105108,
            269: 8.892245099612722,
            270: 8.791822481844404,
            271: 8.732232375531408,
            272: 9.049884633781257,
            273: 8.957456831976552,
            274: 8.854363488931673,
            275: 8.768960825847696,
            276: 8.724727896930611,
            277: 8.684239907509625,
            278: 8.8977044378829,
            279: 9.158979436580791,
            280: 9.092128898902075,
            281: 8.961502991254356,
            282: 8.827664377100062,
            283: 8.682537137565054,
            284: 8.546009034704676,
            285: 8.428584627601175,
            286: 8.34936211520081,
            287: 8.276943165812211,
            288: 8.20708637892648,
            289: 8.122714584095357,
            290: 8.06966196555197,
            291: 8.011308771058879,
            292: 7.967674435686673,
            293: 7.96758315470778,
            294: 7.97663994613154,
            295: 7.961517562423984,
            296: 7.936082871810453,
            297: 7.92126310170792,
            298: 7.882450061957497,
            299: 7.83625888156508,
            300: 7.838016113167503,
            301: 7.919848530631996,
            302: 7.933384148618796,
            303: 7.93106056091132,
            304: 7.917226986913393,
            305: 7.877051603631919,
            306: 7.854264404676833,
            307: 7.849846724115925,
            308: 7.847183377429854,
            309: 7.846955425015007,
            310: 7.863970575238789,
            311: 7.8394138381104215,
            312: 7.780810361252547,
            313: 7.719221793969863,
            314: 7.728178270332491,
            315: 7.745602228824728,
            316: 7.822792324850505,
            317: 7.951959616571143,
            318: 7.977974503889659,
            319: 7.948999698321135,
            320: 7.938573108213414,
            321: 7.916823378858489,
            322: 7.9104878280119255,
            323: 7.983422286519773,
            324: 8.112450309818717,
            325: 8.090879769854407,
            326: 8.030761639437083,
            327: 8.123927433971817,
            328: 8.11750970667534,
            329: 8.059356953880734,
            330: 7.99445808482662,
            331: 7.943322251421611,
            332: 7.9038308429978335,
            333: 7.872407926265351,
            334: 7.781784710460484,
            335: 7.772967835946277,
            336: 7.73208587863117,
            337: 7.7201741864608975,
            338: 7.67811059650169,
            339: 7.6253153162017115,
            340: 7.583122591090435,
            341: 7.5751194961089166,
            342: 7.5902808696410995,
            343: 7.610236802279819,
            344: 7.6003063596271065,
            345: 7.710633405902701,
            346: 7.708449362057367,
            347: 7.629704877484112,
            348: 7.568753210537693,
            349: 7.549735627843823,
            350: 7.555363898781927,
            351: 7.558496864136208,
            352: 7.577284199581566,
            353: 7.641169879748741,
            354: 7.564931894422237,
            355: 7.558317648688142,
            356: 7.587065119594724,
            357: 7.620605380290692,
            358: 7.7112279236197825,
            359: 7.773540530754289,
            360: 7.865636391044915,
            361: 7.891644183861779,
            362: 7.869227526002934,
            363: 7.969946274466815,
            364: 7.990746152944167,
            365: 7.990926126046517,
            366: 7.991106099148868,
            367: 7.991286072251218,
            368: 7.991466045353568,
            369: 7.991646018455919,
            370: 7.991825991558269,
            371: 7.992005964660619,
            372: 7.99218593776297,
            373: 7.99236591086532,
            374: 7.9925458839676695,
            375: 7.99272585707002,
            376: 7.99290583017237,
            377: 7.99308580327472,
            378: 7.99326577637707,
            379: 7.993445749479421,
            380: 7.993625722581771,
            381: 7.993805695684121,
            382: 7.993985668786472,
            383: 7.994165641888822,
            384: 7.994345614991172,
            385: 7.994525588093523,
            386: 7.994705561195873,
            387: 7.994885534298223,
            388: 7.995065507400573,
            389: 7.995245480502923,
            390: 7.995425453605273,
            391: 7.995605426707624,
            392: 7.995785399809974,
            393: 7.995965372912324,
        },
        "fcst_lower": {
            0: 7.293800554207174,
            1: 7.285468415432937,
            2: 7.274986640731,
            3: 7.230296751981492,
            4: 7.201534788338141,
            5: 7.434181906182309,
            6: 7.538453253943996,
            7: 7.506617567785029,
            8: 7.443644364006697,
            9: 7.342712960490526,
            10: 7.244989665126668,
            11: 7.132826027561417,
            12: 7.072082107730977,
            13: 7.028452735571119,
            14: 7.0075248946063375,
            15: 7.02641064119453,
            16: 7.021185917807341,
            17: 6.974355118889007,
            18: 6.871335839929723,
            19: 6.8062583853869,
            20: 6.862512453511511,
            21: 6.977903894277883,
            22: 7.001544257359689,
            23: 6.964492398723221,
            24: 6.929411865856143,
            25: 6.83640517842525,
            26: 6.802710222775756,
            27: 6.7805723145857355,
            28: 6.801477587357818,
            29: 6.816143209341614,
            30: 6.868390183930621,
            31: 6.867376506910674,
            32: 6.830704500509264,
            33: 6.811005612450516,
            34: 6.829925155438331,
            35: 6.865752151683459,
            36: 6.827920024935858,
            37: 6.815619375959732,
            38: 6.84239728681416,
            39: 6.877073419969331,
            40: 6.861541740513441,
            41: 6.820574715110482,
            42: 6.838911147662079,
            43: 6.864289826643376,
            44: 6.8432611915962775,
            45: 6.824834390297204,
            46: 6.770646384587193,
            47: 6.8151627886805715,
            48: 6.823835240512622,
            49: 6.969402400010476,
            50: 7.030355850454231,
            51: 7.003442098809333,
            52: 6.996926788799862,
            53: 6.909208444184878,
            54: 6.830760389289366,
            55: 6.8004786680424765,
            56: 6.805432345353738,
            57: 6.772013542327058,
            58: 6.7421644919771575,
            59: 6.7069936585672005,
            60: 6.63512783211626,
            61: 6.607220605993095,
            62: 6.597683623914241,
            63: 6.619926316119595,
            64: 6.644772087913306,
            65: 6.636541777031396,
            66: 6.66052810858201,
            67: 6.659853999455508,
            68: 6.65374269636268,
            69: 6.686030105149925,
            70: 6.72020099021607,
            71: 6.798317120092439,
            72: 7.007602604258971,
            73: 7.111142056415804,
            74: 7.186415883911525,
            75: 7.161629166423205,
            76: 7.126316089517631,
            77: 7.107844809175297,
            78: 7.092946751243377,
            79: 7.068457586501682,
            80: 7.06165895339294,
            81: 7.009151184428174,
            82: 6.974609075418754,
            83: 7.004677734436905,
            84: 7.009877770008559,
            85: 7.047783932227962,
            86: 7.178206341569175,
            87: 7.3635364613990015,
            88: 7.357391300829934,
            89: 7.352260006114073,
            90: 7.320388138534528,
            91: 7.238217741811444,
            92: 7.16353446213587,
            93: 7.154238659507572,
            94: 7.148966307887025,
            95: 7.154325885636058,
            96: 7.15664818108793,
            97: 7.165670736739906,
            98: 7.1541395186563745,
            99: 7.117543552147345,
            100: 7.1580897360593605,
            101: 7.366581053971847,
            102: 7.446916211530152,
            103: 7.540656507495835,
            104: 7.513988982319657,
            105: 7.537446561241702,
            106: 7.513860898285626,
            107: 7.436041613758145,
            108: 7.437409948428551,
            109: 7.425604578598844,
            110: 7.553747540998434,
            111: 7.670775268378258,
            112: 7.614888151669363,
            113: 7.531456335891501,
            114: 7.509574657857859,
            115: 7.47549554857494,
            116: 7.548933446818853,
            117: 7.767785159295712,
            118: 7.867191741557341,
            119: 7.814762800180076,
            120: 7.745608783697944,
            121: 7.669558137266988,
            122: 7.657306381894323,
            123: 7.626357684680198,
            124: 7.716966885624699,
            125: 7.6924999136259595,
            126: 7.652626850518856,
            127: 7.68560849410149,
            128: 8.004986047936793,
            129: 7.944184715102069,
            130: 7.9182503711809415,
            131: 8.143289993569624,
            132: 8.727404068145047,
            133: 8.716402139842733,
            134: 8.512140764817307,
            135: 8.331612283771479,
            136: 8.266922160593369,
            137: 8.15823106747288,
            138: 8.320357670577314,
            139: 8.399896064489857,
            140: 8.687783946450166,
            141: 8.48377822723175,
            142: 8.281906973482776,
            143: 8.322305822747403,
            144: 8.134075333213575,
            145: 8.242140034870456,
            146: 8.338249926592907,
            147: 8.1970761145125,
            148: 7.971380887142536,
            149: 7.814240896128399,
            150: 7.755887390144443,
            151: 7.667664169473055,
            152: 7.816487413484825,
            153: 8.067556508424014,
            154: 8.025150941498575,
            155: 7.914917511772944,
            156: 7.861758640597087,
            157: 7.915414310448825,
            158: 7.84268304537495,
            159: 8.08037745911738,
            160: 8.28248600643545,
            161: 8.209581719254016,
            162: 8.018274675505255,
            163: 7.84917675540983,
            164: 7.757453899772668,
            165: 7.649904727135687,
            166: 7.751071305878043,
            167: 7.844665620878135,
            168: 8.316680357679614,
            169: 8.204004792071851,
            170: 8.048265674070574,
            171: 7.930736744197039,
            172: 7.785132465426147,
            173: 7.972564125180344,
            174: 8.013275019764018,
            175: 7.9455194696349,
            176: 7.819327548773994,
            177: 7.720372148452921,
            178: 7.679993896698849,
            179: 7.657882771534783,
            180: 7.799841516031051,
            181: 8.192438328511573,
            182: 8.131258347850425,
            183: 8.0390714849874,
            184: 7.925709481585099,
            185: 7.854856774919244,
            186: 7.77500056819654,
            187: 8.005233100689283,
            188: 8.17494342265174,
            189: 8.106964863817902,
            190: 7.952365088448121,
            191: 7.85912512215988,
            192: 7.868228781105265,
            193: 7.744122288393545,
            194: 7.876562552343194,
            195: 7.942872123914488,
            196: 7.900080966539622,
            197: 7.780375894043169,
            198: 7.696437280959263,
            199: 7.61116490288424,
            200: 7.5115005127543695,
            201: 7.677942279885747,
            202: 7.923098333707482,
            203: 7.872936975450792,
            204: 7.750885727147337,
            205: 7.739909468525812,
            206: 7.795711993103747,
            207: 7.715012478957635,
            208: 7.901103050628158,
            209: 8.14187241051445,
            210: 8.085978092532491,
            211: 7.988637524189612,
            212: 7.883097825296415,
            213: 7.863934255071935,
            214: 7.827107657167567,
            215: 7.959632645907223,
            216: 8.137545746714885,
            217: 8.2664100796229,
            218: 8.153825752686808,
            219: 8.078891027092768,
            220: 8.294885710150302,
            221: 8.17776024197963,
            222: 8.206956268391663,
            223: 8.232544805662016,
            224: 8.289497884030673,
            225: 8.186407441159366,
            226: 8.086348606887729,
            227: 7.948434696690103,
            228: 7.8080923484686435,
            229: 7.936912598334092,
            230: 8.04393411454979,
            231: 7.997346546701311,
            232: 7.898455494029569,
            233: 7.797907323294097,
            234: 7.693747536019166,
            235: 7.594202613760225,
            236: 7.759416001942882,
            237: 7.97799556129107,
            238: 7.911013856408748,
            239: 7.852664526638832,
            240: 7.890611570407169,
            241: 7.854572495062668,
            242: 7.791905014238828,
            243: 7.965432173941912,
            244: 8.249898819343402,
            245: 8.229745508559104,
            246: 8.208094866283089,
            247: 8.184530851906258,
            248: 8.231522957668709,
            249: 8.245255746004442,
            250: 8.46259125002582,
            251: 8.481081502589413,
            252: 8.407556496955436,
            253: 8.339777421182108,
            254: 8.266712867433268,
            255: 8.250505548497431,
            256: 8.561349945529434,
            257: 9.023801474597887,
            258: 9.074875182950427,
            259: 8.902691910586752,
            260: 8.669982131002186,
            261: 8.464820291100182,
            262: 8.289195474711162,
            263: 8.10779427910707,
            264: 8.086287096449105,
            265: 8.314580527584768,
            266: 8.254915880174348,
            267: 8.175557308416016,
            268: 8.050740647701069,
            269: 7.943474236262712,
            270: 7.8430516184943935,
            271: 7.783461512181398,
            272: 8.101113770431246,
            273: 8.00868596862654,
            274: 7.905592625581662,
            275: 7.820189962497685,
            276: 7.7759570335806005,
            277: 7.735469044159614,
            278: 7.94893357453289,
            279: 8.21020857323078,
            280: 8.143358035552064,
            281: 8.012732127904345,
            282: 7.878893513750051,
            283: 7.733766274215044,
            284: 7.5972381713546655,
            285: 7.479813764251165,
            286: 7.400591251850799,
            287: 7.3281723024622005,
            288: 7.258315515576469,
            289: 7.1739437207453465,
            290: 7.12089110220196,
            291: 7.062537907708868,
            292: 7.018903572336662,
            293: 7.0188122913577695,
            294: 7.027869082781529,
            295: 7.012746699073973,
            296: 6.987312008460442,
            297: 6.972492238357909,
            298: 6.933679198607487,
            299: 6.88748801821507,
            300: 6.889245249817492,
            301: 6.971077667281985,
            302: 6.984613285268785,
            303: 6.982289697561309,
            304: 6.968456123563382,
            305: 6.928280740281909,
            306: 6.905493541326822,
            307: 6.901075860765914,
            308: 6.898412514079843,
            309: 6.898184561664996,
            310: 6.9151997118887785,
            311: 6.890642974760411,
            312: 6.832039497902536,
            313: 6.770450930619853,
            314: 6.779407406982481,
            315: 6.796831365474717,
            316: 6.874021461500495,
            317: 7.003188753221132,
            318: 7.029203640539648,
            319: 7.000228834971124,
            320: 6.989802244863403,
            321: 6.968052515508479,
            322: 6.961716964661915,
            323: 7.0346514231697626,
            324: 7.163679446468707,
            325: 7.142108906504396,
            326: 7.081990776087072,
            327: 7.175156570621806,
            328: 7.16873884332533,
            329: 7.110586090530723,
            330: 7.0456872214766095,
            331: 6.9945513880716,
            332: 6.955059979647823,
            333: 6.92363706291534,
            334: 6.8330138471104735,
            335: 6.824196972596266,
            336: 6.783315015281159,
            337: 6.771403323110887,
            338: 6.729339733151679,
            339: 6.676544452851701,
            340: 6.634351727740424,
            341: 6.626348632758906,
            342: 6.641510006291089,
            343: 6.661465938929808,
            344: 6.651535496277096,
            345: 6.761862542552691,
            346: 6.759678498707356,
            347: 6.680934014134102,
            348: 6.619982347187682,
            349: 6.6009647644938125,
            350: 6.606593035431916,
            351: 6.609726000786197,
            352: 6.628513336231555,
            353: 6.69239901639873,
            354: 6.6161610310722265,
            355: 6.609546785338131,
            356: 6.638294256244714,
            357: 6.671834516940681,
            358: 6.762457060269772,
            359: 6.824769667404278,
            360: 6.916865527694904,
            361: 6.942873320511768,
            362: 6.920456662652923,
            363: 7.021175411116804,
            364: 7.0419752895941565,
            365: 7.0170579491646325,
            366: 6.992771335282274,
            367: 6.9690701579034275,
            368: 6.9459143008917215,
            369: 6.923268030500096,
            370: 6.9010993530507765,
            371: 6.879379488815659,
            372: 6.858082437392524,
            373: 6.837184615849763,
            374: 6.816664555280485,
            375: 6.796502644639974,
            376: 6.776680913161631,
            377: 6.757182844479369,
            378: 6.737993216985914,
            379: 6.719097966038125,
            380: 6.7004840644626515,
            381: 6.682139418476238,
            382: 6.664052776657809,
            383: 6.646213650025969,
            384: 6.628612241609547,
            385: 6.611239384168365,
            386: 6.5940864849403065,
            387: 6.577145476469456,
            388: 6.560408772716754,
            389: 6.543869229775718,
            390: 6.527520110616059,
            391: 6.511355053361671,
            392: 6.495368042679324,
            393: 6.479553383913212,
        },
        "fcst_upper": {
            0: 9.191342280907197,
            1: 9.183010142132959,
            2: 9.172528367431022,
            3: 9.127838478681515,
            4: 9.099076515038163,
            5: 9.331723632882332,
            6: 9.435994980644018,
            7: 9.404159294485051,
            8: 9.341186090706719,
            9: 9.240254687190548,
            10: 9.14253139182669,
            11: 9.03036775426144,
            12: 8.969623834431,
            13: 8.925994462271142,
            14: 8.905066621306359,
            15: 8.923952367894552,
            16: 8.918727644507364,
            17: 8.87189684558903,
            18: 8.768877566629746,
            19: 8.703800112086922,
            20: 8.760054180211533,
            21: 8.875445620977905,
            22: 8.899085984059711,
            23: 8.862034125423243,
            24: 8.826953592556166,
            25: 8.733946905125272,
            26: 8.700251949475778,
            27: 8.678114041285758,
            28: 8.69901931405784,
            29: 8.713684936041636,
            30: 8.765931910630643,
            31: 8.764918233610695,
            32: 8.728246227209286,
            33: 8.708547339150538,
            34: 8.727466882138353,
            35: 8.76329387838348,
            36: 8.72546175163588,
            37: 8.713161102659754,
            38: 8.739939013514181,
            39: 8.774615146669353,
            40: 8.759083467213463,
            41: 8.718116441810503,
            42: 8.7364528743621,
            43: 8.761831553343399,
            44: 8.7408029182963,
            45: 8.722376116997227,
            46: 8.668188111287215,
            47: 8.712704515380594,
            48: 8.721376967212644,
            49: 8.866944126710498,
            50: 8.927897577154253,
            51: 8.900983825509355,
            52: 8.894468515499884,
            53: 8.8067501708849,
            54: 8.728302115989388,
            55: 8.698020394742498,
            56: 8.70297407205376,
            57: 8.66955526902708,
            58: 8.63970621867718,
            59: 8.604535385267223,
            60: 8.532669558816282,
            61: 8.504762332693117,
            62: 8.495225350614263,
            63: 8.517468042819617,
            64: 8.542313814613328,
            65: 8.534083503731418,
            66: 8.558069835282032,
            67: 8.55739572615553,
            68: 8.551284423062702,
            69: 8.583571831849946,
            70: 8.617742716916093,
            71: 8.695858846792461,
            72: 8.905144330958993,
            73: 9.008683783115826,
            74: 9.083957610611547,
            75: 9.059170893123227,
            76: 9.023857816217653,
            77: 9.005386535875319,
            78: 8.9904884779434,
            79: 8.965999313201705,
            80: 8.959200680092962,
            81: 8.906692911128196,
            82: 8.872150802118776,
            83: 8.902219461136927,
            84: 8.907419496708581,
            85: 8.945325658927985,
            86: 9.075748068269197,
            87: 9.261078188099024,
            88: 9.254933027529956,
            89: 9.249801732814095,
            90: 9.21792986523455,
            91: 9.135759468511466,
            92: 9.061076188835893,
            93: 9.051780386207595,
            94: 9.046508034587047,
            95: 9.05186761233608,
            96: 9.054189907787952,
            97: 9.063212463439928,
            98: 9.051681245356397,
            99: 9.015085278847367,
            100: 9.055631462759383,
            101: 9.264122780671869,
            102: 9.344457938230175,
            103: 9.438198234195857,
            104: 9.41153070901968,
            105: 9.434988287941724,
            106: 9.411402624985648,
            107: 9.333583340458167,
            108: 9.334951675128574,
            109: 9.323146305298867,
            110: 9.451289267698456,
            111: 9.56831699507828,
            112: 9.512429878369385,
            113: 9.428998062591523,
            114: 9.407116384557881,
            115: 9.373037275274962,
            116: 9.446475173518875,
            117: 9.665326885995734,
            118: 9.764733468257363,
            119: 9.712304526880098,
            120: 9.643150510397966,
            121: 9.56709986396701,
            122: 9.554848108594346,
            123: 9.52389941138022,
            124: 9.614508612324721,
            125: 9.590041640325982,
            126: 9.550168577218878,
            127: 9.583150220801512,
            128: 9.902527774636816,
            129: 9.841726441802091,
            130: 9.815792097880964,
            131: 10.040831720269647,
            132: 10.62494579484507,
            133: 10.613943866542757,
            134: 10.40968249151733,
            135: 10.229154010471502,
            136: 10.164463887293392,
            137: 10.055772794172903,
            138: 10.217899397277337,
            139: 10.29743779118988,
            140: 10.585325673150189,
            141: 10.381319953931774,
            142: 10.1794487001828,
            143: 10.219847549447426,
            144: 10.031617059913598,
            145: 10.139681761570479,
            146: 10.23579165329293,
            147: 10.094617841212523,
            148: 9.868922613842559,
            149: 9.711782622828421,
            150: 9.653429116844466,
            151: 9.565205896173078,
            152: 9.714029140184847,
            153: 9.965098235124037,
            154: 9.922692668198598,
            155: 9.812459238472966,
            156: 9.75930036729711,
            157: 9.812956037148847,
            158: 9.740224772074972,
            159: 9.977919185817402,
            160: 10.180027733135473,
            161: 10.10712344595404,
            162: 9.915816402205278,
            163: 9.746718482109852,
            164: 9.65499562647269,
            165: 9.54744645383571,
            166: 9.648613032578066,
            167: 9.742207347578157,
            168: 10.214222084379637,
            169: 10.101546518771874,
            170: 9.945807400770597,
            171: 9.828278470897061,
            172: 9.68267419212617,
            173: 9.870105851880366,
            174: 9.910816746464041,
            175: 9.843061196334922,
            176: 9.716869275474016,
            177: 9.617913875152944,
            178: 9.577535623398871,
            179: 9.555424498234805,
            180: 9.697383242731073,
            181: 10.089980055211596,
            182: 10.028800074550448,
            183: 9.936613211687423,
            184: 9.823251208285122,
            185: 9.752398501619266,
            186: 9.672542294896562,
            187: 9.902774827389306,
            188: 10.072485149351763,
            189: 10.004506590517925,
            190: 9.849906815148143,
            191: 9.756666848859902,
            192: 9.765770507805287,
            193: 9.641664015093568,
            194: 9.774104279043216,
            195: 9.84041385061451,
            196: 9.797622693239644,
            197: 9.677917620743191,
            198: 9.593979007659286,
            199: 9.508706629584262,
            200: 9.409042239454392,
            201: 9.57548400658577,
            202: 9.820640060407504,
            203: 9.770478702150815,
            204: 9.64842745384736,
            205: 9.637451195225834,
            206: 9.693253719803769,
            207: 9.612554205657657,
            208: 9.79864477732818,
            209: 10.039414137214473,
            210: 9.983519819232514,
            211: 9.886179250889635,
            212: 9.780639551996437,
            213: 9.761475981771957,
            214: 9.72464938386759,
            215: 9.857174372607245,
            216: 10.035087473414908,
            217: 10.163951806322924,
            218: 10.051367479386832,
            219: 9.97643275379279,
            220: 10.192427436850325,
            221: 10.075301968679653,
            222: 10.104497995091686,
            223: 10.13008653236204,
            224: 10.187039610730697,
            225: 10.083949167859389,
            226: 9.983890333587752,
            227: 9.845976423390125,
            228: 9.705634075168666,
            229: 9.834454325034114,
            230: 9.941475841249813,
            231: 9.894888273401333,
            232: 9.795997220729591,
            233: 9.695449049994119,
            234: 9.591289262719188,
            235: 9.491744340460247,
            236: 9.656957728642904,
            237: 9.875537287991092,
            238: 9.80855558310877,
            239: 9.750206253338854,
            240: 9.788153297107192,
            241: 9.75211422176269,
            242: 9.68944674093885,
            243: 9.862973900641935,
            244: 10.147440546043425,
            245: 10.127287235259127,
            246: 10.105636592983112,
            247: 10.082072578606281,
            248: 10.129064684368732,
            249: 10.142797472704466,
            250: 10.360132976725843,
            251: 10.378623229289436,
            252: 10.30509822365546,
            253: 10.23731914788213,
            254: 10.164254594133292,
            255: 10.148047275197454,
            256: 10.458891672229457,
            257: 10.92134320129791,
            258: 10.97241690965045,
            259: 10.800233637286775,
            260: 10.56752385770221,
            261: 10.362362017800205,
            262: 10.186737201411185,
            263: 10.005336005807093,
            264: 9.983828823149128,
            265: 10.212122254284791,
            266: 10.152457606874371,
            267: 10.073099035116039,
            268: 9.948282374401092,
            269: 9.841015962962734,
            270: 9.740593345194416,
            271: 9.68100323888142,
            272: 9.998655497131269,
            273: 9.906227695326564,
            274: 9.803134352281685,
            275: 9.717731689197707,
            276: 9.673498760280623,
            277: 9.633010770859636,
            278: 9.846475301232912,
            279: 10.107750299930803,
            280: 10.040899762252087,
            281: 9.910273854604368,
            282: 9.776435240450073,
            283: 9.631308000915066,
            284: 9.494779898054688,
            285: 9.377355490951187,
            286: 9.298132978550822,
            287: 9.225714029162223,
            288: 9.155857242276491,
            289: 9.071485447445369,
            290: 9.018432828901982,
            291: 8.96007963440889,
            292: 8.916445299036685,
            293: 8.916354018057792,
            294: 8.925410809481551,
            295: 8.910288425773995,
            296: 8.884853735160464,
            297: 8.870033965057932,
            298: 8.831220925307509,
            299: 8.785029744915091,
            300: 8.786786976517513,
            301: 8.868619393982007,
            302: 8.882155011968807,
            303: 8.879831424261331,
            304: 8.865997850263405,
            305: 8.825822466981931,
            306: 8.803035268026845,
            307: 8.798617587465936,
            308: 8.795954240779865,
            309: 8.795726288365017,
            310: 8.8127414385888,
            311: 8.788184701460432,
            312: 8.729581224602558,
            313: 8.667992657319875,
            314: 8.676949133682502,
            315: 8.69437309217474,
            316: 8.771563188200517,
            317: 8.900730479921155,
            318: 8.92674536723967,
            319: 8.897770561671146,
            320: 8.887343971563425,
            321: 8.8655942422085,
            322: 8.859258691361937,
            323: 8.932193149869784,
            324: 9.061221173168729,
            325: 9.039650633204419,
            326: 8.979532502787094,
            327: 9.072698297321828,
            328: 9.066280570025352,
            329: 9.008127817230745,
            330: 8.943228948176632,
            331: 8.892093114771622,
            332: 8.852601706347844,
            333: 8.821178789615361,
            334: 8.730555573810495,
            335: 8.721738699296289,
            336: 8.68085674198118,
            337: 8.668945049810908,
            338: 8.6268814598517,
            339: 8.574086179551722,
            340: 8.531893454440446,
            341: 8.523890359458928,
            342: 8.53905173299111,
            343: 8.55900766562983,
            344: 8.549077222977118,
            345: 8.659404269252713,
            346: 8.657220225407379,
            347: 8.578475740834124,
            348: 8.517524073887705,
            349: 8.498506491193835,
            350: 8.504134762131939,
            351: 8.50726772748622,
            352: 8.526055062931578,
            353: 8.589940743098753,
            354: 8.513702757772249,
            355: 8.507088512038154,
            356: 8.535835982944736,
            357: 8.569376243640702,
            358: 8.659998786969794,
            359: 8.7223113941043,
            360: 8.814407254394926,
            361: 8.84041504721179,
            362: 8.817998389352946,
            363: 8.918717137816826,
            364: 8.939517016294179,
            365: 8.964794302928402,
            366: 8.989440863015462,
            367: 9.013501986599008,
            368: 9.037017789815415,
            369: 9.06002400641174,
            370: 9.082552630065761,
            371: 9.10463244050558,
            372: 9.126289438133416,
            373: 9.147547205880876,
            374: 9.168427212654855,
            375: 9.188949069500067,
            376: 9.20913074718311,
            377: 9.22898876207007,
            378: 9.248538335768227,
            379: 9.267793532920718,
            380: 9.28676738070089,
            381: 9.305471972892004,
            382: 9.323918560915134,
            383: 9.342117633751673,
            384: 9.360078988372797,
            385: 9.377811792018681,
            386: 9.395324637451438,
            387: 9.41262559212699,
            388: 9.429722242084392,
            389: 9.44662173123013,
            390: 9.463330796594487,
            391: 9.479855800053578,
            392: 9.496202756940624,
            393: 9.512377361911437,
        },
    }
)

AIR_FCST_15_THETA_SM_12 = pd.DataFrame(
    {
        "time": {
            t1: t2
            for t1, t2 in zip(
                range(144, 159), pd.date_range("1961-01-01", freq="MS", periods=15)
            )
        },
        "fcst": {
            144: 448.2087900770604,
            145: 418.01704627454444,
            146: 462.6226697900576,
            147: 482.01829558715565,
            148: 500.1199199052061,
            149: 563.0404558048393,
            150: 652.4307042492908,
            151: 648.3239024316182,
            152: 529.5672929614743,
            153: 474.35684250110404,
            154: 405.53660708977384,
            155: 445.4969133060624,
            156: 462.6108836763946,
            157: 431.41313113608305,
            158: 477.40873250978916,
        },
        "fcst_lower": {
            144: 434.30437309420444,
            145: 399.62726053256915,
            146: 440.6445982723293,
            147: 456.9606214005715,
            148: 472.3217465183875,
            149: 532.7487102023447,
            150: 619.8355932715863,
            151: 613.577785128364,
            152: 492.79578122134967,
            153: 435.6658166209759,
            154: 365.0168971739888,
            155: 403.227559163114,
            156: 418.66148427589525,
            157: 385.8455865932043,
            158: 430.2785667592864,
        },
        "fcst_upper": {
            144: 462.1132070599164,
            145: 436.40683201651973,
            146: 484.60074130778594,
            147: 507.0759697737398,
            148: 527.9180932920247,
            149: 593.332201407334,
            150: 685.0258152269953,
            151: 683.0700197348724,
            152: 566.338804701599,
            153: 513.0478683812322,
            154: 446.05631700555887,
            155: 487.76626744901085,
            156: 506.560283076894,
            157: 476.9806756789618,
            158: 524.538898260292,
        },
    }
)

AIR_FCST_15_THETA_INCL_HIST_SM_12 = pd.DataFrame(
    {
        "time": {
            t1: t2
            for t1, t2 in zip(
                range(0, 159), pd.date_range("1949-01-01", freq="MS", periods=160)
            )
        },
        "fcst": {
            0: 111.79670896456088,
            1: 119.78825978861222,
            2: 131.108639837203,
            3: 125.52125593777158,
            4: 119.79843574271331,
            5: 135.75952312142212,
            6: 149.49159600425662,
            7: 146.09031891691237,
            8: 136.25293824456878,
            9: 115.61942178015076,
            10: 102.25193807456077,
            11: 120.44840075601132,
            12: 117.57986049609734,
            13: 121.44514623826416,
            14: 140.03514994329447,
            15: 133.1701517951673,
            16: 128.53096202289535,
            17: 139.96545336056764,
            18: 162.2264130013029,
            19: 167.995131473987,
            20: 154.01883207274443,
            21: 135.37786929814985,
            22: 115.55460771339975,
            23: 131.27520720016872,
            24: 138.89032716777527,
            25: 149.22675401621964,
            26: 168.97633126489228,
            27: 166.53323486843237,
            28: 159.00128987511988,
            29: 188.81812462715843,
            30: 195.73756366126267,
            31: 198.92834163791827,
            32: 177.74204274489412,
            33: 159.08148136111856,
            34: 140.4765248149028,
            35: 165.47945476038055,
            36: 167.5886863324693,
            37: 172.695207108439,
            38: 204.56967949380495,
            39: 182.96453987357236,
            40: 180.2358420528077,
            41: 200.3807802955463,
            42: 233.8099668939168,
            43: 232.4679406889497,
            44: 211.83271294828242,
            45: 184.14245575784503,
            46: 165.98485018929784,
            47: 192.59435476206696,
            48: 196.30459247582291,
            49: 192.3859344363729,
            50: 226.8244653984648,
            51: 224.3931842749689,
            52: 233.21798211135595,
            53: 254.05492079939162,
            54: 266.8038301871632,
            55: 264.0560956511354,
            56: 236.11447734133853,
            57: 209.23401387498993,
            58: 183.4710183561026,
            59: 201.82992019907178,
            60: 204.3109115466529,
            61: 195.8684319108758,
            62: 221.14129991175565,
            63: 226.89890933410257,
            64: 225.9584749285574,
            65: 260.7522550196045,
            66: 291.8565558881654,
            67: 294.54415201323656,
            68: 255.8622141632388,
            69: 226.42317074229345,
            70: 197.6555240897916,
            71: 227.49976596193366,
            72: 233.07995817497056,
            73: 228.2993289943148,
            74: 271.51049604617805,
            75: 261.4313673269615,
            76: 268.41504698408835,
            77: 307.01522933820735,
            78: 349.9690674469666,
            79: 350.0838691731356,
            80: 303.58203644312994,
            81: 269.0760537924743,
            82: 236.9104441090903,
            83: 266.7038105344908,
            84: 282.07023903338717,
            85: 268.8986445915135,
            86: 317.9097731770149,
            87: 309.234131246849,
            88: 314.91909624600396,
            89: 369.1869126305076,
            90: 415.1505298125639,
            91: 402.40459003218393,
            92: 349.53067945211615,
            93: 305.39497022457294,
            94: 265.65028984584956,
            95: 302.2768734159642,
            96: 311.66310629464436,
            97: 297.9131426435433,
            98: 345.11216777672917,
            99: 344.0169740780778,
            100: 353.9633896273514,
            101: 414.9829366150804,
            102: 467.98122320341963,
            103: 461.9962274825881,
            104: 393.43206178777564,
            105: 347.9760769401234,
            106: 301.81507870681924,
            107: 336.4992669011685,
            108: 345.3874542293402,
            109: 320.8392528230171,
            110: 362.37933902861516,
            111: 357.5747725563758,
            112: 358.2549748229521,
            113: 418.2370991108101,
            114: 486.7765189251083,
            115: 488.01906719384647,
            116: 418.6727558500043,
            117: 354.28756150717373,
            118: 310.2300396375148,
            119: 341.2719914808622,
            120: 347.5719643095631,
            121: 335.2866312309344,
            122: 382.6122672686611,
            123: 407.57939936085285,
            124: 409.7341279302951,
            125: 477.1531508988016,
            126: 538.6444044372784,
            127: 543.6206782024051,
            128: 458.32216788738526,
            129: 408.2219218583385,
            130: 349.86529923192796,
            131: 395.42118988618614,
            132: 417.33059862216,
            133: 387.91323262824096,
            134: 431.1121962636586,
            135: 437.09888541174723,
            136: 473.72055544701556,
            137: 530.2383328691719,
            138: 617.5649677819079,
            139: 615.8693104427098,
            140: 494.7791685211982,
            141: 452.26060410042675,
            142: 392.08810254275596,
            143: 427.6225229562093,
            144: 448.2087900770604,
            145: 418.01704627454444,
            146: 462.6226697900576,
            147: 482.01829558715565,
            148: 500.1199199052061,
            149: 563.0404558048393,
            150: 652.4307042492908,
            151: 648.3239024316182,
            152: 529.5672929614743,
            153: 474.35684250110404,
            154: 405.53660708977384,
            155: 445.4969133060624,
            156: 462.6108836763946,
            157: 431.41313113608305,
            158: 477.40873250978916,
        },
        "fcst_lower": {
            0: 97.89229198170486,
            1: 105.8838428057562,
            2: 117.20422285434697,
            3: 111.61683895491556,
            4: 105.89401875985729,
            5: 121.8551061385661,
            6: 135.5871790214006,
            7: 132.18590193405635,
            8: 122.34852126171276,
            9: 101.71500479729474,
            10: 88.34752109170475,
            11: 106.5439837731553,
            12: 103.67544351324132,
            13: 107.54072925540814,
            14: 126.13073296043845,
            15: 119.26573481231128,
            16: 114.62654504003933,
            17: 126.06103637771162,
            18: 148.32199601844687,
            19: 154.09071449113097,
            20: 140.1144150898884,
            21: 121.47345231529383,
            22: 101.65019073054373,
            23: 117.3707902173127,
            24: 124.98591018491925,
            25: 135.32233703336362,
            26: 155.07191428203626,
            27: 152.62881788557635,
            28: 145.09687289226386,
            29: 174.9137076443024,
            30: 181.83314667840665,
            31: 185.02392465506225,
            32: 163.8376257620381,
            33: 145.17706437826254,
            34: 126.57210783204678,
            35: 151.57503777752453,
            36: 153.6842693496133,
            37: 158.790790125583,
            38: 190.66526251094893,
            39: 169.06012289071634,
            40: 166.33142506995168,
            41: 186.47636331269027,
            42: 219.90554991106077,
            43: 218.5635237060937,
            44: 197.9282959654264,
            45: 170.238038774989,
            46: 152.08043320644182,
            47: 178.68993777921094,
            48: 182.4001754929669,
            49: 178.4815174535169,
            50: 212.9200484156088,
            51: 210.48876729211287,
            52: 219.31356512849993,
            53: 240.1505038165356,
            54: 252.8994132043072,
            55: 250.1516786682794,
            56: 222.2100603584825,
            57: 195.3295968921339,
            58: 169.56660137324658,
            59: 187.92550321621576,
            60: 190.40649456379688,
            61: 181.9640149280198,
            62: 207.23688292889963,
            63: 212.99449235124655,
            64: 212.05405794570137,
            65: 246.84783803674847,
            66: 277.9521389053094,
            67: 280.63973503038056,
            68: 241.95779718038278,
            69: 212.51875375943743,
            70: 183.7511071069356,
            71: 213.59534897907764,
            72: 219.17554119211454,
            73: 214.39491201145879,
            74: 257.60607906332206,
            75: 247.52695034410547,
            76: 254.51063000123233,
            77: 293.11081235535136,
            78: 336.0646504641106,
            79: 336.1794521902796,
            80: 289.67761946027395,
            81: 255.17163680961826,
            82: 223.00602712623427,
            83: 252.79939355163478,
            84: 268.1658220505312,
            85: 254.9942276086575,
            86: 304.00535619415894,
            87: 295.329714263993,
            88: 301.01467926314797,
            89: 355.2824956476516,
            90: 401.2461128297079,
            91: 388.50017304932794,
            92: 335.62626246926015,
            93: 291.49055324171695,
            94: 251.74587286299354,
            95: 288.3724564331082,
            96: 297.7586893117884,
            97: 284.00872566068733,
            98: 331.2077507938732,
            99: 330.1125570952218,
            100: 340.0589726444954,
            101: 401.0785196322244,
            102: 454.07680622056364,
            103: 448.0918104997321,
            104: 379.52764480491965,
            105: 334.0716599572674,
            106: 287.91066172396324,
            107: 322.5948499183125,
            108: 331.48303724648423,
            109: 306.9348358401611,
            110: 348.4749220457592,
            111: 343.6703555735198,
            112: 344.3505578400961,
            113: 404.3326821279541,
            114: 472.8721019422523,
            115: 474.1146502109905,
            116: 404.7683388671483,
            117: 340.38314452431774,
            118: 296.3256226546588,
            119: 327.3675744980062,
            120: 333.6675473267071,
            121: 321.3822142480784,
            122: 368.70785028580514,
            123: 393.67498237799686,
            124: 395.8297109474391,
            125: 463.2487339159456,
            126: 524.7399874544224,
            127: 529.7162612195491,
            128: 444.41775090452927,
            129: 394.3175048754825,
            130: 335.960882249072,
            131: 381.51677290333015,
            132: 403.426181639304,
            133: 374.00881564538497,
            134: 417.2077792808026,
            135: 423.19446842889124,
            136: 459.81613846415956,
            137: 516.3339158863159,
            138: 603.6605507990519,
            139: 601.9648934598538,
            140: 480.8747515383422,
            141: 438.35618711757076,
            142: 378.18368555989997,
            143: 413.7181059733533,
            144: 434.30437309420444,
            145: 399.62726053256915,
            146: 440.6445982723293,
            147: 456.9606214005715,
            148: 472.3217465183875,
            149: 532.7487102023447,
            150: 619.8355932715863,
            151: 613.577785128364,
            152: 492.79578122134967,
            153: 435.6658166209759,
            154: 365.0168971739888,
            155: 403.227559163114,
            156: 418.66148427589525,
            157: 385.8455865932043,
            158: 430.2785667592864,
        },
        "fcst_upper": {
            0: 125.7011259474169,
            1: 133.69267677146823,
            2: 145.013056820059,
            3: 139.4256729206276,
            4: 133.70285272556933,
            5: 149.66394010427814,
            6: 163.39601298711264,
            7: 159.9947358997684,
            8: 150.1573552274248,
            9: 129.52383876300678,
            10: 116.15635505741679,
            11: 134.35281773886734,
            12: 131.48427747895335,
            13: 135.34956322112018,
            14: 153.9395669261505,
            15: 147.07456877802332,
            16: 142.43537900575137,
            17: 153.86987034342366,
            18: 176.1308299841589,
            19: 181.899548456843,
            20: 167.92324905560045,
            21: 149.28228628100587,
            22: 129.45902469625577,
            23: 145.17962418302474,
            24: 152.7947441506313,
            25: 163.13117099907566,
            26: 182.8807482477483,
            27: 180.4376518512884,
            28: 172.9057068579759,
            29: 202.72254161001445,
            30: 209.6419806441187,
            31: 212.83275862077429,
            32: 191.64645972775014,
            33: 172.98589834397458,
            34: 154.38094179775882,
            35: 179.38387174323657,
            36: 181.49310331532533,
            37: 186.59962409129503,
            38: 218.47409647666097,
            39: 196.86895685642838,
            40: 194.14025903566372,
            41: 214.2851972784023,
            42: 247.7143838767728,
            43: 246.37235767180573,
            44: 225.73712993113844,
            45: 198.04687274070105,
            46: 179.88926717215386,
            47: 206.49877174492298,
            48: 210.20900945867893,
            49: 206.29035141922893,
            50: 240.72888238132083,
            51: 238.2976012578249,
            52: 247.12239909421197,
            53: 267.95933778224764,
            54: 280.7082471700192,
            55: 277.9605126339914,
            56: 250.01889432419455,
            57: 223.13843085784595,
            58: 197.37543533895862,
            59: 215.7343371819278,
            60: 218.21532852950892,
            61: 209.77284889373183,
            62: 235.04571689461167,
            63: 240.8033263169586,
            64: 239.8628919114134,
            65: 274.6566720024605,
            66: 305.7609728710214,
            67: 308.44856899609255,
            68: 269.7666311460948,
            69: 240.32758772514947,
            70: 211.55994107264763,
            71: 241.40418294478968,
            72: 246.98437515782658,
            73: 242.20374597717083,
            74: 285.41491302903404,
            75: 275.3357843098175,
            76: 282.31946396694434,
            77: 320.91964632106334,
            78: 363.8734844298226,
            79: 363.9882861559916,
            80: 317.4864534259859,
            81: 282.9804707753303,
            82: 250.8148610919463,
            83: 280.6082275173468,
            84: 295.97465601624316,
            85: 282.8030615743695,
            86: 331.8141901598709,
            87: 323.138548229705,
            88: 328.82351322885995,
            89: 383.0913296133636,
            90: 429.0549467954199,
            91: 416.3090070150399,
            92: 363.43509643497214,
            93: 319.29938720742894,
            94: 279.55470682870555,
            95: 316.1812903988202,
            96: 325.56752327750036,
            97: 311.8175596263993,
            98: 359.01658475958516,
            99: 357.9213910609338,
            100: 367.86780661020737,
            101: 428.8873535979364,
            102: 481.8856401862756,
            103: 475.9006444654441,
            104: 407.33647877063163,
            105: 361.8804939229794,
            106: 315.7194956896752,
            107: 350.4036838840245,
            108: 359.2918712121962,
            109: 334.7436698058731,
            110: 376.28375601147116,
            111: 371.4791895392318,
            112: 372.15939180580807,
            113: 432.1415160936661,
            114: 500.6809359079643,
            115: 501.92348417670246,
            116: 432.5771728328603,
            117: 368.1919784900297,
            118: 324.13445662037077,
            119: 355.1764084637182,
            120: 361.4763812924191,
            121: 349.1910482137904,
            122: 396.5166842515171,
            123: 421.48381634370884,
            124: 423.63854491315107,
            125: 491.0575678816576,
            126: 552.5488214201343,
            127: 557.5250951852611,
            128: 472.22658487024125,
            129: 422.12633884119447,
            130: 363.76971621478395,
            131: 409.32560686904213,
            132: 431.235015605016,
            133: 401.81764961109695,
            134: 445.01661324651457,
            135: 451.0033023946032,
            136: 487.62497242987155,
            137: 544.1427498520279,
            138: 631.4693847647638,
            139: 629.7737274255658,
            140: 508.6835855040542,
            141: 466.16502108328274,
            142: 405.99251952561195,
            143: 441.5269399390653,
            144: 462.1132070599164,
            145: 436.40683201651973,
            146: 484.60074130778594,
            147: 507.0759697737398,
            148: 527.9180932920247,
            149: 593.332201407334,
            150: 685.0258152269953,
            151: 683.0700197348724,
            152: 566.338804701599,
            153: 513.0478683812322,
            154: 446.05631700555887,
            155: 487.76626744901085,
            156: 506.560283076894,
            157: 476.9806756789618,
            158: 524.538898260292,
        },
    }
)

PEYTON_FCST_30_THETA_SM_12 = pd.DataFrame(
    {
        "time": {
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
            379: pd.Timestamp("2013-05-16 00:00:00"),
            380: pd.Timestamp("2013-05-17 00:00:00"),
            381: pd.Timestamp("2013-05-18 00:00:00"),
            382: pd.Timestamp("2013-05-19 00:00:00"),
            383: pd.Timestamp("2013-05-20 00:00:00"),
            384: pd.Timestamp("2013-05-21 00:00:00"),
            385: pd.Timestamp("2013-05-22 00:00:00"),
            386: pd.Timestamp("2013-05-23 00:00:00"),
            387: pd.Timestamp("2013-05-24 00:00:00"),
            388: pd.Timestamp("2013-05-25 00:00:00"),
            389: pd.Timestamp("2013-05-26 00:00:00"),
            390: pd.Timestamp("2013-05-27 00:00:00"),
            391: pd.Timestamp("2013-05-28 00:00:00"),
            392: pd.Timestamp("2013-05-29 00:00:00"),
            393: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            364: 7.990738547693687,
            365: 7.990918520796038,
            366: 7.991098493898388,
            367: 7.991278467000738,
            368: 7.991458440103089,
            369: 7.991638413205439,
            370: 7.991818386307789,
            371: 7.99199835941014,
            372: 7.9921783325124895,
            373: 7.9923583056148395,
            374: 7.9925382787171895,
            375: 7.99271825181954,
            376: 7.99289822492189,
            377: 7.99307819802424,
            378: 7.993258171126591,
            379: 7.993438144228941,
            380: 7.993618117331291,
            381: 7.993798090433641,
            382: 7.993978063535992,
            383: 7.994158036638342,
            384: 7.994338009740692,
            385: 7.994517982843043,
            386: 7.994697955945393,
            387: 7.9948779290477425,
            388: 7.9950579021500925,
            389: 7.995237875252443,
            390: 7.995417848354793,
            391: 7.995597821457143,
            392: 7.995777794559494,
            393: 7.995957767661844,
        },
        "fcst_lower": {
            364: 7.041967684275796,
            365: 7.017052582945252,
            366: 6.992768098417386,
            367: 6.969068952186619,
            368: 6.9459150379376045,
            369: 6.923270630348319,
            370: 6.90110374302005,
            371: 6.879385602554656,
            372: 6.858090214087461,
            373: 6.8371939995578686,
            374: 6.816675494365484,
            375: 6.796515091290942,
            376: 6.7766948229804775,
            377: 6.757198176125218,
            378: 6.738009931866966,
            379: 6.719116028043378,
            380: 6.700503439727285,
            381: 6.682160075175554,
            382: 6.664074684825556,
            383: 6.646236781393549,
            384: 6.628636569463221,
            385: 6.611264883222001,
            386: 6.594113131221635,
            387: 6.577173247218081,
            388: 6.560437646292465,
            389: 6.5438991855758175,
            390: 6.527551129000639,
            391: 6.511387115585909,
            392: 6.495401130831999,
            393: 6.479587480860724,
        },
        "fcst_upper": {
            364: 8.939509411111578,
            365: 8.964784458646825,
            366: 8.98942888937939,
            367: 9.013487981814857,
            368: 9.037001842268573,
            369: 9.060006196062558,
            370: 9.082533029595528,
            371: 9.104611116265623,
            372: 9.126266450937518,
            373: 9.14752261167181,
            374: 9.168401063068895,
            375: 9.188921412348138,
            376: 9.209101626863303,
            377: 9.228958219923262,
            378: 9.248506410386216,
            379: 9.267760260414503,
            380: 9.286732794935297,
            381: 9.305436105691728,
            382: 9.323881442246428,
            383: 9.342079291883135,
            384: 9.360039450018162,
            385: 9.377771082464085,
            386: 9.39528278066915,
            387: 9.412582610877404,
            388: 9.42967815800772,
            389: 9.44657656492907,
            390: 9.463284567708946,
            391: 9.479808527328377,
            392: 9.49615445828699,
            393: 9.512328054462964,
        },
    }
)

PEYTON_FCST_30_THETA_INCL_HIST_SM_12 = pd.DataFrame(
    {
        "time": {
            0: pd.Timestamp("2012-05-02 00:00:00"),
            1: pd.Timestamp("2012-05-03 00:00:00"),
            2: pd.Timestamp("2012-05-04 00:00:00"),
            3: pd.Timestamp("2012-05-05 00:00:00"),
            4: pd.Timestamp("2012-05-06 00:00:00"),
            5: pd.Timestamp("2012-05-07 00:00:00"),
            6: pd.Timestamp("2012-05-08 00:00:00"),
            7: pd.Timestamp("2012-05-09 00:00:00"),
            8: pd.Timestamp("2012-05-10 00:00:00"),
            9: pd.Timestamp("2012-05-11 00:00:00"),
            10: pd.Timestamp("2012-05-12 00:00:00"),
            11: pd.Timestamp("2012-05-13 00:00:00"),
            12: pd.Timestamp("2012-05-14 00:00:00"),
            13: pd.Timestamp("2012-05-15 00:00:00"),
            14: pd.Timestamp("2012-05-16 00:00:00"),
            15: pd.Timestamp("2012-05-17 00:00:00"),
            16: pd.Timestamp("2012-05-18 00:00:00"),
            17: pd.Timestamp("2012-05-19 00:00:00"),
            18: pd.Timestamp("2012-05-20 00:00:00"),
            19: pd.Timestamp("2012-05-21 00:00:00"),
            20: pd.Timestamp("2012-05-22 00:00:00"),
            21: pd.Timestamp("2012-05-23 00:00:00"),
            22: pd.Timestamp("2012-05-24 00:00:00"),
            23: pd.Timestamp("2012-05-25 00:00:00"),
            24: pd.Timestamp("2012-05-26 00:00:00"),
            25: pd.Timestamp("2012-05-27 00:00:00"),
            26: pd.Timestamp("2012-05-28 00:00:00"),
            27: pd.Timestamp("2012-05-29 00:00:00"),
            28: pd.Timestamp("2012-05-30 00:00:00"),
            29: pd.Timestamp("2012-05-31 00:00:00"),
            30: pd.Timestamp("2012-06-01 00:00:00"),
            31: pd.Timestamp("2012-06-02 00:00:00"),
            32: pd.Timestamp("2012-06-03 00:00:00"),
            33: pd.Timestamp("2012-06-04 00:00:00"),
            34: pd.Timestamp("2012-06-05 00:00:00"),
            35: pd.Timestamp("2012-06-06 00:00:00"),
            36: pd.Timestamp("2012-06-07 00:00:00"),
            37: pd.Timestamp("2012-06-08 00:00:00"),
            38: pd.Timestamp("2012-06-09 00:00:00"),
            39: pd.Timestamp("2012-06-10 00:00:00"),
            40: pd.Timestamp("2012-06-11 00:00:00"),
            41: pd.Timestamp("2012-06-12 00:00:00"),
            42: pd.Timestamp("2012-06-13 00:00:00"),
            43: pd.Timestamp("2012-06-14 00:00:00"),
            44: pd.Timestamp("2012-06-15 00:00:00"),
            45: pd.Timestamp("2012-06-16 00:00:00"),
            46: pd.Timestamp("2012-06-17 00:00:00"),
            47: pd.Timestamp("2012-06-18 00:00:00"),
            48: pd.Timestamp("2012-06-19 00:00:00"),
            49: pd.Timestamp("2012-06-20 00:00:00"),
            50: pd.Timestamp("2012-06-21 00:00:00"),
            51: pd.Timestamp("2012-06-22 00:00:00"),
            52: pd.Timestamp("2012-06-23 00:00:00"),
            53: pd.Timestamp("2012-06-24 00:00:00"),
            54: pd.Timestamp("2012-06-25 00:00:00"),
            55: pd.Timestamp("2012-06-26 00:00:00"),
            56: pd.Timestamp("2012-06-27 00:00:00"),
            57: pd.Timestamp("2012-06-28 00:00:00"),
            58: pd.Timestamp("2012-06-29 00:00:00"),
            59: pd.Timestamp("2012-06-30 00:00:00"),
            60: pd.Timestamp("2012-07-01 00:00:00"),
            61: pd.Timestamp("2012-07-02 00:00:00"),
            62: pd.Timestamp("2012-07-03 00:00:00"),
            63: pd.Timestamp("2012-07-04 00:00:00"),
            64: pd.Timestamp("2012-07-05 00:00:00"),
            65: pd.Timestamp("2012-07-06 00:00:00"),
            66: pd.Timestamp("2012-07-07 00:00:00"),
            67: pd.Timestamp("2012-07-08 00:00:00"),
            68: pd.Timestamp("2012-07-09 00:00:00"),
            69: pd.Timestamp("2012-07-10 00:00:00"),
            70: pd.Timestamp("2012-07-11 00:00:00"),
            71: pd.Timestamp("2012-07-12 00:00:00"),
            72: pd.Timestamp("2012-07-13 00:00:00"),
            73: pd.Timestamp("2012-07-14 00:00:00"),
            74: pd.Timestamp("2012-07-15 00:00:00"),
            75: pd.Timestamp("2012-07-16 00:00:00"),
            76: pd.Timestamp("2012-07-17 00:00:00"),
            77: pd.Timestamp("2012-07-18 00:00:00"),
            78: pd.Timestamp("2012-07-19 00:00:00"),
            79: pd.Timestamp("2012-07-20 00:00:00"),
            80: pd.Timestamp("2012-07-21 00:00:00"),
            81: pd.Timestamp("2012-07-22 00:00:00"),
            82: pd.Timestamp("2012-07-23 00:00:00"),
            83: pd.Timestamp("2012-07-24 00:00:00"),
            84: pd.Timestamp("2012-07-25 00:00:00"),
            85: pd.Timestamp("2012-07-26 00:00:00"),
            86: pd.Timestamp("2012-07-27 00:00:00"),
            87: pd.Timestamp("2012-07-28 00:00:00"),
            88: pd.Timestamp("2012-07-29 00:00:00"),
            89: pd.Timestamp("2012-07-30 00:00:00"),
            90: pd.Timestamp("2012-07-31 00:00:00"),
            91: pd.Timestamp("2012-08-01 00:00:00"),
            92: pd.Timestamp("2012-08-02 00:00:00"),
            93: pd.Timestamp("2012-08-03 00:00:00"),
            94: pd.Timestamp("2012-08-04 00:00:00"),
            95: pd.Timestamp("2012-08-05 00:00:00"),
            96: pd.Timestamp("2012-08-06 00:00:00"),
            97: pd.Timestamp("2012-08-07 00:00:00"),
            98: pd.Timestamp("2012-08-08 00:00:00"),
            99: pd.Timestamp("2012-08-09 00:00:00"),
            100: pd.Timestamp("2012-08-10 00:00:00"),
            101: pd.Timestamp("2012-08-11 00:00:00"),
            102: pd.Timestamp("2012-08-12 00:00:00"),
            103: pd.Timestamp("2012-08-13 00:00:00"),
            104: pd.Timestamp("2012-08-14 00:00:00"),
            105: pd.Timestamp("2012-08-15 00:00:00"),
            106: pd.Timestamp("2012-08-16 00:00:00"),
            107: pd.Timestamp("2012-08-17 00:00:00"),
            108: pd.Timestamp("2012-08-18 00:00:00"),
            109: pd.Timestamp("2012-08-19 00:00:00"),
            110: pd.Timestamp("2012-08-20 00:00:00"),
            111: pd.Timestamp("2012-08-21 00:00:00"),
            112: pd.Timestamp("2012-08-22 00:00:00"),
            113: pd.Timestamp("2012-08-23 00:00:00"),
            114: pd.Timestamp("2012-08-24 00:00:00"),
            115: pd.Timestamp("2012-08-25 00:00:00"),
            116: pd.Timestamp("2012-08-26 00:00:00"),
            117: pd.Timestamp("2012-08-27 00:00:00"),
            118: pd.Timestamp("2012-08-28 00:00:00"),
            119: pd.Timestamp("2012-08-29 00:00:00"),
            120: pd.Timestamp("2012-08-30 00:00:00"),
            121: pd.Timestamp("2012-08-31 00:00:00"),
            122: pd.Timestamp("2012-09-01 00:00:00"),
            123: pd.Timestamp("2012-09-02 00:00:00"),
            124: pd.Timestamp("2012-09-03 00:00:00"),
            125: pd.Timestamp("2012-09-04 00:00:00"),
            126: pd.Timestamp("2012-09-05 00:00:00"),
            127: pd.Timestamp("2012-09-06 00:00:00"),
            128: pd.Timestamp("2012-09-07 00:00:00"),
            129: pd.Timestamp("2012-09-08 00:00:00"),
            130: pd.Timestamp("2012-09-09 00:00:00"),
            131: pd.Timestamp("2012-09-10 00:00:00"),
            132: pd.Timestamp("2012-09-11 00:00:00"),
            133: pd.Timestamp("2012-09-12 00:00:00"),
            134: pd.Timestamp("2012-09-13 00:00:00"),
            135: pd.Timestamp("2012-09-14 00:00:00"),
            136: pd.Timestamp("2012-09-15 00:00:00"),
            137: pd.Timestamp("2012-09-16 00:00:00"),
            138: pd.Timestamp("2012-09-17 00:00:00"),
            139: pd.Timestamp("2012-09-18 00:00:00"),
            140: pd.Timestamp("2012-09-19 00:00:00"),
            141: pd.Timestamp("2012-09-20 00:00:00"),
            142: pd.Timestamp("2012-09-21 00:00:00"),
            143: pd.Timestamp("2012-09-22 00:00:00"),
            144: pd.Timestamp("2012-09-23 00:00:00"),
            145: pd.Timestamp("2012-09-24 00:00:00"),
            146: pd.Timestamp("2012-09-25 00:00:00"),
            147: pd.Timestamp("2012-09-26 00:00:00"),
            148: pd.Timestamp("2012-09-27 00:00:00"),
            149: pd.Timestamp("2012-09-28 00:00:00"),
            150: pd.Timestamp("2012-09-29 00:00:00"),
            151: pd.Timestamp("2012-09-30 00:00:00"),
            152: pd.Timestamp("2012-10-01 00:00:00"),
            153: pd.Timestamp("2012-10-02 00:00:00"),
            154: pd.Timestamp("2012-10-03 00:00:00"),
            155: pd.Timestamp("2012-10-04 00:00:00"),
            156: pd.Timestamp("2012-10-05 00:00:00"),
            157: pd.Timestamp("2012-10-06 00:00:00"),
            158: pd.Timestamp("2012-10-07 00:00:00"),
            159: pd.Timestamp("2012-10-08 00:00:00"),
            160: pd.Timestamp("2012-10-09 00:00:00"),
            161: pd.Timestamp("2012-10-10 00:00:00"),
            162: pd.Timestamp("2012-10-11 00:00:00"),
            163: pd.Timestamp("2012-10-12 00:00:00"),
            164: pd.Timestamp("2012-10-13 00:00:00"),
            165: pd.Timestamp("2012-10-14 00:00:00"),
            166: pd.Timestamp("2012-10-15 00:00:00"),
            167: pd.Timestamp("2012-10-16 00:00:00"),
            168: pd.Timestamp("2012-10-17 00:00:00"),
            169: pd.Timestamp("2012-10-18 00:00:00"),
            170: pd.Timestamp("2012-10-19 00:00:00"),
            171: pd.Timestamp("2012-10-20 00:00:00"),
            172: pd.Timestamp("2012-10-21 00:00:00"),
            173: pd.Timestamp("2012-10-22 00:00:00"),
            174: pd.Timestamp("2012-10-23 00:00:00"),
            175: pd.Timestamp("2012-10-24 00:00:00"),
            176: pd.Timestamp("2012-10-25 00:00:00"),
            177: pd.Timestamp("2012-10-26 00:00:00"),
            178: pd.Timestamp("2012-10-27 00:00:00"),
            179: pd.Timestamp("2012-10-28 00:00:00"),
            180: pd.Timestamp("2012-10-29 00:00:00"),
            181: pd.Timestamp("2012-10-30 00:00:00"),
            182: pd.Timestamp("2012-10-31 00:00:00"),
            183: pd.Timestamp("2012-11-01 00:00:00"),
            184: pd.Timestamp("2012-11-02 00:00:00"),
            185: pd.Timestamp("2012-11-03 00:00:00"),
            186: pd.Timestamp("2012-11-04 00:00:00"),
            187: pd.Timestamp("2012-11-05 00:00:00"),
            188: pd.Timestamp("2012-11-06 00:00:00"),
            189: pd.Timestamp("2012-11-07 00:00:00"),
            190: pd.Timestamp("2012-11-08 00:00:00"),
            191: pd.Timestamp("2012-11-09 00:00:00"),
            192: pd.Timestamp("2012-11-10 00:00:00"),
            193: pd.Timestamp("2012-11-11 00:00:00"),
            194: pd.Timestamp("2012-11-12 00:00:00"),
            195: pd.Timestamp("2012-11-13 00:00:00"),
            196: pd.Timestamp("2012-11-14 00:00:00"),
            197: pd.Timestamp("2012-11-15 00:00:00"),
            198: pd.Timestamp("2012-11-16 00:00:00"),
            199: pd.Timestamp("2012-11-17 00:00:00"),
            200: pd.Timestamp("2012-11-18 00:00:00"),
            201: pd.Timestamp("2012-11-19 00:00:00"),
            202: pd.Timestamp("2012-11-20 00:00:00"),
            203: pd.Timestamp("2012-11-21 00:00:00"),
            204: pd.Timestamp("2012-11-22 00:00:00"),
            205: pd.Timestamp("2012-11-23 00:00:00"),
            206: pd.Timestamp("2012-11-24 00:00:00"),
            207: pd.Timestamp("2012-11-25 00:00:00"),
            208: pd.Timestamp("2012-11-26 00:00:00"),
            209: pd.Timestamp("2012-11-27 00:00:00"),
            210: pd.Timestamp("2012-11-28 00:00:00"),
            211: pd.Timestamp("2012-11-29 00:00:00"),
            212: pd.Timestamp("2012-11-30 00:00:00"),
            213: pd.Timestamp("2012-12-01 00:00:00"),
            214: pd.Timestamp("2012-12-02 00:00:00"),
            215: pd.Timestamp("2012-12-03 00:00:00"),
            216: pd.Timestamp("2012-12-04 00:00:00"),
            217: pd.Timestamp("2012-12-05 00:00:00"),
            218: pd.Timestamp("2012-12-06 00:00:00"),
            219: pd.Timestamp("2012-12-07 00:00:00"),
            220: pd.Timestamp("2012-12-08 00:00:00"),
            221: pd.Timestamp("2012-12-09 00:00:00"),
            222: pd.Timestamp("2012-12-10 00:00:00"),
            223: pd.Timestamp("2012-12-11 00:00:00"),
            224: pd.Timestamp("2012-12-12 00:00:00"),
            225: pd.Timestamp("2012-12-13 00:00:00"),
            226: pd.Timestamp("2012-12-14 00:00:00"),
            227: pd.Timestamp("2012-12-15 00:00:00"),
            228: pd.Timestamp("2012-12-16 00:00:00"),
            229: pd.Timestamp("2012-12-17 00:00:00"),
            230: pd.Timestamp("2012-12-18 00:00:00"),
            231: pd.Timestamp("2012-12-19 00:00:00"),
            232: pd.Timestamp("2012-12-20 00:00:00"),
            233: pd.Timestamp("2012-12-21 00:00:00"),
            234: pd.Timestamp("2012-12-22 00:00:00"),
            235: pd.Timestamp("2012-12-23 00:00:00"),
            236: pd.Timestamp("2012-12-24 00:00:00"),
            237: pd.Timestamp("2012-12-25 00:00:00"),
            238: pd.Timestamp("2012-12-26 00:00:00"),
            239: pd.Timestamp("2012-12-27 00:00:00"),
            240: pd.Timestamp("2012-12-28 00:00:00"),
            241: pd.Timestamp("2012-12-29 00:00:00"),
            242: pd.Timestamp("2012-12-30 00:00:00"),
            243: pd.Timestamp("2012-12-31 00:00:00"),
            244: pd.Timestamp("2013-01-01 00:00:00"),
            245: pd.Timestamp("2013-01-02 00:00:00"),
            246: pd.Timestamp("2013-01-03 00:00:00"),
            247: pd.Timestamp("2013-01-04 00:00:00"),
            248: pd.Timestamp("2013-01-05 00:00:00"),
            249: pd.Timestamp("2013-01-06 00:00:00"),
            250: pd.Timestamp("2013-01-07 00:00:00"),
            251: pd.Timestamp("2013-01-08 00:00:00"),
            252: pd.Timestamp("2013-01-09 00:00:00"),
            253: pd.Timestamp("2013-01-10 00:00:00"),
            254: pd.Timestamp("2013-01-11 00:00:00"),
            255: pd.Timestamp("2013-01-12 00:00:00"),
            256: pd.Timestamp("2013-01-13 00:00:00"),
            257: pd.Timestamp("2013-01-14 00:00:00"),
            258: pd.Timestamp("2013-01-15 00:00:00"),
            259: pd.Timestamp("2013-01-16 00:00:00"),
            260: pd.Timestamp("2013-01-17 00:00:00"),
            261: pd.Timestamp("2013-01-18 00:00:00"),
            262: pd.Timestamp("2013-01-19 00:00:00"),
            263: pd.Timestamp("2013-01-20 00:00:00"),
            264: pd.Timestamp("2013-01-21 00:00:00"),
            265: pd.Timestamp("2013-01-22 00:00:00"),
            266: pd.Timestamp("2013-01-23 00:00:00"),
            267: pd.Timestamp("2013-01-24 00:00:00"),
            268: pd.Timestamp("2013-01-25 00:00:00"),
            269: pd.Timestamp("2013-01-26 00:00:00"),
            270: pd.Timestamp("2013-01-27 00:00:00"),
            271: pd.Timestamp("2013-01-28 00:00:00"),
            272: pd.Timestamp("2013-01-29 00:00:00"),
            273: pd.Timestamp("2013-01-30 00:00:00"),
            274: pd.Timestamp("2013-01-31 00:00:00"),
            275: pd.Timestamp("2013-02-01 00:00:00"),
            276: pd.Timestamp("2013-02-02 00:00:00"),
            277: pd.Timestamp("2013-02-03 00:00:00"),
            278: pd.Timestamp("2013-02-04 00:00:00"),
            279: pd.Timestamp("2013-02-05 00:00:00"),
            280: pd.Timestamp("2013-02-06 00:00:00"),
            281: pd.Timestamp("2013-02-07 00:00:00"),
            282: pd.Timestamp("2013-02-08 00:00:00"),
            283: pd.Timestamp("2013-02-09 00:00:00"),
            284: pd.Timestamp("2013-02-10 00:00:00"),
            285: pd.Timestamp("2013-02-11 00:00:00"),
            286: pd.Timestamp("2013-02-12 00:00:00"),
            287: pd.Timestamp("2013-02-13 00:00:00"),
            288: pd.Timestamp("2013-02-14 00:00:00"),
            289: pd.Timestamp("2013-02-15 00:00:00"),
            290: pd.Timestamp("2013-02-16 00:00:00"),
            291: pd.Timestamp("2013-02-17 00:00:00"),
            292: pd.Timestamp("2013-02-18 00:00:00"),
            293: pd.Timestamp("2013-02-19 00:00:00"),
            294: pd.Timestamp("2013-02-20 00:00:00"),
            295: pd.Timestamp("2013-02-21 00:00:00"),
            296: pd.Timestamp("2013-02-22 00:00:00"),
            297: pd.Timestamp("2013-02-23 00:00:00"),
            298: pd.Timestamp("2013-02-24 00:00:00"),
            299: pd.Timestamp("2013-02-25 00:00:00"),
            300: pd.Timestamp("2013-02-26 00:00:00"),
            301: pd.Timestamp("2013-02-27 00:00:00"),
            302: pd.Timestamp("2013-02-28 00:00:00"),
            303: pd.Timestamp("2013-03-01 00:00:00"),
            304: pd.Timestamp("2013-03-02 00:00:00"),
            305: pd.Timestamp("2013-03-03 00:00:00"),
            306: pd.Timestamp("2013-03-04 00:00:00"),
            307: pd.Timestamp("2013-03-05 00:00:00"),
            308: pd.Timestamp("2013-03-06 00:00:00"),
            309: pd.Timestamp("2013-03-07 00:00:00"),
            310: pd.Timestamp("2013-03-08 00:00:00"),
            311: pd.Timestamp("2013-03-09 00:00:00"),
            312: pd.Timestamp("2013-03-10 00:00:00"),
            313: pd.Timestamp("2013-03-11 00:00:00"),
            314: pd.Timestamp("2013-03-12 00:00:00"),
            315: pd.Timestamp("2013-03-13 00:00:00"),
            316: pd.Timestamp("2013-03-14 00:00:00"),
            317: pd.Timestamp("2013-03-15 00:00:00"),
            318: pd.Timestamp("2013-03-16 00:00:00"),
            319: pd.Timestamp("2013-03-17 00:00:00"),
            320: pd.Timestamp("2013-03-18 00:00:00"),
            321: pd.Timestamp("2013-03-19 00:00:00"),
            322: pd.Timestamp("2013-03-20 00:00:00"),
            323: pd.Timestamp("2013-03-21 00:00:00"),
            324: pd.Timestamp("2013-03-22 00:00:00"),
            325: pd.Timestamp("2013-03-23 00:00:00"),
            326: pd.Timestamp("2013-03-24 00:00:00"),
            327: pd.Timestamp("2013-03-25 00:00:00"),
            328: pd.Timestamp("2013-03-26 00:00:00"),
            329: pd.Timestamp("2013-03-27 00:00:00"),
            330: pd.Timestamp("2013-03-28 00:00:00"),
            331: pd.Timestamp("2013-03-29 00:00:00"),
            332: pd.Timestamp("2013-03-30 00:00:00"),
            333: pd.Timestamp("2013-03-31 00:00:00"),
            334: pd.Timestamp("2013-04-01 00:00:00"),
            335: pd.Timestamp("2013-04-02 00:00:00"),
            336: pd.Timestamp("2013-04-03 00:00:00"),
            337: pd.Timestamp("2013-04-04 00:00:00"),
            338: pd.Timestamp("2013-04-05 00:00:00"),
            339: pd.Timestamp("2013-04-06 00:00:00"),
            340: pd.Timestamp("2013-04-07 00:00:00"),
            341: pd.Timestamp("2013-04-08 00:00:00"),
            342: pd.Timestamp("2013-04-09 00:00:00"),
            343: pd.Timestamp("2013-04-10 00:00:00"),
            344: pd.Timestamp("2013-04-11 00:00:00"),
            345: pd.Timestamp("2013-04-12 00:00:00"),
            346: pd.Timestamp("2013-04-13 00:00:00"),
            347: pd.Timestamp("2013-04-14 00:00:00"),
            348: pd.Timestamp("2013-04-15 00:00:00"),
            349: pd.Timestamp("2013-04-16 00:00:00"),
            350: pd.Timestamp("2013-04-17 00:00:00"),
            351: pd.Timestamp("2013-04-18 00:00:00"),
            352: pd.Timestamp("2013-04-19 00:00:00"),
            353: pd.Timestamp("2013-04-20 00:00:00"),
            354: pd.Timestamp("2013-04-21 00:00:00"),
            355: pd.Timestamp("2013-04-22 00:00:00"),
            356: pd.Timestamp("2013-04-23 00:00:00"),
            357: pd.Timestamp("2013-04-24 00:00:00"),
            358: pd.Timestamp("2013-04-25 00:00:00"),
            359: pd.Timestamp("2013-04-26 00:00:00"),
            360: pd.Timestamp("2013-04-27 00:00:00"),
            361: pd.Timestamp("2013-04-28 00:00:00"),
            362: pd.Timestamp("2013-04-29 00:00:00"),
            363: pd.Timestamp("2013-04-30 00:00:00"),
            364: pd.Timestamp("2013-05-01 00:00:00"),
            365: pd.Timestamp("2013-05-02 00:00:00"),
            366: pd.Timestamp("2013-05-03 00:00:00"),
            367: pd.Timestamp("2013-05-04 00:00:00"),
            368: pd.Timestamp("2013-05-05 00:00:00"),
            369: pd.Timestamp("2013-05-06 00:00:00"),
            370: pd.Timestamp("2013-05-07 00:00:00"),
            371: pd.Timestamp("2013-05-08 00:00:00"),
            372: pd.Timestamp("2013-05-09 00:00:00"),
            373: pd.Timestamp("2013-05-10 00:00:00"),
            374: pd.Timestamp("2013-05-11 00:00:00"),
            375: pd.Timestamp("2013-05-12 00:00:00"),
            376: pd.Timestamp("2013-05-13 00:00:00"),
            377: pd.Timestamp("2013-05-14 00:00:00"),
            378: pd.Timestamp("2013-05-15 00:00:00"),
            379: pd.Timestamp("2013-05-16 00:00:00"),
            380: pd.Timestamp("2013-05-17 00:00:00"),
            381: pd.Timestamp("2013-05-18 00:00:00"),
            382: pd.Timestamp("2013-05-19 00:00:00"),
            383: pd.Timestamp("2013-05-20 00:00:00"),
            384: pd.Timestamp("2013-05-21 00:00:00"),
            385: pd.Timestamp("2013-05-22 00:00:00"),
            386: pd.Timestamp("2013-05-23 00:00:00"),
            387: pd.Timestamp("2013-05-24 00:00:00"),
            388: pd.Timestamp("2013-05-25 00:00:00"),
            389: pd.Timestamp("2013-05-26 00:00:00"),
            390: pd.Timestamp("2013-05-27 00:00:00"),
            391: pd.Timestamp("2013-05-28 00:00:00"),
            392: pd.Timestamp("2013-05-29 00:00:00"),
            393: pd.Timestamp("2013-05-30 00:00:00"),
        },
        "fcst": {
            0: 8.242579885263305,
            1: 8.234246162620314,
            2: 8.223763267886602,
            3: 8.1790740643318,
            4: 8.150311907440315,
            5: 8.382947063270414,
            6: 8.487215019931037,
            7: 8.455382878666658,
            8: 8.392413806237709,
            9: 8.291487292989727,
            10: 8.193767610737689,
            11: 8.08160740237286,
            12: 8.020863794085573,
            13: 7.977233887907018,
            14: 7.956304610638055,
            15: 7.975187454208408,
            16: 7.969961589491025,
            17: 7.923131793725949,
            18: 7.820115824923375,
            19: 7.755039199528699,
            20: 7.8112884216692455,
            21: 7.926673465860681,
            22: 7.950313059660761,
            23: 7.913263352625058,
            24: 7.878184384140694,
            25: 7.785181516690582,
            26: 7.751486816239498,
            27: 7.729348581883333,
            28: 7.750251658809953,
            29: 7.764915875302327,
            30: 7.817160071430963,
            31: 7.816146666145827,
            32: 7.779476480026709,
            33: 7.759778223782158,
            34: 7.778696507078529,
            35: 7.814521771195689,
            36: 7.776691642112765,
            37: 7.7643913744999855,
            38: 7.791167812401593,
            39: 7.8258424566828495,
            40: 7.810311902025161,
            41: 7.769346890476398,
            42: 7.7876821906214335,
            43: 7.81305968111603,
            44: 7.792032229959039,
            45: 7.7736062208791,
            46: 7.719420440084201,
            47: 7.763934093374124,
            48: 7.772606051105608,
            49: 7.918166644398391,
            50: 7.979118872653005,
            51: 7.952208152638921,
            52: 7.945694250549281,
            53: 7.857980657596363,
            54: 7.779535835336176,
            55: 7.749254421601135,
            56: 7.754206742884676,
            57: 7.720788631888217,
            58: 7.690939952029288,
            59: 7.655769643835734,
            60: 7.583905879312095,
            61: 7.555998251185102,
            62: 7.54646012999133,
            63: 7.5687005106297,
            64: 7.593544388384365,
            65: 7.585314116726815,
            66: 7.609299022497691,
            67: 7.608624932128512,
            68: 7.602513889166113,
            69: 7.634799762558459,
            70: 7.668969382581229,
            71: 7.747082554334517,
            72: 7.956359837472911,
            73: 8.059897766110092,
            74: 8.135171700175793,
            75: 8.110389586485248,
            76: 8.07508052322681,
            77: 8.056611566198502,
            78: 8.0417151322158,
            79: 8.017227648890525,
            80: 8.010429508458733,
            81: 7.957924183779159,
            82: 7.923383141265422,
            83: 7.953449700001349,
            84: 7.958649245394266,
            85: 7.996553552875673,
            86: 8.126970355919665,
            87: 8.312293686031653,
            88: 8.30615196075756,
            89: 8.301023260191707,
            90: 8.269154594624652,
            91: 8.186988931669246,
            92: 8.112308951461957,
            93: 8.103012729453773,
            94: 8.097739873720247,
            95: 8.1030985835923,
            96: 8.10542034935462,
            97: 8.114442195153027,
            98: 8.102911360417396,
            99: 8.066316821222165,
            100: 8.106860615821038,
            101: 8.315342507868639,
            102: 8.395676213390722,
            103: 8.489414787689967,
            104: 8.462751380868484,
            105: 8.486209859443242,
            106: 8.462627013817048,
            107: 8.384812345268218,
            108: 8.386180648624423,
            109: 8.374375850071619,
            110: 8.502512926993068,
            111: 8.61953663379448,
            112: 8.563654241642512,
            113: 8.480227301399967,
            114: 8.458346588583973,
            115: 8.42426877227707,
            116: 8.49770280528173,
            117: 8.716544975895879,
            118: 8.815949623313077,
            119: 8.76352605673622,
            120: 8.694376926534346,
            121: 8.618330346800276,
            122: 8.60607883344123,
            123: 8.575131167156163,
            124: 8.665735666951663,
            125: 8.641270282677825,
            126: 8.60139913593804,
            127: 8.634378959793835,
            128: 8.9537421724968,
            129: 8.892946999644026,
            130: 8.867015813872227,
            131: 9.092046521321246,
            132: 9.676137517746005,
            133: 9.665144748530812,
            134: 9.460899145826776,
            135: 9.280381713024724,
            136: 9.215694845316344,
            137: 9.1070082424475,
            138: 9.26912605754045,
            139: 9.34866143030612,
            140: 9.63653757490844,
            141: 9.432545065201737,
            142: 9.230683866287496,
            143: 9.27107949394482,
            144: 9.082856860793797,
            145: 9.190914209886325,
            146: 9.287018991540258,
            147: 9.14585197569593,
            148: 8.920165790784438,
            149: 8.76302965062865,
            150: 8.704674639643034,
            151: 8.616451612263868,
            152: 8.765264292298232,
            153: 9.016320648334693,
            154: 8.973918554372162,
            155: 8.863690858814591,
            156: 8.810533814960449,
            157: 8.86418606195452,
            158: 8.79145787810355,
            159: 9.029140631069012,
            160: 9.231241825453578,
            161: 9.158344315944412,
            162: 8.967047831541633,
            163: 8.797957022464919,
            164: 8.706236134823559,
            165: 8.598689189776595,
            166: 8.699848048177786,
            167: 8.793436772424402,
            168: 9.265430111382035,
            169: 9.152764524995291,
            170: 8.997035021975641,
            171: 8.879511754277779,
            172: 8.733913095567887,
            173: 8.921334023806068,
            174: 8.962043301946881,
            175: 8.89429141138464,
            176: 8.768104943676944,
            177: 8.669152503152226,
            178: 8.628773878755858,
            179: 8.60666164170078,
            180: 8.748612117139842,
            181: 9.141191248238277,
            182: 9.080018186641873,
            183: 8.98783804221945,
            184: 8.874482158768794,
            185: 8.803632234121178,
            186: 8.723778572217173,
            187: 8.953999046941902,
            188: 9.12370283780407,
            189: 9.055730001477137,
            190: 8.901138538315905,
            191: 8.807902186874017,
            192: 8.817003998693355,
            193: 8.692902106481021,
            194: 8.825334312069993,
            195: 8.891640679476948,
            196: 8.848851990195193,
            197: 8.729152290254357,
            198: 8.645216189546908,
            199: 8.559945802467329,
            200: 8.460283592783728,
            201: 8.626715009777975,
            202: 8.871859552459812,
            203: 8.821702693958693,
            204: 8.699658152466434,
            205: 8.688682028258807,
            206: 8.744481638288669,
            207: 8.663786053111279,
            208: 8.849867587447859,
            209: 9.090627531265815,
            210: 9.03473938390778,
            211: 8.937405430613119,
            212: 8.831871185808987,
            213: 8.812707903483961,
            214: 8.775882325046888,
            215: 8.908400443954031,
            216: 9.086306214243852,
            217: 9.215167130362659,
            218: 9.10259108914144,
            219: 9.027661029537049,
            220: 9.243646150753554,
            221: 9.126528388710815,
            222: 9.155723724647906,
            223: 9.18131189432787,
            224: 9.238263272794136,
            225: 9.135178756205269,
            226: 9.035124339181849,
            227: 8.897215534300676,
            228: 8.756877219176914,
            229: 8.885688404512115,
            230: 8.99270393990446,
            231: 8.946118717737555,
            232: 8.847231831364363,
            233: 8.746686937249402,
            234: 8.642529831218887,
            235: 8.5429867608993,
            236: 8.708189607404023,
            237: 8.926758653939324,
            238: 8.859781775114273,
            239: 8.801435763979596,
            240: 8.839381006273712,
            241: 8.803343890079915,
            242: 8.740679118212908,
            243: 8.914197685681229,
            244: 9.19865271455247,
            245: 9.17850424293023,
            246: 9.156857387138363,
            247: 9.133296369081393,
            248: 9.180287588919855,
            249: 9.194021199480641,
            250: 9.411348134227241,
            251: 9.429840787586373,
            252: 9.356321785245436,
            253: 9.288547063237075,
            254: 9.215486094145184,
            255: 9.199278960487977,
            256: 9.510108719899028,
            257: 9.972542148818576,
            258: 10.023620538341127,
            259: 9.851450952730296,
            260: 9.618754426484847,
            261: 9.413601526621555,
            262: 9.23798224568013,
            263: 9.056585565021482,
            264: 9.035074626152367,
            265: 9.263353881800612,
            266: 9.203691354057684,
            267: 9.124335301230126,
            268: 8.999522630598229,
            269: 8.892258492349137,
            270: 8.791837312207486,
            271: 8.732246465398882,
            272: 9.049881106387447,
            273: 8.957458298196094,
            274: 8.854369274655133,
            275: 8.768969131568703,
            276: 8.724736278700766,
            277: 8.68424817848234,
            278: 8.897701147177841,
            279: 9.158965100280913,
            280: 9.09212090277464,
            281: 8.96150274956003,
            282: 8.827670239748846,
            283: 8.682548201453692,
            284: 8.546023707052358,
            285: 8.428601209663489,
            286: 8.349378438441327,
            287: 8.276958982688196,
            288: 8.20710169088123,
            289: 8.12273016398342,
            290: 8.069676335977373,
            291: 8.011322451573655,
            292: 7.967686920846926,
            293: 7.967592753475348,
            294: 7.976646913336884,
            295: 7.9615236000132565,
            296: 7.936088661035004,
            297: 7.921268220362522,
            298: 7.882455749585298,
            299: 7.836265339869824,
            300: 7.838020996857391,
            301: 7.9198485855267435,
            302: 7.933383579107693,
            303: 7.931060228258055,
            304: 7.917227356436718,
            305: 7.8770537031961805,
            306: 7.854267047948764,
            307: 7.849848955069623,
            308: 7.847185212242471,
            309: 7.8469568453401815,
            310: 7.863970897792964,
            311: 7.839415195747365,
            312: 7.780814052961874,
            313: 7.719227414276968,
            314: 7.728182184689131,
            315: 7.745604449526769,
            316: 7.822790543076573,
            317: 7.951952410024676,
            318: 7.977967790120488,
            319: 7.948995848317893,
            320: 7.938570620743333,
            321: 7.9168224501842355,
            322: 7.910487400654833,
            323: 7.983418662074753,
            324: 8.112441693503282,
            325: 8.090874123164395,
            326: 8.030760016884841,
            327: 8.123921976751454,
            328: 8.117505802917965,
            329: 8.059356581925206,
            330: 7.994460731871406,
            331: 7.943326596544797,
            332: 7.903835966835926,
            333: 7.872413283904773,
            334: 7.781792923131236,
            335: 7.772974545699119,
            336: 7.732092882489853,
            337: 7.720180107121238,
            338: 7.678117047355551,
            339: 7.6253226594833885,
            340: 7.583130141041468,
            341: 7.5751256597964085,
            342: 7.590284921167221,
            343: 7.610239013970302,
            344: 7.600308508048267,
            345: 7.710630071068845,
            346: 7.70844689799236,
            347: 7.629706542482938,
            348: 7.568757244568193,
            349: 7.5497395873664175,
            350: 7.555366687259776,
            351: 7.558498865452193,
            352: 7.577284888529757,
            353: 7.641167522095327,
            354: 7.564933527923819,
            355: 7.558319202916154,
            356: 7.587065014848195,
            357: 7.6206037840551835,
            358: 7.711222601557103,
            359: 7.773533624826619,
            360: 7.865626921988621,
            361: 7.891635731711245,
            362: 7.869222043708437,
            363: 7.969937509766953,
            364: 7.990738547693687,
            365: 7.990918520796038,
            366: 7.991098493898388,
            367: 7.991278467000738,
            368: 7.991458440103089,
            369: 7.991638413205439,
            370: 7.991818386307789,
            371: 7.99199835941014,
            372: 7.9921783325124895,
            373: 7.9923583056148395,
            374: 7.9925382787171895,
            375: 7.99271825181954,
            376: 7.99289822492189,
            377: 7.99307819802424,
            378: 7.993258171126591,
            379: 7.993438144228941,
            380: 7.993618117331291,
            381: 7.993798090433641,
            382: 7.993978063535992,
            383: 7.994158036638342,
            384: 7.994338009740692,
            385: 7.994517982843043,
            386: 7.994697955945393,
            387: 7.9948779290477425,
            388: 7.9950579021500925,
            389: 7.995237875252443,
            390: 7.995417848354793,
            391: 7.995597821457143,
            392: 7.995777794559494,
            393: 7.995957767661844,
        },
        "fcst_lower": {
            0: 7.293809021845414,
            1: 7.285475299202423,
            2: 7.27499240446871,
            3: 7.230303200913909,
            4: 7.201541044022424,
            5: 7.434176199852523,
            6: 7.538444156513146,
            7: 7.506612015248766,
            8: 7.443642942819817,
            9: 7.342716429571835,
            10: 7.244996747319798,
            11: 7.132836538954969,
            12: 7.072092930667681,
            13: 7.028463024489127,
            14: 7.0075337472201635,
            15: 7.026416590790516,
            16: 7.021190726073134,
            17: 6.974360930308057,
            18: 6.871344961505484,
            19: 6.806268336110808,
            20: 6.862517558251354,
            21: 6.977902602442789,
            22: 7.00154219624287,
            23: 6.964492489207166,
            24: 6.929413520722803,
            25: 6.83641065327269,
            26: 6.802715952821607,
            27: 6.780577718465442,
            28: 6.801480795392061,
            29: 6.816145011884435,
            30: 6.868389208013071,
            31: 6.867375802727936,
            32: 6.830705616608817,
            33: 6.8110073603642665,
            34: 6.829925643660638,
            35: 6.865750907777797,
            36: 6.827920778694874,
            37: 6.815620511082094,
            38: 6.842396948983701,
            39: 6.877071593264958,
            40: 6.861541038607269,
            41: 6.8205760270585065,
            42: 6.838911327203542,
            43: 6.864288817698139,
            44: 6.843261366541148,
            45: 6.824835357461208,
            46: 6.770649576666309,
            47: 6.815163229956233,
            48: 6.823835187687717,
            49: 6.969395780980499,
            50: 7.030348009235113,
            51: 7.003437289221029,
            52: 6.99692338713139,
            53: 6.909209794178471,
            54: 6.830764971918285,
            55: 6.8004835581832435,
            56: 6.805435879466785,
            57: 6.7720177684703255,
            58: 6.742169088611396,
            59: 6.706998780417843,
            60: 6.635135015894203,
            61: 6.60722738776721,
            62: 6.597689266573439,
            63: 6.6199296472118085,
            64: 6.644773524966474,
            65: 6.636543253308924,
            66: 6.660528159079799,
            67: 6.6598540687106205,
            68: 6.653743025748222,
            69: 6.686028899140568,
            70: 6.720198519163337,
            71: 6.798311690916625,
            72: 7.00758897405502,
            73: 7.111126902692201,
            74: 7.186400836757901,
            75: 7.161618723067356,
            76: 7.126309659808918,
            77: 7.10784070278061,
            78: 7.092944268797908,
            79: 7.068456785472634,
            80: 7.061658645040842,
            81: 7.009153320361268,
            82: 6.97461227784753,
            83: 7.004678836583458,
            84: 7.009878381976375,
            85: 7.047782689457781,
            86: 7.178199492501774,
            87: 7.363522822613762,
            88: 7.357381097339669,
            89: 7.352252396773816,
            90: 7.320383731206761,
            91: 7.238218068251355,
            92: 7.163538088044065,
            93: 7.154241866035882,
            94: 7.1489690103023555,
            95: 7.154327720174409,
            96: 7.156649485936729,
            97: 7.165671331735135,
            98: 7.154140496999505,
            99: 7.117545957804273,
            100: 7.158089752403146,
            101: 7.366571644450747,
            102: 7.44690534997283,
            103: 7.540643924272075,
            104: 7.513980517450593,
            105: 7.537438996025351,
            106: 7.513856150399157,
            107: 7.436041481850326,
            108: 7.4374097852065315,
            109: 7.4256049866537275,
            110: 7.553742063575177,
            111: 7.670765770376589,
            112: 7.61488337822462,
            113: 7.531456437982076,
            114: 7.509575725166082,
            115: 7.475497908859179,
            116: 7.548931941863838,
            117: 7.767774112477987,
            118: 7.867178759895186,
            119: 7.814755193318328,
            120: 7.745606063116455,
            121: 7.669559483382384,
            122: 7.657307970023339,
            123: 7.626360303738272,
            124: 7.716964803533772,
            125: 7.692499419259933,
            126: 7.652628272520149,
            127: 7.685608096375944,
            128: 8.004971309078908,
            129: 7.944176136226135,
            130: 7.918244950454335,
            131: 8.143275657903354,
            132: 8.727366654328113,
            133: 8.71637388511292,
            134: 8.512128282408884,
            135: 8.331610849606832,
            136: 8.266923981898453,
            137: 8.15823737902961,
            138: 8.320355194122559,
            139: 8.399890566888228,
            140: 8.687766711490548,
            141: 8.483774201783845,
            142: 8.281913002869604,
            143: 8.322308630526928,
            144: 8.134085997375905,
            145: 8.242143346468433,
            146: 8.338248128122366,
            147: 8.197081112278038,
            148: 7.971394927366546,
            149: 7.814258787210758,
            150: 7.755903776225143,
            151: 7.667680748845976,
            152: 7.8164934288803405,
            153: 8.067549784916801,
            154: 8.02514769095427,
            155: 7.9149199953966995,
            156: 7.861762951542557,
            157: 7.915415198536628,
            158: 7.842687014685659,
            159: 8.08036976765112,
            160: 8.282470962035687,
            161: 8.20957345252652,
            162: 8.018276968123741,
            163: 7.8491861590470275,
            164: 7.7574652714056676,
            165: 7.649918326358703,
            166: 7.751077184759895,
            167: 7.84466590900651,
            168: 8.316659247964143,
            169: 8.2039936615774,
            170: 8.04826415855775,
            171: 7.930740890859887,
            172: 7.785142232149996,
            173: 7.972563160388177,
            174: 8.01327243852899,
            175: 7.945520547966748,
            176: 7.819334080259052,
            177: 7.7203816397343346,
            178: 7.680003015337967,
            179: 7.657890778282889,
            180: 7.799841253721951,
            181: 8.192420384820386,
            182: 8.131247323223981,
            183: 8.039067178801558,
            184: 7.925711295350903,
            185: 7.854861370703286,
            186: 7.775007708799281,
            187: 8.00522818352401,
            188: 8.174931974386178,
            189: 8.106959138059246,
            190: 7.952367674898014,
            191: 7.8591313234561255,
            192: 7.868233135275464,
            193: 7.74413124306313,
            194: 7.876563448652101,
            195: 7.942869816059057,
            196: 7.900081126777302,
            197: 7.780381426836465,
            198: 7.696445326129016,
            199: 7.611174939049437,
            200: 7.511512729365837,
            201: 7.677944146360083,
            202: 7.92308868904192,
            203: 7.872931830540802,
            204: 7.750887289048542,
            205: 7.739911164840915,
            206: 7.795710774870777,
            207: 7.715015189693387,
            208: 7.901096724029967,
            209: 8.141856667847923,
            210: 8.085968520489889,
            211: 7.988634567195227,
            212: 7.883100322391096,
            213: 7.8639370400660695,
            214: 7.827111461628997,
            215: 7.95962958053614,
            216: 8.13753535082596,
            217: 8.266396266944767,
            218: 8.153820225723548,
            219: 8.078890166119157,
            220: 8.294875287335662,
            221: 8.177757525292924,
            222: 8.206952861230015,
            223: 8.232541030909978,
            224: 8.289492409376244,
            225: 8.186407892787377,
            226: 8.086353475763957,
            227: 7.948444670882784,
            228: 7.808106355759023,
            229: 7.936917541094223,
            230: 8.043933076486569,
            231: 7.997347854319663,
            232: 7.8984609679464715,
            233: 7.7979160738315105,
            234: 7.693758967800996,
            235: 7.5942158974814085,
            236: 7.7594187439861315,
            237: 7.977987790521432,
            238: 7.911010911696382,
            239: 7.852664900561704,
            240: 7.89061014285582,
            241: 7.854573026662024,
            242: 7.7919082547950165,
            243: 7.965426822263337,
            244: 8.249881851134578,
            245: 8.22973337951234,
            246: 8.208086523720471,
            247: 8.184525505663501,
            248: 8.231516725501963,
            249: 8.24525033606275,
            250: 8.46257727080935,
            251: 8.481069924168482,
            252: 8.407550921827545,
            253: 8.339776199819184,
            254: 8.266715230727293,
            255: 8.250508097070085,
            256: 8.561337856481137,
            257: 9.023771285400684,
            258: 9.074849674923236,
            259: 8.902680089312405,
            260: 8.669983563066955,
            261: 8.464830663203664,
            262: 8.289211382262238,
            263: 8.10781470160359,
            264: 8.086303762734476,
            265: 8.31458301838272,
            266: 8.254920490639792,
            267: 8.175564437812234,
            268: 8.050751767180337,
            269: 7.943487628931246,
            270: 7.843066448789594,
            271: 7.7834756019809905,
            272: 8.101110242969556,
            273: 8.008687434778203,
            274: 7.905598411237241,
            275: 7.820198268150811,
            276: 7.775965415282874,
            277: 7.735477315064449,
            278: 7.94893028375995,
            279: 8.210194236863021,
            280: 8.143350039356749,
            281: 8.012731886142138,
            282: 7.8788993763309545,
            283: 7.7337773380358,
            284: 7.597252843634466,
            285: 7.479830346245597,
            286: 7.400607575023436,
            287: 7.328188119270305,
            288: 7.258330827463338,
            289: 7.173959300565528,
            290: 7.120905472559482,
            291: 7.062551588155763,
            292: 7.018916057429035,
            293: 7.018821890057456,
            294: 7.0278760499189925,
            295: 7.012752736595365,
            296: 6.987317797617113,
            297: 6.972497356944631,
            298: 6.9336848861674065,
            299: 6.887494476451932,
            300: 6.889250133439499,
            301: 6.971077722108852,
            302: 6.984612715689802,
            303: 6.982289364840163,
            304: 6.968456493018826,
            305: 6.928282839778289,
            306: 6.905496184530873,
            307: 6.901078091651732,
            308: 6.89841434882458,
            309: 6.89818598192229,
            310: 6.915200034375072,
            311: 6.890644332329473,
            312: 6.832043189543983,
            313: 6.770456550859077,
            314: 6.7794113212712395,
            315: 6.796833586108877,
            316: 6.874019679658682,
            317: 7.003181546606784,
            318: 7.029196926702596,
            319: 7.000224984900002,
            320: 6.989799757325441,
            321: 6.968051586766344,
            322: 6.961716537236941,
            323: 7.034647798656861,
            324: 7.16367083008539,
            325: 7.142103259746504,
            326: 7.0819891534669495,
            327: 7.175151113333563,
            328: 7.168734939500073,
            329: 7.1105857185073145,
            330: 7.045689868453515,
            331: 6.994555733126905,
            332: 6.955065103418034,
            333: 6.923642420486882,
            334: 6.833022059713344,
            335: 6.824203682281228,
            336: 6.783322019071962,
            337: 6.771409243703347,
            338: 6.729346183937659,
            339: 6.676551796065497,
            340: 6.6343592776235765,
            341: 6.626354796378517,
            342: 6.64151405774933,
            343: 6.661468150552411,
            344: 6.651537644630375,
            345: 6.761859207650954,
            346: 6.759676034574468,
            347: 6.680935679065047,
            348: 6.6199863811503015,
            349: 6.600968723948526,
            350: 6.606595823841884,
            351: 6.609728002034301,
            352: 6.6285140251118655,
            353: 6.692396658677436,
            354: 6.616162664505928,
            355: 6.609548339498263,
            356: 6.638294151430303,
            357: 6.671832920637292,
            358: 6.7624517381392115,
            359: 6.824762761408728,
            360: 6.91685605857073,
            361: 6.942864868293354,
            362: 6.920451180290545,
            363: 7.021166646349061,
            364: 7.041967684275796,
            365: 7.017052582945252,
            366: 6.992768098417386,
            367: 6.969068952186619,
            368: 6.9459150379376045,
            369: 6.923270630348319,
            370: 6.90110374302005,
            371: 6.879385602554656,
            372: 6.858090214087461,
            373: 6.8371939995578686,
            374: 6.816675494365484,
            375: 6.796515091290942,
            376: 6.7766948229804775,
            377: 6.757198176125218,
            378: 6.738009931866966,
            379: 6.719116028043378,
            380: 6.700503439727285,
            381: 6.682160075175554,
            382: 6.664074684825556,
            383: 6.646236781393549,
            384: 6.628636569463221,
            385: 6.611264883222001,
            386: 6.594113131221635,
            387: 6.577173247218081,
            388: 6.560437646292465,
            389: 6.5438991855758175,
            390: 6.527551129000639,
            391: 6.511387115585909,
            392: 6.495401130831999,
            393: 6.479587480860724,
        },
        "fcst_upper": {
            0: 9.191350748681197,
            1: 9.183017026038206,
            2: 9.172534131304493,
            3: 9.127844927749692,
            4: 9.099082770858207,
            5: 9.331717926688306,
            6: 9.435985883348929,
            7: 9.40415374208455,
            8: 9.3411846696556,
            9: 9.240258156407618,
            10: 9.14253847415558,
            11: 9.030378265790752,
            12: 8.969634657503464,
            13: 8.926004751324909,
            14: 8.905075474055947,
            15: 8.9239583176263,
            16: 8.918732452908916,
            17: 8.87190265714384,
            18: 8.768886688341267,
            19: 8.70381006294659,
            20: 8.760059285087136,
            21: 8.875444329278572,
            22: 8.899083923078653,
            23: 8.862034216042948,
            24: 8.826955247558585,
            25: 8.733952380108473,
            26: 8.700257679657389,
            27: 8.678119445301224,
            28: 8.699022522227844,
            29: 8.713686738720218,
            30: 8.765930934848853,
            31: 8.764917529563718,
            32: 8.7282473434446,
            33: 8.70854908720005,
            34: 8.72746737049642,
            35: 8.76329263461358,
            36: 8.725462505530656,
            37: 8.713162237917876,
            38: 8.739938675819484,
            39: 8.774613320100741,
            40: 8.759082765443052,
            41: 8.718117753894289,
            42: 8.736453054039325,
            43: 8.761830544533922,
            44: 8.74080309337693,
            45: 8.72237708429699,
            46: 8.668191303502091,
            47: 8.712704956792015,
            48: 8.7213769145235,
            49: 8.866937507816282,
            50: 8.927889736070895,
            51: 8.900979016056812,
            52: 8.894465113967172,
            53: 8.806751521014254,
            54: 8.728306698754068,
            55: 8.698025285019026,
            56: 8.702977606302568,
            57: 8.669559495306109,
            58: 8.63971081544718,
            59: 8.604540507253626,
            60: 8.532676742729986,
            61: 8.504769114602993,
            62: 8.495230993409221,
            63: 8.517471374047592,
            64: 8.542315251802256,
            65: 8.534084980144707,
            66: 8.558069885915582,
            67: 8.557395795546404,
            68: 8.551284752584005,
            69: 8.58357062597635,
            70: 8.61774024599912,
            71: 8.695853417752408,
            72: 8.905130700890803,
            73: 9.008668629527984,
            74: 9.083942563593684,
            75: 9.059160449903139,
            76: 9.0238513866447,
            77: 9.005382429616393,
            78: 8.99048599563369,
            79: 8.965998512308417,
            80: 8.959200371876625,
            81: 8.90669504719705,
            82: 8.872154004683313,
            83: 8.90222056341924,
            84: 8.907420108812158,
            85: 8.945324416293564,
            86: 9.075741219337557,
            87: 9.261064549449545,
            88: 9.254922824175452,
            89: 9.249794123609599,
            90: 9.217925458042544,
            91: 9.135759795087138,
            92: 9.061079814879848,
            93: 9.051783592871665,
            94: 9.046510737138139,
            95: 9.051869447010192,
            96: 9.054191212772512,
            97: 9.063213058570918,
            98: 9.051682223835288,
            99: 9.015087684640056,
            100: 9.05563147923893,
            101: 9.26411337128653,
            102: 9.344447076808613,
            103: 9.438185651107858,
            104: 9.411522244286376,
            105: 9.434980722861134,
            106: 9.41139787723494,
            107: 9.33358320868611,
            108: 9.334951512042315,
            109: 9.32314671348951,
            110: 9.45128379041096,
            111: 9.568307497212372,
            112: 9.512425105060403,
            113: 9.428998164817859,
            114: 9.407117452001865,
            115: 9.373039635694962,
            116: 9.446473668699621,
            117: 9.66531583931377,
            118: 9.764720486730969,
            119: 9.712296920154111,
            120: 9.643147789952238,
            121: 9.567101210218167,
            122: 9.554849696859122,
            123: 9.523902030574055,
            124: 9.614506530369555,
            125: 9.590041146095716,
            126: 9.550169999355932,
            127: 9.583149823211727,
            128: 9.90251303591469,
            129: 9.841717863061918,
            130: 9.815786677290118,
            131: 10.040817384739137,
            132: 10.624908381163896,
            133: 10.613915611948704,
            134: 10.409670009244667,
            135: 10.229152576442615,
            136: 10.164465708734236,
            137: 10.055779105865392,
            138: 10.217896920958342,
            139: 10.297432293724011,
            140: 10.585308438326331,
            141: 10.381315928619628,
            142: 10.179454729705387,
            143: 10.219850357362711,
            144: 10.031627724211688,
            145: 10.139685073304216,
            146: 10.23578985495815,
            147: 10.094622839113821,
            148: 9.86893665420233,
            149: 9.71180051404654,
            150: 9.653445503060926,
            151: 9.56522247568176,
            152: 9.714035155716124,
            153: 9.965091511752584,
            154: 9.922689417790053,
            155: 9.812461722232483,
            156: 9.75930467837834,
            157: 9.812956925372411,
            158: 9.740228741521442,
            159: 9.977911494486904,
            160: 10.18001268887147,
            161: 10.107115179362303,
            162: 9.915818694959524,
            163: 9.74672788588281,
            164: 9.65500699824145,
            165: 9.547460053194486,
            166: 9.648618911595678,
            167: 9.742207635842293,
            168: 10.214200974799926,
            169: 10.101535388413183,
            170: 9.945805885393533,
            171: 9.82828261769567,
            172: 9.682683958985779,
            173: 9.87010488722396,
            174: 9.910814165364773,
            175: 9.84306227480253,
            176: 9.716875807094835,
            177: 9.617923366570118,
            178: 9.57754474217375,
            179: 9.555432505118672,
            180: 9.697382980557734,
            181: 10.089962111656169,
            182: 10.028789050059764,
            183: 9.93660890563734,
            184: 9.823253022186686,
            185: 9.75240309753907,
            186: 9.672549435635064,
            187: 9.902769910359794,
            188: 10.072473701221961,
            189: 10.004500864895029,
            190: 9.849909401733797,
            191: 9.756673050291909,
            192: 9.765774862111247,
            193: 9.641672969898913,
            194: 9.774105175487884,
            195: 9.84041154289484,
            196: 9.797622853613085,
            197: 9.677923153672248,
            198: 9.593987052964799,
            199: 9.50871666588522,
            200: 9.40905445620162,
            201: 9.575485873195866,
            202: 9.820630415877703,
            203: 9.770473557376585,
            204: 9.648429015884325,
            205: 9.637452891676698,
            206: 9.69325250170656,
            207: 9.61255691652917,
            208: 9.79863845086575,
            209: 10.039398394683706,
            210: 9.983510247325672,
            211: 9.88617629403101,
            212: 9.780642049226879,
            213: 9.761478766901853,
            214: 9.72465318846478,
            215: 9.857171307371923,
            216: 10.035077077661743,
            217: 10.16393799378055,
            218: 10.051361952559331,
            219: 9.97643189295494,
            220: 10.192417014171445,
            221: 10.075299252128707,
            222: 10.104494588065798,
            223: 10.130082757745761,
            224: 10.187034136212027,
            225: 10.08394961962316,
            226: 9.98389520259974,
            227: 9.845986397718567,
            228: 9.705648082594806,
            229: 9.834459267930006,
            230: 9.941474803322352,
            231: 9.894889581155446,
            232: 9.796002694782254,
            233: 9.695457800667294,
            234: 9.591300694636779,
            235: 9.491757624317191,
            236: 9.656960470821915,
            237: 9.875529517357215,
            238: 9.808552638532165,
            239: 9.750206627397487,
            240: 9.788151869691603,
            241: 9.752114753497807,
            242: 9.6894499816308,
            243: 9.86296854909912,
            244: 10.147423577970361,
            245: 10.127275106348122,
            246: 10.105628250556254,
            247: 10.082067232499284,
            248: 10.129058452337746,
            249: 10.142792062898533,
            250: 10.360118997645133,
            251: 10.378611651004265,
            252: 10.305092648663328,
            253: 10.237317926654967,
            254: 10.164256957563076,
            255: 10.148049823905868,
            256: 10.45887958331692,
            257: 10.921313012236467,
            258: 10.972391401759019,
            259: 10.800221816148188,
            260: 10.567525289902738,
            261: 10.362372390039447,
            262: 10.18675310909802,
            263: 10.005356428439374,
            264: 9.983845489570259,
            265: 10.212124745218503,
            266: 10.152462217475575,
            267: 10.073106164648017,
            268: 9.94829349401612,
            269: 9.841029355767029,
            270: 9.740608175625377,
            271: 9.681017328816774,
            272: 9.998651969805339,
            273: 9.906229161613986,
            274: 9.803140138073024,
            275: 9.717739994986594,
            276: 9.673507142118657,
            277: 9.633019041900232,
            278: 9.846472010595733,
            279: 10.107735963698804,
            280: 10.040891766192532,
            281: 9.910273612977921,
            282: 9.776441103166738,
            283: 9.631319064871583,
            284: 9.49479457047025,
            285: 9.37737207308138,
            286: 9.298149301859219,
            287: 9.225729846106088,
            288: 9.15587255429912,
            289: 9.071501027401311,
            290: 9.018447199395265,
            291: 8.960093314991546,
            292: 8.916457784264818,
            293: 8.91636361689324,
            294: 8.925417776754776,
            295: 8.910294463431148,
            296: 8.884859524452896,
            297: 8.870039083780414,
            298: 8.831226613003189,
            299: 8.785036203287715,
            300: 8.786791860275281,
            301: 8.868619448944635,
            302: 8.882154442525584,
            303: 8.879831091675946,
            304: 8.865998219854609,
            305: 8.825824566614072,
            306: 8.803037911366655,
            307: 8.798619818487515,
            308: 8.795956075660362,
            309: 8.795727708758072,
            310: 8.812741761210855,
            311: 8.788186059165255,
            312: 8.729584916379766,
            313: 8.66799827769486,
            314: 8.676953048107022,
            315: 8.69437531294466,
            316: 8.771561406494465,
            317: 8.900723273442567,
            318: 8.92673865353838,
            319: 8.897766711735784,
            320: 8.887341484161224,
            321: 8.865593313602126,
            322: 8.859258264072723,
            323: 8.932189525492644,
            324: 9.061212556921173,
            325: 9.039644986582287,
            326: 8.979530880302732,
            327: 9.072692840169346,
            328: 9.066276666335856,
            329: 9.008127445343098,
            330: 8.943231595289298,
            331: 8.892097459962688,
            332: 8.852606830253817,
            333: 8.821184147322665,
            334: 8.730563786549126,
            335: 8.72174540911701,
            336: 8.680863745907745,
            337: 8.668950970539129,
            338: 8.626887910773442,
            339: 8.57409352290128,
            340: 8.531901004459359,
            341: 8.5238965232143,
            342: 8.539055784585113,
            343: 8.559009877388194,
            344: 8.549079371466158,
            345: 8.659400934486737,
            346: 8.657217761410251,
            347: 8.578477405900829,
            348: 8.517528107986085,
            349: 8.498510450784309,
            350: 8.504137550677667,
            351: 8.507269728870083,
            352: 8.526055751947649,
            353: 8.589938385513218,
            354: 8.51370439134171,
            355: 8.507090066334046,
            356: 8.535835878266086,
            357: 8.569374647473074,
            358: 8.659993464974994,
            359: 8.72230448824451,
            360: 8.814397785406513,
            361: 8.840406595129137,
            362: 8.817992907126328,
            363: 8.918708373184844,
            364: 8.939509411111578,
            365: 8.964784458646825,
            366: 8.98942888937939,
            367: 9.013487981814857,
            368: 9.037001842268573,
            369: 9.060006196062558,
            370: 9.082533029595528,
            371: 9.104611116265623,
            372: 9.126266450937518,
            373: 9.14752261167181,
            374: 9.168401063068895,
            375: 9.188921412348138,
            376: 9.209101626863303,
            377: 9.228958219923262,
            378: 9.248506410386216,
            379: 9.267760260414503,
            380: 9.286732794935297,
            381: 9.305436105691728,
            382: 9.323881442246428,
            383: 9.342079291883135,
            384: 9.360039450018162,
            385: 9.377771082464085,
            386: 9.39528278066915,
            387: 9.412582610877404,
            388: 9.42967815800772,
            389: 9.44657656492907,
            390: 9.463284567708946,
            391: 9.479808527328377,
            392: 9.49615445828699,
            393: 9.512328054462964,
        },
    }
)


# Holt Winters model
AIR_FCST_HW_1 = pd.DataFrame(
    [
        {"time": Timestamp("1949-01-01 00:00:00"), "fcst": 126.84753981623055},
        {"time": Timestamp("1949-02-01 00:00:00"), "fcst": 116.43521901797152},
        {"time": Timestamp("1949-03-01 00:00:00"), "fcst": 116.58612705161451},
        {"time": Timestamp("1949-04-01 00:00:00"), "fcst": 139.4030218435132},
        {"time": Timestamp("1949-05-01 00:00:00"), "fcst": 127.31785353777076},
        {"time": Timestamp("1949-06-01 00:00:00"), "fcst": 130.39730055826365},
        {"time": Timestamp("1949-07-01 00:00:00"), "fcst": 135.6463384943683},
        {"time": Timestamp("1949-08-01 00:00:00"), "fcst": 147.43830745237648},
        {"time": Timestamp("1949-09-01 00:00:00"), "fcst": 152.43521898003843},
        {"time": Timestamp("1949-10-01 00:00:00"), "fcst": 134.58612710330593},
        {"time": Timestamp("1949-11-01 00:00:00"), "fcst": 126.40302192145649},
        {"time": Timestamp("1949-12-01 00:00:00"), "fcst": 102.3178535567539},
        {"time": Timestamp("1950-01-01 00:00:00"), "fcst": 127.39730048736035},
        {"time": Timestamp("1950-02-01 00:00:00"), "fcst": 115.64633852952926},
        {"time": Timestamp("1950-03-01 00:00:00"), "fcst": 125.43830744367528},
        {"time": Timestamp("1950-04-01 00:00:00"), "fcst": 145.43521892783133},
        {"time": Timestamp("1950-05-01 00:00:00"), "fcst": 133.58612707914088},
        {"time": Timestamp("1950-06-01 00:00:00"), "fcst": 132.40302189693048},
        {"time": Timestamp("1950-07-01 00:00:00"), "fcst": 147.31785345420252},
        {"time": Timestamp("1950-08-01 00:00:00"), "fcst": 179.39730047936334},
        {"time": Timestamp("1950-09-01 00:00:00"), "fcst": 170.64633853411505},
        {"time": Timestamp("1950-10-01 00:00:00"), "fcst": 157.43830751477844},
        {"time": Timestamp("1950-11-01 00:00:00"), "fcst": 137.43521903345732},
        {"time": Timestamp("1950-12-01 00:00:00"), "fcst": 112.58612710243753},
        {"time": Timestamp("1951-01-01 00:00:00"), "fcst": 147.40302179222792},
        {"time": Timestamp("1951-02-01 00:00:00"), "fcst": 143.317853500865},
        {"time": Timestamp("1951-03-01 00:00:00"), "fcst": 159.39730051164796},
        {"time": Timestamp("1951-04-01 00:00:00"), "fcst": 178.64633844990703},
        {"time": Timestamp("1951-05-01 00:00:00"), "fcst": 162.43830751865534},
        {"time": Timestamp("1951-06-01 00:00:00"), "fcst": 176.43521894313096},
        {"time": Timestamp("1951-07-01 00:00:00"), "fcst": 176.5861270469804},
        {"time": Timestamp("1951-08-01 00:00:00"), "fcst": 206.40302182126086},
        {"time": Timestamp("1951-09-01 00:00:00"), "fcst": 197.31785352810135},
        {"time": Timestamp("1951-10-01 00:00:00"), "fcst": 193.39730057484107},
        {"time": Timestamp("1951-11-01 00:00:00"), "fcst": 162.64633858142048},
        {"time": Timestamp("1951-12-01 00:00:00"), "fcst": 145.43830750887463},
        {"time": Timestamp("1952-01-01 00:00:00"), "fcst": 170.43521890278816},
        {"time": Timestamp("1952-02-01 00:00:00"), "fcst": 169.5861270407929},
        {"time": Timestamp("1952-03-01 00:00:00"), "fcst": 187.4030218423999},
        {"time": Timestamp("1952-04-01 00:00:00"), "fcst": 191.31785348200606},
        {"time": Timestamp("1952-05-01 00:00:00"), "fcst": 190.397300558586},
        {"time": Timestamp("1952-06-01 00:00:00"), "fcst": 183.64633851338857},
        {"time": Timestamp("1952-07-01 00:00:00"), "fcst": 217.4383073815103},
        {"time": Timestamp("1952-08-01 00:00:00"), "fcst": 234.43521894224637},
        {"time": Timestamp("1952-09-01 00:00:00"), "fcst": 240.58612703962305},
        {"time": Timestamp("1952-10-01 00:00:00"), "fcst": 216.40302196707333},
        {"time": Timestamp("1952-11-01 00:00:00"), "fcst": 189.3178535639019},
        {"time": Timestamp("1952-12-01 00:00:00"), "fcst": 181.39730056893725},
        {"time": Timestamp("1953-01-01 00:00:00"), "fcst": 194.64633845326824},
        {"time": Timestamp("1953-02-01 00:00:00"), "fcst": 195.43830746197204},
        {"time": Timestamp("1953-03-01 00:00:00"), "fcst": 200.43521895799557},
        {"time": Timestamp("1953-04-01 00:00:00"), "fcst": 234.58612695038445},
        {"time": Timestamp("1953-05-01 00:00:00"), "fcst": 242.4030218778282},
        {"time": Timestamp("1953-06-01 00:00:00"), "fcst": 227.3178535364932},
        {"time": Timestamp("1953-07-01 00:00:00"), "fcst": 252.39730049298564},
        {"time": Timestamp("1953-08-01 00:00:00"), "fcst": 264.6463384747489},
        {"time": Timestamp("1953-09-01 00:00:00"), "fcst": 271.43830746547513},
        {"time": Timestamp("1953-10-01 00:00:00"), "fcst": 241.43521906684725},
        {"time": Timestamp("1953-11-01 00:00:00"), "fcst": 209.5861271246836},
        {"time": Timestamp("1953-12-01 00:00:00"), "fcst": 187.40302193780357},
        {"time": Timestamp("1954-01-01 00:00:00"), "fcst": 199.31785344222556},
        {"time": Timestamp("1954-02-01 00:00:00"), "fcst": 213.39730050406197},
        {"time": Timestamp("1954-03-01 00:00:00"), "fcst": 188.64633854731198},
        {"time": Timestamp("1954-04-01 00:00:00"), "fcst": 234.4383073334589},
        {"time": Timestamp("1954-05-01 00:00:00"), "fcst": 231.4352189790476},
        {"time": Timestamp("1954-06-01 00:00:00"), "fcst": 232.58612703148432},
        {"time": Timestamp("1954-07-01 00:00:00"), "fcst": 271.4030217859889},
        {"time": Timestamp("1954-08-01 00:00:00"), "fcst": 300.3178534230733},
        {"time": Timestamp("1954-09-01 00:00:00"), "fcst": 302.3973005640082},
        {"time": Timestamp("1954-10-01 00:00:00"), "fcst": 259.64633861804765},
        {"time": Timestamp("1954-11-01 00:00:00"), "fcst": 228.43830754622365},
        {"time": Timestamp("1954-12-01 00:00:00"), "fcst": 207.43521901564736},
        {"time": Timestamp("1955-01-01 00:00:00"), "fcst": 227.58612696849107},
        {"time": Timestamp("1955-02-01 00:00:00"), "fcst": 249.40302182043112},
        {"time": Timestamp("1955-03-01 00:00:00"), "fcst": 231.3178535269139},
        {"time": Timestamp("1955-04-01 00:00:00"), "fcst": 276.3973004244398},
        {"time": Timestamp("1955-05-01 00:00:00"), "fcst": 269.64633851154855},
        {"time": Timestamp("1955-06-01 00:00:00"), "fcst": 269.43830746524475},
        {"time": Timestamp("1955-07-01 00:00:00"), "fcst": 319.43521884513166},
        {"time": Timestamp("1955-08-01 00:00:00"), "fcst": 362.5861269442986},
        {"time": Timestamp("1955-09-01 00:00:00"), "fcst": 354.40302193789864},
        {"time": Timestamp("1955-10-01 00:00:00"), "fcst": 310.317853623534},
        {"time": Timestamp("1955-11-01 00:00:00"), "fcst": 283.3973006274947},
        {"time": Timestamp("1955-12-01 00:00:00"), "fcst": 237.64633860567437},
        {"time": Timestamp("1956-01-01 00:00:00"), "fcst": 277.4383073465219},
        {"time": Timestamp("1956-02-01 00:00:00"), "fcst": 288.4352189396168},
        {"time": Timestamp("1956-03-01 00:00:00"), "fcst": 275.5861270675572},
        {"time": Timestamp("1956-04-01 00:00:00"), "fcst": 324.4030217566258},
        {"time": Timestamp("1956-05-01 00:00:00"), "fcst": 311.317853528182},
        {"time": Timestamp("1956-06-01 00:00:00"), "fcst": 327.3973005130789},
        {"time": Timestamp("1956-07-01 00:00:00"), "fcst": 374.6463383808649},
        {"time": Timestamp("1956-08-01 00:00:00"), "fcst": 412.43830739423504},
        {"time": Timestamp("1956-09-01 00:00:00"), "fcst": 409.43521901681396},
        {"time": Timestamp("1956-10-01 00:00:00"), "fcst": 353.5861272127139},
        {"time": Timestamp("1956-11-01 00:00:00"), "fcst": 313.4030220021086},
        {"time": Timestamp("1956-12-01 00:00:00"), "fcst": 269.31785359570483},
        {"time": Timestamp("1957-01-01 00:00:00"), "fcst": 315.397300415932},
        {"time": Timestamp("1957-02-01 00:00:00"), "fcst": 315.64633848829874},
        {"time": Timestamp("1957-03-01 00:00:00"), "fcst": 300.4383074998819},
        {"time": Timestamp("1957-04-01 00:00:00"), "fcst": 360.43521881145654},
        {"time": Timestamp("1957-05-01 00:00:00"), "fcst": 346.58612708284875},
        {"time": Timestamp("1957-06-01 00:00:00"), "fcst": 362.4030218520986},
        {"time": Timestamp("1957-07-01 00:00:00"), "fcst": 420.31785335003985},
        {"time": Timestamp("1957-08-01 00:00:00"), "fcst": 474.39730044350654},
        {"time": Timestamp("1957-09-01 00:00:00"), "fcst": 467.6463385565014},
        {"time": Timestamp("1957-10-01 00:00:00"), "fcst": 403.43830767127895},
        {"time": Timestamp("1957-11-01 00:00:00"), "fcst": 351.4352191238112},
        {"time": Timestamp("1957-12-01 00:00:00"), "fcst": 303.5861271586409},
        {"time": Timestamp("1958-01-01 00:00:00"), "fcst": 343.4030217696936},
        {"time": Timestamp("1958-02-01 00:00:00"), "fcst": 338.31785349522875},
        {"time": Timestamp("1958-03-01 00:00:00"), "fcst": 327.3973005710917},
        {"time": Timestamp("1958-04-01 00:00:00"), "fcst": 362.64633839142243},
        {"time": Timestamp("1958-05-01 00:00:00"), "fcst": 347.4383075036734},
        {"time": Timestamp("1958-06-01 00:00:00"), "fcst": 367.4352189159238},
        {"time": Timestamp("1958-07-01 00:00:00"), "fcst": 433.58612687091556},
        {"time": Timestamp("1958-08-01 00:00:00"), "fcst": 498.40302174693534},
        {"time": Timestamp("1958-09-01 00:00:00"), "fcst": 503.3178535192069},
        {"time": Timestamp("1958-10-01 00:00:00"), "fcst": 413.3973008226669},
        {"time": Timestamp("1958-11-01 00:00:00"), "fcst": 359.64633863977986},
        {"time": Timestamp("1958-12-01 00:00:00"), "fcst": 309.43830758413844},
        {"time": Timestamp("1959-01-01 00:00:00"), "fcst": 341.4352188655183},
        {"time": Timestamp("1959-02-01 00:00:00"), "fcst": 358.58612697835247},
        {"time": Timestamp("1959-03-01 00:00:00"), "fcst": 349.4030218996877},
        {"time": Timestamp("1959-04-01 00:00:00"), "fcst": 404.3178533332741},
        {"time": Timestamp("1959-05-01 00:00:00"), "fcst": 405.39730055150756},
        {"time": Timestamp("1959-06-01 00:00:00"), "fcst": 420.64633845669096},
        {"time": Timestamp("1959-07-01 00:00:00"), "fcst": 471.4383073453023},
        {"time": Timestamp("1959-08-01 00:00:00"), "fcst": 552.4352187938528},
        {"time": Timestamp("1959-09-01 00:00:00"), "fcst": 557.5861270778247},
        {"time": Timestamp("1959-10-01 00:00:00"), "fcst": 470.40302216096313},
        {"time": Timestamp("1959-11-01 00:00:00"), "fcst": 405.31785367223165},
        {"time": Timestamp("1959-12-01 00:00:00"), "fcst": 371.39730063340994},
        {"time": Timestamp("1960-01-01 00:00:00"), "fcst": 405.64633839010435},
        {"time": Timestamp("1960-02-01 00:00:00"), "fcst": 416.43830743403987},
        {"time": Timestamp("1960-03-01 00:00:00"), "fcst": 395.435219024265},
        {"time": Timestamp("1960-04-01 00:00:00"), "fcst": 417.5861269720748},
        {"time": Timestamp("1960-05-01 00:00:00"), "fcst": 468.4030217567773},
        {"time": Timestamp("1960-06-01 00:00:00"), "fcst": 470.31785349633265},
        {"time": Timestamp("1960-07-01 00:00:00"), "fcst": 544.3973003783929},
        {"time": Timestamp("1960-08-01 00:00:00"), "fcst": 622.646338334976},
        {"time": Timestamp("1960-09-01 00:00:00"), "fcst": 605.4383075759382},
        {"time": Timestamp("1960-10-01 00:00:00"), "fcst": 512.4352192668457},
        {"time": Timestamp("1960-11-01 00:00:00"), "fcst": 459.5861271963348},
        {"time": Timestamp("1960-12-01 00:00:00"), "fcst": 397.40302204973},
        # {"time": NaT, "fcst": 430.3178533862482},
        {"time": Timestamp("1961-01-01 00:00:00"), "fcst": 430.3178533862482},
        {"time": Timestamp("1961-02-01 00:00:00"), "fcst": 439.7151539065179},
        {"time": Timestamp("1961-03-01 00:00:00"), "fcst": 440.3614923926484},
        {"time": Timestamp("1961-04-01 00:00:00"), "fcst": 439.7997998546415},
        {"time": Timestamp("1961-05-01 00:00:00"), "fcst": 444.23501881017836},
        {"time": Timestamp("1961-06-01 00:00:00"), "fcst": 442.8211458460015},
        {"time": Timestamp("1961-07-01 00:00:00"), "fcst": 450.22416770801783},
        {"time": Timestamp("1961-08-01 00:00:00"), "fcst": 448.54202119377453},
        {"time": Timestamp("1961-09-01 00:00:00"), "fcst": 457.93932171404424},
        {"time": Timestamp("1961-10-01 00:00:00"), "fcst": 458.58566020017474},
        {"time": Timestamp("1961-11-01 00:00:00"), "fcst": 458.0239676621678},
        {"time": Timestamp("1961-12-01 00:00:00"), "fcst": 462.4591866177047},
        {"time": Timestamp("1962-01-01 00:00:00"), "fcst": 461.04531365352784},
        {"time": Timestamp("1962-02-01 00:00:00"), "fcst": 468.44833551554416},
        {"time": Timestamp("1962-03-01 00:00:00"), "fcst": 466.766189001301},
        {"time": Timestamp("1962-04-01 00:00:00"), "fcst": 476.1634895215707},
        {"time": Timestamp("1962-05-01 00:00:00"), "fcst": 476.8098280077012},
        {"time": Timestamp("1962-06-01 00:00:00"), "fcst": 476.24813546969426},
        {"time": Timestamp("1962-07-01 00:00:00"), "fcst": 480.68335442523113},
        {"time": Timestamp("1962-08-01 00:00:00"), "fcst": 479.2694814610543},
        {"time": Timestamp("1962-09-01 00:00:00"), "fcst": 486.6725033230705},
        {"time": Timestamp("1962-10-01 00:00:00"), "fcst": 484.9903568088273},
        {"time": Timestamp("1962-11-01 00:00:00"), "fcst": 494.387657329097},
        {"time": Timestamp("1962-12-01 00:00:00"), "fcst": 495.0339958152275},
        {"time": Timestamp("1963-01-01 00:00:00"), "fcst": 494.4723032772206},
        {"time": Timestamp("1963-02-01 00:00:00"), "fcst": 498.90752223275746},
        {"time": Timestamp("1963-03-01 00:00:00"), "fcst": 497.4936492685806},
        {"time": Timestamp("1963-04-01 00:00:00"), "fcst": 504.8966711305969},
        {"time": Timestamp("1963-05-01 00:00:00"), "fcst": 503.21452461635374},
        {"time": Timestamp("1963-06-01 00:00:00"), "fcst": 512.6118251366235},
    ]
)

AIR_FCST_HW_2 = pd.DataFrame(
    {
        "time": {
            144: Timestamp("1960-12-02 00:00:00"),
            145: Timestamp("1960-12-03 00:00:00"),
            146: Timestamp("1960-12-04 00:00:00"),
            147: Timestamp("1960-12-05 00:00:00"),
            148: Timestamp("1960-12-06 00:00:00"),
            149: Timestamp("1960-12-07 00:00:00"),
            150: Timestamp("1960-12-08 00:00:00"),
            151: Timestamp("1960-12-09 00:00:00"),
            152: Timestamp("1960-12-10 00:00:00"),
            153: Timestamp("1960-12-11 00:00:00"),
            154: Timestamp("1960-12-12 00:00:00"),
            155: Timestamp("1960-12-13 00:00:00"),
            156: Timestamp("1960-12-14 00:00:00"),
            157: Timestamp("1960-12-15 00:00:00"),
            158: Timestamp("1960-12-16 00:00:00"),
            159: Timestamp("1960-12-17 00:00:00"),
            160: Timestamp("1960-12-18 00:00:00"),
            161: Timestamp("1960-12-19 00:00:00"),
            162: Timestamp("1960-12-20 00:00:00"),
            163: Timestamp("1960-12-21 00:00:00"),
            164: Timestamp("1960-12-22 00:00:00"),
            165: Timestamp("1960-12-23 00:00:00"),
            166: Timestamp("1960-12-24 00:00:00"),
            167: Timestamp("1960-12-25 00:00:00"),
            168: Timestamp("1960-12-26 00:00:00"),
            169: Timestamp("1960-12-27 00:00:00"),
            170: Timestamp("1960-12-28 00:00:00"),
            171: Timestamp("1960-12-29 00:00:00"),
            172: Timestamp("1960-12-30 00:00:00"),
            173: Timestamp("1960-12-31 00:00:00"),
        },
        "fcst": {
            144: 426.91782612904683,
            145: 442.61178390165213,
            146: 432.030759167949,
            147: 429.6691445287656,
            148: 434.9990742994176,
            149: 429.66385535629826,
            150: 447.1960753762643,
            151: 444.76249371560476,
            152: 461.1124406327931,
            153: 450.089141396734,
            154: 447.6288140179448,
            155: 453.18152864131514,
            156: 447.6233037642325,
            157: 465.8883501483431,
            158: 463.3530476104531,
            159: 480.3864032539542,
            160: 468.9023429567837,
            161: 466.3391767609165,
            162: 472.12398838420717,
            163: 466.33343618502084,
            164: 485.3619402212348,
            165: 482.72066499199514,
            166: 500.4659950500994,
            167: 488.5019144164508,
            168: 485.83161086080395,
            169: 491.85822086811726,
            170: 485.8256303355261,
            171: 505.6495036639397,
            172: 502.8978262083566,
            173: 521.3848903818335,
        },
        "fcst_lower": {
            144: 560.9970638278712,
            145: 577.9179099326489,
            146: 568.5637735311182,
            147: 567.4290472241071,
            148: 573.9858653269314,
            149: 569.8775347159844,
            150: 588.6366430681228,
            151: 587.4299497396356,
            152: 605.0067849889964,
            153: 595.2103740851096,
            154: 593.9769350384928,
            155: 600.7565379940355,
            156: 596.4252014491252,
            157: 615.9171361654081,
            158: 614.6087219596905,
            159: 632.868965935364,
            160: 622.6117939703659,
            161: 621.2755161066709,
            162: 628.287216062134,
            163: 623.7235521951201,
            164: 643.9789445635064,
            165: 642.5645576664391,
            166: 661.5367760567157,
            167: 650.7995837552394,
            168: 649.356168531765,
            169: 656.6096668712506,
            170: 651.8039646708319,
            171: 672.8547263314177,
            172: 671.329937208007,
            173: 691.0438897136563,
        },
        "fcst_upper": {
            144: 292.83858843022244,
            145: 307.3056578706554,
            146: 295.49774480477987,
            147: 291.9092418334242,
            148: 296.01228327190375,
            149: 289.4501759966121,
            150: 305.75550768440576,
            151: 302.0950376915739,
            152: 317.2180962765898,
            153: 304.96790870835844,
            154: 301.28069299739684,
            155: 305.60651928859477,
            156: 298.8214060793398,
            157: 315.85956413127803,
            158: 312.0973732612157,
            159: 327.9038405725444,
            160: 315.1928919432015,
            161: 311.40283741516197,
            162: 315.9607607062803,
            163: 308.9433201749216,
            164: 326.74493587896325,
            165: 322.8767723175512,
            166: 339.3952140434832,
            167: 326.20424507766216,
            168: 322.3070531898429,
            169: 327.1067748649839,
            170: 319.8472960002204,
            171: 338.44428099646166,
            172: 334.46571520870623,
            173: 351.7258910500108,
        },
    }
)

AIR_FCST_15_LSTM_PARAM_1_MODEL_1_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 455.75103306770325,
            "fcst_lower": 432.96348141431804,
            "fcst_upper": 478.53858472108845,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 484.08343428373337,
            "fcst_lower": 459.87926256954665,
            "fcst_upper": 508.2876059979201,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 499.65577667951584,
            "fcst_lower": 474.67298784554004,
            "fcst_upper": 524.6385655134917,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 502.13057881593704,
            "fcst_lower": 477.0240498751402,
            "fcst_upper": 527.237107756734,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 496.5547327399254,
            "fcst_lower": 471.7269961029291,
            "fcst_upper": 521.3824693769217,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 488.76720303297043,
            "fcst_lower": 464.32884288132186,
            "fcst_upper": 513.205563184619,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 483.82811176776886,
            "fcst_lower": 459.6367061793804,
            "fcst_upper": 508.01951735615734,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 482.78278535604477,
            "fcst_lower": 458.6436460882425,
            "fcst_upper": 506.921924623847,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 484.74499732255936,
            "fcst_lower": 460.5077474564314,
            "fcst_upper": 508.9822471886873,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 487.6515737771988,
            "fcst_lower": 463.26899508833884,
            "fcst_upper": 512.0341524660588,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 489.88147377967834,
            "fcst_lower": 465.3874000906944,
            "fcst_upper": 514.3755474686623,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 490.7672988772392,
            "fcst_lower": 466.2289339333772,
            "fcst_upper": 515.3056638211012,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 490.4971253871918,
            "fcst_lower": 465.9722691178322,
            "fcst_upper": 515.0219816565514,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 489.6901710033417,
            "fcst_lower": 465.20566245317457,
            "fcst_upper": 514.1746795535088,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 488.94414883852005,
            "fcst_lower": 464.496941396594,
            "fcst_upper": 513.3913562804461,
        },
    ]
)

AIR_FCST_15_LSTM_PARAM_2_MODEL_1_MONTHLY = pd.DataFrame(
    [
        {
            "time": pd.Timestamp("1961-01-01 00:00:00"),
            "fcst": 422.1656014919281,
            "fcst_lower": 401.05732141733165,
            "fcst_upper": 443.27388156652455,
        },
        {
            "time": pd.Timestamp("1961-02-01 00:00:00"),
            "fcst": 417.3987707197666,
            "fcst_lower": 396.52883218377826,
            "fcst_upper": 438.26870925575497,
        },
        {
            "time": pd.Timestamp("1961-03-01 00:00:00"),
            "fcst": 420.79761373996735,
            "fcst_lower": 399.75773305296894,
            "fcst_upper": 441.83749442696575,
        },
        {
            "time": pd.Timestamp("1961-04-01 00:00:00"),
            "fcst": 419.23954278230667,
            "fcst_lower": 398.27756564319134,
            "fcst_upper": 440.201519921422,
        },
        {
            "time": pd.Timestamp("1961-05-01 00:00:00"),
            "fcst": 418.8230516910553,
            "fcst_lower": 397.8818991065025,
            "fcst_upper": 439.7642042756081,
        },
        {
            "time": pd.Timestamp("1961-06-01 00:00:00"),
            "fcst": 418.9471893161535,
            "fcst_lower": 397.9998298503458,
            "fcst_upper": 439.89454878196125,
        },
        {
            "time": pd.Timestamp("1961-07-01 00:00:00"),
            "fcst": 418.66706243157387,
            "fcst_lower": 397.73370930999516,
            "fcst_upper": 439.6004155531526,
        },
        {
            "time": pd.Timestamp("1961-08-01 00:00:00"),
            "fcst": 418.5670383423567,
            "fcst_lower": 397.6386864252388,
            "fcst_upper": 439.49539025947456,
        },
        {
            "time": pd.Timestamp("1961-09-01 00:00:00"),
            "fcst": 418.5116983950138,
            "fcst_lower": 397.5861134752631,
            "fcst_upper": 439.4372833147645,
        },
        {
            "time": pd.Timestamp("1961-10-01 00:00:00"),
            "fcst": 418.43945813179016,
            "fcst_lower": 397.51748522520063,
            "fcst_upper": 439.3614310383797,
        },
        {
            "time": pd.Timestamp("1961-11-01 00:00:00"),
            "fcst": 418.3985098898411,
            "fcst_lower": 397.478584395349,
            "fcst_upper": 439.31843538433316,
        },
        {
            "time": pd.Timestamp("1961-12-01 00:00:00"),
            "fcst": 418.3679087013006,
            "fcst_lower": 397.44951326623556,
            "fcst_upper": 439.2863041363657,
        },
        {
            "time": pd.Timestamp("1962-01-01 00:00:00"),
            "fcst": 418.3428727686405,
            "fcst_lower": 397.4257291302085,
            "fcst_upper": 439.26001640707256,
        },
        {
            "time": pd.Timestamp("1962-02-01 00:00:00"),
            "fcst": 418.3256096690893,
            "fcst_lower": 397.4093291856348,
            "fcst_upper": 439.2418901525438,
        },
        {
            "time": pd.Timestamp("1962-03-01 00:00:00"),
            "fcst": 418.31263050436974,
            "fcst_lower": 397.39699897915125,
            "fcst_upper": 439.2282620295882,
        },
    ]
)

AIR_FCST_30_LSTM_PARAM_1_MODEL_1_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 455.75103306770325,
            "fcst_lower": 432.96348141431804,
            "fcst_upper": 478.53858472108845,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 484.08343428373337,
            "fcst_lower": 459.87926256954665,
            "fcst_upper": 508.2876059979201,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 499.65577667951584,
            "fcst_lower": 474.67298784554004,
            "fcst_upper": 524.6385655134917,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 502.13057881593704,
            "fcst_lower": 477.0240498751402,
            "fcst_upper": 527.237107756734,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 496.5547327399254,
            "fcst_lower": 471.7269961029291,
            "fcst_upper": 521.3824693769217,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 488.76720303297043,
            "fcst_lower": 464.32884288132186,
            "fcst_upper": 513.205563184619,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 483.82811176776886,
            "fcst_lower": 459.6367061793804,
            "fcst_upper": 508.01951735615734,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 482.78278535604477,
            "fcst_lower": 458.6436460882425,
            "fcst_upper": 506.921924623847,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 484.74499732255936,
            "fcst_lower": 460.5077474564314,
            "fcst_upper": 508.9822471886873,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 487.6515737771988,
            "fcst_lower": 463.26899508833884,
            "fcst_upper": 512.0341524660588,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 489.88147377967834,
            "fcst_lower": 465.3874000906944,
            "fcst_upper": 514.3755474686623,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 490.7672988772392,
            "fcst_lower": 466.2289339333772,
            "fcst_upper": 515.3056638211012,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 490.4971253871918,
            "fcst_lower": 465.9722691178322,
            "fcst_upper": 515.0219816565514,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 489.6901710033417,
            "fcst_lower": 465.20566245317457,
            "fcst_upper": 514.1746795535088,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 488.94414883852005,
            "fcst_lower": 464.496941396594,
            "fcst_upper": 513.3913562804461,
        },
        {
            "time": Timestamp("1962-04-01 00:00:00"),
            "fcst": 488.5810255408287,
            "fcst_lower": 464.1519742637872,
            "fcst_upper": 513.0100768178702,
        },
        {
            "time": Timestamp("1962-05-01 00:00:00"),
            "fcst": 488.6140002608299,
            "fcst_lower": 464.1833002477884,
            "fcst_upper": 513.0447002738714,
        },
        {
            "time": Timestamp("1962-06-01 00:00:00"),
            "fcst": 488.87029534578323,
            "fcst_lower": 464.42678057849406,
            "fcst_upper": 513.3138101130725,
        },
        {
            "time": Timestamp("1962-07-01 00:00:00"),
            "fcst": 489.1462579369545,
            "fcst_lower": 464.6889450401068,
            "fcst_upper": 513.6035708338022,
        },
        {
            "time": Timestamp("1962-08-01 00:00:00"),
            "fcst": 489.3122121691704,
            "fcst_lower": 464.84660156071186,
            "fcst_upper": 513.7778227776289,
        },
        {
            "time": Timestamp("1962-09-01 00:00:00"),
            "fcst": 489.34046298265457,
            "fcst_lower": 464.87343983352184,
            "fcst_upper": 513.8074861317873,
        },
        {
            "time": Timestamp("1962-10-01 00:00:00"),
            "fcst": 489.2760264277458,
            "fcst_lower": 464.8122251063585,
            "fcst_upper": 513.7398277491332,
        },
        {
            "time": Timestamp("1962-11-01 00:00:00"),
            "fcst": 489.1867198944092,
            "fcst_lower": 464.7273838996887,
            "fcst_upper": 513.6460558891297,
        },
        {
            "time": Timestamp("1962-12-01 00:00:00"),
            "fcst": 489.1234102845192,
            "fcst_lower": 464.66723977029324,
            "fcst_upper": 513.5795807987452,
        },
        {
            "time": Timestamp("1963-01-01 00:00:00"),
            "fcst": 489.10422134399414,
            "fcst_lower": 464.6490102767944,
            "fcst_upper": 513.5594324111938,
        },
        {
            "time": Timestamp("1963-02-01 00:00:00"),
            "fcst": 489.1198750734329,
            "fcst_lower": 464.66388131976123,
            "fcst_upper": 513.5758688271046,
        },
        {
            "time": Timestamp("1963-03-01 00:00:00"),
            "fcst": 489.1491602063179,
            "fcst_lower": 464.691702196002,
            "fcst_upper": 513.6066182166338,
        },
        {
            "time": Timestamp("1963-04-01 00:00:00"),
            "fcst": 489.1734281182289,
            "fcst_lower": 464.71475671231747,
            "fcst_upper": 513.6320995241404,
        },
        {
            "time": Timestamp("1963-05-01 00:00:00"),
            "fcst": 489.18391025066376,
            "fcst_lower": 464.72471473813056,
            "fcst_upper": 513.643105763197,
        },
        {
            "time": Timestamp("1963-06-01 00:00:00"),
            "fcst": 489.18161004781723,
            "fcst_lower": 464.72252954542637,
            "fcst_upper": 513.6406905502081,
        },
    ]
)

AIR_FCST_30_LSTM_PARAM_2_MODEL_1_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 422.1656014919281,
            "fcst_lower": 401.05732141733165,
            "fcst_upper": 443.27388156652455,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 417.3987707197666,
            "fcst_lower": 396.52883218377826,
            "fcst_upper": 438.26870925575497,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 420.79761373996735,
            "fcst_lower": 399.75773305296894,
            "fcst_upper": 441.83749442696575,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 419.23954278230667,
            "fcst_lower": 398.27756564319134,
            "fcst_upper": 440.201519921422,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 418.8230516910553,
            "fcst_lower": 397.8818991065025,
            "fcst_upper": 439.7642042756081,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 418.9471893161535,
            "fcst_lower": 397.9998298503458,
            "fcst_upper": 439.89454878196125,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 418.66706243157387,
            "fcst_lower": 397.73370930999516,
            "fcst_upper": 439.6004155531526,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 418.5670383423567,
            "fcst_lower": 397.6386864252388,
            "fcst_upper": 439.49539025947456,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 418.5116983950138,
            "fcst_lower": 397.5861134752631,
            "fcst_upper": 439.4372833147645,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 418.43945813179016,
            "fcst_lower": 397.51748522520063,
            "fcst_upper": 439.3614310383797,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 418.3985098898411,
            "fcst_lower": 397.478584395349,
            "fcst_upper": 439.31843538433316,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 418.3679087013006,
            "fcst_lower": 397.44951326623556,
            "fcst_upper": 439.2863041363657,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 418.3428727686405,
            "fcst_lower": 397.4257291302085,
            "fcst_upper": 439.26001640707256,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 418.3256096690893,
            "fcst_lower": 397.4093291856348,
            "fcst_upper": 439.2418901525438,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 418.31263050436974,
            "fcst_lower": 397.39699897915125,
            "fcst_upper": 439.2282620295882,
        },
        {
            "time": Timestamp("1962-04-01 00:00:00"),
            "fcst": 418.30286622047424,
            "fcst_lower": 397.38772290945053,
            "fcst_upper": 439.21800953149796,
        },
        {
            "time": Timestamp("1962-05-01 00:00:00"),
            "fcst": 418.2957417666912,
            "fcst_lower": 397.3809546783566,
            "fcst_upper": 439.2105288550258,
        },
        {
            "time": Timestamp("1962-06-01 00:00:00"),
            "fcst": 418.2904389500618,
            "fcst_lower": 397.3759170025587,
            "fcst_upper": 439.2049608975649,
        },
        {
            "time": Timestamp("1962-07-01 00:00:00"),
            "fcst": 418.2865023612976,
            "fcst_lower": 397.3721772432327,
            "fcst_upper": 439.2008274793625,
        },
        {
            "time": Timestamp("1962-08-01 00:00:00"),
            "fcst": 418.2835923731327,
            "fcst_lower": 397.36941275447606,
            "fcst_upper": 439.19777199178935,
        },
        {
            "time": Timestamp("1962-09-01 00:00:00"),
            "fcst": 418.2814349681139,
            "fcst_lower": 397.3673632197082,
            "fcst_upper": 439.1955067165196,
        },
        {
            "time": Timestamp("1962-10-01 00:00:00"),
            "fcst": 418.279833316803,
            "fcst_lower": 397.3658416509628,
            "fcst_upper": 439.19382498264315,
        },
        {
            "time": Timestamp("1962-11-01 00:00:00"),
            "fcst": 418.278648480773,
            "fcst_lower": 397.3647160567343,
            "fcst_upper": 439.1925809048116,
        },
        {
            "time": Timestamp("1962-12-01 00:00:00"),
            "fcst": 418.27776853740215,
            "fcst_lower": 397.363880110532,
            "fcst_upper": 439.1916569642723,
        },
        {
            "time": Timestamp("1963-01-01 00:00:00"),
            "fcst": 418.2771201580763,
            "fcst_lower": 397.3632641501724,
            "fcst_upper": 439.19097616598015,
        },
        {
            "time": Timestamp("1963-02-01 00:00:00"),
            "fcst": 418.27663001418114,
            "fcst_lower": 397.36279851347206,
            "fcst_upper": 439.1904615148902,
        },
        {
            "time": Timestamp("1963-03-01 00:00:00"),
            "fcst": 418.27627880871296,
            "fcst_lower": 397.3624648682773,
            "fcst_upper": 439.1900927491486,
        },
        {
            "time": Timestamp("1963-04-01 00:00:00"),
            "fcst": 418.27601251006126,
            "fcst_lower": 397.3622118845582,
            "fcst_upper": 439.18981313556435,
        },
        {
            "time": Timestamp("1963-05-01 00:00:00"),
            "fcst": 418.2758195400238,
            "fcst_lower": 397.3620285630226,
            "fcst_upper": 439.189610517025,
        },
        {
            "time": Timestamp("1963-06-01 00:00:00"),
            "fcst": 418.27567288279533,
            "fcst_lower": 397.3618892386555,
            "fcst_upper": 439.18945652693515,
        },
    ]
)

AIR_FCST_15_LSTM_PARAM_1_MODEL_2_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 444.51894187927246,
            "fcst_lower": 422.2929947853088,
            "fcst_upper": 466.74488897323613,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 440.65989619493484,
            "fcst_lower": 418.6269013851881,
            "fcst_upper": 462.6928910046816,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 434.84059911966324,
            "fcst_lower": 413.09856916368005,
            "fcst_upper": 456.5826290756464,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 428.9367888867855,
            "fcst_lower": 407.48994944244623,
            "fcst_upper": 450.3836283311248,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 425.575814306736,
            "fcst_lower": 404.2970235913992,
            "fcst_upper": 446.8546050220728,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 423.85844272375107,
            "fcst_lower": 402.6655205875635,
            "fcst_upper": 445.05136485993864,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 424.53667837381363,
            "fcst_lower": 403.3098444551229,
            "fcst_upper": 445.76351229250434,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 423.77535754442215,
            "fcst_lower": 402.586589667201,
            "fcst_upper": 444.9641254216433,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 422.6062061190605,
            "fcst_lower": 401.47589581310746,
            "fcst_upper": 443.7365164250136,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 421.6028931438923,
            "fcst_lower": 400.52274848669765,
            "fcst_upper": 442.6830378010869,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 420.8393107056618,
            "fcst_lower": 399.79734517037866,
            "fcst_upper": 441.8812762409449,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 420.31271862983704,
            "fcst_lower": 399.29708269834515,
            "fcst_upper": 441.3283545613289,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 419.9247407913208,
            "fcst_lower": 398.92850375175476,
            "fcst_upper": 440.92097783088684,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 419.60881024599075,
            "fcst_lower": 398.6283697336912,
            "fcst_upper": 440.5892507582903,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 419.27861535549164,
            "fcst_lower": 398.314684587717,
            "fcst_upper": 440.24254612326627,
        },
    ]
)

AIR_FCST_30_LSTM_PARAM_1_MODEL_2_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 444.51894187927246,
            "fcst_lower": 422.2929947853088,
            "fcst_upper": 466.74488897323613,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 440.65989619493484,
            "fcst_lower": 418.6269013851881,
            "fcst_upper": 462.6928910046816,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 434.84059911966324,
            "fcst_lower": 413.09856916368005,
            "fcst_upper": 456.5826290756464,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 428.9367888867855,
            "fcst_lower": 407.48994944244623,
            "fcst_upper": 450.3836283311248,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 425.575814306736,
            "fcst_lower": 404.2970235913992,
            "fcst_upper": 446.8546050220728,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 423.85844272375107,
            "fcst_lower": 402.6655205875635,
            "fcst_upper": 445.05136485993864,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 424.53667837381363,
            "fcst_lower": 403.3098444551229,
            "fcst_upper": 445.76351229250434,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 423.77535754442215,
            "fcst_lower": 402.586589667201,
            "fcst_upper": 444.9641254216433,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 422.6062061190605,
            "fcst_lower": 401.47589581310746,
            "fcst_upper": 443.7365164250136,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 421.6028931438923,
            "fcst_lower": 400.52274848669765,
            "fcst_upper": 442.6830378010869,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 420.8393107056618,
            "fcst_lower": 399.79734517037866,
            "fcst_upper": 441.8812762409449,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 420.31271862983704,
            "fcst_lower": 399.29708269834515,
            "fcst_upper": 441.3283545613289,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 419.9247407913208,
            "fcst_lower": 398.92850375175476,
            "fcst_upper": 440.92097783088684,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 419.60881024599075,
            "fcst_lower": 398.6283697336912,
            "fcst_upper": 440.5892507582903,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 419.27861535549164,
            "fcst_lower": 398.314684587717,
            "fcst_upper": 440.24254612326627,
        },
        {
            "time": Timestamp("1962-04-01 00:00:00"),
            "fcst": 418.98679834604263,
            "fcst_lower": 398.0374584287405,
            "fcst_upper": 439.9361382633448,
        },
        {
            "time": Timestamp("1962-05-01 00:00:00"),
            "fcst": 418.74793231487274,
            "fcst_lower": 397.8105356991291,
            "fcst_upper": 439.6853289306164,
        },
        {
            "time": Timestamp("1962-06-01 00:00:00"),
            "fcst": 418.55423671007156,
            "fcst_lower": 397.62652487456796,
            "fcst_upper": 439.48194854557516,
        },
        {
            "time": Timestamp("1962-07-01 00:00:00"),
            "fcst": 418.39516764879227,
            "fcst_lower": 397.47540926635264,
            "fcst_upper": 439.3149260312319,
        },
        {
            "time": Timestamp("1962-08-01 00:00:00"),
            "fcst": 418.2607215642929,
            "fcst_lower": 397.34768548607826,
            "fcst_upper": 439.17375764250755,
        },
        {
            "time": Timestamp("1962-09-01 00:00:00"),
            "fcst": 418.1449858546257,
            "fcst_lower": 397.2377365618944,
            "fcst_upper": 439.052235147357,
        },
        {
            "time": Timestamp("1962-10-01 00:00:00"),
            "fcst": 418.0447958111763,
            "fcst_lower": 397.14255602061746,
            "fcst_upper": 438.94703560173514,
        },
        {
            "time": Timestamp("1962-11-01 00:00:00"),
            "fcst": 417.9602440595627,
            "fcst_lower": 397.0622318565845,
            "fcst_upper": 438.85825626254086,
        },
        {
            "time": Timestamp("1962-12-01 00:00:00"),
            "fcst": 417.88939318060875,
            "fcst_lower": 396.9949235215783,
            "fcst_upper": 438.7838628396392,
        },
        {
            "time": Timestamp("1963-01-01 00:00:00"),
            "fcst": 417.829788595438,
            "fcst_lower": 396.9382991656661,
            "fcst_upper": 438.7212780252099,
        },
        {
            "time": Timestamp("1963-02-01 00:00:00"),
            "fcst": 417.77938482165337,
            "fcst_lower": 396.8904155805707,
            "fcst_upper": 438.66835406273606,
        },
        {
            "time": Timestamp("1963-03-01 00:00:00"),
            "fcst": 417.73656862974167,
            "fcst_lower": 396.84974019825455,
            "fcst_upper": 438.6233970612288,
        },
        {
            "time": Timestamp("1963-04-01 00:00:00"),
            "fcst": 417.70019763708115,
            "fcst_lower": 396.81518775522704,
            "fcst_upper": 438.58520751893525,
        },
        {
            "time": Timestamp("1963-05-01 00:00:00"),
            "fcst": 417.669361025095,
            "fcst_lower": 396.7858929738402,
            "fcst_upper": 438.5528290763498,
        },
        {
            "time": Timestamp("1963-06-01 00:00:00"),
            "fcst": 417.64329463243484,
            "fcst_lower": 396.7611299008131,
            "fcst_upper": 438.5254593640566,
        },
    ]
)

AIR_FCST_15_LSTM_PARAM_2_MODEL_2_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 410.1320439875126,
            "fcst_lower": 389.6254417881369,
            "fcst_upper": 430.63864618688825,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 409.1636277139187,
            "fcst_lower": 388.7054463282227,
            "fcst_upper": 429.62180909961467,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 409.22159591317177,
            "fcst_lower": 388.76051611751313,
            "fcst_upper": 429.6826757088304,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 408.86590968072414,
            "fcst_lower": 388.4226141966879,
            "fcst_upper": 429.3092051647604,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 408.83762799203396,
            "fcst_lower": 388.39574659243226,
            "fcst_upper": 429.27950939163566,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 408.8285313844681,
            "fcst_lower": 388.38710481524464,
            "fcst_upper": 429.2699579536915,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 408.8220321536064,
            "fcst_lower": 388.38093054592605,
            "fcst_upper": 429.2631337612868,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 408.82110203802586,
            "fcst_lower": 388.38004693612453,
            "fcst_upper": 429.2621571399272,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 408.8207701295614,
            "fcst_lower": 388.37973162308333,
            "fcst_upper": 429.2618086360395,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 408.8206350505352,
            "fcst_lower": 388.3796032980084,
            "fcst_upper": 429.261666803062,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 408.82060031592846,
            "fcst_lower": 388.379570300132,
            "fcst_upper": 429.2616303317249,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 408.8205964565277,
            "fcst_lower": 388.3795666337013,
            "fcst_upper": 429.2616262793541,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
    ]
)

AIR_FCST_30_LSTM_PARAM_2_MODEL_2_MONTHLY = pd.DataFrame(
    [
        {
            "time": Timestamp("1961-01-01 00:00:00"),
            "fcst": 410.1320439875126,
            "fcst_lower": 389.6254417881369,
            "fcst_upper": 430.63864618688825,
        },
        {
            "time": Timestamp("1961-02-01 00:00:00"),
            "fcst": 409.1636277139187,
            "fcst_lower": 388.7054463282227,
            "fcst_upper": 429.62180909961467,
        },
        {
            "time": Timestamp("1961-03-01 00:00:00"),
            "fcst": 409.22159591317177,
            "fcst_lower": 388.76051611751313,
            "fcst_upper": 429.6826757088304,
        },
        {
            "time": Timestamp("1961-04-01 00:00:00"),
            "fcst": 408.86590968072414,
            "fcst_lower": 388.4226141966879,
            "fcst_upper": 429.3092051647604,
        },
        {
            "time": Timestamp("1961-05-01 00:00:00"),
            "fcst": 408.83762799203396,
            "fcst_lower": 388.39574659243226,
            "fcst_upper": 429.27950939163566,
        },
        {
            "time": Timestamp("1961-06-01 00:00:00"),
            "fcst": 408.8285313844681,
            "fcst_lower": 388.38710481524464,
            "fcst_upper": 429.2699579536915,
        },
        {
            "time": Timestamp("1961-07-01 00:00:00"),
            "fcst": 408.8220321536064,
            "fcst_lower": 388.38093054592605,
            "fcst_upper": 429.2631337612868,
        },
        {
            "time": Timestamp("1961-08-01 00:00:00"),
            "fcst": 408.82110203802586,
            "fcst_lower": 388.38004693612453,
            "fcst_upper": 429.2621571399272,
        },
        {
            "time": Timestamp("1961-09-01 00:00:00"),
            "fcst": 408.8207701295614,
            "fcst_lower": 388.37973162308333,
            "fcst_upper": 429.2618086360395,
        },
        {
            "time": Timestamp("1961-10-01 00:00:00"),
            "fcst": 408.8206350505352,
            "fcst_lower": 388.3796032980084,
            "fcst_upper": 429.261666803062,
        },
        {
            "time": Timestamp("1961-11-01 00:00:00"),
            "fcst": 408.82060031592846,
            "fcst_lower": 388.379570300132,
            "fcst_upper": 429.2616303317249,
        },
        {
            "time": Timestamp("1961-12-01 00:00:00"),
            "fcst": 408.8205964565277,
            "fcst_lower": 388.3795666337013,
            "fcst_upper": 429.2616262793541,
        },
        {
            "time": Timestamp("1962-01-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-02-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-03-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-04-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-05-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-06-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-07-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-08-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-09-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-10-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-11-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1962-12-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1963-01-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1963-02-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1963-03-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1963-04-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1963-05-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
        {
            "time": Timestamp("1963-06-01 00:00:00"),
            "fcst": 408.8205887377262,
            "fcst_lower": 388.3795593008399,
            "fcst_upper": 429.2616181746125,
        },
    ]
)

PT_FCST_15_LSTM_PARAM_1_MODEL_1_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 7.915496461032264,
            "fcst_lower": 7.51972163798065,
            "fcst_upper": 8.311271284083878,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 7.8202741773578595,
            "fcst_lower": 7.429260468489966,
            "fcst_upper": 8.211287886225753,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 7.77689999022705,
            "fcst_lower": 7.388054990715697,
            "fcst_upper": 8.165744989738403,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 7.751239990193409,
            "fcst_lower": 7.363677990683739,
            "fcst_upper": 8.13880198970308,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 7.745551860225734,
            "fcst_lower": 7.358274267214447,
            "fcst_upper": 8.13282945323702,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 7.766512724955451,
            "fcst_lower": 7.378187088707678,
            "fcst_upper": 8.154838361203224,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 7.760765091159458,
            "fcst_lower": 7.372726836601485,
            "fcst_upper": 8.14880334571743,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 7.7462157639309,
            "fcst_lower": 7.3589049757343545,
            "fcst_upper": 8.133526552127446,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 7.730567283011599,
            "fcst_lower": 7.344038918861019,
            "fcst_upper": 8.117095647162179,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 7.718697423431436,
            "fcst_lower": 7.332762552259864,
            "fcst_upper": 8.10463229460301,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 7.711273551402833,
            "fcst_lower": 7.325709873832691,
            "fcst_upper": 8.096837228972975,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 7.707942234704144,
            "fcst_lower": 7.322545122968936,
            "fcst_upper": 8.093339346439352,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 7.70762624885722,
            "fcst_lower": 7.322244936414358,
            "fcst_upper": 8.09300756130008,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 7.707581364503963,
            "fcst_lower": 7.322202296278765,
            "fcst_upper": 8.092960432729162,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 7.706951188184244,
            "fcst_lower": 7.321603628775032,
            "fcst_upper": 8.092298747593457,
        },
    ]
)

PT_FCST_15_LSTM_PARAM_2_MODEL_1_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 7.868598852170829,
            "fcst_lower": 7.475168909562288,
            "fcst_upper": 8.262028794779372,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 7.847685564855564,
            "fcst_lower": 7.4553012866127855,
            "fcst_upper": 8.240069843098343,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 7.785592294078679,
            "fcst_lower": 7.396312679374745,
            "fcst_upper": 8.174871908782613,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 7.74719975719529,
            "fcst_lower": 7.359839769335525,
            "fcst_upper": 8.134559745055055,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 7.727431149129071,
            "fcst_lower": 7.341059591672617,
            "fcst_upper": 8.113802706585524,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 7.710651582507708,
            "fcst_lower": 7.325119003382323,
            "fcst_upper": 8.096184161633094,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 7.699919348921082,
            "fcst_lower": 7.314923381475027,
            "fcst_upper": 8.084915316367136,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 7.693030754865313,
            "fcst_lower": 7.308379217122047,
            "fcst_upper": 8.077682292608579,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 7.6881745243249915,
            "fcst_lower": 7.303765798108741,
            "fcst_upper": 8.072583250541241,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 7.684973628732766,
            "fcst_lower": 7.300724947296127,
            "fcst_upper": 8.069222310169405,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 7.682842776122172,
            "fcst_lower": 7.298700637316063,
            "fcst_upper": 8.06698491492828,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 7.6814000647675025,
            "fcst_lower": 7.297330061529127,
            "fcst_upper": 8.065470068005878,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 7.68043877016176,
            "fcst_lower": 7.296416831653671,
            "fcst_upper": 8.064460708669849,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 7.679795513259092,
            "fcst_lower": 7.295805737596137,
            "fcst_upper": 8.063785288922046,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 7.679363597539756,
            "fcst_lower": 7.295395417662768,
            "fcst_upper": 8.063331777416744,
        },
    ]
)

PT_FCST_15_LSTM_PARAM_1_MODEL_2_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 8.047312060229524,
            "fcst_lower": 7.644946457218047,
            "fcst_upper": 8.449677663241001,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 8.051697133301662,
            "fcst_lower": 7.649112276636578,
            "fcst_upper": 8.454281989966745,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 8.06038417927191,
            "fcst_lower": 7.657364970308314,
            "fcst_upper": 8.463403388235506,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 8.04928774121886,
            "fcst_lower": 7.646823354157917,
            "fcst_upper": 8.451752128279804,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 8.0596714157422,
            "fcst_lower": 7.656687844955089,
            "fcst_upper": 8.46265498652931,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 8.088926267748647,
            "fcst_lower": 7.684479954361215,
            "fcst_upper": 8.49337258113608,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 8.06375191641724,
            "fcst_lower": 7.660564320596378,
            "fcst_upper": 8.466939512238103,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 8.064431209043523,
            "fcst_lower": 7.661209648591346,
            "fcst_upper": 8.4676527694957,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 8.066842781223484,
            "fcst_lower": 7.663500642162309,
            "fcst_upper": 8.470184920284659,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 8.069026084406882,
            "fcst_lower": 7.665574780186538,
            "fcst_upper": 8.472477388627228,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 8.07041788408086,
            "fcst_lower": 7.666896989876816,
            "fcst_upper": 8.473938778284902,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 8.073052339134989,
            "fcst_lower": 7.669399722178239,
            "fcst_upper": 8.476704956091739,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 8.07457750945864,
            "fcst_lower": 7.670848633985708,
            "fcst_upper": 8.478306384931573,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 8.073042336336263,
            "fcst_lower": 7.66939021951945,
            "fcst_upper": 8.476694453153076,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 8.074317693173791,
            "fcst_lower": 7.670601808515101,
            "fcst_upper": 8.47803357783248,
        },
    ]
)

PT_FCST_15_LSTM_PARAM_2_MODEL_2_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 8.397010031921214,
            "fcst_lower": 7.977159530325153,
            "fcst_upper": 8.816860533517275,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 8.453978663725305,
            "fcst_lower": 8.031279730539039,
            "fcst_upper": 8.876677596911572,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 8.471730938402239,
            "fcst_lower": 8.048144391482126,
            "fcst_upper": 8.895317485322352,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 8.507812187574944,
            "fcst_lower": 8.082421578196197,
            "fcst_upper": 8.93320279695369,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 8.518635600519184,
            "fcst_lower": 8.092703820493226,
            "fcst_upper": 8.944567380545143,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 8.524949418371254,
            "fcst_lower": 8.09870194745269,
            "fcst_upper": 8.951196889289816,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 8.529857201797315,
            "fcst_lower": 8.103364341707449,
            "fcst_upper": 8.95635006188718,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 8.53198972154103,
            "fcst_lower": 8.105390235463979,
            "fcst_upper": 8.958589207618083,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 8.533268540885809,
            "fcst_lower": 8.106605113841518,
            "fcst_upper": 8.9599319679301,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 8.53405299113972,
            "fcst_lower": 8.107350341582734,
            "fcst_upper": 8.960755640696707,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 8.534455667908935,
            "fcst_lower": 8.107732884513487,
            "fcst_upper": 8.961178451304383,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 8.534690733678989,
            "fcst_lower": 8.107956196995039,
            "fcst_upper": 8.96142527036294,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 8.534826156184813,
            "fcst_lower": 8.108084848375572,
            "fcst_upper": 8.961567463994054,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 8.534900023006173,
            "fcst_lower": 8.108155021855865,
            "fcst_upper": 8.961645024156482,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 8.534942342539244,
            "fcst_lower": 8.108195225412281,
            "fcst_upper": 8.961689459666207,
        },
    ]
)

PT_FCST_30_LSTM_PARAM_1_MODEL_1_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 7.915496461032264,
            "fcst_lower": 7.51972163798065,
            "fcst_upper": 8.311271284083878,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 7.8202741773578595,
            "fcst_lower": 7.429260468489966,
            "fcst_upper": 8.211287886225753,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 7.77689999022705,
            "fcst_lower": 7.388054990715697,
            "fcst_upper": 8.165744989738403,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 7.751239990193409,
            "fcst_lower": 7.363677990683739,
            "fcst_upper": 8.13880198970308,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 7.745551860225734,
            "fcst_lower": 7.358274267214447,
            "fcst_upper": 8.13282945323702,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 7.766512724955451,
            "fcst_lower": 7.378187088707678,
            "fcst_upper": 8.154838361203224,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 7.760765091159458,
            "fcst_lower": 7.372726836601485,
            "fcst_upper": 8.14880334571743,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 7.7462157639309,
            "fcst_lower": 7.3589049757343545,
            "fcst_upper": 8.133526552127446,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 7.730567283011599,
            "fcst_lower": 7.344038918861019,
            "fcst_upper": 8.117095647162179,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 7.718697423431436,
            "fcst_lower": 7.332762552259864,
            "fcst_upper": 8.10463229460301,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 7.711273551402833,
            "fcst_lower": 7.325709873832691,
            "fcst_upper": 8.096837228972975,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 7.707942234704144,
            "fcst_lower": 7.322545122968936,
            "fcst_upper": 8.093339346439352,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 7.70762624885722,
            "fcst_lower": 7.322244936414358,
            "fcst_upper": 8.09300756130008,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 7.707581364503963,
            "fcst_lower": 7.322202296278765,
            "fcst_upper": 8.092960432729162,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 7.706951188184244,
            "fcst_lower": 7.321603628775032,
            "fcst_upper": 8.092298747593457,
        },
        {
            "time": Timestamp("2013-05-16 00:00:00"),
            "fcst": 7.705767523668369,
            "fcst_lower": 7.32047914748495,
            "fcst_upper": 8.091055899851789,
        },
        {
            "time": Timestamp("2013-05-17 00:00:00"),
            "fcst": 7.704436125509775,
            "fcst_lower": 7.319214319234286,
            "fcst_upper": 8.089657931785265,
        },
        {
            "time": Timestamp("2013-05-18 00:00:00"),
            "fcst": 7.703302731469547,
            "fcst_lower": 7.318137594896069,
            "fcst_upper": 8.088467868043026,
        },
        {
            "time": Timestamp("2013-05-19 00:00:00"),
            "fcst": 7.7025457247916265,
            "fcst_lower": 7.317418438552044,
            "fcst_upper": 8.087673011031209,
        },
        {
            "time": Timestamp("2013-05-20 00:00:00"),
            "fcst": 7.702165233717022,
            "fcst_lower": 7.31705697203117,
            "fcst_upper": 8.087273495402872,
        },
        {
            "time": Timestamp("2013-05-21 00:00:00"),
            "fcst": 7.702009933854755,
            "fcst_lower": 7.316909437162017,
            "fcst_upper": 8.087110430547494,
        },
        {
            "time": Timestamp("2013-05-22 00:00:00"),
            "fcst": 7.701933630454219,
            "fcst_lower": 7.316836948931508,
            "fcst_upper": 8.08703031197693,
        },
        {
            "time": Timestamp("2013-05-23 00:00:00"),
            "fcst": 7.70185232565432,
            "fcst_lower": 7.3167597093716035,
            "fcst_upper": 8.086944941937036,
        },
        {
            "time": Timestamp("2013-05-24 00:00:00"),
            "fcst": 7.701745757375589,
            "fcst_lower": 7.316658469506809,
            "fcst_upper": 8.086833045244369,
        },
        {
            "time": Timestamp("2013-05-25 00:00:00"),
            "fcst": 7.701629827503178,
            "fcst_lower": 7.316548336128019,
            "fcst_upper": 8.086711318878336,
        },
        {
            "time": Timestamp("2013-05-26 00:00:00"),
            "fcst": 7.701528004141791,
            "fcst_lower": 7.316451603934701,
            "fcst_upper": 8.086604404348881,
        },
        {
            "time": Timestamp("2013-05-27 00:00:00"),
            "fcst": 7.701455419730524,
            "fcst_lower": 7.316382648743998,
            "fcst_upper": 8.08652819071705,
        },
        {
            "time": Timestamp("2013-05-28 00:00:00"),
            "fcst": 7.7014119460283705,
            "fcst_lower": 7.316341348726952,
            "fcst_upper": 8.08648254332979,
        },
        {
            "time": Timestamp("2013-05-29 00:00:00"),
            "fcst": 7.701388990887705,
            "fcst_lower": 7.3163195413433195,
            "fcst_upper": 8.086458440432091,
        },
        {
            "time": Timestamp("2013-05-30 00:00:00"),
            "fcst": 7.7013760385457655,
            "fcst_lower": 7.316307236618477,
            "fcst_upper": 8.086444840473055,
        },
    ]
)

PT_FCST_30_LSTM_PARAM_2_MODEL_1_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 7.868598852170829,
            "fcst_lower": 7.475168909562288,
            "fcst_upper": 8.262028794779372,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 7.847685564855564,
            "fcst_lower": 7.4553012866127855,
            "fcst_upper": 8.240069843098343,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 7.785592294078679,
            "fcst_lower": 7.396312679374745,
            "fcst_upper": 8.174871908782613,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 7.74719975719529,
            "fcst_lower": 7.359839769335525,
            "fcst_upper": 8.134559745055055,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 7.727431149129071,
            "fcst_lower": 7.341059591672617,
            "fcst_upper": 8.113802706585524,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 7.710651582507708,
            "fcst_lower": 7.325119003382323,
            "fcst_upper": 8.096184161633094,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 7.699919348921082,
            "fcst_lower": 7.314923381475027,
            "fcst_upper": 8.084915316367136,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 7.693030754865313,
            "fcst_lower": 7.308379217122047,
            "fcst_upper": 8.077682292608579,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 7.6881745243249915,
            "fcst_lower": 7.303765798108741,
            "fcst_upper": 8.072583250541241,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 7.684973628732766,
            "fcst_lower": 7.300724947296127,
            "fcst_upper": 8.069222310169405,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 7.682842776122172,
            "fcst_lower": 7.298700637316063,
            "fcst_upper": 8.06698491492828,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 7.6814000647675025,
            "fcst_lower": 7.297330061529127,
            "fcst_upper": 8.065470068005878,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 7.68043877016176,
            "fcst_lower": 7.296416831653671,
            "fcst_upper": 8.064460708669849,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 7.679795513259092,
            "fcst_lower": 7.295805737596137,
            "fcst_upper": 8.063785288922046,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 7.679363597539756,
            "fcst_lower": 7.295395417662768,
            "fcst_upper": 8.063331777416744,
        },
        {
            "time": Timestamp("2013-05-16 00:00:00"),
            "fcst": 7.6790750552688225,
            "fcst_lower": 7.295121302505381,
            "fcst_upper": 8.063028808032264,
        },
        {
            "time": Timestamp("2013-05-17 00:00:00"),
            "fcst": 7.6788819243088104,
            "fcst_lower": 7.29493782809337,
            "fcst_upper": 8.062826020524252,
        },
        {
            "time": Timestamp("2013-05-18 00:00:00"),
            "fcst": 7.6787524008894135,
            "fcst_lower": 7.294814780844942,
            "fcst_upper": 8.062690020933884,
        },
        {
            "time": Timestamp("2013-05-19 00:00:00"),
            "fcst": 7.678665966449143,
            "fcst_lower": 7.294732668126685,
            "fcst_upper": 8.0625992647716,
        },
        {
            "time": Timestamp("2013-05-20 00:00:00"),
            "fcst": 7.678607745030919,
            "fcst_lower": 7.294677357779372,
            "fcst_upper": 8.062538132282466,
        },
        {
            "time": Timestamp("2013-05-21 00:00:00"),
            "fcst": 7.678569016246109,
            "fcst_lower": 7.294640565433803,
            "fcst_upper": 8.062497467058416,
        },
        {
            "time": Timestamp("2013-05-22 00:00:00"),
            "fcst": 7.67854311156223,
            "fcst_lower": 7.294615955984118,
            "fcst_upper": 8.062470267140341,
        },
        {
            "time": Timestamp("2013-05-23 00:00:00"),
            "fcst": 7.678525670784964,
            "fcst_lower": 7.294599387245715,
            "fcst_upper": 8.062451954324212,
        },
        {
            "time": Timestamp("2013-05-24 00:00:00"),
            "fcst": 7.6785138726121085,
            "fcst_lower": 7.294588178981503,
            "fcst_upper": 8.062439566242714,
        },
        {
            "time": Timestamp("2013-05-25 00:00:00"),
            "fcst": 7.67850617815155,
            "fcst_lower": 7.294580869243972,
            "fcst_upper": 8.062431487059127,
        },
        {
            "time": Timestamp("2013-05-26 00:00:00"),
            "fcst": 7.678501048511178,
            "fcst_lower": 7.2945759960856185,
            "fcst_upper": 8.062426100936737,
        },
        {
            "time": Timestamp("2013-05-27 00:00:00"),
            "fcst": 7.6784974577629175,
            "fcst_lower": 7.294572584874771,
            "fcst_upper": 8.062422330651064,
        },
        {
            "time": Timestamp("2013-05-28 00:00:00"),
            "fcst": 7.6784954059067685,
            "fcst_lower": 7.2945706356114295,
            "fcst_upper": 8.062420176202107,
        },
        {
            "time": Timestamp("2013-05-29 00:00:00"),
            "fcst": 7.678493867014657,
            "fcst_lower": 7.294569173663924,
            "fcst_upper": 8.06241856036539,
        },
        {
            "time": Timestamp("2013-05-30 00:00:00"),
            "fcst": 7.678492584604564,
            "fcst_lower": 7.294567955374336,
            "fcst_upper": 8.062417213834793,
        },
    ]
)

PT_FCST_30_LSTM_PARAM_1_MODEL_2_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 8.047312060229524,
            "fcst_lower": 7.644946457218047,
            "fcst_upper": 8.449677663241001,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 8.051697133301662,
            "fcst_lower": 7.649112276636578,
            "fcst_upper": 8.454281989966745,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 8.06038417927191,
            "fcst_lower": 7.657364970308314,
            "fcst_upper": 8.463403388235506,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 8.04928774121886,
            "fcst_lower": 7.646823354157917,
            "fcst_upper": 8.451752128279804,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 8.0596714157422,
            "fcst_lower": 7.656687844955089,
            "fcst_upper": 8.46265498652931,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 8.088926267748647,
            "fcst_lower": 7.684479954361215,
            "fcst_upper": 8.49337258113608,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 8.06375191641724,
            "fcst_lower": 7.660564320596378,
            "fcst_upper": 8.466939512238103,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 8.064431209043523,
            "fcst_lower": 7.661209648591346,
            "fcst_upper": 8.4676527694957,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 8.066842781223484,
            "fcst_lower": 7.663500642162309,
            "fcst_upper": 8.470184920284659,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 8.069026084406882,
            "fcst_lower": 7.665574780186538,
            "fcst_upper": 8.472477388627228,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 8.07041788408086,
            "fcst_lower": 7.666896989876816,
            "fcst_upper": 8.473938778284902,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 8.073052339134989,
            "fcst_lower": 7.669399722178239,
            "fcst_upper": 8.476704956091739,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 8.07457750945864,
            "fcst_lower": 7.670848633985708,
            "fcst_upper": 8.478306384931573,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 8.073042336336263,
            "fcst_lower": 7.66939021951945,
            "fcst_upper": 8.476694453153076,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 8.074317693173791,
            "fcst_lower": 7.670601808515101,
            "fcst_upper": 8.47803357783248,
        },
        {
            "time": Timestamp("2013-05-16 00:00:00"),
            "fcst": 8.075702824315282,
            "fcst_lower": 7.671917683099518,
            "fcst_upper": 8.479487965531048,
        },
        {
            "time": Timestamp("2013-05-17 00:00:00"),
            "fcst": 8.076942145429197,
            "fcst_lower": 7.6730950381577365,
            "fcst_upper": 8.480789252700657,
        },
        {
            "time": Timestamp("2013-05-18 00:00:00"),
            "fcst": 8.07804309449407,
            "fcst_lower": 7.674140939769367,
            "fcst_upper": 8.481945249218775,
        },
        {
            "time": Timestamp("2013-05-19 00:00:00"),
            "fcst": 8.079086078622739,
            "fcst_lower": 7.675131774691601,
            "fcst_upper": 8.483040382553876,
        },
        {
            "time": Timestamp("2013-05-20 00:00:00"),
            "fcst": 8.079944267457,
            "fcst_lower": 7.6759470540841495,
            "fcst_upper": 8.48394148082985,
        },
        {
            "time": Timestamp("2013-05-21 00:00:00"),
            "fcst": 8.080748210344327,
            "fcst_lower": 7.67671079982711,
            "fcst_upper": 8.484785620861544,
        },
        {
            "time": Timestamp("2013-05-22 00:00:00"),
            "fcst": 8.08182915381175,
            "fcst_lower": 7.677737696121162,
            "fcst_upper": 8.485920611502339,
        },
        {
            "time": Timestamp("2013-05-23 00:00:00"),
            "fcst": 8.082885346764376,
            "fcst_lower": 7.678741079426157,
            "fcst_upper": 8.487029614102596,
        },
        {
            "time": Timestamp("2013-05-24 00:00:00"),
            "fcst": 8.083896398881729,
            "fcst_lower": 7.6797015789376415,
            "fcst_upper": 8.488091218825815,
        },
        {
            "time": Timestamp("2013-05-25 00:00:00"),
            "fcst": 8.084876929638867,
            "fcst_lower": 7.680633083156923,
            "fcst_upper": 8.48912077612081,
        },
        {
            "time": Timestamp("2013-05-26 00:00:00"),
            "fcst": 8.085842712679934,
            "fcst_lower": 7.681550577045937,
            "fcst_upper": 8.49013484831393,
        },
        {
            "time": Timestamp("2013-05-27 00:00:00"),
            "fcst": 8.0868015707065,
            "fcst_lower": 7.682461492171175,
            "fcst_upper": 8.491141649241825,
        },
        {
            "time": Timestamp("2013-05-28 00:00:00"),
            "fcst": 8.087773894039042,
            "fcst_lower": 7.683385199337089,
            "fcst_upper": 8.492162588740994,
        },
        {
            "time": Timestamp("2013-05-29 00:00:00"),
            "fcst": 8.088764940558942,
            "fcst_lower": 7.684326693530995,
            "fcst_upper": 8.49320318758689,
        },
        {
            "time": Timestamp("2013-05-30 00:00:00"),
            "fcst": 8.089744060664978,
            "fcst_lower": 7.685256857631729,
            "fcst_upper": 8.494231263698227,
        },
    ]
)

PT_FCST_30_LSTM_PARAM_2_MODEL_2_DAILY = pd.DataFrame(
    [
        {
            "time": Timestamp("2013-05-01 00:00:00"),
            "fcst": 8.397010031921214,
            "fcst_lower": 7.977159530325153,
            "fcst_upper": 8.816860533517275,
        },
        {
            "time": Timestamp("2013-05-02 00:00:00"),
            "fcst": 8.453978663725305,
            "fcst_lower": 8.031279730539039,
            "fcst_upper": 8.876677596911572,
        },
        {
            "time": Timestamp("2013-05-03 00:00:00"),
            "fcst": 8.471730938402239,
            "fcst_lower": 8.048144391482126,
            "fcst_upper": 8.895317485322352,
        },
        {
            "time": Timestamp("2013-05-04 00:00:00"),
            "fcst": 8.507812187574944,
            "fcst_lower": 8.082421578196197,
            "fcst_upper": 8.93320279695369,
        },
        {
            "time": Timestamp("2013-05-05 00:00:00"),
            "fcst": 8.518635600519184,
            "fcst_lower": 8.092703820493226,
            "fcst_upper": 8.944567380545143,
        },
        {
            "time": Timestamp("2013-05-06 00:00:00"),
            "fcst": 8.524949418371254,
            "fcst_lower": 8.09870194745269,
            "fcst_upper": 8.951196889289816,
        },
        {
            "time": Timestamp("2013-05-07 00:00:00"),
            "fcst": 8.529857201797315,
            "fcst_lower": 8.103364341707449,
            "fcst_upper": 8.95635006188718,
        },
        {
            "time": Timestamp("2013-05-08 00:00:00"),
            "fcst": 8.53198972154103,
            "fcst_lower": 8.105390235463979,
            "fcst_upper": 8.958589207618083,
        },
        {
            "time": Timestamp("2013-05-09 00:00:00"),
            "fcst": 8.533268540885809,
            "fcst_lower": 8.106605113841518,
            "fcst_upper": 8.9599319679301,
        },
        {
            "time": Timestamp("2013-05-10 00:00:00"),
            "fcst": 8.53405299113972,
            "fcst_lower": 8.107350341582734,
            "fcst_upper": 8.960755640696707,
        },
        {
            "time": Timestamp("2013-05-11 00:00:00"),
            "fcst": 8.534455667908935,
            "fcst_lower": 8.107732884513487,
            "fcst_upper": 8.961178451304383,
        },
        {
            "time": Timestamp("2013-05-12 00:00:00"),
            "fcst": 8.534690733678989,
            "fcst_lower": 8.107956196995039,
            "fcst_upper": 8.96142527036294,
        },
        {
            "time": Timestamp("2013-05-13 00:00:00"),
            "fcst": 8.534826156184813,
            "fcst_lower": 8.108084848375572,
            "fcst_upper": 8.961567463994054,
        },
        {
            "time": Timestamp("2013-05-14 00:00:00"),
            "fcst": 8.534900023006173,
            "fcst_lower": 8.108155021855865,
            "fcst_upper": 8.961645024156482,
        },
        {
            "time": Timestamp("2013-05-15 00:00:00"),
            "fcst": 8.534942342539244,
            "fcst_lower": 8.108195225412281,
            "fcst_upper": 8.961689459666207,
        },
        {
            "time": Timestamp("2013-05-16 00:00:00"),
            "fcst": 8.534966195366975,
            "fcst_lower": 8.108217885598625,
            "fcst_upper": 8.961714505135324,
        },
        {
            "time": Timestamp("2013-05-17 00:00:00"),
            "fcst": 8.53497966067295,
            "fcst_lower": 8.108230677639304,
            "fcst_upper": 8.961728643706598,
        },
        {
            "time": Timestamp("2013-05-18 00:00:00"),
            "fcst": 8.5349872268925,
            "fcst_lower": 8.108237865547874,
            "fcst_upper": 8.961736588237127,
        },
        {
            "time": Timestamp("2013-05-19 00:00:00"),
            "fcst": 8.534991587086816,
            "fcst_lower": 8.108242007732475,
            "fcst_upper": 8.961741166441158,
        },
        {
            "time": Timestamp("2013-05-20 00:00:00"),
            "fcst": 8.534994023665993,
            "fcst_lower": 8.108244322482692,
            "fcst_upper": 8.961743724849294,
        },
        {
            "time": Timestamp("2013-05-21 00:00:00"),
            "fcst": 8.534995306076086,
            "fcst_lower": 8.10824554077228,
            "fcst_upper": 8.961745071379891,
        },
        {
            "time": Timestamp("2013-05-22 00:00:00"),
            "fcst": 8.534996203763152,
            "fcst_lower": 8.108246393574994,
            "fcst_upper": 8.96174601395131,
        },
        {
            "time": Timestamp("2013-05-23 00:00:00"),
            "fcst": 8.53499646024517,
            "fcst_lower": 8.108246637232911,
            "fcst_upper": 8.961746283257428,
        },
        {
            "time": Timestamp("2013-05-24 00:00:00"),
            "fcst": 8.534996844968198,
            "fcst_lower": 8.108247002719787,
            "fcst_upper": 8.961746687216609,
        },
        {
            "time": Timestamp("2013-05-25 00:00:00"),
            "fcst": 8.534996844968198,
            "fcst_lower": 8.108247002719787,
            "fcst_upper": 8.961746687216609,
        },
        {
            "time": Timestamp("2013-05-26 00:00:00"),
            "fcst": 8.534997101450216,
            "fcst_lower": 8.108247246377704,
            "fcst_upper": 8.961746956522727,
        },
        {
            "time": Timestamp("2013-05-27 00:00:00"),
            "fcst": 8.534997101450216,
            "fcst_lower": 8.108247246377704,
            "fcst_upper": 8.961746956522727,
        },
        {
            "time": Timestamp("2013-05-28 00:00:00"),
            "fcst": 8.534997101450216,
            "fcst_lower": 8.108247246377704,
            "fcst_upper": 8.961746956522727,
        },
        {
            "time": Timestamp("2013-05-29 00:00:00"),
            "fcst": 8.534997101450216,
            "fcst_lower": 8.108247246377704,
            "fcst_upper": 8.961746956522727,
        },
        {
            "time": Timestamp("2013-05-30 00:00:00"),
            "fcst": 8.534997101450216,
            "fcst_lower": 8.108247246377704,
            "fcst_upper": 8.961746956522727,
        },
    ]
)
