#!/usr/bin/env python
"""
@author: Syed Mahir Tazwar
"""

# Determine word affect based on the NRC emotional lexicon
# Input should be a list of words
# Library is built on TextBlob

from textblob import TextBlob
from collections import Counter
import pandas as pd
import copy


def build_word_affect(self):
    # Build word affect function
    affect_list = []
    affect_values = dict()
    affect_dict = dict()
    df=[]
    affect_frequencies = Counter()
    word_frequencies = Counter()
    lexicon_keys = self.lexicon.keys()
    for word in self.text:
        if word in lexicon_keys:
            affect_list.extend(self.lexicon[word])
            affect_dict.update({word: self.lexicon[word]})
    for word in affect_list:
        affect_frequencies[word] += 1
    for word in self.text:
        word_frequencies[word] += 1
    my_dict = copy.deepcopy(affect_dict)
    for word in my_dict.keys():
        my_dict[word].update((x, y*word_frequencies[word]) for x, y in my_dict[word].items())  # update the affect dict values with frequency of the word in word_frequency
    sum_values = sum(affect_frequencies.values())
    df = pd.DataFrame(my_dict.values()).fillna(0)
    affect_values = df.sum(axis=0).to_dict()
    my_dict = dict()
    self.affect_list = affect_list
    self.affect_dict = affect_dict
    self.weighted_emotion_scores = affect_values
    self.raw_emotion_scores = dict(affect_frequencies)
    self.word_frequencies = dict(word_frequencies)






class Emo:
    """Lexicon source is (C) 2016 National Research Council Canada (NRC) and library is for research purposes only.  Source: http://sentiment.nrc.ca/lexicons-for-research/"""

    lexicon = {'outraged': {'anger': 0.9640000000000001}, 'brutality': {'anger': 0.9590000000000001, 'fear': 0.922}, 'hatred': {'anger': 0.953, 'disgust': 0.68, 'fear': 0.703, 'sadness': 0.6409999999999999}, 'hateful': {'anger': 0.94, 'disgust': 0.703, 'fear': 0.578, 'sadness': 0.575}, 'terrorize': {'anger': 0.9390000000000001, 'fear': 0.922, 'sadness': 0.7809999999999999}, 'infuriated': {'anger': 0.938}, 'violently': {'anger': 0.938, 'disgust': 0.609, 'fear': 0.828, 'sadness': 0.7190000000000001}, 'furious': {'anger': 0.929, 'disgust': 0.469}, 'enraged': {'anger': 0.927}, 'furiously': {'anger': 0.927}, 'screwyou': {'anger': 0.924}, 'murderer': {'anger': 0.922, 'disgust': 0.82, 'fear': 0.953, 'sadness': 0.877}, 'fury': {'anger': 0.922, 'fear': 0.672, 'sadness': 0.406}, 'execution': {'anger': 0.917, 'fear': 0.8440000000000001, 'sadness': 0.8590000000000001, 'trust': 0.32799999999999996}, 'angered': {'anger': 0.9159999999999999}, 'savagery': {'anger': 0.915, 'fear': 0.875}, 'slaughtering': {'anger': 0.914, 'disgust': 0.828, 'fear': 0.875, 'sadness': 0.8440000000000001, 'surprise': 0.625}, 'veryangry': {'anger': 0.9129999999999999}, 'assassinate': {'anger': 0.912, 'fear': 0.9059999999999999}, 'fuckoff': {'anger': 0.912}, 'annihilation': {'anger': 0.912, 'fear': 0.875, 'sadness': 0.828}, 'rage': {'anger': 0.9109999999999999}, 'loathe': {'anger': 0.909, 'disgust': 0.617}, 'damnation': {'anger': 0.9059999999999999, 'fear': 0.812, 'sadness': 0.75}, 'roadrage': {'anger': 0.9059999999999999}, 'fucktard': {'anger': 0.9059999999999999}, 'homicidal': {'anger': 0.9059999999999999, 'fear': 0.9590000000000001}, 'furor': {'anger': 0.9}, 'hostile': {'anger': 0.898, 'disgust': 0.609, 'fear': 0.688}, 'annihilate': {'anger': 0.898, 'fear': 0.953}, 'murder': {'anger': 0.897, 'disgust': 0.8390000000000001, 'fear': 0.9059999999999999, 'sadness': 0.828, 'surprise': 0.617}, 'raging': {'anger': 0.8959999999999999, 'disgust': 0.484, 'fear': 0.6409999999999999}, 'sopissed': {'anger': 0.894}, 'pissed': {'anger': 0.894}, 'rape': {'anger': 0.894, 'disgust': 0.9059999999999999, 'fear': 0.87, 'sadness': 0.875}, 'explosive': {'anger': 0.894, 'anticipation': 0.523, 'fear': 0.8590000000000001, 'surprise': 0.883}, 'obliterated': {'anger': 0.894, 'fear': 0.8}, 'vengeful': {'anger': 0.894, 'fear': 0.625}, 'ferocious': {'anger': 0.894, 'disgust': 0.42200000000000004, 'fear': 0.667}, 'infuriates': {'anger': 0.894}, 'killing': {'anger': 0.893, 'fear': 0.9059999999999999, 'sadness': 0.812}, 'combative': {'anger': 0.8909999999999999, 'fear': 0.625}, 'gofuckyourself': {'anger': 0.8859999999999999}, 'vengeance': {'anger': 0.8859999999999999, 'fear': 0.8440000000000001}, 'wrath': {'anger': 0.885, 'fear': 0.609}, 'torment': {'anger': 0.885, 'fear': 0.8059999999999999, 'sadness': 0.828}, 'vicious': {'anger': 0.884, 'disgust': 0.7190000000000001}, 'threatening': {'anger': 0.882, 'disgust': 0.555, 'fear': 0.875}, 'massacre': {'anger': 0.882, 'disgust': 0.883, 'fear': 0.9109999999999999, 'sadness': 0.9309999999999999}, 'bloodthirsty': {'anger': 0.875, 'disgust': 0.852, 'fear': 0.922}, 'abhorrent': {'anger': 0.875, 'disgust': 0.68, 'fear': 0.672}, 'pissoff': {'anger': 0.875}, 'fighting': {'anger': 0.868}, 'annihilated': {'anger': 0.865, 'fear': 0.8590000000000001, 'sadness': 0.828}, 'attacking': {'anger': 0.865, 'disgust': 0.547, 'fear': 0.8590000000000001, 'sadness': 0.531, 'surprise': 0.648}, 'angriest': {'anger': 0.8640000000000001}, 'bloodshed': {'anger': 0.8640000000000001, 'disgust': 0.7140000000000001, 'fear': 0.8590000000000001, 'sadness': 0.836, 'surprise': 0.6559999999999999}, 'smite': {'anger': 0.862, 'fear': 0.516, 'sadness': 0.555}, 'brawl': {'anger': 0.861, 'disgust': 0.531, 'fear': 0.688}, 'assault': {'anger': 0.8590000000000001, 'fear': 0.8909999999999999}, 'assassination': {'anger': 0.8590000000000001, 'fear': 0.828, 'sadness': 0.797}, 'strangle': {'anger': 0.8590000000000001, 'disgust': 0.617, 'fear': 0.75, 'sadness': 0.703, 'surprise': 0.609}, 'explode': {'anger': 0.8590000000000001, 'fear': 0.828, 'sadness': 0.5, 'surprise': 0.9059999999999999}, 'malicious': {'anger': 0.8590000000000001, 'disgust': 0.617, 'fear': 0.6559999999999999, 'sadness': 0.7190000000000001}, 'tirade': {'anger': 0.8590000000000001, 'disgust': 0.5}, 'hostility': {'anger': 0.8590000000000001, 'disgust': 0.594}, 'loathsome': {'anger': 0.857, 'disgust': 0.773}, 'attack': {'anger': 0.853, 'fear': 0.797}, 'hell': {'anger': 0.853, 'disgust': 0.68, 'fear': 0.86, 'sadness': 0.7}, 'murderous': {'anger': 0.853, 'disgust': 0.789, 'fear': 0.92, 'sadness': 0.8440000000000001, 'surprise': 0.625}, 'malice': {'anger': 0.852, 'fear': 0.625}, 'terrorism': {'anger': 0.851, 'disgust': 0.7340000000000001, 'fear': 0.9690000000000001, 'sadness': 0.812}, 'beating': {'anger': 0.8490000000000001, 'fear': 0.609, 'sadness': 0.652}, 'pissingmeoff': {'anger': 0.848}, 'desecration': {'anger': 0.848, 'disgust': 0.82, 'fear': 0.578, 'sadness': 0.7809999999999999}, 'outrage': {'anger': 0.848, 'disgust': 0.469}, 'irate': {'anger': 0.8440000000000001}, 'tumultuous': {'anger': 0.8440000000000001, 'fear': 0.578}, 'destroying': {'anger': 0.8440000000000001, 'fear': 0.8440000000000001, 'sadness': 0.7340000000000001}, 'violent': {'anger': 0.8440000000000001, 'disgust': 0.711, 'fear': 0.812, 'surprise': 0.648}, 'stab': {'anger': 0.8440000000000001, 'fear': 0.672, 'sadness': 0.688, 'surprise': 0.695}, 'infuriate': {'anger': 0.8440000000000001}, 'slaughter': {'anger': 0.8440000000000001, 'disgust': 0.875, 'fear': 0.8909999999999999, 'sadness': 0.7340000000000001, 'surprise': 0.742}, 'abomination': {'anger': 0.8440000000000001, 'disgust': 0.742, 'fear': 0.8440000000000001}, 'obliterate': {'anger': 0.843, 'fear': 0.7659999999999999, 'sadness': 0.594}, 'dumbbitch': {'anger': 0.841}, 'belligerent': {'anger': 0.841, 'fear': 0.594}, 'detest': {'anger': 0.838, 'disgust': 0.68}, 'hostilities': {'anger': 0.8370000000000001, 'fear': 0.586}, 'prick': {'anger': 0.835, 'disgust': 0.461, 'fear': 0.43799999999999994, 'surprise': 0.484}, 'cruelty': {'anger': 0.833, 'disgust': 0.758, 'fear': 0.797, 'sadness': 0.812}, 'horrid': {'anger': 0.833, 'disgust': 0.648, 'fear': 0.705, 'sadness': 0.7340000000000001}, 'rampage': {'anger': 0.833, 'fear': 0.7809999999999999}, 'rabid': {'anger': 0.833, 'anticipation': 0.43799999999999994, 'disgust': 0.688, 'fear': 0.688, 'sadness': 0.375}, 'torture': {'anger': 0.833, 'anticipation': 0.47700000000000004, 'disgust': 0.828, 'fear': 0.9840000000000001, 'sadness': 0.7659999999999999}, 'satanic': {'anger': 0.828}, 'hate': {'anger': 0.828, 'disgust': 0.695, 'fear': 0.484, 'sadness': 0.6559999999999999}, 'hating': {'anger': 0.828}, 'tyrannical': {'anger': 0.828, 'disgust': 0.562, 'fear': 0.7340000000000001}, 'demonic': {'anger': 0.828, 'disgust': 0.742, 'fear': 0.8590000000000001, 'sadness': 0.6559999999999999}, 'ragemode': {'anger': 0.828}, 'despicable': {'anger': 0.828, 'disgust': 0.7340000000000001}, 'ruinous': {'anger': 0.825, 'disgust': 0.578, 'fear': 0.625, 'sadness': 0.698}, 'condemn': {'anger': 0.825}, 'extermination': {'anger': 0.8240000000000001, 'fear': 0.797}, 'riots': {'anger': 0.8240000000000001}, 'dickhead': {'anger': 0.8240000000000001}, 'angry': {'anger': 0.8240000000000001, 'disgust': 0.469}, 'demolish': {'anger': 0.8240000000000001, 'sadness': 0.636}, 'livid': {'anger': 0.821, 'disgust': 0.469}, 'madman': {'anger': 0.82, 'fear': 0.625}, 'vindictive': {'anger': 0.8190000000000001, 'disgust': 0.648}, 'ferocity': {'anger': 0.818}, 'terrorist': {'anger': 0.818, 'disgust': 0.82, 'fear': 0.972, 'sadness': 0.75, 'surprise': 0.672}, 'venomous': {'anger': 0.818, 'disgust': 0.609, 'fear': 0.7809999999999999}, 'threaten': {'anger': 0.818, 'anticipation': 0.484, 'fear': 0.7340000000000001}, 'hateyou': {'anger': 0.818}, 'effyou': {'anger': 0.818}, 'abhor': {'anger': 0.816, 'disgust': 0.609, 'fear': 0.547}, 'carnage': {'anger': 0.8140000000000001, 'disgust': 0.7809999999999999, 'fear': 0.7170000000000001, 'sadness': 0.833, 'surprise': 0.688}, 'savage': {'anger': 0.8140000000000001, 'fear': 0.8140000000000001}, 'atrocity': {'anger': 0.8140000000000001, 'disgust': 0.7340000000000001, 'fear': 0.672, 'sadness': 0.8590000000000001}, 'fuming': {'anger': 0.812}, 'pissedoff': {'anger': 0.812}, 'pissesmeoff': {'anger': 0.812}, 'fierce': {'anger': 0.812, 'disgust': 0.35200000000000004, 'fear': 0.469}, 'abuse': {'anger': 0.812, 'disgust': 0.695, 'fear': 0.672, 'sadness': 0.625}, 'barbaric': {'anger': 0.812, 'disgust': 0.7190000000000001, 'fear': 0.8590000000000001}, 'berserk': {'anger': 0.812}, 'fucksake': {'anger': 0.812}, 'vendetta': {'anger': 0.812, 'fear': 0.703, 'sadness': 0.594}, 'angrytweet': {'anger': 0.812}, 'destroyer': {'anger': 0.812, 'fear': 0.75}, 'tyrant': {'anger': 0.812, 'disgust': 0.711, 'fear': 0.7879999999999999, 'sadness': 0.625}, 'anger': {'anger': 0.8109999999999999}, 'pieceofshit': {'anger': 0.81}, 'slam': {'anger': 0.8029999999999999, 'fear': 0.484, 'surprise': 0.703}, 'punching': {'anger': 0.8029999999999999}, 'homicide': {'anger': 0.8029999999999999, 'disgust': 0.836, 'fear': 0.8590000000000001, 'sadness': 0.8440000000000001}, 'punched': {'anger': 0.8029999999999999}, 'bitch': {'anger': 0.8029999999999999, 'disgust': 0.648, 'fear': 0.297, 'sadness': 0.406}, 'fights': {'anger': 0.8029999999999999}, 'destructive': {'anger': 0.797, 'disgust': 0.531, 'fear': 0.812}, 'ruthless': {'anger': 0.797, 'disgust': 0.562, 'fear': 0.6559999999999999}, 'villainous': {'anger': 0.797, 'disgust': 0.6409999999999999, 'fear': 0.594}, 'slap': {'anger': 0.7909999999999999, 'surprise': 0.68}, 'destroyed': {'anger': 0.7879999999999999, 'fear': 0.754, 'sadness': 0.8440000000000001}, 'ragetweet': {'anger': 0.7879999999999999}, 'slaughterhouse': {'anger': 0.7879999999999999, 'disgust': 0.867, 'fear': 0.8590000000000001, 'sadness': 0.703}, 'retaliatory': {'anger': 0.7879999999999999}, 'yelling': {'anger': 0.7879999999999999}, 'riot': {'anger': 0.7879999999999999, 'fear': 0.7659999999999999}, 'punishing': {'anger': 0.7879999999999999, 'fear': 0.562, 'sadness': 0.703}, 'growthefuckup': {'anger': 0.7879999999999999}, 'diabolical': {'anger': 0.7879999999999999, 'disgust': 0.727, 'fear': 0.703}, 'clash': {'anger': 0.7829999999999999}, 'manslaughter': {'anger': 0.7829999999999999, 'disgust': 0.812, 'fear': 0.828, 'sadness': 0.833, 'surprise': 0.7190000000000001}, 'hellish': {'anger': 0.7809999999999999, 'disgust': 0.695, 'fear': 0.828, 'sadness': 0.738}, 'bloody': {'anger': 0.7809999999999999, 'disgust': 0.555, 'fear': 0.7809999999999999, 'sadness': 0.8059999999999999}, 'loath': {'anger': 0.7809999999999999}, 'quarrel': {'anger': 0.7809999999999999}, 'detonation': {'anger': 0.7809999999999999}, 'sinister': {'anger': 0.7809999999999999, 'disgust': 0.75, 'fear': 0.672}, 'fumin': {'anger': 0.779}, 'hateeee': {'anger': 0.779}, 'treacherous': {'anger': 0.779, 'disgust': 0.57, 'fear': 0.75}, 'accusing': {'anger': 0.779, 'fear': 0.484}, 'madder': {'anger': 0.773}, 'retaliate': {'anger': 0.773}, 'revulsion': {'anger': 0.773, 'disgust': 0.7659999999999999, 'fear': 0.516}, 'horrific': {'anger': 0.773, 'disgust': 0.789, 'fear': 0.9690000000000001, 'sadness': 0.8440000000000001}, 'scorn': {'anger': 0.769}, 'bomb': {'anger': 0.7659999999999999, 'fear': 0.935, 'sadness': 0.621, 'surprise': 0.789}, 'deplorable': {'anger': 0.7659999999999999, 'disgust': 0.516, 'fear': 0.609, 'sadness': 0.75}, 'anarchist': {'anger': 0.765, 'fear': 0.75}, 'devastation': {'anger': 0.765, 'fear': 0.9059999999999999, 'sadness': 0.917, 'surprise': 0.703}, 'resent': {'anger': 0.765}, 'firestorm': {'anger': 0.765}, 'contemptible': {'anger': 0.764, 'disgust': 0.625}, 'shittest': {'anger': 0.76}, 'smash': {'anger': 0.758, 'fear': 0.6559999999999999}, 'deadly': {'anger': 0.758, 'disgust': 0.664, 'fear': 0.875, 'sadness': 0.898}, 'soangry': {'anger': 0.758}, 'rant': {'anger': 0.758}, 'cruel': {'anger': 0.758, 'disgust': 0.7659999999999999, 'fear': 0.6559999999999999, 'sadness': 0.609}, 'outburst': {'anger': 0.757, 'fear': 0.547, 'joy': 0.17600000000000002, 'sadness': 0.531, 'surprise': 0.8590000000000001}, 'snarl': {'anger': 0.754, 'disgust': 0.484}, 'crazed': {'anger': 0.75, 'fear': 0.6559999999999999}, 'dontmesswithme': {'anger': 0.75}, 'profane': {'anger': 0.75}, 'aggravating': {'anger': 0.75, 'sadness': 0.5}, 'douchebags': {'anger': 0.75}, 'offend': {'anger': 0.75, 'disgust': 0.42200000000000004}, 'horror': {'anger': 0.75, 'disgust': 0.6559999999999999, 'fear': 0.9229999999999999, 'sadness': 0.7190000000000001, 'surprise': 0.742}, 'revolting': {'anger': 0.75, 'disgust': 0.82, 'fear': 0.625}, 'despise': {'anger': 0.75, 'disgust': 0.57}, 'vulgarity': {'anger': 0.75, 'disgust': 0.703, 'sadness': 0.45299999999999996}, 'growling': {'anger': 0.75, 'disgust': 0.297, 'fear': 0.547}, 'stfu': {'anger': 0.75}, 'molestation': {'anger': 0.742, 'disgust': 0.914, 'fear': 0.8590000000000001, 'sadness': 0.7440000000000001}, 'fuckedoff': {'anger': 0.742}, 'erupt': {'anger': 0.742, 'surprise': 0.789}, 'violence': {'anger': 0.742, 'fear': 0.812, 'sadness': 0.7120000000000001}, 'horrible': {'anger': 0.742, 'disgust': 0.6559999999999999, 'fear': 0.7340000000000001}, 'screaming': {'anger': 0.742, 'disgust': 0.5, 'fear': 0.7809999999999999}, 'threat': {'anger': 0.742, 'fear': 0.604}, 'bastards': {'anger': 0.741}, 'revenge': {'anger': 0.738, 'anticipation': 0.602, 'fear': 0.6559999999999999, 'surprise': 0.57}, 'menacing': {'anger': 0.735, 'fear': 0.672}, 'crushing': {'anger': 0.735, 'disgust': 0.39799999999999996, 'fear': 0.672, 'sadness': 0.609}, 'damn': {'anger': 0.735, 'disgust': 0.359}, 'catastrophe': {'anger': 0.735, 'disgust': 0.594, 'fear': 0.953, 'sadness': 0.9109999999999999, 'surprise': 0.836}, 'demon': {'anger': 0.735, 'disgust': 0.742, 'fear': 0.9059999999999999, 'sadness': 0.594}, 'argue': {'anger': 0.7340000000000001}, 'fedup': {'anger': 0.7340000000000001}, 'vehement': {'anger': 0.7340000000000001, 'fear': 0.6409999999999999}, 'thrash': {'anger': 0.7340000000000001, 'disgust': 0.539, 'fear': 0.562, 'sadness': 0.344}, 'warfare': {'anger': 0.7340000000000001, 'fear': 0.8590000000000001, 'sadness': 0.7340000000000001}, 'revolt': {'anger': 0.7340000000000001, 'surprise': 0.6559999999999999}, 'flog': {'anger': 0.7340000000000001, 'disgust': 0.57, 'fear': 0.653, 'sadness': 0.562}, 'deplore': {'anger': 0.7340000000000001, 'disgust': 0.461, 'sadness': 0.5760000000000001}, 'persecute': {'anger': 0.7340000000000001, 'fear': 0.672}, 'riotous': {'anger': 0.7340000000000001, 'fear': 0.75, 'surprise': 0.727}, 'altercation': {'anger': 0.7290000000000001}, 'warlike': {'anger': 0.728, 'fear': 0.7809999999999999}, 'mutiny': {'anger': 0.727, 'disgust': 0.484, 'fear': 0.7340000000000001, 'surprise': 0.648}, 'shitday': {'anger': 0.727}, 'sabotage': {'anger': 0.727, 'disgust': 0.609, 'fear': 0.703, 'sadness': 0.484, 'surprise': 0.7190000000000001}, 'castrate': {'anger': 0.727}, 'strike': {'anger': 0.721, 'surprise': 0.695}, 'malevolent': {'anger': 0.721, 'disgust': 0.547, 'fear': 0.703, 'sadness': 0.672}, 'disaster': {'anger': 0.721, 'disgust': 0.508, 'fear': 0.875, 'sadness': 0.758, 'surprise': 0.812}, 'disastrous': {'anger': 0.72, 'fear': 0.875, 'sadness': 0.7340000000000001}, 'disdain': {'anger': 0.7190000000000001, 'disgust': 0.39799999999999996}, 'choke': {'anger': 0.7190000000000001, 'sadness': 0.682}, 'arseholes': {'anger': 0.7190000000000001}, 'devil': {'anger': 0.7190000000000001, 'anticipation': 0.273, 'disgust': 0.664, 'fear': 0.828, 'sadness': 0.5760000000000001}, 'scream': {'anger': 0.7190000000000001, 'disgust': 0.43799999999999994, 'fear': 0.7190000000000001, 'surprise': 0.7190000000000001}, 'spiteful': {'anger': 0.7190000000000001}, 'bastarding': {'anger': 0.7190000000000001}, 'scorching': {'anger': 0.7190000000000001}, 'horseshit': {'anger': 0.7190000000000001}, 'treachery': {'anger': 0.7190000000000001, 'fear': 0.856, 'sadness': 0.848, 'surprise': 0.633}, 'slay': {'anger': 0.7190000000000001}, 'brutal': {'anger': 0.7190000000000001, 'fear': 0.828}, 'tumult': {'anger': 0.7190000000000001, 'fear': 0.6559999999999999, 'surprise': 0.6409999999999999}, 'madden': {'anger': 0.7190000000000001, 'fear': 0.5}, 'aggravates': {'anger': 0.7190000000000001}, 'vermin': {'anger': 0.7190000000000001, 'disgust': 0.789, 'fear': 0.672}, 'anarchism': {'anger': 0.7140000000000001, 'fear': 0.688}, 'mutilation': {'anger': 0.7140000000000001, 'disgust': 0.93, 'fear': 0.9059999999999999, 'sadness': 0.828}, 'mangle': {'anger': 0.7140000000000001, 'disgust': 0.578, 'fear': 0.672, 'sadness': 0.6559999999999999}, 'criminal': {'anger': 0.7140000000000001, 'disgust': 0.47700000000000004, 'fear': 0.7659999999999999}, 'punch': {'anger': 0.713, 'fear': 0.58, 'sadness': 0.391, 'surprise': 0.539}, 'denunciation': {'anger': 0.713, 'disgust': 0.42200000000000004, 'fear': 0.456}, 'holocaust': {'anger': 0.7120000000000001, 'disgust': 0.852, 'fear': 0.9059999999999999, 'sadness': 0.953}, 'blasphemous': {'anger': 0.7120000000000001, 'disgust': 0.531}, 'battled': {'anger': 0.7120000000000001, 'fear': 0.615, 'sadness': 0.5}, 'dumbasses': {'anger': 0.7120000000000001}, 'fatal': {'anger': 0.7120000000000001, 'fear': 0.828, 'sadness': 0.922}, 'virulence': {'anger': 0.7120000000000001, 'fear': 0.625}, 'dontlikeyou': {'anger': 0.7120000000000001}, 'hurting': {'anger': 0.7120000000000001, 'fear': 0.672, 'sadness': 0.625}, 'crucifixion': {'anger': 0.7120000000000001, 'disgust': 0.7340000000000001, 'fear': 0.8909999999999999, 'sadness': 0.8590000000000001}, 'deranged': {'anger': 0.706, 'disgust': 0.742, 'fear': 0.703}, 'evil': {'anger': 0.706, 'disgust': 0.758, 'fear': 0.833, 'sadness': 0.672}, 'irritated': {'anger': 0.706}, 'atrocious': {'anger': 0.706, 'disgust': 0.617}, 'assassin': {'anger': 0.703, 'fear': 0.875, 'sadness': 0.7340000000000001}, 'intimidation': {'anger': 0.703, 'fear': 0.5589999999999999}, 'persecution': {'anger': 0.703, 'disgust': 0.625, 'fear': 0.797, 'sadness': 0.8440000000000001}, 'slayer': {'anger': 0.703, 'disgust': 0.555, 'fear': 0.8440000000000001, 'sadness': 0.7659999999999999, 'surprise': 0.5}, 'kidnap': {'anger': 0.703, 'fear': 0.8909999999999999, 'sadness': 0.682, 'surprise': 0.7659999999999999}, 'dicks': {'anger': 0.703}, 'scolding': {'anger': 0.703}, 'aggravated': {'anger': 0.703}, 'aggression': {'anger': 0.7020000000000001, 'fear': 0.609}, 'armed': {'anger': 0.7, 'fear': 0.703}, 'poison': {'anger': 0.6970000000000001, 'disgust': 0.6559999999999999, 'fear': 0.797, 'sadness': 0.672}, 'snarling': {'anger': 0.6970000000000001}, 'venom': {'anger': 0.6970000000000001, 'disgust': 0.594, 'fear': 0.804}, 'battle': {'anger': 0.6970000000000001}, 'disgruntled': {'anger': 0.693, 'disgust': 0.406, 'sadness': 0.7120000000000001}, 'assailant': {'anger': 0.691, 'fear': 0.703, 'sadness': 0.536}, 'insidious': {'anger': 0.691, 'disgust': 0.773, 'fear': 0.516}, 'resentment': {'anger': 0.691, 'disgust': 0.508, 'sadness': 0.562}, 'contemptuous': {'anger': 0.69}, 'lynch': {'anger': 0.69, 'disgust': 0.7659999999999999, 'fear': 0.7190000000000001, 'sadness': 0.773}, 'lunatic': {'anger': 0.688, 'disgust': 0.594, 'fear': 0.6559999999999999}, 'mad': {'anger': 0.688, 'disgust': 0.484, 'fear': 0.547, 'sadness': 0.5}, 'peeved': {'anger': 0.688}, 'bully': {'anger': 0.688, 'fear': 0.6559999999999999, 'sadness': 0.578}, 'temper': {'anger': 0.688}, 'infanticide': {'anger': 0.688, 'anticipation': 0.32, 'disgust': 0.836, 'fear': 0.609}, 'curse': {'anger': 0.688, 'disgust': 0.43, 'fear': 0.578, 'sadness': 0.608}, 'domination': {'anger': 0.688, 'fear': 0.5660000000000001, 'sadness': 0.469}, 'imprisonment': {'anger': 0.688, 'disgust': 0.602, 'fear': 0.75, 'sadness': 0.672}, 'terrible': {'anger': 0.688, 'disgust': 0.562, 'fear': 0.594, 'sadness': 0.578}, 'disparage': {'anger': 0.688, 'disgust': 0.45299999999999996, 'sadness': 0.672}, 'makesmemad': {'anger': 0.688}, 'volatility': {'anger': 0.687, 'anticipation': 0.42200000000000004, 'fear': 0.578, 'surprise': 0.695}, 'eradication': {'anger': 0.685, 'disgust': 0.516, 'fear': 0.828}, 'scoundrel': {'anger': 0.682, 'disgust': 0.562, 'fear': 0.6409999999999999, 'trust': 0.11699999999999999}, 'eradicate': {'anger': 0.682}, 'tantrum': {'anger': 0.682}, 'devastate': {'anger': 0.682, 'fear': 0.792, 'sadness': 0.797}, 'agitation': {'anger': 0.68}, 'aggressively': {'anger': 0.68}, 'irritates': {'anger': 0.6759999999999999}, 'dictatorship': {'anger': 0.6759999999999999, 'anticipation': 0.23399999999999999, 'disgust': 0.672, 'fear': 0.7340000000000001, 'sadness': 0.509}, 'profanity': {'anger': 0.6729999999999999}, 'dastardly': {'anger': 0.672, 'disgust': 0.625, 'fear': 0.6409999999999999}, 'expletive': {'anger': 0.672}, 'wreak': {'anger': 0.672}, 'contempt': {'anger': 0.672, 'disgust': 0.484, 'fear': 0.359}, 'crime': {'anger': 0.672, 'fear': 0.7190000000000001}, 'poisonous': {'anger': 0.672, 'disgust': 0.6559999999999999, 'fear': 0.812, 'sadness': 0.6409999999999999}, 'nasty': {'anger': 0.672, 'disgust': 0.703, 'fear': 0.466, 'sadness': 0.484}, 'aggravation': {'anger': 0.672, 'disgust': 0.469}, 'condemnation': {'anger': 0.672, 'anticipation': 0.391, 'disgust': 0.547, 'fear': 0.637, 'sadness': 0.754}, 'egregious': {'anger': 0.672, 'disgust': 0.57}, 'shove': {'anger': 0.672}, 'shoot': {'anger': 0.672, 'fear': 0.7340000000000001}, 'shot': {'anger': 0.672, 'fear': 0.7340000000000001, 'sadness': 0.547, 'surprise': 0.711}, 'crushed': {'anger': 0.672, 'disgust': 0.35200000000000004, 'fear': 0.812, 'sadness': 0.703}, 'corrupting': {'anger': 0.672, 'disgust': 0.75, 'fear': 0.562, 'sadness': 0.565}, 'harmful': {'anger': 0.672, 'disgust': 0.562, 'fear': 0.797, 'sadness': 0.578}, 'cruelly': {'anger': 0.672, 'fear': 0.6579999999999999}, 'maniac': {'anger': 0.67, 'fear': 0.7809999999999999}, 'irritable': {'anger': 0.667}, 'shooting': {'anger': 0.667, 'fear': 0.812, 'sadness': 0.688}, 'odious': {'anger': 0.667, 'disgust': 0.555, 'fear': 0.5}, 'shout': {'anger': 0.667, 'surprise': 0.6409999999999999}, 'eruption': {'anger': 0.667, 'fear': 0.672, 'surprise': 0.883}, 'cutthroat': {'anger': 0.667, 'fear': 0.664}, 'kick': {'anger': 0.667}, 'hateeveryone': {'anger': 0.667}, 'hit': {'anger': 0.667}, 'fight': {'anger': 0.667, 'fear': 0.7190000000000001}, 'enemy': {'anger': 0.667, 'disgust': 0.562, 'fear': 0.625}, 'combat': {'anger': 0.667, 'fear': 0.728}, 'aggressive': {'anger': 0.667, 'fear': 0.703}, 'punished': {'anger': 0.662, 'anticipation': 0.406, 'disgust': 0.391, 'fear': 0.6409999999999999, 'sadness': 0.672}, 'yell': {'anger': 0.6609999999999999, 'fear': 0.43799999999999994, 'surprise': 0.695}, 'ambush': {'anger': 0.6609999999999999, 'fear': 0.688, 'surprise': 0.883}, 'harass': {'anger': 0.659, 'disgust': 0.586}, 'gore': {'anger': 0.6559999999999999, 'disgust': 0.828, 'fear': 0.7340000000000001, 'sadness': 0.609}, 'expel': {'anger': 0.6559999999999999, 'disgust': 0.391, 'fear': 0.43799999999999994, 'sadness': 0.414}, 'malignant': {'anger': 0.6559999999999999, 'fear': 0.7340000000000001}, 'destruction': {'anger': 0.6559999999999999, 'fear': 0.797}, 'aggressor': {'anger': 0.6559999999999999, 'fear': 0.812}, 'incense': {'anger': 0.6559999999999999, 'joy': 0.23399999999999999}, 'grudge': {'anger': 0.6559999999999999}, 'antichrist': {'anger': 0.6559999999999999, 'disgust': 0.68, 'fear': 0.6409999999999999}, 'cranky': {'anger': 0.653}, 'reprisal': {'anger': 0.652, 'fear': 0.7659999999999999, 'sadness': 0.484}, 'slave': {'anger': 0.652, 'fear': 0.531, 'sadness': 0.797}, 'growl': {'anger': 0.652, 'fear': 0.516}, 'offended': {'anger': 0.652, 'sadness': 0.5}, 'clashing': {'anger': 0.652, 'fear': 0.578}, 'insulting': {'anger': 0.652, 'disgust': 0.461, 'fear': 0.435, 'sadness': 0.391}, 'insurrection': {'anger': 0.652}, 'spank': {'anger': 0.652, 'fear': 0.5870000000000001, 'sadness': 0.40299999999999997}, 'animosity': {'anger': 0.652, 'disgust': 0.484, 'fear': 0.469, 'sadness': 0.43799999999999994}, 'denounce': {'anger': 0.652, 'disgust': 0.43}, 'growls': {'anger': 0.649}, 'executioner': {'anger': 0.644, 'fear': 0.8590000000000001, 'sadness': 0.667}, 'twat': {'anger': 0.644}, 'doomsday': {'anger': 0.643, 'anticipation': 0.5, 'disgust': 0.633, 'fear': 0.828, 'sadness': 0.75}, 'bombard': {'anger': 0.6409999999999999, 'fear': 0.74}, 'feud': {'anger': 0.6409999999999999}, 'accused': {'anger': 0.6409999999999999, 'fear': 0.469}, 'arson': {'anger': 0.6409999999999999, 'fear': 0.794}, 'daemon': {'anger': 0.6409999999999999, 'disgust': 0.516, 'fear': 0.625, 'sadness': 0.391, 'surprise': 0.484}, 'shackle': {'anger': 0.6409999999999999, 'anticipation': 0.289, 'disgust': 0.5, 'fear': 0.609, 'sadness': 0.609}, 'indignant': {'anger': 0.6409999999999999}, 'obscenity': {'anger': 0.6409999999999999, 'disgust': 0.625}, 'spat': {'anger': 0.6409999999999999}, 'havoc': {'anger': 0.6409999999999999, 'fear': 0.7190000000000001}, 'grr': {'anger': 0.6409999999999999}, 'inexcusable': {'anger': 0.6409999999999999, 'disgust': 0.484, 'sadness': 0.379}, 'expulsion': {'anger': 0.6409999999999999, 'disgust': 0.578, 'fear': 0.547, 'sadness': 0.469}, 'reprimand': {'anger': 0.6409999999999999}, 'somad': {'anger': 0.637}, 'poisoned': {'anger': 0.636, 'disgust': 0.711, 'fear': 0.8859999999999999, 'sadness': 0.667}, 'kicking': {'anger': 0.636}, 'wound': {'anger': 0.636, 'fear': 0.5710000000000001, 'sadness': 0.625}, 'batter': {'anger': 0.636, 'fear': 0.45299999999999996}, 'frustrated': {'anger': 0.636}, 'hanging': {'anger': 0.636, 'disgust': 0.531, 'fear': 0.6409999999999999, 'sadness': 0.547}, 'disgusting': {'anger': 0.636, 'disgust': 0.703, 'fear': 0.484}, 'spanking': {'anger': 0.636}, 'suicidal': {'anger': 0.636, 'disgust': 0.695, 'fear': 0.898, 'sadness': 0.941}, 'anarchy': {'anger': 0.636, 'fear': 0.75}, 'glaring': {'anger': 0.636}, 'combatant': {'anger': 0.636, 'fear': 0.672}, 'wrecked': {'anger': 0.633, 'fear': 0.703, 'sadness': 0.625}, 'inflict': {'anger': 0.633, 'fear': 0.562, 'sadness': 0.531}, 'grievous': {'anger': 0.632, 'fear': 0.516, 'sadness': 0.7040000000000001}, 'cheat': {'anger': 0.63, 'disgust': 0.508}, 'prosecute': {'anger': 0.63, 'fear': 0.609, 'sadness': 0.5}, 'agitated': {'anger': 0.63}, 'swastika': {'anger': 0.627, 'fear': 0.531}, 'enslaved': {'anger': 0.625, 'disgust': 0.836, 'fear': 0.7809999999999999, 'sadness': 0.828}, 'scourge': {'anger': 0.625, 'fear': 0.609, 'sadness': 0.6409999999999999}, 'raid': {'anger': 0.625, 'fear': 0.6, 'surprise': 0.773}, 'suffocation': {'anger': 0.625, 'fear': 0.875}, 'defamatory': {'anger': 0.625}, 'indict': {'anger': 0.625, 'fear': 0.469}, 'cursing': {'anger': 0.625, 'disgust': 0.43}, 'provocation': {'anger': 0.625}, 'harassing': {'anger': 0.625}, 'injure': {'anger': 0.625, 'fear': 0.625, 'sadness': 0.609}, 'betray': {'anger': 0.625, 'disgust': 0.516, 'sadness': 0.594, 'surprise': 0.602}, 'thundering': {'anger': 0.625, 'fear': 0.625}, 'strife': {'anger': 0.625}, 'arsehole': {'anger': 0.624}, 'jerk': {'anger': 0.621, 'surprise': 0.562}, 'retaliation': {'anger': 0.621, 'fear': 0.6409999999999999}, 'fiend': {'anger': 0.621, 'disgust': 0.578, 'fear': 0.484}, 'theft': {'anger': 0.621, 'disgust': 0.5, 'fear': 0.531, 'sadness': 0.531}, 'insane': {'anger': 0.621, 'fear': 0.6559999999999999}, 'irritate': {'anger': 0.621}, 'deprivation': {'anger': 0.621, 'disgust': 0.602, 'fear': 0.578, 'sadness': 0.672}, 'convict': {'anger': 0.621, 'disgust': 0.516, 'fear': 0.594, 'sadness': 0.469}, 'cussed': {'anger': 0.619}, 'turmoil': {'anger': 0.618, 'fear': 0.733, 'sadness': 0.578}, 'smack': {'anger': 0.615}, 'retribution': {'anger': 0.614, 'fear': 0.545, 'sadness': 0.424}, 'adverse': {'anger': 0.609, 'disgust': 0.43, 'fear': 0.35200000000000004, 'sadness': 0.281}, 'battery': {'anger': 0.609}, 'twats': {'anger': 0.609}, 'collision': {'anger': 0.609}, 'injurious': {'anger': 0.609, 'fear': 0.6409999999999999, 'sadness': 0.5}, 'rebellion': {'anger': 0.609, 'disgust': 0.359, 'fear': 0.531}, 'slavery': {'anger': 0.609, 'disgust': 0.812, 'fear': 0.75, 'sadness': 0.828}, 'gang': {'anger': 0.609, 'fear': 0.672}, 'irritability': {'anger': 0.609}, 'bitterly': {'anger': 0.609, 'disgust': 0.547, 'sadness': 0.625}, 'oppressor': {'anger': 0.609, 'fear': 0.609, 'sadness': 0.703}, 'antagonism': {'anger': 0.609}, 'intolerable': {'anger': 0.609}, 'disgraced': {'anger': 0.608, 'disgust': 0.523, 'sadness': 0.7340000000000001}, 'diatribe': {'anger': 0.606, 'disgust': 0.391}, 'sickening': {'anger': 0.606, 'disgust': 0.742, 'fear': 0.625, 'sadness': 0.75}, 'ranting': {'anger': 0.606}, 'asshole': {'anger': 0.606, 'disgust': 0.836}, 'irks': {'anger': 0.606}, 'irritating': {'anger': 0.606, 'disgust': 0.375}, 'discrimination': {'anger': 0.606, 'disgust': 0.664, 'fear': 0.391, 'sadness': 0.578}, 'bombardment': {'anger': 0.606, 'fear': 0.8440000000000001}, 'thug': {'anger': 0.606, 'disgust': 0.594, 'fear': 0.672}, 'antagonistic': {'anger': 0.606, 'disgust': 0.47700000000000004}, 'revolution': {'anger': 0.606, 'anticipation': 0.6409999999999999, 'fear': 0.359, 'sadness': 0.203, 'surprise': 0.664}, 'blast': {'anger': 0.606, 'fear': 0.688, 'surprise': 0.852}, 'frustrate': {'anger': 0.604, 'disgust': 0.35200000000000004, 'sadness': 0.469}, 'tension': {'anger': 0.603}, 'manipulation': {'anger': 0.603, 'fear': 0.531}, 'oppression': {'anger': 0.603, 'disgust': 0.6559999999999999, 'fear': 0.688, 'sadness': 0.812}, 'hurtful': {'anger': 0.603, 'disgust': 0.36700000000000005, 'fear': 0.625, 'sadness': 0.688}, 'insult': {'anger': 0.603, 'disgust': 0.39299999999999996, 'sadness': 0.484, 'surprise': 0.539}, 'tiredofit': {'anger': 0.603}, 'bigot': {'anger': 0.603, 'disgust': 0.8590000000000001, 'fear': 0.42200000000000004}, 'disgust': {'anger': 0.602, 'disgust': 0.7190000000000001, 'fear': 0.406, 'sadness': 0.531}, 'spite': {'anger': 0.6}, 'intrusive': {'anger': 0.598, 'disgust': 0.531, 'fear': 0.469, 'surprise': 0.617}, 'harshness': {'anger': 0.597, 'fear': 0.516}, 'slur': {'anger': 0.596, 'disgust': 0.547, 'sadness': 0.266}, 'bitterness': {'anger': 0.594, 'disgust': 0.5, 'sadness': 0.578, 'trust': 0.23399999999999999}, 'tempest': {'anger': 0.594, 'anticipation': 0.539, 'fear': 0.423, 'sadness': 0.25, 'surprise': 0.625}, 'miserable': {'anger': 0.594, 'disgust': 0.547, 'sadness': 0.8440000000000001}, 'morbidity': {'anger': 0.594, 'disgust': 0.727, 'fear': 0.82, 'sadness': 0.8640000000000001}, 'assail': {'anger': 0.594, 'fear': 0.578, 'surprise': 0.602}, 'puncture': {'anger': 0.594}, 'invasion': {'anger': 0.594}, 'inferno': {'anger': 0.594, 'fear': 0.7659999999999999}, 'casualty': {'anger': 0.594, 'fear': 0.7190000000000001, 'sadness': 0.828}, 'storming': {'anger': 0.594}, 'wretch': {'anger': 0.594, 'disgust': 0.695, 'sadness': 0.672}, 'consternation': {'anger': 0.5920000000000001, 'fear': 0.359}, 'guillotine': {'anger': 0.591, 'anticipation': 0.39799999999999996, 'disgust': 0.617, 'fear': 0.8590000000000001, 'sadness': 0.446}, 'forcibly': {'anger': 0.591, 'fear': 0.7}, 'overpowering': {'anger': 0.591, 'fear': 0.562}, 'immoral': {'anger': 0.591, 'disgust': 0.648, 'fear': 0.41, 'sadness': 0.578}, 'guilty': {'anger': 0.591, 'sadness': 0.609}, 'depraved': {'anger': 0.591, 'anticipation': 0.391, 'disgust': 0.703, 'fear': 0.7340000000000001, 'sadness': 0.688}, 'raving': {'anger': 0.591, 'anticipation': 0.531, 'fear': 0.5, 'joy': 0.578, 'surprise': 0.578}, 'soannoyed': {'anger': 0.588}, 'recalcitrant': {'anger': 0.588, 'disgust': 0.445}, 'accursed': {'anger': 0.588, 'fear': 0.594, 'sadness': 0.6970000000000001}, 'screwed': {'anger': 0.588}, 'invader': {'anger': 0.588, 'fear': 0.7659999999999999, 'sadness': 0.42}, 'scare': {'anger': 0.588, 'anticipation': 0.469, 'fear': 0.8440000000000001, 'surprise': 0.797}, 'indignation': {'anger': 0.5870000000000001, 'disgust': 0.45299999999999996}, 'jealousy': {'anger': 0.5870000000000001, 'disgust': 0.5, 'fear': 0.365, 'sadness': 0.382, 'trust': 0.188}, 'vexed': {'anger': 0.586}, 'confront': {'anger': 0.5820000000000001}, 'brute': {'anger': 0.581, 'fear': 0.5, 'sadness': 0.391}, 'throttle': {'anger': 0.579}, 'provoking': {'anger': 0.578, 'disgust': 0.32799999999999996}, 'coup': {'anger': 0.578, 'surprise': 0.609}, 'pillage': {'anger': 0.578, 'disgust': 0.547, 'fear': 0.574}, 'damage': {'anger': 0.578, 'disgust': 0.391, 'sadness': 0.578}, 'shutup': {'anger': 0.578}, 'contentious': {'anger': 0.578, 'disgust': 0.42200000000000004, 'fear': 0.344}, 'shutit': {'anger': 0.578}, 'bickering': {'anger': 0.578, 'disgust': 0.336}, 'incarceration': {'anger': 0.578, 'disgust': 0.523, 'fear': 0.625, 'sadness': 0.6409999999999999}, 'butcher': {'anger': 0.578, 'disgust': 0.594, 'fear': 0.609}, 'lash': {'anger': 0.578, 'fear': 0.484}, 'conflict': {'anger': 0.578, 'fear': 0.6409999999999999, 'sadness': 0.469}, 'blaze': {'anger': 0.578}, 'slut': {'anger': 0.578, 'disgust': 0.703}, 'defiant': {'anger': 0.578}, 'wreck': {'anger': 0.578, 'disgust': 0.49200000000000005, 'fear': 0.6409999999999999, 'sadness': 0.45299999999999996, 'surprise': 0.742}, 'revolver': {'anger': 0.578, 'fear': 0.672, 'sadness': 0.45299999999999996}, 'yousuck': {'anger': 0.578}, 'criminality': {'anger': 0.578, 'disgust': 0.6409999999999999, 'fear': 0.642}, 'cancer': {'anger': 0.5770000000000001, 'disgust': 0.7340000000000001, 'fear': 0.828, 'sadness': 0.875}, 'frustration': {'anger': 0.5760000000000001}, 'standoff': {'anger': 0.5760000000000001, 'fear': 0.716}, 'gory': {'anger': 0.5760000000000001, 'disgust': 0.82, 'fear': 0.688, 'sadness': 0.672}, 'dontmess': {'anger': 0.5760000000000001}, 'alienation': {'anger': 0.5760000000000001, 'disgust': 0.375, 'fear': 0.609, 'sadness': 0.685}, 'gun': {'anger': 0.5760000000000001, 'fear': 0.7340000000000001}, 'pernicious': {'anger': 0.5760000000000001, 'fear': 0.516, 'sadness': 0.469}, 'grope': {'anger': 0.5760000000000001, 'disgust': 0.703, 'fear': 0.45299999999999996}, 'discord': {'anger': 0.5760000000000001, 'disgust': 0.38299999999999995}, 'condescension': {'anger': 0.5760000000000001, 'disgust': 0.531, 'sadness': 0.391}, 'discriminate': {'anger': 0.5760000000000001, 'sadness': 0.45299999999999996}, 'blasphemy': {'anger': 0.5760000000000001}, 'chaotic': {'anger': 0.5760000000000001}, 'disturbance': {'anger': 0.5760000000000001, 'fear': 0.45899999999999996, 'sadness': 0.484, 'surprise': 0.688}, 'friggen': {'anger': 0.575}, 'jab': {'anger': 0.574}, 'monstrosity': {'anger': 0.574, 'disgust': 0.7809999999999999, 'fear': 0.797, 'surprise': 0.594}, 'lunacy': {'anger': 0.574, 'disgust': 0.602, 'fear': 0.625, 'sadness': 0.43799999999999994}, 'oppressive': {'anger': 0.574, 'disgust': 0.633, 'fear': 0.6559999999999999, 'sadness': 0.625}, 'scandalous': {'anger': 0.574}, 'cursed': {'anger': 0.574, 'fear': 0.7340000000000001, 'sadness': 0.625}, 'sneer': {'anger': 0.574, 'disgust': 0.539}, 'death': {'anger': 0.574, 'anticipation': 0.39799999999999996, 'disgust': 0.6559999999999999, 'fear': 0.843, 'sadness': 0.915, 'surprise': 0.578}, 'shit': {'anger': 0.573, 'disgust': 0.82}, 'slash': {'anger': 0.5710000000000001}, 'unfair': {'anger': 0.5710000000000001, 'disgust': 0.281, 'sadness': 0.5}, 'disparaging': {'anger': 0.5710000000000001, 'disgust': 0.523, 'sadness': 0.609}, 'gallows': {'anger': 0.57, 'fear': 0.6859999999999999, 'sadness': 0.797}, 'escalate': {'anger': 0.569}, 'intolerant': {'anger': 0.564, 'disgust': 0.531, 'fear': 0.5, 'sadness': 0.5}, 'lawlessness': {'anger': 0.563, 'fear': 0.531}, 'bluddy': {'anger': 0.562}, 'dreadful': {'anger': 0.562, 'anticipation': 0.508, 'disgust': 0.586, 'fear': 0.75, 'sadness': 0.797}, 'arghh': {'anger': 0.562}, 'derogatory': {'anger': 0.562, 'disgust': 0.6409999999999999, 'fear': 0.45299999999999996, 'sadness': 0.609}, 'beast': {'anger': 0.562, 'fear': 0.7340000000000001}, 'malign': {'anger': 0.562, 'disgust': 0.49200000000000005}, 'traitor': {'anger': 0.562, 'disgust': 0.602, 'fear': 0.6559999999999999, 'sadness': 0.588}, 'grouchy': {'anger': 0.562}, 'slander': {'anger': 0.562, 'disgust': 0.609}, 'wrangling': {'anger': 0.562, 'disgust': 0.273, 'fear': 0.531, 'sadness': 0.359}, 'taunt': {'anger': 0.562, 'fear': 0.375, 'sadness': 0.359}, 'perdition': {'anger': 0.562, 'disgust': 0.461, 'fear': 0.5770000000000001, 'sadness': 0.569}, 'frightful': {'anger': 0.562, 'fear': 0.812, 'sadness': 0.672}, 'invade': {'anger': 0.562, 'fear': 0.7659999999999999, 'sadness': 0.45299999999999996, 'surprise': 0.773}, 'glare': {'anger': 0.562, 'fear': 0.43}, 'deceived': {'anger': 0.562}, 'torpedo': {'anger': 0.562}, 'bellows': {'anger': 0.562}, 'retards': {'anger': 0.562}, 'bearish': {'anger': 0.562, 'fear': 0.344}, 'rave': {'anger': 0.561, 'disgust': 0.203, 'joy': 0.706, 'surprise': 0.508, 'trust': 0.35200000000000004}, 'hurt': {'anger': 0.561, 'fear': 0.688, 'sadness': 0.688}, 'grating': {'anger': 0.561, 'disgust': 0.469}, 'thief': {'anger': 0.561, 'disgust': 0.547, 'fear': 0.547, 'sadness': 0.42200000000000004, 'surprise': 0.609}, 'uncontrollable': {'anger': 0.561, 'anticipation': 0.516, 'joy': 0.203, 'surprise': 0.711}, 'idiots': {'anger': 0.561}, 'devastating': {'anger': 0.561, 'disgust': 0.57, 'fear': 0.7190000000000001, 'sadness': 0.875, 'trust': 0.22699999999999998}, 'banshee': {'anger': 0.561, 'disgust': 0.469, 'fear': 0.6409999999999999, 'sadness': 0.391}, 'cross': {'anger': 0.561, 'fear': 0.203, 'sadness': 0.156}, 'betrayal': {'anger': 0.561, 'disgust': 0.617, 'sadness': 0.7340000000000001}, 'fits': {'anger': 0.561}, 'shatter': {'anger': 0.561, 'fear': 0.672, 'sadness': 0.609, 'surprise': 0.609, 'trust': 0.172}, 'conflagration': {'anger': 0.561, 'fear': 0.609}, 'jeopardize': {'anger': 0.561, 'fear': 0.547}, 'dissension': {'anger': 0.561}, 'subjugation': {'anger': 0.5589999999999999, 'disgust': 0.484, 'fear': 0.531, 'sadness': 0.609}, 'disturbed': {'anger': 0.5589999999999999, 'sadness': 0.5}, 'stomped': {'anger': 0.557}, 'grab': {'anger': 0.557}, 'ticked': {'anger': 0.556}, 'masochism': {'anger': 0.556, 'disgust': 0.664, 'fear': 0.594}, 'grievance': {'anger': 0.556, 'disgust': 0.32799999999999996, 'sadness': 0.53}, 'defiance': {'anger': 0.552, 'disgust': 0.43, 'fear': 0.5}, 'blackmail': {'anger': 0.55, 'fear': 0.612}, 'offensive': {'anger': 0.5489999999999999, 'disgust': 0.578}, 'decry': {'anger': 0.5479999999999999}, 'sin': {'anger': 0.547, 'disgust': 0.625, 'fear': 0.56, 'sadness': 0.516}, 'fustrated': {'anger': 0.547}, 'ire': {'anger': 0.547}, 'confine': {'anger': 0.547, 'fear': 0.562, 'sadness': 0.406}, 'deceive': {'anger': 0.547, 'disgust': 0.461, 'sadness': 0.562}, 'arghhhh': {'anger': 0.547}, 'punishment': {'anger': 0.547, 'disgust': 0.391, 'fear': 0.6559999999999999}, 'violation': {'anger': 0.547, 'fear': 0.7659999999999999, 'sadness': 0.594, 'surprise': 0.539}, 'preposterous': {'anger': 0.547}, 'disgraceful': {'anger': 0.547, 'disgust': 0.625}, 'darkside': {'anger': 0.547}, 'frustrates': {'anger': 0.547}, 'overbearing': {'anger': 0.547}, 'misery': {'anger': 0.547, 'disgust': 0.594, 'fear': 0.7340000000000001, 'sadness': 0.938}, 'firearms': {'anger': 0.547, 'fear': 0.6}, 'rebel': {'anger': 0.547, 'fear': 0.359}, 'shrill': {'anger': 0.547, 'fear': 0.45299999999999996, 'surprise': 0.594}, 'disparity': {'anger': 0.547, 'disgust': 0.305, 'sadness': 0.531}, 'hadenough': {'anger': 0.546}, 'stolen': {'anger': 0.546}, 'foul': {'anger': 0.545, 'disgust': 0.7340000000000001, 'fear': 0.25}, 'adversary': {'anger': 0.545}, 'conspirator': {'anger': 0.545, 'anticipation': 0.42200000000000004, 'disgust': 0.578, 'fear': 0.516}, 'skirmish': {'anger': 0.545}, 'ruined': {'anger': 0.545, 'disgust': 0.531, 'fear': 0.5, 'sadness': 0.6970000000000001}, 'annoyin': {'anger': 0.545}, 'menace': {'anger': 0.545, 'fear': 0.672}, 'tackle': {'anger': 0.545, 'surprise': 0.602}, 'humiliate': {'anger': 0.545, 'sadness': 0.703}, 'prejudice': {'anger': 0.545}, 'resentful': {'anger': 0.545}, 'antagonist': {'anger': 0.545}, 'heated': {'anger': 0.545}, 'wanker': {'anger': 0.545}, 'callous': {'anger': 0.545, 'disgust': 0.43}, 'argument': {'anger': 0.545}, 'sting': {'anger': 0.544, 'fear': 0.516}, 'outcry': {'anger': 0.544, 'fear': 0.547, 'surprise': 0.727}, 'grumble': {'anger': 0.544, 'disgust': 0.336}, 'robbery': {'anger': 0.544, 'disgust': 0.555, 'fear': 0.8, 'sadness': 0.6}, 'entangled': {'anger': 0.544, 'disgust': 0.242, 'fear': 0.43799999999999994, 'sadness': 0.377}, 'resistance': {'anger': 0.5429999999999999, 'trust': 0.297}, 'irreconcilable': {'anger': 0.5429999999999999, 'fear': 0.43799999999999994, 'sadness': 0.594}, 'obstructive': {'anger': 0.542}, 'dismay': {'anger': 0.54, 'anticipation': 0.297, 'fear': 0.484, 'sadness': 0.636, 'surprise': 0.57}, 'mob': {'anger': 0.5379999999999999, 'fear': 0.5770000000000001}, 'juststop': {'anger': 0.537}, 'badness': {'anger': 0.536, 'disgust': 0.42200000000000004, 'fear': 0.539}, 'ridicule': {'anger': 0.534, 'disgust': 0.555, 'sadness': 0.518}, 'incendiary': {'anger': 0.5329999999999999, 'fear': 0.625, 'surprise': 0.6559999999999999}, 'flares': {'anger': 0.532}, 'twofaced': {'anger': 0.531}, 'exacerbation': {'anger': 0.531, 'fear': 0.516}, 'prejudicial': {'anger': 0.531}, 'unbridled': {'anger': 0.531, 'anticipation': 0.5, 'fear': 0.271, 'surprise': 0.547}, 'intruder': {'anger': 0.531, 'fear': 0.828, 'surprise': 0.703}, 'communism': {'anger': 0.531, 'fear': 0.547, 'sadness': 0.25}, 'uprising': {'anger': 0.531, 'anticipation': 0.68, 'fear': 0.545}, 'dispute': {'anger': 0.531}, 'reckless': {'anger': 0.531, 'fear': 0.344}, 'confinement': {'anger': 0.531, 'fear': 0.507, 'sadness': 0.439}, 'degeneracy': {'anger': 0.531, 'disgust': 0.7340000000000001, 'sadness': 0.578}, 'whip': {'anger': 0.531}, 'belittle': {'anger': 0.531, 'disgust': 0.508, 'fear': 0.344, 'sadness': 0.672}, 'allegation': {'anger': 0.531}, 'offender': {'anger': 0.53, 'disgust': 0.484, 'fear': 0.698, 'sadness': 0.594}, 'tackled': {'anger': 0.53}, 'dictatorial': {'anger': 0.53}, 'perversion': {'anger': 0.53, 'disgust': 0.758, 'sadness': 0.469}, 'unjust': {'anger': 0.53}, 'fiesty': {'anger': 0.53}, 'hassle': {'anger': 0.53}, 'unjustifiable': {'anger': 0.53, 'disgust': 0.461, 'fear': 0.344}, 'bigoted': {'anger': 0.53, 'disgust': 0.633, 'fear': 0.281, 'sadness': 0.574}, 'dissonance': {'anger': 0.53}, 'prison': {'anger': 0.529, 'fear': 0.625, 'sadness': 0.594}, 'trespass': {'anger': 0.529}, 'cantstandit': {'anger': 0.529}, 'hot': {'anger': 0.529}, 'renegade': {'anger': 0.529}, 'suicide': {'anger': 0.521, 'fear': 0.879, 'sadness': 0.912}, 'annoy': {'anger': 0.52, 'disgust': 0.336}, 'leavemealone': {'anger': 0.517}, 'depravity': {'anger': 0.516, 'disgust': 0.797}, 'venting': {'anger': 0.516}, 'divorce': {'anger': 0.516, 'disgust': 0.38299999999999995, 'fear': 0.484, 'sadness': 0.623, 'surprise': 0.39799999999999996, 'trust': 0.133}, 'dishonest': {'anger': 0.516, 'disgust': 0.45299999999999996, 'sadness': 0.48200000000000004}, 'prisoner': {'anger': 0.516, 'disgust': 0.508, 'fear': 0.562, 'sadness': 0.531}, 'duress': {'anger': 0.516, 'disgust': 0.5, 'fear': 0.6409999999999999, 'sadness': 0.625}, 'inimical': {'anger': 0.516, 'sadness': 0.531}, 'grrr': {'anger': 0.516}, 'idiotic': {'anger': 0.516, 'disgust': 0.42200000000000004}, 'treason': {'anger': 0.516, 'disgust': 0.688, 'fear': 0.6559999999999999, 'surprise': 0.539}, 'tortious': {'anger': 0.516, 'disgust': 0.516}, 'criticize': {'anger': 0.516, 'disgust': 0.312, 'fear': 0.469, 'sadness': 0.469}, 'disrespectful': {'anger': 0.516, 'disgust': 0.484, 'fear': 0.34299999999999997, 'sadness': 0.5}, 'distrust': {'anger': 0.516, 'disgust': 0.336, 'fear': 0.531}, 'cretins': {'anger': 0.516}, 'broil': {'anger': 0.516}, 'hangry': {'anger': 0.515}, 'unkind': {'anger': 0.515, 'disgust': 0.406, 'fear': 0.312, 'sadness': 0.547}, 'bile': {'anger': 0.515, 'disgust': 0.742}, 'roar': {'anger': 0.515}, 'poaching': {'anger': 0.515, 'disgust': 0.602, 'fear': 0.484, 'sadness': 0.594}, 'unforgiving': {'anger': 0.515, 'sadness': 0.612}, 'poachers': {'anger': 0.515}, 'pow': {'anger': 0.515}, 'unleash': {'anger': 0.515}, 'scold': {'anger': 0.515, 'disgust': 0.297, 'fear': 0.45299999999999996, 'sadness': 0.327}, 'argumentation': {'anger': 0.515}, 'chaos': {'anger': 0.515, 'fear': 0.8390000000000001, 'sadness': 0.594}, 'frustrating': {'anger': 0.515}, 'jerks': {'anger': 0.515}, 'coercion': {'anger': 0.515, 'disgust': 0.547, 'fear': 0.547, 'sadness': 0.43799999999999994}, 'grump': {'anger': 0.515}, 'victimized': {'anger': 0.515, 'disgust': 0.6559999999999999, 'fear': 0.7340000000000001, 'sadness': 0.75, 'surprise': 0.523}, 'tussle': {'anger': 0.514}, 'bane': {'anger': 0.511, 'disgust': 0.45299999999999996, 'fear': 0.35600000000000004}, 'accusation': {'anger': 0.51, 'disgust': 0.523}, 'enmity': {'anger': 0.51, 'fear': 0.547, 'sadness': 0.406}, 'repudiation': {'anger': 0.51, 'disgust': 0.539}, 'banish': {'anger': 0.509, 'disgust': 0.5, 'fear': 0.688, 'sadness': 0.6970000000000001}, 'disfigured': {'anger': 0.508, 'disgust': 0.7190000000000001, 'fear': 0.625, 'sadness': 0.703}, 'storm': {'anger': 0.507}, 'derogation': {'anger': 0.5, 'disgust': 0.523, 'fear': 0.547, 'sadness': 0.491}, 'obstruct': {'anger': 0.5, 'fear': 0.43799999999999994}, 'nobodycares': {'anger': 0.5}, 'rejects': {'anger': 0.5, 'fear': 0.359, 'sadness': 0.43799999999999994}, 'unruly': {'anger': 0.5, 'disgust': 0.39799999999999996, 'fear': 0.281}, 'crazy': {'anger': 0.5, 'fear': 0.519, 'sadness': 0.368}, 'hammering': {'anger': 0.5}, 'malpractice': {'anger': 0.5}, 'frenzied': {'anger': 0.5, 'fear': 0.531}, 'suppression': {'anger': 0.5, 'disgust': 0.47700000000000004, 'fear': 0.5}, 'scoff': {'anger': 0.5, 'disgust': 0.375}, 'possessed': {'anger': 0.5, 'disgust': 0.484, 'fear': 0.594}, 'intractable': {'anger': 0.5}, 'fervor': {'anger': 0.5, 'joy': 0.295}, 'delusional': {'anger': 0.5, 'fear': 0.25}, 'brunt': {'anger': 0.5}, 'confined': {'anger': 0.5, 'disgust': 0.32, 'fear': 0.578, 'sadness': 0.531}, 'injustice': {'anger': 0.5}, 'shun': {'anger': 0.5, 'disgust': 0.43799999999999994, 'sadness': 0.547}, 'defy': {'anger': 0.5, 'fear': 0.344, 'sadness': 0.312, 'surprise': 0.602}, 'anguish': {'anger': 0.5, 'fear': 0.703, 'sadness': 0.902}, 'antithesis': {'anger': 0.5}, 'fear': {'anger': 0.5, 'fear': 0.828}, 'bout': {'anger': 0.5}, 'derision': {'anger': 0.5, 'disgust': 0.5}, 'banished': {'anger': 0.5, 'fear': 0.562, 'sadness': 0.688}, 'animus': {'anger': 0.5}, 'reject': {'anger': 0.5, 'fear': 0.391, 'sadness': 0.547, 'trust': 0.22699999999999998}, 'spear': {'anger': 0.5, 'anticipation': 0.36700000000000005, 'fear': 0.46799999999999997}, 'dominate': {'anger': 0.5, 'fear': 0.43799999999999994}, 'patronising': {'anger': 0.5}, 'brazen': {'anger': 0.5}, 'disrupting': {'anger': 0.5}, 'ordeal': {'anger': 0.5, 'surprise': 0.45299999999999996}, 'foaming': {'anger': 0.5}, 'getoveryourself': {'anger': 0.495}, 'stupidpeople': {'anger': 0.49200000000000005}, 'toughness': {'anger': 0.49200000000000005, 'fear': 0.4, 'trust': 0.43}, 'sinful': {'anger': 0.491, 'disgust': 0.633, 'fear': 0.5, 'sadness': 0.6409999999999999}, 'madness': {'anger': 0.491, 'fear': 0.675}, 'oppress': {'anger': 0.49, 'disgust': 0.57, 'fear': 0.516, 'sadness': 0.664}, 'avarice': {'anger': 0.49, 'disgust': 0.523}, 'anathema': {'anger': 0.485, 'disgust': 0.547, 'fear': 0.42200000000000004, 'sadness': 0.562}, 'incest': {'anger': 0.485, 'disgust': 0.914, 'fear': 0.5710000000000001, 'sadness': 0.75}, 'dissident': {'anger': 0.485, 'fear': 0.42200000000000004}, 'abolish': {'anger': 0.485}, 'smuggler': {'anger': 0.485, 'disgust': 0.531, 'fear': 0.625}, 'claw': {'anger': 0.485, 'fear': 0.406}, 'revoke': {'anger': 0.485, 'disgust': 0.36700000000000005, 'fear': 0.469, 'sadness': 0.281}, 'complaint': {'anger': 0.485}, 'infraction': {'anger': 0.485}, 'avenger': {'anger': 0.485}, 'pervert': {'anger': 0.485, 'disgust': 0.82}, 'cutting': {'anger': 0.485, 'disgust': 0.35200000000000004, 'fear': 0.484, 'sadness': 0.42200000000000004}, 'usurp': {'anger': 0.485}, 'inhuman': {'anger': 0.485, 'disgust': 0.672, 'fear': 0.625, 'sadness': 0.703}, 'disservice': {'anger': 0.485, 'disgust': 0.32, 'sadness': 0.258}, 'annoyed': {'anger': 0.485}, 'stayaway': {'anger': 0.485}, 'disobedient': {'anger': 0.485}, 'alienate': {'anger': 0.485, 'disgust': 0.45299999999999996}, 'fricking': {'anger': 0.485}, 'demand': {'anger': 0.485}, 'disapproved': {'anger': 0.485, 'sadness': 0.43799999999999994}, 'oust': {'anger': 0.484, 'sadness': 0.375}, 'litigious': {'anger': 0.484, 'disgust': 0.414}, 'rivalry': {'anger': 0.484}, 'mocking': {'anger': 0.484, 'disgust': 0.469, 'sadness': 0.363}, 'obnoxious': {'anger': 0.484, 'disgust': 0.43799999999999994, 'sadness': 0.406}, 'thresh': {'anger': 0.484, 'fear': 0.469, 'sadness': 0.312}, 'restrain': {'anger': 0.484, 'fear': 0.45299999999999996}, 'blame': {'anger': 0.484, 'disgust': 0.375}, 'deceit': {'anger': 0.484, 'disgust': 0.617, 'fear': 0.594, 'sadness': 0.562, 'surprise': 0.586}, 'strained': {'anger': 0.484}, 'penalty': {'anger': 0.484, 'fear': 0.45299999999999996, 'sadness': 0.469}, 'opposed': {'anger': 0.484, 'fear': 0.344}, 'disgrace': {'anger': 0.484, 'disgust': 0.539, 'sadness': 0.812}, 'imprisoned': {'anger': 0.484, 'disgust': 0.539, 'fear': 0.8109999999999999, 'sadness': 0.688}, 'sucker': {'anger': 0.484}, 'suspicious': {'anger': 0.484, 'anticipation': 0.547}, 'upheaval': {'anger': 0.484, 'fear': 0.703, 'sadness': 0.45299999999999996}, 'renounce': {'anger': 0.484}, 'turbulence': {'anger': 0.483, 'fear': 0.562, 'joy': 0.045}, 'pound': {'anger': 0.48100000000000004}, 'coldness': {'anger': 0.47700000000000004, 'disgust': 0.266, 'fear': 0.375, 'sadness': 0.391}, 'ungrateful': {'anger': 0.47200000000000003, 'disgust': 0.406}, 'stoopid': {'anger': 0.47100000000000003}, 'battalion': {'anger': 0.47100000000000003}, 'armament': {'anger': 0.47, 'fear': 0.6559999999999999}, 'jealous': {'anger': 0.47, 'disgust': 0.539}, 'hostage': {'anger': 0.47, 'fear': 0.7340000000000001}, 'adversity': {'anger': 0.47, 'fear': 0.418, 'sadness': 0.484}, 'infidel': {'anger': 0.47, 'disgust': 0.602, 'fear': 0.594}, 'ram': {'anger': 0.47, 'anticipation': 0.38299999999999995}, 'annoying': {'anger': 0.47}, 'dispossessed': {'anger': 0.47, 'fear': 0.578, 'sadness': 0.531}, 'feudalism': {'anger': 0.47, 'sadness': 0.406}, 'gall': {'anger': 0.47, 'disgust': 0.305}, 'accuser': {'anger': 0.47, 'fear': 0.43799999999999994}, 'friction': {'anger': 0.47}, 'subversion': {'anger': 0.47, 'fear': 0.469}, 'plunder': {'anger': 0.469, 'disgust': 0.461, 'fear': 0.516, 'sadness': 0.461, 'surprise': 0.633}, 'incite': {'anger': 0.469, 'anticipation': 0.547, 'fear': 0.516}, 'objection': {'anger': 0.469}, 'simmer': {'anger': 0.469, 'anticipation': 0.39799999999999996}, 'offense': {'anger': 0.469, 'disgust': 0.5, 'fear': 0.42200000000000004, 'sadness': 0.484}, 'complain': {'anger': 0.469, 'sadness': 0.509}, 'injury': {'anger': 0.469, 'fear': 0.672, 'sadness': 0.562}, 'disruption': {'anger': 0.469, 'fear': 0.45299999999999996, 'surprise': 0.648}, 'backoff': {'anger': 0.469}, 'steal': {'anger': 0.469, 'fear': 0.42200000000000004, 'sadness': 0.6559999999999999}, 'angermanagement': {'anger': 0.469}, 'stifled': {'anger': 0.469, 'fear': 0.391, 'sadness': 0.516}, 'smother': {'anger': 0.469}, 'selfish': {'anger': 0.469, 'disgust': 0.45299999999999996}, 'dislike': {'anger': 0.469, 'disgust': 0.406}, 'recidivism': {'anger': 0.469, 'disgust': 0.406, 'sadness': 0.469}, 'disobey': {'anger': 0.469, 'disgust': 0.414}, 'intolerance': {'anger': 0.469, 'disgust': 0.523, 'fear': 0.516}, 'exile': {'anger': 0.469, 'fear': 0.516, 'sadness': 0.742}, 'thump': {'anger': 0.469}, 'selfishness': {'anger': 0.469}, 'distress': {'anger': 0.469, 'disgust': 0.508, 'fear': 0.6559999999999999, 'sadness': 0.594, 'surprise': 0.625}, 'huff': {'anger': 0.469, 'disgust': 0.273}, 'perpetrator': {'anger': 0.469, 'disgust': 0.633, 'fear': 0.56, 'sadness': 0.359}, 'subversive': {'anger': 0.469, 'surprise': 0.47700000000000004}, 'opposition': {'anger': 0.469}, 'insanity': {'anger': 0.469, 'disgust': 0.562, 'fear': 0.547, 'sadness': 0.688}, 'areyoukidding': {'anger': 0.46799999999999997}, 'mug': {'anger': 0.467, 'fear': 0.359, 'sadness': 0.141}, 'agony': {'anger': 0.465, 'fear': 0.75, 'sadness': 0.9}, 'arrogant': {'anger': 0.461, 'disgust': 0.469}, 'vent': {'anger': 0.456}, 'sux': {'anger': 0.456}, 'picketing': {'anger': 0.456}, 'elimination': {'anger': 0.456, 'disgust': 0.45299999999999996, 'fear': 0.588, 'sadness': 0.516}, 'haughty': {'anger': 0.456}, 'troublesome': {'anger': 0.455, 'fear': 0.516}, 'mislead': {'anger': 0.455, 'fear': 0.297, 'sadness': 0.297, 'trust': 0.18}, 'impermeable': {'anger': 0.455, 'fear': 0.43799999999999994}, 'illegality': {'anger': 0.455, 'disgust': 0.47700000000000004, 'fear': 0.469}, 'constraint': {'anger': 0.455, 'fear': 0.5, 'sadness': 0.28800000000000003}, 'dying': {'anger': 0.455, 'disgust': 0.617, 'fear': 0.948, 'sadness': 0.875}, 'clamor': {'anger': 0.455, 'anticipation': 0.578, 'disgust': 0.156, 'surprise': 0.68}, 'flagrant': {'anger': 0.455, 'disgust': 0.5}, 'illicit': {'anger': 0.455, 'disgust': 0.602, 'fear': 0.45299999999999996}, 'busted': {'anger': 0.455, 'fear': 0.516}, 'veto': {'anger': 0.455}, 'idiocy': {'anger': 0.455, 'disgust': 0.508, 'sadness': 0.359}, 'crabby': {'anger': 0.455}, 'stubbed': {'anger': 0.455}, 'grated': {'anger': 0.455}, 'desist': {'anger': 0.45299999999999996, 'disgust': 0.281}, 'suppress': {'anger': 0.45299999999999996, 'fear': 0.5, 'sadness': 0.297}, 'bad': {'anger': 0.45299999999999996, 'disgust': 0.391, 'fear': 0.375, 'sadness': 0.42200000000000004}, 'disagreeing': {'anger': 0.45299999999999996, 'sadness': 0.33299999999999996}, 'struggle': {'anger': 0.45299999999999996, 'fear': 0.7190000000000001, 'sadness': 0.379}, 'despotism': {'anger': 0.45299999999999996, 'disgust': 0.703, 'fear': 0.609, 'sadness': 0.45299999999999996}, 'disapproving': {'anger': 0.45299999999999996, 'disgust': 0.32, 'sadness': 0.43799999999999994}, 'bayonet': {'anger': 0.45299999999999996, 'fear': 0.42200000000000004}, 'intense': {'anger': 0.45299999999999996, 'disgust': 0.21899999999999997, 'fear': 0.27899999999999997, 'joy': 0.242, 'surprise': 0.617, 'trust': 0.39799999999999996}, 'hysterical': {'anger': 0.45299999999999996, 'fear': 0.703}, 'usurped': {'anger': 0.45299999999999996, 'fear': 0.42200000000000004}, 'displeased': {'anger': 0.45299999999999996, 'disgust': 0.35200000000000004, 'fear': 0.273, 'sadness': 0.516}, 'godless': {'anger': 0.45299999999999996}, 'unlawful': {'anger': 0.451, 'disgust': 0.406, 'fear': 0.519, 'sadness': 0.455}, 'wrongly': {'anger': 0.44799999999999995, 'fear': 0.32799999999999996, 'sadness': 0.45299999999999996}, 'repellent': {'anger': 0.442, 'disgust': 0.469, 'fear': 0.391}, 'wrongful': {'anger': 0.441, 'disgust': 0.35200000000000004, 'sadness': 0.484}, 'dishonor': {'anger': 0.441, 'disgust': 0.516, 'fear': 0.484, 'sadness': 0.625}, 'foe': {'anger': 0.441, 'fear': 0.594}, 'wasted': {'anger': 0.441, 'disgust': 0.445}, 'psychosis': {'anger': 0.441, 'fear': 0.703, 'sadness': 0.638}, 'aversion': {'anger': 0.44, 'disgust': 0.43799999999999994, 'fear': 0.28300000000000003}, 'punitive': {'anger': 0.439, 'fear': 0.425, 'sadness': 0.562}, 'ultimatum': {'anger': 0.439, 'fear': 0.42200000000000004}, 'gahhh': {'anger': 0.439}, 'knuckles': {'anger': 0.439}, 'effigy': {'anger': 0.439}, 'upset': {'anger': 0.439, 'sadness': 0.562}, 'schism': {'anger': 0.439}, 'separatist': {'anger': 0.43799999999999994, 'disgust': 0.43}, 'deny': {'anger': 0.43799999999999994, 'trust': 0.18}, 'stupidity': {'anger': 0.43799999999999994}, 'deleterious': {'anger': 0.43799999999999994, 'disgust': 0.547, 'fear': 0.42200000000000004}, 'worthless': {'anger': 0.43799999999999994, 'disgust': 0.508, 'sadness': 0.609}, 'abandonment': {'anger': 0.43799999999999994, 'fear': 0.609, 'sadness': 0.8590000000000001, 'surprise': 0.523}, 'mucked': {'anger': 0.43799999999999994}, 'ransom': {'anger': 0.43799999999999994, 'fear': 0.644}, 'irritation': {'anger': 0.43799999999999994, 'disgust': 0.375, 'sadness': 0.47}, 'fugitive': {'anger': 0.43799999999999994, 'disgust': 0.38299999999999995, 'fear': 0.703, 'sadness': 0.43799999999999994, 'trust': 0.141}, 'segregate': {'anger': 0.43700000000000006, 'disgust': 0.555, 'sadness': 0.469}, 'oblivion': {'anger': 0.43700000000000006, 'fear': 0.609}, 'payback': {'anger': 0.436}, 'incongruous': {'anger': 0.435}, 'eviction': {'anger': 0.435, 'disgust': 0.38299999999999995, 'fear': 0.596, 'sadness': 0.594}, 'collusion': {'anger': 0.43200000000000005, 'disgust': 0.555, 'fear': 0.312, 'sadness': 0.469}, 'rob': {'anger': 0.431, 'disgust': 0.516, 'fear': 0.609, 'sadness': 0.491}, 'ravenous': {'anger': 0.429, 'fear': 0.484, 'sadness': 0.391}, 'infidelity': {'anger': 0.429, 'disgust': 0.539, 'fear': 0.469, 'sadness': 0.688}, 'overrun': {'anger': 0.429}, 'rejection': {'anger': 0.426, 'disgust': 0.508, 'fear': 0.5329999999999999, 'sadness': 0.562, 'trust': 0.273}, 'stupidrain': {'anger': 0.426}, 'getoverit': {'anger': 0.426}, 'incredulous': {'anger': 0.426, 'disgust': 0.43}, 'martial': {'anger': 0.426}, 'harbinger': {'anger': 0.426, 'anticipation': 0.531, 'fear': 0.531}, 'painful': {'anger': 0.426, 'disgust': 0.531, 'fear': 0.8440000000000001, 'sadness': 0.75}, 'defense': {'anger': 0.425, 'anticipation': 0.49200000000000005, 'fear': 0.258}, 'enforce': {'anger': 0.424, 'fear': 0.516}, 'fuss': {'anger': 0.424, 'sadness': 0.359}, 'banger': {'anger': 0.424, 'anticipation': 0.38299999999999995, 'fear': 0.266, 'surprise': 0.531}, 'defraud': {'anger': 0.424, 'disgust': 0.516}, 'commotion': {'anger': 0.424}, 'powerful': {'anger': 0.424, 'anticipation': 0.47700000000000004, 'disgust': 0.102, 'fear': 0.312, 'joy': 0.516, 'trust': 0.523}, 'fraudulent': {'anger': 0.424, 'disgust': 0.461}, 'concealment': {'anger': 0.424, 'anticipation': 0.445, 'fear': 0.391}, 'indecency': {'anger': 0.424, 'disgust': 0.6409999999999999}, 'greed': {'anger': 0.424, 'disgust': 0.5}, 'exasperation': {'anger': 0.424, 'disgust': 0.32799999999999996}, 'disobedience': {'anger': 0.424, 'disgust': 0.359}, 'censor': {'anger': 0.424, 'disgust': 0.35200000000000004, 'fear': 0.149, 'trust': 0.21100000000000002}, 'discontent': {'anger': 0.424, 'disgust': 0.336, 'fear': 0.23399999999999999, 'sadness': 0.5429999999999999}, 'fallacious': {'anger': 0.424}, 'gonorrhea': {'anger': 0.424, 'disgust': 0.9059999999999999, 'fear': 0.547, 'sadness': 0.5}, 'unsympathetic': {'anger': 0.424}, 'cur': {'anger': 0.42200000000000004, 'disgust': 0.45299999999999996, 'fear': 0.359}, 'duel': {'anger': 0.42200000000000004, 'anticipation': 0.484, 'fear': 0.562}, 'banishment': {'anger': 0.42200000000000004, 'disgust': 0.469, 'sadness': 0.79}, 'annoyance': {'anger': 0.42200000000000004, 'disgust': 0.32}, 'bang': {'anger': 0.42200000000000004, 'disgust': 0.305, 'fear': 0.652, 'sadness': 0.25, 'surprise': 0.836}, 'deportation': {'anger': 0.42200000000000004, 'fear': 0.517, 'sadness': 0.594}, 'penetration': {'anger': 0.42200000000000004, 'fear': 0.531}, 'nettle': {'anger': 0.42200000000000004, 'disgust': 0.289}, 'scar': {'anger': 0.42200000000000004, 'disgust': 0.461, 'fear': 0.406, 'sadness': 0.375}, 'misrepresented': {'anger': 0.42200000000000004}, 'penitentiary': {'anger': 0.42200000000000004}, 'sedition': {'anger': 0.42200000000000004, 'sadness': 0.469}, 'barb': {'anger': 0.42200000000000004}, 'snubbed': {'anger': 0.42200000000000004}, 'sarcasm': {'anger': 0.42200000000000004, 'disgust': 0.258, 'sadness': 0.18100000000000002}, 'cracked': {'anger': 0.42200000000000004, 'fear': 0.484}, 'blatant': {'anger': 0.42, 'disgust': 0.36700000000000005}, 'force': {'anger': 0.418, 'fear': 0.266}, 'perverse': {'anger': 0.415, 'disgust': 0.805, 'fear': 0.43799999999999994}, 'wring': {'anger': 0.415}, 'grim': {'anger': 0.413, 'anticipation': 0.312, 'disgust': 0.516, 'fear': 0.672, 'sadness': 0.708}, 'bastion': {'anger': 0.413}, 'tiff': {'anger': 0.41200000000000003}, 'sordid': {'anger': 0.41200000000000003, 'disgust': 0.562, 'fear': 0.425, 'sadness': 0.578}, 'surly': {'anger': 0.41200000000000003, 'disgust': 0.38299999999999995}, 'nothappy': {'anger': 0.41200000000000003}, 'moody': {'anger': 0.41200000000000003, 'sadness': 0.469}, 'hunting': {'anger': 0.41100000000000003, 'anticipation': 0.539, 'fear': 0.5, 'joy': 0.109}, 'indenture': {'anger': 0.41}, 'detainee': {'anger': 0.409, 'anticipation': 0.414, 'fear': 0.516, 'sadness': 0.43799999999999994}, 'supremacy': {'anger': 0.409, 'anticipation': 0.45299999999999996, 'fear': 0.32799999999999996, 'joy': 0.242, 'surprise': 0.391, 'trust': 0.42200000000000004}, 'compulsion': {'anger': 0.409}, 'reproach': {'anger': 0.409, 'disgust': 0.32, 'sadness': 0.391}, 'areyoukiddingme': {'anger': 0.409}, 'inept': {'anger': 0.409, 'disgust': 0.35200000000000004}, 'cantwin': {'anger': 0.409}, 'squelch': {'anger': 0.409, 'disgust': 0.36700000000000005}, 'forfeit': {'anger': 0.409, 'sadness': 0.344}, 'blockade': {'anger': 0.409, 'fear': 0.5820000000000001, 'sadness': 0.23399999999999999}, 'disappoint': {'anger': 0.409, 'disgust': 0.38299999999999995, 'sadness': 0.609}, 'implicate': {'anger': 0.409}, 'sham': {'anger': 0.409, 'disgust': 0.509}, 'awful': {'anger': 0.409, 'disgust': 0.562, 'fear': 0.672, 'sadness': 0.6409999999999999}, 'contradict': {'anger': 0.409}, 'sneak': {'anger': 0.409, 'fear': 0.266, 'surprise': 0.6559999999999999}, 'lying': {'anger': 0.408, 'disgust': 0.531}, 'badger': {'anger': 0.406}, 'forsaken': {'anger': 0.406, 'sadness': 0.7190000000000001}, 'antipathy': {'anger': 0.406, 'disgust': 0.45299999999999996}, 'inequality': {'anger': 0.406, 'fear': 0.23399999999999999, 'sadness': 0.6409999999999999}, 'epidemic': {'anger': 0.406, 'anticipation': 0.445, 'disgust': 0.594, 'fear': 0.7759999999999999, 'sadness': 0.688, 'surprise': 0.648}, 'wop': {'anger': 0.406}, 'onerous': {'anger': 0.406, 'sadness': 0.223}, 'tremor': {'anger': 0.406, 'anticipation': 0.484, 'fear': 0.594, 'sadness': 0.359}, 'wrongdoing': {'anger': 0.406, 'disgust': 0.406, 'sadness': 0.42200000000000004}, 'scrapie': {'anger': 0.406, 'fear': 0.469, 'sadness': 0.281}, 'nuisance': {'anger': 0.406}, 'unthinkable': {'anger': 0.406, 'disgust': 0.45299999999999996, 'fear': 0.516}, 'rail': {'anger': 0.406, 'anticipation': 0.23399999999999999}, 'cacophony': {'anger': 0.406, 'disgust': 0.32799999999999996}, 'delusion': {'anger': 0.406, 'fear': 0.42200000000000004, 'sadness': 0.516}, 'arguments': {'anger': 0.40399999999999997}, 'affront': {'anger': 0.40299999999999997, 'disgust': 0.42200000000000004, 'fear': 0.266, 'sadness': 0.359, 'surprise': 0.531}, 'traumatic': {'anger': 0.402, 'fear': 0.8440000000000001, 'sadness': 0.8590000000000001}, 'libel': {'anger': 0.4, 'fear': 0.348, 'trust': 0.21899999999999997}, 'annoys': {'anger': 0.4}, 'sodding': {'anger': 0.4}, 'soslow': {'anger': 0.39799999999999996}, 'watchout': {'anger': 0.39799999999999996}, 'frenetic': {'anger': 0.397, 'fear': 0.5, 'surprise': 0.7340000000000001}, 'remiss': {'anger': 0.397, 'disgust': 0.281, 'sadness': 0.266}, 'barge': {'anger': 0.396}, 'rabble': {'anger': 0.39399999999999996, 'fear': 0.484}, 'confiscate': {'anger': 0.39399999999999996, 'sadness': 0.45299999999999996}, 'disrespect': {'anger': 0.39399999999999996}, 'illegal': {'anger': 0.39399999999999996, 'disgust': 0.43, 'fear': 0.5, 'sadness': 0.469}, 'sue': {'anger': 0.39399999999999996, 'sadness': 0.318}, 'actionable': {'anger': 0.39399999999999996, 'disgust': 0.21100000000000002}, 'unfriendly': {'anger': 0.39399999999999996, 'disgust': 0.305, 'fear': 0.281, 'sadness': 0.516}, 'extinguish': {'anger': 0.39399999999999996}, 'boxing': {'anger': 0.39399999999999996}, 'keyed': {'anger': 0.39399999999999996}, 'fraud': {'anger': 0.39399999999999996}, 'untoward': {'anger': 0.39399999999999996, 'disgust': 0.35200000000000004}, 'whatsthepoint': {'anger': 0.39399999999999996}, 'nag': {'anger': 0.39399999999999996}, 'dangit': {'anger': 0.39399999999999996}, 'howl': {'anger': 0.39399999999999996, 'disgust': 0.195, 'fear': 0.45299999999999996, 'sadness': 0.5, 'surprise': 0.516}, 'brimstone': {'anger': 0.392, 'fear': 0.391}, 'recklessness': {'anger': 0.391, 'disgust': 0.461, 'fear': 0.406, 'surprise': 0.68}, 'dissolution': {'anger': 0.391, 'fear': 0.375, 'sadness': 0.48, 'surprise': 0.336}, 'pique': {'anger': 0.391}, 'earthquake': {'anger': 0.391, 'fear': 0.812, 'sadness': 0.7340000000000001, 'surprise': 0.812}, 'rigged': {'anger': 0.391}, 'grrrrr': {'anger': 0.391}, 'argh': {'anger': 0.391}, 'disagree': {'anger': 0.389}, 'lawsuit': {'anger': 0.386, 'disgust': 0.336, 'fear': 0.562, 'sadness': 0.344, 'surprise': 0.43}, 'immorality': {'anger': 0.382, 'disgust': 0.47700000000000004}, 'despair': {'anger': 0.382, 'disgust': 0.445, 'fear': 0.6409999999999999, 'sadness': 0.812}, 'disused': {'anger': 0.382}, 'sore': {'anger': 0.379, 'sadness': 0.516}, 'touchy': {'anger': 0.379, 'sadness': 0.14}, 'sizzle': {'anger': 0.379}, 'incurable': {'anger': 0.379, 'disgust': 0.508, 'fear': 0.797, 'sadness': 0.703}, 'coerce': {'anger': 0.379, 'disgust': 0.36700000000000005, 'fear': 0.484}, 'falsification': {'anger': 0.379}, 'firstworldprobs': {'anger': 0.379}, 'difficulty': {'anger': 0.379, 'fear': 0.23399999999999999, 'sadness': 0.5}, 'pokes': {'anger': 0.379}, 'rifle': {'anger': 0.379, 'fear': 0.45299999999999996}, 'picket': {'anger': 0.37799999999999995, 'anticipation': 0.273, 'fear': 0.25}, 'concussion': {'anger': 0.377, 'sadness': 0.545}, 'pitfall': {'anger': 0.375, 'disgust': 0.36700000000000005, 'fear': 0.562, 'sadness': 0.39399999999999996, 'surprise': 0.586}, 'militia': {'anger': 0.375, 'fear': 0.672, 'sadness': 0.344}, 'sly': {'anger': 0.375, 'disgust': 0.32799999999999996, 'fear': 0.156}, 'remand': {'anger': 0.375}, 'stuckup': {'anger': 0.375}, 'disillusionment': {'anger': 0.375, 'disgust': 0.36700000000000005, 'sadness': 0.547}, 'faulty': {'anger': 0.375}, 'pessimism': {'anger': 0.375, 'fear': 0.359, 'sadness': 0.5760000000000001}, 'petpeeve': {'anger': 0.375}, 'rawr': {'anger': 0.375}, 'infantile': {'anger': 0.375, 'disgust': 0.42200000000000004}, 'cannon': {'anger': 0.375, 'fear': 0.547}, 'inhibit': {'anger': 0.371, 'disgust': 0.32799999999999996, 'sadness': 0.312}, 'distressing': {'anger': 0.371, 'fear': 0.562}, 'vindicate': {'anger': 0.371}, 'nepotism': {'anger': 0.371, 'disgust': 0.484, 'sadness': 0.32799999999999996}, 'schizophrenia': {'anger': 0.369, 'disgust': 0.508, 'fear': 0.703, 'sadness': 0.625}, 'skewed': {'anger': 0.368, 'anticipation': 0.281}, 'disreputable': {'anger': 0.368, 'disgust': 0.49200000000000005, 'fear': 0.45299999999999996}, 'forbidding': {'anger': 0.368, 'fear': 0.578}, 'conquest': {'anger': 0.36700000000000005, 'fear': 0.359}, 'leukemia': {'anger': 0.365, 'fear': 0.688, 'sadness': 0.797}, 'bark': {'anger': 0.365}, 'warrior': {'anger': 0.364, 'fear': 0.484}, 'barks': {'anger': 0.364}, 'burke': {'anger': 0.364, 'disgust': 0.312, 'fear': 0.359, 'sadness': 0.23399999999999999}, 'disapprove': {'anger': 0.364, 'disgust': 0.344, 'fear': 0.38, 'sadness': 0.45299999999999996}, 'unhappy': {'anger': 0.364, 'disgust': 0.21100000000000002, 'sadness': 0.75}, 'retarded': {'anger': 0.364}, 'challenge': {'anger': 0.364, 'fear': 0.281}, 'belt': {'anger': 0.364, 'fear': 0.266}, 'aftermath': {'anger': 0.359, 'disgust': 0.281, 'fear': 0.469, 'sadness': 0.5}, 'cad': {'anger': 0.359, 'disgust': 0.36700000000000005}, 'paucity': {'anger': 0.359, 'disgust': 0.39799999999999996, 'sadness': 0.43799999999999994}, 'opinionated': {'anger': 0.359}, 'incompetence': {'anger': 0.359}, 'broken': {'anger': 0.359, 'fear': 0.531, 'sadness': 0.594}, 'restriction': {'anger': 0.359, 'fear': 0.484, 'sadness': 0.43799999999999994}, 'controversial': {'anger': 0.359}, 'litigate': {'anger': 0.359, 'anticipation': 0.5, 'disgust': 0.35200000000000004, 'fear': 0.312, 'sadness': 0.344}, 'loudness': {'anger': 0.359}, 'disliked': {'anger': 0.359, 'disgust': 0.336, 'sadness': 0.5760000000000001}, 'sectarian': {'anger': 0.359, 'fear': 0.359}, 'polemic': {'anger': 0.359, 'disgust': 0.5}, 'interrupting': {'anger': 0.358}, 'fussy': {'anger': 0.35700000000000004, 'disgust': 0.22699999999999998}, 'wench': {'anger': 0.353, 'disgust': 0.617}, 'gruff': {'anger': 0.35100000000000003, 'disgust': 0.258}, 'misbehavior': {'anger': 0.35100000000000003, 'disgust': 0.35200000000000004, 'surprise': 0.5}, 'brat': {'anger': 0.35100000000000003}, 'remove': {'anger': 0.35100000000000003, 'fear': 0.32799999999999996, 'sadness': 0.281}, 'scarcity': {'anger': 0.35, 'fear': 0.43799999999999994, 'sadness': 0.45299999999999996}, 'losing': {'anger': 0.349, 'sadness': 0.594}, 'lie': {'anger': 0.348, 'disgust': 0.445, 'sadness': 0.585}, 'defect': {'anger': 0.348}, 'pest': {'anger': 0.348, 'disgust': 0.508, 'fear': 0.344}, 'retract': {'anger': 0.348}, 'disappointed': {'anger': 0.348, 'disgust': 0.32799999999999996, 'sadness': 0.636}, 'untrustworthy': {'anger': 0.348}, 'ulcer': {'anger': 0.348, 'disgust': 0.633, 'fear': 0.562, 'sadness': 0.312}, 'stigma': {'anger': 0.348, 'disgust': 0.45299999999999996, 'fear': 0.455, 'sadness': 0.43799999999999994}, 'hardened': {'anger': 0.348, 'disgust': 0.391, 'fear': 0.391}, 'deserted': {'anger': 0.348, 'disgust': 0.359, 'fear': 0.531, 'sadness': 0.688}, 'timewasters': {'anger': 0.348}, 'disagreement': {'anger': 0.348, 'sadness': 0.43799999999999994}, 'bias': {'anger': 0.345}, 'unreliable': {'anger': 0.344, 'trust': 0.172}, 'disclaim': {'anger': 0.344, 'disgust': 0.32, 'trust': 0.36700000000000005}, 'impotence': {'anger': 0.344, 'fear': 0.531, 'sadness': 0.625}, 'negation': {'anger': 0.344}, 'stripped': {'anger': 0.344, 'anticipation': 0.344, 'disgust': 0.36700000000000005, 'fear': 0.43799999999999994, 'sadness': 0.516}, 'unsettled': {'anger': 0.344, 'disgust': 0.336, 'fear': 0.327}, 'misleading': {'anger': 0.344, 'disgust': 0.321}, 'pirate': {'anger': 0.344}, 'shaky': {'anger': 0.344, 'anticipation': 0.469, 'fear': 0.344}, 'antisocial': {'anger': 0.344, 'disgust': 0.391, 'fear': 0.324, 'sadness': 0.531}, 'shoddy': {'anger': 0.344, 'disgust': 0.469}, 'anxiety': {'anger': 0.344, 'anticipation': 0.609, 'fear': 0.594, 'sadness': 0.5}, 'bothering': {'anger': 0.344, 'sadness': 0.435}, 'stingy': {'anger': 0.344, 'disgust': 0.39799999999999996, 'fear': 0.21899999999999997, 'sadness': 0.319}, 'deterioration': {'anger': 0.344, 'disgust': 0.7190000000000001, 'fear': 0.562, 'sadness': 0.536}, 'evade': {'anger': 0.344, 'disgust': 0.21899999999999997, 'fear': 0.344}, 'interminable': {'anger': 0.34299999999999997, 'anticipation': 0.375}, 'disease': {'anger': 0.341, 'disgust': 0.688, 'fear': 0.688, 'sadness': 0.665}, 'meddle': {'anger': 0.341}, 'warp': {'anger': 0.34, 'sadness': 0.23399999999999999}, 'infamous': {'anger': 0.33799999999999997, 'disgust': 0.289, 'fear': 0.42200000000000004}, 'alcoholism': {'anger': 0.33799999999999997, 'disgust': 0.562, 'fear': 0.5, 'sadness': 0.609}, 'averse': {'anger': 0.33799999999999997, 'disgust': 0.39799999999999996, 'fear': 0.483}, 'row': {'anger': 0.337}, 'staticky': {'anger': 0.336}, 'witchcraft': {'anger': 0.33299999999999996, 'fear': 0.703, 'sadness': 0.508}, 'illegitimate': {'anger': 0.33299999999999996, 'disgust': 0.414, 'fear': 0.43799999999999994, 'sadness': 0.41600000000000004, 'surprise': 0.414}, 'scorpion': {'anger': 0.33299999999999996, 'disgust': 0.391, 'fear': 0.547, 'surprise': 0.523}, 'paralyzed': {'anger': 0.33299999999999996, 'fear': 0.8590000000000001, 'sadness': 0.703, 'surprise': 0.586}, 'ill': {'anger': 0.33299999999999996, 'disgust': 0.49200000000000005, 'fear': 0.621, 'sadness': 0.594}, 'interrupt': {'anger': 0.33299999999999996, 'surprise': 0.539}, 'encumbrance': {'anger': 0.33299999999999996, 'fear': 0.32799999999999996, 'sadness': 0.441}, 'sinner': {'anger': 0.331, 'disgust': 0.594, 'fear': 0.483, 'sadness': 0.609}, 'hulk': {'anger': 0.32899999999999996, 'disgust': 0.25}, 'inconsiderate': {'anger': 0.32899999999999996, 'disgust': 0.312, 'sadness': 0.375}, 'dashed': {'anger': 0.32799999999999996, 'fear': 0.297, 'sadness': 0.469}, 'hiss': {'anger': 0.32799999999999996, 'fear': 0.344}, 'dislocated': {'anger': 0.32799999999999996, 'disgust': 0.375, 'fear': 0.43799999999999994, 'sadness': 0.43799999999999994}, 'opponent': {'anger': 0.32799999999999996, 'anticipation': 0.406, 'disgust': 0.242, 'fear': 0.312}, 'scapegoat': {'anger': 0.32799999999999996, 'fear': 0.25}, 'prohibited': {'anger': 0.32799999999999996, 'disgust': 0.281, 'fear': 0.5}, 'spammers': {'anger': 0.32799999999999996}, 'brrr': {'anger': 0.32799999999999996}, 'tighten': {'anger': 0.32799999999999996}, 'disqualified': {'anger': 0.32799999999999996, 'disgust': 0.22699999999999998, 'sadness': 0.435}, 'grumpy': {'anger': 0.32799999999999996, 'disgust': 0.305, 'sadness': 0.281}, 'fib': {'anger': 0.32799999999999996}, 'resisting': {'anger': 0.32799999999999996, 'fear': 0.45299999999999996, 'sadness': 0.309}, 'phony': {'anger': 0.32799999999999996, 'disgust': 0.406}, 'crusade': {'anger': 0.32799999999999996, 'fear': 0.392}, 'victim': {'anger': 0.32799999999999996, 'fear': 0.672, 'sadness': 0.703}, 'trickery': {'anger': 0.324, 'disgust': 0.43, 'fear': 0.312, 'sadness': 0.391, 'surprise': 0.617}, 'loss': {'anger': 0.324, 'fear': 0.578, 'sadness': 0.688}, 'neglected': {'anger': 0.324, 'disgust': 0.414, 'sadness': 0.688}, 'haye': {'anger': 0.324}, 'inappropriate': {'anger': 0.324, 'disgust': 0.312, 'sadness': 0.297}, 'eschew': {'anger': 0.324, 'disgust': 0.45299999999999996, 'sadness': 0.172}, 'canker': {'anger': 0.32299999999999995, 'disgust': 0.758}, 'crunch': {'anger': 0.318}, 'criticism': {'anger': 0.318, 'sadness': 0.484, 'trust': 0.23399999999999999}, 'duplicity': {'anger': 0.318}, 'queues': {'anger': 0.318}, 'muff': {'anger': 0.318, 'disgust': 0.391}, 'shriek': {'anger': 0.316, 'fear': 0.516, 'sadness': 0.485, 'surprise': 0.7190000000000001}, 'depreciate': {'anger': 0.315, 'disgust': 0.344}, 'carelessness': {'anger': 0.312, 'disgust': 0.42200000000000004}, 'mortality': {'anger': 0.312, 'fear': 0.797, 'sadness': 0.5}, 'dismissal': {'anger': 0.312, 'disgust': 0.35200000000000004, 'fear': 0.406, 'sadness': 0.6859999999999999, 'surprise': 0.312}, 'deflate': {'anger': 0.312, 'sadness': 0.43799999999999994}, 'dumps': {'anger': 0.312, 'sadness': 0.516}, 'chaff': {'anger': 0.312, 'fear': 0.172}, 'dupe': {'anger': 0.312}, 'dramaqueen': {'anger': 0.312}, 'poverty': {'anger': 0.312, 'disgust': 0.469, 'fear': 0.391, 'sadness': 0.69}, 'revving': {'anger': 0.309}, 'disallowed': {'anger': 0.308, 'disgust': 0.336, 'fear': 0.406, 'sadness': 0.32799999999999996}, 'boisterous': {'anger': 0.307, 'anticipation': 0.555, 'joy': 0.667}, 'thoughtless': {'anger': 0.307, 'disgust': 0.336}, 'burial': {'anger': 0.304, 'fear': 0.703, 'sadness': 0.812}, 'theocratic': {'anger': 0.303, 'fear': 0.391, 'sadness': 0.125, 'trust': 0.42200000000000004}, 'wince': {'anger': 0.303, 'disgust': 0.281, 'fear': 0.43799999999999994, 'sadness': 0.484}, 'sullen': {'anger': 0.303, 'sadness': 0.531}, 'involution': {'anger': 0.3}, 'talons': {'anger': 0.297, 'fear': 0.547}, 'senseless': {'anger': 0.297, 'disgust': 0.39799999999999996, 'fear': 0.32799999999999996, 'sadness': 0.281, 'surprise': 0.43799999999999994}, 'hoax': {'anger': 0.297, 'disgust': 0.36700000000000005, 'sadness': 0.406, 'surprise': 0.45299999999999996}, 'misuse': {'anger': 0.297}, 'wasteful': {'anger': 0.297, 'disgust': 0.484, 'sadness': 0.25}, 'depreciated': {'anger': 0.297, 'disgust': 0.312, 'fear': 0.297, 'sadness': 0.46}, 'getyourown': {'anger': 0.297}, 'depressed': {'anger': 0.297, 'fear': 0.469, 'sadness': 0.8590000000000001}, 'taxed': {'anger': 0.297}, 'stalemate': {'anger': 0.297, 'disgust': 0.188}, 'paralysis': {'anger': 0.295, 'anticipation': 0.21100000000000002, 'fear': 0.7340000000000001, 'sadness': 0.7190000000000001}, 'displaced': {'anger': 0.294, 'fear': 0.43799999999999994, 'sadness': 0.691}, 'limited': {'anger': 0.292, 'sadness': 0.16699999999999998}, 'disapointment': {'anger': 0.29}, 'orc': {'anger': 0.289, 'disgust': 0.38299999999999995, 'fear': 0.38799999999999996}, 'ridiculous': {'anger': 0.289, 'disgust': 0.35200000000000004}, 'react': {'anger': 0.28800000000000003, 'fear': 0.25}, 'spine': {'anger': 0.28800000000000003}, 'presumptuous': {'anger': 0.28800000000000003, 'disgust': 0.38299999999999995}, 'teasing': {'anger': 0.28800000000000003, 'fear': 0.303}, 'homeless': {'anger': 0.28800000000000003, 'anticipation': 0.289, 'disgust': 0.43799999999999994, 'fear': 0.609, 'sadness': 0.7340000000000001}, 'sharpen': {'anger': 0.28800000000000003, 'anticipation': 0.484}, 'barrier': {'anger': 0.287}, 'hoot': {'anger': 0.287, 'disgust': 0.16399999999999998}, 'twitchy': {'anger': 0.287}, 'myopia': {'anger': 0.28300000000000003, 'sadness': 0.33899999999999997}, 'spam': {'anger': 0.281}, 'restitution': {'anger': 0.281}, 'disconnects': {'anger': 0.281}, 'flexin': {'anger': 0.281}, 'lagging': {'anger': 0.281, 'anticipation': 0.18, 'disgust': 0.23399999999999999, 'sadness': 0.344}, 'incompatible': {'anger': 0.281, 'disgust': 0.359, 'sadness': 0.297}, 'delinquent': {'anger': 0.281, 'disgust': 0.42200000000000004}, 'contraband': {'anger': 0.281, 'disgust': 0.484, 'fear': 0.46399999999999997}, 'agh': {'anger': 0.281}, 'shiver': {'anger': 0.281, 'anticipation': 0.36700000000000005, 'fear': 0.484, 'sadness': 0.29100000000000004}, 'unfairness': {'anger': 0.27899999999999997, 'sadness': 0.745}, 'buffering': {'anger': 0.27899999999999997}, 'foray': {'anger': 0.27899999999999997}, 'troll': {'anger': 0.27899999999999997, 'fear': 0.42200000000000004}, 'noncompliance': {'anger': 0.27899999999999997, 'anticipation': 0.289, 'fear': 0.276, 'sadness': 0.375}, 'nether': {'anger': 0.278, 'fear': 0.312, 'sadness': 0.32799999999999996}, 'uncaring': {'anger': 0.273, 'disgust': 0.47700000000000004, 'sadness': 0.469}, 'bogus': {'anger': 0.273, 'disgust': 0.406}, 'bugaboo': {'anger': 0.273, 'fear': 0.32799999999999996, 'sadness': 0.304}, 'immaturity': {'anger': 0.273, 'anticipation': 0.273}, 'shock': {'anger': 0.26899999999999996, 'disgust': 0.375, 'fear': 0.7190000000000001, 'surprise': 0.8440000000000001}, 'feisty': {'anger': 0.26899999999999996}, 'pry': {'anger': 0.266, 'anticipation': 0.469, 'trust': 0.195}, 'nopoint': {'anger': 0.266}, 'notamorningperson': {'anger': 0.266}, 'quandary': {'anger': 0.266, 'fear': 0.45299999999999996}, 'bear': {'anger': 0.266, 'fear': 0.524}, 'feminism': {'anger': 0.266}, 'rapping': {'anger': 0.266}, 'defendant': {'anger': 0.266, 'fear': 0.32799999999999996, 'sadness': 0.359}, 'inconvenient': {'anger': 0.266, 'disgust': 0.203, 'sadness': 0.263}, 'inoperative': {'anger': 0.266}, 'latent': {'anger': 0.266, 'anticipation': 0.273, 'disgust': 0.305, 'surprise': 0.156}, 'humbug': {'anger': 0.266, 'disgust': 0.32, 'sadness': 0.25}, 'interrupts': {'anger': 0.265}, 'fluctuation': {'anger': 0.265, 'fear': 0.204}, 'exaggerate': {'anger': 0.263}, 'lose': {'anger': 0.261, 'disgust': 0.25, 'fear': 0.391, 'sadness': 0.509, 'surprise': 0.38299999999999995}, 'stone': {'anger': 0.258}, 'shoplifting': {'anger': 0.258, 'disgust': 0.406}, 'patter': {'anger': 0.258}, 'furnace': {'anger': 0.258}, 'soldier': {'anger': 0.258, 'sadness': 0.273}, 'tease': {'anger': 0.258, 'anticipation': 0.57, 'sadness': 0.188}, 'incompetent': {'anger': 0.257, 'sadness': 0.32799999999999996}, 'indoctrination': {'anger': 0.255, 'fear': 0.45299999999999996}, 'tripping': {'anger': 0.25, 'sadness': 0.429}, 'falsehood': {'anger': 0.25, 'trust': 0.16399999999999998}, 'unfollow': {'anger': 0.25}, 'nonsense': {'anger': 0.25}, 'socialist': {'anger': 0.25, 'disgust': 0.42200000000000004, 'fear': 0.318, 'sadness': 0.125}, 'rocket': {'anger': 0.25}, 'noisy': {'anger': 0.25}, 'notoriety': {'anger': 0.25, 'disgust': 0.289, 'fear': 0.109}, 'complicate': {'anger': 0.25}, 'untrue': {'anger': 0.25}, 'cane': {'anger': 0.25, 'fear': 0.21899999999999997}, 'skid': {'anger': 0.25, 'fear': 0.266, 'sadness': 0.312}, 'mastery': {'anger': 0.25, 'joy': 0.53, 'trust': 0.672}, 'attentionseeker': {'anger': 0.25}, 'pouting': {'anger': 0.25}, 'lawyer': {'anger': 0.25, 'disgust': 0.35200000000000004, 'fear': 0.349}, 'vampire': {'anger': 0.242, 'disgust': 0.414, 'fear': 0.625}, 'capslock': {'anger': 0.242}, 'obstacle': {'anger': 0.242, 'fear': 0.344, 'sadness': 0.266, 'trust': 0.242}, 'fenced': {'anger': 0.242}, 'ringer': {'anger': 0.242}, 'halter': {'anger': 0.242, 'fear': 0.318, 'sadness': 0.188}, 'dontunderstand': {'anger': 0.242}, 'detract': {'anger': 0.242}, 'witch': {'anger': 0.242, 'disgust': 0.43, 'fear': 0.565}, 'frowning': {'anger': 0.239, 'disgust': 0.21899999999999997, 'sadness': 0.5}, 'saber': {'anger': 0.23800000000000002, 'fear': 0.531}, 'hunger': {'anger': 0.235}, 'imtryingtosleep': {'anger': 0.23399999999999999}, 'shell': {'anger': 0.23399999999999999, 'fear': 0.172, 'sadness': 0.045, 'surprise': 0.21100000000000002}, 'recession': {'anger': 0.23399999999999999, 'disgust': 0.49200000000000005, 'fear': 0.344, 'sadness': 0.485}, 'politics': {'anger': 0.23399999999999999}, 'lava': {'anger': 0.23399999999999999, 'fear': 0.588}, 'dabbling': {'anger': 0.23399999999999999, 'disgust': 0.195}, 'wokemeup': {'anger': 0.23399999999999999}, 'rascal': {'anger': 0.23399999999999999, 'disgust': 0.258, 'fear': 0.25}, 'tariff': {'anger': 0.23399999999999999, 'disgust': 0.242}, 'failing': {'anger': 0.23399999999999999, 'anticipation': 0.38299999999999995, 'fear': 0.531, 'sadness': 0.6409999999999999}, 'undesirable': {'anger': 0.231, 'disgust': 0.43, 'fear': 0.32799999999999996, 'sadness': 0.578}, 'copycat': {'anger': 0.22699999999999998, 'disgust': 0.258}, 'resign': {'anger': 0.22699999999999998, 'disgust': 0.23399999999999999, 'fear': 0.45299999999999996, 'sadness': 0.484}, 'versus': {'anger': 0.22699999999999998}, 'darkness': {'anger': 0.22699999999999998, 'fear': 0.516, 'sadness': 0.409}, 'soaked': {'anger': 0.226}, 'unfulfilled': {'anger': 0.225, 'anticipation': 0.391, 'sadness': 0.547, 'surprise': 0.195}, 'abandoned': {'anger': 0.222, 'fear': 0.534, 'sadness': 0.828}, 'owing': {'anger': 0.221, 'anticipation': 0.516, 'disgust': 0.203, 'fear': 0.188, 'sadness': 0.39799999999999996, 'trust': 0.289}, 'unattainable': {'anger': 0.221, 'sadness': 0.43799999999999994}, 'bankruptcy': {'anger': 0.221, 'disgust': 0.445, 'fear': 0.359, 'sadness': 0.5}, 'misconception': {'anger': 0.21899999999999997, 'disgust': 0.25, 'fear': 0.375}, 'warden': {'anger': 0.21899999999999997, 'fear': 0.354, 'trust': 0.5}, 'whiny': {'anger': 0.21899999999999997}, 'tool': {'anger': 0.21899999999999997}, 'confusion': {'anger': 0.21899999999999997, 'fear': 0.281, 'sadness': 0.273}, 'mosquito': {'anger': 0.21899999999999997, 'disgust': 0.445}, 'twitching': {'anger': 0.21899999999999997}, 'unhelpful': {'anger': 0.21899999999999997}, 'compress': {'anger': 0.21899999999999997}, 'somethingigetalot': {'anger': 0.21899999999999997}, 'nosey': {'anger': 0.213}, 'overpriced': {'anger': 0.212, 'disgust': 0.312, 'sadness': 0.141}, 'harry': {'anger': 0.212, 'sadness': 0.109}, 'adder': {'anger': 0.212, 'disgust': 0.38299999999999995, 'fear': 0.547, 'sadness': 0.361}, 'shortage': {'anger': 0.212, 'fear': 0.344, 'sadness': 0.281}, 'melodrama': {'anger': 0.212, 'sadness': 0.242}, 'possession': {'anger': 0.20600000000000002, 'disgust': 0.18, 'fear': 0.406}, 'desert': {'anger': 0.20600000000000002, 'disgust': 0.203, 'fear': 0.359, 'sadness': 0.344}, 'overplayed': {'anger': 0.20600000000000002}, 'unlucky': {'anger': 0.203, 'disgust': 0.23399999999999999, 'fear': 0.32799999999999996, 'sadness': 0.516}, 'arraignment': {'anger': 0.203, 'fear': 0.45, 'sadness': 0.359}, 'unpaid': {'anger': 0.203, 'sadness': 0.125}, 'rook': {'anger': 0.203, 'disgust': 0.242}, 'uninvited': {'anger': 0.203, 'sadness': 0.344}, 'powerless': {'anger': 0.203, 'disgust': 0.36700000000000005, 'fear': 0.562, 'sadness': 0.6409999999999999}, 'backbone': {'anger': 0.203, 'trust': 0.633}, 'sentence': {'anger': 0.203, 'anticipation': 0.273, 'disgust': 0.156, 'fear': 0.266, 'sadness': 0.23399999999999999}, 'inefficient': {'anger': 0.203, 'sadness': 0.391}, 'pout': {'anger': 0.203}, 'court': {'anger': 0.19899999999999998, 'anticipation': 0.49200000000000005, 'fear': 0.284}, 'endless': {'anger': 0.198, 'fear': 0.297, 'joy': 0.303, 'sadness': 0.32799999999999996, 'trust': 0.344}, 'misstatement': {'anger': 0.19699999999999998, 'disgust': 0.23399999999999999}, 'distracted': {'anger': 0.19699999999999998}, 'adverts': {'anger': 0.19699999999999998}, 'delay': {'anger': 0.19699999999999998, 'disgust': 0.297, 'fear': 0.141, 'sadness': 0.373}, 'misunderstanding': {'anger': 0.195, 'sadness': 0.359}, 'excite': {'anger': 0.191, 'anticipation': 0.742, 'fear': 0.132, 'joy': 0.6970000000000001, 'surprise': 0.695}, 'inadmissible': {'anger': 0.191, 'disgust': 0.305}, 'lightning': {'anger': 0.18899999999999997, 'fear': 0.594, 'surprise': 0.594}, 'preclude': {'anger': 0.188}, 'incase': {'anger': 0.188, 'disgust': 0.258, 'fear': 0.109, 'sadness': 0.297}, 'insecure': {'anger': 0.188, 'fear': 0.461, 'sadness': 0.509}, 'mournful': {'anger': 0.188, 'fear': 0.359, 'sadness': 0.812}, 'claimant': {'anger': 0.182, 'disgust': 0.18}, 'mutter': {'anger': 0.182}, 'mistress': {'anger': 0.182, 'disgust': 0.523}, 'rating': {'anger': 0.182, 'fear': 0.25, 'sadness': 0.109}, 'pare': {'anger': 0.182, 'anticipation': 0.336, 'fear': 0.36700000000000005, 'sadness': 0.155}, 'insist': {'anger': 0.182}, 'distracting': {'anger': 0.182, 'anticipation': 0.39799999999999996}, 'opium': {'anger': 0.18, 'disgust': 0.445, 'fear': 0.344, 'sadness': 0.303}, 'willful': {'anger': 0.17600000000000002, 'sadness': 0.16}, 'deserve': {'anger': 0.17600000000000002, 'anticipation': 0.602, 'trust': 0.516}, 'treat': {'anger': 0.175, 'anticipation': 0.516, 'disgust': 0.078, 'fear': 0.094, 'joy': 0.529, 'sadness': 0.076, 'surprise': 0.312, 'trust': 0.42200000000000004}, 'insists': {'anger': 0.175}, 'gibberish': {'anger': 0.172}, 'excitation': {'anger': 0.172, 'anticipation': 0.703, 'fear': 0.391, 'joy': 0.8909999999999999, 'surprise': 0.6409999999999999}, 'mighty': {'anger': 0.172, 'fear': 0.203, 'joy': 0.43799999999999994, 'trust': 0.469}, 'hormonal': {'anger': 0.172}, 'fee': {'anger': 0.172}, 'fleece': {'anger': 0.172, 'disgust': 0.195, 'sadness': 0.109}, 'indecisive': {'anger': 0.172, 'fear': 0.25}, 'liberate': {'anger': 0.172, 'anticipation': 0.695, 'joy': 0.485, 'surprise': 0.523, 'trust': 0.523}, 'peice': {'anger': 0.172}, 'misplace': {'anger': 0.172, 'disgust': 0.156}, 'thanksalot': {'anger': 0.172}, 'yelp': {'anger': 0.168, 'fear': 0.281, 'surprise': 0.516}, 'bargaining': {'anger': 0.16699999999999998}, 'mule': {'anger': 0.16699999999999998, 'trust': 0.281}, 'unequal': {'anger': 0.16699999999999998, 'disgust': 0.32, 'fear': 0.21899999999999997, 'sadness': 0.42200000000000004}, 'insignificant': {'anger': 0.16699999999999998, 'sadness': 0.43799999999999994}, 'hamstring': {'anger': 0.16699999999999998, 'sadness': 0.312}, 'insufficiency': {'anger': 0.16699999999999998}, 'attentionseekers': {'anger': 0.163}, 'forearm': {'anger': 0.156, 'anticipation': 0.25}, 'rheumatism': {'anger': 0.156, 'fear': 0.43799999999999994, 'sadness': 0.562}, 'indifference': {'anger': 0.156, 'disgust': 0.203, 'fear': 0.25, 'sadness': 0.21899999999999997}, 'coop': {'anger': 0.156, 'disgust': 0.304}, 'attorney': {'anger': 0.152, 'fear': 0.188, 'trust': 0.35200000000000004}, 'uncertain': {'anger': 0.152, 'disgust': 0.35200000000000004, 'fear': 0.172, 'surprise': 0.633}, 'involvement': {'anger': 0.152}, 'underpaid': {'anger': 0.152, 'sadness': 0.43799999999999994}, 'pretending': {'anger': 0.152}, 'justthebeginning': {'anger': 0.152}, 'bee': {'anger': 0.152, 'fear': 0.23399999999999999}, 'disinformation': {'anger': 0.152, 'fear': 0.28600000000000003}, 'campaigning': {'anger': 0.151, 'fear': 0.125}, 'hopelessness': {'anger': 0.149, 'disgust': 0.43799999999999994, 'fear': 0.531, 'sadness': 0.8440000000000001}, 'feeling': {'anger': 0.147, 'anticipation': 0.555, 'disgust': 0.141, 'fear': 0.32799999999999996, 'joy': 0.359, 'sadness': 0.172, 'surprise': 0.359, 'trust': 0.518}, 'legalized': {'anger': 0.145, 'fear': 0.156, 'joy': 0.203, 'trust': 0.578}, 'caution': {'anger': 0.145, 'anticipation': 0.516, 'fear': 0.32799999999999996}, 'morals': {'anger': 0.141, 'anticipation': 0.266, 'disgust': 0.195, 'joy': 0.297, 'surprise': 0.203, 'trust': 0.695}, 'sterling': {'anger': 0.141, 'anticipation': 0.375, 'joy': 0.312, 'trust': 0.47700000000000004}, 'obliging': {'anger': 0.141, 'anticipation': 0.39799999999999996, 'disgust': 0.156, 'fear': 0.25, 'joy': 0.33299999999999996, 'surprise': 0.188, 'trust': 0.539}, 'subsidy': {'anger': 0.141, 'disgust': 0.22699999999999998}, 'wimpy': {'anger': 0.14, 'disgust': 0.36700000000000005, 'fear': 0.312, 'sadness': 0.348}, 'bummer': {'anger': 0.139, 'disgust': 0.14800000000000002, 'sadness': 0.439}, 'repay': {'anger': 0.136, 'anticipation': 0.49200000000000005, 'joy': 0.212, 'trust': 0.43}, 'surcharge': {'anger': 0.136}, 'saloon': {'anger': 0.136}, 'misspell': {'anger': 0.136}, 'blemish': {'anger': 0.136, 'disgust': 0.531, 'fear': 0.266, 'sadness': 0.31}, 'geez': {'anger': 0.136}, 'birch': {'anger': 0.135, 'disgust': 0.203, 'fear': 0.172}, 'noob': {'anger': 0.133}, 'honk': {'anger': 0.133}, 'orchestra': {'anger': 0.132, 'joy': 0.221, 'sadness': 0.109, 'trust': 0.445}, 'wireless': {'anger': 0.125, 'anticipation': 0.344, 'surprise': 0.14800000000000002}, 'standstill': {'anger': 0.125, 'fear': 0.25}, 'competitive': {'anger': 0.125}, 'mosque': {'anger': 0.122}, 'reversal': {'anger': 0.121, 'disgust': 0.22699999999999998, 'surprise': 0.469}, 'inattention': {'anger': 0.121}, 'lace': {'anger': 0.11800000000000001, 'fear': 0.111, 'sadness': 0.11800000000000001, 'trust': 0.344}, 'elbow': {'anger': 0.11699999999999999}, 'instinctive': {'anger': 0.11199999999999999, 'disgust': 0.258, 'fear': 0.23399999999999999}, 'chant': {'anger': 0.111, 'anticipation': 0.38299999999999995, 'joy': 0.203, 'surprise': 0.23399999999999999}, 'gnome': {'anger': 0.109, 'disgust': 0.203, 'fear': 0.188}, 'lonely': {'anger': 0.109, 'disgust': 0.297, 'fear': 0.183, 'sadness': 0.6559999999999999}, 'tolerate': {'anger': 0.106, 'sadness': 0.141}, 'management': {'anger': 0.102, 'trust': 0.516}, 'advocacy': {'anger': 0.1, 'anticipation': 0.5, 'joy': 0.25, 'trust': 0.68}, 'moral': {'anger': 0.094, 'trust': 0.758}, 'roadworks': {'anger': 0.091}, 'honest': {'anger': 0.087, 'disgust': 0.055, 'fear': 0.047, 'joy': 0.303, 'sadness': 0.062, 'trust': 0.8440000000000001}, 'forgetful': {'anger': 0.076}, 'gent': {'anger': 0.076, 'disgust': 0.188, 'fear': 0.141}, 'liquor': {'anger': 0.075, 'joy': 0.188, 'sadness': 0.0}, 'money': {'anger': 0.07400000000000001, 'anticipation': 0.586, 'joy': 0.531, 'surprise': 0.203, 'trust': 0.359}, 'hood': {'anger': 0.071, 'disgust': 0.203, 'fear': 0.266}, 'curriculum': {'anger': 0.063}, 'words': {'anger': 0.062}, 'smell': {'anger': 0.061, 'disgust': 0.445}, 'elf': {'anger': 0.061, 'disgust': 0.141, 'fear': 0.185, 'joy': 0.156}, 'playful': {'anger': 0.061, 'joy': 0.609, 'surprise': 0.266, 'trust': 0.43}, 'opera': {'anger': 0.061, 'anticipation': 0.469, 'fear': 0.057, 'joy': 0.109, 'sadness': 0.078, 'surprise': 0.242, 'trust': 0.336}, 'trumpet': {'anger': 0.059000000000000004}, 'nurture': {'anger': 0.059000000000000004, 'anticipation': 0.406, 'disgust': 0.11699999999999999, 'fear': 0.078, 'joy': 0.469, 'trust': 0.703}, 'asleeep': {'anger': 0.059000000000000004}, 'counsellor': {'anger': 0.059000000000000004, 'fear': 0.094, 'trust': 0.57}, 'birthplace': {'anger': 0.051}, 'ribbon': {'anger': 0.047, 'anticipation': 0.32799999999999996, 'joy': 0.212}, 'vote': {'anger': 0.045, 'anticipation': 0.547, 'joy': 0.23399999999999999, 'sadness': 0.031, 'surprise': 0.125, 'trust': 0.555}, 'youth': {'anger': 0.045, 'anticipation': 0.49200000000000005, 'fear': 0.062, 'joy': 0.375, 'surprise': 0.172}, 'cash': {'anger': 0.039, 'anticipation': 0.469, 'fear': 0.062, 'joy': 0.406, 'trust': 0.414}, 'wannasleep': {'anger': 0.031}, 'waffle': {'anger': 0.03, 'sadness': 0.047}, 'dame': {'anger': 0.03, 'disgust': 0.21899999999999997, 'trust': 0.344}, 'buffet': {'anger': 0.028999999999999998}, 'celebrity': {'anger': 0.026000000000000002, 'anticipation': 0.516, 'disgust': 0.188, 'joy': 0.342, 'surprise': 0.344, 'trust': 0.273}, 'autocorrect': {'anger': 0.015}, 'sisterhood': {'anger': 0.015, 'sadness': 0.125, 'surprise': 0.109, 'trust': 0.773}, 'musical': {'anger': 0.011000000000000001, 'anticipation': 0.36700000000000005, 'joy': 0.42200000000000004, 'sadness': 0.045, 'surprise': 0.21899999999999997, 'trust': 0.49200000000000005}, 'tree': {'anger': 0.0, 'anticipation': 0.22699999999999998, 'disgust': 0.039, 'joy': 0.09, 'surprise': 0.078, 'trust': 0.406}, 'excited': {'anticipation': 0.8590000000000001, 'joy': 0.818, 'surprise': 0.625, 'trust': 0.45299999999999996}, 'anticipation': {'anticipation': 0.8590000000000001}, 'excitement': {'anticipation': 0.82, 'joy': 0.922, 'surprise': 0.7340000000000001}, 'anticipate': {'anticipation': 0.82}, 'eagerness': {'anticipation': 0.812, 'joy': 0.552, 'trust': 0.469}, 'exciting': {'anticipation': 0.797, 'joy': 0.853, 'surprise': 0.672}, 'expectant': {'anticipation': 0.789}, 'thrilling': {'anticipation': 0.7809999999999999, 'joy': 0.7759999999999999, 'surprise': 0.8590000000000001}, 'hope': {'anticipation': 0.773, 'joy': 0.586, 'surprise': 0.36700000000000005, 'trust': 0.68}, 'quest': {'anticipation': 0.7659999999999999}, 'countdown': {'anticipation': 0.75, 'fear': 0.156}, 'anticipatory': {'anticipation': 0.75}, 'expectance': {'anticipation': 0.75}, 'start': {'anticipation': 0.75, 'surprise': 0.344}, 'adventure': {'anticipation': 0.75, 'joy': 0.47}, 'eager': {'anticipation': 0.742, 'joy': 0.43799999999999994, 'surprise': 0.406, 'trust': 0.539}, 'climax': {'anticipation': 0.742, 'joy': 0.636, 'surprise': 0.805, 'trust': 0.39799999999999996}, 'arouse': {'anticipation': 0.742}, 'expect': {'anticipation': 0.742, 'surprise': 0.14800000000000002, 'trust': 0.47700000000000004}, 'prophecy': {'anticipation': 0.742}, 'ejaculation': {'anticipation': 0.7340000000000001, 'joy': 0.424, 'surprise': 0.547, 'trust': 0.273}, 'announcement': {'anticipation': 0.7340000000000001}, 'birth': {'anticipation': 0.7340000000000001, 'fear': 0.203, 'joy': 0.45299999999999996, 'trust': 0.5}, 'imminent': {'anticipation': 0.727, 'fear': 0.345}, 'urgent': {'anticipation': 0.727, 'fear': 0.45, 'surprise': 0.695}, 'expecting': {'anticipation': 0.727}, 'liberation': {'anticipation': 0.727, 'joy': 0.531, 'surprise': 0.414}, 'expectancy': {'anticipation': 0.727}, 'prospection': {'anticipation': 0.7190000000000001}, 'prospect': {'anticipation': 0.7190000000000001}, 'reunion': {'anticipation': 0.7190000000000001, 'joy': 0.375, 'trust': 0.555}, 'aspire': {'anticipation': 0.7190000000000001, 'joy': 0.516, 'trust': 0.49200000000000005}, 'voyage': {'anticipation': 0.7190000000000001}, 'trepidation': {'anticipation': 0.7190000000000001, 'fear': 0.688, 'surprise': 0.43}, 'mystery': {'anticipation': 0.711, 'surprise': 0.625}, 'journey': {'anticipation': 0.711, 'fear': 0.062, 'joy': 0.447}, 'kiss': {'anticipation': 0.711, 'joy': 0.61, 'surprise': 0.312}, 'yearning': {'anticipation': 0.711, 'joy': 0.297, 'trust': 0.39799999999999996}, 'enthusiasm': {'anticipation': 0.711, 'joy': 0.742, 'surprise': 0.6409999999999999}, 'ecstasy': {'anticipation': 0.711, 'joy': 0.9059999999999999}, 'suspense': {'anticipation': 0.711, 'fear': 0.529, 'surprise': 0.703}, 'rapture': {'anticipation': 0.711, 'joy': 0.485}, 'thrill': {'anticipation': 0.703, 'fear': 0.21899999999999997, 'joy': 0.721, 'surprise': 0.68}, 'urgency': {'anticipation': 0.703, 'fear': 0.391, 'surprise': 0.625}, 'tantalizing': {'anticipation': 0.703, 'joy': 0.5720000000000001, 'surprise': 0.547}, 'frantic': {'anticipation': 0.703, 'disgust': 0.266, 'fear': 0.705, 'surprise': 0.7340000000000001}, 'prospective': {'anticipation': 0.703}, 'lottery': {'anticipation': 0.703}, 'progress': {'anticipation': 0.703, 'joy': 0.397}, 'hopeful': {'anticipation': 0.703, 'joy': 0.5589999999999999, 'surprise': 0.23399999999999999, 'trust': 0.633}, 'destination': {'anticipation': 0.703, 'fear': 0.109, 'joy': 0.281, 'sadness': 0.17, 'surprise': 0.14800000000000002}, 'arrival': {'anticipation': 0.695}, 'achievement': {'anticipation': 0.695, 'joy': 0.7120000000000001, 'trust': 0.625}, 'hurry': {'anticipation': 0.695, 'fear': 0.203}, 'advance': {'anticipation': 0.695, 'fear': 0.188, 'joy': 0.375, 'surprise': 0.375}, 'explore': {'anticipation': 0.695}, 'readiness': {'anticipation': 0.695, 'joy': 0.473, 'trust': 0.547}, 'vacation': {'anticipation': 0.695, 'joy': 0.547}, 'expectation': {'anticipation': 0.695}, 'prediction': {'anticipation': 0.695}, 'sex': {'anticipation': 0.695, 'joy': 0.622, 'trust': 0.375}, 'approaching': {'anticipation': 0.688}, 'ecstatic': {'anticipation': 0.688, 'joy': 0.9540000000000001, 'surprise': 0.562}, 'allure': {'anticipation': 0.688, 'joy': 0.45299999999999996, 'surprise': 0.406}, 'roulette': {'anticipation': 0.68}, 'honeymoon': {'anticipation': 0.68, 'joy': 0.636, 'surprise': 0.25, 'trust': 0.523}, 'wishful': {'anticipation': 0.672}, 'celebrating': {'anticipation': 0.672, 'joy': 0.97}, 'holiday': {'anticipation': 0.672, 'joy': 0.7120000000000001}, 'crescendo': {'anticipation': 0.672, 'joy': 0.485, 'surprise': 0.555, 'trust': 0.35200000000000004}, 'orgasm': {'anticipation': 0.664, 'joy': 0.765}, 'invitation': {'anticipation': 0.664}, 'impending': {'anticipation': 0.664, 'fear': 0.562}, 'winning': {'anticipation': 0.664, 'disgust': 0.109, 'joy': 0.703, 'sadness': 0.094, 'surprise': 0.45299999999999996, 'trust': 0.523}, 'winnings': {'anticipation': 0.664, 'joy': 0.609}, 'craving': {'anticipation': 0.664}, 'rescue': {'anticipation': 0.664, 'joy': 0.225, 'surprise': 0.547, 'trust': 0.531}, 'triumph': {'anticipation': 0.664, 'joy': 0.742}, 'waiting': {'anticipation': 0.664, 'fear': 0.141}, 'courtship': {'anticipation': 0.6559999999999999, 'joy': 0.375, 'trust': 0.508}, 'bridegroom': {'anticipation': 0.6559999999999999, 'joy': 0.469, 'trust': 0.445}, 'gain': {'anticipation': 0.6559999999999999, 'joy': 0.28800000000000003, 'trust': 0.469}, 'aspiring': {'anticipation': 0.6559999999999999, 'joy': 0.618, 'trust': 0.539}, 'celebration': {'anticipation': 0.6559999999999999, 'joy': 0.929, 'surprise': 0.539, 'trust': 0.523}, 'bridal': {'anticipation': 0.6559999999999999, 'joy': 0.531, 'trust': 0.43}, 'jackpot': {'anticipation': 0.6559999999999999, 'joy': 0.6409999999999999, 'surprise': 0.812}, 'reward': {'anticipation': 0.6559999999999999, 'joy': 0.625, 'surprise': 0.562, 'trust': 0.508}, 'marriage': {'anticipation': 0.6559999999999999, 'joy': 0.514, 'trust': 0.695}, 'victory': {'anticipation': 0.6559999999999999, 'joy': 0.7340000000000001, 'trust': 0.586}, 'fortune': {'anticipation': 0.6559999999999999, 'joy': 0.591, 'surprise': 0.47700000000000004, 'trust': 0.38299999999999995}, 'strive': {'anticipation': 0.6559999999999999, 'trust': 0.531}, 'aspiration': {'anticipation': 0.648, 'joy': 0.485, 'surprise': 0.391, 'trust': 0.633}, 'prescient': {'anticipation': 0.648}, 'inheritance': {'anticipation': 0.648, 'joy': 0.47, 'surprise': 0.38299999999999995, 'trust': 0.586}, 'opportunity': {'anticipation': 0.648}, 'delivery': {'anticipation': 0.648}, 'alertness': {'anticipation': 0.648, 'fear': 0.21600000000000003, 'surprise': 0.5}, 'treasure': {'anticipation': 0.648, 'joy': 0.652, 'trust': 0.5}, 'tomorrow': {'anticipation': 0.648}, 'crowning': {'anticipation': 0.648, 'joy': 0.485, 'surprise': 0.38299999999999995, 'trust': 0.484}, 'intrigue': {'anticipation': 0.648, 'fear': 0.188, 'surprise': 0.43}, 'rising': {'anticipation': 0.648, 'joy': 0.375}, 'receiving': {'anticipation': 0.6409999999999999, 'joy': 0.287, 'surprise': 0.258}, 'bride': {'anticipation': 0.6409999999999999, 'joy': 0.47100000000000003, 'trust': 0.531}, 'celebrated': {'anticipation': 0.6409999999999999, 'joy': 0.8590000000000001}, 'launch': {'anticipation': 0.6409999999999999}, 'engaged': {'anticipation': 0.6409999999999999, 'joy': 0.652, 'trust': 0.625}, 'possibility': {'anticipation': 0.6409999999999999}, 'expedition': {'anticipation': 0.6409999999999999}, 'spectacular': {'anticipation': 0.6409999999999999, 'joy': 0.912, 'surprise': 0.688}, 'happiness': {'anticipation': 0.6409999999999999, 'joy': 0.9840000000000001}, 'reckoning': {'anticipation': 0.6409999999999999}, 'prognosis': {'anticipation': 0.6409999999999999, 'fear': 0.217}, 'erotic': {'anticipation': 0.6409999999999999, 'joy': 0.5, 'surprise': 0.5, 'trust': 0.21899999999999997}, 'award': {'anticipation': 0.6409999999999999, 'joy': 0.727, 'surprise': 0.35200000000000004, 'trust': 0.523}, 'anxious': {'anticipation': 0.6409999999999999, 'fear': 0.518}, 'hype': {'anticipation': 0.6409999999999999}, 'await': {'anticipation': 0.633}, 'curious': {'anticipation': 0.633}, 'vision': {'anticipation': 0.633}, 'coming': {'anticipation': 0.633}, 'birthday': {'anticipation': 0.633, 'joy': 0.691, 'surprise': 0.49200000000000005}, 'delight': {'anticipation': 0.633, 'joy': 0.765}, 'beware': {'anticipation': 0.633, 'fear': 0.547}, 'passionate': {'anticipation': 0.633, 'joy': 0.7340000000000001, 'trust': 0.617}, 'firstborn': {'anticipation': 0.633, 'joy': 0.531, 'trust': 0.531}, 'miracle': {'anticipation': 0.633, 'joy': 0.742, 'surprise': 0.8590000000000001, 'trust': 0.562}, 'destiny': {'anticipation': 0.633, 'joy': 0.484}, 'passion': {'anticipation': 0.633, 'joy': 0.603, 'trust': 0.469}, 'prepare': {'anticipation': 0.633}, 'captivate': {'anticipation': 0.633, 'joy': 0.6559999999999999, 'surprise': 0.672, 'trust': 0.523}, 'graduation': {'anticipation': 0.633, 'fear': 0.078, 'joy': 0.42200000000000004, 'surprise': 0.18, 'trust': 0.523}, 'ominous': {'anticipation': 0.633, 'fear': 0.594}, 'succeed': {'anticipation': 0.633, 'joy': 0.516, 'surprise': 0.375, 'trust': 0.555}, 'triumphant': {'anticipation': 0.625, 'joy': 0.907, 'trust': 0.617}, 'ripen': {'anticipation': 0.625}, 'retirement': {'anticipation': 0.625, 'fear': 0.156, 'joy': 0.275, 'sadness': 0.188, 'trust': 0.531}, 'gift': {'anticipation': 0.625, 'joy': 0.547, 'surprise': 0.43}, 'optimism': {'anticipation': 0.625, 'joy': 0.703, 'surprise': 0.336, 'trust': 0.617}, 'foresee': {'anticipation': 0.625, 'surprise': 0.18, 'trust': 0.45299999999999996}, 'inspiration': {'anticipation': 0.625, 'joy': 0.725, 'trust': 0.648}, 'revival': {'anticipation': 0.625, 'joy': 0.359, 'trust': 0.578}, 'lust': {'anticipation': 0.625}, 'escape': {'anticipation': 0.625, 'fear': 0.406}, 'destined': {'anticipation': 0.617, 'trust': 0.555}, 'verge': {'anticipation': 0.617, 'fear': 0.23399999999999999}, 'embrace': {'anticipation': 0.617, 'joy': 0.6759999999999999, 'surprise': 0.312, 'trust': 0.602}, 'foresight': {'anticipation': 0.617, 'trust': 0.555}, 'surprisingly': {'anticipation': 0.617, 'surprise': 0.875}, 'enchanting': {'anticipation': 0.617, 'joy': 0.828}, 'risky': {'anticipation': 0.617, 'fear': 0.562}, 'bloom': {'anticipation': 0.617, 'joy': 0.5, 'trust': 0.531}, 'ambition': {'anticipation': 0.617, 'joy': 0.578, 'trust': 0.586}, 'simmering': {'anticipation': 0.617}, 'foreboding': {'anticipation': 0.617, 'fear': 0.516}, 'seductive': {'anticipation': 0.609}, 'magical': {'anticipation': 0.609, 'joy': 0.742, 'surprise': 0.609}, 'bonus': {'anticipation': 0.609, 'joy': 0.547, 'surprise': 0.586}, 'lookout': {'anticipation': 0.609}, 'alerts': {'anticipation': 0.609, 'fear': 0.276, 'surprise': 0.594}, 'matrimony': {'anticipation': 0.609, 'joy': 0.531, 'trust': 0.648}, 'succeeding': {'anticipation': 0.609, 'joy': 0.5760000000000001, 'trust': 0.562}, 'forecast': {'anticipation': 0.609, 'trust': 0.484}, 'applicant': {'anticipation': 0.602}, 'winner': {'anticipation': 0.602, 'joy': 0.636, 'surprise': 0.547}, 'foreseen': {'anticipation': 0.602}, 'inspire': {'anticipation': 0.602, 'joy': 0.594, 'trust': 0.68}, 'picnic': {'anticipation': 0.602, 'joy': 0.39399999999999996, 'surprise': 0.078, 'trust': 0.375}, 'success': {'anticipation': 0.602, 'joy': 0.797}, 'nervous': {'anticipation': 0.602, 'fear': 0.469}, 'visionary': {'anticipation': 0.602, 'joy': 0.5, 'trust': 0.594}, 'entertaining': {'anticipation': 0.602, 'joy': 0.688}, 'longing': {'anticipation': 0.602, 'sadness': 0.594}, 'diagnosis': {'anticipation': 0.602, 'fear': 0.391, 'trust': 0.484}, 'boomerang': {'anticipation': 0.602, 'trust': 0.359}, 'prophetic': {'anticipation': 0.602}, 'fulfillment': {'anticipation': 0.602, 'joy': 0.728, 'trust': 0.664}, 'intended': {'anticipation': 0.602, 'trust': 0.469}, 'momentum': {'anticipation': 0.594}, 'luck': {'anticipation': 0.594, 'joy': 0.484, 'surprise': 0.508}, 'illuminate': {'anticipation': 0.594, 'joy': 0.547, 'surprise': 0.547}, 'arrive': {'anticipation': 0.594}, 'romance': {'anticipation': 0.594, 'fear': 0.031, 'joy': 0.779, 'sadness': 0.0, 'surprise': 0.289, 'trust': 0.484}, 'preparedness': {'anticipation': 0.594}, 'result': {'anticipation': 0.594}, 'acquiring': {'anticipation': 0.594}, 'accelerate': {'anticipation': 0.594}, 'advent': {'anticipation': 0.594, 'joy': 0.152, 'trust': 0.516}, 'buzz': {'anticipation': 0.594, 'fear': 0.23399999999999999}, 'rekindle': {'anticipation': 0.594, 'fear': 0.23399999999999999, 'joy': 0.609, 'surprise': 0.336}, 'marry': {'anticipation': 0.594, 'fear': 0.125, 'joy': 0.6759999999999999, 'surprise': 0.242, 'trust': 0.594}, 'predict': {'anticipation': 0.589}, 'presumption': {'anticipation': 0.586, 'trust': 0.305}, 'progression': {'anticipation': 0.586, 'joy': 0.312, 'sadness': 0.201, 'trust': 0.609}, 'endeavor': {'anticipation': 0.586}, 'investigation': {'anticipation': 0.586}, 'uplift': {'anticipation': 0.586, 'joy': 0.723, 'trust': 0.562}, 'impatient': {'anticipation': 0.586, 'fear': 0.22399999999999998}, 'preparation': {'anticipation': 0.586}, 'gambling': {'anticipation': 0.586, 'surprise': 0.445}, 'auspices': {'anticipation': 0.586}, 'delightful': {'anticipation': 0.586, 'joy': 0.818, 'trust': 0.539}, 'overdue': {'anticipation': 0.586, 'sadness': 0.281, 'surprise': 0.156}, 'raffle': {'anticipation': 0.586, 'surprise': 0.45299999999999996}, 'flirt': {'anticipation': 0.586, 'joy': 0.594, 'surprise': 0.312, 'trust': 0.281}, 'enthusiast': {'anticipation': 0.586, 'joy': 0.47100000000000003, 'surprise': 0.445}, 'sequel': {'anticipation': 0.586}, 'crave': {'anticipation': 0.586}, 'seek': {'anticipation': 0.586}, 'immerse': {'anticipation': 0.586, 'fear': 0.266, 'joy': 0.258, 'surprise': 0.266, 'trust': 0.469}, 'fiesta': {'anticipation': 0.586, 'joy': 0.773, 'surprise': 0.43, 'trust': 0.281}, 'enjoying': {'anticipation': 0.586, 'joy': 0.7709999999999999, 'trust': 0.586}, 'experiment': {'anticipation': 0.58, 'surprise': 0.414}, 'completing': {'anticipation': 0.578, 'joy': 0.406}, 'divination': {'anticipation': 0.578}, 'thirst': {'anticipation': 0.578, 'sadness': 0.21899999999999997, 'surprise': 0.172}, 'angling': {'anticipation': 0.578}, 'precarious': {'anticipation': 0.578, 'fear': 0.547, 'sadness': 0.406}, 'thriving': {'anticipation': 0.578, 'joy': 0.7190000000000001}, 'transcendence': {'anticipation': 0.578, 'joy': 0.484, 'surprise': 0.508, 'trust': 0.602}, 'harvest': {'anticipation': 0.578, 'joy': 0.297}, 'heavenly': {'anticipation': 0.578, 'joy': 0.853, 'trust': 0.57}, 'attainable': {'anticipation': 0.578}, 'remedy': {'anticipation': 0.578, 'joy': 0.22699999999999998, 'trust': 0.516}, 'majestic': {'anticipation': 0.578, 'joy': 0.682, 'surprise': 0.523, 'trust': 0.625}, 'blessing': {'anticipation': 0.578, 'joy': 0.8440000000000001, 'trust': 0.625}, 'excavation': {'anticipation': 0.578, 'surprise': 0.36700000000000005}, 'enjoy': {'anticipation': 0.578, 'joy': 0.812, 'trust': 0.484}, 'prosper': {'anticipation': 0.578, 'joy': 0.562}, 'inviting': {'anticipation': 0.578, 'joy': 0.5, 'surprise': 0.289, 'trust': 0.578}, 'risk': {'anticipation': 0.578, 'fear': 0.562}, 'healing': {'anticipation': 0.578, 'joy': 0.32799999999999996, 'sadness': 0.23399999999999999, 'trust': 0.672}, 'warned': {'anticipation': 0.57, 'fear': 0.359, 'surprise': 0.336}, 'gambler': {'anticipation': 0.57, 'surprise': 0.406}, 'matchmaker': {'anticipation': 0.57}, 'ultimate': {'anticipation': 0.57, 'sadness': 0.109}, 'magnificence': {'anticipation': 0.57, 'joy': 0.797, 'trust': 0.609}, 'finally': {'anticipation': 0.57, 'disgust': 0.125, 'joy': 0.157, 'surprise': 0.297, 'trust': 0.45299999999999996}, 'omen': {'anticipation': 0.57, 'fear': 0.594}, 'sweetheart': {'anticipation': 0.57, 'joy': 0.758, 'sadness': 0.0, 'trust': 0.589}, 'prospectively': {'anticipation': 0.57}, 'restlessness': {'anticipation': 0.57}, 'invite': {'anticipation': 0.57, 'joy': 0.457, 'surprise': 0.266, 'trust': 0.43}, 'plan': {'anticipation': 0.57}, 'dare': {'anticipation': 0.57, 'trust': 0.258}, 'emancipation': {'anticipation': 0.57, 'joy': 0.397}, 'intimate': {'anticipation': 0.57, 'joy': 0.71, 'trust': 0.634}, 'zest': {'anticipation': 0.57, 'joy': 0.516, 'trust': 0.289}, 'festival': {'anticipation': 0.562, 'joy': 0.625, 'surprise': 0.266}, 'immortality': {'anticipation': 0.562}, 'hypothesis': {'anticipation': 0.562, 'surprise': 0.258}, 'predilection': {'anticipation': 0.562}, 'parade': {'anticipation': 0.562, 'fear': 0.062, 'joy': 0.621, 'surprise': 0.406}, 'trophy': {'anticipation': 0.562, 'joy': 0.484, 'surprise': 0.23399999999999999, 'trust': 0.406}, 'expected': {'anticipation': 0.562}, 'champion': {'anticipation': 0.562, 'joy': 0.6409999999999999, 'trust': 0.6409999999999999}, 'exalt': {'anticipation': 0.562, 'joy': 0.636, 'trust': 0.555}, 'independence': {'anticipation': 0.562, 'joy': 0.607, 'surprise': 0.242, 'trust': 0.547}, 'accolade': {'anticipation': 0.562, 'joy': 0.586, 'surprise': 0.281, 'trust': 0.508}, 'fun': {'anticipation': 0.562, 'joy': 0.7879999999999999}, 'forewarned': {'anticipation': 0.562, 'fear': 0.25}, 'fanfare': {'anticipation': 0.562, 'joy': 0.594, 'surprise': 0.484}, 'rejoice': {'anticipation': 0.562, 'joy': 0.812, 'surprise': 0.523, 'trust': 0.547}, 'mysterious': {'anticipation': 0.562, 'fear': 0.435, 'surprise': 0.586}, 'quicken': {'anticipation': 0.562}, 'enchant': {'anticipation': 0.562, 'joy': 0.7340000000000001, 'surprise': 0.42200000000000004}, 'lover': {'anticipation': 0.562, 'joy': 0.7190000000000001, 'trust': 0.47700000000000004}, 'attempt': {'anticipation': 0.562}, 'expose': {'anticipation': 0.562, 'fear': 0.375}, 'curiosity': {'anticipation': 0.555, 'surprise': 0.484}, 'uneasiness': {'anticipation': 0.555, 'sadness': 0.469}, 'speculative': {'anticipation': 0.555}, 'splendor': {'anticipation': 0.555, 'joy': 0.7879999999999999, 'surprise': 0.43799999999999994}, 'shopping': {'anticipation': 0.555, 'joy': 0.382, 'surprise': 0.21899999999999997, 'trust': 0.297}, 'salvation': {'anticipation': 0.555, 'joy': 0.41200000000000003, 'trust': 0.547}, 'happy': {'anticipation': 0.555, 'joy': 0.7879999999999999, 'trust': 0.609}, 'rejoicing': {'anticipation': 0.555, 'joy': 0.818, 'surprise': 0.578}, 'oracle': {'anticipation': 0.555, 'trust': 0.43799999999999994}, 'heroism': {'anticipation': 0.555, 'joy': 0.5760000000000001, 'surprise': 0.547, 'trust': 0.648}, 'fate': {'anticipation': 0.555, 'trust': 0.43799999999999994}, 'lovely': {'anticipation': 0.555, 'joy': 0.7190000000000001, 'sadness': 0.009000000000000001, 'surprise': 0.18, 'trust': 0.586}, 'amour': {'anticipation': 0.555, 'joy': 0.607, 'trust': 0.508}, 'grasping': {'anticipation': 0.555}, 'liberty': {'anticipation': 0.555, 'joy': 0.486, 'surprise': 0.312, 'trust': 0.547}, 'unfold': {'anticipation': 0.555}, 'grow': {'anticipation': 0.555, 'joy': 0.242, 'trust': 0.49200000000000005}, 'convergence': {'anticipation': 0.547}, 'warn': {'anticipation': 0.547, 'fear': 0.45299999999999996, 'surprise': 0.297, 'trust': 0.305}, 'morrow': {'anticipation': 0.547}, 'sorcery': {'anticipation': 0.547, 'fear': 0.516, 'surprise': 0.625}, 'bountiful': {'anticipation': 0.547, 'joy': 0.667}, 'recreational': {'anticipation': 0.547, 'joy': 0.318}, 'changeable': {'anticipation': 0.547, 'surprise': 0.43799999999999994}, 'apprehensive': {'anticipation': 0.547, 'fear': 0.578}, 'leisure': {'anticipation': 0.547, 'joy': 0.515, 'surprise': 0.086, 'trust': 0.406}, 'delighted': {'anticipation': 0.547, 'joy': 0.8909999999999999, 'surprise': 0.43}, 'glory': {'anticipation': 0.547, 'joy': 0.8590000000000001, 'trust': 0.47700000000000004}, 'probability': {'anticipation': 0.547}, 'glimmer': {'anticipation': 0.547, 'joy': 0.53, 'surprise': 0.266}, 'abundance': {'anticipation': 0.547, 'disgust': 0.078, 'joy': 0.652, 'trust': 0.57}, 'pray': {'anticipation': 0.547, 'fear': 0.109, 'joy': 0.469, 'surprise': 0.18, 'trust': 0.516}, 'agape': {'anticipation': 0.547, 'surprise': 0.633}, 'resultant': {'anticipation': 0.547}, 'hungry': {'anticipation': 0.547}, 'monetary': {'anticipation': 0.547}, 'sensual': {'anticipation': 0.539, 'joy': 0.5760000000000001, 'surprise': 0.36700000000000005, 'trust': 0.445}, 'bounty': {'anticipation': 0.539, 'joy': 0.485, 'trust': 0.38299999999999995}, 'contingent': {'anticipation': 0.539}, 'blessings': {'anticipation': 0.539, 'joy': 0.75, 'surprise': 0.35200000000000004, 'trust': 0.609}, 'entertainment': {'anticipation': 0.539, 'joy': 0.603, 'surprise': 0.359, 'trust': 0.344}, 'merge': {'anticipation': 0.539}, 'ballot': {'anticipation': 0.539, 'trust': 0.531}, 'grandchildren': {'anticipation': 0.539, 'joy': 0.54, 'trust': 0.49200000000000005}, 'auction': {'anticipation': 0.539}, 'worrying': {'anticipation': 0.539, 'fear': 0.484, 'sadness': 0.562}, 'inquiry': {'anticipation': 0.539}, 'vindication': {'anticipation': 0.539, 'joy': 0.45299999999999996, 'trust': 0.5}, 'exceed': {'anticipation': 0.539, 'joy': 0.348}, 'hankering': {'anticipation': 0.539}, 'glad': {'anticipation': 0.536, 'joy': 0.7809999999999999}, 'spirits': {'anticipation': 0.531, 'joy': 0.375, 'surprise': 0.414}, 'dread': {'anticipation': 0.531, 'fear': 0.8590000000000001}, 'forming': {'anticipation': 0.531}, 'hurried': {'anticipation': 0.531}, 'magnificent': {'anticipation': 0.531, 'joy': 0.8590000000000001, 'surprise': 0.508, 'trust': 0.586}, 'feat': {'anticipation': 0.531, 'joy': 0.297, 'surprise': 0.445}, 'stealthy': {'anticipation': 0.531, 'fear': 0.25, 'surprise': 0.43}, 'virginity': {'anticipation': 0.531}, 'celestial': {'anticipation': 0.531, 'joy': 0.547}, 'cheer': {'anticipation': 0.531, 'joy': 0.897, 'surprise': 0.539, 'trust': 0.547}, 'betrothed': {'anticipation': 0.531, 'joy': 0.485, 'trust': 0.555}, 'deliverance': {'anticipation': 0.531, 'joy': 0.348, 'trust': 0.531}, 'overthrow': {'anticipation': 0.531, 'fear': 0.547}, 'visitor': {'anticipation': 0.531, 'joy': 0.25}, 'appeal': {'anticipation': 0.531}, 'responsive': {'anticipation': 0.531, 'trust': 0.539}, 'prevail': {'anticipation': 0.523, 'joy': 0.562}, 'cheery': {'anticipation': 0.523, 'joy': 0.727}, 'competition': {'anticipation': 0.523, 'fear': 0.172}, 'beaming': {'anticipation': 0.523, 'joy': 0.938}, 'ultimately': {'anticipation': 0.523}, 'child': {'anticipation': 0.523, 'joy': 0.466}, 'revive': {'anticipation': 0.523}, 'pleasant': {'anticipation': 0.523, 'joy': 0.6559999999999999, 'surprise': 0.242, 'trust': 0.562}, 'notification': {'anticipation': 0.523}, 'preparatory': {'anticipation': 0.523}, 'planning': {'anticipation': 0.523, 'trust': 0.617}, 'germination': {'anticipation': 0.523}, 'wait': {'anticipation': 0.523}, 'watch': {'anticipation': 0.523, 'fear': 0.188}, 'importance': {'anticipation': 0.523}, 'prognostic': {'anticipation': 0.523}, 'hunter': {'anticipation': 0.523, 'fear': 0.562, 'sadness': 0.359}, 'radiance': {'anticipation': 0.523, 'joy': 0.725, 'trust': 0.49200000000000005}, 'haste': {'anticipation': 0.523}, 'prophet': {'anticipation': 0.523, 'trust': 0.555}, 'salary': {'anticipation': 0.516, 'joy': 0.23399999999999999, 'trust': 0.414}, 'loom': {'anticipation': 0.516, 'fear': 0.32799999999999996}, 'time': {'anticipation': 0.516}, 'chocolate': {'anticipation': 0.516, 'joy': 0.484, 'trust': 0.445}, 'begun': {'anticipation': 0.516}, 'sensuality': {'anticipation': 0.516, 'joy': 0.6409999999999999}, 'precious': {'anticipation': 0.516, 'joy': 0.682, 'surprise': 0.195}, 'fermentation': {'anticipation': 0.516}, 'compensate': {'anticipation': 0.516, 'joy': 0.273, 'surprise': 0.266, 'trust': 0.562}, 'renovation': {'anticipation': 0.516, 'joy': 0.33299999999999996}, 'present': {'anticipation': 0.516, 'joy': 0.441, 'surprise': 0.32, 'trust': 0.45299999999999996}, 'recreation': {'anticipation': 0.516, 'joy': 0.545}, 'endanger': {'anticipation': 0.516, 'fear': 0.688}, 'infant': {'anticipation': 0.508, 'fear': 0.067, 'joy': 0.309, 'surprise': 0.141}, 'commemoration': {'anticipation': 0.508, 'joy': 0.479}, 'exigent': {'anticipation': 0.508, 'disgust': 0.336, 'fear': 0.391, 'surprise': 0.49200000000000005}, 'practise': {'anticipation': 0.508}, 'transitional': {'anticipation': 0.508}, 'vigilance': {'anticipation': 0.508, 'trust': 0.594}, 'elevation': {'anticipation': 0.508, 'fear': 0.266, 'joy': 0.455, 'trust': 0.523}, 'signify': {'anticipation': 0.508}, 'perfection': {'anticipation': 0.508, 'joy': 0.779, 'surprise': 0.305, 'trust': 0.688}, 'cultivate': {'anticipation': 0.508, 'trust': 0.555}, 'intermission': {'anticipation': 0.508}, 'contemplation': {'anticipation': 0.508}, 'horizon': {'anticipation': 0.508}, 'prerequisite': {'anticipation': 0.508}, 'wilderness': {'anticipation': 0.508, 'fear': 0.42200000000000004, 'joy': 0.121, 'sadness': 0.255}, 'cue': {'anticipation': 0.508}, 'develop': {'anticipation': 0.508}, 'income': {'anticipation': 0.5, 'joy': 0.40299999999999997, 'sadness': 0.1, 'trust': 0.484}, 'blindfold': {'anticipation': 0.5, 'fear': 0.266, 'surprise': 0.609}, 'reconciliation': {'anticipation': 0.5, 'joy': 0.316, 'trust': 0.555}, 'puppy': {'anticipation': 0.5, 'trust': 0.45299999999999996}, 'intuitively': {'anticipation': 0.5}, 'airport': {'anticipation': 0.5}, 'sunny': {'anticipation': 0.5, 'joy': 0.562, 'surprise': 0.102}, 'uphill': {'anticipation': 0.5, 'fear': 0.203}, 'calculation': {'anticipation': 0.5}, 'young': {'anticipation': 0.5, 'joy': 0.33299999999999996, 'surprise': 0.16399999999999998}, 'romantic': {'anticipation': 0.5, 'joy': 0.75, 'trust': 0.5}, 'eventuality': {'anticipation': 0.5, 'fear': 0.141}, 'depart': {'anticipation': 0.5, 'sadness': 0.23399999999999999}, 'utopian': {'anticipation': 0.5, 'joy': 0.7190000000000001, 'trust': 0.43}, 'zeal': {'anticipation': 0.5, 'joy': 0.547, 'surprise': 0.484, 'trust': 0.32799999999999996}, 'undisclosed': {'anticipation': 0.5}, 'swim': {'anticipation': 0.5, 'fear': 0.125, 'joy': 0.273}, 'favorable': {'anticipation': 0.5, 'joy': 0.561, 'surprise': 0.297, 'trust': 0.6559999999999999}, 'sneaking': {'anticipation': 0.5, 'fear': 0.375, 'trust': 0.21100000000000002}, 'peril': {'anticipation': 0.5, 'fear': 0.8590000000000001, 'sadness': 0.6559999999999999}, 'ardent': {'anticipation': 0.5, 'joy': 0.25}, 'horoscope': {'anticipation': 0.5}, 'invocation': {'anticipation': 0.5, 'trust': 0.547}, 'hero': {'anticipation': 0.5, 'joy': 0.562, 'surprise': 0.344, 'trust': 0.773}, 'ready': {'anticipation': 0.5}, 'commemorate': {'anticipation': 0.5, 'joy': 0.45299999999999996, 'sadness': 0.125}, 'nascent': {'anticipation': 0.5}, 'attendance': {'anticipation': 0.5}, 'inauguration': {'anticipation': 0.49200000000000005, 'joy': 0.409, 'trust': 0.43799999999999994}, 'restorative': {'anticipation': 0.49200000000000005, 'joy': 0.318, 'trust': 0.555}, 'improvise': {'anticipation': 0.49200000000000005, 'surprise': 0.523}, 'perspective': {'anticipation': 0.49200000000000005, 'joy': 0.221}, 'bless': {'anticipation': 0.49200000000000005, 'joy': 0.561, 'trust': 0.633}, 'worry': {'anticipation': 0.49200000000000005, 'fear': 0.578, 'sadness': 0.6409999999999999}, 'parole': {'anticipation': 0.49200000000000005}, 'consequent': {'anticipation': 0.49200000000000005}, 'gaping': {'anticipation': 0.49200000000000005}, 'eventual': {'anticipation': 0.49200000000000005}, 'undertaking': {'anticipation': 0.49200000000000005}, 'heyday': {'anticipation': 0.49200000000000005, 'joy': 0.484, 'trust': 0.32}, 'proceeding': {'anticipation': 0.49200000000000005}, 'highest': {'anticipation': 0.491, 'fear': 0.23600000000000002, 'joy': 0.591, 'surprise': 0.344}, 'contagion': {'anticipation': 0.484, 'disgust': 0.7190000000000001, 'fear': 0.688}, 'auspicious': {'anticipation': 0.484, 'joy': 0.391}, 'letter': {'anticipation': 0.484}, 'vow': {'anticipation': 0.484, 'joy': 0.382, 'trust': 0.7809999999999999}, 'correspondence': {'anticipation': 0.484}, 'shortly': {'anticipation': 0.484}, 'happen': {'anticipation': 0.484}, 'god': {'anticipation': 0.484, 'fear': 0.094, 'joy': 0.545, 'trust': 0.617}, 'engulf': {'anticipation': 0.484}, 'conjure': {'anticipation': 0.484, 'surprise': 0.555}, 'sparkle': {'anticipation': 0.484, 'joy': 0.5770000000000001, 'surprise': 0.36700000000000005}, 'generosity': {'anticipation': 0.484, 'joy': 0.625, 'surprise': 0.305, 'trust': 0.594}, 'voluptuous': {'anticipation': 0.484, 'joy': 0.344}, 'unexplained': {'anticipation': 0.484, 'sadness': 0.25}, 'princely': {'anticipation': 0.484, 'joy': 0.515, 'surprise': 0.39799999999999996, 'trust': 0.531}, 'arbitration': {'anticipation': 0.47700000000000004}, 'clue': {'anticipation': 0.47700000000000004}, 'recipient': {'anticipation': 0.47700000000000004}, 'gravitate': {'anticipation': 0.47700000000000004}, 'medal': {'anticipation': 0.47700000000000004, 'joy': 0.424, 'surprise': 0.289, 'trust': 0.461}, 'perilous': {'anticipation': 0.47700000000000004, 'fear': 0.6409999999999999, 'sadness': 0.6409999999999999}, 'accompaniment': {'anticipation': 0.47700000000000004, 'joy': 0.179, 'trust': 0.531}, 'glow': {'anticipation': 0.47700000000000004, 'joy': 0.6559999999999999, 'trust': 0.39799999999999996}, 'glorify': {'anticipation': 0.47700000000000004, 'joy': 0.7809999999999999, 'surprise': 0.344, 'trust': 0.406}, 'submit': {'anticipation': 0.47700000000000004}, 'determinate': {'anticipation': 0.47700000000000004, 'trust': 0.57}, 'unification': {'anticipation': 0.47700000000000004, 'joy': 0.348, 'trust': 0.7340000000000001}, 'glide': {'anticipation': 0.47700000000000004, 'joy': 0.162}, 'enroll': {'anticipation': 0.47700000000000004, 'trust': 0.461}, 'onset': {'anticipation': 0.47700000000000004}, 'adore': {'anticipation': 0.47700000000000004, 'joy': 0.667, 'trust': 0.578}, 'contemplate': {'anticipation': 0.47700000000000004}, 'cherish': {'anticipation': 0.47700000000000004, 'joy': 0.703, 'surprise': 0.21899999999999997, 'trust': 0.617}, 'predispose': {'anticipation': 0.47700000000000004}, 'score': {'anticipation': 0.47700000000000004, 'joy': 0.182, 'surprise': 0.38299999999999995}, 'praiseworthy': {'anticipation': 0.473, 'joy': 0.609, 'surprise': 0.38299999999999995, 'trust': 0.609}, 'sweets': {'anticipation': 0.469, 'joy': 0.562}, 'fete': {'anticipation': 0.469, 'joy': 0.484, 'surprise': 0.406}, 'star': {'anticipation': 0.469, 'joy': 0.406, 'trust': 0.391}, 'motion': {'anticipation': 0.469}, 'dawn': {'anticipation': 0.469, 'joy': 0.33299999999999996, 'surprise': 0.21100000000000002, 'trust': 0.45299999999999996}, 'creeping': {'anticipation': 0.469}, 'precursor': {'anticipation': 0.469}, 'immediately': {'anticipation': 0.469}, 'cautious': {'anticipation': 0.469, 'fear': 0.281, 'trust': 0.461}, 'production': {'anticipation': 0.469}, 'unknown': {'anticipation': 0.469, 'fear': 0.369}, 'completion': {'anticipation': 0.469, 'joy': 0.547}, 'starry': {'anticipation': 0.469, 'joy': 0.391}, 'unsurpassed': {'anticipation': 0.469, 'fear': 0.297, 'joy': 0.424, 'trust': 0.508}, 'successful': {'anticipation': 0.469, 'joy': 0.606, 'trust': 0.648}, 'football': {'anticipation': 0.469, 'joy': 0.25}, 'invoke': {'anticipation': 0.469}, 'elite': {'anticipation': 0.469, 'joy': 0.547, 'trust': 0.43799999999999994}, 'hire': {'anticipation': 0.469, 'joy': 0.203, 'trust': 0.484}, 'providing': {'anticipation': 0.469, 'joy': 0.3, 'trust': 0.555}, 'excel': {'anticipation': 0.461, 'joy': 0.5, 'surprise': 0.445, 'trust': 0.609}, 'sanctuary': {'anticipation': 0.461, 'joy': 0.541, 'trust': 0.703}, 'jeopardy': {'anticipation': 0.461, 'fear': 0.578}, 'shining': {'anticipation': 0.461, 'joy': 0.515}, 'regatta': {'anticipation': 0.461}, 'soundness': {'anticipation': 0.461, 'joy': 0.42100000000000004, 'trust': 0.633}, 'mail': {'anticipation': 0.461}, 'overture': {'anticipation': 0.461}, 'synchronize': {'anticipation': 0.461, 'joy': 0.32899999999999996, 'surprise': 0.195, 'trust': 0.5}, 'pay': {'anticipation': 0.461, 'joy': 0.242, 'trust': 0.43}, 'cheerfulness': {'anticipation': 0.461, 'joy': 0.758, 'trust': 0.578}, 'friendly': {'anticipation': 0.461, 'joy': 0.578, 'trust': 0.547}, 'brilliant': {'anticipation': 0.461, 'joy': 0.8590000000000001, 'trust': 0.609}, 'untold': {'anticipation': 0.461}, 'testament': {'anticipation': 0.461, 'trust': 0.617}, 'preliminary': {'anticipation': 0.461}, 'extricate': {'anticipation': 0.461}, 'punt': {'anticipation': 0.461}, 'plight': {'anticipation': 0.461, 'disgust': 0.375, 'fear': 0.516, 'sadness': 0.621}, 'draft': {'anticipation': 0.461}, 'commemorative': {'anticipation': 0.461}, 'alive': {'anticipation': 0.461, 'joy': 0.531, 'trust': 0.5}, 'complement': {'anticipation': 0.45299999999999996, 'joy': 0.647, 'surprise': 0.258, 'trust': 0.57}, 'sunset': {'anticipation': 0.45299999999999996, 'joy': 0.312}, 'unexpected': {'anticipation': 0.45299999999999996, 'fear': 0.312, 'joy': 0.203, 'surprise': 0.711}, 'renovate': {'anticipation': 0.45299999999999996}, 'compliment': {'anticipation': 0.45299999999999996, 'joy': 0.831, 'surprise': 0.375, 'trust': 0.516}, 'rehabilitation': {'anticipation': 0.45299999999999996}, 'prologue': {'anticipation': 0.45299999999999996}, 'basketball': {'anticipation': 0.45299999999999996, 'joy': 0.062}, 'elegance': {'anticipation': 0.45299999999999996, 'joy': 0.609, 'trust': 0.49200000000000005}, 'infinity': {'anticipation': 0.45299999999999996, 'joy': 0.281, 'trust': 0.5}, 'flinch': {'anticipation': 0.45299999999999996, 'disgust': 0.35200000000000004, 'fear': 0.484, 'sadness': 0.281, 'surprise': 0.742}, 'improve': {'anticipation': 0.45299999999999996, 'joy': 0.364, 'trust': 0.49200000000000005}, 'career': {'anticipation': 0.45299999999999996}, 'prevention': {'anticipation': 0.45299999999999996}, 'perpetuity': {'anticipation': 0.45299999999999996, 'trust': 0.516}, 'intimately': {'anticipation': 0.45299999999999996, 'fear': 0.156, 'joy': 0.507}, 'inaugural': {'anticipation': 0.45299999999999996}, 'perfect': {'anticipation': 0.445, 'joy': 0.7190000000000001, 'trust': 0.539}, 'conjecture': {'anticipation': 0.445}, 'confidence': {'anticipation': 0.445, 'fear': 0.109, 'joy': 0.547, 'trust': 0.6409999999999999}, 'volunteer': {'anticipation': 0.445, 'fear': 0.031, 'joy': 0.294, 'trust': 0.509}, 'veracity': {'anticipation': 0.445, 'joy': 0.5, 'surprise': 0.414, 'trust': 0.47700000000000004}, 'sun': {'anticipation': 0.445, 'joy': 0.266, 'surprise': 0.172, 'trust': 0.43799999999999994}, 'fain': {'anticipation': 0.445, 'joy': 0.16699999999999998, 'trust': 0.39799999999999996}, 'surround': {'anticipation': 0.445}, 'share': {'anticipation': 0.445, 'joy': 0.43799999999999994, 'trust': 0.586}, 'sweet': {'anticipation': 0.445, 'joy': 0.625, 'surprise': 0.203, 'trust': 0.484}, 'fitting': {'anticipation': 0.445, 'joy': 0.258, 'trust': 0.406}, 'saint': {'anticipation': 0.43799999999999994, 'joy': 0.32799999999999996, 'surprise': 0.312, 'trust': 0.648}, 'conservation': {'anticipation': 0.43799999999999994, 'trust': 0.586}, 'faith': {'anticipation': 0.43799999999999994, 'joy': 0.45299999999999996, 'trust': 0.742}, 'prepared': {'anticipation': 0.43799999999999994, 'trust': 0.703}, 'passenger': {'anticipation': 0.43799999999999994}, 'ferment': {'anticipation': 0.43799999999999994}, 'respect': {'anticipation': 0.43799999999999994, 'joy': 0.5, 'trust': 0.75}, 'recombination': {'anticipation': 0.43799999999999994}, 'reconstruction': {'anticipation': 0.43799999999999994}, 'tickle': {'anticipation': 0.43799999999999994, 'joy': 0.47, 'surprise': 0.516, 'trust': 0.297}, 'medical': {'anticipation': 0.43799999999999994, 'fear': 0.297, 'trust': 0.508}, 'serial': {'anticipation': 0.43799999999999994}, 'goodness': {'anticipation': 0.43799999999999994, 'joy': 0.818, 'surprise': 0.16399999999999998, 'trust': 0.68}, 'plea': {'anticipation': 0.43799999999999994, 'fear': 0.377, 'sadness': 0.344}, 'superstitious': {'anticipation': 0.43799999999999994, 'fear': 0.531}, 'aloha': {'anticipation': 0.43799999999999994, 'joy': 0.484}, 'angel': {'anticipation': 0.43799999999999994, 'joy': 0.594, 'surprise': 0.32, 'trust': 0.625}, 'reconstruct': {'anticipation': 0.43799999999999994}, 'devout': {'anticipation': 0.43799999999999994, 'joy': 0.273, 'trust': 0.562}, 'peace': {'anticipation': 0.43, 'joy': 0.5760000000000001, 'trust': 0.602}, 'tabulate': {'anticipation': 0.43}, 'install': {'anticipation': 0.43}, 'serenity': {'anticipation': 0.43, 'joy': 0.6559999999999999, 'trust': 0.602}, 'strategist': {'anticipation': 0.43, 'trust': 0.45299999999999996}, 'clap': {'anticipation': 0.43, 'joy': 0.25, 'trust': 0.344}, 'venerable': {'anticipation': 0.43, 'joy': 0.27899999999999997, 'trust': 0.508}, 'perpetuate': {'anticipation': 0.43}, 'luscious': {'anticipation': 0.43, 'joy': 0.682}, 'unverified': {'anticipation': 0.43}, 'spa': {'anticipation': 0.43, 'joy': 0.33299999999999996, 'surprise': 0.086, 'trust': 0.312}, 'tribunal': {'anticipation': 0.43, 'disgust': 0.273, 'fear': 0.43799999999999994, 'trust': 0.516}, 'labyrinth': {'anticipation': 0.43}, 'charitable': {'anticipation': 0.43, 'joy': 0.5, 'trust': 0.711}, 'worship': {'anticipation': 0.42200000000000004, 'fear': 0.172, 'joy': 0.379, 'trust': 0.555}, 'candid': {'anticipation': 0.42200000000000004, 'joy': 0.281, 'surprise': 0.281, 'trust': 0.531}, 'recognizable': {'anticipation': 0.42200000000000004}, 'unresolved': {'anticipation': 0.42200000000000004}, 'forestall': {'anticipation': 0.42200000000000004}, 'patience': {'anticipation': 0.42200000000000004, 'trust': 0.555}, 'edification': {'anticipation': 0.42200000000000004, 'joy': 0.33299999999999996, 'trust': 0.531}, 'grin': {'anticipation': 0.42200000000000004, 'joy': 0.672, 'surprise': 0.336, 'trust': 0.391}, 'oasis': {'anticipation': 0.42200000000000004, 'joy': 0.486, 'trust': 0.45299999999999996}, 'vista': {'anticipation': 0.42200000000000004}, 'adrift': {'anticipation': 0.42200000000000004, 'fear': 0.32799999999999996, 'sadness': 0.32799999999999996}, 'revere': {'anticipation': 0.42200000000000004, 'joy': 0.594, 'trust': 0.586}, 'peaceful': {'anticipation': 0.42200000000000004, 'joy': 0.636, 'surprise': 0.086, 'trust': 0.648}, 'laughter': {'anticipation': 0.42200000000000004, 'joy': 0.8240000000000001, 'surprise': 0.445}, 'weigh': {'anticipation': 0.414, 'trust': 0.344}, 'pretty': {'anticipation': 0.414, 'joy': 0.469, 'trust': 0.36700000000000005}, 'withstand': {'anticipation': 0.414, 'fear': 0.19699999999999998}, 'ordination': {'anticipation': 0.414, 'joy': 0.23399999999999999, 'trust': 0.562}, 'grant': {'anticipation': 0.414, 'joy': 0.366, 'trust': 0.594}, 'frisky': {'anticipation': 0.414, 'joy': 0.42200000000000004, 'surprise': 0.375}, 'punctual': {'anticipation': 0.414, 'trust': 0.57}, 'astrologer': {'anticipation': 0.414}, 'morn': {'anticipation': 0.414}, 'probation': {'anticipation': 0.414, 'fear': 0.43799999999999994, 'sadness': 0.336}, 'calls': {'anticipation': 0.414, 'trust': 0.359}, 'mediate': {'anticipation': 0.414, 'trust': 0.555}, 'proficiency': {'anticipation': 0.414, 'joy': 0.359, 'surprise': 0.344, 'trust': 0.6559999999999999}, 'craps': {'anticipation': 0.414}, 'ongoing': {'anticipation': 0.414}, 'thought': {'anticipation': 0.414}, 'continue': {'anticipation': 0.414, 'trust': 0.42200000000000004}, 'sing': {'anticipation': 0.41100000000000003, 'joy': 0.7290000000000001, 'sadness': 0.017, 'trust': 0.42200000000000004}, 'outdo': {'anticipation': 0.406}, 'mother': {'anticipation': 0.406, 'joy': 0.41200000000000003, 'sadness': 0.016, 'trust': 0.703}, 'subscribe': {'anticipation': 0.406}, 'proud': {'anticipation': 0.406, 'joy': 0.7040000000000001, 'trust': 0.547}, 'comfort': {'anticipation': 0.406, 'joy': 0.515, 'trust': 0.609}, 'debenture': {'anticipation': 0.406}, 'long': {'anticipation': 0.406}, 'banquet': {'anticipation': 0.406, 'joy': 0.303}, 'twinkle': {'anticipation': 0.406, 'joy': 0.636}, 'wizard': {'anticipation': 0.406, 'surprise': 0.469}, 'midwife': {'anticipation': 0.406, 'joy': 0.28800000000000003, 'trust': 0.555}, 'navigable': {'anticipation': 0.406}, 'confession': {'anticipation': 0.406, 'fear': 0.266, 'sadness': 0.281, 'surprise': 0.45299999999999996, 'trust': 0.516}, 'continuation': {'anticipation': 0.406}, 'headlight': {'anticipation': 0.406}, 'prophylactic': {'anticipation': 0.406, 'trust': 0.312}, 'chicane': {'anticipation': 0.406, 'surprise': 0.47700000000000004, 'trust': 0.289}, 'university': {'anticipation': 0.406}, 'deal': {'anticipation': 0.402, 'joy': 0.312, 'surprise': 0.22699999999999998, 'trust': 0.391}, 'efficient': {'anticipation': 0.39799999999999996, 'trust': 0.594}, 'lettered': {'anticipation': 0.39799999999999996, 'trust': 0.359}, 'reliance': {'anticipation': 0.39799999999999996, 'trust': 0.664}, 'balm': {'anticipation': 0.39799999999999996, 'joy': 0.152}, 'mortification': {'anticipation': 0.39799999999999996, 'disgust': 0.711, 'fear': 0.7190000000000001, 'sadness': 0.802}, 'saintly': {'anticipation': 0.39799999999999996, 'joy': 0.6409999999999999, 'surprise': 0.305, 'trust': 0.633}, 'symphony': {'anticipation': 0.39799999999999996, 'joy': 0.42200000000000004}, 'top': {'anticipation': 0.39799999999999996, 'trust': 0.469}, 'vigil': {'anticipation': 0.39799999999999996}, 'representing': {'anticipation': 0.39799999999999996}, 'judiciary': {'anticipation': 0.39799999999999996, 'trust': 0.6409999999999999}, 'assurance': {'anticipation': 0.391, 'trust': 0.703}, 'antidote': {'anticipation': 0.391, 'trust': 0.539}, 'undoubted': {'anticipation': 0.391, 'disgust': 0.16399999999999998}, 'objective': {'anticipation': 0.391, 'trust': 0.617}, 'maternal': {'anticipation': 0.391}, 'abeyance': {'anticipation': 0.391}, 'art': {'anticipation': 0.391, 'joy': 0.23399999999999999, 'sadness': 0.0, 'surprise': 0.172}, 'familiarity': {'anticipation': 0.391, 'joy': 0.33299999999999996, 'trust': 0.68}, 'chuckle': {'anticipation': 0.391, 'joy': 0.706, 'surprise': 0.258, 'trust': 0.21899999999999997}, 'sanctify': {'anticipation': 0.391, 'joy': 0.359, 'sadness': 0.10800000000000001, 'surprise': 0.336, 'trust': 0.672}, 'diplomacy': {'anticipation': 0.391, 'trust': 0.586}, 'linger': {'anticipation': 0.391}, 'poke': {'anticipation': 0.391}, 'trust': {'anticipation': 0.391, 'trust': 0.805}, 'inoculation': {'anticipation': 0.384, 'trust': 0.539}, 'labor': {'anticipation': 0.38299999999999995, 'joy': 0.106, 'surprise': 0.281, 'trust': 0.414}, 'dutiful': {'anticipation': 0.38299999999999995, 'trust': 0.578}, 'humanitarian': {'anticipation': 0.38299999999999995, 'joy': 0.469, 'surprise': 0.195, 'trust': 0.695}, 'ship': {'anticipation': 0.38299999999999995}, 'depend': {'anticipation': 0.38299999999999995, 'trust': 0.594}, 'good': {'anticipation': 0.38299999999999995, 'joy': 0.547, 'surprise': 0.21899999999999997, 'trust': 0.617}, 'scientist': {'anticipation': 0.38299999999999995, 'trust': 0.695}, 'undecided': {'anticipation': 0.38299999999999995, 'fear': 0.098}, 'simplify': {'anticipation': 0.38299999999999995, 'joy': 0.312, 'surprise': 0.21100000000000002, 'trust': 0.43}, 'hap': {'anticipation': 0.38299999999999995, 'surprise': 0.32}, 'hymn': {'anticipation': 0.38299999999999995, 'joy': 0.375, 'sadness': 0.064, 'trust': 0.42200000000000004}, 'playground': {'anticipation': 0.38299999999999995, 'joy': 0.391, 'surprise': 0.133, 'trust': 0.344}, 'discretion': {'anticipation': 0.38299999999999995, 'trust': 0.555}, 'clock': {'anticipation': 0.375}, 'interim': {'anticipation': 0.375}, 'public': {'anticipation': 0.375}, 'savor': {'anticipation': 0.375, 'disgust': 0.11699999999999999, 'joy': 0.531, 'sadness': 0.034, 'trust': 0.508}, 'recurrent': {'anticipation': 0.375}, 'gradual': {'anticipation': 0.375}, 'mountain': {'anticipation': 0.375, 'joy': 0.25}, 'track': {'anticipation': 0.375}, 'cradle': {'anticipation': 0.375, 'joy': 0.247, 'trust': 0.531}, 'navigator': {'anticipation': 0.375, 'trust': 0.578}, 'sonar': {'anticipation': 0.36700000000000005}, 'instructions': {'anticipation': 0.36700000000000005, 'trust': 0.539}, 'lesson': {'anticipation': 0.36700000000000005, 'trust': 0.461}, 'abide': {'anticipation': 0.36700000000000005}, 'towering': {'anticipation': 0.36700000000000005, 'fear': 0.5}, 'concealed': {'anticipation': 0.36700000000000005, 'fear': 0.43799999999999994, 'surprise': 0.531}, 'whim': {'anticipation': 0.36700000000000005, 'joy': 0.266, 'surprise': 0.555}, 'convince': {'anticipation': 0.36700000000000005, 'trust': 0.586}, 'biennial': {'anticipation': 0.36700000000000005}, 'theory': {'anticipation': 0.359, 'trust': 0.32799999999999996}, 'offset': {'anticipation': 0.359}, 'atone': {'anticipation': 0.359, 'joy': 0.19699999999999998, 'trust': 0.43799999999999994}, 'theology': {'anticipation': 0.359}, 'undying': {'anticipation': 0.359, 'joy': 0.25, 'sadness': 0.25, 'trust': 0.5}, 'timidity': {'anticipation': 0.359, 'fear': 0.297}, 'plump': {'anticipation': 0.359}, 'audience': {'anticipation': 0.35700000000000004}, 'nobility': {'anticipation': 0.35200000000000004, 'trust': 0.523}, 'localize': {'anticipation': 0.35200000000000004}, 'paragon': {'anticipation': 0.35200000000000004, 'joy': 0.266, 'trust': 0.523}, 'edition': {'anticipation': 0.35200000000000004}, 'kindred': {'anticipation': 0.35200000000000004, 'joy': 0.455, 'trust': 0.7190000000000001}, 'dietary': {'anticipation': 0.35200000000000004}, 'closure': {'anticipation': 0.35200000000000004, 'joy': 0.172, 'sadness': 0.195}, 'daily': {'anticipation': 0.35200000000000004}, 'farm': {'anticipation': 0.35200000000000004}, 'store': {'anticipation': 0.35200000000000004}, 'cramp': {'anticipation': 0.35200000000000004}, 'consecration': {'anticipation': 0.35200000000000004, 'joy': 0.235, 'sadness': 0.359, 'trust': 0.461}, 'errand': {'anticipation': 0.344, 'trust': 0.43}, 'meditate': {'anticipation': 0.344, 'joy': 0.43799999999999994, 'trust': 0.555}, 'mutable': {'anticipation': 0.344}, 'mobile': {'anticipation': 0.344}, 'archaeology': {'anticipation': 0.344}, 'unaccountable': {'anticipation': 0.336, 'disgust': 0.305, 'sadness': 0.33899999999999997, 'trust': 0.172}, 'buddy': {'anticipation': 0.336, 'joy': 0.42700000000000005, 'trust': 0.555}, 'unbeaten': {'anticipation': 0.336, 'joy': 0.43799999999999994, 'sadness': 0.193, 'surprise': 0.336}, 'germ': {'anticipation': 0.336, 'disgust': 0.68}, 'brotherly': {'anticipation': 0.336, 'joy': 0.516, 'trust': 0.633}, 'lessen': {'anticipation': 0.336}, 'chastity': {'anticipation': 0.32799999999999996, 'trust': 0.539}, 'council': {'anticipation': 0.32799999999999996, 'trust': 0.594}, 'patient': {'anticipation': 0.32799999999999996, 'joy': 0.18600000000000003}, 'possess': {'anticipation': 0.32799999999999996, 'joy': 0.21899999999999997, 'trust': 0.38299999999999995}, 'digress': {'anticipation': 0.32799999999999996}, 'secular': {'anticipation': 0.32799999999999996}, 'dove': {'anticipation': 0.32799999999999996, 'joy': 0.312, 'trust': 0.469}, 'olfactory': {'anticipation': 0.32799999999999996}, 'immature': {'anticipation': 0.32}, 'fancy': {'anticipation': 0.32, 'joy': 0.516}, 'disposed': {'anticipation': 0.32, 'trust': 0.32}, 'heft': {'anticipation': 0.32, 'fear': 0.21899999999999997}, 'paddle': {'anticipation': 0.32}, 'cove': {'anticipation': 0.32, 'disgust': 0.11699999999999999, 'fear': 0.141, 'joy': 0.203}, 'regularity': {'anticipation': 0.32, 'trust': 0.539}, 'mediator': {'anticipation': 0.32, 'trust': 0.609}, 'preservative': {'anticipation': 0.32, 'joy': 0.242, 'surprise': 0.195, 'trust': 0.414}, 'scrutinize': {'anticipation': 0.32}, 'denying': {'anticipation': 0.312, 'trust': 0.281}, 'analyst': {'anticipation': 0.312, 'trust': 0.531}, 'unpublished': {'anticipation': 0.312, 'sadness': 0.11599999999999999}, 'church': {'anticipation': 0.312, 'joy': 0.242, 'trust': 0.49200000000000005}, 'bugle': {'anticipation': 0.312}, 'mill': {'anticipation': 0.305}, 'priesthood': {'anticipation': 0.305, 'joy': 0.121, 'sadness': 0.109, 'trust': 0.461}, 'broadside': {'anticipation': 0.305}, 'judicial': {'anticipation': 0.305, 'trust': 0.633}, 'saliva': {'anticipation': 0.297}, 'thermocouple': {'anticipation': 0.297}, 'cap': {'anticipation': 0.297, 'trust': 0.32}, 'instructor': {'anticipation': 0.297, 'trust': 0.469}, 'exhaustion': {'anticipation': 0.297, 'sadness': 0.375}, 'tributary': {'anticipation': 0.297}, 'cataract': {'anticipation': 0.289, 'fear': 0.25, 'sadness': 0.188}, 'wont': {'anticipation': 0.289}, 'bruise': {'anticipation': 0.289}, 'visor': {'anticipation': 0.289, 'surprise': 0.156}, 'addresses': {'anticipation': 0.289}, 'discreet': {'anticipation': 0.289}, 'network': {'anticipation': 0.289}, 'astronomer': {'anticipation': 0.281}, 'neighbor': {'anticipation': 0.281, 'trust': 0.523}, 'cream': {'anticipation': 0.273, 'joy': 0.061, 'surprise': 0.141}, 'holiness': {'anticipation': 0.273, 'fear': 0.109, 'joy': 0.531, 'surprise': 0.23399999999999999, 'trust': 0.6559999999999999}, 'lull': {'anticipation': 0.266}, 'habitual': {'anticipation': 0.266}, 'neighborhood': {'anticipation': 0.266}, 'weight': {'anticipation': 0.258, 'disgust': 0.21899999999999997, 'fear': 0.109, 'joy': 0.109, 'sadness': 0.141, 'surprise': 0.11699999999999999, 'trust': 0.289}, 'bye': {'anticipation': 0.258}, 'clown': {'anticipation': 0.25, 'fear': 0.125, 'joy': 0.409, 'surprise': 0.35200000000000004}, 'organ': {'anticipation': 0.25, 'joy': 0.094}, 'quote': {'anticipation': 0.242, 'surprise': 0.141}, 'commonplace': {'anticipation': 0.242, 'trust': 0.45299999999999996}, 'white': {'anticipation': 0.23399999999999999, 'joy': 0.109, 'trust': 0.344}, 'treadmill': {'anticipation': 0.23399999999999999}, 'board': {'anticipation': 0.23399999999999999}, 'sundial': {'anticipation': 0.22699999999999998, 'trust': 0.305}, 'worm': {'anticipation': 0.203, 'surprise': 0.055}, 'cement': {'anticipation': 0.203, 'trust': 0.336}, 'organization': {'anticipation': 0.203, 'joy': 0.156, 'surprise': 0.125, 'trust': 0.516}, 'neutral': {'anticipation': 0.14800000000000002, 'joy': 0.114, 'trust': 0.39799999999999996}, 'cannibalism': {'disgust': 0.953}, 'cannibal': {'disgust': 0.898, 'fear': 0.74}, 'rot': {'disgust': 0.8909999999999999, 'fear': 0.594, 'sadness': 0.5}, 'corpse': {'disgust': 0.883, 'sadness': 0.75}, 'excrement': {'disgust': 0.883}, 'barf': {'disgust': 0.875}, 'filth': {'disgust': 0.8590000000000001}, 'sewerage': {'disgust': 0.8590000000000001}, 'incestuous': {'disgust': 0.8590000000000001}, 'rancid': {'disgust': 0.8590000000000001}, 'plague': {'disgust': 0.852, 'fear': 0.703, 'sadness': 0.547}, 'infestation': {'disgust': 0.852, 'fear': 0.716}, 'maggot': {'disgust': 0.8440000000000001}, 'rotting': {'disgust': 0.8440000000000001}, 'feces': {'disgust': 0.8440000000000001}, 'fecal': {'disgust': 0.8440000000000001}, 'perverted': {'disgust': 0.828}, 'excretion': {'disgust': 0.828}, 'contaminate': {'disgust': 0.821}, 'diarrhoea': {'disgust': 0.82}, 'manure': {'disgust': 0.82}, 'repugnant': {'disgust': 0.82}, 'grotesque': {'disgust': 0.82}, 'dismemberment': {'disgust': 0.812, 'fear': 0.875, 'sadness': 0.7659999999999999}, 'vomit': {'disgust': 0.812}, 'sewer': {'disgust': 0.812}, 'faeces': {'disgust': 0.812}, 'cadaver': {'disgust': 0.812, 'fear': 0.688, 'sadness': 0.853, 'surprise': 0.38299999999999995}, 'hemorrhage': {'disgust': 0.805, 'fear': 0.807, 'sadness': 0.75}, 'repulsive': {'disgust': 0.805}, 'diseased': {'disgust': 0.797, 'fear': 0.7340000000000001, 'sadness': 0.7659999999999999}, 'filthy': {'disgust': 0.797}, 'sewage': {'disgust': 0.797}, 'carcass': {'disgust': 0.795, 'fear': 0.672, 'sadness': 0.653}, 'decompose': {'disgust': 0.789}, 'dung': {'disgust': 0.789}, 'parasite': {'disgust': 0.789, 'fear': 0.578}, 'puke': {'disgust': 0.789}, 'decayed': {'disgust': 0.789, 'sadness': 0.516}, 'mutilated': {'disgust': 0.789}, 'herpes': {'disgust': 0.789}, 'gruesome': {'disgust': 0.789}, 'flatulence': {'disgust': 0.7809999999999999}, 'slime': {'disgust': 0.7809999999999999}, 'crap': {'disgust': 0.7809999999999999}, 'malaria': {'disgust': 0.7809999999999999, 'fear': 0.609, 'sadness': 0.547}, 'pestilence': {'disgust': 0.7809999999999999, 'fear': 0.625}, 'pus': {'disgust': 0.773}, 'morgue': {'disgust': 0.773, 'fear': 0.8440000000000001, 'sadness': 0.7340000000000001}, 'herpesvirus': {'disgust': 0.773}, 'leprosy': {'disgust': 0.773, 'fear': 0.7659999999999999, 'sadness': 0.7190000000000001}, 'toxic': {'disgust': 0.773}, 'anthrax': {'disgust': 0.7659999999999999, 'fear': 0.8590000000000001, 'sadness': 0.6}, 'regurgitation': {'disgust': 0.7659999999999999}, 'repugnance': {'disgust': 0.7659999999999999}, 'xenophobia': {'disgust': 0.7659999999999999, 'fear': 0.6559999999999999}, 'whore': {'disgust': 0.7659999999999999}, 'dissection': {'disgust': 0.759}, 'mucous': {'disgust': 0.758}, 'infectious': {'disgust': 0.758, 'fear': 0.703, 'sadness': 0.483}, 'slum': {'disgust': 0.758}, 'phlegm': {'disgust': 0.758}, 'decomposition': {'disgust': 0.75, 'fear': 0.469, 'sadness': 0.703}, 'leeches': {'disgust': 0.75, 'fear': 0.531}, 'stinking': {'disgust': 0.742}, 'soiled': {'disgust': 0.742}, 'mucus': {'disgust': 0.742}, 'abhorrence': {'disgust': 0.742}, 'septic': {'disgust': 0.742}, 'sicken': {'disgust': 0.7340000000000001}, 'obese': {'disgust': 0.7340000000000001}, 'repulsion': {'disgust': 0.727, 'fear': 0.431}, 'adultery': {'disgust': 0.727, 'sadness': 0.5660000000000001}, 'grisly': {'disgust': 0.727, 'fear': 0.703}, 'dirty': {'disgust': 0.727}, 'contamination': {'disgust': 0.727}, 'enema': {'disgust': 0.727}, 'bacterium': {'disgust': 0.727, 'fear': 0.531}, 'dysentery': {'disgust': 0.727, 'sadness': 0.593}, 'garbage': {'disgust': 0.7190000000000001}, 'autopsy': {'disgust': 0.7190000000000001, 'fear': 0.557, 'sadness': 0.562}, 'bowels': {'disgust': 0.7190000000000001}, 'entrails': {'disgust': 0.7190000000000001}, 'muck': {'disgust': 0.7190000000000001}, 'gross': {'disgust': 0.7190000000000001}, 'vulgar': {'disgust': 0.7190000000000001}, 'pungent': {'disgust': 0.7190000000000001}, 'lewd': {'disgust': 0.7190000000000001}, 'gag': {'disgust': 0.711}, 'nausea': {'disgust': 0.711, 'fear': 0.406}, 'pollute': {'disgust': 0.711}, 'wretched': {'disgust': 0.711, 'sadness': 0.672}, 'slimy': {'disgust': 0.703}, 'poisoning': {'disgust': 0.703}, 'secretion': {'disgust': 0.703}, 'noxious': {'disgust': 0.703, 'fear': 0.547}, 'grime': {'disgust': 0.703}, 'nauseate': {'disgust': 0.703}, 'porn': {'disgust': 0.703}, 'constipation': {'disgust': 0.703}, 'measles': {'disgust': 0.696, 'fear': 0.359, 'sadness': 0.469}, 'scum': {'disgust': 0.695}, 'intestinal': {'disgust': 0.695}, 'obesity': {'disgust': 0.695, 'sadness': 0.359}, 'wart': {'disgust': 0.695}, 'contagious': {'disgust': 0.695, 'fear': 0.72, 'joy': 0.25}, 'waste': {'disgust': 0.695, 'sadness': 0.348}, 'contaminated': {'disgust': 0.688, 'fear': 0.61, 'sadness': 0.594}, 'ooze': {'disgust': 0.688}, 'smut': {'disgust': 0.688, 'fear': 0.32799999999999996}, 'heartworm': {'disgust': 0.688}, 'bestial': {'disgust': 0.68, 'fear': 0.639}, 'pollution': {'disgust': 0.68}, 'freakish': {'disgust': 0.68, 'fear': 0.484, 'surprise': 0.664}, 'soulless': {'disgust': 0.68, 'fear': 0.469, 'sadness': 0.623}, 'abominate': {'disgust': 0.68}, 'deformed': {'disgust': 0.68, 'sadness': 0.703}, 'cholera': {'disgust': 0.68, 'fear': 0.75, 'sadness': 0.583}, 'sickness': {'disgust': 0.68, 'fear': 0.594, 'sadness': 0.828}, 'grimy': {'disgust': 0.68}, 'dilapidated': {'disgust': 0.672, 'sadness': 0.609}, 'hideous': {'disgust': 0.672, 'fear': 0.6409999999999999, 'sadness': 0.516}, 'loathful': {'disgust': 0.672}, 'obscene': {'disgust': 0.672}, 'loathing': {'disgust': 0.672}, 'greasy': {'disgust': 0.672}, 'cess': {'disgust': 0.67}, 'abominable': {'disgust': 0.664, 'fear': 0.738}, 'nauseous': {'disgust': 0.664, 'fear': 0.375, 'sadness': 0.5}, 'deformity': {'disgust': 0.664, 'fear': 0.547, 'sadness': 0.703}, 'swine': {'disgust': 0.664}, 'heretic': {'disgust': 0.664}, 'corruption': {'disgust': 0.6559999999999999}, 'goo': {'disgust': 0.6559999999999999}, 'prejudiced': {'disgust': 0.6559999999999999, 'fear': 0.484}, 'mange': {'disgust': 0.6559999999999999, 'fear': 0.562}, 'bacteria': {'disgust': 0.6559999999999999, 'fear': 0.578, 'sadness': 0.32799999999999996}, 'abortion': {'disgust': 0.6559999999999999, 'fear': 0.6409999999999999, 'sadness': 0.7659999999999999}, 'latrines': {'disgust': 0.6559999999999999}, 'nefarious': {'disgust': 0.6559999999999999, 'fear': 0.6559999999999999, 'sadness': 0.546, 'surprise': 0.562}, 'trash': {'disgust': 0.6559999999999999, 'sadness': 0.23399999999999999}, 'detestation': {'disgust': 0.648}, 'outhouse': {'disgust': 0.648}, 'ugly': {'disgust': 0.648}, 'sludge': {'disgust': 0.648}, 'trashy': {'disgust': 0.648}, 'horrifying': {'disgust': 0.6409999999999999, 'fear': 0.9059999999999999, 'sadness': 0.907}, 'pimple': {'disgust': 0.6409999999999999}, 'laxative': {'disgust': 0.6409999999999999, 'fear': 0.312}, 'malfeasance': {'disgust': 0.6409999999999999}, 'cystic': {'disgust': 0.6409999999999999}, 'unsightly': {'disgust': 0.6409999999999999}, 'spew': {'disgust': 0.6409999999999999}, 'slop': {'disgust': 0.6409999999999999}, 'secrete': {'disgust': 0.633}, 'rat': {'disgust': 0.633, 'fear': 0.484}, 'queasy': {'disgust': 0.633}, 'prostitution': {'disgust': 0.633, 'sadness': 0.375}, 'mildew': {'disgust': 0.633}, 'aghast': {'disgust': 0.625, 'fear': 0.6409999999999999, 'surprise': 0.805}, 'gluttony': {'disgust': 0.625}, 'stools': {'disgust': 0.625}, 'bloated': {'disgust': 0.625}, 'ghastly': {'disgust': 0.625, 'fear': 0.836}, 'cuckold': {'disgust': 0.625}, 'suffering': {'disgust': 0.625, 'fear': 0.812, 'sadness': 0.8440000000000001}, 'degrading': {'disgust': 0.625, 'fear': 0.562, 'sadness': 0.609}, 'fungus': {'disgust': 0.625}, 'devilish': {'disgust': 0.625, 'fear': 0.7340000000000001}, 'louse': {'disgust': 0.617}, 'diaper': {'disgust': 0.617}, 'infect': {'disgust': 0.617}, 'crusty': {'disgust': 0.617}, 'polygamy': {'disgust': 0.617}, 'sickly': {'disgust': 0.617, 'sadness': 0.7120000000000001}, 'fat': {'disgust': 0.617, 'sadness': 0.203}, 'termite': {'disgust': 0.617}, 'spoil': {'disgust': 0.617}, 'tetanus': {'disgust': 0.617}, 'bleeding': {'disgust': 0.609, 'fear': 0.609, 'sadness': 0.6729999999999999}, 'deform': {'disgust': 0.609}, 'ghetto': {'disgust': 0.609, 'fear': 0.406, 'sadness': 0.43799999999999994}, 'brothel': {'disgust': 0.609}, 'drool': {'disgust': 0.609}, 'hag': {'disgust': 0.602, 'fear': 0.25}, 'ugliness': {'disgust': 0.602, 'fear': 0.41, 'sadness': 0.609}, 'unwashed': {'disgust': 0.602}, 'musty': {'disgust': 0.602}, 'swampy': {'disgust': 0.602, 'fear': 0.25}, 'toilet': {'disgust': 0.594}, 'slug': {'disgust': 0.594}, 'intoxicated': {'disgust': 0.594}, 'blister': {'disgust': 0.594}, 'gut': {'disgust': 0.594}, 'repelling': {'disgust': 0.594}, 'deceitful': {'disgust': 0.594, 'sadness': 0.562}, 'lurid': {'disgust': 0.594}, 'queasiness': {'disgust': 0.594}, 'deteriorated': {'disgust': 0.586, 'sadness': 0.365}, 'appalling': {'disgust': 0.586, 'fear': 0.562}, 'incubus': {'disgust': 0.586, 'fear': 0.562}, 'lavatory': {'disgust': 0.586}, 'prostitute': {'disgust': 0.586}, 'unclean': {'disgust': 0.586}, 'pornography': {'disgust': 0.586}, 'humiliating': {'disgust': 0.578}, 'squeamish': {'disgust': 0.578, 'fear': 0.5}, 'retard': {'disgust': 0.578, 'fear': 0.484, 'sadness': 0.516}, 'larceny': {'disgust': 0.578}, 'hypocrite': {'disgust': 0.578}, 'flea': {'disgust': 0.578}, 'rash': {'disgust': 0.578}, 'unfaithful': {'disgust': 0.578}, 'sick': {'disgust': 0.578, 'sadness': 0.531}, 'debauchery': {'disgust': 0.578, 'fear': 0.6559999999999999}, 'quagmire': {'disgust': 0.578}, 'serpent': {'disgust': 0.57, 'fear': 0.638}, 'bastard': {'disgust': 0.57, 'sadness': 0.366}, 'spit': {'disgust': 0.57}, 'dank': {'disgust': 0.57}, 'dogsick': {'disgust': 0.57}, 'messy': {'disgust': 0.57}, 'swamp': {'disgust': 0.57, 'fear': 0.297}, 'sloppy': {'disgust': 0.562}, 'sinning': {'disgust': 0.562}, 'harlot': {'disgust': 0.562}, 'stealing': {'disgust': 0.562, 'fear': 0.578}, 'humiliation': {'disgust': 0.562, 'sadness': 0.578}, 'snake': {'disgust': 0.562, 'fear': 0.7759999999999999}, 'loo': {'disgust': 0.562}, 'indecent': {'disgust': 0.562}, 'arsenic': {'disgust': 0.555, 'fear': 0.703, 'sadness': 0.484}, 'insufferable': {'disgust': 0.555}, 'coward': {'disgust': 0.555, 'fear': 0.578, 'sadness': 0.484}, 'atrophy': {'disgust': 0.555, 'fear': 0.43799999999999994, 'sadness': 0.7190000000000001}, 'flabby': {'disgust': 0.555}, 'beastly': {'disgust': 0.555, 'fear': 0.688}, 'distaste': {'disgust': 0.555}, 'wickedness': {'disgust': 0.555}, 'unattractive': {'disgust': 0.555, 'sadness': 0.373}, 'varicella': {'disgust': 0.555, 'fear': 0.42200000000000004, 'sadness': 0.424}, 'discriminating': {'disgust': 0.555}, 'ogre': {'disgust': 0.547, 'fear': 0.609}, 'vesicular': {'disgust': 0.547}, 'purgatory': {'disgust': 0.547, 'fear': 0.6559999999999999}, 'burglar': {'disgust': 0.547, 'fear': 0.594}, 'suffocating': {'disgust': 0.547, 'fear': 0.858, 'sadness': 0.703}, 'sty': {'disgust': 0.547}, 'drunken': {'disgust': 0.539}, 'liar': {'disgust': 0.539}, 'sloth': {'disgust': 0.539}, 'pig': {'disgust': 0.539}, 'greedy': {'disgust': 0.539}, 'repellant': {'disgust': 0.539, 'fear': 0.373}, 'fatty': {'disgust': 0.539, 'sadness': 0.312}, 'gob': {'disgust': 0.539}, 'shame': {'disgust': 0.539, 'fear': 0.344, 'sadness': 0.594}, 'lethal': {'disgust': 0.536, 'fear': 0.8059999999999999, 'sadness': 0.797}, 'neurotic': {'disgust': 0.531, 'fear': 0.703}, 'withered': {'disgust': 0.531}, 'hydrocephalus': {'disgust': 0.531, 'fear': 0.45299999999999996, 'sadness': 0.547}, 'aberration': {'disgust': 0.531}, 'burnt': {'disgust': 0.531}, 'disintegrate': {'disgust': 0.531, 'fear': 0.609}, 'travesty': {'disgust': 0.531, 'fear': 0.562, 'sadness': 0.688}, 'rubbish': {'disgust': 0.523}, 'blighted': {'disgust': 0.523, 'sadness': 0.6559999999999999}, 'remains': {'disgust': 0.516, 'fear': 0.281, 'trust': 0.445}, 'cringe': {'disgust': 0.516, 'fear': 0.578, 'sadness': 0.5}, 'mite': {'disgust': 0.516}, 'vulture': {'disgust': 0.516, 'fear': 0.41}, 'stink': {'disgust': 0.516}, 'sump': {'disgust': 0.516}, 'degrade': {'disgust': 0.516}, 'gutter': {'disgust': 0.516}, 'delirium': {'disgust': 0.508, 'sadness': 0.5760000000000001}, 'dreadfully': {'disgust': 0.508, 'fear': 0.7959999999999999, 'sadness': 0.797, 'surprise': 0.47700000000000004}, 'glut': {'disgust': 0.508}, 'smelling': {'disgust': 0.508}, 'distasteful': {'disgust': 0.508}, 'bombed': {'disgust': 0.508}, 'blob': {'disgust': 0.508, 'fear': 0.5}, 'crude': {'disgust': 0.508}, 'endemic': {'disgust': 0.508, 'fear': 0.484, 'sadness': 0.5}, 'impurity': {'disgust': 0.5}, 'impeach': {'disgust': 0.5, 'fear': 0.354}, 'mire': {'disgust': 0.5}, 'blight': {'disgust': 0.5, 'fear': 0.312, 'sadness': 0.591}, 'dirt': {'disgust': 0.5}, 'bribery': {'disgust': 0.5}, 'taboo': {'disgust': 0.5, 'fear': 0.344}, 'goblin': {'disgust': 0.5, 'fear': 0.594}, 'idolatry': {'disgust': 0.5, 'fear': 0.469}, 'gorge': {'disgust': 0.49200000000000005}, 'idiot': {'disgust': 0.49200000000000005}, 'robber': {'disgust': 0.49200000000000005, 'fear': 0.516}, 'boil': {'disgust': 0.49200000000000005}, 'squirm': {'disgust': 0.49200000000000005}, 'leer': {'disgust': 0.49200000000000005}, 'unconscionable': {'disgust': 0.49200000000000005}, 'mess': {'disgust': 0.484}, 'stain': {'disgust': 0.484}, 'occult': {'disgust': 0.484, 'fear': 0.5589999999999999}, 'affliction': {'disgust': 0.484, 'fear': 0.557, 'joy': 0.10300000000000001, 'sadness': 0.645}, 'nappy': {'disgust': 0.484}, 'servile': {'disgust': 0.484, 'fear': 0.344, 'sadness': 0.359}, 'unbearable': {'disgust': 0.484, 'sadness': 0.83}, 'defamation': {'disgust': 0.484, 'fear': 0.484}, 'aversation': {'disgust': 0.484}, 'tramp': {'disgust': 0.484, 'fear': 0.44, 'sadness': 0.28800000000000003}, 'mockery': {'disgust': 0.47700000000000004}, 'dismal': {'disgust': 0.47700000000000004, 'fear': 0.584, 'sadness': 0.562}, 'palsy': {'disgust': 0.47700000000000004, 'fear': 0.516, 'sadness': 0.625}, 'unpleasant': {'disgust': 0.47700000000000004, 'sadness': 0.53}, 'pathetic': {'disgust': 0.47700000000000004, 'sadness': 0.688}, 'wallow': {'disgust': 0.469, 'sadness': 0.562}, 'cough': {'disgust': 0.469}, 'perspiration': {'disgust': 0.469}, 'spider': {'disgust': 0.461, 'fear': 0.6559999999999999}, 'muddy': {'disgust': 0.461}, 'spurious': {'disgust': 0.461}, 'distorted': {'disgust': 0.461}, 'fool': {'disgust': 0.461}, 'quack': {'disgust': 0.461}, 'aphid': {'disgust': 0.45299999999999996}, 'dire': {'disgust': 0.45299999999999996, 'fear': 0.578, 'sadness': 0.609, 'surprise': 0.664}, 'disingenuous': {'disgust': 0.45299999999999996}, 'caries': {'disgust': 0.445}, 'pious': {'disgust': 0.445, 'sadness': 0.21899999999999997, 'trust': 0.5}, 'iniquity': {'disgust': 0.445}, 'egotistical': {'disgust': 0.445}, 'vacuous': {'disgust': 0.445}, 'piles': {'disgust': 0.445}, 'garish': {'disgust': 0.445, 'surprise': 0.508}, 'abnormal': {'disgust': 0.43799999999999994}, 'ashamed': {'disgust': 0.43799999999999994, 'sadness': 0.7190000000000001}, 'abject': {'disgust': 0.43799999999999994}, 'sticky': {'disgust': 0.43799999999999994}, 'inmate': {'disgust': 0.43799999999999994, 'fear': 0.469}, 'hog': {'disgust': 0.43799999999999994}, 'alien': {'disgust': 0.43799999999999994, 'fear': 0.42200000000000004}, 'debris': {'disgust': 0.43}, 'falsity': {'disgust': 0.43}, 'creature': {'disgust': 0.43, 'fear': 0.34}, 'pall': {'disgust': 0.43}, 'shameless': {'disgust': 0.43}, 'reflux': {'disgust': 0.43}, 'lusty': {'disgust': 0.43}, 'mistrust': {'disgust': 0.42200000000000004, 'fear': 0.5}, 'impure': {'disgust': 0.42200000000000004}, 'pompous': {'disgust': 0.42200000000000004}, 'bum': {'disgust': 0.42200000000000004, 'sadness': 0.43799999999999994}, 'collapse': {'disgust': 0.42200000000000004, 'fear': 0.703, 'sadness': 0.469}, 'swarm': {'disgust': 0.42200000000000004}, 'hairy': {'disgust': 0.42200000000000004}, 'tasteless': {'disgust': 0.42200000000000004}, 'gush': {'disgust': 0.42200000000000004, 'joy': 0.545}, 'wasting': {'disgust': 0.42200000000000004, 'fear': 0.359, 'sadness': 0.375}, 'nicotine': {'disgust': 0.42200000000000004}, 'slush': {'disgust': 0.42200000000000004, 'surprise': 0.141}, 'bovine': {'disgust': 0.42200000000000004}, 'hypertrophy': {'disgust': 0.42200000000000004, 'fear': 0.594, 'surprise': 0.32799999999999996}, 'untidy': {'disgust': 0.42200000000000004}, 'tarnish': {'disgust': 0.42200000000000004, 'sadness': 0.531}, 'ammonia': {'disgust': 0.42200000000000004}, 'vegetative': {'disgust': 0.414, 'sadness': 0.516}, 'unfavorable': {'disgust': 0.414, 'sadness': 0.469}, 'drivel': {'disgust': 0.414}, 'socialism': {'disgust': 0.414, 'fear': 0.405}, 'displacency': {'disgust': 0.414}, 'sour': {'disgust': 0.414}, 'murky': {'disgust': 0.414, 'sadness': 0.375}, 'dishonesty': {'disgust': 0.414}, 'repel': {'disgust': 0.406}, 'ignorant': {'disgust': 0.406}, 'displeasure': {'disgust': 0.406}, 'prosecution': {'disgust': 0.406}, 'discontinuity': {'disgust': 0.406, 'fear': 0.312, 'sadness': 0.297}, 'outcast': {'disgust': 0.406, 'fear': 0.38799999999999996, 'sadness': 0.672}, 'falsify': {'disgust': 0.406}, 'woe': {'disgust': 0.39799999999999996, 'fear': 0.491, 'sadness': 0.7190000000000001}, 'worsening': {'disgust': 0.39799999999999996, 'sadness': 0.562}, 'unnatural': {'disgust': 0.39799999999999996, 'fear': 0.42200000000000004}, 'rigor': {'disgust': 0.39799999999999996, 'fear': 0.45299999999999996}, 'amphetamines': {'disgust': 0.39799999999999996}, 'subvert': {'disgust': 0.39799999999999996, 'fear': 0.5, 'sadness': 0.384}, 'loon': {'disgust': 0.39799999999999996}, 'failure': {'disgust': 0.39799999999999996, 'fear': 0.578, 'sadness': 0.812}, 'lick': {'disgust': 0.39799999999999996}, 'woefully': {'disgust': 0.39799999999999996, 'sadness': 0.672}, 'averseness': {'disgust': 0.391}, 'farcical': {'disgust': 0.391}, 'critter': {'disgust': 0.391}, 'disrelish': {'disgust': 0.391}, 'teeming': {'disgust': 0.38299999999999995}, 'shabby': {'disgust': 0.38299999999999995}, 'sacrifices': {'disgust': 0.38299999999999995, 'fear': 0.562, 'sadness': 0.609}, 'guilt': {'disgust': 0.38299999999999995, 'sadness': 0.75}, 'illiterate': {'disgust': 0.38299999999999995}, 'hypocritical': {'disgust': 0.38299999999999995}, 'fulsome': {'disgust': 0.38299999999999995}, 'plagiarism': {'disgust': 0.38299999999999995}, 'irrational': {'disgust': 0.38299999999999995, 'fear': 0.305}, 'lament': {'disgust': 0.38299999999999995, 'fear': 0.42200000000000004, 'sadness': 0.636}, 'anaconda': {'disgust': 0.38299999999999995, 'fear': 0.75}, 'unworthy': {'disgust': 0.375}, 'depressing': {'disgust': 0.375, 'sadness': 0.9059999999999999}, 'misconduct': {'disgust': 0.375}, 'defective': {'disgust': 0.375}, 'vainly': {'disgust': 0.36700000000000005, 'sadness': 0.091}, 'wimp': {'disgust': 0.36700000000000005, 'fear': 0.32799999999999996}, 'unhealthy': {'disgust': 0.36700000000000005, 'fear': 0.469, 'sadness': 0.474}, 'shuddering': {'disgust': 0.36700000000000005}, 'exclusion': {'disgust': 0.36700000000000005, 'fear': 0.636, 'sadness': 0.5}, 'toad': {'disgust': 0.36700000000000005}, 'oddity': {'disgust': 0.359, 'sadness': 0.188, 'surprise': 0.578}, 'ineptitude': {'disgust': 0.359, 'fear': 0.41700000000000004, 'sadness': 0.391}, 'dispose': {'disgust': 0.359}, 'bug': {'disgust': 0.359, 'fear': 0.188}, 'compost': {'disgust': 0.35200000000000004}, 'obi': {'disgust': 0.35200000000000004, 'fear': 0.375}, 'flesh': {'disgust': 0.35200000000000004}, 'tearful': {'disgust': 0.344, 'fear': 0.406, 'sadness': 0.703}, 'lumpy': {'disgust': 0.336}, 'disinclination': {'disgust': 0.336}, 'heartsick': {'disgust': 0.336}, 'discoloration': {'disgust': 0.336}, 'daft': {'disgust': 0.336}, 'blunder': {'disgust': 0.336, 'sadness': 0.21899999999999997}, 'excluded': {'disgust': 0.32799999999999996, 'sadness': 0.609}, 'instability': {'disgust': 0.32799999999999996, 'fear': 0.5}, 'unmanageable': {'disgust': 0.32799999999999996}, 'hydrophobia': {'disgust': 0.32799999999999996}, 'whine': {'disgust': 0.32799999999999996, 'sadness': 0.578}, 'materialist': {'disgust': 0.32799999999999996}, 'unsatisfactory': {'disgust': 0.32799999999999996}, 'groan': {'disgust': 0.32, 'sadness': 0.545}, 'soot': {'disgust': 0.32}, 'rags': {'disgust': 0.32}, 'mishap': {'disgust': 0.32, 'fear': 0.32799999999999996, 'sadness': 0.33799999999999997, 'surprise': 0.594}, 'theism': {'disgust': 0.312}, 'disincline': {'disgust': 0.312}, 'stomach': {'disgust': 0.312}, 'sneeze': {'disgust': 0.312, 'surprise': 0.47700000000000004}, 'soil': {'disgust': 0.312}, 'disliking': {'disgust': 0.305}, 'shack': {'disgust': 0.305, 'sadness': 0.266}, 'soreness': {'disgust': 0.297, 'sadness': 0.32799999999999996}, 'congress': {'disgust': 0.297, 'trust': 0.273}, 'disappointment': {'disgust': 0.297, 'sadness': 0.594}, 'disregarded': {'disgust': 0.297}, 'rogue': {'disgust': 0.297}, 'backwards': {'disgust': 0.297}, 'lesbian': {'disgust': 0.289, 'sadness': 0.141}, 'flop': {'disgust': 0.289, 'sadness': 0.281}, 'janitor': {'disgust': 0.289}, 'catechism': {'disgust': 0.289}, 'gaby': {'disgust': 0.281}, 'saturated': {'disgust': 0.281}, 'uneasy': {'disgust': 0.273, 'fear': 0.312}, 'discolored': {'disgust': 0.273, 'sadness': 0.21899999999999997}, 'bureaucrat': {'disgust': 0.266}, 'unsatisfied': {'disgust': 0.266, 'sadness': 0.405}, 'inefficiency': {'disgust': 0.266, 'sadness': 0.359}, 'crawl': {'disgust': 0.266}, 'weird': {'disgust': 0.266}, 'politic': {'disgust': 0.266}, 'impolite': {'disgust': 0.266}, 'swig': {'disgust': 0.266}, 'octopus': {'disgust': 0.258}, 'chagrin': {'disgust': 0.258, 'sadness': 0.547}, 'barrow': {'disgust': 0.258}, 'shanghai': {'disgust': 0.25, 'fear': 0.266}, 'john': {'disgust': 0.25}, 'disinclined': {'disgust': 0.25}, 'cupping': {'disgust': 0.25, 'fear': 0.266, 'sadness': 0.172}, 'baboon': {'disgust': 0.25}, 'gratuitous': {'disgust': 0.242}, 'scrub': {'disgust': 0.242}, 'prolong': {'disgust': 0.23399999999999999}, 'questionable': {'disgust': 0.23399999999999999}, 'backwardness': {'disgust': 0.23399999999999999}, 'reluctance': {'disgust': 0.23399999999999999}, 'ineffectual': {'disgust': 0.22699999999999998}, 'default': {'disgust': 0.22699999999999998, 'fear': 0.226, 'sadness': 0.121}, 'unpopular': {'disgust': 0.22699999999999998, 'sadness': 0.359}, 'petroleum': {'disgust': 0.21899999999999997}, 'tawny': {'disgust': 0.21100000000000002}, 'donkey': {'disgust': 0.21100000000000002}, 'speck': {'disgust': 0.203}, 'awkwardness': {'disgust': 0.203}, 'dandy': {'disgust': 0.203}, 'monochrome': {'disgust': 0.195}, 'airs': {'disgust': 0.195}, 'misguided': {'disgust': 0.195}, 'gelatin': {'disgust': 0.195}, 'avoid': {'disgust': 0.188, 'fear': 0.297}, 'lush': {'disgust': 0.188, 'joy': 0.47, 'sadness': 0.109}, 'lesser': {'disgust': 0.188}, 'sunk': {'disgust': 0.18, 'fear': 0.25, 'sadness': 0.426}, 'laughable': {'disgust': 0.18}, 'nose': {'disgust': 0.18}, 'larger': {'disgust': 0.16399999999999998, 'surprise': 0.297, 'trust': 0.38299999999999995}, 'thrift': {'disgust': 0.16399999999999998, 'trust': 0.22699999999999998}, 'mouthful': {'disgust': 0.16399999999999998}, 'pregnancy': {'disgust': 0.16399999999999998}, 'parrot': {'disgust': 0.156}, 'nameless': {'disgust': 0.14800000000000002}, 'excellence': {'disgust': 0.141, 'joy': 0.818, 'trust': 0.727}, 'turn': {'disgust': 0.133}, 'gray': {'disgust': 0.133, 'sadness': 0.26899999999999996}, 'asymmetry': {'disgust': 0.133}, 'clumsy': {'disgust': 0.133}, 'stall': {'disgust': 0.133}, 'bran': {'disgust': 0.125}, 'lord': {'disgust': 0.125, 'joy': 0.312, 'trust': 0.445}, 'boy': {'disgust': 0.11699999999999999}, 'lemon': {'disgust': 0.109}, 'glitter': {'disgust': 0.094, 'joy': 0.42200000000000004}, 'interior': {'disgust': 0.086, 'trust': 0.32}, 'mind': {'disgust': 0.086}, 'interested': {'disgust': 0.078, 'sadness': 0.114}, 'kite': {'disgust': 0.055}, 'humble': {'disgust': 0.047, 'joy': 0.344, 'sadness': 0.078, 'trust': 0.68}, 'terrorists': {'fear': 0.9690000000000001}, 'suicidebombing': {'fear': 0.9670000000000001}, 'kill': {'fear': 0.9620000000000001, 'sadness': 0.797}, 'terror': {'fear': 0.953}, 'war': {'fear': 0.9420000000000001}, 'bombing': {'fear': 0.938}, 'missiles': {'fear': 0.934}, 'horrified': {'fear': 0.922}, 'terrifying': {'fear': 0.9059999999999999}, 'fatality': {'fear': 0.9059999999999999, 'sadness': 0.7659999999999999}, 'horrors': {'fear': 0.9059999999999999, 'sadness': 0.828}, 'terrified': {'fear': 0.9059999999999999}, 'doomed': {'fear': 0.888, 'sadness': 0.7659999999999999}, 'explosion': {'fear': 0.879, 'surprise': 0.898}, 'tragedy': {'fear': 0.8590000000000001, 'sadness': 0.9059999999999999}, 'ihatespiders': {'fear': 0.8590000000000001}, 'fright': {'fear': 0.853, 'surprise': 0.836}, 'panicked': {'fear': 0.8440000000000001}, 'apocalypse': {'fear': 0.8440000000000001}, 'monster': {'fear': 0.8440000000000001}, 'afraid': {'fear': 0.8440000000000001}, 'drown': {'fear': 0.8440000000000001, 'sadness': 0.6409999999999999}, 'petrified': {'fear': 0.8440000000000001}, 'frightened': {'fear': 0.8440000000000001, 'surprise': 0.867}, 'frightening': {'fear': 0.8440000000000001}, 'scariest': {'fear': 0.8440000000000001}, 'grenade': {'fear': 0.828}, 'frighten': {'fear': 0.828, 'sadness': 0.578, 'surprise': 0.875}, 'nightmare': {'fear': 0.828}, 'doom': {'fear': 0.828}, 'gunmen': {'fear': 0.828}, 'trauma': {'fear': 0.828}, 'kidnapped': {'fear': 0.828}, 'paralyze': {'fear': 0.828}, 'crippling': {'fear': 0.8170000000000001}, 'heartattack': {'fear': 0.812}, 'quake': {'fear': 0.812}, 'hurricane': {'fear': 0.8109999999999999}, 'exterminate': {'fear': 0.81, 'sadness': 0.736}, 'fearing': {'fear': 0.8079999999999999}, 'claustrophobia': {'fear': 0.8029999999999999}, 'danger': {'fear': 0.802, 'sadness': 0.7190000000000001}, 'snakes': {'fear': 0.802}, 'exorcism': {'fear': 0.8, 'sadness': 0.6409999999999999}, 'terrifies': {'fear': 0.7979999999999999}, 'bombers': {'fear': 0.797}, 'cyanide': {'fear': 0.797}, 'hysteria': {'fear': 0.797}, 'biggestfear': {'fear': 0.797}, 'anxietyattack': {'fear': 0.797}, 'warcrimes': {'fear': 0.785}, 'perish': {'fear': 0.784, 'sadness': 0.8590000000000001}, 'feared': {'fear': 0.782}, 'freakingout': {'fear': 0.7809999999999999}, 'lifeless': {'fear': 0.7809999999999999, 'sadness': 0.797}, 'panicattack': {'fear': 0.774}, 'dangerously': {'fear': 0.7659999999999999}, 'ohshit': {'fear': 0.7659999999999999}, 'shipwreck': {'fear': 0.7659999999999999, 'sadness': 0.562}, 'tumor': {'fear': 0.7659999999999999}, 'fearful': {'fear': 0.7659999999999999, 'sadness': 0.7659999999999999}, 'hazardous': {'fear': 0.7659999999999999}, 'crisis': {'fear': 0.7659999999999999}, 'detonate': {'fear': 0.7659999999999999, 'surprise': 0.773}, 'jihad': {'fear': 0.7659999999999999}, 'die': {'fear': 0.7659999999999999, 'sadness': 0.773}, 'scary': {'fear': 0.7659999999999999}, 'claustrophobic': {'fear': 0.765}, 'hyperventilating': {'fear': 0.762}, 'nightmares': {'fear': 0.759}, 'ghostly': {'fear': 0.754}, 'tyranny': {'fear': 0.75, 'sadness': 0.562}, 'obliteration': {'fear': 0.75, 'sadness': 0.75}, 'hurricanes': {'fear': 0.75}, 'dangerous': {'fear': 0.75}, 'panic': {'fear': 0.75}, 'projectiles': {'fear': 0.75}, 'tragedies': {'fear': 0.75}, 'ptsd': {'fear': 0.75}, 'mortuary': {'fear': 0.75, 'sadness': 0.797}, 'fears': {'fear': 0.75}, 'hazard': {'fear': 0.75}, 'accident': {'fear': 0.75, 'sadness': 0.516, 'surprise': 0.75}, 'wrenching': {'fear': 0.75}, 'malignancy': {'fear': 0.742, 'sadness': 0.8029999999999999}, 'mafia': {'fear': 0.7340000000000001}, 'melee': {'fear': 0.7340000000000001}, 'bomber': {'fear': 0.7340000000000001, 'sadness': 0.547}, 'missile': {'fear': 0.7340000000000001}, 'crash': {'fear': 0.7340000000000001, 'sadness': 0.5, 'surprise': 0.7340000000000001}, 'scared': {'fear': 0.7340000000000001}, 'hyperventilate': {'fear': 0.7340000000000001}, 'tornado': {'fear': 0.7340000000000001}, 'alligator': {'fear': 0.727}, 'ruin': {'fear': 0.725, 'sadness': 0.6559999999999999}, 'shooter': {'fear': 0.722}, 'excruciating': {'fear': 0.7190000000000001}, 'emergency': {'fear': 0.7190000000000001, 'sadness': 0.6409999999999999, 'surprise': 0.828}, 'seizure': {'fear': 0.7190000000000001}, 'phobia': {'fear': 0.7190000000000001}, 'starvation': {'fear': 0.7190000000000001, 'sadness': 0.8190000000000001}, 'injured': {'fear': 0.7190000000000001, 'sadness': 0.609}, 'desperation': {'fear': 0.7190000000000001, 'sadness': 0.75}, 'miscarriage': {'fear': 0.7190000000000001, 'sadness': 0.8240000000000001}, 'harm': {'fear': 0.7190000000000001}, 'frantically': {'fear': 0.7170000000000001}, 'soscary': {'fear': 0.7120000000000001}, 'panicking': {'fear': 0.708}, 'rupture': {'fear': 0.706, 'sadness': 0.588, 'surprise': 0.7190000000000001}, 'dreaded': {'fear': 0.703}, 'gash': {'fear': 0.703}, 'sos': {'fear': 0.703}, 'agonizing': {'fear': 0.703}, 'harrowing': {'fear': 0.703}, 'terminal': {'fear': 0.703, 'sadness': 0.688}, 'freaked': {'fear': 0.703}, 'cobra': {'fear': 0.703}, 'carcinoma': {'fear': 0.703, 'sadness': 0.703}, 'prey': {'fear': 0.703}, 'cripple': {'fear': 0.703, 'sadness': 0.7190000000000001}, 'avalanche': {'fear': 0.703, 'sadness': 0.45299999999999996, 'surprise': 0.711}, 'crocodile': {'fear': 0.7}, 'abduction': {'fear': 0.7, 'sadness': 0.75, 'surprise': 0.773}, 'mayhem': {'fear': 0.69}, 'socialanxiety': {'fear': 0.688}, 'radiation': {'fear': 0.688}, 'agoraphobia': {'fear': 0.688}, 'shrapnel': {'fear': 0.688}, 'alarm': {'fear': 0.688, 'surprise': 0.852}, 'wounding': {'fear': 0.688}, 'paranoid': {'fear': 0.688}, 'cyclone': {'fear': 0.688, 'surprise': 0.648}, 'guerilla': {'fear': 0.688}, 'hopeless': {'fear': 0.688, 'sadness': 0.688, 'trust': 0.203}, 'coffin': {'fear': 0.684, 'sadness': 0.672}, 'spook': {'fear': 0.6729999999999999}, 'ghost': {'fear': 0.672}, 'dungeon': {'fear': 0.672}, 'militants': {'fear': 0.672}, 'felon': {'fear': 0.672}, 'soscared': {'fear': 0.672}, 'viper': {'fear': 0.672}, 'perishing': {'fear': 0.672, 'sadness': 0.804}, 'frankenstorm': {'fear': 0.672}, 'outbreak': {'fear': 0.672}, 'nervouswreck': {'fear': 0.672}, 'freakedout': {'fear': 0.672}, 'tarantula': {'fear': 0.672}, 'fangs': {'fear': 0.672}, 'scarier': {'fear': 0.672}, 'trembling': {'fear': 0.672}, 'battered': {'fear': 0.667, 'sadness': 0.7340000000000001}, 'desolation': {'fear': 0.667, 'sadness': 0.797}, 'pandemic': {'fear': 0.664, 'sadness': 0.75}, 'volcano': {'fear': 0.6629999999999999, 'surprise': 0.664}, 'scares': {'fear': 0.66}, 'alarming': {'fear': 0.6559999999999999, 'surprise': 0.773}, 'dictator': {'fear': 0.6559999999999999}, 'stroke': {'fear': 0.6559999999999999, 'sadness': 0.406}, 'typhoon': {'fear': 0.6559999999999999}, 'endangered': {'fear': 0.6559999999999999}, 'emetophobia': {'fear': 0.6559999999999999}, 'coma': {'fear': 0.6559999999999999, 'sadness': 0.5}, 'battlefield': {'fear': 0.6559999999999999}, 'fearfully': {'fear': 0.6559999999999999, 'sadness': 0.609, 'surprise': 0.531}, 'selfharm': {'fear': 0.6559999999999999}, 'blizzard': {'fear': 0.6559999999999999}, 'radioactive': {'fear': 0.6559999999999999}, 'despotic': {'fear': 0.6559999999999999}, 'neurosis': {'fear': 0.6559999999999999, 'sadness': 0.531}, 'shitless': {'fear': 0.6559999999999999}, 'encroachment': {'fear': 0.6559999999999999}, 'projectile': {'fear': 0.654}, 'intimidate': {'fear': 0.6409999999999999}, 'wildfire': {'fear': 0.6409999999999999, 'sadness': 0.406, 'surprise': 0.6409999999999999}, 'dreading': {'fear': 0.6409999999999999}, 'dementia': {'fear': 0.6409999999999999, 'sadness': 0.688}, 'perturbation': {'fear': 0.6409999999999999}, 'targeted': {'fear': 0.6409999999999999}, 'warlock': {'fear': 0.6409999999999999}, 'tumour': {'fear': 0.6409999999999999, 'sadness': 0.7809999999999999}, 'demise': {'fear': 0.6409999999999999, 'sadness': 0.7170000000000001}, 'rattlesnake': {'fear': 0.6409999999999999}, 'deteriorate': {'fear': 0.6409999999999999, 'sadness': 0.625}, 'isolated': {'fear': 0.6409999999999999, 'sadness': 0.547}, 'quivering': {'fear': 0.6409999999999999}, 'demented': {'fear': 0.6409999999999999}, 'raptors': {'fear': 0.6409999999999999}, 'haunt': {'fear': 0.6409999999999999}, 'cantbreathe': {'fear': 0.6409999999999999}, 'armaments': {'fear': 0.636}, 'fire': {'fear': 0.636}, 'corrosive': {'fear': 0.636}, 'nervousness': {'fear': 0.627}, 'stunned': {'fear': 0.625, 'surprise': 0.82}, 'infection': {'fear': 0.625}, 'sarcoma': {'fear': 0.625, 'sadness': 0.797}, 'artillery': {'fear': 0.625}, 'mercenary': {'fear': 0.625}, 'irreparable': {'fear': 0.625, 'sadness': 0.609}, 'spiders': {'fear': 0.625}, 'landslide': {'fear': 0.625, 'sadness': 0.375}, 'repression': {'fear': 0.625}, 'turbulent': {'fear': 0.625}, 'wracking': {'fear': 0.625}, 'seize': {'fear': 0.625}, 'meltdown': {'fear': 0.625, 'sadness': 0.703}, 'pneumonia': {'fear': 0.625}, 'wicked': {'fear': 0.625}, 'manic': {'fear': 0.625}, 'barbarian': {'fear': 0.62}, 'plummet': {'fear': 0.613}, 'hangman': {'fear': 0.61}, 'darkened': {'fear': 0.61, 'sadness': 0.43799999999999994}, 'interrogation': {'fear': 0.609}, 'injection': {'fear': 0.609}, 'sufferer': {'fear': 0.609, 'sadness': 0.77}, 'insurmountable': {'fear': 0.609, 'sadness': 0.625}, 'injuring': {'fear': 0.609}, 'dagger': {'fear': 0.609}, 'illness': {'fear': 0.609, 'sadness': 0.688}, 'merciless': {'fear': 0.609}, 'nerves': {'fear': 0.6}, 'villain': {'fear': 0.595}, 'torrent': {'fear': 0.594}, 'tribulation': {'fear': 0.594, 'joy': 0.32799999999999996, 'sadness': 0.45299999999999996}, 'casket': {'fear': 0.594, 'sadness': 0.6559999999999999}, 'haze': {'fear': 0.594}, 'flee': {'fear': 0.594}, 'euthanasia': {'fear': 0.594, 'sadness': 0.927}, 'restrained': {'fear': 0.594}, 'fraught': {'fear': 0.594, 'sadness': 0.722}, 'dragon': {'fear': 0.594}, 'paranoia': {'fear': 0.594}, 'shelling': {'fear': 0.594}, 'cardiomyopathy': {'fear': 0.594, 'sadness': 0.42200000000000004}, 'pain': {'fear': 0.594, 'sadness': 0.7190000000000001}, 'pounding': {'fear': 0.594}, 'sepsis': {'fear': 0.594, 'sadness': 0.611}, 'wounded': {'fear': 0.5920000000000001}, 'evacuate': {'fear': 0.578}, 'infliction': {'fear': 0.578, 'sadness': 0.562}, 'quarantine': {'fear': 0.578}, 'shudder': {'fear': 0.578}, 'eatingdisorders': {'fear': 0.578}, 'grizzly': {'fear': 0.578}, 'haunted': {'fear': 0.578, 'sadness': 0.42200000000000004}, 'sostressed': {'fear': 0.578}, 'demoralized': {'fear': 0.578, 'sadness': 0.7809999999999999}, 'angina': {'fear': 0.578}, 'abyss': {'fear': 0.578, 'sadness': 0.594}, 'surgery': {'fear': 0.578, 'sadness': 0.344}, 'jail': {'fear': 0.578, 'sadness': 0.6559999999999999}, 'pained': {'fear': 0.578, 'sadness': 0.833}, 'shady': {'fear': 0.578}, 'comatose': {'fear': 0.575, 'sadness': 0.562}, 'unholy': {'fear': 0.575}, 'toxin': {'fear': 0.575}, 'forced': {'fear': 0.569}, 'cowardice': {'fear': 0.5670000000000001, 'sadness': 0.652}, 'crypt': {'fear': 0.5660000000000001, 'sadness': 0.594}, 'smuggle': {'fear': 0.565}, 'incrimination': {'fear': 0.562, 'sadness': 0.545}, 'afflict': {'fear': 0.562, 'sadness': 0.789}, 'masks': {'fear': 0.562}, 'evasion': {'fear': 0.562, 'sadness': 0.484}, 'grave': {'fear': 0.562, 'sadness': 0.727}, 'eeek': {'fear': 0.562}, 'martyrdom': {'fear': 0.562, 'sadness': 0.594}, 'freak': {'fear': 0.562}, 'martyr': {'fear': 0.562, 'sadness': 0.556}, 'vanished': {'fear': 0.562, 'sadness': 0.695, 'surprise': 0.727}, 'apprehend': {'fear': 0.562}, 'purge': {'fear': 0.562}, 'gunpowder': {'fear': 0.562}, 'misfortune': {'fear': 0.562, 'sadness': 0.516}, 'syncope': {'fear': 0.562, 'sadness': 0.40700000000000003, 'surprise': 0.414}, 'worries': {'fear': 0.562}, 'jitters': {'fear': 0.562}, 'polio': {'fear': 0.562, 'sadness': 0.6559999999999999}, 'unsafe': {'fear': 0.561}, 'worstfeeling': {'fear': 0.56}, 'disable': {'fear': 0.5579999999999999, 'sadness': 0.529}, 'decay': {'fear': 0.557, 'sadness': 0.48200000000000004}, 'vulnerability': {'fear': 0.5479999999999999, 'sadness': 0.469}, 'asylum': {'fear': 0.547}, 'flood': {'fear': 0.547}, 'brigade': {'fear': 0.547}, 'plunge': {'fear': 0.547}, 'appendicitis': {'fear': 0.547, 'sadness': 0.43799999999999994}, 'needles': {'fear': 0.547}, 'samurai': {'fear': 0.547}, 'senile': {'fear': 0.547, 'sadness': 0.5}, 'apparition': {'fear': 0.547, 'surprise': 0.633}, 'ailing': {'fear': 0.547, 'sadness': 0.6559999999999999}, 'defenseless': {'fear': 0.547, 'sadness': 0.526}, 'bondage': {'fear': 0.547, 'sadness': 0.32799999999999996}, 'scandal': {'fear': 0.547}, 'neuralgia': {'fear': 0.547, 'sadness': 0.42200000000000004}, 'siren': {'fear': 0.547}, 'cemetery': {'fear': 0.541, 'sadness': 0.7659999999999999}, 'phantom': {'fear': 0.5379999999999999}, 'fled': {'fear': 0.534}, 'jarring': {'fear': 0.531, 'sadness': 0.42200000000000004}, 'buried': {'fear': 0.531, 'sadness': 0.703}, 'endocarditis': {'fear': 0.531, 'sadness': 0.562}, 'carnivorous': {'fear': 0.531}, 'eek': {'fear': 0.531}, 'manifestation': {'fear': 0.531}, 'atherosclerosis': {'fear': 0.531, 'sadness': 0.5}, 'punish': {'fear': 0.531}, 'cowardly': {'fear': 0.531}, 'shaking': {'fear': 0.531}, 'captor': {'fear': 0.531}, 'helpless': {'fear': 0.531, 'sadness': 0.594}, 'freakout': {'fear': 0.531}, 'stressed': {'fear': 0.531}, 'stormy': {'fear': 0.531}, 'unstable': {'fear': 0.531, 'surprise': 0.609}, 'abandon': {'fear': 0.531, 'sadness': 0.703}, 'stalk': {'fear': 0.531}, 'disembodied': {'fear': 0.531, 'sadness': 0.66}, 'incursion': {'fear': 0.531}, 'blood': {'fear': 0.525}, 'hiding': {'fear': 0.524}, 'cult': {'fear': 0.518}, 'captive': {'fear': 0.517, 'sadness': 0.5760000000000001}, 'emaciated': {'fear': 0.516, 'sadness': 0.7190000000000001}, 'embolism': {'fear': 0.516, 'sadness': 0.531}, 'biopsy': {'fear': 0.516}, 'suspect': {'fear': 0.516}, 'relapse': {'fear': 0.516, 'sadness': 0.53}, 'helplessness': {'fear': 0.516, 'sadness': 0.828}, 'chased': {'fear': 0.516}, 'badfeeling': {'fear': 0.516}, 'fang': {'fear': 0.516}, 'depression': {'fear': 0.508, 'sadness': 0.925}, 'wasp': {'fear': 0.5}, 'downfall': {'fear': 0.5, 'sadness': 0.594}, 'snowmageddon': {'fear': 0.5}, 'surrender': {'fear': 0.5, 'sadness': 0.45299999999999996, 'trust': 0.281}, 'infarct': {'fear': 0.5, 'surprise': 0.49200000000000005}, 'prayforme': {'fear': 0.5}, 'premeditated': {'fear': 0.5}, 'vertigo': {'fear': 0.5}, 'eeeek': {'fear': 0.5}, 'cliff': {'fear': 0.5}, 'scalpel': {'fear': 0.5}, 'indictment': {'fear': 0.484}, 'insecurity': {'fear': 0.484}, 'ohno': {'fear': 0.484}, 'ambulance': {'fear': 0.484, 'trust': 0.555}, 'jumpy': {'fear': 0.484}, 'perjury': {'fear': 0.484, 'surprise': 0.414}, 'ravine': {'fear': 0.484}, 'blackness': {'fear': 0.484, 'sadness': 0.375}, 'intrusion': {'fear': 0.484}, 'palpitations': {'fear': 0.484}, 'syringe': {'fear': 0.484}, 'hearse': {'fear': 0.484, 'sadness': 0.703}, 'armor': {'fear': 0.484, 'trust': 0.484}, 'canthandleit': {'fear': 0.484}, 'indefensible': {'fear': 0.484}, 'hallucination': {'fear': 0.484}, 'worse': {'fear': 0.484, 'sadness': 0.45299999999999996}, 'sonervous': {'fear': 0.484}, 'lion': {'fear': 0.484}, 'hospital': {'fear': 0.484, 'sadness': 0.484, 'trust': 0.531}, 'inspection': {'fear': 0.483}, 'missing': {'fear': 0.474, 'sadness': 0.7190000000000001}, 'despairing': {'fear': 0.474, 'sadness': 0.672}, 'darken': {'fear': 0.47100000000000003, 'sadness': 0.406}, 'austere': {'fear': 0.47, 'sadness': 0.359}, 'sinking': {'fear': 0.469}, 'precipice': {'fear': 0.469}, 'quiver': {'fear': 0.469}, 'toothache': {'fear': 0.469}, 'startle': {'fear': 0.469, 'surprise': 0.875}, 'fever': {'fear': 0.469}, 'asteroid': {'fear': 0.469}, 'regime': {'fear': 0.469}, 'admonition': {'fear': 0.469}, 'superstition': {'fear': 0.469}, 'overwhelmed': {'fear': 0.469, 'sadness': 0.609}, 'foreclose': {'fear': 0.469, 'sadness': 0.45299999999999996}, 'jaws': {'fear': 0.469}, 'fret': {'fear': 0.469}, 'armored': {'fear': 0.469}, 'breakdown': {'fear': 0.469}, 'worried': {'fear': 0.466, 'sadness': 0.621}, 'puma': {'fear': 0.465, 'surprise': 0.312}, 'thirteenth': {'fear': 0.465}, 'destitute': {'fear': 0.455, 'sadness': 0.7659999999999999}, 'powerfully': {'fear': 0.45399999999999996}, 'unspeakable': {'fear': 0.45299999999999996, 'surprise': 0.6559999999999999}, 'dinosaur': {'fear': 0.45299999999999996}, 'straits': {'fear': 0.45299999999999996}, 'stranger': {'fear': 0.45299999999999996}, 'lockup': {'fear': 0.45299999999999996, 'sadness': 0.359}, 'omgomgomg': {'fear': 0.45299999999999996}, 'wail': {'fear': 0.45299999999999996, 'sadness': 0.672}, 'orphan': {'fear': 0.45299999999999996, 'sadness': 0.7340000000000001}, 'apprehension': {'fear': 0.45299999999999996}, 'ohgod': {'fear': 0.45299999999999996}, 'penal': {'fear': 0.45299999999999996, 'sadness': 0.469}, 'spasm': {'fear': 0.45299999999999996}, 'behemoth': {'fear': 0.439}, 'stress': {'fear': 0.439}, 'falter': {'fear': 0.43799999999999994}, 'accidental': {'fear': 0.43799999999999994, 'surprise': 0.672}, 'predicament': {'fear': 0.43799999999999994}, 'aghhh': {'fear': 0.43799999999999994}, 'infirmity': {'fear': 0.43799999999999994}, 'looming': {'fear': 0.43799999999999994}, 'coldsweat': {'fear': 0.43799999999999994}, 'mace': {'fear': 0.43799999999999994}, 'gasping': {'fear': 0.43799999999999994}, 'cabal': {'fear': 0.43799999999999994}, 'unprepared': {'fear': 0.43799999999999994}, 'debacle': {'fear': 0.43799999999999994, 'sadness': 0.609}, 'bewildered': {'fear': 0.43799999999999994, 'surprise': 0.7190000000000001}, 'asp': {'fear': 0.43799999999999994}, 'forfeiture': {'fear': 0.43799999999999994, 'sadness': 0.531}, 'indomitable': {'fear': 0.43799999999999994}, 'dentists': {'fear': 0.43799999999999994}, 'broke': {'fear': 0.43799999999999994, 'sadness': 0.484}, 'targeting': {'fear': 0.43799999999999994}, 'halting': {'fear': 0.435, 'sadness': 0.297}, 'rebels': {'fear': 0.435}, 'stake': {'fear': 0.423}, 'fainting': {'fear': 0.42200000000000004, 'sadness': 0.359, 'surprise': 0.5}, 'depresson': {'fear': 0.42200000000000004}, 'thumping': {'fear': 0.42200000000000004}, 'suspension': {'fear': 0.42200000000000004}, 'publicspeaking': {'fear': 0.42200000000000004}, 'heathen': {'fear': 0.42200000000000004}, 'coyote': {'fear': 0.42200000000000004}, 'stresses': {'fear': 0.42200000000000004}, 'disappear': {'fear': 0.42200000000000004}, 'reticent': {'fear': 0.42200000000000004}, 'stressin': {'fear': 0.42200000000000004}, 'unsteady': {'fear': 0.42200000000000004}, 'extrajudicial': {'fear': 0.42200000000000004}, 'burdensome': {'fear': 0.42200000000000004, 'sadness': 0.634}, 'bier': {'fear': 0.42200000000000004, 'sadness': 0.5}, 'depress': {'fear': 0.42200000000000004, 'sadness': 0.755}, 'hydra': {'fear': 0.42200000000000004}, 'prowl': {'fear': 0.42200000000000004, 'surprise': 0.469}, 'outsider': {'fear': 0.413}, 'distressed': {'fear': 0.406}, 'drones': {'fear': 0.406}, 'dominant': {'fear': 0.406}, 'disorder': {'fear': 0.406}, 'omnipotence': {'fear': 0.406}, 'stressing': {'fear': 0.406}, 'insolvent': {'fear': 0.406, 'sadness': 0.42200000000000004, 'trust': 0.289}, 'blackout': {'fear': 0.406}, 'wary': {'fear': 0.406}, 'stressful': {'fear': 0.406}, 'weakly': {'fear': 0.406, 'sadness': 0.544}, 'screech': {'fear': 0.406, 'surprise': 0.6409999999999999}, 'penance': {'fear': 0.406, 'sadness': 0.531}, 'disabled': {'fear': 0.406, 'sadness': 0.672}, 'deport': {'fear': 0.406, 'sadness': 0.5}, 'squall': {'fear': 0.406, 'sadness': 0.32799999999999996}, 'resection': {'fear': 0.406}, 'whimper': {'fear': 0.406, 'sadness': 0.5760000000000001}, 'ohdear': {'fear': 0.406}, 'rubble': {'fear': 0.406, 'sadness': 0.282}, 'stretcher': {'fear': 0.406, 'sadness': 0.391}, 'conspiracy': {'fear': 0.4}, 'defection': {'fear': 0.39799999999999996}, 'absence': {'fear': 0.396, 'sadness': 0.547}, 'moan': {'fear': 0.39399999999999996, 'sadness': 0.484}, 'insolvency': {'fear': 0.391, 'sadness': 0.43799999999999994, 'surprise': 0.266}, 'refutation': {'fear': 0.391}, 'descent': {'fear': 0.391, 'sadness': 0.377}, 'conquer': {'fear': 0.391, 'trust': 0.273}, 'overt': {'fear': 0.391}, 'snare': {'fear': 0.391}, 'xanax': {'fear': 0.391}, 'cyst': {'fear': 0.391, 'sadness': 0.42200000000000004}, 'suspicion': {'fear': 0.391}, 'musket': {'fear': 0.391}, 'separation': {'fear': 0.391}, 'gulp': {'fear': 0.391, 'surprise': 0.375}, 'unemployed': {'fear': 0.391, 'sadness': 0.359}, 'scarecrow': {'fear': 0.391}, 'unrest': {'fear': 0.391, 'sadness': 0.35100000000000003}, 'cleave': {'fear': 0.391}, 'radon': {'fear': 0.391}, 'spaz': {'fear': 0.391}, 'mental': {'fear': 0.391}, 'nervy': {'fear': 0.391}, 'dubious': {'fear': 0.391, 'trust': 0.195}, 'submission': {'fear': 0.391}, 'whatdoido': {'fear': 0.391}, 'procedure': {'fear': 0.391}, 'avoiding': {'fear': 0.391}, 'throb': {'fear': 0.38799999999999996, 'sadness': 0.273}, 'dontpanic': {'fear': 0.37799999999999995}, 'withdrawals': {'fear': 0.377}, 'barricade': {'fear': 0.375}, 'bankrupt': {'fear': 0.375, 'sadness': 0.609}, 'pressure': {'fear': 0.375}, 'frigate': {'fear': 0.375}, 'edict': {'fear': 0.375}, 'suspected': {'fear': 0.375}, 'sultan': {'fear': 0.375}, 'khan': {'fear': 0.375, 'trust': 0.266}, 'military': {'fear': 0.375}, 'embarrassment': {'fear': 0.375, 'sadness': 0.531, 'surprise': 0.5}, 'psychological': {'fear': 0.375}, 'mentalhealth': {'fear': 0.375}, 'escaped': {'fear': 0.375}, 'locust': {'fear': 0.375}, 'flu': {'fear': 0.375}, 'chasm': {'fear': 0.375}, 'chimera': {'fear': 0.375, 'surprise': 0.49200000000000005}, 'grieve': {'fear': 0.375, 'sadness': 0.8440000000000001}, 'obligor': {'fear': 0.375}, 'ocd': {'fear': 0.375}, 'whirlpool': {'fear': 0.375}, 'antsy': {'fear': 0.375}, 'kerosene': {'fear': 0.375}, 'interrogate': {'fear': 0.375}, 'bunker': {'fear': 0.375}, 'dentistry': {'fear': 0.375}, 'government': {'fear': 0.359}, 'onedge': {'fear': 0.359}, 'bottomless': {'fear': 0.359}, 'headaches': {'fear': 0.359}, 'exam': {'fear': 0.359}, 'dart': {'fear': 0.359}, 'difficult': {'fear': 0.359}, 'protestant': {'fear': 0.359}, 'depreciation': {'fear': 0.359}, 'mandamus': {'fear': 0.359}, 'spike': {'fear': 0.359}, 'jaundice': {'fear': 0.359}, 'recurring': {'fear': 0.359}, 'anomaly': {'fear': 0.359, 'surprise': 0.633}, 'stint': {'fear': 0.359, 'sadness': 0.156}, 'cautionary': {'fear': 0.359}, 'formidable': {'fear': 0.359}, 'timid': {'fear': 0.359, 'sadness': 0.281}, 'sortie': {'fear': 0.359}, 'concerned': {'fear': 0.359, 'sadness': 0.184}, 'languishing': {'fear': 0.358, 'sadness': 0.609}, 'constrain': {'fear': 0.358}, 'retrenchment': {'fear': 0.345}, 'avoidance': {'fear': 0.344}, 'eel': {'fear': 0.344}, 'cutter': {'fear': 0.344}, 'fanaticism': {'fear': 0.344}, 'loneliness': {'fear': 0.344, 'sadness': 0.7659999999999999}, 'resistant': {'fear': 0.344}, 'sorrow': {'fear': 0.344, 'sadness': 0.8440000000000001}, 'psych': {'fear': 0.344}, 'parachute': {'fear': 0.344}, 'verdict': {'fear': 0.344}, 'mri': {'fear': 0.344}, 'discipline': {'fear': 0.344}, 'knell': {'fear': 0.344, 'sadness': 0.275}, 'hesitation': {'fear': 0.344}, 'aaaaaaah': {'fear': 0.344}, 'swerve': {'fear': 0.344, 'surprise': 0.508}, 'launches': {'fear': 0.344}, 'phalanx': {'fear': 0.342, 'trust': 0.359}, 'specter': {'fear': 0.331, 'sadness': 0.344}, 'mortgage': {'fear': 0.331}, 'enigmatic': {'fear': 0.32899999999999996}, 'spillin': {'fear': 0.32799999999999996}, 'hives': {'fear': 0.32799999999999996}, 'police': {'fear': 0.32799999999999996, 'trust': 0.484}, 'shank': {'fear': 0.32799999999999996}, 'weirdo': {'fear': 0.32799999999999996}, 'subordinate': {'fear': 0.32799999999999996}, 'dominion': {'fear': 0.32799999999999996, 'trust': 0.42200000000000004}, 'outpost': {'fear': 0.32799999999999996}, 'shutdown': {'fear': 0.32799999999999996}, 'quash': {'fear': 0.32799999999999996}, 'uhoh': {'fear': 0.32799999999999996}, 'dike': {'fear': 0.32799999999999996}, 'gametime': {'fear': 0.32799999999999996}, 'ethereal': {'fear': 0.32799999999999996}, 'gladiator': {'fear': 0.32799999999999996}, 'scarce': {'fear': 0.327, 'sadness': 0.42200000000000004}, 'astray': {'fear': 0.32}, 'vigilant': {'fear': 0.319, 'trust': 0.594}, 'pessimist': {'fear': 0.317, 'sadness': 0.562}, 'pacing': {'fear': 0.316}, 'conspire': {'fear': 0.312}, 'therapist': {'fear': 0.312}, 'bewilderment': {'fear': 0.312, 'surprise': 0.828}, 'ahhhhhhhh': {'fear': 0.312}, 'cram': {'fear': 0.312}, 'clinical': {'fear': 0.312}, 'valium': {'fear': 0.312}, 'thorny': {'fear': 0.312}, 'whirlwind': {'fear': 0.312}, 'obsessing': {'fear': 0.312}, 'deadline': {'fear': 0.312}, 'foreigner': {'fear': 0.312}, 'ordnance': {'fear': 0.312}, 'dentist': {'fear': 0.312}, 'seclusion': {'fear': 0.312}, 'muzzle': {'fear': 0.312}, 'chargeable': {'fear': 0.312, 'sadness': 0.203}, 'overthinking': {'fear': 0.309}, 'doubts': {'fear': 0.308, 'trust': 0.172}, 'seriousness': {'fear': 0.305, 'sadness': 0.39399999999999996}, 'razor': {'fear': 0.303}, 'erase': {'fear': 0.303}, 'sweating': {'fear': 0.298}, 'giant': {'fear': 0.297}, 'reluctant': {'fear': 0.297}, 'crouching': {'fear': 0.297}, 'weighty': {'fear': 0.297}, 'adjudicate': {'fear': 0.297}, 'flounder': {'fear': 0.297, 'sadness': 0.359}, 'deflation': {'fear': 0.297}, 'auditor': {'fear': 0.297, 'trust': 0.555}, 'inflation': {'fear': 0.297}, 'mage': {'fear': 0.297}, 'hide': {'fear': 0.297}, 'bale': {'fear': 0.297}, 'warning': {'fear': 0.297}, 'deluge': {'fear': 0.287, 'sadness': 0.402, 'surprise': 0.602}, 'hurryup': {'fear': 0.281}, 'oncoming': {'fear': 0.281}, 'discourage': {'fear': 0.281, 'sadness': 0.547}, 'dwarfed': {'fear': 0.281, 'sadness': 0.391}, 'rush': {'fear': 0.281}, 'surveillance': {'fear': 0.281}, 'swelling': {'fear': 0.281}, 'fortress': {'fear': 0.281, 'sadness': 0.11, 'trust': 0.461}, 'notready': {'fear': 0.281}, 'submitting': {'fear': 0.281}, 'flying': {'fear': 0.281}, 'cartridge': {'fear': 0.281}, 'apache': {'fear': 0.281}, 'wan': {'fear': 0.281, 'sadness': 0.312}, 'mistaken': {'fear': 0.281}, 'planes': {'fear': 0.27399999999999997}, 'cop': {'fear': 0.273, 'trust': 0.43}, 'auditions': {'fear': 0.266}, 'acrobat': {'fear': 0.266, 'joy': 0.162, 'trust': 0.258}, 'problem': {'fear': 0.266, 'sadness': 0.43799999999999994}, 'operation': {'fear': 0.266, 'trust': 0.445}, 'newjob': {'fear': 0.266}, 'posse': {'fear': 0.266}, 'insomnia': {'fear': 0.266}, 'cloak': {'fear': 0.266}, 'crowds': {'fear': 0.266}, 'flurries': {'fear': 0.266}, 'crouch': {'fear': 0.266}, 'regiment': {'fear': 0.266}, 'forgotten': {'fear': 0.266, 'sadness': 0.53}, 'hooded': {'fear': 0.266}, 'uncanny': {'fear': 0.266, 'surprise': 0.586}, 'spur': {'fear': 0.262}, 'mortgagor': {'fear': 0.258}, 'repent': {'fear': 0.25}, 'breakingnews': {'fear': 0.25}, 'run': {'fear': 0.25}, 'spinster': {'fear': 0.25, 'sadness': 0.4}, 'jobinterview': {'fear': 0.25}, 'impatiently': {'fear': 0.25}, 'doubt': {'fear': 0.25, 'sadness': 0.359, 'trust': 0.203}, 'insect': {'fear': 0.25}, 'unfamiliar': {'fear': 0.25}, 'guard': {'fear': 0.25, 'trust': 0.5}, 'defend': {'fear': 0.25}, 'badhabit': {'fear': 0.242}, 'grounded': {'fear': 0.242, 'sadness': 0.13}, 'shrink': {'fear': 0.23399999999999999, 'sadness': 0.295}, 'overdrive': {'fear': 0.23399999999999999}, 'shelters': {'fear': 0.23399999999999999}, 'dependence': {'fear': 0.23399999999999999, 'sadness': 0.32799999999999996}, 'buck': {'fear': 0.23399999999999999, 'surprise': 0.38299999999999995}, 'insomniac': {'fear': 0.23399999999999999}, 'pinion': {'fear': 0.23399999999999999}, 'chicken': {'fear': 0.23399999999999999}, 'aaaah': {'fear': 0.23399999999999999}, 'psychiatrist': {'fear': 0.23399999999999999}, 'finalized': {'fear': 0.23399999999999999}, 'sleepless': {'fear': 0.23399999999999999}, 'thatmoment': {'fear': 0.23399999999999999}, 'intercede': {'fear': 0.23399999999999999, 'sadness': 0.344}, 'scaffold': {'fear': 0.23399999999999999}, 'rushing': {'fear': 0.233}, 'overslept': {'fear': 0.226}, 'confessional': {'fear': 0.225, 'trust': 0.508}, 'veer': {'fear': 0.21899999999999997, 'surprise': 0.523}, 'blues': {'fear': 0.21899999999999997, 'sadness': 0.43799999999999994}, 'fingerscrossed': {'fear': 0.21899999999999997}, 'lastminute': {'fear': 0.21899999999999997}, 'aga': {'fear': 0.21899999999999997, 'trust': 0.359}, 'bait': {'fear': 0.21899999999999997, 'trust': 0.133}, 'waver': {'fear': 0.21899999999999997}, 'whatif': {'fear': 0.21899999999999997}, 'sweat': {'fear': 0.21899999999999997}, 'jungle': {'fear': 0.21899999999999997}, 'revelations': {'fear': 0.21899999999999997}, 'tactics': {'fear': 0.21899999999999997, 'trust': 0.35200000000000004}, 'immigrant': {'fear': 0.21899999999999997}, 'overtired': {'fear': 0.218}, 'hyped': {'fear': 0.214}, 'wishmeluck': {'fear': 0.212}, 'somuchtodo': {'fear': 0.212}, 'toomuchtodo': {'fear': 0.212}, 'tryouts': {'fear': 0.21}, 'clowns': {'fear': 0.207}, 'restless': {'fear': 0.204}, 'examination': {'fear': 0.204, 'surprise': 0.32}, 'phew': {'fear': 0.203}, 'help': {'fear': 0.203}, 'acceptances': {'fear': 0.203}, 'recesses': {'fear': 0.203}, 'quail': {'fear': 0.203}, 'intimacy': {'fear': 0.203}, 'overcome': {'fear': 0.203}, 'fearless': {'fear': 0.2}, 'change': {'fear': 0.198}, 'ware': {'fear': 0.198}, 'asap': {'fear': 0.191}, 'waitinggame': {'fear': 0.188}, 'rule': {'fear': 0.188, 'trust': 0.43}, 'knots': {'fear': 0.188}, 'stillness': {'fear': 0.188, 'joy': 0.203, 'sadness': 0.125}, 'deadlines': {'fear': 0.188}, 'fragile': {'fear': 0.188, 'sadness': 0.319}, 'tract': {'fear': 0.188}, 'heighten': {'fear': 0.188}, 'overcoming': {'fear': 0.188}, 'cautiously': {'fear': 0.188}, 'unorganised': {'fear': 0.188}, 'stillwaiting': {'fear': 0.184}, 'slippery': {'fear': 0.18100000000000002}, 'interview': {'fear': 0.18}, 'everyman': {'fear': 0.17800000000000002}, 'speculation': {'fear': 0.17600000000000002, 'sadness': 0.25}, 'needtoknow': {'fear': 0.17300000000000001}, 'assessment': {'fear': 0.172, 'surprise': 0.23399999999999999, 'trust': 0.594}, 'readytogo': {'fear': 0.172}, 'settlor': {'fear': 0.172}, 'surprise': {'fear': 0.172, 'joy': 0.562, 'surprise': 0.93}, 'humanrights': {'fear': 0.172}, 'regulatory': {'fear': 0.172}, 'composure': {'fear': 0.172}, 'checkpoint': {'fear': 0.172}, 'interviewer': {'fear': 0.172}, 'rod': {'fear': 0.172, 'trust': 0.32}, 'unsure': {'fear': 0.172}, 'less': {'fear': 0.16699999999999998}, 'coy': {'fear': 0.162}, 'iris': {'fear': 0.16}, 'medication': {'fear': 0.156}, 'hearing': {'fear': 0.156}, 'audition': {'fear': 0.156}, 'needit': {'fear': 0.156}, 'ceasefire': {'fear': 0.156}, 'bases': {'fear': 0.156}, 'courageous': {'fear': 0.154, 'trust': 0.633}, 'overthinker': {'fear': 0.153}, 'backtrack': {'fear': 0.151}, 'dawned': {'fear': 0.15}, 'syllabus': {'fear': 0.147}, 'bailiff': {'fear': 0.147, 'trust': 0.36700000000000005}, 'imagination': {'fear': 0.141, 'trust': 0.43799999999999994}, 'newcomer': {'fear': 0.141, 'surprise': 0.35200000000000004}, 'rationality': {'fear': 0.141}, 'caricature': {'fear': 0.141}, 'validity': {'fear': 0.141}, 'alreadyyyyy': {'fear': 0.14}, 'shy': {'fear': 0.14}, 'symptom': {'fear': 0.133}, 'raccoon': {'fear': 0.127}, 'ahhh': {'fear': 0.125}, 'soready': {'fear': 0.125}, 'needtorelax': {'fear': 0.125}, 'gameday': {'fear': 0.125}, 'prevent': {'fear': 0.125}, 'hawk': {'fear': 0.125}, 'tryout': {'fear': 0.125}, 'sprite': {'fear': 0.125}, 'sag': {'fear': 0.12300000000000001}, 'pharmacy': {'fear': 0.12300000000000001}, 'policeman': {'fear': 0.121, 'trust': 0.47700000000000004}, 'dreamt': {'fear': 0.111}, 'knot': {'fear': 0.109}, 'homework': {'fear': 0.109}, 'bigday': {'fear': 0.109}, 'slender': {'fear': 0.1}, 'sympathetic': {'fear': 0.09699999999999999, 'joy': 0.188, 'sadness': 0.307, 'trust': 0.602}, 'case': {'fear': 0.094, 'sadness': 0.228}, 'poise': {'fear': 0.094}, 'helmet': {'fear': 0.094}, 'loyal': {'fear': 0.094, 'joy': 0.485, 'surprise': 0.14800000000000002, 'trust': 0.75}, 'locate': {'fear': 0.094}, 'grades': {'fear': 0.094}, 'confident': {'fear': 0.094, 'joy': 0.531, 'trust': 0.727}, 'northeast': {'fear': 0.08800000000000001}, 'compassion': {'fear': 0.078, 'trust': 0.759}, 'graded': {'fear': 0.075}, 'mum': {'fear': 0.07}, 'cloudiness': {'fear': 0.062}, 'guidelines': {'fear': 0.062}, 'civilians': {'fear': 0.062}, 'soulmate': {'fear': 0.062}, 'civilian': {'fear': 0.062}, 'gradschool': {'fear': 0.062}, 'synonymous': {'fear': 0.055999999999999994, 'trust': 0.49200000000000005}, 'praying': {'fear': 0.047}, 'intelligence': {'fear': 0.038, 'joy': 0.47700000000000004, 'trust': 0.7190000000000001}, 'lines': {'fear': 0.031}, 'obey': {'fear': 0.016, 'trust': 0.578}, 'happiest': {'joy': 0.986}, 'bliss': {'joy': 0.971}, 'jubilant': {'joy': 0.9690000000000001, 'surprise': 0.578, 'trust': 0.49200000000000005}, 'elation': {'joy': 0.9440000000000001}, 'bestdayever': {'joy': 0.938}, 'loveee': {'joy': 0.932}, 'awesomeness': {'joy': 0.9259999999999999}, 'joy': {'joy': 0.924}, 'joyous': {'joy': 0.922}, 'happily': {'joy': 0.922}, 'exuberance': {'joy': 0.922}, 'makesmehappy': {'joy': 0.922}, 'euphoria': {'joy': 0.922}, 'fabulous': {'joy': 0.922}, 'lovee': {'joy': 0.92}, 'gratitude': {'joy': 0.914, 'trust': 0.594}, 'merriment': {'joy': 0.912, 'surprise': 0.45299999999999996}, 'happydance': {'joy': 0.912}, 'purebliss': {'joy': 0.909}, 'overjoyed': {'joy': 0.909}, 'cheerful': {'joy': 0.9059999999999999, 'surprise': 0.391}, 'lovelovelove': {'joy': 0.9059999999999999}, 'elated': {'joy': 0.894}, 'exhilaration': {'joy': 0.8909999999999999, 'surprise': 0.672}, 'peaceofmind': {'joy': 0.8909999999999999}, 'jolly': {'joy': 0.8909999999999999}, 'lovethis': {'joy': 0.8909999999999999}, 'pleasures': {'joy': 0.8909999999999999}, 'laugh': {'joy': 0.8909999999999999, 'surprise': 0.258}, 'marvelously': {'joy': 0.8809999999999999}, 'loving': {'joy': 0.879, 'trust': 0.6409999999999999}, 'blissful': {'joy': 0.879}, 'joyful': {'joy': 0.879, 'trust': 0.586}, 'outstanding': {'joy': 0.879}, 'pleasurable': {'joy': 0.877}, 'yaaaay': {'joy': 0.875}, 'happyplace': {'joy': 0.875}, 'overthemoon': {'joy': 0.875}, 'glee': {'joy': 0.875}, 'enthusiastic': {'joy': 0.875}, 'lovinglife': {'joy': 0.875}, 'iloveher': {'joy': 0.875}, 'sohappy': {'joy': 0.868}, 'laughing': {'joy': 0.8640000000000001}, 'superb': {'joy': 0.8640000000000001}, 'woohoo': {'joy': 0.8640000000000001}, 'wonderful': {'joy': 0.863, 'surprise': 0.45299999999999996, 'trust': 0.625}, 'ilovechristmas': {'joy': 0.8590000000000001}, 'cheering': {'joy': 0.8590000000000001}, 'hooray': {'joy': 0.8590000000000001}, 'loved': {'joy': 0.8590000000000001}, 'hallelujah': {'joy': 0.8590000000000001}, 'tearsofjoy': {'joy': 0.8590000000000001}, 'yayyyy': {'joy': 0.8590000000000001}, 'thrilled': {'joy': 0.851}, 'mademyday': {'joy': 0.848}, 'hohoho': {'joy': 0.845}, 'wonderfully': {'joy': 0.8440000000000001, 'surprise': 0.344}, 'favoriteholiday': {'joy': 0.8440000000000001}, 'celebrate': {'joy': 0.8440000000000001}, 'festive': {'joy': 0.833}, 'paradise': {'joy': 0.833}, 'celebrations': {'joy': 0.833}, 'sweetness': {'joy': 0.833}, 'marvellous': {'joy': 0.833}, 'blessed': {'joy': 0.833}, 'allsmiles': {'joy': 0.828}, 'love': {'joy': 0.828, 'trust': 0.758}, 'smiling': {'joy': 0.828}, 'homesweethome': {'joy': 0.826}, 'marvelous': {'joy': 0.8240000000000001, 'surprise': 0.5}, 'thankyougod': {'joy': 0.8240000000000001}, 'goodmood': {'joy': 0.8190000000000001}, 'happyheart': {'joy': 0.818}, 'joys': {'joy': 0.818}, 'sensational': {'joy': 0.818}, 'celebratory': {'joy': 0.818}, 'greatful': {'joy': 0.816}, 'jovial': {'joy': 0.8140000000000001}, 'smiley': {'joy': 0.812}, 'victorious': {'joy': 0.812}, 'greatday': {'joy': 0.812}, 'lovemaking': {'joy': 0.812, 'trust': 0.562}, 'bonanza': {'joy': 0.812}, 'excellent': {'joy': 0.812, 'trust': 0.6559999999999999}, 'splendid': {'joy': 0.812, 'surprise': 0.445}, 'glorious': {'joy': 0.812}, 'whatmakesmesmile': {'joy': 0.8109999999999999}, 'goodtimes': {'joy': 0.8109999999999999}, 'happyday': {'joy': 0.809}, 'myfavorite': {'joy': 0.804}, 'pleasure': {'joy': 0.8029999999999999}, 'yayyy': {'joy': 0.8029999999999999}, 'gladness': {'joy': 0.8029999999999999}, 'yeahhhh': {'joy': 0.8029999999999999}, 'thankyoulord': {'joy': 0.8029999999999999}, 'giggle': {'joy': 0.802}, 'happytweet': {'joy': 0.797}, 'dancing': {'joy': 0.797}, 'yesss': {'joy': 0.797}, 'lovemylife': {'joy': 0.797}, 'lovinlife': {'joy': 0.797}, 'happier': {'joy': 0.797}, 'grateful': {'joy': 0.789}, 'amuse': {'joy': 0.7879999999999999}, 'sothankful': {'joy': 0.7809999999999999}, 'solucky': {'joy': 0.7809999999999999}, 'radiant': {'joy': 0.7809999999999999}, 'enchanted': {'joy': 0.7809999999999999, 'trust': 0.516}, 'giggling': {'joy': 0.7809999999999999}, 'beautiful': {'joy': 0.7809999999999999}, 'christmassy': {'joy': 0.779}, 'heavens': {'joy': 0.779, 'trust': 0.531}, 'happyvalentinesday': {'joy': 0.773}, 'entertain': {'joy': 0.773}, 'miraculous': {'joy': 0.773, 'surprise': 0.773}, 'cheered': {'joy': 0.773}, 'positivity': {'joy': 0.773, 'trust': 0.625}, 'congrats': {'joy': 0.773}, 'cheers': {'joy': 0.773}, 'lovable': {'joy': 0.773, 'trust': 0.648}, 'funday': {'joy': 0.772}, 'thebest': {'joy': 0.7659999999999999}, 'lifeisgood': {'joy': 0.7659999999999999}, 'smiles': {'joy': 0.7659999999999999}, 'christmasspirit': {'joy': 0.7659999999999999}, 'amused': {'joy': 0.7659999999999999}, 'goodfeeling': {'joy': 0.7659999999999999}, 'sosweet': {'joy': 0.7659999999999999}, 'cuddling': {'joy': 0.7659999999999999}, 'party': {'joy': 0.765}, 'positive': {'joy': 0.7609999999999999}, 'enlighten': {'joy': 0.758, 'trust': 0.594}, 'miracles': {'joy': 0.758}, 'christmastime': {'joy': 0.757}, 'giddy': {'joy': 0.757}, 'laughs': {'joy': 0.75}, 'pleasing': {'joy': 0.75}, 'gratify': {'joy': 0.75, 'surprise': 0.305}, 'smile': {'joy': 0.75, 'surprise': 0.11699999999999999, 'trust': 0.578}, 'happyholidays': {'joy': 0.75}, 'tistheseason': {'joy': 0.75}, 'greatness': {'joy': 0.75, 'surprise': 0.49200000000000005, 'trust': 0.555}, 'friendliness': {'joy': 0.75, 'trust': 0.703}, 'frolic': {'joy': 0.748}, 'positiveenergy': {'joy': 0.742}, 'jubilee': {'joy': 0.742, 'surprise': 0.602}, 'goodvibes': {'joy': 0.742}, 'selflove': {'joy': 0.742}, 'rewarding': {'joy': 0.742}, 'feelgood': {'joy': 0.736}, 'prosperity': {'joy': 0.735}, 'admiration': {'joy': 0.7340000000000001, 'surprise': 0.32799999999999996, 'trust': 0.703}, 'feelinggood': {'joy': 0.7340000000000001}, 'tgif': {'joy': 0.7340000000000001}, 'goodday': {'joy': 0.7340000000000001}, 'greatnight': {'joy': 0.7340000000000001}, 'behappy': {'joy': 0.7340000000000001}, 'vivacious': {'joy': 0.7340000000000001}, 'luxurious': {'joy': 0.7340000000000001}, 'glorification': {'joy': 0.733}, 'glowing': {'joy': 0.7290000000000001}, 'yessss': {'joy': 0.728}, 'breathtaking': {'joy': 0.728}, 'hurrah': {'joy': 0.727}, 'merry': {'joy': 0.727}, 'thankful': {'joy': 0.727}, 'win': {'joy': 0.727}, 'christmasbreak': {'joy': 0.727}, 'atpeace': {'joy': 0.727}, 'santa': {'joy': 0.727}, 'pleased': {'joy': 0.725}, 'optimistic': {'joy': 0.723}, 'holidays': {'joy': 0.721}, 'heaven': {'joy': 0.721}, 'lucky': {'joy': 0.721, 'surprise': 0.539}, 'godisgreat': {'joy': 0.721}, 'praising': {'joy': 0.7190000000000001}, 'heartfelt': {'joy': 0.7190000000000001, 'sadness': 0.188, 'trust': 0.7340000000000001}, 'congratulatory': {'joy': 0.7190000000000001}, 'brighten': {'joy': 0.7190000000000001, 'surprise': 0.43799999999999994, 'trust': 0.602}, 'amusement': {'joy': 0.7190000000000001}, 'harmony': {'joy': 0.7190000000000001, 'trust': 0.648}, 'xmas': {'joy': 0.7190000000000001}, 'bestfeeling': {'joy': 0.7120000000000001}, 'luxury': {'joy': 0.7120000000000001, 'trust': 0.406}, 'merrychristmas': {'joy': 0.7120000000000001}, 'treasures': {'joy': 0.7120000000000001}, 'luckiest': {'joy': 0.7120000000000001}, 'yay': {'joy': 0.7120000000000001}, 'magic': {'joy': 0.7120000000000001}, 'soblessed': {'joy': 0.706}, 'yaaay': {'joy': 0.706}, 'goodlife': {'joy': 0.703}, 'lovelife': {'joy': 0.703}, 'sweetest': {'joy': 0.703}, 'appreciates': {'joy': 0.703}, 'satisfying': {'joy': 0.703}, 'amazingly': {'joy': 0.703, 'surprise': 0.648}, 'goodnews': {'joy': 0.703}, 'beautification': {'joy': 0.703, 'trust': 0.508}, 'gooood': {'joy': 0.703}, 'truelove': {'joy': 0.703}, 'fuckyeah': {'joy': 0.703}, 'cuddled': {'joy': 0.703}, 'entertained': {'joy': 0.7}, 'yaay': {'joy': 0.7}, 'newbeginnings': {'joy': 0.693}, 'praisejesus': {'joy': 0.691}, 'honored': {'joy': 0.688, 'trust': 0.7190000000000001}, 'favorite': {'joy': 0.688, 'trust': 0.484}, 'adoration': {'joy': 0.688, 'trust': 0.523}, 'metime': {'joy': 0.688}, 'greatfriends': {'joy': 0.688}, 'holidayseason': {'joy': 0.688}, 'angelic': {'joy': 0.688, 'trust': 0.586}, 'godsend': {'joy': 0.688, 'surprise': 0.578}, 'content': {'joy': 0.688, 'trust': 0.562}, 'exquisite': {'joy': 0.688}, 'thankyoujesus': {'joy': 0.688}, 'exaltation': {'joy': 0.682, 'trust': 0.445}, 'brightens': {'joy': 0.682}, 'appreciated': {'joy': 0.682}, 'smiled': {'joy': 0.682}, 'bestfriends': {'joy': 0.682}, 'goodhealth': {'joy': 0.682}, 'memoriesiwontforget': {'joy': 0.682}, 'tranquility': {'joy': 0.679, 'trust': 0.594}, 'positively': {'joy': 0.6759999999999999}, 'hug': {'joy': 0.672, 'sadness': 0.078, 'trust': 0.523}, 'dearest': {'joy': 0.672}, 'giggles': {'joy': 0.672}, 'relaxation': {'joy': 0.672}, 'accomplished': {'joy': 0.672}, 'enliven': {'joy': 0.672, 'surprise': 0.5, 'trust': 0.445}, 'weeeee': {'joy': 0.672}, 'contentment': {'joy': 0.672}, 'bday': {'joy': 0.672}, 'hilarious': {'joy': 0.672, 'surprise': 0.461}, 'fulfilled': {'joy': 0.667, 'trust': 0.703}, 'victor': {'joy': 0.667}, 'fulfill': {'joy': 0.664, 'trust': 0.602}, 'cuddles': {'joy': 0.662}, 'prosperous': {'joy': 0.66}, 'satisfy': {'joy': 0.6559999999999999}, 'happynewyear': {'joy': 0.6559999999999999}, 'encouraged': {'joy': 0.6559999999999999}, 'innerpeace': {'joy': 0.6559999999999999}, 'christmaseve': {'joy': 0.6559999999999999}, 'appreciation': {'joy': 0.6559999999999999, 'trust': 0.617}, 'humor': {'joy': 0.6559999999999999}, 'romanticism': {'joy': 0.6559999999999999}, 'besties': {'joy': 0.6559999999999999}, 'praised': {'joy': 0.652, 'trust': 0.594}, 'fortunes': {'joy': 0.652}, 'relaxing': {'joy': 0.652}, 'satisfaction': {'joy': 0.652}, 'praises': {'joy': 0.652}, 'affection': {'joy': 0.647, 'trust': 0.484}, 'nothingbetter': {'joy': 0.647}, 'relieved': {'joy': 0.647}, 'carnival': {'joy': 0.643}, 'uplifting': {'joy': 0.6409999999999999}, 'wedding': {'joy': 0.6409999999999999}, 'divine': {'joy': 0.6409999999999999}, 'harmoniously': {'joy': 0.6409999999999999, 'trust': 0.672}, 'priceless': {'joy': 0.6409999999999999}, 'achieve': {'joy': 0.6409999999999999, 'trust': 0.6559999999999999}, 'thanksgiving': {'joy': 0.6409999999999999}, 'comforting': {'joy': 0.636}, 'cuddle': {'joy': 0.636, 'trust': 0.57}, 'reverie': {'joy': 0.636, 'trust': 0.516}, 'yayy': {'joy': 0.636}, 'felicity': {'joy': 0.636}, 'xoxo': {'joy': 0.634}, 'stargazing': {'joy': 0.625}, 'praisegod': {'joy': 0.625}, 'fondness': {'joy': 0.625}, 'gorgeous': {'joy': 0.625}, 'amusing': {'joy': 0.625}, 'hearts': {'joy': 0.625}, 'snuggling': {'joy': 0.625}, 'brighter': {'joy': 0.625}, 'beauty': {'joy': 0.621}, 'kind': {'joy': 0.621, 'trust': 0.6409999999999999}, 'applause': {'joy': 0.621, 'surprise': 0.406, 'trust': 0.539}, 'genial': {'joy': 0.621}, 'newlife': {'joy': 0.618}, 'fulfilling': {'joy': 0.618}, 'godbless': {'joy': 0.616}, 'virtuous': {'joy': 0.613, 'trust': 0.7190000000000001}, 'adorable': {'joy': 0.609}, 'awards': {'joy': 0.609}, 'super': {'joy': 0.609}, 'enlightenment': {'joy': 0.609, 'trust': 0.602}, 'rainbows': {'joy': 0.609}, 'generous': {'joy': 0.609, 'trust': 0.594}, 'christmas': {'joy': 0.609}, 'wonder': {'joy': 0.606, 'surprise': 0.523}, 'surprises': {'joy': 0.606}, 'onelove': {'joy': 0.606}, 'freely': {'joy': 0.606, 'trust': 0.516}, 'hilarity': {'joy': 0.606}, 'heheh': {'joy': 0.606}, 'inspired': {'joy': 0.606, 'surprise': 0.406, 'trust': 0.602}, 'kindness': {'joy': 0.606}, 'whimsical': {'joy': 0.603}, 'beautify': {'joy': 0.601}, 'stressfree': {'joy': 0.601}, 'sunrise': {'joy': 0.6}, 'godisgood': {'joy': 0.597}, 'goodmusic': {'joy': 0.594}, 'whoo': {'joy': 0.594}, 'snuggled': {'joy': 0.594}, 'goodies': {'joy': 0.594}, 'thankgod': {'joy': 0.594}, 'accomplishment': {'joy': 0.594}, 'peacefully': {'joy': 0.594}, 'jesus': {'joy': 0.594}, 'friendship': {'joy': 0.591, 'trust': 0.727}, 'heroic': {'joy': 0.591, 'surprise': 0.5, 'trust': 0.664}, 'singing': {'joy': 0.591}, 'exalted': {'joy': 0.591, 'trust': 0.539}, 'summer': {'joy': 0.591}, 'overflowing': {'joy': 0.588}, 'woot': {'joy': 0.588}, 'rollicking': {'joy': 0.588}, 'contented': {'joy': 0.588}, 'cozy': {'joy': 0.583}, 'delicious': {'joy': 0.579}, 'darling': {'joy': 0.578, 'trust': 0.5}, 'praise': {'joy': 0.578, 'trust': 0.609}, 'picturesque': {'joy': 0.578}, 'sensuous': {'joy': 0.578}, 'everlasting': {'joy': 0.578, 'trust': 0.57}, 'thelife': {'joy': 0.578}, 'luckygirl': {'joy': 0.5760000000000001}, 'flattering': {'joy': 0.5760000000000001}, 'grace': {'joy': 0.5760000000000001}, 'yeahhh': {'joy': 0.5760000000000001}, 'livelife': {'joy': 0.574}, 'special': {'joy': 0.574}, 'pumped': {'joy': 0.5670000000000001}, 'admirable': {'joy': 0.562, 'trust': 0.7340000000000001}, 'relax': {'joy': 0.562}, 'superstar': {'joy': 0.562, 'trust': 0.36700000000000005}, 'yey': {'joy': 0.562}, 'revels': {'joy': 0.562}, 'worthwhile': {'joy': 0.562}, 'humorous': {'joy': 0.562}, 'liking': {'joy': 0.562, 'trust': 0.609}, 'hugs': {'joy': 0.562}, 'freedom': {'joy': 0.561, 'trust': 0.742}, 'tenderness': {'joy': 0.561}, 'newyear': {'joy': 0.561}, 'masterpiece': {'joy': 0.561}, 'dreams': {'joy': 0.5589999999999999}, 'home': {'joy': 0.5589999999999999}, 'cruising': {'joy': 0.556}, 'gracias': {'joy': 0.5539999999999999}, 'faithfulness': {'joy': 0.5529999999999999}, 'closeness': {'joy': 0.552, 'trust': 0.7190000000000001}, 'sunshine': {'joy': 0.551}, 'comfy': {'joy': 0.551}, 'gifts': {'joy': 0.547}, 'mistletoe': {'joy': 0.547}, 'astonishment': {'joy': 0.547, 'surprise': 0.805}, 'goodmorning': {'joy': 0.547}, 'daughter': {'joy': 0.547}, 'heart': {'joy': 0.547}, 'lifted': {'joy': 0.547}, 'charmed': {'joy': 0.546}, 'dance': {'joy': 0.545, 'trust': 0.359}, 'sublime': {'joy': 0.545}, 'encouragement': {'joy': 0.545}, 'freshstart': {'joy': 0.544}, 'free': {'joy': 0.544}, 'savior': {'joy': 0.5429999999999999}, 'wellness': {'joy': 0.537}, 'revel': {'joy': 0.534}, 'music': {'joy': 0.531, 'sadness': 0.016}, 'vitality': {'joy': 0.531, 'trust': 0.562}, 'rainbow': {'joy': 0.531}, 'serene': {'joy': 0.531, 'trust': 0.586}, 'inspirational': {'joy': 0.531}, 'soar': {'joy': 0.531}, 'soothing': {'joy': 0.531, 'trust': 0.562}, 'dayoff': {'joy': 0.531}, 'fab': {'joy': 0.531}, 'welcomed': {'joy': 0.53}, 'illumination': {'joy': 0.53, 'surprise': 0.47700000000000004, 'trust': 0.555}, 'warmth': {'joy': 0.53}, 'elegant': {'joy': 0.53}, 'blossom': {'joy': 0.53}, 'faithful': {'joy': 0.529, 'trust': 0.797}, 'snuggles': {'joy': 0.522}, 'laurels': {'joy': 0.521}, 'commendable': {'joy': 0.519, 'trust': 0.68}, 'silly': {'joy': 0.516}, 'remarkable': {'joy': 0.516, 'surprise': 0.5, 'trust': 0.562}, 'jingle': {'joy': 0.516}, 'noschool': {'joy': 0.516}, 'pride': {'joy': 0.516}, 'almighty': {'joy': 0.516}, 'resplendent': {'joy': 0.516}, 'abundant': {'joy': 0.516}, 'presents': {'joy': 0.516}, 'greeted': {'joy': 0.516}, 'strengthening': {'joy': 0.516, 'trust': 0.6609999999999999}, 'payday': {'joy': 0.515}, 'reunited': {'joy': 0.515}, 'spirit': {'joy': 0.515}, 'coronation': {'joy': 0.515, 'trust': 0.523}, 'complete': {'joy': 0.515}, 'newme': {'joy': 0.515}, 'animated': {'joy': 0.515}, 'therapeutic': {'joy': 0.515, 'trust': 0.633}, 'kid': {'joy': 0.515}, 'kudos': {'joy': 0.515, 'trust': 0.414}, 'zen': {'joy': 0.515}, 'vivid': {'joy': 0.515}, 'cutie': {'joy': 0.515}, 'thanking': {'joy': 0.515}, 'familytime': {'joy': 0.515}, 'godly': {'joy': 0.514, 'trust': 0.586}, 'relationship': {'joy': 0.514, 'trust': 0.6559999999999999}, 'daymade': {'joy': 0.514}, 'spouse': {'joy': 0.507, 'trust': 0.594}, 'nature': {'joy': 0.5}, 'holyspirit': {'joy': 0.5}, 'meritorious': {'joy': 0.5, 'trust': 0.586}, 'soulful': {'joy': 0.5}, 'refreshed': {'joy': 0.5}, 'motherhood': {'joy': 0.5, 'trust': 0.703}, 'family': {'joy': 0.5}, 'stressrelief': {'joy': 0.5}, 'achieved': {'joy': 0.5}, 'diamond': {'joy': 0.5}, 'teamjesus': {'joy': 0.5}, 'satisfied': {'joy': 0.5}, 'memorable': {'joy': 0.5, 'surprise': 0.336, 'trust': 0.539}, 'encourage': {'joy': 0.5, 'trust': 0.625}, 'gem': {'joy': 0.5}, 'baby': {'joy': 0.5}, 'dignity': {'joy': 0.5, 'trust': 0.672}, 'welcoming': {'joy': 0.5}, 'healthy': {'joy': 0.5}, 'beach': {'joy': 0.5}, 'christ': {'joy': 0.5}, 'accomplish': {'joy': 0.5}, 'carefree': {'joy': 0.5}, 'friends': {'joy': 0.5}, 'purr': {'joy': 0.5, 'trust': 0.344}, 'surreal': {'joy': 0.5}, 'health': {'joy': 0.493}, 'aura': {'joy': 0.493}, 'approved': {'joy': 0.486, 'trust': 0.633}, 'yehey': {'joy': 0.486}, 'prestige': {'joy': 0.485, 'trust': 0.586}, 'inseparable': {'joy': 0.485, 'trust': 0.531}, 'privileged': {'joy': 0.485, 'trust': 0.359}, 'gentle': {'joy': 0.485}, 'engaging': {'joy': 0.485, 'trust': 0.547}, 'nocomplaints': {'joy': 0.485}, 'selfworth': {'joy': 0.484}, 'desire': {'joy': 0.484}, 'yummy': {'joy': 0.484}, 'datenight': {'joy': 0.484}, 'creativity': {'joy': 0.484}, 'bouquet': {'joy': 0.484, 'trust': 0.375}, 'dream': {'joy': 0.484}, 'boyfriend': {'joy': 0.48}, 'friend': {'joy': 0.47100000000000003, 'trust': 0.75}, 'calming': {'joy': 0.47}, 'massage': {'joy': 0.47}, 'nostalgia': {'joy': 0.47, 'sadness': 0.312}, 'kiddo': {'joy': 0.47}, 'soothe': {'joy': 0.47}, 'luster': {'joy': 0.469}, 'eternal': {'joy': 0.469}, 'purring': {'joy': 0.469}, 'heartily': {'joy': 0.469}, 'bonding': {'joy': 0.469}, 'princess': {'joy': 0.469}, 'rest': {'joy': 0.469}, 'benevolence': {'joy': 0.469, 'trust': 0.672}, 'goals': {'joy': 0.469}, 'amicable': {'joy': 0.469}, 'giving': {'joy': 0.469}, 'getaway': {'joy': 0.469}, 'salutary': {'joy': 0.465, 'trust': 0.523}, 'beam': {'joy': 0.456}, 'reminiscing': {'joy': 0.456}, 'friday': {'joy': 0.455}, 'aesthetics': {'joy': 0.455}, 'hee': {'joy': 0.455}, 'ceremony': {'joy': 0.455, 'surprise': 0.297}, 'scholarship': {'joy': 0.455}, 'befriend': {'joy': 0.455, 'trust': 0.594}, 'mindfulness': {'joy': 0.455}, 'freshair': {'joy': 0.455}, 'tropical': {'joy': 0.455}, 'sonice': {'joy': 0.455}, 'noworries': {'joy': 0.45299999999999996}, 'namaste': {'joy': 0.45299999999999996}, 'forgiveness': {'joy': 0.45299999999999996}, 'waterfall': {'joy': 0.45299999999999996}, 'approve': {'joy': 0.45299999999999996, 'trust': 0.68}, 'scenery': {'joy': 0.45299999999999996}, 'meditation': {'joy': 0.446}, 'relaxed': {'joy': 0.442}, 'tender': {'joy': 0.441, 'trust': 0.516}, 'weekend': {'joy': 0.441}, 'tranquil': {'joy': 0.441}, 'sharing': {'joy': 0.439}, 'lyrical': {'joy': 0.439}, 'righteousness': {'joy': 0.439}, 'esteem': {'joy': 0.439, 'sadness': 0.172, 'trust': 0.688}, 'prayer': {'joy': 0.439}, 'nostalgic': {'joy': 0.439}, 'relief': {'joy': 0.43799999999999994}, 'life': {'joy': 0.43799999999999994}, 'husband': {'joy': 0.43799999999999994}, 'strength': {'joy': 0.43799999999999994, 'trust': 0.6559999999999999}, 'newday': {'joy': 0.43799999999999994}, 'sonnet': {'joy': 0.43799999999999994, 'sadness': 0.094}, 'warm': {'joy': 0.429}, 'winterbreak': {'joy': 0.429}, 'movingforward': {'joy': 0.429}, 'oneness': {'joy': 0.426}, 'reverence': {'joy': 0.424, 'trust': 0.703}, 'thelittlethings': {'joy': 0.424}, 'carols': {'joy': 0.424}, 'amen': {'joy': 0.424, 'trust': 0.516}, 'healthful': {'joy': 0.424}, 'unconstrained': {'joy': 0.424}, 'candlelight': {'joy': 0.424}, 'calmness': {'joy': 0.42200000000000004}, 'lml': {'joy': 0.42200000000000004}, 'helpful': {'joy': 0.42200000000000004, 'trust': 0.602}, 'ease': {'joy': 0.42200000000000004}, 'energy': {'joy': 0.42200000000000004}, 'safe': {'joy': 0.42200000000000004, 'trust': 0.672}, 'sledding': {'joy': 0.42200000000000004}, 'wealth': {'joy': 0.42200000000000004, 'trust': 0.43}, 'beginnings': {'joy': 0.42200000000000004}, 'nostress': {'joy': 0.42100000000000004}, 'promise': {'joy': 0.415, 'trust': 0.773}, 'reunite': {'joy': 0.414}, 'poems': {'joy': 0.41200000000000003}, 'lighten': {'joy': 0.409}, 'lavender': {'joy': 0.409}, 'aromatherapy': {'joy': 0.409}, 'travel': {'joy': 0.409, 'trust': 0.42200000000000004}, 'purify': {'joy': 0.409, 'trust': 0.625}, 'immaculate': {'joy': 0.409, 'trust': 0.57}, 'charity': {'joy': 0.406}, 'wishing': {'joy': 0.406}, 'heal': {'joy': 0.406, 'trust': 0.609}, 'live': {'joy': 0.406}, 'companion': {'joy': 0.406, 'trust': 0.75}, 'flowers': {'joy': 0.406}, 'opportune': {'joy': 0.406}, 'soul': {'joy': 0.401}, 'munchies': {'joy': 0.4}, 'christian': {'joy': 0.397}, 'indescribable': {'joy': 0.397, 'surprise': 0.6409999999999999}, 'calm': {'joy': 0.39399999999999996}, 'hammock': {'joy': 0.39399999999999996}, 'rhythmical': {'joy': 0.39399999999999996, 'surprise': 0.23399999999999999}, 'equality': {'joy': 0.39399999999999996, 'trust': 0.727}, 'together': {'joy': 0.39399999999999996}, 'childhood': {'joy': 0.39399999999999996}, 'fullness': {'joy': 0.39399999999999996}, 'zealous': {'joy': 0.39299999999999996, 'trust': 0.258}, 'movies': {'joy': 0.39299999999999996}, 'humanity': {'joy': 0.391, 'trust': 0.688}, 'affluence': {'joy': 0.391}, 'meaningful': {'joy': 0.391}, 'adventures': {'joy': 0.391}, 'choir': {'joy': 0.391, 'trust': 0.414}, 'warms': {'joy': 0.391}, 'littlethings': {'joy': 0.391}, 'goofy': {'joy': 0.391}, 'gesture': {'joy': 0.387}, 'witty': {'joy': 0.382}, 'communion': {'joy': 0.379, 'trust': 0.578}, 'vibes': {'joy': 0.379}, 'jump': {'joy': 0.379}, 'reverend': {'joy': 0.377}, 'experience': {'joy': 0.375}, 'full': {'joy': 0.375}, 'redeemed': {'joy': 0.375}, 'simplicity': {'joy': 0.375}, 'scenic': {'joy': 0.375}, 'beaches': {'joy': 0.375}, 'sonorous': {'joy': 0.375}, 'mirth': {'joy': 0.375}, 'unique': {'joy': 0.375, 'surprise': 0.43799999999999994}, 'unforgettable': {'joy': 0.375}, 'baptismal': {'joy': 0.368}, 'alliance': {'joy': 0.368, 'trust': 0.727}, 'moonlight': {'joy': 0.364}, 'conciliation': {'joy': 0.364, 'trust': 0.547}, 'pure': {'joy': 0.364}, 'sanctification': {'joy': 0.364, 'trust': 0.633}, 'authentic': {'joy': 0.364, 'trust': 0.75}, 'kitten': {'joy': 0.364, 'trust': 0.461}, 'improves': {'joy': 0.364}, 'weightloss': {'joy': 0.36200000000000004}, 'raspberries': {'joy': 0.36}, 'listenting': {'joy': 0.359}, 'fidelity': {'joy': 0.359, 'trust': 0.633}, 'jest': {'joy': 0.359, 'surprise': 0.531}, 'tinsel': {'joy': 0.359}, 'independent': {'joy': 0.359}, 'devotional': {'joy': 0.359, 'trust': 0.633}, 'giver': {'joy': 0.353}, 'cocoa': {'joy': 0.353}, 'romp': {'joy': 0.348}, 'melody': {'joy': 0.348}, 'choral': {'joy': 0.348}, 'dolphin': {'joy': 0.348, 'surprise': 0.11699999999999999, 'trust': 0.36700000000000005}, 'favor': {'joy': 0.348}, 'roaring': {'joy': 0.348}, 'purpose': {'joy': 0.348}, 'hotyoga': {'joy': 0.34700000000000003}, 'thx': {'joy': 0.344}, 'roadtrip': {'joy': 0.344}, 'kiddos': {'joy': 0.344}, 'manicure': {'joy': 0.344}, 'newstart': {'joy': 0.344}, 'date': {'joy': 0.344}, 'hedonism': {'joy': 0.344}, 'pledge': {'joy': 0.344, 'trust': 0.688}, 'cookies': {'joy': 0.344}, 'fruits': {'joy': 0.344}, 'electric': {'joy': 0.344, 'surprise': 0.578}, 'nowork': {'joy': 0.344}, 'rhythm': {'joy': 0.33799999999999997}, 'bridesmaid': {'joy': 0.33799999999999997, 'trust': 0.469}, 'gazing': {'joy': 0.33299999999999996}, 'snowday': {'joy': 0.33299999999999996}, 'connoisseur': {'joy': 0.33299999999999996, 'trust': 0.523}, 'partner': {'joy': 0.33299999999999996}, 'coffee': {'joy': 0.33299999999999996}, 'garden': {'joy': 0.33299999999999996}, 'foodie': {'joy': 0.331}, 'pedicure': {'joy': 0.32799999999999996}, 'noregrets': {'joy': 0.32799999999999996}, 'hobby': {'joy': 0.32799999999999996}, 'amnesty': {'joy': 0.32799999999999996}, 'true': {'joy': 0.32799999999999996, 'trust': 0.789}, 'chirping': {'joy': 0.32799999999999996}, 'psalm': {'joy': 0.32799999999999996, 'trust': 0.49200000000000005}, 'carol': {'joy': 0.32799999999999996, 'trust': 0.336}, 'respite': {'joy': 0.324, 'trust': 0.42200000000000004}, 'cousins': {'joy': 0.318}, 'mellow': {'joy': 0.318}, 'lazyday': {'joy': 0.318}, 'classics': {'joy': 0.318}, 'pony': {'joy': 0.312}, 'muchneeded': {'joy': 0.312}, 'recovery': {'joy': 0.312, 'trust': 0.539}, 'presto': {'joy': 0.312, 'surprise': 0.633}, 'fitness': {'joy': 0.312}, 'relight': {'joy': 0.312}, 'crafts': {'joy': 0.312}, 'woods': {'joy': 0.312}, 'playhouse': {'joy': 0.312}, 'wisdom': {'joy': 0.312, 'trust': 0.789}, 'superman': {'joy': 0.312, 'trust': 0.5}, 'living': {'joy': 0.312}, 'improvement': {'joy': 0.309, 'trust': 0.523}, 'absolution': {'joy': 0.306, 'trust': 0.617}, 'established': {'joy': 0.303}, 'decorating': {'joy': 0.303}, 'gently': {'joy': 0.303}, 'breeze': {'joy': 0.297}, 'joker': {'joy': 0.297, 'surprise': 0.36700000000000005}, 'spending': {'joy': 0.297}, 'notable': {'joy': 0.297, 'trust': 0.523}, 'mine': {'joy': 0.297}, 'meditating': {'joy': 0.297}, 'light': {'joy': 0.297}, 'fraternal': {'joy': 0.297, 'trust': 0.531}, 'softly': {'joy': 0.297}, 'spiritual': {'joy': 0.297, 'trust': 0.664}, 'growth': {'joy': 0.297}, 'strolling': {'joy': 0.297}, 'lounging': {'joy': 0.297}, 'quaint': {'joy': 0.297, 'trust': 0.39799999999999996}, 'quotes': {'joy': 0.294}, 'hippie': {'joy': 0.28800000000000003}, 'psalms': {'joy': 0.28800000000000003, 'trust': 0.539}, 'create': {'joy': 0.28800000000000003}, 'resources': {'joy': 0.28800000000000003, 'trust': 0.43}, 'taoism': {'joy': 0.28800000000000003}, 'ocean': {'joy': 0.28600000000000003}, 'lsd': {'joy': 0.28600000000000003}, 'snowfall': {'joy': 0.28600000000000003}, 'hiking': {'joy': 0.28300000000000003}, 'truce': {'joy': 0.281, 'trust': 0.617}, 'toast': {'joy': 0.281}, 'evergreen': {'joy': 0.281, 'trust': 0.531}, 'buzzing': {'joy': 0.281}, 'buddhist': {'joy': 0.281}, 'unwind': {'joy': 0.281}, 'chill': {'joy': 0.281}, 'rested': {'joy': 0.281}, 'balance': {'joy': 0.275}, 'fireplace': {'joy': 0.273}, 'drinks': {'joy': 0.273}, 'buddha': {'joy': 0.273}, 'rapt': {'joy': 0.273, 'surprise': 0.43799999999999994, 'trust': 0.414}, 'snowing': {'joy': 0.271}, 'sublimation': {'joy': 0.27}, 'fruity': {'joy': 0.268}, 'sunday': {'joy': 0.266}, 'humility': {'joy': 0.266, 'trust': 0.602}, 'salute': {'joy': 0.266, 'trust': 0.49200000000000005}, 'sketching': {'joy': 0.266}, 'fortitude': {'joy': 0.266, 'trust': 0.633}, 'waves': {'joy': 0.266}, 'cathedral': {'joy': 0.266, 'trust': 0.455}, 'buddhism': {'joy': 0.266}, 'yoga': {'joy': 0.266}, 'ministry': {'joy': 0.266, 'trust': 0.594}, 'artwork': {'joy': 0.265}, 'practiced': {'joy': 0.264, 'surprise': 0.156, 'trust': 0.633}, 'clean': {'joy': 0.26, 'trust': 0.484}, 'food': {'joy': 0.258, 'trust': 0.336}, 'exercise': {'joy': 0.258}, 'found': {'joy': 0.258, 'trust': 0.484}, 'clarity': {'joy': 0.258}, 'running': {'joy': 0.258}, 'autumn': {'joy': 0.254}, 'demonstrative': {'joy': 0.25, 'sadness': 0.242}, 'fit': {'joy': 0.25}, 'chirp': {'joy': 0.25}, 'countryside': {'joy': 0.25}, 'diary': {'joy': 0.25, 'trust': 0.42200000000000004}, 'expedient': {'joy': 0.25, 'trust': 0.531}, 'hardy': {'joy': 0.25, 'trust': 0.49200000000000005}, 'chilled': {'joy': 0.25}, 'morning': {'joy': 0.25}, 'outdoors': {'joy': 0.25}, 'candles': {'joy': 0.25}, 'trance': {'joy': 0.24600000000000002}, 'procession': {'joy': 0.242, 'sadness': 0.152, 'surprise': 0.22699999999999998}, 'breakfast': {'joy': 0.242}, 'skiing': {'joy': 0.23399999999999999}, 'lyre': {'joy': 0.23399999999999999}, 'lifetime': {'joy': 0.23399999999999999}, 'snowy': {'joy': 0.23399999999999999}, 'candle': {'joy': 0.23399999999999999}, 'humbled': {'joy': 0.23399999999999999, 'sadness': 0.273}, 'nursery': {'joy': 0.23399999999999999, 'trust': 0.47700000000000004}, 'doll': {'joy': 0.23399999999999999}, 'pastry': {'joy': 0.22899999999999998}, 'firefly': {'joy': 0.22699999999999998}, 'chilling': {'joy': 0.22699999999999998}, 'camping': {'joy': 0.221}, 'orchard': {'joy': 0.221}, 'lamb': {'joy': 0.21899999999999997, 'trust': 0.47700000000000004}, 'gardens': {'joy': 0.21899999999999997}, 'castle': {'joy': 0.21899999999999997}, 'breezy': {'joy': 0.21899999999999997}, 'raindrops': {'joy': 0.212}, 'countrymusic': {'joy': 0.212}, 'bouttime': {'joy': 0.212}, 'listneing': {'joy': 0.212}, 'brisk': {'joy': 0.212}, 'teach': {'joy': 0.212, 'surprise': 0.125, 'trust': 0.617}, 'pho': {'joy': 0.212}, 'reggae': {'joy': 0.212}, 'mucis': {'joy': 0.212}, 'nap': {'joy': 0.20600000000000002}, 'vernal': {'joy': 0.203}, 'lights': {'joy': 0.203}, 'save': {'joy': 0.2, 'trust': 0.562}, 'pastor': {'joy': 0.19699999999999998, 'trust': 0.47700000000000004}, 'oneday': {'joy': 0.19699999999999998}, 'trees': {'joy': 0.19699999999999998}, 'symmetry': {'joy': 0.19699999999999998, 'trust': 0.602}, 'scripture': {'joy': 0.196, 'trust': 0.609}, 'mountains': {'joy': 0.19399999999999998}, 'craziness': {'joy': 0.188}, 'walking': {'joy': 0.188}, 'whiteness': {'joy': 0.188}, 'custom': {'joy': 0.188}, 'forefathers': {'joy': 0.188, 'trust': 0.539}, 'soppy': {'joy': 0.188}, 'quiet': {'joy': 0.188, 'sadness': 0.094}, 'tea': {'joy': 0.188}, 'pathway': {'joy': 0.188}, 'bath': {'joy': 0.182}, 'movingon': {'joy': 0.182}, 'dollhouse': {'joy': 0.182}, 'supporter': {'joy': 0.18, 'trust': 0.7340000000000001}, 'pursuit': {'joy': 0.17600000000000002}, 'frosty': {'joy': 0.174}, 'wintery': {'joy': 0.172}, 'workout': {'joy': 0.172}, 'luncheon': {'joy': 0.172}, 'service': {'joy': 0.172}, 'civilized': {'joy': 0.16899999999999998, 'trust': 0.625}, 'wages': {'joy': 0.16899999999999998}, 'december': {'joy': 0.16699999999999998}, 'bathtub': {'joy': 0.156}, 'stroll': {'joy': 0.156}, 'chai': {'joy': 0.156}, 'break': {'joy': 0.156, 'surprise': 0.461}, 'reproductive': {'joy': 0.156}, 'obtainable': {'joy': 0.156}, 'peppermint': {'joy': 0.156}, 'measured': {'joy': 0.152, 'trust': 0.57}, 'scifi': {'joy': 0.152}, 'spaniel': {'joy': 0.145, 'trust': 0.312}, 'ditty': {'joy': 0.141}, 'oils': {'joy': 0.141}, 'bubble': {'joy': 0.141}, 'tan': {'joy': 0.141}, 'simple': {'joy': 0.141}, 'beer': {'joy': 0.141}, 'green': {'joy': 0.13699999999999998, 'trust': 0.359}, 'books': {'joy': 0.136}, 'buss': {'joy': 0.136}, 'makingdisciples': {'joy': 0.136}, 'chow': {'joy': 0.135}, 'pitter': {'joy': 0.134}, 'flows': {'joy': 0.13}, 'silence': {'joy': 0.127}, 'wine': {'joy': 0.125}, 'circumstances': {'joy': 0.125, 'trust': 0.359}, 'solitude': {'joy': 0.125}, 'bookstore': {'joy': 0.125}, 'roadster': {'joy': 0.125, 'trust': 0.359}, 'japan': {'joy': 0.121}, 'soak': {'joy': 0.121}, 'critical': {'joy': 0.11599999999999999}, 'untie': {'joy': 0.109}, 'sand': {'joy': 0.109}, 'wind': {'joy': 0.109}, 'classical': {'joy': 0.106}, 'lake': {'joy': 0.10300000000000001}, 'dwelling': {'joy': 0.094}, 'pond': {'joy': 0.08900000000000001}, 'latte': {'joy': 0.078}, 'marrow': {'joy': 0.078, 'trust': 0.36700000000000005}, 'sipping': {'joy': 0.076}, 'benign': {'joy': 0.07400000000000001}, 'majority': {'joy': 0.073, 'trust': 0.539}, 'leaf': {'joy': 0.065}, 'troubles': {'joy': 0.062}, 'explosions': {'joy': 0.061}, 'shepherd': {'joy': 0.057999999999999996, 'trust': 0.508}, 'tuesday': {'joy': 0.047}, 'calf': {'joy': 0.04, 'trust': 0.289}, 'hardship': {'joy': 0.031, 'sadness': 0.685}, 'unhappiness': {'joy': 0.016, 'sadness': 0.8390000000000001}, 'sixty': {'joy': 0.016}, 'heartbreaking': {'sadness': 0.9690000000000001}, 'mourning': {'sadness': 0.9690000000000001}, 'tragic': {'sadness': 0.961}, 'bereavement': {'sadness': 0.922}, 'grieving': {'sadness': 0.922}, 'bereaved': {'sadness': 0.92}, 'devastated': {'sadness': 0.912}, 'died': {'sadness': 0.9059999999999999}, 'weeping': {'sadness': 0.8959999999999999}, 'stillbirth': {'sadness': 0.8909999999999999}, 'deceased': {'sadness': 0.8909999999999999}, 'sadness': {'sadness': 0.8640000000000001, 'trust': 0.25}, 'grief': {'sadness': 0.8590000000000001}, 'betrayed': {'sadness': 0.848}, 'funeral': {'sadness': 0.8440000000000001}, 'sad': {'sadness': 0.8440000000000001}, 'crippled': {'sadness': 0.836}, 'stillborn': {'sadness': 0.83}, 'morbid': {'sadness': 0.828}, 'mourn': {'sadness': 0.828}, 'sadly': {'sadness': 0.812}, 'childloss': {'sadness': 0.812}, 'distraught': {'sadness': 0.812}, 'saddens': {'sadness': 0.812}, 'famine': {'sadness': 0.812}, 'heartache': {'sadness': 0.812}, 'inhumanity': {'sadness': 0.804}, 'perished': {'sadness': 0.797}, 'brokenheart': {'sadness': 0.792}, 'disheartened': {'sadness': 0.7879999999999999}, 'heartbreak': {'sadness': 0.7809999999999999}, 'crying': {'sadness': 0.7809999999999999}, 'bury': {'sadness': 0.7809999999999999}, 'condolence': {'sadness': 0.7659999999999999}, 'painfully': {'sadness': 0.758}, 'moribund': {'sadness': 0.758}, 'defeated': {'sadness': 0.75, 'trust': 0.258}, 'depressive': {'sadness': 0.75}, 'sorrowful': {'sadness': 0.75}, 'regretful': {'sadness': 0.75}, 'cry': {'sadness': 0.75}, 'abysmal': {'sadness': 0.742}, 'lonesome': {'sadness': 0.7340000000000001}, 'miserably': {'sadness': 0.7340000000000001}, 'listless': {'sadness': 0.7290000000000001}, 'alienated': {'sadness': 0.727}, 'emptiness': {'sadness': 0.727}, 'unfortunately': {'sadness': 0.727}, 'cried': {'sadness': 0.7190000000000001}, 'disheartening': {'sadness': 0.7190000000000001}, 'heartless': {'sadness': 0.7190000000000001}, 'rejected': {'sadness': 0.7120000000000001}, 'torn': {'sadness': 0.71}, 'calamity': {'sadness': 0.7090000000000001}, 'obit': {'sadness': 0.703, 'surprise': 0.35200000000000004}, 'extinct': {'sadness': 0.703}, 'isolate': {'sadness': 0.703}, 'isolation': {'sadness': 0.703}, 'lifesucks': {'sadness': 0.7}, 'widow': {'sadness': 0.6970000000000001}, 'nohope': {'sadness': 0.688}, 'sob': {'sadness': 0.688}, 'hospice': {'sadness': 0.688}, 'widower': {'sadness': 0.688}, 'foreveralone': {'sadness': 0.688}, 'teary': {'sadness': 0.688}, 'regretting': {'sadness': 0.688}, 'missingyou': {'sadness': 0.672}, 'obituary': {'sadness': 0.672}, 'feelingdown': {'sadness': 0.672}, 'decomposed': {'sadness': 0.672}, 'abortive': {'sadness': 0.672}, 'barren': {'sadness': 0.67}, 'weep': {'sadness': 0.6559999999999999}, 'tear': {'sadness': 0.6559999999999999}, 'dreary': {'sadness': 0.6559999999999999}, 'shitty': {'sadness': 0.6559999999999999}, 'bleak': {'sadness': 0.6559999999999999}, 'lamenting': {'sadness': 0.6559999999999999}, 'regretted': {'sadness': 0.652}, 'disability': {'sadness': 0.648}, 'infertility': {'sadness': 0.6409999999999999}, 'shroud': {'sadness': 0.6409999999999999}, 'terribly': {'sadness': 0.6409999999999999}, 'termination': {'sadness': 0.6409999999999999}, 'woeful': {'sadness': 0.6409999999999999}, 'stricken': {'sadness': 0.6409999999999999}, 'mausoleum': {'sadness': 0.63}, 'shattered': {'sadness': 0.63}, 'terminate': {'sadness': 0.625}, 'lost': {'sadness': 0.625}, 'posthumous': {'sadness': 0.625}, 'regret': {'sadness': 0.625}, 'demolished': {'sadness': 0.625}, 'gloom': {'sadness': 0.625}, 'disappointing': {'sadness': 0.625}, 'undesired': {'sadness': 0.625}, 'forlorn': {'sadness': 0.625}, 'cremation': {'sadness': 0.621}, 'forsake': {'sadness': 0.621}, 'melancholy': {'sadness': 0.621}, 'faithless': {'sadness': 0.609}, 'breakup': {'sadness': 0.609}, 'shameful': {'sadness': 0.609}, 'alone': {'sadness': 0.6}, 'angst': {'sadness': 0.598}, 'nothingness': {'sadness': 0.594}, 'remorse': {'sadness': 0.594}, 'bawl': {'sadness': 0.594}, 'petloss': {'sadness': 0.594}, 'crumbling': {'sadness': 0.594}, 'condolences': {'sadness': 0.594}, 'captivity': {'sadness': 0.594}, 'deprived': {'sadness': 0.594}, 'somber': {'sadness': 0.594}, 'melancholic': {'sadness': 0.591}, 'haggard': {'sadness': 0.5870000000000001}, 'interment': {'sadness': 0.578}, 'gloomy': {'sadness': 0.578}, 'unwell': {'sadness': 0.578}, 'denied': {'sadness': 0.578, 'trust': 0.21100000000000002}, 'damages': {'sadness': 0.5760000000000001}, 'pauper': {'sadness': 0.562}, 'sadday': {'sadness': 0.562}, 'runaway': {'sadness': 0.562}, 'urn': {'sadness': 0.562}, 'tomb': {'sadness': 0.562}, 'expire': {'sadness': 0.562}, 'departed': {'sadness': 0.5579999999999999}, 'pity': {'sadness': 0.547}, 'imissyou': {'sadness': 0.547}, 'surrendering': {'sadness': 0.547}, 'memorial': {'sadness': 0.547}, 'malaise': {'sadness': 0.547}, 'resignation': {'sadness': 0.547, 'surprise': 0.281}, 'glum': {'sadness': 0.547}, 'bummed': {'sadness': 0.547}, 'dark': {'sadness': 0.545}, 'aching': {'sadness': 0.544}, 'undertaker': {'sadness': 0.5379999999999999}, 'fooled': {'sadness': 0.531}, 'homesick': {'sadness': 0.531}, 'requiem': {'sadness': 0.531}, 'sorely': {'sadness': 0.531}, 'epitaph': {'sadness': 0.531}, 'ache': {'sadness': 0.531}, 'console': {'sadness': 0.531}, 'defunct': {'sadness': 0.518}, 'sequestration': {'sadness': 0.516}, 'wither': {'sadness': 0.516}, 'blindness': {'sadness': 0.516}, 'weakness': {'sadness': 0.516, 'trust': 0.266}, 'regrettable': {'sadness': 0.509}, 'unrequited': {'sadness': 0.509}, 'negative': {'sadness': 0.5}, 'evict': {'sadness': 0.5}, 'ungodly': {'sadness': 0.5}, 'messedup': {'sadness': 0.5}, 'weary': {'sadness': 0.5}, 'drugged': {'sadness': 0.5}, 'dolor': {'sadness': 0.5}, 'chronic': {'sadness': 0.5}, 'cytomegalovirus': {'sadness': 0.5}, 'discomfort': {'sadness': 0.5}, 'damper': {'sadness': 0.5}, 'impossible': {'sadness': 0.5}, 'beg': {'sadness': 0.484}, 'repress': {'sadness': 0.484}, 'frailty': {'sadness': 0.484}, 'worn': {'sadness': 0.484}, 'weariness': {'sadness': 0.484}, 'inadequate': {'sadness': 0.484}, 'lowest': {'sadness': 0.478}, 'fallout': {'sadness': 0.469}, 'unfortunate': {'sadness': 0.469}, 'leftout': {'sadness': 0.469}, 'ail': {'sadness': 0.469}, 'disapproval': {'sadness': 0.469}, 'frayed': {'sadness': 0.467}, 'infamy': {'sadness': 0.46399999999999997}, 'wane': {'sadness': 0.456}, 'badly': {'sadness': 0.455}, 'refugee': {'sadness': 0.45299999999999996}, 'inhospitable': {'sadness': 0.45299999999999996}, 'secluded': {'sadness': 0.45299999999999996}, 'inability': {'sadness': 0.45299999999999996}, 'criticise': {'sadness': 0.45299999999999996}, 'doldrums': {'sadness': 0.45299999999999996}, 'frown': {'sadness': 0.45299999999999996}, 'gone': {'sadness': 0.45299999999999996}, 'memorials': {'sadness': 0.45299999999999996}, 'bittersweet': {'sadness': 0.45299999999999996}, 'fell': {'sadness': 0.45299999999999996}, 'perplexity': {'sadness': 0.45299999999999996}, 'lowly': {'sadness': 0.44799999999999995}, 'lone': {'sadness': 0.446}, 'annulment': {'sadness': 0.44}, 'badday': {'sadness': 0.439}, 'delirious': {'sadness': 0.439}, 'futile': {'sadness': 0.43799999999999994}, 'disconnected': {'sadness': 0.43799999999999994}, 'departure': {'sadness': 0.43799999999999994}, 'cancellation': {'sadness': 0.43799999999999994}, 'forbid': {'sadness': 0.43799999999999994}, 'sympathize': {'sadness': 0.43799999999999994}, 'abscess': {'sadness': 0.43799999999999994}, 'apathetic': {'sadness': 0.43799999999999994}, 'imprudent': {'sadness': 0.43799999999999994}, 'pensive': {'sadness': 0.43799999999999994}, 'absent': {'sadness': 0.43799999999999994}, 'farewell': {'sadness': 0.43799999999999994}, 'lethargy': {'sadness': 0.43799999999999994}, 'indigent': {'sadness': 0.43799999999999994}, 'diminish': {'sadness': 0.43799999999999994}, 'emotional': {'sadness': 0.43799999999999994}, 'draining': {'sadness': 0.424}, 'lastday': {'sadness': 0.424}, 'unwelcome': {'sadness': 0.42200000000000004}, 'handicap': {'sadness': 0.42200000000000004}, 'deviation': {'sadness': 0.42200000000000004}, 'rip': {'sadness': 0.42200000000000004}, 'dispassionate': {'sadness': 0.42200000000000004}, 'falling': {'sadness': 0.42200000000000004}, 'beggar': {'sadness': 0.42200000000000004}, 'difficulties': {'sadness': 0.42100000000000004}, 'drab': {'sadness': 0.42}, 'fall': {'sadness': 0.418}, 'meaningless': {'sadness': 0.409}, 'fault': {'sadness': 0.406}, 'subjected': {'sadness': 0.406}, 'fatigued': {'sadness': 0.406}, 'sigh': {'sadness': 0.402}, 'blue': {'sadness': 0.4}, 'needalife': {'sadness': 0.39799999999999996}, 'pointless': {'sadness': 0.39399999999999996}, 'embarrass': {'sadness': 0.39399999999999996}, 'noose': {'sadness': 0.391}, 'feeble': {'sadness': 0.391}, 'debt': {'sadness': 0.391}, 'refused': {'sadness': 0.391}, 'ifonly': {'sadness': 0.391}, 'exhausted': {'sadness': 0.391}, 'rue': {'sadness': 0.391}, 'monsoon': {'sadness': 0.391}, 'cage': {'sadness': 0.391}, 'geriatric': {'sadness': 0.379}, 'miss': {'sadness': 0.379}, 'ashes': {'sadness': 0.377}, 'inferior': {'sadness': 0.375}, 'sucks': {'sadness': 0.375}, 'funk': {'sadness': 0.375}, 'withdraw': {'sadness': 0.375}, 'goodbye': {'sadness': 0.375}, 'overcast': {'sadness': 0.375}, 'disqualify': {'sadness': 0.375}, 'dispel': {'sadness': 0.375}, 'parting': {'sadness': 0.375}, 'sympathy': {'sadness': 0.375}, 'slump': {'sadness': 0.375}, 'apologize': {'sadness': 0.37, 'trust': 0.47700000000000004}, 'inter': {'sadness': 0.364}, 'empty': {'sadness': 0.364}, 'fruitless': {'sadness': 0.359}, 'plaintive': {'sadness': 0.359}, 'unsuccessful': {'sadness': 0.359}, 'hindering': {'sadness': 0.359}, 'unable': {'sadness': 0.359}, 'disconnect': {'sadness': 0.359}, 'corse': {'sadness': 0.359}, 'numbness': {'sadness': 0.359}, 'absentee': {'sadness': 0.348}, 'intervention': {'sadness': 0.348}, 'spoiler': {'sadness': 0.348}, 'flaw': {'sadness': 0.34700000000000003}, 'blindly': {'sadness': 0.344}, 'cumbersome': {'sadness': 0.344}, 'detention': {'sadness': 0.344}, 'uninspired': {'sadness': 0.344}, 'attenuation': {'sadness': 0.344}, 'furrow': {'sadness': 0.344}, 'stained': {'sadness': 0.344}, 'resigned': {'sadness': 0.344}, 'severance': {'sadness': 0.33299999999999996}, 'unacceptable': {'sadness': 0.32799999999999996}, 'leave': {'sadness': 0.32799999999999996, 'surprise': 0.23399999999999999}, 'unacknowledged': {'sadness': 0.32799999999999996}, 'sterile': {'sadness': 0.32799999999999996}, 'flaccid': {'sadness': 0.324}, 'hobo': {'sadness': 0.32299999999999995}, 'scarcely': {'sadness': 0.318}, 'committal': {'sadness': 0.312}, 'nonsensical': {'sadness': 0.312}, 'evanescence': {'sadness': 0.312, 'surprise': 0.45299999999999996}, 'mistake': {'sadness': 0.312}, 'clouded': {'sadness': 0.312}, 'conceal': {'sadness': 0.311}, 'confess': {'sadness': 0.303, 'trust': 0.484}, 'alas': {'sadness': 0.302}, 'subsidence': {'sadness': 0.297}, 'migraine': {'sadness': 0.297}, 'wrinkled': {'sadness': 0.297}, 'dull': {'sadness': 0.297}, 'weak': {'sadness': 0.297}, 'toocold': {'sadness': 0.297}, 'setback': {'sadness': 0.297}, 'hermit': {'sadness': 0.29600000000000004, 'trust': 0.305}, 'moving': {'sadness': 0.295}, 'unimportant': {'sadness': 0.28800000000000003}, 'black': {'sadness': 0.281}, 'negro': {'sadness': 0.281}, 'grey': {'sadness': 0.281}, 'down': {'sadness': 0.281}, 'taint': {'sadness': 0.281}, 'unseat': {'sadness': 0.281}, 'excluding': {'sadness': 0.281}, 'wearily': {'sadness': 0.281}, 'apathy': {'sadness': 0.281}, 'jurisprudence': {'sadness': 0.273}, 'lax': {'sadness': 0.266}, 'eternity': {'sadness': 0.266}, 'drifted': {'sadness': 0.266}, 'leaving': {'sadness': 0.266}, 'mixedemotions': {'sadness': 0.266}, 'unrealistic': {'sadness': 0.266}, 'misrepresentation': {'sadness': 0.259}, 'restrict': {'sadness': 0.259}, 'stagnant': {'sadness': 0.259}, 'nosun': {'sadness': 0.255}, 'backwater': {'sadness': 0.255}, 'pine': {'sadness': 0.25}, 'labored': {'sadness': 0.25}, 'gullible': {'sadness': 0.25, 'trust': 0.281}, 'anchorage': {'sadness': 0.25}, 'older': {'sadness': 0.25}, 'incomplete': {'sadness': 0.25}, 'error': {'sadness': 0.25}, 'uneducated': {'sadness': 0.25}, 'rainyday': {'sadness': 0.242}, 'necessity': {'sadness': 0.23600000000000002}, 'boredom': {'sadness': 0.235}, 'void': {'sadness': 0.23399999999999999}, 'uninteresting': {'sadness': 0.23399999999999999}, 'cancel': {'sadness': 0.23399999999999999}, 'cloudy': {'sadness': 0.23399999999999999}, 'misty': {'sadness': 0.23399999999999999}, 'foggy': {'sadness': 0.23399999999999999}, 'pale': {'sadness': 0.23399999999999999}, 'hollow': {'sadness': 0.23399999999999999}, 'rainy': {'sadness': 0.22699999999999998}, 'uninterested': {'sadness': 0.223}, 'bottom': {'sadness': 0.223}, 'fasting': {'sadness': 0.22}, 'dole': {'sadness': 0.21899999999999997}, 'boooo': {'sadness': 0.21899999999999997}, 'coping': {'sadness': 0.21899999999999997}, 'cocaine': {'sadness': 0.218}, 'tough': {'sadness': 0.212}, 'arid': {'sadness': 0.203}, 'hoary': {'sadness': 0.203}, 'sprain': {'sadness': 0.203}, 'lower': {'sadness': 0.203}, 'sluggish': {'sadness': 0.203}, 'yucky': {'sadness': 0.203}, 'chilly': {'sadness': 0.203}, 'wanting': {'sadness': 0.20199999999999999}, 'meh': {'sadness': 0.188}, 'rumor': {'sadness': 0.188}, 'invalid': {'sadness': 0.188}, 'veal': {'sadness': 0.188, 'trust': 0.312}, 'rack': {'sadness': 0.188}, 'interrupted': {'sadness': 0.188}, 'cold': {'sadness': 0.188}, 'splitting': {'sadness': 0.188}, 'strip': {'sadness': 0.179}, 'sap': {'sadness': 0.172}, 'overload': {'sadness': 0.172}, 'divided': {'sadness': 0.172}, 'memories': {'sadness': 0.172}, 'nosnow': {'sadness': 0.16899999999999998}, 'rain': {'sadness': 0.163}, 'untitled': {'sadness': 0.157}, 'weeds': {'sadness': 0.156}, 'snort': {'sadness': 0.154}, 'inconsequential': {'sadness': 0.152}, 'tax': {'sadness': 0.142}, 'emo': {'sadness': 0.141}, 'kennel': {'sadness': 0.13}, 'meek': {'sadness': 0.125}, 'terrific': {'sadness': 0.125}, 'clouds': {'sadness': 0.125}, 'margin': {'sadness': 0.125}, 'late': {'sadness': 0.125}, 'boo': {'sadness': 0.094}, 'wet': {'sadness': 0.078}, 'motivating': {'sadness': 0.078}, 'hut': {'sadness': 0.078}, 'ovation': {'sadness': 0.078}, 'relics': {'sadness': 0.061}, 'couch': {'sadness': 0.06}, 'napkin': {'sadness': 0.031}, 'nutritious': {'sadness': 0.015}, 'flabbergast': {'surprise': 0.9059999999999999}, 'shockingly': {'surprise': 0.875}, 'surprising': {'surprise': 0.867}, 'surprised': {'surprise': 0.867}, 'astonishingly': {'surprise': 0.852}, 'jolt': {'surprise': 0.8440000000000001}, 'thunderstruck': {'surprise': 0.8440000000000001}, 'dazzle': {'surprise': 0.836}, 'unexpectedly': {'surprise': 0.836}, 'suddenly': {'surprise': 0.828}, 'startling': {'surprise': 0.828}, 'astound': {'surprise': 0.82}, 'astonish': {'surprise': 0.805}, 'awestruck': {'surprise': 0.797}, 'exclaim': {'surprise': 0.789}, 'amazement': {'surprise': 0.7809999999999999}, 'stupefy': {'surprise': 0.758}, 'dumfound': {'surprise': 0.758}, 'unpredictable': {'surprise': 0.758}, 'overwhelming': {'surprise': 0.758}, 'outrageous': {'surprise': 0.75}, 'erratic': {'surprise': 0.75}, 'unimaginable': {'surprise': 0.75}, 'blitz': {'surprise': 0.742}, 'bewilder': {'surprise': 0.742}, 'petrify': {'surprise': 0.742}, 'amaze': {'surprise': 0.742}, 'stupefaction': {'surprise': 0.7340000000000001}, 'moonstruck': {'surprise': 0.727}, 'sudden': {'surprise': 0.727}, 'amazedness': {'surprise': 0.7190000000000001}, 'unanticipated': {'surprise': 0.7190000000000001}, 'breathless': {'surprise': 0.7190000000000001}, 'awe': {'surprise': 0.7190000000000001}, 'gasp': {'surprise': 0.711}, 'stun': {'surprise': 0.711}, 'electrify': {'surprise': 0.711}, 'unforeseen': {'surprise': 0.703}, 'abrupt': {'surprise': 0.703}, 'surge': {'surprise': 0.703}, 'unprecedented': {'surprise': 0.695}, 'dumfounder': {'surprise': 0.695}, 'incredible': {'surprise': 0.688}, 'monstrous': {'surprise': 0.68}, 'inexplicable': {'surprise': 0.672}, 'striking': {'surprise': 0.672}, 'accidentally': {'surprise': 0.672}, 'topple': {'surprise': 0.664}, 'unsuspecting': {'surprise': 0.648}, 'unintended': {'surprise': 0.648}, 'spellbound': {'surprise': 0.648}, 'improvisation': {'surprise': 0.6409999999999999}, 'gape': {'surprise': 0.633}, 'trick': {'surprise': 0.625}, 'wonderment': {'surprise': 0.625}, 'inimaginable': {'surprise': 0.617}, 'prank': {'surprise': 0.617}, 'quickness': {'surprise': 0.617}, 'vanish': {'surprise': 0.617}, 'splash': {'surprise': 0.609}, 'inconceivable': {'surprise': 0.602}, 'stupor': {'surprise': 0.602}, 'stupendous': {'surprise': 0.594}, 'wild': {'surprise': 0.586}, 'wondrous': {'surprise': 0.586}, 'randomly': {'surprise': 0.586}, 'fluke': {'surprise': 0.578}, 'bizarre': {'surprise': 0.578}, 'stagger': {'surprise': 0.578}, 'premature': {'surprise': 0.578}, 'dynamic': {'surprise': 0.57}, 'uncover': {'surprise': 0.562}, 'reappear': {'surprise': 0.562}, 'fascinate': {'surprise': 0.562}, 'thaumaturgy': {'surprise': 0.555}, 'zany': {'surprise': 0.555}, 'thwart': {'surprise': 0.547}, 'daze': {'surprise': 0.547}, 'rarity': {'surprise': 0.547}, 'marvel': {'surprise': 0.539}, 'lunge': {'surprise': 0.539}, 'illusion': {'surprise': 0.539}, 'sensation': {'surprise': 0.531}, 'snag': {'surprise': 0.531}, 'immediacy': {'surprise': 0.523}, 'undiscovered': {'surprise': 0.523}, 'chance': {'surprise': 0.516}, 'stealthily': {'surprise': 0.516}, 'pop': {'surprise': 0.508}, 'unintentionally': {'surprise': 0.508}, 'reflex': {'surprise': 0.508}, 'pang': {'surprise': 0.5}, 'infrequent': {'surprise': 0.5}, 'diversion': {'surprise': 0.5}, 'decoy': {'surprise': 0.49200000000000005}, 'trump': {'surprise': 0.49200000000000005}, 'unutterable': {'surprise': 0.49200000000000005}, 'nab': {'surprise': 0.49200000000000005}, 'camouflage': {'surprise': 0.49200000000000005}, 'variable': {'surprise': 0.484}, 'horde': {'surprise': 0.484}, 'underestimate': {'surprise': 0.484}, 'magician': {'surprise': 0.484}, 'inexpressible': {'surprise': 0.484}, 'incident': {'surprise': 0.47700000000000004}, 'gawk': {'surprise': 0.47700000000000004}, 'unguarded': {'surprise': 0.47700000000000004}, 'strange': {'surprise': 0.47700000000000004}, 'leery': {'surprise': 0.469}, 'rapid': {'surprise': 0.469}, 'coincidence': {'surprise': 0.461}, 'subito': {'surprise': 0.461}, 'divergent': {'surprise': 0.461}, 'slip': {'surprise': 0.461}, 'overestimate': {'surprise': 0.45299999999999996}, 'stound': {'surprise': 0.445}, 'perchance': {'surprise': 0.445}, 'unintentional': {'surprise': 0.43799999999999994}, 'fascination': {'surprise': 0.43}, 'stealth': {'surprise': 0.42200000000000004}, 'originality': {'surprise': 0.42200000000000004}, 'riddle': {'surprise': 0.42200000000000004}, 'quicksilver': {'surprise': 0.42200000000000004}, 'judgment': {'surprise': 0.42200000000000004, 'trust': 0.469}, 'elusive': {'surprise': 0.414}, 'guess': {'surprise': 0.39799999999999996}, 'secrecy': {'surprise': 0.39799999999999996, 'trust': 0.25}, 'burlesque': {'surprise': 0.39799999999999996}, 'incontinence': {'surprise': 0.391}, 'peri': {'surprise': 0.391}, 'hermaphrodite': {'surprise': 0.391}, 'camouflaged': {'surprise': 0.375}, 'mystic': {'surprise': 0.375}, 'postponement': {'surprise': 0.35200000000000004}, 'modify': {'surprise': 0.35200000000000004}, 'prodigious': {'surprise': 0.336}, 'catch': {'surprise': 0.32}, 'inaffable': {'surprise': 0.312}, 'scrimmage': {'surprise': 0.312}, 'occasional': {'surprise': 0.312}, 'sally': {'surprise': 0.305}, 'differently': {'surprise': 0.297}, 'palpable': {'surprise': 0.297}, 'polarity': {'surprise': 0.297}, 'greeting': {'surprise': 0.289}, 'trip': {'surprise': 0.281}, 'stare': {'surprise': 0.273}, 'somatic': {'surprise': 0.266}, 'admire': {'surprise': 0.266, 'trust': 0.703}, 'mimicry': {'surprise': 0.266}, 'placard': {'surprise': 0.22699999999999998}, 'purity': {'surprise': 0.203}, 'nullify': {'surprise': 0.203}, 'singularly': {'surprise': 0.188}, 'mouth': {'surprise': 0.172}, 'cable': {'surprise': 0.109}, 'steady': {'surprise': 0.094, 'trust': 0.602}, 'truthfulness': {'trust': 0.9059999999999999}, 'trusted': {'trust': 0.883}, 'trustworthy': {'trust': 0.867}, 'truth': {'trust': 0.8440000000000001}, 'honor': {'trust': 0.8440000000000001}, 'honesty': {'trust': 0.8440000000000001}, 'trusting': {'trust': 0.836}, 'truthful': {'trust': 0.836}, 'brotherhood': {'trust': 0.82}, 'entrust': {'trust': 0.812}, 'credibility': {'trust': 0.805}, 'integrity': {'trust': 0.805}, 'honorable': {'trust': 0.805}, 'loyalty': {'trust': 0.805}, 'committed': {'trust': 0.805}, 'sincere': {'trust': 0.797}, 'partnership': {'trust': 0.789}, 'responsible': {'trust': 0.789}, 'verification': {'trust': 0.7809999999999999}, 'cooperative': {'trust': 0.7809999999999999}, 'oath': {'trust': 0.7809999999999999}, 'credible': {'trust': 0.773}, 'respectable': {'trust': 0.773}, 'verified': {'trust': 0.773}, 'qualified': {'trust': 0.7659999999999999}, 'respected': {'trust': 0.7659999999999999}, 'authentication': {'trust': 0.7659999999999999}, 'safekeeping': {'trust': 0.758}, 'trusts': {'trust': 0.758}, 'reputable': {'trust': 0.758}, 'reliability': {'trust': 0.758}, 'approval': {'trust': 0.758}, 'competence': {'trust': 0.75}, 'ally': {'trust': 0.75}, 'advised': {'trust': 0.75}, 'safeguard': {'trust': 0.75}, 'genuine': {'trust': 0.75}, 'stable': {'trust': 0.75}, 'friendships': {'trust': 0.75}, 'respects': {'trust': 0.742}, 'wholesome': {'trust': 0.742}, 'proven': {'trust': 0.742}, 'accepting': {'trust': 0.742}, 'confirmation': {'trust': 0.7340000000000001}, 'protecting': {'trust': 0.7340000000000001}, 'reassurance': {'trust': 0.7340000000000001}, 'respectful': {'trust': 0.7340000000000001}, 'trustee': {'trust': 0.7340000000000001}, 'fact': {'trust': 0.727}, 'confidentially': {'trust': 0.727}, 'believing': {'trust': 0.727}, 'credential': {'trust': 0.727}, 'partners': {'trust': 0.727}, 'agreement': {'trust': 0.727}, 'authenticate': {'trust': 0.7190000000000001}, 'virtue': {'trust': 0.7190000000000001}, 'allegiance': {'trust': 0.711}, 'dedication': {'trust': 0.711}, 'cooperating': {'trust': 0.711}, 'cooperation': {'trust': 0.711}, 'determination': {'trust': 0.711}, 'straightforward': {'trust': 0.711}, 'consistency': {'trust': 0.711}, 'creditable': {'trust': 0.711}, 'guarantee': {'trust': 0.711}, 'justice': {'trust': 0.711}, 'morality': {'trust': 0.703}, 'guardianship': {'trust': 0.703}, 'proof': {'trust': 0.703}, 'mentor': {'trust': 0.703}, 'innocent': {'trust': 0.703}, 'reliable': {'trust': 0.703}, 'protected': {'trust': 0.703}, 'compassionate': {'trust': 0.695}, 'certified': {'trust': 0.695}, 'skillful': {'trust': 0.695}, 'united': {'trust': 0.695}, 'approving': {'trust': 0.695}, 'agreeable': {'trust': 0.695}, 'allied': {'trust': 0.695}, 'bodyguard': {'trust': 0.695}, 'courage': {'trust': 0.695}, 'pact': {'trust': 0.695}, 'accountable': {'trust': 0.695}, 'guardian': {'trust': 0.695}, 'indestructible': {'trust': 0.695}, 'guidance': {'trust': 0.688}, 'justifiable': {'trust': 0.688}, 'competent': {'trust': 0.688}, 'valor': {'trust': 0.688}, 'secure': {'trust': 0.688}, 'adviser': {'trust': 0.688}, 'monogamy': {'trust': 0.688}, 'authenticity': {'trust': 0.688}, 'believed': {'trust': 0.688}, 'understanding': {'trust': 0.688}, 'solidity': {'trust': 0.688}, 'diplomatic': {'trust': 0.68}, 'expertise': {'trust': 0.68}, 'confirmed': {'trust': 0.68}, 'confide': {'trust': 0.68}, 'confidential': {'trust': 0.68}, 'strongest': {'trust': 0.68}, 'professional': {'trust': 0.68}, 'grandfather': {'trust': 0.68}, 'indivisible': {'trust': 0.68}, 'diligence': {'trust': 0.68}, 'leader': {'trust': 0.68}, 'agreeing': {'trust': 0.68}, 'affirm': {'trust': 0.68}, 'elders': {'trust': 0.68}, 'official': {'trust': 0.68}, 'protector': {'trust': 0.68}, 'acceptance': {'trust': 0.68}, 'faultless': {'trust': 0.672}, 'cohesive': {'trust': 0.672}, 'encyclopedia': {'trust': 0.672}, 'accepted': {'trust': 0.672}, 'unwavering': {'trust': 0.672}, 'intelligent': {'trust': 0.672}, 'believes': {'trust': 0.672}, 'accredited': {'trust': 0.672}, 'covenant': {'trust': 0.672}, 'advocate': {'trust': 0.664}, 'team': {'trust': 0.664}, 'authority': {'trust': 0.664}, 'supporting': {'trust': 0.664}, 'affirmatively': {'trust': 0.664}, 'attestation': {'trust': 0.664}, 'proficient': {'trust': 0.664}, 'disciple': {'trust': 0.664}, 'impeccable': {'trust': 0.664}, 'accountability': {'trust': 0.664}, 'ambassador': {'trust': 0.664}, 'communicate': {'trust': 0.664}, 'expert': {'trust': 0.664}, 'merit': {'trust': 0.664}, 'accept': {'trust': 0.664}, 'specialist': {'trust': 0.664}, 'guidebook': {'trust': 0.664}, 'counsel': {'trust': 0.6559999999999999}, 'steadfast': {'trust': 0.6559999999999999}, 'scientific': {'trust': 0.6559999999999999}, 'warranty': {'trust': 0.6559999999999999}, 'facts': {'trust': 0.6559999999999999}, 'constancy': {'trust': 0.6559999999999999}, 'structure': {'trust': 0.6559999999999999}, 'familiar': {'trust': 0.6559999999999999}, 'elder': {'trust': 0.6559999999999999}, 'gentleman': {'trust': 0.6559999999999999}, 'supports': {'trust': 0.6559999999999999}, 'defended': {'trust': 0.6559999999999999}, 'agreed': {'trust': 0.648}, 'noble': {'trust': 0.648}, 'comrade': {'trust': 0.648}, 'counselor': {'trust': 0.648}, 'assuredly': {'trust': 0.648}, 'rely': {'trust': 0.648}, 'solidarity': {'trust': 0.648}, 'accepts': {'trust': 0.648}, 'advisable': {'trust': 0.648}, 'academic': {'trust': 0.648}, 'competency': {'trust': 0.648}, 'brother': {'trust': 0.648}, 'assist': {'trust': 0.648}, 'protective': {'trust': 0.648}, 'uphold': {'trust': 0.648}, 'unconditionally': {'trust': 0.648}, 'worthy': {'trust': 0.643}, 'assure': {'trust': 0.6409999999999999}, 'lawful': {'trust': 0.6409999999999999}, 'conscientious': {'trust': 0.6409999999999999}, 'teacher': {'trust': 0.6409999999999999}, 'mamma': {'trust': 0.6409999999999999}, 'relationships': {'trust': 0.6409999999999999}, 'doctor': {'trust': 0.6409999999999999}, 'leading': {'trust': 0.6409999999999999}, 'establish': {'trust': 0.6409999999999999}, 'benefactor': {'trust': 0.6409999999999999}, 'ordained': {'trust': 0.6409999999999999}, 'real': {'trust': 0.6409999999999999}, 'durability': {'trust': 0.6409999999999999}, 'coexist': {'trust': 0.6409999999999999}, 'credence': {'trust': 0.6409999999999999}, 'unity': {'trust': 0.6409999999999999}, 'legal': {'trust': 0.6409999999999999}, 'endorse': {'trust': 0.633}, 'homage': {'trust': 0.633}, 'important': {'trust': 0.633}, 'conscience': {'trust': 0.633}, 'legitimacy': {'trust': 0.633}, 'physician': {'trust': 0.633}, 'deepest': {'trust': 0.633}, 'authorize': {'trust': 0.633}, 'convincing': {'trust': 0.633}, 'fireman': {'trust': 0.625}, 'beliefs': {'trust': 0.625}, 'accurate': {'trust': 0.625}, 'assured': {'trust': 0.625}, 'profound': {'trust': 0.625}, 'authorization': {'trust': 0.625}, 'professorship': {'trust': 0.625}, 'communication': {'trust': 0.625}, 'certify': {'trust': 0.625}, 'caretaker': {'trust': 0.625}, 'regard': {'trust': 0.625}, 'evident': {'trust': 0.625}, 'commend': {'trust': 0.617}, 'reassure': {'trust': 0.617}, 'approvement': {'trust': 0.617}, 'heroine': {'trust': 0.617}, 'unimpeachable': {'trust': 0.617}, 'rational': {'trust': 0.617}, 'haven': {'trust': 0.617}, 'constantly': {'trust': 0.617}, 'attentive': {'trust': 0.617}, 'advice': {'trust': 0.617}, 'gospel': {'trust': 0.617}, 'believer': {'trust': 0.617}, 'corroborate': {'trust': 0.617}, 'qualities': {'trust': 0.617}, 'bedrock': {'trust': 0.617}, 'surety': {'trust': 0.617}, 'accord': {'trust': 0.617}, 'fundamental': {'trust': 0.617}, 'thoughtful': {'trust': 0.617}, 'officer': {'trust': 0.609}, 'civilization': {'trust': 0.609}, 'awareness': {'trust': 0.609}, 'purification': {'trust': 0.609}, 'considerate': {'trust': 0.609}, 'patron': {'trust': 0.609}, 'notary': {'trust': 0.609}, 'steward': {'trust': 0.609}, 'recommend': {'trust': 0.609}, 'definitive': {'trust': 0.609}, 'babysitter': {'trust': 0.609}, 'vetted': {'trust': 0.609}, 'witness': {'trust': 0.602}, 'experienced': {'trust': 0.602}, 'guarded': {'trust': 0.602}, 'nun': {'trust': 0.602}, 'identify': {'trust': 0.602}, 'brave': {'trust': 0.602}, 'unconditional': {'trust': 0.602}, 'unquestionable': {'trust': 0.602}, 'mainstay': {'trust': 0.602}, 'strengthen': {'trust': 0.594}, 'nurse': {'trust': 0.594}, 'admiral': {'trust': 0.594}, 'eminence': {'trust': 0.594}, 'commendation': {'trust': 0.594}, 'endowment': {'trust': 0.594}, 'fairly': {'trust': 0.594}, 'complimentary': {'trust': 0.594}, 'openly': {'trust': 0.594}, 'philanthropic': {'trust': 0.594}, 'regent': {'trust': 0.594}, 'sage': {'trust': 0.594}, 'substantiate': {'trust': 0.594}, 'compliance': {'trust': 0.586}, 'unfailing': {'trust': 0.586}, 'sobriety': {'trust': 0.586}, 'helper': {'trust': 0.586}, 'testimony': {'trust': 0.586}, 'seniority': {'trust': 0.586}, 'father': {'trust': 0.586}, 'educational': {'trust': 0.586}, 'husbandry': {'trust': 0.586}, 'mate': {'trust': 0.586}, 'rooted': {'trust': 0.586}, 'delegate': {'trust': 0.586}, 'firmness': {'trust': 0.586}, 'bylaw': {'trust': 0.586}, 'acclaim': {'trust': 0.586}, 'collectively': {'trust': 0.586}, 'checklist': {'trust': 0.586}, 'monk': {'trust': 0.586}, 'attest': {'trust': 0.586}, 'constitutional': {'trust': 0.586}, 'designation': {'trust': 0.586}, 'tribe': {'trust': 0.586}, 'impartiality': {'trust': 0.578}, 'coexisting': {'trust': 0.578}, 'unquestioned': {'trust': 0.578}, 'upright': {'trust': 0.578}, 'irrefutable': {'trust': 0.578}, 'shelter': {'trust': 0.578}, 'commandant': {'trust': 0.578}, 'authoritative': {'trust': 0.578}, 'professor': {'trust': 0.578}, 'philanthropist': {'trust': 0.578}, 'judge': {'trust': 0.578}, 'convinced': {'trust': 0.578}, 'structural': {'trust': 0.578}, 'watchdog': {'trust': 0.578}, 'careful': {'trust': 0.578}, 'connective': {'trust': 0.57}, 'principal': {'trust': 0.57}, 'unequivocal': {'trust': 0.57}, 'compass': {'trust': 0.57}, 'ordinance': {'trust': 0.57}, 'modest': {'trust': 0.57}, 'pilot': {'trust': 0.57}, 'insure': {'trust': 0.57}, 'guide': {'trust': 0.57}, 'matron': {'trust': 0.57}, 'adhering': {'trust': 0.57}, 'apostle': {'trust': 0.57}, 'plausible': {'trust': 0.57}, 'advise': {'trust': 0.57}, 'volunteers': {'trust': 0.57}, 'corroboration': {'trust': 0.57}, 'consult': {'trust': 0.57}, 'relative': {'trust': 0.57}, 'unquestionably': {'trust': 0.57}, 'pedigree': {'trust': 0.57}, 'earned': {'trust': 0.57}, 'collaborator': {'trust': 0.57}, 'frankness': {'trust': 0.562}, 'apostolic': {'trust': 0.562}, 'jurist': {'trust': 0.562}, 'fort': {'trust': 0.562}, 'vigorous': {'trust': 0.562}, 'congregation': {'trust': 0.562}, 'curable': {'trust': 0.562}, 'cohesion': {'trust': 0.562}, 'applaud': {'trust': 0.562}, 'prize': {'trust': 0.562}, 'earn': {'trust': 0.562}, 'strong': {'trust': 0.562}, 'jury': {'trust': 0.562}, 'spotless': {'trust': 0.562}, 'pertinent': {'trust': 0.562}, 'concordance': {'trust': 0.562}, 'admit': {'trust': 0.562}, 'insight': {'trust': 0.562}, 'treasurer': {'trust': 0.562}, 'intuition': {'trust': 0.555}, 'influential': {'trust': 0.555}, 'precedence': {'trust': 0.555}, 'constant': {'trust': 0.555}, 'coach': {'trust': 0.555}, 'coalesce': {'trust': 0.555}, 'impartial': {'trust': 0.555}, 'veteran': {'trust': 0.555}, 'congruence': {'trust': 0.555}, 'defender': {'trust': 0.555}, 'privacy': {'trust': 0.555}, 'inclusion': {'trust': 0.555}, 'physicist': {'trust': 0.555}, 'forgive': {'trust': 0.547}, 'durable': {'trust': 0.547}, 'statement': {'trust': 0.547}, 'promises': {'trust': 0.547}, 'reinforcement': {'trust': 0.547}, 'commanding': {'trust': 0.547}, 'prevalent': {'trust': 0.547}, 'convent': {'trust': 0.547}, 'impenetrable': {'trust': 0.547}, 'law': {'trust': 0.547}, 'heritage': {'trust': 0.547}, 'provide': {'trust': 0.547}, 'temperate': {'trust': 0.547}, 'securities': {'trust': 0.547}, 'eyewitness': {'trust': 0.547}, 'prudent': {'trust': 0.547}, 'govern': {'trust': 0.547}, 'registry': {'trust': 0.547}, 'ancestral': {'trust': 0.547}, 'obedience': {'trust': 0.539}, 'ensemble': {'trust': 0.539}, 'proctor': {'trust': 0.539}, 'tantamount': {'trust': 0.539}, 'define': {'trust': 0.539}, 'obvious': {'trust': 0.539}, 'inimitable': {'trust': 0.539}, 'architecture': {'trust': 0.539}, 'uncensured': {'trust': 0.539}, 'admitting': {'trust': 0.539}, 'immovable': {'trust': 0.539}, 'reinforcements': {'trust': 0.539}, 'watchman': {'trust': 0.539}, 'institute': {'trust': 0.539}, 'chronicle': {'trust': 0.539}, 'relevant': {'trust': 0.539}, 'stamina': {'trust': 0.539}, 'choices': {'trust': 0.539}, 'doubtless': {'trust': 0.531}, 'dependent': {'trust': 0.531}, 'seal': {'trust': 0.531}, 'refuge': {'trust': 0.531}, 'answerable': {'trust': 0.531}, 'deed': {'trust': 0.531}, 'school': {'trust': 0.531}, 'omniscient': {'trust': 0.531}, 'transcript': {'trust': 0.531}, 'center': {'trust': 0.531}, 'terms': {'trust': 0.531}, 'verily': {'trust': 0.531}, 'immunization': {'trust': 0.531}, 'sponsor': {'trust': 0.531}, 'approbation': {'trust': 0.527}, 'dictionary': {'trust': 0.523}, 'chaplain': {'trust': 0.523}, 'commonwealth': {'trust': 0.523}, 'ourselves': {'trust': 0.523}, 'ratify': {'trust': 0.523}, 'account': {'trust': 0.523}, 'unbroken': {'trust': 0.523}, 'taught': {'trust': 0.523}, 'correctness': {'trust': 0.523}, 'countenance': {'trust': 0.523}, 'laureate': {'trust': 0.523}, 'unimpeached': {'trust': 0.523}, 'benedictory': {'trust': 0.523}, 'sentinel': {'trust': 0.516}, 'minded': {'trust': 0.516}, 'obstetrician': {'trust': 0.516}, 'association': {'trust': 0.516}, 'passwords': {'trust': 0.516}, 'framework': {'trust': 0.516}, 'committee': {'trust': 0.516}, 'fully': {'trust': 0.516}, 'formative': {'trust': 0.516}, 'predominant': {'trust': 0.516}, 'credit': {'trust': 0.516}, 'measure': {'trust': 0.516}, 'inform': {'trust': 0.516}, 'nobleman': {'trust': 0.516}, 'housewife': {'trust': 0.508}, 'automatic': {'trust': 0.508}, 'philosopher': {'trust': 0.508}, 'enable': {'trust': 0.508}, 'patronage': {'trust': 0.508}, 'tolerance': {'trust': 0.508}, 'admissible': {'trust': 0.508}, 'custodian': {'trust': 0.508}, 'intact': {'trust': 0.508}, 'virgin': {'trust': 0.508}, 'diversity': {'trust': 0.508}, 'constable': {'trust': 0.508}, 'instruct': {'trust': 0.508}, 'policy': {'trust': 0.508}, 'priest': {'trust': 0.508}, 'sovereign': {'trust': 0.508}, 'lieutenant': {'trust': 0.508}, 'vouch': {'trust': 0.508}, 'forgiving': {'trust': 0.508}, 'pontiff': {'trust': 0.5}, 'infallibility': {'trust': 0.5}, 'gateway': {'trust': 0.5}, 'timing': {'trust': 0.5}, 'retain': {'trust': 0.5}, 'doctrine': {'trust': 0.5}, 'backer': {'trust': 0.5}, 'religions': {'trust': 0.5}, 'optimist': {'trust': 0.5}, 'majesty': {'trust': 0.5}, 'info': {'trust': 0.5}, 'nerds': {'trust': 0.5}, 'instruction': {'trust': 0.5}, 'indelible': {'trust': 0.5}, 'watchful': {'trust': 0.5}, 'guru': {'trust': 0.5}, 'related': {'trust': 0.5}, 'personal': {'trust': 0.5}, 'badge': {'trust': 0.5}, 'apologetic': {'trust': 0.5}, 'harbor': {'trust': 0.49200000000000005}, 'efforts': {'trust': 0.49200000000000005}, 'laudatory': {'trust': 0.49200000000000005}, 'judgement': {'trust': 0.49200000000000005}, 'popularity': {'trust': 0.49200000000000005}, 'hosannah': {'trust': 0.49200000000000005}, 'sheriff': {'trust': 0.49200000000000005}, 'contributor': {'trust': 0.49200000000000005}, 'attraction': {'trust': 0.49200000000000005}, 'constitute': {'trust': 0.49200000000000005}, 'formality': {'trust': 0.49200000000000005}, 'inevitable': {'trust': 0.49200000000000005}, 'moderator': {'trust': 0.49200000000000005}, 'privy': {'trust': 0.49200000000000005}, 'chairman': {'trust': 0.49200000000000005}, 'spokesman': {'trust': 0.49200000000000005}, 'fellow': {'trust': 0.49200000000000005}, 'endow': {'trust': 0.49200000000000005}, 'proverbs': {'trust': 0.49200000000000005}, 'umpire': {'trust': 0.49200000000000005}, 'concord': {'trust': 0.484}, 'colonel': {'trust': 0.484}, 'arbiter': {'trust': 0.484}, 'assembly': {'trust': 0.484}, 'path': {'trust': 0.484}, 'referee': {'trust': 0.484}, 'depth': {'trust': 0.484}, 'approbate': {'trust': 0.484}, 'like': {'trust': 0.484}, 'voucher': {'trust': 0.484}, 'ranger': {'trust': 0.484}, 'laudation': {'trust': 0.484}, 'countryman': {'trust': 0.484}, 'episcopal': {'trust': 0.47700000000000004}, 'sacrifice': {'trust': 0.47700000000000004}, 'signature': {'trust': 0.47700000000000004}, 'frank': {'trust': 0.47700000000000004}, 'word': {'trust': 0.47700000000000004}, 'purely': {'trust': 0.47700000000000004}, 'mathematical': {'trust': 0.47700000000000004}, 'votive': {'trust': 0.47700000000000004}, 'calculator': {'trust': 0.47700000000000004}, 'follow': {'trust': 0.47700000000000004}, 'putative': {'trust': 0.47700000000000004}, 'landmark': {'trust': 0.47700000000000004}, 'preponderance': {'trust': 0.47700000000000004}, 'consul': {'trust': 0.47700000000000004}, 'sermon': {'trust': 0.47700000000000004}, 'matter': {'trust': 0.47700000000000004}, 'parliament': {'trust': 0.47700000000000004}, 'counted': {'trust': 0.47700000000000004}, 'tribune': {'trust': 0.469}, 'title': {'trust': 0.469}, 'capacity': {'trust': 0.469}, 'judicious': {'trust': 0.469}, 'underwrite': {'trust': 0.469}, 'cashier': {'trust': 0.469}, 'recruits': {'trust': 0.469}, 'prefer': {'trust': 0.469}, 'commission': {'trust': 0.469}, 'tutelage': {'trust': 0.469}, 'religion': {'trust': 0.469}, 'vicar': {'trust': 0.469}, 'marshal': {'trust': 0.469}, 'associate': {'trust': 0.469}, 'uncritical': {'trust': 0.469}, 'author': {'trust': 0.469}, 'regal': {'trust': 0.469}, 'flagship': {'trust': 0.469}, 'effective': {'trust': 0.469}, 'admitted': {'trust': 0.461}, 'moorings': {'trust': 0.461}, 'manage': {'trust': 0.461}, 'eventually': {'trust': 0.461}, 'aunt': {'trust': 0.461}, 'lifestyle': {'trust': 0.461}, 'magnetic': {'trust': 0.461}, 'bank': {'trust': 0.461}, 'trade': {'trust': 0.461}, 'partake': {'trust': 0.461}, 'crucial': {'trust': 0.461}, 'socially': {'trust': 0.461}, 'patriarchal': {'trust': 0.461}, 'courier': {'trust': 0.461}, 'contains': {'trust': 0.461}, 'commerce': {'trust': 0.461}, 'theological': {'trust': 0.461}, 'oblige': {'trust': 0.461}, 'necessarily': {'trust': 0.461}, 'attendant': {'trust': 0.461}, 'custody': {'trust': 0.461}, 'insulation': {'trust': 0.45299999999999996}, 'chairwoman': {'trust': 0.45299999999999996}, 'chart': {'trust': 0.45299999999999996}, 'president': {'trust': 0.45299999999999996}, 'laud': {'trust': 0.45299999999999996}, 'governor': {'trust': 0.45299999999999996}, 'journeyman': {'trust': 0.45299999999999996}, 'perceive': {'trust': 0.45299999999999996}, 'deputy': {'trust': 0.45299999999999996}, 'encomium': {'trust': 0.45299999999999996}, 'exchange': {'trust': 0.45299999999999996}, 'level': {'trust': 0.45299999999999996}, 'eagle': {'trust': 0.45299999999999996}, 'synergistic': {'trust': 0.45299999999999996}, 'employ': {'trust': 0.445}, 'impart': {'trust': 0.445}, 'asserting': {'trust': 0.445}, 'negotiate': {'trust': 0.445}, 'usual': {'trust': 0.445}, 'sir': {'trust': 0.445}, 'dictum': {'trust': 0.445}, 'chancellor': {'trust': 0.445}, 'tradesmen': {'trust': 0.445}, 'theorem': {'trust': 0.445}, 'chemist': {'trust': 0.445}, 'matters': {'trust': 0.445}, 'lodging': {'trust': 0.445}, 'orthodoxy': {'trust': 0.445}, 'statistical': {'trust': 0.445}, 'director': {'trust': 0.445}, 'indemnity': {'trust': 0.445}, 'handbook': {'trust': 0.445}, 'magnify': {'trust': 0.445}, 'crew': {'trust': 0.445}, 'formula': {'trust': 0.445}, 'abbot': {'trust': 0.43799999999999994}, 'mlk': {'trust': 0.43799999999999994}, 'economy': {'trust': 0.43799999999999994}, 'exhaustive': {'trust': 0.43799999999999994}, 'conveyancing': {'trust': 0.43799999999999994}, 'arbitrator': {'trust': 0.43799999999999994}, 'tandem': {'trust': 0.43799999999999994}, 'villager': {'trust': 0.43799999999999994}, 'conformity': {'trust': 0.43799999999999994}, 'merci': {'trust': 0.43799999999999994}, 'elect': {'trust': 0.43799999999999994}, 'encore': {'trust': 0.43799999999999994}, 'emphasize': {'trust': 0.43799999999999994}, 'governess': {'trust': 0.43799999999999994}, 'comptroller': {'trust': 0.43799999999999994}, 'cabinet': {'trust': 0.43799999999999994}, 'digit': {'trust': 0.43799999999999994}, 'butler': {'trust': 0.43799999999999994}, 'count': {'trust': 0.43}, 'sentry': {'trust': 0.43}, 'blanket': {'trust': 0.43}, 'elucidate': {'trust': 0.43}, 'differential': {'trust': 0.43}, 'circle': {'trust': 0.43}, 'estimable': {'trust': 0.43}, 'deacon': {'trust': 0.43}, 'bequest': {'trust': 0.43}, 'lender': {'trust': 0.43}, 'persuade': {'trust': 0.43}, 'base': {'trust': 0.43}, 'grit': {'trust': 0.43}, 'lesbians': {'trust': 0.43}, 'disclosed': {'trust': 0.43}, 'impressionable': {'trust': 0.43}, 'occupant': {'trust': 0.43}, 'compact': {'trust': 0.43}, 'grammar': {'trust': 0.43}, 'jeremiah': {'trust': 0.43}, 'neutrality': {'trust': 0.43}, 'hail': {'trust': 0.43}, 'easiest': {'trust': 0.42200000000000004}, 'reconsideration': {'trust': 0.42200000000000004}, 'maintenance': {'trust': 0.42200000000000004}, 'axiom': {'trust': 0.42200000000000004}, 'eulogize': {'trust': 0.42200000000000004}, 'enablement': {'trust': 0.42200000000000004}, 'antiseptic': {'trust': 0.42200000000000004}, 'apprentice': {'trust': 0.42200000000000004}, 'shopkeeper': {'trust': 0.42200000000000004}, 'trading': {'trust': 0.42200000000000004}, 'probity': {'trust': 0.42200000000000004}, 'truss': {'trust': 0.42200000000000004}, 'dealings': {'trust': 0.42200000000000004}, 'parish': {'trust': 0.42200000000000004}, 'assignee': {'trust': 0.42200000000000004}, 'supplication': {'trust': 0.42200000000000004}, 'primer': {'trust': 0.42200000000000004}, 'wonderstruck': {'trust': 0.42200000000000004}, 'intend': {'trust': 0.42200000000000004}, 'fixed': {'trust': 0.42200000000000004}, 'forum': {'trust': 0.42200000000000004}, 'perennial': {'trust': 0.42200000000000004}, 'accountant': {'trust': 0.42200000000000004}, 'commodore': {'trust': 0.414}, 'reporter': {'trust': 0.414}, 'conglomerate': {'trust': 0.414}, 'routine': {'trust': 0.414}, 'consort': {'trust': 0.414}, 'leap': {'trust': 0.414}, 'akin': {'trust': 0.414}, 'gate': {'trust': 0.414}, 'trainer': {'trust': 0.414}, 'offering': {'trust': 0.414}, 'deference': {'trust': 0.414}, 'specialize': {'trust': 0.414}, 'gazette': {'trust': 0.414}, 'incline': {'trust': 0.414}, 'athlete': {'trust': 0.414}, 'cogent': {'trust': 0.414}, 'fellas': {'trust': 0.414}, 'transaction': {'trust': 0.414}, 'amortization': {'trust': 0.414}, 'synod': {'trust': 0.414}, 'privilege': {'trust': 0.414}, 'serve': {'trust': 0.414}, 'radar': {'trust': 0.406}, 'extol': {'trust': 0.406}, 'legislator': {'trust': 0.406}, 'patrol': {'trust': 0.406}, 'linguist': {'trust': 0.406}, 'dermatologist': {'trust': 0.406}, 'nation': {'trust': 0.406}, 'relancer': {'trust': 0.406}, 'sanction': {'trust': 0.406}, 'reimbursement': {'trust': 0.406}, 'judged': {'trust': 0.406}, 'abacus': {'trust': 0.406}, 'executor': {'trust': 0.406}, 'system': {'trust': 0.406}, 'budget': {'trust': 0.406}, 'clan': {'trust': 0.39799999999999996}, 'parietal': {'trust': 0.39799999999999996}, 'journalism': {'trust': 0.39799999999999996}, 'merchandise': {'trust': 0.39799999999999996}, 'electorate': {'trust': 0.39799999999999996}, 'favs': {'trust': 0.39799999999999996}, 'barter': {'trust': 0.39799999999999996}, 'paths': {'trust': 0.39799999999999996}, 'popular': {'trust': 0.39799999999999996}, 'iron': {'trust': 0.39799999999999996}, 'eulogy': {'trust': 0.39799999999999996}, 'pursue': {'trust': 0.39799999999999996}, 'ground': {'trust': 0.39799999999999996}, 'explain': {'trust': 0.39799999999999996}, 'depository': {'trust': 0.39799999999999996}, 'nest': {'trust': 0.39799999999999996}, 'clearance': {'trust': 0.39799999999999996}, 'gentry': {'trust': 0.39799999999999996}, 'deluxe': {'trust': 0.39799999999999996}, 'cube': {'trust': 0.391}, 'eulogistic': {'trust': 0.391}, 'translation': {'trust': 0.391}, 'gay': {'trust': 0.391}, 'paean': {'trust': 0.391}, 'baggage': {'trust': 0.391}, 'intercession': {'trust': 0.391}, 'usher': {'trust': 0.391}, 'accounts': {'trust': 0.391}, 'chandler': {'trust': 0.391}, 'collins': {'trust': 0.391}, 'messenger': {'trust': 0.391}, 'regardless': {'trust': 0.391}, 'follower': {'trust': 0.391}, 'homie': {'trust': 0.391}, 'surrogate': {'trust': 0.391}, 'horse': {'trust': 0.391}, 'downright': {'trust': 0.391}, 'stages': {'trust': 0.391}, 'recline': {'trust': 0.391}, 'escort': {'trust': 0.391}, 'armory': {'trust': 0.391}, 'faculty': {'trust': 0.38299999999999995}, 'bartender': {'trust': 0.38299999999999995}, 'gage': {'trust': 0.38299999999999995}, 'leaning': {'trust': 0.38299999999999995}, 'lean': {'trust': 0.38299999999999995}, 'series': {'trust': 0.38299999999999995}, 'plaudit': {'trust': 0.38299999999999995}, 'encomiastic': {'trust': 0.38299999999999995}, 'curfew': {'trust': 0.38299999999999995}, 'someday': {'trust': 0.38299999999999995}, 'reparation': {'trust': 0.38299999999999995}, 'culinary': {'trust': 0.38299999999999995}, 'label': {'trust': 0.38299999999999995}, 'edited': {'trust': 0.38299999999999995}, 'crisp': {'trust': 0.38299999999999995}, 'assessor': {'trust': 0.375}, 'confederate': {'trust': 0.375}, 'jual': {'trust': 0.375}, 'differences': {'trust': 0.375}, 'berminat': {'trust': 0.375}, 'adjust': {'trust': 0.375}, 'general': {'trust': 0.375}, 'personalities': {'trust': 0.375}, 'cover': {'trust': 0.375}, 'clapping': {'trust': 0.375}, 'desires': {'trust': 0.375}, 'marine': {'trust': 0.36700000000000005}, 'senate': {'trust': 0.36700000000000005}, 'bursary': {'trust': 0.36700000000000005}, 'garrison': {'trust': 0.36700000000000005}, 'bristol': {'trust': 0.36700000000000005}, 'swell': {'trust': 0.36700000000000005}, 'periodicity': {'trust': 0.36700000000000005}, 'magnet': {'trust': 0.36700000000000005}, 'microscope': {'trust': 0.36700000000000005}, 'throne': {'trust': 0.36700000000000005}, 'manual': {'trust': 0.36700000000000005}, 'collateral': {'trust': 0.36700000000000005}, 'dogma': {'trust': 0.36700000000000005}, 'cosmopolitan': {'trust': 0.36700000000000005}, 'homosexual': {'trust': 0.36700000000000005}, 'knickers': {'trust': 0.36700000000000005}, 'nestle': {'trust': 0.36700000000000005}, 'bargain': {'trust': 0.36700000000000005}, 'stark': {'trust': 0.359}, 'footing': {'trust': 0.359}, 'mortgagee': {'trust': 0.359}, 'fade': {'trust': 0.359}, 'eulogium': {'trust': 0.359}, 'promo': {'trust': 0.359}, 'vulnerable': {'trust': 0.359}, 'maxim': {'trust': 0.359}, 'fender': {'trust': 0.359}, 'axiomatic': {'trust': 0.35200000000000004}, 'fuse': {'trust': 0.35200000000000004}, 'font': {'trust': 0.35200000000000004}, 'show': {'trust': 0.35200000000000004}, 'pocketbac': {'trust': 0.35200000000000004}, 'laser': {'trust': 0.35200000000000004}, 'suggest': {'trust': 0.35200000000000004}, 'seals': {'trust': 0.35200000000000004}, 'aneka': {'trust': 0.35200000000000004}, 'poll': {'trust': 0.35200000000000004}, 'banker': {'trust': 0.35200000000000004}, 'administrative': {'trust': 0.35200000000000004}, 'bounce': {'trust': 0.344}, 'dealt': {'trust': 0.344}, 'proviso': {'trust': 0.344}, 'servant': {'trust': 0.344}, 'shoutout': {'trust': 0.344}, 'monde': {'trust': 0.344}, 'holder': {'trust': 0.344}, 'petit': {'trust': 0.344}, 'legislature': {'trust': 0.336}, 'hairchalk': {'trust': 0.336}, 'estimation': {'trust': 0.336}, 'repute': {'trust': 0.336}, 'lens': {'trust': 0.336}, 'shoulder': {'trust': 0.336}, 'county': {'trust': 0.336}, 'canons': {'trust': 0.32799999999999996}, 'wear': {'trust': 0.32799999999999996}, 'corporation': {'trust': 0.32799999999999996}, 'struggles': {'trust': 0.32799999999999996}, 'youll': {'trust': 0.32799999999999996}, 'karunia': {'trust': 0.32799999999999996}, 'swear': {'trust': 0.32799999999999996}, 'gauging': {'trust': 0.32799999999999996}, 'handgel': {'trust': 0.32}, 'pulsa': {'trust': 0.32}, 'sist': {'trust': 0.32}, 'behel': {'trust': 0.32}, 'aksesoris': {'trust': 0.32}, 'fill': {'trust': 0.32}, 'darkest': {'trust': 0.32}, 'unofficial': {'trust': 0.32}, 'pavement': {'trust': 0.32}, 'sib': {'trust': 0.32}, 'sur': {'trust': 0.32}, 'proxy': {'trust': 0.32}, 'clerical': {'trust': 0.32}, 'girder': {'trust': 0.32}, 'respon': {'trust': 0.32}, 'trans': {'trust': 0.32}, 'smith': {'trust': 0.312}, 'tema': {'trust': 0.312}, 'reseller': {'trust': 0.312}, 'imperfections': {'trust': 0.312}, 'pill': {'trust': 0.312}, 'romans': {'trust': 0.312}, 'bruh': {'trust': 0.312}, 'mau': {'trust': 0.312}, 'gubernatorial': {'trust': 0.312}, 'holla': {'trust': 0.312}, 'pake': {'trust': 0.305}, 'secret': {'trust': 0.305}, 'exception': {'trust': 0.305}, 'actress': {'trust': 0.305}, 'thermometer': {'trust': 0.305}, 'harga': {'trust': 0.305}, 'aquapix': {'trust': 0.305}, 'dha': {'trust': 0.305}, 'ganna': {'trust': 0.297}, 'flatter': {'trust': 0.297}, 'carl': {'trust': 0.297}, 'divan': {'trust': 0.297}, 'mandarin': {'trust': 0.297}, 'levee': {'trust': 0.297}, 'congressman': {'trust': 0.297}, 'tiket': {'trust': 0.297}, 'indonesia': {'trust': 0.297}, 'wigan': {'trust': 0.297}, 'pith': {'trust': 0.297}, 'ori': {'trust': 0.297}, 'hairclip': {'trust': 0.297}, 'kita': {'trust': 0.297}, 'pin': {'trust': 0.297}, 'hemat': {'trust': 0.297}, 'pivot': {'trust': 0.297}, 'talaga': {'trust': 0.297}, 'challenges': {'trust': 0.289}, 'contagiously': {'trust': 0.289}, 'machine': {'trust': 0.289}, 'shorty': {'trust': 0.289}, 'ribet': {'trust': 0.289}, 'gon': {'trust': 0.289}, 'terbang': {'trust': 0.281}, 'regrets': {'trust': 0.281}, 'tentang': {'trust': 0.281}, 'fisheye': {'trust': 0.281}, 'florence': {'trust': 0.281}, 'unik': {'trust': 0.273}, 'don': {'trust': 0.273}, 'jellylens': {'trust': 0.273}, 'nigga': {'trust': 0.273}, 'bisa': {'trust': 0.273}, 'autism': {'trust': 0.273}, 'sappy': {'trust': 0.273}, 'chubby': {'trust': 0.273}, 'indent': {'trust': 0.273}, 'bbw': {'trust': 0.266}, 'antifungal': {'trust': 0.266}, 'jodie': {'trust': 0.266}, 'fashion': {'trust': 0.266}, 'truck': {'trust': 0.266}, 'sepatu': {'trust': 0.266}, 'crumpled': {'trust': 0.258}, 'puff': {'trust': 0.258}, 'wadsworth': {'trust': 0.258}, 'minat': {'trust': 0.258}, 'stephanie': {'trust': 0.258}, 'utk': {'trust': 0.258}, 'hai': {'trust': 0.258}, 'urs': {'trust': 0.258}, 'ella': {'trust': 0.25}, 'rota': {'trust': 0.25}, 'fabrication': {'trust': 0.25}, 'bureaucracy': {'trust': 0.25}, 'ting': {'trust': 0.242}, 'denial': {'trust': 0.242}, 'flange': {'trust': 0.242}, 'merchant': {'trust': 0.242}, 'aku': {'trust': 0.242}, 'juga': {'trust': 0.242}, 'secrets': {'trust': 0.23399999999999999}, 'xxx': {'trust': 0.23399999999999999}, 'gusset': {'trust': 0.23399999999999999}, 'mag': {'trust': 0.23399999999999999}, 'tas': {'trust': 0.23399999999999999}, 'wot': {'trust': 0.23399999999999999}, 'alb': {'trust': 0.23399999999999999}, 'naman': {'trust': 0.23399999999999999}, 'ada': {'trust': 0.23399999999999999}, 'murah': {'trust': 0.23399999999999999}, 'pesawat': {'trust': 0.23399999999999999}, 'dgn': {'trust': 0.23399999999999999}, 'burden': {'trust': 0.23399999999999999}, 'beliebers': {'trust': 0.22699999999999998}, 'faults': {'trust': 0.22699999999999998}, 'sceptical': {'trust': 0.22699999999999998}, 'flaws': {'trust': 0.22699999999999998}, 'shyt': {'trust': 0.22699999999999998}, 'envy': {'trust': 0.21899999999999997}, 'peepul': {'trust': 0.21899999999999997}, 'koo': {'trust': 0.21100000000000002}, 'pawn': {'trust': 0.21100000000000002}, 'idc': {'trust': 0.21100000000000002}, 'battles': {'trust': 0.21100000000000002}, 'garansi': {'trust': 0.21100000000000002}, 'undone': {'trust': 0.21100000000000002}, 'whstupp': {'trust': 0.203}, 'disappointments': {'trust': 0.203}, 'deceiving': {'trust': 0.203}, 'coax': {'trust': 0.203}, 'untuk': {'trust': 0.203}, 'moat': {'trust': 0.203}, 'erased': {'trust': 0.195}, 'ehh': {'trust': 0.188}, 'yuk': {'trust': 0.188}, 'wack': {'trust': 0.188}, 'insecurities': {'trust': 0.18}, 'weaknesses': {'trust': 0.18}, 'addict': {'trust': 0.172}, 'thang': {'trust': 0.156}, 'bieber': {'trust': 0.14800000000000002}, 'mistakes': {'trust': 0.133}}




    def __init__(self, text):
        self.text = text
        build_word_affect(self)

    def append_text(self, text_add):
        self.text = self.text + ' ' + text_add
        build_word_affect(self)
