/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.btree.keys.KVO;
import java.util.concurrent.ConcurrentLinkedQueue;

public class KVOList<O>
extends KVO<O> {
    private final ConcurrentLinkedQueue<KVO<O>> duplicateList = new ConcurrentLinkedQueue();
    private volatile boolean done = false;

    public KVOList(byte[] key, byte[] val, O obj) {
        super(key, val, obj);
    }

    public synchronized void add(KVO<O> o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (this.done) {
            throw new IllegalStateException();
        }
        this.duplicateList.add(o);
        if (o instanceof KVOList) {
            KVOList t = (KVOList)o;
            this.duplicateList.addAll(t.duplicateList);
            t.duplicateList.clear();
        }
    }

    public int getDuplicateCount() {
        return this.duplicateList.size();
    }

    public boolean isDuplicateListEmpty() {
        return this.duplicateList.isEmpty();
    }

    @Override
    public synchronized void done() {
        if (this.done) {
            throw new IllegalStateException();
        }
        this.done = true;
        super.done();
        for (KVO<O> o : this.duplicateList) {
            o.done();
        }
    }

    public void map(Op<O> op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        for (KVO<O> o : this.duplicateList) {
            op.apply(o);
        }
    }

    public static interface Op<O> {
        public void apply(KVO<O> var1);
    }
}

