/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule;

import com.bigdata.bop.solutions.ISortOrder;
import com.bigdata.relation.rule.IQueryOptions;
import com.bigdata.relation.rule.ISlice;
import java.util.Arrays;

public class QueryOptions
implements IQueryOptions {
    private static final long serialVersionUID = -4926866732224421937L;
    private final boolean distinct;
    private final boolean stable;
    private final ISortOrder[] orderBy;
    private final ISlice slice;
    public static final transient IQueryOptions NONE = new QueryOptions(false, false, null, null);
    public static final transient IQueryOptions DISTINCT = new QueryOptions(true, false, null, null);

    public QueryOptions(boolean distinct, boolean stable, ISortOrder[] orderBy, ISlice slice) {
        this.distinct = distinct;
        this.stable = stable;
        this.orderBy = orderBy;
        this.slice = slice;
        if (!(stable || slice == null || slice.getOffset() == 0L && slice.getLimit() == Long.MAX_VALUE)) {
            throw new IllegalArgumentException("slices must be stable");
        }
    }

    @Override
    public final boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public final boolean isStable() {
        return this.stable;
    }

    @Override
    public final ISortOrder[] getOrderBy() {
        return this.orderBy;
    }

    @Override
    public final ISlice getSlice() {
        return this.slice;
    }

    public String toString() {
        return "QueryOptions{ distinct=" + this.distinct + ", stable=" + this.stable + ", orderBy=" + (this.orderBy == null ? "N/A" : Arrays.toString(this.orderBy)) + ", slice=" + this.slice + "}";
    }
}

