/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.ImmutableBOp;
import com.bigdata.bop.NV;
import com.bigdata.bop.aggregate.AggregateBase;
import com.bigdata.bop.rdf.aggregate.AVERAGE;
import com.bigdata.bop.rdf.aggregate.COUNT;
import com.bigdata.bop.rdf.aggregate.GROUP_CONCAT;
import com.bigdata.bop.rdf.aggregate.MAX;
import com.bigdata.bop.rdf.aggregate.MIN;
import com.bigdata.bop.rdf.aggregate.SAMPLE;
import com.bigdata.bop.rdf.aggregate.SUM;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.AndBOp;
import com.bigdata.rdf.internal.constraints.BNodeBOp;
import com.bigdata.rdf.internal.constraints.CoalesceBOp;
import com.bigdata.rdf.internal.constraints.CompareBOp;
import com.bigdata.rdf.internal.constraints.ComputedIN;
import com.bigdata.rdf.internal.constraints.ConcatBOp;
import com.bigdata.rdf.internal.constraints.DatatypeBOp;
import com.bigdata.rdf.internal.constraints.DateBOp;
import com.bigdata.rdf.internal.constraints.DigestBOp;
import com.bigdata.rdf.internal.constraints.EncodeForURIBOp;
import com.bigdata.rdf.internal.constraints.FalseBOp;
import com.bigdata.rdf.internal.constraints.FuncBOp;
import com.bigdata.rdf.internal.constraints.IfBOp;
import com.bigdata.rdf.internal.constraints.InHashBOp;
import com.bigdata.rdf.internal.constraints.IriBOp;
import com.bigdata.rdf.internal.constraints.IsBNodeBOp;
import com.bigdata.rdf.internal.constraints.IsBoundBOp;
import com.bigdata.rdf.internal.constraints.IsLiteralBOp;
import com.bigdata.rdf.internal.constraints.IsNumericBOp;
import com.bigdata.rdf.internal.constraints.IsURIBOp;
import com.bigdata.rdf.internal.constraints.LangBOp;
import com.bigdata.rdf.internal.constraints.LangMatchesBOp;
import com.bigdata.rdf.internal.constraints.LcaseBOp;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.constraints.NotBOp;
import com.bigdata.rdf.internal.constraints.NowBOp;
import com.bigdata.rdf.internal.constraints.NumericBOp;
import com.bigdata.rdf.internal.constraints.OrBOp;
import com.bigdata.rdf.internal.constraints.RandBOp;
import com.bigdata.rdf.internal.constraints.RegexBOp;
import com.bigdata.rdf.internal.constraints.ReplaceBOp;
import com.bigdata.rdf.internal.constraints.SameTermBOp;
import com.bigdata.rdf.internal.constraints.SparqlTypeErrorBOp;
import com.bigdata.rdf.internal.constraints.StrAfterBOp;
import com.bigdata.rdf.internal.constraints.StrBOp;
import com.bigdata.rdf.internal.constraints.StrBeforeBOp;
import com.bigdata.rdf.internal.constraints.StrcontainsBOp;
import com.bigdata.rdf.internal.constraints.StrdtBOp;
import com.bigdata.rdf.internal.constraints.StrendsBOp;
import com.bigdata.rdf.internal.constraints.StrlangBOp;
import com.bigdata.rdf.internal.constraints.StrlenBOp;
import com.bigdata.rdf.internal.constraints.StrstartsBOp;
import com.bigdata.rdf.internal.constraints.SubstrBOp;
import com.bigdata.rdf.internal.constraints.TrueBOp;
import com.bigdata.rdf.internal.constraints.UUIDBOp;
import com.bigdata.rdf.internal.constraints.UcaseBOp;
import com.bigdata.rdf.internal.constraints.XsdLongBOp;
import com.bigdata.rdf.internal.constraints.XsdStrBOp;
import com.bigdata.rdf.internal.constraints.XsdUnsignedLongBOp;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.Compare;

public class FunctionRegistry {
    private static ConcurrentMap<URI, Factory> factories = new ConcurrentHashMap<URI, Factory>();
    public static final String SPARQL_FUNCTIONS = "http://www.w3.org/2006/sparql-functions#";
    public static final String XPATH_FUNCTIONS = "http://www.w3.org/2005/xpath-functions#";
    public static final String SPARQL10_UNDEFINED_FUNCTIONS = "http://www.bigdata.com/sparql-1.0-undefined-functions";
    public static final String SPARQL11_UNDEFINED_FUNCTIONS = "http://www.bigdata.com/sparql-1.1-undefined-functions";
    public static final URI BOUND = new URIImpl("http://www.w3.org/2006/sparql-functions#bound");
    public static final URI IS_LITERAL = new URIImpl("http://www.w3.org/2006/sparql-functions#isLiteral");
    public static final URI IS_BLANK = new URIImpl("http://www.w3.org/2006/sparql-functions#isBlank");
    public static final URI IS_URI = new URIImpl("http://www.w3.org/2006/sparql-functions#isURI");
    public static final URI IS_IRI = new URIImpl("http://www.w3.org/2006/sparql-functions#isIRI");
    public static final URI IS_NUMERIC = new URIImpl("http://www.w3.org/2006/sparql-functions#isNumeric");
    public static final URI STR = new URIImpl("http://www.w3.org/2006/sparql-functions#str");
    public static final URI LANG = new URIImpl("http://www.w3.org/2006/sparql-functions#lang");
    public static final URI DATATYPE = new URIImpl("http://www.w3.org/2006/sparql-functions#datatype");
    public static final URI LANG_MATCHES = new URIImpl("http://www.w3.org/2006/sparql-functions#langMatches");
    public static final URI REGEX = new URIImpl("http://www.w3.org/2005/xpath-functions#matches");
    public static final URI OR = new URIImpl("http://www.w3.org/2006/sparql-functions#logical-or");
    public static final URI AND = new URIImpl("http://www.w3.org/2006/sparql-functions#logical-and");
    public static final URI NOT = new URIImpl("http://www.w3.org/2005/xpath-functions#not");
    public static final URI SAME_TERM = new URIImpl("http://www.w3.org/2006/sparql-functions#sameTerm");
    public static final URI CONCAT = new URIImpl("http://www.w3.org/2006/sparql-functions#concat");
    public static final URI COALESCE = new URIImpl("http://www.w3.org/2006/sparql-functions#coalesce");
    public static final URI IN = new URIImpl("http://www.w3.org/2006/sparql-functions#in");
    public static final URI NOT_IN = new URIImpl("http://www.w3.org/2006/sparql-functions#notIn");
    public static final URI IF = new URIImpl("http://www.w3.org/2006/sparql-functions#if");
    public static final URI NOW = new URIImpl("http://www.w3.org/2005/xpath-functions#now");
    public static final URI YEAR = new URIImpl("http://www.w3.org/2005/xpath-functions#year-from-dateTime");
    public static final URI MONTH = new URIImpl("http://www.w3.org/2005/xpath-functions#month-from-dateTime");
    public static final URI DAY = new URIImpl("http://www.w3.org/2005/xpath-functions#day-from-dateTime");
    public static final URI HOURS = new URIImpl("http://www.w3.org/2005/xpath-functions#hours-from-dateTime");
    public static final URI MINUTES = new URIImpl("http://www.w3.org/2005/xpath-functions#minutes-from-dateTime");
    public static final URI SECONDS = new URIImpl("http://www.w3.org/2005/xpath-functions#seconds-from-dateTime");
    public static final URI TZ = new URIImpl("http://www.w3.org/2005/xpath-functions#tz");
    public static final URI TIMEZONE = new URIImpl("http://www.w3.org/2005/xpath-functions#timezone-from-dateTime");
    public static final URI MD5 = new URIImpl("http://www.w3.org/2006/sparql-functions#md5");
    public static final URI SHA1 = new URIImpl("http://www.w3.org/2006/sparql-functions#sha1");
    public static final URI SHA224 = new URIImpl("http://www.w3.org/2006/sparql-functions#sha224");
    public static final URI SHA256 = new URIImpl("http://www.w3.org/2006/sparql-functions#sha256");
    public static final URI SHA384 = new URIImpl("http://www.w3.org/2006/sparql-functions#sha384");
    public static final URI SHA512 = new URIImpl("http://www.w3.org/2006/sparql-functions#sha512");
    public static final URI UUID = new URIImpl("http://www.w3.org/2006/sparql-functions#uuid");
    public static final URI STRUUID = new URIImpl("http://www.w3.org/2006/sparql-functions#struuid");
    public static final URI STR_DT = new URIImpl("http://www.w3.org/2006/sparql-functions#strdt");
    public static final URI STR_LANG = new URIImpl("http://www.w3.org/2006/sparql-functions#strlang");
    public static final URI LCASE = FN.LOWER_CASE;
    public static final URI UCASE = FN.UPPER_CASE;
    public static final URI ENCODE_FOR_URI = FN.ENCODE_FOR_URI;
    public static final URI STR_LEN = FN.STRING_LENGTH;
    public static final URI SUBSTR = FN.SUBSTRING;
    public static final URI CONTAINS = FN.CONTAINS;
    public static final URI STARTS_WITH = FN.STARTS_WITH;
    public static final URI ENDS_WITH = FN.ENDS_WITH;
    public static final URI STR_AFTER = FN.SUBSTRING_AFTER;
    public static final URI STR_BEFORE = FN.SUBSTRING_BEFORE;
    public static final URI REPLACE = FN.REPLACE;
    public static final URI IRI = new URIImpl("http://www.bigdata.com/sparql-1.1-undefined-functionsiri");
    public static final URI BNODE = new URIImpl("http://www.bigdata.com/sparql-1.1-undefined-functionsbnode");
    public static final URI EXISTS = new URIImpl("http://www.bigdata.com/sparql-1.1-undefined-functionsexists");
    public static final URI NOT_EXISTS = new URIImpl("http://www.bigdata.com/sparql-1.1-undefined-functionsnot-exists");
    public static final URI EQ = new URIImpl("http://www.w3.org/2005/xpath-functions#equal-to");
    public static final URI NE = new URIImpl("http://www.w3.org/2005/xpath-functions#not-equal-to");
    public static final URI GT = new URIImpl("http://www.w3.org/2005/xpath-functions#greater-than");
    public static final URI GE = new URIImpl("http://www.w3.org/2005/xpath-functions#greater-than-or-equal-to");
    public static final URI LT = new URIImpl("http://www.w3.org/2005/xpath-functions#less-than");
    public static final URI LE = new URIImpl("http://www.w3.org/2005/xpath-functions#less-than-or-equal-to");
    public static final URI ADD = new URIImpl("http://www.w3.org/2005/xpath-functions#numeric-add");
    public static final URI SUBTRACT = new URIImpl("http://www.w3.org/2005/xpath-functions#numeric-subtract");
    public static final URI MULTIPLY = new URIImpl("http://www.w3.org/2005/xpath-functions#numeric-multiply");
    public static final URI DIVIDE = new URIImpl("http://www.w3.org/2005/xpath-functions#numeric-divide");
    public static final URI ABS = FN.NUMERIC_ABS;
    public static final URI ROUND = FN.NUMERIC_ROUND;
    public static final URI CEIL = FN.NUMERIC_CEIL;
    public static final URI FLOOR = FN.NUMERIC_FLOOR;
    public static final URI RAND = new URIImpl("http://www.w3.org/2006/sparql-functions#numeric-rand");
    public static final URI AVERAGE = new URIImpl("http://www.w3.org/2006/sparql-functions#average");
    public static final URI COUNT = new URIImpl("http://www.w3.org/2006/sparql-functions#count");
    public static final URI GROUP_CONCAT = new URIImpl("http://www.w3.org/2006/sparql-functions#groupConcat");
    public static final URI MAX = new URIImpl("http://www.w3.org/2006/sparql-functions#max");
    public static final URI MIN = new URIImpl("http://www.w3.org/2006/sparql-functions#min");
    public static final URI SAMPLE = new URIImpl("http://www.w3.org/2006/sparql-functions#sample");
    public static final URI SUM = new URIImpl("http://www.w3.org/2006/sparql-functions#sum");
    public static final URI XSD_BOOL = XMLSchema.BOOLEAN;
    public static final URI XSD_DT = XMLSchema.DATETIME;
    public static final URI XSD_DEC = XMLSchema.DECIMAL;
    public static final URI XSD_DBL = XMLSchema.DOUBLE;
    public static final URI XSD_FLT = XMLSchema.FLOAT;
    public static final URI XSD_INT = XMLSchema.INTEGER;
    public static final URI XSD_STR = XMLSchema.STRING;
    public static final URI XSD_DATE = XMLSchema.DATE;
    public static final URI XSD_LONG = XMLSchema.LONG;
    public static final URI XSD_UNSIGNED_LONG = XMLSchema.UNSIGNED_LONG;

    public static boolean containsFunction(URI functionUri) {
        return factories.containsKey(functionUri);
    }

    public static boolean isAggregate(URI functionUri) {
        Factory f = (Factory)factories.get(functionUri);
        return f != null && f instanceof AggregateFactory;
    }

    public static final void checkArgs(ValueExpressionNode[] args, Class ... types) {
        if (args.length < types.length) {
            throw new IllegalArgumentException("wrong # of args");
        }
        for (int i = 0; i < args.length; ++i) {
            if (types[i >= types.length ? types.length - 1 : i].isAssignableFrom(args[i].getClass())) continue;
            throw new IllegalArgumentException("wrong type for arg# " + i + ": " + args[i].getClass());
        }
    }

    public static final IValueExpression<? extends IV> toVE(BOpContextBase context, GlobalAnnotations globals, URI functionURI, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
        if (functionURI == null) {
            throw new IllegalArgumentException("functionURI is null");
        }
        Factory f = factories.containsKey(functionURI) ? (Factory)factories.get(functionURI) : new UnknownFunctionFactory(functionURI);
        return f.create(context, globals, scalarValues, args);
    }

    public static final void add(URI functionURI, Factory factory) {
        if (factories.putIfAbsent(functionURI, factory) != null) {
            throw new UnsupportedOperationException("Already declared.");
        }
    }

    public static final void addAlias(URI functionURI, URI aliasURI) {
        if (!factories.containsKey(functionURI)) {
            throw new UnsupportedOperationException("FunctionURI:" + functionURI + " not present.");
        }
        if (factories.putIfAbsent(aliasURI, (Factory)factories.get(functionURI)) != null) {
            throw new UnsupportedOperationException("Already declared.");
        }
    }

    public static Factory remove(URI functionURI) {
        return (Factory)factories.remove(functionURI);
    }

    static {
        FunctionRegistry.add(AVERAGE, new AggregateFactory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new AVERAGE(new BOp[]{ve}, scalarValues);
            }
        });
        FunctionRegistry.add(COUNT, new AggregateFactory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new COUNT(new BOp[]{ve}, scalarValues);
            }
        });
        FunctionRegistry.add(GROUP_CONCAT, new GroupConcatFactory());
        FunctionRegistry.add(MAX, new AggregateFactory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression[] expressions = new IValueExpression[args.length];
                for (int i = 0; i < args.length; ++i) {
                    expressions[i] = AST2BOpUtility.toVE(context, globals, args[i]);
                }
                return new MAX((BOp[])expressions, scalarValues);
            }
        });
        FunctionRegistry.add(MIN, new AggregateFactory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression[] expressions = new IValueExpression[args.length];
                for (int i = 0; i < args.length; ++i) {
                    expressions[i] = AST2BOpUtility.toVE(context, globals, args[i]);
                }
                return new MIN((BOp[])expressions, scalarValues);
            }
        });
        FunctionRegistry.add(SAMPLE, new AggregateFactory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new SAMPLE(false, (IValueExpression<IV>)ve);
            }
        });
        FunctionRegistry.add(SUM, new AggregateFactory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression[] expressions = new IValueExpression[args.length];
                for (int i = 0; i < args.length; ++i) {
                    expressions[i] = AST2BOpUtility.toVE(context, globals, args[i]);
                }
                return new SUM((BOp[])expressions, scalarValues);
            }
        });
        FunctionRegistry.add(BOUND, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, VarNode.class);
                IVariable<IV> var = ((VarNode)args[0]).getValueExpression();
                return new IsBoundBOp(var);
            }
        });
        FunctionRegistry.add(IS_LITERAL, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new IsLiteralBOp(ve);
            }
        });
        FunctionRegistry.add(IS_BLANK, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new IsBNodeBOp(ve);
            }
        });
        FunctionRegistry.add(IS_URI, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new IsURIBOp(ve);
            }
        });
        FunctionRegistry.add(IS_IRI, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new IsURIBOp(ve);
            }
        });
        FunctionRegistry.add(IS_NUMERIC, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new IsNumericBOp(ve);
            }
        });
        FunctionRegistry.add(STR, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new StrBOp(ve, globals);
            }
        });
        FunctionRegistry.add(ENCODE_FOR_URI, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new EncodeForURIBOp(ve, globals);
            }
        });
        FunctionRegistry.add(LCASE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new LcaseBOp(ve, globals);
            }
        });
        FunctionRegistry.add(UCASE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new UcaseBOp(ve, globals);
            }
        });
        FunctionRegistry.add(STR_DT, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> type = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrdtBOp(ve, type, globals);
            }
        });
        FunctionRegistry.add(STR_LANG, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> lang = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrlangBOp(var, lang, globals);
            }
        });
        FunctionRegistry.add(STR_LEN, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                return new StrlenBOp(var, globals);
            }
        });
        FunctionRegistry.add(SUBSTR, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> start = AST2BOpUtility.toVE(context, globals, args[1]);
                IValueExpression<? extends IV> length = args.length >= 3 ? AST2BOpUtility.toVE(context, globals, args[2]) : null;
                return new SubstrBOp(var, start, length, globals);
            }
        });
        FunctionRegistry.add(CONTAINS, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> x = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> y = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrcontainsBOp(x, y);
            }
        });
        FunctionRegistry.add(LANG, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new LangBOp(ve, globals);
            }
        });
        FunctionRegistry.add(CONCAT, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression[] expressions = new IValueExpression[args.length];
                for (int i = 0; i < args.length; ++i) {
                    expressions[i] = AST2BOpUtility.toVE(context, globals, args[i]);
                }
                return new ConcatBOp(globals, expressions);
            }
        });
        FunctionRegistry.add(COALESCE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression[] expressions = new IValueExpression[args.length];
                for (int i = 0; i < args.length; ++i) {
                    expressions[i] = AST2BOpUtility.toVE(context, globals, args[i]);
                }
                return new CoalesceBOp(globals, expressions);
            }
        });
        FunctionRegistry.add(IF, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> conditional = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> expression1 = AST2BOpUtility.toVE(context, globals, args[1]);
                IValueExpression<? extends IV> expression2 = AST2BOpUtility.toVE(context, globals, args[2]);
                return new IfBOp(conditional, expression1, expression2);
            }
        });
        FunctionRegistry.add(DATATYPE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new DatatypeBOp(ve, globals);
            }
        });
        FunctionRegistry.add(RAND, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args != null && args.length > 0) {
                    throw new IllegalArgumentException("wrong # of args");
                }
                return new RandBOp();
            }
        });
        FunctionRegistry.add(LANG_MATCHES, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> right = AST2BOpUtility.toVE(context, globals, args[1]);
                return new LangMatchesBOp(left, right);
            }
        });
        FunctionRegistry.add(REGEX, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> pattern = AST2BOpUtility.toVE(context, globals, args[1]);
                if (args.length == 2) {
                    return new RegexBOp(var, pattern);
                }
                IValueExpression<? extends IV> flags = AST2BOpUtility.toVE(context, globals, args[2]);
                return new RegexBOp(var, pattern, flags);
            }
        });
        FunctionRegistry.add(AND, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> right = AST2BOpUtility.toVE(context, globals, args[1]);
                return new AndBOp(left, right);
            }
        });
        FunctionRegistry.add(OR, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> right = AST2BOpUtility.toVE(context, globals, args[1]);
                return new OrBOp(left, right);
            }
        });
        FunctionRegistry.add(NOT, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> arg = AST2BOpUtility.toVE(context, globals, args[0]);
                return new NotBOp(arg);
            }
        });
        FunctionRegistry.add(IRI, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                String baseURI = (String)scalarValues.get(IriBOp.Annotations.BASE_URI);
                return new IriBOp(ve, baseURI, globals);
            }
        });
        FunctionRegistry.add(BNODE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args.length == 0) {
                    return new BNodeBOp(globals);
                }
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new BNodeBOp(ve, globals);
            }
        });
        FunctionRegistry.add(STARTS_WITH, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> token = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrstartsBOp(var, token);
            }
        });
        FunctionRegistry.add(ENDS_WITH, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> token = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrendsBOp(var, token);
            }
        });
        FunctionRegistry.add(STR_BEFORE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> arg1 = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> arg2 = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrBeforeBOp(arg1, arg2, globals);
            }
        });
        FunctionRegistry.add(STR_AFTER, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> arg1 = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> arg2 = AST2BOpUtility.toVE(context, globals, args[1]);
                return new StrAfterBOp(arg1, arg2, globals);
            }
        });
        FunctionRegistry.add(REPLACE, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression<? extends IV> var = AST2BOpUtility.toVE(context, globals, args[0]);
                IValueExpression<? extends IV> pattern = AST2BOpUtility.toVE(context, globals, args[1]);
                IValueExpression<? extends IV> replacement = AST2BOpUtility.toVE(context, globals, args[2]);
                if (args.length == 3) {
                    return new ReplaceBOp(var, pattern, replacement, globals);
                }
                IValueExpression<? extends IV> flags = AST2BOpUtility.toVE(context, globals, args[3]);
                return new ReplaceBOp(var, pattern, replacement, flags, globals);
            }
        });
        FunctionRegistry.add(IN, new InFactory(false));
        FunctionRegistry.add(NOT_IN, new InFactory(true));
        FunctionRegistry.add(SAME_TERM, SameTermFactory.INSTANCE);
        FunctionRegistry.add(EQ, new CompareFactory(Compare.CompareOp.EQ));
        FunctionRegistry.add(NE, new CompareFactory(Compare.CompareOp.NE));
        FunctionRegistry.add(GT, new CompareFactory(Compare.CompareOp.GT));
        FunctionRegistry.add(GE, new CompareFactory(Compare.CompareOp.GE));
        FunctionRegistry.add(LT, new CompareFactory(Compare.CompareOp.LT));
        FunctionRegistry.add(LE, new CompareFactory(Compare.CompareOp.LE));
        FunctionRegistry.add(ADD, new MathFactory(MathBOp.MathOp.PLUS));
        FunctionRegistry.add(SUBTRACT, new MathFactory(MathBOp.MathOp.MINUS));
        FunctionRegistry.add(MULTIPLY, new MathFactory(MathBOp.MathOp.MULTIPLY));
        FunctionRegistry.add(DIVIDE, new MathFactory(MathBOp.MathOp.DIVIDE));
        FunctionRegistry.add(ABS, new NumericFactory(NumericBOp.NumericOp.ABS));
        FunctionRegistry.add(ROUND, new NumericFactory(NumericBOp.NumericOp.ROUND));
        FunctionRegistry.add(CEIL, new NumericFactory(NumericBOp.NumericOp.CEIL));
        FunctionRegistry.add(FLOOR, new NumericFactory(NumericBOp.NumericOp.FLOOR));
        FunctionRegistry.add(XSD_BOOL, new CastFactory(XMLSchema.BOOLEAN.toString()));
        FunctionRegistry.add(XSD_DT, new CastFactory(XMLSchema.DATETIME.toString()));
        FunctionRegistry.add(XSD_DEC, new CastFactory(XMLSchema.DECIMAL.toString()));
        FunctionRegistry.add(XSD_DBL, new CastFactory(XMLSchema.DOUBLE.toString()));
        FunctionRegistry.add(XSD_FLT, new CastFactory(XMLSchema.FLOAT.toString()));
        FunctionRegistry.add(XSD_INT, new CastFactory(XMLSchema.INTEGER.toString()));
        FunctionRegistry.add(XSD_LONG, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new XsdLongBOp(ve, globals);
            }
        });
        FunctionRegistry.add(XSD_UNSIGNED_LONG, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new XsdUnsignedLongBOp(ve, globals);
            }
        });
        FunctionRegistry.add(XSD_STR, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
                IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
                return new XsdStrBOp(ve, globals);
            }
        });
        FunctionRegistry.add(YEAR, new DateFactory(DateBOp.DateOp.YEAR));
        FunctionRegistry.add(MONTH, new DateFactory(DateBOp.DateOp.MONTH));
        FunctionRegistry.add(DAY, new DateFactory(DateBOp.DateOp.DAY));
        FunctionRegistry.add(HOURS, new DateFactory(DateBOp.DateOp.HOURS));
        FunctionRegistry.add(MINUTES, new DateFactory(DateBOp.DateOp.MINUTES));
        FunctionRegistry.add(SECONDS, new DateFactory(DateBOp.DateOp.SECONDS));
        FunctionRegistry.add(TIMEZONE, new DateFactory(DateBOp.DateOp.TIMEZONE));
        FunctionRegistry.add(XSD_DATE, new DateFactory(DateBOp.DateOp.DATE));
        FunctionRegistry.add(TZ, new DateFactory(DateBOp.DateOp.TZ));
        FunctionRegistry.add(NOW, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args != null && args.length > 0) {
                    throw new IllegalArgumentException("no args for NOW()");
                }
                return new NowBOp(globals);
            }
        });
        FunctionRegistry.add(UUID, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args != null && args.length > 0) {
                    throw new IllegalArgumentException("no args for UUID()");
                }
                return new UUIDBOp(globals, false);
            }
        });
        FunctionRegistry.add(STRUUID, new Factory(){

            @Override
            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args != null && args.length > 0) {
                    throw new IllegalArgumentException("no args for STRUUID()");
                }
                return new UUIDBOp(globals, true);
            }
        });
        FunctionRegistry.add(MD5, new DigestFactory(DigestBOp.DigestOp.MD5));
        FunctionRegistry.add(SHA1, new DigestFactory(DigestBOp.DigestOp.SHA1));
        FunctionRegistry.add(SHA224, new DigestFactory(DigestBOp.DigestOp.SHA224));
        FunctionRegistry.add(SHA256, new DigestFactory(DigestBOp.DigestOp.SHA256));
        FunctionRegistry.add(SHA384, new DigestFactory(DigestBOp.DigestOp.SHA384));
        FunctionRegistry.add(SHA512, new DigestFactory(DigestBOp.DigestOp.SHA512));
        FunctionRegistry.add(EXISTS, new ExistsFactory(true));
        FunctionRegistry.add(NOT_EXISTS, new ExistsFactory(false));
    }

    public static class UnknownFunctionBOp
    extends ImmutableBOp
    implements IValueExpression<IV> {
        private static final long serialVersionUID = 1L;
        private static final String FUNCTION_URI = "FUNCTION_URI";

        public UnknownFunctionBOp(URI functionURI) {
            this(BOp.NOARGS, NV.asMap(FUNCTION_URI, (Object)functionURI));
        }

        public UnknownFunctionBOp(UnknownFunctionBOp op) {
            super(op);
        }

        public UnknownFunctionBOp(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public IV get(IBindingSet bindingSet) {
            throw new UnsupportedOperationException("unknown function: " + this.getRequiredProperty(FUNCTION_URI));
        }
    }

    private static class UnknownFunctionFactory
    implements Factory {
        private URI functionURI;

        public UnknownFunctionFactory(URI functionURI) {
            this.functionURI = functionURI;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            return new UnknownFunctionBOp(this.functionURI);
        }
    }

    public static class ExistsFactory
    implements Factory {
        private final boolean exists;

        public ExistsFactory(boolean exists) {
            this.exists = exists;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            VarNode anonvar = (VarNode)args[0];
            return this.exists ? anonvar.getValueExpression() : new NotBOp((IValueExpression<? extends IV>)anonvar.getValueExpression());
        }
    }

    public static class InFactory
    implements Factory {
        private final boolean not;

        public InFactory(boolean not) {
            this.not = not;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            if (args.length == 0) {
                throw new IllegalArgumentException();
            }
            if (args.length == 1) {
                return this.not ? TrueBOp.INSTANCE : FalseBOp.INSTANCE;
            }
            boolean allowLiterals = scalarValues != null && scalarValues.containsKey(Annotations.ALLOW_LITERALS) ? (Boolean)scalarValues.get(Annotations.ALLOW_LITERALS) : false;
            if (args.length == 2) {
                if (allowLiterals) {
                    IValueExpression<? extends IV> ret = SameTermFactory.INSTANCE.create(context, globals, scalarValues, args);
                    if (this.not) {
                        return new NotBOp(ret);
                    }
                    return ret;
                }
                IValueExpression<? extends IV> ret = new CompareFactory(Compare.CompareOp.EQ).create(context, globals, scalarValues, args);
                if (this.not) {
                    return new NotBOp(ret);
                }
                return ret;
            }
            try {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ConstantNode.class);
                IValueExpression<? extends IV> arg = AST2BOpUtility.toVE(context, globals, args[0]);
                IConstant[] set = new IConstant[args.length - 1];
                try {
                    for (int i = 1; i < args.length; ++i) {
                        set[i - 1] = ((ConstantNode)args[i]).getValueExpression();
                        IV iv = (IV)set[i - 1].get();
                        if (allowLiterals || !iv.isLiteral()) continue;
                        throw new IllegalArgumentException("must use CompareBOps for literals");
                    }
                    return new InHashBOp(this.not, arg, set);
                }
                catch (IllegalArgumentException ex) {
                    OrBOp ret = null;
                    CompareFactory compare = new CompareFactory(Compare.CompareOp.EQ);
                    for (int i = 1; i < args.length; ++i) {
                        ret = ret == null ? compare.create(context, globals, scalarValues, args[0], args[i]) : new OrBOp(ret, compare.create(context, globals, scalarValues, args[0], args[i]));
                    }
                    if (this.not) {
                        return new NotBOp((IValueExpression<? extends IV>)ret);
                    }
                    return ret;
                }
            }
            catch (IllegalArgumentException iae) {
                FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
                IValueExpression[] set = new IValueExpression[args.length];
                for (int i = 0; i < args.length; ++i) {
                    set[i] = AST2BOpUtility.toVE(context, globals, args[i]);
                }
                return new ComputedIN(this.not, set);
            }
        }

        public static interface Annotations {
            public static final String ALLOW_LITERALS = Annotations.class.getName() + ".allowLiterals";
        }
    }

    public static class GroupConcatFactory
    implements AggregateFactory {
        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
            LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>(scalarValues);
            if (!scalarValues.containsKey("separator")) {
                tmp.put("separator", " ");
            }
            tmp.put(Annotations.NAMESPACE, globals.lex);
            IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(context, globals, args[0]);
            return new GROUP_CONCAT(new BOp[]{ve}, tmp);
        }

        public static interface Annotations
        extends GROUP_CONCAT.Annotations {
        }
    }

    public static class CastFactory
    implements Factory {
        private final String uri;

        public CastFactory(String uri) {
            this.uri = uri;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            IValueExpression[] bops = new IValueExpression[args.length];
            for (int i = 0; i < args.length; ++i) {
                bops[i] = AST2BOpUtility.toVE(context, globals, args[i]);
            }
            return new FuncBOp(bops, this.uri, globals);
        }
    }

    public static class DateFactory
    implements Factory {
        private final DateBOp.DateOp op;

        public DateFactory(DateBOp.DateOp op) {
            this.op = op;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
            IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
            return new DateBOp(left, this.op, globals);
        }
    }

    public static class DigestFactory
    implements Factory {
        private final DigestBOp.DigestOp op;

        public DigestFactory(DigestBOp.DigestOp op) {
            this.op = op;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
            IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
            return new DigestBOp(left, this.op, globals);
        }
    }

    public static class NumericFactory
    implements Factory {
        private final NumericBOp.NumericOp op;

        public NumericFactory(NumericBOp.NumericOp op) {
            this.op = op;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class);
            IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
            return new NumericBOp(left, this.op);
        }
    }

    public static class MathFactory
    implements Factory {
        private final MathBOp.MathOp op;

        public MathFactory(MathBOp.MathOp op) {
            this.op = op;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
            IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
            IValueExpression<? extends IV> right = AST2BOpUtility.toVE(context, globals, args[1]);
            return new MathBOp(left, right, this.op, globals);
        }
    }

    public static class SameTermFactory
    implements Factory {
        public static final SameTermFactory INSTANCE = new SameTermFactory();

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
            IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
            IValueExpression<? extends IV> right = AST2BOpUtility.toVE(context, globals, args[1]);
            return new SameTermBOp(left, right, Compare.CompareOp.EQ);
        }
    }

    public static class CompareFactory
    implements Factory {
        private final Compare.CompareOp op;

        public CompareFactory(Compare.CompareOp op) {
            this.op = op;
        }

        @Override
        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs(args, ValueExpressionNode.class, ValueExpressionNode.class);
            IValueExpression<? extends IV> left = AST2BOpUtility.toVE(context, globals, args[0]);
            IValueExpression<? extends IV> right = AST2BOpUtility.toVE(context, globals, args[1]);
            if (this.op != Compare.CompareOp.EQ && this.op != Compare.CompareOp.NE) {
                if (left instanceof Constant && ((IV)((Constant)left).get()).isURI()) {
                    return SparqlTypeErrorBOp.INSTANCE;
                }
                if (right instanceof Constant && ((IV)((Constant)right).get()).isURI()) {
                    return SparqlTypeErrorBOp.INSTANCE;
                }
            }
            if (left instanceof IVariableOrConstant && right instanceof IVariableOrConstant && left.equals(right)) {
                if (this.op == Compare.CompareOp.EQ || this.op == Compare.CompareOp.LE || this.op == Compare.CompareOp.GE) {
                    return TrueBOp.INSTANCE;
                }
                return FalseBOp.INSTANCE;
            }
            return new CompareBOp(left, right, this.op);
        }
    }

    public static interface AggregateFactory
    extends Factory {
    }

    public static interface Factory {
        public IValueExpression<? extends IV> create(BOpContextBase var1, GlobalAnnotations var2, Map<String, Object> var3, ValueExpressionNode ... var4);
    }

    public static interface Annotations
    extends AggregateBase.Annotations {
    }
}

