/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.sail.sparql.ASTVisitorBase;
import com.bigdata.rdf.sail.sparql.SPARQLUtil;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTString;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilderVisitor;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import org.openrdf.query.MalformedQueryException;

public class StringEscapesProcessor {
    public static void process(ASTOperationContainer qc) throws MalformedQueryException {
        StringProcessor visitor = new StringProcessor();
        try {
            qc.jjtAccept((SyntaxTreeBuilderVisitor)visitor, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
    }

    private static class StringProcessor
    extends ASTVisitorBase {
        @Override
        public Object visit(ASTString stringNode, Object data) throws VisitorException {
            String value = stringNode.getValue();
            try {
                value = SPARQLUtil.decodeString(value);
                stringNode.setValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            return super.visit(stringNode, data);
        }
    }
}

