/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.Literal;

public class XSDDecimalIV<V extends BigdataLiteral>
extends NumericIV<V, BigDecimal>
implements Literal {
    private static final long serialVersionUID = -7549521965119949938L;
    private final BigDecimal value;
    private transient int byteLength;
    private int hash = 0;

    @Override
    public IV<V, BigDecimal> clone(boolean clearCache) {
        XSDDecimalIV tmp = new XSDDecimalIV(this.value);
        tmp.byteLength = this.byteLength;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDDecimalIV(BigDecimal value) {
        super(DTE.XSDDecimal);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public final BigDecimal getInlineValue() {
        return this.value;
    }

    @Override
    public String getLabel() {
        return this.value.toPlainString();
    }

    @Override
    public boolean booleanValue() {
        return !this.value.equals(BigDecimal.ZERO);
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public final long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createLiteral(this.value.toPlainString(), DTE.XSDDecimal.getDatatypeURI());
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDDecimalIV) {
            return this.value.compareTo(((XSDDecimalIV)o).value) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.stripTrailingZeros().hashCode();
        }
        return this.hash;
    }

    @Override
    public int byteLength() {
        if (this.byteLength == 0) {
            this.byteLength = 1 + KeyBuilder.byteLength(this.value);
        }
        return this.byteLength;
    }

    @Override
    public int _compareTo(IV o) {
        return this.value.compareTo(((XSDDecimalIV)o).value);
    }
}

