/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class XSDStringExtension<V extends BigdataValue>
implements IExtension<V> {
    private final BigdataURI xsdStringURI;
    private final int maxInlineStringLength;

    public XSDStringExtension(IDatatypeURIResolver resolver, int maxInlineStringLength) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        if (maxInlineStringLength < 0) {
            throw new IllegalArgumentException();
        }
        this.xsdStringURI = resolver.resolve(XSD.STRING);
        this.maxInlineStringLength = maxInlineStringLength;
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        LinkedHashSet<BigdataURI> datatypes = new LinkedHashSet<BigdataURI>();
        datatypes.add(this.xsdStringURI);
        return datatypes;
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        if (value.stringValue().length() > this.maxInlineStringLength) {
            return null;
        }
        Literal lit = (Literal)value;
        URI dt = lit.getDatatype();
        if (dt == null || !XSD.STRING.stringValue().equals(dt.stringValue())) {
            throw new IllegalArgumentException();
        }
        String s = value.stringValue();
        FullyInlineTypedLiteralIV<BigdataLiteral> delegate = new FullyInlineTypedLiteralIV<BigdataLiteral>(s, null, null);
        return new LiteralExtensionIV(delegate, this.xsdStringURI.getIV());
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        return (V)vf.createLiteral(iv.getDelegate().stringValue(), this.xsdStringURI);
    }
}

