/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.error;

import com.bigdata.rdf.error.W3CQueryLanguageException;
import com.bigdata.util.NV;
import org.openrdf.model.URI;

public class SparqlDynamicErrorException
extends W3CQueryLanguageException {
    private static final long serialVersionUID = 1L;
    public static String SPARQL_DYNAMIC_ERROR_0000 = SparqlDynamicErrorException.toURI(0);
    public static String SPARQL_DYNAMIC_ERROR_0001 = SparqlDynamicErrorException.toURI(1);
    public static String SPARQL_DYNAMIC_ERROR_0002 = SparqlDynamicErrorException.toURI(2);
    public static String SPARQL_DYNAMIC_ERROR_0003 = SparqlDynamicErrorException.toURI(3);
    public static String SPARQL_DYNAMIC_ERROR_0004 = SparqlDynamicErrorException.toURI(4);
    public static String SPARQL_DYNAMIC_ERROR_0005 = SparqlDynamicErrorException.toURI(5);

    public SparqlDynamicErrorException() {
        this(0, SPARQL_DYNAMIC_ERROR_0000);
    }

    protected SparqlDynamicErrorException(int errorCode, String uri) {
        super(W3CQueryLanguageException.LanguageFamily.SP, W3CQueryLanguageException.ErrorCategory.DY, errorCode, uri);
    }

    protected SparqlDynamicErrorException(int errorCode, NV[] params) {
        super(W3CQueryLanguageException.LanguageFamily.SP, W3CQueryLanguageException.ErrorCategory.DY, errorCode, params);
    }

    protected SparqlDynamicErrorException(int errorCode, String uri, NV[] params) {
        super(W3CQueryLanguageException.LanguageFamily.SP, W3CQueryLanguageException.ErrorCategory.DY, errorCode, params);
    }

    protected static String toURI(int errorCode) {
        return W3CQueryLanguageException.toURI(W3CQueryLanguageException.LanguageFamily.SP, W3CQueryLanguageException.ErrorCategory.DY, errorCode, null);
    }

    public static class UnknownContentTypeException
    extends SparqlDynamicErrorException {
        private static final long serialVersionUID = 1L;

        public UnknownContentTypeException(String contentType) {
            super(5, SPARQL_DYNAMIC_ERROR_0005, new NV[]{new NV("Content-Type", contentType)});
        }
    }

    public static class SolutionSetDoesNotExistException
    extends SparqlDynamicErrorException {
        private static final long serialVersionUID = 1L;

        public SolutionSetDoesNotExistException(String solutionSet) {
            super(4, SPARQL_DYNAMIC_ERROR_0004, new NV[]{new NV("name", solutionSet)});
        }
    }

    public static class SolutionSetExistsException
    extends SparqlDynamicErrorException {
        private static final long serialVersionUID = 1L;

        public SolutionSetExistsException(String solutionSet) {
            super(3, SPARQL_DYNAMIC_ERROR_0003, new NV[]{new NV("name", solutionSet)});
        }
    }

    public static class GraphEmptyException
    extends SparqlDynamicErrorException {
        private static final long serialVersionUID = 1L;

        public GraphEmptyException(URI graphUri) {
            super(2, SPARQL_DYNAMIC_ERROR_0002, new NV[]{new NV("uri", graphUri.stringValue())});
        }
    }

    public static class GraphExistsException
    extends SparqlDynamicErrorException {
        private static final long serialVersionUID = 1L;

        public GraphExistsException(URI graphUri) {
            super(1, SPARQL_DYNAMIC_ERROR_0001, new NV[]{new NV("uri", graphUri.stringValue())});
        }
    }
}

