/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.om;

import com.bigdata.gom.om.IIDGenerator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;

public class IDGenerator
implements IIDGenerator {
    private final ValueFactory valueFactory;
    private final String prefix;
    private final AtomicInteger nextId = new AtomicInteger(0);

    public IDGenerator(String endpoint, UUID uuid, ValueFactory valueFactory) {
        if (endpoint == null) {
            throw new IllegalArgumentException();
        }
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        if (valueFactory == null) {
            throw new IllegalArgumentException();
        }
        this.valueFactory = valueFactory;
        this.prefix = endpoint + "/gpo/" + uuid + "/";
    }

    @Override
    public URI genId() {
        return this.valueFactory.createURI(this.prefix + this.nextId.incrementAndGet());
    }

    @Override
    public URI genId(String scope) {
        return this.valueFactory.createURI(this.prefix + scope + "/" + this.nextId.incrementAndGet());
    }

    @Override
    public void rollback() {
        this.nextId.set(0);
    }
}

