/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.jooq.exception.IOException;
import org.jooq.tools.jdbc.JDBCUtils;

public final class Source {
    private final String string;
    private final byte[] bytes;
    private final String charsetName;
    private final Charset charset;
    private final CharsetDecoder charsetDecoder;
    private final Reader reader;
    private final InputStream inputStream;
    private final File file;

    private Source(String string, byte[] bytes, String charsetName, Charset charset, CharsetDecoder charsetDecoder, Reader reader, InputStream inputStream, File file) {
        this.string = string;
        this.bytes = bytes;
        this.charsetName = charsetName;
        this.charset = charset;
        this.charsetDecoder = charsetDecoder;
        this.reader = reader;
        this.inputStream = inputStream;
        this.file = file;
    }

    public static final Source of(String string) {
        return new Source(string, null, null, null, null, null, null, null);
    }

    public static final Source of(byte[] bytes) {
        return Source.of(bytes, (Charset)null);
    }

    public static final Source of(byte[] bytes, String charsetName) {
        return new Source(null, bytes, charsetName, null, null, null, null, null);
    }

    public static final Source of(byte[] bytes, Charset charset) {
        return new Source(null, bytes, null, charset, null, null, null, null);
    }

    public static final Source of(byte[] bytes, CharsetDecoder charsetDecoder) {
        return new Source(null, bytes, null, null, charsetDecoder, null, null, null);
    }

    public static final Source of(File file) {
        return new Source(null, null, null, null, null, null, null, file);
    }

    public static final Source of(File file, String charsetName) {
        return new Source(null, null, charsetName, null, null, null, null, file);
    }

    public static final Source of(File file, Charset charset) {
        return new Source(null, null, null, charset, null, null, null, file);
    }

    public static final Source of(File file, CharsetDecoder charsetDecoder) {
        return new Source(null, null, null, null, charsetDecoder, null, null, file);
    }

    public static final Source of(Reader reader) {
        return new Source(null, null, null, null, null, reader, null, null);
    }

    public static final Source of(InputStream inputStream) {
        return new Source(null, null, null, null, null, null, inputStream, null);
    }

    public static final Source of(InputStream inputStream, String charsetName) {
        return new Source(null, null, charsetName, null, null, null, inputStream, null);
    }

    public static final Source of(InputStream inputStream, Charset charset) {
        return new Source(null, null, null, charset, null, null, inputStream, null);
    }

    public static final Source of(InputStream inputStream, CharsetDecoder charsetDecoder) {
        return new Source(null, null, null, null, charsetDecoder, null, inputStream, null);
    }

    public final Reader reader() throws IOException {
        try {
            if (this.string != null) {
                return new StringReader(this.string);
            }
            if (this.bytes != null) {
                return this.inputStreamReader(new ByteArrayInputStream(this.bytes));
            }
            if (this.reader != null) {
                return this.reader;
            }
            if (this.inputStream != null) {
                return this.inputStreamReader(this.inputStream);
            }
            if (this.file != null) {
                return new BufferedReader(this.inputStreamReader(new FileInputStream(this.file)));
            }
            throw new IllegalStateException("Could not produce a reader from this source");
        }
        catch (java.io.IOException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public final String readString() throws IOException {
        StringWriter w = new StringWriter();
        Reader r = null;
        try {
            int read;
            r = this.reader();
            char[] buffer = new char[8192];
            while ((read = r.read(buffer, 0, 8192)) >= 0) {
                w.write(buffer, 0, read);
            }
        }
        catch (java.io.IOException e) {
            throw new IOException("Could not read source", e);
        }
        finally {
            JDBCUtils.safeClose(r);
        }
        return w.toString();
    }

    private final Reader inputStreamReader(InputStream is) throws UnsupportedEncodingException {
        if (this.charsetName != null) {
            return new InputStreamReader(is, this.charsetName);
        }
        if (this.charset != null) {
            return new InputStreamReader(is, this.charset);
        }
        if (this.charsetDecoder != null) {
            return new InputStreamReader(is, this.charsetDecoder);
        }
        return new InputStreamReader(is);
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        if (this.bytes != null) {
            return this.readString();
        }
        if (this.reader != null) {
            return "Source (Reader)";
        }
        if (this.inputStream != null) {
            return "Source (InputStream)";
        }
        if (this.file != null) {
            return "Source (" + this.file + ")";
        }
        return "Source (other)";
    }
}

