/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.query.FileBasedStoreClient;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.util.InputValidator;

public class StoreRouter {
    private static Logger LOGGER = LogManager.getLogger(StoreRouter.class);
    public static final String FILE = "file://";
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String KB = "kb";
    public static final String SLASH = "/";
    public static final String HTTP_KB_PREFIX = "http://".concat("kb").concat("/");
    public static final String EMPTY = "";
    private static final String STOREROUTER_ENDPOINT = "http://www.theworldavatar.com/blazegraph/namespace/ontokgrouter/sparql";
    public static final String RDFS_PREFIX = "rdfs";
    public static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String RDF_PREFIX = "rdf";
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_TYPE = "type";
    public static final String ONTOKGROUTER_PREFIX = "ontokgrouter";
    public static final String ONTOKGROUTER = "http://www.theworldavatar.com/ontology/ontokgrouter/OntoKGRouter.owl#";
    public static final String RESOURCE = "resource";
    public static final String LABEL = "label";
    public static final String QUERY_ENDPOINT = "queryEndpoint";
    public static final String HAS_QUERY_ENDPOINT = "hasQueryEndpoint";
    public static final String UPDATE_ENDPOINT = "updateEndpoint";
    public static final String HAS_UPDATE_ENDPOINT = "hasUpdateEndpoint";
    public static final String FILE_PATH = "filePath";
    public static final String HAS_FILE_PATH = "hasFilePath";
    public static final String TOMCAT_ROOT_LABEL = "tomcatrootpath";
    public static final String COLON = ":";
    public static final String QUESTION_MARK = "?";
    public static final String TARGET_RESOURCE = "TargetResource";
    public static final List<String> fileExtensions = Arrays.asList(".owl", ".rdf", ".nt");
    static StoreRouter storeRouter = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StoreClientInterface getStoreClient(String targetResourceID, boolean isQueryOperation, boolean isUpdateOperation) {
        String queryIRI = null;
        String updateIRI = null;
        StoreClientInterface kbClient = null;
        if (targetResourceID != null && !targetResourceID.isEmpty()) {
            if (storeRouter == null) {
                storeRouter = new StoreRouter();
            }
            if (StoreRouter.isFileBasedTargetResourceID(targetResourceID)) {
                String relativePath = StoreRouter.getPathComponent(targetResourceID);
                String rootPath = StoreRouter.getPathComponent(storeRouter.getLocalFilePath(STOREROUTER_ENDPOINT, TOMCAT_ROOT_LABEL));
                String filePath = StoreRouter.joinPaths(rootPath, relativePath);
                LOGGER.info("File based resource. file path=" + filePath);
                return new FileBasedStoreClient(filePath);
            }
            if (!StoreRouter.isRemoteTargetResourceID(targetResourceID)) throw new JPSRuntimeException("Invalid targetResourceID: " + targetResourceID);
            String targetResourceLabel = StoreRouter.getLabelFromTargetResourceID(targetResourceID);
            LOGGER.info("Remote store. targetResourceLabel=" + targetResourceLabel);
            if (isQueryOperation) {
                queryIRI = storeRouter.getQueryIRI(STOREROUTER_ENDPOINT, targetResourceLabel);
            }
            if (isUpdateOperation) {
                updateIRI = storeRouter.getUpdateIRI(STOREROUTER_ENDPOINT, targetResourceLabel);
            }
            if (queryIRI != null && !queryIRI.isEmpty()) {
                kbClient = new RemoteStoreClient(queryIRI);
            }
            if (updateIRI != null && !updateIRI.isEmpty()) {
                if (kbClient == null) {
                    kbClient = new RemoteStoreClient();
                }
                kbClient.setUpdateEndpoint(updateIRI);
            }
            if (queryIRI == null && updateIRI == null) {
                LOGGER.error("Endpoint could not be retrieved for the following resource IRI:" + targetResourceID + ", label:" + targetResourceLabel);
            }
            if (isQueryOperation) return kbClient;
            if (isUpdateOperation) return kbClient;
            LOGGER.error("null will be returned as both the isQueryOperation and isUpdateOperation parameters are set to false.");
            return kbClient;
        } else {
            LOGGER.error("targetResourceID is null.");
        }
        return kbClient;
    }

    public static boolean isRemoteTargetResourceID(String targetResourceID) {
        if (InputValidator.checkIfValidIRI(targetResourceID)) {
            return true;
        }
        if (targetResourceID.matches("[A-Za-z0-9]+")) {
            return true;
        }
        LOGGER.error("Invalid namespace label:" + targetResourceID + ". Not alphanumeric.");
        return false;
    }

    public static boolean isFileBasedTargetResourceID(String targetResourceID) {
        if (fileExtensions.stream().anyMatch(targetResourceID.trim()::endsWith)) {
            String path = null;
            try {
                path = InputValidator.checkIfValidIRI(targetResourceID) ? StoreRouter.getPathComponent(targetResourceID) : targetResourceID;
                Paths.get(path, new String[0]);
            }
            catch (InvalidPathException | JPSRuntimeException ex) {
                LOGGER.error("Invalid file path: " + path);
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getLabelFromTargetResourceID(String targetResourceID) {
        return targetResourceID.substring(targetResourceID.lastIndexOf(SLASH) + 1).trim();
    }

    public static String getPathComponent(String iri) {
        String path = null;
        try {
            URI uri = new URI(URLDecoder.decode(iri.trim(), "UTF-8"));
            path = uri.getPath();
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new JPSRuntimeException(e);
        }
        return path;
    }

    public static String joinPaths(String path1, String path2) {
        if (!path2.startsWith(SLASH)) {
            return path1.trim() + SLASH + path2.trim();
        }
        return path1.trim() + path2.trim();
    }

    private String getLocalFilePath(String kgrouterEndpoint, String targetResourceName) {
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar((Object)QUESTION_MARK.concat(RESOURCE)).addVar((Object)QUESTION_MARK.concat(LABEL)).addVar((Object)QUESTION_MARK.concat(FILE_PATH)).addWhere((AbstractQueryBuilder)this.getCommonKGRouterWhereBuilder())).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_FILE_PATH), (Object)QUESTION_MARK.concat(FILE_PATH));
        RemoteStoreClient rKBClient = new RemoteStoreClient(kgrouterEndpoint);
        System.out.println(builder.toString());
        String json = rKBClient.execute(builder.toString());
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(FILE_PATH));
            return obj.getString(FILE_PATH);
        }
        return null;
    }

    private String getQueryIRI(String kgrouterEndpoint, String targetResourceName) {
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar((Object)QUESTION_MARK.concat(RESOURCE)).addVar((Object)QUESTION_MARK.concat(LABEL)).addVar((Object)QUESTION_MARK.concat(QUERY_ENDPOINT)).addWhere((AbstractQueryBuilder)this.getCommonKGRouterWhereBuilder())).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_QUERY_ENDPOINT), (Object)QUESTION_MARK.concat(QUERY_ENDPOINT));
        RemoteStoreClient rKBClient = new RemoteStoreClient(kgrouterEndpoint);
        System.out.println(builder.toString());
        String json = rKBClient.execute(builder.toString());
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(QUERY_ENDPOINT));
            return obj.getString(QUERY_ENDPOINT);
        }
        return null;
    }

    private String getUpdateIRI(String kgrouterEndpoint, String targetResourceName) {
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar((Object)QUESTION_MARK.concat(RESOURCE)).addVar((Object)QUESTION_MARK.concat(LABEL)).addVar((Object)QUESTION_MARK.concat(UPDATE_ENDPOINT)).addWhere((AbstractQueryBuilder)this.getCommonKGRouterWhereBuilder())).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_UPDATE_ENDPOINT), (Object)QUESTION_MARK.concat(UPDATE_ENDPOINT));
        RemoteStoreClient rKBClient = new RemoteStoreClient(kgrouterEndpoint);
        System.out.println(builder.toString());
        String json = rKBClient.execute(builder.toString());
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(UPDATE_ENDPOINT));
            return obj.getString(UPDATE_ENDPOINT);
        }
        return null;
    }

    private WhereBuilder getCommonKGRouterWhereBuilder() {
        return ((WhereBuilder)((WhereBuilder)((WhereBuilder)new WhereBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)RDF_PREFIX.concat(COLON).concat(RDF_TYPE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(TARGET_RESOURCE)).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)RDFS_PREFIX.concat(COLON).concat(LABEL), (Object)QUESTION_MARK.concat(LABEL));
    }
}

