/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.derivation.Entity;

public class Derivation {
    private String iri;
    private List<Entity> inputs;
    private Long timestamp;
    private String agentURL;
    private List<Entity> entities;
    private String rdfType;

    public Derivation(String iri, String rdfType) {
        this.iri = iri;
        this.rdfType = rdfType;
        this.entities = new ArrayList<Entity>();
        this.inputs = new ArrayList<Entity>();
    }

    public String getIri() {
        return this.iri;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAgentURL(String agentURL) {
        this.agentURL = agentURL;
    }

    public void addEntity(Entity entity) {
        if (!this.entities.stream().anyMatch(e -> e.getIri().equals(entity.getIri()))) {
            this.entities.add(entity);
            entity.setBelongsTo(this);
        }
    }

    public void replaceEntities(List<Entity> entities) {
        this.entities = new ArrayList<Entity>();
        for (Entity entity : entities) {
            this.entities.add(entity);
            entity.setBelongsTo(this);
        }
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<String> getEntitiesIri() {
        return this.entities.stream().map(e -> e.getIri()).collect(Collectors.toList());
    }

    public void addInput(Entity input) {
        if (!this.inputs.stream().anyMatch(i -> i.getIri().equals(input.getIri()))) {
            this.inputs.add(input);
            input.setAsInput(this);
        }
    }

    public void removeInput(Entity input) {
        this.inputs.remove(input);
    }

    public List<Entity> getInputs() {
        return this.inputs;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public List<Derivation> getInputsWithBelongsTo() {
        List<Entity> inputs = this.getInputs();
        ArrayList<Derivation> inputsWithBelongsTo = new ArrayList<Derivation>();
        for (Entity input : inputs) {
            if (!input.hasBelongsTo()) continue;
            inputsWithBelongsTo.add(input.getBelongsTo());
        }
        return inputsWithBelongsTo;
    }

    public List<String> getAgentInputs() {
        return this.getInputs().stream().map(i -> i.getIri()).collect(Collectors.toList());
    }

    public boolean isOutOfDate() {
        boolean outOfDate = false;
        List<Entity> inputs = this.getInputs();
        for (Entity input : inputs) {
            long input_timestamp = input.hasBelongsTo() ? input.getBelongsTo().getTimestamp().longValue() : input.getTimestamp().longValue();
            if (input_timestamp <= this.timestamp) continue;
            outOfDate = true;
            return outOfDate;
        }
        return outOfDate;
    }

    public String getAgentURL() {
        return this.agentURL;
    }

    public boolean isDerivationWithTimeSeries() {
        return this.rdfType.equals(DerivationSparql.derivednamespace + "DerivationWithTimeSeries");
    }
}

