/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.agent;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.agent.JPSAgent;
import uk.ac.cam.cares.jps.base.derivation.DerivationClient;
import uk.ac.cam.cares.jps.base.interfaces.AsynAgentInterface;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class AsynAgent
extends JPSAgent
implements AsynAgentInterface {
    private static final Logger LOGGER = LogManager.getLogger(AsynAgent.class);
    private static final long serialVersionUID = 1L;
    StoreClientInterface storeClient;
    DerivationClient devClient;

    public AsynAgent(StoreClientInterface storeClient) {
        this.storeClient = storeClient;
        this.devClient = new DerivationClient(storeClient);
    }

    @Override
    public void monitorDerivation(String agentIRI) {
        List<String> listOfDerivation = this.devClient.getDerivations(agentIRI);
        for (String derivation : listOfDerivation) {
            if (this.devClient.isDerivedAsynchronous(derivation)) {
                if (this.devClient.isRequested(derivation)) {
                    JSONObject agentInputs = this.devClient.retrieveAgentInputs(derivation, agentIRI);
                    this.devClient.markAsInProgress(derivation);
                    List<String> newDerivedIRI = this.setupJob(agentInputs);
                    this.devClient.updateStatusAtJobCompletion(derivation, newDerivedIRI);
                    continue;
                }
                if (this.devClient.isInProgress(derivation) || !this.devClient.isFinished(derivation)) continue;
                this.devClient.cleanUpFinishedDerivationUpdate(derivation);
                continue;
            }
            LOGGER.info("Derivation instance <" + derivation + "> is not an asynchronous derivation.");
        }
    }

    @Override
    public List<String> setupJob(JSONObject requestParams) {
        return null;
    }
}

