/*
 * Decompiled with CFR 0.152.
 */
package org.cts.parser.prj;

import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cts.parser.prj.PrjElement;
import org.cts.parser.prj.PrjMatcher;
import org.cts.parser.prj.PrjNodeElement;
import org.cts.parser.prj.PrjNumberElement;
import org.cts.parser.prj.PrjParserException;
import org.cts.parser.prj.PrjStringElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrjParser {
    public Map<String, String> getParameters(String prjString) {
        PrjElement e;
        CharBuffer s = CharBuffer.wrap(prjString);
        try {
            e = this.parseNode(s);
        }
        catch (BufferUnderflowException ex) {
            throw new PrjParserException("Failed to read PRJ.", ex);
        }
        Map<String, String> prjParameters = PrjMatcher.match(e);
        return prjParameters;
    }

    public PrjElement parseNode(CharBuffer s) {
        boolean complexNode = false;
        int start = s.position();
        int ll = 0;
        while (s.hasRemaining()) {
            char c = s.get();
            if (c == '[') {
                complexNode = true;
                break;
            }
            if (c == ']' || c == ',') break;
            ++ll;
        }
        s.position(start);
        String name = s.subSequence(0, ll).toString();
        s.position(start + ll + 1);
        if (complexNode) {
            return new PrjNodeElement(name, this.parseNodeChildren(s));
        }
        s.position(s.position() - 1);
        return new PrjStringElement(name);
    }

    private char next(CharBuffer s) {
        char next;
        while (Character.isWhitespace(next = s.get())) {
        }
        return next;
    }

    private List<PrjElement> parseNodeChildren(CharBuffer s) {
        ArrayList<PrjElement> elms = new ArrayList<PrjElement>();
        boolean finished = false;
        do {
            char next;
            if ((next = this.next(s)) == '\"') {
                elms.add(this.parseString(s));
            } else {
                s.position(s.position() - 1);
                if (Character.isDigit(next) || next == '-') {
                    elms.add(this.parseNumber(s));
                } else {
                    elms.add(this.parseNode(s));
                }
            }
            next = this.next(s);
            switch (next) {
                case ',': {
                    break;
                }
                case ']': {
                    finished = true;
                    break;
                }
                default: {
                    throw new PrjParserException("weird character: " + next);
                }
            }
        } while (!finished);
        return elms;
    }

    private PrjStringElement parseString(CharBuffer s) {
        char c;
        int start = s.position();
        int ll = 0;
        while (s.hasRemaining() && (c = s.get()) != '\"') {
            ++ll;
        }
        s.position(start);
        String str = s.subSequence(0, ll).toString();
        s.position(start + ll + 1);
        return new PrjStringElement(str);
    }

    private PrjNumberElement parseNumber(CharBuffer s) {
        char c;
        int start = s.position();
        int ll = 0;
        while (s.hasRemaining() && (c = s.get()) != ',' && c != ']' && !Character.isWhitespace(c)) {
            ++ll;
        }
        s.position(start);
        String str = s.subSequence(0, ll).toString();
        s.position(start + ll);
        return new PrjNumberElement(Double.parseDouble(str));
    }
}

